<h1 align="center"><img alt="Logo" src="./frontend/src/assets/images/Logo_GeoSQL.png" /></h1>

<p align="center">
  <a href="#clipboard-about-the-project">About the Project</a> •
  <a href="#hammer-built-with">Built With</a> •
  <a href="#rocket-contributing">Contributing</a> •
  <a href="#computer-usage">Usage</a> •
  <a href="#information_source-license">License</a> •
  <a href="#email-contact">Contact</a> •
  <a href="#purple_heart-acknowledgments">Acknowledgements</a>
</p>

<p align="center">
  <img alt="GitHub top language" src="https://img.shields.io/github/languages/top/M-Henrique/GeoSQL?style=for-the-badge">
  <img alt="GitHub language count" src="https://img.shields.io/github/languages/count/M-Henrique/GeoSQL?style=for-the-badge&color=yellowgreen">
  <img alt="GitHub license" src="https://img.shields.io/badge/LICENSE-GNU%20v2-brightgreen?style=for-the-badge"> 
  <img alt="Github UFMG-DCC" src="https://img.shields.io/badge/UFMG-DCC-red?style=for-the-badge">
  <img alt="Github version" src="https://img.shields.io/badge/v-3.0-lightgrey?style=for-the-badge&color=blueviolet">
</p>

## :clipboard: About the Project

   <p align="justify">Learning database usages and tools can often prove to be a daunting task. Students face many new and exotic concepts in doing so, which may hinder the process.<br /><br />
    With the objective of easing the learning curve, GeoSQL was born and improved as a practicing tool of SQL, the main language that Database Management Systems use on their task of communicating with databases. It is a powerful system, providing users with robust and varied databases, handling of complex queries and visual representation and customization of the results.<br /><br />
    It is expected that, with such tools, the vital knowledge of database applications will be sped up and made easier to acquire and disseminate.
    </p>
   
## :hammer: Built With
  - [NodeJS](https://nodejs.org/en/)
  - [ReactJS](https://reactjs.org/)
  - [PostgreSQL](https://www.postgresql.org/)
  - [Openlayers](https://openlayers.org/)
  - [TypeScript](https://www.typescriptlang.org/)
  
## :rocket: Contributing
  GeoSQL is an open source project. If you have the interest in contributing, you can do so either by contacting us directly (e-mails at a later section) or making direct changes to the platform via pull requests:

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

Some information regarding the development environment of the application:

-  Frontend: Port 3000
-  Backend: Port 3333
-  REACT_APP_BASE_URL: base url used by react router if the application is under some route like http://www.example.com/geosql
-  REACT_APP_API_URL: represents the backend public url, where axios can find the api

## :computer: Usage

The platform is available for use at [http://aqui.io/geosql/](http://aqui.io/geosql/). The help page offers an extensive tutorial on the features and tools of the system.

## :information_source: License

This project is under the [GNU v2](LICENSE.md) license.

## :email: Contact

If you like the project and have the interest in contacting the responsibles directly, please send an email to [mhenrique.silva408@gmail.com](mhenrique.silva408@gmail.com) or [clodoveu@dcc.ufmg.br](clodoveu@dcc.ufmg.br) with the subject "GeoSQL".

## :purple_heart: Acknowledgments

This platform is the product of a Scientific Initiation project developed at the [Departamento de Ciência da Computação (DCC)](https://www.dcc.ufmg.br/dcc/) of the [Universidade Federal de Minas Gerais (UFMG)](https://ufmg.br/). As such, it would not be possible without the sponsorship of the [Conselho Nacional de Desenvolvimento Científico e Tecnológico (CNPq)](https://www.gov.br/cnpq/pt-br) and the guidance of [Clodoveu Davis A. Júnior](http://buscatextual.cnpq.br/buscatextual/visualizacv.do?id=K4728961T5).
