# Book CRUD - Vue.js

> Implementation of a CRUD of books in Vue.js.

> This application use the API: https://github.com/Lucasbrunoferreira/dotnet-api-rest

![](https://i.imgur.com/IJO3T0k.png)

## Dependency

|                |                             |        |
| -------------- |---------------------------  |------  |
| Vuex         | https://vuex.vuejs.org/  | State management pattern + library for Vue.js applications   |
| Element UI     | http://element.eleme.io|    CSS Library Components     |
| SASS           | https://sass-lang.com/                     |    Improves performance during development with CSS     |
| Vue Router | https://router.vuejs.org/                    |   Vue Router is the official router for Vue.js     |
| Style Lint         | https://stylelint.io/ |    Linter for CSS files, in order to better the code.    |
| Eslint | https://eslint.org/ | Linter for JavaScript files, in order to better the code.   | 
| Axios | https://github.com/axios/axios | Promise based HTTP client. |

## RUN

```
cd vue.js-CRUD

npm install

npm run serve

```
Application is running in 8080 localhost port.

