# Contribution Guidelines

## The pull request should have a useful title 
Pull requests with `Update readme.md` as title are not informative enough. 
Write about what additions you've made and *why* do you think it is useful. 

## Guidelines
- Make an individual pull request for each suggestion
- Use [title-casing](http://titlecapitalization.com) (AP style)
- Use the following format: `[Relevant Link](link)`
- Link additions should be added to the bottom of the relevant category
- **New categories or improvements to the existing categorization are welcome**
- Check your spelling and grammar
- Make sure your text editor is set to remove trailing whitespace
- The pull request and commit should have a useful title

## How to Contribute?
You'll need a [GitHub account](https://github.com/join)!

1. Access the GitHub page: https://github.com/Liquid-Legal-Institute/Legal-Text-Analytics
2. Click on the `readme.md` file: ![Step 2 Click on Readme.md](https://github.com/Liquid-Legal-Institute/Legal-Text-Analytics/blob/main/images/tutorial_contribute_1.png)
3. Now click on the edit icon. ![Step 3 - Click on Edit](https://github.com/Liquid-Legal-Institute/Legal-Text-Analytics/blob/main/images/tutorial_contribute_2.png)
4. You can start editing the text of the file in the in-browser editor. Make sure you follow guidelines above. You can use [GitHub Flavored Markdown](https://help.github.com/articles/github-flavored-markdown/). ![Step 4 - Edit the file](https://github.com/Liquid-Legal-Institute/Legal-Text-Analytics/blob/main/images/tutorial_contribute_3.png)
5. Say why you're proposing the changes, and then click on "Propose file change". ![Step 5 - Propose Changes](https://github.com/Liquid-Legal-Institute/Legal-Text-Analytics/blob/main/images/tutorial_contribute_4.png)
6. Submit the [pull request](https://help.github.com/articles/using-pull-requests/)!

## Updating your Pull Request

Sometimes, a maintainer of an awesome list will ask you to edit your Pull Request before it is included. This is normally due to spelling errors or because your PR didn't match the [CLP principles](https://github.com/Liquid-Legal-Institute/Common-Legal-Platform).

[Here](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) is a write up on how to change a Pull Request, and the different ways you can do that.

**Credits**
These contributing guidelines are taken from [awesome's contributing guidelines](https://github.com/sindresorhus/awesome/blob/master/contributing.md)
