#include  <linux/kernel.h>        // for kernel programming
#include <linux/module.h>      //  for kernel module struct.
#include <linux/fs.h>               //  struct file_operations
#include <linux/uaccess.h>
#define  RWBUF_CLEAR   0x909090 
#define RW_CLEAR 123
#define DEVICE_NAME "rwbuf"           
#define  rwbuf_size 1024                 // MAX size of buffer
static char  rwbuf[rwbuf_size] = "18130500001";        // the buffer keeping string
static int     rwlen = 0;  // length of string

static int  rwbuf_open ( struct inode *inode,  struct file * filep );
static int rwbuf_close( struct inode *inode,  struct file * filep );
static ssize_t rwbuf_read( struct file* filep,   char * buf, size_t count, loff_t* ppos);
static long  rwbuf_ioctl  ( struct file * filep,
			unsigned int cmd, unsigned long arg );
static ssize_t rwbuf_write ( struct file * filep,    const char *buf, 
                                           size_t   count,   loff_t * ppos );

static struct file_operations rwbuf_fops =
{
	open:     rwbuf_open,
	release: rwbuf_close,
	read:      rwbuf_read,
	write:     rwbuf_write,
	unlocked_ioctl:      rwbuf_ioctl,
};


static ssize_t rwbuf_read( struct file* filep,   char * buf, size_t count, loff_t* ppos)
{
	if(count > rwbuf_size || count <0)
	{
		printk("error input");
		return 0;
	}
	// 判断读取的长度是否有效
	copy_to_user( buf, rwbuf, count); // 从内核空间复制到用户空间
   // print some message by printk()
	return count;
}

static long  rwbuf_ioctl  (  struct file * filep,
			unsigned int cmd, unsigned long arg )
{
	if ( cmd == RWBUF_CLEAR )  {
		rwlen = 0;	// clear buf by set its len to zero
		rwbuf[0] = '\0';
		printk("rwbuf in kernel zero-ed\n");
	};

	return 0;
}

static ssize_t rwbuf_write ( struct file * filep,    const char *buf, 
                                           size_t   count,   loff_t * ppos )
{
	// 判断写入的长度是否有效
	copy_from_user(rwbuf, buf, count); // 从用户空间复制到内核空间
	rwlen = count;
   //  print some message by printk();
	return count;
}


static int inuse=0;	// only one process permited at the same time
static int  rwbuf_open ( struct inode *inode,  struct file * filep )  {
    if (inuse == 1)  return  -1;
    inuse = 1;
   try_module_get(THIS_MODULE);
   return 0;
}

static int rwbuf_close( struct inode *inode,  struct file * filep ) {
	inuse  =  0;
	module_put(THIS_MODULE);
	return 0;
}

int init_rwbuf(void)
{
      printk("Hello world\n");
      if ( register_chrdev(60,                          DEVICE_NAME, &rwbuf_fops))
		
      {  printk("register error\n");
         return -1; 
      }
     printk("register ok\n");
     return 0;
}

void cleanup_rwbuf(void)
{
    unregister_chrdev(  60,  DEVICE_NAME);
    printk("bye\n");
}

MODULE_LICENSE("GPL");
module_init(init_rwbuf);
module_exit(cleanup_rwbuf);
