
     ](langchain_core.documents.baseDocument)}(__dict__}(idNmetadata}(sourcehttps://vuejs.org/tutorial/titleTutorial | Vue.jsupage_contentX  Skip to content
Vue.js
Search
Main Navigation
Docs
Guide
Tutorial
Examples
Quick Start
Glossary
Error Reference
Vue 2 Docs
Migration from Vue 2
API
Playground
Ecosystem
Resources
Partners
Themes
UI Components
Certification
Jobs
T-Shirt Shop
Official Libraries
Vue Router
Pinia
Tooling Guide
Video Courses
Vue Mastery
Vue School
Help
Discord Chat
GitHub Discussions
DEV Community
News
Blog
Twitter
Events
Newsletters
About
FAQ
Team
Releases
Community Guide
Code of Conduct
Privacy Policy
The Documentary
Sponsor
Partners
简体中文
日本語
Українська
Français
한국어
Português
বাংলা
Italiano
فارسی
Русский
Čeština
繁體中文
Help Us Translate!
github
twitter
discord
Appearance
github
twitter
discord
Tutorial has loadedtypehu__fields_set__(hh	__private_attribute_values__}ubh)}(h}(hNh	}(hhttps://vuejs.org/api/sfc-spech
!SFC Syntax Specification | Vue.jsuhX  SFC Syntax Specification
Overview
A Vue Single-File Component (SFC), conventionally using the *.vue
file extension, is a custom file format that uses an HTML-like syntax to describe a Vue component. A Vue SFC is syntactically compatible with HTML.
Each *.vue
file consists of three types of top-level language blocks: <template>
, <script>
, and <style>
, and optionally additional custom blocks:
vue
<template>
<div class="example">{{ msg }}</div>
</template>
<script>
export default {
data() {
return {
msg: 'Hello world!'
}
}
}
</script>
<style>
.example {
color: red;
}
</style>
<custom1>
This could be e.g. documentation for the component.
</custom1>
Language Blocks
<template>
Each
*.vue
file can contain at most one top-level<template>
block.Contents will be extracted and passed on to
@vue/compiler-dom
, pre-compiled into JavaScript render functions, and attached to the exported component as itsrender
option.
<script>
Each
*.vue
file can contain at most one<script>
block (excluding<script setup>
).The script is executed as an ES Module.
The default export should be a Vue component options object, either as a plain object or as the return value of defineComponent.
<script setup>
Each
*.vue
file can contain at most one<script setup>
block (excluding normal<script>
).The script is pre-processed and used as the component's
setup()
function, which means it will be executed for each instance of the component. Top-level bindings in<script setup>
are automatically exposed to the template. For more details, see dedicated documentation on<script setup>
.
<style>
A single
*.vue
file can contain multiple<style>
tags.A
<style>
tag can havescoped
ormodule
attributes (see SFC Style Features for more details) to help encapsulate the styles to the current component. Multiple<style>
tags with different encapsulation modes can be mixed in the same component.
Custom Blocks
Additional custom blocks can be included in a *.vue
file for any project-specific needs, for example a <docs>
block. Some real-world examples of custom blocks include:
Handling of Custom Blocks will depend on tooling - if you want to build your own custom block integrations, see the SFC custom block integrations tooling section for more details.
Automatic Name Inference
An SFC automatically infers the component's name from its filename in the following cases:
- Dev warning formatting
- DevTools inspection
- Recursive self-reference, e.g. a file named
FooBar.vue
can refer to itself as<FooBar/>
in its template. This has lower priority than explicitly registered/imported components.
Pre-Processors
Blocks can declare pre-processor languages using the lang
attribute. The most common case is using TypeScript for the <script>
block:
template
<script lang="ts">
// use TypeScript
</script>
lang
can be applied to any block - for example we can use <style>
with Sass and <template>
with Pug:
template
<template lang="pug">
p {{ msg }}
</template>
<style lang="scss">
$primary-color: #333;
body {
color: $primary-color;
}
</style>
Note that integration with various pre-processors may differ by toolchain. Check out the respective documentation for examples:
src
Imports
If you prefer splitting up your *.vue
components into multiple files, you can use the src
attribute to import an external file for a language block:
vue
<template src="./template.html"></template>
<style src="./style.css"></style>
<script src="./script.js"></script>
Beware that src
imports follow the same path resolution rules as webpack module requests, which means:
- Relative paths need to start with
./
- You can import resources from npm dependencies:
vue
<!-- import a file from the installed "todomvc-app-css" npm package -->
<style src="todomvc-app-css/index.css" />
src
imports also work with custom blocks, e.g.:
vue
<unit-test src="./unit-test.js">
</unit-test>
Comments
Inside each block you shall use the comment syntax of the language being used (HTML, CSS, JavaScript, Pug, etc.). For top-level comments, use HTML comment syntax: <!-- comment contents here -->hhuh(hh	h}ubh)}(h}(hNh	}(h#https://vuejs.org/api/options-stateh
Options: State | Vue.jsuhX,  Options: State
data
A function that returns the initial reactive state for the component instance.
Type
tsinterface ComponentOptions { data?( this: ComponentPublicInstance, vm: ComponentPublicInstance ): object }
Details
The function is expected to return a plain JavaScript object, which will be made reactive by Vue. After the instance is created, the reactive data object can be accessed as
this.$data
. The component instance also proxies all the properties found on the data object, sothis.a
will be equivalent tothis.$data.a
.All top-level data properties must be included in the returned data object. Adding new properties to
this.$data
is possible, but it is not recommended. If the desired value of a property is not yet available then an empty value such asundefined
ornull
should be included as a placeholder to ensure that Vue knows that the property exists.Properties that start with
_
or$
will not be proxied on the component instance because they may conflict with Vue's internal properties and API methods. You will have to access them asthis.$data._property
.It is not recommended to return objects with their own stateful behavior like browser API objects and prototype properties. The returned object should ideally be a plain object that only represents the state of the component.
Example
jsexport default { data() { return { a: 1 } }, created() { console.log(this.a) // 1 console.log(this.$data) // { a: 1 } } }
Note that if you use an arrow function with the
data
property,this
won't be the component's instance, but you can still access the instance as the function's first argument:jsdata: (vm) => ({ a: vm.myProp })
See also Reactivity in Depth
props
Declare the props of a component.
Type
tsinterface ComponentOptions { props?: ArrayPropsOptions | ObjectPropsOptions } type ArrayPropsOptions = string[] type ObjectPropsOptions = { [key: string]: Prop } type Prop<T = any> = PropOptions<T> | PropType<T> | null interface PropOptions<T> { type?: PropType<T> required?: boolean default?: T | ((rawProps: object) => T) validator?: (value: unknown, rawProps: object) => boolean } type PropType<T> = { new (): T } | { new (): T }[]
Types are simplified for readability.
Details
In Vue, all component props need to be explicitly declared. Component props can be declared in two forms:
- Simple form using an array of strings
- Full form using an object where each property key is the name of the prop, and the value is the prop's type (a constructor function) or advanced options.
With object-based syntax, each prop can further define the following options:
type
: Can be one of the following native constructors:String
,Number
,Boolean
,Array
,Object
,Date
,Function
,Symbol
, any custom constructor function or an array of those. In development mode, Vue will check if a prop's value matches the declared type, and will throw a warning if it doesn't. See Prop Validation for more details.Also note that a prop with
Boolean
type affects its value casting behavior in both development and production. See Boolean Casting for more details.default
: Specifies a default value for the prop when it is not passed by the parent or hasundefined
value. Object or array defaults must be returned using a factory function. The factory function also receives the raw props object as the argument.required
: Defines if the prop is required. In a non-production environment, a console warning will be thrown if this value is truthy and the prop is not passed.validator
: Custom validator function that takes the prop value as the sole argument. In development mode, a console warning will be thrown if this function returns a falsy value (i.e. the validation fails).
Example
Simple declaration:
jsexport default { props: ['size', 'myMessage'] }
Object declaration with validations:
jsexport default { props: { // type check height: Number, // type check plus other validations age: { type: Number, default: 0, required: true, validator: (value) => { return value >= 0 } } } }
See also
computed
Declare computed properties to be exposed on the component instance.
Type
tsinterface ComponentOptions { computed?: { [key: string]: ComputedGetter<any> | WritableComputedOptions<any> } } type ComputedGetter<T> = ( this: ComponentPublicInstance, vm: ComponentPublicInstance ) => T type ComputedSetter<T> = ( this: ComponentPublicInstance, value: T ) => void type WritableComputedOptions<T> = { get: ComputedGetter<T> set: ComputedSetter<T> }
Details
The option accepts an object where the key is the name of the computed property, and the value is either a computed getter, or an object with
get
andset
methods (for writable computed properties).All getters and setters have their
this
context automatically bound to the component instance.Note that if you use an arrow function with a computed property,
this
won't point to the component's instance, but you can still access the instance as the function's first argument:jsexport default { computed: { aDouble: (vm) => vm.a * 2 } }
Example
jsexport default { data() { return { a: 1 } }, computed: { // readonly aDouble() { return this.a * 2 }, // writable aPlus: { get() { return this.a + 1 }, set(v) { this.a = v - 1 } } }, created() { console.log(this.aDouble) // => 2 console.log(this.aPlus) // => 2 this.aPlus = 3 console.log(this.a) // => 2 console.log(this.aDouble) // => 4 } }
See also
methods
Declare methods to be mixed into the component instance.
Type
tsinterface ComponentOptions { methods?: { [key: string]: (this: ComponentPublicInstance, ...args: any[]) => any } }
Details
Declared methods can be directly accessed on the component instance, or used in template expressions. All methods have their
this
context automatically bound to the component instance, even when passed around.Avoid using arrow functions when declaring methods, as they will not have access to the component instance via
this
.Example
jsexport default { data() { return { a: 1 } }, methods: { plus() { this.a++ } }, created() { this.plus() console.log(this.a) // => 2 } }
See also Event Handling
watch
Declare watch callbacks to be invoked on data change.
Type
tsinterface ComponentOptions { watch?: { [key: string]: WatchOptionItem | WatchOptionItem[] } } type WatchOptionItem = string | WatchCallback | ObjectWatchOptionItem type WatchCallback<T> = ( value: T, oldValue: T, onCleanup: (cleanupFn: () => void) => void ) => void type ObjectWatchOptionItem = { handler: WatchCallback | string immediate?: boolean // default: false deep?: boolean // default: false flush?: 'pre' | 'post' | 'sync' // default: 'pre' onTrack?: (event: DebuggerEvent) => void onTrigger?: (event: DebuggerEvent) => void }
Types are simplified for readability.
Details
The
watch
option expects an object where keys are the reactive component instance properties to watch (e.g. properties declared viadata
orcomputed
) — and values are the corresponding callbacks. The callback receives the new value and the old value of the watched source.In addition to a root-level property, the key can also be a simple dot-delimited path, e.g.
a.b.c
. Note that this usage does not support complex expressions - only dot-delimited paths are supported. If you need to watch complex data sources, use the imperative$watch()
API instead.The value can also be a string of a method name (declared via
methods
), or an object that contains additional options. When using the object syntax, the callback should be declared under thehandler
field. Additional options include:immediate
: trigger the callback immediately on watcher creation. Old value will beundefined
on the first call.deep
: force deep traversal of the source if it is an object or an array, so that the callback fires on deep mutations. See Deep Watchers.flush
: adjust the callback's flush timing. See Callback Flush Timing andwatchEffect()
.onTrack / onTrigger
: debug the watcher's dependencies. See Watcher Debugging.
Avoid using arrow functions when declaring watch callbacks as they will not have access to the component instance via
this
.Example
jsexport default { data() { return { a: 1, b: 2, c: { d: 4 }, e: 5, f: 6 } }, watch: { // watching top-level property a(val, oldVal) { console.log(`new: ${val}, old: ${oldVal}`) }, // string method name b: 'someMethod', // the callback will be called whenever any of the watched object properties change regardless of their nested depth c: { handler(val, oldVal) { console.log('c changed') }, deep: true }, // watching a single nested property: 'c.d': function (val, oldVal) { // do something }, // the callback will be called immediately after the start of the observation e: { handler(val, oldVal) { console.log('e changed') }, immediate: true }, // you can pass array of callbacks, they will be called one-by-one f: [ 'handle1', function handle2(val, oldVal) { console.log('handle2 triggered') }, { handler: function handle3(val, oldVal) { console.log('handle3 triggered') } /* ... */ } ] }, methods: { someMethod() { console.log('b changed') }, handle1() { console.log('handle 1 triggered') } }, created() { this.a = 3 // => new: 3, old: 1 } }
See also Watchers
emits
Declare the custom events emitted by the component.
Type
tsinterface ComponentOptions { emits?: ArrayEmitsOptions | ObjectEmitsOptions } type ArrayEmitsOptions = string[] type ObjectEmitsOptions = { [key: string]: EmitValidator | null } type EmitValidator = (...args: unknown[]) => boolean
Details
Emitted events can be declared in two forms:
- Simple form using an array of strings
- Full form using an object where each property key is the name of the event, and the value is either
null
or a validator function.
The validation function will receive the additional arguments passed to the component's
$emit
call. For example, ifthis.$emit('foo', 1)
is called, the corresponding validator forfoo
will receive the argument1
. The validator function should return a boolean to indicate whether the event arguments are valid.Note that the
emits
option affects which event listeners are considered component event listeners, rather than native DOM event listeners. The listeners for declared events will be removed from the component's$attrs
object, so they will not be passed through to the component's root element. See Fallthrough Attributes for more details.Example
Array syntax:
jsexport default { emits: ['check'], created() { this.$emit('check') } }
Object syntax:
jsexport default { emits: { // no validation click: null, // with validation submit: (payload) => { if (payload.email && payload.password) { return true } else { console.warn(`Invalid submit event payload!`) return false } } } }
See also
expose
Declare exposed public properties when the component instance is accessed by a parent via template refs.
Type
tsinterface ComponentOptions { expose?: string[] }
Details
By default, a component instance exposes all instance properties to the parent when accessed via
$parent
,$root
, or template refs. This can be undesirable, since a component most likely has internal state or methods that should be kept private to avoid tight coupling.The
expose
option expects a list of property name strings. Whenexpose
is used, only the properties explicitly listed will be exposed on the component's public instance.expose
only affects user-defined properties - it does not filter out built-in component instance properties.Example
jsexport default { // only `publicMethod` will be available on the public instance expose: ['publicMethod'], methods: { publicMethod() { // ... }, privateMethod() { // ... } } }hhuh(hh	h}ubh)}(h}(hNh	}(h(https://vuejs.org/api/component-instanceh
Component Instance | Vue.jsuhX  Component Instance
INFO
This page documents the built-in properties and methods exposed on the component public instance, i.e. this
.
All properties listed on this page are readonly (except nested properties in $data
).
$data
The object returned from the data
option, made reactive by the component. The component instance proxies access to the properties on its data object.
Type
tsinterface ComponentPublicInstance { $data: object }
$props
An object representing the component's current, resolved props.
Type
tsinterface ComponentPublicInstance { $props: object }
Details
Only props declared via the
props
option will be included. The component instance proxies access to the properties on its props object.
$el
The root DOM node that the component instance is managing.
Type
tsinterface ComponentPublicInstance { $el: Node | undefined }
Details
$el
will beundefined
until the component is mounted.- For components with a single root element,
$el
will point to that element. - For components with text root,
$el
will point to the text node. - For components with multiple root nodes,
$el
will be the placeholder DOM node that Vue uses to keep track of the component's position in the DOM (a text node, or a comment node in SSR hydration mode).
TIP
For consistency, it is recommended to use template refs for direct access to elements instead of relying on
$el
.- For components with a single root element,
$options
The resolved component options used for instantiating the current component instance.
Type
tsinterface ComponentPublicInstance { $options: ComponentOptions }
Details
The
$options
object exposes the resolved options for the current component and is the merge result of these possible sources:- Global mixins
- Component
extends
base - Component mixins
It is typically used to support custom component options:
jsconst app = createApp({ customOption: 'foo', created() { console.log(this.$options.customOption) // => 'foo' } })
See also
app.config.optionMergeStrategies
$parent
The parent instance, if the current instance has one. It will be null
for the root instance itself.
Type
tsinterface ComponentPublicInstance { $parent: ComponentPublicInstance | null }
$root
The root component instance of the current component tree. If the current instance has no parents this value will be itself.
Type
tsinterface ComponentPublicInstance { $root: ComponentPublicInstance }
$slots
An object representing the slots passed by the parent component.
Type
tsinterface ComponentPublicInstance { $slots: { [name: string]: Slot } } type Slot = (...args: any[]) => VNode[]
Details
Typically used when manually authoring render functions, but can also be used to detect whether a slot is present.
Each slot is exposed on
this.$slots
as a function that returns an array of vnodes under the key corresponding to that slot's name. The default slot is exposed asthis.$slots.default
.If a slot is a scoped slot, arguments passed to the slot functions are available to the slot as its slot props.
See also Render Functions - Rendering Slots
$refs
An object of DOM elements and component instances, registered via template refs.
Type
tsinterface ComponentPublicInstance { $refs: { [name: string]: Element | ComponentPublicInstance | null } }
See also
$attrs
An object that contains the component's fallthrough attributes.
Type
tsinterface ComponentPublicInstance { $attrs: object }
Details
Fallthrough Attributes are attributes and event handlers passed by the parent component, but not declared as a prop or an emitted event by the child.
By default, everything in
$attrs
will be automatically inherited on the component's root element if there is only a single root element. This behavior is disabled if the component has multiple root nodes, and can be explicitly disabled with theinheritAttrs
option.See also
$watch()
Imperative API for creating watchers.
Type
tsinterface ComponentPublicInstance { $watch( source: string | (() => any), callback: WatchCallback, options?: WatchOptions ): StopHandle } type WatchCallback<T> = ( value: T, oldValue: T, onCleanup: (cleanupFn: () => void) => void ) => void interface WatchOptions { immediate?: boolean // default: false deep?: boolean // default: false flush?: 'pre' | 'post' | 'sync' // default: 'pre' onTrack?: (event: DebuggerEvent) => void onTrigger?: (event: DebuggerEvent) => void } type StopHandle = () => void
Details
The first argument is the watch source. It can be a component property name string, a simple dot-delimited path string, or a getter function.
The second argument is the callback function. The callback receives the new value and the old value of the watched source.
immediate
: trigger the callback immediately on watcher creation. Old value will beundefined
on the first call.deep
: force deep traversal of the source if it is an object, so that the callback fires on deep mutations. See Deep Watchers.flush
: adjust the callback's flush timing. See Callback Flush Timing andwatchEffect()
.onTrack / onTrigger
: debug the watcher's dependencies. See Watcher Debugging.
Example
Watch a property name:
jsthis.$watch('a', (newVal, oldVal) => {})
Watch a dot-delimited path:
jsthis.$watch('a.b', (newVal, oldVal) => {})
Using getter for more complex expressions:
jsthis.$watch( // every time the expression `this.a + this.b` yields // a different result, the handler will be called. // It's as if we were watching a computed property // without defining the computed property itself. () => this.a + this.b, (newVal, oldVal) => {} )
Stopping the watcher:
jsconst unwatch = this.$watch('a', cb) // later... unwatch()
See also
$emit()
Trigger a custom event on the current instance. Any additional arguments will be passed into the listener's callback function.
Type
tsinterface ComponentPublicInstance { $emit(event: string, ...args: any[]): void }
Example
jsexport default { created() { // only event this.$emit('foo') // with additional arguments this.$emit('bar', 1, 2, 3) } }
See also
$forceUpdate()
Force the component instance to re-render.
Type
tsinterface ComponentPublicInstance { $forceUpdate(): void }
Details
This should be rarely needed given Vue's fully automatic reactivity system. The only cases where you may need it is when you have explicitly created non-reactive component state using advanced reactivity APIs.
$nextTick()
Instance-bound version of the global nextTick()
.
Type
tsinterface ComponentPublicInstance { $nextTick(callback?: (this: ComponentPublicInstance) => void): Promise<void> }
Details
The only difference from the global version of
nextTick()
is that the callback passed tothis.$nextTick()
will have itsthis
context bound to the current component instance.See also
nextTick()hhuh(hh	h}ubh)}(h}(hNh	}(h%https://vuejs.org/api/custom-rendererh
Custom Renderer API | Vue.jsuhXF  Custom Renderer API
createRenderer()
Creates a custom renderer. By providing platform-specific node creation and manipulation APIs, you can leverage Vue's core runtime to target non-DOM environments.
Type
tsfunction createRenderer<HostNode, HostElement>( options: RendererOptions<HostNode, HostElement> ): Renderer<HostElement> interface Renderer<HostElement> { render: RootRenderFunction<HostElement> createApp: CreateAppFunction<HostElement> } interface RendererOptions<HostNode, HostElement> { patchProp( el: HostElement, key: string, prevValue: any, nextValue: any, // the rest is unused for most custom renderers isSVG?: boolean, prevChildren?: VNode<HostNode, HostElement>[], parentComponent?: ComponentInternalInstance | null, parentSuspense?: SuspenseBoundary | null, unmountChildren?: UnmountChildrenFn ): void insert( el: HostNode, parent: HostElement, anchor?: HostNode | null ): void remove(el: HostNode): void createElement( type: string, isSVG?: boolean, isCustomizedBuiltIn?: string, vnodeProps?: (VNodeProps & { [key: string]: any }) | null ): HostElement createText(text: string): HostNode createComment(text: string): HostNode setText(node: HostNode, text: string): void setElementText(node: HostElement, text: string): void parentNode(node: HostNode): HostElement | null nextSibling(node: HostNode): HostNode | null // optional, DOM-specific querySelector?(selector: string): HostElement | null setScopeId?(el: HostElement, id: string): void cloneNode?(node: HostNode): HostNode insertStaticContent?( content: string, parent: HostElement, anchor: HostNode | null, isSVG: boolean ): [HostNode, HostNode] }
Example
jsimport { createRenderer } from '@vue/runtime-core' const { render, createApp } = createRenderer({ patchProp, insert, remove, createElement // ... }) // `render` is the low-level API // `createApp` returns an app instance export { render, createApp } // re-export Vue core APIs export * from '@vue/runtime-core'
Vue's own
@vue/runtime-dom
is implemented using the same API. For a simpler implementation, check out@vue/runtime-test
which is a private package for Vue's own unit testing.hhuh(hh	h}ubh)}(h}(hNh	}(h*https://vuejs.org/api/reactivity-utilitiesh
"Reactivity API: Utilities | Vue.jsuhX  Reactivity API: Utilities
isRef()
Checks if a value is a ref object.
Type
tsfunction isRef<T>(r: Ref<T> | unknown): r is Ref<T>
Note the return type is a type predicate, which means
isRef
can be used as a type guard:tslet foo: unknown if (isRef(foo)) { // foo's type is narrowed to Ref<unknown> foo.value }
unref()
Returns the inner value if the argument is a ref, otherwise return the argument itself. This is a sugar function for val = isRef(val) ? val.value : val
.
Type
tsfunction unref<T>(ref: T | Ref<T>): T
Example
tsfunction useFoo(x: number | Ref<number>) { const unwrapped = unref(x) // unwrapped is guaranteed to be number now }
toRef()
Can be used to normalize values / refs / getters into refs (3.3+).
Can also be used to create a ref for a property on a source reactive object. The created ref is synced with its source property: mutating the source property will update the ref, and vice-versa.
Type
ts// normalization signature (3.3+) function toRef<T>( value: T ): T extends () => infer R ? Readonly<Ref<R>> : T extends Ref ? T : Ref<UnwrapRef<T>> // object property signature function toRef<T extends object, K extends keyof T>( object: T, key: K, defaultValue?: T[K] ): ToRef<T[K]> type ToRef<T> = T extends Ref ? T : Ref<T>
Example
Normalization signature (3.3+):
js// returns existing refs as-is toRef(existingRef) // creates a readonly ref that calls the getter on .value access toRef(() => props.foo) // creates normal refs from non-function values // equivalent to ref(1) toRef(1)
Object property signature:
jsconst state = reactive({ foo: 1, bar: 2 }) // a two-way ref that syncs with the original property const fooRef = toRef(state, 'foo') // mutating the ref updates the original fooRef.value++ console.log(state.foo) // 2 // mutating the original also updates the ref state.foo++ console.log(fooRef.value) // 3
Note this is different from:
jsconst fooRef = ref(state.foo)
The above ref is not synced with
state.foo
, because theref()
receives a plain number value.toRef()
is useful when you want to pass the ref of a prop to a composable function:vue<script setup> import { toRef } from 'vue' const props = defineProps(/* ... */) // convert `props.foo` into a ref, then pass into // a composable useSomeFeature(toRef(props, 'foo')) // getter syntax - recommended in 3.3+ useSomeFeature(toRef(() => props.foo)) </script>
When
toRef
is used with component props, the usual restrictions around mutating the props still apply. Attempting to assign a new value to the ref is equivalent to trying to modify the prop directly and is not allowed. In that scenario you may want to consider usingcomputed
withget
andset
instead. See the guide to usingv-model
with components for more information.When using the object property signature,
toRef()
will return a usable ref even if the source property doesn't currently exist. This makes it possible to work with optional properties, which wouldn't be picked up bytoRefs
.
toValue()
Normalizes values / refs / getters to values. This is similar to unref(), except that it also normalizes getters. If the argument is a getter, it will be invoked and its return value will be returned.
This can be used in Composables to normalize an argument that can be either a value, a ref, or a getter.
Type
tsfunction toValue<T>(source: T | Ref<T> | (() => T)): T
Example
jstoValue(1) // --> 1 toValue(ref(1)) // --> 1 toValue(() => 1) // --> 1
Normalizing arguments in composables:
tsimport type { MaybeRefOrGetter } from 'vue' function useFeature(id: MaybeRefOrGetter<number>) { watch(() => toValue(id), id => { // react to id changes }) } // this composable supports any of the following: useFeature(1) useFeature(ref(1)) useFeature(() => 1)
toRefs()
Converts a reactive object to a plain object where each property of the resulting object is a ref pointing to the corresponding property of the original object. Each individual ref is created using toRef()
.
Type
tsfunction toRefs<T extends object>( object: T ): { [K in keyof T]: ToRef<T[K]> } type ToRef = T extends Ref ? T : Ref<T>
Example
jsconst state = reactive({ foo: 1, bar: 2 }) const stateAsRefs = toRefs(state) /* Type of stateAsRefs: { foo: Ref<number>, bar: Ref<number> } */ // The ref and the original property is "linked" state.foo++ console.log(stateAsRefs.foo.value) // 2 stateAsRefs.foo.value++ console.log(state.foo) // 3
toRefs
is useful when returning a reactive object from a composable function so that the consuming component can destructure/spread the returned object without losing reactivity:jsfunction useFeatureX() { const state = reactive({ foo: 1, bar: 2 }) // ...logic operating on state // convert to refs when returning return toRefs(state) } // can destructure without losing reactivity const { foo, bar } = useFeatureX()
toRefs
will only generate refs for properties that are enumerable on the source object at call time. To create a ref for a property that may not exist yet, usetoRef
instead.
isProxy()
Checks if an object is a proxy created by reactive()
, readonly()
, shallowReactive()
or shallowReadonly()
.
Type
tsfunction isProxy(value: any): boolean
isReactive()
Checks if an object is a proxy created by reactive()
or shallowReactive()
.
Type
tsfunction isReactive(value: unknown): boolean
isReadonly()
Checks whether the passed value is a readonly object. The properties of a readonly object can change, but they can't be assigned directly via the passed object.
The proxies created by readonly()
and shallowReadonly()
are both considered readonly, as is a computed()
ref without a set
function.
Type
tsfunction isReadonly(value: unknown): booleanhhuh(hh	h}ubh)}(h}(hNh	}(hhttps://vuejs.org/api/h
API Reference | Vue.jsuhX  API Reference
Global API
Application
- createApp()
- createSSRApp()
- app.mount()
- app.unmount()
- app.component()
- app.directive()
- app.use()
- app.mixin()
- app.provide()
- app.runWithContext()
- app.version
- app.config
- app.config.errorHandler
- app.config.warnHandler
- app.config.performance
- app.config.compilerOptions
- app.config.globalProperties
- app.config.optionMergeStrategieshhuh(hh	h}ubh)}(h}(hNh	}(hhttps://vuejs.org/glossary/h
Glossary | Vue.jsuhXVT  Glossary
This glossary is intended to provide some guidance about the meanings of technical terms that are in common usage when talking about Vue. It is intended to be descriptive of how terms are commonly used, not a prescriptive specification of how they must be used. Some terms may have slightly different meanings or nuances depending on the surrounding context.
async component
An async component is a wrapper around another component that allows for the wrapped component to be lazy loaded. This is typically used as a way to reduce the size of the built .js
files, allowing them to be split into smaller chunks that are loaded only when required.
Vue Router has a similar feature for the lazy loading of route components, though this does not use Vue's async components feature.
For more details see:
compiler macro
A compiler macro is special code that is processed by a compiler and converted into something else. They are effectively a clever form of string replacement.
Vue's SFC compiler supports various macros, such as defineProps()
, defineEmits()
and defineExpose()
. These macros are intentionally designed to look like normal JavaScript functions so that they can leverage the same parser and type inference tooling around JavaScript / TypeScript. However, they are not actual functions that are run in the browser. These are special strings that the compiler detects and replaces with the real JavaScript code that will actually be run.
Macros have limitations on their use that don't apply to normal JavaScript code. For example, you might think that const dp = defineProps
would allow you to create an alias for defineProps
, but it'll actually result in an error. There are also limitations on what values can be passed to defineProps()
, as the 'arguments' have to be processed by the compiler and not at runtime.
For more details see:
component
The term component is not unique to Vue. It is common to many UI frameworks. It describes a chunk of the UI, such as a button or checkbox. Components can also be combined to form larger components.
Components are the primary mechanism provided by Vue to split a UI into smaller pieces, both to improve maintainability and to allow for code reuse.
A Vue component is an object. All properties are optional, but either a template or render function is required for the component to render. For example, the following object would be a valid component:
js
const HelloWorldComponent = {
render() {
return 'Hello world!'
}
}
In practice, most Vue applications are written using Single-File Components (.vue
files). While these components may not appear to be objects at first glance, the SFC compiler will convert them into an object, which is used as the default export for the file. From an external perspective, a .vue
file is just an ES module that exports a component object.
The properties of a component object are usually referred to as options. This is where the Options API gets its name.
The options for a component define how instances of that component should be created. Components are conceptually similar to classes, though Vue doesn't use actual JavaScript classes to define them.
The term component can also be used more loosely to refer to component instances.
For more details see:
The word 'component' also features in several other terms:
composable
The term composable describes a common usage pattern in Vue. It isn't a separate feature of Vue, it's just a way of using the framework's Composition API.
- A composable is a function.
- Composables are used to encapsulate and reuse stateful logic.
- The function name usually begins with
use
, so that other developers know it's a composable. - The function is typically expected to be called during the synchronous execution of a component's
setup()
function (or, equivalently, during the execution of a<script setup>
block). This ties the invocation of the composable to the current component context, e.g. via calls toprovide()
,inject()
oronMounted()
. - Composables typically return a plain object, not a reactive object. This object usually contains refs and functions and is expected to be destructured within the calling code.
As with many patterns, there can be some disagreement about whether specific code qualifies for the label. Not all JavaScript utility functions are composables. If a function doesn't use the Composition API then it probably isn't a composable. If it doesn't expect to be called during the synchronous execution of setup()
then it probably isn't a composable. Composables are specifically used to encapsulate stateful logic, they are not just a naming convention for functions.
See Guide - Composables for more details about writing composables.
Composition API
The Composition API is a collection of functions used to write components and composables in Vue.
The term is also used to describe one of the two main styles used to write components, the other being the Options API. Components written using the Composition API use either <script setup>
or an explicit setup()
function.
See the Composition API FAQ for more details.
custom element
A custom element is a feature of the Web Components standard, which is implemented in modern web browsers. It refers to the ability to use a custom HTML element in your HTML markup to include a Web Component at that point in the page.
Vue has built-in support for rendering custom elements and allows them to be used directly in Vue component templates.
Custom elements should not be confused with the ability to include Vue components as tags within another Vue component's template. Custom elements are used to create Web Components, not Vue components.
For more details see:
directive
The term directive refers to template attributes beginning with the v-
prefix, or their equivalent shorthands.
Built-in directives include v-if
, v-for
, v-bind
, v-on
and v-slot
.
Vue also supports creating custom directives, though they are typically only used as an 'escape hatch' for manipulating DOM nodes directly. Custom directives generally can't be used to recreate the functionality of the built-in directives.
For more details see:
dynamic component
The term dynamic component is used to describe cases where the choice of which child component to render needs to be made dynamically. Typically, this is achieved using <component :is="type">
.
A dynamic component is not a special type of component. Any component can be used as a dynamic component. It is the choice of component that is dynamic, rather than the component itself.
For more details see:
effect
See reactive effect and side effect.
event
The use of events for communicating between different parts of a program is common to many different areas of programming. Within Vue, the term is commonly applied to both native HTML element events and Vue component events. The v-on
directive is used in templates to listen for both types of event.
For more details see:
fragment
The term fragment refers to a special type of VNode that is used as a parent for other VNodes, but which doesn't render any elements itself.
The name comes from the similar concept of a DocumentFragment
in the native DOM API.
Fragments are used to support components with multiple root nodes. While such components might appear to have multiple roots, behind the scenes they use a fragment node as a single root, as a parent of the 'root' nodes.
Fragments are also used by the template compiler as a way to wrap multiple dynamic nodes, e.g. those created via v-for
or v-if
. This allows for extra hints to be passed to the VDOM patching algorithm. Much of this is handled internally, but one place you may encounter this directly is using a key
on a <template>
tag with v-for
. In that scenario, the key
is added as a prop to the fragment VNode.
Fragment nodes are currently rendered to the DOM as empty text nodes, though that is an implementation detail. You may encounter those text nodes if you use $el
or attempt to walk the DOM with built-in browser APIs.
functional component
A component definition is usually an object containing options. It may not appear that way if you're using <script setup>
, but the component exported from the .vue
file will still be an object.
A functional component is an alternative form of component that is declared using a function instead. That function acts as the render function for the component.
A functional component cannot have any state of its own. It also doesn't go through the usual component lifecycle, so lifecycle hooks can't be used. This makes them slightly lighter than normal, stateful components.
For more details see:
hoisting
The term hoisting is used to describe running a section of code before it is reached, ahead of other code. The execution is 'pulled up' to an earlier point.
JavaScript uses hoisting for some constructs, such as var
, import
and function declarations.
In a Vue context, the template compiler applies static hoisting to improve performance. When converting a template to a render function, VNodes that correspond to static content can be created once and then reused. These static VNodes are described as hoisted because they are created outside the render function, before it runs. A similar form of hoisting is applied to static objects or arrays that are generated by the template compiler.
For more details see:
in-DOM template
There are various ways to specify a template for a component. In most cases the template is provided as a string.
The term in-DOM template refers to the scenario where the template is provided in the form of DOM nodes, instead of a string. Vue then converts the DOM nodes into a template string using innerHTML
.
Typically, an in-DOM template starts off as HTML markup written directly in the HTML of the page. The browser then parses this into DOM nodes, which Vue then uses to read off the innerHTML
.
For more details see:
- Guide - Creating an Application - In-DOM Root Component Template
- Guide - Component Basics - in-DOM Template Parsing Caveats
- Options: Rendering - template
inject
See provide / inject.
lifecycle hooks
A Vue component instance goes through a lifecycle. For example, it is created, mounted, updated, and unmounted.
The lifecycle hooks are a way to listen for these lifecycle events.
With the Options API, each hook is provided as a separate option, e.g. mounted
. The Composition API uses functions instead, such as onMounted()
.
For more details see:
macro
See compiler macro.
named slot
A component can have multiple slots, differentiated by name. Slots other than the default slot are referred to as named slots.
For more details see:
Options API
Vue components are defined using objects. The properties of these component objects are known as options.
Components can be written in two styles. One style uses the Composition API in conjunction with setup
(either via a setup()
option or <script setup>
). The other style makes very little direct use of the Composition API, instead using various component options to achieve a similar result. The component options that are used in this way are referred to as the Options API.
The Options API includes options such as data()
, computed
, methods
and created()
.
Some options, such as props
, emits
and inheritAttrs
, can be used when authoring components with either API. As they are component options, they could be considered part of the Options API. However, as these options are also used in conjunction with setup()
, it is usually more useful to think of them as shared between the two component styles.
The setup()
function itself is a component option, so it could be described as part of the Options API. However, this is not how the term 'Options API' is normally used. Instead, the setup()
function is considered to be part of Composition API.
plugin
While the term plugin can be used in a wide variety of contexts, Vue has a specific concept of a plugin as a way to add functionality to an application.
Plugins are added to an application by calling app.use(plugin)
. The plugin itself is either a function or an object with an install
function. That function will be passed the application instance and can then do whatever it needs to do.
For more details see:
prop
There are three common uses of the term prop in Vue:
- Component props
- VNode props
- Slot props
Component props are what most people think of as props. These are explicitly defined by a component using either defineProps()
or the props
option.
The term VNode props refers to the properties of the object passed as the second argument to h()
. These can include component props, but they can also include component events, DOM events, DOM attributes and DOM properties. You'd usually only encounter VNode props if you're working with render functions to manipulate VNodes directly.
Slot props are the properties passed to a scoped slot.
In all cases, props are properties that are passed in from elsewhere.
While the word props is derived from the word properties, the term props has a much more specific meaning in the context of Vue. You should avoid using it as an abbreviation of properties.
For more details see:
provide / inject
provide
and inject
are a form of inter-component communication.
When a component provides a value, all descendants of that component can then choose to grab that value, using inject
. Unlike with props, the providing component doesn't know precisely which component is receiving the value.
provide
and inject
are sometimes used to avoid prop drilling. They can also be used as an implicit way for a component to communicate with its slot contents.
provide
can also be used at the application level, making a value available to all components within that application.
For more details see:
reactive effect
A reactive effect is part of Vue's reactivity system. It refers to the process of tracking the dependencies of a function and re-running that function when the values of those dependencies change.
watchEffect()
is the most direct way to create an effect. Various other parts of Vue use effects internally. e.g. component rendering updates, computed()
and watch()
.
Vue can only track reactive dependencies within a reactive effect. If a property's value is read outside a reactive effect it'll 'lose' reactivity, in the sense that Vue won't know what to do if that property subsequently changes.
The term is derived from 'side effect'. Calling the effect function is a side effect of the property value being changed.
For more details see:
reactivity
In general, reactivity refers to the ability to automatically perform actions in response to data changes. For example, updating the DOM or making a network request when a data value changes.
In a Vue context, reactivity is used to describe a collection of features. Those features combine to form a reactivity system, which is exposed via the Reactivity API.
There are various different ways that a reactivity system could be implemented. For example, it could be done by static analysis of code to determine its dependencies. However, Vue doesn't employ that form of reactivity system.
Instead, Vue's reactivity system tracks property access at runtime. It does this using both Proxy wrappers and getter/setter functions for properties.
For more details see:
Reactivity API
The Reactivity API is a collection of core Vue functions related to reactivity. These can be used independently of components. It includes functions such as ref()
, reactive()
, computed()
, watch()
and watchEffect()
.
The Reactivity API is a subset of the Composition API.
For more details see:
ref
This entry is about the use of
ref
for reactivity. For theref
attribute used in templates, see template ref instead.
A ref
is part of Vue's reactivity system. It is an object with a single reactive property, called value
.
There are various different types of ref. For example, refs can be created using ref()
, shallowRef()
, computed()
, and customRef()
. The function isRef()
can be used to check whether an object is a ref, and isReadonly()
can be used to check whether the ref allows the direct reassignment of its value.
For more details see:
- Guide - Reactivity Fundamentals
- Reactivity API: Core
- Reactivity API: Utilities
- Reactivity API: Advanced
render function
A render function is the part of a component that generates the VNodes used during rendering. Templates are compiled down into render functions.
For more details see:
scheduler
The scheduler is the part of Vue's internals that controls the timing of when reactive effects are run.
When reactive state changes, Vue doesn't immediately trigger rendering updates. Instead, it batches them together using a queue. This ensures that a component only re-renders once, even if multiple changes are made to the underlying data.
Watchers are also batched using the scheduler queue. Watchers with flush: 'pre'
(the default) will run before component rendering, whereas those with flush: 'post'
will run after component rendering.
Jobs in the scheduler are also used to perform various other internal tasks, such as triggering some lifecycle hooks and updating template refs.
scoped slot
The term scoped slot is used to refer to a slot that receives props.
Historically, Vue made a much greater distinction between scoped and non-scoped slots. To some extent they could be regarded as two separate features, unified behind a common template syntax.
In Vue 3, the slot APIs were simplified to make all slots behave like scoped slots. However, the use cases for scoped and non-scoped slots often differ, so the term still proves useful as a way to refer to slots with props.
The props passed to a slot can only be used within a specific region of the parent template, responsible for defining the slot's contents. This region of the template behaves as a variable scope for the props, hence the name 'scoped slot'.
For more details see:
SFC
side effect
The term side effect is not specific to Vue. It is used to describe operations or functions that do something beyond their local scope.
For example, in the context of setting a property like user.name = null
, it is expected that this will change the value of user.name
. If it also does something else, like triggering Vue's reactivity system, then this would be described as a side effect. This is the origin of the term reactive effect within Vue.
When a function is described as having side effects, it means that the function performs some sort of action that is observable outside the function, aside from just returning a value. This might mean that it updates a value in state, or triggers a network request.
The term is often used when describing rendering or computed properties. It is considered best practice for rendering to have no side effects. Likewise, the getter function for a computed property should have no side effects.
Single-File Component
The term Single-File Component, or SFC, refers to the .vue
file format that is commonly used for Vue components.
See also:
slot
Slots are used to pass content to child components. Whereas props are used to pass data values, slots are used to pass richer content consisting of HTML elements and other Vue components.
For more details see:
template ref
The term template ref refers to using a ref
attribute on a tag within a template. After the component renders, this attribute is used to populate a corresponding property with either the HTML element or the component instance that corresponds to the tag in the template.
If you are using the Options API then the refs are exposed via properties of the $refs
object.
With the Composition API, template refs populate a reactive ref with the same name.
Template refs should not be confused with the reactive refs found in Vue's reactivity system.
For more details see:
VDOM
See virtual DOM.
virtual DOM
The term virtual DOM (VDOM) is not unique to Vue. It is a common approach used by several web frameworks for managing updates to the UI.
Browsers use a tree of nodes to represent the current state of the page. That tree, and the JavaScript APIs used to interact with it, are referred to as the document object model, or DOM.
Manipulating the DOM is a major performance bottleneck. The virtual DOM provides one strategy for managing that.
Rather than creating DOM nodes directly, Vue components generate a description of what DOM nodes they would like. These descriptors are plain JavaScript objects, known as VNodes (virtual DOM nodes). Creating VNodes is relatively cheap.
Every time a component re-renders, the new tree of VNodes is compared to the previous tree of VNodes and any differences are then applied to the real DOM. If nothing has changed then the DOM doesn't need to be touched.
Vue uses a hybrid approach that we call Compiler-Informed Virtual DOM. Vue's template compiler is able to apply performance optimizations based on static analysis of the template. Rather than performing a full comparison of a component's old and new VNode trees at runtime, Vue can use information extracted by the compiler to reduce the comparison to just the parts of the tree that can actually change.
For more details see:
VNode
A VNode is a virtual DOM node. They can be created using the h()
function.
See virtual DOM for more information.
Web Component
The Web Components standard is a collection of features implemented in modern web browsers.
Vue components are not Web Components, but defineCustomElement()
can be used to create a custom element from a Vue component. Vue also supports the use of custom elements inside Vue components.
For more details see:hhuh(hh	h}ubh)}(h}(hNh	}(h&https://vuejs.org/api/sfc-css-featuresh
SFC CSS Features | Vue.jsuhX  SFC CSS Features
Scoped CSS
When a <style>
tag has the scoped
attribute, its CSS will apply to elements of the current component only. This is similar to the style encapsulation found in Shadow DOM. It comes with some caveats, but doesn't require any polyfills. It is achieved by using PostCSS to transform the following:
vue
<style scoped>
.example {
color: red;
}
</style>
<template>
<div class="example">hi</div>
</template>
Into the following:
vue
<style>
.example[data-v-f3f3eg9] {
color: red;
}
</style>
<template>
<div class="example" data-v-f3f3eg9>hi</div>
</template>
Child Component Root Elements
With scoped
, the parent component's styles will not leak into child components. However, a child component's root node will be affected by both the parent's scoped CSS and the child's scoped CSS. This is by design so that the parent can style the child root element for layout purposes.
Deep Selectors
If you want a selector in scoped
styles to be "deep", i.e. affecting child components, you can use the :deep()
pseudo-class:
vue
<style scoped>
.a :deep(.b) {
/* ... */
}
</style>
The above will be compiled into:
css
.a[data-v-f3f3eg9] .b {
/* ... */
}
TIP
DOM content created with v-html
are not affected by scoped styles, but you can still style them using deep selectors.
Slotted Selectors
By default, scoped styles do not affect contents rendered by <slot/>
, as they are considered to be owned by the parent component passing them in. To explicitly target slot content, use the :slotted
pseudo-class:
vue
<style scoped>
:slotted(div) {
color: red;
}
</style>
Global Selectors
If you want just one rule to apply globally, you can use the :global
pseudo-class rather than creating another <style>
(see below):
vue
<style scoped>
:global(.red) {
color: red;
}
</style>
Mixing Local and Global Styles
You can also include both scoped and non-scoped styles in the same component:
vue
<style>
/* global styles */
</style>
<style scoped>
/* local styles */
</style>
Scoped Style Tips
Scoped styles do not eliminate the need for classes. Due to the way browsers render various CSS selectors,
p { color: red }
will be many times slower when scoped (i.e. when combined with an attribute selector). If you use classes or ids instead, such as in.example { color: red }
, then you virtually eliminate that performance hit.Be careful with descendant selectors in recursive components! For a CSS rule with the selector
.a .b
, if the element that matches.a
contains a recursive child component, then all.b
in that child component will be matched by the rule.
CSS Modules
A <style module>
tag is compiled as CSS Modules and exposes the resulting CSS classes to the component as an object under the key of $style
:
vue
<template>
<p :class="$style.red">This should be red</p>
</template>
<style module>
.red {
color: red;
}
</style>
The resulting classes are hashed to avoid collision, achieving the same effect of scoping the CSS to the current component only.
Refer to the CSS Modules spec for more details such as global exceptions and composition.
Custom Inject Name
You can customize the property key of the injected classes object by giving the module
attribute a value:
vue
<template>
<p :class="classes.red">red</p>
</template>
<style module="classes">
.red {
color: red;
}
</style>
Usage with Composition API
The injected classes can be accessed in setup()
and <script setup>
via the useCssModule
API. For <style module>
blocks with custom injection names, useCssModule
accepts the matching module
attribute value as the first argument:
js
import { useCssModule } from 'vue'
// inside setup() scope...
// default, returns classes for <style module>
useCssModule()
// named, returns classes for <style module="classes">
useCssModule('classes')
v-bind()
in CSS
SFC <style>
tags support linking CSS values to dynamic component state using the v-bind
CSS function:
vue
<template>
<div class="text">hello</div>
</template>
<script>
export default {
data() {
return {
color: 'red'
}
}
}
</script>
<style>
.text {
color: v-bind(color);
}
</style>
The syntax works with <script setup>
, and supports JavaScript expressions (must be wrapped in quotes):
vue
<script setup>
import { ref } from 'vue'
const theme = ref({
color: 'red',
})
</script>
<template>
<p>hello</p>
</template>
<style scoped>
p {
color: v-bind('theme.color');
}
</style>
The actual value will be compiled into a hashed CSS custom property, so the CSS is still static. The custom property will be applied to the component's root element via inline styles and reactively updated if the source value changes.hhuh(hh	h}ubh)}(h}(hNh	}(hhttps://vuejs.org/api/generalh
Global API: General | Vue.jsuhX  Global API: General
version
Exposes the current version of Vue.
Type:
string
Example
jsimport { version } from 'vue' console.log(version)
nextTick()
A utility for waiting for the next DOM update flush.
Type
tsfunction nextTick(callback?: () => void): Promise<void>
Details
When you mutate reactive state in Vue, the resulting DOM updates are not applied synchronously. Instead, Vue buffers them until the "next tick" to ensure that each component updates only once no matter how many state changes you have made.
nextTick()
can be used immediately after a state change to wait for the DOM updates to complete. You can either pass a callback as an argument, or await the returned Promise.Example
vue<script setup> import { ref, nextTick } from 'vue' const count = ref(0) async function increment() { count.value++ // DOM not yet updated console.log(document.getElementById('counter').textContent) // 0 await nextTick() // DOM is now updated console.log(document.getElementById('counter').textContent) // 1 } </script> <template> <button id="counter" @click="increment">{{ count }}</button> </template>
See also
this.$nextTick()
defineComponent()
A type helper for defining a Vue component with type inference.
Type
ts// options syntax function defineComponent( component: ComponentOptions ): ComponentConstructor // function syntax (requires 3.3+) function defineComponent( setup: ComponentOptions['setup'], extraOptions?: ComponentOptions ): () => any
Type is simplified for readability.
Details
The first argument expects a component options object. The return value will be the same options object, since the function is essentially a runtime no-op for type inference purposes only.
Note that the return type is a bit special: it will be a constructor type whose instance type is the inferred component instance type based on the options. This is used for type inference when the returned type is used as a tag in TSX.
You can extract the instance type of a component (equivalent to the type of
this
in its options) from the return type ofdefineComponent()
like this:tsconst Foo = defineComponent(/* ... */) type FooInstance = InstanceType<typeof Foo>
Function Signature
defineComponent()
also has an alternative signature that is meant to be used with Composition API and render functions or JSX.Instead of passing in an options object, a function is expected instead. This function works the same as the Composition API
setup()
function: it receives the props and the setup context. The return value should be a render function - bothh()
and JSX are supported:jsimport { ref, h } from 'vue' const Comp = defineComponent( (props) => { // use Composition API here like in <script setup> const count = ref(0) return () => { // render function or JSX return h('div', count.value) } }, // extra options, e.g. declare props and emits { props: { /* ... */ } } )
The main use case for this signature is with TypeScript (and in particular with TSX), as it supports generics:
tsxconst Comp = defineComponent( <T extends string | number>(props: { msg: T; list: T[] }) => { // use Composition API here like in <script setup> const count = ref(0) return () => { // render function or JSX return <div>{count.value}</div> } }, // manual runtime props declaration is currently still needed. { props: ['msg', 'list'] } )
In the future, we plan to provide a Babel plugin that automatically infers and injects the runtime props (like for
defineProps
in SFCs) so that the runtime props declaration can be omitted.Note on webpack Treeshaking
Because
defineComponent()
is a function call, it could look like that it would produce side-effects to some build tools, e.g. webpack. This will prevent the component from being tree-shaken even when the component is never used.To tell webpack that this function call is safe to be tree-shaken, you can add a
/*#__PURE__*/
comment notation before the function call:jsexport default /*#__PURE__*/ defineComponent(/* ... */)
Note this is not necessary if you are using Vite, because Rollup (the underlying production bundler used by Vite) is smart enough to determine that
defineComponent()
is in fact side-effect-free without the need for manual annotations.See also Guide - Using Vue with TypeScript
defineAsyncComponent()
Define an async component which is lazy loaded only when it is rendered. The argument can either be a loader function, or an options object for more advanced control of the loading behavior.
Type
tsfunction defineAsyncComponent( source: AsyncComponentLoader | AsyncComponentOptions ): Component type AsyncComponentLoader = () => Promise<Component> interface AsyncComponentOptions { loader: AsyncComponentLoader loadingComponent?: Component errorComponent?: Component delay?: number timeout?: number suspensible?: boolean onError?: ( error: Error, retry: () => void, fail: () => void, attempts: number ) => any }
See also Guide - Async Components
defineCustomElement()
This method accepts the same argument as defineComponent
, but instead returns a native Custom Element class constructor.
Type
tsfunction defineCustomElement( component: | (ComponentOptions & { styles?: string[] }) | ComponentOptions['setup'] ): { new (props?: object): HTMLElement }
Type is simplified for readability.
Details
In addition to normal component options,
defineCustomElement()
also supports a special optionstyles
, which should be an array of inlined CSS strings, for providing CSS that should be injected into the element's shadow root.The return value is a custom element constructor that can be registered using
customElements.define()
.Example
jsimport { defineCustomElement } from 'vue' const MyVueElement = defineCustomElement({ /* component options */ }) // Register the custom element. customElements.define('my-vue-element', MyVueElement)
See also
Also note that
defineCustomElement()
requires special config when used with Single-File Components.hhuh(hh	h}ubh)}(h}(hNh	}(h#https://vuejs.org/api/utility-typesh
Utility Types | Vue.jsuhX  Utility Types
INFO
This page only lists a few commonly used utility types that may need explanation for their usage. For a full list of exported types, consult the source code.
PropType<T>
Used to annotate a prop with more advanced types when using runtime props declarations.
Example
tsimport type { PropType } from 'vue' interface Book { title: string author: string year: number } export default { props: { book: { // provide more specific type to `Object` type: Object as PropType<Book>, required: true } } }
See also Guide - Typing Component Props
MaybeRef<T>
Alias for T | Ref<T>
. Useful for annotating arguments of Composables.
- Only supported in 3.3+.
MaybeRefOrGetter<T>
Alias for T | Ref<T> | (() => T)
. Useful for annotating arguments of Composables.
- Only supported in 3.3+.
ExtractPropTypes<T>
Extract prop types from a runtime props options object. The extracted types are internal facing - i.e. the resolved props received by the component. This means boolean props and props with default values are always defined, even if they are not required.
To extract public facing props, i.e. props that the parent is allowed to pass, use ExtractPublicPropTypes
.
Example
tsconst propsOptions = { foo: String, bar: Boolean, baz: { type: Number, required: true }, qux: { type: Number, default: 1 } } as const type Props = ExtractPropTypes<typeof propsOptions> // { // foo?: string, // bar: boolean, // baz: number, // qux: number // }
ExtractPublicPropTypes<T>
Extract prop types from a runtime props options object. The extracted types are public facing - i.e. the props that the parent is allowed to pass.
Only supported in 3.3+.
Example
tsconst propsOptions = { foo: String, bar: Boolean, baz: { type: Number, required: true }, qux: { type: Number, default: 1 } } as const type Props = ExtractPublicPropTypes<typeof propsOptions> // { // foo?: string, // bar?: boolean, // baz: number, // qux?: number // }
ComponentCustomProperties
Used to augment the component instance type to support custom global properties.
Example
tsimport axios from 'axios' declare module 'vue' { interface ComponentCustomProperties { $http: typeof axios $translate: (key: string) => string } }
TIP
Augmentations must be placed in a module
.ts
or.d.ts
file. See Type Augmentation Placement for more details.See also Guide - Augmenting Global Properties
ComponentCustomOptions
Used to augment the component options type to support custom options.
Example
tsimport { Route } from 'vue-router' declare module 'vue' { interface ComponentCustomOptions { beforeRouteEnter?(to: any, from: any, next: () => void): void } }
TIP
Augmentations must be placed in a module
.ts
or.d.ts
file. See Type Augmentation Placement for more details.See also Guide - Augmenting Custom Options
ComponentCustomProps
Used to augment allowed TSX props in order to use non-declared props on TSX elements.
Example
tsdeclare module 'vue' { interface ComponentCustomProps { hello?: string } } export {}
tsx// now works even if hello is not a declared prop <MyComponent hello="world" />
TIP
Augmentations must be placed in a module
.ts
or.d.ts
file. See Type Augmentation Placement for more details.
CSSProperties
Used to augment allowed values in style property bindings.
Example
Allow any custom CSS property
tsdeclare module 'vue' { interface CSSProperties { [key: `--${string}`]: string } }
tsx<div style={ { '--bg-color': 'blue' } }>
html<div :style="{ '--bg-color': 'blue' }"></div>
TIP
Augmentations must be placed in a module .ts
or .d.ts
file. See Type Augmentation Placement for more details.
See also
SFC <style>
tags support linking CSS values to dynamic component state using the v-bind
CSS function. This allows for custom properties without type augmentation.     hhuh(hh	h}ubh)}(h}(hNh	}(h+https://vuejs.org/api/composition-api-setuph
!Composition API: setup() | Vue.jsuhX  Composition API: setup()
Basic Usage
The setup()
hook serves as the entry point for Composition API usage in components in the following cases:
- Using Composition API without a build step;
- Integrating with Composition-API-based code in an Options API component.
Note
If you are using Composition API with Single-File Components, <script setup>
is strongly recommended for a more succinct and ergonomic syntax.
We can declare reactive state using Reactivity APIs and expose them to the template by returning an object from setup()
. The properties on the returned object will also be made available on the component instance (if other options are used):
vue
<script>
import { ref } from 'vue'
export default {
setup() {
const count = ref(0)
// expose to template and other options API hooks
return {
count
}
},
mounted() {
console.log(this.count) // 0
}
}
</script>
<template>
<button @click="count++">{{ count }}</button>
</template>
refs returned from setup
are automatically shallow unwrapped when accessed in the template so you do not need to use .value
when accessing them. They are also unwrapped in the same way when accessed on this
.
setup()
itself does not have access to the component instance - this
will have a value of undefined
inside setup()
. You can access Composition-API-exposed values from Options API, but not the other way around.
setup()
should return an object synchronously. The only case when async setup()
can be used is when the component is a descendant of a Suspense component.
Accessing Props
The first argument in the setup
function is the props
argument. Just as you would expect in a standard component, props
inside of a setup
function are reactive and will be updated when new props are passed in.
js
export default {
props: {
title: String
},
setup(props) {
console.log(props.title)
}
}
Note that if you destructure the props
object, the destructured variables will lose reactivity. It is therefore recommended to always access props in the form of props.xxx
.
If you really need to destructure the props, or need to pass a prop into an external function while retaining reactivity, you can do so with the toRefs() and toRef() utility APIs:
js
import { toRefs, toRef } from 'vue'
export default {
setup(props) {
// turn `props` into an object of refs, then destructure
const { title } = toRefs(props)
// `title` is a ref that tracks `props.title`
console.log(title.value)
// OR, turn a single property on `props` into a ref
const title = toRef(props, 'title')
}
}
Setup Context
The second argument passed to the setup
function is a Setup Context object. The context object exposes other values that may be useful inside setup
:
js
export default {
setup(props, context) {
// Attributes (Non-reactive object, equivalent to $attrs)
console.log(context.attrs)
// Slots (Non-reactive object, equivalent to $slots)
console.log(context.slots)
// Emit events (Function, equivalent to $emit)
console.log(context.emit)
// Expose public properties (Function)
console.log(context.expose)
}
}
The context object is not reactive and can be safely destructured:
js
export default {
setup(props, { attrs, slots, emit, expose }) {
...
}
}
attrs
and slots
are stateful objects that are always updated when the component itself is updated. This means you should avoid destructuring them and always reference properties as attrs.x
or slots.x
. Also note that, unlike props
, the properties of attrs
and slots
are not reactive. If you intend to apply side effects based on changes to attrs
or slots
, you should do so inside an onBeforeUpdate
lifecycle hook.
Exposing Public Properties
expose
is a function that can be used to explicitly limit the properties exposed when the component instance is accessed by a parent component via template refs:
js
export default {
setup(props, { expose }) {
// make the instance "closed" -
// i.e. do not expose anything to the parent
expose()
const publicCount = ref(0)
const privateCount = ref(0)
// selectively expose local state
expose({ count: publicCount })
}
}
Usage with Render Functions
setup
can also return a render function which can directly make use of the reactive state declared in the same scope:
js
import { h, ref } from 'vue'
export default {
setup() {
const count = ref(0)
return () => h('div', count.value)
}
}
Returning a render function prevents us from returning anything else. Internally that shouldn't be a problem, but it can be problematic if we want to expose methods of this component to the parent component via template refs.
We can solve this problem by calling expose()
:
js
import { h, ref } from 'vue'
export default {
setup(props, { expose }) {
const count = ref(0)
const increment = () => ++count.value
expose({
increment
})
return () => h('div', count.value)
}
}
The increment
method would then be available in the parent component via a template ref.hhuh(hh	h}ubh)}(h}(hNh	}(h!https://vuejs.org/api/applicationh
Application API | Vue.jsuhX3  Application API
createApp()
Creates an application instance.
Type
tsfunction createApp(rootComponent: Component, rootProps?: object): App
Details
The first argument is the root component. The second optional argument is the props to be passed to the root component.
Example
With inline root component:
jsimport { createApp } from 'vue' const app = createApp({ /* root component options */ })
With imported component:
jsimport { createApp } from 'vue' import App from './App.vue' const app = createApp(App)
See also Guide - Creating a Vue Application
createSSRApp()
Creates an application instance in SSR Hydration mode. Usage is exactly the same as createApp()
.
app.mount()
Mounts the application instance in a container element.
Type
tsinterface App { mount(rootContainer: Element | string): ComponentPublicInstance }
Details
The argument can either be an actual DOM element or a CSS selector (the first matched element will be used). Returns the root component instance.
If the component has a template or a render function defined, it will replace any existing DOM nodes inside the container. Otherwise, if the runtime compiler is available, the
innerHTML
of the container will be used as the template.In SSR hydration mode, it will hydrate the existing DOM nodes inside the container. If there are mismatches, the existing DOM nodes will be morphed to match the expected output.
For each app instance,
mount()
can only be called once.Example
jsimport { createApp } from 'vue' const app = createApp(/* ... */) app.mount('#app')
Can also mount to an actual DOM element:
jsapp.mount(document.body.firstChild)
app.unmount()
Unmounts a mounted application instance, triggering the unmount lifecycle hooks for all components in the application's component tree.
Type
tsinterface App { unmount(): void }
app.component()
Registers a global component if passing both a name string and a component definition, or retrieves an already registered one if only the name is passed.
Type
tsinterface App { component(name: string): Component | undefined component(name: string, component: Component): this }
Example
jsimport { createApp } from 'vue' const app = createApp({}) // register an options object app.component('my-component', { /* ... */ }) // retrieve a registered component const MyComponent = app.component('my-component')
See also Component Registration
app.directive()
Registers a global custom directive if passing both a name string and a directive definition, or retrieves an already registered one if only the name is passed.
Type
tsinterface App { directive(name: string): Directive | undefined directive(name: string, directive: Directive): this }
Example
jsimport { createApp } from 'vue' const app = createApp({ /* ... */ }) // register (object directive) app.directive('my-directive', { /* custom directive hooks */ }) // register (function directive shorthand) app.directive('my-directive', () => { /* ... */ }) // retrieve a registered directive const myDirective = app.directive('my-directive')
See also Custom Directives
app.use()
Installs a plugin.
Type
tsinterface App { use(plugin: Plugin, ...options: any[]): this }
Details
Expects the plugin as the first argument, and optional plugin options as the second argument.
The plugin can either be an object with an
install()
method, or just a function that will be used as theinstall()
method. The options (second argument ofapp.use()
) will be passed along to the plugin'sinstall()
method.When
app.use()
is called on the same plugin multiple times, the plugin will be installed only once.Example
jsimport { createApp } from 'vue' import MyPlugin from './plugins/MyPlugin' const app = createApp({ /* ... */ }) app.use(MyPlugin)
See also Plugins
app.mixin()
Applies a global mixin (scoped to the application). A global mixin applies its included options to every component instance in the application.
Not Recommended
Mixins are supported in Vue 3 mainly for backwards compatibility, due to their widespread use in ecosystem libraries. Use of mixins, especially global mixins, should be avoided in application code.
For logic reuse, prefer Composables instead.
Type
tsinterface App { mixin(mixin: ComponentOptions): this }
app.provide()
Provide a value that can be injected in all descendant components within the application.
Type
tsinterface App { provide<T>(key: InjectionKey<T> | symbol | string, value: T): this }
Details
Expects the injection key as the first argument, and the provided value as the second. Returns the application instance itself.
Example
jsimport { createApp } from 'vue' const app = createApp(/* ... */) app.provide('message', 'hello')
Inside a component in the application:
jsimport { inject } from 'vue' export default { setup() { console.log(inject('message')) // 'hello' } }
See also
app.runWithContext()
Execute a callback with the current app as injection context.
Type
tsinterface App { runWithContext<T>(fn: () => T): T }
Details
Expects a callback function and runs the callback immediately. During the synchronous call of the callback,
inject()
calls are able to look up injections from the values provided by the current app, even when there is no current active component instance. The return value of the callback will also be returned.Example
jsimport { inject } from 'vue' app.provide('id', 1) const injected = app.runWithContext(() => { return inject('id') }) console.log(injected) // 1
app.version
Provides the version of Vue that the application was created with. This is useful inside plugins, where you might need conditional logic based on different Vue versions.
Type
tsinterface App { version: string }
Example
Performing a version check inside a plugin:
jsexport default { install(app) { const version = Number(app.version.split('.')[0]) if (version < 3) { console.warn('This plugin requires Vue 3') } } }
See also Global API - version
app.config
Every application instance exposes a config
object that contains the configuration settings for that application. You can modify its properties (documented below) before mounting your application.
js
import { createApp } from 'vue'
const app = createApp(/* ... */)
console.log(app.config)
app.config.errorHandler
Assign a global handler for uncaught errors propagating from within the application.
Type
tsinterface AppConfig { errorHandler?: ( err: unknown, instance: ComponentPublicInstance | null, // `info` is a Vue-specific error info, // e.g. which lifecycle hook the error was thrown in info: string ) => void }
Details
The error handler receives three arguments: the error, the component instance that triggered the error, and an information string specifying the error source type.
It can capture errors from the following sources:
- Component renders
- Event handlers
- Lifecycle hooks
setup()
function- Watchers
- Custom directive hooks
- Transition hooks
TIP
In production, the 3rd argument (
info
) will be a shortened code instead of the full information string. You can find the code to string mapping in the Production Error Code Reference.Example
jsapp.config.errorHandler = (err, instance, info) => { // handle error, e.g. report to a service }
app.config.warnHandler
Assign a custom handler for runtime warnings from Vue.
Type
tsinterface AppConfig { warnHandler?: ( msg: string, instance: ComponentPublicInstance | null, trace: string ) => void }
Details
The warning handler receives the warning message as the first argument, the source component instance as the second argument, and a component trace string as the third.
It can be used to filter out specific warnings to reduce console verbosity. All Vue warnings should be addressed during development, so this is only recommended during debug sessions to focus on specific warnings among many, and should be removed once the debugging is done.
TIP
Warnings only work during development, so this config is ignored in production mode.
Example
jsapp.config.warnHandler = (msg, instance, trace) => { // `trace` is the component hierarchy trace }
app.config.performance
Set this to true
to enable component init, compile, render and patch performance tracing in the browser devtool performance/timeline panel. Only works in development mode and in browsers that support the performance.mark API.
Type:
boolean
See also Guide - Performance
app.config.compilerOptions
Configure runtime compiler options. Values set on this object will be passed to the in-browser template compiler and affect every component in the configured app. Note you can also override these options on a per-component basis using the compilerOptions
option.
Important
This config option is only respected when using the full build (i.e. the standalone vue.js
that can compile templates in the browser). If you are using the runtime-only build with a build setup, compiler options must be passed to @vue/compiler-dom
via build tool configurations instead.
For
vue-loader
: pass via thecompilerOptions
loader option. Also see how to configure it invue-cli
.For
vite
: pass via@vitejs/plugin-vue
options.
app.config.compilerOptions.isCustomElement
Specifies a check method to recognize native custom elements.
Type:
(tag: string) => boolean
Details
Should return
true
if the tag should be treated as a native custom element. For a matched tag, Vue will render it as a native element instead of attempting to resolve it as a Vue component.Native HTML and SVG tags don't need to be matched in this function - Vue's parser recognizes them automatically.
Example
js// treat all tags starting with 'ion-' as custom elements app.config.compilerOptions.isCustomElement = (tag) => { return tag.startsWith('ion-') }
See also Vue and Web Components
app.config.compilerOptions.whitespace
Adjusts template whitespace handling behavior.
Type:
'condense' | 'preserve'
Default:
'condense'
Details
Vue removes / condenses whitespace characters in templates to produce more efficient compiled output. The default strategy is "condense", with the following behavior:
- Leading / ending whitespace characters inside an element are condensed into a single space.
- Whitespace characters between elements that contain newlines are removed.
- Consecutive whitespace characters in text nodes are condensed into a single space.
Setting this option to
'preserve'
will disable (2) and (3).Example
jsapp.config.compilerOptions.whitespace = 'preserve'
app.config.compilerOptions.delimiters
Adjusts the delimiters used for text interpolation within the template.
Type:
[string, string]
Default:
['{{', '}}']
Details
This is typically used to avoid conflicting with server-side frameworks that also use mustache syntax.
Example
js// Delimiters changed to ES6 template string style app.config.compilerOptions.delimiters = ['${', '}']
app.config.compilerOptions.comments
Adjusts treatment of HTML comments in templates.
Type:
boolean
Default:
false
Details
By default, Vue will remove the comments in production. Setting this option to
true
will force Vue to preserve comments even in production. Comments are always preserved during development. This option is typically used when Vue is used with other libraries that rely on HTML comments.Example
jsapp.config.compilerOptions.comments = true
app.config.globalProperties
An object that can be used to register global properties that can be accessed on any component instance inside the application.
Type
tsinterface AppConfig { globalProperties: Record<string, any> }
Details
This is a replacement of Vue 2's
Vue.prototype
which is no longer present in Vue 3. As with anything global, this should be used sparingly.If a global property conflicts with a component’s own property, the component's own property will have higher priority.
Usage
jsapp.config.globalProperties.msg = 'hello'
This makes
msg
available inside any component template in the application, and also onthis
of any component instance:jsexport default { mounted() { console.log(this.msg) // 'hello' } }
See also Guide - Augmenting Global Properties
app.config.optionMergeStrategies
An object for defining merging strategies for custom component options.
Type
tsinterface AppConfig { optionMergeStrategies: Record<string, OptionMergeFunction> } type OptionMergeFunction = (to: unknown, from: unknown) => any
Details
Some plugins / libraries add support for custom component options (by injecting global mixins). These options may require special merging logic when the same option needs to be "merged" from multiple sources (e.g. mixins or component inheritance).
A merge strategy function can be registered for a custom option by assigning it on the
app.config.optionMergeStrategies
object using the option's name as the key.The merge strategy function receives the value of that option defined on the parent and child instances as the first and second arguments, respectively.
Example
jsconst app = createApp({ // option from self msg: 'Vue', // option from a mixin mixins: [ { msg: 'Hello ' } ], mounted() { // merged options exposed on this.$options console.log(this.$options.msg) } }) // define a custom merge strategy for `msg` app.config.optionMergeStrategies.msg = (parent, child) => { return (parent || '') + (child || '') } app.mount('#app') // logs 'Hello Vue'
See also Component Instance -
$optionshhuh(hh	h}ubh)}(h}(hNh	}(h1https://vuejs.org/api/built-in-special-attributesh
$Built-in Special Attributes | Vue.jsuhXO  Built-in Special Attributes
key
The key
special attribute is primarily used as a hint for Vue's virtual DOM algorithm to identify vnodes when diffing the new list of nodes against the old list.
Expects:
number | string | symbol
Details
Without keys, Vue uses an algorithm that minimizes element movement and tries to patch/reuse elements of the same type in-place as much as possible. With keys, it will reorder elements based on the order change of keys, and elements with keys that are no longer present will always be removed / destroyed.
Children of the same common parent must have unique keys. Duplicate keys will cause render errors.
The most common use case is combined with
v-for
:template<ul> <li v-for="item in items" :key="item.id">...</li> </ul>
It can also be used to force replacement of an element/component instead of reusing it. This can be useful when you want to:
- Properly trigger lifecycle hooks of a component
- Trigger transitions
For example:
template<transition> <span :key="text">{{ text }}</span> </transition>
When
text
changes, the<span>
will always be replaced instead of patched, so a transition will be triggered.See also Guide - List Rendering - Maintaining State with
key
ref
Denotes a template ref.
Expects:
string | Function
Details
ref
is used to register a reference to an element or a child component.In Options API, the reference will be registered under the component's
this.$refs
object:template<!-- stored as this.$refs.p --> <p ref="p">hello</p>
In Composition API, the reference will be stored in a ref with matching name:
vue<script setup> import { ref } from 'vue' const p = ref() </script> <template> <p ref="p">hello</p> </template>
If used on a plain DOM element, the reference will be that element; if used on a child component, the reference will be the child component instance.
Alternatively
ref
can accept a function value which provides full control over where to store the reference:template<ChildComponent :ref="(el) => child = el" />
An important note about the ref registration timing: because the refs themselves are created as a result of the render function, you must wait until the component is mounted before accessing them.
this.$refs
is also non-reactive, therefore you should not attempt to use it in templates for data-binding.See also
is
Used for binding dynamic components.
Expects:
string | Component
Usage on native elements 3.1+
When the
is
attribute is used on a native HTML element, it will be interpreted as a Customized built-in element, which is a native web platform feature.There is, however, a use case where you may need Vue to replace a native element with a Vue component, as explained in in-DOM Template Parsing Caveats. You can prefix the value of the
is
attribute withvue:
so that Vue will render the element as a Vue component instead:template<table> <tr is="vue:my-row-component"></tr> </table>
See alsohhuh(hh	h}ubh)}(h}(hNh	}(h%https://vuejs.org/api/reactivity-coreh
Reactivity API: Core | Vue.jsuhX}+  Reactivity API: Core
See also
To better understand the Reactivity APIs, it is recommended to read the following chapters in the guide:
- Reactivity Fundamentals (with the API preference set to Composition API)
- Reactivity in Depth
ref()
Takes an inner value and returns a reactive and mutable ref object, which has a single property .value
that points to the inner value.
Type
tsfunction ref<T>(value: T): Ref<UnwrapRef<T>> interface Ref<T> { value: T }
Details
The ref object is mutable - i.e. you can assign new values to
.value
. It is also reactive - i.e. any read operations to.value
are tracked, and write operations will trigger associated effects.If an object is assigned as a ref's value, the object is made deeply reactive with reactive(). This also means if the object contains nested refs, they will be deeply unwrapped.
To avoid the deep conversion, use
shallowRef()
instead.Example
jsconst count = ref(0) console.log(count.value) // 0 count.value = 1 console.log(count.value) // 1
See also
computed()
Takes a getter function and returns a readonly reactive ref object for the returned value from the getter. It can also take an object with get
and set
functions to create a writable ref object.
Type
ts// read-only function computed<T>( getter: (oldValue: T | undefined) => T, // see "Computed Debugging" link below debuggerOptions?: DebuggerOptions ): Readonly<Ref<Readonly<T>>> // writable function computed<T>( options: { get: (oldValue: T | undefined) => T set: (value: T) => void }, debuggerOptions?: DebuggerOptions ): Ref<T>
Example
Creating a readonly computed ref:
jsconst count = ref(1) const plusOne = computed(() => count.value + 1) console.log(plusOne.value) // 2 plusOne.value++ // error
Creating a writable computed ref:
jsconst count = ref(1) const plusOne = computed({ get: () => count.value + 1, set: (val) => { count.value = val - 1 } }) plusOne.value = 1 console.log(count.value) // 0
Debugging:
jsconst plusOne = computed(() => count.value + 1, { onTrack(e) { debugger }, onTrigger(e) { debugger } })
See also
reactive()
Returns a reactive proxy of the object.
Type
tsfunction reactive<T extends object>(target: T): UnwrapNestedRefs<T>
Details
The reactive conversion is "deep": it affects all nested properties. A reactive object also deeply unwraps any properties that are refs while maintaining reactivity.
It should also be noted that there is no ref unwrapping performed when the ref is accessed as an element of a reactive array or a native collection type like
Map
.To avoid the deep conversion and only retain reactivity at the root level, use shallowReactive() instead.
The returned object and its nested objects are wrapped with ES Proxy and not equal to the original objects. It is recommended to work exclusively with the reactive proxy and avoid relying on the original object.
Example
Creating a reactive object:
jsconst obj = reactive({ count: 0 }) obj.count++
Ref unwrapping:
tsconst count = ref(1) const obj = reactive({ count }) // ref will be unwrapped console.log(obj.count === count.value) // true // it will update `obj.count` count.value++ console.log(count.value) // 2 console.log(obj.count) // 2 // it will also update `count` ref obj.count++ console.log(obj.count) // 3 console.log(count.value) // 3
Note that refs are not unwrapped when accessed as array or collection elements:
jsconst books = reactive([ref('Vue 3 Guide')]) // need .value here console.log(books[0].value) const map = reactive(new Map([['count', ref(0)]])) // need .value here console.log(map.get('count').value)
When assigning a ref to a
reactive
property, that ref will also be automatically unwrapped:tsconst count = ref(1) const obj = reactive({}) obj.count = count console.log(obj.count) // 1 console.log(obj.count === count.value) // true
See also
readonly()
Takes an object (reactive or plain) or a ref and returns a readonly proxy to the original.
Type
tsfunction readonly<T extends object>( target: T ): DeepReadonly<UnwrapNestedRefs<T>>
Details
A readonly proxy is deep: any nested property accessed will be readonly as well. It also has the same ref-unwrapping behavior as
reactive()
, except the unwrapped values will also be made readonly.To avoid the deep conversion, use shallowReadonly() instead.
Example
jsconst original = reactive({ count: 0 }) const copy = readonly(original) watchEffect(() => { // works for reactivity tracking console.log(copy.count) }) // mutating original will trigger watchers relying on the copy original.count++ // mutating the copy will fail and result in a warning copy.count++ // warning!
watchEffect()
Runs a function immediately while reactively tracking its dependencies and re-runs it whenever the dependencies are changed.
Type
tsfunction watchEffect( effect: (onCleanup: OnCleanup) => void, options?: WatchEffectOptions ): StopHandle type OnCleanup = (cleanupFn: () => void) => void interface WatchEffectOptions { flush?: 'pre' | 'post' | 'sync' // default: 'pre' onTrack?: (event: DebuggerEvent) => void onTrigger?: (event: DebuggerEvent) => void } type StopHandle = () => void
Details
The first argument is the effect function to be run. The effect function receives a function that can be used to register a cleanup callback. The cleanup callback will be called right before the next time the effect is re-run, and can be used to clean up invalidated side effects, e.g. a pending async request (see example below).
The second argument is an optional options object that can be used to adjust the effect's flush timing or to debug the effect's dependencies.
By default, watchers will run just prior to component rendering. Setting
flush: 'post'
will defer the watcher until after component rendering. See Callback Flush Timing for more information. In rare cases, it might be necessary to trigger a watcher immediately when a reactive dependency changes, e.g. to invalidate a cache. This can be achieved usingflush: 'sync'
. However, this setting should be used with caution, as it can lead to problems with performance and data consistency if multiple properties are being updated at the same time.The return value is a handle function that can be called to stop the effect from running again.
Example
jsconst count = ref(0) watchEffect(() => console.log(count.value)) // -> logs 0 count.value++ // -> logs 1
Side effect cleanup:
jswatchEffect(async (onCleanup) => { const { response, cancel } = doAsyncWork(id.value) // `cancel` will be called if `id` changes // so that previous pending request will be cancelled // if not yet completed onCleanup(cancel) data.value = await response })
Stopping the watcher:
jsconst stop = watchEffect(() => {}) // when the watcher is no longer needed: stop()
Options:
jswatchEffect(() => {}, { flush: 'post', onTrack(e) { debugger }, onTrigger(e) { debugger } })
See also
watchPostEffect()
Alias of watchEffect()
with flush: 'post'
option.
watchSyncEffect()
Alias of watchEffect()
with flush: 'sync'
option.
watch()
Watches one or more reactive data sources and invokes a callback function when the sources change.
Type
ts// watching single source function watch<T>( source: WatchSource<T>, callback: WatchCallback<T>, options?: WatchOptions ): StopHandle // watching multiple sources function watch<T>( sources: WatchSource<T>[], callback: WatchCallback<T[]>, options?: WatchOptions ): StopHandle type WatchCallback<T> = ( value: T, oldValue: T, onCleanup: (cleanupFn: () => void) => void ) => void type WatchSource<T> = | Ref<T> // ref | (() => T) // getter | T extends object ? T : never // reactive object interface WatchOptions extends WatchEffectOptions { immediate?: boolean // default: false deep?: boolean // default: false flush?: 'pre' | 'post' | 'sync' // default: 'pre' onTrack?: (event: DebuggerEvent) => void onTrigger?: (event: DebuggerEvent) => void once?: boolean // default: false (3.4+) }
Types are simplified for readability.
Details
watch()
is lazy by default - i.e. the callback is only called when the watched source has changed.The first argument is the watcher's source. The source can be one of the following:
- A getter function that returns a value
- A ref
- A reactive object
- ...or an array of the above.
The second argument is the callback that will be called when the source changes. The callback receives three arguments: the new value, the old value, and a function for registering a side effect cleanup callback. The cleanup callback will be called right before the next time the effect is re-run, and can be used to clean up invalidated side effects, e.g. a pending async request.
When watching multiple sources, the callback receives two arrays containing new / old values corresponding to the source array.
The third optional argument is an options object that supports the following options:
immediate
: trigger the callback immediately on watcher creation. Old value will beundefined
on the first call.deep
: force deep traversal of the source if it is an object, so that the callback fires on deep mutations. See Deep Watchers.flush
: adjust the callback's flush timing. See Callback Flush Timing andwatchEffect()
.onTrack / onTrigger
: debug the watcher's dependencies. See Watcher Debugging.once
: run the callback only once. The watcher is automatically stopped after the first callback run.
Compared to
watchEffect()
,watch()
allows us to:- Perform the side effect lazily;
- Be more specific about what state should trigger the watcher to re-run;
- Access both the previous and current value of the watched state.
Example
Watching a getter:
jsconst state = reactive({ count: 0 }) watch( () => state.count, (count, prevCount) => { /* ... */ } )
Watching a ref:
jsconst count = ref(0) watch(count, (count, prevCount) => { /* ... */ })
When watching multiple sources, the callback receives arrays containing new / old values corresponding to the source array:
jswatch([fooRef, barRef], ([foo, bar], [prevFoo, prevBar]) => { /* ... */ })
When using a getter source, the watcher only fires if the getter's return value has changed. If you want the callback to fire even on deep mutations, you need to explicitly force the watcher into deep mode with
{ deep: true }
. Note in deep mode, the new value and the old will be the same object if the callback was triggered by a deep mutation:jsconst state = reactive({ count: 0 }) watch( () => state, (newValue, oldValue) => { // newValue === oldValue }, { deep: true } )
When directly watching a reactive object, the watcher is automatically in deep mode:
jsconst state = reactive({ count: 0 }) watch(state, () => { /* triggers on deep mutation to state */ })
watch()
shares the same flush timing and debugging options withwatchEffect()
:jswatch(source, callback, { flush: 'post', onTrack(e) { debugger }, onTrigger(e) { debugger } })
Stopping the watcher:
jsconst stop = watch(source, callback) // when the watcher is no longer needed: stop()
Side effect cleanup:
jswatch(id, async (newId, oldId, onCleanup) => { const { response, cancel } = doAsyncWork(newId) // `cancel` will be called if `id` changes, cancelling // the previous request if it hasn't completed yet onCleanup(cancel) data.value = await response })
See alsohhuh(hh	h}ubh)}(h}(hNh	}(h)https://vuejs.org/api/options-compositionh
Options: Composition | Vue.jsuhX  Options: Composition
provide
Provide values that can be injected by descendant components.
Type
tsinterface ComponentOptions { provide?: object | ((this: ComponentPublicInstance) => object) }
Details
provide
andinject
are used together to allow an ancestor component to serve as a dependency injector for all its descendants, regardless of how deep the component hierarchy is, as long as they are in the same parent chain.The
provide
option should be either an object or a function that returns an object. This object contains the properties that are available for injection into its descendants. You can use Symbols as keys in this object.Example
Basic usage:
jsconst s = Symbol() export default { provide: { foo: 'foo', [s]: 'bar' } }
Using a function to provide per-component state:
jsexport default { data() { return { msg: 'foo' } } provide() { return { msg: this.msg } } }
Note in the above example, the provided
msg
will NOT be reactive. See Working with Reactivity for more details.See also Provide / Inject
inject
Declare properties to inject into the current component by locating them from ancestor providers.
Type
tsinterface ComponentOptions { inject?: ArrayInjectOptions | ObjectInjectOptions } type ArrayInjectOptions = string[] type ObjectInjectOptions = { [key: string | symbol]: | string | symbol | { from?: string | symbol; default?: any } }
Details
The
inject
option should be either:- An array of strings, or
- An object where the keys are the local binding name and the value is either:
- The key (string or Symbol) to search for in available injections, or
- An object where:
- The
from
property is the key (string or Symbol) to search for in available injections, and - The
default
property is used as fallback value. Similar to props default values, a factory function is needed for object types to avoid value sharing between multiple component instances.
- The
An injected property will be
undefined
if neither a matching property nor a default value was provided.Note that injected bindings are NOT reactive. This is intentional. However, if the injected value is a reactive object, properties on that object do remain reactive. See Working with Reactivity for more details.
Example
Basic usage:
jsexport default { inject: ['foo'], created() { console.log(this.foo) } }
Using an injected value as the default for a prop:
jsconst Child = { inject: ['foo'], props: { bar: { default() { return this.foo } } } }
Using an injected value as data entry:
jsconst Child = { inject: ['foo'], data() { return { bar: this.foo } } }
Injections can be optional with default value:
jsconst Child = { inject: { foo: { default: 'foo' } } }
If it needs to be injected from a property with a different name, use
from
to denote the source property:jsconst Child = { inject: { foo: { from: 'bar', default: 'foo' } } }
Similar to prop defaults, you need to use a factory function for non-primitive values:
jsconst Child = { inject: { foo: { from: 'bar', default: () => [1, 2, 3] } } }
See also Provide / Inject
mixins
An array of option objects to be mixed into the current component.
Type
tsinterface ComponentOptions { mixins?: ComponentOptions[] }
Details
The
mixins
option accepts an array of mixin objects. These mixin objects can contain instance options like normal instance objects, and they will be merged against the eventual options using the certain option merging logic. For example, if your mixin contains acreated
hook and the component itself also has one, both functions will be called.Mixin hooks are called in the order they are provided, and called before the component's own hooks.
No Longer Recommended
In Vue 2, mixins were the primary mechanism for creating reusable chunks of component logic. While mixins continue to be supported in Vue 3, Composable functions using Composition API is now the preferred approach for code reuse between components.
Example
jsconst mixin = { created() { console.log(1) } } createApp({ created() { console.log(2) }, mixins: [mixin] }) // => 1 // => 2
extends
A "base class" component to extend from.
Type
tsinterface ComponentOptions { extends?: ComponentOptions }
Details
Allows one component to extend another, inheriting its component options.
From an implementation perspective,
extends
is almost identical tomixins
. The component specified byextends
will be treated as though it were the first mixin.However,
extends
andmixins
express different intents. Themixins
option is primarily used to compose chunks of functionality, whereasextends
is primarily concerned with inheritance.As with
mixins
, any options (except forsetup()
) will be merged using the relevant merge strategy.Example
jsconst CompA = { ... } const CompB = { extends: CompA, ... }
Not Recommended for Composition API
extends
is designed for Options API and does not handle the merging of thesetup()
hook.In Composition API, the preferred mental model for logic reuse is "compose" over "inheritance". If you have logic from a component that needs to be reused in another one, consider extracting the relevant logic into a Composable.
If you still intend to "extend" a component using Composition API, you can call the base component's
setup()
in the extending component'ssetup()
:jsimport Base from './Base.js' export default { extends: Base, setup(props, ctx) { return { ...Base.setup(props, ctx), // local bindings } } }hhuh(hh	h}ubh)}(h}(hNh	}(h"https://vuejs.org/error-reference/h
(Production Error Code Reference | Vue.jsuhX  Production Error Code Reference
Runtime Errors
In production builds, the 3rd argument passed to the following error handler APIs will be a short code instead of the full information string:
app.config.errorHandler
onErrorCaptured
(Composition API)errorCaptured
(Options API)
The following table maps the codes to their original full information strings.
Code | Message |
---|---|
0 | setup function |
1 | render function |
2 | watcher getter |
3 | watcher callback |
4 | watcher cleanup function |
5 | native event handler |
6 | component event handler |
7 | vnode hook |
8 | directive hook |
9 | transition hook |
10 | app errorHandler |
11 | app warnHandler |
12 | ref function |
13 | async component loader |
14 | scheduler flush |
15 | component update |
sp | serverPrefetch hook |
bc | beforeCreate hook |
c | created hook |
bm | beforeMount hook |
m | mounted hook |
bu | beforeUpdate hook |
u | updated |
bum | beforeUnmount hook |
um | unmounted hook |
a | activated hook |
da | deactivated hook |
ec | errorCaptured hook |
rtc | renderTracked hook |
rtg | renderTriggered hook |
Compiler Errors
The following table provides a mapping of the production compiler error codes to their original messages.
Code | Message |
---|---|
0 | Illegal comment. |
1 | CDATA section is allowed only in XML context. |
2 | Duplicate attribute. |
3 | End tag cannot have attributes. |
4 | Illegal '/' in tags. |
5 | Unexpected EOF in tag. |
6 | Unexpected EOF in CDATA section. |
7 | Unexpected EOF in comment. |
8 | Unexpected EOF in script. |
9 | Unexpected EOF in tag. |
10 | Incorrectly closed comment. |
11 | Incorrectly opened comment. |
12 | Illegal tag name. Use '<' to print '<'. |
13 | Attribute value was expected. |
14 | End tag name was expected. |
15 | Whitespace was expected. |
16 | Unexpected '<!--' in comment. |
17 | Attribute name cannot contain U+0022 ("), U+0027 ('), and U+003C (<). |
18 | Unquoted attribute value cannot contain U+0022 ("), U+0027 ('), U+003C (<), U+003D (=), and U+0060 (`). |
19 | Attribute name cannot start with '='. |
20 | Unexpected null character. |
21 | '<?' is allowed only in XML context. |
22 | Illegal '/' in tags. |
23 | Invalid end tag. |
24 | Element is missing end tag. |
25 | Interpolation end sign was not found. |
26 | Legal directive name was expected. |
27 | End bracket for dynamic directive argument was not found. Note that dynamic directive argument cannot contain spaces. |
28 | v-if/v-else-if is missing expression. |
29 | v-if/else branches must use unique keys. |
30 | v-else/v-else-if has no adjacent v-if or v-else-if. |
31 | v-for is missing expression. |
32 | v-for has invalid expression. |
33 | <template v-for> key should be placed on the <template> tag. |
34 | v-bind is missing expression. |
35 | v-on is missing expression. |
36 | Unexpected custom directive on <slot> outlet. |
37 | Mixed v-slot usage on both the component and nested <template>. When there are multiple named slots, all slots should use <template> syntax to avoid scope ambiguity. |
38 | Duplicate slot names found. |
39 | Extraneous children found when component already has explicitly named default slot. These children will be ignored. |
40 | v-slot can only be used on components or <template> tags. |
41 | v-model is missing expression. |
42 | v-model value must be a valid JavaScript member expression. |
43 | v-model cannot be used on v-for or v-slot scope variables because they are not writable. |
44 | v-model cannot be used on a prop, because local prop bindings are not writable. Use a v-bind binding combined with a v-on listener that emits update:x event instead. |
45 | Error parsing JavaScript expression: |
46 | <KeepAlive> expects exactly one child component. |
47 | "prefixIdentifiers" option is not supported in this build of compiler. |
48 | ES module mode is not supported in this build of compiler. |
49 | "cacheHandlers" option is only supported when the "prefixIdentifiers" option is enabled. |
50 | "scopeId" option is only supported in module mode. |
51 | @vnode-* hooks in templates are no longer supported. Use the vue: prefix instead. For example, @vnode-mounted should be changed to @vue:mounted. @vnode-* hooks support has been removed in 3.4. |
52 | v-bind with same-name shorthand only allows static argument. |
53 | v-html is missing expression. |
54 | v-html will override element children. |
55 | v-text is missing expression. |
56 | v-text will override element children. |
57 | v-model can only be used on <input>, <textarea> and <select> elements. |
58 | v-model argument is not supported on plain elements. |
59 | v-model cannot be used on file inputs since they are read-only. Use a v-on:change listener instead. |
60 | Unnecessary value binding used alongside v-model. It will interfere with v-model's behavior. |
61 | v-show is missing expression. |
62 | <Transition> expects exactly one child element or component. |
63 | Tags with side effect (<script> and <style>) are ignored in client component templates. |hhuh(hh	h}ubh)}(h}(hNh	}(hhttps://vuejs.org/examples/h
Examples | Vue.jsuhX  Skip to content
Vue.js
Search
Main Navigation
Docs
Guide
Tutorial
Examples
Quick Start
Glossary
Error Reference
Vue 2 Docs
Migration from Vue 2
API
Playground
Ecosystem
Resources
Partners
Themes
UI Components
Certification
Jobs
T-Shirt Shop
Official Libraries
Vue Router
Pinia
Tooling Guide
Video Courses
Vue Mastery
Vue School
Help
Discord Chat
GitHub Discussions
DEV Community
News
Blog
Twitter
Events
Newsletters
About
FAQ
Team
Releases
Community Guide
Code of Conduct
Privacy Policy
The Documentary
Sponsor
Partners
简体中文
日本語
Українська
Français
한국어
Português
বাংলা
Italiano
فارسی
Русский
Čeština
繁體中文
Help Us Translate!
github
twitter
discord
Appearance
github
twitter
discord
Menu
Examples has loadedhhuh(hh	h}ubh)}(h}(hNh	}(h(https://vuejs.org/api/compile-time-flagsh
Compile-Time Flags | Vue.jsuhX[
  Compile-Time Flags
TIP
Compile-time flags only apply when using the esm-bundler
build of Vue (i.e. vue/dist/vue.esm-bundler.js
).
When using Vue with a build step, it is possible to configure a number of compile-time flags to enable / disable certain features. The benefit of using compile-time flags is that features disabled this way can be removed from the final bundle via tree-shaking.
Vue will work even if these flags are not explicitly configured. However, it is recommended to always configure them so that the relevant features can be properly removed when possible.
See Configuration Guides on how to configure them depending on your build tool.
__VUE_OPTIONS_API__
Default:
true
Enable / disable Options API support. Disabling this will result in smaller bundles, but may affect compatibility with 3rd party libraries if they rely on Options API.
__VUE_PROD_DEVTOOLS__
Default:
false
Enable / disable devtools support in production builds. This will result in more code included in the bundle, so it is recommended to only enable this for debugging purposes.
__VUE_PROD_HYDRATION_MISMATCH_DETAILS__
Default:
false
Enable/disable detailed warnings for hydration mismatches in production builds. This will result in more code included in the bundle, so it is recommended to only enable this for debugging purposes.
Configuration Guides
Vite
@vitejs/plugin-vue
automatically provides default values for these flags. To change the default values, use Vite's define
config option:
js
// vite.config.js
import { defineConfig } from 'vite'
export default defineConfig({
define: {
// enable hydration mismatch details in production build
__VUE_PROD_HYDRATION_MISMATCH_DETAILS__: 'true'
}
})
vue-cli
@vue/cli-service
automatically provides default values for some of these flags. To configure /change the values:
js
// vue.config.js
module.exports = {
chainWebpack: (config) => {
config.plugin('define').tap((definitions) => {
Object.assign(definitions[0], {
__VUE_OPTIONS_API__: 'true',
__VUE_PROD_DEVTOOLS__: 'false',
__VUE_PROD_HYDRATION_MISMATCH_DETAILS__: 'false'
})
return definitions
})
}
}
webpack
Flags should be defined using webpack's DefinePlugin:
js
// webpack.config.js
module.exports = {
// ...
plugins: [
new webpack.DefinePlugin({
__VUE_OPTIONS_API__: 'true',
__VUE_PROD_DEVTOOLS__: 'false',
__VUE_PROD_HYDRATION_MISMATCH_DETAILS__: 'false'
})
]
}
Rollup
Flags should be defined using @rollup/plugin-replace:
js
// rollup.config.js
import replace from '@rollup/plugin-replace'
export default {
plugins: [
replace({
__VUE_OPTIONS_API__: 'true',
__VUE_PROD_DEVTOOLS__: 'false',
__VUE_PROD_HYDRATION_MISMATCH_DETAILS__: 'false'
})
]
}hhuh(hh	h}ubh)}(h}(hNh	}(h%https://vuejs.org/api/render-functionh
Render Function APIs | Vue.jsuhX#  Render Function APIs
h()
Creates virtual DOM nodes (vnodes).
Type
ts// full signature function h( type: string | Component, props?: object | null, children?: Children | Slot | Slots ): VNode // omitting props function h(type: string | Component, children?: Children | Slot): VNode type Children = string | number | boolean | VNode | null | Children[] type Slot = () => Children type Slots = { [name: string]: Slot }
Types are simplified for readability.
Details
The first argument can either be a string (for native elements) or a Vue component definition. The second argument is the props to be passed, and the third argument is the children.
When creating a component vnode, the children must be passed as slot functions. A single slot function can be passed if the component expects only the default slot. Otherwise, the slots must be passed as an object of slot functions.
For convenience, the props argument can be omitted when the children is not a slots object.
Example
Creating native elements:
jsimport { h } from 'vue' // all arguments except the type are optional h('div') h('div', { id: 'foo' }) // both attributes and properties can be used in props // Vue automatically picks the right way to assign it h('div', { class: 'bar', innerHTML: 'hello' }) // class and style have the same object / array // value support like in templates h('div', { class: [foo, { bar }], style: { color: 'red' } }) // event listeners should be passed as onXxx h('div', { onClick: () => {} }) // children can be a string h('div', { id: 'foo' }, 'hello') // props can be omitted when there are no props h('div', 'hello') h('div', [h('span', 'hello')]) // children array can contain mixed vnodes and strings h('div', ['hello', h('span', 'hello')])
Creating components:
jsimport Foo from './Foo.vue' // passing props h(Foo, { // equivalent of some-prop="hello" someProp: 'hello', // equivalent of @update="() => {}" onUpdate: () => {} }) // passing single default slot h(Foo, () => 'default slot') // passing named slots // notice the `null` is required to avoid // slots object being treated as props h(MyComponent, null, { default: () => 'default slot', foo: () => h('div', 'foo'), bar: () => [h('span', 'one'), h('span', 'two')] })
mergeProps()
Merge multiple props objects with special handling for certain props.
Type
tsfunction mergeProps(...args: object[]): object
Details
mergeProps()
supports merging multiple props objects with special handling for the following props:class
style
onXxx
event listeners - multiple listeners with the same name will be merged into an array.
If you do not need the merge behavior and want simple overwrites, native object spread can be used instead.
Example
jsimport { mergeProps } from 'vue' const one = { class: 'foo', onClick: handlerA } const two = { class: { bar: true }, onClick: handlerB } const merged = mergeProps(one, two) /** { class: 'foo bar', onClick: [handlerA, handlerB] } */
cloneVNode()
Clones a vnode.
Type
tsfunction cloneVNode(vnode: VNode, extraProps?: object): VNode
Details
Returns a cloned vnode, optionally with extra props to merge with the original.
Vnodes should be considered immutable once created, and you should not mutate the props of an existing vnode. Instead, clone it with different / extra props.
Vnodes have special internal properties, so cloning them is not as simple as an object spread.
cloneVNode()
handles most of the internal logic.Example
jsimport { h, cloneVNode } from 'vue' const original = h('div') const cloned = cloneVNode(original, { id: 'foo' })
isVNode()
Checks if a value is a vnode.
Type
tsfunction isVNode(value: unknown): boolean
resolveComponent()
For manually resolving a registered component by name.
Type
tsfunction resolveComponent(name: string): Component | string
Details
Note: you do not need this if you can import the component directly.
resolveComponent()
must be called inside eithersetup()
or the render function in order to resolve from the correct component context.If the component is not found, a runtime warning will be emitted, and the name string is returned.
Example
jsimport { h, resolveComponent } from 'vue' export default { setup() { const ButtonCounter = resolveComponent('ButtonCounter') return () => { return h(ButtonCounter) } } }
resolveDirective()
For manually resolving a registered directive by name.
Type
tsfunction resolveDirective(name: string): Directive | undefined
Details
Note: you do not need this if you can import the directive directly.
resolveDirective()
must be called inside eithersetup()
or the render function in order to resolve from the correct component context.If the directive is not found, a runtime warning will be emitted, and the function returns
undefined
.
withDirectives()
For adding custom directives to vnodes.
Type
tsfunction withDirectives( vnode: VNode, directives: DirectiveArguments ): VNode // [Directive, value, argument, modifiers] type DirectiveArguments = Array< | [Directive] | [Directive, any] | [Directive, any, string] | [Directive, any, string, DirectiveModifiers] >
Details
Wraps an existing vnode with custom directives. The second argument is an array of custom directives. Each custom directive is also represented as an array in the form of
[Directive, value, argument, modifiers]
. Tailing elements of the array can be omitted if not needed.Example
jsimport { h, withDirectives } from 'vue' // a custom directive const pin = { mounted() { /* ... */ }, updated() { /* ... */ } } // <div v-pin:top.animate="200"></div> const vnode = withDirectives(h('div'), [ [pin, 200, 'top', { animate: true }] ])
withModifiers()
For adding built-in v-on
modifiers to an event handler function.
Type
tsfunction withModifiers(fn: Function, modifiers: ModifierGuardsKeys[]): Function
Example
jsimport { h, withModifiers } from 'vue' const vnode = h('button', { // equivalent of v-on:click.stop.prevent onClick: withModifiers(() => { // ... }, ['stop', 'prevent']) })hhuh(hh	h}ubh)}(h}(hNh	}(h)https://vuejs.org/api/built-in-directivesh
Built-in Directives | Vue.jsuhX8  Built-in Directives
v-text
Update the element's text content.
Expects:
string
Details
v-text
works by setting the element's textContent property, so it will overwrite any existing content inside the element. If you need to update the part oftextContent
, you should use mustache interpolations instead.Example
template<span v-text="msg"></span> <!-- same as --> <span>{{msg}}</span>
See also Template Syntax - Text Interpolation
v-html
Update the element's innerHTML.
Expects:
string
Details
Contents of
v-html
are inserted as plain HTML - Vue template syntax will not be processed. If you find yourself trying to compose templates usingv-html
, try to rethink the solution by using components instead.Security Note
Dynamically rendering arbitrary HTML on your website can be very dangerous because it can easily lead to XSS attacks. Only use
v-html
on trusted content and never on user-provided content.In Single-File Components,
scoped
styles will not apply to content insidev-html
, because that HTML is not processed by Vue's template compiler. If you want to targetv-html
content with scoped CSS, you can instead use CSS modules or an additional, global<style>
element with a manual scoping strategy such as BEM.Example
template<div v-html="html"></div>
See also Template Syntax - Raw HTML
v-show
Toggle the element's visibility based on the truthy-ness of the expression value.
Expects:
any
Details
v-show
works by setting thedisplay
CSS property via inline styles, and will try to respect the initialdisplay
value when the element is visible. It also triggers transitions when its condition changes.See also Conditional Rendering - v-show
v-if
Conditionally render an element or a template fragment based on the truthy-ness of the expression value.
Expects:
any
Details
When a
v-if
element is toggled, the element and its contained directives / components are destroyed and re-constructed. If the initial condition is falsy, then the inner content won't be rendered at all.Can be used on
<template>
to denote a conditional block containing only text or multiple elements.This directive triggers transitions when its condition changes.
When used together,
v-if
has a higher priority thanv-for
. We don't recommend using these two directives together on one element — see the list rendering guide for details.See also Conditional Rendering - v-if
v-else
Denote the "else block" for v-if
or a v-if
/ v-else-if
chain.
Does not expect expression
Details
Restriction: previous sibling element must have
v-if
orv-else-if
.Can be used on
<template>
to denote a conditional block containing only text or multiple elements.
Example
template<div v-if="Math.random() > 0.5"> Now you see me </div> <div v-else> Now you don't </div>
See also Conditional Rendering - v-else
v-else-if
Denote the "else if block" for v-if
. Can be chained.
Expects:
any
Details
Restriction: previous sibling element must have
v-if
orv-else-if
.Can be used on
<template>
to denote a conditional block containing only text or multiple elements.
Example
template<div v-if="type === 'A'"> A </div> <div v-else-if="type === 'B'"> B </div> <div v-else-if="type === 'C'"> C </div> <div v-else> Not A/B/C </div>
See also Conditional Rendering - v-else-if
v-for
Render the element or template block multiple times based on the source data.
Expects:
Array | Object | number | string | Iterable
Details
The directive's value must use the special syntax
alias in expression
to provide an alias for the current element being iterated on:template<div v-for="item in items"> {{ item.text }} </div>
Alternatively, you can also specify an alias for the index (or the key if used on an Object):
template<div v-for="(item, index) in items"></div> <div v-for="(value, key) in object"></div> <div v-for="(value, name, index) in object"></div>
The default behavior of
v-for
will try to patch the elements in-place without moving them. To force it to reorder elements, you should provide an ordering hint with thekey
special attribute:template<div v-for="item in items" :key="item.id"> {{ item.text }} </div>
v-for
can also work on values that implement the Iterable Protocol, including nativeMap
andSet
.See also
v-on
Attach an event listener to the element.
Shorthand:
@
Expects:
Function | Inline Statement | Object (without argument)
Argument:
event
(optional if using Object syntax)Modifiers
.stop
- callevent.stopPropagation()
..prevent
- callevent.preventDefault()
..capture
- add event listener in capture mode..self
- only trigger handler if event was dispatched from this element..{keyAlias}
- only trigger handler on certain keys..once
- trigger handler at most once..left
- only trigger handler for left button mouse events..right
- only trigger handler for right button mouse events..middle
- only trigger handler for middle button mouse events..passive
- attaches a DOM event with{ passive: true }
.
Details
The event type is denoted by the argument. The expression can be a method name, an inline statement, or omitted if there are modifiers present.
When used on a normal element, it listens to native DOM events only. When used on a custom element component, it listens to custom events emitted on that child component.
When listening to native DOM events, the method receives the native event as the only argument. If using inline statement, the statement has access to the special
$event
property:v-on:click="handle('ok', $event)"
.v-on
also supports binding to an object of event / listener pairs without an argument. Note when using the object syntax, it does not support any modifiers.Example
template<!-- method handler --> <button v-on:click="doThis"></button> <!-- dynamic event --> <button v-on:[event]="doThis"></button> <!-- inline statement --> <button v-on:click="doThat('hello', $event)"></button> <!-- shorthand --> <button @click="doThis"></button> <!-- shorthand dynamic event --> <button @[event]="doThis"></button> <!-- stop propagation --> <button @click.stop="doThis"></button> <!-- prevent default --> <button @click.prevent="doThis"></button> <!-- prevent default without expression --> <form @submit.prevent></form> <!-- chain modifiers --> <button @click.stop.prevent="doThis"></button> <!-- key modifier using keyAlias --> <input @keyup.enter="onEnter" /> <!-- the click event will be triggered at most once --> <button v-on:click.once="doThis"></button> <!-- object syntax --> <button v-on="{ mousedown: doThis, mouseup: doThat }"></button>
Listening to custom events on a child component (the handler is called when "my-event" is emitted on the child):
template<MyComponent @my-event="handleThis" /> <!-- inline statement --> <MyComponent @my-event="handleThis(123, $event)" />
See also
v-bind
Dynamically bind one or more attributes, or a component prop to an expression.
Shorthand:
:
or.
(when using.prop
modifier)- Omitting value (when attribute and bound value has the same name) 3.4+
Expects:
any (with argument) | Object (without argument)
Argument:
attrOrProp (optional)
Modifiers
.camel
- transform the kebab-case attribute name into camelCase..prop
- force a binding to be set as a DOM property. 3.2+.attr
- force a binding to be set as a DOM attribute. 3.2+
Usage
When used to bind the
class
orstyle
attribute,v-bind
supports additional value types such as Array or Objects. See linked guide section below for more details.When setting a binding on an element, Vue by default checks whether the element has the key defined as a property using an
in
operator check. If the property is defined, Vue will set the value as a DOM property instead of an attribute. This should work in most cases, but you can override this behavior by explicitly using.prop
or.attr
modifiers. This is sometimes necessary, especially when working with custom elements.When used for component prop binding, the prop must be properly declared in the child component.
When used without an argument, can be used to bind an object containing attribute name-value pairs.
Example
template<!-- bind an attribute --> <img v-bind:src="imageSrc" /> <!-- dynamic attribute name --> <button v-bind:[key]="value"></button> <!-- shorthand --> <img :src="imageSrc" /> <!-- same-name shorthand (3.4+), expands to :src="src" --> <img :src /> <!-- shorthand dynamic attribute name --> <button :[key]="value"></button> <!-- with inline string concatenation --> <img :src="'/path/to/images/' + fileName" /> <!-- class binding --> <div :class="{ red: isRed }"></div> <div :class="[classA, classB]"></div> <div :class="[classA, { classB: isB, classC: isC }]"></div> <!-- style binding --> <div :style="{ fontSize: size + 'px' }"></div> <div :style="[styleObjectA, styleObjectB]"></div> <!-- binding an object of attributes --> <div v-bind="{ id: someProp, 'other-attr': otherProp }"></div> <!-- prop binding. "prop" must be declared in the child component. --> <MyComponent :prop="someThing" /> <!-- pass down parent props in common with a child component --> <MyComponent v-bind="$props" /> <!-- XLink --> <svg><a :xlink:special="foo"></a></svg>
The
.prop
modifier also has a dedicated shorthand,.
:template<div :someProperty.prop="someObject"></div> <!-- equivalent to --> <div .someProperty="someObject"></div>
The
.camel
modifier allows camelizing av-bind
attribute name when using in-DOM templates, e.g. the SVGviewBox
attribute:template<svg :view-box.camel="viewBox"></svg>
.camel
is not needed if you are using string templates, or pre-compiling the template with a build step.See also
v-model
Create a two-way binding on a form input element or a component.
Expects: varies based on value of form inputs element or output of components
Limited to:
<input>
<select>
<textarea>
- components
Modifiers
See also
v-slot
Denote named slots or scoped slots that expect to receive props.
Shorthand:
#
Expects: JavaScript expression that is valid in a function argument position, including support for destructuring. Optional - only needed if expecting props to be passed to the slot.
Argument: slot name (optional, defaults to
default
)Limited to:
<template>
- components (for a lone default slot with props)
Example
template<!-- Named slots --> <BaseLayout> <template v-slot:header> Header content </template> <template v-slot:default> Default slot content </template> <template v-slot:footer> Footer content </template> </BaseLayout> <!-- Named slot that receives props --> <InfiniteScroll> <template v-slot:item="slotProps"> <div class="item"> {{ slotProps.item.text }} </div> </template> </InfiniteScroll> <!-- Default slot that receive props, with destructuring --> <Mouse v-slot="{ x, y }"> Mouse position: {{ x }}, {{ y }} </Mouse>
See also
v-pre
Skip compilation for this element and all its children.
Does not expect expression
Details
Inside the element with
v-pre
, all Vue template syntax will be preserved and rendered as-is. The most common use case of this is displaying raw mustache tags.Example
template<span v-pre>{{ this will not be compiled }}</span>
v-once
Render the element and component once only, and skip future updates.
Does not expect expression
Details
On subsequent re-renders, the element/component and all its children will be treated as static content and skipped. This can be used to optimize update performance.
template<!-- single element --> <span v-once>This will never change: {{msg}}</span> <!-- the element have children --> <div v-once> <h1>Comment</h1> <p>{{msg}}</p> </div> <!-- component --> <MyComponent v-once :comment="msg"></MyComponent> <!-- `v-for` directive --> <ul> <li v-for="i in list" v-once>{{i}}</li> </ul>
Since 3.2, you can also memoize part of the template with invalidation conditions using
v-memo
.See also
v-memo
Expects:
any[]
Details
Memoize a sub-tree of the template. Can be used on both elements and components. The directive expects a fixed-length array of dependency values to compare for the memoization. If every value in the array was the same as last render, then updates for the entire sub-tree will be skipped. For example:
template<div v-memo="[valueA, valueB]"> ... </div>
When the component re-renders, if both
valueA
andvalueB
remain the same, all updates for this<div>
and its children will be skipped. In fact, even the Virtual DOM VNode creation will also be skipped since the memoized copy of the sub-tree can be reused.It is important to specify the memoization array correctly, otherwise we may skip updates that should indeed be applied.
v-memo
with an empty dependency array (v-memo="[]"
) would be functionally equivalent tov-once
.Usage with
v-for
v-memo
is provided solely for micro optimizations in performance-critical scenarios and should be rarely needed. The most common case where this may prove helpful is when rendering largev-for
lists (wherelength > 1000
):template<div v-for="item in list" :key="item.id" v-memo="[item.id === selected]"> <p>ID: {{ item.id }} - selected: {{ item.id === selected }}</p> <p>...more child nodes</p> </div>
When the component's
selected
state changes, a large amount of VNodes will be created even though most of the items remained exactly the same. Thev-memo
usage here is essentially saying "only update this item if it went from non-selected to selected, or the other way around". This allows every unaffected item to reuse its previous VNode and skip diffing entirely. Note we don't need to includeitem.id
in the memo dependency array here since Vue automatically infers it from the item's:key
.WARNING
When using
v-memo
withv-for
, make sure they are used on the same element.v-memo
does not work insidev-for
.v-memo
can also be used on components to manually prevent unwanted updates in certain edge cases where the child component update check has been de-optimized. But again, it is the developer's responsibility to specify correct dependency arrays to avoid skipping necessary updates.See also
v-cloak
Used to hide un-compiled template until it is ready.
Does not expect expression
Details
This directive is only needed in no-build-step setups.
When using in-DOM templates, there can be a "flash of un-compiled templates": the user may see raw mustache tags until the mounted component replaces them with rendered content.
v-cloak
will remain on the element until the associated component instance is mounted. Combined with CSS rules such as[v-cloak] { display: none }
, it can be used to hide the raw templates until the component is ready.Example
css[v-cloak] { display: none; }
template<div v-cloak> {{ message }} </div>
The
<div>
will not be visible until the compilation is done.	     hhuh(hh	h}ubh)}(h}(hNh	}(h/https://vuejs.org/api/built-in-special-elementsh
"Built-in Special Elements | Vue.jsuhX  Built-in Special Elements
Not Components
<component>
, <slot>
and <template>
are component-like features and part of the template syntax. They are not true components and are compiled away during template compilation. As such, they are conventionally written with lowercase in templates.
<component>
A "meta component" for rendering dynamic components or elements.
Props
tsinterface DynamicComponentProps { is: string | Component }
Details
The actual component to render is determined by the
is
prop.When
is
is a string, it could be either an HTML tag name or a component's registered name.Alternatively,
is
can also be directly bound to the definition of a component.
Example
Rendering components by registered name (Options API):
vue<script> import Foo from './Foo.vue' import Bar from './Bar.vue' export default { components: { Foo, Bar }, data() { return { view: 'Foo' } } } </script> <template> <component :is="view" /> </template>
Rendering components by definition (Composition API with
<script setup>
):vue<script setup> import Foo from './Foo.vue' import Bar from './Bar.vue' </script> <template> <component :is="Math.random() > 0.5 ? Foo : Bar" /> </template>
Rendering HTML elements:
template<component :is="href ? 'a' : 'span'"></component>
The built-in components can all be passed to
is
, but you must register them if you want to pass them by name. For example:vue<script> import { Transition, TransitionGroup } from 'vue' export default { components: { Transition, TransitionGroup } } </script> <template> <component :is="isGroup ? 'TransitionGroup' : 'Transition'"> ... </component> </template>
Registration is not required if you pass the component itself to
is
rather than its name, e.g. in<script setup>
.If
v-model
is used on a<component>
tag, the template compiler will expand it to amodelValue
prop andupdate:modelValue
event listener, much like it would for any other component. However, this won't be compatible with native HTML elements, such as<input>
or<select>
. As a result, usingv-model
with a dynamically created native element won't work:vue<script setup> import { ref } from 'vue' const tag = ref('input') const username = ref('') </script> <template> <!-- This won't work as 'input' is a native HTML element --> <component :is="tag" v-model="username" /> </template>
In practice, this edge case isn't common as native form fields are typically wrapped in components in real applications. If you do need to use a native element directly then you can split the
v-model
into an attribute and event manually.See also Dynamic Components
<slot>
Denotes slot content outlets in templates.
Props
tsinterface SlotProps { /** * Any props passed to <slot> to passed as arguments * for scoped slots */ [key: string]: any /** * Reserved for specifying slot name. */ name?: string }
Details
The
<slot>
element can use thename
attribute to specify a slot name. When noname
is specified, it will render the default slot. Additional attributes passed to the slot element will be passed as slot props to the scoped slot defined in the parent.The element itself will be replaced by its matched slot content.
<slot>
elements in Vue templates are compiled into JavaScript, so they are not to be confused with native<slot>
elements.See also Component - Slots
<template>
The <template>
tag is used as a placeholder when we want to use a built-in directive without rendering an element in the DOM.
Details
The special handling for
<template>
is only triggered if it is used with one of these directives:v-if
,v-else-if
, orv-else
v-for
v-slot
If none of those directives are present then it will be rendered as a native
<template>
element instead.A
<template>
with av-for
can also have akey
attribute. All other attributes and directives will be discarded, as they aren't meaningful without a corresponding element.Single-file components use a top-level
<template>
tag to wrap the entire template. That usage is separate from the use of<template>
described above. That top-level tag is not part of the template itself and doesn't support template syntax, such as directives.See alsohhuh(hh	h}ubh)}(h}(hNh	}(h'https://vuejs.org/api/options-lifecycleh
Options: Lifecycle | Vue.jsuhX!  Options: Lifecycle
See also
For shared usage of lifecycle hooks, see Guide - Lifecycle Hooks
beforeCreate
Called when the instance is initialized.
Type
tsinterface ComponentOptions { beforeCreate?(this: ComponentPublicInstance): void }
Details
Called immediately when the instance is initialized and props are resolved.
Then the props will be defined as reactive properties and the state such as
data()
orcomputed
will be set up.Note that the
setup()
hook of Composition API is called before any Options API hooks, evenbeforeCreate()
.
created
Called after the instance has finished processing all state-related options.
Type
tsinterface ComponentOptions { created?(this: ComponentPublicInstance): void }
Details
When this hook is called, the following have been set up: reactive data, computed properties, methods, and watchers. However, the mounting phase has not been started, and the
$el
property will not be available yet.
beforeMount
Called right before the component is to be mounted.
Type
tsinterface ComponentOptions { beforeMount?(this: ComponentPublicInstance): void }
Details
When this hook is called, the component has finished setting up its reactive state, but no DOM nodes have been created yet. It is about to execute its DOM render effect for the first time.
This hook is not called during server-side rendering.
mounted
Called after the component has been mounted.
Type
tsinterface ComponentOptions { mounted?(this: ComponentPublicInstance): void }
Details
A component is considered mounted after:
All of its synchronous child components have been mounted (does not include async components or components inside
<Suspense>
trees).Its own DOM tree has been created and inserted into the parent container. Note it only guarantees that the component's DOM tree is in-document if the application's root container is also in-document.
This hook is typically used for performing side effects that need access to the component's rendered DOM, or for limiting DOM-related code to the client in a server-rendered application.
This hook is not called during server-side rendering.
beforeUpdate
Called right before the component is about to update its DOM tree due to a reactive state change.
Type
tsinterface ComponentOptions { beforeUpdate?(this: ComponentPublicInstance): void }
Details
This hook can be used to access the DOM state before Vue updates the DOM. It is also safe to modify component state inside this hook.
This hook is not called during server-side rendering.
updated
Called after the component has updated its DOM tree due to a reactive state change.
Type
tsinterface ComponentOptions { updated?(this: ComponentPublicInstance): void }
Details
A parent component's updated hook is called after that of its child components.
This hook is called after any DOM update of the component, which can be caused by different state changes. If you need to access the updated DOM after a specific state change, use nextTick() instead.
This hook is not called during server-side rendering.
WARNING
Do not mutate component state in the updated hook - this will likely lead to an infinite update loop!
beforeUnmount
Called right before a component instance is to be unmounted.
Type
tsinterface ComponentOptions { beforeUnmount?(this: ComponentPublicInstance): void }
Details
When this hook is called, the component instance is still fully functional.
This hook is not called during server-side rendering.
unmounted
Called after the component has been unmounted.
Type
tsinterface ComponentOptions { unmounted?(this: ComponentPublicInstance): void }
Details
A component is considered unmounted after:
All of its child components have been unmounted.
All of its associated reactive effects (render effect and computed / watchers created during
setup()
) have been stopped.
Use this hook to clean up manually created side effects such as timers, DOM event listeners or server connections.
This hook is not called during server-side rendering.
errorCaptured
Called when an error propagating from a descendant component has been captured.
Type
tsinterface ComponentOptions { errorCaptured?( this: ComponentPublicInstance, err: unknown, instance: ComponentPublicInstance | null, info: string ): boolean | void }
Details
Errors can be captured from the following sources:
- Component renders
- Event handlers
- Lifecycle hooks
setup()
function- Watchers
- Custom directive hooks
- Transition hooks
The hook receives three arguments: the error, the component instance that triggered the error, and an information string specifying the error source type.
TIP
In production, the 3rd argument (
info
) will be a shortened code instead of the full information string. You can find the code to string mapping in the Production Error Code Reference.You can modify component state in
errorCaptured()
to display an error state to the user. However, it is important that the error state should not render the original content that caused the error; otherwise the component will be thrown into an infinite render loop.The hook can return
false
to stop the error from propagating further. See error propagation details below.Error Propagation Rules
By default, all errors are still sent to the application-level
app.config.errorHandler
if it is defined, so that these errors can still be reported to an analytics service in a single place.If multiple
errorCaptured
hooks exist on a component's inheritance chain or parent chain, all of them will be invoked on the same error, in the order of bottom to top. This is similar to the bubbling mechanism of native DOM events.If the
errorCaptured
hook itself throws an error, both this error and the original captured error are sent toapp.config.errorHandler
.An
errorCaptured
hook can returnfalse
to prevent the error from propagating further. This is essentially saying "this error has been handled and should be ignored." It will prevent any additionalerrorCaptured
hooks orapp.config.errorHandler
from being invoked for this error.
renderTracked
Called when a reactive dependency has been tracked by the component's render effect.
This hook is development-mode-only and not called during server-side rendering.
Type
tsinterface ComponentOptions { renderTracked?(this: ComponentPublicInstance, e: DebuggerEvent): void } type DebuggerEvent = { effect: ReactiveEffect target: object type: TrackOpTypes /* 'get' | 'has' | 'iterate' */ key: any }
See also Reactivity in Depth
renderTriggered
Called when a reactive dependency triggers the component's render effect to be re-run.
This hook is development-mode-only and not called during server-side rendering.
Type
tsinterface ComponentOptions { renderTriggered?(this: ComponentPublicInstance, e: DebuggerEvent): void } type DebuggerEvent = { effect: ReactiveEffect target: object type: TriggerOpTypes /* 'set' | 'add' | 'delete' | 'clear' */ key: any newValue?: any oldValue?: any oldTarget?: Map<any, any> | Set<any> }
See also Reactivity in Depth
activated
Called after the component instance is inserted into the DOM as part of a tree cached by <KeepAlive>
.
This hook is not called during server-side rendering.
Type
tsinterface ComponentOptions { activated?(this: ComponentPublicInstance): void }
See also Guide - Lifecycle of Cached Instance
deactivated
Called after the component instance is removed from the DOM as part of a tree cached by <KeepAlive>
.
This hook is not called during server-side rendering.
Type
tsinterface ComponentOptions { deactivated?(this: ComponentPublicInstance): void }
See also Guide - Lifecycle of Cached Instance
serverPrefetch
Async function to be resolved before the component instance is to be rendered on the server.
Type
tsinterface ComponentOptions { serverPrefetch?(this: ComponentPublicInstance): Promise<any> }
Details
If the hook returns a Promise, the server renderer will wait until the Promise is resolved before rendering the component.
This hook is only called during server-side rendering can be used to perform server-only data fetching.
Example
jsexport default { data() { return { data: null } }, async serverPrefetch() { // component is rendered as part of the initial request // pre-fetch data on server as it is faster than on the client this.data = await fetchOnServer(/* ... */) }, async mounted() { if (!this.data) { // if data is null on mount, it means the component // is dynamically rendered on the client. Perform a // client-side fetch instead. this.data = await fetchOnClient(/* ... */) } } }
See also Server-Side Renderinghhuh(hh	h}ubh)}(h}(hNh	}(h"https://vuejs.org/api/options-misch
Options: Misc | Vue.jsuhX  Options: Misc
name
Explicitly declare a display name for the component.
Type
tsinterface ComponentOptions { name?: string }
Details
The name of a component is used for the following:
- Recursive self-reference in the component's own template
- Display in Vue DevTools' component inspection tree
- Display in warning component traces
When you use Single-File Components, the component already infers its own name from the filename. For example, a file named
MyComponent.vue
will have the inferred display name "MyComponent".Another case is that when a component is registered globally with
app.component
, the global ID is automatically set as its name.The
name
option allows you to override the inferred name, or to explicitly provide a name when no name can be inferred (e.g. when not using build tools, or an inlined non-SFC component).There is one case where
name
is explicitly necessary: when matching against cacheable components in<KeepAlive>
via itsinclude / exclude
props.TIP
Since version 3.2.34, a single-file component using
<script setup>
will automatically infer itsname
option based on the filename, removing the need to manually declare the name even when used with<KeepAlive>
.
inheritAttrs
Controls whether the default component attribute fallthrough behavior should be enabled.
Type
tsinterface ComponentOptions { inheritAttrs?: boolean // default: true }
Details
By default, parent scope attribute bindings that are not recognized as props will "fallthrough". This means that when we have a single-root component, these bindings will be applied to the root element of the child component as normal HTML attributes. When authoring a component that wraps a target element or another component, this may not always be the desired behavior. By setting
inheritAttrs
tofalse
, this default behavior can be disabled. The attributes are available via the$attrs
instance property and can be explicitly bound to a non-root element usingv-bind
.Example
When declaring this option in a component that uses
<script setup>
, you can use thedefineOptions
macro:vue<script setup> defineProps(['label', 'value']) defineEmits(['input']) defineOptions({ inheritAttrs: false }) </script> <template> <label> {{ label }} <input v-bind="$attrs" v-bind:value="value" v-on:input="$emit('input', $event.target.value)" /> </label> </template>
See also Fallthrough Attributes
components
An object that registers components to be made available to the component instance.
Type
tsinterface ComponentOptions { components?: { [key: string]: Component } }
Example
jsimport Foo from './Foo.vue' import Bar from './Bar.vue' export default { components: { // shorthand Foo, // register under a different name RenamedBar: Bar } }
See also Component Registration
directives
An object that registers directives to be made available to the component instance.
Type
tsinterface ComponentOptions { directives?: { [key: string]: Directive } }
Example
jsexport default { directives: { // enables v-focus in template focus: { mounted(el) { el.focus() } } } }
template<input v-focus>
See also Custom Directiveshhuh(hh	h}ubh)}(h}(hNh	}(h/https://vuejs.org/api/composition-api-lifecycleh
)Composition API: Lifecycle Hooks | Vue.jsuhX-"  Composition API: Lifecycle Hooks
Usage Note
All APIs listed on this page must be called synchronously during the setup()
phase of a component. See Guide - Lifecycle Hooks for more details.
onMounted()
Registers a callback to be called after the component has been mounted.
Type
tsfunction onMounted(callback: () => void): void
Details
A component is considered mounted after:
All of its synchronous child components have been mounted (does not include async components or components inside
<Suspense>
trees).Its own DOM tree has been created and inserted into the parent container. Note it only guarantees that the component's DOM tree is in-document if the application's root container is also in-document.
This hook is typically used for performing side effects that need access to the component's rendered DOM, or for limiting DOM-related code to the client in a server-rendered application.
This hook is not called during server-side rendering.
Example
Accessing an element via template ref:
vue<script setup> import { ref, onMounted } from 'vue' const el = ref() onMounted(() => { el.value // <div> }) </script> <template> <div ref="el"></div> </template>
onUpdated()
Registers a callback to be called after the component has updated its DOM tree due to a reactive state change.
Type
tsfunction onUpdated(callback: () => void): void
Details
A parent component's updated hook is called after that of its child components.
This hook is called after any DOM update of the component, which can be caused by different state changes, because multiple state changes can be batched into a single render cycle for performance reasons. If you need to access the updated DOM after a specific state change, use nextTick() instead.
This hook is not called during server-side rendering.
WARNING
Do not mutate component state in the updated hook - this will likely lead to an infinite update loop!
Example
Accessing updated DOM:
vue<script setup> import { ref, onUpdated } from 'vue' const count = ref(0) onUpdated(() => { // text content should be the same as current `count.value` console.log(document.getElementById('count').textContent) }) </script> <template> <button id="count" @click="count++">{{ count }}</button> </template>
onUnmounted()
Registers a callback to be called after the component has been unmounted.
Type
tsfunction onUnmounted(callback: () => void): void
Details
A component is considered unmounted after:
All of its child components have been unmounted.
All of its associated reactive effects (render effect and computed / watchers created during
setup()
) have been stopped.
Use this hook to clean up manually created side effects such as timers, DOM event listeners or server connections.
This hook is not called during server-side rendering.
Example
vue<script setup> import { onMounted, onUnmounted } from 'vue' let intervalId onMounted(() => { intervalId = setInterval(() => { // ... }) }) onUnmounted(() => clearInterval(intervalId)) </script>
onBeforeMount()
Registers a hook to be called right before the component is to be mounted.
Type
tsfunction onBeforeMount(callback: () => void): void
Details
When this hook is called, the component has finished setting up its reactive state, but no DOM nodes have been created yet. It is about to execute its DOM render effect for the first time.
This hook is not called during server-side rendering.
onBeforeUpdate()
Registers a hook to be called right before the component is about to update its DOM tree due to a reactive state change.
Type
tsfunction onBeforeUpdate(callback: () => void): void
Details
This hook can be used to access the DOM state before Vue updates the DOM. It is also safe to modify component state inside this hook.
This hook is not called during server-side rendering.
onBeforeUnmount()
Registers a hook to be called right before a component instance is to be unmounted.
Type
tsfunction onBeforeUnmount(callback: () => void): void
Details
When this hook is called, the component instance is still fully functional.
This hook is not called during server-side rendering.
onErrorCaptured()
Registers a hook to be called when an error propagating from a descendant component has been captured.
Type
tsfunction onErrorCaptured(callback: ErrorCapturedHook): void type ErrorCapturedHook = ( err: unknown, instance: ComponentPublicInstance | null, info: string ) => boolean | void
Details
Errors can be captured from the following sources:
- Component renders
- Event handlers
- Lifecycle hooks
setup()
function- Watchers
- Custom directive hooks
- Transition hooks
The hook receives three arguments: the error, the component instance that triggered the error, and an information string specifying the error source type.
TIP
In production, the 3rd argument (
info
) will be a shortened code instead of the full information string. You can find the code to string mapping in the Production Error Code Reference.You can modify component state in
errorCaptured()
to display an error state to the user. However, it is important that the error state should not render the original content that caused the error; otherwise the component will be thrown into an infinite render loop.The hook can return
false
to stop the error from propagating further. See error propagation details below.Error Propagation Rules
By default, all errors are still sent to the application-level
app.config.errorHandler
if it is defined, so that these errors can still be reported to an analytics service in a single place.If multiple
errorCaptured
hooks exist on a component's inheritance chain or parent chain, all of them will be invoked on the same error, in the order of bottom to top. This is similar to the bubbling mechanism of native DOM events.If the
errorCaptured
hook itself throws an error, both this error and the original captured error are sent toapp.config.errorHandler
.An
errorCaptured
hook can returnfalse
to prevent the error from propagating further. This is essentially saying "this error has been handled and should be ignored." It will prevent any additionalerrorCaptured
hooks orapp.config.errorHandler
from being invoked for this error.
onRenderTracked()
Registers a debug hook to be called when a reactive dependency has been tracked by the component's render effect.
This hook is development-mode-only and not called during server-side rendering.
Type
tsfunction onRenderTracked(callback: DebuggerHook): void type DebuggerHook = (e: DebuggerEvent) => void type DebuggerEvent = { effect: ReactiveEffect target: object type: TrackOpTypes /* 'get' | 'has' | 'iterate' */ key: any }
See also Reactivity in Depth
onRenderTriggered()
Registers a debug hook to be called when a reactive dependency triggers the component's render effect to be re-run.
This hook is development-mode-only and not called during server-side rendering.
Type
tsfunction onRenderTriggered(callback: DebuggerHook): void type DebuggerHook = (e: DebuggerEvent) => void type DebuggerEvent = { effect: ReactiveEffect target: object type: TriggerOpTypes /* 'set' | 'add' | 'delete' | 'clear' */ key: any newValue?: any oldValue?: any oldTarget?: Map<any, any> | Set<any> }
See also Reactivity in Depth
onActivated()
Registers a callback to be called after the component instance is inserted into the DOM as part of a tree cached by <KeepAlive>
.
This hook is not called during server-side rendering.
Type
tsfunction onActivated(callback: () => void): void
See also Guide - Lifecycle of Cached Instance
onDeactivated()
Registers a callback to be called after the component instance is removed from the DOM as part of a tree cached by <KeepAlive>
.
This hook is not called during server-side rendering.
Type
tsfunction onDeactivated(callback: () => void): void
See also Guide - Lifecycle of Cached Instance
onServerPrefetch()
Registers an async function to be resolved before the component instance is to be rendered on the server.
Type
tsfunction onServerPrefetch(callback: () => Promise<any>): void
Details
If the callback returns a Promise, the server renderer will wait until the Promise is resolved before rendering the component.
This hook is only called during server-side rendering can be used to perform server-only data fetching.
Example
vue<script setup> import { ref, onServerPrefetch, onMounted } from 'vue' const data = ref(null) onServerPrefetch(async () => { // component is rendered as part of the initial request // pre-fetch data on server as it is faster than on the client data.value = await fetchOnServer(/* ... */) }) onMounted(async () => { if (!data.value) { // if data is null on mount, it means the component // is dynamically rendered on the client. Perform a // client-side fetch instead. data.value = await fetchOnClient(/* ... */) } }) </script>
See also Server-Side Renderinghhuh(hh	h}ubh)}(h}(hNh	}(h:https://vuejs.org/api/composition-api-dependency-injectionh
.Composition API: Dependency Injection | Vue.jsuhX  Composition API:
Dependency Injection
provide()
Provides a value that can be injected by descendant components.
Type
tsfunction provide<T>(key: InjectionKey<T> | string, value: T): void
Details
provide()
takes two arguments: the key, which can be a string or a symbol, and the value to be injected.When using TypeScript, the key can be a symbol casted as
InjectionKey
- a Vue provided utility type that extendsSymbol
, which can be used to sync the value type betweenprovide()
andinject()
.Similar to lifecycle hook registration APIs,
provide()
must be called synchronously during a component'ssetup()
phase.Example
vue<script setup> import { ref, provide } from 'vue' import { countSymbol } from './injectionSymbols' // provide static value provide('path', '/project/') // provide reactive value const count = ref(0) provide('count', count) // provide with Symbol keys provide(countSymbol, count) </script>
See also
inject()
Injects a value provided by an ancestor component or the application (via app.provide()
).
Type
ts// without default value function inject<T>(key: InjectionKey<T> | string): T | undefined // with default value function inject<T>(key: InjectionKey<T> | string, defaultValue: T): T // with factory function inject<T>( key: InjectionKey<T> | string, defaultValue: () => T, treatDefaultAsFactory: true ): T
Details
The first argument is the injection key. Vue will walk up the parent chain to locate a provided value with a matching key. If multiple components in the parent chain provides the same key, the one closest to the injecting component will "shadow" those higher up the chain. If no value with matching key was found,
inject()
returnsundefined
unless a default value is provided.The second argument is optional and is the default value to be used when no matching value was found.
The second argument can also be a factory function that returns values that are expensive to create. In this case,
true
must be passed as the third argument to indicate that the function should be used as a factory instead of the value itself.Similar to lifecycle hook registration APIs,
inject()
must be called synchronously during a component'ssetup()
phase.When using TypeScript, the key can be of type of
InjectionKey
- a Vue-provided utility type that extendsSymbol
, which can be used to sync the value type betweenprovide()
andinject()
.Example
Assuming a parent component has provided values as shown in the previous
provide()
example:vue<script setup> import { inject } from 'vue' import { countSymbol } from './injectionSymbols' // inject static value without default const path = inject('path') // inject reactive value const count = inject('count') // inject with Symbol keys const count2 = inject(countSymbol) // inject with default value const bar = inject('path', '/default-path') // inject with function default value const fn = inject('function', () => {}) // inject with default value factory const baz = inject('factory', () => new ExpensiveObject(), true) </script>
See also
hasInjectionContext()
Returns true if inject() can be used without warning about being called in the wrong place (e.g. outside of setup()
). This method is designed to be used by libraries that want to use inject()
internally without triggering a warning to the end user.
Type
tsfunction hasInjectionContext(): booleanhhuh(hh	h}ubh)}(h}(hNh	}(h)https://vuejs.org/api/built-in-componentsh
Built-in Components | Vue.jsuhX}  Built-in Components
Registration and Usage
Built-in components can be used directly in templates without needing to be registered. They are also tree-shakeable: they are only included in the build when they are used.
When using them in render functions, they need to be imported explicitly. For example:
js
import { h, Transition } from 'vue'
h(Transition, {
/* props */
})
<Transition>
Provides animated transition effects to a single element or component.
Props
tsinterface TransitionProps { /** * Used to automatically generate transition CSS class names. * e.g. `name: 'fade'` will auto expand to `.fade-enter`, * `.fade-enter-active`, etc. */ name?: string /** * Whether to apply CSS transition classes. * Default: true */ css?: boolean /** * Specifies the type of transition events to wait for to * determine transition end timing. * Default behavior is auto detecting the type that has * longer duration. */ type?: 'transition' | 'animation' /** * Specifies explicit durations of the transition. * Default behavior is wait for the first `transitionend` * or `animationend` event on the root transition element. */ duration?: number | { enter: number; leave: number } /** * Controls the timing sequence of leaving/entering transitions. * Default behavior is simultaneous. */ mode?: 'in-out' | 'out-in' | 'default' /** * Whether to apply transition on initial render. * Default: false */ appear?: boolean /** * Props for customizing transition classes. * Use kebab-case in templates, e.g. enter-from-class="xxx" */ enterFromClass?: string enterActiveClass?: string enterToClass?: string appearFromClass?: string appearActiveClass?: string appearToClass?: string leaveFromClass?: string leaveActiveClass?: string leaveToClass?: string }
Events
@before-enter
@before-leave
@enter
@leave
@appear
@after-enter
@after-leave
@after-appear
@enter-cancelled
@leave-cancelled
(v-show
only)@appear-cancelled
Example
Simple element:
template<Transition> <div v-if="ok">toggled content</div> </Transition>
Forcing a transition by changing the
key
attribute:template<Transition> <div :key="text">{{ text }}</div> </Transition>
Dynamic component, with transition mode + animate on appear:
template<Transition name="fade" mode="out-in" appear> <component :is="view"></component> </Transition>
Listening to transition events:
template<Transition @after-enter="onTransitionComplete"> <div v-show="ok">toggled content</div> </Transition>
See also Guide - Transition
<TransitionGroup>
Provides transition effects for multiple elements or components in a list.
Props
<TransitionGroup>
accepts the same props as<Transition>
exceptmode
, plus two additional props:tsinterface TransitionGroupProps extends Omit<TransitionProps, 'mode'> { /** * If not defined, renders as a fragment. */ tag?: string /** * For customizing the CSS class applied during move transitions. * Use kebab-case in templates, e.g. move-class="xxx" */ moveClass?: string }
Events
<TransitionGroup>
emits the same events as<Transition>
.Details
By default,
<TransitionGroup>
doesn't render a wrapper DOM element, but one can be defined via thetag
prop.Note that every child in a
<transition-group>
must be uniquely keyed for the animations to work properly.<TransitionGroup>
supports moving transitions via CSS transform. When a child's position on screen has changed after an update, it will get applied a moving CSS class (auto generated from thename
attribute or configured with themove-class
prop). If the CSStransform
property is "transition-able" when the moving class is applied, the element will be smoothly animated to its destination using the FLIP technique.Example
template<TransitionGroup tag="ul" name="slide"> <li v-for="item in items" :key="item.id"> {{ item.text }} </li> </TransitionGroup>
See also Guide - TransitionGroup
<KeepAlive>
Caches dynamically toggled components wrapped inside.
Props
tsinterface KeepAliveProps { /** * If specified, only components with names matched by * `include` will be cached. */ include?: MatchPattern /** * Any component with a name matched by `exclude` will * not be cached. */ exclude?: MatchPattern /** * The maximum number of component instances to cache. */ max?: number | string } type MatchPattern = string | RegExp | (string | RegExp)[]
Details
When wrapped around a dynamic component,
<KeepAlive>
caches the inactive component instances without destroying them.There can only be one active component instance as the direct child of
<KeepAlive>
at any time.When a component is toggled inside
<KeepAlive>
, itsactivated
anddeactivated
lifecycle hooks will be invoked accordingly, providing an alternative tomounted
andunmounted
, which are not called. This applies to the direct child of<KeepAlive>
as well as to all of its descendants.Example
Basic usage:
template<KeepAlive> <component :is="view"></component> </KeepAlive>
When used with
v-if
/v-else
branches, there must be only one component rendered at a time:template<KeepAlive> <comp-a v-if="a > 1"></comp-a> <comp-b v-else></comp-b> </KeepAlive>
Used together with
<Transition>
:template<Transition> <KeepAlive> <component :is="view"></component> </KeepAlive> </Transition>
Using
include
/exclude
:template<!-- comma-delimited string --> <KeepAlive include="a,b"> <component :is="view"></component> </KeepAlive> <!-- regex (use `v-bind`) --> <KeepAlive :include="/a|b/"> <component :is="view"></component> </KeepAlive> <!-- Array (use `v-bind`) --> <KeepAlive :include="['a', 'b']"> <component :is="view"></component> </KeepAlive>
Usage with
max
:template<KeepAlive :max="10"> <component :is="view"></component> </KeepAlive>
See also Guide - KeepAlive
<Teleport>
Renders its slot content to another part of the DOM.
Props
tsinterface TeleportProps { /** * Required. Specify target container. * Can either be a selector or an actual element. */ to: string | HTMLElement /** * When `true`, the content will remain in its original * location instead of moved into the target container. * Can be changed dynamically. */ disabled?: boolean }
Example
Specifying target container:
template<Teleport to="#some-id" /> <Teleport to=".some-class" /> <Teleport to="[data-teleport]" />
Conditionally disabling:
template<Teleport to="#popup" :disabled="displayVideoInline"> <video src="./my-movie.mp4"> </Teleport>
See also Guide - Teleport
<Suspense>
Used for orchestrating nested async dependencies in a component tree.
Props
tsinterface SuspenseProps { timeout?: string | number suspensible?: boolean }
Events
@resolve
@pending
@fallback
Details
<Suspense>
accepts two slots: the#default
slot and the#fallback
slot. It will display the content of the fallback slot while rendering the default slot in memory.If it encounters async dependencies (Async Components and components with
async setup()
) while rendering the default slot, it will wait until all of them are resolved before displaying the default slot.By setting the Suspense as
suspensible
, all the async dependency handling will be handled by the parent Suspense. See implementation detailsSee also Guide - Suspensehhuh(hh	h}ubh)}(h}(hNh	}(h'https://vuejs.org/api/options-renderingh
Options: Rendering | Vue.jsuhX#  Options: Rendering
template
A string template for the component.
Type
tsinterface ComponentOptions { template?: string }
Details
A template provided via the
template
option will be compiled on-the-fly at runtime. It is only supported when using a build of Vue that includes the template compiler. The template compiler is NOT included in Vue builds that have the wordruntime
in their names, e.g.vue.runtime.esm-bundler.js
. Consult the dist file guide for more details about the different builds.If the string starts with
#
it will be used as aquerySelector
and use the selected element'sinnerHTML
as the template string. This allows the source template to be authored using native<template>
elements.If the
render
option is also present in the same component,template
will be ignored.If the root component of your application doesn't have a
template
orrender
option specified, Vue will try to use theinnerHTML
of the mounted element as the template instead.Security Note
Only use template sources that you can trust. Do not use user-provided content as your template. See Security Guide for more details.
render
A function that programmatically returns the virtual DOM tree of the component.
Type
tsinterface ComponentOptions { render?(this: ComponentPublicInstance) => VNodeChild } type VNodeChild = VNodeChildAtom | VNodeArrayChildren type VNodeChildAtom = | VNode | string | number | boolean | null | undefined | void type VNodeArrayChildren = (VNodeArrayChildren | VNodeChildAtom)[]
Details
render
is an alternative to string templates that allows you to leverage the full programmatic power of JavaScript to declare the render output of the component.Pre-compiled templates, for example those in Single-File Components, are compiled into the
render
option at build time. If bothrender
andtemplate
are present in a component,render
will take higher priority.See also
compilerOptions
Configure runtime compiler options for the component's template.
Type
tsinterface ComponentOptions { compilerOptions?: { isCustomElement?: (tag: string) => boolean whitespace?: 'condense' | 'preserve' // default: 'condense' delimiters?: [string, string] // default: ['{{', '}}'] comments?: boolean // default: false } }
Details
This config option is only respected when using the full build (i.e. the standalone
vue.js
that can compile templates in the browser). It supports the same options as the app-level app.config.compilerOptions, and has higher priority for the current component.See also app.config.compilerOptions
slots
An option to assist with type inference when using slots programmatically in render functions. Only supported in 3.3+.
Details
This option's runtime value is not used. The actual types should be declared via type casting using the
SlotsType
type helper:tsimport { SlotsType } from 'vue' defineComponent({ slots: Object as SlotsType<{ default: { foo: string; bar: number } item: { data: number } }>, setup(props, { slots }) { expectType< undefined | ((scope: { foo: string; bar: number }) => any) >(slots.default) expectType<undefined | ((scope: { data: number }) => any)>( slots.item ) } })hhuh(hh	h}ubh)}(h}(hNh	}(h)https://vuejs.org/api/reactivity-advancedh
!Reactivity API: Advanced | Vue.jsuhX   Reactivity API: Advanced
shallowRef()
Shallow version of ref()
.
Type
tsfunction shallowRef<T>(value: T): ShallowRef<T> interface ShallowRef<T> { value: T }
Details
Unlike
ref()
, the inner value of a shallow ref is stored and exposed as-is, and will not be made deeply reactive. Only the.value
access is reactive.shallowRef()
is typically used for performance optimizations of large data structures, or integration with external state management systems.Example
jsconst state = shallowRef({ count: 1 }) // does NOT trigger change state.value.count = 2 // does trigger change state.value = { count: 2 }
See also
triggerRef()
Force trigger effects that depends on a shallow ref. This is typically used after making deep mutations to the inner value of a shallow ref.
Type
tsfunction triggerRef(ref: ShallowRef): void
Example
jsconst shallow = shallowRef({ greet: 'Hello, world' }) // Logs "Hello, world" once for the first run-through watchEffect(() => { console.log(shallow.value.greet) }) // This won't trigger the effect because the ref is shallow shallow.value.greet = 'Hello, universe' // Logs "Hello, universe" triggerRef(shallow)
customRef()
Creates a customized ref with explicit control over its dependency tracking and updates triggering.
Type
tsfunction customRef<T>(factory: CustomRefFactory<T>): Ref<T> type CustomRefFactory<T> = ( track: () => void, trigger: () => void ) => { get: () => T set: (value: T) => void }
Details
customRef()
expects a factory function, which receivestrack
andtrigger
functions as arguments and should return an object withget
andset
methods.In general,
track()
should be called insideget()
, andtrigger()
should be called insideset()
. However, you have full control over when they should be called, or whether they should be called at all.Example
Creating a debounced ref that only updates the value after a certain timeout after the latest set call:
jsimport { customRef } from 'vue' export function useDebouncedRef(value, delay = 200) { let timeout return customRef((track, trigger) => { return { get() { track() return value }, set(newValue) { clearTimeout(timeout) timeout = setTimeout(() => { value = newValue trigger() }, delay) } } }) }
Usage in component:
vue<script setup> import { useDebouncedRef } from './debouncedRef' const text = useDebouncedRef('hello') </script> <template> <input v-model="text" /> </template>
Use with caution
When using customRef, we should be cautious about the return value of its getter, particularly when generating new object datatypes each time the getter is run. This affects the relationship between parent and child components, where such a customRef has been passed as a prop.
The parent component's render function could be triggered by changes to a different reactive state. During rerender, the value of our customRef is reevaluated, returning a new object datatype as a prop to a child component. This prop is compared with its last value in the child component, and since they are different, the reactive dependencies of the customRef are triggered in the child component. Meanwhile, the reactive dependencies in the parent component do not run because the customRef's setter was not called, and its dependencies were not triggered as a result.
shallowReactive()
Shallow version of reactive()
.
Type
tsfunction shallowReactive<T extends object>(target: T): T
Details
Unlike
reactive()
, there is no deep conversion: only root-level properties are reactive for a shallow reactive object. Property values are stored and exposed as-is - this also means properties with ref values will not be automatically unwrapped.Use with Caution
Shallow data structures should only be used for root level state in a component. Avoid nesting it inside a deep reactive object as it creates a tree with inconsistent reactivity behavior which can be difficult to understand and debug.
Example
jsconst state = shallowReactive({ foo: 1, nested: { bar: 2 } }) // mutating state's own properties is reactive state.foo++ // ...but does not convert nested objects isReactive(state.nested) // false // NOT reactive state.nested.bar++
shallowReadonly()
Shallow version of readonly()
.
Type
tsfunction shallowReadonly<T extends object>(target: T): Readonly<T>
Details
Unlike
readonly()
, there is no deep conversion: only root-level properties are made readonly. Property values are stored and exposed as-is - this also means properties with ref values will not be automatically unwrapped.Use with Caution
Shallow data structures should only be used for root level state in a component. Avoid nesting it inside a deep reactive object as it creates a tree with inconsistent reactivity behavior which can be difficult to understand and debug.
Example
jsconst state = shallowReadonly({ foo: 1, nested: { bar: 2 } }) // mutating state's own properties will fail state.foo++ // ...but works on nested objects isReadonly(state.nested) // false // works state.nested.bar++
toRaw()
Returns the raw, original object of a Vue-created proxy.
Type
tsfunction toRaw<T>(proxy: T): T
Details
toRaw()
can return the original object from proxies created byreactive()
,readonly()
,shallowReactive()
orshallowReadonly()
.This is an escape hatch that can be used to temporarily read without incurring proxy access / tracking overhead or write without triggering changes. It is not recommended to hold a persistent reference to the original object. Use with caution.
Example
jsconst foo = {} const reactiveFoo = reactive(foo) console.log(toRaw(reactiveFoo) === foo) // true
markRaw()
Marks an object so that it will never be converted to a proxy. Returns the object itself.
Type
tsfunction markRaw<T extends object>(value: T): T
Example
jsconst foo = markRaw({}) console.log(isReactive(reactive(foo))) // false // also works when nested inside other reactive objects const bar = reactive({ foo }) console.log(isReactive(bar.foo)) // false
Use with Caution
markRaw()
and shallow APIs such asshallowReactive()
allow you to selectively opt-out of the default deep reactive/readonly conversion and embed raw, non-proxied objects in your state graph. They can be used for various reasons:Some values simply should not be made reactive, for example a complex 3rd party class instance, or a Vue component object.
Skipping proxy conversion can provide performance improvements when rendering large lists with immutable data sources.
They are considered advanced because the raw opt-out is only at the root level, so if you set a nested, non-marked raw object into a reactive object and then access it again, you get the proxied version back. This can lead to identity hazards - i.e. performing an operation that relies on object identity but using both the raw and the proxied version of the same object:
jsconst foo = markRaw({ nested: {} }) const bar = reactive({ // although `foo` is marked as raw, foo.nested is not. nested: foo.nested }) console.log(foo.nested === bar.nested) // false
Identity hazards are in general rare. However, to properly utilize these APIs while safely avoiding identity hazards requires a solid understanding of how the reactivity system works.
effectScope()
Creates an effect scope object which can capture the reactive effects (i.e. computed and watchers) created within it so that these effects can be disposed together. For detailed use cases of this API, please consult its corresponding RFC.
Type
tsfunction effectScope(detached?: boolean): EffectScope interface EffectScope { run<T>(fn: () => T): T | undefined // undefined if scope is inactive stop(): void }
Example
jsconst scope = effectScope() scope.run(() => { const doubled = computed(() => counter.value * 2) watch(doubled, () => console.log(doubled.value)) watchEffect(() => console.log('Count: ', doubled.value)) }) // to dispose all effects in the scope scope.stop()
getCurrentScope()
Returns the current active effect scope if there is one.
Type
tsfunction getCurrentScope(): EffectScope | undefined
onScopeDispose()
Registers a dispose callback on the current active effect scope. The callback will be invoked when the associated effect scope is stopped.
This method can be used as a non-component-coupled replacement of onUnmounted
in reusable composition functions, since each Vue component's setup()
function is also invoked in an effect scope.
Type
tsfunction onScopeDispose(fn: () => void): voidhhuh(hh	h}ubh)}(h}(hNh	}(h&https://vuejs.org/api/sfc-script-setuph
<script setup> | Vue.jsuhXFA  <script setup>
<script setup>
is a compile-time syntactic sugar for using Composition API inside Single-File Components (SFCs). It is the recommended syntax if you are using both SFCs and Composition API. It provides a number of advantages over the normal <script>
syntax:
- More succinct code with less boilerplate
- Ability to declare props and emitted events using pure TypeScript
- Better runtime performance (the template is compiled into a render function in the same scope, without an intermediate proxy)
- Better IDE type-inference performance (less work for the language server to extract types from code)
Basic Syntax
To opt-in to the syntax, add the setup
attribute to the <script>
block:
vue
<script setup>
console.log('hello script setup')
</script>
The code inside is compiled as the content of the component's setup()
function. This means that unlike normal <script>
, which only executes once when the component is first imported, code inside <script setup>
will execute every time an instance of the component is created.
Top-level bindings are exposed to template
When using <script setup>
, any top-level bindings (including variables, function declarations, and imports) declared inside <script setup>
are directly usable in the template:
vue
<script setup>
// variable
const msg = 'Hello!'
// functions
function log() {
console.log(msg)
}
</script>
<template>
<button @click="log">{{ msg }}</button>
</template>
Imports are exposed in the same fashion. This means you can directly use an imported helper function in template expressions without having to expose it via the methods
option:
vue
<script setup>
import { capitalize } from './helpers'
</script>
<template>
<div>{{ capitalize('hello') }}</div>
</template>
Reactivity
Reactive state needs to be explicitly created using Reactivity APIs. Similar to values returned from a setup()
function, refs are automatically unwrapped when referenced in templates:
vue
<script setup>
import { ref } from 'vue'
const count = ref(0)
</script>
<template>
<button @click="count++">{{ count }}</button>
</template>
Using Components
Values in the scope of <script setup>
can also be used directly as custom component tag names:
vue
<script setup>
import MyComponent from './MyComponent.vue'
</script>
<template>
<MyComponent />
</template>
Think of MyComponent
as being referenced as a variable. If you have used JSX, the mental model is similar here. The kebab-case equivalent <my-component>
also works in the template - however PascalCase component tags are strongly recommended for consistency. It also helps differentiating from native custom elements.
Dynamic Components
Since components are referenced as variables instead of registered under string keys, we should use dynamic :is
binding when using dynamic components inside <script setup>
:
vue
<script setup>
import Foo from './Foo.vue'
import Bar from './Bar.vue'
</script>
<template>
<component :is="Foo" />
<component :is="someCondition ? Foo : Bar" />
</template>
Note how the components can be used as variables in a ternary expression.
Recursive Components
An SFC can implicitly refer to itself via its filename. E.g. a file named FooBar.vue
can refer to itself as <FooBar/>
in its template.
Note this has lower priority than imported components. If you have a named import that conflicts with the component's inferred name, you can alias the import:
js
import { FooBar as FooBarChild } from './components'
Namespaced Components
You can use component tags with dots like <Foo.Bar>
to refer to components nested under object properties. This is useful when you import multiple components from a single file:
vue
<script setup>
import * as Form from './form-components'
</script>
<template>
<Form.Input>
<Form.Label>label</Form.Label>
</Form.Input>
</template>
Using Custom Directives
Globally registered custom directives just work as normal. Local custom directives don't need to be explicitly registered with <script setup>
, but they must follow the naming scheme vNameOfDirective
:
vue
<script setup>
const vMyDirective = {
beforeMount: (el) => {
// do something with the element
}
}
</script>
<template>
<h1 v-my-directive>This is a Heading</h1>
</template>
If you're importing a directive from elsewhere, it can be renamed to fit the required naming scheme:
vue
<script setup>
import { myDirective as vMyDirective } from './MyDirective.js'
</script>
defineProps() & defineEmits()
To declare options like props
and emits
with full type inference support, we can use the defineProps
and defineEmits
APIs, which are automatically available inside <script setup>
:
vue
<script setup>
const props = defineProps({
foo: String
})
const emit = defineEmits(['change', 'delete'])
// setup code
</script>
defineProps
anddefineEmits
are compiler macros only usable inside<script setup>
. They do not need to be imported, and are compiled away when<script setup>
is processed.defineProps
accepts the same value as theprops
option, whiledefineEmits
accepts the same value as theemits
option.defineProps
anddefineEmits
provide proper type inference based on the options passed.The options passed to
defineProps
anddefineEmits
will be hoisted out of setup into module scope. Therefore, the options cannot reference local variables declared in setup scope. Doing so will result in a compile error. However, it can reference imported bindings since they are in the module scope as well.
Type-only props/emit declarations
Props and emits can also be declared using pure-type syntax by passing a literal type argument to defineProps
or defineEmits
:
ts
const props = defineProps<{
foo: string
bar?: number
}>()
const emit = defineEmits<{
(e: 'change', id: number): void
(e: 'update', value: string): void
}>()
// 3.3+: alternative, more succinct syntax
const emit = defineEmits<{
change: [id: number] // named tuple syntax
update: [value: string]
}>()
defineProps
ordefineEmits
can only use either runtime declaration OR type declaration. Using both at the same time will result in a compile error.When using type declaration, the equivalent runtime declaration is automatically generated from static analysis to remove the need for double declaration and still ensure correct runtime behavior.
In dev mode, the compiler will try to infer corresponding runtime validation from the types. For example here
foo: String
is inferred from thefoo: string
type. If the type is a reference to an imported type, the inferred result will befoo: null
(equal toany
type) since the compiler does not have information of external files.In prod mode, the compiler will generate the array format declaration to reduce bundle size (the props here will be compiled into
['foo', 'bar']
)
In version 3.2 and below, the generic type parameter for
defineProps()
were limited to a type literal or a reference to a local interface.This limitation has been resolved in 3.3. The latest version of Vue supports referencing imported and a limited set of complex types in the type parameter position. However, because the type to runtime conversion is still AST-based, some complex types that require actual type analysis, e.g. conditional types, are not supported. You can use conditional types for the type of a single prop, but not the entire props object.
Default props values when using type declaration
One drawback of the type-only defineProps
declaration is that it doesn't have a way to provide default values for the props. To resolve this problem, a withDefaults
compiler macro is also provided:
ts
export interface Props {
msg?: string
labels?: string[]
}
const props = withDefaults(defineProps<Props>(), {
msg: 'hello',
labels: () => ['one', 'two']
})
This will be compiled to equivalent runtime props default
options. In addition, the withDefaults
helper provides type checks for the default values, and ensures the returned props
type has the optional flags removed for properties that do have default values declared.
INFO
Note that default values for mutable reference types (like arrays or objects) should be wrapped in functions to avoid accidental modification and external side effects. This ensures each component instance gets its own copy of the default value.
defineModel()
This macro can be used to declare a two-way binding prop that can be consumed via v-model
from the parent component. Example usage is also discussed in the Component v-model
guide.
Under the hood, this macro declares a model prop and a corresponding value update event. If the first argument is a literal string, it will be used as the prop name; Otherwise the prop name will default to "modelValue"
. In both cases, you can also pass an additional object which can include the prop's options and the model ref's value transform options.
js
// declares "modelValue" prop, consumed by parent via v-model
const model = defineModel()
// OR: declares "modelValue" prop with options
const model = defineModel({ type: String })
// emits "update:modelValue" when mutated
model.value = 'hello'
// declares "count" prop, consumed by parent via v-model:count
const count = defineModel('count')
// OR: declares "count" prop with options
const count = defineModel('count', { type: Number, default: 0 })
function inc() {
// emits "update:count" when mutated
count.value++
}
WARNING
If you have a default
value for defineModel
prop and you don't provide any value for this prop from the parent component, it can cause a de-synchronization between parent and child components. In the example below, the parent's myRef
is undefined, but the child's model
is 1:
js
// child component:
const model = defineModel({ default: 1 })
// parent component:
const myRef = ref()
html
<Child v-model="myRef"></Child>
Modifiers and Transformers
To access modifiers used with the v-model
directive, we can destructure the return value of defineModel()
like this:
js
const [modelValue, modelModifiers] = defineModel()
// corresponds to v-model.trim
if (modelModifiers.trim) {
// ...
}
When a modifier is present, we likely need to transform the value when reading or syncing it back to the parent. We can achieve this by using the get
and set
transformer options:
js
const [modelValue, modelModifiers] = defineModel({
// get() omitted as it is not needed here
set(value) {
// if the .trim modifier is used, return trimmed value
if (modelModifiers.trim) {
return value.trim()
}
// otherwise, return the value as-is
return value
}
})
Usage with TypeScript
Like defineProps
and defineEmits
, defineModel
can also receive type arguments to specify the types of the model value and the modifiers:
ts
const modelValue = defineModel<string>()
// ^? Ref<string | undefined>
// default model with options, required removes possible undefined values
const modelValue = defineModel<string>({ required: true })
// ^? Ref<string>
const [modelValue, modifiers] = defineModel<string, 'trim' | 'uppercase'>()
// ^? Record<'trim' | 'uppercase', true | undefined>
defineExpose()
Components using <script setup>
are closed by default - i.e. the public instance of the component, which is retrieved via template refs or $parent
chains, will not expose any of the bindings declared inside <script setup>
.
To explicitly expose properties in a <script setup>
component, use the defineExpose
compiler macro:
vue
<script setup>
import { ref } from 'vue'
const a = 1
const b = ref(2)
defineExpose({
a,
b
})
</script>
When a parent gets an instance of this component via template refs, the retrieved instance will be of the shape { a: number, b: number }
(refs are automatically unwrapped just like on normal instances).
defineOptions()
This macro can be used to declare component options directly inside <script setup>
without having to use a separate <script>
block:
vue
<script setup>
defineOptions({
inheritAttrs: false,
customOptions: {
/* ... */
}
})
</script>
- Only supported in 3.3+.
- This is a macro. The options will be hoisted to module scope and cannot access local variables in
<script setup>
that are not literal constants.
defineSlots()
This macro can be used to provide type hints to IDEs for slot name and props type checking.
defineSlots()
only accepts a type parameter and no runtime arguments. The type parameter should be a type literal where the property key is the slot name, and the value type is the slot function. The first argument of the function is the props the slot expects to receive, and its type will be used for slot props in the template. The return type is currently ignored and can be any
, but we may leverage it for slot content checking in the future.
It also returns the slots
object, which is equivalent to the slots
object exposed on the setup context or returned by useSlots()
.
vue
<script setup lang="ts">
const slots = defineSlots<{
default(props: { msg: string }): any
}>()
</script>
- Only supported in 3.3+.
useSlots()
& useAttrs()
Usage of slots
and attrs
inside <script setup>
should be relatively rare, since you can access them directly as $slots
and $attrs
in the template. In the rare case where you do need them, use the useSlots
and useAttrs
helpers respectively:
vue
<script setup>
import { useSlots, useAttrs } from 'vue'
const slots = useSlots()
const attrs = useAttrs()
</script>
useSlots
and useAttrs
are actual runtime functions that return the equivalent of setupContext.slots
and setupContext.attrs
. They can be used in normal composition API functions as well.
Usage alongside normal <script>
<script setup>
can be used alongside normal <script>
. A normal <script>
may be needed in cases where we need to:
- Declare options that cannot be expressed in
<script setup>
, for exampleinheritAttrs
or custom options enabled via plugins (Can be replaced bydefineOptions
in 3.3+). - Declaring named exports.
- Run side effects or create objects that should only execute once.
vue
<script>
// normal <script>, executed in module scope (only once)
runSideEffectOnce()
// declare additional options
export default {
inheritAttrs: false,
customOptions: {}
}
</script>
<script setup>
// executed in setup() scope (for each instance)
</script>
Support for combining <script setup>
and <script>
in the same component is limited to the scenarios described above. Specifically:
- Do NOT use a separate
<script>
section for options that can already be defined using<script setup>
, such asprops
andemits
. - Variables created inside
<script setup>
are not added as properties to the component instance, making them inaccessible from the Options API. Mixing APIs in this way is strongly discouraged.
If you find yourself in one of the scenarios that is not supported then you should consider switching to an explicit setup()
function, instead of using <script setup>
.
Top-level await
Top-level await
can be used inside <script setup>
. The resulting code will be compiled as async setup()
:
vue
<script setup>
const post = await fetch(`/api/post/1`).then((r) => r.json())
</script>
In addition, the awaited expression will be automatically compiled in a format that preserves the current component instance context after the await
.
Note
async setup()
must be used in combination with Suspense
, which is currently still an experimental feature. We plan to finalize and document it in a future release - but if you are curious now, you can refer to its tests to see how it works.
Generics
Generic type parameters can be declared using the generic
attribute on the <script>
tag:
vue
<script setup lang="ts" generic="T">
defineProps<{
items: T[]
selected: T
}>()
</script>
The value of generic
works exactly the same as the parameter list between <...>
in TypeScript. For example, you can use multiple parameters, extends
constraints, default types, and reference imported types:
vue
<script
setup
lang="ts"
generic="T extends string | number, U extends Item"
>
import type { Item } from './types'
defineProps<{
id: T
list: U[]
}>()
</script>
In order to use a reference to a generic component in a ref
you need to use the vue-component-type-helpers
library as InstanceType
won't work.
vue
<script
setup
lang="ts"
>
import componentWithoutGenerics from '../component-without-generics.vue';
import genericComponent from '../generic-component.vue';
import type { ComponentExposed } from 'vue-component-type-helpers';
// Works for a component without generics
ref<InstanceType<typeof componentWithoutGenerics>>();
ref<ComponentExposed<typeof genericComponent>>();
Restrictions
- Due to the difference in module execution semantics, code inside
<script setup>
relies on the context of an SFC. When moved into external.js
or.ts
files, it may lead to confusion for both developers and tools. Therefore,<script setup>
cannot be used with thesrc
attribute. <script setup>
does not support In-DOM Root Component Template.(Related Discussion)hhuh(hh	h}ubh)}(h}(hNh	}(hhttps://vuejs.org/api/ssrh
"Server-Side Rendering API | Vue.jsuhX  Server-Side Rendering API
renderToString()
Exported from
vue/server-renderer
Type
tsfunction renderToString( input: App | VNode, context?: SSRContext ): Promise<string>
Example
jsimport { createSSRApp } from 'vue' import { renderToString } from 'vue/server-renderer' const app = createSSRApp({ data: () => ({ msg: 'hello' }), template: `<div>{{ msg }}</div>` }) ;(async () => { const html = await renderToString(app) console.log(html) })()
SSR Context
You can pass an optional context object, which can be used to record additional data during the render, for example accessing content of Teleports:
jsconst ctx = {} const html = await renderToString(app, ctx) console.log(ctx.teleports) // { '#teleported': 'teleported content' }
Most other SSR APIs on this page also optionally accept a context object. The context object can be accessed in component code via the useSSRContext helper.
See also Guide - Server-Side Rendering
renderToNodeStream()
Renders input as a Node.js Readable stream.
Exported from
vue/server-renderer
Type
tsfunction renderToNodeStream( input: App | VNode, context?: SSRContext ): Readable
Example
js// inside a Node.js http handler renderToNodeStream(app).pipe(res)
Note
This method is not supported in the ESM build of
vue/server-renderer
, which is decoupled from Node.js environments. UsepipeToNodeWritable
instead.
pipeToNodeWritable()
Render and pipe to an existing Node.js Writable stream instance.
Exported from
vue/server-renderer
Type
tsfunction pipeToNodeWritable( input: App | VNode, context: SSRContext = {}, writable: Writable ): void
Example
js// inside a Node.js http handler pipeToNodeWritable(app, {}, res)
renderToWebStream()
Renders input as a Web ReadableStream.
Exported from
vue/server-renderer
Type
tsfunction renderToWebStream( input: App | VNode, context?: SSRContext ): ReadableStream
Example
js// inside an environment with ReadableStream support return new Response(renderToWebStream(app))
Note
In environments that do not expose
ReadableStream
constructor in the global scope,pipeToWebWritable()
should be used instead.
pipeToWebWritable()
Render and pipe to an existing Web WritableStream instance.
Exported from
vue/server-renderer
Type
tsfunction pipeToWebWritable( input: App | VNode, context: SSRContext = {}, writable: WritableStream ): void
Example
This is typically used in combination with
TransformStream
:js// TransformStream is available in environments such as CloudFlare workers. // in Node.js, TransformStream needs to be explicitly imported from 'stream/web' const { readable, writable } = new TransformStream() pipeToWebWritable(app, {}, writable) return new Response(readable)
renderToSimpleStream()
Renders input in streaming mode using a simple readable interface.
Exported from
vue/server-renderer
Type
tsfunction renderToSimpleStream( input: App | VNode, context: SSRContext, options: SimpleReadable ): SimpleReadable interface SimpleReadable { push(content: string | null): void destroy(err: any): void }
Example
jslet res = '' renderToSimpleStream( app, {}, { push(chunk) { if (chunk === null) { // done console(`render complete: ${res}`) } else { res += chunk } }, destroy(err) { // error encountered } } )
useSSRContext()
A runtime API used to retrieve the context object passed to renderToString()
or other server render APIs.
Type
tsfunction useSSRContext<T = Record<string, any>>(): T | undefined
Example
The retrieved context can be used to attach information that is needed for rendering the final HTML (e.g. head metadata).
vue<script setup> import { useSSRContext } from 'vue' // make sure to only call it during SSR // https://vitejs.dev/guide/ssr.html#conditional-logic if (import.meta.env.SSR) { const ctx = useSSRContext() // ...attach properties to the context } </script>     hhuh(hh	h}ubh)}(h}(hNh	}(h6https://router.vuejs.org/guide/essentials/named-routesh
Named Routes | Vue RouteruhX  Named Routes
When creating a route, we can optionally give the route a name
:
const routes = [
{
path: '/user/:username',
name: 'profile',
component: User
}
]
We can then use the name
instead of the path
when passing the to
prop to <router-link>
:
<router-link :to="{ name: 'profile', params: { username: 'erina' } }">
User profile
</router-link>
The example above would create a link to /user/erina
.
Using a name
has various advantages:
- No hardcoded URLs.
- Automatic encoding of
params
. - Avoids URL typos.
- Bypassing path ranking, e.g. to display a lower-ranked route that matches the same path.
Each name must be unique across all routes. If you add the same name to multiple routes, the router will only keep the last one. You can read more about this in the Dynamic Routing section.
There are various other parts of Vue Router that can be passed a location, e.g. the methods router.push()
and router.replace()
. We'll go into more detail about those methods in the guide to programmatic navigation. Just like the to
prop, these methods also support passing a location by name
:
router.push({ name: 'profile', params: { username: 'erina' } })hhuh(hh	h}ubh)}(h}(hNh	}(h3https://router.vuejs.org/guide/advanced/transitionsh
Transitions | Vue RouteruhX'  Transitions
In order to use transitions on your route components and animate navigations, you need to use the <RouterView>
slot:
<router-view v-slot="{ Component }">
<transition name="fade">
<component :is="Component" />
</transition>
</router-view>
All transition APIs work the same here.
Per-Route Transition
The above usage will apply the same transition for all routes. If you want each route's component to have different transitions, you can instead combine meta fields and a dynamic name
on <transition>
:
const routes = [
{
path: '/custom-transition',
component: PanelLeft,
meta: { transition: 'slide-left' },
},
{
path: '/other-transition',
component: PanelRight,
meta: { transition: 'slide-right' },
},
]
<router-view v-slot="{ Component, route }">
<!-- Use a custom transition or fallback to `fade` -->
<transition :name="route.meta.transition || 'fade'">
<component :is="Component" />
</transition>
</router-view>
Route-Based Dynamic Transition
It is also possible to determine the transition to use dynamically based on the relationship between the target route and current route. Using a very similar snippet to the one just before:
<!-- use a dynamic transition name -->
<router-view v-slot="{ Component, route }">
<transition :name="route.meta.transition">
<component :is="Component" />
</transition>
</router-view>
We can add an after navigation hook to dynamically add information to the meta
field based on the depth of the route
router.afterEach((to, from) => {
const toDepth = to.path.split('/').length
const fromDepth = from.path.split('/').length
to.meta.transition = toDepth < fromDepth ? 'slide-right' : 'slide-left'
})
Forcing a transition between reused views
Vue might automatically reuse components that look alike, avoiding any transition. Fortunately, it is possible to add a key
attribute to force transitions. This also allows you to trigger transitions while staying on the same route with different params:
<router-view v-slot="{ Component, route }">
<transition name="fade">
<component :is="Component" :key="route.path" />
</transition>
</router-view>hhuh(hh	h}ubh)}(h}(hNh	}(h;https://router.vuejs.org/guide/advanced/navigation-failuresh
3Waiting for the result of a Navigation | Vue RouteruhX+  Waiting for the result of a Navigation
When using router-link
, Vue Router calls router.push
to trigger a navigation. While the expected behavior for most links is to navigate a user to a new page, there are a few situations where users will remain on the same page:
- Users are already on the page that they are trying to navigate to.
- A navigation guard aborts the navigation by doing
return false
. - A new navigation guard takes place while the previous one not finished.
- A navigation guard redirects somewhere else by returning a new location (e.g.
return '/login'
). - A navigation guard throws an
Error
.
If we want to do something after a navigation is finished, we need a way to wait after calling router.push
. Imagine we have a mobile menu that allows us to go to different pages and we only want to hide the menu once we have navigated to the new page, we might want to do something like this:
router.push('/my-profile')
this.isMenuOpen = false
But this will close the menu right away because navigations are asynchronous, we need to await
the promise returned by router.push
:
await router.push('/my-profile')
this.isMenuOpen = false
Now the menu will close once the navigation is finished but it will also close if the navigation was prevented. We need a way to detect if we actually changed the page we are on or not.
Detecting Navigation Failures
If a navigation is prevented, resulting in the user staying on the same page, the resolved value of the Promise
returned by router.push
will be a Navigation Failure. Otherwise, it will be a falsy value (usually undefined
). This allows us to differentiate the case where we navigated away from where we are or not:
const navigationResult = await router.push('/my-profile')
if (navigationResult) {
// navigation prevented
} else {
// navigation succeeded (this includes the case of a redirection)
this.isMenuOpen = false
}
Navigation Failures are Error
instances with a few extra properties that gives us enough information to know what navigation was prevented and why. To check the nature of a navigation result, use the isNavigationFailure
function:
import { NavigationFailureType, isNavigationFailure } from 'vue-router'
// trying to leave the editing page of an article without saving
const failure = await router.push('/articles/2')
if (isNavigationFailure(failure, NavigationFailureType.aborted)) {
// show a small notification to the user
showToast('You have unsaved changes, discard and leave anyway?')
}
TIP
If you omit the second parameter: isNavigationFailure(failure)
, it will only check if failure
is a Navigation Failure.
Global navigation failures
You can detect global navigation failures globally by using the router.afterEach()
navigation guard:
router.afterEach((to, from, failure) => {
if (failure) {
sendToAnalytics(to, from, failure)
}
})
Differentiating Navigation Failures
As we said at the beginning, there are different situations aborting a navigation, all of them resulting in different Navigation Failures. They can be differentiated using the isNavigationFailure
and NavigationFailureType
. There are three different types:
aborted
:false
was returned inside of a navigation guard to the navigation.cancelled
: A new navigation took place before the current navigation could finish. e.g.router.push
was called while waiting inside of a navigation guard.duplicated
: The navigation was prevented because we are already at the target location.
Navigation Failures's properties
All navigation failures expose to
and from
properties to reflect the current location as well as the target location for the navigation that failed:
// trying to access the admin page
router.push('/admin').then(failure => {
if (isNavigationFailure(failure, NavigationFailureType.aborted)) {
failure.to.path // '/admin'
failure.from.path // '/'
}
})
In all cases, to
and from
are normalized route locations.
Detecting Redirections
When returning a new location inside of a Navigation Guard, we are triggering a new navigation that overrides the ongoing one. Differently from other return values, a redirection doesn't prevent a navigation, it creates a new one. It is therefore checked differently, by reading the redirectedFrom
property in a Route Location:
await router.push('/my-profile')
if (router.currentRoute.value.redirectedFrom) {
// redirectedFrom is resolved route location like to and from in navigation guards
}hhuh(hh	h}ubh)}(h}(hNh	}(h4https://router.vuejs.org/guide/advanced/typed-routesh
Typed Routes | Vue RouteruhX)  Typed Routes v4.4.0+
DANGER
‼️ Experimental feature
It's possible to configure the router to have a map of typed routes. While this can be done manually, it is recommended to use the unplugin-vue-router plugin to generate the routes and the types automatically.
Manual Configuration
Here is an example of how to manually configure typed routes:
ts
// import the `RouteRecordInfo` type from vue-router to type your routes
import type { RouteRecordInfo } from 'vue-router'
// Define an interface of routes
export interface RouteNamedMap {
// each key is a name
home: RouteRecordInfo<
// here we have the same name
'home',
// this is the path, it will appear in autocompletion
'/',
// these are the raw params. In this case, there are no params allowed
Record<never, never>,
// these are the normalized params
Record<never, never>
>
// repeat for each route..
// Note you can name them whatever you want
'named-param': RouteRecordInfo<
'named-param',
'/:name',
{ name: string | number }, // raw value
{ name: string } // normalized value
>
'article-details': RouteRecordInfo<
'article-details',
'/articles/:id+',
{ id: Array<number | string> },
{ id: string[] }
>
'not-found': RouteRecordInfo<
'not-found',
'/:path(.*)',
{ path: string },
{ path: string }
>
}
// Last, you will need to augment the Vue Router types with this map of routes
declare module 'vue-router' {
interface TypesConfig {
RouteNamedMap: RouteNamedMap
}
}
TIP
This is indeed tedious and error-prone. That's why it's recommended to use unplugin-vue-router to generate the routes and the types automatically.hhuh(hh	h}ubh)}(h}(hNh	}(hhttps://router.vuejs.org/guide/h
Getting Started | Vue RouteruhX  Getting Started
Vue Router is the official client-side routing solution for Vue.
Client-side routing is used by single-page applications (SPAs) to tie the browser URL to the content seen by the user. As users navigate around the application, the URL updates accordingly, but the page doesn't need to be reloaded from the server.
Vue Router is built on Vue's component system. You configure routes to tell Vue Router which components to show for each URL path.
Prerequisites
This guide will assume that you are already familiar with Vue itself. You don't need to be a Vue expert, but you may occasionally need to refer back to the core Vue documentation for more information about certain features.
An example
To introduce some of the main ideas, we're going to consider this example:
Let's start by looking at the root component, App.vue
.
App.vue
<template>
<h1>Hello App!</h1>
<p>
<strong>Current route path:</strong> {{ $route.fullPath }}
</p>
<nav>
<RouterLink to="/">Go to Home</RouterLink>
<RouterLink to="/about">Go to About</RouterLink>
</nav>
<main>
<RouterView />
</main>
</template>
This template is using two components provided by Vue Router, RouterLink
and RouterView
.
Instead of using regular <a>
tags, we use the custom component RouterLink
to create links. This allows Vue Router to change the URL without reloading the page, handle URL generation, encoding, and various other features. We'll go into more detail about RouterLink
in later sections of the guide.
The RouterView
component tells Vue Router where to render the current route component. That's the component that corresponds to the current URL path. It doesn't have to be in App.vue
, you can put it anywhere to adapt it to your layout, but it does need to be included somewhere, otherwise Vue Router won't render anything.
The example above also uses {{ $route.fullPath }}
. You can use $route
in your component templates to access an object that represents the current route.
Creating the router instance
The router instance is created by calling the function createRouter()
:
import { createMemoryHistory, createRouter } from 'vue-router'
import HomeView from './HomeView.vue'
import AboutView from './AboutView.vue'
const routes = [
{ path: '/', component: HomeView },
{ path: '/about', component: AboutView },
]
const router = createRouter({
history: createMemoryHistory(),
routes,
})
The routes
option defines the routes themselves, mapping URL paths to components. The component specified by the component
option is the one that will be rendered by the <RouterView>
in our earlier App.vue
. These route components are sometimes referred to as views, though they are just normal Vue components.
Routes support various other options that we'll see later in the guide, but for now we only need path
and component
.
The history
option controls how routes are mapped onto URLs and vice versa. For the Playground example we're using createMemoryHistory()
, which ignores the browser URL entirely and uses its own internal URL instead. That works well for the Playground, but it's unlikely to be what you'd want in a real application. Typically, you'd want to use createWebHistory()
instead, or perhaps createWebHashHistory()
. We'll cover that topic in more detail in the guide to History modes.
Registering the router plugin
Once we've created our router instance, we need to register it as a plugin by calling use()
on our application:
createApp(App)
.use(router)
.mount('#app')
Or, equivalently:
const app = createApp(App)
app.use(router)
app.mount('#app')
Like with most Vue plugins, the call to use()
needs to happen before the call to mount()
.
If you're curious about what this plugin does, some of its responsibilities include:
- Globally registering the
RouterView
andRouterLink
components. - Adding the global
$router
and$route
properties. - Enabling the
useRouter()
anduseRoute()
composables. - Triggering the router to resolve the initial route.
Accessing the router and current route
You'll likely want to access the router from elsewhere in your application.
If you're exporting the router instance from an ES module, you could import the router instance directly where you need it. In some cases this is the best approach, but we have other options if we're inside a component.
In component templates, the router instance is exposed as $router
. This is similar to the $route
property we saw earlier, but note the extra r
on the end.
If we're using the Options API, we can access these same two properties as this.$router
and this.$route
in our JavaScript code. The HomeView.vue
component in the Playground example accesses the router that way:
export default {
methods: {
goToAbout() {
this.$router.push('/about')
},
},
}
This method is calling push()
, which is used for programmatic navigation. We'll learn more about that later.
With the Composition API, we don't have access to the component instance via this
, so Vue Router includes some composables that we can use instead. AboutView.vue
in the Playground example is using that approach:
<script setup>
import { computed } from 'vue'
import { useRoute, useRouter } from 'vue-router'
const router = useRouter()
const route = useRoute()
const search = computed({
get() {
return route.query.search ?? ''
},
set(search) {
router.replace({ query: { search } })
}
})
</script>
It's not necessary to understand all of that code right now. The key thing to notice is that the composables useRouter()
and useRoute()
are used to access the router instance and current route respectively.
Next steps
If you'd like to see a complete example using Vite, you can use the create-vue scaffolding tool, which has the option to include Vue Router in its example project:
npm create vue@latest
yarn create vue
pnpm create vue
The example project created by create-vue uses similar features to the ones we've seen here. You may find that a useful starting point for exploring the features introduced in the next few pages of this guide.
Conventions in this guide
Single-File Components
Vue Router is most commonly used in applications built using a bundler (e.g. Vite) and SFCs (i.e. .vue
files). Most of the examples in this guide will be written in that style, but Vue Router itself doesn't require you to use build tools or SFCs.
For example, if you're using the global builds of Vue and Vue Router, the libraries are exposed via global objects, rather than imports:
const { createApp } = Vue
const { createRouter, createWebHistory } = VueRouter
Component API style
Vue Router can be used with both the Composition API and the Options API. Where relevant, the examples in this guide will show components written in both styles. Composition API examples will typically use <script setup>
, rather than an explicit setup
function.
If you need a refresher about the two styles, see Vue - API Styles.
router
and route
Throughout the guide, we will often refer to the router instance as router
. This is the object returned by createRouter()
. How you access that object in your application will depend on the context. For example, in a component using the Composition API, it can be accessed by calling useRouter()
. With the Options API, it can be accessed using this.$router
.
Similarly, the current route will be referred to as route
. It can be accessed in components using useRoute()
or this.$route
, depending on which API the component is using.
RouterView
and RouterLink
The components RouterView
and RouterLink
are both registered globally, so they don't need to be imported before using them in component templates. However, if you prefer, you can import them locally, e.g. import { RouterLink } from 'vue-router'
.
In templates, component names can be written in either PascalCase or kebab-case. Vue's template compiler supports either format, so <RouterView>
and <router-view>
are usually equivalent. You should follow whatever convention is used within your project.
If you're using in-DOM templates then the usual caveats apply: component names must be written in kebab-case and self-closing tags are not supported. So rather than writing <RouterView />
, you would need to use <router-view></router-view>
instead.hhuh(hh	h}ubh)}(h}(hNh	}(h<https://router.vuejs.org/guide/essentials/redirect-and-aliash
Redirect and Alias | Vue RouteruhX
  Redirect and Alias
Redirect
Redirecting is also done in the routes
configuration. To redirect from /home
to /
:
const routes = [{ path: '/home', redirect: '/' }]
The redirect can also be targeting a named route:
const routes = [{ path: '/home', redirect: { name: 'homepage' } }]
Or even use a function for dynamic redirecting:
const routes = [
{
// /search/screens -> /search?q=screens
path: '/search/:searchText',
redirect: to => {
// the function receives the target route as the argument
// we return a redirect path/location here.
return { path: '/search', query: { q: to.params.searchText } }
},
},
{
path: '/search',
// ...
},
]
Note that Navigation Guards are not applied on the route that redirects, only on its target. e.g. In the above example, adding a beforeEnter
guard to the /home
route would not have any effect.
When writing a redirect
, you can omit the component
option because it is never directly reached so there is no component to render. The only exception are nested routes: if a route record has children
and a redirect
property, it should also have a component
property.
Relative redirecting
It's also possible to redirect to a relative location:
const routes = [
{
// will always redirect /users/123/posts to /users/123/profile
path: '/users/:id/posts',
redirect: to => {
// the function receives the target route as the argument
// a relative location doesn't start with `/`
// or { path: 'profile'}
return 'profile'
},
},
]
Alias
A redirect means when the user visits /home
, the URL will be replaced by /
, and then matched as /
. But what is an alias?
An alias of /
as /home
means when the user visits /home
, the URL remains /home
, but it will be matched as if the user is visiting /
.
The above can be expressed in the route configuration as:
const routes = [{ path: '/', component: Homepage, alias: '/home' }]
An alias gives you the freedom to map a UI structure to an arbitrary URL, instead of being constrained by the configuration's nesting structure. Make the alias start with a /
to make the path absolute in nested routes. You can even combine both and provide multiple aliases with an array:
const routes = [
{
path: '/users',
component: UsersLayout,
children: [
// this will render the UserList for these 3 URLs
// - /users
// - /users/list
// - /people
{ path: '', component: UserList, alias: ['/people', 'list'] },
],
},
]
If your route has parameters, make sure to include them in any absolute alias:
const routes = [
{
path: '/users/:id',
component: UsersByIdLayout,
children: [
// this will render the UserDetails for these 3 URLs
// - /users/24
// - /users/24/profile
// - /24
{ path: 'profile', component: UserDetails, alias: ['/:id', ''] },
],
},
]
Note about SEO: when using aliases, make sure to define canonical links.hhuh(hh	h}ubh)}(h}(hNh	}(h,https://router.vuejs.org/guide/advanced/metah
Route Meta Fields | Vue RouteruhX	  Route Meta Fields
Sometimes, you might want to attach arbitrary information to routes like： transition names, or roles to control who can access the route, etc. This can be achieved through the meta
property which accepts an object of properties and can be accessed on the route location and navigation guards. You can define meta
properties like this:
const routes = [
{
path: '/posts',
component: PostsLayout,
children: [
{
path: 'new',
component: PostsNew,
// only authenticated users can create posts
meta: { requiresAuth: true },
},
{
path: ':id',
component: PostsDetail,
// anybody can read a post
meta: { requiresAuth: false },
},
],
},
]
So how do we access this meta
field?
First, each route object in the routes
configuration is called a route record. Route records may be nested. Therefore when a route is matched, it can potentially match more than one route record.
For example, with the above route config, the URL /posts/new
will match both the parent route record (path: '/posts'
) and the child route record (path: 'new'
).
All route records matched by a route are exposed on the route
object (and also route objects in navigation guards) as the route.matched
Array. We could loop through that array to check all meta
fields, but Vue Router also provides you a route.meta
that is a non-recursive merge of all meta
fields from parent to child. Meaning you can simply write:
router.beforeEach((to, from) => {
// instead of having to check every route record with
// to.matched.some(record => record.meta.requiresAuth)
if (to.meta.requiresAuth && !auth.isLoggedIn()) {
// this route requires auth, check if logged in
// if not, redirect to login page.
return {
path: '/login',
// save the location we were at to come back later
query: { redirect: to.fullPath },
}
}
})
TypeScript
It is possible to type the meta field by extending the RouteMeta
interface from vue-router
:
// This can be directly added to any of your `.ts` files like `router.ts`
// It can also be added to a `.d.ts` file. Make sure it's included in
// project's tsconfig.json "files"
import 'vue-router'
// To ensure it is treated as a module, add at least one `export` statement
export {}
declare module 'vue-router' {
interface RouteMeta {
// is optional
isAdmin?: boolean
// must be declared by every route
requiresAuth: boolean
}
}hhuh(hh	h}ubh)}(h}(hNh	}(h4https://router.vuejs.org/guide/advanced/lazy-loadingh
 Lazy Loading Routes | Vue RouteruhX	  Lazy Loading Routes
When building apps with a bundler, the JavaScript bundle can become quite large, and thus affect the page load time. It would be more efficient if we can split each route's components into separate chunks, and only load them when the route is visited.
Vue Router supports dynamic imports out of the box, meaning you can replace static imports with dynamic ones:
// replace
// import UserDetails from './views/UserDetails'
// with
const UserDetails = () => import('./views/UserDetails.vue')
const router = createRouter({
// ...
routes: [
{ path: '/users/:id', component: UserDetails }
// or use it directly in the route definition
{ path: '/users/:id', component: () => import('./views/UserDetails.vue') },
],
})
The component
(and components
) option accepts a function that returns a Promise of a component and Vue Router will only fetch it when entering the page for the first time, then use the cached version. Which means you can also have more complex functions as long as they return a Promise:
const UserDetails = () =>
Promise.resolve({
/* component definition */
})
In general, it's a good idea to always use dynamic imports for all your routes.
Note
Do not use Async components for routes. Async components can still be used inside route components but route component themselves are just dynamic imports.
When using a bundler like webpack, this will automatically benefit from code splitting
When using Babel, you will need to add the syntax-dynamic-import plugin so that Babel can properly parse the syntax.
Grouping Components in the Same Chunk
With webpack
Sometimes we may want to group all the components nested under the same route into the same async chunk. To achieve that we need to use named chunks by providing a chunk name using a special comment syntax (requires webpack > 2.4):
const UserDetails = () =>
import(/* webpackChunkName: "group-user" */ './UserDetails.vue')
const UserDashboard = () =>
import(/* webpackChunkName: "group-user" */ './UserDashboard.vue')
const UserProfileEdit = () =>
import(/* webpackChunkName: "group-user" */ './UserProfileEdit.vue')
webpack will group any async module with the same chunk name into the same async chunk.
With Vite
In Vite you can define the chunks under the rollupOptions
:
// vite.config.js
export default defineConfig({
build: {
rollupOptions: {
// https://rollupjs.org/guide/en/#outputmanualchunks
output: {
manualChunks: {
'group-user': [
'./src/UserDetails',
'./src/UserDashboard',
'./src/UserProfileEdit',
],
},
},
},
},
})hhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/guide/essentials/passing-propsh
.Passing Props to Route Components | Vue RouteruhXk
  Passing Props to Route Components
Using $route
or useRoute()
in your component creates a tight coupling with the route which limits the flexibility of the component as it can only be used on certain URLs. While this is not necessarily a bad thing, we can decouple this behavior with a props
option.
Let's return to our earlier example:
<!-- User.vue -->
<template>
<div>
User {{ $route.params.id }}
</div>
</template>
with:
import User from './User.vue'
// these are passed to `createRouter`
const routes = [
{ path: '/users/:id', component: User },
]
We can remove the direct dependency on $route
in User.vue
by declaring a prop instead:
<!-- User.vue -->
<script setup>
defineProps({
id: String
})
</script>
<template>
<div>
User {{ id }}
</div>
</template>
<!-- User.vue -->
<script>
export default {
props: {
id: String
}
}
</script>
<template>
<div>
User {{ id }}
</div>
</template>
We can then configure the route to pass the id
param as a prop by setting props: true
:
const routes = [
{ path: '/user/:id', component: User, props: true }
]
This allows you to use the component anywhere, which makes the component easier to reuse and test.
Boolean mode
When props
is set to true
, the route.params
will be set as the component props.
Named views
For routes with named views, you have to define the props
option for each named view:
const routes = [
{
path: '/user/:id',
components: { default: User, sidebar: Sidebar },
props: { default: true, sidebar: false }
}
]
Object mode
When props
is an object, this will be set as the component props as-is. Useful for when the props are static.
const routes = [
{
path: '/promotion/from-newsletter',
component: Promotion,
props: { newsletterPopup: false }
}
]
Function mode
You can create a function that returns props. This allows you to cast parameters into other types, combine static values with route-based values, etc.
const routes = [
{
path: '/search',
component: SearchUser,
props: route => ({ query: route.query.q })
}
]
The URL /search?q=vue
would pass {query: 'vue'}
as props to the SearchUser
component.
Try to keep the props
function stateless, as it's only evaluated on route changes. Use a wrapper component if you need state to define the props, that way Vue can react to state changes.
Via RouterView
You can also pass any props via the <RouterView>
slot:
<RouterView v-slot="{ Component }">
<component
:is="Component"
view-prop="value"
/>
</RouterView>
WARNING
In this case, all view components will receive view-prop
. This is usually not a good idea as it means that all of the view components have declared a view-prop
prop, which is not necessarily true. If possible, use any of the options above.hhuh(hh	h}ubh)}(h}(hNh	}(h6https://router.vuejs.org/guide/essentials/active-linksh
Active links | Vue RouteruhX`	  Active links
It's common for applications to have a navigation component that renders a list of RouterLink components. Within that list, we might want to style links to the currently active route differently from the others.
The RouterLink component adds two CSS classes to active links, router-link-active
and router-link-exact-active
. To understand the difference between them, we first need to consider how Vue Router decides that a link is active.
When are links active?
A RouterLink is considered to be active if:
- It matches the same route record (i.e. configured route) as the current location.
- It has the same values for the
params
as the current location.
If you're using nested routes, any links to ancestor routes will also be considered active if the relevant params
match.
Other route properties, such as the query
, are not taken into account.
The path doesn't necessarily need to be a perfect match. For example, using an alias
would still be considered a match, so long as it resolves to the same route record and params
.
If a route has a redirect
, it won't be followed when checking whether a link is active.
Exact active links
An exact match does not include ancestor routes.
Let's imagine we have the following routes:
const routes = [
{
path: '/user/:username',
component: User,
children: [
{
path: 'role/:roleId',
component: Role,
},
],
},
]
Then consider these two links:
<RouterLink to="/user/erina">
User
</RouterLink>
<RouterLink to="/user/erina/role/admin">
Role
</RouterLink>
If the current location path is /user/erina/role/admin
then these would both be considered active, so the class router-link-active
would be applied to both links. But only the second link would be considered exact, so only that second link would have the class router-link-exact-active
.
Configuring the classes
The RouterLink component has two props, activeClass
and exactActiveClass
, that can be used to change the names of the classes that are applied:
<RouterLink
activeClass="border-indigo-500"
exactActiveClass="border-indigo-700"
...
>
The default class names can also be changed globally by passing the linkActiveClass
and linkExactActiveClass
options to createRouter()
:
const router = createRouter({
linkActiveClass: 'border-indigo-500',
linkExactActiveClass: 'border-indigo-700',
// ...
})
See Extending RouterLink for more advanced customization techniques using the v-slot
API.hhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/guide/advanced/scroll-behaviorh
Scroll Behavior | Vue RouteruhXw  Scroll Behavior
When using client-side routing, we may want to scroll to top when navigating to a new route, or preserve the scrolling position of history entries just like real page reload does. Vue Router allows you to achieve these and even better, allows you to completely customize the scroll behavior on route navigation.
Note: this feature only works if the browser supports history.pushState
.
When creating the router instance, you can provide the scrollBehavior
function:
const router = createRouter({
history: createWebHashHistory(),
routes: [...],
scrollBehavior (to, from, savedPosition) {
// return desired position
}
})
The scrollBehavior
function receives the to
and from
route objects, like Navigation Guards. The third argument, savedPosition
, is only available if this is a popstate
navigation (triggered by the browser's back/forward buttons).
The function can return a ScrollToOptions
position object:
const router = createRouter({
scrollBehavior(to, from, savedPosition) {
// always scroll to top
return { top: 0 }
},
})
You can also pass a CSS selector or a DOM element via el
. In that scenario, top
and left
will be treated as relative offsets to that element.
const router = createRouter({
scrollBehavior(to, from, savedPosition) {
// always scroll 10px above the element #main
return {
// could also be
// el: document.getElementById('main'),
el: '#main',
// 10px above the element
top: 10,
}
},
})
If a falsy value or an empty object is returned, no scrolling will happen.
Returning the savedPosition
will result in a native-like behavior when navigating with back/forward buttons:
const router = createRouter({
scrollBehavior(to, from, savedPosition) {
if (savedPosition) {
return savedPosition
} else {
return { top: 0 }
}
},
})
If you want to simulate the "scroll to anchor" behavior:
const router = createRouter({
scrollBehavior(to, from, savedPosition) {
if (to.hash) {
return {
el: to.hash,
}
}
},
})
If your browser supports scroll behavior, you can make it smooth:
const router = createRouter({
scrollBehavior(to, from, savedPosition) {
if (to.hash) {
return {
el: to.hash,
behavior: 'smooth',
}
}
}
})
Delaying the scroll
Sometimes we need to wait a bit before scrolling in the page. For example, when dealing with transitions, we want to wait for the transition to finish before scrolling. To do this you can return a Promise that returns the desired position descriptor. Here is an example where we wait 500ms before scrolling:
const router = createRouter({
scrollBehavior(to, from, savedPosition) {
return new Promise((resolve, reject) => {
setTimeout(() => {
resolve({ left: 0, top: 0 })
}, 500)
})
},
})
It's possible to hook this up with events from a page-level transition component to make the scroll behavior play nicely with your page transitions, but due to the possible variance and complexity in use cases, we simply provide this primitive to enable specific userland implementations.hhuh(hh	h}ubh)}(h}(hNh	}(h)https://router.vuejs.org/guide/migration/h
!Migrating from Vue 2 | Vue RouteruhXA  Migrating from Vue 2
Most of Vue Router API has remained unchanged during its rewrite from v3 (for Vue 2) to v4 (for Vue 3) but there are still a few breaking changes that you might encounter while migrating your application. This guide is here to help you understand why these changes happened and how to adapt your application to make it work with Vue Router 4.
Breaking Changes
Changes are ordered by their usage. It is therefore recommended to follow this list in order.
new Router becomes createRouter
Vue Router is no longer a class but a set of functions. Instead of writing new Router()
, you now have to call createRouter
:
// previously was
// import Router from 'vue-router'
import { createRouter } from 'vue-router'
const router = createRouter({
// ...
})
New history
option to replace mode
The mode: 'history'
option has been replaced with a more flexible one named history
. Depending on which mode you were using, you will have to replace it with the appropriate function:
"history"
:createWebHistory()
"hash"
:createWebHashHistory()
"abstract"
:createMemoryHistory()
Here is a full snippet:
import { createRouter, createWebHistory } from 'vue-router'
// there is also createWebHashHistory and createMemoryHistory
createRouter({
history: createWebHistory(),
routes: [],
})
On SSR, you need to manually pass the appropriate history:
// router.js
let history = isServer ? createMemoryHistory() : createWebHistory()
let router = createRouter({ routes, history })
// somewhere in your server-entry.js
router.push(req.url) // request url
router.isReady().then(() => {
// resolve the request
})
Reason: enable tree shaking of non used histories as well as implementing custom histories for advanced use cases like native solutions.
Moved the base
option
The base
option is now passed as the first argument to createWebHistory
(and other histories):
import { createRouter, createWebHistory } from 'vue-router'
createRouter({
history: createWebHistory('/base-directory/'),
routes: [],
})
Removal of the fallback
option
The fallback
option is no longer supported when creating the router:
-new VueRouter({
+createRouter({
- fallback: false,
// other options...
})
Reason: All browsers supported by Vue support the HTML5 History API, allowing us to avoid hacks around modifying location.hash
and directly use history.pushState()
.
Removed *
(star or catch all) routes
Catch all routes (*
, /*
) must now be defined using a parameter with a custom regex:
const routes = [
// pathMatch is the name of the param, e.g., going to /not/found yields
// { params: { pathMatch: ['not', 'found'] }}
// this is thanks to the last *, meaning repeated params and it is necessary if you
// plan on directly navigating to the not-found route using its name
{ path: '/:pathMatch(.*)*', name: 'not-found', component: NotFound },
// if you omit the last `*`, the `/` character in params will be encoded when resolving or pushing
{ path: '/:pathMatch(.*)', name: 'bad-not-found', component: NotFound },
]
// bad example if using named routes:
router.resolve({
name: 'bad-not-found',
params: { pathMatch: 'not/found' },
}).href // '/not%2Ffound'
// good example:
router.resolve({
name: 'not-found',
params: { pathMatch: ['not', 'found'] },
}).href // '/not/found'
TIP
You don't need to add the *
for repeated params if you don't plan to directly push to the not found route using its name. If you call router.push('/not/found/url')
, it will provide the right pathMatch
param.
Reason: Vue Router doesn't use path-to-regexp
anymore, instead it implements its own parsing system that allows route ranking and enables dynamic routing. Since we usually add one single catch-all route per project, there is no big benefit in supporting a special syntax for *
. The encoding of params is encoding across routes, without exception to make things easier to predict.
The currentRoute
property is now a ref()
Previously the properties of the currentRoute
object on a router instance could be accessed directly.
With the introduction of vue-router v4, the underlying type of the currentRoute
object on the router instance has changed to Ref<RouteLocationNormalizedLoaded>
, which comes from the newer reactivity fundamentals introduced in Vue 3.
While this doesn't change anything if you're reading the route with useRoute()
or this.$route
, if you're accessing it directly on the router instance, you will need to access the actual route object via currentRoute.value
:
const { page } = router.currentRoute.query
const { page } = router.currentRoute.value.query
Replaced onReady
with isReady
The existing router.onReady()
function has been replaced with router.isReady()
which doesn't take any argument and returns a Promise:
// replace
router.onReady(onSuccess, onError)
// with
router.isReady().then(onSuccess).catch(onError)
// or use await:
try {
await router.isReady()
// onSuccess
} catch (err) {
// onError
}
scrollBehavior
changes
The object returned in scrollBehavior
is now similar to ScrollToOptions
: x
is renamed to left
and y
is renamed to top
. See RFC.
Reason: making the object similar to ScrollToOptions
to make it feel more familiar with native JS APIs and potentially enable future new options.
<router-view>
, <keep-alive>
, and <transition>
transition
and keep-alive
must now be used inside of RouterView
via the v-slot
API:
<router-view v-slot="{ Component }">
<transition>
<keep-alive>
<component :is="Component" />
</keep-alive>
</transition>
</router-view>
Reason: This was a necessary change. See the related RFC.
Removal of append
prop in <router-link>
The append
prop has been removed from <router-link>
. You can manually concatenate the value to an existing path
instead:
replace
<router-link to="child-route" append>to relative child</router-link>
with
<router-link :to="append($route.path, 'child-route')">
to relative child
</router-link>
You must define a global append
function on your App instance:
app.config.globalProperties.append = (path, pathToAppend) =>
path + (path.endsWith('/') ? '' : '/') + pathToAppend
Reason: append
wasn't used very often, is easy to replicate in user land.
Removal of event
and tag
props in <router-link>
Both event
, and tag
props have been removed from <router-link>
. You can use the v-slot
API to fully customize <router-link>
:
replace
<router-link to="/about" tag="span" event="dblclick">About Us</router-link>
with
<router-link to="/about" custom v-slot="{ navigate }">
<span @click="navigate" @keypress.enter="navigate" role="link">About Us</span>
</router-link>
Reason: These props were often used together to use something different from an <a>
tag but were introduced before the v-slot
API and are not used enough to justify adding to the bundle size for everybody.
Removal of the exact
prop in <router-link>
The exact
prop has been removed because the caveat it was fixing is no longer present so you should be able to safely remove it. There are however two things you should be aware of:
- Routes are now active based on the route records they represent instead of the generated route location objects and their
path
,query
, andhash
properties - Only the
path
section is matched,query
, andhash
aren't taken into account anymore
If you wish to customize this behavior, e.g. take into account the hash
section, you should use the v-slot
API to extend <router-link>
.
Reason: See the RFC about active matching changes for more details.
Navigation guards in mixins are ignored
At the moment navigation guards in mixins are not supported. You can track its support at vue-router#454.
Removal of router.match
and changes to router.resolve
Both router.match
, and router.resolve
have been merged together into router.resolve
with a slightly different signature. Refer to the API for more details.
Reason: Uniting multiple methods that were used for the same purpose.
Removal of router.getMatchedComponents()
The method router.getMatchedComponents
is now removed as matched components can be retrieved from router.currentRoute.value.matched
:
router.currentRoute.value.matched.flatMap(record =>
Object.values(record.components)
)
Reason: This method was only used during SSR and is a one liner that can be done by the user.
Redirect records cannot use special paths
Previously, a non documented feature allowed to set a redirect record to a special path like /events/:id
and it would reuse an existing param id
. This is no longer possible and there are two options:
- Using the name of the route without the param:
redirect: { name: 'events' }
. Note this won't work if the param:id
is optional - Using a function to recreate the new location based on the target:
redirect: to => ({ name: 'events', params: to.params })
Reason: This syntax was rarely used and another way of doing things that wasn't shorter enough compared to the versions above while introducing some complexity and making the router heavier.
All navigations are now always asynchronous
All navigations, including the first one, are now asynchronous, meaning that, if you use a transition
, you may need to wait for the router to be ready before mounting the app:
app.use(router)
// Note: on Server Side, you need to manually push the initial location
router.isReady().then(() => app.mount('#app'))
Otherwise there will be an initial transition as if you provided the appear
prop to transition
because the router displays its initial location (nothing) and then displays the first location.
Note that if you have navigation guards upon the initial navigation, you might not want to block the app render until they are resolved unless you are doing Server Side Rendering. In this scenario, not waiting the router to be ready to mount the app would yield the same result as in Vue 2.
Removal of router.app
router.app
used to represent the last root component (Vue instance) that injected the router. Vue Router can now be safely used by multiple Vue applications at the same time. You can still add it when using the router:
app.use(router)
router.app = app
You can also extend the TypeScript definition of the Router
interface to add the app
property.
Reason: Vue 3 applications do not exist in Vue 2 and now we properly support multiple applications using the same Router instance, so having an app
property would have been misleading because it would have been the application instead of the root instance.
Passing content to route components' <slot>
Before you could directly pass a template to be rendered by a route components' <slot>
by nesting it under a <router-view>
component:
<router-view>
<p>In Vue Router 3, I render inside the route component</p>
</router-view>
Because of the introduction of the v-slot
api for <router-view>
, you must pass it to the <component>
using the v-slot
API:
<router-view v-slot="{ Component }">
<component :is="Component">
<p>In Vue Router 3, I render inside the route component</p>
</component>
</router-view>
Removal of parent
from route locations
The parent
property has been removed from normalized route locations (this.$route
and object returned by router.resolve
). You can still access it via the matched
array:
const parent = this.$route.matched[this.$route.matched.length - 2]
Reason: Having parent
and children
creates unnecessary circular references while the properties could be retrieved already through matched
.
Removal of pathToRegexpOptions
The pathToRegexpOptions
and caseSensitive
properties of route records have been replaced with sensitive
and strict
options for createRouter()
. They can now also be directly passed when creating the router with createRouter()
. Any other option specific to path-to-regexp
has been removed as path-to-regexp
is no longer used to parse paths.
Removal of unnamed parameters
Due to the removal of path-to-regexp
, unnamed parameters are no longer supported:
/foo(/foo)?/suffix
becomes/foo/:_(foo)?/suffix
/foo(foo)?
becomes/foo:_(foo)?
/foo/(.*)
becomes/foo/:_(.*)
TIP
Note you can use any name instead of _
for the param. The point is to provide one.
Usage of history.state
Vue Router saves information on the history.state
. If you have any code manually calling history.pushState()
, you should likely avoid it or refactor it with a regular router.push()
and a history.replaceState()
:
// replace
history.pushState(myState, '', url)
// with
await router.push(url)
history.replaceState({ ...history.state, ...myState }, '')
Similarly, if you were calling history.replaceState()
without preserving the current state, you will need to pass the current history.state
:
// replace
history.replaceState({}, '', url)
// with
history.replaceState(history.state, '', url)
Reason: We use the history state to save information about the navigation like the scroll position, previous location, etc.
routes
option is required in options
The property routes
is now required in options
.
createRouter({ routes: [] })
Reason: The router is designed to be created with routes even though you can add them later on. You need at least one route in most scenarios and this is written once per app in general.
Non existent named routes
Pushing or resolving a non existent named route throws an error:
// Oops, we made a typo in name
router.push({ name: 'homee' }) // throws
router.resolve({ name: 'homee' }) // throws
Reason: Previously, the router would navigate to /
but display nothing (instead of the home page). Throwing an error makes more sense because we cannot produce a valid URL to navigate to.
Missing required params
on named routes
Pushing or resolving a named route without its required params will throw an error:
// given the following route:
const routes = [{ path: '/users/:id', name: 'user', component: UserDetails }]
// Missing the `id` param will fail
router.push({ name: 'user' })
router.resolve({ name: 'user' })
Reason: Same as above.
Named children routes with an empty path
no longer appends a slash
Given any nested named route with an empty path
:
const routes = [
{
path: '/dashboard',
name: 'dashboard-parent',
component: DashboardParent,
children: [
{ path: '', name: 'dashboard', component: DashboardDefault },
{
path: 'settings',
name: 'dashboard-settings',
component: DashboardSettings,
},
],
},
]
Navigating or resolving to the named route dashboard
will now produce a URL without a trailing slash:
router.resolve({ name: 'dashboard' }).href // '/dashboard'
This has an important side effect about children redirect
records like these:
const routes = [
{
path: '/parent',
component: Parent,
children: [
// this would now redirect to `/home` instead of `/parent/home`
{ path: '', redirect: 'home' },
{ path: 'home', component: Home },
],
},
]
Note this will work if path
was /parent/
as the relative location home
to /parent/
is indeed /parent/home
but the relative location of home
to /parent
is /home
.
Reason: This is to make trailing slash behavior consistent: by default all routes allow a trailing slash. It can be disabled by using the strict
option and manually appending (or not) a slash to the routes.
$route
properties Encoding
Decoded values in params
, query
, and hash
are now consistent no matter where the navigation is initiated (older browsers will still produce unencoded path
and fullPath
). The initial navigation should yield the same results as in-app navigations.
Given any normalized route location:
- Values in
path
,fullPath
are not decoded anymore. They will appear as provided by the browser (most browsers provide them encoded). e.g. directly writing on the address barhttps://example.com/hello world
will yield the encoded version:https://example.com/hello%20world
and bothpath
andfullPath
will be/hello%20world
. hash
is now decoded, that way it can be copied over:router.push({ hash: $route.hash })
and be used directly in scrollBehavior'sel
option.- When using
push
,resolve
, andreplace
and providing astring
location or apath
property in an object, it must be encoded (like in the previous version). On the other hand,params
,query
andhash
must be provided in its unencoded version. - The slash character (
/
) is now properly decoded insideparams
while still producing an encoded version on the URL:%2F
.
Reason: This allows to easily copy existing properties of a location when calling router.push()
and router.resolve()
, and make the resulting route location consistent across browsers. router.push()
is now idempotent, meaning that calling router.push(route.fullPath)
, router.push({ hash: route.hash })
, router.push({ query: route.query })
, and router.push({ params: route.params })
will not create extra encoding.
TypeScript changes
To make typings more consistent and expressive, some types have been renamed:
vue-router@3 | vue-router@4 |
---|---|
RouteConfig | RouteRecordRaw |
Location | RouteLocation |
Route | RouteLocationNormalized |
New Features
Some of new features to keep an eye on in Vue Router 4 include:hhuh(hh	h}ubh)}(h}(hNh	}(h:https://router.vuejs.org/guide/essentials/dynamic-matchingh
/Dynamic Route Matching with Params | Vue RouteruhX!  Dynamic Route Matching with Params
Very often we will need to map routes with the given pattern to the same component. For example, we may have a User
component which should be rendered for all users but with different user IDs. In Vue Router we can use a dynamic segment in the path to achieve that, we call that a param:
import User from './User.vue'
// these are passed to `createRouter`
const routes = [
// dynamic segments start with a colon
{ path: '/users/:id', component: User },
]
Now URLs like /users/johnny
and /users/jolyne
will both map to the same route.
A param is denoted by a colon :
. When a route is matched, the value of its params will be exposed as route.params
in every component. Therefore, we can render the current user ID by updating User
's template to this:
<template>
<div>
<!-- The current route is accessible as $route in the template -->
User {{ $route.params.id }}
</div>
</template>
You can have multiple params in the same route, and they will map to corresponding fields on route.params
. Examples:
pattern | matched path | route.params |
---|---|---|
/users/:username | /users/eduardo | { username: 'eduardo' } |
/users/:username/posts/:postId | /users/eduardo/posts/123 | { username: 'eduardo', postId: '123' } |
In addition to route.params
, the route
object also exposes other useful information such as route.query
(if there is a query in the URL), route.hash
, etc. You can check out the full details in the API Reference.
A working demo of this example can be found here.
Reacting to Params Changes
One thing to note when using routes with params is that when the user navigates from /users/johnny
to /users/jolyne
, the same component instance will be reused. Since both routes render the same component, this is more efficient than destroying the old instance and then creating a new one. However, this also means that the lifecycle hooks of the component will not be called.
To react to params changes in the same component, you can simply watch anything on the route
object, in this scenario, the route.params
:
<script setup>
import { watch } from 'vue'
import { useRoute } from 'vue-router'
const route = useRoute()
watch(
() => route.params.id,
(newId, oldId) => {
// react to route changes...
}
)
</script>
<script>
export default {
created() {
this.$watch(
() => this.$route.params.id,
(newId, oldId) => {
// react to route changes...
}
)
},
}
</script>
Or, use the beforeRouteUpdate
navigation guard, which also allows you to cancel the navigation:
<script setup>
import { onBeforeRouteUpdate } from 'vue-router'
// ...
onBeforeRouteUpdate(async (to, from) => {
// react to route changes...
userData.value = await fetchUser(to.params.id)
})
</script>
<script>
export default {
async beforeRouteUpdate(to, from) {
// react to route changes...
this.userData = await fetchUser(to.params.id)
},
// ...
}
</script>
Catch all / 404 Not found Route
Regular params will only match characters in between url fragments, separated by /
. If we want to match anything, we can use a custom param regexp by adding the regexp inside parentheses right after the param:
const routes = [
// will match everything and put it under `route.params.pathMatch`
{ path: '/:pathMatch(.*)*', name: 'NotFound', component: NotFound },
// will match anything starting with `/user-` and put it under `route.params.afterUser`
{ path: '/user-:afterUser(.*)', component: UserGeneric },
]
In this specific scenario, we are using a custom regexp between parentheses and marking the pathMatch
param as optionally repeatable. This allows us to directly navigate to the route if we need to by splitting the path
into an array:
router.push({
name: 'NotFound',
// preserve current path and remove the first char to avoid the target URL starting with `//`
params: { pathMatch: route.path.substring(1).split('/') },
// preserve existing query and hash if any
query: route.query,
hash: route.hash,
})
See more in the repeated params section.
If you are using History mode, make sure to follow the instructions to correctly configure your server as well.
Advanced Matching Patterns
Vue Router uses its own path matching syntax, inspired by the one used by express
, so it supports many advanced matching patterns such as optional params, zero or more / one or more requirements, and even custom regex patterns. Please check the Advanced Matching documentation to explore them.hhuh(hh	h}ubh)}(h}(hNh	}(h9https://router.vuejs.org/guide/advanced/navigation-guardsh
Navigation Guards | Vue RouteruhX!'  Navigation Guards
As the name suggests, the navigation guards provided by Vue router are primarily used to guard navigations either by redirecting it or canceling it. There are a number of ways to hook into the route navigation process: globally, per-route, or in-component.
Global Before Guards
You can register global before guards using router.beforeEach
:
const router = createRouter({ ... })
router.beforeEach((to, from) => {
// ...
// explicitly return false to cancel the navigation
return false
})
Global before guards are called in creation order, whenever a navigation is triggered. Guards may be resolved asynchronously, and the navigation is considered pending before all hooks have been resolved.
Every guard function receives two arguments:
to
: the target route location in a normalized format being navigated to.from
: the current route location in a normalized format being navigated away from.
And can optionally return any of the following values:
false
: cancel the current navigation. If the browser URL was changed (either manually by the user or via back button), it will be reset to that of thefrom
route.A Route Location: Redirect to a different location by passing a route location as if you were calling
router.push()
, which allows you to pass options likereplace: true
orname: 'home'
. The current navigation is dropped and a new one is created with the samefrom
.jsrouter.beforeEach(async (to, from) => { if ( // make sure the user is authenticated !isAuthenticated && // ❗️ Avoid an infinite redirect to.name !== 'Login' ) { // redirect the user to the login page return { name: 'Login' } } })
It's also possible to throw an Error
if an unexpected situation was met. This will also cancel the navigation and call any callback registered via router.onError()
.
If nothing, undefined
or true
is returned, the navigation is validated, and the next navigation guard is called.
All of the things above work the same way with async
functions and Promises:
router.beforeEach(async (to, from) => {
// canUserAccess() returns `true` or `false`
const canAccess = await canUserAccess(to)
if (!canAccess) return '/login'
})
Optional third argument next
In previous versions of Vue Router, it was also possible to use a third argument next
, this was a common source of mistakes and went through an RFC to remove it. However, it is still supported, meaning you can pass a third argument to any navigation guard. In that case, you must call next
exactly once in any given pass through a navigation guard. It can appear more than once, but only if the logical paths have no overlap, otherwise the hook will never be resolved or produce errors. Here is a bad example of redirecting the user to /login
if they are not authenticated:
// BAD
router.beforeEach((to, from, next) => {
if (to.name !== 'Login' && !isAuthenticated) next({ name: 'Login' })
// if the user is not authenticated, `next` is called twice
next()
})
Here is the correct version:
// GOOD
router.beforeEach((to, from, next) => {
if (to.name !== 'Login' && !isAuthenticated) next({ name: 'Login' })
else next()
})
Global Resolve Guards
You can register a global guard with router.beforeResolve
. This is similar to router.beforeEach
because it triggers on every navigation, but resolve guards are called right before the navigation is confirmed, after all in-component guards and async route components are resolved. Here is an example that ensures the user has given access to the Camera for routes that have defined a custom meta property requiresCamera
:
router.beforeResolve(async to => {
if (to.meta.requiresCamera) {
try {
await askForCameraPermission()
} catch (error) {
if (error instanceof NotAllowedError) {
// ... handle the error and then cancel the navigation
return false
} else {
// unexpected error, cancel the navigation and pass the error to the global handler
throw error
}
}
}
})
router.beforeResolve
is the ideal spot to fetch data or do any other operation that you want to avoid doing if the user cannot enter a page.
Global After Hooks
You can also register global after hooks, however unlike guards, these hooks do not get a next
function and cannot affect the navigation:
router.afterEach((to, from) => {
sendToAnalytics(to.fullPath)
})
They are useful for analytics, changing the title of the page, accessibility features like announcing the page and many other things.
They also reflect navigation failures as the third argument:
router.afterEach((to, from, failure) => {
if (!failure) sendToAnalytics(to.fullPath)
})
Learn more about navigation failures on its guide.
Global injections within guards
Since Vue 3.3, it is possible to use inject()
within navigation guards. This is useful for injecting global properties like the pinia stores. Anything that is provided with app.provide()
is also accessible within router.beforeEach()
, router.beforeResolve()
, router.afterEach()
:
// main.ts
const app = createApp(App)
app.provide('global', 'hello injections')
// router.ts or main.ts
router.beforeEach((to, from) => {
const global = inject('global') // 'hello injections'
// a pinia store
const userStore = useAuthStore()
// ...
})
Per-Route Guard
You can define beforeEnter
guards directly on a route's configuration object:
const routes = [
{
path: '/users/:id',
component: UserDetails,
beforeEnter: (to, from) => {
// reject the navigation
return false
},
},
]
beforeEnter
guards only trigger when entering the route, they don't trigger when the params
, query
or hash
change e.g. going from /users/2
to /users/3
or going from /users/2#info
to /users/2#projects
. They are only triggered when navigating from a different route.
You can also pass an array of functions to beforeEnter
, this is useful when reusing guards for different routes:
function removeQueryParams(to) {
if (Object.keys(to.query).length)
return { path: to.path, query: {}, hash: to.hash }
}
function removeHash(to) {
if (to.hash) return { path: to.path, query: to.query, hash: '' }
}
const routes = [
{
path: '/users/:id',
component: UserDetails,
beforeEnter: [removeQueryParams, removeHash],
},
{
path: '/about',
component: UserDetails,
beforeEnter: [removeQueryParams],
},
]
When working with nested routes, both parent and child routes can use beforeEnter
. When placed on a parent route, it won't be triggered when moving between children with that same parent. For example:
const routes = [
{
path: '/user',
beforeEnter() {
// ...
},
children: [
{ path: 'list', component: UserList },
{ path: 'details', component: UserDetails },
],
},
]
The beforeEnter
in the example above won't be called when moving between /user/list
and /user/details
, as they share the same parent. If we put the beforeEnter
guard directly on the details
route instead, that would be called when moving between those two routes.
TIP
It is possible to achieve similar behavior to per-route guards by using route meta fields and global navigation guards.
In-Component Guards
Finally, you can directly define route navigation guards inside route components (the ones passed to the router configuration)
Using the Options API
You can add the following options to route components:
beforeRouteEnter
beforeRouteUpdate
beforeRouteLeave
<script>
export default {
beforeRouteEnter(to, from) {
// called before the route that renders this component is confirmed.
// does NOT have access to `this` component instance,
// because it has not been created yet when this guard is called!
},
beforeRouteUpdate(to, from) {
// called when the route that renders this component has changed, but this component is reused in the new route.
// For example, given a route with params `/users/:id`, when we navigate between `/users/1` and `/users/2`,
// the same `UserDetails` component instance will be reused, and this hook will be called when that happens.
// Because the component is mounted while this happens, the navigation guard has access to `this` component instance.
},
beforeRouteLeave(to, from) {
// called when the route that renders this component is about to be navigated away from.
// As with `beforeRouteUpdate`, it has access to `this` component instance.
},
}
</script>
The beforeRouteEnter
guard does NOT have access to this
, because the guard is called before the navigation is confirmed, thus the new entering component has not even been created yet.
However, you can access the instance by passing a callback to next
. The callback will be called when the navigation is confirmed, and the component instance will be passed to the callback as the argument:
beforeRouteEnter (to, from, next) {
next(vm => {
// access to component public instance via `vm`
})
}
Note that beforeRouteEnter
is the only guard that supports passing a callback to next
. For beforeRouteUpdate
and beforeRouteLeave
, this
is already available, so passing a callback is unnecessary and therefore not supported:
beforeRouteUpdate (to, from) {
// just use `this`
this.name = to.params.name
}
The leave guard is usually used to prevent the user from accidentally leaving the route with unsaved edits. The navigation can be canceled by returning false
.
beforeRouteLeave (to, from) {
const answer = window.confirm('Do you really want to leave? you have unsaved changes!')
if (!answer) return false
}
Using the Composition API
If you are writing your component using the Composition API, you can add update and leave guards through onBeforeRouteUpdate
and onBeforeRouteLeave
respectively. Please refer to the Composition API section for more details.
The Full Navigation Resolution Flow
- Navigation triggered.
- Call
beforeRouteLeave
guards in deactivated components. - Call global
beforeEach
guards. - Call
beforeRouteUpdate
guards in reused components. - Call
beforeEnter
in route configs. - Resolve async route components.
- Call
beforeRouteEnter
in activated components. - Call global
beforeResolve
guards. - Navigation is confirmed.
- Call global
afterEach
hooks. - DOM updates triggered.
- Call callbacks passed to
next
inbeforeRouteEnter
guards with instantiated instances.     hhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/guide/essentials/nested-routesh
Nested Routes | Vue RouteruhX  Nested Routes
Some applications' UIs are composed of components that are nested multiple levels deep. In this case, it is very common that the segments of a URL correspond to a certain structure of nested components, for example:
/user/johnny/profile /user/johnny/posts
┌──────────────────┐ ┌──────────────────┐
│ User │ │ User │
│ ┌──────────────┐ │ │ ┌──────────────┐ │
│ │ Profile │ │ ●────────────▶ │ │ Posts │ │
│ │ │ │ │ │ │ │
│ └──────────────┘ │ │ └──────────────┘ │
└──────────────────┘ └──────────────────┘
With Vue Router, you can express this relationship using nested route configurations.
Given the app we created in the last chapter:
<!-- App.vue -->
<template>
<router-view />
</template>
<!-- User.vue -->
<template>
<div>
User {{ $route.params.id }}
</div>
</template>
import User from './User.vue'
// these are passed to `createRouter`
const routes = [{ path: '/user/:id', component: User }]
The <router-view>
here is a top-level router-view
. It renders the component matched by a top level route. Similarly, a rendered component can also contain its own, nested <router-view>
. For example, if we add one inside the User
component's template:
<!-- User.vue -->
<template>
<div class="user">
<h2>User {{ $route.params.id }}</h2>
<router-view />
</div>
</template>
To render components into this nested router-view
, we need to use the children
option in any of the routes:
const routes = [
{
path: '/user/:id',
component: User,
children: [
{
// UserProfile will be rendered inside User's <router-view>
// when /user/:id/profile is matched
path: 'profile',
component: UserProfile,
},
{
// UserPosts will be rendered inside User's <router-view>
// when /user/:id/posts is matched
path: 'posts',
component: UserPosts,
},
],
},
]
Note that nested paths that start with /
will be treated as root paths. This allows you to leverage the component nesting without having to use a nested URL.
As you can see, the children
option is just another Array of routes like routes
itself. Therefore, you can keep nesting views as much as you need.
At this point, with the above configuration, when you visit /user/eduardo
, nothing will be rendered inside User
's router-view
, because no nested route is matched. Maybe you do want to render something there. In such case you can provide an empty nested path:
const routes = [
{
path: '/user/:id',
component: User,
children: [
// UserHome will be rendered inside User's <router-view>
// when /user/:id is matched
{ path: '', component: UserHome },
// ...other sub routes
],
},
]
A working demo of this example can be found here.
Nested Named Routes
When dealing with Named Routes, you usually name the children routes:
const routes = [
{
path: '/user/:id',
component: User,
// notice how only the child route has a name
children: [{ path: '', name: 'user', component: UserHome }],
},
]
This will ensure navigating to /user/:id
will always display the nested route.
In some scenarios, you may want to navigate to a named route without navigating to the nested route. For example, if you want to navigate to /user/:id
without displaying the nested route. In that case, you can also name the parent route but note that reloading the page will always display the nested child as it's considered a navigation to the path /users/:id
instead of the named route:
const routes = [
{
path: '/user/:id',
name: 'user-parent',
component: User,
children: [{ path: '', name: 'user', component: UserHome }],
},
]
Omitting parent components 4.1+
We can also take advantage of the parent-child relationship between routes without needing to nest route components. This can be useful for grouping together routes with a common path prefix, or when working with more advanced features, such as per-route navigation guards or route meta fields.
To achieve this, we omit the component
and components
options from the parent route:
const routes = [
{
path: '/admin',
children: [
{ path: '', component: AdminOverview },
{ path: 'users', component: AdminUserList },
{ path: 'users/:id', component: AdminUserDetails },
],
},
]
As the parent doesn't specify a route component, the top-level <router-view>
will skip over the parent and just use the component from the relevant child instead.hhuh(hh	h}ubh)}(h}(hNh	}(h5https://router.vuejs.org/guide/advanced/data-fetchingh
Data Fetching | Vue RouteruhX  Data Fetching
Sometimes you need to fetch data from the server when a route is activated. For example, before rendering a user profile, you need to fetch the user's data from the server. We can achieve this in two different ways:
Fetching After Navigation: perform the navigation first, and fetch data in the incoming component's lifecycle hook. Display a loading state while data is being fetched.
Fetching Before Navigation: Fetch data before navigation in the route enter guard, and perform the navigation after data has been fetched.
Technically, both are valid choices - it ultimately depends on the user experience you are aiming for.
Fetching After Navigation
When using this approach, we navigate and render the incoming component immediately, and fetch data in the component itself. It gives us the opportunity to display a loading state while the data is being fetched over the network, and we can also handle loading differently for each view.
Let's assume we have a Post
component that needs to fetch the data for a post based on route.params.id
:
<template>
<div class="post">
<div v-if="loading" class="loading">Loading...</div>
<div v-if="error" class="error">{{ error }}</div>
<div v-if="post" class="content">
<h2>{{ post.title }}</h2>
<p>{{ post.body }}</p>
</div>
</div>
</template>
<script setup>
import { ref, watch } from 'vue'
import { useRoute } from 'vue-router'
import { getPost } from './api.js'
const route = useRoute()
const loading = ref(false)
const post = ref(null)
const error = ref(null)
// watch the params of the route to fetch the data again
watch(() => route.params.id, fetchData, { immediate: true })
async function fetchData(id) {
error.value = post.value = null
loading.value = true
try {
// replace `getPost` with your data fetching util / API wrapper
post.value = await getPost(id)
} catch (err) {
error.value = err.toString()
} finally {
loading.value = false
}
}
</script>
<template>
<div class="post">
<div v-if="loading" class="loading">Loading...</div>
<div v-if="error" class="error">{{ error }}</div>
<div v-if="post" class="content">
<h2>{{ post.title }}</h2>
<p>{{ post.body }}</p>
</div>
</div>
</template>
<script>
import { getPost } from './api.js'
export default {
data() {
return {
loading: false,
post: null,
error: null,
}
},
created() {
// watch the params of the route to fetch the data again
this.$watch(
() => this.$route.params.id,
this.fetchData,
// fetch the data when the view is created and the data is
// already being observed
{ immediate: true }
)
},
methods: {
async fetchData(id) {
this.error = this.post = null
this.loading = true
try {
// replace `getPost` with your data fetching util / API wrapper
this.post = await getPost(id)
} catch (err) {
this.error = err.toString()
} finally {
this.loading = false
}
},
},
}
</script>
Fetching Before Navigation
With this approach we fetch the data before actually navigating to the new route. We can perform the data fetching in the beforeRouteEnter
guard in the incoming component, and only call next
when the fetch is complete. The callback passed to next
will be called after the component is mounted:
export default {
data() {
return {
post: null,
error: null,
}
},
async beforeRouteEnter(to, from, next) {
try {
const post = await getPost(to.params.id)
// `setPost` is a method defined below
next(vm => vm.setPost(post))
} catch (err) {
// `setError` is a method defined below
next(vm => vm.setError(err))
}
},
// when route changes and this component is already rendered,
// the logic will be slightly different.
beforeRouteUpdate(to, from) {
this.post = null
getPost(to.params.id).then(this.setPost).catch(this.setError)
},
methods: {
setPost(post) {
this.post = post
},
setError(err) {
this.error = err.toString()
}
}
}
The user will stay on the previous view while the resource is being fetched for the incoming view. It is therefore recommended to display a progress bar or some kind of indicator while the data is being fetched. If the data fetch fails, it's also necessary to display some kind of global warning message.hhuh(hh	h}ubh)}(h}(hNh	}(h&https://v2.vuejs.org/v2/guide/instanceh
The Vue Instance — Vue.jsuhX9  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
The Vue Instance
Creating a Vue Instance
Every Vue application starts by creating a new Vue instance with the Vue
function:
|
Although not strictly associated with the MVVM pattern, Vue’s design was partly inspired by it. As a convention, we often use the variable vm
(short for ViewModel) to refer to our Vue instance.
When you create a Vue instance, you pass in an options object. The majority of this guide describes how you can use these options to create your desired behavior. For reference, you can also browse the full list of options in the API reference.
A Vue application consists of a root Vue instance created with new Vue
, optionally organized into a tree of nested, reusable components. For example, a todo app’s component tree might look like this:
|
We’ll talk about the component system in detail later. For now, just know that all Vue components are also Vue instances, and so accept the same options object (except for a few root-specific options).
Data and Methods
When a Vue instance is created, it adds all the properties found in its data
object to Vue’s reactivity system. When the values of those properties change, the view will “react”, updating to match the new values.
|
When this data changes, the view will re-render. It should be noted that properties in data
are only reactive if they existed when the instance was created. That means if you add a new property, like:
|
Then changes to b
will not trigger any view updates. If you know you’ll need a property later, but it starts out empty or non-existent, you’ll need to set some initial value. For example:
|
The only exception to this being the use of Object.freeze()
, which prevents existing properties from being changed, which also means the reactivity system can’t track changes.
|
|
In addition to data properties, Vue instances expose a number of useful instance properties and methods. These are prefixed with $
to differentiate them from user-defined properties. For example:
|
In the future, you can consult the API reference for a full list of instance properties and methods.
Instance Lifecycle Hooks
Each Vue instance goes through a series of initialization steps when it’s created - for example, it needs to set up data observation, compile the template, mount the instance to the DOM, and update the DOM when data changes. Along the way, it also runs functions called lifecycle hooks, giving users the opportunity to add their own code at specific stages.
For example, the created
hook can be used to run code after an instance is created:
|
There are also other hooks which will be called at different stages of the instance’s lifecycle, such as mounted
, updated
, and destroyed
. All lifecycle hooks are called with their this
context pointing to the Vue instance invoking it.
Don’t use arrow functions on an options property or callback, such as created: () => console.log(this.a)
or vm.$watch('a', newValue => this.myMethod())
. Since an arrow function doesn’t have a this
, this
will be treated as any other variable and lexically looked up through parent scopes until found, often resulting in errors such as Uncaught TypeError: Cannot read property of undefined
or Uncaught TypeError: this.myMethod is not a function
.
Lifecycle Diagram
Below is a diagram for the instance lifecycle. You don’t need to fully understand everything going on right now, but as you learn and build more, it will be a useful reference.hhuh(hh	h}ubh)}(h}(hNh	}(h%https://v2.vuejs.org/v2/guide/routingh
Routing — Vue.jsuhX  Become a Sponsor
Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Become a Sponsor
Routing
Official Router
For most Single Page Applications, it’s recommended to use the officially-supported vue-router library. For more details, see vue-router’s documentation.
Simple Routing From Scratch
If you only need very simple routing and do not wish to involve a full-featured router library, you can do so by dynamically rendering a page-level component like this:
|
Combined with the HTML5 History API, you can build a very basic but fully-functional client-side router. To see that in practice, check out this example app.
Integrating 3rd-Party Routers
If there’s a 3rd-party router you prefer to use, such as Page.js or Director, integration is similarly easy. Here’s a complete example using Page.js.
Caught a mistake or want to contribute to the documentation?
Edit this on GitHub!
Deployed on
Netlify .hhuh(hh	h}ubh)}(h}(hNh	}(h%https://v2.vuejs.org/v2/guide/filtersh
Filters — Vue.jsuhXZ	  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Filters
Vue.js allows you to define filters that can be used to apply common text formatting. Filters are usable in two places: mustache interpolations and v-bind
expressions (the latter supported in 2.1.0+). Filters should be appended to the end of the JavaScript expression, denoted by the “pipe” symbol:
|
You can define local filters in a component’s options:
|
or define a filter globally before creating the Vue instance:
|
When the global filter has the same name as the local filter, the local filter will be preferred.
Below is an example of our capitalize
filter being used:
{{ message | capitalize }}
The filter’s function always receives the expression’s value (the result of the former chain) as its first argument. In the above example, the capitalize
filter function will receive the value of message
as its argument.
Filters can be chained:
|
In this case, filterA
, defined with a single argument, will receive the value of message
, and then the filterB
function will be called with the result of filterA
passed into filterB
‘s single argument.
Filters are JavaScript functions, therefore they can take arguments:
|
Here filterA
is defined as a function taking three arguments. The value of message
will be passed into the first argument. The plain string 'arg1'
will be passed into the filterA
as its second argument, and the value of expression arg2
will be evaluated and passed in as the third argument.hhuh(hh	h}ubh)}(h}(hNh	}(hhttps://v2.vuejs.org/v2/guide/h
Introduction — Vue.jsuhX   Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Introduction
What is Vue.js?
Vue (pronounced /vjuː/, like view) is a progressive framework for building user interfaces. Unlike other monolithic frameworks, Vue is designed from the ground up to be incrementally adoptable. The core library is focused on the view layer only, and is easy to pick up and integrate with other libraries or existing projects. On the other hand, Vue is also perfectly capable of powering sophisticated Single-Page Applications when used in combination with modern tooling and supporting libraries.
If you’d like to learn more about Vue before diving in, we created a video walking through the core principles and a sample project.
If you are an experienced frontend developer and want to know how Vue compares to other libraries/frameworks, check out the Comparison with Other Frameworks.
Getting Started
The official guide assumes intermediate level knowledge of HTML, CSS, and JavaScript. If you are totally new to frontend development, it might not be the best idea to jump right into a framework as your first step - grasp the basics then come back! Prior experience with other frameworks helps, but is not required.
The easiest way to try out Vue.js is using the Hello World example. Feel free to open it in another tab and follow along as we go through some basic examples. Or, you can create an index.html
file and include Vue with:
|
or:
|
The Installation page provides more options of installing Vue. Note: We do not recommend that beginners start with vue-cli
, especially if you are not yet familiar with Node.js-based build tools.
If you prefer something more interactive, you can also check out this tutorial series on Scrimba, which gives you a mix of screencast and code playground that you can pause and play around with anytime.
Declarative Rendering
At the core of Vue.js is a system that enables us to declaratively render data to the DOM using straightforward template syntax:
|
|
We have already created our very first Vue app! This looks pretty similar to rendering a string template, but Vue has done a lot of work under the hood. The data and the DOM are now linked, and everything is now reactive. How do we know? Open your browser’s JavaScript console (right now, on this page) and set app.message
to a different value. You should see the rendered example above update accordingly.
Note that we no longer have to interact with the HTML directly. A Vue app attaches itself to a single DOM element (#app
in our case) then fully controls it. The HTML is our entry point, but everything else happens within the newly created Vue instance.
In addition to text interpolation, we can also bind element attributes like this:
|
|
Here we are encountering something new. The v-bind
attribute you are seeing is called a directive. Directives are prefixed with v-
to indicate that they are special attributes provided by Vue, and as you may have guessed, they apply special reactive behavior to the rendered DOM. Here, it is basically saying “keep this element’s title
attribute up-to-date with the message
property on the Vue instance.”
If you open up your JavaScript console again and enter app2.message = 'some new message'
, you’ll once again see that the bound HTML - in this case the title
attribute - has been updated.
Conditionals and Loops
It’s easy to toggle the presence of an element, too:
|
|
Go ahead and enter app3.seen = false
in the console. You should see the message disappear.
This example demonstrates that we can bind data to not only text and attributes, but also the structure of the DOM. Moreover, Vue also provides a powerful transition effect system that can automatically apply transition effects when elements are inserted/updated/removed by Vue.
There are quite a few other directives, each with its own special functionality. For example, the v-for
directive can be used for displaying a list of items using the data from an Array:
|
|
- {{ todo.text }}
In the console, enter app4.todos.push({ text: 'New item' })
. You should see a new item appended to the list.
Handling User Input
To let users interact with your app, we can use the v-on
directive to attach event listeners that invoke methods on our Vue instances:
|
|
{{ message }}
Note that in this method we update the state of our app without touching the DOM - all DOM manipulations are handled by Vue, and the code you write is focused on the underlying logic.
Vue also provides the v-model
directive that makes two-way binding between form input and app state a breeze:
|
|
{{ message }}
Composing with Components
The component system is another important concept in Vue, because it’s an abstraction that allows us to build large-scale applications composed of small, self-contained, and often reusable components. If we think about it, almost any type of application interface can be abstracted into a tree of components:
In Vue, a component is essentially a Vue instance with pre-defined options. Registering a component in Vue is straightforward:
|
Now you can compose it in another component’s template:
|
But this would render the same text for every todo, which is not super interesting. We should be able to pass data from the parent scope into child components. Let’s modify the component definition to make it accept a prop:
|
Now we can pass the todo into each repeated component using v-bind
:
|
|
This is a contrived example, but we have managed to separate our app into two smaller units, and the child is reasonably well-decoupled from the parent via the props interface. We can now further improve our <todo-item>
component with more complex template and logic without affecting the parent app.
In a large application, it is necessary to divide the whole app into components to make development manageable. We will talk a lot more about components later in the guide, but here’s an (imaginary) example of what an app’s template might look like with components:
|
Relation to Custom Elements
You may have noticed that Vue components are very similar to Custom Elements, which are part of the Web Components Spec. That’s because Vue’s component syntax is loosely modeled after the spec. For example, Vue components implement the Slot API and the is
special attribute. However, there are a few key differences:
The Web Components Spec has been finalized, but is not natively implemented in every browser. Safari 10.1+, Chrome 54+ and Firefox 63+ natively support web components. In comparison, Vue components don’t require any polyfills and work consistently in all supported browsers (IE9 and above). When needed, Vue components can also be wrapped inside a native custom element.
Vue components provide important features that are not available in plain custom elements, most notably cross-component data flow, custom event communication and build tool integrations.
Although Vue doesn’t use custom elements internally, it has great interoperability when it comes to consuming or distributing as custom elements. Vue CLI also supports building Vue components that register themselves as native custom elements.
Ready for More?
We’ve briefly introduced the most basic features of Vue.js core - the rest of this guide will cover them and other advanced features with much finer details, so make sure to read through it all!
Video by Vue Mastery. Watch Vue Mastery’s free Intro to Vue course.hhuh(hh	h}ubh)}(h}(hNh	}(h%https://v2.vuejs.org/v2/guide/pluginsh
Plugins — Vue.jsuhX0	  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Plugins
Plugins usually add global-level functionality to Vue. There is no strictly defined scope for a plugin - there are typically several types of plugins:
Add some global methods or properties. e.g. vue-custom-element
Add one or more global assets: directives/filters/transitions etc. e.g. vue-touch
Add some component options by global mixin. e.g. vue-router
Add some Vue instance methods by attaching them to Vue.prototype.
A library that provides an API of its own, while at the same time injecting some combination of the above. e.g. vue-router
Using a Plugin
Use plugins by calling the Vue.use()
global method. This has to be done before you start your app by calling new Vue()
:
|
You can optionally pass in some options:
|
Vue.use
automatically prevents you from using the same plugin more than once, so calling it multiple times on the same plugin will install the plugin only once.
Some plugins provided by Vue.js official plugins such as vue-router
automatically calls Vue.use()
if Vue
is available as a global variable. However in a module environment such as CommonJS, you always need to call Vue.use()
explicitly:
|
Checkout awesome-vue for a huge collection of community-contributed plugins and libraries.
Writing a Plugin
A Vue.js plugin should expose an install
method. The method will be called with the Vue
constructor as the first argument, along with possible options:
|hhuh(hh	h}ubh)}(h}(hNh	}(h8https://router.vuejs.org/guide/advanced/router-view-sloth
RouterView slot | Vue RouteruhX  RouterView slot
The RouterView component exposes a slot that can be used to render the route component:
<router-view v-slot="{ Component }">
<component :is="Component" />
</router-view>
The code above is equivalent to using <router-view />
without the slot, but the slot provides extra flexibility when we want to work with other features.
KeepAlive & Transition
When working with the KeepAlive component, we would usually want it to keep the route components alive, not the RouterView itself. We can achieve that by putting the KeepAlive inside the slot:
<router-view v-slot="{ Component }">
<keep-alive>
<component :is="Component" />
</keep-alive>
</router-view>
Similarly, the slot allows us to use a Transition component to transition between route components:
<router-view v-slot="{ Component }">
<transition>
<component :is="Component" />
</transition>
</router-view>
We can also use KeepAlive inside a Transition:
<router-view v-slot="{ Component }">
<transition>
<keep-alive>
<component :is="Component" />
</keep-alive>
</transition>
</router-view>
For more information about using RouterView with the Transition component, see the Transitions guide.
Passing props and slots
We can use the slot to pass props or slots to the route component:
<router-view v-slot="{ Component }">
<component :is="Component" some-prop="a value">
<p>Some slotted content</p>
</component>
</router-view>
In practice, this usually isn't something you would want to do, as the route components would all need to use the same props and slots. See Passing Props to Route Components for other ways to pass props.
Template refs
Using the slot allows us to put a template ref directly on the route component:
<router-view v-slot="{ Component }">
<component :is="Component" ref="mainContent" />
</router-view>
If we put the ref on the <router-view>
instead then the ref would be populated with the RouterView instance, rather than the route component.hhuh(hh	h}ubh)}(h}(hNh	}(h4https://router.vuejs.org/guide/essentials/navigationh
$Programmatic Navigation | Vue RouteruhXp  Programmatic Navigation
Aside from using <router-link>
to create anchor tags for declarative navigation, we can do this programmatically using the router's instance methods.
Navigate to a different location
Note: The examples below refer to the router instance as router
. Inside a component, you can access the router using the $router
property, e.g. this.$router.push(...)
. If you're using the Composition API, the router is accessible by calling useRouter()
.
To navigate to a different URL, use router.push
. This method pushes a new entry into the history stack, so when the user clicks the browser back button they will be taken to the previous URL.
This is the method called internally when you click a <router-link>
, so clicking <router-link :to="...">
is the equivalent of calling router.push(...)
.
Declarative | Programmatic |
---|---|
<router-link :to="..."> | router.push(...) |
The argument can be a string path, or a location descriptor object. Examples:
// literal string path
router.push('/users/eduardo')
// object with path
router.push({ path: '/users/eduardo' })
// named route with params to let the router build the url
router.push({ name: 'user', params: { username: 'eduardo' } })
// with query, resulting in /register?plan=private
router.push({ path: '/register', query: { plan: 'private' } })
// with hash, resulting in /about#team
router.push({ path: '/about', hash: '#team' })
Note: params
are ignored if a path
is provided, which is not the case for query
, as shown in the example above. Instead, you need to provide the name
of the route or manually specify the whole path
with any parameter:
const username = 'eduardo'
// we can manually build the url but we will have to handle the encoding ourselves
router.push(`/user/${username}`) // -> /user/eduardo
// same as
router.push({ path: `/user/${username}` }) // -> /user/eduardo
// if possible use `name` and `params` to benefit from automatic URL encoding
router.push({ name: 'user', params: { username } }) // -> /user/eduardo
// `params` cannot be used alongside `path`
router.push({ path: '/user', params: { username } }) // -> /user
When specifying params
, make sure to either provide a string
or number
(or an array of these for repeatable params). Any other type (like objects, booleans, etc) will be automatically stringified. For optional params, you can provide an empty string (""
) or null
as the value to remove it.
Since the prop to
accepts the same kind of object as router.push
, the exact same rules apply to both of them.
router.push
and all the other navigation methods return a Promise that allows us to wait till the navigation is finished and to know if it succeeded or failed. We will talk more about that in Navigation Handling.
Replace current location
It acts like router.push
, the only difference is that it navigates without pushing a new history entry, as its name suggests - it replaces the current entry.
Declarative | Programmatic |
---|---|
<router-link :to="..." replace> | router.replace(...) |
It's also possible to directly add a property replace: true
to the to
argument that is passed to router.push
:
router.push({ path: '/home', replace: true })
// equivalent to
router.replace({ path: '/home' })
Traverse history
This method takes a single integer as parameter that indicates by how many steps to go forward or go backward in the history stack, similar to window.history.go(n)
.
Examples
// go forward by one record, the same as router.forward()
router.go(1)
// go back by one record, the same as router.back()
router.go(-1)
// go forward by 3 records
router.go(3)
// fails silently if there aren't that many records
router.go(-100)
router.go(100)
History Manipulation
You may have noticed that router.push
, router.replace
and router.go
are counterparts of window.history.pushState
, window.history.replaceState
and window.history.go
, and they do imitate the window.history
APIs.
Therefore, if you are already familiar with Browser History APIs, manipulating history will feel familiar when using Vue Router.
It is worth mentioning that Vue Router navigation methods (push
, replace
, go
) work consistently no matter the history
option passed when creating the router instance.hhuh(hh	h}ubh)}(h}(hNh	}(h?https://router.vuejs.org/guide/essentials/route-matching-syntaxh
$Routes' Matching Syntax | Vue RouteruhX  Routes' Matching Syntax
Most applications will use static routes like /about
and dynamic routes like /users/:userId
like we just saw in Dynamic Route Matching, but Vue Router has much more to offer!
TIP
For the sake of simplicity, all route records are omitting the component
property to focus on the path
value.
Custom regex in params
When defining a param like :userId
, we internally use the following regex ([^/]+)
(at least one character that isn't a slash /
) to extract params from URLs. This works well unless you need to differentiate two routes based on the param content. Imagine two routes /:orderId
and /:productName
, both would match the exact same URLs, so we need a way to differentiate them. The easiest way would be to add a static section to the path that differentiates them:
const routes = [
// matches /o/3549
{ path: '/o/:orderId' },
// matches /p/books
{ path: '/p/:productName' },
]
But in some scenarios, we don't want to add that static section /o
or /p
. However, orderId
is always a number while productName
can be anything so we can specify a custom regex for a param in parentheses:
const routes = [
// /:orderId -> matches only numbers
{ path: '/:orderId(\\d+)' },
// /:productName -> matches anything else
{ path: '/:productName' },
]
Now, going to /25
will match /:orderId
while going to anything else will match /:productName
. The order of the routes
array doesn't even matter!
TIP
Make sure to escape backslashes (\
) like we did with \d
(becomes \\d
) to actually pass the backslash character in a string in JavaScript.
Repeatable params
If you need to match routes with multiple sections like /first/second/third
, you should mark a param as repeatable with *
(0 or more) and +
(1 or more):
const routes = [
// /:chapters -> matches /one, /one/two, /one/two/three, etc
{ path: '/:chapters+' },
// /:chapters -> matches /, /one, /one/two, /one/two/three, etc
{ path: '/:chapters*' },
]
This will give you an array of params instead of a string and will also require you to pass an array when using named routes:
// given { path: '/:chapters*', name: 'chapters' },
router.resolve({ name: 'chapters', params: { chapters: [] } }).href
// produces /
router.resolve({ name: 'chapters', params: { chapters: ['a', 'b'] } }).href
// produces /a/b
// given { path: '/:chapters+', name: 'chapters' },
router.resolve({ name: 'chapters', params: { chapters: [] } }).href
// throws an Error because `chapters` is empty
These can also be combined with a custom regex by adding them after the closing parentheses:
const routes = [
// only match numbers
// matches /1, /1/2, etc
{ path: '/:chapters(\\d+)+' },
// matches /, /1, /1/2, etc
{ path: '/:chapters(\\d+)*' },
]
Sensitive and strict route options
By default, all routes are case-insensitive and match routes with or without a trailing slash. e.g. a route /users
matches /users
, /users/
, and even /Users/
. This behavior can be configured with the strict
and sensitive
options, they can be set both at a router and route level:
const router = createRouter({
history: createWebHistory(),
routes: [
// will match /users/posva but not:
// - /users/posva/ because of strict: true
// - /Users/posva because of sensitive: true
{ path: '/users/:id', sensitive: true },
// will match /users, /Users, and /users/42 but not /users/ or /users/42/
{ path: '/users/:id?' },
],
strict: true, // applies to all routes
})
Optional parameters
You can also mark a parameter as optional by using the ?
modifier (0 or 1):
const routes = [
// will match /users and /users/posva
{ path: '/users/:userId?' },
// will match /users and /users/42
{ path: '/users/:userId(\\d+)?' },
]
Note that *
technically also marks a parameter as optional but ?
parameters cannot be repeated.
If the route segment contains more than just an optional parameter, it won't match a path without the trailing slash. For example:
/users/:uid?-:name?
won't match/users
, only/users/-
or even/users/-/
/users/:uid(\\d+)?:name?
won't match/users
, only/users/
,/users/2
,/users/2/
, etc
You can play around with the matching syntax in the playground
Debugging
If you need to dig how your routes are transformed into a regex to understand why a route isn't being matched or, to report a bug, you can use the path ranker tool. It supports sharing your routes through the URL.hhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/guide/advanced/dynamic-routingh
Dynamic Routing | Vue RouteruhXp  Dynamic Routing
Adding routes to your router is usually done via the routes
option but in some situations, you might want to add or remove routes while the application is already running. Applications with extensible interfaces like Vue CLI UI can use this to make the application grow.
Adding routes
Dynamic routing is achieved mainly via two functions: router.addRoute()
and router.removeRoute()
. They only register a new route, meaning that if the newly added route matches the current location, it would require you to manually navigate with router.push()
or router.replace()
to display that new route. Let's take a look at an example:
Imagine having the following router with one single route:
const router = createRouter({
history: createWebHistory(),
routes: [{ path: '/:articleName', component: Article }],
})
Going to any page like /about
, /store
, or /3-tricks-to-improve-your-routing-code
ends up rendering the Article
component. If we are on /about
and we add a new route:
router.addRoute({ path: '/about', component: About })
The page will still show the Article
component. We need to manually call router.replace()
to change the current location and overwrite where we were (instead of pushing a new entry, ending up in the same location twice in our history):
router.addRoute({ path: '/about', component: About })
// we could also use this.$route or useRoute()
router.replace(router.currentRoute.value.fullPath)
Remember you can await router.replace()
if you need to wait for the new route to be displayed.
Adding routes inside navigation guards
If you decide to add or remove routes inside of a navigation guard, you should not call router.replace()
but trigger a redirection by returning the new location:
router.beforeEach(to => {
if (!hasNecessaryRoute(to)) {
router.addRoute(generateRoute(to))
// trigger a redirection
return to.fullPath
}
})
The example above assumes two things: first, the newly added route record will match the to
location, effectively resulting in a different location from the one we were trying to access. Second, hasNecessaryRoute()
returns false
after adding the new route to avoid an infinite redirection.
Because we are redirecting, we are replacing the ongoing navigation, effectively behaving like the example shown before. In real world scenarios, adding is more likely to happen outside of navigation guards, e.g. when a view component mounts, it register new routes.
Removing routes
There are few different ways to remove existing routes:
By adding a route with a conflicting name. If you add a route that has the same name as an existing route, it will remove the route first and then add the route:
jsrouter.addRoute({ path: '/about', name: 'about', component: About }) // this will remove the previously added route because they have // the same name and names are unique across all routes router.addRoute({ path: '/other', name: 'about', component: Other })
By calling the callback returned by
router.addRoute()
:jsconst removeRoute = router.addRoute(routeRecord) removeRoute() // removes the route if it exists
This is useful when the routes do not have a name
By using
router.removeRoute()
to remove a route by its name:jsrouter.addRoute({ path: '/about', name: 'about', component: About }) // remove the route router.removeRoute('about')
Note you can use
Symbol
s for names in routes if you wish to use this function but want to avoid conflicts in names.
Whenever a route is removed, all of its aliases and children are removed with it.
Adding nested routes
To add nested routes to an existing route, you can pass the name of the route as its first parameter to router.addRoute()
. This will effectively add the route as if it was added through children
:
router.addRoute({ name: 'admin', path: '/admin', component: Admin })
router.addRoute('admin', { path: 'settings', component: AdminSettings })
This is equivalent to:
router.addRoute({
name: 'admin',
path: '/admin',
component: Admin,
children: [{ path: 'settings', component: AdminSettings }],
})
Looking at existing routes
Vue Router gives you two functions to look at existing routes:
router.hasRoute()
: check if a route exists.router.getRoutes()
: get an array with all the route records.hhuh(hh	h}ubh)}(h}(hNh	}(h=https://router.vuejs.org/guide/advanced/extending-router-linkh
!Extending RouterLink | Vue RouteruhX%  Extending RouterLink
The RouterLink component exposes enough props
to suffice most basic applications but it doesn't try to cover every possible use case and you will likely find yourself using v-slot
for some advanced cases. In most medium to large sized applications, it's worth creating one if not multiple custom RouterLink components to reuse them across your application. Some examples are Links in a Navigation Menu, handling external links, adding an inactive-class
, etc.
Let's extend RouterLink to handle external links as well and adding a custom inactive-class
in an AppLink.vue
file:
<script setup>
import { computed } from 'vue'
import { RouterLink } from 'vue-router'
defineOptions({
inheritAttrs: false,
})
const props = defineProps({
// add @ts-ignore if using TypeScript
...RouterLink.props,
inactiveClass: String,
})
const isExternalLink = computed(() => {
return typeof props.to === 'string' && props.to.startsWith('http')
})
</script>
<template>
<a v-if="isExternalLink" v-bind="$attrs" :href="to" target="_blank">
<slot />
</a>
<router-link
v-else
v-bind="$props"
custom
v-slot="{ isActive, href, navigate }"
>
<a
v-bind="$attrs"
:href="href"
@click="navigate"
:class="isActive ? activeClass : inactiveClass"
>
<slot />
</a>
</router-link>
</template>
<script>
import { RouterLink } from 'vue-router'
export default {
name: 'AppLink',
inheritAttrs: false,
props: {
// add @ts-ignore if using TypeScript
...RouterLink.props,
inactiveClass: String,
},
computed: {
isExternalLink() {
return typeof this.to === 'string' && this.to.startsWith('http')
},
},
}
</script>
<template>
<a v-if="isExternalLink" v-bind="$attrs" :href="to" target="_blank">
<slot />
</a>
<router-link
v-else
v-bind="$props"
custom
v-slot="{ isActive, href, navigate }"
>
<a
v-bind="$attrs"
:href="href"
@click="navigate"
:class="isActive ? activeClass : inactiveClass"
>
<slot />
</a>
</router-link>
</template>
If you prefer using a render function or create computed
properties, you can use the useLink
from the Composition API:
import { RouterLink, useLink } from 'vue-router'
export default {
name: 'AppLink',
props: {
// add @ts-ignore if using TypeScript
...RouterLink.props,
inactiveClass: String,
},
setup(props) {
// `props` contains `to` and any other prop that can be passed to <router-link>
const { navigate, href, route, isActive, isExactActive } = useLink(props)
// profit!
return { isExternalLink }
},
}
In practice, you might want to use your AppLink
component for different parts of your application. e.g. using Tailwind CSS, you could create a NavLink.vue
component with all the classes:
<template>
<AppLink
v-bind="$attrs"
class="inline-flex items-center px-1 pt-1 border-b-2 border-transparent text-sm font-medium leading-5 text-gray-500 hover:text-gray-700 hover:border-gray-300 focus:outline-none focus:text-gray-700 focus:border-gray-300 transition duration-150 ease-in-out"
active-class="border-indigo-500 text-gray-900 focus:border-indigo-700"
inactive-class="text-gray-500 hover:text-gray-700 hover:border-gray-300 focus:text-gray-700 focus:border-gray-300"
>
<slot />
</AppLink>
</template>hhuh(hh	h}ubh)}(h}(hNh	}(h5https://router.vuejs.org/guide/essentials/named-viewsh
Named Views | Vue RouteruhX 
  Named Views
Sometimes you need to display multiple views at the same time instead of nesting them, e.g. creating a layout with a sidebar
view and a main
view. This is where named views come in handy. Instead of having one single outlet in your view, you can have multiple and give each of them a name. A router-view
without a name will be given default
as its name.
<router-view class="view left-sidebar" name="LeftSidebar" />
<router-view class="view main-content" />
<router-view class="view right-sidebar" name="RightSidebar" />
A view is rendered by using a component, therefore multiple views require multiple components for the same route. Make sure to use the components
(with an s) option:
const router = createRouter({
history: createWebHashHistory(),
routes: [
{
path: '/',
components: {
default: Home,
// short for LeftSidebar: LeftSidebar
LeftSidebar,
// they match the `name` attribute on `<router-view>`
RightSidebar,
},
},
],
})
A working demo of this example can be found here.
Nested Named Views
It is possible to create complex layouts using named views with nested views. When doing so, you will also need to give nested router-view
a name. Let's take a Settings panel example:
/settings/emails /settings/profile
+-----------------------------------+ +------------------------------+
| UserSettings | | UserSettings |
| +-----+-------------------------+ | | +-----+--------------------+ |
| | Nav | UserEmailsSubscriptions | | +------------> | | Nav | UserProfile | |
| | +-------------------------+ | | | +--------------------+ |
| | | | | | | | UserProfilePreview | |
| +-----+-------------------------+ | | +-----+--------------------+ |
+-----------------------------------+ +------------------------------+
Nav
is just a regular componentUserSettings
is the parent view componentUserEmailsSubscriptions
,UserProfile
,UserProfilePreview
are nested view components
Note: Let's forget about how the HTML/CSS should look like to represent such layout and focus on the components used.
The <template>
section for UserSettings
component in the above layout would look something like this:
<!-- UserSettings.vue -->
<div>
<h1>User Settings</h1>
<NavBar />
<router-view />
<router-view name="helper" />
</div>
Then you can achieve the layout above with this route configuration:
{
path: '/settings',
// You could also have named views at the top
component: UserSettings,
children: [{
path: 'emails',
component: UserEmailsSubscriptions
}, {
path: 'profile',
components: {
default: UserProfile,
helper: UserProfilePreview
}
}]
}
A working demo of this example can be found here.hhuh(hh	h}ubh)}(h}(hNh	}(h3https://v2.vuejs.org/v2/guide/components-edge-casesh
Handling Edge Cases — Vue.jsuhX~3  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Handling Edge Cases
This page assumes you’ve already read the Components Basics. Read that first if you are new to components.
All the features on this page document the handling of edge cases, meaning unusual situations that sometimes require bending Vue’s rules a little. Note however, that they all have disadvantages or situations where they could be dangerous. These are noted in each case, so keep them in mind when deciding to use each feature.
Element & Component Access
In most cases, it’s best to avoid reaching into other component instances or manually manipulating DOM elements. There are cases, however, when it can be appropriate.
Accessing the Root Instance
In every subcomponent of a new Vue
instance, this root instance can be accessed with the $root
property. For example, in this root instance:
|
All subcomponents will now be able to access this instance and use it as a global store:
|
This can be convenient for demos or very small apps with a handful of components. However, the pattern does not scale well to medium or large-scale applications, so we strongly recommend using Vuex to manage state in most cases.
Accessing the Parent Component Instance
Similar to $root
, the $parent
property can be used to access the parent instance from a child. This can be tempting to reach for as a lazy alternative to passing data with a prop.
In most cases, reaching into the parent makes your application more difficult to debug and understand, especially if you mutate data in the parent. When looking at that component later, it will be very difficult to figure out where that mutation came from.
There are cases however, particularly shared component libraries, when this might be appropriate. For example, in abstract components that interact with JavaScript APIs instead of rendering HTML, like these hypothetical Google Maps components:
|
The <google-map>
component might define a map
property that all subcomponents need access to. In this case <google-map-markers>
might want to access that map with something like this.$parent.getMap
, in order to add a set of markers to it. You can see this pattern in action here.
Keep in mind, however, that components built with this pattern are still inherently fragile. For example, imagine we add a new <google-map-region>
component and when <google-map-markers>
appears within that, it should only render markers that fall within that region:
|
Then inside <google-map-markers>
you might find yourself reaching for a hack like this:
|
This has quickly gotten out of hand. That’s why to provide context information to descendant components arbitrarily deep, we instead recommend dependency injection.
Accessing Child Component Instances & Child Elements
Despite the existence of props and events, sometimes you might still need to directly access a child component in JavaScript. To achieve this you can assign a reference ID to the child component using the ref
attribute. For example:
|
Now in the component where you’ve defined this ref
, you can use:
|
to access the <base-input>
instance. This may be useful when you want to, for example, programmatically focus this input from a parent. In that case, the <base-input>
component may similarly use a ref
to provide access to specific elements inside it, such as:
|
And even define methods for use by the parent:
|
Thus allowing the parent component to focus the input inside <base-input>
with:
|
When ref
is used together with v-for
, the ref you get will be an array containing the child components mirroring the data source.
$refs
are only populated after the component has been rendered, and they are not reactive. It is only meant as an escape hatch for direct child manipulation - you should avoid accessing $refs
from within templates or computed properties.
Dependency Injection
Earlier, when we described Accessing the Parent Component Instance, we showed an example like this:
|
In this component, all descendants of <google-map>
needed access to a getMap
method, in order to know which map to interact with. Unfortunately, using the $parent
property didn’t scale well to more deeply nested components. That’s where dependency injection can be useful, using two new instance options: provide
and inject
.
The provide
options allows us to specify the data/methods we want to provide to descendant components. In this case, that’s the getMap
method inside <google-map>
:
|
Then in any descendants, we can use the inject
option to receive specific properties we’d like to add to that instance:
|
You can see the full example here. The advantage over using $parent
is that we can access getMap
in any descendant component, without exposing the entire instance of <google-map>
. This allows us to more safely keep developing that component, without fear that we might change/remove something that a child component is relying on. The interface between these components remains clearly defined, just as with props
.
In fact, you can think of dependency injection as sort of “long-range props”, except:
- ancestor components don’t need to know which descendants use the properties it provides
- descendant components don’t need to know where injected properties are coming from
However, there are downsides to dependency injection. It couples components in your application to the way they’re currently organized, making refactoring more difficult. Provided properties are also not reactive. This is by design, because using them to create a central data store scales just as poorly as using $root
for the same purpose. If the properties you want to share are specific to your app, rather than generic, or if you ever want to update provided data inside ancestors, then that’s a good sign that you probably need a real state management solution like Vuex instead.
Learn more about dependency injection in the API doc.
Programmatic Event Listeners
So far, you’ve seen uses of $emit
, listened to with v-on
, but Vue instances also offer other methods in its events interface. We can:
- Listen for an event with
$on(eventName, eventHandler)
- Listen for an event only once with
$once(eventName, eventHandler)
- Stop listening for an event with
$off(eventName, eventHandler)
You normally won’t have to use these, but they’re available for cases when you need to manually listen for events on a component instance. They can also be useful as a code organization tool. For example, you may often see this pattern for integrating a 3rd-party library:
|
This has two potential issues:
- It requires saving the
picker
to the component instance, when it’s possible that only lifecycle hooks need access to it. This isn’t terrible, but it could be considered clutter. - Our setup code is kept separate from our cleanup code, making it more difficult to programmatically clean up anything we set up.
You could resolve both issues with a programmatic listener:
|
Using this strategy, we could even use Pikaday with several input elements, with each new instance automatically cleaning up after itself:
|
See this example for the full code. Note, however, that if you find yourself having to do a lot of setup and cleanup within a single component, the best solution will usually be to create more modular components. In this case, we’d recommend creating a reusable <input-datepicker>
component.
To learn more about programmatic listeners, check out the API for Events Instance Methods.
Note that Vue’s event system is different from the browser’s EventTarget API. Though they work similarly, $emit
, $on
, and $off
are not aliases for dispatchEvent
, addEventListener
, and removeEventListener
.
Circular References
Recursive Components
Components can recursively invoke themselves in their own template. However, they can only do so with the name
option:
|
When you register a component globally using Vue.component
, the global ID is automatically set as the component’s name
option.
|
If you’re not careful, recursive components can also lead to infinite loops:
|
A component like the above will result in a “max stack size exceeded” error, so make sure recursive invocation is conditional (i.e. uses a v-if
that will eventually be false
).
Circular References Between Components
Let’s say you’re building a file directory tree, like in Finder or File Explorer. You might have a tree-folder
component with this template:
|
Then a tree-folder-contents
component with this template:
|
When you look closely, you’ll see that these components will actually be each other’s descendant and ancestor in the render tree - a paradox! When registering components globally with Vue.component
, this paradox is resolved for you automatically. If that’s you, you can stop reading here.
However, if you’re requiring/importing components using a module system, e.g. via Webpack or Browserify, you’ll get an error:
|
To explain what’s happening, let’s call our components A and B. The module system sees that it needs A, but first A needs B, but B needs A, but A needs B, etc. It’s stuck in a loop, not knowing how to fully resolve either component without first resolving the other. To fix this, we need to give the module system a point at which it can say, “A needs B eventually, but there’s no need to resolve B first.”
In our case, let’s make that point the tree-folder
component. We know the child that creates the paradox is the tree-folder-contents
component, so we’ll wait until the beforeCreate
lifecycle hook to register it:
|
Or alternatively, you could use Webpack’s asynchronous import
when you register the component locally:
|
Problem solved!
Alternate Template Definitions
Inline Templates
When the inline-template
special attribute is present on a child component, the component will use its inner content as its template, rather than treating it as distributed content. This allows more flexible template-authoring.
|
Your inline template needs to be defined inside the DOM element to which Vue is attached.
However, inline-template
makes the scope of your templates harder to reason about. As a best practice, prefer defining templates inside the component using the template
option or in a <template>
element in a .vue
file.
X-Templates
Another way to define templates is inside of a script element with the type text/x-template
, then referencing the template by an id. For example:
|
|
Your x-template needs to be defined outside the DOM element to which Vue is attached.
These can be useful for demos with large templates or in extremely small applications, but should otherwise be avoided, because they separate templates from the rest of the component definition.
Controlling Updates
Thanks to Vue’s Reactivity system, it always knows when to update (if you use it correctly). There are edge cases, however, when you might want to force an update, despite the fact that no reactive data has changed. Then there are other cases when you might want to prevent unnecessary updates.
Forcing an Update
If you find yourself needing to force an update in Vue, in 99.99% of cases, you’ve made a mistake somewhere.
You may not have accounted for change detection caveats with arrays or objects, or you may be relying on state that isn’t tracked by Vue’s reactivity system, e.g. with data
.
However, if you’ve ruled out the above and find yourself in this extremely rare situation of having to manually force an update, you can do so with $forceUpdate
.
Cheap Static Components with v-once
Rendering plain HTML elements is very fast in Vue, but sometimes you might have a component that contains a lot of static content. In these cases, you can ensure that it’s only evaluated once and then cached by adding the v-once
directive to the root element, like this:
|
Once again, try not to overuse this pattern. While convenient in those rare cases when you have to render a lot of static content, it’s simply not necessary unless you actually notice slow rendering – plus, it could cause a lot of confusion later. For example, imagine another developer who’s not familiar with v-once
or simply misses it in the template. They might spend hours trying to figure out why the template isn’t updating correctly.hhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/guide/advanced/composition-apih
/Vue Router and the Composition API | Vue RouteruhX  Vue Router and the Composition API
The introduction of Vue's Composition API opened up new possibilities, but to be able to get the full potential out of Vue Router, we will need to use a few new functions to replace access to this
and in-component navigation guards.
Accessing the Router and current Route inside setup
Because we don't have access to this
inside of setup
, we cannot directly access this.$router
or this.$route
. Instead, we use the useRouter
and useRoute
composables:
<script setup>
import { useRouter, useRoute } from 'vue-router'
const router = useRouter()
const route = useRoute()
function pushWithQuery(query) {
router.push({
name: 'search',
query: {
...route.query,
...query,
},
})
}
</script>
The route
object is a reactive object. In most scenarios, you should avoid watching the whole route
object. Instead, you can directly watch the properties you are expecting to change:
<script setup>
import { useRoute } from 'vue-router'
import { ref, watch } from 'vue'
const route = useRoute()
const userData = ref()
// fetch the user information when params change
watch(
() => route.params.id,
async newId => {
userData.value = await fetchUser(newId)
}
)
</script>
Note we still have access to $router
and $route
in templates, so there's no need to use useRouter
or useRoute
if we only need those objects in the template.
Navigation Guards
Vue Router exposes update and leave guards as Composition API functions:
<script setup>
import { onBeforeRouteLeave, onBeforeRouteUpdate } from 'vue-router'
import { ref } from 'vue'
// same as beforeRouteLeave option but with no access to `this`
onBeforeRouteLeave((to, from) => {
const answer = window.confirm(
'Do you really want to leave? you have unsaved changes!'
)
// cancel the navigation and stay on the same page
if (!answer) return false
})
const userData = ref()
// same as beforeRouteUpdate option but with no access to `this`
onBeforeRouteUpdate(async (to, from) => {
// only fetch the user if the id changed as maybe only the query or the hash changed
if (to.params.id !== from.params.id) {
userData.value = await fetchUser(to.params.id)
}
})
</script>
Composition API guards can also be used in any component rendered by <router-view>
, they don't have to be used directly on the route component like in-component guards.
useLink
Vue Router exposes the internal behavior of RouterLink as a composable. It accepts a reactive object like the props of RouterLink
and exposes low-level properties to build your own RouterLink
component or generate custom links:
<script setup>
import { RouterLink, useLink } from 'vue-router'
import { computed } from 'vue'
const props = defineProps({
// add @ts-ignore if using TypeScript
...RouterLink.props,
inactiveClass: String,
})
const {
// the resolved route object
route,
// the href to use in a link
href,
// boolean ref indicating if the link is active
isActive,
// boolean ref indicating if the link is exactly active
isExactActive,
// function to navigate to the link
navigate
} = useLink(props)
const isExternalLink = computed(
() => typeof props.to === 'string' && props.to.startsWith('http')
)
</script>
Note that the RouterLink's v-slot
gives access to the same properties as the useLink
composable.      hhuh(hh	h}ubh)}(h}(hNh	}(h6https://router.vuejs.org/guide/essentials/history-modeh
$Different History modes | Vue RouteruhX+  Different History modes
The history
option when creating the router instance allows us to choose among different history modes.
Hash Mode
The hash history mode is created with createWebHashHistory()
:
import { createRouter, createWebHashHistory } from 'vue-router'
const router = createRouter({
history: createWebHashHistory(),
routes: [
//...
],
})
It uses a hash character (#
) before the actual URL that is internally passed. Because this section of the URL is never sent to the server, it doesn't require any special treatment on the server level. It does however have a bad impact in SEO. If that's a concern for you, use the HTML5 history mode.
HTML5 Mode
The HTML5 mode is created with createWebHistory()
and is the recommended mode:
import { createRouter, createWebHistory } from 'vue-router'
const router = createRouter({
history: createWebHistory(),
routes: [
//...
],
})
When using createWebHistory()
, the URL will look "normal," e.g. https://example.com/user/id
. Beautiful!
Here comes a problem, though: Since our app is a single page client side app, without a proper server configuration, the users will get a 404 error if they access https://example.com/user/id
directly in their browser. Now that's ugly.
Not to worry: To fix the issue, all you need to do is add a simple catch-all fallback route to your server. If the URL doesn't match any static assets, it should serve the same index.html
page that your app lives in. Beautiful, again!
Memory mode
The memory history mode doesn't assume a browser environment and therefore doesn't interact with the URL nor automatically triggers the initial navigation. This makes it perfect for Node environment and SSR. It is created with createMemoryHistory()
and requires you to push the initial navigation after calling app.use(router)
.
import { createRouter, createMemoryHistory } from 'vue-router'
const router = createRouter({
history: createMemoryHistory(),
routes: [
//...
],
})
While it's not recommended, you can use this mode inside Browser applications but note there will be no history, meaning you won't be able to go back or forward.
Example Server Configurations
Note: The following examples assume you are serving your app from the root folder. If you deploy to a subfolder, you should use the publicPath
option of Vue CLI and the related base
property of the router. You also need to adjust the examples below to use the subfolder instead of the root folder (e.g. replacing RewriteBase /
with RewriteBase /name-of-your-subfolder/
).
Apache
<IfModule mod_negotiation.c>
Options -MultiViews
</IfModule>
<IfModule mod_rewrite.c>
RewriteEngine On
RewriteBase /
RewriteRule ^index\.html$ - [L]
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule . /index.html [L]
</IfModule>
Instead of mod_rewrite
, you could also use FallbackResource
.
nginx
location / {
try_files $uri $uri/ /index.html;
}
Native Node.js
const http = require('http')
const fs = require('fs')
const httpPort = 80
http
.createServer((req, res) => {
fs.readFile('index.html', 'utf-8', (err, content) => {
if (err) {
console.log('We cannot open "index.html" file.')
}
res.writeHead(200, {
'Content-Type': 'text/html; charset=utf-8',
})
res.end(content)
})
})
.listen(httpPort, () => {
console.log('Server listening on: http://localhost:%s', httpPort)
})
Express with Node.js
For Node.js/Express, consider using connect-history-api-fallback middleware.
Internet Information Services (IIS)
- Install IIS UrlRewrite
- Create a
web.config
file in the root directory of your site with the following:
<?xml version="1.0" encoding="UTF-8"?>
<configuration>
<system.webServer>
<rewrite>
<rules>
<rule name="Handle History Mode and custom 404/500" stopProcessing="true">
<match url="(.*)" />
<conditions logicalGrouping="MatchAll">
<add input="{REQUEST_FILENAME}" matchType="IsFile" negate="true" />
<add input="{REQUEST_FILENAME}" matchType="IsDirectory" negate="true" />
</conditions>
<action type="Rewrite" url="/" />
</rule>
</rules>
</rewrite>
</system.webServer>
</configuration>
Caddy v2
try_files {path} /
Caddy v1
rewrite {
regexp .*
to {path} /
}
Firebase hosting
Add this to your firebase.json
:
{
"hosting": {
"public": "dist",
"rewrites": [
{
"source": "**",
"destination": "/index.html"
}
]
}
}
Netlify
Create a _redirects
file that is included with your deployed files:
/* /index.html 200
In vue-cli, nuxt, and vite projects, this file usually goes under a folder named static
or public
.
You can read more about the syntax on Netlify documentation. You can also create a netlify.toml
to combine redirections with other Netlify features.
Vercel
Create a vercel.json
file under the root directory of your project with the following:
{
"rewrites": [{ "source": "/:path*", "destination": "/index.html" }]
}
Caveat
There is a caveat to this: Your server will no longer report 404 errors as all not-found paths now serve up your index.html
file. To get around the issue, you should implement a catch-all route within your Vue app to show a 404 page:
const router = createRouter({
history: createWebHistory(),
routes: [{ path: '/:pathMatch(.*)', component: NotFoundComponent }],
})
Alternatively, if you are using a Node.js server, you can implement the fallback by using the router on the server side to match the incoming URL and respond with 404 if no route is matched. Check out the Vue server side rendering documentation for more information.hhuh(hh	h}ubh)}(h}(hNh	}(h(https://v2.vuejs.org/v2/guide/deploymenth
 Production Deployment — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Production Deployment
Most of the tips below are enabled by default if you are using Vue CLI. This section is only relevant if you are using a custom build setup.
Turn on Production Mode
During development, Vue provides a lot of warnings to help you with common errors and pitfalls. However, these warning strings become useless in production and bloat your app’s payload size. In addition, some of these warning checks have small runtime costs that can be avoided in production mode.
Without Build Tools
If you are using the full build, i.e. directly including Vue via a script tag without a build tool, make sure to use the minified version (vue.min.js
) for production. Both versions can be found in the Installation guide.
With Build Tools
When using a build tool like Webpack or Browserify, the production mode will be determined by process.env.NODE_ENV
inside Vue’s source code, and it will be in development mode by default. Both build tools provide ways to overwrite this variable to enable Vue’s production mode, and warnings will be stripped by minifiers during the build. All vue-cli
templates have these pre-configured for you, but it would be beneficial to know how it is done:
Webpack
In Webpack 4+, you can use the mode
option:
|
But in Webpack 3 and earlier, you’ll need to use DefinePlugin:
|
Browserify
Run your bundling command with the actual
NODE_ENV
environment variable set to"production"
. This tellsvueify
to avoid including hot-reload and development related code.Apply a global envify transform to your bundle. This allows the minifier to strip out all the warnings in Vue’s source code wrapped in env variable conditional blocks. For example:
NODE_ENV=production browserify -g envify -e main.js | uglifyjs -c -m > build.js
Or, using envify with Gulp:
// Use the envify custom module to specify environment variables
var envify = require('envify/custom')
browserify(browserifyOptions)
.transform(vueify)
.transform(
// Required in order to process node_modules files
{ global: true },
envify({ NODE_ENV: 'production' })
)
.bundle()Or, using envify with Grunt and grunt-browserify:
// Use the envify custom module to specify environment variables
var envify = require('envify/custom')
browserify: {
dist: {
options: {
// Function to deviate from grunt-browserify's default order
configure: b => b
.transform('vueify')
.transform(
// Required in order to process node_modules files
{ global: true },
envify({ NODE_ENV: 'production' })
)
.bundle()
}
}
}
Rollup
|
Pre-Compiling Templates
When using in-DOM templates or in-JavaScript template strings, the template-to-render-function compilation is performed on the fly. This is usually fast enough in most cases, but is best avoided if your application is performance-sensitive.
The easiest way to pre-compile templates is using Single-File Components - the associated build setups automatically performs pre-compilation for you, so the built code contains the already compiled render functions instead of raw template strings.
If you are using Webpack, and prefer separating JavaScript and template files, you can use vue-template-loader, which also transforms the template files into JavaScript render functions during the build step.
Extracting Component CSS
When using Single-File Components, the CSS inside components are injected dynamically as <style>
tags via JavaScript. This has a small runtime cost, and if you are using server-side rendering it will cause a “flash of unstyled content”. Extracting the CSS across all components into the same file will avoid these issues, and also result in better CSS minification and caching.
Refer to the respective build tool documentations to see how it’s done:
- Webpack + vue-loader (the
vue-cli
webpack template has this pre-configured) - Browserify + vueify
- Rollup + rollup-plugin-vue
Tracking Runtime Errors
If a runtime error occurs during a component’s render, it will be passed to the global Vue.config.errorHandler
config function if it has been set. It might be a good idea to leverage this hook together with an error-tracking service like Sentry, which provides an official integration for Vue.hhuh(hh	h}ubh)}(h}(hNh	}(h.https://v2.vuejs.org/v2/guide/components-propsh
Props — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Props
This page assumes you’ve already read the Components Basics. Read that first if you are new to components.
Prop Casing (camelCase vs kebab-case)
HTML attribute names are case-insensitive, so browsers will interpret any uppercase characters as lowercase. That means when you’re using in-DOM templates, camelCased prop names need to use their kebab-cased (hyphen-delimited) equivalents:
|
|
Again, if you’re using string templates, this limitation does not apply.
Prop Types
So far, we’ve only seen props listed as an array of strings:
|
Usually though, you’ll want every prop to be a specific type of value. In these cases, you can list props as an object, where the properties’ names and values contain the prop names and types, respectively:
|
This not only documents your component, but will also warn users in the browser’s JavaScript console if they pass the wrong type. You’ll learn much more about type checks and other prop validations further down this page.
Passing Static or Dynamic Props
So far, you’ve seen props passed a static value, like in:
|
You’ve also seen props assigned dynamically with v-bind
, such as in:
|
In the two examples above, we happen to pass string values, but any type of value can actually be passed to a prop.
Passing a Number
|
Passing a Boolean
|
Passing an Array
|
Passing an Object
|
Passing the Properties of an Object
If you want to pass all the properties of an object as props, you can use v-bind
without an argument (v-bind
instead of v-bind:prop-name
). For example, given a post
object:
|
The following template:
|
Will be equivalent to:
|
One-Way Data Flow
All props form a one-way-down binding between the child property and the parent one: when the parent property updates, it will flow down to the child, but not the other way around. This prevents child components from accidentally mutating the parent’s state, which can make your app’s data flow harder to understand.
In addition, every time the parent component is updated, all props in the child component will be refreshed with the latest value. This means you should not attempt to mutate a prop inside a child component. If you do, Vue will warn you in the console.
There are usually two cases where it’s tempting to mutate a prop:
The prop is used to pass in an initial value; the child component wants to use it as a local data property afterwards. In this case, it’s best to define a local data property that uses the prop as its initial value:
props: ['initialCounter'],
data: function () {
return {
counter: this.initialCounter
}
}The prop is passed in as a raw value that needs to be transformed. In this case, it’s best to define a computed property using the prop’s value:
props: ['size'],
computed: {
normalizedSize: function () {
return this.size.trim().toLowerCase()
}
}
Note that objects and arrays in JavaScript are passed by reference, so if the prop is an array or object, mutating the object or array itself inside the child component will affect parent state.
Prop Validation
Components can specify requirements for their props, such as the types you’ve already seen. If a requirement isn’t met, Vue will warn you in the browser’s JavaScript console. This is especially useful when developing a component that’s intended to be used by others.
To specify prop validations, you can provide an object with validation requirements to the value of props
, instead of an array of strings. For example:
|
When prop validation fails, Vue will produce a console warning (if using the development build).
Note that props are validated before a component instance is created, so instance properties (e.g. data
, computed
, etc) will not be available inside default
or validator
functions.
Type Checks
The type
can be one of the following native constructors:
- String
- Number
- Boolean
- Array
- Object
- Date
- Function
- Symbol
In addition, type
can also be a custom constructor function and the assertion will be made with an instanceof
check. For example, given the following constructor function exists:
|
You could use:
|
to validate that the value of the author
prop was created with new Person
.
Non-Prop Attributes
A non-prop attribute is an attribute that is passed to a component, but does not have a corresponding prop defined.
While explicitly defined props are preferred for passing information to a child component, authors of component libraries can’t always foresee the contexts in which their components might be used. That’s why components can accept arbitrary attributes, which are added to the component’s root element.
For example, imagine we’re using a 3rd-party bootstrap-date-input
component with a Bootstrap plugin that requires a data-date-picker
attribute on the input
. We can add this attribute to our component instance:
|
And the data-date-picker="activated"
attribute will automatically be added to the root element of bootstrap-date-input
.
Replacing/Merging with Existing Attributes
Imagine this is the template for bootstrap-date-input
:
|
To specify a theme for our date picker plugin, we might need to add a specific class, like this:
|
In this case, two different values for class
are defined:
form-control
, which is set by the component in its templatedate-picker-theme-dark
, which is passed to the component by its parent
For most attributes, the value provided to the component will replace the value set by the component. So for example, passing type="text"
will replace type="date"
and probably break it! Fortunately, the class
and style
attributes are a little smarter, so both values are merged, making the final value: form-control date-picker-theme-dark
.
Disabling Attribute Inheritance
If you do not want the root element of a component to inherit attributes, you can set inheritAttrs: false
in the component’s options. For example:
|
This can be especially useful in combination with the $attrs
instance property, which contains the attribute names and values passed to a component, such as:
|
With inheritAttrs: false
and $attrs
, you can manually decide which element you want to forward attributes to, which is often desirable for base components:
|
Note that inheritAttrs: false
option does not affect style
and class
bindings.
This pattern allows you to use base components more like raw HTML elements, without having to care about which element is actually at its root:
|hhuh(hh	h}ubh)}(h}(hNh	}(h6https://v2.vuejs.org/v2/guide/components-dynamic-asynch
%Dynamic & Async Components — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Dynamic & Async Components
This page assumes you’ve already read the Components Basics. Read that first if you are new to components.
keep-alive
with Dynamic Components
Earlier, we used the is
attribute to switch between components in a tabbed interface:
|
When switching between these components though, you’ll sometimes want to maintain their state or avoid re-rendering for performance reasons. For example, when expanding our tabbed interface a little:
You’ll notice that if you select a post, switch to the Archive tab, then switch back to Posts, it’s no longer showing the post you selected. That’s because each time you switch to a new tab, Vue creates a new instance of the currentTabComponent
.
Recreating dynamic components is normally useful behavior, but in this case, we’d really like those tab component instances to be cached once they’re created for the first time. To solve this problem, we can wrap our dynamic component with a <keep-alive>
element:
|
Check out the result below:
Now the Posts tab maintains its state (the selected post) even when it’s not rendered. See this example for the complete code.
Note that <keep-alive>
requires the components being switched between to all have names, either using the name
option on a component, or through local/global registration.
Check out more details on <keep-alive>
in the API reference.
Async Components
In large applications, we may need to divide the app into smaller chunks and only load a component from the server when it’s needed. To make that easier, Vue allows you to define your component as a factory function that asynchronously resolves your component definition. Vue will only trigger the factory function when the component needs to be rendered and will cache the result for future re-renders. For example:
|
As you can see, the factory function receives a resolve
callback, which should be called when you have retrieved your component definition from the server. You can also call reject(reason)
to indicate the load has failed. The setTimeout
here is for demonstration; how to retrieve the component is up to you. One recommended approach is to use async components together with Webpack’s code-splitting feature:
|
You can also return a Promise
in the factory function, so with Webpack 2 and ES2015 syntax you can make use of dynamic imports:
|
When using local registration, you can also directly provide a function that returns a Promise
:
|
If you’re a Browserify user that would like to use async components, its creator has unfortunately made it clear that async loading “is not something that Browserify will ever support.” Officially, at least. The Browserify community has found some workarounds, which may be helpful for existing and complex applications. For all other scenarios, we recommend using Webpack for built-in, first-class async support.
Handling Loading State
New in 2.3.0+
The async component factory can also return an object of the following format:
|
Note that you must use Vue Router 2.4.0+ if you wish to use the above syntax for route components.hhuh(hh	h}ubh)}(h}(hNh	}(h,https://v2.vuejs.org/v2/guide/migration-vuexh
+Migration from Vuex 0.6.x to 1.0 — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Migration from Vuex 0.6.x to 1.0
Vuex 2.0 is released, but this guide only covers the migration to 1.0? Is that a typo? Also, it looks like Vuex 1.0 and 2.0 were released simultaneously. What’s going on? Which one should I use and what’s compatible with Vue 2.0?
Both Vuex 1.0 and 2.0:
- fully support both Vue 1.0 and 2.0
- will be maintained for the foreseeable future
They have slightly different target users however.
Vuex 2.0 is a radical redesign and simplification of the API, for those who are starting new projects or want to be on the cutting edge of client-side state management. It is not covered by this migration guide, so you should check out the Vuex 2.0 docs if you’d like to learn more about it.
Vuex 1.0 is mostly backwards-compatible, so requires very few changes to upgrade. It is recommended for those with large existing codebases or who want the smoothest possible upgrade path to Vue 2.0. This guide is dedicated to facilitating that process, but only includes migration notes. For the complete usage guide, see the Vuex 1.0 docs.
store.watch
with String Property Path replaced
store.watch
now only accept functions. So for example, you would have to replace:
|
with:
|
This gives you more complete control over the reactive properties you’d like to watch.
Upgrade Path
Run the migration helper on your codebase to find examples of store.watch
with a string as the first argument.
Store’s Event Emitter removed
The store instance no longer exposes the event emitter interface (on
, off
, emit
). If you were previously using the store as a global event bus, see this section for migration instructions.
Instead of using this interface to watch events emitted by the store itself (e.g. store.on('mutation', callback)
), a new method store.subscribe
is introduced. Typical usage inside a plugin would be:
|
See example the plugins docs for more info.
Upgrade Path
Run the migration helper on your codebase to find examples of store.on
, store.off
, and store.emit
.
Middlewares replaced
Middlewares are replaced by plugins. A plugin is a function that receives the store as the only argument, and can listen to the mutation event on the store:
|
For more details, see the plugins docs.
Upgrade Path
Run the migration helper on your codebase to find examples of the middlewares
option on a store.hhuh(hh	h}ubh)}(h}(hNh	}(h(https://v2.vuejs.org/v2/guide/typescripth
TypeScript Support — Vue.jsuhXr  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
TypeScript Support
Vue CLI provides built-in TypeScript tooling support.
Official Declaration in NPM Packages
A static type system can help prevent many potential runtime errors, especially as applications grow. That’s why Vue ships with official type declarations for TypeScript - not only in Vue core, but also for vue-router and vuex as well.
Since these are published on NPM, and the latest TypeScript knows how to resolve type declarations in NPM packages, this means when installed via NPM, you don’t need any additional tooling to use TypeScript with Vue.
Recommended Configuration
|
Note that you have to include strict: true
(or at least noImplicitThis: true
which is a part of strict
flag) to leverage type checking of this
in component methods otherwise it is always treated as any
type.
See TypeScript compiler options docs for more details.
Development Tooling
Project Creation
Vue CLI 3 can generate new projects that use TypeScript. To get started:
|
Editor Support
For developing Vue applications with TypeScript, we strongly recommend using Visual Studio Code, which provides great out-of-the-box support for TypeScript. If you are using single-file components (SFCs), get the awesome Vetur extension, which provides TypeScript inference inside SFCs and many other great features.
WebStorm also provides out-of-the-box support for both TypeScript and Vue.
Basic Usage
To let TypeScript properly infer types inside Vue component options, you need to define components with Vue.component
or Vue.extend
:
|
Class-Style Vue Components
If you prefer a class-based API when declaring components, you can use the officially maintained vue-class-component decorator:
|
Augmenting Types for Use with Plugins
Plugins may add to Vue’s global/instance properties and component options. In these cases, type declarations are needed to make plugins compile in TypeScript. Fortunately, there’s a TypeScript feature to augment existing types called module augmentation.
For example, to declare an instance property $myProperty
with type string
:
|
After including the above code as a declaration file (like my-property.d.ts
) in your project, you can use $myProperty
on a Vue instance.
|
You can also declare additional global properties and component options:
|
The above declarations allow the following code to be compiled:
|
Annotating Return Types
Because of the circular nature of Vue’s declaration files, TypeScript may have difficulties inferring the types of certain methods. For this reason, you may need to annotate the return type on methods like render
and those in computed
.
|
If you find type inference or member completion isn’t working, annotating certain methods may help address these problems. Using the --noImplicitAny
option will help find many of these unannotated methods.
Annotating Props
|
If you find validator not getting type inference or member completion isn’t working, annotating the argument with the expected type may help address these problems.hhuh(hh	h}ubh)}(h}(hNh	}(h6https://v2.vuejs.org/v2/guide/components-custom-eventsh
Custom Events — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Custom Events
This page assumes you’ve already read the Components Basics. Read that first if you are new to components.
Event Names
Unlike components and props, event names don’t provide any automatic case transformation. Instead, the name of an emitted event must exactly match the name used to listen to that event. For example, if emitting a camelCased event name:
|
Listening to the kebab-cased version will have no effect:
|
Unlike components and props, event names will never be used as variable or property names in JavaScript, so there’s no reason to use camelCase or PascalCase. Additionally, v-on
event listeners inside DOM templates will be automatically transformed to lowercase (due to HTML’s case-insensitivity), so v-on:myEvent
would become v-on:myevent
– making myEvent
impossible to listen to.
For these reasons, we recommend you always use kebab-case for event names.
Customizing Component v-model
New in 2.2.0+
By default, v-model
on a component uses value
as the prop and input
as the event, but some input types such as checkboxes and radio buttons may want to use the value
attribute for a different purpose. Using the model
option can avoid a conflict in such cases:
|
Now when using v-model
on this component:
|
the value of lovingVue
will be passed to the checked
prop. The lovingVue
property will then be updated when <base-checkbox>
emits a change
event with a new value.
Note that you still have to declare the checked
prop in the component’s props
option.
Binding Native Events to Components
There may be times when you want to listen directly to a native event on the root element of a component. In these cases, you can use the .native
modifier for v-on
:
|
This can be useful sometimes, but it’s not a good idea when you’re trying to listen on a very specific element, like an <input>
. For example, the <base-input>
component above might refactor so that the root element is actually a <label>
element:
|
In that case, the .native
listener in the parent would silently break. There would be no errors, but the onFocus
handler wouldn’t be called when we expected it to.
To solve this problem, Vue provides a $listeners
property containing an object of listeners being used on the component. For example:
|
Using the $listeners
property, you can forward all event listeners on the component to a specific child element with v-on="$listeners"
. For elements like <input>
, that you also want to work with v-model
, it’s often useful to create a new computed property for listeners, like inputListeners
below:
|
Now the <base-input>
component is a fully transparent wrapper, meaning it can be used exactly like a normal <input>
element: all the same attributes and listeners will work, without the .native
modifier.
.sync
Modifier
New in 2.3.0+
In some cases, we may need “two-way binding” for a prop. Unfortunately, true two-way binding can create maintenance issues, because child components can mutate the parent without the source of that mutation being obvious in both the parent and the child.
That’s why instead, we recommend emitting events in the pattern of update:myPropName
. For example, in a hypothetical component with a title
prop, we could communicate the intent of assigning a new value with:
|
Then the parent can listen to that event and update a local data property, if it wants to. For example:
|
For convenience, we offer a shorthand for this pattern with the .sync
modifier:
|
Note that v-bind
with the .sync
modifier does not work with expressions (e.g. v-bind:title.sync=”doc.title + ‘!’”
is invalid). Instead, you must only provide the name of the property you want to bind, similar to v-model
.
The .sync
modifier can also be used with v-bind
when using an object to set multiple props at once:
|
This passes each property in the doc
object (e.g. title
) as an individual prop, then adds v-on
update listeners for each one.
Using v-bind.sync
with a literal object, such as in v-bind.sync=”{ title: doc.title }”
, will not work, because there are too many edge cases to consider in parsing a complex expression like this.hhuh(hh	h}ubh)}(h}(hNh	}(h$https://v2.vuejs.org/v2/guide/syntaxh
Template Syntax — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Template Syntax
Vue.js uses an HTML-based template syntax that allows you to declaratively bind the rendered DOM to the underlying Vue instance’s data. All Vue.js templates are valid HTML that can be parsed by spec-compliant browsers and HTML parsers.
Under the hood, Vue compiles the templates into Virtual DOM render functions. Combined with the reactivity system, Vue is able to intelligently figure out the minimal number of components to re-render and apply the minimal amount of DOM manipulations when the app state changes.
If you are familiar with Virtual DOM concepts and prefer the raw power of JavaScript, you can also directly write render functions instead of templates, with optional JSX support.
Interpolations
Text
The most basic form of data binding is text interpolation using the “Mustache” syntax (double curly braces):
|
The mustache tag will be replaced with the value of the msg
property on the corresponding data object. It will also be updated whenever the data object’s msg
property changes.
You can also perform one-time interpolations that do not update on data change by using the v-once directive, but keep in mind this will also affect any other bindings on the same node:
|
Raw HTML
The double mustaches interprets the data as plain text, not HTML. In order to output real HTML, you will need to use the v-html
directive:
|
Using mustaches: {{ rawHtml }}
Using v-html directive:
The contents of the span
will be replaced with the value of the rawHtml
property, interpreted as plain HTML - data bindings are ignored. Note that you cannot use v-html
to compose template partials, because Vue is not a string-based templating engine. Instead, components are preferred as the fundamental unit for UI reuse and composition.
Dynamically rendering arbitrary HTML on your website can be very dangerous because it can easily lead to XSS vulnerabilities. Only use HTML interpolation on trusted content and never on user-provided content.
Attributes
Mustaches cannot be used inside HTML attributes. Instead, use a v-bind
directive:
|
In the case of boolean attributes, where their mere existence implies true
, v-bind
works a little differently. In this example:
|
If isButtonDisabled
has the value of null
, undefined
, or false
, the disabled
attribute will not even be included in the rendered <button>
element.
Using JavaScript Expressions
So far we’ve only been binding to simple property keys in our templates. But Vue.js actually supports the full power of JavaScript expressions inside all data bindings:
|
These expressions will be evaluated as JavaScript in the data scope of the owner Vue instance. One restriction is that each binding can only contain one single expression, so the following will NOT work:
|
Template expressions are sandboxed and only have access to a whitelist of globals such as Math
and Date
. You should not attempt to access user-defined globals in template expressions.
Directives
Directives are special attributes with the v-
prefix. Directive attribute values are expected to be a single JavaScript expression (with the exception of v-for
, which will be discussed later). A directive’s job is to reactively apply side effects to the DOM when the value of its expression changes. Let’s review the example we saw in the introduction:
|
Here, the v-if
directive would remove/insert the <p>
element based on the truthiness of the value of the expression seen
.
Arguments
Some directives can take an “argument”, denoted by a colon after the directive name. For example, the v-bind
directive is used to reactively update an HTML attribute:
|
Here href
is the argument, which tells the v-bind
directive to bind the element’s href
attribute to the value of the expression url
.
Another example is the v-on
directive, which listens to DOM events:
|
Here the argument is the event name to listen to. We will talk about event handling in more detail too.
Dynamic Arguments
New in 2.6.0+
Starting in version 2.6.0, it is also possible to use a JavaScript expression in a directive argument by wrapping it with square brackets:
|
Here attributeName
will be dynamically evaluated as a JavaScript expression, and its evaluated value will be used as the final value for the argument. For example, if your Vue instance has a data property, attributeName
, whose value is "href"
, then this binding will be equivalent to v-bind:href
.
Similarly, you can use dynamic arguments to bind a handler to a dynamic event name:
|
In this example, when eventName
‘s value is "focus"
, v-on:[eventName]
will be equivalent to v-on:focus
.
Dynamic Argument Value Constraints
Dynamic arguments are expected to evaluate to a string, with the exception of null
. The special value null
can be used to explicitly remove the binding. Any other non-string value will trigger a warning.
Dynamic Argument Expression Constraints
Dynamic argument expressions have some syntax constraints because certain characters, such as spaces and quotes, are invalid inside HTML attribute names. For example, the following is invalid:
|
The workaround is to either use expressions without spaces or quotes, or replace the complex expression with a computed property.
When using in-DOM templates (i.e., templates written directly in an HTML file), you should also avoid naming keys with uppercase characters, as browsers will coerce attribute names into lowercase:
|
Modifiers
Modifiers are special postfixes denoted by a dot, which indicate that a directive should be bound in some special way. For example, the .prevent
modifier tells the v-on
directive to call event.preventDefault()
on the triggered event:
|
You’ll see other examples of modifiers later, for v-on
and for v-model
, when we explore those features.
Shorthands
The v-
prefix serves as a visual cue for identifying Vue-specific attributes in your templates. This is useful when you are using Vue.js to apply dynamic behavior to some existing markup, but can feel verbose for some frequently used directives. At the same time, the need for the v-
prefix becomes less important when you are building a SPA, where Vue manages every template. Therefore, Vue provides special shorthands for two of the most often used directives, v-bind
and v-on
:
v-bind
Shorthand
|
v-on
Shorthand
|
They may look a bit different from normal HTML, but :
and @
are valid characters for attribute names and all Vue-supported browsers can parse it correctly. In addition, they do not appear in the final rendered markup. The shorthand syntax is totally optional, but you will likely appreciate it when you learn more about its usage later.hhuh(hh	h}ubh)}(h}(hNh	}(h"https://v2.vuejs.org/v2/guide/teamh
Meet the Team — Vue.jsuhX  Become a Sponsor
Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Become a Sponsor
Meet the Team
Active Core Team Members
Failed to get your location.
The development of Vue and its ecosystem is guided by an international team, some of whom have chosen to be featured below.
The core team has been sorted by their distance from you.
Core Team Emeriti
Here we honor some no-longer-active core team members who have made valuable contributions in the past.
Community Partners
Failed to get your location.
Some members of the Vue community have so enriched it, that they deserve special mention. We've developed a more intimate relationship with these key partners, often coordinating with them on upcoming features and news.
The community partners have been sorted by their distance from you.
Caught a mistake or want to contribute to the documentation?
Edit this on GitHub!
Deployed on
Netlify .hhuh(hh	h}ubh)}(h}(hNh	}(h"https://v2.vuejs.org/v2/guide/joinh
%Join the Vue.js Community! — Vue.jsuhX~  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Join the Vue.js Community!
Vue’s community is growing incredibly fast and if you’re reading this, there’s a good chance you’re ready to join it. So… welcome!
Now we’ll answer both what the community can do for you and what you can do for the community.
Resources
Code of Conduct
Our Code of Conduct is a guide to make it easier to enrich all of us and the technical communities in which we participate.
Get Support
- Forum: The best place to ask questions and get answers about Vue and its ecosystem.
- Chat: A place for Vue devs to meet and chat in real time.
- Meetups: Want to find local Vue.js enthusiasts like yourself? Interested in becoming a community leader? We have the help and support you need right here!
- GitHub: If you have a bug to report or feature to request, that’s what the GitHub issues are for. We also welcome pull requests!
Explore the Ecosystem
- The Awesome Vue Page: See what other awesome resources have been published by other awesome people.
- The “Show and Tell” Subforum: Another great place to check out what others have built with and for the growing Vue ecosystem.
What You Can Do
Contribute Code
As with any project, there are rules to contributing. To ensure that we can help you or accept your pull request as quickly as possible, please read the contributing guide.
After that, you’ll be ready to contribute to Vue’s core repositories:
- vue: the core library
- vuex: Flux-inspired state management
- vue-router: a routing system for SPAs
…as well as many smaller official companion libraries.
Share (and Build) Your Experience
Apart from answering questions and sharing resources in the forum and chat, there are a few other less obvious ways to share and expand what you know:
- Develop learning materials. It’s often said that the best way to learn is to teach. If there’s something interesting you’re doing with Vue, strengthen your expertise by writing a blog post, developing a workshop, or even publishing a gist that you share on social media.
- Watch a repo you care about. This will send you notifications whenever there’s activity in that repository, giving you insider knowledge about ongoing discussions and upcoming features. It’s a fantastic way to build expertise so that you’re eventually able to help address issues and pull requests.
Translate Docs
Vue has already spread across the globe, with even the core team in at least half a dozen timezones. The forum includes 7 languages and counting and many of our docs have actively-maintained translations. We’re very proud of Vue’s international reach, but we can do even better.
I hope that right now, you’re reading this sentence in your preferred language. If not, would you like to help us get there?
If so, please feel free to fork the repo for these docs or for any other officially maintained documentation, then start translating. Once you’ve made some progress, open an issue or pull request in the main repo and we’ll put out a call for more contributors to help you out.
Become a Community Leader
There’s a lot you can do to help Vue grow in your community:
- Present at your local meetup. Whether it’s giving a talk or running a workshop, you can bring a lot of value to your community by helping both new and experienced Vue developers continue to grow.
- Start your own meetup. If there’s not already a Vue meetup in your area, you can start your own! Use the resources at events.vuejs.org to help you succeed!
- Help meetup organizers. There can never be too much help when it comes to running an event, so offer a hand to help out local organizers to help make every event a success.
If you have any questions on how you can get more involved with your local Vue community, reach out at @Vuejs_Events!hhuh(hh	h}ubh)}(h}(hNh	}(h5https://v2.vuejs.org/v2/guide/components-registrationh
!Component Registration — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Component Registration
This page assumes you’ve already read the Components Basics. Read that first if you are new to components.
Component Names
When registering a component, it will always be given a name. For example, in the global registration we’ve seen so far:
|
The component’s name is the first argument of Vue.component
.
The name you give a component may depend on where you intend to use it. When using a component directly in the DOM (as opposed to in a string template or single-file component), we strongly recommend following the W3C rules for custom tag names (all-lowercase, must contain a hyphen). This helps you avoid conflicts with current and future HTML elements.
You can see other recommendations for component names in the Style Guide.
Name Casing
You have two options when defining component names:
With kebab-case
|
When defining a component with kebab-case, you must also use kebab-case when referencing its custom element, such as in <my-component-name>
.
With PascalCase
|
When defining a component with PascalCase, you can use either case when referencing its custom element. That means both <my-component-name>
and <MyComponentName>
are acceptable. Note, however, that only kebab-case names are valid directly in the DOM (i.e. non-string templates).
Global Registration
So far, we’ve only created components using Vue.component
:
|
These components are globally registered. That means they can be used in the template of any root Vue instance (new Vue
) created after registration. For example:
|
|
This even applies to all subcomponents, meaning all three of these components will also be available inside each other.
Local Registration
Global registration often isn’t ideal. For example, if you’re using a build system like Webpack, globally registering all components means that even if you stop using a component, it could still be included in your final build. This unnecessarily increases the amount of JavaScript your users have to download.
In these cases, you can define your components as plain JavaScript objects:
|
Then define the components you’d like to use in a components
option:
|
For each property in the components
object, the key will be the name of the custom element, while the value will contain the options object for the component.
Note that locally registered components are not also available in subcomponents. For example, if you wanted ComponentA
to be available in ComponentB
, you’d have to use:
|
Or if you’re using ES2015 modules, such as through Babel and Webpack, that might look more like:
|
Note that in ES2015+, placing a variable name like ComponentA
inside an object is shorthand for ComponentA: ComponentA
, meaning the name of the variable is both:
- the custom element name to use in the template, and
- the name of the variable containing the component options
Module Systems
If you’re not using a module system with import
/require
, you can probably skip this section for now. If you are, we have some special instructions and tips just for you.
Local Registration in a Module System
If you’re still here, then it’s likely you’re using a module system, such as with Babel and Webpack. In these cases, we recommend creating a components
directory, with each component in its own file.
Then you’ll need to import each component you’d like to use, before you locally register it. For example, in a hypothetical ComponentB.js
or ComponentB.vue
file:
|
Now both ComponentA
and ComponentC
can be used inside ComponentB
‘s template.
Automatic Global Registration of Base Components
Many of your components will be relatively generic, possibly only wrapping an element like an input or a button. We sometimes refer to these as base components and they tend to be used very frequently across your components.
The result is that many components may include long lists of base components:
|
Just to support relatively little markup in a template:
|
Fortunately, if you’re using Webpack (or Vue CLI 3+, which uses Webpack internally), you can use require.context
to globally register only these very common base components. Here’s an example of the code you might use to globally import base components in your app’s entry file (e.g. src/main.js
):
|
Remember that global registration must take place before the root Vue instance is created (with new Vue
). Here’s an example of this pattern in a real project context.hhuh(hh	h}ubh)}(h}(hNh	}(h/https://v2.vuejs.org/v2/guide/migration-vue-2-7h
Migration to Vue 2.7 — Vue.jsuhX[  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Migration to Vue 2.7
Vue 2.7 is the latest minor version of Vue 2. It provides built-in support for the Composition API.
Despite Vue 3 now being the default version, we understand that there are still many users who have to stay on Vue 2 due to dependency compatibility, browser support requirements, or simply not enough bandwidth to upgrade. In Vue 2.7, we have backported some of the most important features from Vue 3 so that Vue 2 users can benefit from them as well.
Backported Features
- Composition API
- SFC
<script setup>
- SFC CSS v-bind
In addition, the following APIs are also supported:
defineComponent()
with improved type inference (compared toVue.extend
)h()
,useSlot()
,useAttrs()
,useCssModules()
set()
,del()
andnextTick()
are also provided as named exports in ESM builds.The
emits
option is also supported, but only for type-checking purposes (does not affect runtime behavior)2.7 also supports using ESNext syntax in template expressions. When using a build system, the compiled template render function will go through the same loaders / plugins configured for normal JavaScript. This means if you have configured Babel for
.js
files, it will also apply to the expressions in your SFC templates.
Notes on API exposure
In ESM builds, these APIs are provided as named exports (and named exports only):
import Vue, { ref } from "vue";
Vue.ref; // undefined, use named export insteadIn UMD and CJS builds, these APIs are exposed as properties on the global
Vue
object.When bundling with CJS builds externalized, bundlers should be able to handle ESM interop when externalizing CJS builds.
Behavior Differences from Vue 3
The Composition API is backported using Vue 2’s getter/setter-based reactivity system to ensure browser compatibility. This means there are some important behavior differences from Vue 3’s proxy-based system:
All Vue 2 change detection caveats still apply.
reactive()
,ref()
, andshallowReactive()
will directly convert original objects instead of creating proxies. This means:// true in 2.7, false in 3.x
reactive(foo) === foo;readonly()
does create a separate object, but it won’t track newly added properties and does not work on arrays.Avoid using arrays as root values in
reactive()
because without property access the array’s mutation won’t be tracked (this will result in a warning).Reactivity APIs ignore properties with symbol keys.
In addition, the following features are explicitly NOT ported:
- ❌
createApp()
(Vue 2 doesn’t have isolated app scope) - ❌ Top-level
await
in<script setup>
(Vue 2 does not support async component initialization) - ❌ TypeScript syntax in template expressions (incompatible w/ Vue 2 parser)
- ❌ Reactivity transform (still experimental)
- ❌
expose
option is not supported for options components (butdefineExpose()
is supported in<script setup>
).
Upgrade Guide
Vue CLI / webpack
Upgrade local
@vue/cli-xxx
dependencies the latest version in your major version range (if applicable):~4.5.18
for v4~5.0.6
for v5
Upgrade
vue
to^2.7.0
. You can also removevue-template-compiler
from the dependencies - it is no longer needed in 2.7.Note: if you are using
@vue/test-utils
, you will need to keepvue-template-compiler
in the dependencies because test utils rely on some APIs only exposed in this package.Check your package manager lockfile to ensure the following dependencies meet the version requirements. They may be transitive dependencies not listed in
package.json
.vue-loader
:^15.10.0
vue-demi
:^0.13.1
If not, you will need to remove
node_modules
and the lockfile and perform a fresh install to ensure they are bumped to the latest version.If you were previously using
@vue/composition-api
, update imports from it tovue
instead. Note that some APIs exported by the plugin, e.g.createApp
, are not ported in 2.7.Update
eslint-plugin-vue
to latest version (9+) if you run into unused variable lint errors when using<script setup>
.The SFC compiler for 2.7 now uses PostCSS 8 (upgraded from 7). PostCSS 8 should be backwards compatible with most plugins, but the upgrade may cause issues if you were previously using a custom PostCSS plugin that can only work with PostCSS 7. In such cases, you will need to upgrade the relevant plugins to their PostCSS 8 compatible versions.
Vite
2.7 support for Vite is provided via a new plugin: @vitejs/plugin-vue2. This new plugin requires Vue 2.7 or above and supersedes the existing vite-plugin-vue2.
Note that the new plugin does not handle Vue-specific JSX / TSX transform, which is intentional. Vue 2 JSX / TSX transform for Vite is handled in a separate, dedicated plugin: @vitejs/plugin-vue2-jsx.
Volar Compatibility
2.7 ships improved type definitions so it is no longer necessary to install @vue/runtime-dom
just for Volar template type inference support. All you need now is the following config in tsconfig.json
:
|
Devtools Support
Vue Devtools 6.2.0 has added support for inspecting 2.7 Composition API state, but the extensions may still need a few days to go through review on respective publishing platforms.
Implications of the 2.7 Release
As stated before, 2.7 is the final minor release of Vue 2.x. After this release, Vue 2 has entered LTS (long-term support) which lasts for 18 months from now, and will no longer receive new features.
This means Vue 2 will reach End of Life on December 31st, 2023. We believe this should provide plenty of time for most of the ecosystem to migrate over to Vue 3. However, we also understand that there could be teams or projects that cannot upgrade by this timeline while still need to fullfil security and compliance requirements. If your team expects to be using Vue 2 beyond end of 2023, make sure to plan head and understand your options: learn more about Vue 2 LTS and Extended Support.hhuh(hh	h}ubh)}(h}(hNh	}(h-https://v2.vuejs.org/v2/guide/render-functionh
!Render Functions & JSX — Vue.jsuhX,  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Render Functions & JSX
Basics
Vue recommends using templates to build your HTML in the vast majority of cases. There are situations however, where you really need the full programmatic power of JavaScript. That’s where you can use the render function, a closer-to-the-compiler alternative to templates.
Let’s dive into a simple example where a render
function would be practical. Say you want to generate anchored headings:
|
For the HTML above, you decide you want this component interface:
|
When you get started with a component that only generates a heading based on the level
prop, you quickly arrive at this:
|
|
That template doesn’t feel great. It’s not only verbose, but we’re duplicating <slot></slot>
for every heading level and will have to do the same when we add the anchor element.
While templates work great for most components, it’s clear that this isn’t one of them. So let’s try rewriting it with a render
function:
|
Much simpler! Sort of. The code is shorter, but also requires greater familiarity with Vue instance properties. In this case, you have to know that when you pass children without a v-slot
directive into a component, like the Hello world!
inside of anchored-heading
, those children are stored on the component instance at $slots.default
. If you haven’t already, it’s recommended to read through the instance properties API before diving into render functions.
Nodes, Trees, and the Virtual DOM
Before we dive into render functions, it’s important to know a little about how browsers work. Take this HTML for example:
|
When a browser reads this code, it builds a tree of “DOM nodes” to help it keep track of everything, just as you might build a family tree to keep track of your extended family.
The tree of DOM nodes for the HTML above looks like this:
Every element is a node. Every piece of text is a node. Even comments are nodes! A node is just a piece of the page. And as in a family tree, each node can have children (i.e. each piece can contain other pieces).
Updating all these nodes efficiently can be difficult, but thankfully, you never have to do it manually. Instead, you tell Vue what HTML you want on the page, in a template:
|
Or a render function:
|
And in both cases, Vue automatically keeps the page updated, even when blogTitle
changes.
The Virtual DOM
Vue accomplishes this by building a virtual DOM to keep track of the changes it needs to make to the real DOM. Taking a closer look at this line:
|
What is createElement
actually returning? It’s not exactly a real DOM element. It could perhaps more accurately be named createNodeDescription
, as it contains information describing to Vue what kind of node it should render on the page, including descriptions of any child nodes. We call this node description a “virtual node”, usually abbreviated to VNode. “Virtual DOM” is what we call the entire tree of VNodes, built by a tree of Vue components.
createElement
Arguments
The next thing you’ll have to become familiar with is how to use template features in the createElement
function. Here are the arguments that createElement
accepts:
|
The Data Object In-Depth
One thing to note: similar to how v-bind:class
and v-bind:style
have special treatment in templates, they have their own top-level fields in VNode data objects. This object also allows you to bind normal HTML attributes as well as DOM properties such as innerHTML
(this would replace the v-html
directive):
|
Complete Example
With this knowledge, we can now finish the component we started:
|
Constraints
VNodes Must Be Unique
All VNodes in the component tree must be unique. That means the following render function is invalid:
|
If you really want to duplicate the same element/component many times, you can do so with a factory function. For example, the following render function is a perfectly valid way of rendering 20 identical paragraphs:
|
Replacing Template Features with Plain JavaScript
v-if
and v-for
Wherever something can be easily accomplished in plain JavaScript, Vue render functions do not provide a proprietary alternative. For example, in a template using v-if
and v-for
:
|
This could be rewritten with JavaScript’s if
/else
and map
in a render function:
|
v-model
There is no direct v-model
counterpart in render functions - you will have to implement the logic yourself:
|
This is the cost of going lower-level, but it also gives you much more control over the interaction details compared to v-model
.
Event & Key Modifiers
For the .passive
, .capture
and .once
event modifiers, Vue offers prefixes that can be used with on
:
Modifier(s) | Prefix |
---|---|
.passive |
& |
.capture |
! |
.once |
~ |
.capture.once or.once.capture |
~! |
For example:
|
For all other event and key modifiers, no proprietary prefix is necessary, because you can use event methods in the handler:
Modifier(s) | Equivalent in Handler |
---|---|
.stop |
event.stopPropagation() |
.prevent |
event.preventDefault() |
.self |
if (event.target !== event.currentTarget) return |
Keys:.enter , .13 |
if (event.keyCode !== 13) return (change 13 to another key code for other key modifiers) |
Modifiers Keys:.ctrl , .alt , .shift , .meta |
if (!event.ctrlKey) return (change ctrlKey to altKey , shiftKey , or metaKey , respectively) |
Here’s an example with all of these modifiers used together:
|
Slots
You can access static slot contents as Arrays of VNodes from this.$slots
:
|
And access scoped slots as functions that return VNodes from this.$scopedSlots
:
|
To pass scoped slots to a child component using render functions, use the scopedSlots
field in VNode data:
|
JSX
If you’re writing a lot of render
functions, it might feel painful to write something like this:
|
Especially when the template version is so simple in comparison:
|
That’s why there’s a Babel plugin to use JSX with Vue, getting us back to a syntax that’s closer to templates:
|
Aliasing createElement
to h
is a common convention you’ll see in the Vue ecosystem and is actually required for JSX. Starting with version 3.4.0 of the Babel plugin for Vue, we automatically inject const h = this.$createElement
in any method and getter (not functions or arrow functions), declared in ES2015 syntax that has JSX, so you can drop the (h)
parameter. With prior versions of the plugin, your app would throw an error if h
was not available in the scope.
For more on how JSX maps to JavaScript, see the usage docs.
Functional Components
The anchored heading component we created earlier is relatively simple. It doesn’t manage any state, watch any state passed to it, and it has no lifecycle methods. Really, it’s only a function with some props.
In cases like this, we can mark components as functional
, which means that they’re stateless (no reactive data) and instanceless (no this
context). A functional component looks like this:
|
Note: in versions before 2.3.0, the
props
option is required if you wish to accept props in a functional component. In 2.3.0+ you can omit theprops
option and all attributes found on the component node will be implicitly extracted as props.The reference will be HTMLElement when used with functional components because they’re stateless and instanceless.
In 2.5.0+, if you are using single-file components, template-based functional components can be declared with:
|
Everything the component needs is passed through context
, which is an object containing:
props
: An object of the provided propschildren
: An array of the VNode childrenslots
: A function returning a slots objectscopedSlots
: (2.6.0+) An object that exposes passed-in scoped slots. Also exposes normal slots as functions.data
: The entire data object, passed to the component as the 2nd argument ofcreateElement
parent
: A reference to the parent componentlisteners
: (2.3.0+) An object containing parent-registered event listeners. This is an alias todata.on
injections
: (2.3.0+) if using theinject
option, this will contain resolved injections.
After adding functional: true
, updating the render function of our anchored heading component would require adding the context
argument, updating this.$slots.default
to context.children
, then updating this.level
to context.props.level
.
Since functional components are just functions, they’re much cheaper to render.
They’re also very useful as wrapper components. For example, when you need to:
- Programmatically choose one of several other components to delegate to
- Manipulate children, props, or data before passing them on to a child component
Here’s an example of a smart-list
component that delegates to more specific components, depending on the props passed to it:
|
Passing Attributes and Events to Child Elements/Components
On normal components, attributes not defined as props are automatically added to the root element of the component, replacing or intelligently merging with any existing attributes of the same name.
Functional components, however, require you to explicitly define this behavior:
|
By passing context.data
as the second argument to createElement
, we are passing down any attributes or event listeners used on my-functional-button
. It’s so transparent, in fact, that events don’t even require the .native
modifier.
If you are using template-based functional components, you will also have to manually add attributes and listeners. Since we have access to the individual context contents, we can use data.attrs
to pass along any HTML attributes and listeners
(the alias for data.on
) to pass along any event listeners.
|
slots()
vs children
You may wonder why we need both slots()
and children
. Wouldn’t slots().default
be the same as children
? In some cases, yes - but what if you have a functional component with the following children?
|
For this component, children
will give you both paragraphs, slots().default
will give you only the second, and slots().foo
will give you only the first. Having both children
and slots()
therefore allows you to choose whether this component knows about a slot system or perhaps delegates that responsibility to another component by passing along children
.
Template Compilation
You may be interested to know that Vue’s templates actually compile to render functions. This is an implementation detail you usually don’t need to know about, but if you’d like to see how specific template features are compiled, you may find it interesting. Below is a little demo using Vue.compile
to live-compile a template string:     hhuh(hh	h}ubh)}(h}(hNh	}(h(https://v2.vuejs.org/v2/guide/componentsh
Components Basics — Vue.jsuhX)  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Components Basics
Base Example
Here’s an example of a Vue component:
|
Components are reusable Vue instances with a name: in this case, <button-counter>
. We can use this component as a custom element inside a root Vue instance created with new Vue
:
|
|
Since components are reusable Vue instances, they accept the same options as new Vue
, such as data
, computed
, watch
, methods
, and lifecycle hooks. The only exceptions are a few root-specific options like el
.
Reusing Components
Components can be reused as many times as you want:
|
Notice that when clicking on the buttons, each one maintains its own, separate count
. That’s because each time you use a component, a new instance of it is created.
data
Must Be a Function
When we defined the <button-counter>
component, you may have noticed that data
wasn’t directly provided an object, like this:
|
Instead, a component’s data
option must be a function, so that each instance can maintain an independent copy of the returned data object:
|
If Vue didn’t have this rule, clicking on one button would affect the data of all other instances, like below:
Organizing Components
It’s common for an app to be organized into a tree of nested components:
For example, you might have components for a header, sidebar, and content area, each typically containing other components for navigation links, blog posts, etc.
To use these components in templates, they must be registered so that Vue knows about them. There are two types of component registration: global and local. So far, we’ve only registered components globally, using Vue.component
:
|
Globally registered components can be used in the template of any root Vue instance (new Vue
) created afterwards – and even inside all subcomponents of that Vue instance’s component tree.
That’s all you need to know about registration for now, but once you’ve finished reading this page and feel comfortable with its content, we recommend coming back later to read the full guide on Component Registration.
Passing Data to Child Components with Props
Earlier, we mentioned creating a component for blog posts. The problem is, that component won’t be useful unless you can pass data to it, such as the title and content of the specific post we want to display. That’s where props come in.
Props are custom attributes you can register on a component. When a value is passed to a prop attribute, it becomes a property on that component instance. To pass a title to our blog post component, we can include it in the list of props this component accepts, using a props
option:
|
A component can have as many props as you’d like and by default, any value can be passed to any prop. In the template above, you’ll see that we can access this value on the component instance, just like with data
.
Once a prop is registered, you can pass data to it as a custom attribute, like this:
|
In a typical app, however, you’ll likely have an array of posts in data
:
|
Then want to render a component for each one:
|
Above, you’ll see that we can use v-bind
to dynamically pass props. This is especially useful when you don’t know the exact content you’re going to render ahead of time, like when fetching posts from an API.
That’s all you need to know about props for now, but once you’ve finished reading this page and feel comfortable with its content, we recommend coming back later to read the full guide on Props.
A Single Root Element
When building out a <blog-post>
component, your template will eventually contain more than just the title:
|
At the very least, you’ll want to include the post’s content:
|
If you try this in your template, however, Vue will show an error, explaining that every component must have a single root element. You can fix this error by wrapping the template in a parent element, such as:
|
As our component grows, it’s likely we’ll not only need the title and content of a post, but also the published date, comments, and more. Defining a prop for each related piece of information could become very annoying:
|
So this might be a good time to refactor the <blog-post>
component to accept a single post
prop instead:
|
|
The above example and some future ones use JavaScript’s template literal to make multi-line templates more readable. These are not supported by Internet Explorer (IE), so if you must support IE and are not transpiling (e.g. with Babel or TypeScript), use newline escapes instead.
Now, whenever a new property is added to post
objects, it will automatically be available inside <blog-post>
.
Listening to Child Components Events
As we develop our <blog-post>
component, some features may require communicating back up to the parent. For example, we may decide to include an accessibility feature to enlarge the text of blog posts, while leaving the rest of the page its default size:
In the parent, we can support this feature by adding a postFontSize
data property:
|
Which can be used in the template to control the font size of all blog posts:
|
Now let’s add a button to enlarge the text right before the content of every post:
|
The problem is, this button doesn’t do anything:
|
When we click on the button, we need to communicate to the parent that it should enlarge the text of all posts. Fortunately, Vue instances provide a custom events system to solve this problem. The parent can choose to listen to any event on the child component instance with v-on
, just as we would with a native DOM event:
|
Then the child component can emit an event on itself by calling the built-in $emit
method, passing the name of the event:
|
Thanks to the v-on:enlarge-text="postFontSize += 0.1"
listener, the parent will receive the event and update postFontSize
value.
Emitting a Value With an Event
It’s sometimes useful to emit a specific value with an event. For example, we may want the <blog-post>
component to be in charge of how much to enlarge the text by. In those cases, we can use $emit
‘s 2nd parameter to provide this value:
|
Then when we listen to the event in the parent, we can access the emitted event’s value with $event
:
|
Or, if the event handler is a method:
|
Then the value will be passed as the first parameter of that method:
|
Using v-model
on Components
Custom events can also be used to create custom inputs that work with v-model
. Remember that:
|
does the same thing as:
|
When used on a component, v-model
instead does this:
|
For this to actually work though, the <input>
inside the component must:
- Bind the
value
attribute to avalue
prop - On
input
, emit its own custominput
event with the new value
Here’s that in action:
|
Now v-model
should work perfectly with this component:
|
That’s all you need to know about custom component events for now, but once you’ve finished reading this page and feel comfortable with its content, we recommend coming back later to read the full guide on Custom Events.
Content Distribution with Slots
Just like with HTML elements, it’s often useful to be able to pass content to a component, like this:
|
Which might render something like:
Fortunately, this task is made very simple by Vue’s custom <slot>
element:
|
As you’ll see above, we just add the slot where we want it to go – and that’s it. We’re done!
That’s all you need to know about slots for now, but once you’ve finished reading this page and feel comfortable with its content, we recommend coming back later to read the full guide on Slots.
Dynamic Components
Sometimes, it’s useful to dynamically switch between components, like in a tabbed interface:
The above is made possible by Vue’s <component>
element with the is
special attribute:
|
In the example above, currentTabComponent
can contain either:
- the name of a registered component, or
- a component’s options object
See this example to experiment with the full code, or this version for an example binding to a component’s options object, instead of its registered name.
Keep in mind that this attribute can be used with regular HTML elements, however they will be treated as components, which means all attributes will be bound as DOM attributes. For some properties such as value
to work as you would expect, you will need to bind them using the .prop
modifier.
That’s all you need to know about dynamic components for now, but once you’ve finished reading this page and feel comfortable with its content, we recommend coming back later to read the full guide on Dynamic & Async Components.
DOM Template Parsing Caveats
Some HTML elements, such as <ul>
, <ol>
, <table>
and <select>
have restrictions on what elements can appear inside them, and some elements such as <li>
, <tr>
, and <option>
can only appear inside certain other elements.
This will lead to issues when using components with elements that have such restrictions. For example:
|
The custom component <blog-post-row>
will be hoisted out as invalid content, causing errors in the eventual rendered output. Fortunately, the is
special attribute offers a workaround:
|
It should be noted that this limitation does not apply if you are using string templates from one of the following sources:
- String templates (e.g.
template: '...'
) - Single-file (
.vue
) components <script type="text/x-template">
That’s all you need to know about DOM template parsing caveats for now – and actually, the end of Vue’s Essentials. Congratulations! There’s still more to learn, but first, we recommend taking a break to play with Vue yourself and build something fun.
Once you feel comfortable with the knowledge you’ve just digested, we recommend coming back to read the full guide on Dynamic & Async Components, as well as the other pages in the Components In-Depth section of the sidebar.hhuh(hh	h}ubh)}(h}(hNh	}(h!https://v2.vuejs.org/v2/guide/ssrh
 Server-Side Rendering — Vue.jsuhX	  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Server-Side Rendering
The Complete SSR Guide
We have created a standalone guide for creating server-rendered Vue applications. This is a very in-depth guide for those who are already familiar with client-side Vue development, server-side Node.js development and webpack. Check it out at v2.ssr.vuejs.org.
Nuxt.js
Properly configuring all the discussed aspects of a production-ready server-rendered app can be a daunting task. Luckily, there is an excellent community project that aims to make all of this easier: Nuxt.js. Nuxt.js is a higher-level framework built on top of the Vue ecosystem which provides an extremely streamlined development experience for writing universal Vue applications. Better yet, you can even use it as a static site generator (with pages authored as single-file Vue components)! We highly recommend giving it a try.
Quasar Framework SSR + PWA
Quasar Framework will generate an SSR app (with optional PWA handoff) that leverages its best-in-class build system, sensible configuration and developer extensibility to make designing and building your idea a breeze. With over one hundred specific “Material Design 2.0”-compliant components, you can decide which ones to execute on the server, which are available in the browser - and even manage the <meta>
tags of your site. Quasar is a node.js and webpack based development environment that supercharges and streamlines rapid development of SPA, PWA, SSR, Electron, Capacitor and Cordova apps - all from one codebase.hhuh(hh	h}ubh)}(h}(hNh	}(h.https://v2.vuejs.org/v2/guide/state-managementh
State Management — Vue.jsuhX:  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
State Management
Official Flux-Like Implementation
Large applications can often grow in complexity, due to multiple pieces of state scattered across many components and the interactions between them. To solve this problem, Vue offers vuex: our own Elm-inspired state management library. It even integrates into vue-devtools, providing zero-setup access to time travel debugging.
Information for React Developers
If you’re coming from React, you may be wondering how vuex compares to redux, the most popular Flux implementation in that ecosystem. Redux is actually view-layer agnostic, so it can easily be used with Vue via simple bindings. Vuex is different in that it knows it’s in a Vue app. This allows it to better integrate with Vue, offering a more intuitive API and improved development experience.
Simple State Management from Scratch
It is often overlooked that the source of truth in Vue applications is the raw data
object - a Vue instance only proxies access to it. Therefore, if you have a piece of state that should be shared by multiple instances, you can share it by identity:
|
Now whenever sourceOfTruth
is mutated, both vmA
and vmB
will update their views automatically. Subcomponents within each of these instances would also have access via this.$root.$data
. We have a single source of truth now, but debugging would be a nightmare. Any piece of data could be changed by any part of our app at any time, without leaving a trace.
To help solve this problem, we can adopt a store pattern:
|
Notice all actions that mutate the store’s state are put inside the store itself. This type of centralized state management makes it easier to understand what type of mutations could happen and how they are triggered. Now when something goes wrong, we’ll also have a log of what happened leading up to the bug.
In addition, each instance/component can still own and manage its own private state:
|
It’s important to note that you should never replace the original state object in your actions - the components and the store need to share reference to the same object in order for mutations to be observed.
As we continue developing the convention where components are never allowed to directly mutate state that belongs to a store, but should instead dispatch events that notify the store to perform actions, we eventually arrive at the Flux architecture. The benefit of this convention is we can record all state mutations happening to the store and implement advanced debugging helpers such as mutation logs, snapshots, and history re-rolls / time travel.
This brings us full circle back to vuex, so if you’ve read this far it’s probably time to try it out!hhuh(hh	h}ubh)}(h}(hNh	}(h&https://v2.vuejs.org/v2/guide/computedh
+Computed Properties and Watchers — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Computed Properties and Watchers
Computed Properties
In-template expressions are very convenient, but they are meant for simple operations. Putting too much logic in your templates can make them bloated and hard to maintain. For example:
|
At this point, the template is no longer simple and declarative. You have to look at it for a second before realizing that it displays message
in reverse. The problem is made worse when you want to include the reversed message in your template more than once.
That’s why for any complex logic, you should use a computed property.
Basic Example
|
|
Result:
Original message: "{{ message }}"
Computed reversed message: "{{ reversedMessage }}"
Here we have declared a computed property reversedMessage
. The function we provided will be used as the getter function for the property vm.reversedMessage
:
|
You can open the console and play with the example vm yourself. The value of vm.reversedMessage
is always dependent on the value of vm.message
.
You can data-bind to computed properties in templates just like a normal property. Vue is aware that vm.reversedMessage
depends on vm.message
, so it will update any bindings that depend on vm.reversedMessage
when vm.message
changes. And the best part is that we’ve created this dependency relationship declaratively: the computed getter function has no side effects, which makes it easier to test and understand.
Computed Caching vs Methods
You may have noticed we can achieve the same result by invoking a method in the expression:
|
|
Instead of a computed property, we can define the same function as a method. For the end result, the two approaches are indeed exactly the same. However, the difference is that computed properties are cached based on their reactive dependencies. A computed property will only re-evaluate when some of its reactive dependencies have changed. This means as long as message
has not changed, multiple access to the reversedMessage
computed property will immediately return the previously computed result without having to run the function again.
This also means the following computed property will never update, because Date.now()
is not a reactive dependency:
|
In comparison, a method invocation will always run the function whenever a re-render happens.
Why do we need caching? Imagine we have an expensive computed property A, which requires looping through a huge Array and doing a lot of computations. Then we may have other computed properties that in turn depend on A. Without caching, we would be executing A’s getter many more times than necessary! In cases where you do not want caching, use a method instead.
Computed vs Watched Property
Vue does provide a more generic way to observe and react to data changes on a Vue instance: watch properties. When you have some data that needs to change based on some other data, it is tempting to overuse watch
- especially if you are coming from an AngularJS background. However, it is often a better idea to use a computed property rather than an imperative watch
callback. Consider this example:
|
|
The above code is imperative and repetitive. Compare it with a computed property version:
|
Much better, isn’t it?
Computed Setter
Computed properties are by default getter-only, but you can also provide a setter when you need it:
|
Now when you run vm.fullName = 'John Doe'
, the setter will be invoked and vm.firstName
and vm.lastName
will be updated accordingly.
Watchers
While computed properties are more appropriate in most cases, there are times when a custom watcher is necessary. That’s why Vue provides a more generic way to react to data changes through the watch
option. This is most useful when you want to perform asynchronous or expensive operations in response to changing data.
For example:
|
|
Result:
Ask a yes/no question:
{{ answer }}
In this case, using the watch
option allows us to perform an asynchronous operation (accessing an API), limit how often we perform that operation, and set intermediary states until we get a final answer. None of that would be possible with a computed property.
In addition to the watch
option, you can also use the imperative vm.$watch API.hhuh(hh	h}ubh)}(h}(hNh	}(h-https://v2.vuejs.org/v2/guide/class-and-styleh
#Class and Style Bindings — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Class and Style Bindings
A common need for data binding is manipulating an element’s class list and its inline styles. Since they are both attributes, we can use v-bind
to handle them: we only need to calculate a final string with our expressions. However, meddling with string concatenation is annoying and error-prone. For this reason, Vue provides special enhancements when v-bind
is used with class
and style
. In addition to strings, the expressions can also evaluate to objects or arrays.
Binding HTML Classes
Object Syntax
We can pass an object to v-bind:class
to dynamically toggle classes:
|
The above syntax means the presence of the active
class will be determined by the truthiness of the data property isActive
.
You can have multiple classes toggled by having more fields in the object. In addition, the v-bind:class
directive can also co-exist with the plain class
attribute. So given the following template:
|
And the following data:
|
It will render:
|
When isActive
or hasError
changes, the class list will be updated accordingly. For example, if hasError
becomes true
, the class list will become "static active text-danger"
.
The bound object doesn’t have to be inline:
|
|
This will render the same result. We can also bind to a computed property that returns an object. This is a common and powerful pattern:
|
|
Array Syntax
We can pass an array to v-bind:class
to apply a list of classes:
|
|
Which will render:
|
If you would like to also toggle a class in the list conditionally, you can do it with a ternary expression:
|
This will always apply errorClass
, but will only apply activeClass
when isActive
is truthy.
However, this can be a bit verbose if you have multiple conditional classes. That’s why it’s also possible to use the object syntax inside array syntax:
|
With Components
This section assumes knowledge of Vue Components. Feel free to skip it and come back later.
When you use the class
attribute on a custom component, those classes will be added to the component’s root element. Existing classes on this element will not be overwritten.
For example, if you declare this component:
|
Then add some classes when using it:
|
The rendered HTML will be:
|
The same is true for class bindings:
|
When isActive
is truthy, the rendered HTML will be:
|
Binding Inline Styles
Object Syntax
The object syntax for v-bind:style
is pretty straightforward - it looks almost like CSS, except it’s a JavaScript object. You can use either camelCase or kebab-case (use quotes with kebab-case) for the CSS property names:
|
|
It is often a good idea to bind to a style object directly so that the template is cleaner:
|
|
Again, the object syntax is often used in conjunction with computed properties that return objects.
Array Syntax
The array syntax for v-bind:style
allows you to apply multiple style objects to the same element:
|
Auto-prefixing
When you use a CSS property that requires vendor prefixes in v-bind:style
, for example transform
, Vue will automatically detect and add appropriate prefixes to the applied styles.
Multiple Values
2.3.0+
Starting in 2.3.0+ you can provide an array of multiple (prefixed) values to a style property, for example:
|
This will only render the last value in the array which the browser supports. In this example, it will render display: flex
for browsers that support the unprefixed version of flexbox.hhuh(hh	h}ubh)}(h}(hNh	}(h4https://v2.vuejs.org/v2/guide/single-file-componentsh
!Single File Components — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Single File Components
Introduction
In many Vue projects, global components will be defined using Vue.component
, followed by new Vue({ el: '#container' })
to target a container element in the body of every page.
This can work very well for small to medium-sized projects, where JavaScript is only used to enhance certain views. In more complex projects however, or when your frontend is entirely driven by JavaScript, these disadvantages become apparent:
- Global definitions force unique names for every component
- String templates lack syntax highlighting and require ugly slashes for multiline HTML
- No CSS support means that while HTML and JavaScript are modularized into components, CSS is conspicuously left out
- No build step restricts us to HTML and ES5 JavaScript, rather than preprocessors like Pug (formerly Jade) and Babel
All of these are solved by single-file components with a .vue
extension, made possible with build tools such as Webpack or Browserify.
Here’s an example of a file we’ll call Hello.vue
:
Now we get:
As promised, we can also use preprocessors such as Pug, Babel (with ES2015 modules), and Stylus for cleaner and more feature-rich components.
These specific languages are only examples. You could as easily use Bublé, TypeScript, SCSS, PostCSS - or whatever other preprocessors that help you be productive. If using Webpack with vue-loader
, it also has first-class support for CSS Modules.
What About Separation of Concerns?
One important thing to note is that separation of concerns is not equal to separation of file types. In modern UI development, we have found that instead of dividing the codebase into three huge layers that interweave with one another, it makes much more sense to divide them into loosely-coupled components and compose them. Inside a component, its template, logic and styles are inherently coupled, and collocating them actually makes the component more cohesive and maintainable.
Even if you don’t like the idea of Single-File Components, you can still leverage its hot-reloading and pre-compilation features by separating your JavaScript and CSS into separate files:
|
Getting Started
Example Sandbox
If you want to dive right in and start playing with single-file components, check out this simple todo app on CodeSandbox.
For Users New to Module Build Systems in JavaScript
With .vue
components, we’re entering the realm of advanced JavaScript applications. That means learning to use a few additional tools if you haven’t already:
Node Package Manager (NPM): Read the Getting Started guide section about how to get packages from the registry.
Modern JavaScript with ES2015/16: Read through Babel’s Learn ES2015 guide. You don’t have to memorize every feature right now, but keep this page as a reference you can come back to.
After you’ve taken a day to dive into these resources, we recommend checking out Vue CLI 3. Follow the instructions and you should have a Vue project with .vue
components, ES2015, Webpack and hot-reloading in no time!
For Advanced Users
The CLI takes care of most of the tooling configurations for you, but also allows fine-grained customization through its own config options.
In case you prefer setting up your own build setup from scratch, you will need to manually configure webpack with vue-loader. To learn more about webpack itself, check out their official docs and Webpack Academy.hhuh(hh	h}ubh)}(h}(hNh	}(h1https://v2.vuejs.org/v2/guide/transitioning-stateh
State Transitions — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
State Transitions
Vue’s transition system offers many simple ways to animate entering, leaving, and lists, but what about animating your data itself? For example:
- numbers and calculations
- colors displayed
- the positions of SVG nodes
- the sizes and other properties of elements
All of these are either already stored as raw numbers or can be converted into numbers. Once we do that, we can animate these state changes using 3rd-party libraries to tween state, in combination with Vue’s reactivity and component systems.
Animating State with Watchers
Watchers allow us to animate changes of any numerical property into another property. That may sound complicated in the abstract, so let’s dive into an example using GreenSock:
|
|
{{ animatedNumber }}
When you update the number, the change is animated below the input. This makes for a nice demo, but what about something that isn’t directly stored as a number, like any valid CSS color for example? Here’s how we could accomplish this with Tween.js and Color.js:
|
|
|
Preview:
{{ tweenedCSSColor }}
Dynamic State Transitions
As with Vue’s transition components, the data backing state transitions can be updated in real time, which is especially useful for prototyping! Even using a simple SVG polygon, you can achieve many effects that would be difficult to conceive of until you’ve played with the variables a little.
See this example for the complete code behind the above demo.
Organizing Transitions into Components
Managing many state transitions can quickly increase the complexity of a Vue instance or component. Fortunately, many animations can be extracted out into dedicated child components. Let’s do this with the animated integer from our earlier example:
|
|
Within child components, we can use any combination of transition strategies that have been covered on this page, along with those offered by Vue’s built-in transition system. Together, there are very few limits to what can be accomplished.
Bringing Designs to Life
To animate, by one definition, means to bring to life. Unfortunately, when designers create icons, logos, and mascots, they’re usually delivered as images or static SVGs. So although GitHub’s octocat, Twitter’s bird, and many other logos resemble living creatures, they don’t really seem alive.
Vue can help. Since SVGs are just data, we only need examples of what these creatures look like when excited, thinking, or alarmed. Then Vue can help transition between these states, making your welcome pages, loading indicators, and notifications more emotionally compelling.
Sarah Drasner demonstrates this in the demo below, using a combination of timed and interactivity-driven state changes:
See the Pen Vue-controlled Wall-E by Sarah Drasner (@sdras) on CodePen.hhuh(hh	h}ubh)}(h}(hNh	}(h)https://v2.vuejs.org/v2/guide/conditionalh
 Conditional Rendering — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Conditional Rendering
v-if
The directive v-if
is used to conditionally render a block. The block will only be rendered if the directive’s expression returns a truthy value.
|
It is also possible to add an “else block” with v-else
:
|
Conditional Groups with v-if
on <template>
Because v-if
is a directive, it has to be attached to a single element. But what if we want to toggle more than one element? In this case we can use v-if
on a <template>
element, which serves as an invisible wrapper. The final rendered result will not include the <template>
element.
|
v-else
You can use the v-else
directive to indicate an “else block” for v-if
:
|
A v-else
element must immediately follow a v-if
or a v-else-if
element - otherwise it will not be recognized.
v-else-if
New in 2.1.0+
The v-else-if
, as the name suggests, serves as an “else if block” for v-if
. It can also be chained multiple times:
|
Similar to v-else
, a v-else-if
element must immediately follow a v-if
or a v-else-if
element.
Controlling Reusable Elements with key
Vue tries to render elements as efficiently as possible, often re-using them instead of rendering from scratch. Beyond helping make Vue very fast, this can have some useful advantages. For example, if you allow users to toggle between multiple login types:
|
Then switching the loginType
in the code above will not erase what the user has already entered. Since both templates use the same elements, the <input>
is not replaced - just its placeholder
.
Check it out for yourself by entering some text in the input, then pressing the toggle button:
This isn’t always desirable though, so Vue offers a way for you to say, “These two elements are completely separate - don’t re-use them.” Add a key
attribute with unique values:
|
Now those inputs will be rendered from scratch each time you toggle. See for yourself:
Note that the <label>
elements are still efficiently re-used, because they don’t have key
attributes.
v-show
Another option for conditionally displaying an element is the v-show
directive. The usage is largely the same:
|
The difference is that an element with v-show
will always be rendered and remain in the DOM; v-show
only toggles the display
CSS property of the element.
Note that v-show
doesn’t support the <template>
element, nor does it work with v-else
.
v-if
vs v-show
v-if
is “real” conditional rendering because it ensures that event listeners and child components inside the conditional block are properly destroyed and re-created during toggles.
v-if
is also lazy: if the condition is false on initial render, it will not do anything - the conditional block won’t be rendered until the condition becomes true for the first time.
In comparison, v-show
is much simpler - the element is always rendered regardless of initial condition, with CSS-based toggling.
Generally speaking, v-if
has higher toggle costs while v-show
has higher initial render costs. So prefer v-show
if you need to toggle something very often, and prefer v-if
if the condition is unlikely to change at runtime.
v-if
with v-for
Using v-if
and v-for
together is not recommended. See the style guide for further information.
When used together with v-if
, v-for
has a higher priority than v-if
. See the list rendering guide for details.hhuh(hh	h}ubh)}(h}(hNh	}(h(https://v2.vuejs.org/v2/guide/reactivityh
Reactivity in Depth — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Reactivity in Depth
Now it’s time to take a deep dive! One of Vue’s most distinct features is the unobtrusive reactivity system. Models are just plain JavaScript objects. When you modify them, the view updates. It makes state management simple and intuitive, but it’s also important to understand how it works to avoid some common gotchas. In this section, we are going to dig into some of the lower-level details of Vue’s reactivity system.
How Changes Are Tracked
When you pass a plain JavaScript object to a Vue instance as its data
option, Vue will walk through all of its properties and convert them to getter/setters using Object.defineProperty
. This is an ES5-only and un-shimmable feature, which is why Vue doesn’t support IE8 and below.
The getter/setters are invisible to the user, but under the hood they enable Vue to perform dependency-tracking and change-notification when properties are accessed or modified. One caveat is that browser consoles format getter/setters differently when converted data objects are logged, so you may want to install vue-devtools for a more inspection-friendly interface.
Every component instance has a corresponding watcher instance, which records any properties “touched” during the component’s render as dependencies. Later on when a dependency’s setter is triggered, it notifies the watcher, which in turn causes the component to re-render.
Change Detection Caveats
Due to limitations in JavaScript, there are types of changes that Vue cannot detect. However, there are ways to circumvent them to preserve reactivity.
For Objects
Vue cannot detect property addition or deletion. Since Vue performs the getter/setter conversion process during instance initialization, a property must be present in the data
object in order for Vue to convert it and make it reactive. For example:
|
Vue does not allow dynamically adding new root-level reactive properties to an already created instance. However, it’s possible to add reactive properties to a nested object using the Vue.set(object, propertyName, value)
method:
|
You can also use the vm.$set
instance method, which is an alias to the global Vue.set
:
|
Sometimes you may want to assign a number of properties to an existing object, for example using Object.assign()
or _.extend()
. However, new properties added to the object will not trigger changes. In such cases, create a fresh object with properties from both the original object and the mixin object:
|
For Arrays
Vue cannot detect the following changes to an array:
- When you directly set an item with the index, e.g.
vm.items[indexOfItem] = newValue
- When you modify the length of the array, e.g.
vm.items.length = newLength
For example:
|
To overcome caveat 1, both of the following will accomplish the same as vm.items[indexOfItem] = newValue
, but will also trigger state updates in the reactivity system:
|
|
You can also use the vm.$set
instance method, which is an alias for the global Vue.set
:
|
To deal with caveat 2, you can use splice
:
|
Declaring Reactive Properties
Since Vue doesn’t allow dynamically adding root-level reactive properties, you have to initialize Vue instances by declaring all root-level reactive data properties upfront, even with an empty value:
|
If you don’t declare message
in the data option, Vue will warn you that the render function is trying to access a property that doesn’t exist.
There are technical reasons behind this restriction - it eliminates a class of edge cases in the dependency tracking system, and also makes Vue instances play nicer with type checking systems. But there is also an important consideration in terms of code maintainability: the data
object is like the schema for your component’s state. Declaring all reactive properties upfront makes the component code easier to understand when revisited later or read by another developer.
Async Update Queue
In case you haven’t noticed yet, Vue performs DOM updates asynchronously. Whenever a data change is observed, it will open a queue and buffer all the data changes that happen in the same event loop. If the same watcher is triggered multiple times, it will be pushed into the queue only once. This buffered de-duplication is important in avoiding unnecessary calculations and DOM manipulations. Then, in the next event loop “tick”, Vue flushes the queue and performs the actual (already de-duped) work. Internally Vue tries native Promise.then
, MutationObserver
, and setImmediate
for the asynchronous queuing and falls back to setTimeout(fn, 0)
.
For example, when you set vm.someData = 'new value'
, the component will not re-render immediately. It will update in the next “tick”, when the queue is flushed. Most of the time we don’t need to care about this, but it can be tricky when you want to do something that depends on the post-update DOM state. Although Vue.js generally encourages developers to think in a “data-driven” fashion and avoid touching the DOM directly, sometimes it might be necessary to get your hands dirty. In order to wait until Vue.js has finished updating the DOM after a data change, you can use Vue.nextTick(callback)
immediately after the data is changed. The callback will be called after the DOM has been updated. For example:
|
|
There is also the vm.$nextTick()
instance method, which is especially handy inside components, because it doesn’t need global Vue
and its callback’s this
context will be automatically bound to the current Vue instance:
|
Since $nextTick()
returns a promise, you can achieve the same as the above using the new ES2017 async/await syntax:
|hhuh(hh	h}ubh)}(h}(hNh	}(h%https://v2.vuejs.org/v2/guide/testingh
Testing — Vue.jsuhX(  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Testing
Introduction
When it comes to building reliable applications, tests can play a critical role in an individual or team’s ability to build new features, refactor code, fix bugs, etc. While there are many schools of thought with testing, there are three categories often discussed in the context of web applications:
- Unit Testing
- Component Testing
- End-To-End (E2E) Testing
This section aims to provide guidance to navigating the testing ecosystem and choosing the right tools for your Vue application or component library.
Unit Testing
Introduction
Unit tests allow you to test individual units of code in isolation. The purpose of unit testing is to provide developers with confidence in their code. By writing thorough, meaningful tests, you achieve the confidence that as new features are built or your code is refactored your application will remain functional and stable.
Unit testing a Vue application does not significantly differ from testing other types of applications.
Choosing Your Framework
Since unit testing advice is often framework-agnostic, here are some basic guidelines to keep in mind when evaluating which unit testing tool is best for your application.
First-class error reporting
When tests fail, it is critical that your unit testing framework provides useful errors. This is the job of the assertion library. An assertion with high-quality error messages helps minimize the amount of time it takes to debug the problem. In addition to simply telling you what test is failing, assertion libraries provide context for why a test fails, e.g., what is expected vs what was received.
Some unit testing frameworks, like Jest, include assertion libraries. Others, like Mocha, require you to install assertion libraries separately (usually Chai).
Active community and team
Since the majority of unit testing frameworks are open-source, having a community that is active can be critical to some teams that will be maintaining their tests for a long period of time and needs to ensure that a project will be actively maintained. In addition, having an active community has the benefit of providing more support whenever you run into issues.
Frameworks
While there are many tools in the ecosystem, here are some common unit testing tools that are being used in the Vue.js ecosystem.
Jest
Jest is a JavaScript test framework that is focused on simplicity. One of its unique features is the ability to take snapshots of tests in order to provide an alternative means of verifying units of your application.
Resources:
Mocha
Mocha is a JavaScript test framework that is focused on being flexible. Because of this flexibility, it allows you to choose different libraries to fulfill other common features such as spying (e.g., Sinon) and assertions (e.g., Chai). Another unique feature of Mocha is that it can also execute tests in the browser in addition to Node.js.
Resources:
Component Testing
Introduction
To test most Vue components, they must be mounted to the DOM (either virtual or real) in order to fully assert that they are working. This is another framework-agnostic concept. As a result, component testing frameworks were created to give users the ability to do this reliably while also providing Vue-specific conveniences such as integrations for Vuex, Vue Router, and other Vue plugins.
Choosing Your Framework
The following section provides guidelines on things to keep in mind when evaluating which component testing framework is best for your application.
Optimal compatibility with the Vue ecosystem
It should be no surprise that one of the first criteria is that a component testing library should have is being as compatible with the Vue ecosystem as possible. While this may seem comprehensive, some key integration areas to keep in mind include single file components (SFCs), Vuex, Vue Router, and any other Vue specific plugins that your application relies on.
First-class error reporting
When tests fail, it is critical that your component testing framework provides useful error logs that help to minimize the amount of time it takes to debug the problem. In addition to simply telling you what test fails, they should also provide context for why a test fails, e.g., what is expected vs what was received.
Recommendations
Vue Testing Library (@testing-library/vue)
Vue Testing Library is a set of tools focused on testing components without relying on implementation details. Built with accessibility in mind, its approach also makes refactoring a breeze.
Its guiding principle is that the more tests resemble the way software is used, the more confidence they can provide.
Resources:
Vue Test Utils
Vue Test Utils is the official low-level component testing library that was written to provide users access to Vue specific APIs. If you are new to testing Vue applications, we would recommend using Vue Testing Library, which is an abstraction over Vue Test Utils.
Resources
- Official Vue Test Utils Documentation
- Vue Testing Handbook by Lachlan Miller
- Cookbook: Unit Testing Vue Components
End-to-End (E2E) Testing
Introduction
While unit tests provide developers with some degree of confidence, unit and component tests are limited in their abilities to provide holistic coverage of an application when deployed to production. As a result, end-to-end (E2E) tests provide coverage on what is arguably the most important aspect of an application: what happens when users actually use your applications.
In other words, E2E tests validate all of the layers in your application. This not only includes your frontend code, but all associated backend services and infrastructure that are more representative of the environment that your users will be in. By testing how user actions impact your application, E2E tests are often the key to higher confidence in whether an application is functioning properly or not.
Choosing Your Framework
While end-to-end (E2E) testing on the web has gained a negative reputation for unreliable (flaky) tests and slowing down development processes, modern E2E tools have made strides forward to create more reliable, interactive, and useful tests. When choosing an E2E testing framework, the following sections provide some guidance on things to keep in mind when choosing a testing framework for your application.
Cross-browser testing
One of the primary benefits that end-to-end (E2E) testing is known for is its ability to test your application across multiple browsers. While it may seem desirable to have 100% cross-browser coverage, it is important to note that cross browser testing has diminishing returns on a team’s resources due the additional time and machine power required to run them consistently. As a result, it is important to be mindful of this trade-off when choosing the amount of cross-browser testing your application needs.
A recent development in E2E for catching browser-specific issues is using application monitoring and error reporting tools (e.g., Sentry, LogRocket, etc.) for browsers that are not as commonly used (e.g., < IE11, older Safari versions, etc.).
Faster feedback loops
One of the primary problems with end-to-end (E2E) tests and development is that running the entire suite takes a long time. Typically, this is only done in continuous integration and deployment (CI/CD) pipelines. Modern E2E testing frameworks have helped to solve this by adding features like parallelization, which allows for CI/CD pipelines to often run magnitudes faster than before. In addition, when developing locally, the ability to selectively run a single test for the page you are working on while also providing hot reloading of tests can help to boost a developer’s workflow and productivity.
First class debugging experience
While developers have traditionally relied on scanning logs in a terminal window to help determine what went wrong in a test, modern end-to-end (E2E) test frameworks allow developers to leverage tools that they are already familiar with, e.g. browser developer tools.
Visibility in headless mode
When end-to-end (E2E) tests are run in continuous integration / deployment pipelines, they are often run in headless browsers (i.e., no visible browser is opened for the user to watch). As a result, when errors occur, a critical feature that modern E2E testing frameworks provide 1st class support for is the ability to see snapshots and/or videos of your applications during various testing stages in order to provide insight into why errors are happening. Historically, it was tedious to maintain these integrations.
Recommendations
While there are many tools in the ecosystem, here are some common end-to-end (E2E) testing frameworks that are being used in the Vue.js ecosystem.
Cypress.io
Cypress.io is a testing framework that aims to enhance developer productivity by enabling developers to reliably test their applications while providing a first class developer experience.
Resources
Nightwatch.js
Nightwatch.js is an end-to-end testing framework that can be used to test web applications and websites, as well as Node.js unit and integration testing.
Resources:
Puppeteer
Puppeteer is a Node library that provides a high-level API to control the browser and can pair with other test runners (e.g., Jest) to test your application.
Resources:
TestCafe
TestCafe is a Node.js based end-to-end framework that aims to provide easy setup so that developers can focus on creating tests that are easy to write and reliable.
Resources:hhuh(hh	h}ubh)}(h}(hNh	}(h$https://v2.vuejs.org/v2/guide/mixinsh
Mixins — Vue.jsuhXV  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Mixins
Basics
Mixins are a flexible way to distribute reusable functionalities for Vue components. A mixin object can contain any component options. When a component uses a mixin, all options in the mixin will be “mixed” into the component’s own options.
Example:
|
Option Merging
When a mixin and the component itself contain overlapping options, they will be “merged” using appropriate strategies.
For example, data objects undergo a recursive merge, with the component’s data taking priority in cases of conflicts.
|
Hook functions with the same name are merged into an array so that all of them will be called. Mixin hooks will be called before the component’s own hooks.
|
Options that expect object values, for example methods
, components
and directives
, will be merged into the same object. The component’s options will take priority when there are conflicting keys in these objects:
|
Note that the same merge strategies are used in Vue.extend()
.
Global Mixin
You can also apply a mixin globally. Use with caution! Once you apply a mixin globally, it will affect every Vue instance created afterwards. When used properly, this can be used to inject processing logic for custom options:
|
Use global mixins sparsely and carefully, because it affects every single Vue instance created, including third party components. In most cases, you should only use it for custom option handling like demonstrated in the example above. It’s also a good idea to ship them as Plugins to avoid duplicate application.
Custom Option Merge Strategies
When custom options are merged, they use the default strategy which overwrites the existing value. If you want a custom option to be merged using custom logic, you need to attach a function to Vue.config.optionMergeStrategies
:
|
For most object-based options, you can use the same strategy used by methods
:
|
A more advanced example can be found on Vuex‘s 1.x merging strategy:
|hhuh(hh	h}ubh)}(h}(hNh	}(h&https://v2.vuejs.org/v2/guide/securityh
Security — Vue.jsuhX#  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Security
Reporting Vulnerabilities
When a vulnerability is reported, it immediately becomes our top concern, with a full-time contributor dropping everything to work on it. To report a vulnerability, please email security@vuejs.org.
While the discovery of new vulnerabilities is rare, we also recommend always using the latest versions of Vue and its official companion libraries to ensure your application remains as secure as possible.
Rule No.1: Never Use Non-trusted Templates
The most fundamental security rule when using Vue is never use non-trusted content as your component template. Doing so is equivalent to allowing arbitrary JavaScript execution in your application - and worse, could lead to server breaches if the code is executed during server-side rendering. An example of such usage:
|
Vue templates are compiled into JavaScript, and expressions inside templates will be executed as part of the rendering process. Although the expressions are evaluated against a specific rendering context, due to the complexity of potential global execution environments, it is impractical for a framework like Vue to completely shield you from potential malicious code execution without incurring unrealistic performance overhead. The most straightforward way to avoid this category of problems altogether is to make sure the contents of your Vue templates are always trusted and entirely controlled by you.
What Vue Does to Protect You
HTML content
Whether using templates or render functions, content is automatically escaped. That means in this template:
|
if userProvidedString
contained:
|
then it would be escaped to the following HTML:
|
thus preventing the script injection. This escaping is done using native browser APIs, like textContent
, so a vulnerability can only exist if the browser itself is vulnerable.
Attribute bindings
Similarly, dynamic attribute bindings are also automatically escaped. That means in this template:
|
if userProvidedString
contained:
|
then it would be escaped to the following HTML:
|
thus preventing the close of the title
attribute to inject new, arbitrary HTML. This escaping is done using native browser APIs, like setAttribute
, so a vulnerability can only exist if the browser itself is vulnerable.
Potential Dangers
In any web application, allowing unsanitized, user-provided content to be executed as HTML, CSS, or JavaScript is potentially dangerous, so should be avoided wherever possible. There are times when some risk be acceptable though.
For example, services like CodePen and JSFiddle allow user-provided content to be executed, but it’s in a context where this is expected and sandboxed to some extent inside iframes. In the cases when an important feature inherently requires some level of vulnerability, it’s up to your team to weigh the importance of the feature against the worst-case scenarios the vulnerability enables.
Injecting HTML
As you learned earlier, Vue automatically escapes HTML content, preventing you from accidentally injecting executable HTML into your application. However, in cases where you know the HTML is safe, you can explicitly render HTML content:
Using a template:
<div v-html="userProvidedHtml"></div>
Using a render function:
h('div', {
domProps: {
innerHTML: this.userProvidedHtml
}
})Using a render function with JSX:
<div domPropsInnerHTML={this.userProvidedHtml}></div>
Note that user-provided HTML can never be considered 100% safe unless it’s in a sandboxed iframe or in a part of the app where only the user who wrote that HTML can ever be exposed to it. Additionally, allowing users to write their own Vue templates brings similar dangers.
Injecting URLs
In a URL like this:
|
There’s a potential security issue if the URL has not been “sanitized” to prevent JavaScript execution using javascript:
. There are libraries such as sanitize-url to help with this, but note:
If you’re ever doing URL sanitization on the frontend, you already have a security issue. User-provided URLs should always be sanitized by your backend before even being saved to a database. Then the problem is avoided for every client connecting to your API, including native mobile apps. Also note that even with sanitized URLs, Vue cannot help you guarantee that they lead to safe destinations.
Injecting Styles
Looking at this example:
|
let’s assume that sanitizedUrl
has been sanitized, so that it’s definitely a real URL and not JavaScript. With the userProvidedStyles
, malicious users could still provide CSS to “click jack”, e.g. styling the link into a transparent box over the “Log in” button. Then if https://user-controlled-website.com/
is built to resemble the login page of your application, they might have just captured a user’s real login information.
You may be able to imagine how allowing user-provided content for a <style>
element would create an even greater vulnerability, giving that user full control over how to style the entire page. That’s why Vue prevents rendering of style tags inside templates, such as:
|
To keep your users fully safe from click jacking, we recommend only allowing full control over CSS inside a sandboxed iframe. Alternatively, when providing user control through a style binding, we recommend using its object syntax and only allowing users to provide values for specific properties it’s safe for them to control, like this:
|
Injecting JavaScript
We strongly discourage ever rendering a <script>
element with Vue, since templates and render functions should never have side effects. However, this isn’t the only way to include strings that would be evaluated as JavaScript at runtime.
Every HTML element has attributes with values accepting strings of JavaScript, such as onclick
, onfocus
, and onmouseenter
. Binding user-provided JavaScript to any of these event attributes is a potential security risk, so should be avoided.
Note that user-provided JavaScript can never be considered 100% safe unless it’s in a sandboxed iframe or in a part of the app where only the user who wrote that JavaScript can ever be exposed to it.
Sometimes we receive vulnerability reports on how it’s possible to do cross-site scripting (XSS) in Vue templates. In general, we do not consider such cases to be actual vulnerabilities, because there’s no practical way to protect developers from the two scenarios that would allow XSS:
The developer is explicitly asking Vue to render user-provided, unsanitized content as Vue templates. This is inherently unsafe and there’s no way for Vue to know the origin.
The developer is mounting Vue to an entire HTML page which happens to contain server-rendered and user-provided content. This is fundamentally the same problem as #1, but sometimes devs may do it without realizing. This can lead to possible vulnerabilities where the attacker provides HTML which is safe as plain HTML but unsafe as a Vue template. The best practice is to never mount Vue on nodes that may contain server-rendered and user-provided content.
Best Practices
The general rule is that if you allow unsanitized, user-provided content to be executed (as either HTML, JavaScript, or even CSS), you might be opening yourself up to attacks. This advice actually holds true whether using Vue, another framework, or even no framework.
Beyond the recommendations made above for Potential Dangers, we also recommend familiarizing yourself with these resources:
Then use what you learn to also review the source code of your dependencies for potentially dangerous patterns, if any of them include 3rd-party components or otherwise influence what’s rendered to the DOM.
Backend Coordination
HTTP security vulnerabilities, such as cross-site request forgery (CSRF/XSRF) and cross-site script inclusion (XSSI), are primarily addressed on the backend, so aren’t a concern of Vue’s. However, it’s still a good idea to communicate with your backend team to learn how to best interact with their API, e.g. by submitting CSRF tokens with form submissions.
Server-Side Rendering (SSR)
There are some additional security concerns when using SSR, so make sure to follow the best practices outlined throughout our SSR documentation to avoid vulnerabilities.71     hhuh(hh	h}ubh)}(h}(hNh	}(h#https://v2.vuejs.org/v2/guide/formsh
Form Input Bindings — Vue.jsuhX@  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Form Input Bindings
Basic Usage
You can use the v-model
directive to create two-way data bindings on form input, textarea, and select elements. It automatically picks the correct way to update the element based on the input type. Although a bit magical, v-model
is essentially syntax sugar for updating data on user input events, plus special care for some edge cases.
v-model
will ignore the initial value
, checked
, or selected
attributes found on any form elements. It will always treat the Vue instance data as the source of truth. You should declare the initial value on the JavaScript side, inside the data
option of your component.
v-model
internally uses different properties and emits different events for different input elements:
- text and textarea elements use
value
property andinput
event; - checkboxes and radiobuttons use
checked
property andchange
event; - select fields use
value
as a prop andchange
as an event.
For languages that require an IME (Chinese, Japanese, Korean, etc.), you’ll notice that v-model
doesn’t get updated during IME composition. If you want to cater to these updates as well, use the input
event instead.
Text
|
Message is: {{ message }}
Multiline text
|
{{ message }}
Interpolation on textareas (<textarea>{{text}}</textarea>
) won't work. Use v-model
instead.
Checkbox
Single checkbox, boolean value:
|
Multiple checkboxes, bound to the same Array:
|
|
Checked names: {{ checkedNames }}
Radio
|
Picked: {{ picked }}
Select
Single select:
|
|
If the initial value of your v-model
expression does not match any of the options, the <select>
element will render in an “unselected” state. On iOS, this will prevent the user from being able to select the first item, because iOS does not fire a change
event in this case. It is therefore recommended to provide a disabled
option with an empty value, as demonstrated in the example above.
Multiple select (bound to Array):
|
Selected: {{ selected }}
Dynamic options rendered with v-for
:
|
|
Value Bindings
For radio, checkbox and select options, the v-model
binding values are usually static strings (or booleans for checkboxes):
|
But sometimes, we may want to bind the value to a dynamic property on the Vue instance. We can use v-bind
to achieve that. In addition, using v-bind
allows us to bind the input value to non-string values.
Checkbox
|
|
The true-value
and false-value
attributes don’t affect the input’s value
attribute, because browsers don’t include unchecked boxes in form submissions. To guarantee that one of two values is submitted in a form (i.e. “yes” or “no”), use radio inputs instead.
Radio
|
|
Select Options
|
|
Modifiers
.lazy
By default, v-model
syncs the input with the data after each input
event (with the exception of IME composition, as stated above). You can add the lazy
modifier to instead sync after change
events:
|
.number
If you want user input to be automatically typecast as a Number, you can add the number
modifier to your v-model
managed inputs:
|
This is often useful, because even with type="number"
, the value of HTML input elements always returns a string. If the value cannot be parsed with parseFloat()
, then the original value is returned.
.trim
If you want whitespace from user input to be trimmed automatically, you can add the trim
modifier to your v-model
-managed inputs:
|
v-model
with Components
If you’re not yet familiar with Vue’s components, you can skip this for now.
HTML’s built-in input types won’t always meet your needs. Fortunately, Vue components allow you to build reusable inputs with completely customized behavior. These inputs even work with v-model
!
To learn more, read about custom inputs in the Components guide.hhuh(hh	h}ubh)}(h}(hNh	}(h.https://v2.vuejs.org/v2/guide/custom-directiveh
Custom Directives — Vue.jsuhX1  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Custom Directives
Intro
In addition to the default set of directives shipped in core (v-model
and v-show
), Vue also allows you to register your own custom directives. Note that in Vue 2.0, the primary form of code reuse and abstraction is components - however there may be cases where you need some low-level DOM access on plain elements, and this is where custom directives would still be useful. An example would be focusing on an input element, like this one:
When the page loads, that element gains focus (note: autofocus
doesn’t work on mobile Safari). In fact, if you haven’t clicked on anything else since visiting this page, the input above should be focused now. Now let’s build the directive that accomplishes this:
|
If you want to register a directive locally instead, components also accept a directives
option:
|
Then in a template, you can use the new v-focus
attribute on any element, like this:
|
Hook Functions
A directive definition object can provide several hook functions (all optional):
bind
: called only once, when the directive is first bound to the element. This is where you can do one-time setup work.inserted
: called when the bound element has been inserted into its parent node (this only guarantees parent node presence, not necessarily in-document).update
: called after the containing component’s VNode has updated, but possibly before its children have updated. The directive’s value may or may not have changed, but you can skip unnecessary updates by comparing the binding’s current and old values (see below on hook arguments).
We’ll cover VNodes in more detail later, when we discuss render functions.
componentUpdated
: called after the containing component’s VNode and the VNodes of its children have updated.unbind
: called only once, when the directive is unbound from the element.
We’ll explore the arguments passed into these hooks (i.e. el
, binding
, vnode
, and oldVnode
) in the next section.
Directive Hook Arguments
Directive hooks are passed these arguments:
el
: The element the directive is bound to. This can be used to directly manipulate the DOM.binding
: An object containing the following properties.name
: The name of the directive, without thev-
prefix.value
: The value passed to the directive. For example inv-my-directive="1 + 1"
, the value would be2
.oldValue
: The previous value, only available inupdate
andcomponentUpdated
. It is available whether or not the value has changed.expression
: The expression of the binding as a string. For example inv-my-directive="1 + 1"
, the expression would be"1 + 1"
.arg
: The argument passed to the directive, if any. For example inv-my-directive:foo
, the arg would be"foo"
.modifiers
: An object containing modifiers, if any. For example inv-my-directive.foo.bar
, the modifiers object would be{ foo: true, bar: true }
.
vnode
: The virtual node produced by Vue’s compiler. See the VNode API for full details.oldVnode
: The previous virtual node, only available in theupdate
andcomponentUpdated
hooks.
Apart from el
, you should treat these arguments as read-only and never modify them. If you need to share information across hooks, it is recommended to do so through element’s dataset.
An example of a custom directive using some of these properties:
|
|
Dynamic Directive Arguments
Directive arguments can be dynamic. For example, in v-mydirective:[argument]="value"
, the argument
can be updated based on data properties in our component instance! This makes our custom directives flexible for use throughout our application.
Let’s say you want to make a custom directive that allows you to pin elements to your page using fixed positioning. We could create a custom directive where the value updates the vertical positioning in pixels, like this:
|
|
This would pin the element 200px from the top of the page. But what happens if we run into a scenario when we need to pin the element from the left, instead of the top? Here’s where a dynamic argument that can be updated per component instance comes in very handy:
|
|
Result:
Our custom directive is now flexible enough to support a few different use cases.
Function Shorthand
In many cases, you may want the same behavior on bind
and update
, but don’t care about the other hooks. For example:
|
Object Literals
If your directive needs multiple values, you can also pass in a JavaScript object literal. Remember, directives can take any valid JavaScript expression.
|
|hhuh(hh	h}ubh)}(h}(hNh	}(h$https://v2.vuejs.org/v2/guide/eventsh
Event Handling — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Event Handling
Listening to Events
We can use the v-on
directive to listen to DOM events and run some JavaScript when they’re triggered.
For example:
|
|
Result:
The button above has been clicked {{ counter }} times.
Method Event Handlers
The logic for many event handlers will be more complex though, so keeping your JavaScript in the value of the v-on
attribute isn’t feasible. That’s why v-on
can also accept the name of a method you’d like to call.
For example:
|
|
Result:
Methods in Inline Handlers
Instead of binding directly to a method name, we can also use methods in an inline JavaScript statement:
|
|
Result:
Sometimes we also need to access the original DOM event in an inline statement handler. You can pass it into a method using the special $event
variable:
|
|
Event Modifiers
It is a very common need to call event.preventDefault()
or event.stopPropagation()
inside event handlers. Although we can do this easily inside methods, it would be better if the methods can be purely about data logic rather than having to deal with DOM event details.
To address this problem, Vue provides event modifiers for v-on
. Recall that modifiers are directive postfixes denoted by a dot.
.stop
.prevent
.capture
.self
.once
.passive
|
Order matters when using modifiers because the relevant code is generated in the same order. Therefore using v-on:click.prevent.self
will prevent all clicks while v-on:click.self.prevent
will only prevent clicks on the element itself.
New in 2.1.4+
|
Unlike the other modifiers, which are exclusive to native DOM events, the .once
modifier can also be used on component events. If you haven’t read about components yet, don’t worry about this for now.
New in 2.3.0+
Vue also offers the .passive
modifier, corresponding to addEventListener
‘s passive
option.
|
The .passive
modifier is especially useful for improving performance on mobile devices.
Don’t use .passive
and .prevent
together, because .prevent
will be ignored and your browser will probably show you a warning. Remember, .passive
communicates to the browser that you don’t want to prevent the event’s default behavior.
Key Modifiers
When listening for keyboard events, we often need to check for specific keys. Vue allows adding key modifiers for v-on
when listening for key events:
|
You can directly use any valid key names exposed via KeyboardEvent.key
as modifiers by converting them to kebab-case.
|
In the above example, the handler will only be called if $event.key
is equal to 'PageDown'
.
Key Codes
The use of keyCode
events is deprecated and may not be supported in new browsers.
Using keyCode
attributes is also permitted:
|
Vue provides aliases for the most commonly used key codes when necessary for legacy browser support:
.enter
.tab
.delete
(captures both “Delete” and “Backspace” keys).esc
.space
.up
.down
.left
.right
A few keys (.esc
and all arrow keys) have inconsistent key
values in IE9, so these built-in aliases should be preferred if you need to support IE9.
You can also define custom key modifier aliases via the global config.keyCodes
object:
|
System Modifier Keys
New in 2.1.0+
You can use the following modifiers to trigger mouse or keyboard event listeners only when the corresponding modifier key is pressed:
.ctrl
.alt
.shift
.meta
Note: On Macintosh keyboards, meta is the command key (⌘). On Windows keyboards, meta is the Windows key (⊞). On Sun Microsystems keyboards, meta is marked as a solid diamond (◆). On certain keyboards, specifically MIT and Lisp machine keyboards and successors, such as the Knight keyboard, space-cadet keyboard, meta is labeled “META”. On Symbolics keyboards, meta is labeled “META” or “Meta”.
For example:
|
Note that modifier keys are different from regular keys and when used with keyup
events, they have to be pressed when the event is emitted. In other words, keyup.ctrl
will only trigger if you release a key while holding down ctrl
. It won’t trigger if you release the ctrl
key alone. If you do want such behaviour, use the keyCode
for ctrl
instead: keyup.17
.
.exact
Modifier
New in 2.5.0+
The .exact
modifier allows control of the exact combination of system modifiers needed to trigger an event.
|
Mouse Button Modifiers
New in 2.2.0+
.left
.right
.middle
These modifiers restrict the handler to events triggered by a specific mouse button.
Why Listeners in HTML?
You might be concerned that this whole event listening approach violates the good old rules about “separation of concerns”. Rest assured - since all Vue handler functions and expressions are strictly bound to the ViewModel that’s handling the current view, it won’t cause any maintenance difficulty. In fact, there are several benefits in using v-on
:
It’s easier to locate the handler function implementations within your JS code by skimming the HTML template.
Since you don’t have to manually attach event listeners in JS, your ViewModel code can be pure logic and DOM-free. This makes it easier to test.
When a ViewModel is destroyed, all event listeners are automatically removed. You don’t need to worry about cleaning it up yourself.hhuh(hh	h}ubh)}(h}(hNh	}(h"https://v2.vuejs.org/v2/guide/listh
List Rendering — Vue.jsuhXt  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
List Rendering
Mapping an Array to Elements with v-for
We can use the v-for
directive to render a list of items based on an array. The v-for
directive requires a special syntax in the form of item in items
, where items
is the source data array and item
is an alias for the array element being iterated on:
|
|
Result:
- {{item.message}}
Inside v-for
blocks we have full access to parent scope properties. v-for
also supports an optional second argument for the index of the current item.
|
|
Result:
- {{ parentMessage }} - {{ index }} - {{ item.message }}
You can also use of
as the delimiter instead of in
, so that it is closer to JavaScript’s syntax for iterators:
|
v-for
with an Object
You can also use v-for
to iterate through the properties of an object.
|
|
Result:
- {{ value }}
You can also provide a second argument for the property’s name (a.k.a. key):
|
And another for the index:
|
When iterating over an object, the order is based on the enumeration order of Object.keys()
, which is not guaranteed to be consistent across JavaScript engine implementations.
Maintaining State
When Vue is updating a list of elements rendered with v-for
, by default it uses an “in-place patch” strategy. If the order of the data items has changed, instead of moving the DOM elements to match the order of the items, Vue will patch each element in-place and make sure it reflects what should be rendered at that particular index. This is similar to the behavior of track-by="$index"
in Vue 1.x.
This default mode is efficient, but only suitable when your list render output does not rely on child component state or temporary DOM state (e.g. form input values).
To give Vue a hint so that it can track each node’s identity, and thus reuse and reorder existing elements, you need to provide a unique key
attribute for each item:
|
It is recommended to provide a key
attribute with v-for
whenever possible, unless the iterated DOM content is simple, or you are intentionally relying on the default behavior for performance gains.
Since it’s a generic mechanism for Vue to identify nodes, the key
also has other uses that are not specifically tied to v-for
, as we will see later in the guide.
Don’t use non-primitive values like objects and arrays as v-for
keys. Use string or numeric values instead.
For detailed usage of the key
attribute, please see the key
API documentation.
Array Change Detection
Mutation Methods
Vue wraps an observed array’s mutation methods so they will also trigger view updates. The wrapped methods are:
push()
pop()
shift()
unshift()
splice()
sort()
reverse()
You can open the console and play with the previous examples’ items
array by calling their mutation methods. For example: example1.items.push({ message: 'Baz' })
.
Replacing an Array
Mutation methods, as the name suggests, mutate the original array they are called on. In comparison, there are also non-mutating methods, e.g. filter()
, concat()
and slice()
, which do not mutate the original array but always return a new array. When working with non-mutating methods, you can replace the old array with the new one:
|
You might think this will cause Vue to throw away the existing DOM and re-render the entire list - luckily, that is not the case. Vue implements some smart heuristics to maximize DOM element reuse, so replacing an array with another array containing overlapping objects is a very efficient operation.
Caveats
Due to limitations in JavaScript, there are types of changes that Vue cannot detect with arrays and objects. These are discussed in the reactivity section.
Displaying Filtered/Sorted Results
Sometimes we want to display a filtered or sorted version of an array without actually mutating or resetting the original data. In this case, you can create a computed property that returns the filtered or sorted array.
For example:
|
|
In situations where computed properties are not feasible (e.g. inside nested v-for
loops), you can use a method:
|
|
v-for
with a Range
v-for
can also take an integer. In this case it will repeat the template that many times.
|
Result:
v-for
on a <template>
Similar to template v-if
, you can also use a <template>
tag with v-for
to render a block of multiple elements. For example:
|
v-for
with v-if
Note that it’s not recommended to use v-if
and v-for
together. Refer to style guide for details.
When they exist on the same node, v-for
has a higher priority than v-if
. That means the v-if
will be run on each iteration of the loop separately. This can be useful when you want to render nodes for only some items, like below:
|
The above only renders the todos that are not complete.
If instead, your intent is to conditionally skip execution of the loop, you can place the v-if
on a wrapper element (or <template>
). For example:
|
v-for
with a Component
This section assumes knowledge of Components. Feel free to skip it and come back later.
You can directly use v-for
on a custom component, like any normal element:
|
In 2.2.0+, when using
v-for
with a component, akey
is now required.
However, this won’t automatically pass any data to the component, because components have isolated scopes of their own. In order to pass the iterated data into the component, we should also use props:
|
The reason for not automatically injecting item
into the component is because that makes the component tightly coupled to how v-for
works. Being explicit about where its data comes from makes the component reusable in other situations.
Here’s a complete example of a simple todo list:
|
Note the is="todo-item"
attribute. This is necessary in DOM templates, because only an <li>
element is valid inside a <ul>
. It does the same thing as <todo-item>
, but works around a potential browser parsing error. See DOM Template Parsing Caveats to learn more.
|hhuh(hh	h}ubh)}(h}(hNh	}(h(https://v2.vuejs.org/v2/guide/comparisonh
+Comparison with Other Frameworks — Vue.jsuhXY  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Comparison with Other Frameworks
This is definitely the most difficult page in the guide to write, but we do feel it’s important. Odds are, you’ve had problems you tried to solve and you’ve used another library to solve them. You’re here because you want to know if Vue can solve your specific problems better. That’s what we hope to answer for you.
We also try very hard to avoid bias. As the core team, we obviously like Vue a lot. There are some problems we think it solves better than anything else out there. If we didn’t believe that, we wouldn’t be working on it. We do want to be fair and accurate though. Where other libraries offer significant advantages, such as React’s vast ecosystem of alternative renderers or Knockout’s browser support back to IE6, we try to list these as well.
We’d also like your help keeping this document up-to-date because the JavaScript world moves fast! If you notice an inaccuracy or something that doesn’t seem quite right, please let us know by opening an issue.
React
React and Vue share many similarities. They both:
- utilize a virtual DOM
- provide reactive and composable view components
- maintain focus in the core library, with concerns such as routing and global state management handled by companion libraries
Being so similar in scope, we’ve put more time into fine-tuning this comparison than any other. We want to ensure not only technical accuracy, but also balance. We point out where React outshines Vue, for example in the richness of their ecosystem and abundance of their custom renderers.
With that said, it’s inevitable that the comparison would appear biased towards Vue to some React users, as many of the subjects explored are to some extent subjective. We acknowledge the existence of varying technical taste, and this comparison primarily aims to outline the reasons why Vue could potentially be a better fit if your preferences happen to coincide with ours.
Some of the sections below may also be slightly outdated due to recent updates in React 16+, and we are planning to work with the React community to revamp this section in the near future.
Runtime Performance
Both React and Vue are exceptionally and similarly fast, so speed is unlikely to be a deciding factor in choosing between them. For specific metrics though, check out this 3rd party benchmark, which focuses on raw render/update performance with very simple component trees.
Optimization Efforts
In React, when a component’s state changes, it triggers the re-render of the entire component sub-tree, starting at that component as root. To avoid unnecessary re-renders of child components, you need to either use PureComponent
or implement shouldComponentUpdate
whenever you can. You may also need to use immutable data structures to make your state changes more optimization-friendly. However, in certain cases you may not be able to rely on such optimizations because PureComponent/shouldComponentUpdate
assumes the entire sub tree’s render output is determined by the props of the current component. If that is not the case, then such optimizations may lead to inconsistent DOM state.
In Vue, a component’s dependencies are automatically tracked during its render, so the system knows precisely which components actually need to re-render when state changes. Each component can be considered to have shouldComponentUpdate
automatically implemented for you, without the nested component caveats.
Overall this removes the need for a whole class of performance optimizations from the developer’s plate, and allows them to focus more on building the app itself as it scales.
HTML & CSS
In React, everything is just JavaScript. Not only are HTML structures expressed via JSX, the recent trends also tend to put CSS management inside JavaScript as well. This approach has its own benefits, but also comes with various trade-offs that may not seem worthwhile for every developer.
Vue embraces classic web technologies and builds on top of them. To show you what that means, we’ll dive into some examples.
JSX vs Templates
In React, all components express their UI within render functions using JSX, a declarative XML-like syntax that works within JavaScript.
Render functions with JSX have a few advantages:
You can leverage the power of a full programming language (JavaScript) to build your view. This includes temporary variables, flow controls, and directly referencing JavaScript values in scope.
The tooling support (e.g. linting, type checking, editor autocompletion) for JSX is in some ways more advanced than what’s currently available for Vue templates.
In Vue, we also have render functions and even support JSX, because sometimes you do need that power. However, as the default experience we offer templates as a simpler alternative. Any valid HTML is also a valid Vue template, and this leads to a few advantages of its own:
For many developers who have been working with HTML, templates feel more natural to read and write. The preference itself can be somewhat subjective, but if it makes the developer more productive then the benefit is objective.
HTML-based templates make it much easier to progressively migrate existing applications to take advantage of Vue’s reactivity features.
It also makes it much easier for designers and less experienced developers to parse and contribute to the codebase.
You can even use pre-processors such as Pug (formerly known as Jade) to author your Vue templates.
Some argue that you’d need to learn an extra DSL (Domain-Specific Language) to be able to write templates - we believe this difference is superficial at best. First, JSX doesn’t mean the user doesn’t need to learn anything - it’s additional syntax on top of plain JavaScript, so it can be easy for someone familiar with JavaScript to learn, but saying it’s essentially free is misleading. Similarly, a template is just additional syntax on top of plain HTML and thus has very low learning cost for those who are already familiar with HTML. With the DSL we are also able to help the user get more done with less code (e.g. v-on
modifiers). The same task can involve a lot more code when using plain JSX or render functions.
On a higher level, we can divide components into two categories: presentational ones and logical ones. We recommend using templates for presentational components and render function / JSX for logical ones. The percentage of these components depends on the type of app you are building, but in general we find presentational ones to be much more common.
Component-Scoped CSS
Unless you spread components out over multiple files (for example with CSS Modules), scoping CSS in React is often done via CSS-in-JS solutions (e.g. styled-components and emotion). This introduces a new component-oriented styling paradigm that is different from the normal CSS authoring process. Additionally, although there is support for extracting CSS into a single stylesheet at build time, it is still common that a runtime will need to be included in the bundle for styling to work properly. While you gain access to the dynamism of JavaScript while constructing your styles, the tradeoff is often increased bundle size and runtime cost.
If you are a fan of CSS-in-JS, many of the popular CSS-in-JS libraries support Vue (e.g. styled-components-vue and vue-emotion). The main difference between React and Vue here is that the default method of styling in Vue is through more familiar style
tags in single-file components.
Single-file components give you full access to CSS in the same file as the rest of your component code.
|
The optional scoped
attribute automatically scopes this CSS to your component by adding a unique attribute (such as data-v-21e5b78
) to elements and compiling .list-container:hover
to something like .list-container[data-v-21e5b78]:hover
.
Lastly, the styling in Vue’s single-file components is very flexible. Through vue-loader, you can use any preprocessor, post-processor, and even deep integration with CSS Modules – all within the <style>
element.
Scale
Scaling Up
For large applications, both Vue and React offer robust routing solutions. The React community has also been very innovative in terms of state management solutions (e.g. Flux/Redux). These state management patterns and even Redux itself can be easily integrated into Vue applications. In fact, Vue has even taken this model a step further with Vuex, an Elm-inspired state management solution that integrates deeply into Vue that we think offers a superior development experience.
Another important difference between these offerings is that Vue’s companion libraries for state management and routing (among other concerns) are all officially supported and kept up-to-date with the core library. React instead chooses to leave these concerns to the community, creating a more fragmented ecosystem. Being more popular though, React’s ecosystem is considerably richer than Vue’s.
Finally, Vue offers a CLI project generator that makes it trivially easy to start a new project by featuring an interactive project scaffolding wizard. You can even use it for instantly prototyping a component. React is also making strides in this area with create-react-app, but it currently has a few limitations:
- It does not allow any configuration during project generation, while Vue CLI runs on top of an upgradeable runtime dependency that can be extended via plugins.
- It only offers a single template that assumes you’re building a single-page application, while Vue offers a wide variety of default options for various purposes and build systems.
- It cannot generate projects from user-built presets, which can be especially useful for enterprise environments with pre-established conventions.
It’s important to note that many of these limitations are intentional design decisions made by the create-react-app team and they do have their advantages. For example, as long as your project’s needs are very simple and you never need to “eject” to customize your build process, you’ll be able to update it as a dependency. You can read more about the differing philosophy here.
Scaling Down
React is renowned for its steep learning curve. Before you can really get started, you need to know about JSX and probably ES2015+, since many examples use React’s class syntax. You also have to learn about build systems, because although you could technically use Babel Standalone to live-compile your code in the browser, it’s absolutely not suitable for production.
While Vue scales up just as well as React, it also scales down just as well as jQuery. That’s right - to get started, all you have to do is drop a single script tag into the page:
|
Then you can start writing Vue code and even ship the minified version to production without feeling guilty or having to worry about performance problems.
Since you don’t need to know about JSX, ES2015, or build systems to get started with Vue, it also typically takes developers less than a day reading the guide to learn enough to build non-trivial applications.
Native Rendering
React Native enables you to write native-rendered apps for iOS and Android using the same React component model. This is great in that as a developer, you can apply your knowledge of a framework across multiple platforms. On this front, Vue has an official collaboration with Weex, a cross-platform UI framework created by Alibaba Group and being incubated by the Apache Software Foundation (ASF). Weex allows you to use the same Vue component syntax to author components that can not only be rendered in the browser, but also natively on iOS and Android!
At this moment, Weex is still in active development and is not as mature and battle-tested as React Native, but its development is driven by the production needs of the largest e-commerce business in the world, and the Vue team will also actively collaborate with the Weex team to ensure a smooth experience for Vue developers.
Another option is NativeScript-Vue, a NativeScript plugin for building truly native applications using Vue.js.
With MobX
MobX has become quite popular in the React community and it actually uses a nearly identical reactivity system to Vue. To a limited extent, the React + MobX workflow can be thought of as a more verbose Vue, so if you’re using that combination and are enjoying it, jumping into Vue is probably the next logical step.
Preact and Other React-Like Libraries
React-like libraries usually try to share as much of their API and ecosystem with React as is feasible. For that reason, the vast majority of comparisons above will also apply to them. The main difference will typically be a reduced ecosystem, often significantly, compared to React. Since these libraries cannot be 100% compatible with everything in the React ecosystem, some tooling and companion libraries may not be usable. Or, even if they appear to work, they could break at any time unless your specific React-like library is officially supported on par with React.
AngularJS (Angular 1)
Some of Vue’s syntax will look very similar to AngularJS (e.g. v-if
vs ng-if
). This is because there were a lot of things that AngularJS got right and these were an inspiration for Vue very early in its development. There are also many pains that come with AngularJS however, where Vue has attempted to offer a significant improvement.
Complexity
Vue is much simpler than AngularJS, both in terms of API and design. Learning enough to build non-trivial applications typically takes less than a day, which is not true for AngularJS.
Flexibility and Modularity
AngularJS has strong opinions about how your applications should be structured, while Vue is a more flexible, modular solution. While this makes Vue more adaptable to a wide variety of projects, we also recognize that sometimes it’s useful to have some decisions made for you, so that you can just start coding.
That’s why we offer a full system for rapid Vue.js development. Vue CLI aims to be the standard tooling baseline for the Vue ecosystem. It ensures the various build tools work smoothly together with sensible defaults so you can focus on writing your app instead of spending hours wrangling with configurations. At the same time, it still offers the flexibility to tweak the configuration of each tool to specific needs.
Data binding
AngularJS uses two-way binding between scopes, while Vue enforces a one-way data flow between components. This makes the flow of data easier to reason about in non-trivial applications.
Directives vs Components
Vue has a clearer separation between directives and components. Directives are meant to encapsulate DOM manipulations only, while components are self-contained units that have their own view and data logic. In AngularJS, directives do everything and components are just a specific kind of directive.
Runtime Performance
Vue has better performance and is much, much easier to optimize because it doesn’t use dirty checking. AngularJS becomes slow when there are a lot of watchers, because every time anything in the scope changes, all these watchers need to be re-evaluated again. Also, the digest cycle may have to run multiple times to “stabilize” if some watcher triggers another update. AngularJS users often have to resort to esoteric techniques to get around the digest cycle, and in some situations, there’s no way to optimize a scope with many watchers.
Vue doesn’t suffer from this at all because it uses a transparent dependency-tracking observation system with async queueing - all changes trigger independently unless they have explicit dependency relationships.
Interestingly, there are quite a few similarities in how Angular and Vue are addressing these AngularJS issues.
Angular (Formerly known as Angular 2)
We have a separate section for the new Angular because it really is a completely different framework from AngularJS. For example, it features a first-class component system, many implementation details have been completely rewritten, and the API has also changed quite drastically.
TypeScript
Angular essentially requires using TypeScript, given that almost all its documentation and learning resources are TypeScript-based. TypeScript has its benefits - static type checking can be very useful for large-scale applications, and can be a big productivity boost for developers with backgrounds in Java and C#.
However, not everyone wants to use TypeScript. In many smaller-scale use cases, introducing a type system may result in more overhead than productivity gain. In those cases you’d be better off going with Vue instead, since using Angular without TypeScript can be challenging.
Finally, although not as deeply integrated with TypeScript as Angular is, Vue also offers official typings and official decorator for those who wish to use TypeScript with Vue. We are also actively collaborating with the TypeScript and VSCode teams at Microsoft to improve the TS/IDE experience for Vue + TS users.
Runtime Performance
Both frameworks are exceptionally fast, with very similar metrics on benchmarks. You can browse specific metrics for a more granular comparison, but speed is unlikely to be a deciding factor.
Size
Recent versions of Angular, with AOT compilation and tree-shaking, have been able to get its size down considerably. However, a full-featured Vue 2 project with Vuex + Vue Router included (~30KB gzipped) is still significantly lighter than an out-of-the-box, AOT-compiled application generated by angular-cli
(~65KB gzipped).
Flexibility
Vue is much less opinionated than Angular, offering official support for a variety of build systems, with no restrictions on how you structure your application. Many developers enjoy this freedom, while some prefer having only one Right Way to build any application.
Learning Curve
To get started with Vue, all you need is familiarity with HTML and ES5 JavaScript (i.e. plain JavaScript). With these basic skills, you can start building non-trivial applications within less than a day of reading the guide.
Angular’s learning curve is much steeper. The API surface of the framework is huge and as a user you will need to familiarize yourself with a lot more concepts before getting productive. The complexity of Angular is largely due to its design goal of targeting only large, complex applications - but that does make the framework a lot more difficult for less-experienced developers to pick up.
Ember
Ember is a full-featured framework that is designed to be highly opinionated. It provides a lot of established conventions and once you are familiar enough with them, it can make you very productive. However, it also means the learning curve is high and flexibility suffers. It’s a trade-off when you try to pick between an opinionated framework and a library with a loosely coupled set of tools that work together. The latter gives you more freedom but also requires you to make more architectural decisions.
That said, it would probably make a better comparison between Vue core and Ember’s templating and object model layers:
Vue provides unobtrusive reactivity on plain JavaScript objects and fully automatic computed properties. In Ember, you need to wrap everything in Ember Objects and manually declare dependencies for computed properties.
Vue’s template syntax harnesses the full power of JavaScript expressions, while Handlebars’ expression and helper syntax is intentionally quite limited in comparison.
Performance-wise, Vue outperforms Ember by a fair margin, even after the latest Glimmer engine update in Ember 3.x. Vue automatically batches updates, while in Ember you need to manually manage run loops in performance-critical situations.
Knockout
Knockout was a pioneer in the MVVM and dependency tracking spaces and its reactivity system is very similar to Vue’s. Its browser support is also very impressive considering everything it does, with support back to IE6! Vue on the other hand only supports IE9+.
Over time though, Knockout development has slowed and it’s begun to show its age a little. For example, its component system lacks a full set of lifecycle hooks and although it’s a very common use case, the interface for passing children to a component feels a little clunky compared to Vue’s.
There also seem to be philosophical differences in the API design which if you’re curious, can be demonstrated by how each handles the creation of a simple todo list. It’s definitely somewhat subjective, but many consider Vue’s API to be less complex and better structured.
Polymer
Polymer is another Google-sponsored project and in fact was a source of inspiration for Vue as well. Vue’s components can be loosely compared to Polymer’s custom elements and both provide a very similar development style. The biggest difference is that Polymer is built upon the latest Web Components features and requires non-trivial polyfills to work (with degraded performance) in browsers that don’t support those features natively. In contrast, Vue works without any dependencies or polyfills down to IE9.
In Polymer, the team has also made its data-binding system very limited in order to compensate for the performance. For example, the only expressions supported in Polymer templates are boolean negation and single method calls. Its computed property implementation is also not very flexible.
Riot
Riot 3.0 provides a similar component-based development model (which is called a “tag” in Riot), with a minimal and beautifully designed API. Riot and Vue probably share a lot in design philosophies. However, despite being a bit heavier than Riot, Vue does offer some significant advantages:
- Better performance. Riot traverses a DOM tree rather than using a virtual DOM, so suffers from the same performance issues as AngularJS.
- More mature tooling support. Vue provides official support for webpack and Browserify, while Riot relies on community support for build system integration.hhuh(hh	h}ubh)}(h}(hNh	}(h*https://v2.vuejs.org/v2/guide/installationh
Installation — Vue.jsuhX  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Installation
Compatibility Note
Vue does not support IE8 and below, because it uses ECMAScript 5 features that are un-shimmable in IE8. However it supports all ECMAScript 5 compliant browsers.
Semantic Versioning
Vue follows Semantic Versioning in all its official projects for documented features and behavior. For undocumented behavior or exposed internals, changes are described in release notes.
Release Notes
Latest stable version: 2.7.16
Detailed release notes for each version are available on GitHub.
Vue Devtools
When using Vue, we recommend also installing the Vue Devtools in your browser, allowing you to inspect and debug your Vue applications in a more user-friendly interface.
Direct <script>
Include
Simply download and include with a script tag. Vue
will be registered as a global variable.
Don’t use the minified version during development. You will miss out on all the nice warnings for common mistakes!
Development VersionWith full warnings and debug mode
Production VersionWarnings stripped, 37.70KB min+gzip
CDN
For prototyping or learning purposes, you can use the latest version with:
|
For production, we recommend linking to a specific version number and build to avoid unexpected breakage from newer versions:
|
If you are using native ES Modules, there is also an ES Modules compatible build:
|
You can browse the source of the NPM package at cdn.jsdelivr.net/npm/vue.
Vue is also available on unpkg and cdnjs (cdnjs takes some time to sync so the latest release may not be available yet).
Make sure to read about the different builds of Vue and use the production
version in your published site, replacing vue.js
with vue.min.js
. This is a smaller build optimized for speed instead of development experience.
NPM
NPM is the recommended installation method when building large scale applications with Vue. It pairs nicely with module bundlers such as Webpack or Browserify. Vue also provides accompanying tools for authoring Single File Components.
|
CLI
Vue provides an official CLI for quickly scaffolding ambitious Single Page Applications. It provides batteries-included build setups for a modern frontend workflow. It takes only a few minutes to get up and running with hot-reload, lint-on-save, and production-ready builds. See the Vue CLI docs for more details.
The CLI assumes prior knowledge of Node.js and the associated build tools. If you are new to Vue or front-end build tools, we strongly suggest going through the guide without any build tools before using the CLI.
Explanation of Different Builds
In the dist/
directory of the NPM package you will find many different builds of Vue.js. Here’s an overview of the difference between them:
UMD | CommonJS | ES Module (for bundlers) | ES Module (for browsers) | |
---|---|---|---|---|
Full | vue.js | vue.common.js | vue.esm.js | vue.esm.browser.js |
Runtime-only | vue.runtime.js | vue.runtime.common.js | vue.runtime.esm.js | - |
Full (production) | vue.min.js | - | - | vue.esm.browser.min.js |
Runtime-only (production) | vue.runtime.min.js | - | - | - |
Terms
Full: builds that contain both the compiler and the runtime.
Compiler: code that is responsible for compiling template strings into JavaScript render functions.
Runtime: code that is responsible for creating Vue instances, rendering and patching virtual DOM, etc. Basically everything minus the compiler.
UMD: UMD builds can be used directly in the browser via a
<script>
tag. The default file from jsDelivr CDN at https://cdn.jsdelivr.net/npm/vue@2.7.16 is the Runtime + Compiler UMD build (vue.js
).CommonJS: CommonJS builds are intended for use with older bundlers like browserify or webpack 1. The default file for these bundlers (
pkg.main
) is the Runtime only CommonJS build (vue.runtime.common.js
).ES Module: starting in 2.6 Vue provides two ES Modules (ESM) builds:
ESM for bundlers: intended for use with modern bundlers like webpack 2 or Rollup. ESM format is designed to be statically analyzable so the bundlers can take advantage of that to perform “tree-shaking” and eliminate unused code from your final bundle. The default file for these bundlers (
pkg.module
) is the Runtime only ES Module build (vue.runtime.esm.js
).ESM for browsers (2.6+ only): intended for direct imports in modern browsers via
<script type="module">
.
Runtime + Compiler vs. Runtime-only
If you need to compile templates on the client (e.g. passing a string to the template
option, or mounting to an element using its in-DOM HTML as the template), you will need the compiler and thus the full build:
|
When using vue-loader
or vueify
, templates inside *.vue
files are pre-compiled into JavaScript at build time. You don’t really need the compiler in the final bundle, and can therefore use the runtime-only build.
Since the runtime-only builds are roughly 30% lighter-weight than their full-build counterparts, you should use it whenever you can. If you still wish to use the full build instead, you need to configure an alias in your bundler:
Webpack
|
Rollup
|
Browserify
Add to your project’s package.json
:
|
Parcel
Add to your project’s package.json
:
|
Development vs. Production Mode
Development/production modes are hard-coded for the UMD builds: the un-minified files are for development, and the minified files are for production.
CommonJS and ES Module builds are intended for bundlers, therefore we don’t provide minified versions for them. You will be responsible for minifying the final bundle yourself.
CommonJS and ES Module builds also preserve raw checks for process.env.NODE_ENV
to determine the mode they should run in. You should use appropriate bundler configurations to replace these environment variables in order to control which mode Vue will run in. Replacing process.env.NODE_ENV
with string literals also allows minifiers like UglifyJS to completely drop the development-only code blocks, reducing final file size.
Webpack
In Webpack 4+, you can use the mode
option:
|
But in Webpack 3 and earlier, you’ll need to use DefinePlugin:
|
Rollup
|
Browserify
Apply a global envify transform to your bundle.
|
Also see Production Deployment Tips.
CSP environments
Some environments, such as Google Chrome Apps, enforce Content Security Policy (CSP), which prohibits the use of new Function()
for evaluating expressions. The full build depends on this feature to compile templates, so is unusable in these environments.
On the other hand, the runtime-only build is fully CSP-compliant. When using the runtime-only build with Webpack + vue-loader or Browserify + vueify, your templates will be precompiled into render
functions which work perfectly in CSP environments.
Dev Build
Important: the built files in GitHub’s /dist
folder are only checked-in during releases. To use Vue from the latest source code on GitHub, you will have to build it yourself!
|
Bower
Only UMD builds are available from Bower.
|
AMD Module Loaders
All UMD builds can be used directly as an AMD module.hhuh(hh	h}ubh)}(h}(hNh	}(h2https://v2.vuejs.org/v2/guide/migration-vue-routerh
*Migration from Vue Router 0.7.x — Vue.jsuhX#  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Migration from Vue Router 0.7.x
Only Vue Router 2 is compatible with Vue 2, so if you’re updating Vue, you’ll have to update Vue Router as well. That’s why we’ve included details on the migration path here in the main docs. For a complete guide on using the new Vue Router, see the Vue Router docs.
Router Initialization
router.start
replaced
There is no longer a special API to initialize an app with Vue Router. That means instead of:
|
You pass a router property to a Vue instance:
|
Or, if you’re using the runtime-only build of Vue:
|
Upgrade Path
Run the migration helper on your codebase to find examples of router.start
being called.
Route Definitions
router.map
replaced
Routes are now defined as an array on a routes
option at router instantiation. So these routes for example:
|
Will instead be defined with:
|
The array syntax allows more predictable route matching, since iterating over an object is not guaranteed to use the same property order across browsers.
Upgrade Path
Run the migration helper on your codebase to find examples of router.map
being called.
router.on
removed
If you need to programmatically generate routes when starting up your app, you can do so by dynamically pushing definitions to a routes array. For example:
|
If you need to add new routes after the router has been instantiated, you can replace the router’s matcher with a new one that includes the route you’d like to add:
|
Upgrade Path
Run the migration helper on your codebase to find examples of router.on
being called.
router.beforeEach
changed
router.beforeEach
now works asynchronously and takes a next
function as its third argument.
|
|
subRoutes
renamed
Renamed to children
for consistency within Vue and with other routing libraries.
Upgrade Path
Run the migration helper on your codebase to find examples of the subRoutes
option.
router.redirect
replaced
This is now an option on route definitions. So for example, you will update:
|
to a definition like below in your routes
configuration:
|
Upgrade Path
Run the migration helper on your codebase to find examples of router.redirect
being called.
router.alias
replaced
This is now an option on the definition for the route you’d like to alias to. So for example, you will update:
|
to a definition like below in your routes
configuration:
|
If you need multiple aliases, you can also use an array syntax:
|
Upgrade Path
Run the migration helper on your codebase to find examples of router.alias
being called.
Arbitrary Route Properties replaced
Arbitrary route properties must now be scoped under the new meta property, to avoid conflicts with future features. So for example, if you had defined:
|
Then you would now update it to:
|
Then when later accessing this property on a route, you will still go through meta. For example:
|
Upgrade Path
Run the migration helper on your codebase to find examples of arbitrary route properties not scoped under meta.
[] Syntax for Arrays in Queries removed
When passing arrays to query parameters the QueryString syntax is no longer /foo?users[]=Tom&users[]=Jerry
, instead, the new syntax is /foo?users=Tom&users=Jerry
. Internally, $route.query.users
will still be an Array, but if there’s only one parameter in the query: /foo?users=Tom
, when directly accessing this route, there’s no way for the router to know if we were expecting users
to be an Array. Because of this, consider adding a computed property and replacing every reference of $route.query.users
with it:
|
Route Matching
Route matching now uses path-to-regexp under the hood, making it much more flexible than previously.
One or More Named Parameters changed
The syntax has changed slightly, so /category/*tags
for example, should be updated to /category/:tags+
.
Upgrade Path
Run the migration helper on your codebase to find examples of the obsolete route syntax.
Links
v-link
replaced
The v-link
directive has been replaced with a new <router-link>
component, as this sort of job is now solely the responsibility of components in Vue 2. That means whenever wherever you have a link like this:
|
You’ll need to update it like this:
|
Note that target="_blank"
is not supported on <router-link>
, so if you need to open a link in a new tab, you have to use <a>
instead.
Upgrade Path
Run the migration helper on your codebase to find examples of the v-link
directive.
v-link-active
replaced
The v-link-active
directive has also been replaced by the tag
attribute on the <router-link>
component. So for example, you’ll update this:
|
to this:
|
The <a>
will be the actual link (and will get the correct href), but the active class will be applied to the outer <li>
.
Upgrade Path
Run the migration helper on your codebase to find examples of the v-link-active
directive.
Programmatic Navigation
router.go
changed
For consistency with the HTML5 History API, router.go
is now only used for back/forward navigation, while router.push
is used to navigate to a specific page.
Upgrade Path
Run the migration helper on your codebase to find examples of router.go
being used where router.push
should be used instead.
Router Options: Modes
hashbang: false
removed
Hashbangs are no longer required for Google to crawl a URL, so they are no longer the default (or even an option) for the hash strategy.
Upgrade Path
Run the migration helper on your codebase to find examples of the hashbang: false
option.
history: true
replaced
All routing mode options have been condensed into a single mode
option. Update:
|
to:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the history: true
option.
abstract: true
replaced
All routing mode options have been condensed into a single mode
option. Update:
|
to:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the abstract: true
option.
Route Options: Misc
saveScrollPosition
replaced
This has been replaced with a scrollBehavior
option that accepts a function, so that the scroll behavior is completely customizable - even per route. This opens many new possibilities, but to replicate the old behavior of:
|
You can replace it with:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the saveScrollPosition: true
option.
root
renamed
Renamed to base
for consistency with the HTML <base>
element.
Upgrade Path
Run the migration helper on your codebase to find examples of the root
option.
transitionOnLoad
removed
This option is no longer necessary now that Vue’s transition system has explicit appear
transition control.
Upgrade Path
Run the migration helper on your codebase to find examples of the transitionOnLoad: true
option.
suppressTransitionError
removed
Removed due to hooks simplification. If you really must suppress transition errors, you can use try
…catch
instead.
Upgrade Path
Run the migration helper on your codebase to find examples of the suppressTransitionError: true
option.
Route Hooks
activate
replaced
Use beforeRouteEnter
in the component instead.
Upgrade Path
Run the migration helper on your codebase to find examples of the activate
hook.
canActivate
replaced
Use beforeEnter
in the route instead.
Upgrade Path
Run the migration helper on your codebase to find examples of the canActivate
hook.
deactivate
removed
Use the component’s beforeDestroy
or destroyed
hooks instead.
Upgrade Path
Run the migration helper on your codebase to find examples of the deactivate
hook.
canDeactivate
replaced
Use beforeRouteLeave
in the component instead.
Upgrade Path
Run the migration helper on your codebase to find examples of the canDeactivate
hook.
canReuse: false
removed
There’s no longer a use case for this in the new Vue Router.
Upgrade Path
Run the migration helper on your codebase to find examples of the canReuse: false
option.
data
replaced
The $route
property is now reactive, so you can use a watcher to react to route changes, like this:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the data
hook.
$loadingRouteData
removed
Define your own property (e.g. isLoading
), then update the loading state in a watcher on the route. For example, if fetching data with axios:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the $loadingRouteData
meta property.hhuh(hh	h}ubh)}(h}(hNh	}(h)https://v2.vuejs.org/v2/guide/transitionsh
)Enter/Leave & List Transitions — Vue.jsuhX}6  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Enter/Leave & List Transitions
Overview
Vue provides a variety of ways to apply transition effects when items are inserted, updated, or removed from the DOM. This includes tools to:
- automatically apply classes for CSS transitions and animations
- integrate 3rd-party CSS animation libraries, such as Animate.css
- use JavaScript to directly manipulate the DOM during transition hooks
- integrate 3rd-party JavaScript animation libraries, such as Velocity.js
On this page, we’ll only cover entering, leaving, and list transitions, but you can see the next section for managing state transitions.
Transitioning Single Elements/Components
Vue provides a transition
wrapper component, allowing you to add entering/leaving transitions for any element or component in the following contexts:
- Conditional rendering (using
v-if
) - Conditional display (using
v-show
) - Dynamic components
- Component root nodes
This is what an example looks like in action:
|
|
|
hello
When an element wrapped in a transition
component is inserted or removed, this is what happens:
Vue will automatically sniff whether the target element has CSS transitions or animations applied. If it does, CSS transition classes will be added/removed at appropriate timings.
If the transition component provided JavaScript hooks, these hooks will be called at appropriate timings.
If no CSS transitions/animations are detected and no JavaScript hooks are provided, the DOM operations for insertion and/or removal will be executed immediately on next frame (Note: this is a browser animation frame, different from Vue’s concept of
nextTick
).
Transition Classes
There are six classes applied for enter/leave transitions.
v-enter
: Starting state for enter. Added before element is inserted, removed one frame after element is inserted.v-enter-active
: Active state for enter. Applied during the entire entering phase. Added before element is inserted, removed when transition/animation finishes. This class can be used to define the duration, delay and easing curve for the entering transition.v-enter-to
: Only available in versions 2.1.8+. Ending state for enter. Added one frame after element is inserted (at the same timev-enter
is removed), removed when transition/animation finishes.v-leave
: Starting state for leave. Added immediately when a leaving transition is triggered, removed after one frame.v-leave-active
: Active state for leave. Applied during the entire leaving phase. Added immediately when leave transition is triggered, removed when the transition/animation finishes. This class can be used to define the duration, delay and easing curve for the leaving transition.v-leave-to
: Only available in versions 2.1.8+. Ending state for leave. Added one frame after a leaving transition is triggered (at the same timev-leave
is removed), removed when the transition/animation finishes.
Each of these classes will be prefixed with the name of the transition. Here the v-
prefix is the default when you use a <transition>
element with no name. If you use <transition name="my-transition">
for example, then the v-enter
class would instead be my-transition-enter
.
v-enter-active
and v-leave-active
give you the ability to specify different easing curves for enter/leave transitions, which you’ll see an example of in the following section.
CSS Transitions
One of the most common transition types uses CSS transitions. Here’s an example:
|
|
|
hello
CSS Animations
CSS animations are applied in the same way as CSS transitions, the difference being that v-enter
is not removed immediately after the element is inserted, but on an animationend
event.
Here’s an example, omitting prefixed CSS rules for the sake of brevity:
|
|
|
Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris facilisis enim libero, at lacinia diam fermentum id. Pellentesque habitant morbi tristique senectus et netus.
Custom Transition Classes
You can also specify custom transition classes by providing the following attributes:
enter-class
enter-active-class
enter-to-class
(2.1.8+)leave-class
leave-active-class
leave-to-class
(2.1.8+)
These will override the conventional class names. This is especially useful when you want to combine Vue’s transition system with an existing CSS animation library, such as Animate.css.
Here’s an example:
|
|
hello
Using Transitions and Animations Together
Vue needs to attach event listeners in order to know when a transition has ended. It can either be transitionend
or animationend
, depending on the type of CSS rules applied. If you are only using one or the other, Vue can automatically detect the correct type.
However, in some cases you may want to have both on the same element, for example having a CSS animation triggered by Vue, along with a CSS transition effect on hover. In these cases, you will have to explicitly declare the type you want Vue to care about in a type
attribute, with a value of either animation
or transition
.
Explicit Transition Durations
New in 2.2.0+
In most cases, Vue can automatically figure out when the transition has finished. By default, Vue waits for the first transitionend
or animationend
event on the root transition element. However, this may not always be desired - for example, we may have a choreographed transition sequence where some nested inner elements have a delayed transition or a longer transition duration than the root transition element.
In such cases you can specify an explicit transition duration (in milliseconds) using the duration
prop on the <transition>
component:
|
You can also specify separate values for enter and leave durations:
|
JavaScript Hooks
You can also define JavaScript hooks in attributes:
|
|
These hooks can be used in combination with CSS transitions/animations or on their own.
When using JavaScript-only transitions, the done
callbacks are required for the enter
and leave
hooks. Otherwise, the hooks will be called synchronously and the transition will finish immediately.
It’s also a good idea to explicitly add v-bind:css="false"
for JavaScript-only transitions so that Vue can skip the CSS detection. This also prevents CSS rules from accidentally interfering with the transition.
Now let’s dive into an example. Here’s a JavaScript transition using Velocity.js:
|
|
Demo
Transitions on Initial Render
If you also want to apply a transition on the initial render of a node, you can add the appear
attribute:
|
By default, this will use the transitions specified for entering and leaving. If you’d like however, you can also specify custom CSS classes:
|
and custom JavaScript hooks:
|
In the example above, either appear
attribute or v-on:appear
hook will cause an appear transition.
Transitioning Between Elements
We discuss transitioning between components later, but you can also transition between raw elements using v-if
/v-else
. One of the most common two-element transitions is between a list container and a message describing an empty list:
|
This works well, but there’s one caveat to be aware of:
When toggling between elements that have the same tag name, you must tell Vue that they are distinct elements by giving them unique key
attributes. Otherwise, Vue’s compiler will only replace the content of the element for efficiency. Even when technically unnecessary though, it’s considered good practice to always key multiple items within a <transition>
component.
For example:
|
In these cases, you can also use the key
attribute to transition between different states of the same element. Instead of using v-if
and v-else
, the above example could be rewritten as:
|
It’s actually possible to transition between any number of elements, either by using multiple v-if
s or binding a single element to a dynamic property. For example:
|
Which could also be written as:
|
|
Transition Modes
There’s still one problem though. Try clicking the button below:
As it’s transitioning between the “on” button and the “off” button, both buttons are rendered - one transitioning out while the other transitions in. This is the default behavior of <transition>
- entering and leaving happens simultaneously.
Sometimes this works great, like when transitioning items are absolutely positioned on top of each other:
And then maybe also translated so that they look like slide transitions:
Simultaneous entering and leaving transitions aren’t always desirable though, so Vue offers some alternative transition modes:
in-out
: New element transitions in first, then when complete, the current element transitions out.out-in
: Current element transitions out first, then when complete, the new element transitions in.
Now let’s update the transition for our on/off buttons with out-in
:
|
With one attribute addition, we’ve fixed that original transition without having to add any special styling.
The in-out
mode isn’t used as often, but can sometimes be useful for a slightly different transition effect. Let’s try combining it with the slide-fade transition we worked on earlier:
Pretty cool, right?
Transitioning Between Components
Transitioning between components is even simpler - we don’t even need the key
attribute. Instead, we wrap a dynamic component:
|
|
|
List Transitions
So far, we’ve managed transitions for:
- Individual nodes
- Multiple nodes where only 1 is rendered at a time
So what about for when we have a whole list of items we want to render simultaneously, for example with v-for
? In this case, we’ll use the <transition-group>
component. Before we dive into an example though, there are a few things that are important to know about this component:
- Unlike
<transition>
, it renders an actual element: a<span>
by default. You can change the element that’s rendered with thetag
attribute. - Transition modes are not available, because we are no longer alternating between mutually exclusive elements.
- Elements inside are always required to have a unique
key
attribute. - CSS transition classes will be applied to inner elements and not to the group/container itself.
List Entering/Leaving Transitions
Now let’s dive into an example, transitioning entering and leaving using the same CSS classes we’ve used previously:
|
|
|
There’s one problem with this example. When you add or remove an item, the ones around it instantly snap into their new place instead of smoothly transitioning. We’ll fix that later.
List Move Transitions
The <transition-group>
component has another trick up its sleeve. It can not only animate entering and leaving, but also changes in position. The only new concept you need to know to use this feature is the addition of the v-move
class, which is added when items are changing positions. Like the other classes, its prefix will match the value of a provided name
attribute and you can also manually specify a class with the move-class
attribute.
This class is mostly useful for specifying the transition timing and easing curve, as you’ll see below:
|
|
|
This might seem like magic, but under the hood, Vue is using an animation technique called FLIP to smoothly transition elements from their old position to their new position using transforms.
We can combine this technique with our previous implementation to animate every possible change to our list!
|
|
|
One important note is that these FLIP transitions do not work with elements set to display: inline
. As an alternative, you can use display: inline-block
or place elements in a flex context.
These FLIP animations are also not limited to a single axis. Items in a multidimensional grid can be transitioned too:
Keep hitting the shuffle button until you win.
Staggering List Transitions
By communicating with JavaScript transitions through data attributes, it’s also possible to stagger transitions in a list:
|
|
Reusable Transitions
Transitions can be reused through Vue’s component system. To create a reusable transition, all you have to do is place a <transition>
or <transition-group>
component at the root, then pass any children into the transition component.
Here’s an example using a template component:
|
And functional components are especially well-suited to this task:
|
Dynamic Transitions
Yes, even transitions in Vue are data-driven! The most basic example of a dynamic transition binds the name
attribute to a dynamic property.
|
This can be useful when you’ve defined CSS transitions/animations using Vue’s transition class conventions and want to switch between them.
Really though, any transition attribute can be dynamically bound. And it’s not only attributes. Since event hooks are methods, they have access to any data in the context. That means depending on the state of your component, your JavaScript transitions can behave differently.
|
|
hello
Finally, the ultimate way of creating dynamic transitions is through components that accept props to change the nature of the transition(s) to be used. It may sound cheesy, but the only limit really is your imagination..     hhuh(hh	h}ubh)}(h}(hNh	}(h.https://v2.vuejs.org/v2/guide/components-slotsh
Slots — Vue.jsuhX&  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Slots
This page assumes you’ve already read the Components Basics. Read that first if you are new to components.
In 2.6.0, we introduced a new unified syntax (the
v-slot
directive) for named and scoped slots. It replaces theslot
andslot-scope
attributes, which are now deprecated, but have not been removed and are still documented here. The rationale for introducing the new syntax is described in this RFC.
Slot Content
Vue implements a content distribution API inspired by the Web Components spec draft, using the <slot>
element to serve as distribution outlets for content.
This allows you to compose components like this:
|
Then in the template for <navigation-link>
, you might have:
|
When the component renders, <slot></slot>
will be replaced by “Your Profile”. Slots can contain any template code, including HTML:
|
Or even other components:
|
If <navigation-link>
‘s template did not contain a <slot>
element, any content provided between its opening and closing tag would be discarded.
Compilation Scope
When you want to use data inside a slot, such as in:
|
That slot has access to the same instance properties (i.e. the same “scope”) as the rest of the template. The slot does not have access to <navigation-link>
‘s scope. For example, trying to access url
would not work:
|
As a rule, remember that:
Everything in the parent template is compiled in parent scope; everything in the child template is compiled in the child scope.
Fallback Content
There are cases when it’s useful to specify fallback (i.e. default) content for a slot, to be rendered only when no content is provided. For example, in a <submit-button>
component:
|
We might want the text “Submit” to be rendered inside the <button>
most of the time. To make “Submit” the fallback content, we can place it in between the <slot>
tags:
|
Now when we use <submit-button>
in a parent component, providing no content for the slot:
|
will render the fallback content, “Submit”:
|
But if we provide content:
|
Then the provided content will be rendered instead:
|
Named Slots
Updated in 2.6.0+. See here for the deprecated syntax using the
slot
attribute.
There are times when it’s useful to have multiple slots. For example, in a <base-layout>
component with the following template:
|
For these cases, the <slot>
element has a special attribute, name
, which can be used to define additional slots:
|
A <slot>
outlet without name
implicitly has the name “default”.
To provide content to named slots, we can use the v-slot
directive on a <template>
, providing the name of the slot as v-slot
‘s argument:
|
Now everything inside the <template>
elements will be passed to the corresponding slots. Any content not wrapped in a <template>
using v-slot
is assumed to be for the default slot.
However, you can still wrap default slot content in a <template>
if you wish to be explicit:
|
Either way, the rendered HTML will be:
|
Note that v-slot
can only be added to a <template>
(with one exception), unlike the deprecated slot
attribute.
Scoped Slots
Updated in 2.6.0+. See here for the deprecated syntax using the
slot-scope
attribute.
Sometimes, it’s useful for slot content to have access to data only available in the child component. For example, imagine a <current-user>
component with the following template:
|
We might want to replace this fallback content to display the user’s first name, instead of last, like this:
|
That won’t work, however, because only the <current-user>
component has access to the user
and the content we’re providing is rendered in the parent.
To make user
available to the slot content in the parent, we can bind user
as an attribute to the <slot>
element:
|
Attributes bound to a <slot>
element are called slot props. Now, in the parent scope, we can use v-slot
with a value to define a name for the slot props we’ve been provided:
|
In this example, we’ve chosen to name the object containing all our slot props slotProps
, but you can use any name you like.
Abbreviated Syntax for Lone Default Slots
In cases like above, when only the default slot is provided content, the component’s tags can be used as the slot’s template. This allows us to use v-slot
directly on the component:
|
This can be shortened even further. Just as non-specified content is assumed to be for the default slot, v-slot
without an argument is assumed to refer to the default slot:
|
Note that the abbreviated syntax for default slot cannot be mixed with named slots, as it would lead to scope ambiguity:
|
Whenever there are multiple slots, use the full <template>
based syntax for all slots:
|
Destructuring Slot Props
Internally, scoped slots work by wrapping your slot content in a function passed a single argument:
|
That means the value of v-slot
can actually accept any valid JavaScript expression that can appear in the argument position of a function definition. So in supported environments (single-file components or modern browsers), you can also use ES2015 destructuring to pull out specific slot props, like so:
|
This can make the template much cleaner, especially when the slot provides many props. It also opens other possibilities, such as renaming props, e.g. user
to person
:
|
You can even define fallbacks, to be used in case a slot prop is undefined:
|
Dynamic Slot Names
New in 2.6.0+
Dynamic directive arguments also work on v-slot
, allowing the definition of dynamic slot names:
|
Named Slots Shorthand
New in 2.6.0+
Similar to v-on
and v-bind
, v-slot
also has a shorthand, replacing everything before the argument (v-slot:
) with the special symbol #
. For example, v-slot:header
can be rewritten as #header
:
|
However, just as with other directives, the shorthand is only available when an argument is provided. That means the following syntax is invalid:
|
Instead, you must always specify the name of the slot if you wish to use the shorthand:
|
Other Examples
Slot props allow us to turn slots into reusable templates that can render different content based on input props. This is most useful when you are designing a reusable component that encapsulates data logic while allowing the consuming parent component to customize part of its layout.
For example, we are implementing a <todo-list>
component that contains the layout and filtering logic for a list:
|
Instead of hard-coding the content for each todo, we can let the parent component take control by making every todo a slot, then binding todo
as a slot prop:
|
Now when we use the <todo-list>
component, we can optionally define an alternative <template>
for todo items, but with access to data from the child:
|
However, even this barely scratches the surface of what scoped slots are capable of. For real-life, powerful examples of scoped slot usage, we recommend browsing libraries such as Vue Virtual Scroller, Vue Promised, and Portal Vue.
Deprecated Syntax
The
v-slot
directive was introduced in Vue 2.6.0, offering an improved, alternative API to the still-supportedslot
andslot-scope
attributes. The full rationale for introducingv-slot
is described in this RFC. Theslot
andslot-scope
attributes will continue to be supported in all future 2.x releases, but are officially deprecated and will eventually be removed in Vue 3.
Named Slots with the slot
Attribute
Deprecated in 2.6.0+. See here for the new, recommended syntax.
To pass content to named slots from the parent, use the special slot
attribute on <template>
(using the <base-layout>
component described here as example):
|
Or, the slot
attribute can also be used directly on a normal element:
|
There can still be one unnamed slot, which is the default slot that serves as a catch-all for any unmatched content. In both examples above, the rendered HTML would be:
|
Scoped Slots with the slot-scope
Attribute
Deprecated in 2.6.0+. See here for the new, recommended syntax.
To receive props passed to a slot, the parent component can use <template>
with the slot-scope
attribute (using the <slot-example>
described here as example):
|
Here, slot-scope
declares the received props object as the slotProps
variable, and makes it available inside the <template>
scope. You can name slotProps
anything you like similar to naming function arguments in JavaScript.
Here slot="default"
can be omitted as it is implied:
|
The slot-scope
attribute can also be used directly on a non-<template>
element (including components):
|
The value of slot-scope
can accept any valid JavaScript expression that can appear in the argument position of a function definition. This means in supported environments (single-file components or modern browsers) you can also use ES2015 destructuring in the expression, like so:
|
Using the <todo-list>
described here as an example, here’s the equivalent usage using slot-scope
:
|hhuh(hh	h}ubh)}(h}(hNh	}(h8https://router.vuejs.org/api/enums/navigationfailuretypeh
/Enumeration: NavigationFailureType | Vue RouteruhX  API Documentation / NavigationFailureType
Enumeration: NavigationFailureType
Enumeration with all possible types for navigation failures. Can be passed to isNavigationFailure to check for specific failures.
Enumeration Members
aborted
• aborted = 4
An aborted navigation is a navigation that failed because a navigation guard returned false
or called next(false)
cancelled
• cancelled = 8
A cancelled navigation is a navigation that failed because a more recent navigation finished started (not necessarily finished).
duplicated
• duplicated = 16
A duplicated navigation is a navigation that failed because it was initiated while already being at the exact same location.hhuh(hh	h}ubh)}(h}(hNh	}(h<https://router.vuejs.org/api/interfaces/routerscrollbehaviorh
,Interface: RouterScrollBehavior | Vue RouteruhX  API Documentation / RouterScrollBehavior
Interface: RouterScrollBehavior
Type of the scrollBehavior
option that can be passed to createRouter
.
Callable
RouterScrollBehavior
▸ RouterScrollBehavior(to
, from
, savedPosition
): Awaitable
<false
| void
| ScrollPosition
>
Parameters
Name | Type | Description |
---|---|---|
to | RouteLocationNormalizedGeneric | Route location where we are navigating to |
from | RouteLocationNormalizedLoadedGeneric | Route location where we are navigating from |
savedPosition | null | _ScrollPositionNormalized | saved position if it exists, null otherwise |
Returns
Awaitable
<false
| void
| ScrollPosition
>hhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/api/interfaces/routerlinkpropsh
'Interface: RouterLinkProps | Vue RouteruhX  API Documentation / RouterLinkProps
Interface: RouterLinkProps
Hierarchy
RouterLinkOptions
↳
RouterLinkProps
Properties
activeClass
• Optional
activeClass: string
Class to apply when the link is active
ariaCurrentValue
• Optional
ariaCurrentValue: "time"
| "location"
| "page"
| "step"
| "date"
| "true"
| "false"
Value passed to the attribute aria-current
when the link is exact active.
Default Value
'page'
custom
• Optional
custom: boolean
Whether RouterLink should not wrap its content in an a
tag. Useful when using v-slot
to create a custom RouterLink
exactActiveClass
• Optional
exactActiveClass: string
Class to apply when the link is exact active
replace
• Optional
replace: boolean
Calls router.replace
instead of router.push
.
Inherited from
RouterLinkOptions.replace
to
• to: string
| RouteLocationAsRelativeGeneric
| RouteLocationAsPathGeneric
Route Location the link should navigate to when clicked on.
Inherited from
RouterLinkOptions.tohhuh(hh	h}ubh)}(h}(hNh	}(h<https://router.vuejs.org/api/interfaces/routelocationoptionsh
,Interface: RouteLocationOptions | Vue RouteruhX  API Documentation / RouteLocationOptions
Interface: RouteLocationOptions
Common options for all navigation methods.
Hierarchy
RouteLocationOptions
↳
RouteLocationAsRelativeGeneric
Properties
force
• Optional
force: boolean
Triggers the navigation even if the location is the same as the current one. Note this will also add a new entry to the history unless replace: true
is passed.
replace
• Optional
replace: boolean
Replace the entry in the history instead of pushing a new entry
state
• Optional
state: HistoryState
State to save using the History API. This cannot contain any reactive values and some primitives like Symbols are forbidden. More info at https://developer.mozilla.org/en-US/docs/Web/API/History/statehhuh(hh	h}ubh)}(h}(hNh	}(hFhttps://router.vuejs.org/api/interfaces/routelocationasrelativegenerich
6Interface: RouteLocationAsRelativeGeneric | Vue RouteruhXS  API Documentation / RouteLocationAsRelativeGeneric
Interface: RouteLocationAsRelativeGeneric
Generic version of RouteLocationAsRelative. It is used when no RouteMap is provided.
Hierarchy
↳
RouteLocationAsRelativeGeneric
Properties
force
• Optional
force: boolean
Triggers the navigation even if the location is the same as the current one. Note this will also add a new entry to the history unless replace: true
is passed.
Inherited from
hash
• Optional
hash: string
Inherited from
name
• Optional
name: RouteRecordNameGeneric
params
• Optional
params: RouteParamsRawGeneric
path
• Optional
path: undefined
A relative path to the current location. This property should be removed
query
• Optional
query: LocationQueryRaw
Inherited from
replace
• Optional
replace: boolean
Replace the entry in the history instead of pushing a new entry
Inherited from
state
• Optional
state: HistoryState
State to save using the History API. This cannot contain any reactive values and some primitives like Symbols are forbidden. More info at https://developer.mozilla.org/en-US/docs/Web/API/History/statehhuh(hh	h}ubh)}(h}(hNh	}(h=https://router.vuejs.org/api/interfaces/routelocationnamedrawh
-Interface: RouteLocationNamedRaw | Vue RouteruhXm  API Documentation / RouteLocationNamedRaw
Interface: RouteLocationNamedRaw
Route Location that can infer the necessary params based on the name.
Hierarchy
↳
RouteLocationNamedRaw
Properties
force
• Optional
force: boolean
Triggers the navigation even if the location is the same as the current one. Note this will also add a new entry to the history unless replace: true
is passed.
Inherited from
hash
• Optional
hash: string
Inherited from
name
• Optional
name: RouteRecordNameGeneric
Inherited from
params
• Optional
params: RouteParamsRawGeneric
Inherited from
path
• Optional
path: undefined
Ignored path property since we are dealing with a relative location. Only undefined
is allowed.
Inherited from
query
• Optional
query: LocationQueryRaw
Inherited from
replace
• Optional
replace: boolean
Replace the entry in the history instead of pushing a new entry
Inherited from
state
• Optional
state: HistoryState
State to save using the History API. This cannot contain any reactive values and some primitives like Symbols are forbidden. More info at https://developer.mozilla.org/en-US/docs/Web/API/History/statehhuh(hh	h}ubh)}(h}(hNh	}(h@https://router.vuejs.org/api/interfaces/routerecordmultipleviewsh
0Interface: RouteRecordMultipleViews | Vue RouteruhX  API Documentation / RouteRecordMultipleViews
Interface: RouteRecordMultipleViews
Route Record defining multiple named components with the components
option.
Hierarchy
↳
RouteRecordMultipleViews
Properties
alias
• Optional
alias: string
| string
[]
Aliases for the record. Allows defining extra paths that will behave like a copy of the record. Allows having paths shorthands like /users/:id
and /u/:id
. All alias
and path
values must share the same params.
Inherited from
beforeEnter
• Optional
beforeEnter: NavigationGuardWithThis
<undefined
> | NavigationGuardWithThis
<undefined
>[]
Before Enter guard specific to this record. Note beforeEnter
has no effect if the record has a redirect
property.
Inherited from
children
• Optional
children: undefined
Array of nested routes.
Overrides
component
• Optional
component: undefined
components
• components: Record
<string
, RawRouteComponent
>
Components to display when the URL matches this route. Allow using named views.
end
• Optional
end: boolean
Should the RegExp match until the end by appending a $
to it.
Default Value
true
Inherited from
meta
• Optional
meta: RouteMeta
Arbitrary data attached to the record.
Inherited from
name
• Optional
name: RouteRecordNameGeneric
Name for the route record. Must be unique.
Inherited from
path
• path: string
Path of the record. Should start with /
unless the record is the child of another record.
Example
`/users/:id` matches `/users/1` as well as `/users/posva`.
Inherited from
props
• Optional
props: boolean
| Record
<string
, _RouteRecordProps
>
Allow passing down params as props to the component rendered by router-view
. Should be an object with the same keys as components
or a boolean to be applied to every component.
Overrides
redirect
• Optional
redirect: undefined
Where to redirect if the route is directly matched. The redirection happens before any navigation guard and triggers a new navigation with the new target location.
Overrides
sensitive
• Optional
sensitive: boolean
Makes the RegExp case-sensitive.
Default Value
false
Inherited from
strict
• Optional
strict: boolean
Whether to disallow a trailing slash or not.
Default Value
falsehhuh(hh	h}ubh)}(h}(hNh	}(hLhttps://router.vuejs.org/api/interfaces/routerecordmultipleviewswithchildrenh
<Interface: RouteRecordMultipleViewsWithChildren | Vue RouteruhX  API Documentation / RouteRecordMultipleViewsWithChildren
Interface: RouteRecordMultipleViewsWithChildren
Route Record defining multiple named components with the components
option and children.
Hierarchy
↳
RouteRecordMultipleViewsWithChildren
Properties
alias
• Optional
alias: string
| string
[]
Aliases for the record. Allows defining extra paths that will behave like a copy of the record. Allows having paths shorthands like /users/:id
and /u/:id
. All alias
and path
values must share the same params.
Inherited from
beforeEnter
• Optional
beforeEnter: NavigationGuardWithThis
<undefined
> | NavigationGuardWithThis
<undefined
>[]
Before Enter guard specific to this record. Note beforeEnter
has no effect if the record has a redirect
property.
Inherited from
children
• children: RouteRecordRaw
[]
Array of nested routes.
Overrides
component
• Optional
component: undefined
components
• Optional
components: null
| Record
<string
, RawRouteComponent
>
Components to display when the URL matches this route. Allow using named views.
end
• Optional
end: boolean
Should the RegExp match until the end by appending a $
to it.
Default Value
true
Inherited from
meta
• Optional
meta: RouteMeta
Arbitrary data attached to the record.
Inherited from
name
• Optional
name: RouteRecordNameGeneric
Name for the route record. Must be unique.
Inherited from
path
• path: string
Path of the record. Should start with /
unless the record is the child of another record.
Example
`/users/:id` matches `/users/1` as well as `/users/posva`.
Inherited from
props
• Optional
props: boolean
| Record
<string
, _RouteRecordProps
>
Allow passing down params as props to the component rendered by router-view
. Should be an object with the same keys as components
or a boolean to be applied to every component.
Overrides
redirect
• Optional
redirect: RouteRecordRedirectOption
Where to redirect if the route is directly matched. The redirection happens before any navigation guard and triggers a new navigation with the new target location.
Inherited from
sensitive
• Optional
sensitive: boolean
Makes the RegExp case-sensitive.
Default Value
false
Inherited from
strict
• Optional
strict: boolean
Whether to disallow a trailing slash or not.
Default Value
falsehhuh(hh	h}ubh)}(h}(hNh	}(h'https://v2.vuejs.org/v2/guide/migrationh
!Migration from Vue 1.x — Vue.jsuhXx  Guide
Essentials
- Installation
- Introduction
- The Vue Instance
- Template Syntax
- Computed Properties and Watchers
- Class and Style Bindings
- Conditional Rendering
- List Rendering
- Event Handling
- Form Input Bindings
- Components Basics
Components In-Depth
- Component Registration
- Props
- Custom Events
- Slots
- Dynamic & Async Components
- Handling Edge Cases
Transitions & Animation
- Enter/Leave & List Transitions
- State Transitions
Reusability & Composition
- Mixins
- Custom Directives
- Render Functions & JSX
- Plugins
- Filters
Tooling
- Single File Components
- Testing
- TypeScript Support
- Production Deployment
Scaling Up
- Routing
- State Management
- Server-Side Rendering
- Security
Internals
- Reactivity in Depth
Migrating
- Migration from Vue 1.x
- Migration from Vue Router 0.7.x
- Migration from Vuex 0.6.x to 1.0
- Migration to Vue 2.7
Meta
- Comparison with Other Frameworks
- Join the Vue.js Community!
- Meet the Team
Migration from Vue 1.x
FAQ
Woah - this is a super long page! Does that mean 2.0 is completely different, I’ll have to learn the basics all over again, and migrating will be practically impossible?
I’m glad you asked! The answer is no. About 90% of the API is the same and the core concepts haven’t changed. It’s long because we like to offer very detailed explanations and include a lot of examples. Rest assured, this is not something you have to read from top to bottom!
Where should I start in a migration?
Start by running the migration helper on a current project. We’ve carefully minified and compressed a senior Vue dev into a simple command line interface. Whenever they recognize an obsolete feature, they’ll let you know, offer suggestions, and provide links to more info.
After that, browse through the table of contents for this page in the sidebar. If you see a topic you may be affected by, but the migration helper didn’t catch, check it out.
If you have any tests, run them and see what still fails. If you don’t have tests, just open the app in your browser and keep an eye out for warnings or errors as you navigate around.
By now, your app should be fully migrated. If you’re still hungry for more though, you can read the rest of this page - or dive in to the new and improved guide from the beginning. Many parts will be skimmable, since you’re already familiar with the core concepts.
How long will it take to migrate a Vue 1.x app to 2.0?
It depends on a few factors:
The size of your app (small to medium-sized apps will probably be less than a day)
How many times you get distracted and start playing with a cool new feature. 😉 Not judging, it also happened to us while building 2.0!
Which obsolete features you’re using. Most can be upgraded with find-and-replace, but others might take a few minutes. If you’re not currently following best practices, Vue 2.0 will also try harder to force you to. This is a good thing in the long run, but could also mean a significant (though possibly overdue) refactor.
If I upgrade to Vue 2, will I also have to upgrade Vuex and Vue Router?
Only Vue Router 2 is compatible with Vue 2, so yes, you’ll have to follow the migration path for Vue Router as well. Fortunately, most applications don’t have a lot of router code, so this likely won’t take more than an hour.
As for Vuex, even version 0.8 is compatible with Vue 2, so you’re not forced to upgrade. The only reason you may want to upgrade immediately is to take advantage of the new features in Vuex 2, such as modules and reduced boilerplate.
Templates
Fragment Instances removed
Every component must have exactly one root element. Fragment instances are no longer allowed. If you have a template like this:
|
It’s recommended to wrap the entire contents in a new element, like this:
|
Upgrade Path
Run your end-to-end test suite or app after upgrading and look for console warnings about multiple root elements in a template.
Lifecycle Hooks
beforeCompile
removed
Use the created
hook instead.
Upgrade Path
Run the migration helper on your codebase to find all examples of this hook.
compiled
replaced
Use the new mounted
hook instead.
Upgrade Path
Run the migration helper on your codebase to find all examples of this hook.
attached
removed
Use a custom in-DOM check in other hooks. For example, to replace:
|
You could use:
|
Upgrade Path
Run the migration helper on your codebase to find all examples of this hook.
detached
removed
Use a custom in-DOM check in other hooks. For example, to replace:
|
You could use:
|
Upgrade Path
Run the migration helper on your codebase to find all examples of this hook.
init
renamed
Use the new beforeCreate
hook instead, which is essentially the same thing. It was renamed for consistency with other lifecycle methods.
Upgrade Path
Run the migration helper on your codebase to find all examples of this hook.
ready
replaced
Use the new mounted
hook instead. It should be noted though that with mounted
, there’s no guarantee to be in-document. For that, also include Vue.nextTick
/vm.$nextTick
. For example:
|
Upgrade Path
Run the migration helper on your codebase to find all examples of this hook.
v-for
v-for
Argument Order for Arrays changed
When including an index
, the argument order for arrays used to be (index, value)
. It is now (value, index)
to be more consistent with JavaScript’s native array methods such as forEach
and map
.
Upgrade Path
Run the migration helper on your codebase to find examples of the obsolete argument order. Note that if you name your index arguments something unusual like position
or num
, the helper will not flag them.
v-for
Argument Order for Objects changed
When including a property name/key, the argument order for objects used to be (name, value)
. It is now (value, name)
to be more consistent with common object iterators such as lodash’s.
Upgrade Path
Run the migration helper on your codebase to find examples of the obsolete argument order. Note that if you name your key arguments something like name
or property
, the helper will not flag them.
$index
and $key
removed
The implicitly assigned $index
and $key
variables have been removed in favor of explicitly defining them in v-for
. This makes the code easier to read for developers less experienced with Vue and also results in much clearer behavior when dealing with nested loops.
Upgrade Path
Run the migration helper on your codebase to find examples of these removed variables. If you miss any, you should also see console errors such as: Uncaught ReferenceError: $index is not defined
track-by
replaced
track-by
has been replaced with key
, which works like any other attribute: without the v-bind:
or :
prefix, it is treated as a literal string. In most cases, you’d want to use a dynamic binding which expects a full expression instead of a key. For example, in place of:
|
You would now write:
|
Upgrade Path
Run the migration helper on your codebase to find examples of track-by
.
v-for
Range Values changed
Previously, v-for="number in 10"
would have number
starting at 0 and ending at 9. Now it starts at 1 and ends at 10.
Upgrade Path
Search your codebase for the regex /\w+ in \d+/
. Wherever it appears in a v-for
, check to see if you may be affected.
Props
coerce
Prop Option removed
If you want to coerce a prop, setup a local computed value based on it instead. For example, instead of:
|
You could write:
|
There are a few advantages:
- You still have access to the original value of the prop.
- You are forced to be more explicit, by giving your coerced value a name that differentiates it from the value passed in the prop.
Upgrade Path
Run the migration helper on your codebase to find examples of the coerce
option.
twoWay
Prop Option removed
Props are now always one-way down. To produce side effects in the parent scope, a component needs to explicitly emit an event instead of relying on implicit binding. For more information, see:
- Custom component events
- Custom input components (using component events)
- Global state management
Upgrade Path
Run the migration helper on your codebase to find examples of the twoWay
option.
.once
and .sync
Modifiers on v-bind
removed
Props are now always one-way down. To produce side effects in the parent scope, a component needs to explicitly emit an event instead of relying on implicit binding. For more information, see:
- Custom component events
- Custom input components (using component events)
- Global state management
Upgrade Path
Run the migration helper on your codebase to find examples of the .once
and .sync
modifiers.
Prop Mutation deprecated
Mutating a prop locally is now considered an anti-pattern, e.g. declaring a prop and then setting this.myProp = 'someOtherValue'
in the component. Due to the new rendering mechanism, whenever the parent component re-renders, the child component’s local changes will be overwritten.
Most use cases of mutating a prop can be replaced by one of these options:
- a data property, with the prop used to set its default value
- a computed property
Upgrade Path
Run your end-to-end test suite or app after upgrading and look for console warnings about prop mutations.
Props on a Root Instance replaced
On root Vue instances (i.e. instances created with new Vue({ ... })
), you must use propsData
instead of props
.
Upgrade Path
Run your end-to-end test suite, if you have one. The failed tests should alert to you to the fact that props passed to root instances are no longer working.
Computed properties
cache: false
deprecated
Caching invalidation of computed properties will be removed in future major versions of Vue. Replace any uncached computed properties with methods, which will have the same result.
For example:
|
Or with component methods:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the cache: false
option.
Built-In Directives
Truthiness/Falsiness with v-bind
changed
When used with v-bind
, the only falsy values are now: null
, undefined
, and false
. This means 0
and empty strings will render as truthy. So for example, v-bind:draggable="''"
will render as draggable="true"
.
For enumerated attributes, in addition to the falsy values above, the string "false"
will also render as attr="false"
.
Note that for other directives (e.g. v-if
and v-show
), JavaScript’s normal truthiness still applies.
Upgrade Path
Run your end-to-end test suite, if you have one. The failed tests should alert to you to any parts of your app that may be affected by this change.
Listening for Native Events on Components with v-on
changed
When used on a component, v-on
now only listens to custom events $emit
ted by that component. To listen for a native DOM event on the root element, you can use the .native
modifier. For example:
|
Upgrade Path
Run your end-to-end test suite, if you have one. The failed tests should alert to you to any parts of your app that may be affected by this change.
debounce
Param Attribute for v-model
removed
Debouncing is used to limit how often we execute Ajax requests and other expensive operations. Vue’s debounce
attribute parameter for v-model
made this easy for very simple cases, but it actually debounced state updates rather than the expensive operations themselves. It’s a subtle difference, but it comes with limitations as an application grows.
These limitations become apparent when designing a search indicator, like this one for example:
Using the debounce
attribute, there’d be no way to detect the “Typing” state, because we lose access to the input’s real-time state. By decoupling the debounce function from Vue however, we’re able to debounce only the operation we want to limit, removing the limits on features we can develop:
|
|
Another advantage of this approach is there will be times when debouncing isn’t quite the right wrapper function. For example, when hitting an API for search suggestions, waiting to offer suggestions until after the user has stopped typing for a period of time isn’t an ideal experience. What you probably want instead is a throttling function. Now since you’re already using a utility library like lodash, refactoring to use its throttle
function instead takes only a few seconds.
Upgrade Path
Run the migration helper on your codebase to find examples of the debounce
attribute.
lazy
or number
Param Attributes for v-model
replaced
The lazy
and number
param attributes are now modifiers, to make it more clear what That means instead of:
|
You would use:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the these param attributes.
value
Attribute with v-model
removed
v-model
no longer cares about the initial value of an inline value
attribute. For predictability, it will instead always treat the Vue instance data as the source of truth.
That means this element:
|
backed by this data:
|
will render with a value of “bar” instead of “foo”. The same goes for a <textarea>
with existing content. Instead of:
|
You should ensure your initial value for text
is “hello world”.
Upgrade Path
Run your end-to-end test suite or app after upgrading and look for console warnings about inline value attributes with v-model
.
v-model
with v-for
Iterated Primitive Values removed
Cases like this no longer work:
|
The reason is this is the equivalent JavaScript that the <input>
would compile to:
|
As you can see, v-model
‘s two-way binding doesn’t make sense here. Setting str
to another value in the iterator function will do nothing because it’s only a local variable in the function scope.
Instead, you should use an array of objects so that v-model
can update the field on the object. For example:
|
Upgrade Path
Run your test suite, if you have one. The failed tests should alert to you to any parts of your app that may be affected by this change.
v-bind:style
with Object Syntax and !important
removed
This will no longer work:
|
If you really need to override another !important
, you must use the string syntax:
|
Upgrade Path
Run the migration helper on your codebase to find examples of style bindings with !important
in objects.
v-el
and v-ref
replaced
For simplicity, v-el
and v-ref
have been merged into the ref
attribute, accessible on a component instance via $refs
. That means v-el:my-element
would become ref="myElement"
and v-ref:my-component
would become ref="myComponent"
. When used on a normal element, the ref
will be the DOM element, and when used on a component, the ref
will be the component instance.
Since v-ref
is no longer a directive, but a special attribute, it can also be dynamically defined. This is especially useful in combination with v-for
. For example:
|
Previously, v-el
/v-ref
combined with v-for
would produce an array of elements/components, because there was no way to give each item a unique name. You can still achieve this behavior by giving each item the same ref
:
|
Unlike in 1.x, these $refs
are not reactive, because they’re registered/updated during the render process itself. Making them reactive would require duplicate renders for every change.
On the other hand, $refs
are designed primarily for programmatic access in JavaScript - it is not recommended to rely on them in templates, because that would mean referring to state that does not belong to the instance itself. This would violate Vue’s data-driven view model.
Upgrade Path
Run the migration helper on your codebase to find examples of v-el
and v-ref
.
v-else
with v-show
removed
v-else
no longer works with v-show
. Use v-if
with a negation expression instead. For example, instead of:
|
You can use:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the v-else
with v-show
.
Custom Directives simplified
Directives have a greatly reduced scope of responsibility: they are now only used for applying low-level direct DOM manipulations. In most cases, you should prefer using components as the main code-reuse abstraction.
Some of the most notable differences include:
- Directives no longer have instances. This means there’s no more
this
inside directive hooks. Instead, they receive everything they might need as arguments. If you really must persist state across hooks, you can do so onel
. - Options such as
acceptStatement
,deep
,priority
, etc have all been removed. To replacetwoWay
directives, see this example. - Some of the current hooks have different behavior and there are also a couple new hooks.
Fortunately, since the new directives are much simpler, you can master them more easily. Read the new Custom Directives guide to learn more.
Upgrade Path
Run the migration helper on your codebase to find examples of defined directives. The helper will flag all of them, as it's likely in most cases that you'll want to refactor to a component.
Directive .literal
Modifier removed
The .literal
modifier has been removed, as the same can be easily achieved by providing a string literal as the value.
For example, you can update:
|
to:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the `.literal` modifier on a directive.
Transitions
transition
Attribute replaced
Vue’s transition system has changed quite drastically and now uses <transition>
and <transition-group>
wrapper elements, rather than the transition
attribute. It’s recommended to read the new Transitions guide to learn more.
Upgrade Path
Run the migration helper on your codebase to find examples of the transition
attribute.
Vue.transition
for Reusable Transitions replaced
With the new transition system, you can now use components for reusable transitions.
Upgrade Path
Run the migration helper on your codebase to find examples of Vue.transition
.
Transition stagger
Attribute removed
If you need to stagger list transitions, you can control timing by setting and accessing a data-index
(or similar attribute) on an element. See an example here.
Upgrade Path
Run the migration helper on your codebase to find examples of the transition
attribute. During your update, you can transition (pun very much intended) to the new staggering strategy as well.
Events
events
option removed
The events
option has been removed. Event handlers should now be registered in the created
hook instead. Check out the $dispatch
and $broadcast
migration guide for a detailed example.
Vue.directive('on').keyCodes
replaced
The new, more concise way to configure keyCodes
is through Vue.config.keyCodes
. For example:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the the old keyCode
configuration syntax.
$dispatch
and $broadcast
replaced
$dispatch
and $broadcast
have been removed in favor of more explicitly cross-component communication and more maintainable state management solutions, such as Vuex.
The problem is event flows that depend on a component’s tree structure can be hard to reason about and are very brittle when the tree becomes large. They don’t scale well and only set you up for pain later. $dispatch
and $broadcast
also do not solve communication between sibling components.
One of the most common uses for these methods is to communicate between a parent and its direct children. In these cases, you can actually listen to an $emit
from a child with v-on
. This allows you to keep the convenience of events with added explicitness.
However, when communicating between distant descendants/ancestors, $emit
won’t help you. Instead, the simplest possible upgrade would be to use a centralized event hub. This has the added benefit of allowing you to communicate between components no matter where they are in the component tree - even between siblings! Because Vue instances implement an event emitter interface, you can actually use an empty Vue instance for this purpose.
For example, let’s say we have a todo app structured like this:
|
We could manage communication between components with this single event hub:
|
Then in our components, we can use $emit
, $on
, $off
to emit events, listen for events, and clean up event listeners, respectively:
|
|
|
This pattern can serve as a replacement for $dispatch
and $broadcast
in simple scenarios, but for more complex cases, it’s recommended to use a dedicated state management layer such as Vuex.
Upgrade Path
Run the migration helper on your codebase to find examples of $dispatch
and $broadcast
.
Filters
Filters Outside Text Interpolations removed
Filters can now only be used inside text interpolations ({{ }}
tags). In the past we’ve found using filters within directives such as v-model
, v-on
, etc led to more complexity than convenience. For list filtering on v-for
, it’s also better to move that logic into JavaScript as computed properties, so that it can be reused throughout your component.
In general, whenever something can be achieved in plain JavaScript, we want to avoid introducing a special syntax like filters to take care of the same concern. Here’s how you can replace Vue’s built-in directive filters:
Replacing the debounce
Filter
Instead of:
|
|
Use lodash’s debounce
(or possibly throttle
) to directly limit calling the expensive method. You can achieve the same as above like this:
|
|
For more on the advantages of this strategy, see the example here with v-model
.
Replacing the limitBy
Filter
Instead of:
|
Use JavaScript’s built-in .slice
method in a computed property:
|
|
Replacing the filterBy
Filter
Instead of:
|
Use JavaScript’s built-in .filter
method in a computed property:
|
|
JavaScript’s native .filter
can also manage much more complex filtering operations, because you have access to the full power of JavaScript within computed properties. For example, if you wanted to find all active users and case-insensitively match against both their name and email:
|
Replacing the orderBy
Filter
Instead of:
|
Use lodash’s orderBy
(or possibly sortBy
) in a computed property:
|
|
You can even order by multiple columns:
|
Upgrade Path
Run the migration helper on your codebase to find examples of filters being used inside directives. If you miss any, you should also see console errors.
Filter Argument Syntax changed
Filters’ syntax for arguments now better aligns with JavaScript function invocation. So instead of taking space-delimited arguments:
|
We surround the arguments with parentheses and delimit the arguments with commas:
|
Upgrade Path
Run the migration helper on your codebase to find examples of the old filter syntax. If you miss any, you should also see console errors.
Built-In Text Filters removed
Although filters within text interpolations are still allowed, all of the filters have been removed. Instead, it’s recommended to use more specialized libraries for solving problems in each domain (e.g. date-fns
to format dates and accounting
for currencies).
For each of Vue’s built-in text filters, we go through how you can replace them below. The example code could exist in custom helper functions, methods, or computed properties.
Replacing the json
Filter
You actually don’t need to for debugging anymore, as Vue will nicely format output for you automatically, whether it’s a string, number, array, or plain object. If you want the exact same functionality as JavaScript’s JSON.stringify
though, then you can use that in a method or computed property.
Replacing the capitalize
Filter
|
Replacing the uppercase
Filter
|
Replacing the lowercase
Filter
|
Replacing the pluralize
Filter
The pluralize package on NPM serves this purpose nicely, but if you only want to pluralize a specific word or want to have special output for cases like 0
, then you can also easily define your own pluralize functions. For example:
|
Replacing the currency
Filter
For a very naive implementation, you could do something like this:
|
In many cases though, you’ll still run into strange behavior (e.g. 0.035.toFixed(2)
rounds up to 0.04
, but 0.045
rounds down to 0.04
). To work around these issues, you can use the accounting
library to more reliably format currencies.
Upgrade Path
Run the migration helper on your codebase to find examples of the obsolete text filters. If you miss any, you should also see console errors.
Two-Way Filters replaced
Some users have enjoyed using two-way filters with v-model
to create interesting inputs with very little code. While seemingly simple however, two-way filters can also hide a great deal of complexity - and even encourage poor UX by delaying state updates. Instead, components wrapping an input are recommended as a more explicit and feature-rich way of creating custom inputs.
As an example, we’ll now walk the migration of a two-way currency filter:
It mostly works well, but the delayed state updates can cause strange behavior. For example, try entering 9.999
into one of those inputs. When the input loses focus, its value will update to $10.00
. When looking at the calculated total however, you’ll see that 9.999
is what’s stored in our data. The version of reality that the user sees is out of sync!
To start transitioning towards a more robust solution using Vue 2.0, let’s first wrap this filter in a new <currency-input>
component:
This allows us add behavior that a filter alone couldn’t encapsulate, such as selecting the content of an input on focus. Now the next step will be to extract the business logic from the filter. Below, we pull everything out into an external currencyValidator
object:
This increased modularity not only makes it easier to migrate to Vue 2, but also allows currency parsing and formatting to be:
- unit tested in isolation from your Vue code
- used by other parts of your application, such as to validate the payload to an API endpoint
Having this validator extracted out, we’ve also more comfortably built it up into a more robust solution. The state quirks have been eliminated and it’s actually impossible for users to enter anything wrong, similar to what the browser’s native number input tries to do.
We’re still limited however, by filters and by Vue 1.0 in general, so let’s complete the upgrade to Vue 2.0:
You may notice that:
- Every aspect of our input is more explicit, using lifecycle hooks and DOM events in place of the hidden behavior of two-way filters.
- We can now use
v-model
directly on our custom inputs, which is not only more consistent with normal inputs, but also means our component is Vuex-friendly. - Since we’re no longer using filter options that require a value to be returned, our currency work could actually be done asynchronously. That means if we had a lot of apps that had to work with currencies, we could easily refactor this logic into a shared microservice.
Upgrade Path
Run the migration helper on your codebase to find examples of filters used in directives like v-model
. If you miss any, you should also see console errors.
Slots
Duplicate Slots removed
It is no longer supported to have <slot>
s with the same name in the same template. When a slot is rendered it is “used up” and cannot be rendered elsewhere in the same render tree. If you must render the same content in multiple places, pass that content as a prop.
Upgrade Path
Run your end-to-end test suite or app after upgrading and look for console warnings about duplicate slots v-model
.
slot
Attribute Styling removed
Content inserted via named <slot>
no longer preserves the slot
attribute. Use a wrapper element to style them, or for advanced use cases, modify the inserted content programmatically using render functions.
Upgrade Path
Run the migration helper on your codebase to find CSS selectors targeting named slots (e.g. [slot="my-slot-name"]
).
Special Attributes
keep-alive
Attribute replaced
keep-alive
is no longer a special attribute, but rather a wrapper component, similar to <transition>
. For example:
|
This makes it possible to use <keep-alive>
on multiple conditional children:
|
When <keep-alive>
has multiple children, they should eventually evaluate to a single child. Any child other than the first one will be ignored.
When used together with <transition>
, make sure to nest it inside:
|
Upgrade Path
Run the migration helper on your codebase to find keep-alive
attributes.
Interpolation
Interpolation within Attributes removed
Interpolation within attributes is no longer valid. For example:
|
Should either be updated to use an inline expression:
|
Or a data/computed property:
|
|
Upgrade Path
Run the migration helper on your codebase to find examples of interpolation used within attributes.
HTML Interpolation removed
HTML interpolations ({{{ foo }}}
) have been removed in favor of the v-html
directive.
Upgrade Path
Run the migration helper on your codebase to find HTML interpolations.
One-Time Bindings replaced
One time bindings ({{* foo }}
) have been replaced by the new v-once
directive.
Upgrade Path
Run the migration helper on your codebase to find one-time bindings.
Reactivity
vm.$watch
changed
Watchers created via vm.$watch
are now fired before the associated component rerenders. This gives you the chance to further update state before the component rerender, thus avoiding unnecessary updates. For example, you can watch a component prop and update the component’s own data when the prop changes.
If you were previously relying on vm.$watch
to do something with the DOM after a component updates, you can instead do so in the updated
lifecycle hook.
Upgrade Path
Run your end-to-end test suite, if you have one. The failed tests should alert to you to the fact that a watcher was relying on the old behavior.
vm.$set
changed
vm.$set
is now an alias for Vue.set
.
Upgrade Path
Run the migration helper on your codebase to find examples of the obsolete usage.
vm.$delete
changed
vm.$delete
is now an alias for Vue.delete
.
Upgrade Path
Run the migration helper on your codebase to find examples of the obsolete usage.
Array.prototype.$set
removed
Use Vue.set
instead.
Upgrade Path
Run the migration helper on your codebase to find examples of .$set
on an array. If you miss any, you should see console errors from the missing method.
Array.prototype.$remove
removed
Use Array.prototype.splice
instead. For example:
|
Or better yet, pass removal methods an index:
|
Upgrade Path
Run the migration helper on your codebase to find examples of .$remove
on an array. If you miss any, you should see console errors from the missing method.
Vue.set
and Vue.delete
on Vue instances removed
Vue.set
and Vue.delete
can no longer work on Vue instances. It is now mandatory to properly declare all top-level reactive properties in the data option. If you’d like to delete properties on a Vue instance or its $data
, set it to null.
Upgrade Path
Run the migration helper on your codebase to find examples of Vue.set
or Vue.delete
on a Vue instance. If you miss any, they'll trigger console warnings.
Replacing vm.$data
removed
It is now prohibited to replace a component instance’s root $data. This prevents some edge cases in the reactivity system and makes the component state more predictable (especially with type-checking systems).
Upgrade Path
Run the migration helper on your codebase to find examples of overwriting vm.$data
. If you miss any, console warnings will be emitted.
vm.$get
removed
Instead, retrieve reactive data directly.
Upgrade Path
Run the migration helper on your codebase to find examples of vm.$get
. If you miss any, you'll see console errors.
DOM-Focused Instance Methods
vm.$appendTo
removed
Use the native DOM API:
|
Upgrade Path
Run the migration helper on your codebase to find examples of vm.$appendTo
. If you miss any, you'll see console errors.
vm.$before
removed
Use the native DOM API:
|
Upgrade Path
Run the migration helper on your codebase to find examples of vm.$before
. If you miss any, you'll see console errors.
vm.$after
removed
Use the native DOM API:
|
Or if myElement
is the last child:
|
Upgrade Path
Run the migration helper on your codebase to find examples of vm.$after
. If you miss any, you'll see console errors.
vm.$remove
removed
Use the native DOM API:
|
Upgrade Path
Run the migration helper on your codebase to find examples of vm.$remove
. If you miss any, you'll see console errors.
Meta Instance Methods
vm.$eval
removed
No real use. If you do happen to rely on this feature somehow and aren’t sure how to work around it, post on the forum for ideas.
Upgrade Path
Run the migration helper on your codebase to find examples of vm.$eval
. If you miss any, you'll see console errors.
vm.$interpolate
removed
No real use. If you do happen to rely on this feature somehow and aren’t sure how to work around it, post on the forum for ideas.
Upgrade Path
Run the migration helper on your codebase to find examples of vm.$interpolate
. If you miss any, you'll see console errors.
vm.$log
removed
Use the Vue Devtools for the optimal debugging experience.
Upgrade Path
Run the migration helper on your codebase to find examples of vm.$log
. If you miss any, you'll see console errors.
Instance DOM Options
replace: false
removed
Components now always replace the element they’re bound to. To simulate the behavior of replace: false
, you can wrap your root component with an element similar to the one you’re replacing. For example:
|
Or with a render function:
|
Upgrade Path
Run the migration helper on your codebase to find examples of replace: false
.
Global Config
Vue.config.debug
removed
No longer necessary, since warnings come with stack traces by default now.
Upgrade Path
Run the migration helper on your codebase to find examples of Vue.config.debug
.
Vue.config.async
removed
Async is now required for rendering performance.
Upgrade Path
Run the migration helper on your codebase to find examples of Vue.config.async
.
Vue.config.delimiters
replaced
This has been reworked as a component-level option. This allows you to use alternative delimiters within your app without breaking 3rd-party components.
Upgrade Path
Run the migration helper on your codebase to find examples of Vue.config.delimiters
.
Vue.config.unsafeDelimiters
removed
HTML interpolation has been removed in favor of v-html
.
Upgrade Path
Run the migration helper on your codebase to find examples of Vue.config.unsafeDelimiters
. After this, the helper will also find instances of HTML interpolation so that you can replace them with `v-html`.
Global API
Vue.extend
with el
removed
The el option can no longer be used in Vue.extend
. It’s only valid as an instance creation option.
Upgrade Path
Run your end-to-end test suite or app after upgrading and look for console warnings about the el
option with Vue.extend
.
Vue.elementDirective
removed
Use components instead.
Upgrade Path
Run the migration helper on your codebase to find examples of Vue.elementDirective
.
Vue.partial
removed
Partials have been removed in favor of more explicit data flow between components, using props. Unless you’re using a partial in a performance-critical area, the recommendation is to use a normal component instead. If you were dynamically binding the name
of a partial, you can use a dynamic component.
If you happen to be using partials in a performance-critical part of your app, then you should upgrade to functional components. They must be in a plain JS/JSX file (rather than in a .vue
file) and are stateless and instanceless, like partials. This makes rendering extremely fast.
A benefit of functional components over partials is that they can be much more dynamic, because they grant you access to the full power of JavaScript. There is a cost to this power however. If you’ve never used a component framework with render functions before, they may take a bit longer to learn.
Upgrade Path
Run the migration helper on your codebase to find examples of Vue.partial
.hhuh(hh	h}ubh)}(h}(hNh	}(hhttps://router.vuejs.org/api/h
API Documentation | Vue RouteruhXO  API Documentation
API Documentation
Enumerations
Interfaces
- HistoryState
- LocationAsRelativeRaw
- MatcherLocation
- MatcherLocationAsPath
- NavigationFailure
- NavigationGuard
- NavigationGuardNext
- NavigationGuardWithThis
- NavigationHookAfter
- NavigationRedirectError
- RouteLocationAsPathGeneric
- RouteLocationAsPathTyped
- RouteLocationAsRelativeGeneric
- RouteLocationAsRelativeTyped
- RouteLocationGeneric
- RouteLocationMatched
- RouteLocationNamedRaw
- RouteLocationNormalizedGeneric
- RouteLocationNormalizedLoadedGeneric
- RouteLocationNormalizedLoadedTyped
- RouteLocationNormalizedTyped
- RouteLocationOptions
- RouteLocationPathRaw
- RouteLocationResolvedGeneric
- RouteLocationResolvedTyped
- RouteLocationTyped
- RouteMeta
- RouteQueryAndHash
- RouteRecordInfo
- RouteRecordMultipleViews
- RouteRecordMultipleViewsWithChildren
- RouteRecordNormalized
- RouteRecordRedirect
- RouteRecordSingleView
- RouteRecordSingleViewWithChildren
- Router
- RouterHistory
- RouterLinkProps
- RouterMatcher
- RouterOptions
- RouterScrollBehavior
- RouterViewProps
- TypesConfig
- UseLinkOptions
- UseLinkReturn
- _PathParserOptions
- _RouteLocationBase
- _RouteRecordBase
- _RouterLinkI
Type Aliases
LocationQuery
Ƭ LocationQuery: Record
<string
, LocationQueryValue
| LocationQueryValue
[]>
Normalized query object that appears in RouteLocationNormalized
LocationQueryRaw
Ƭ LocationQueryRaw: Record
<string
| number
, LocationQueryValueRaw
| LocationQueryValueRaw
[]>
Loose LocationQuery object that can be passed to functions like Router.push and Router.replace or anywhere when creating a RouteLocationRaw
LocationQueryValue
Ƭ LocationQueryValue: string
| null
Possible values in normalized LocationQuery. null
renders the query param but without an =
.
Example
?isNull&isEmpty=&other=other
gives
`{ isNull: null, isEmpty: '', other: 'other' }`.
LocationQueryValueRaw
Ƭ LocationQueryValueRaw: LocationQueryValue
| number
| undefined
Possible values when defining a query.
NavigationGuardNextCallback
Ƭ NavigationGuardNextCallback: (vm
: ComponentPublicInstance
) => unknown
Callback that can be passed to next()
in beforeRouteEnter()
guards.
Type declaration
▸ (vm
): unknown
Parameters
Name | Type |
---|---|
vm | ComponentPublicInstance |
Returns
unknown
NavigationGuardReturn
Ƭ NavigationGuardReturn: void
| Error
| boolean
| RouteLocationRaw
Return types for a Navigation Guard. Based on TypesConfig
See
ParamValue
Ƭ ParamValue<isRaw
>: true
extends isRaw
? string
| number
: string
Utility type for raw and non raw params like :id
Type parameters
Name | Type |
---|---|
isRaw | extends boolean |
ParamValueOneOrMore
Ƭ ParamValueOneOrMore<isRaw
>: [ParamValue
<isRaw
>, ...ParamValue<isRaw>[]]
Utility type for raw and non raw params like :id+
Type parameters
Name | Type |
---|---|
isRaw | extends boolean |
ParamValueZeroOrMore
Ƭ ParamValueZeroOrMore<isRaw
>: true
extends isRaw
? ParamValue
<isRaw
>[] | undefined
| null
: ParamValue
<isRaw
>[] | undefined
Utility type for raw and non raw params like :id*
Type parameters
Name | Type |
---|---|
isRaw | extends boolean |
ParamValueZeroOrOne
Ƭ ParamValueZeroOrOne<isRaw
>: true
extends isRaw
? string
| number
| null
| undefined
: string
Utility type for raw and non raw params like :id?
Type parameters
Name | Type |
---|---|
isRaw | extends boolean |
PathParserOptions
Ƭ PathParserOptions: Pick
<_PathParserOptions
, "end"
| "sensitive"
| "strict"
>
RouteComponent
Ƭ RouteComponent: Component
| DefineComponent
Allowed Component in RouteLocationMatched
RouteLocation
Ƭ RouteLocation<Name
>: RouteMapGeneric
extends RouteMap
? RouteLocationGeneric
: RouteLocationTypedList
<RouteMap
>[Name
]
RouteLocationRaw resolved using the matcher
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
RouteLocationAsPath
Ƭ RouteLocationAsPath<Name
>: RouteMapGeneric
extends RouteMap
? RouteLocationAsPathGeneric
: RouteLocationAsPathTypedList
<RouteMap
>[Name
]
Route location as an object with a path
property.
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
RouteLocationAsPathTypedList
Ƭ RouteLocationAsPathTypedList<RouteMap
>: { [N in keyof RouteMap]: RouteLocationAsPathTyped<RouteMap, N> }
List of all possible RouteLocationAsPath indexed by the route name.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
RouteLocationAsRelative
Ƭ RouteLocationAsRelative<Name
>: RouteMapGeneric
extends RouteMap
? RouteLocationAsRelativeGeneric
: RouteLocationAsRelativeTypedList
<RouteMap
>[Name
]
Route location relative to the current location. It accepts other properties than path
like params
, query
and hash
to conveniently change them.
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
RouteLocationAsRelativeTypedList
Ƭ RouteLocationAsRelativeTypedList<RouteMap
>: { [N in keyof RouteMap]: RouteLocationAsRelativeTyped<RouteMap, N> }
List of all possible RouteLocationAsRelative indexed by the route name.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
RouteLocationAsString
Ƭ RouteLocationAsString<Name
>: RouteMapGeneric
extends RouteMap
? string
: _LiteralUnion
<RouteLocationAsStringTypedList
<RouteMap
>[Name
], string
>
Same as RouteLocationAsPath but as a string literal.
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
RouteLocationAsStringTyped
Ƭ RouteLocationAsStringTyped<RouteMap
, Name
>: RouteMap
[Name
]["path"
]
Helper to generate a type safe version of the RouteLocationAsString type.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
Name | extends keyof RouteMap = keyof RouteMap |
RouteLocationAsStringTypedList
Ƭ RouteLocationAsStringTypedList<RouteMap
>: { [N in keyof RouteMap]: RouteLocationAsStringTyped<RouteMap, N> }
List of all possible RouteLocationAsString indexed by the route name.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
RouteLocationNormalized
Ƭ RouteLocationNormalized<Name
>: RouteMapGeneric
extends RouteMap
? RouteLocationNormalizedGeneric
: RouteLocationNormalizedTypedList
<RouteMap
>[Name
]
Similar to RouteLocation but its matched
property cannot contain redirect records
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
RouteLocationNormalizedLoaded
Ƭ RouteLocationNormalizedLoaded<Name
>: RouteMapGeneric
extends RouteMap
? RouteLocationNormalizedLoadedGeneric
: RouteLocationNormalizedLoadedTypedList
<RouteMap
>[Name
]
Similar to RouteLocationNormalized but its components
do not contain any function to lazy load components. In other words, it's ready to be rendered by <RouterView>
.
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
RouteLocationNormalizedLoadedTypedList
Ƭ RouteLocationNormalizedLoadedTypedList<RouteMap
>: { [N in keyof RouteMap]: RouteLocationNormalizedLoadedTyped<RouteMap, N> }
List of all possible RouteLocationNormalizedLoaded indexed by the route name.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
RouteLocationNormalizedTypedList
Ƭ RouteLocationNormalizedTypedList<RouteMap
>: { [N in keyof RouteMap]: RouteLocationNormalizedTyped<RouteMap, N> }
List of all possible RouteLocationNormalized indexed by the route name.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
RouteLocationRaw
Ƭ RouteLocationRaw<Name
>: RouteMapGeneric
extends RouteMap
? RouteLocationAsString
| RouteLocationAsRelativeGeneric
| RouteLocationAsPathGeneric
: _LiteralUnion
<RouteLocationAsStringTypedList
<RouteMap
>[Name
], string
> | RouteLocationAsRelativeTypedList
<RouteMap
>[Name
] | RouteLocationAsPathTypedList
<RouteMap
>[Name
]
Route location that can be passed to router.push()
and other user-facing APIs.
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
RouteLocationResolved
Ƭ RouteLocationResolved<Name
>: RouteMapGeneric
extends RouteMap
? RouteLocationResolvedGeneric
: RouteLocationResolvedTypedList
<RouteMap
>[Name
]
Route location resolved with router.resolve()
.
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
RouteLocationResolvedTypedList
Ƭ RouteLocationResolvedTypedList<RouteMap
>: { [N in keyof RouteMap]: RouteLocationResolvedTyped<RouteMap, N> }
List of all possible RouteLocationResolved indexed by the route name.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
RouteLocationTypedList
Ƭ RouteLocationTypedList<RouteMap
>: { [N in keyof RouteMap]: RouteLocationTyped<RouteMap, N> }
List of all possible RouteLocation indexed by the route name.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
RouteMap
Ƭ RouteMap: TypesConfig
extends Record
<"RouteNamedMap"
, infer RouteNamedMap> ? RouteNamedMap
: RouteMapGeneric
Convenience type to get the typed RouteMap or a generic one if not provided. It is extracted from the TypesConfig if it exists, it becomes RouteMapGeneric otherwise.
RouteMapGeneric
Ƭ RouteMapGeneric: Record
<string
| symbol
, RouteRecordInfo
>
Generic version of the RouteMap
.
RouteParamValue
Ƭ RouteParamValue: string
RouteParamValueRaw
Ƭ RouteParamValueRaw: RouteParamValue
| number
| null
| undefined
RouteParams
Ƭ RouteParams<Name
>: RouteMap
[Name
]["params"
]
Generate a type safe params for a route location. Requires the name of the route to be passed as a generic.
See
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
RouteParamsGeneric
Ƭ RouteParamsGeneric: Record
<string
, RouteParamValue
| RouteParamValue
[]>
RouteParamsRaw
Ƭ RouteParamsRaw<Name
>: RouteMap
[Name
]["paramsRaw"
]
Generate a type safe raw params for a route location. Requires the name of the route to be passed as a generic.
See
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
RouteParamsRawGeneric
Ƭ RouteParamsRawGeneric: Record
<string
, RouteParamValueRaw
| Exclude
<RouteParamValueRaw
, null
| undefined
>[]>
RouteRecord
Ƭ RouteRecord: RouteRecordNormalized
Normalized version of a route record.
RouteRecordName
Ƭ RouteRecordName: RouteMapGeneric
extends RouteMap
? RouteRecordNameGeneric
: keyof RouteMap
Possible values for a route record after normalization
NOTE: since RouteRecordName
is a type, it evaluates too early and it's often the generic version RouteRecordNameGeneric. If you need a typed version of all of the names of routes, use keyof RouteMap
RouteRecordNameGeneric
Ƭ RouteRecordNameGeneric: string
| symbol
| undefined
Generic version of RouteRecordName.
RouteRecordRaw
Ƭ RouteRecordRaw: RouteRecordSingleView
| RouteRecordSingleViewWithChildren
| RouteRecordMultipleViews
| RouteRecordMultipleViewsWithChildren
| RouteRecordRedirect
RouteRecordRedirectOption
Ƭ RouteRecordRedirectOption: RouteLocationRaw
| (to
: RouteLocation
) => RouteLocationRaw
_Awaitable
Ƭ _Awaitable<T
>: T
| PromiseLike
<T
>
Maybe a promise maybe not
Type parameters
Name |
---|
T |
_RouteMetaBase
Ƭ _RouteMetaBase: Record
<string
| number
| symbol
, unknown
>
Default type for RouteMeta when not augmented.
_RouteRecordProps
Ƭ _RouteRecordProps<Name
>: boolean
| Record
<string
, any
> | (to
: RouteLocationNormalized
<Name
>) => Record
<string
, any
>
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
Variables
RouterLink
• Const
RouterLink: _RouterLinkI
Component to render a link that triggers a navigation on click.
RouterView
• Const
RouterView: () => { $props
: AllowedComponentProps
& ComponentCustomProps
& VNodeProps
& RouterViewProps
; $slots
: { default?
: (__namedParameters
: { Component
: VNode
<RendererNode
, RendererElement
, { [key: string]
: any
; }> ; route
: RouteLocationNormalizedLoadedGeneric
}) => VNode
<RendererNode
, RendererElement
, { [key: string]
: any
; }>[] } }
Component to display the current route the user is at.
Type declaration
• new RouterView(): Object
Component to display the current route the user is at.
Returns
Object
Name | Type |
---|---|
$props | AllowedComponentProps & ComponentCustomProps & VNodeProps & RouterViewProps |
$slots | { default? : (__namedParameters : { Component : VNode <RendererNode , RendererElement , { [key: string] : any ; }> ; route : RouteLocationNormalizedLoadedGeneric }) => VNode <RendererNode , RendererElement , { [key: string] : any ; }>[] } |
$slots.default? | (__namedParameters : { Component : VNode <RendererNode , RendererElement , { [key: string] : any ; }> ; route : RouteLocationNormalizedLoadedGeneric }) => VNode <RendererNode , RendererElement , { [key: string] : any ; }>[] |
START_LOCATION
• Const
START_LOCATION: RouteLocationNormalizedLoaded
Initial route location where the router is. Can be used in navigation guards to differentiate the initial navigation.
Example
import { START_LOCATION } from 'vue-router'
router.beforeEach((to, from) => {
if (from === START_LOCATION) {
// initial navigation
}
})
matchedRouteKey
• Const
matchedRouteKey: InjectionKey
<ComputedRef
<undefined
| RouteRecordNormalized
>>
RouteRecord being rendered by the closest ancestor Router View. Used for onBeforeRouteUpdate
and onBeforeRouteLeave
. rvlm stands for Router View Location Matched
routeLocationKey
• Const
routeLocationKey: InjectionKey
<RouteLocationNormalizedLoadedGeneric
>
Allows overriding the current route returned by useRoute
in tests. rl stands for route location
routerKey
• Const
routerKey: InjectionKey
<Router
>
Allows overriding the router instance returned by useRouter
in tests. r stands for router
routerViewLocationKey
• Const
routerViewLocationKey: InjectionKey
<Ref
<RouteLocationNormalizedLoadedGeneric
>>
Allows overriding the current route used by router-view. Internally this is used when the route
prop is passed.
viewDepthKey
• Const
viewDepthKey: InjectionKey
<number
| Ref
<number
>>
Allows overriding the router view depth to control which component in matched
is rendered. rvd stands for Router View Depth
Functions
createMemoryHistory
▸ createMemoryHistory(base?
): RouterHistory
Creates an in-memory based history. The main purpose of this history is to handle SSR. It starts in a special location that is nowhere. It's up to the user to replace that location with the starter location by either calling router.push
or router.replace
.
Parameters
Name | Type | Default value | Description |
---|---|---|---|
base | string | '' | Base applied to all urls, defaults to '/' |
Returns
a history object that can be passed to the router constructor
createRouter
▸ createRouter(options
): Router
Creates a Router instance that can be used by a Vue app.
Parameters
Name | Type | Description |
---|---|---|
options | RouterOptions | RouterOptions |
Returns
createRouterMatcher
▸ createRouterMatcher(routes
, globalOptions
): RouterMatcher
Creates a Router Matcher.
Parameters
Name | Type | Description |
---|---|---|
routes | readonly RouteRecordRaw [] | array of initial routes |
globalOptions | PathParserOptions | global route options |
Returns
createWebHashHistory
▸ createWebHashHistory(base?
): RouterHistory
Creates a hash history. Useful for web applications with no host (e.g. file://
) or when configuring a server to handle any URL is not possible.
Parameters
Name | Type | Description |
---|---|---|
base? | string | optional base to provide. Defaults to location.pathname + location.search If there is a <base> tag in the head , its value will be ignored in favor of this parameter but note it affects all the history.pushState() calls, meaning that if you use a <base> tag, it's href value has to match this parameter (ignoring anything after the # ). |
Returns
Example
// at https://example.com/folder
createWebHashHistory() // gives a url of `https://example.com/folder#`
createWebHashHistory('/folder/') // gives a url of `https://example.com/folder/#`
// if the `#` is provided in the base, it won't be added by `createWebHashHistory`
createWebHashHistory('/folder/#/app/') // gives a url of `https://example.com/folder/#/app/`
// you should avoid doing this because it changes the original url and breaks copying urls
createWebHashHistory('/other-folder/') // gives a url of `https://example.com/other-folder/#`
// at file:///usr/etc/folder/index.html
// for locations with no `host`, the base is ignored
createWebHashHistory('/iAmIgnored') // gives a url of `file:///usr/etc/folder/index.html#`
createWebHistory
▸ createWebHistory(base?
): RouterHistory
Creates an HTML5 history. Most common history for single page applications.
Parameters
Name | Type |
---|---|
base? | string |
Returns
isNavigationFailure
▸ isNavigationFailure(error
, type?
): error is NavigationRedirectError
Check if an object is a NavigationFailure.
Parameters
Name | Type | Description |
---|---|---|
error | any | possible NavigationFailure |
type? | NAVIGATION_GUARD_REDIRECT | optional types to check for |
Returns
error is NavigationRedirectError
Example
import { isNavigationFailure, NavigationFailureType } from 'vue-router'
router.afterEach((to, from, failure) => {
// Any kind of navigation failure
if (isNavigationFailure(failure)) {
// ...
}
// Only duplicated navigations
if (isNavigationFailure(failure, NavigationFailureType.duplicated)) {
// ...
}
// Aborted or canceled navigations
if (isNavigationFailure(failure, NavigationFailureType.aborted | NavigationFailureType.canceled)) {
// ...
}
})
▸ isNavigationFailure(error
, type?
): error is NavigationFailure
Parameters
Name | Type |
---|---|
error | any |
type? | ErrorTypes | NavigationFailureType |
Returns
error is NavigationFailure
loadRouteLocation
▸ loadRouteLocation(route
): Promise
<RouteLocationNormalizedLoaded
>
Ensures a route is loaded, so it can be passed as o prop to <RouterView>
.
Parameters
Name | Type | Description |
---|---|---|
route | RouteLocationNormalizedGeneric | RouteLocationGeneric | resolved route to load |
Returns
Promise
<RouteLocationNormalizedLoaded
>
onBeforeRouteLeave
▸ onBeforeRouteLeave(leaveGuard
): void
Add a navigation guard that triggers whenever the component for the current location is about to be left. Similar to beforeRouteLeave but can be used in any component. The guard is removed when the component is unmounted.
Parameters
Name | Type | Description |
---|---|---|
leaveGuard | NavigationGuard | NavigationGuard |
Returns
void
onBeforeRouteUpdate
▸ onBeforeRouteUpdate(updateGuard
): void
Add a navigation guard that triggers whenever the current location is about to be updated. Similar to beforeRouteUpdate but can be used in any component. The guard is removed when the component is unmounted.
Parameters
Name | Type | Description |
---|---|---|
updateGuard | NavigationGuard | NavigationGuard |
Returns
void
parseQuery
▸ parseQuery(search
): LocationQuery
Transforms a queryString into a LocationQuery object. Accept both, a version with the leading ?
and without Should work as URLSearchParams
Parameters
Name | Type | Description |
---|---|---|
search | string | search string to parse |
Returns
a query object
stringifyQuery
▸ stringifyQuery(query
): string
Stringifies a LocationQueryRaw object. Like URLSearchParams
, it doesn't prepend a ?
Parameters
Name | Type | Description |
---|---|---|
query | LocationQueryRaw | query object to stringify |
Returns
string
string version of the query without the leading ?
useLink
▸ useLink<Name
>(props
): UseLinkReturn
<Name
>
Returns the internal behavior of a RouterLink without the rendering part.
Type parameters
Name | Type |
---|---|
Name | extends string | symbol = string | symbol |
Parameters
Name | Type | Description |
---|---|---|
props | UseLinkOptions <Name > | a to location and an optional replace flag |
Returns
UseLinkReturn
<Name
>
useRoute
▸ useRoute<Name
>(_name?
): RouteLocationNormalizedLoaded
<Name
>
Returns the current route location. Equivalent to using $route
inside templates.
Type parameters
Name | Type |
---|---|
Name | extends string | symbol = string | symbol |
Parameters
Name | Type |
---|---|
_name? | Name |
Returns
RouteLocationNormalizedLoaded
<Name
>
useRouter
▸ useRouter(): Router
Returns the router instance. Equivalent to using $router
inside templates.8     hhuh(hh	h}ubh)}(h}(hNh	}(h@https://router.vuejs.org/api/interfaces/routelocationaspathtypedh
@Interface: RouteLocationAsPathTyped<RouteMap, Name> | Vue RouteruhX  API Documentation / RouteLocationAsPathTyped
Interface: RouteLocationAsPathTyped<RouteMap, Name>
Helper to generate a type safe version of the RouteLocationAsPath type.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
Name | extends keyof RouteMap = keyof RouteMap |
Hierarchy
↳
RouteLocationAsPathTyped
Properties
force
• Optional
force: boolean
Triggers the navigation even if the location is the same as the current one. Note this will also add a new entry to the history unless replace: true
is passed.
Inherited from
RouteLocationAsPathGeneric.force
hash
• Optional
hash: string
Inherited from
RouteLocationAsPathGeneric.hash
path
• path: _LiteralUnion
<RouteMap
[Name
]["path"
]>
Percentage encoded pathname section of the URL.
Overrides
RouteLocationAsPathGeneric.path
query
• Optional
query: LocationQueryRaw
Inherited from
RouteLocationAsPathGeneric.query
replace
• Optional
replace: boolean
Replace the entry in the history instead of pushing a new entry
Inherited from
RouteLocationAsPathGeneric.replace
state
• Optional
state: HistoryState
State to save using the History API. This cannot contain any reactive values and some primitives like Symbols are forbidden. More info at https://developer.mozilla.org/en-US/docs/Web/API/History/statehhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/api/interfaces/matcherlocationh
'Interface: MatcherLocation | Vue RouteruhX  API Documentation / MatcherLocation
Interface: MatcherLocation
Normalized/resolved Route location that returned by the matcher.
Properties
matched
• matched: RouteRecordNormalized
[]
Array of RouteRecord containing components as they were passed when adding records. It can also contain redirect records. This can't be used directly
meta
• meta: RouteMeta
Merged meta
properties from all the matched route records.
name
• name: null
| RouteRecordNameGeneric
Name of the matched record
params
• params: RouteParamsGeneric
Object of decoded params extracted from the path
.
path
• path: string
Percentage encoded pathname section of the URL.hhuh(hh	h}ubh)}(h}(hNh	}(h6https://router.vuejs.org/api/interfaces/uselinkoptionsh
,Interface: UseLinkOptions<Name> | Vue RouteruhX  API Documentation / UseLinkOptions
Interface: UseLinkOptions<Name>
Options passed to useLink.
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
Properties
replace
• Optional
replace: MaybeRef
<undefined
| boolean
>
to
• to: MaybeRef
<string
| RouteLocationAsRelativeGeneric
| RouteLocationAsPathGeneric
| RouteLocationAsRelativeTyped
<RouteMapGeneric
, Name
>>hhuh(hh	h}ubh)}(h}(hNh	}(h5https://router.vuejs.org/api/interfaces/routermatcherh
%Interface: RouterMatcher | Vue RouteruhXj  API Documentation / RouterMatcher
Interface: RouterMatcher
Internal RouterMatcher
Properties
addRoute
• addRoute: (record
: RouteRecordRaw
, parent?
: RouteRecordMatcher
) => () => void
Type declaration
▸ (record
, parent?
): () => void
Parameters
Name | Type |
---|---|
record | RouteRecordRaw |
parent? | RouteRecordMatcher |
Returns
fn
▸ (): void
Returns
void
clearRoutes
• clearRoutes: () => void
Type declaration
▸ (): void
Returns
void
getRecordMatcher
• getRecordMatcher: (name
: NonNullable
<RouteRecordNameGeneric
>) => undefined
| RouteRecordMatcher
Type declaration
▸ (name
): undefined
| RouteRecordMatcher
Parameters
Name | Type |
---|---|
name | NonNullable <RouteRecordNameGeneric > |
Returns
undefined
| RouteRecordMatcher
getRoutes
• getRoutes: () => RouteRecordMatcher
[]
Type declaration
▸ (): RouteRecordMatcher
[]
Returns
RouteRecordMatcher
[]
resolve
• resolve: (location
: MatcherLocationRaw
, currentLocation
: MatcherLocation
) => MatcherLocation
Resolves a location. Gives access to the route record that corresponds to the actual path as well as filling the corresponding params objects
Param
MatcherLocationRaw to resolve to a url
Param
MatcherLocation of the current location
Type declaration
▸ (location
, currentLocation
): MatcherLocation
Resolves a location. Gives access to the route record that corresponds to the actual path as well as filling the corresponding params objects
Parameters
Name | Type | Description |
---|---|---|
location | MatcherLocationRaw | MatcherLocationRaw to resolve to a url |
currentLocation | MatcherLocation | MatcherLocation of the current location |
Returns
Methods
removeRoute
▸ removeRoute(matcher
): void
Parameters
Name | Type |
---|---|
matcher | RouteRecordMatcher |
Returns
void
▸ removeRoute(name
): void
Parameters
Name | Type |
---|---|
name | NonNullable <RouteRecordNameGeneric > |
Returns
voidhhuh(hh	h}ubh)}(h}(hNh	}(hLhttps://router.vuejs.org/api/interfaces/routelocationnormalizedloadedgenerich
<Interface: RouteLocationNormalizedLoadedGeneric | Vue RouteruhX  API Documentation / RouteLocationNormalizedLoadedGeneric
Interface: RouteLocationNormalizedLoadedGeneric
Generic version of RouteLocationNormalizedLoaded that is used when no RouteMap is provided.
Hierarchy
RouteLocationNormalizedGeneric
↳
RouteLocationNormalizedLoadedGeneric
Properties
fullPath
• fullPath: string
The whole location including the search
and hash
. This string is percentage encoded.
Inherited from
RouteLocationNormalizedGeneric.fullPath
hash
• hash: string
Hash of the current location. If present, starts with a #
.
Inherited from
RouteLocationNormalizedGeneric.hash
matched
• matched: RouteLocationMatched
[]
Array of RouteLocationMatched containing only plain components (any lazy-loaded components have been loaded and were replaced inside the components
object) so it can be directly used to display routes. It cannot contain redirect records either. This property is non-enumerable.
Overrides
RouteLocationNormalizedGeneric.matched
meta
• meta: RouteMeta
Merged meta
properties from all the matched route records.
Inherited from
RouteLocationNormalizedGeneric.meta
name
• name: RouteRecordNameGeneric
Name of the matched record
Inherited from
RouteLocationNormalizedGeneric.name
params
• params: RouteParamsGeneric
Object of decoded params extracted from the path
.
Inherited from
RouteLocationNormalizedGeneric.params
path
• path: string
Percentage encoded pathname section of the URL.
Inherited from
RouteLocationNormalizedGeneric.path
query
• query: LocationQuery
Object representation of the search
property of the current location.
Inherited from
RouteLocationNormalizedGeneric.query
redirectedFrom
• redirectedFrom: undefined
| RouteLocationGeneric
Contains the location we were initially trying to access before ending up on the current location.hhuh(hh	h}ubh)}(h}(hNh	}(h;https://router.vuejs.org/api/interfaces/routerecordredirecth
+Interface: RouteRecordRedirect | Vue RouteruhX  API Documentation / RouteRecordRedirect
Interface: RouteRecordRedirect
Route Record that defines a redirect. Cannot have component
or components
as it is never rendered.
Hierarchy
↳
RouteRecordRedirect
Properties
alias
• Optional
alias: string
| string
[]
Aliases for the record. Allows defining extra paths that will behave like a copy of the record. Allows having paths shorthands like /users/:id
and /u/:id
. All alias
and path
values must share the same params.
Inherited from
beforeEnter
• Optional
beforeEnter: NavigationGuardWithThis
<undefined
> | NavigationGuardWithThis
<undefined
>[]
Before Enter guard specific to this record. Note beforeEnter
has no effect if the record has a redirect
property.
Inherited from
children
• Optional
children: RouteRecordRaw
[]
Array of nested routes.
Inherited from
component
• Optional
component: undefined
components
• Optional
components: undefined
end
• Optional
end: boolean
Should the RegExp match until the end by appending a $
to it.
Default Value
true
Inherited from
meta
• Optional
meta: RouteMeta
Arbitrary data attached to the record.
Inherited from
name
• Optional
name: RouteRecordNameGeneric
Name for the route record. Must be unique.
Inherited from
path
• path: string
Path of the record. Should start with /
unless the record is the child of another record.
Example
`/users/:id` matches `/users/1` as well as `/users/posva`.
Inherited from
props
• Optional
props: undefined
Allow passing down params as props to the component rendered by router-view
.
Overrides
redirect
• redirect: RouteRecordRedirectOption
Where to redirect if the route is directly matched. The redirection happens before any navigation guard and triggers a new navigation with the new target location.
Overrides
sensitive
• Optional
sensitive: boolean
Makes the RegExp case-sensitive.
Default Value
false
Inherited from
strict
• Optional
strict: boolean
Whether to disallow a trailing slash or not.
Default Value
falsehhuh(hh	h}ubh)}(h}(hNh	}(hDhttps://router.vuejs.org/api/interfaces/routelocationasrelativetypedh
DInterface: RouteLocationAsRelativeTyped<RouteMap, Name> | Vue RouteruhX<  API Documentation / RouteLocationAsRelativeTyped
Interface: RouteLocationAsRelativeTyped<RouteMap, Name>
Helper to generate a type safe version of the RouteLocationAsRelative type.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
Name | extends keyof RouteMap = keyof RouteMap |
Hierarchy
RouteLocationAsRelativeGeneric
↳
RouteLocationAsRelativeTyped
Properties
force
• Optional
force: boolean
Triggers the navigation even if the location is the same as the current one. Note this will also add a new entry to the history unless replace: true
is passed.
Inherited from
RouteLocationAsRelativeGeneric.force
hash
• Optional
hash: string
Inherited from
RouteLocationAsRelativeGeneric.hash
name
• Optional
name: Extract
<Name
, string
| symbol
>
Overrides
RouteLocationAsRelativeGeneric.name
params
• Optional
params: RouteMap
[Name
]["paramsRaw"
]
Overrides
RouteLocationAsRelativeGeneric.params
path
• Optional
path: undefined
A relative path to the current location. This property should be removed
Inherited from
RouteLocationAsRelativeGeneric.path
query
• Optional
query: LocationQueryRaw
Inherited from
RouteLocationAsRelativeGeneric.query
replace
• Optional
replace: boolean
Replace the entry in the history instead of pushing a new entry
Inherited from
RouteLocationAsRelativeGeneric.replace
state
• Optional
state: HistoryState
State to save using the History API. This cannot contain any reactive values and some primitives like Symbols are forbidden. More info at https://developer.mozilla.org/en-US/docs/Web/API/History/statehhuh(hh	h}ubh)}(h}(hNh	}(h?https://router.vuejs.org/api/interfaces/navigationredirecterrorh
/Interface: NavigationRedirectError | Vue RouteruhX  API Documentation / NavigationRedirectError
Interface: NavigationRedirectError
Internal error used to detect a redirection.
Hierarchy
Omit
<NavigationFailure
,"to"
|"type"
>↳
NavigationRedirectError
Properties
cause
• Optional
cause: unknown
Inherited from
Omit.cause
from
• from: RouteLocationNormalizedGeneric
Route location we were navigating from
Inherited from
Omit.from
message
• message: string
Inherited from
Omit.message
name
• name: string
Inherited from
Omit.name
stack
• Optional
stack: string
Inherited from
Omit.stack
to
• to: string
| RouteLocationAsRelativeGeneric
| RouteLocationAsPathGeneric
type
• type: NAVIGATION_GUARD_REDIRECThhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/api/interfaces/routerviewpropsh
'Interface: RouterViewProps | Vue RouteruhX  API Documentation / RouterViewProps
Interface: RouterViewProps
Properties
name
• Optional
name: string
route
• Optional
route: RouteLocationNormalizedGeneric
API Documentation / RouterViewProps
• Optional
name: string
• Optional
route: RouteLocationNormalizedGenerichhuh(hh	h}ubh)}(h}(hNh	}(h5https://router.vuejs.org/api/interfaces/routeroptionsh
%Interface: RouterOptions | Vue RouteruhX  API Documentation / RouterOptions
Interface: RouterOptions
Options to initialize a Router instance.
Hierarchy
↳
RouterOptions
Properties
end
• Optional
end: boolean
Should the RegExp match until the end by appending a $
to it.
Default Value
true
Inherited from
PathParserOptions.end
history
• history: RouterHistory
History implementation used by the router. Most web applications should use createWebHistory
but it requires the server to be properly configured. You can also use a hash based history with createWebHashHistory
that does not require any configuration on the server but isn't handled at all by search engines and does poorly on SEO.
Example
createRouter({
history: createWebHistory(),
// other options...
})
linkActiveClass
• Optional
linkActiveClass: string
Default class applied to active RouterLink. If none is provided, router-link-active
will be applied.
linkExactActiveClass
• Optional
linkExactActiveClass: string
Default class applied to exact active RouterLink. If none is provided, router-link-exact-active
will be applied.
parseQuery
• Optional
parseQuery: (search
: string
) => LocationQuery
Custom implementation to parse a query. See its counterpart, RouterOptions.stringifyQuery.
Example
Let's say you want to use the qs package to parse queries, you can provide both parseQuery
and stringifyQuery
:
import qs from 'qs'
createRouter({
// other options...
parseQuery: qs.parse,
stringifyQuery: qs.stringify,
})
Type declaration
▸ (search
): LocationQuery
Custom implementation to parse a query. See its counterpart, RouterOptions.stringifyQuery.
Parameters
Name | Type |
---|---|
search | string |
Returns
Example
Let's say you want to use the qs package to parse queries, you can provide both parseQuery
and stringifyQuery
:
import qs from 'qs'
createRouter({
// other options...
parseQuery: qs.parse,
stringifyQuery: qs.stringify,
})
routes
• routes: readonly RouteRecordRaw
[]
Initial list of routes that should be added to the router.
scrollBehavior
• Optional
scrollBehavior: RouterScrollBehavior
Function to control scrolling when navigating between pages. Can return a Promise to delay scrolling. Check ScrollBehavior.
Example
function scrollBehavior(to, from, savedPosition) {
// `to` and `from` are both route locations
// `savedPosition` can be null if there isn't one
}
sensitive
• Optional
sensitive: boolean
Makes the RegExp case-sensitive.
Default Value
false
Inherited from
PathParserOptions.sensitive
strict
• Optional
strict: boolean
Whether to disallow a trailing slash or not.
Default Value
false
Inherited from
PathParserOptions.strict
stringifyQuery
• Optional
stringifyQuery: (query
: LocationQueryRaw
) => string
Custom implementation to stringify a query object. Should not prepend a leading ?
. parseQuery counterpart to handle query parsing.
Type declaration
▸ (query
): string
Custom implementation to stringify a query object. Should not prepend a leading ?
. parseQuery counterpart to handle query parsing.
Parameters
Name | Type |
---|---|
query | LocationQueryRaw |
Returns
stringhhuh(hh	h}ubh)}(h}(hNh	}(h9https://router.vuejs.org/api/interfaces/routequeryandhashh
)Interface: RouteQueryAndHash | Vue RouteruhXp  API Documentation / RouteQueryAndHash
Interface: RouteQueryAndHash
Hierarchy
RouteQueryAndHash
↳
RouteLocationAsRelativeGeneric
Properties
hash
• Optional
hash: string
query
• Optional
query: LocationQueryRaw
API Documentation / RouteQueryAndHash
RouteQueryAndHash
↳ RouteLocationAsRelativeGeneric
• Optional
hash: string
• Optional
query: LocationQueryRawhhuh(hh	h}ubh)}(h}(hNh	}(h9https://router.vuejs.org/api/interfaces/routelocationbaseh
*Interface: _RouteLocationBase | Vue RouteruhXM  API Documentation / _RouteLocationBase
Interface: _RouteLocationBase
Base properties for a normalized route location.
Hierarchy
Pick
<MatcherLocation
,"name"
|"path"
|"params"
|"meta"
>↳
_RouteLocationBase
Properties
fullPath
• fullPath: string
The whole location including the search
and hash
. This string is percentage encoded.
hash
• hash: string
Hash of the current location. If present, starts with a #
.
meta
• meta: RouteMeta
Merged meta
properties from all the matched route records.
Inherited from
Pick.meta
name
• name: null
| RouteRecordNameGeneric
Name of the matched record
Inherited from
Pick.name
params
• params: RouteParamsGeneric
Object of decoded params extracted from the path
.
Inherited from
Pick.params
path
• path: string
Percentage encoded pathname section of the URL.
Inherited from
Pick.path
query
• query: LocationQuery
Object representation of the search
property of the current location.
redirectedFrom
• redirectedFrom: undefined
| RouteLocationGeneric
Contains the location we were initially trying to access before ending up on the current location.hhuh(hh	h}ubh)}(h}(hNh	}(h4https://router.vuejs.org/api/interfaces/historystateh
$Interface: HistoryState | Vue RouteruhEnglish
Appearance
Complete guide to
Mastering Pinia
written by its creator
The official
Vue.js Certification
Get certified!
API Documentation / HistoryState
Allowed HTML history.state
▪ [x: number]: HistoryStateValue
number
HistoryStateValuehhuh(hh	h}ubh)}(h}(hNh	}(h.https://router.vuejs.org/api/interfaces/routerh
Interface: Router | Vue RouteruhX  API Documentation / Router
Interface: Router
Router instance.
Properties
currentRoute
• Readonly
currentRoute: Ref
<RouteLocationNormalizedLoadedGeneric
>
Current RouteLocationNormalized
listening
• listening: boolean
Allows turning off the listening of history events. This is a low level api for micro-frontend.
options
• Readonly
options: RouterOptions
Original options object passed to create the Router
Methods
addRoute
▸ addRoute(parentName
, route
): () => void
Add a new route record as the child of an existing route.
Parameters
Name | Type | Description |
---|---|---|
parentName | NonNullable <RouteRecordNameGeneric > | Parent Route Record where route should be appended at |
route | RouteRecordRaw | Route Record to add |
Returns
fn
▸ (): void
Returns
void
▸ addRoute(route
): () => void
Add a new route record to the router.
Parameters
Name | Type | Description |
---|---|---|
route | RouteRecordRaw | Route Record to add |
Returns
fn
▸ (): void
Returns
void
afterEach
▸ afterEach(guard
): () => void
Add a navigation hook that is executed after every navigation. Returns a function that removes the registered hook.
Parameters
Name | Type | Description |
---|---|---|
guard | NavigationHookAfter | navigation hook to add |
Returns
fn
a function that removes the registered hook
▸ (): void
Returns
void
Example
router.afterEach((to, from, failure) => {
if (isNavigationFailure(failure)) {
console.log('failed navigation', failure)
}
})
back
▸ back(): void
Go back in history if possible by calling history.back()
. Equivalent to router.go(-1)
.
Returns
void
beforeEach
▸ beforeEach(guard
): () => void
Add a navigation guard that executes before any navigation. Returns a function that removes the registered guard.
Parameters
Name | Type | Description |
---|---|---|
guard | NavigationGuardWithThis <undefined > | navigation guard to add |
Returns
fn
▸ (): void
Returns
void
beforeResolve
▸ beforeResolve(guard
): () => void
Add a navigation guard that executes before navigation is about to be resolved. At this state all component have been fetched and other navigation guards have been successful. Returns a function that removes the registered guard.
Parameters
Name | Type | Description |
---|---|---|
guard | NavigationGuardWithThis <undefined > | navigation guard to add |
Returns
fn
a function that removes the registered guard
▸ (): void
Returns
void
Example
router.beforeResolve(to => {
if (to.meta.requiresAuth && !isAuthenticated) return false
})
clearRoutes
▸ clearRoutes(): void
Delete all routes from the router matcher.
Returns
void
forward
▸ forward(): void
Go forward in history if possible by calling history.forward()
. Equivalent to router.go(1)
.
Returns
void
getRoutes
▸ getRoutes(): RouteRecordNormalized
[]
Get a full list of all the route records.
Returns
go
▸ go(delta
): void
Allows you to move forward or backward through the history. Calls history.go()
.
Parameters
Name | Type | Description |
---|---|---|
delta | number | The position in the history to which you want to move, relative to the current page |
Returns
void
hasRoute
▸ hasRoute(name
): boolean
Checks if a route with a given name exists
Parameters
Name | Type | Description |
---|---|---|
name | NonNullable <RouteRecordNameGeneric > | Name of the route to check |
Returns
boolean
install
▸ install(app
): void
Called automatically by app.use(router)
. Should not be called manually by the user. This will trigger the initial navigation when on client side.
Parameters
Name | Type | Description |
---|---|---|
app | App <any > | Application that uses the router |
Returns
void
isReady
▸ isReady(): Promise
<void
>
Returns a Promise that resolves when the router has completed the initial navigation, which means it has resolved all async enter hooks and async components that are associated with the initial route. If the initial navigation already happened, the promise resolves immediately.
This is useful in server-side rendering to ensure consistent output on both the server and the client. Note that on server side, you need to manually push the initial location while on client side, the router automatically picks it up from the URL.
Returns
Promise
<void
>
onError
▸ onError(handler
): () => void
Adds an error handler that is called every time a non caught error happens during navigation. This includes errors thrown synchronously and asynchronously, errors returned or passed to next
in any navigation guard, and errors occurred when trying to resolve an async component that is required to render a route.
Parameters
Name | Type | Description |
---|---|---|
handler | _ErrorListener | error handler to register |
Returns
fn
▸ (): void
Returns
void
push
▸ push(to
): Promise
<undefined
| void
| NavigationFailure
>
Programmatically navigate to a new URL by pushing an entry in the history stack.
Parameters
Name | Type | Description |
---|---|---|
to | string | RouteLocationAsRelativeGeneric | RouteLocationAsPathGeneric | Route location to navigate to |
Returns
Promise
<undefined
| void
| NavigationFailure
>
removeRoute
▸ removeRoute(name
): void
Remove an existing route by its name.
Parameters
Name | Type | Description |
---|---|---|
name | NonNullable <RouteRecordNameGeneric > | Name of the route to remove |
Returns
void
replace
▸ replace(to
): Promise
<undefined
| void
| NavigationFailure
>
Programmatically navigate to a new URL by replacing the current entry in the history stack.
Parameters
Name | Type | Description |
---|---|---|
to | string | RouteLocationAsRelativeGeneric | RouteLocationAsPathGeneric | Route location to navigate to |
Returns
Promise
<undefined
| void
| NavigationFailure
>
resolve
▸ resolve<Name
>(to
, currentLocation?
): RouteLocationResolvedGeneric
Returns the normalized version of a route location. Also includes an href
property that includes any existing base
. By default, the currentLocation
used is router.currentRoute
and should only be overridden in advanced use cases.
Type parameters
Name | Type |
---|---|
Name | extends string | symbol = string | symbol |
Parameters
Name | Type | Description |
---|---|---|
to | RouteLocationAsRelativeTyped <RouteMapGeneric , Name > | Raw route location to resolve |
currentLocation? | RouteLocationNormalizedLoadedGeneric | Optional current location to resolve against |
Returns
▸ resolve(to
, currentLocation?
): RouteLocationResolvedGeneric
Parameters
Name | Type |
---|---|
to | string | RouteLocationAsRelativeGeneric | RouteLocationAsPathGeneric |
currentLocation? | RouteLocationNormalizedLoadedGeneric |hhuh(hh	h}ubh)}(h}(hNh	}(h5https://router.vuejs.org/api/interfaces/routerhistoryh
%Interface: RouterHistory | Vue RouteruhX	  API Documentation / RouterHistory
Interface: RouterHistory
Interface implemented by History implementations that can be passed to the router as Router.history
Properties
base
• Readonly
base: string
Base path that is prepended to every url. This allows hosting an SPA at a sub-folder of a domain like example.com/sub-folder
by having a base
of /sub-folder
location
• Readonly
location: string
Current History location
state
• Readonly
state: HistoryState
Current History state
Methods
createHref
▸ createHref(location
): string
Generates the corresponding href to be used in an anchor tag.
Parameters
Name | Type | Description |
---|---|---|
location | string | history location that should create an href |
Returns
string
destroy
▸ destroy(): void
Clears any event listener attached by the history implementation.
Returns
void
go
▸ go(delta
, triggerListeners?
): void
Traverses history in a given direction.
Parameters
Name | Type | Description |
---|---|---|
delta | number | distance to travel. If delta is < 0, it will go back, if it's > 0, it will go forward by that amount of entries. |
triggerListeners? | boolean | whether this should trigger listeners attached to the history |
Returns
void
Example
myHistory.go(-1) // equivalent to window.history.back()
myHistory.go(1) // equivalent to window.history.forward()
listen
▸ listen(callback
): () => void
Attach a listener to the History implementation that is triggered when the navigation is triggered from outside (like the Browser back and forward buttons) or when passing true
to RouterHistory.back and RouterHistory.forward
Parameters
Name | Type | Description |
---|---|---|
callback | NavigationCallback | listener to attach |
Returns
fn
a callback to remove the listener
▸ (): void
Returns
void
push
▸ push(to
, data?
): void
Navigates to a location. In the case of an HTML5 History implementation, this will call history.pushState
to effectively change the URL.
Parameters
Name | Type | Description |
---|---|---|
to | string | location to push |
data? | HistoryState | optional HistoryState to be associated with the navigation entry |
Returns
void
replace
▸ replace(to
, data?
): void
Same as RouterHistory.push but performs a history.replaceState
instead of history.pushState
Parameters
Name | Type | Description |
---|---|---|
to | string | location to set |
data? | HistoryState | optional HistoryState to be associated with the navigation entry |
Returns
voidhhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/api/interfaces/routerecordbaseh
(Interface: _RouteRecordBase | Vue RouteruhX  API Documentation / _RouteRecordBase
Interface: _RouteRecordBase
Internal type for common properties among all kind of RouteRecordRaw.
Hierarchy
_RouteRecordBaseMeta
↳
_RouteRecordBase
↳↳
RouteRecordSingleViewWithChildren
↳↳
RouteRecordMultipleViewsWithChildren
Properties
alias
• Optional
alias: string
| string
[]
Aliases for the record. Allows defining extra paths that will behave like a copy of the record. Allows having paths shorthands like /users/:id
and /u/:id
. All alias
and path
values must share the same params.
beforeEnter
• Optional
beforeEnter: NavigationGuardWithThis
<undefined
> | NavigationGuardWithThis
<undefined
>[]
Before Enter guard specific to this record. Note beforeEnter
has no effect if the record has a redirect
property.
children
• Optional
children: RouteRecordRaw
[]
Array of nested routes.
end
• Optional
end: boolean
Should the RegExp match until the end by appending a $
to it.
Default Value
true
Inherited from
PathParserOptions.end
meta
• Optional
meta: RouteMeta
Arbitrary data attached to the record.
Inherited from
_RouteRecordBaseMeta.meta
name
• Optional
name: RouteRecordNameGeneric
Name for the route record. Must be unique.
path
• path: string
Path of the record. Should start with /
unless the record is the child of another record.
Example
`/users/:id` matches `/users/1` as well as `/users/posva`.
props
• Optional
props: _RouteRecordProps
| Record
<string
, _RouteRecordProps
>
Allow passing down params as props to the component rendered by router-view
.
redirect
• Optional
redirect: RouteRecordRedirectOption
Where to redirect if the route is directly matched. The redirection happens before any navigation guard and triggers a new navigation with the new target location.
sensitive
• Optional
sensitive: boolean
Makes the RegExp case-sensitive.
Default Value
false
Inherited from
PathParserOptions.sensitive
strict
• Optional
strict: boolean
Whether to disallow a trailing slash or not.
Default Value
false
Inherited from
PathParserOptions.stricthhuh(hh	h}ubh)}(h}(hNh	}(h:https://router.vuejs.org/api/interfaces/routelocationtypedh
:Interface: RouteLocationTyped<RouteMap, Name> | Vue RouteruhX  API Documentation / RouteLocationTyped
Interface: RouteLocationTyped<RouteMap, Name>
Helper to generate a type safe version of the RouteLocation type.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric |
Name | extends keyof RouteMap |
Hierarchy
↳
RouteLocationTyped
Properties
fullPath
• fullPath: string
The whole location including the search
and hash
. This string is percentage encoded.
Inherited from
hash
• hash: string
Hash of the current location. If present, starts with a #
.
Inherited from
matched
• matched: RouteRecordNormalized
[]
Array of RouteRecord containing components as they were passed when adding records. It can also contain redirect records. This can't be used directly. This property is non-enumerable.
Inherited from
meta
• meta: RouteMeta
Merged meta
properties from all the matched route records.
Inherited from
name
• name: Extract
<Name
, string
| symbol
>
Name of the matched record
Overrides
params
• params: RouteMap
[Name
]["params"
]
Object of decoded params extracted from the path
.
Overrides
path
• path: string
Percentage encoded pathname section of the URL.
Inherited from
query
• query: LocationQuery
Object representation of the search
property of the current location.
Inherited from
redirectedFrom
• redirectedFrom: undefined
| RouteLocationGeneric
Contains the location we were initially trying to access before ending up on the current location.hhuh(hh	h}ubh)}(h}(hNh	}(h<https://router.vuejs.org/api/interfaces/routelocationpathrawh
,Interface: RouteLocationPathRaw | Vue RouteruhXk  API Documentation / RouteLocationPathRaw
Interface: RouteLocationPathRaw
Route Location that can infer the possible paths.
Hierarchy
↳
RouteLocationPathRaw
Properties
force
• Optional
force: boolean
Triggers the navigation even if the location is the same as the current one. Note this will also add a new entry to the history unless replace: true
is passed.
Inherited from
hash
• Optional
hash: string
Inherited from
path
• path: string
Inherited from
query
• Optional
query: LocationQueryRaw
Inherited from
replace
• Optional
replace: boolean
Replace the entry in the history instead of pushing a new entry
Inherited from
state
• Optional
state: HistoryState
State to save using the History API. This cannot contain any reactive values and some primitives like Symbols are forbidden. More info at https://developer.mozilla.org/en-US/docs/Web/API/History/statehhuh(hh	h}ubh)}(h}(hNh	}(h<https://router.vuejs.org/api/interfaces/routelocationmatchedh
,Interface: RouteLocationMatched | Vue RouteruhX7
  API Documentation / RouteLocationMatched
Interface: RouteLocationMatched
Normalized version of a route record.
Hierarchy
↳
RouteLocationMatched
Properties
aliasOf
• aliasOf: undefined
| RouteRecordNormalized
Defines if this record is the alias of another one. This property is undefined
if the record is the original one.
Inherited from
beforeEnter
• beforeEnter: undefined
| NavigationGuardWithThis
<undefined
> | NavigationGuardWithThis
<undefined
>[]
Registered beforeEnter guards
Inherited from
RouteRecordNormalized.beforeEnter
children
• children: RouteRecordRaw
[]
Nested route records.
Inherited from
RouteRecordNormalized.children
components
• components: undefined
| null
| Record
<string
, RouteComponent
>
Components to display when the URL matches this route. Allow using named views.
Overrides
RouteRecordNormalized.components
enterCallbacks
• enterCallbacks: Record
<string
, NavigationGuardNextCallback
[]>
Registered beforeRouteEnter callbacks passed to next
or returned in guards
Inherited from
RouteRecordNormalized.enterCallbacks
instances
• instances: Record
<string
, undefined
| null
| ComponentPublicInstance
>
Mounted route component instances Having the instances on the record mean beforeRouteUpdate and beforeRouteLeave guards can only be invoked with the latest mounted app instance if there are multiple application instances rendering the same view, basically duplicating the content on the page, which shouldn't happen in practice. It will work if multiple apps are rendering different named views.
Inherited from
RouteRecordNormalized.instances
leaveGuards
• leaveGuards: Set
<NavigationGuard
>
Registered leave guards
Inherited from
RouteRecordNormalized.leaveGuards
meta
• meta: RouteMeta
Arbitrary data attached to the record.
Inherited from
name
• name: RouteRecordNameGeneric
Name for the route record. Must be unique.
Inherited from
path
• path: string
Path of the record. Should start with /
unless the record is the child of another record.
Inherited from
props
• props: Record
<string
, _RouteRecordProps
>
Allow passing down params as props to the component rendered by router-view
. Should be an object with the same keys as components
or a boolean to be applied to every component.
Inherited from
redirect
• redirect: undefined
| RouteRecordRedirectOption
Where to redirect if the route is directly matched. The redirection happens before any navigation guard and triggers a new navigation with the new target location.
Inherited from
RouteRecordNormalized.redirect
updateGuards
• updateGuards: Set
<NavigationGuard
>
Registered update guardshhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/api/interfaces/routerecordinfoh
LInterface: RouteRecordInfo<Name, Path, ParamsRaw, Params, Meta> | Vue RouteruhX-  API Documentation / RouteRecordInfo
Interface: RouteRecordInfo<Name, Path, ParamsRaw, Params, Meta>
Helper type to define a Typed RouteRecord
See
Type parameters
Name | Type |
---|---|
Name | extends string | symbol = string |
Path | extends string = string |
ParamsRaw | extends RouteParamsRawGeneric = RouteParamsRawGeneric |
Params | extends RouteParamsGeneric = RouteParamsGeneric |
Meta | extends RouteMeta = RouteMeta |
Properties
meta
• meta: Meta
name
• name: Name
params
• params: Params
paramsRaw
• paramsRaw: ParamsRaw
path
• path: Pathhhuh(hh	h}ubh)}(h}(hNh	}(hJhttps://router.vuejs.org/api/interfaces/routelocationnormalizedloadedtypedh
JInterface: RouteLocationNormalizedLoadedTyped<RouteMap, Name> | Vue RouteruhX  API Documentation / RouteLocationNormalizedLoadedTyped
Interface: RouteLocationNormalizedLoadedTyped<RouteMap, Name>
Helper to generate a type safe version of the RouteLocationNormalizedLoaded type.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
Name | extends keyof RouteMap = keyof RouteMap |
Hierarchy
RouteLocationNormalizedLoadedGeneric
↳
RouteLocationNormalizedLoadedTyped
Properties
fullPath
• fullPath: string
The whole location including the search
and hash
. This string is percentage encoded.
Inherited from
RouteLocationNormalizedLoadedGeneric.fullPath
hash
• hash: string
Hash of the current location. If present, starts with a #
.
Inherited from
RouteLocationNormalizedLoadedGeneric.hash
matched
• matched: RouteLocationMatched
[]
Array of RouteLocationMatched containing only plain components (any lazy-loaded components have been loaded and were replaced inside the components
object) so it can be directly used to display routes. It cannot contain redirect records either. This property is non-enumerable.
Inherited from
RouteLocationNormalizedLoadedGeneric.matched
meta
• meta: RouteMeta
Merged meta
properties from all the matched route records.
Inherited from
RouteLocationNormalizedLoadedGeneric.meta
name
• name: Extract
<Name
, string
| symbol
>
Name of the matched record
Overrides
RouteLocationNormalizedLoadedGeneric.name
params
• params: RouteMap
[Name
]["params"
]
Object of decoded params extracted from the path
.
Overrides
RouteLocationNormalizedLoadedGeneric.params
path
• path: string
Percentage encoded pathname section of the URL.
Inherited from
RouteLocationNormalizedLoadedGeneric.path
query
• query: LocationQuery
Object representation of the search
property of the current location.
Inherited from
RouteLocationNormalizedLoadedGeneric.query
redirectedFrom
• redirectedFrom: undefined
| RouteLocationGeneric
Contains the location we were initially trying to access before ending up on the current location.hhuh(hh	h}ubh)}(h}(hNh	}(hDhttps://router.vuejs.org/api/interfaces/routelocationnormalizedtypedh
DInterface: RouteLocationNormalizedTyped<RouteMap, Name> | Vue RouteruhX  API Documentation / RouteLocationNormalizedTyped
Interface: RouteLocationNormalizedTyped<RouteMap, Name>
Helper to generate a type safe version of the RouteLocationNormalized type.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric = RouteMapGeneric |
Name | extends keyof RouteMap = keyof RouteMap |
Hierarchy
RouteLocationNormalizedGeneric
↳
RouteLocationNormalizedTyped
Properties
fullPath
• fullPath: string
The whole location including the search
and hash
. This string is percentage encoded.
Inherited from
RouteLocationNormalizedGeneric.fullPath
hash
• hash: string
Hash of the current location. If present, starts with a #
.
Inherited from
RouteLocationNormalizedGeneric.hash
matched
• matched: RouteRecordNormalized
[]
Array of RouteRecordNormalized
Overrides
RouteLocationNormalizedGeneric.matched
meta
• meta: RouteMeta
Merged meta
properties from all the matched route records.
Inherited from
RouteLocationNormalizedGeneric.meta
name
• name: Extract
<Name
, string
| symbol
>
Name of the matched record
Overrides
RouteLocationNormalizedGeneric.name
params
• params: RouteMap
[Name
]["params"
]
Object of decoded params extracted from the path
.
Overrides
RouteLocationNormalizedGeneric.params
path
• path: string
Percentage encoded pathname section of the URL.
Inherited from
RouteLocationNormalizedGeneric.path
query
• query: LocationQuery
Object representation of the search
property of the current location.
Inherited from
RouteLocationNormalizedGeneric.query
redirectedFrom
• redirectedFrom: undefined
| RouteLocationGeneric
Contains the location we were initially trying to access before ending up on the current location.hhuh(hh	h}ubh)}(h}(hNh	}(hBhttps://router.vuejs.org/api/interfaces/routelocationresolvedtypedh
BInterface: RouteLocationResolvedTyped<RouteMap, Name> | Vue RouteruhXN  API Documentation / RouteLocationResolvedTyped
Interface: RouteLocationResolvedTyped<RouteMap, Name>
Helper to generate a type safe version of the RouteLocationResolved type.
Type parameters
Name | Type |
---|---|
RouteMap | extends RouteMapGeneric |
Name | extends keyof RouteMap |
Hierarchy
RouteLocationTyped
<RouteMap
,Name
>↳
RouteLocationResolvedTyped
Properties
fullPath
• fullPath: string
The whole location including the search
and hash
. This string is percentage encoded.
Inherited from
hash
• hash: string
Hash of the current location. If present, starts with a #
.
Inherited from
href
• href: string
Resolved href
for the route location that will be set on the <a href="...">
.
matched
• matched: RouteRecordNormalized
[]
Array of RouteRecord containing components as they were passed when adding records. It can also contain redirect records. This can't be used directly. This property is non-enumerable.
Inherited from
meta
• meta: RouteMeta
Merged meta
properties from all the matched route records.
Inherited from
name
• name: Extract
<Name
, string
| symbol
>
Name of the matched record
Inherited from
params
• params: RouteMap
[Name
]["params"
]
Object of decoded params extracted from the path
.
Inherited from
path
• path: string
Percentage encoded pathname section of the URL.
Inherited from
query
• query: LocationQuery
Object representation of the search
property of the current location.
Inherited from
redirectedFrom
• redirectedFrom: undefined
| RouteLocationGeneric
Contains the location we were initially trying to access before ending up on the current location.hhuh(hh	h}ubh)}(h}(hNh	}(h9https://router.vuejs.org/api/interfaces/pathparseroptionsh
*Interface: _PathParserOptions | Vue RouteruhX  API Documentation / _PathParserOptions
Interface: _PathParserOptions
Properties
end
• Optional
end: boolean
Should the RegExp match until the end by appending a $
to it.
Default Value
true
sensitive
• Optional
sensitive: boolean
Makes the RegExp case-sensitive.
Default Value
false
start
• Optional
start: boolean
Should the RegExp match from the beginning by prepending a ^
to it.
Default Value
true
strict
• Optional
strict: boolean
Whether to disallow a trailing slash or not.
Default Value
falsehhuh(hh	h}ubh)}(h}(hNh	}(h-https://router.vuejs.org/api/enums/errortypesh
$Enumeration: ErrorTypes | Vue RouteruhX  API Documentation / ErrorTypes
Enumeration: ErrorTypes
Flags so we can combine them when checking for multiple errors. This is the internal version of NavigationFailureType.
Enumeration Members
MATCHER_NOT_FOUND
• MATCHER_NOT_FOUND = 1
NAVIGATION_ABORTED
• NAVIGATION_ABORTED = 4
NAVIGATION_CANCELLED
• NAVIGATION_CANCELLED = 8
NAVIGATION_DUPLICATED
• NAVIGATION_DUPLICATED = 16
NAVIGATION_GUARD_REDIRECT
• NAVIGATION_GUARD_REDIRECT = 2hhuh(hh	h}ubh)}(h}(hNh	}(h=https://router.vuejs.org/api/interfaces/routerecordsingleviewh
-Interface: RouteRecordSingleView | Vue RouteruhX  API Documentation / RouteRecordSingleView
Interface: RouteRecordSingleView
Route Record defining one single component with the component
option.
Hierarchy
↳
RouteRecordSingleView
Properties
alias
• Optional
alias: string
| string
[]
Aliases for the record. Allows defining extra paths that will behave like a copy of the record. Allows having paths shorthands like /users/:id
and /u/:id
. All alias
and path
values must share the same params.
Inherited from
beforeEnter
• Optional
beforeEnter: NavigationGuardWithThis
<undefined
> | NavigationGuardWithThis
<undefined
>[]
Before Enter guard specific to this record. Note beforeEnter
has no effect if the record has a redirect
property.
Inherited from
children
• Optional
children: undefined
Array of nested routes.
Overrides
component
• component: RawRouteComponent
Component to display when the URL matches this route.
components
• Optional
components: undefined
end
• Optional
end: boolean
Should the RegExp match until the end by appending a $
to it.
Default Value
true
Inherited from
meta
• Optional
meta: RouteMeta
Arbitrary data attached to the record.
Inherited from
name
• Optional
name: RouteRecordNameGeneric
Name for the route record. Must be unique.
Inherited from
path
• path: string
Path of the record. Should start with /
unless the record is the child of another record.
Example
`/users/:id` matches `/users/1` as well as `/users/posva`.
Inherited from
props
• Optional
props: _RouteRecordProps
Allow passing down params as props to the component rendered by router-view
.
Overrides
redirect
• Optional
redirect: undefined
Where to redirect if the route is directly matched. The redirection happens before any navigation guard and triggers a new navigation with the new target location.
Overrides
sensitive
• Optional
sensitive: boolean
Makes the RegExp case-sensitive.
Default Value
false
Inherited from
strict
• Optional
strict: boolean
Whether to disallow a trailing slash or not.
Default Value
falsehhuh(hh	h}ubh)}(h}(hNh	}(h=https://router.vuejs.org/api/interfaces/locationasrelativerawh
-Interface: LocationAsRelativeRaw | Vue RouteruhXX  API Documentation / LocationAsRelativeRaw
Interface: LocationAsRelativeRaw
Hierarchy
LocationAsRelativeRaw
Properties
name
• Optional
name: RouteRecordNameGeneric
params
• Optional
params: RouteParamsRawGeneric
path
• Optional
path: undefined
Ignored path property since we are dealing with a relative location. Only undefined
is allowed.hhuh(hh	h}ubh)}(h}(hNh	}(hFhttps://router.vuejs.org/api/interfaces/routelocationnormalizedgenerich
6Interface: RouteLocationNormalizedGeneric | Vue RouteruhX  API Documentation / RouteLocationNormalizedGeneric
Interface: RouteLocationNormalizedGeneric
Generic version of RouteLocationNormalized that is used when no RouteMap is provided.
Hierarchy
↳
RouteLocationNormalizedGeneric
↳↳
RouteLocationNormalizedTyped
Properties
fullPath
• fullPath: string
The whole location including the search
and hash
. This string is percentage encoded.
Inherited from
hash
• hash: string
Hash of the current location. If present, starts with a #
.
Inherited from
matched
• matched: RouteRecordNormalized
[]
Array of RouteRecordNormalized
meta
• meta: RouteMeta
Merged meta
properties from all the matched route records.
Inherited from
name
• name: RouteRecordNameGeneric
Name of the matched record
Overrides
params
• params: RouteParamsGeneric
Object of decoded params extracted from the path
.
Overrides
path
• path: string
Percentage encoded pathname section of the URL.
Inherited from
query
• query: LocationQuery
Object representation of the search
property of the current location.
Inherited from
redirectedFrom
• redirectedFrom: undefined
| RouteLocationGeneric
Contains the location we were initially trying to access before ending up on the current location.hhuh(hh	h}ubh)}(h}(hNh	}(h7https://router.vuejs.org/api/interfaces/navigationguardh
'Interface: NavigationGuard | Vue RouteruhXH  API Documentation / NavigationGuard
Interface: NavigationGuard
Navigation Guard.
Callable
NavigationGuard
▸ NavigationGuard(to
, from
, next
): _Awaitable
<NavigationGuardReturn
>
Parameters
Name | Type |
---|---|
to | RouteLocationNormalizedGeneric |
from | RouteLocationNormalizedLoadedGeneric |
next | NavigationGuardNext |hhuh(hh	h}ubh)}(h}(hNh	}(h<https://router.vuejs.org/api/interfaces/routelocationgenerich
,Interface: RouteLocationGeneric | Vue RouteruhX  API Documentation / RouteLocationGeneric
Interface: RouteLocationGeneric
Generic version of RouteLocation. It is used when no RouteMap is provided.
Hierarchy
↳
RouteLocationGeneric
Properties
fullPath
• fullPath: string
The whole location including the search
and hash
. This string is percentage encoded.
Inherited from
hash
• hash: string
Hash of the current location. If present, starts with a #
.
Inherited from
matched
• matched: RouteRecordNormalized
[]
Array of RouteRecord containing components as they were passed when adding records. It can also contain redirect records. This can't be used directly. This property is non-enumerable.
meta
• meta: RouteMeta
Merged meta
properties from all the matched route records.
Inherited from
name
• name: null
| RouteRecordNameGeneric
Name of the matched record
Inherited from
params
• params: RouteParamsGeneric
Object of decoded params extracted from the path
.
Inherited from
path
• path: string
Percentage encoded pathname section of the URL.
Inherited from
query
• query: LocationQuery
Object representation of the search
property of the current location.
Inherited from
redirectedFrom
• redirectedFrom: undefined
| RouteLocationGeneric
Contains the location we were initially trying to access before ending up on the current location.hhuh(hh	h}ubh)}(h}(hNh	}(h5https://router.vuejs.org/api/interfaces/uselinkreturnh
+Interface: UseLinkReturn<Name> | Vue RouteruhX+  API Documentation / UseLinkReturn
Interface: UseLinkReturn<Name>
Return type of useLink.
Type parameters
Name | Type |
---|---|
Name | extends keyof RouteMap = keyof RouteMap |
Properties
href
• href: ComputedRef
<string
>
isActive
• isActive: ComputedRef
<boolean
>
isExactActive
• isExactActive: ComputedRef
<boolean
>
route
• route: ComputedRef
<RouteLocationResolvedGeneric
>
Methods
navigate
▸ navigate(e?
): Promise
<void
| NavigationFailure
>
Parameters
Name | Type |
---|---|
e? | MouseEvent |
Returns
Promise
<void
| NavigationFailure
>hhuh(hh	h}ubh)}(h}(hNh	}(hBhttps://router.vuejs.org/api/interfaces/routelocationaspathgenerich
2Interface: RouteLocationAsPathGeneric | Vue RouteruhX  API Documentation / RouteLocationAsPathGeneric
Interface: RouteLocationAsPathGeneric
Generic version of RouteLocationAsPath. It is used when no RouteMap is provided.
Hierarchy
↳
RouteLocationAsPathGeneric
Properties
force
• Optional
force: boolean
Triggers the navigation even if the location is the same as the current one. Note this will also add a new entry to the history unless replace: true
is passed.
Inherited from
hash
• Optional
hash: string
Inherited from
path
• path: string
Percentage encoded pathname section of the URL.
query
• Optional
query: LocationQueryRaw
Inherited from
replace
• Optional
replace: boolean
Replace the entry in the history instead of pushing a new entry
Inherited from
state
• Optional
state: HistoryState
State to save using the History API. This cannot contain any reactive values and some primitives like Symbols are forbidden. More info at https://developer.mozilla.org/en-US/docs/Web/API/History/statehhuh(hh	h}ubh)}(h}(hNh	}(h9https://router.vuejs.org/api/interfaces/navigationfailureh
)Interface: NavigationFailure | Vue RouteruhX  API Documentation / NavigationFailure
Interface: NavigationFailure
Extended Error that contains extra information regarding a failed navigation.
Hierarchy
Error
↳
NavigationFailure
Properties
cause
• Optional
cause: unknown
Inherited from
Error.cause
from
• from: RouteLocationNormalizedGeneric
Route location we were navigating from
message
• message: string
Inherited from
Error.message
name
• name: string
Inherited from
Error.name
stack
• Optional
stack: string
Inherited from
Error.stack
to
• to: RouteLocationNormalizedGeneric
Route location we were navigating to
type
• type: NAVIGATION_ABORTED
| NAVIGATION_CANCELLED
| NAVIGATION_DUPLICATED
Type of the navigation. One of NavigationFailureTypehhuh(hh	h}ubh)}(h}(hNh	}(hDhttps://router.vuejs.org/api/interfaces/routelocationresolvedgenerich
4Interface: RouteLocationResolvedGeneric | Vue RouteruhX  API Documentation / RouteLocationResolvedGeneric
Interface: RouteLocationResolvedGeneric
Generic version of RouteLocationResolved. It is used when no RouteMap is provided.
Hierarchy
↳
RouteLocationResolvedGeneric
Properties
fullPath
• fullPath: string
The whole location including the search
and hash
. This string is percentage encoded.
Inherited from
hash
• hash: string
Hash of the current location. If present, starts with a #
.
Inherited from
href
• href: string
Resolved href
for the route location that will be set on the <a href="...">
.
matched
• matched: RouteRecordNormalized
[]
Array of RouteRecord containing components as they were passed when adding records. It can also contain redirect records. This can't be used directly. This property is non-enumerable.
Inherited from
meta
• meta: RouteMeta
Merged meta
properties from all the matched route records.
Inherited from
name
• name: null
| RouteRecordNameGeneric
Name of the matched record
Inherited from
params
• params: RouteParamsGeneric
Object of decoded params extracted from the path
.
Inherited from
path
• path: string
Percentage encoded pathname section of the URL.
Inherited from
query
• query: LocationQuery
Object representation of the search
property of the current location.
Inherited from
redirectedFrom
• redirectedFrom: undefined
| RouteLocationGeneric
Contains the location we were initially trying to access before ending up on the current location.hhuh(hh	h}ubh)}(h}(hNh	}(h3https://router.vuejs.org/api/interfaces/typesconfigh
#Interface: TypesConfig | Vue RouteruhX  API Documentation / TypesConfig
Interface: TypesConfig
Allows customizing existing types of the router that are used globally like $router
, <RouterLink>
, etc. ONLY FOR INTERNAL USAGE.
$router
- the router instance$route
- the current route locationbeforeRouteEnter
- Page component optionbeforeRouteUpdate
- Page component optionbeforeRouteLeave
- Page component optionRouterLink
- RouterLink ComponentRouterView
- RouterView Componenthhuh(hh	h}ubh)}(h}(hNh	}(h?https://router.vuejs.org/api/interfaces/navigationguardwiththish
2Interface: NavigationGuardWithThis<T> | Vue RouteruhX  API Documentation / NavigationGuardWithThis
Interface: NavigationGuardWithThis<T>
Navigation Guard with a type parameter for this
.
See
Type parameters
Name |
---|
T |
Callable
NavigationGuardWithThis
▸ NavigationGuardWithThis(this
, to
, from
, next
): _Awaitable
<NavigationGuardReturn
>
Parameters
Name | Type |
---|---|
this | T |
to | RouteLocationNormalizedGeneric |
from | RouteLocationNormalizedLoadedGeneric |
next | NavigationGuardNext |hhuh(hh	h}ubh)}(h}(hNh	}(h3https://router.vuejs.org/api/interfaces/routerlinkih
$Interface: _RouterLinkI | Vue RouteruhX  API Documentation / _RouterLinkI
Interface: _RouterLinkI
Typed version of the RouterLink
component. Its generic defaults to the typed router, so it can be inferred automatically for JSX.
Constructors
constructor
• new _RouterLinkI(): Object
Returns
Object
Name | Type |
---|---|
$props | AllowedComponentProps & ComponentCustomProps & VNodeProps & RouterLinkProps |
$slots | { default? : (__namedParameters : { href : string ; isActive : boolean ; isExactActive : boolean ; route : RouteLocationResolvedGeneric ; navigate : (e? : MouseEvent ) => Promise <void | NavigationFailure > }) => VNode <RendererNode , RendererElement , { [key: string] : any ; }>[] } |
$slots.default? | (__namedParameters : { href : string ; isActive : boolean ; isExactActive : boolean ; route : RouteLocationResolvedGeneric ; navigate : (e? : MouseEvent ) => Promise <void | NavigationFailure > }) => VNode <RendererNode , RendererElement , { [key: string] : any ; }>[] |
Properties
useLink
• useLink: <Name>(props
: UseLinkOptions
<Name
>) => UseLinkReturn
<Name
>
Access to useLink()
without depending on using vue-router
Type declaration
▸ <Name
>(props
): UseLinkReturn
<Name
>
Access to useLink()
without depending on using vue-router
Type parameters
Name | Type |
---|---|
Name | extends string | symbol = string | symbol |
Parameters
Name | Type |
---|---|
props | UseLinkOptions <Name > |
Returns
UseLinkReturn
<Name
>hhuh(hh	h}ubh)}(h}(hNh	}(hIhttps://router.vuejs.org/api/interfaces/routerecordsingleviewwithchildrenh
9Interface: RouteRecordSingleViewWithChildren | Vue RouteruhX  API Documentation / RouteRecordSingleViewWithChildren
Interface: RouteRecordSingleViewWithChildren
Route Record defining one single component with a nested view.
Hierarchy
↳
RouteRecordSingleViewWithChildren
Properties
alias
• Optional
alias: string
| string
[]
Aliases for the record. Allows defining extra paths that will behave like a copy of the record. Allows having paths shorthands like /users/:id
and /u/:id
. All alias
and path
values must share the same params.
Inherited from
beforeEnter
• Optional
beforeEnter: NavigationGuardWithThis
<undefined
> | NavigationGuardWithThis
<undefined
>[]
Before Enter guard specific to this record. Note beforeEnter
has no effect if the record has a redirect
property.
Inherited from
children
• children: RouteRecordRaw
[]
Array of nested routes.
Overrides
component
• Optional
component: null
| RawRouteComponent
Component to display when the URL matches this route.
components
• Optional
components: undefined
end
• Optional
end: boolean
Should the RegExp match until the end by appending a $
to it.
Default Value
true
Inherited from
meta
• Optional
meta: RouteMeta
Arbitrary data attached to the record.
Inherited from
name
• Optional
name: RouteRecordNameGeneric
Name for the route record. Must be unique.
Inherited from
path
• path: string
Path of the record. Should start with /
unless the record is the child of another record.
Example
`/users/:id` matches `/users/1` as well as `/users/posva`.
Inherited from
props
• Optional
props: _RouteRecordProps
Allow passing down params as props to the component rendered by router-view
.
Overrides
redirect
• Optional
redirect: RouteRecordRedirectOption
Where to redirect if the route is directly matched. The redirection happens before any navigation guard and triggers a new navigation with the new target location.
Inherited from
sensitive
• Optional
sensitive: boolean
Makes the RegExp case-sensitive.
Default Value
false
Inherited from
strict
• Optional
strict: boolean
Whether to disallow a trailing slash or not.
Default Value
falsehhuh(hh	h}ubh)}(h}(hNh	}(h;https://router.vuejs.org/api/interfaces/navigationguardnexth
+Interface: NavigationGuardNext | Vue RouteruhX  API Documentation / NavigationGuardNext
Interface: NavigationGuardNext
next()
callback passed to navigation guards.
Callable
NavigationGuardNext
▸ NavigationGuardNext(): void
Returns
void
NavigationGuardNext
▸ NavigationGuardNext(error
): void
Parameters
Name | Type |
---|---|
error | Error |
Returns
void
NavigationGuardNext
▸ NavigationGuardNext(location
): void
Parameters
Name | Type |
---|---|
location | string | RouteLocationAsRelativeGeneric | RouteLocationAsPathGeneric |
Returns
void
NavigationGuardNext
▸ NavigationGuardNext(valid
): void
Parameters
Name | Type |
---|---|
valid | undefined | boolean |
Returns
void
NavigationGuardNext
▸ NavigationGuardNext(cb
): void
Parameters
Name | Type |
---|---|
cb | NavigationGuardNextCallback |
Returns
voidhhuh(hh	h}ubh)}(h}(hNh	}(h1https://router.vuejs.org/api/interfaces/routemetah
!Interface: RouteMeta | Vue RouteruhX  API Documentation / RouteMeta
Interface: RouteMeta
Interface to type meta
fields in route records.
Example
ts
// typings.d.ts or router.ts
import 'vue-router';
declare module 'vue-router' {
interface RouteMeta {
requiresAuth?: boolean
}
}
Hierarchy
↳
RouteMetahhuh(hh	h}ubh)}(h}(hNh	}(h;https://router.vuejs.org/api/interfaces/navigationhookafterh
+Interface: NavigationHookAfter | Vue RouteruhX  API Documentation / NavigationHookAfter
Interface: NavigationHookAfter
Navigation hook triggered after a navigation is settled.
Callable
NavigationHookAfter
▸ NavigationHookAfter(to
, from
, failure?
): unknown
Parameters
Name | Type |
---|---|
to | RouteLocationNormalizedGeneric |
from | RouteLocationNormalizedLoadedGeneric |
failure? | void | NavigationFailure |
Returns
unknownhhuh(hh	h}ubh)}(h}(hNh	}(h=https://router.vuejs.org/api/interfaces/matcherlocationaspathh
-Interface: MatcherLocationAsPath | Vue RouteruhX  English
Appearance
Complete guide to
Mastering Pinia
written by its creator
The official
Vue.js Certification
Get certified!
API Documentation / MatcherLocationAsPath
MatcherLocationAsPath
↳ RouteLocationPathRaw
RouteLocationPathRaw
• path: string
stringhhuh(hh	h}ubh)}(h}(hNh	}(h=https://router.vuejs.org/api/interfaces/routerecordnormalizedh
-Interface: RouteRecordNormalized | Vue RouteruhX  API Documentation / RouteRecordNormalized
Interface: RouteRecordNormalized
Normalized version of a route record.
Hierarchy
RouteRecordNormalized
Properties
aliasOf
• aliasOf: undefined
| RouteRecordNormalized
Defines if this record is the alias of another one. This property is undefined
if the record is the original one.
beforeEnter
• beforeEnter: undefined
| NavigationGuardWithThis
<undefined
> | NavigationGuardWithThis
<undefined
>[]
Registered beforeEnter guards
children
• children: RouteRecordRaw
[]
Nested route records.
components
• components: undefined
| null
| Record
<string
, RawRouteComponent
>
Components to display when the URL matches this route. Allow using named views.
enterCallbacks
• enterCallbacks: Record
<string
, NavigationGuardNextCallback
[]>
Registered beforeRouteEnter callbacks passed to next
or returned in guards
instances
• instances: Record
<string
, undefined
| null
| ComponentPublicInstance
>
Mounted route component instances Having the instances on the record mean beforeRouteUpdate and beforeRouteLeave guards can only be invoked with the latest mounted app instance if there are multiple application instances rendering the same view, basically duplicating the content on the page, which shouldn't happen in practice. It will work if multiple apps are rendering different named views.
leaveGuards
• leaveGuards: Set
<NavigationGuard
>
Registered leave guards
meta
• meta: RouteMeta
Arbitrary data attached to the record.
name
• name: RouteRecordNameGeneric
Name for the route record. Must be unique.
path
• path: string
Path of the record. Should start with /
unless the record is the child of another record.
props
• props: Record
<string
, _RouteRecordProps
>
Allow passing down params as props to the component rendered by router-view
. Should be an object with the same keys as components
or a boolean to be applied to every component.
redirect
• redirect: undefined
| RouteRecordRedirectOption
Where to redirect if the route is directly matched. The redirection happens before any navigation guard and triggers a new navigation with the new target location.
updateGuards
• updateGuards: Set
<NavigationGuard
>
Registered update guardshhuh(hh	h}ubh)}(h}(hNh	}(hhttps://vuejs.org/guide/h
Introduction | Vue.jsuhX  Introduction
You are reading the documentation for Vue 3!
- Vue 2 support has ended on Dec 31, 2023. Learn more about Vue 2 EOL.
- Upgrading from Vue 2? Check out the Migration Guide.
What is Vue?
Vue (pronounced /vjuː/, like view) is a JavaScript framework for building user interfaces. It builds on top of standard HTML, CSS, and JavaScript and provides a declarative, component-based programming model that helps you efficiently develop user interfaces of any complexity.
Here is a minimal example:
js
import { createApp, ref } from 'vue'
createApp({
setup() {
return {
count: ref(0)
}
}
}).mount('#app')
template
<div id="app">
<button @click="count++">
Count is: {{ count }}
</button>
</div>
Result
The above example demonstrates the two core features of Vue:
Declarative Rendering: Vue extends standard HTML with a template syntax that allows us to declaratively describe HTML output based on JavaScript state.
Reactivity: Vue automatically tracks JavaScript state changes and efficiently updates the DOM when changes happen.
You may already have questions - don't worry. We will cover every little detail in the rest of the documentation. For now, please read along so you can have a high-level understanding of what Vue offers.
Prerequisites
The rest of the documentation assumes basic familiarity with HTML, CSS, and JavaScript. If you are totally new to frontend development, it might not be the best idea to jump right into a framework as your first step - grasp the basics and then come back! You can check your knowledge level with these overviews for JavaScript, HTML and CSS if needed. Prior experience with other frameworks helps, but is not required.
The Progressive Framework
Vue is a framework and ecosystem that covers most of the common features needed in frontend development. But the web is extremely diverse - the things we build on the web may vary drastically in form and scale. With that in mind, Vue is designed to be flexible and incrementally adoptable. Depending on your use case, Vue can be used in different ways:
- Enhancing static HTML without a build step
- Embedding as Web Components on any page
- Single-Page Application (SPA)
- Fullstack / Server-Side Rendering (SSR)
- Jamstack / Static Site Generation (SSG)
- Targeting desktop, mobile, WebGL, and even the terminal
If you find these concepts intimidating, don't worry! The tutorial and guide only require basic HTML and JavaScript knowledge, and you should be able to follow along without being an expert in any of these.
If you are an experienced developer interested in how to best integrate Vue into your stack, or you are curious about what these terms mean, we discuss them in more detail in Ways of Using Vue.
Despite the flexibility, the core knowledge about how Vue works is shared across all these use cases. Even if you are just a beginner now, the knowledge gained along the way will stay useful as you grow to tackle more ambitious goals in the future. If you are a veteran, you can pick the optimal way to leverage Vue based on the problems you are trying to solve, while retaining the same productivity. This is why we call Vue "The Progressive Framework": it's a framework that can grow with you and adapt to your needs.
Single-File Components
In most build-tool-enabled Vue projects, we author Vue components using an HTML-like file format called Single-File Component (also known as *.vue
files, abbreviated as SFC). A Vue SFC, as the name suggests, encapsulates the component's logic (JavaScript), template (HTML), and styles (CSS) in a single file. Here's the previous example, written in SFC format:
vue
<script setup>
import { ref } from 'vue'
const count = ref(0)
</script>
<template>
<button @click="count++">Count is: {{ count }}</button>
</template>
<style scoped>
button {
font-weight: bold;
}
</style>
SFC is a defining feature of Vue and is the recommended way to author Vue components if your use case warrants a build setup. You can learn more about the how and why of SFC in its dedicated section - but for now, just know that Vue will handle all the build tools setup for you.
API Styles
Vue components can be authored in two different API styles: Options API and Composition API.
Options API
With Options API, we define a component's logic using an object of options such as data
, methods
, and mounted
. Properties defined by options are exposed on this
inside functions, which points to the component instance:
vue
<script>
export default {
// Properties returned from data() become reactive state
// and will be exposed on `this`.
data() {
return {
count: 0
}
},
// Methods are functions that mutate state and trigger updates.
// They can be bound as event handlers in templates.
methods: {
increment() {
this.count++
}
},
// Lifecycle hooks are called at different stages
// of a component's lifecycle.
// This function will be called when the component is mounted.
mounted() {
console.log(`The initial count is ${this.count}.`)
}
}
</script>
<template>
<button @click="increment">Count is: {{ count }}</button>
</template>
Composition API
With Composition API, we define a component's logic using imported API functions. In SFCs, Composition API is typically used with <script setup>
. The setup
attribute is a hint that makes Vue perform compile-time transforms that allow us to use Composition API with less boilerplate. For example, imports and top-level variables / functions declared in <script setup>
are directly usable in the template.
Here is the same component, with the exact same template, but using Composition API and <script setup>
instead:
vue
<script setup>
import { ref, onMounted } from 'vue'
// reactive state
const count = ref(0)
// functions that mutate state and trigger updates
function increment() {
count.value++
}
// lifecycle hooks
onMounted(() => {
console.log(`The initial count is ${count.value}.`)
})
</script>
<template>
<button @click="increment">Count is: {{ count }}</button>
</template>
Which to Choose?
Both API styles are fully capable of covering common use cases. They are different interfaces powered by the exact same underlying system. In fact, the Options API is implemented on top of the Composition API! The fundamental concepts and knowledge about Vue are shared across the two styles.
The Options API is centered around the concept of a "component instance" (this
as seen in the example), which typically aligns better with a class-based mental model for users coming from OOP language backgrounds. It is also more beginner-friendly by abstracting away the reactivity details and enforcing code organization via option groups.
The Composition API is centered around declaring reactive state variables directly in a function scope and composing state from multiple functions together to handle complexity. It is more free-form and requires an understanding of how reactivity works in Vue to be used effectively. In return, its flexibility enables more powerful patterns for organizing and reusing logic.
You can learn more about the comparison between the two styles and the potential benefits of Composition API in the Composition API FAQ.
If you are new to Vue, here's our general recommendation:
For learning purposes, go with the style that looks easier to understand to you. Again, most of the core concepts are shared between the two styles. You can always pick up the other style later.
For production use:
Go with Options API if you are not using build tools, or plan to use Vue primarily in low-complexity scenarios, e.g. progressive enhancement.
Go with Composition API + Single-File Components if you plan to build full applications with Vue.
You don't have to commit to only one style during the learning phase. The rest of the documentation will provide code samples in both styles where applicable, and you can toggle between them at any time using the API Preference switches at the top of the left sidebar.
Still Got Questions?
Check out our FAQ.
Pick Your Learning Path
Different developers have different learning styles. Feel free to pick a learning path that suits your preference - although we do recommend going over all of the content, if possible!H
     hhuh(hh	h}ubh)}(h}(hNh	}(h'https://vuejs.org/guide/essentials/listh
List Rendering | Vue.jsuhX4   List Rendering
v-for
We can use the v-for
directive to render a list of items based on an array. The v-for
directive requires a special syntax in the form of item in items
, where items
is the source data array and item
is an alias for the array element being iterated on:
js
const items = ref([{ message: 'Foo' }, { message: 'Bar' }])
template
<li v-for="item in items">
{{ item.message }}
</li>
Inside the v-for
scope, template expressions have access to all parent scope properties. In addition, v-for
also supports an optional second alias for the index of the current item:
js
const parentMessage = ref('Parent')
const items = ref([{ message: 'Foo' }, { message: 'Bar' }])
template
<li v-for="(item, index) in items">
{{ parentMessage }} - {{ index }} - {{ item.message }}
</li>
The variable scoping of v-for
is similar to the following JavaScript:
js
const parentMessage = 'Parent'
const items = [
/* ... */
]
items.forEach((item, index) => {
// has access to outer scope `parentMessage`
// but `item` and `index` are only available in here
console.log(parentMessage, item.message, index)
})
Notice how the v-for
value matches the function signature of the forEach
callback. In fact, you can use destructuring on the v-for
item alias similar to destructuring function arguments:
template
<li v-for="{ message } in items">
{{ message }}
</li>
<!-- with index alias -->
<li v-for="({ message }, index) in items">
{{ message }} {{ index }}
</li>
For nested v-for
, scoping also works similar to nested functions. Each v-for
scope has access to parent scopes:
template
<li v-for="item in items">
<span v-for="childItem in item.children">
{{ item.message }} {{ childItem }}
</span>
</li>
You can also use of
as the delimiter instead of in
, so that it is closer to JavaScript's syntax for iterators:
template
<div v-for="item of items"></div>
v-for
with an Object
You can also use v-for
to iterate through the properties of an object. The iteration order will be based on the result of calling Object.keys()
on the object:
js
const myObject = reactive({
title: 'How to do lists in Vue',
author: 'Jane Doe',
publishedAt: '2016-04-10'
})
template
<ul>
<li v-for="value in myObject">
{{ value }}
</li>
</ul>
You can also provide a second alias for the property's name (a.k.a. key):
template
<li v-for="(value, key) in myObject">
{{ key }}: {{ value }}
</li>
And another for the index:
template
<li v-for="(value, key, index) in myObject">
{{ index }}. {{ key }}: {{ value }}
</li>
v-for
with a Range
v-for
can also take an integer. In this case it will repeat the template that many times, based on a range of 1...n
.
template
<span v-for="n in 10">{{ n }}</span>
Note here n
starts with an initial value of 1
instead of 0
.
v-for
on <template>
Similar to template v-if
, you can also use a <template>
tag with v-for
to render a block of multiple elements. For example:
template
<ul>
<template v-for="item in items">
<li>{{ item.msg }}</li>
<li class="divider" role="presentation"></li>
</template>
</ul>
v-for
with v-if
Note
It's not recommended to use v-if
and v-for
on the same element due to implicit precedence. Refer to style guide for details.
When they exist on the same node, v-if
has a higher priority than v-for
. That means the v-if
condition will not have access to variables from the scope of the v-for
:
template
<!--
This will throw an error because property "todo"
is not defined on instance.
-->
<li v-for="todo in todos" v-if="!todo.isComplete">
{{ todo.name }}
</li>
This can be fixed by moving v-for
to a wrapping <template>
tag (which is also more explicit):
template
<template v-for="todo in todos">
<li v-if="!todo.isComplete">
{{ todo.name }}
</li>
</template>
Maintaining State with key
When Vue is updating a list of elements rendered with v-for
, by default it uses an "in-place patch" strategy. If the order of the data items has changed, instead of moving the DOM elements to match the order of the items, Vue will patch each element in-place and make sure it reflects what should be rendered at that particular index.
This default mode is efficient, but only suitable when your list render output does not rely on child component state or temporary DOM state (e.g. form input values).
To give Vue a hint so that it can track each node's identity, and thus reuse and reorder existing elements, you need to provide a unique key
attribute for each item:
template
<div v-for="item in items" :key="item.id">
<!-- content -->
</div>
When using <template v-for>
, the key
should be placed on the <template>
container:
template
<template v-for="todo in todos" :key="todo.name">
<li>{{ todo.name }}</li>
</template>
Note
key
here is a special attribute being bound with v-bind
. It should not be confused with the property key variable when using v-for
with an object.
It is recommended to provide a key
attribute with v-for
whenever possible, unless the iterated DOM content is simple (i.e. contains no components or stateful DOM elements), or you are intentionally relying on the default behavior for performance gains.
The key
binding expects primitive values - i.e. strings and numbers. Do not use objects as v-for
keys. For detailed usage of the key
attribute, please see the key
API documentation.
v-for
with a Component
This section assumes knowledge of Components. Feel free to skip it and come back later.
You can directly use v-for
on a component, like any normal element (don't forget to provide a key
):
template
<MyComponent v-for="item in items" :key="item.id" />
However, this won't automatically pass any data to the component, because components have isolated scopes of their own. In order to pass the iterated data into the component, we should also use props:
template
<MyComponent
v-for="(item, index) in items"
:item="item"
:index="index"
:key="item.id"
/>
The reason for not automatically injecting item
into the component is because that makes the component tightly coupled to how v-for
works. Being explicit about where its data comes from makes the component reusable in other situations.
Check out this example of a simple todo list to see how to render a list of components using v-for
, passing different data to each instance.
Array Change Detection
Mutation Methods
Vue is able to detect when a reactive array's mutation methods are called and trigger necessary updates. These mutation methods are:
push()
pop()
shift()
unshift()
splice()
sort()
reverse()
Replacing an Array
Mutation methods, as the name suggests, mutate the original array they are called on. In comparison, there are also non-mutating methods, e.g. filter()
, concat()
and slice()
, which do not mutate the original array but always return a new array. When working with non-mutating methods, we should replace the old array with the new one:
js
// `items` is a ref with array value
items.value = items.value.filter((item) => item.message.match(/Foo/))
You might think this will cause Vue to throw away the existing DOM and re-render the entire list - luckily, that is not the case. Vue implements some smart heuristics to maximize DOM element reuse, so replacing an array with another array containing overlapping objects is a very efficient operation.
Displaying Filtered/Sorted Results
Sometimes we want to display a filtered or sorted version of an array without actually mutating or resetting the original data. In this case, you can create a computed property that returns the filtered or sorted array.
For example:
js
const numbers = ref([1, 2, 3, 4, 5])
const evenNumbers = computed(() => {
return numbers.value.filter((n) => n % 2 === 0)
})
template
<li v-for="n in evenNumbers">{{ n }}</li>
In situations where computed properties are not feasible (e.g. inside nested v-for
loops), you can use a method:
js
const sets = ref([
[1, 2, 3, 4, 5],
[6, 7, 8, 9, 10]
])
function even(numbers) {
return numbers.filter((number) => number % 2 === 0)
}
template
<ul v-for="numbers in sets">
<li v-for="n in even(numbers)">{{ n }}</li>
</ul>
Be careful with reverse()
and sort()
in a computed property! These two methods will mutate the original array, which should be avoided in computed getters. Create a copy of the original array before calling these methods:
diff
- return numbers.reverse()
+ return [...numbers].reverse()hhuh(hh	h}ubh)}(h}(hNh	}(h2https://vuejs.org/guide/built-ins/transition-grouph
TransitionGroup | Vue.jsuhX
  TransitionGroup
<TransitionGroup>
is a built-in component designed for animating the insertion, removal, and order change of elements or components that are rendered in a list.
Differences from <Transition>
<TransitionGroup>
supports the same props, CSS transition classes, and JavaScript hook listeners as <Transition>
, with the following differences:
By default, it doesn't render a wrapper element. But you can specify an element to be rendered with the
tag
prop.Transition modes are not available, because we are no longer alternating between mutually exclusive elements.
Elements inside are always required to have a unique
key
attribute.CSS transition classes will be applied to individual elements in the list, not to the group / container itself.
TIP
When used in in-DOM templates, it should be referenced as <transition-group>
.
Enter / Leave Transitions
Here is an example of applying enter / leave transitions to a v-for
list using <TransitionGroup>
:
template
<TransitionGroup name="list" tag="ul">
<li v-for="item in items" :key="item">
{{ item }}
</li>
</TransitionGroup>
css
.list-enter-active,
.list-leave-active {
transition: all 0.5s ease;
}
.list-enter-from,
.list-leave-to {
opacity: 0;
transform: translateX(30px);
}
- 1
- 2
- 3
- 4
- 5
Move Transitions
The above demo has some obvious flaws: when an item is inserted or removed, its surrounding items instantly "jump" into place instead of moving smoothly. We can fix this by adding a few additional CSS rules:
css
.list-move, /* apply transition to moving elements */
.list-enter-active,
.list-leave-active {
transition: all 0.5s ease;
}
.list-enter-from,
.list-leave-to {
opacity: 0;
transform: translateX(30px);
}
/* ensure leaving items are taken out of layout flow so that moving
animations can be calculated correctly. */
.list-leave-active {
position: absolute;
}
Now it looks much better - even animating smoothly when the whole list is shuffled:
- 1
- 2
- 3
- 4
- 5
Staggering List Transitions
By communicating with JavaScript transitions through data attributes, it's also possible to stagger transitions in a list. First, we render the index of an item as a data attribute on the DOM element:
template
<TransitionGroup
tag="ul"
:css="false"
@before-enter="onBeforeEnter"
@enter="onEnter"
@leave="onLeave"
>
<li
v-for="(item, index) in computedList"
:key="item.msg"
:data-index="index"
>
{{ item.msg }}
</li>
</TransitionGroup>
Then, in JavaScript hooks, we animate the element with a delay based on the data attribute. This example is using the GSAP library to perform the animation:
js
function onEnter(el, done) {
gsap.to(el, {
opacity: 1,
height: '1.6em',
delay: el.dataset.index * 0.15,
onComplete: done
})
}
- Bruce Lee
- Jackie Chan
- Chuck Norris
- Jet Li
- Kung Fury
Relatedhhuh(hh	h}ubh)}(h}(hNh	}(h(https://vuejs.org/guide/components/asynch
Async Components | Vue.jsuhX  Async Components
Basic Usage
In large applications, we may need to divide the app into smaller chunks and only load a component from the server when it's needed. To make that possible, Vue has a defineAsyncComponent
function:
js
import { defineAsyncComponent } from 'vue'
const AsyncComp = defineAsyncComponent(() => {
return new Promise((resolve, reject) => {
// ...load component from server
resolve(/* loaded component */)
})
})
// ... use `AsyncComp` like a normal component
As you can see, defineAsyncComponent
accepts a loader function that returns a Promise. The Promise's resolve
callback should be called when you have retrieved your component definition from the server. You can also call reject(reason)
to indicate the load has failed.
ES module dynamic import also returns a Promise, so most of the time we will use it in combination with defineAsyncComponent
. Bundlers like Vite and webpack also support the syntax (and will use it as bundle split points), so we can use it to import Vue SFCs:
js
import { defineAsyncComponent } from 'vue'
const AsyncComp = defineAsyncComponent(() =>
import('./components/MyComponent.vue')
)
The resulting AsyncComp
is a wrapper component that only calls the loader function when it is actually rendered on the page. In addition, it will pass along any props and slots to the inner component, so you can use the async wrapper to seamlessly replace the original component while achieving lazy loading.
As with normal components, async components can be registered globally using app.component()
:
js
app.component('MyComponent', defineAsyncComponent(() =>
import('./components/MyComponent.vue')
))
They can also be defined directly inside their parent component:
vue
<script setup>
import { defineAsyncComponent } from 'vue'
const AdminPage = defineAsyncComponent(() =>
import('./components/AdminPageComponent.vue')
)
</script>
<template>
<AdminPage />
</template>
Loading and Error States
Asynchronous operations inevitably involve loading and error states - defineAsyncComponent()
supports handling these states via advanced options:
js
const AsyncComp = defineAsyncComponent({
// the loader function
loader: () => import('./Foo.vue'),
// A component to use while the async component is loading
loadingComponent: LoadingComponent,
// Delay before showing the loading component. Default: 200ms.
delay: 200,
// A component to use if the load fails
errorComponent: ErrorComponent,
// The error component will be displayed if a timeout is
// provided and exceeded. Default: Infinity.
timeout: 3000
})
If a loading component is provided, it will be displayed first while the inner component is being loaded. There is a default 200ms delay before the loading component is shown - this is because on fast networks, an instant loading state may get replaced too fast and end up looking like a flicker.
If an error component is provided, it will be displayed when the Promise returned by the loader function is rejected. You can also specify a timeout to show the error component when the request is taking too long.
Using with Suspense
Async components can be used with the <Suspense>
built-in component. The interaction between <Suspense>
and async components is documented in the dedicated chapter for <Suspense>
.hhuh(hh	h}ubh)}(h}(hNh	}(h*https://vuejs.org/guide/scaling-up/toolingh
Tooling | Vue.jsuhX  Tooling
Try It Online
You don't need to install anything on your machine to try out Vue SFCs - there are online playgrounds that allow you to do so right in the browser:
- Vue SFC Playground
- Always deployed from latest commit
- Designed for inspecting component compilation results
- Vue + Vite on StackBlitz
- IDE-like environment running actual Vite dev server in the browser
- Closest to local setup
It is also recommended to use these online playgrounds to provide reproductions when reporting bugs.
Project Scaffolding
Vite
Vite is a lightweight and fast build tool with first-class Vue SFC support. It is created by Evan You, who is also the author of Vue!
To get started with Vite + Vue, simply run:
npm
pnpm
yarn
bun
sh
$ npm create vue@latest
This command will install and execute create-vue, the official Vue project scaffolding tool.
- To learn more about Vite, check out the Vite docs.
- To configure Vue-specific behavior in a Vite project, for example passing options to the Vue compiler, check out the docs for @vitejs/plugin-vue.
Both online playgrounds mentioned above also support downloading files as a Vite project.
Vue CLI
Vue CLI is the official webpack-based toolchain for Vue. It is now in maintenance mode and we recommend starting new projects with Vite unless you rely on specific webpack-only features. Vite will provide superior developer experience in most cases.
For information on migrating from Vue CLI to Vite:
Note on In-Browser Template Compilation
When using Vue without a build step, component templates are written either directly in the page's HTML or as inlined JavaScript strings. In such cases, Vue needs to ship the template compiler to the browser in order to perform on-the-fly template compilation. On the other hand, the compiler would be unnecessary if we pre-compile the templates with a build step. To reduce client bundle size, Vue provides different "builds" optimized for different use cases.
Build files that start with
vue.runtime.*
are runtime-only builds: they do not include the compiler. When using these builds, all templates must be pre-compiled via a build step.Build files that do not include
.runtime
are full builds: they include the compiler and support compiling templates directly in the browser. However, they will increase the payload by ~14kb.
Our default tooling setups use the runtime-only build since all templates in SFCs are pre-compiled. If, for some reason, you need in-browser template compilation even with a build step, you can do so by configuring the build tool to alias vue
to vue/dist/vue.esm-bundler.js
instead.
If you are looking for a lighter-weight alternative for no-build-step usage, check out petite-vue.
IDE Support
The recommended IDE setup is VS Code + the Vue - Official extension (previously Volar). The extension provides syntax highlighting, TypeScript support, and intellisense for template expressions and component props.
TIP
Vue - Official replaces Vetur, our previous official VS Code extension for Vue 2. If you have Vetur currently installed, make sure to disable it in Vue 3 projects.
WebStorm also provides great built-in support for Vue SFCs.
Other IDEs that support the Language Service Protocol (LSP) can also leverage Volar's core functionalities via LSP:
Browser Devtools
The Vue browser devtools extension allows you to explore a Vue app's component tree, inspect the state of individual components, track state management events, and profile performance.
TypeScript
Main article: Using Vue with TypeScript.
Vue - Official extension provides type checking for SFCs using
<script lang="ts">
blocks, including template expressions and cross-component props validation.Use
vue-tsc
for performing the same type checking from the command line, or for generatingd.ts
files for SFCs.
Testing
Main article: Testing Guide.
Cypress is recommended for E2E tests. It can also be used for component testing for Vue SFCs via the Cypress Component Test Runner.
Vitest is a test runner created by Vue / Vite team members that focuses on speed. It is specifically designed for Vite-based applications to provide the same instant feedback loop for unit / component testing.
Jest can be made to work with Vite via vite-jest. However, this is only recommended if you have existing Jest-based test suites that you need to migrate over to a Vite-based setup, as Vitest provides similar functionalities with a much more efficient integration.
Linting
The Vue team maintains eslint-plugin-vue, an ESLint plugin that supports SFC-specific linting rules.
Users previously using Vue CLI may be used to having linters configured via webpack loaders. However when using a Vite-based build setup, our general recommendation is:
npm install -D eslint eslint-plugin-vue
, then followeslint-plugin-vue
's configuration guide.Setup ESLint IDE extensions, for example ESLint for VS Code, so you get linter feedback right in your editor during development. This also avoids unnecessary linting cost when starting the dev server.
Run ESLint as part of the production build command, so you get full linter feedback before shipping to production.
(Optional) Setup tools like lint-staged to automatically lint modified files on git commit.
Formatting
The Vue - Official VS Code extension provides formatting for Vue SFCs out of the box.
Alternatively, Prettier provides built-in Vue SFC formatting support.
SFC Custom Block Integrations
Custom blocks are compiled into imports to the same Vue file with different request queries. It is up to the underlying build tool to handle these import requests.
If using Vite, a custom Vite plugin should be used to transform matched custom blocks into executable JavaScript. Example
If using Vue CLI or plain webpack, a webpack loader should be configured to transform the matched blocks. Example
Lower-Level Packages
@vue/compiler-sfc
This package is part of the Vue core monorepo and is always published with the same version as the main vue
package. It is included as a dependency of the main vue
package and proxied under vue/compiler-sfc
so you don't need to install it individually.
The package itself provides lower-level utilities for processing Vue SFCs and is only meant for tooling authors that need to support Vue SFCs in custom tools.
TIP
Always prefer using this package via the vue/compiler-sfc
deep import since this ensures its version is in sync with the Vue runtime.
@vitejs/plugin-vue
Official plugin that provides Vue SFC support in Vite.
vue-loader
The official loader that provides Vue SFC support in webpack. If you are using Vue CLI, also see docs on modifying vue-loader
options in Vue CLI.hhuh(hh	h}ubh)}(h}(hNh	}(h+https://vuejs.org/guide/typescript/overviewh
"Using Vue with TypeScript | Vue.jsuhX  Using Vue with TypeScript
A type system like TypeScript can detect many common errors via static analysis at build time. This reduces the chance of runtime errors in production, and also allows us to more confidently refactor code in large-scale applications. TypeScript also improves developer ergonomics via type-based auto-completion in IDEs.
Vue is written in TypeScript itself and provides first-class TypeScript support. All official Vue packages come with bundled type declarations that should work out-of-the-box.
Project Setup
create-vue
, the official project scaffolding tool, offers the options to scaffold a Vite-powered, TypeScript-ready Vue project.
Overview
With a Vite-based setup, the dev server and the bundler are transpilation-only and do not perform any type-checking. This ensures the Vite dev server stays blazing fast even when using TypeScript.
During development, we recommend relying on a good IDE setup for instant feedback on type errors.
If using SFCs, use the
vue-tsc
utility for command line type checking and type declaration generation.vue-tsc
is a wrapper aroundtsc
, TypeScript's own command line interface. It works largely the same astsc
except that it supports Vue SFCs in addition to TypeScript files. You can runvue-tsc
in watch mode in parallel to the Vite dev server, or use a Vite plugin like vite-plugin-checker which runs the checks in a separate worker thread.Vue CLI also provides TypeScript support, but is no longer recommended. See notes below.
IDE Support
Visual Studio Code (VS Code) is strongly recommended for its great out-of-the-box support for TypeScript.
Vue - Official (previously Volar) is the official VS Code extension that provides TypeScript support inside Vue SFCs, along with many other great features.
TIP
Vue - Official extension replaces Vetur, our previous official VS Code extension for Vue 2. If you have Vetur currently installed, make sure to disable it in Vue 3 projects.
WebStorm also provides out-of-the-box support for both TypeScript and Vue. Other JetBrains IDEs support them too, either out of the box or via a free plugin. As of version 2023.2, WebStorm and the Vue Plugin come with built-in support for the Vue Language Server. You can set the Vue service to use Volar integration on all TypeScript versions, under Settings > Languages & Frameworks > TypeScript > Vue. By default, Volar will be used for TypeScript versions 5.0 and higher.
Configuring tsconfig.json
Projects scaffolded via create-vue
include pre-configured tsconfig.json
. The base config is abstracted in the @vue/tsconfig
package. Inside the project, we use Project References to ensure correct types for code running in different environments (e.g. app code and test code should have different global variables).
When configuring tsconfig.json
manually, some notable options include:
compilerOptions.isolatedModules
is set totrue
because Vite uses esbuild for transpiling TypeScript and is subject to single-file transpile limitations.compilerOptions.verbatimModuleSyntax
is a superset ofisolatedModules
and is a good choice, too - it's what@vue/tsconfig
uses.If you're using Options API, you need to set
compilerOptions.strict
totrue
(or at least enablecompilerOptions.noImplicitThis
, which is a part of thestrict
flag) to leverage type checking ofthis
in component options. Otherwisethis
will be treated asany
.If you have configured resolver aliases in your build tool, for example the
@/*
alias configured by default in acreate-vue
project, you need to also configure it for TypeScript viacompilerOptions.paths
.If you intend to use TSX with Vue, set
compilerOptions.jsx
to"preserve"
, and setcompilerOptions.jsxImportSource
to"vue"
.
See also:
Note on Vue CLI and ts-loader
In webpack-based setups such as Vue CLI, it is common to perform type checking as part of the module transform pipeline, for example with ts-loader
. This, however, isn't a clean solution because the type system needs knowledge of the entire module graph to perform type checks. Individual module's transform step simply is not the right place for the task. It leads to the following problems:
ts-loader
can only type check post-transform code. This doesn't align with the errors we see in IDEs or fromvue-tsc
, which map directly back to the source code.Type checking can be slow. When it is performed in the same thread / process with code transformations, it significantly affects the build speed of the entire application.
We already have type checking running right in our IDE in a separate process, so the cost of dev experience slow down simply isn't a good trade-off.
If you are currently using Vue 3 + TypeScript via Vue CLI, we strongly recommend migrating over to Vite. We are also working on CLI options to enable transpile-only TS support, so that you can switch to vue-tsc
for type checking.
General Usage Notes
defineComponent()
To let TypeScript properly infer types inside component options, we need to define components with defineComponent()
:
ts
import { defineComponent } from 'vue'
export default defineComponent({
// type inference enabled
props: {
name: String,
msg: { type: String, required: true }
},
data() {
return {
count: 1
}
},
mounted() {
this.name // type: string | undefined
this.msg // type: string
this.count // type: number
}
})
defineComponent()
also supports inferring the props passed to setup()
when using Composition API without <script setup>
:
ts
import { defineComponent } from 'vue'
export default defineComponent({
// type inference enabled
props: {
message: String
},
setup(props) {
props.message // type: string | undefined
}
})
See also:
TIP
defineComponent()
also enables type inference for components defined in plain JavaScript.
Usage in Single-File Components
To use TypeScript in SFCs, add the lang="ts"
attribute to <script>
tags. When lang="ts"
is present, all template expressions also enjoy stricter type checking.
vue
<script lang="ts">
import { defineComponent } from 'vue'
export default defineComponent({
data() {
return {
count: 1
}
}
})
</script>
<template>
<!-- type checking and auto-completion enabled -->
{{ count.toFixed(2) }}
</template>
lang="ts"
can also be used with <script setup>
:
vue
<script setup lang="ts">
// TypeScript enabled
import { ref } from 'vue'
const count = ref(1)
</script>
<template>
<!-- type checking and auto-completion enabled -->
{{ count.toFixed(2) }}
</template>
TypeScript in Templates
The <template>
also supports TypeScript in binding expressions when <script lang="ts">
or <script setup lang="ts">
is used. This is useful in cases where you need to perform type casting in template expressions.
Here's a contrived example:
vue
<script setup lang="ts">
let x: string | number = 1
</script>
<template>
<!-- error because x could be a string -->
{{ x.toFixed(2) }}
</template>
This can be worked around with an inline type cast:
vue
<script setup lang="ts">
let x: string | number = 1
</script>
<template>
{{ (x as number).toFixed(2) }}
</template>
TIP
If using Vue CLI or a webpack-based setup, TypeScript in template expressions requires vue-loader@^16.8.0
.
Usage with TSX
Vue also supports authoring components with JSX / TSX. Details are covered in the Render Function & JSX guide.
Generic Components
Generic components are supported in two cases:
- In SFCs:
<script setup>
with thegeneric
attribute - Render function / JSX components:
defineComponent()
's function signaturehhuh(hh	h}ubh)}(h}(hNh	}(h,https://vuejs.org/guide/built-ins/transitionh
Transition | Vue.jsuhX<  Transition
Vue offers two built-in components that can help work with transitions and animations in response to changing state:
<Transition>
for applying animations when an element or component is entering and leaving the DOM. This is covered on this page.<TransitionGroup>
for applying animations when an element or component is inserted into, removed from, or moved within av-for
list. This is covered in the next chapter.
Aside from these two components, we can also apply animations in Vue using other techniques such as toggling CSS classes or state-driven animations via style bindings. These additional techniques are covered in the Animation Techniques chapter.
The <Transition>
Component
<Transition>
is a built-in component: this means it is available in any component's template without having to register it. It can be used to apply enter and leave animations on elements or components passed to it via its default slot. The enter or leave can be triggered by one of the following:
- Conditional rendering via
v-if
- Conditional display via
v-show
- Dynamic components toggling via the
<component>
special element - Changing the special
key
attribute
This is an example of the most basic usage:
template
<button @click="show = !show">Toggle</button>
<Transition>
<p v-if="show">hello</p>
</Transition>
css
/* we will explain what these classes do next! */
.v-enter-active,
.v-leave-active {
transition: opacity 0.5s ease;
}
.v-enter-from,
.v-leave-to {
opacity: 0;
}
hello
TIP
<Transition>
only supports a single element or component as its slot content. If the content is a component, the component must also have only one single root element.
When an element in a <Transition>
component is inserted or removed, this is what happens:
Vue will automatically sniff whether the target element has CSS transitions or animations applied. If it does, a number of CSS transition classes will be added / removed at appropriate timings.
If there are listeners for JavaScript hooks, these hooks will be called at appropriate timings.
If no CSS transitions / animations are detected and no JavaScript hooks are provided, the DOM operations for insertion and/or removal will be executed on the browser's next animation frame.
CSS-Based Transitions
Transition Classes
There are six classes applied for enter / leave transitions.
v-enter-from
: Starting state for enter. Added before the element is inserted, removed one frame after the element is inserted.v-enter-active
: Active state for enter. Applied during the entire entering phase. Added before the element is inserted, removed when the transition/animation finishes. This class can be used to define the duration, delay and easing curve for the entering transition.v-enter-to
: Ending state for enter. Added one frame after the element is inserted (at the same timev-enter-from
is removed), removed when the transition/animation finishes.v-leave-from
: Starting state for leave. Added immediately when a leaving transition is triggered, removed after one frame.v-leave-active
: Active state for leave. Applied during the entire leaving phase. Added immediately when a leaving transition is triggered, removed when the transition/animation finishes. This class can be used to define the duration, delay and easing curve for the leaving transition.v-leave-to
: Ending state for leave. Added one frame after a leaving transition is triggered (at the same timev-leave-from
is removed), removed when the transition/animation finishes.
v-enter-active
and v-leave-active
give us the ability to specify different easing curves for enter / leave transitions, which we'll see an example of in the following sections.
Named Transitions
A transition can be named via the name
prop:
template
<Transition name="fade">
...
</Transition>
For a named transition, its transition classes will be prefixed with its name instead of v
. For example, the applied class for the above transition will be fade-enter-active
instead of v-enter-active
. The CSS for the fade transition should look like this:
css
.fade-enter-active,
.fade-leave-active {
transition: opacity 0.5s ease;
}
.fade-enter-from,
.fade-leave-to {
opacity: 0;
}
CSS Transitions
<Transition>
is most commonly used in combination with native CSS transitions, as seen in the basic example above. The transition
CSS property is a shorthand that allows us to specify multiple aspects of a transition, including properties that should be animated, duration of the transition, and easing curves.
Here is a more advanced example that transitions multiple properties, with different durations and easing curves for enter and leave:
template
<Transition name="slide-fade">
<p v-if="show">hello</p>
</Transition>
css
/*
Enter and leave animations can use different
durations and timing functions.
*/
.slide-fade-enter-active {
transition: all 0.3s ease-out;
}
.slide-fade-leave-active {
transition: all 0.8s cubic-bezier(1, 0.5, 0.8, 1);
}
.slide-fade-enter-from,
.slide-fade-leave-to {
transform: translateX(20px);
opacity: 0;
}
hello
CSS Animations
Native CSS animations are applied in the same way as CSS transitions, with the difference being that *-enter-from
is not removed immediately after the element is inserted, but on an animationend
event.
For most CSS animations, we can simply declare them under the *-enter-active
and *-leave-active
classes. Here's an example:
template
<Transition name="bounce">
<p v-if="show" style="text-align: center;">
Hello here is some bouncy text!
</p>
</Transition>
css
.bounce-enter-active {
animation: bounce-in 0.5s;
}
.bounce-leave-active {
animation: bounce-in 0.5s reverse;
}
@keyframes bounce-in {
0% {
transform: scale(0);
}
50% {
transform: scale(1.25);
}
100% {
transform: scale(1);
}
}
Hello here is some bouncy text!
Custom Transition Classes
You can also specify custom transition classes by passing the following props to <Transition>
:
enter-from-class
enter-active-class
enter-to-class
leave-from-class
leave-active-class
leave-to-class
These will override the conventional class names. This is especially useful when you want to combine Vue's transition system with an existing CSS animation library, such as Animate.css:
template
<!-- assuming Animate.css is included on the page -->
<Transition
name="custom-classes"
enter-active-class="animate__animated animate__tada"
leave-active-class="animate__animated animate__bounceOutRight"
>
<p v-if="show">hello</p>
</Transition>
Using Transitions and Animations Together
Vue needs to attach event listeners in order to know when a transition has ended. It can either be transitionend
or animationend
, depending on the type of CSS rules applied. If you are only using one or the other, Vue can automatically detect the correct type.
However, in some cases you may want to have both on the same element, for example having a CSS animation triggered by Vue, along with a CSS transition effect on hover. In these cases, you will have to explicitly declare the type you want Vue to care about by passing the type
prop, with a value of either animation
or transition
:
template
<Transition type="animation">...</Transition>
Nested Transitions and Explicit Transition Durations
Although the transition classes are only applied to the direct child element in <Transition>
, we can transition nested elements using nested CSS selectors:
template
<Transition name="nested">
<div v-if="show" class="outer">
<div class="inner">
Hello
</div>
</div>
</Transition>
css
/* rules that target nested elements */
.nested-enter-active .inner,
.nested-leave-active .inner {
transition: all 0.3s ease-in-out;
}
.nested-enter-from .inner,
.nested-leave-to .inner {
transform: translateX(30px);
opacity: 0;
}
/* ... other necessary CSS omitted */
We can even add a transition delay to the nested element on enter, which creates a staggered enter animation sequence:
css
/* delay enter of nested element for staggered effect */
.nested-enter-active .inner {
transition-delay: 0.25s;
}
However, this creates a small issue. By default, the <Transition>
component attempts to automatically figure out when the transition has finished by listening to the first transitionend
or animationend
event on the root transition element. With a nested transition, the desired behavior should be waiting until the transitions of all inner elements have finished.
In such cases you can specify an explicit transition duration (in milliseconds) using the duration
prop on the <transition>
component. The total duration should match the delay plus transition duration of the inner element:
template
<Transition :duration="550">...</Transition>
Hello
If necessary, you can also specify separate values for enter and leave durations using an object:
template
<Transition :duration="{ enter: 500, leave: 800 }">...</Transition>
Performance Considerations
You may notice that the animations shown above are mostly using properties like transform
and opacity
. These properties are efficient to animate because:
They do not affect the document layout during the animation, so they do not trigger expensive CSS layout calculation on every animation frame.
Most modern browsers can leverage GPU hardware acceleration when animating
transform
.
In comparison, properties like height
or margin
will trigger CSS layout, so they are much more expensive to animate, and should be used with caution.
JavaScript Hooks
You can hook into the transition process with JavaScript by listening to events on the <Transition>
component:
html
<Transition
@before-enter="onBeforeEnter"
@enter="onEnter"
@after-enter="onAfterEnter"
@enter-cancelled="onEnterCancelled"
@before-leave="onBeforeLeave"
@leave="onLeave"
@after-leave="onAfterLeave"
@leave-cancelled="onLeaveCancelled"
>
<!-- ... -->
</Transition>
js
// called before the element is inserted into the DOM.
// use this to set the "enter-from" state of the element
function onBeforeEnter(el) {}
// called one frame after the element is inserted.
// use this to start the entering animation.
function onEnter(el, done) {
// call the done callback to indicate transition end
// optional if used in combination with CSS
done()
}
// called when the enter transition has finished.
function onAfterEnter(el) {}
// called when the enter transition is cancelled before completion.
function onEnterCancelled(el) {}
// called before the leave hook.
// Most of the time, you should just use the leave hook
function onBeforeLeave(el) {}
// called when the leave transition starts.
// use this to start the leaving animation.
function onLeave(el, done) {
// call the done callback to indicate transition end
// optional if used in combination with CSS
done()
}
// called when the leave transition has finished and the
// element has been removed from the DOM.
function onAfterLeave(el) {}
// only available with v-show transitions
function onLeaveCancelled(el) {}
These hooks can be used in combination with CSS transitions / animations or on their own.
When using JavaScript-only transitions, it is usually a good idea to add the :css="false"
prop. This explicitly tells Vue to skip auto CSS transition detection. Aside from being slightly more performant, this also prevents CSS rules from accidentally interfering with the transition:
template
<Transition
...
:css="false"
>
...
</Transition>
With :css="false"
, we are also fully responsible for controlling when the transition ends. In this case, the done
callbacks are required for the @enter
and @leave
hooks. Otherwise, the hooks will be called synchronously and the transition will finish immediately.
Here's a demo using the GSAP library to perform the animations. You can, of course, use any other animation library you want, for example Anime.js or Motion One:
Reusable Transitions
Transitions can be reused through Vue's component system. To create a reusable transition, we can create a component that wraps the <Transition>
component and passes down the slot content:
vue
<!-- MyTransition.vue -->
<script>
// JavaScript hooks logic...
</script>
<template>
<!-- wrap the built-in Transition component -->
<Transition
name="my-transition"
@enter="onEnter"
@leave="onLeave">
<slot></slot> <!-- pass down slot content -->
</Transition>
</template>
<style>
/*
Necessary CSS...
Note: avoid using <style scoped> here since it
does not apply to slot content.
*/
</style>
Now MyTransition
can be imported and used just like the built-in version:
template
<MyTransition>
<div v-if="show">Hello</div>
</MyTransition>
Transition on Appear
If you also want to apply a transition on the initial render of a node, you can add the appear
prop:
template
<Transition appear>
...
</Transition>
Transition Between Elements
In addition to toggling an element with v-if
/ v-show
, we can also transition between two elements using v-if
/ v-else
/ v-else-if
, as long as we make sure that there is only one element being shown at any given moment:
template
<Transition>
<button v-if="docState === 'saved'">Edit</button>
<button v-else-if="docState === 'edited'">Save</button>
<button v-else-if="docState === 'editing'">Cancel</button>
</Transition>
Click to cycle through states:
Transition Modes
In the previous example, the entering and leaving elements are animated at the same time, and we had to make them position: absolute
to avoid the layout issue when both elements are present in the DOM.
However, in some cases this isn't an option, or simply isn't the desired behavior. We may want the leaving element to be animated out first, and for the entering element to only be inserted after the leaving animation has finished. Orchestrating such animations manually would be very complicated - luckily, we can enable this behavior by passing <Transition>
a mode
prop:
template
<Transition mode="out-in">
...
</Transition>
Here's the previous demo with mode="out-in"
:
Click to cycle through states:
<Transition>
also supports mode="in-out"
, although it's much less frequently used.
Transition Between Components
<Transition>
can also be used around dynamic components:
template
<Transition name="fade" mode="out-in">
<component :is="activeComponent"></component>
</Transition>
Component A
Dynamic Transitions
<Transition>
props like name
can also be dynamic! It allows us to dynamically apply different transitions based on state change:
template
<Transition :name="transitionName">
<!-- ... -->
</Transition>
This can be useful when you've defined CSS transitions / animations using Vue's transition class conventions and want to switch between them.
You can also apply different behavior in JavaScript transition hooks based on the current state of your component. Finally, the ultimate way of creating dynamic transitions is through reusable transition components that accept props to change the nature of the transition(s) to be used. It may sound cheesy, but the only limit really is your imagination.
Transitions with the Key Attribute
Sometimes you need to force the re-render of a DOM element in order for a transition to occur.
Take this counter component for example:
vue
<script setup>
import { ref } from 'vue';
const count = ref(0);
setInterval(() => count.value++, 1000);
</script>
<template>
<Transition>
<span :key="count">{{ count }}</span>
</Transition>
</template>
If we had excluded the key
attribute, only the text node would be updated and thus no transition would occur. However, with the key
attribute in place, Vue knows to create a new span
element whenever count
changes and thus the Transition
component has 2 different elements to transition between.
Relatedhhuh(hh	h}ubh)}(h}(hNh	}(h&https://vuejs.org/guide/scaling-up/sfch
Single-File Components | Vue.jsuhX  Single-File Components
Introduction
Vue Single-File Components (a.k.a. *.vue
files, abbreviated as SFC) is a special file format that allows us to encapsulate the template, logic, and styling of a Vue component in a single file. Here's an example SFC:
vue
<script setup>
import { ref } from 'vue'
const greeting = ref('Hello World!')
</script>
<template>
<p class="greeting">{{ greeting }}</p>
</template>
<style>
.greeting {
color: red;
font-weight: bold;
}
</style>
As we can see, Vue SFC is a natural extension of the classic trio of HTML, CSS and JavaScript. The <template>
, <script>
, and <style>
blocks encapsulate and colocate the view, logic and styling of a component in the same file. The full syntax is defined in the SFC Syntax Specification.
Why SFC
While SFCs require a build step, there are numerous benefits in return:
- Author modularized components using familiar HTML, CSS and JavaScript syntax
- Colocation of inherently coupled concerns
- Pre-compiled templates without runtime compilation cost
- Component-scoped CSS
- More ergonomic syntax when working with Composition API
- More compile-time optimizations by cross-analyzing template and script
- IDE support with auto-completion and type-checking for template expressions
- Out-of-the-box Hot-Module Replacement (HMR) support
SFC is a defining feature of Vue as a framework, and is the recommended approach for using Vue in the following scenarios:
- Single-Page Applications (SPA)
- Static Site Generation (SSG)
- Any non-trivial frontend where a build step can be justified for better development experience (DX).
That said, we do realize there are scenarios where SFCs can feel like overkill. This is why Vue can still be used via plain JavaScript without a build step. If you are just looking for enhancing largely static HTML with light interactions, you can also check out petite-vue, a 6 kB subset of Vue optimized for progressive enhancement.
How It Works
Vue SFC is a framework-specific file format and must be pre-compiled by @vue/compiler-sfc into standard JavaScript and CSS. A compiled SFC is a standard JavaScript (ES) module - which means with proper build setup you can import an SFC like a module:
js
import MyComponent from './MyComponent.vue'
export default {
components: {
MyComponent
}
}
<style>
tags inside SFCs are typically injected as native <style>
tags during development to support hot updates. For production they can be extracted and merged into a single CSS file.
You can play with SFCs and explore how they are compiled in the Vue SFC Playground.
In actual projects, we typically integrate the SFC compiler with a build tool such as Vite or Vue CLI (which is based on webpack), and Vue provides official scaffolding tools to get you started with SFCs as fast as possible. Check out more details in the SFC Tooling section.
What About Separation of Concerns?
Some users coming from a traditional web development background may have the concern that SFCs are mixing different concerns in the same place - which HTML/CSS/JS were supposed to separate!
To answer this question, it is important for us to agree that separation of concerns is not equal to the separation of file types. The ultimate goal of engineering principles is to improve the maintainability of codebases. Separation of concerns, when applied dogmatically as separation of file types, does not help us reach that goal in the context of increasingly complex frontend applications.
In modern UI development, we have found that instead of dividing the codebase into three huge layers that interweave with one another, it makes much more sense to divide them into loosely-coupled components and compose them. Inside a component, its template, logic, and styles are inherently coupled, and colocating them actually makes the component more cohesive and maintainable.
Note even if you don't like the idea of Single-File Components, you can still leverage its hot-reloading and pre-compilation features by separating your JavaScript and CSS into separate files using Src Imports.hhuh(hh	h}ubh)}(h}(hNh	}(h3https://vuejs.org/guide/essentials/component-basicsh
Components Basics | Vue.jsuhX6  Components Basics
Components allow us to split the UI into independent and reusable pieces, and think about each piece in isolation. It's common for an app to be organized into a tree of nested components:
This is very similar to how we nest native HTML elements, but Vue implements its own component model that allows us to encapsulate custom content and logic in each component. Vue also plays nicely with native Web Components. If you are curious about the relationship between Vue Components and native Web Components, read more here.
Defining a Component
When using a build step, we typically define each Vue component in a dedicated file using the .vue
extension - known as a Single-File Component (SFC for short):
vue
<script setup>
import { ref } from 'vue'
const count = ref(0)
</script>
<template>
<button @click="count++">You clicked me {{ count }} times.</button>
</template>
When not using a build step, a Vue component can be defined as a plain JavaScript object containing Vue-specific options:
js
import { ref } from 'vue'
export default {
setup() {
const count = ref(0)
return { count }
},
template: `
<button @click="count++">
You clicked me {{ count }} times.
</button>`
// Can also target an in-DOM template:
// template: '#my-template-element'
}
The template is inlined as a JavaScript string here, which Vue will compile on the fly. You can also use an ID selector pointing to an element (usually native <template>
elements) - Vue will use its content as the template source.
The example above defines a single component and exports it as the default export of a .js
file, but you can use named exports to export multiple components from the same file.
Using a Component
TIP
We will be using SFC syntax for the rest of this guide - the concepts around components are the same regardless of whether you are using a build step or not. The Examples section shows component usage in both scenarios.
To use a child component, we need to import it in the parent component. Assuming we placed our counter component inside a file called ButtonCounter.vue
, the component will be exposed as the file's default export:
vue
<script setup>
import ButtonCounter from './ButtonCounter.vue'
</script>
<template>
<h1>Here is a child component!</h1>
<ButtonCounter />
</template>
With <script setup>
, imported components are automatically made available to the template.
It's also possible to globally register a component, making it available to all components in a given app without having to import it. The pros and cons of global vs. local registration is discussed in the dedicated Component Registration section.
Components can be reused as many times as you want:
template
<h1>Here are many child components!</h1>
<ButtonCounter />
<ButtonCounter />
<ButtonCounter />
Notice that when clicking on the buttons, each one maintains its own, separate count
. That's because each time you use a component, a new instance of it is created.
In SFCs, it's recommended to use PascalCase
tag names for child components to differentiate from native HTML elements. Although native HTML tag names are case-insensitive, Vue SFC is a compiled format so we are able to use case-sensitive tag names in it. We are also able to use />
to close a tag.
If you are authoring your templates directly in a DOM (e.g. as the content of a native <template>
element), the template will be subject to the browser's native HTML parsing behavior. In such cases, you will need to use kebab-case
and explicit closing tags for components:
template
<!-- if this template is written in the DOM -->
<button-counter></button-counter>
<button-counter></button-counter>
<button-counter></button-counter>
See in-DOM template parsing caveats for more details.
Passing Props
If we are building a blog, we will likely need a component representing a blog post. We want all the blog posts to share the same visual layout, but with different content. Such a component won't be useful unless you can pass data to it, such as the title and content of the specific post we want to display. That's where props come in.
Props are custom attributes you can register on a component. To pass a title to our blog post component, we must declare it in the list of props this component accepts, using the defineProps
macro:
vue
<!-- BlogPost.vue -->
<script setup>
defineProps(['title'])
</script>
<template>
<h4>{{ title }}</h4>
</template>
defineProps
is a compile-time macro that is only available inside <script setup>
and does not need to be explicitly imported. Declared props are automatically exposed to the template. defineProps
also returns an object that contains all the props passed to the component, so that we can access them in JavaScript if needed:
js
const props = defineProps(['title'])
console.log(props.title)
See also: Typing Component Props
If you are not using <script setup>
, props should be declared using the props
option, and the props object will be passed to setup()
as the first argument:
js
export default {
props: ['title'],
setup(props) {
console.log(props.title)
}
}
A component can have as many props as you like and, by default, any value can be passed to any prop.
Once a prop is registered, you can pass data to it as a custom attribute, like this:
template
<BlogPost title="My journey with Vue" />
<BlogPost title="Blogging with Vue" />
<BlogPost title="Why Vue is so fun" />
In a typical app, however, you'll likely have an array of posts in your parent component:
js
const posts = ref([
{ id: 1, title: 'My journey with Vue' },
{ id: 2, title: 'Blogging with Vue' },
{ id: 3, title: 'Why Vue is so fun' }
])
Then want to render a component for each one, using v-for
:
template
<BlogPost
v-for="post in posts"
:key="post.id"
:title="post.title"
/>
Notice how v-bind
syntax (:title="post.title"
) is used to pass dynamic prop values. This is especially useful when you don't know the exact content you're going to render ahead of time.
That's all you need to know about props for now, but once you've finished reading this page and feel comfortable with its content, we recommend coming back later to read the full guide on Props.
Listening to Events
As we develop our <BlogPost>
component, some features may require communicating back up to the parent. For example, we may decide to include an accessibility feature to enlarge the text of blog posts, while leaving the rest of the page at its default size.
In the parent, we can support this feature by adding a postFontSize
ref:
js
const posts = ref([
/* ... */
])
const postFontSize = ref(1)
Which can be used in the template to control the font size of all blog posts:
template
<div :style="{ fontSize: postFontSize + 'em' }">
<BlogPost
v-for="post in posts"
:key="post.id"
:title="post.title"
/>
</div>
Now let's add a button to the <BlogPost>
component's template:
vue
<!-- BlogPost.vue, omitting <script> -->
<template>
<div class="blog-post">
<h4>{{ title }}</h4>
<button>Enlarge text</button>
</div>
</template>
The button doesn't do anything yet - we want clicking the button to communicate to the parent that it should enlarge the text of all posts. To solve this problem, components provide a custom events system. The parent can choose to listen to any event on the child component instance with v-on
or @
, just as we would with a native DOM event:
template
<BlogPost
...
@enlarge-text="postFontSize += 0.1"
/>
Then the child component can emit an event on itself by calling the built-in $emit
method, passing the name of the event:
vue
<!-- BlogPost.vue, omitting <script> -->
<template>
<div class="blog-post">
<h4>{{ title }}</h4>
<button @click="$emit('enlarge-text')">Enlarge text</button>
</div>
</template>
Thanks to the @enlarge-text="postFontSize += 0.1"
listener, the parent will receive the event and update the value of postFontSize
.
We can optionally declare emitted events using the defineEmits
macro:
vue
<!-- BlogPost.vue -->
<script setup>
defineProps(['title'])
defineEmits(['enlarge-text'])
</script>
This documents all the events that a component emits and optionally validates them. It also allows Vue to avoid implicitly applying them as native listeners to the child component's root element.
Similar to defineProps
, defineEmits
is only usable in <script setup>
and doesn't need to be imported. It returns an emit
function that is equivalent to the $emit
method. It can be used to emit events in the <script setup>
section of a component, where $emit
isn't directly accessible:
vue
<script setup>
const emit = defineEmits(['enlarge-text'])
emit('enlarge-text')
</script>
See also: Typing Component Emits
If you are not using <script setup>
, you can declare emitted events using the emits
option. You can access the emit
function as a property of the setup context (passed to setup()
as the second argument):
js
export default {
emits: ['enlarge-text'],
setup(props, ctx) {
ctx.emit('enlarge-text')
}
}
That's all you need to know about custom component events for now, but once you've finished reading this page and feel comfortable with its content, we recommend coming back later to read the full guide on Custom Events.
Content Distribution with Slots
Just like with HTML elements, it's often useful to be able to pass content to a component, like this:
template
<AlertBox>
Something bad happened.
</AlertBox>
Which might render something like:
This is an Error for Demo Purposes
Something bad happened.
This can be achieved using Vue's custom <slot>
element:
vue
<!-- AlertBox.vue -->
<template>
<div class="alert-box">
<strong>This is an Error for Demo Purposes</strong>
<slot />
</div>
</template>
<style scoped>
.alert-box {
/* ... */
}
</style>
As you'll see above, we use the <slot>
as a placeholder where we want the content to go – and that's it. We're done!
That's all you need to know about slots for now, but once you've finished reading this page and feel comfortable with its content, we recommend coming back later to read the full guide on Slots.
Dynamic Components
Sometimes, it's useful to dynamically switch between components, like in a tabbed interface:
The above is made possible by Vue's <component>
element with the special is
attribute:
template
<!-- Component changes when currentTab changes -->
<component :is="tabs[currentTab]"></component>
In the example above, the value passed to :is
can contain either:
- the name string of a registered component, OR
- the actual imported component object
You can also use the is
attribute to create regular HTML elements.
When switching between multiple components with <component :is="...">
, a component will be unmounted when it is switched away from. We can force the inactive components to stay "alive" with the built-in <KeepAlive>
component.
in-DOM Template Parsing Caveats
If you are writing your Vue templates directly in the DOM, Vue will have to retrieve the template string from the DOM. This leads to some caveats due to browsers' native HTML parsing behavior.
TIP
It should be noted that the limitations discussed below only apply if you are writing your templates directly in the DOM. They do NOT apply if you are using string templates from the following sources:
- Single-File Components
- Inlined template strings (e.g.
template: '...'
) <script type="text/x-template">
Case Insensitivity
HTML tags and attribute names are case-insensitive, so browsers will interpret any uppercase characters as lowercase. That means when you’re using in-DOM templates, PascalCase component names and camelCased prop names or v-on
event names all need to use their kebab-cased (hyphen-delimited) equivalents:
js
// camelCase in JavaScript
const BlogPost = {
props: ['postTitle'],
emits: ['updatePost'],
template: `
<h3>{{ postTitle }}</h3>
`
}
template
<!-- kebab-case in HTML -->
<blog-post post-title="hello!" @update-post="onUpdatePost"></blog-post>
Self Closing Tags
We have been using self-closing tags for components in previous code samples:
template
<MyComponent />
This is because Vue's template parser respects />
as an indication to end any tag, regardless of its type.
In in-DOM templates, however, we must always include explicit closing tags:
template
<my-component></my-component>
This is because the HTML spec only allows a few specific elements to omit closing tags, the most common being <input>
and <img>
. For all other elements, if you omit the closing tag, the native HTML parser will think you never terminated the opening tag. For example, the following snippet:
template
<my-component /> <!-- we intend to close the tag here... -->
<span>hello</span>
will be parsed as:
template
<my-component>
<span>hello</span>
</my-component> <!-- but the browser will close it here. -->
Element Placement Restrictions
Some HTML elements, such as <ul>
, <ol>
, <table>
and <select>
have restrictions on what elements can appear inside them, and some elements such as <li>
, <tr>
, and <option>
can only appear inside certain other elements.
This will lead to issues when using components with elements that have such restrictions. For example:
template
<table>
<blog-post-row></blog-post-row>
</table>
The custom component <blog-post-row>
will be hoisted out as invalid content, causing errors in the eventual rendered output. We can use the special is
attribute as a workaround:
template
<table>
<tr is="vue:blog-post-row"></tr>
</table>
TIP
When used on native HTML elements, the value of is
must be prefixed with vue:
in order to be interpreted as a Vue component. This is required to avoid confusion with native customized built-in elements.
That's all you need to know about in-DOM template parsing caveats for now - and actually, the end of Vue's Essentials. Congratulations! There's still more to learn, but first, we recommend taking a break to play with Vue yourself - build something fun, or check out some of the Examples if you haven't already.
Once you feel comfortable with the knowledge you've just digested, move on with the guide to learn more about components in depth.hhuh(hh	h}ubh)}(h}(hNh	}(h0https://vuejs.org/guide/extras/ways-of-using-vueh
Ways of Using Vue | Vue.jsuhX.  Ways of Using Vue
We believe there is no "one size fits all" story for the web. This is why Vue is designed to be flexible and incrementally adoptable. Depending on your use case, Vue can be used in different ways to strike the optimal balance between stack complexity, developer experience and end performance.
Standalone Script
Vue can be used as a standalone script file - no build step required! If you have a backend framework already rendering most of the HTML, or your frontend logic isn't complex enough to justify a build step, this is the easiest way to integrate Vue into your stack. You can think of Vue as a more declarative replacement of jQuery in such cases.
Vue also provides an alternative distribution called petite-vue that is specifically optimized for progressively enhancing existing HTML. It has a smaller feature set, but is extremely lightweight and uses an implementation that is more efficient in no-build-step scenarios.
Embedded Web Components
You can use Vue to build standard Web Components that can be embedded in any HTML page, regardless of how they are rendered. This option allows you to leverage Vue in a completely consumer-agnostic fashion: the resulting web components can be embedded in legacy applications, static HTML, or even applications built with other frameworks.
Single-Page Application (SPA)
Some applications require rich interactivity, deep session depth, and non-trivial stateful logic on the frontend. The best way to build such applications is to use an architecture where Vue not only controls the entire page, but also handles data updates and navigation without having to reload the page. This type of application is typically referred to as a Single-Page Application (SPA).
Vue provides core libraries and comprehensive tooling support with amazing developer experience for building modern SPAs, including:
- Client-side router
- Blazing fast build tool chain
- IDE support
- Browser devtools
- TypeScript integrations
- Testing utilities
SPAs typically require the backend to expose API endpoints - but you can also pair Vue with solutions like Inertia.js to get the SPA benefits while retaining a server-centric development model.
Fullstack / SSR
Pure client-side SPAs are problematic when the app is sensitive to SEO and time-to-content. This is because the browser will receive a largely empty HTML page, and has to wait until the JavaScript is loaded before rendering anything.
Vue provides first-class APIs to "render" a Vue app into HTML strings on the server. This allows the server to send back already-rendered HTML, allowing end users to see the content immediately while the JavaScript is being downloaded. Vue will then "hydrate" the application on the client side to make it interactive. This is called Server-Side Rendering (SSR) and it greatly improves Core Web Vital metrics such as Largest Contentful Paint (LCP).
There are higher-level Vue-based frameworks built on top of this paradigm, such as Nuxt, which allow you to develop a fullstack application using Vue and JavaScript.
JAMStack / SSG
Server-side rendering can be done ahead of time if the required data is static. This means we can pre-render an entire application into HTML and serve them as static files. This improves site performance and makes deployment a lot simpler since we no longer need to dynamically render pages on each request. Vue can still hydrate such applications to provide rich interactivity on the client. This technique is commonly referred to as Static-Site Generation (SSG), also known as JAMStack.
There are two flavors of SSG: single-page and multi-page. Both flavors pre-render the site into static HTML, the difference is that:
After the initial page load, a single-page SSG "hydrates" the page into an SPA. This requires more upfront JS payload and hydration cost, but subsequent navigations will be faster, since it only needs to partially update the page content instead of reloading the entire page.
A multi-page SSG loads a new page on every navigation. The upside is that it can ship minimal JS - or no JS at all if the page requires no interaction! Some multi-page SSG frameworks such as Astro also support "partial hydration" - which allows you to use Vue components to create interactive "islands" inside static HTML.
Single-page SSGs are better suited if you expect non-trivial interactivity, deep session lengths, or persisted elements / state across navigations. Otherwise, multi-page SSG would be the better choice.
The Vue team also maintains a static-site generator called VitePress, which powers this website you are reading right now! VitePress supports both flavors of SSG. Nuxt also supports SSG. You can even mix SSR and SSG for different routes in the same Nuxt app.
Beyond the Web
Although Vue is primarily designed for building web applications, it is by no means limited to just the browser. You can:
- Build desktop apps with Electron
- Build mobile apps with Ionic Vue
- Build desktop and mobile apps from the same codebase with Quasar or Tauri
- Build 3D WebGL experiences with TresJS
- Use Vue's Custom Renderer API to build custom renderers, like those for the terminal!
     hhuh(hh	h}ubh)}(h}(hNh	}(h<https://vuejs.org/guide/best-practices/production-deploymenth
Production Deployment | Vue.jsuhX  Production Deployment
Development vs. Production
During development, Vue provides a number of features to improve the development experience:
- Warning for common errors and pitfalls
- Props / events validation
- Reactivity debugging hooks
- Devtools integration
However, these features become useless in production. Some of the warning checks can also incur a small amount of performance overhead. When deploying to production, we should drop all the unused, development-only code branches for smaller payload size and better performance.
Without Build Tools
If you are using Vue without a build tool by loading it from a CDN or self-hosted script, make sure to use the production build (dist files that end in .prod.js
) when deploying to production. Production builds are pre-minified with all development-only code branches removed.
- If using global build (accessing via the
Vue
global): usevue.global.prod.js
. - If using ESM build (accessing via native ESM imports): use
vue.esm-browser.prod.js
.
Consult the dist file guide for more details.
With Build Tools
Projects scaffolded via create-vue
(based on Vite) or Vue CLI (based on webpack) are pre-configured for production builds.
If using a custom setup, make sure that:
vue
resolves tovue.runtime.esm-bundler.js
.- The compile time feature flags are properly configured.
process.env
is replaced with.NODE_ENV "production"
during build.
Additional references:
Tracking Runtime Errors
The app-level error handler can be used to report errors to tracking services:
js
import { createApp } from 'vue'
const app = createApp(...)
app.config.errorHandler = (err, instance, info) => {
// report error to tracking services
}
Services such as Sentry and Bugsnag also provide official integrations for Vue.hhuh(hh	h}ubh)}(h}(hNh	}(h/https://vuejs.org/guide/best-practices/securityh
Security | Vue.jsuhXJ"  Security
Reporting Vulnerabilities
When a vulnerability is reported, it immediately becomes our top concern, with a full-time contributor dropping everything to work on it. To report a vulnerability, please email security@vuejs.org.
While the discovery of new vulnerabilities is rare, we also recommend always using the latest versions of Vue and its official companion libraries to ensure your application remains as secure as possible.
Rule No.1: Never Use Non-trusted Templates
The most fundamental security rule when using Vue is never use non-trusted content as your component template. Doing so is equivalent to allowing arbitrary JavaScript execution in your application - and worse, could lead to server breaches if the code is executed during server-side rendering. An example of such usage:
js
Vue.createApp({
template: `<div>` + userProvidedString + `</div>` // NEVER DO THIS
}).mount('#app')
Vue templates are compiled into JavaScript, and expressions inside templates will be executed as part of the rendering process. Although the expressions are evaluated against a specific rendering context, due to the complexity of potential global execution environments, it is impractical for a framework like Vue to completely shield you from potential malicious code execution without incurring unrealistic performance overhead. The most straightforward way to avoid this category of problems altogether is to make sure the contents of your Vue templates are always trusted and entirely controlled by you.
What Vue Does to Protect You
HTML content
Whether using templates or render functions, content is automatically escaped. That means in this template:
template
<h1>{{ userProvidedString }}</h1>
if userProvidedString
contained:
js
'<script>alert("hi")</script>'
then it would be escaped to the following HTML:
template
<script>alert("hi")</script>
thus preventing the script injection. This escaping is done using native browser APIs, like textContent
, so a vulnerability can only exist if the browser itself is vulnerable.
Attribute bindings
Similarly, dynamic attribute bindings are also automatically escaped. That means in this template:
template
<h1 :title="userProvidedString">
hello
</h1>
if userProvidedString
contained:
js
'" onclick="alert(\'hi\')'
then it would be escaped to the following HTML:
template
" onclick="alert('hi')
thus preventing the close of the title
attribute to inject new, arbitrary HTML. This escaping is done using native browser APIs, like setAttribute
, so a vulnerability can only exist if the browser itself is vulnerable.
Potential Dangers
In any web application, allowing unsanitized, user-provided content to be executed as HTML, CSS, or JavaScript is potentially dangerous, so it should be avoided wherever possible. There are times when some risk may be acceptable, though.
For example, services like CodePen and JSFiddle allow user-provided content to be executed, but it's in a context where this is expected and sandboxed to some extent inside iframes. In the cases when an important feature inherently requires some level of vulnerability, it's up to your team to weigh the importance of the feature against the worst-case scenarios the vulnerability enables.
HTML Injection
As you learned earlier, Vue automatically escapes HTML content, preventing you from accidentally injecting executable HTML into your application. However, in cases where you know the HTML is safe, you can explicitly render HTML content:
Using a template:
template<div v-html="userProvidedHtml"></div>
Using a render function:
jsh('div', { innerHTML: this.userProvidedHtml })
Using a render function with JSX:
jsx<div innerHTML={this.userProvidedHtml}></div>
WARNING
User-provided HTML can never be considered 100% safe unless it's in a sandboxed iframe or in a part of the app where only the user who wrote that HTML can ever be exposed to it. Additionally, allowing users to write their own Vue templates brings similar dangers.
URL Injection
In a URL like this:
template
<a :href="userProvidedUrl">
click me
</a>
There's a potential security issue if the URL has not been "sanitized" to prevent JavaScript execution using javascript:
. There are libraries such as sanitize-url to help with this, but note: if you're ever doing URL sanitization on the frontend, you already have a security issue. User-provided URLs should always be sanitized by your backend before even being saved to a database. Then the problem is avoided for every client connecting to your API, including native mobile apps. Also note that even with sanitized URLs, Vue cannot help you guarantee that they lead to safe destinations.
Style Injection
Looking at this example:
template
<a
:href="sanitizedUrl"
:style="userProvidedStyles"
>
click me
</a>
Let's assume that sanitizedUrl
has been sanitized, so that it's definitely a real URL and not JavaScript. With the userProvidedStyles
, malicious users could still provide CSS to "click jack", e.g. styling the link into a transparent box over the "Log in" button. Then if https://user-controlled-website.com/
is built to resemble the login page of your application, they might have just captured a user's real login information.
You may be able to imagine how allowing user-provided content for a <style>
element would create an even greater vulnerability, giving that user full control over how to style the entire page. That's why Vue prevents rendering of style tags inside templates, such as:
template
<style>{{ userProvidedStyles }}</style>
To keep your users fully safe from clickjacking, we recommend only allowing full control over CSS inside a sandboxed iframe. Alternatively, when providing user control through a style binding, we recommend using its object syntax and only allowing users to provide values for specific properties it's safe for them to control, like this:
template
<a
:href="sanitizedUrl"
:style="{
color: userProvidedColor,
background: userProvidedBackground
}"
>
click me
</a>
JavaScript Injection
We strongly discourage ever rendering a <script>
element with Vue, since templates and render functions should never have side effects. However, this isn't the only way to include strings that would be evaluated as JavaScript at runtime.
Every HTML element has attributes with values accepting strings of JavaScript, such as onclick
, onfocus
, and onmouseenter
. Binding user-provided JavaScript to any of these event attributes is a potential security risk, so it should be avoided.
WARNING
User-provided JavaScript can never be considered 100% safe unless it's in a sandboxed iframe or in a part of the app where only the user who wrote that JavaScript can ever be exposed to it.
Sometimes we receive vulnerability reports on how it's possible to do cross-site scripting (XSS) in Vue templates. In general, we do not consider such cases to be actual vulnerabilities because there's no practical way to protect developers from the two scenarios that would allow XSS:
The developer is explicitly asking Vue to render user-provided, unsanitized content as Vue templates. This is inherently unsafe, and there's no way for Vue to know the origin.
The developer is mounting Vue to an entire HTML page which happens to contain server-rendered and user-provided content. This is fundamentally the same problem as #1, but sometimes devs may do it without realizing it. This can lead to possible vulnerabilities where the attacker provides HTML which is safe as plain HTML but unsafe as a Vue template. The best practice is to never mount Vue on nodes that may contain server-rendered and user-provided content.
Best Practices
The general rule is that if you allow unsanitized, user-provided content to be executed (as either HTML, JavaScript, or even CSS), you might open yourself up to attacks. This advice actually holds true whether using Vue, another framework, or even no framework.
Beyond the recommendations made above for Potential Dangers, we also recommend familiarizing yourself with these resources:
Then use what you learn to also review the source code of your dependencies for potentially dangerous patterns, if any of them include 3rd-party components or otherwise influence what's rendered to the DOM.
Backend Coordination
HTTP security vulnerabilities, such as cross-site request forgery (CSRF/XSRF) and cross-site script inclusion (XSSI), are primarily addressed on the backend, so they aren't a concern of Vue's. However, it's still a good idea to communicate with your backend team to learn how to best interact with their API, e.g., by submitting CSRF tokens with form submissions.
Server-Side Rendering (SSR)
There are some additional security concerns when using SSR, so make sure to follow the best practices outlined throughout our SSR documentation to avoid vulnerabilities.hhuh(hh	h}ubh)}(h}(hNh	}(h2https://vuejs.org/guide/best-practices/performanceh
Performance | Vue.jsuhX-  Performance
Overview
Vue is designed to be performant for most common use cases without much need for manual optimizations. However, there are always challenging scenarios where extra fine-tuning is needed. In this section, we will discuss what you should pay attention to when it comes to performance in a Vue application.
First, let's discuss the two major aspects of web performance:
Page Load Performance: how fast the application shows content and becomes interactive on the initial visit. This is usually measured using web vital metrics like Largest Contentful Paint (LCP) and First Input Delay (FID).
Update Performance: how fast the application updates in response to user input. For example, how fast a list updates when the user types in a search box, or how fast the page switches when the user clicks a navigation link in a Single-Page Application (SPA).
While it would be ideal to maximize both, different frontend architectures tend to affect how easy it is to attain desired performance in these aspects. In addition, the type of application you are building greatly influences what you should prioritize in terms of performance. Therefore, the first step of ensuring optimal performance is picking the right architecture for the type of application you are building:
Consult Ways of Using Vue to see how you can leverage Vue in different ways.
Jason Miller discusses the types of web applications and their respective ideal implementation / delivery in Application Holotypes.
Profiling Options
To improve performance, we need to first know how to measure it. There are a number of great tools that can help in this regard:
For profiling load performance of production deployments:
For profiling performance during local development:
- Chrome DevTools Performance Panel
app.config.performance
enables Vue-specific performance markers in Chrome DevTools' performance timeline.
- Vue DevTools Extension also provides a performance profiling feature.
Page Load Optimizations
There are many framework-agnostic aspects for optimizing page load performance - check out this web.dev guide for a comprehensive round up. Here, we will primarily focus on techniques that are specific to Vue.
Choosing the Right Architecture
If your use case is sensitive to page load performance, avoid shipping it as a pure client-side SPA. You want your server to be directly sending HTML containing the content the users want to see. Pure client-side rendering suffers from slow time-to-content. This can be mitigated with Server-Side Rendering (SSR) or Static Site Generation (SSG). Check out the SSR Guide to learn about performing SSR with Vue. If your app doesn't have rich interactivity requirements, you can also use a traditional backend server to render the HTML and enhance it with Vue on the client.
If your main application has to be an SPA, but has marketing pages (landing, about, blog), ship them separately! Your marketing pages should ideally be deployed as static HTML with minimal JS, by using SSG.
Bundle Size and Tree-shaking
One of the most effective ways to improve page load performance is shipping smaller JavaScript bundles. Here are a few ways to reduce bundle size when using Vue:
Use a build step if possible.
Many of Vue's APIs are "tree-shakable" if bundled via a modern build tool. For example, if you don't use the built-in
<Transition>
component, it won't be included in the final production bundle. Tree-shaking can also remove other unused modules in your source code.When using a build step, templates are pre-compiled so we don't need to ship the Vue compiler to the browser. This saves 14kb min+gzipped JavaScript and avoids the runtime compilation cost.
Be cautious of size when introducing new dependencies! In real-world applications, bloated bundles are most often a result of introducing heavy dependencies without realizing it.
If using a build step, prefer dependencies that offer ES module formats and are tree-shaking friendly. For example, prefer
lodash-es
overlodash
.Check a dependency's size and evaluate whether it is worth the functionality it provides. Note if the dependency is tree-shaking friendly, the actual size increase will depend on the APIs you actually import from it. Tools like bundlejs.com can be used for quick checks, but measuring with your actual build setup will always be the most accurate.
If you are using Vue primarily for progressive enhancement and prefer to avoid a build step, consider using petite-vue (only 6kb) instead.
Code Splitting
Code splitting is where a build tool splits the application bundle into multiple smaller chunks, which can then be loaded on demand or in parallel. With proper code splitting, features required at page load can be downloaded immediately, with additional chunks being lazy loaded only when needed, thus improving performance.
Bundlers like Rollup (which Vite is based upon) or webpack can automatically create split chunks by detecting the ESM dynamic import syntax:
js
// lazy.js and its dependencies will be split into a separate chunk
// and only loaded when `loadLazy()` is called.
function loadLazy() {
return import('./lazy.js')
}
Lazy loading is best used on features that are not immediately needed after initial page load. In Vue applications, this can be used in combination with Vue's Async Component feature to create split chunks for component trees:
js
import { defineAsyncComponent } from 'vue'
// a separate chunk is created for Foo.vue and its dependencies.
// it is only fetched on demand when the async component is
// rendered on the page.
const Foo = defineAsyncComponent(() => import('./Foo.vue'))
For applications using Vue Router, it is strongly recommended to use lazy loading for route components. Vue Router has explicit support for lazy loading, separate from defineAsyncComponent
. See Lazy Loading Routes for more details.
Update Optimizations
Props Stability
In Vue, a child component only updates when at least one of its received props has changed. Consider the following example:
template
<ListItem
v-for="item in list"
:id="item.id"
:active-id="activeId" />
Inside the <ListItem>
component, it uses its id
and activeId
props to determine whether it is the currently active item. While this works, the problem is that whenever activeId
changes, every <ListItem>
in the list has to update!
Ideally, only the items whose active status changed should update. We can achieve that by moving the active status computation into the parent, and make <ListItem>
directly accept an active
prop instead:
template
<ListItem
v-for="item in list"
:id="item.id"
:active="item.id === activeId" />
Now, for most components the active
prop will remain the same when activeId
changes, so they no longer need to update. In general, the idea is keeping the props passed to child components as stable as possible.
v-once
v-once
is a built-in directive that can be used to render content that relies on runtime data but never needs to update. The entire sub-tree it is used on will be skipped for all future updates. Consult its API reference for more details.
v-memo
v-memo
is a built-in directive that can be used to conditionally skip the update of large sub-trees or v-for
lists. Consult its API reference for more details.
Computed Stability
Starting in 3.4, a computed property will only trigger effects when its computed value has changed from the previous one. For example, the following isEven
computed only triggers effects if the returned value has changed from true
to false
, or vice-versa:
js
const count = ref(0)
const isEven = computed(() => count.value % 2 === 0)
watchEffect(() => console.log(isEven.value)) // true
// will not trigger new logs because the computed value stays `true`
count.value = 2
count.value = 4
This reduces unnecessary effect triggers, but unfortunately doesn't work if the computed creates a new object on each compute:
js
const computedObj = computed(() => {
return {
isEven: count.value % 2 === 0
}
})
Because a new object is created each time, the new value is technically always different from the old value. Even if the isEven
property remains the same, Vue won't be able to know unless it performs a deep comparison of the old value and the new value. Such comparison could be expensive and likely not worth it.
Instead, we can optimize this by manually comparing the new value with the old value, and conditionally returning the old value if we know nothing has changed:
js
const computedObj = computed((oldValue) => {
const newValue = {
isEven: count.value % 2 === 0
}
if (oldValue && oldValue.isEven === newValue.isEven) {
return oldValue
}
return newValue
})
Note that you should always perform the full computation before comparing and returning the old value, so that the same dependencies can be collected on every run.
General Optimizations
The following tips affect both page load and update performance.
Virtualize Large Lists
One of the most common performance issues in all frontend applications is rendering large lists. No matter how performant a framework is, rendering a list with thousands of items will be slow due to the sheer number of DOM nodes that the browser needs to handle.
However, we don't necessarily have to render all these nodes upfront. In most cases, the user's screen size can display only a small subset of our large list. We can greatly improve the performance with list virtualization, the technique of only rendering the items that are currently in or close to the viewport in a large list.
Implementing list virtualization isn't easy, luckily there are existing community libraries that you can directly use:
Reduce Reactivity Overhead for Large Immutable Structures
Vue's reactivity system is deep by default. While this makes state management intuitive, it does create a certain level of overhead when the data size is large, because every property access triggers proxy traps that perform dependency tracking. This typically becomes noticeable when dealing with large arrays of deeply nested objects, where a single render needs to access 100,000+ properties, so it should only affect very specific use cases.
Vue does provide an escape hatch to opt-out of deep reactivity by using shallowRef()
and shallowReactive()
. Shallow APIs create state that is reactive only at the root level, and exposes all nested objects untouched. This keeps nested property access fast, with the trade-off being that we must now treat all nested objects as immutable, and updates can only be triggered by replacing the root state:
js
const shallowArray = shallowRef([
/* big list of deep objects */
])
// this won't trigger updates...
shallowArray.value.push(newObject)
// this does:
shallowArray.value = [...shallowArray.value, newObject]
// this won't trigger updates...
shallowArray.value[0].foo = 1
// this does:
shallowArray.value = [
{
...shallowArray.value[0],
foo: 1
},
...shallowArray.value.slice(1)
]
Avoid Unnecessary Component Abstractions
Sometimes we may create renderless components or higher-order components (i.e. components that render other components with extra props) for better abstraction or code organization. While there is nothing wrong with this, do keep in mind that component instances are much more expensive than plain DOM nodes, and creating too many of them due to abstraction patterns will incur performance costs.
Note that reducing only a few instances won't have noticeable effect, so don't sweat it if the component is rendered only a few times in the app. The best scenario to consider this optimization is again in large lists. Imagine a list of 100 items where each item component contains many child components. Removing one unnecessary component abstraction here could result in a reduction of hundreds of component instances.hhuh(hh	h}ubh)}(h}(hNh	}(h1https://vuejs.org/guide/essentials/event-handlingh
Event Handling | Vue.jsuhX  Event Handling
Listening to Events
We can use the v-on
directive, which we typically shorten to the @
symbol, to listen to DOM events and run some JavaScript when they're triggered. The usage would be v-on:click="handler"
or with the shortcut, @click="handler"
.
The handler value can be one of the following:
Inline handlers: Inline JavaScript to be executed when the event is triggered (similar to the native
onclick
attribute).Method handlers: A property name or path that points to a method defined on the component.
Inline Handlers
Inline handlers are typically used in simple cases, for example:
js
const count = ref(0)
template
<button @click="count++">Add 1</button>
<p>Count is: {{ count }}</p>
Method Handlers
The logic for many event handlers will be more complex though, and likely isn't feasible with inline handlers. That's why v-on
can also accept the name or path of a component method you'd like to call.
For example:
js
const name = ref('Vue.js')
function greet(event) {
alert(`Hello ${name.value}!`)
// `event` is the native DOM event
if (event) {
alert(event.target.tagName)
}
}
template
<!-- `greet` is the name of the method defined above -->
<button @click="greet">Greet</button>
A method handler automatically receives the native DOM Event object that triggers it - in the example above, we are able to access the element dispatching the event via event.target
.
See also: Typing Event Handlers
Method vs. Inline Detection
The template compiler detects method handlers by checking whether the v-on
value string is a valid JavaScript identifier or property access path. For example, foo
, foo.bar
and foo['bar']
are treated as method handlers, while foo()
and count++
are treated as inline handlers.
Calling Methods in Inline Handlers
Instead of binding directly to a method name, we can also call methods in an inline handler. This allows us to pass the method custom arguments instead of the native event:
js
function say(message) {
alert(message)
}
template
<button @click="say('hello')">Say hello</button>
<button @click="say('bye')">Say bye</button>
Accessing Event Argument in Inline Handlers
Sometimes we also need to access the original DOM event in an inline handler. You can pass it into a method using the special $event
variable, or use an inline arrow function:
template
<!-- using $event special variable -->
<button @click="warn('Form cannot be submitted yet.', $event)">
Submit
</button>
<!-- using inline arrow function -->
<button @click="(event) => warn('Form cannot be submitted yet.', event)">
Submit
</button>
js
function warn(message, event) {
// now we have access to the native event
if (event) {
event.preventDefault()
}
alert(message)
}
Event Modifiers
It is a very common need to call event.preventDefault()
or event.stopPropagation()
inside event handlers. Although we can do this easily inside methods, it would be better if the methods can be purely about data logic rather than having to deal with DOM event details.
To address this problem, Vue provides event modifiers for v-on
. Recall that modifiers are directive postfixes denoted by a dot.
.stop
.prevent
.self
.capture
.once
.passive
template
<!-- the click event's propagation will be stopped -->
<a @click.stop="doThis"></a>
<!-- the submit event will no longer reload the page -->
<form @submit.prevent="onSubmit"></form>
<!-- modifiers can be chained -->
<a @click.stop.prevent="doThat"></a>
<!-- just the modifier -->
<form @submit.prevent></form>
<!-- only trigger handler if event.target is the element itself -->
<!-- i.e. not from a child element -->
<div @click.self="doThat">...</div>
TIP
Order matters when using modifiers because the relevant code is generated in the same order. Therefore using @click.prevent.self
will prevent click's default action on the element itself and its children, while @click.self.prevent
will only prevent click's default action on the element itself.
The .capture
, .once
, and .passive
modifiers mirror the options of the native addEventListener
method:
template
<!-- use capture mode when adding the event listener -->
<!-- i.e. an event targeting an inner element is handled -->
<!-- here before being handled by that element -->
<div @click.capture="doThis">...</div>
<!-- the click event will be triggered at most once -->
<a @click.once="doThis"></a>
<!-- the scroll event's default behavior (scrolling) will happen -->
<!-- immediately, instead of waiting for `onScroll` to complete -->
<!-- in case it contains `event.preventDefault()` -->
<div @scroll.passive="onScroll">...</div>
The .passive
modifier is typically used with touch event listeners for improving performance on mobile devices.
TIP
Do not use .passive
and .prevent
together, because .passive
already indicates to the browser that you do not intend to prevent the event's default behavior, and you will likely see a warning from the browser if you do so.
Key Modifiers
When listening for keyboard events, we often need to check for specific keys. Vue allows adding key modifiers for v-on
or @
when listening for key events:
template
<!-- only call `submit` when the `key` is `Enter` -->
<input @keyup.enter="submit" />
You can directly use any valid key names exposed via KeyboardEvent.key
as modifiers by converting them to kebab-case.
template
<input @keyup.page-down="onPageDown" />
In the above example, the handler will only be called if $event.key
is equal to 'PageDown'
.
Key Aliases
Vue provides aliases for the most commonly used keys:
.enter
.tab
.delete
(captures both "Delete" and "Backspace" keys).esc
.space
.up
.down
.left
.right
System Modifier Keys
You can use the following modifiers to trigger mouse or keyboard event listeners only when the corresponding modifier key is pressed:
.ctrl
.alt
.shift
.meta
Note
On Macintosh keyboards, meta is the command key (⌘). On Windows keyboards, meta is the Windows key (⊞). On Sun Microsystems keyboards, meta is marked as a solid diamond (◆). On certain keyboards, specifically MIT and Lisp machine keyboards and successors, such as the Knight keyboard, space-cadet keyboard, meta is labeled “META”. On Symbolics keyboards, meta is labeled “META” or “Meta”.
For example:
template
<!-- Alt + Enter -->
<input @keyup.alt.enter="clear" />
<!-- Ctrl + Click -->
<div @click.ctrl="doSomething">Do something</div>
TIP
Note that modifier keys are different from regular keys and when used with keyup
events, they have to be pressed when the event is emitted. In other words, keyup.ctrl
will only trigger if you release a key while holding down ctrl
. It won't trigger if you release the ctrl
key alone.
.exact
Modifier
The .exact
modifier allows control of the exact combination of system modifiers needed to trigger an event.
template
<!-- this will fire even if Alt or Shift is also pressed -->
<button @click.ctrl="onClick">A</button>
<!-- this will only fire when Ctrl and no other keys are pressed -->
<button @click.ctrl.exact="onCtrlClick">A</button>
<!-- this will only fire when no system modifiers are pressed -->
<button @click.exact="onClick">A</button>
Mouse Button Modifiers
.left
.right
.middle
These modifiers restrict the handler to events triggered by a specific mouse button.hhuh(hh	h}ubh)}(h}(hNh	}(h2https://vuejs.org/guide/essentials/template-syntaxh
Template Syntax | Vue.jsuhX:*  Template Syntax
Vue uses an HTML-based template syntax that allows you to declaratively bind the rendered DOM to the underlying component instance's data. All Vue templates are syntactically valid HTML that can be parsed by spec-compliant browsers and HTML parsers.
Under the hood, Vue compiles the templates into highly-optimized JavaScript code. Combined with the reactivity system, Vue can intelligently figure out the minimal number of components to re-render and apply the minimal amount of DOM manipulations when the app state changes.
If you are familiar with Virtual DOM concepts and prefer the raw power of JavaScript, you can also directly write render functions instead of templates, with optional JSX support. However, do note that they do not enjoy the same level of compile-time optimizations as templates.
Text Interpolation
The most basic form of data binding is text interpolation using the "Mustache" syntax (double curly braces):
template
<span>Message: {{ msg }}</span>
The mustache tag will be replaced with the value of the msg
property from the corresponding component instance. It will also be updated whenever the msg
property changes.
Raw HTML
The double mustaches interpret the data as plain text, not HTML. In order to output real HTML, you will need to use the v-html
directive:
template
<p>Using text interpolation: {{ rawHtml }}</p>
<p>Using v-html directive: <span v-html="rawHtml"></span></p>
Using text interpolation: <span style="color: red">This should be red.</span>
Using v-html directive: This should be red.
Here we're encountering something new. The v-html
attribute you're seeing is called a directive. Directives are prefixed with v-
to indicate that they are special attributes provided by Vue, and as you may have guessed, they apply special reactive behavior to the rendered DOM. Here, we're basically saying "keep this element's inner HTML up-to-date with the rawHtml
property on the current active instance."
The contents of the span
will be replaced with the value of the rawHtml
property, interpreted as plain HTML - data bindings are ignored. Note that you cannot use v-html
to compose template partials, because Vue is not a string-based templating engine. Instead, components are preferred as the fundamental unit for UI reuse and composition.
Security Warning
Dynamically rendering arbitrary HTML on your website can be very dangerous because it can easily lead to XSS vulnerabilities. Only use v-html
on trusted content and never on user-provided content.
Attribute Bindings
Mustaches cannot be used inside HTML attributes. Instead, use a v-bind
directive:
template
<div v-bind:id="dynamicId"></div>
The v-bind
directive instructs Vue to keep the element's id
attribute in sync with the component's dynamicId
property. If the bound value is null
or undefined
, then the attribute will be removed from the rendered element.
Shorthand
Because v-bind
is so commonly used, it has a dedicated shorthand syntax:
template
<div :id="dynamicId"></div>
Attributes that start with :
may look a bit different from normal HTML, but it is in fact a valid character for attribute names and all Vue-supported browsers can parse it correctly. In addition, they do not appear in the final rendered markup. The shorthand syntax is optional, but you will likely appreciate it when you learn more about its usage later.
For the rest of the guide, we will be using the shorthand syntax in code examples, as that's the most common usage for Vue developers.
Same-name Shorthand
If the attribute has the same name with the JavaScript value being bound, the syntax can be further shortened to omit the attribute value:
template
<!-- same as :id="id" -->
<div :id></div>
<!-- this also works -->
<div v-bind:id></div>
This is similar to the property shorthand syntax when declaring objects in JavaScript. Note this is a feature that is only available in Vue 3.4 and above.
Boolean Attributes
Boolean attributes are attributes that can indicate true / false values by their presence on an element. For example, disabled
is one of the most commonly used boolean attributes.
v-bind
works a bit differently in this case:
template
<button :disabled="isButtonDisabled">Button</button>
The disabled
attribute will be included if isButtonDisabled
has a truthy value. It will also be included if the value is an empty string, maintaining consistency with <button disabled="">
. For other falsy values the attribute will be omitted.
Dynamically Binding Multiple Attributes
If you have a JavaScript object representing multiple attributes that looks like this:
js
const objectOfAttrs = {
id: 'container',
class: 'wrapper',
style: 'background-color:green'
}
You can bind them to a single element by using v-bind
without an argument:
template
<div v-bind="objectOfAttrs"></div>
Using JavaScript Expressions
So far we've only been binding to simple property keys in our templates. But Vue actually supports the full power of JavaScript expressions inside all data bindings:
template
{{ number + 1 }}
{{ ok ? 'YES' : 'NO' }}
{{ message.split('').reverse().join('') }}
<div :id="`list-${id}`"></div>
These expressions will be evaluated as JavaScript in the data scope of the current component instance.
In Vue templates, JavaScript expressions can be used in the following positions:
- Inside text interpolations (mustaches)
- In the attribute value of any Vue directives (special attributes that start with
v-
)
Expressions Only
Each binding can only contain one single expression. An expression is a piece of code that can be evaluated to a value. A simple check is whether it can be used after return
.
Therefore, the following will NOT work:
template
<!-- this is a statement, not an expression: -->
{{ var a = 1 }}
<!-- flow control won't work either, use ternary expressions -->
{{ if (ok) { return message } }}
Calling Functions
It is possible to call a component-exposed method inside a binding expression:
template
<time :title="toTitleDate(date)" :datetime="date">
{{ formatDate(date) }}
</time>
TIP
Functions called inside binding expressions will be called every time the component updates, so they should not have any side effects, such as changing data or triggering asynchronous operations.
Restricted Globals Access
Template expressions are sandboxed and only have access to a restricted list of globals. The list exposes commonly used built-in globals such as Math
and Date
.
Globals not explicitly included in the list, for example user-attached properties on window
, will not be accessible in template expressions. You can, however, explicitly define additional globals for all Vue expressions by adding them to app.config.globalProperties
.
Directives
Directives are special attributes with the v-
prefix. Vue provides a number of built-in directives, including v-html
and v-bind
which we have introduced above.
Directive attribute values are expected to be single JavaScript expressions (with the exception of v-for
, v-on
and v-slot
, which will be discussed in their respective sections later). A directive's job is to reactively apply updates to the DOM when the value of its expression changes. Take v-if
as an example:
template
<p v-if="seen">Now you see me</p>
Here, the v-if
directive would remove / insert the <p>
element based on the truthiness of the value of the expression seen
.
Arguments
Some directives can take an "argument", denoted by a colon after the directive name. For example, the v-bind
directive is used to reactively update an HTML attribute:
template
<a v-bind:href="url"> ... </a>
<!-- shorthand -->
<a :href="url"> ... </a>
Here, href
is the argument, which tells the v-bind
directive to bind the element's href
attribute to the value of the expression url
. In the shorthand, everything before the argument (i.e., v-bind:
) is condensed into a single character, :
.
Another example is the v-on
directive, which listens to DOM events:
template
<a v-on:click="doSomething"> ... </a>
<!-- shorthand -->
<a @click="doSomething"> ... </a>
Here, the argument is the event name to listen to: click
. v-on
has a corresponding shorthand, namely the @
character. We will talk about event handling in more detail too.
Dynamic Arguments
It is also possible to use a JavaScript expression in a directive argument by wrapping it with square brackets:
template
<!--
Note that there are some constraints to the argument expression,
as explained in the "Dynamic Argument Value Constraints" and "Dynamic Argument Syntax Constraints" sections below.
-->
<a v-bind:[attributeName]="url"> ... </a>
<!-- shorthand -->
<a :[attributeName]="url"> ... </a>
Here, attributeName
will be dynamically evaluated as a JavaScript expression, and its evaluated value will be used as the final value for the argument. For example, if your component instance has a data property, attributeName
, whose value is "href"
, then this binding will be equivalent to v-bind:href
.
Similarly, you can use dynamic arguments to bind a handler to a dynamic event name:
template
<a v-on:[eventName]="doSomething"> ... </a>
<!-- shorthand -->
<a @[eventName]="doSomething"> ... </a>
In this example, when eventName
's value is "focus"
, v-on:[eventName]
will be equivalent to v-on:focus
.
Dynamic Argument Value Constraints
Dynamic arguments are expected to evaluate to a string, with the exception of null
. The special value null
can be used to explicitly remove the binding. Any other non-string value will trigger a warning.
Dynamic Argument Syntax Constraints
Dynamic argument expressions have some syntax constraints because certain characters, such as spaces and quotes, are invalid inside HTML attribute names. For example, the following is invalid:
template
<!-- This will trigger a compiler warning. -->
<a :['foo' + bar]="value"> ... </a>
If you need to pass a complex dynamic argument, it's probably better to use a computed property, which we will cover shortly.
When using in-DOM templates (templates directly written in an HTML file), you should also avoid naming keys with uppercase characters, as browsers will coerce attribute names into lowercase:
template
<a :[someAttr]="value"> ... </a>
The above will be converted to :[someattr]
in in-DOM templates. If your component has a someAttr
property instead of someattr
, your code won't work. Templates inside Single-File Components are not subject to this constraint.
Modifiers
Modifiers are special postfixes denoted by a dot, which indicate that a directive should be bound in some special way. For example, the .prevent
modifier tells the v-on
directive to call event.preventDefault()
on the triggered event:
template
<form @submit.prevent="onSubmit">...</form>
You'll see other examples of modifiers later, for v-on
and for v-model
, when we explore those features.
And finally, here's the full directive syntax visualized:hhuh(hh	h}ubh)}(h}(hNh	}(h.https://vuejs.org/guide/essentials/conditionalh
Conditional Rendering | Vue.jsuhX
  Conditional Rendering
v-if
The directive v-if
is used to conditionally render a block. The block will only be rendered if the directive's expression returns a truthy value.
template
<h1 v-if="awesome">Vue is awesome!</h1>
v-else
You can use the v-else
directive to indicate an "else block" for v-if
:
template
<button @click="awesome = !awesome">Toggle</button>
<h1 v-if="awesome">Vue is awesome!</h1>
<h1 v-else>Oh no 😢</h1>
Vue is awesome!
A v-else
element must immediately follow a v-if
or a v-else-if
element - otherwise it will not be recognized.
v-else-if
The v-else-if
, as the name suggests, serves as an "else if block" for v-if
. It can also be chained multiple times:
template
<div v-if="type === 'A'">
A
</div>
<div v-else-if="type === 'B'">
B
</div>
<div v-else-if="type === 'C'">
C
</div>
<div v-else>
Not A/B/C
</div>
Similar to v-else
, a v-else-if
element must immediately follow a v-if
or a v-else-if
element.
v-if
on <template>
Because v-if
is a directive, it has to be attached to a single element. But what if we want to toggle more than one element? In this case we can use v-if
on a <template>
element, which serves as an invisible wrapper. The final rendered result will not include the <template>
element.
template
<template v-if="ok">
<h1>Title</h1>
<p>Paragraph 1</p>
<p>Paragraph 2</p>
</template>
v-else
and v-else-if
can also be used on <template>
.
v-show
Another option for conditionally displaying an element is the v-show
directive. The usage is largely the same:
template
<h1 v-show="ok">Hello!</h1>
The difference is that an element with v-show
will always be rendered and remain in the DOM; v-show
only toggles the display
CSS property of the element.
v-show
doesn't support the <template>
element, nor does it work with v-else
.
v-if
vs. v-show
v-if
is "real" conditional rendering because it ensures that event listeners and child components inside the conditional block are properly destroyed and re-created during toggles.
v-if
is also lazy: if the condition is false on initial render, it will not do anything - the conditional block won't be rendered until the condition becomes true for the first time.
In comparison, v-show
is much simpler - the element is always rendered regardless of initial condition, with CSS-based toggling.
Generally speaking, v-if
has higher toggle costs while v-show
has higher initial render costs. So prefer v-show
if you need to toggle something very often, and prefer v-if
if the condition is unlikely to change at runtime.
v-if
with v-for
Note
It's not recommended to use v-if
and v-for
on the same element due to implicit precedence. Refer to style guide for details.
When v-if
and v-for
are both used on the same element, v-if
will be evaluated first. See the list rendering guide for details.hhuh(hh	h}ubh)}(h}(hNh	}(h5https://vuejs.org/guide/reusability/custom-directivesh
Custom Directives | Vue.jsuhX  Custom Directives
Introduction
In addition to the default set of directives shipped in core (like v-model
or v-show
), Vue also allows you to register your own custom directives.
We have introduced two forms of code reuse in Vue: components and composables. Components are the main building blocks, while composables are focused on reusing stateful logic. Custom directives, on the other hand, are mainly intended for reusing logic that involves low-level DOM access on plain elements.
A custom directive is defined as an object containing lifecycle hooks similar to those of a component. The hooks receive the element the directive is bound to. Here is an example of a directive that focuses an input when the element is inserted into the DOM by Vue:
vue
<script setup>
// enables v-focus in templates
const vFocus = {
mounted: (el) => el.focus()
}
</script>
<template>
<input v-focus />
</template>
Assuming you haven't clicked elsewhere on the page, the input above should be auto-focused. This directive is more useful than the autofocus
attribute because it works not just on page load - it also works when the element is dynamically inserted by Vue.
In <script setup>
, any camelCase variable that starts with the v
prefix can be used as a custom directive. In the example above, vFocus
can be used in the template as v-focus
.
If not using <script setup>
, custom directives can be registered using the directives
option:
js
export default {
setup() {
/*...*/
},
directives: {
// enables v-focus in template
focus: {
/* ... */
}
}
}
It is also common to globally register custom directives at the app level:
js
const app = createApp({})
// make v-focus usable in all components
app.directive('focus', {
/* ... */
})
TIP
Custom directives should only be used when the desired functionality can only be achieved via direct DOM manipulation. Prefer declarative templating using built-in directives such as v-bind
when possible because they are more efficient and server-rendering friendly.
Directive Hooks
A directive definition object can provide several hook functions (all optional):
js
const myDirective = {
// called before bound element's attributes
// or event listeners are applied
created(el, binding, vnode) {
// see below for details on arguments
},
// called right before the element is inserted into the DOM.
beforeMount(el, binding, vnode) {},
// called when the bound element's parent component
// and all its children are mounted.
mounted(el, binding, vnode) {},
// called before the parent component is updated
beforeUpdate(el, binding, vnode, prevVnode) {},
// called after the parent component and
// all of its children have updated
updated(el, binding, vnode, prevVnode) {},
// called before the parent component is unmounted
beforeUnmount(el, binding, vnode) {},
// called when the parent component is unmounted
unmounted(el, binding, vnode) {}
}
Hook Arguments
Directive hooks are passed these arguments:
el
: the element the directive is bound to. This can be used to directly manipulate the DOM.binding
: an object containing the following properties.value
: The value passed to the directive. For example inv-my-directive="1 + 1"
, the value would be2
.oldValue
: The previous value, only available inbeforeUpdate
andupdated
. It is available whether or not the value has changed.arg
: The argument passed to the directive, if any. For example inv-my-directive:foo
, the arg would be"foo"
.modifiers
: An object containing modifiers, if any. For example inv-my-directive.foo.bar
, the modifiers object would be{ foo: true, bar: true }
.instance
: The instance of the component where the directive is used.dir
: the directive definition object.
vnode
: the underlying VNode representing the bound element.prevVnode
: the VNode representing the bound element from the previous render. Only available in thebeforeUpdate
andupdated
hooks.
As an example, consider the following directive usage:
template
<div v-example:foo.bar="baz">
The binding
argument would be an object in the shape of:
js
{
arg: 'foo',
modifiers: { bar: true },
value: /* value of `baz` */,
oldValue: /* value of `baz` from previous update */
}
Similar to built-in directives, custom directive arguments can be dynamic. For example:
template
<div v-example:[arg]="value"></div>
Here the directive argument will be reactively updated based on arg
property in our component state.
Note
Apart from el
, you should treat these arguments as read-only and never modify them. If you need to share information across hooks, it is recommended to do so through element's dataset.
Function Shorthand
It's common for a custom directive to have the same behavior for mounted
and updated
, with no need for the other hooks. In such cases we can define the directive as a function:
template
<div v-color="color"></div>
js
app.directive('color', (el, binding) => {
// this will be called for both `mounted` and `updated`
el.style.color = binding.value
})
Object Literals
If your directive needs multiple values, you can also pass in a JavaScript object literal. Remember, directives can take any valid JavaScript expression.
template
<div v-demo="{ color: 'white', text: 'hello!' }"></div>
js
app.directive('demo', (el, binding) => {
console.log(binding.value.color) // => "white"
console.log(binding.value.text) // => "hello!"
})
Usage on Components
Not recommended
Using custom directives on components is not recommended. Unexpected behaviour may occur when a component has multiple root nodes.
When used on components, custom directives will always apply to a component's root node, similar to Fallthrough Attributes.
template
<MyComponent v-demo="test" />
template
<!-- template of MyComponent -->
<div> <!-- v-demo directive will be applied here -->
<span>My component content</span>
</div>
Note that components can potentially have more than one root node. When applied to a multi-root component, a directive will be ignored and a warning will be thrown. Unlike attributes, directives can't be passed to a different element with v-bind="$attrs"
.hhuh(hh	h}ubh)}(h}(hNh	}(h*https://vuejs.org/guide/components/v-modelh
Component v-model | Vue.jsuhX  Component v-model
Basic Usage
v-model
can be used on a component to implement a two-way binding.
Starting in Vue 3.4, the recommended approach to achieve this is using the defineModel()
macro:
vue
<!-- Child.vue -->
<script setup>
const model = defineModel()
function update() {
model.value++
}
</script>
<template>
<div>Parent bound v-model is: {{ model }}</div>
<button @click="update">Increment</button>
</template>
The parent can then bind a value with v-model
:
template
<!-- Parent.vue -->
<Child v-model="countModel" />
The value returned by defineModel()
is a ref. It can be accessed and mutated like any other ref, except that it acts as a two-way binding between a parent value and a local one:
- Its
.value
is synced with the value bound by the parentv-model
; - When it is mutated by the child, it causes the parent bound value to be updated as well.
This means you can also bind this ref to a native input element with v-model
, making it straightforward to wrap native input elements while providing the same v-model
usage:
vue
<script setup>
const model = defineModel()
</script>
<template>
<input v-model="model" />
</template>
Under the Hood
defineModel
is a convenience macro. The compiler expands it to the following:
- A prop named
modelValue
, which the local ref's value is synced with; - An event named
update:modelValue
, which is emitted when the local ref's value is mutated.
This is how you would implement the same child component shown above prior to 3.4:
vue
<!-- Child.vue -->
<script setup>
const props = defineProps(['modelValue'])
const emit = defineEmits(['update:modelValue'])
</script>
<template>
<input
:value="props.modelValue"
@input="emit('update:modelValue', $event.target.value)"
/>
</template>
Then, v-model="foo"
in the parent component will be compiled to:
template
<!-- Parent.vue -->
<Child
:modelValue="foo"
@update:modelValue="$event => (foo = $event)"
/>
As you can see, it is quite a bit more verbose. However, it is helpful to understand what is happening under the hood.
Because defineModel
declares a prop, you can therefore declare the underlying prop's options by passing it to defineModel
:
js
// making the v-model required
const model = defineModel({ required: true })
// providing a default value
const model = defineModel({ default: 0 })
WARNING
If you have a default
value for defineModel
prop and you don't provide any value for this prop from the parent component, it can cause a de-synchronization between parent and child components. In the example below, the parent's myRef
is undefined, but the child's model
is 1:
js
// child component:
const model = defineModel({ default: 1 })
// parent component:
const myRef = ref()
html
<Child v-model="myRef"></Child>
v-model
arguments
v-model
on a component can also accept an argument:
template
<MyComponent v-model:title="bookTitle" />
In the child component, we can support the corresponding argument by passing a string to defineModel()
as its first argument:
vue
<!-- MyComponent.vue -->
<script setup>
const title = defineModel('title')
</script>
<template>
<input type="text" v-model="title" />
</template>
If prop options are also needed, they should be passed after the model name:
js
const title = defineModel('title', { required: true })
Pre 3.4 Usage
vue
<!-- MyComponent.vue -->
<script setup>
defineProps({
title: {
required: true
}
})
defineEmits(['update:title'])
</script>
<template>
<input
type="text"
:value="title"
@input="$emit('update:title', $event.target.value)"
/>
</template>
Multiple v-model
bindings
By leveraging the ability to target a particular prop and event as we learned before with v-model
arguments, we can now create multiple v-model
bindings on a single component instance.
Each v-model
will sync to a different prop, without the need for extra options in the component:
template
<UserName
v-model:first-name="first"
v-model:last-name="last"
/>
vue
<script setup>
const firstName = defineModel('firstName')
const lastName = defineModel('lastName')
</script>
<template>
<input type="text" v-model="firstName" />
<input type="text" v-model="lastName" />
</template>
Pre 3.4 Usage
vue
<script setup>
defineProps({
firstName: String,
lastName: String
})
defineEmits(['update:firstName', 'update:lastName'])
</script>
<template>
<input
type="text"
:value="firstName"
@input="$emit('update:firstName', $event.target.value)"
/>
<input
type="text"
:value="lastName"
@input="$emit('update:lastName', $event.target.value)"
/>
</template>
Handling v-model
modifiers
When we were learning about form input bindings, we saw that v-model
has built-in modifiers - .trim
, .number
and .lazy
. In some cases, you might also want the v-model
on your custom input component to support custom modifiers.
Let's create an example custom modifier, capitalize
, that capitalizes the first letter of the string provided by the v-model
binding:
template
<MyComponent v-model.capitalize="myText" />
Modifiers added to a component v-model
can be accessed in the child component by destructuring the defineModel()
return value like this:
vue
<script setup>
const [model, modifiers] = defineModel()
console.log(modifiers) // { capitalize: true }
</script>
<template>
<input type="text" v-model="model" />
</template>
To conditionally adjust how the value should be read / written based on modifiers, we can pass get
and set
options to defineModel()
. These two options receive the value on get / set of the model ref and should return a transformed value. This is how we can use the set
option to implement the capitalize
modifier:
vue
<script setup>
const [model, modifiers] = defineModel({
set(value) {
if (modifiers.capitalize) {
return value.charAt(0).toUpperCase() + value.slice(1)
}
return value
}
})
</script>
<template>
<input type="text" v-model="model" />
</template>
Pre 3.4 Usage
vue
<script setup>
const props = defineProps({
modelValue: String,
modelModifiers: { default: () => ({}) }
})
const emit = defineEmits(['update:modelValue'])
function emitValue(e) {
let value = e.target.value
if (props.modelModifiers.capitalize) {
value = value.charAt(0).toUpperCase() + value.slice(1)
}
emit('update:modelValue', value)
}
</script>
<template>
<input type="text" :value="modelValue" @input="emitValue" />
</template>
Modifiers for v-model
with arguments
Here's another example of using modifiers with multiple v-model
with different arguments:
template
<UserName
v-model:first-name.capitalize="first"
v-model:last-name.uppercase="last"
/>
vue
<script setup>
const [firstName, firstNameModifiers] = defineModel('firstName')
const [lastName, lastNameModifiers] = defineModel('lastName')
console.log(firstNameModifiers) // { capitalize: true }
console.log(lastNameModifiers) // { uppercase: true }
</script>
Pre 3.4 Usage
vue
<script setup>
const props = defineProps({
firstName: String,
lastName: String,
firstNameModifiers: { default: () => ({}) },
lastNameModifiers: { default: () => ({}) }
})
defineEmits(['update:firstName', 'update:lastName'])
console.log(props.firstNameModifiers) // { capitalize: true }
console.log(props.lastNameModifiers) // { uppercase: true }
</script>hhuh(hh	h}ubh)}(h}(hNh	}(h2https://vuejs.org/guide/typescript/composition-apih
(TypeScript with Composition API | Vue.jsuhXH-  TypeScript with Composition API
This page assumes you've already read the overview on Using Vue with TypeScript.
Typing Component Props
Using <script setup>
When using <script setup>
, the defineProps()
macro supports inferring the props types based on its argument:
vue
<script setup lang="ts">
const props = defineProps({
foo: { type: String, required: true },
bar: Number
})
props.foo // string
props.bar // number | undefined
</script>
This is called "runtime declaration", because the argument passed to defineProps()
will be used as the runtime props
option.
However, it is usually more straightforward to define props with pure types via a generic type argument:
vue
<script setup lang="ts">
const props = defineProps<{
foo: string
bar?: number
}>()
</script>
This is called "type-based declaration". The compiler will try to do its best to infer the equivalent runtime options based on the type argument. In this case, our second example compiles into the exact same runtime options as the first example.
You can use either type-based declaration OR runtime declaration, but you cannot use both at the same time.
We can also move the props types into a separate interface:
vue
<script setup lang="ts">
interface Props {
foo: string
bar?: number
}
const props = defineProps<Props>()
</script>
This also works if Props
is imported from an external source. This feature requires TypeScript to be a peer dependency of Vue.
vue
<script setup lang="ts">
import type { Props } from './foo'
const props = defineProps<Props>()
</script>
Syntax Limitations
In version 3.2 and below, the generic type parameter for defineProps()
were limited to a type literal or a reference to a local interface.
This limitation has been resolved in 3.3. The latest version of Vue supports referencing imported and a limited set of complex types in the type parameter position. However, because the type to runtime conversion is still AST-based, some complex types that require actual type analysis, e.g. conditional types, are not supported. You can use conditional types for the type of a single prop, but not the entire props object.
Props Default Values
When using type-based declaration, we lose the ability to declare default values for the props. This can be resolved by the withDefaults
compiler macro:
ts
export interface Props {
msg?: string
labels?: string[]
}
const props = withDefaults(defineProps<Props>(), {
msg: 'hello',
labels: () => ['one', 'two']
})
This will be compiled to equivalent runtime props default
options. In addition, the withDefaults
helper provides type checks for the default values, and ensures the returned props
type has the optional flags removed for properties that do have default values declared.
INFO
Note that default values for mutable reference types (like arrays or objects) should be wrapped in functions to avoid accidental modification and external side effects. This ensures each component instance gets its own copy of the default value.
Without <script setup>
If not using <script setup>
, it is necessary to use defineComponent()
to enable props type inference. The type of the props object passed to setup()
is inferred from the props
option.
ts
import { defineComponent } from 'vue'
export default defineComponent({
props: {
message: String
},
setup(props) {
props.message // <-- type: string
}
})
Complex prop types
With type-based declaration, a prop can use a complex type much like any other type:
vue
<script setup lang="ts">
interface Book {
title: string
author: string
year: number
}
const props = defineProps<{
book: Book
}>()
</script>
For runtime declaration, we can use the PropType
utility type:
ts
import type { PropType } from 'vue'
const props = defineProps({
book: Object as PropType<Book>
})
This works in much the same way if we're specifying the props
option directly:
ts
import { defineComponent } from 'vue'
import type { PropType } from 'vue'
export default defineComponent({
props: {
book: Object as PropType<Book>
}
})
The props
option is more commonly used with the Options API, so you'll find more detailed examples in the guide to TypeScript with Options API. The techniques shown in those examples also apply to runtime declarations using defineProps()
.
Typing Component Emits
In <script setup>
, the emit
function can also be typed using either runtime declaration OR type declaration:
vue
<script setup lang="ts">
// runtime
const emit = defineEmits(['change', 'update'])
// options based
const emit = defineEmits({
change: (id: number) => {
// return `true` or `false` to indicate
// validation pass / fail
},
update: (value: string) => {
// return `true` or `false` to indicate
// validation pass / fail
}
})
// type-based
const emit = defineEmits<{
(e: 'change', id: number): void
(e: 'update', value: string): void
}>()
// 3.3+: alternative, more succinct syntax
const emit = defineEmits<{
change: [id: number]
update: [value: string]
}>()
</script>
The type argument can be one of the following:
- A callable function type, but written as a type literal with Call Signatures. It will be used as the type of the returned
emit
function. - A type literal where the keys are the event names, and values are array / tuple types representing the additional accepted parameters for the event. The example above is using named tuples so each argument can have an explicit name.
As we can see, the type declaration gives us much finer-grained control over the type constraints of emitted events.
When not using <script setup>
, defineComponent()
is able to infer the allowed events for the emit
function exposed on the setup context:
ts
import { defineComponent } from 'vue'
export default defineComponent({
emits: ['change'],
setup(props, { emit }) {
emit('change') // <-- type check / auto-completion
}
})
Typing ref()
Refs infer the type from the initial value:
ts
import { ref } from 'vue'
// inferred type: Ref<number>
const year = ref(2020)
// => TS Error: Type 'string' is not assignable to type 'number'.
year.value = '2020'
Sometimes we may need to specify complex types for a ref's inner value. We can do that by using the Ref
type:
ts
import { ref } from 'vue'
import type { Ref } from 'vue'
const year: Ref<string | number> = ref('2020')
year.value = 2020 // ok!
Or, by passing a generic argument when calling ref()
to override the default inference:
ts
// resulting type: Ref<string | number>
const year = ref<string | number>('2020')
year.value = 2020 // ok!
If you specify a generic type argument but omit the initial value, the resulting type will be a union type that includes undefined
:
ts
// inferred type: Ref<number | undefined>
const n = ref<number>()
Typing reactive()
reactive()
also implicitly infers the type from its argument:
ts
import { reactive } from 'vue'
// inferred type: { title: string }
const book = reactive({ title: 'Vue 3 Guide' })
To explicitly type a reactive
property, we can use interfaces:
ts
import { reactive } from 'vue'
interface Book {
title: string
year?: number
}
const book: Book = reactive({ title: 'Vue 3 Guide' })
TIP
It's not recommended to use the generic argument of reactive()
because the returned type, which handles nested ref unwrapping, is different from the generic argument type.
Typing computed()
computed()
infers its type based on the getter's return value:
ts
import { ref, computed } from 'vue'
const count = ref(0)
// inferred type: ComputedRef<number>
const double = computed(() => count.value * 2)
// => TS Error: Property 'split' does not exist on type 'number'
const result = double.value.split('')
You can also specify an explicit type via a generic argument:
ts
const double = computed<number>(() => {
// type error if this doesn't return a number
})
Typing Event Handlers
When dealing with native DOM events, it might be useful to type the argument we pass to the handler correctly. Let's take a look at this example:
vue
<script setup lang="ts">
function handleChange(event) {
// `event` implicitly has `any` type
console.log(event.target.value)
}
</script>
<template>
<input type="text" @change="handleChange" />
</template>
Without type annotation, the event
argument will implicitly have a type of any
. This will also result in a TS error if "strict": true
or "noImplicitAny": true
are used in tsconfig.json
. It is therefore recommended to explicitly annotate the argument of event handlers. In addition, you may need to use type assertions when accessing the properties of event
:
ts
function handleChange(event: Event) {
console.log((event.target as HTMLInputElement).value)
}
Typing Provide / Inject
Provide and inject are usually performed in separate components. To properly type injected values, Vue provides an InjectionKey
interface, which is a generic type that extends Symbol
. It can be used to sync the type of the injected value between the provider and the consumer:
ts
import { provide, inject } from 'vue'
import type { InjectionKey } from 'vue'
const key = Symbol() as InjectionKey<string>
provide(key, 'foo') // providing non-string value will result in error
const foo = inject(key) // type of foo: string | undefined
It's recommended to place the injection key in a separate file so that it can be imported in multiple components.
When using string injection keys, the type of the injected value will be unknown
, and needs to be explicitly declared via a generic type argument:
ts
const foo = inject<string>('foo') // type: string | undefined
Notice the injected value can still be undefined
, because there is no guarantee that a provider will provide this value at runtime.
The undefined
type can be removed by providing a default value:
ts
const foo = inject<string>('foo', 'bar') // type: string
If you are sure that the value is always provided, you can also force cast the value:
ts
const foo = inject('foo') as string
Typing Template Refs
Template refs should be created with an explicit generic type argument and an initial value of null
:
vue
<script setup lang="ts">
import { ref, onMounted } from 'vue'
const el = ref<HTMLInputElement | null>(null)
onMounted(() => {
el.value?.focus()
})
</script>
<template>
<input ref="el" />
</template>
To get the right DOM interface you can check pages like MDN.
Note that for strict type safety, it is necessary to use optional chaining or type guards when accessing el.value
. This is because the initial ref value is null
until the component is mounted, and it can also be set to null
if the referenced element is unmounted by v-if
.
Typing Component Template Refs
Sometimes you might need to annotate a template ref for a child component in order to call its public method. For example, we have a MyModal
child component with a method that opens the modal:
vue
<!-- MyModal.vue -->
<script setup lang="ts">
import { ref } from 'vue'
const isContentShown = ref(false)
const open = () => (isContentShown.value = true)
defineExpose({
open
})
</script>
In order to get the instance type of MyModal
, we need to first get its type via typeof
, then use TypeScript's built-in InstanceType
utility to extract its instance type:
vue
<!-- App.vue -->
<script setup lang="ts">
import MyModal from './MyModal.vue'
const modal = ref<InstanceType<typeof MyModal> | null>(null)
const openModal = () => {
modal.value?.open()
}
</script>
In cases where the exact type of the component isn't available or isn't important, ComponentPublicInstance
can be used instead. This will only include properties that are shared by all components, such as $el
:
ts
import { ref } from 'vue'
import type { ComponentPublicInstance } from 'vue'
const child = ref<ComponentPublicInstance | null>(null)G     hhuh(hh	h}ubh)}(h}(hNh	}(h3https://vuejs.org/guide/scaling-up/state-managementh
State Management | Vue.jsuhXq  State Management
What is State Management?
Technically, every Vue component instance already "manages" its own reactive state. Take a simple counter component as an example:
vue
<script setup>
import { ref } from 'vue'
// state
const count = ref(0)
// actions
function increment() {
count.value++
}
</script>
<!-- view -->
<template>{{ count }}</template>
It is a self-contained unit with the following parts:
- The state, the source of truth that drives our app;
- The view, a declarative mapping of the state;
- The actions, the possible ways the state could change in reaction to user inputs from the view.
This is a simple representation of the concept of "one-way data flow":
However, the simplicity starts to break down when we have multiple components that share a common state:
- Multiple views may depend on the same piece of state.
- Actions from different views may need to mutate the same piece of state.
For case one, a possible workaround is by "lifting" the shared state up to a common ancestor component, and then pass it down as props. However, this quickly gets tedious in component trees with deep hierarchies, leading to another problem known as Prop Drilling.
For case two, we often find ourselves resorting to solutions such as reaching for direct parent / child instances via template refs, or trying to mutate and synchronize multiple copies of the state via emitted events. Both of these patterns are brittle and quickly lead to unmaintainable code.
A simpler and more straightforward solution is to extract the shared state out of the components, and manage it in a global singleton. With this, our component tree becomes a big "view", and any component can access the state or trigger actions, no matter where they are in the tree!
Simple State Management with Reactivity API
If you have a piece of state that should be shared by multiple instances, you can use reactive()
to create a reactive object, and then import it into multiple components:
js
// store.js
import { reactive } from 'vue'
export const store = reactive({
count: 0
})
vue
<!-- ComponentA.vue -->
<script setup>
import { store } from './store.js'
</script>
<template>From A: {{ store.count }}</template>
vue
<!-- ComponentB.vue -->
<script setup>
import { store } from './store.js'
</script>
<template>From B: {{ store.count }}</template>
Now whenever the store
object is mutated, both <ComponentA>
and <ComponentB>
will update their views automatically - we have a single source of truth now.
However, this also means any component importing store
can mutate it however they want:
template
<template>
<button @click="store.count++">
From B: {{ store.count }}
</button>
</template>
While this works in simple cases, global state that can be arbitrarily mutated by any component is not going to be very maintainable in the long run. To ensure the state-mutating logic is centralized like the state itself, it is recommended to define methods on the store with names that express the intention of the actions:
js
// store.js
import { reactive } from 'vue'
export const store = reactive({
count: 0,
increment() {
this.count++
}
})
template
<template>
<button @click="store.increment()">
From B: {{ store.count }}
</button>
</template>
TIP
Note the click handler uses store.increment()
with parentheses - this is necessary to call the method with the proper this
context since it's not a component method.
Although here we are using a single reactive object as a store, you can also share reactive state created using other Reactivity APIs such as ref()
or computed()
, or even return global state from a Composable:
js
import { ref } from 'vue'
// global state, created in module scope
const globalCount = ref(1)
export function useCount() {
// local state, created per-component
const localCount = ref(1)
return {
globalCount,
localCount
}
}
The fact that Vue's reactivity system is decoupled from the component model makes it extremely flexible.
SSR Considerations
If you are building an application that leverages Server-Side Rendering (SSR), the above pattern can lead to issues due to the store being a singleton shared across multiple requests. This is discussed in more details in the SSR guide.
Pinia
While our hand-rolled state management solution will suffice in simple scenarios, there are many more things to consider in large-scale production applications:
- Stronger conventions for team collaboration
- Integrating with the Vue DevTools, including timeline, in-component inspection, and time-travel debugging
- Hot Module Replacement
- Server-Side Rendering support
Pinia is a state management library that implements all of the above. It is maintained by the Vue core team, and works with both Vue 2 and Vue 3.
Existing users may be familiar with Vuex, the previous official state management library for Vue. With Pinia serving the same role in the ecosystem, Vuex is now in maintenance mode. It still works, but will no longer receive new features. It is recommended to use Pinia for new applications.
Pinia started out as an exploration of what the next iteration of Vuex could look like, incorporating many ideas from core team discussions for Vuex 5. Eventually, we realized that Pinia already implements most of what we wanted in Vuex 5, and decided to make it the new recommendation instead.
Compared to Vuex, Pinia provides a simpler API with less ceremony, offers Composition-API-style APIs, and most importantly, has solid type inference support when used with TypeScript.hhuh(hh	h}ubh)}(h}(hNh	}(h&https://vuejs.org/guide/scaling-up/ssrh
$Server-Side Rendering (SSR) | Vue.jsuhXH  Server-Side Rendering (SSR)
Overview
What is SSR?
Vue.js is a framework for building client-side applications. By default, Vue components produce and manipulate DOM in the browser as output. However, it is also possible to render the same components into HTML strings on the server, send them directly to the browser, and finally "hydrate" the static markup into a fully interactive app on the client.
A server-rendered Vue.js app can also be considered "isomorphic" or "universal", in the sense that the majority of your app's code runs on both the server and the client.
Why SSR?
Compared to a client-side Single-Page Application (SPA), the advantage of SSR primarily lies in:
Faster time-to-content: this is more prominent on slow internet or slow devices. Server-rendered markup doesn't need to wait until all JavaScript has been downloaded and executed to be displayed, so your user will see a fully-rendered page sooner. In addition, data fetching is done on the server-side for the initial visit, which likely has a faster connection to your database than the client. This generally results in improved Core Web Vitals metrics, better user experience, and can be critical for applications where time-to-content is directly associated with conversion rate.
Unified mental model: you get to use the same language and the same declarative, component-oriented mental model for developing your entire app, instead of jumping back and forth between a backend templating system and a frontend framework.
Better SEO: the search engine crawlers will directly see the fully rendered page.
TIP
As of now, Google and Bing can index synchronous JavaScript applications just fine. Synchronous being the key word there. If your app starts with a loading spinner, then fetches content via Ajax, the crawler will not wait for you to finish. This means if you have content fetched asynchronously on pages where SEO is important, SSR might be necessary.
There are also some trade-offs to consider when using SSR:
Development constraints. Browser-specific code can only be used inside certain lifecycle hooks; some external libraries may need special treatment to be able to run in a server-rendered app.
More involved build setup and deployment requirements. Unlike a fully static SPA that can be deployed on any static file server, a server-rendered app requires an environment where a Node.js server can run.
More server-side load. Rendering a full app in Node.js is going to be more CPU-intensive than just serving static files, so if you expect high traffic, be prepared for corresponding server load and wisely employ caching strategies.
Before using SSR for your app, the first question you should ask is whether you actually need it. It mostly depends on how important time-to-content is for your app. For example, if you are building an internal dashboard where an extra few hundred milliseconds on initial load doesn't matter that much, SSR would be an overkill. However, in cases where time-to-content is absolutely critical, SSR can help you achieve the best possible initial load performance.
SSR vs. SSG
Static Site Generation (SSG), also referred to as pre-rendering, is another popular technique for building fast websites. If the data needed to server-render a page is the same for every user, then instead of rendering the page every time a request comes in, we can render it only once, ahead of time, during the build process. Pre-rendered pages are generated and served as static HTML files.
SSG retains the same performance characteristics of SSR apps: it provides great time-to-content performance. At the same time, it is cheaper and easier to deploy than SSR apps because the output is static HTML and assets. The keyword here is static: SSG can only be applied to pages providing static data, i.e. data that is known at build time and can not change between requests. Every time the data changes, a new deployment is needed.
If you're only investigating SSR to improve the SEO of a handful of marketing pages (e.g. /
, /about
, /contact
, etc.), then you probably want SSG instead of SSR. SSG is also great for content-based websites such as documentation sites or blogs. In fact, this website you are reading right now is statically generated using VitePress, a Vue-powered static site generator.
Basic Tutorial
Rendering an App
Let's take a look at the most bare-bones example of Vue SSR in action.
- Create a new directory and
cd
into it - Run
npm init -y
- Add
"type": "module"
inpackage.json
so that Node.js runs in ES modules mode. - Run
npm install vue
- Create an
example.js
file:
js
// this runs in Node.js on the server.
import { createSSRApp } from 'vue'
// Vue's server-rendering API is exposed under `vue/server-renderer`.
import { renderToString } from 'vue/server-renderer'
const app = createSSRApp({
data: () => ({ count: 1 }),
template: `<button @click="count++">{{ count }}</button>`
})
renderToString(app).then((html) => {
console.log(html)
})
Then run:
sh
> node example.js
It should print the following to the command line:
<button>1</button>
renderToString()
takes a Vue app instance and returns a Promise that resolves to the rendered HTML of the app. It is also possible to stream rendering using the Node.js Stream API or Web Streams API. Check out the SSR API Reference for full details.
We can then move the Vue SSR code into a server request handler, which wraps the application markup with the full page HTML. We will be using express
for the next steps:
- Run
npm install express
- Create the following
server.js
file:
js
import express from 'express'
import { createSSRApp } from 'vue'
import { renderToString } from 'vue/server-renderer'
const server = express()
server.get('/', (req, res) => {
const app = createSSRApp({
data: () => ({ count: 1 }),
template: `<button @click="count++">{{ count }}</button>`
})
renderToString(app).then((html) => {
res.send(`
<!DOCTYPE html>
<html>
<head>
<title>Vue SSR Example</title>
</head>
<body>
<div id="app">${html}</div>
</body>
</html>
`)
})
})
server.listen(3000, () => {
console.log('ready')
})
Finally, run node server.js
and visit http://localhost:3000
. You should see the page working with the button.
Client Hydration
If you click the button, you'll notice the number doesn't change. The HTML is completely static on the client since we are not loading Vue in the browser.
To make the client-side app interactive, Vue needs to perform the hydration step. During hydration, it creates the same Vue application that was run on the server, matches each component to the DOM nodes it should control, and attaches DOM event listeners.
To mount an app in hydration mode, we need to use createSSRApp()
instead of createApp()
:
js
// this runs in the browser.
import { createSSRApp } from 'vue'
const app = createSSRApp({
// ...same app as on server
})
// mounting an SSR app on the client assumes
// the HTML was pre-rendered and will perform
// hydration instead of mounting new DOM nodes.
app.mount('#app')
Code Structure
Notice how we need to reuse the same app implementation as on the server. This is where we need to start thinking about code structure in an SSR app - how do we share the same application code between the server and the client?
Here we will demonstrate the most bare-bones setup. First, let's split the app creation logic into a dedicated file, app.js
:
js
// app.js (shared between server and client)
import { createSSRApp } from 'vue'
export function createApp() {
return createSSRApp({
data: () => ({ count: 1 }),
template: `<button @click="count++">{{ count }}</button>`
})
}
This file and its dependencies are shared between the server and the client - we call them universal code. There are a number of things you need to pay attention to when writing universal code, as we will discuss below.
Our client entry imports the universal code, creates the app, and performs the mount:
js
// client.js
import { createApp } from './app.js'
createApp().mount('#app')
And the server uses the same app creation logic in the request handler:
js
// server.js (irrelevant code omitted)
import { createApp } from './app.js'
server.get('/', (req, res) => {
const app = createApp()
renderToString(app).then(html => {
// ...
})
})
In addition, in order to load the client files in the browser, we also need to:
- Serve client files by adding
server.use(express.static('.'))
inserver.js
. - Load the client entry by adding
<script type="module" src="/client.js"></script>
to the HTML shell. - Support usage like
import * from 'vue'
in the browser by adding an Import Map to the HTML shell.
Try the completed example on StackBlitz. The button is now interactive!
Higher Level Solutions
Moving from the example to a production-ready SSR app involves a lot more. We will need to:
Support Vue SFCs and other build step requirements. In fact, we will need to coordinate two builds for the same app: one for the client, and one for the server.
TIP
Vue components are compiled differently when used for SSR - templates are compiled into string concatenations instead of Virtual DOM render functions for more efficient rendering performance.
In the server request handler, render the HTML with the correct client-side asset links and optimal resource hints. We may also need to switch between SSR and SSG mode, or even mix both in the same app.
Manage routing, data fetching, and state management stores in a universal manner.
A complete implementation would be quite complex and depends on the build toolchain you have chosen to work with. Therefore, we highly recommend going with a higher-level, opinionated solution that abstracts away the complexity for you. Below we will introduce a few recommended SSR solutions in the Vue ecosystem.
Nuxt
Nuxt is a higher-level framework built on top of the Vue ecosystem which provides a streamlined development experience for writing universal Vue applications. Better yet, you can also use it as a static site generator! We highly recommend giving it a try.
Quasar
Quasar is a complete Vue-based solution that allows you to target SPA, SSR, PWA, mobile app, desktop app, and browser extension all using one codebase. It not only handles the build setup, but also provides a full collection of Material Design compliant UI components.
Vite SSR
Vite provides built-in support for Vue server-side rendering, but it is intentionally low-level. If you wish to go directly with Vite, check out vite-plugin-ssr, a community plugin that abstracts away many challenging details for you.
You can also find an example Vue + Vite SSR project using manual setup here, which can serve as a base to build upon. Note this is only recommended if you are experienced with SSR / build tools and really want to have complete control over the higher-level architecture.
Writing SSR-friendly Code
Regardless of your build setup or higher-level framework choice, there are some principles that apply in all Vue SSR applications.
Reactivity on the Server
During SSR, each request URL maps to a desired state of our application. There is no user interaction and no DOM updates, so reactivity is unnecessary on the server. By default, reactivity is disabled during SSR for better performance.
Component Lifecycle Hooks
Since there are no dynamic updates, lifecycle hooks such as onMounted
or onUpdated
will NOT be called during SSR and will only be executed on the client.
You should avoid code that produces side effects that need cleanup in setup()
or the root scope of <script setup>
. An example of such side effects is setting up timers with setInterval
. In client-side only code we may setup a timer and then tear it down in onBeforeUnmount
or onUnmounted
. However, because the unmount hooks will never be called during SSR, the timers will stay around forever. To avoid this, move your side-effect code into onMounted
instead.
Access to Platform-Specific APIs
Universal code cannot assume access to platform-specific APIs, so if your code directly uses browser-only globals like window
or document
, they will throw errors when executed in Node.js, and vice-versa.
For tasks that are shared between server and client but with different platform APIs, it's recommended to wrap the platform-specific implementations inside a universal API, or use libraries that do this for you. For example, you can use node-fetch
to use the same fetch API on both server and client.
For browser-only APIs, the common approach is to lazily access them inside client-only lifecycle hooks such as onMounted
.
Note that if a third-party library is not written with universal usage in mind, it could be tricky to integrate it into a server-rendered app. You might be able to get it working by mocking some of the globals, but it would be hacky and may interfere with the environment detection code of other libraries.
Cross-Request State Pollution
In the State Management chapter, we introduced a simple state management pattern using Reactivity APIs. In an SSR context, this pattern requires some additional adjustments.
The pattern declares shared state in a JavaScript module's root scope. This makes them singletons - i.e. there is only one instance of the reactive object throughout the entire lifecycle of our application. This works as expected in a pure client-side Vue application, since the modules in our application are initialized fresh for each browser page visit.
However, in an SSR context, the application modules are typically initialized only once on the server, when the server boots up. The same module instances will be reused across multiple server requests, and so will our singleton state objects. If we mutate the shared singleton state with data specific to one user, it can be accidentally leaked to a request from another user. We call this cross-request state pollution.
We can technically re-initialize all the JavaScript modules on each request, just like we do in browsers. However, initializing JavaScript modules can be costly, so this would significantly affect server performance.
The recommended solution is to create a new instance of the entire application - including the router and global stores - on each request. Then, instead of directly importing it in our components, we provide the shared state using app-level provide and inject it in components that need it:
js
// app.js (shared between server and client)
import { createSSRApp } from 'vue'
import { createStore } from './store.js'
// called on each request
export function createApp() {
const app = createSSRApp(/* ... */)
// create new instance of store per request
const store = createStore(/* ... */)
// provide store at the app level
app.provide('store', store)
// also expose store for hydration purposes
return { app, store }
}
State Management libraries like Pinia are designed with this in mind. Consult Pinia's SSR guide for more details.
Hydration Mismatch
If the DOM structure of the pre-rendered HTML does not match the expected output of the client-side app, there will be a hydration mismatch error. Hydration mismatch is most commonly introduced by the following causes:
The template contains invalid HTML nesting structure, and the rendered HTML got "corrected" by the browser's native HTML parsing behavior. For example, a common gotcha is that
<div>
cannot be placed inside<p>
:html<p><div>hi</div></p>
If we produce this in our server-rendered HTML, the browser will terminate the first
<p>
when<div>
is encountered and parse it into the following DOM structure:html<p></p> <div>hi</div> <p></p>
The data used during render contains randomly generated values. Since the same application will run twice - once on the server, and once on the client - the random values are not guaranteed to be the same between the two runs. There are two ways to avoid random-value-induced mismatches:
Use
v-if
+onMounted
to render the part that depends on random values only on the client. Your framework may also have built-in features to make this easier, for example the<ClientOnly>
component in VitePress.Use a random number generator library that supports generating with seeds, and guarantee the server run and the client run are using the same seed (e.g. by including the seed in serialized state and retrieving it on the client).
The server and the client are in different time zones. Sometimes, we may want to convert a timestamp into the user's local time. However, the timezone during the server run and the timezone during the client run are not always the same, and we may not reliably know the user's timezone during the server run. In such cases, the local time conversion should also be performed as a client-only operation.
When Vue encounters a hydration mismatch, it will attempt to automatically recover and adjust the pre-rendered DOM to match the client-side state. This will lead to some rendering performance loss due to incorrect nodes being discarded and new nodes being mounted, but in most cases, the app should continue to work as expected. That said, it is still best to eliminate hydration mismatches during development.
Custom Directives
Since most custom directives involve direct DOM manipulation, they are ignored during SSR. However, if you want to specify how a custom directive should be rendered (i.e. what attributes it should add to the rendered element), you can use the getSSRProps
directive hook:
js
const myDirective = {
mounted(el, binding) {
// client-side implementation:
// directly update the DOM
el.id = binding.value
},
getSSRProps(binding) {
// server-side implementation:
// return the props to be rendered.
// getSSRProps only receives the directive binding.
return {
id: binding.value
}
}
}
Teleports
Teleports require special handling during SSR. If the rendered app contains Teleports, the teleported content will not be part of the rendered string. An easier solution is to conditionally render the Teleport on mount.
If you do need to hydrate teleported content, they are exposed under the teleports
property of the ssr context object:
js
const ctx = {}
const html = await renderToString(app, ctx)
console.log(ctx.teleports) // { '#teleported': 'teleported content' }
You need to inject the teleport markup into the correct location in your final page HTML similar to how you need to inject the main app markup.
TIP
Avoid targeting body
when using Teleports and SSR together - usually, <body>
will contain other server-rendered content which makes it impossible for Teleports to determine the correct starting location for hydration.
Instead, prefer a dedicated container, e.g. <div id="teleported"></div>
which contains only teleported content.hhuh(hh	h}ubh)}(h}(hNh	}(h#https://vuejs.org/guide/quick-starth
Quick Start | Vue.jsuhXl  Quick Start
Try Vue Online
To quickly get a taste of Vue, you can try it directly in our Playground.
If you prefer a plain HTML setup without any build steps, you can use this JSFiddle as your starting point.
If you are already familiar with Node.js and the concept of build tools, you can also try a complete build setup right within your browser on StackBlitz.
Creating a Vue Application
Prerequisites
- Familiarity with the command line
- Install Node.js version 18.3 or higher
In this section we will introduce how to scaffold a Vue Single Page Application on your local machine. The created project will be using a build setup based on Vite and allow us to use Vue Single-File Components (SFCs).
Make sure you have an up-to-date version of Node.js installed and your current working directory is the one where you intend to create a project. Run the following command in your command line (without the $
sign):
npm
pnpm
yarn
bun
sh
$ npm create vue@latest
This command will install and execute create-vue, the official Vue project scaffolding tool. You will be presented with prompts for several optional features such as TypeScript and testing support:
✔ Project name: … <your-project-name>
✔ Add TypeScript? … No / Yes
✔ Add JSX Support? … No / Yes
✔ Add Vue Router for Single Page Application development? … No / Yes
✔ Add Pinia for state management? … No / Yes
✔ Add Vitest for Unit testing? … No / Yes
✔ Add an End-to-End Testing Solution? … No / Cypress / Nightwatch / Playwright
✔ Add ESLint for code quality? … No / Yes
✔ Add Prettier for code formatting? … No / Yes
✔ Add Vue DevTools 7 extension for debugging? (experimental) … No / Yes
Scaffolding project in ./<your-project-name>...
Done.
If you are unsure about an option, simply choose No
by hitting enter for now. Once the project is created, follow the instructions to install dependencies and start the dev server:
npm
pnpm
yarn
bun
sh
$ cd <your-project-name>
$ npm install
$ npm run dev
You should now have your first Vue project running! Note that the example components in the generated project are written using the Composition API and <script setup>
, rather than the Options API. Here are some additional tips:
- The recommended IDE setup is Visual Studio Code + Vue - Official extension. If you use other editors, check out the IDE support section.
- More tooling details, including integration with backend frameworks, are discussed in the Tooling Guide.
- To learn more about the underlying build tool Vite, check out the Vite docs.
- If you choose to use TypeScript, check out the TypeScript Usage Guide.
When you are ready to ship your app to production, run the following:
npm
pnpm
yarn
bun
sh
$ npm run build
This will create a production-ready build of your app in the project's ./dist
directory. Check out the Production Deployment Guide to learn more about shipping your app to production.
Using Vue from CDN
You can use Vue directly from a CDN via a script tag:
html
<script src="https://unpkg.com/vue@3/dist/vue.global.js"></script>
Here we are using unpkg, but you can also use any CDN that serves npm packages, for example jsdelivr or cdnjs. Of course, you can also download this file and serve it yourself.
When using Vue from a CDN, there is no "build step" involved. This makes the setup a lot simpler, and is suitable for enhancing static HTML or integrating with a backend framework. However, you won't be able to use the Single-File Component (SFC) syntax.
Using the Global Build
The above link loads the global build of Vue, where all top-level APIs are exposed as properties on the global Vue
object. Here is a full example using the global build:
html
<script src="https://unpkg.com/vue@3/dist/vue.global.js"></script>
<div id="app">{{ message }}</div>
<script>
const { createApp, ref } = Vue
createApp({
setup() {
const message = ref('Hello vue!')
return {
message
}
}
}).mount('#app')
</script>
TIP
Many of the examples for Composition API throughout the guide will be using the <script setup>
syntax, which requires build tools. If you intend to use Composition API without a build step, consult the usage of the setup()
option.
Using the ES Module Build
Throughout the rest of the documentation, we will be primarily using ES modules syntax. Most modern browsers now support ES modules natively, so we can use Vue from a CDN via native ES modules like this:
html
<div id="app">{{ message }}</div>
<script type="module">
import { createApp, ref } from 'https://unpkg.com/vue@3/dist/vue.esm-browser.js'
createApp({
setup() {
const message = ref('Hello Vue!')
return {
message
}
}
}).mount('#app')
</script>
Notice that we are using <script type="module">
, and the imported CDN URL is pointing to the ES modules build of Vue instead.
Enabling Import maps
In the above example, we are importing from the full CDN URL, but in the rest of the documentation you will see code like this:
js
import { createApp } from 'vue'
We can teach the browser where to locate the vue
import by using Import Maps:
html
<script type="importmap">
{
"imports": {
"vue": "https://unpkg.com/vue@3/dist/vue.esm-browser.js"
}
}
</script>
<div id="app">{{ message }}</div>
<script type="module">
import { createApp, ref } from 'vue'
createApp({
setup() {
const message = ref('Hello Vue!')
return {
message
}
}
}).mount('#app')
</script>
You can also add entries for other dependencies to the import map - but make sure they point to the ES modules version of the library you intend to use.
Import Maps Browser Support
Import Maps is a relatively new browser feature. Make sure to use a browser within its support range. In particular, it is only supported in Safari 16.4+.
Notes on Production Use
The examples so far are using the development build of Vue - if you intend to use Vue from a CDN in production, make sure to check out the Production Deployment Guide.
While it is possible to use Vue without a build system, an alternative approach to consider is using vuejs/petite-vue
that could better suit the context where jquery/jquery
(in the past) or alpinejs/alpine
(in the present) might be used instead.
Splitting Up the Modules
As we dive deeper into the guide, we may need to split our code into separate JavaScript files so that they are easier to manage. For example:
html
<!-- index.html -->
<div id="app"></div>
<script type="module">
import { createApp } from 'vue'
import MyComponent from './my-component.js'
createApp(MyComponent).mount('#app')
</script>
js
// my-component.js
import { ref } from 'vue'
export default {
setup() {
const count = ref(0)
return { count }
},
template: `<div>Count is: {{ count }}</div>`
}
If you directly open the above index.html
in your browser, you will find that it throws an error because ES modules cannot work over the file://
protocol, which is the protocol the browser uses when you open a local file.
Due to security reasons, ES modules can only work over the http://
protocol, which is what the browsers use when opening pages on the web. In order for ES modules to work on our local machine, we need to serve the index.html
over the http://
protocol, with a local HTTP server.
To start a local HTTP server, first make sure you have Node.js installed, then run npx serve
from the command line in the same directory where your HTML file is. You can also use any other HTTP server that can serve static files with the correct MIME types.
You may have noticed that the imported component's template is inlined as a JavaScript string. If you are using VS Code, you can install the es6-string-html extension and prefix the strings with a /*html*/
comment to get syntax highlighting for them.
Next Steps
If you skipped the Introduction, we strongly recommend reading it before moving on to the rest of the documentation.hhuh(hh	h}ubh)}(h}(hNh	}(h$https://vuejs.org/guide/introductionh
Introduction | Vue.jsuhX  Introduction
You are reading the documentation for Vue 3!
- Vue 2 support has ended on Dec 31, 2023. Learn more about Vue 2 EOL.
- Upgrading from Vue 2? Check out the Migration Guide.
What is Vue?
Vue (pronounced /vjuː/, like view) is a JavaScript framework for building user interfaces. It builds on top of standard HTML, CSS, and JavaScript and provides a declarative, component-based programming model that helps you efficiently develop user interfaces of any complexity.
Here is a minimal example:
js
import { createApp, ref } from 'vue'
createApp({
setup() {
return {
count: ref(0)
}
}
}).mount('#app')
template
<div id="app">
<button @click="count++">
Count is: {{ count }}
</button>
</div>
Result
The above example demonstrates the two core features of Vue:
Declarative Rendering: Vue extends standard HTML with a template syntax that allows us to declaratively describe HTML output based on JavaScript state.
Reactivity: Vue automatically tracks JavaScript state changes and efficiently updates the DOM when changes happen.
You may already have questions - don't worry. We will cover every little detail in the rest of the documentation. For now, please read along so you can have a high-level understanding of what Vue offers.
Prerequisites
The rest of the documentation assumes basic familiarity with HTML, CSS, and JavaScript. If you are totally new to frontend development, it might not be the best idea to jump right into a framework as your first step - grasp the basics and then come back! You can check your knowledge level with these overviews for JavaScript, HTML and CSS if needed. Prior experience with other frameworks helps, but is not required.
The Progressive Framework
Vue is a framework and ecosystem that covers most of the common features needed in frontend development. But the web is extremely diverse - the things we build on the web may vary drastically in form and scale. With that in mind, Vue is designed to be flexible and incrementally adoptable. Depending on your use case, Vue can be used in different ways:
- Enhancing static HTML without a build step
- Embedding as Web Components on any page
- Single-Page Application (SPA)
- Fullstack / Server-Side Rendering (SSR)
- Jamstack / Static Site Generation (SSG)
- Targeting desktop, mobile, WebGL, and even the terminal
If you find these concepts intimidating, don't worry! The tutorial and guide only require basic HTML and JavaScript knowledge, and you should be able to follow along without being an expert in any of these.
If you are an experienced developer interested in how to best integrate Vue into your stack, or you are curious about what these terms mean, we discuss them in more detail in Ways of Using Vue.
Despite the flexibility, the core knowledge about how Vue works is shared across all these use cases. Even if you are just a beginner now, the knowledge gained along the way will stay useful as you grow to tackle more ambitious goals in the future. If you are a veteran, you can pick the optimal way to leverage Vue based on the problems you are trying to solve, while retaining the same productivity. This is why we call Vue "The Progressive Framework": it's a framework that can grow with you and adapt to your needs.
Single-File Components
In most build-tool-enabled Vue projects, we author Vue components using an HTML-like file format called Single-File Component (also known as *.vue
files, abbreviated as SFC). A Vue SFC, as the name suggests, encapsulates the component's logic (JavaScript), template (HTML), and styles (CSS) in a single file. Here's the previous example, written in SFC format:
vue
<script setup>
import { ref } from 'vue'
const count = ref(0)
</script>
<template>
<button @click="count++">Count is: {{ count }}</button>
</template>
<style scoped>
button {
font-weight: bold;
}
</style>
SFC is a defining feature of Vue and is the recommended way to author Vue components if your use case warrants a build setup. You can learn more about the how and why of SFC in its dedicated section - but for now, just know that Vue will handle all the build tools setup for you.
API Styles
Vue components can be authored in two different API styles: Options API and Composition API.
Options API
With Options API, we define a component's logic using an object of options such as data
, methods
, and mounted
. Properties defined by options are exposed on this
inside functions, which points to the component instance:
vue
<script>
export default {
// Properties returned from data() become reactive state
// and will be exposed on `this`.
data() {
return {
count: 0
}
},
// Methods are functions that mutate state and trigger updates.
// They can be bound as event handlers in templates.
methods: {
increment() {
this.count++
}
},
// Lifecycle hooks are called at different stages
// of a component's lifecycle.
// This function will be called when the component is mounted.
mounted() {
console.log(`The initial count is ${this.count}.`)
}
}
</script>
<template>
<button @click="increment">Count is: {{ count }}</button>
</template>
Composition API
With Composition API, we define a component's logic using imported API functions. In SFCs, Composition API is typically used with <script setup>
. The setup
attribute is a hint that makes Vue perform compile-time transforms that allow us to use Composition API with less boilerplate. For example, imports and top-level variables / functions declared in <script setup>
are directly usable in the template.
Here is the same component, with the exact same template, but using Composition API and <script setup>
instead:
vue
<script setup>
import { ref, onMounted } from 'vue'
// reactive state
const count = ref(0)
// functions that mutate state and trigger updates
function increment() {
count.value++
}
// lifecycle hooks
onMounted(() => {
console.log(`The initial count is ${count.value}.`)
})
</script>
<template>
<button @click="increment">Count is: {{ count }}</button>
</template>
Which to Choose?
Both API styles are fully capable of covering common use cases. They are different interfaces powered by the exact same underlying system. In fact, the Options API is implemented on top of the Composition API! The fundamental concepts and knowledge about Vue are shared across the two styles.
The Options API is centered around the concept of a "component instance" (this
as seen in the example), which typically aligns better with a class-based mental model for users coming from OOP language backgrounds. It is also more beginner-friendly by abstracting away the reactivity details and enforcing code organization via option groups.
The Composition API is centered around declaring reactive state variables directly in a function scope and composing state from multiple functions together to handle complexity. It is more free-form and requires an understanding of how reactivity works in Vue to be used effectively. In return, its flexibility enables more powerful patterns for organizing and reusing logic.
You can learn more about the comparison between the two styles and the potential benefits of Composition API in the Composition API FAQ.
If you are new to Vue, here's our general recommendation:
For learning purposes, go with the style that looks easier to understand to you. Again, most of the core concepts are shared between the two styles. You can always pick up the other style later.
For production use:
Go with Options API if you are not using build tools, or plan to use Vue primarily in low-complexity scenarios, e.g. progressive enhancement.
Go with Composition API + Single-File Components if you plan to build full applications with Vue.
You don't have to commit to only one style during the learning phase. The rest of the documentation will provide code samples in both styles where applicable, and you can toggle between them at any time using the API Preference switches at the top of the left sidebar.
Still Got Questions?
Check out our FAQ.
Pick Your Learning Path
Different developers have different learning styles. Feel free to pick a learning path that suits your preference - although we do recommend going over all of the content, if possible!hhuh(hh	h}ubh)}(h}(hNh	}(h4https://vuejs.org/guide/best-practices/accessibilityh
Accessibility | Vue.jsuhX6  Accessibility
Web accessibility (also known as a11y) refers to the practice of creating websites that can be used by anyone — be that a person with a disability, a slow connection, outdated or broken hardware or simply someone in an unfavorable environment. For example, adding subtitles to a video would help both your deaf and hard-of-hearing users and your users who are in a loud environment and can't hear their phone. Similarly, making sure your text isn't too low contrast will help both your low-vision users and your users who are trying to use their phone in bright sunlight.
Ready to start but aren’t sure where?
Checkout the Planning and managing web accessibility guide provided by World Wide Web Consortium (W3C)
Skip link
You should add a link at the top of each page that goes directly to the main content area so users can skip content that is repeated on multiple Web pages.
Typically this is done on the top of App.vue
as it will be the first focusable element on all your pages:
template
<ul class="skip-links">
<li>
<a href="#main" ref="skipLink" class="skip-link">Skip to main content</a>
</li>
</ul>
To hide the link unless it is focused, you can add the following style:
css
.skip-link {
white-space: nowrap;
margin: 1em auto;
top: 0;
position: fixed;
left: 50%;
margin-left: -72px;
opacity: 0;
}
.skip-link:focus {
opacity: 1;
background-color: white;
padding: 0.5em;
border: 1px solid black;
}
Once a user changes route, bring focus back to the skip link. This can be achieved by calling focus on the skip link's template ref (assuming usage of vue-router
):
vue
<script setup>
import { ref, watch } from 'vue'
import { useRoute } from 'vue-router'
const route = useRoute()
const skipLink = ref()
watch(
() => route.path,
() => {
skipLink.value.focus()
}
)
</script>
Read documentation on skip link to main content
Content Structure
One of the most important pieces of accessibility is making sure that design can support accessible implementation. Design should consider not only color contrast, font selection, text sizing, and language, but also how the content is structured in the application.
Headings
Users can navigate an application through headings. Having descriptive headings for every section of your application makes it easier for users to predict the content of each section. When it comes to headings, there are a couple of recommended accessibility practices:
- Nest headings in their ranking order:
<h1>
-<h6>
- Don’t skip headings within a section
- Use actual heading tags instead of styling text to give the visual appearance of headings
template
<main role="main" aria-labelledby="main-title">
<h1 id="main-title">Main title</h1>
<section aria-labelledby="section-title-1">
<h2 id="section-title-1"> Section Title </h2>
<h3>Section Subtitle</h3>
<!-- Content -->
</section>
<section aria-labelledby="section-title-2">
<h2 id="section-title-2"> Section Title </h2>
<h3>Section Subtitle</h3>
<!-- Content -->
<h3>Section Subtitle</h3>
<!-- Content -->
</section>
</main>
Landmarks
Landmarks provide programmatic access to sections within an application. Users who rely on assistive technology can navigate to each section of the application and skip over content. You can use ARIA roles to help you achieve this.
HTML | ARIA Role | Landmark Purpose |
---|---|---|
header | role="banner" | Prime heading: title of the page |
nav | role="navigation" | Collection of links suitable for use when navigating the document or related documents |
main | role="main" | The main or central content of the document. |
footer | role="contentinfo" | Information about the parent document: footnotes/copyrights/links to privacy statement |
aside | role="complementary" | Supports the main content, yet is separated and meaningful on its own content |
search | role="search" | This section contains the search functionality for the application |
form | role="form" | Collection of form-associated elements |
section | role="region" | Content that is relevant and that users will likely want to navigate to. Label must be provided for this element |
Tip:
It is recommended to use landmark HTML elements with redundant landmark role attributes in order to maximize compatibility with legacy browsers that don’t support HTML5 semantic elements.
Semantic Forms
When creating a form, you can use the following elements: <form>
, <label>
, <input>
, <textarea>
, and <button>
Labels are typically placed on top or to the left of the form fields:
template
<form action="/dataCollectionLocation" method="post" autocomplete="on">
<div v-for="item in formItems" :key="item.id" class="form-item">
<label :for="item.id">{{ item.label }}: </label>
<input
:type="item.type"
:id="item.id"
:name="item.id"
v-model="item.value"
/>
</div>
<button type="submit">Submit</button>
</form>
Notice how you can include autocomplete='on'
on the form element and it will apply to all inputs in your form. You can also set different values for autocomplete attribute for each input.
Labels
Provide labels to describe the purpose of all form control; linking for
and id
:
template
<label for="name">Name: </label>
<input type="text" name="name" id="name" v-model="name" />
If you inspect this element in your Chrome DevTools and open the Accessibility tab inside the Elements tab, you will see how the input gets its name from the label:
Warning:
Though you might have seen labels wrapping the input fields like this:
template
<label>
Name:
<input type="text" name="name" id="name" v-model="name" />
</label>
Explicitly setting the labels with a matching id is better supported by assistive technology.
aria-label
You can also give the input an accessible name with aria-label
.
template
<label for="name">Name: </label>
<input
type="text"
name="name"
id="name"
v-model="name"
:aria-label="nameLabel"
/>
Feel free to inspect this element in Chrome DevTools to see how the accessible name has changed:
aria-labelledby
Using aria-labelledby
is similar to aria-label
except it is used if the label text is visible on screen. It is paired to other elements by their id
and you can link multiple id
s:
template
<form
class="demo"
action="/dataCollectionLocation"
method="post"
autocomplete="on"
>
<h1 id="billing">Billing</h1>
<div class="form-item">
<label for="name">Name: </label>
<input
type="text"
name="name"
id="name"
v-model="name"
aria-labelledby="billing name"
/>
</div>
<button type="submit">Submit</button>
</form>
aria-describedby
aria-describedby is used the same way as aria-labelledby
except provides a description with additional information that the user might need. This can be used to describe the criteria for any input:
template
<form
class="demo"
action="/dataCollectionLocation"
method="post"
autocomplete="on"
>
<h1 id="billing">Billing</h1>
<div class="form-item">
<label for="name">Full Name: </label>
<input
type="text"
name="name"
id="name"
v-model="name"
aria-labelledby="billing name"
aria-describedby="nameDescription"
/>
<p id="nameDescription">Please provide first and last name.</p>
</div>
<button type="submit">Submit</button>
</form>
You can see the description by inspecting Chrome DevTools:
Placeholder
Avoid using placeholders as they can confuse many users.
One of the issues with placeholders is that they don't meet the color contrast criteria by default; fixing the color contrast makes the placeholder look like pre-populated data in the input fields. Looking at the following example, you can see that the Last Name placeholder which meets the color contrast criteria looks like pre-populated data:
template
<form
class="demo"
action="/dataCollectionLocation"
method="post"
autocomplete="on"
>
<div v-for="item in formItems" :key="item.id" class="form-item">
<label :for="item.id">{{ item.label }}: </label>
<input
type="text"
:id="item.id"
:name="item.id"
v-model="item.value"
:placeholder="item.placeholder"
/>
</div>
<button type="submit">Submit</button>
</form>
css
/* https://www.w3schools.com/howto/howto_css_placeholder.asp */
#lastName::placeholder {
/* Chrome, Firefox, Opera, Safari 10.1+ */
color: black;
opacity: 1; /* Firefox */
}
#lastName:-ms-input-placeholder {
/* Internet Explorer 10-11 */
color: black;
}
#lastName::-ms-input-placeholder {
/* Microsoft Edge */
color: black;
}
It is best to provide all the information the user needs to fill out forms outside any inputs.
Instructions
When adding instructions for your input fields, make sure to link it correctly to the input. You can provide additional instructions and bind multiple ids inside an aria-labelledby
. This allows for more flexible design.
template
<fieldset>
<legend>Using aria-labelledby</legend>
<label id="date-label" for="date">Current Date: </label>
<input
type="date"
name="date"
id="date"
aria-labelledby="date-label date-instructions"
/>
<p id="date-instructions">MM/DD/YYYY</p>
</fieldset>
Alternatively, you can attach the instructions to the input with aria-describedby
:
template
<fieldset>
<legend>Using aria-describedby</legend>
<label id="dob" for="dob">Date of Birth: </label>
<input type="date" name="dob" id="dob" aria-describedby="dob-instructions" />
<p id="dob-instructions">MM/DD/YYYY</p>
</fieldset>
Hiding Content
Usually it is not recommended to visually hide labels, even if the input has an accessible name. However, if the functionality of the input can be understood with surrounding content, then we can hide the visual label.
Let's look at this search field:
template
<form role="search">
<label for="search" class="hidden-visually">Search: </label>
<input type="text" name="search" id="search" v-model="search" />
<button type="submit">Search</button>
</form>
We can do this because the search button will help visual users identify the purpose of the input field.
We can use CSS to visually hide elements but keep them available for assistive technology:
css
.hidden-visually {
position: absolute;
overflow: hidden;
white-space: nowrap;
margin: 0;
padding: 0;
height: 1px;
width: 1px;
clip: rect(0 0 0 0);
clip-path: inset(100%);
}
aria-hidden="true"
Adding aria-hidden="true"
will hide the element from assistive technology but leave it visually available for other users. Do not use it on focusable elements, purely on decorative, duplicated or offscreen content.
template
<p>This is not hidden from screen readers.</p>
<p aria-hidden="true">This is hidden from screen readers.</p>
Buttons
When using buttons inside a form, you must set the type to prevent submitting the form. You can also use an input to create buttons:
template
<form action="/dataCollectionLocation" method="post" autocomplete="on">
<!-- Buttons -->
<button type="button">Cancel</button>
<button type="submit">Submit</button>
<!-- Input buttons -->
<input type="button" value="Cancel" />
<input type="submit" value="Submit" />
</form>
Functional Images
You can use this technique to create functional images.
Input fields
- These images will act as a submit type button on forms
template<form role="search"> <label for="search" class="hidden-visually">Search: </label> <input type="text" name="search" id="search" v-model="search" /> <input type="image" class="btnImg" src="https://img.icons8.com/search" alt="Search" /> </form>
Icons
template
<form role="search">
<label for="searchIcon" class="hidden-visually">Search: </label>
<input type="text" name="searchIcon" id="searchIcon" v-model="searchIcon" />
<button type="submit">
<i class="fas fa-search" aria-hidden="true"></i>
<span class="hidden-visually">Search</span>
</button>
</form>
Standards
The World Wide Web Consortium (W3C) Web Accessibility Initiative (WAI) develops web accessibility standards for the different components:
- User Agent Accessibility Guidelines (UAAG)
- web browsers and media players, including some aspects of assistive technologies
- Authoring Tool Accessibility Guidelines (ATAG)
- authoring tools
- Web Content Accessibility Guidelines (WCAG)
- web content - used by developers, authoring tools, and accessibility evaluation tools
Web Content Accessibility Guidelines (WCAG)
WCAG 2.1 extends on WCAG 2.0 and allows implementation of new technologies by addressing changes to the web. The W3C encourages use of the most current version of WCAG when developing or updating Web accessibility policies.
WCAG 2.1 Four Main Guiding Principles (abbreviated as POUR):
- Perceivable
- Users must be able to perceive the information being presented
- Operable
- Interface forms, controls, and navigation are operable
- Understandable
- Information and the operation of user interface must be understandable to all users
- Robust
- Users must be able to access the content as technologies advance
Web Accessibility Initiative – Accessible Rich Internet Applications (WAI-ARIA)
W3C's WAI-ARIA provides guidance on how to build dynamic content and advanced user interface controls.
Resources
Documentation
- WCAG 2.0
- WCAG 2.1
- Accessible Rich Internet Applications (WAI-ARIA) 1.2
- WAI-ARIA Authoring Practices 1.2
Assistive Technologies
Testing
- Automated Tools
- Color Tools
- Other Helpful Tools
Users
The World Health Organization estimates that 15% of the world's population has some form of disability, 2-4% of them severely so. That is an estimated 1 billion people worldwide; making people with disabilities the largest minority group in the world.
There are a huge range of disabilities, which can be divided roughly into four categories:
- Visual - These users can benefit from the use of screen readers, screen magnification, controlling screen contrast, or braille display.
- Auditory - These users can benefit from captioning, transcripts or sign language video.
- Motor - These users can benefit from a range of assistive technologies for motor impairments: voice recognition software, eye tracking, single-switch access, head wand, sip and puff switch, oversized trackball mouse, adaptive keyboard or other assistive technologies.
- Cognitive - These users can benefit from supplemental media, structural organization of content, clear and simple writing.
Check out the following links from WebAim to understand from users:hhuh(hh	h}ubh)}(h}(hNh	}(h*https://vuejs.org/guide/built-ins/teleporth
Teleport | Vue.jsuhXM  Teleport
<Teleport>
is a built-in component that allows us to "teleport" a part of a component's template into a DOM node that exists outside the DOM hierarchy of that component.
Basic Usage
Sometimes we may run into the following scenario: a part of a component's template belongs to it logically, but from a visual standpoint, it should be displayed somewhere else in the DOM, outside of the Vue application.
The most common example of this is when building a full-screen modal. Ideally, we want the modal's button and the modal itself to live within the same component, since they are both related to the open / close state of the modal. But that means the modal will be rendered alongside the button, deeply nested in the application's DOM hierarchy. This can create some tricky issues when positioning the modal via CSS.
Consider the following HTML structure.
template
<div class="outer">
<h3>Vue Teleport Example</h3>
<div>
<MyModal />
</div>
</div>
And here is the implementation of <MyModal>
:
vue
<script setup>
import { ref } from 'vue'
const open = ref(false)
</script>
<template>
<button @click="open = true">Open Modal</button>
<div v-if="open" class="modal">
<p>Hello from the modal!</p>
<button @click="open = false">Close</button>
</div>
</template>
<style scoped>
.modal {
position: fixed;
z-index: 999;
top: 20%;
left: 50%;
width: 300px;
margin-left: -150px;
}
</style>
The component contains a <button>
to trigger the opening of the modal, and a <div>
with a class of .modal
, which will contain the modal's content and a button to self-close.
When using this component inside the initial HTML structure, there are a number of potential issues:
position: fixed
only places the element relative to the viewport when no ancestor element hastransform
,perspective
orfilter
property set. If, for example, we intend to animate the ancestor<div class="outer">
with a CSS transform, it would break the modal layout!The modal's
z-index
is constrained by its containing elements. If there is another element that overlaps with<div class="outer">
and has a higherz-index
, it would cover our modal.
<Teleport>
provides a clean way to work around these, by allowing us to break out of the nested DOM structure. Let's modify <MyModal>
to use <Teleport>
:
template
<button @click="open = true">Open Modal</button>
<Teleport to="body">
<div v-if="open" class="modal">
<p>Hello from the modal!</p>
<button @click="open = false">Close</button>
</div>
</Teleport>
The to
target of <Teleport>
expects a CSS selector string or an actual DOM node. Here, we are essentially telling Vue to "teleport this template fragment to the body
tag".
You can click the button below and inspect the <body>
tag via your browser's devtools:
You can combine <Teleport>
with <Transition>
to create animated modals - see Example here.
TIP
The teleport to
target must be already in the DOM when the <Teleport>
component is mounted. Ideally, this should be an element outside the entire Vue application. If targeting another element rendered by Vue, you need to make sure that element is mounted before the <Teleport>
.
Using with Components
<Teleport>
only alters the rendered DOM structure - it does not affect the logical hierarchy of the components. That is to say, if <Teleport>
contains a component, that component will remain a logical child of the parent component containing the <Teleport>
. Props passing and event emitting will continue to work the same way.
This also means that injections from a parent component work as expected, and that the child component will be nested below the parent component in the Vue Devtools, instead of being placed where the actual content moved to.
Disabling Teleport
In some cases, we may want to conditionally disable <Teleport>
. For example, we may want to render a component as an overlay for desktop, but inline on mobile. <Teleport>
supports the disabled
prop which can be dynamically toggled:
template
<Teleport :disabled="isMobile">
...
</Teleport>
Where the isMobile
state can be dynamically updated by detecting media query changes.
Multiple Teleports on the Same Target
A common use case would be a reusable <Modal>
component, with the potential for multiple instances to be active at the same time. For this kind of scenario, multiple <Teleport>
components can mount their content to the same target element. The order will be a simple append - later mounts will be located after earlier ones within the target element.
Given the following usage:
template
<Teleport to="#modals">
<div>A</div>
</Teleport>
<Teleport to="#modals">
<div>B</div>
</Teleport>
The rendered result would be:
html
<div id="modals">
<div>A</div>
<div>B</div>
</div>
Relatedhhuh(hh	h}ubh)}(h}(hNh	}(h(https://vuejs.org/guide/components/slotsh
Slots | Vue.jsuhX=3  Slots
This page assumes you've already read the Components Basics. Read that first if you are new to components.
Slot Content and Outlet
We have learned that components can accept props, which can be JavaScript values of any type. But how about template content? In some cases, we may want to pass a template fragment to a child component, and let the child component render the fragment within its own template.
For example, we may have a <FancyButton>
component that supports usage like this:
template
<FancyButton>
Click me! <!-- slot content -->
</FancyButton>
The template of <FancyButton>
looks like this:
template
<button class="fancy-btn">
<slot></slot> <!-- slot outlet -->
</button>
The <slot>
element is a slot outlet that indicates where the parent-provided slot content should be rendered.
And the final rendered DOM:
html
<button class="fancy-btn">Click me!</button>
With slots, the <FancyButton>
is responsible for rendering the outer <button>
(and its fancy styling), while the inner content is provided by the parent component.
Another way to understand slots is by comparing them to JavaScript functions:
js
// parent component passing slot content
FancyButton('Click me!')
// FancyButton renders slot content in its own template
function FancyButton(slotContent) {
return `<button class="fancy-btn">
${slotContent}
</button>`
}
Slot content is not just limited to text. It can be any valid template content. For example, we can pass in multiple elements, or even other components:
template
<FancyButton>
<span style="color:red">Click me!</span>
<AwesomeIcon name="plus" />
</FancyButton>
By using slots, our <FancyButton>
is more flexible and reusable. We can now use it in different places with different inner content, but all with the same fancy styling.
Vue components' slot mechanism is inspired by the native Web Component <slot>
element, but with additional capabilities that we will see later.
Render Scope
Slot content has access to the data scope of the parent component, because it is defined in the parent. For example:
template
<span>{{ message }}</span>
<FancyButton>{{ message }}</FancyButton>
Here both {{ message }}
interpolations will render the same content.
Slot content does not have access to the child component's data. Expressions in Vue templates can only access the scope it is defined in, consistent with JavaScript's lexical scoping. In other words:
Expressions in the parent template only have access to the parent scope; expressions in the child template only have access to the child scope.
Fallback Content
There are cases when it's useful to specify fallback (i.e. default) content for a slot, to be rendered only when no content is provided. For example, in a <SubmitButton>
component:
template
<button type="submit">
<slot></slot>
</button>
We might want the text "Submit" to be rendered inside the <button>
if the parent didn't provide any slot content. To make "Submit" the fallback content, we can place it in between the <slot>
tags:
template
<button type="submit">
<slot>
Submit <!-- fallback content -->
</slot>
</button>
Now when we use <SubmitButton>
in a parent component, providing no content for the slot:
template
<SubmitButton />
This will render the fallback content, "Submit":
html
<button type="submit">Submit</button>
But if we provide content:
template
<SubmitButton>Save</SubmitButton>
Then the provided content will be rendered instead:
html
<button type="submit">Save</button>
Named Slots
There are times when it's useful to have multiple slot outlets in a single component. For example, in a <BaseLayout>
component with the following template:
template
<div class="container">
<header>
<!-- We want header content here -->
</header>
<main>
<!-- We want main content here -->
</main>
<footer>
<!-- We want footer content here -->
</footer>
</div>
For these cases, the <slot>
element has a special attribute, name
, which can be used to assign a unique ID to different slots so you can determine where content should be rendered:
template
<div class="container">
<header>
<slot name="header"></slot>
</header>
<main>
<slot></slot>
</main>
<footer>
<slot name="footer"></slot>
</footer>
</div>
A <slot>
outlet without name
implicitly has the name "default".
In a parent component using <BaseLayout>
, we need a way to pass multiple slot content fragments, each targeting a different slot outlet. This is where named slots come in.
To pass a named slot, we need to use a <template>
element with the v-slot
directive, and then pass the name of the slot as an argument to v-slot
:
template
<BaseLayout>
<template v-slot:header>
<!-- content for the header slot -->
</template>
</BaseLayout>
v-slot
has a dedicated shorthand #
, so <template v-slot:header>
can be shortened to just <template #header>
. Think of it as "render this template fragment in the child component's 'header' slot".
Here's the code passing content for all three slots to <BaseLayout>
using the shorthand syntax:
template
<BaseLayout>
<template #header>
<h1>Here might be a page title</h1>
</template>
<template #default>
<p>A paragraph for the main content.</p>
<p>And another one.</p>
</template>
<template #footer>
<p>Here's some contact info</p>
</template>
</BaseLayout>
When a component accepts both a default slot and named slots, all top-level non-<template>
nodes are implicitly treated as content for the default slot. So the above can also be written as:
template
<BaseLayout>
<template #header>
<h1>Here might be a page title</h1>
</template>
<!-- implicit default slot -->
<p>A paragraph for the main content.</p>
<p>And another one.</p>
<template #footer>
<p>Here's some contact info</p>
</template>
</BaseLayout>
Now everything inside the <template>
elements will be passed to the corresponding slots. The final rendered HTML will be:
html
<div class="container">
<header>
<h1>Here might be a page title</h1>
</header>
<main>
<p>A paragraph for the main content.</p>
<p>And another one.</p>
</main>
<footer>
<p>Here's some contact info</p>
</footer>
</div>
Again, it may help you understand named slots better using the JavaScript function analogy:
js
// passing multiple slot fragments with different names
BaseLayout({
header: `...`,
default: `...`,
footer: `...`
})
// <BaseLayout> renders them in different places
function BaseLayout(slots) {
return `<div class="container">
<header>${slots.header}</header>
<main>${slots.default}</main>
<footer>${slots.footer}</footer>
</div>`
}
Conditional Slots
Sometimes you want to render something based on whether or not a slot is present.
You can use the $slots property in combination with a v-if to achieve this.
In the example below we define a Card component with three conditional slots: header
, footer
and the default
one. When the header / footer / default is present we want to wrap them to provide additional styling:
template
<template>
<div class="card">
<div v-if="$slots.header" class="card-header">
<slot name="header" />
</div>
<div v-if="$slots.default" class="card-content">
<slot />
</div>
<div v-if="$slots.footer" class="card-footer">
<slot name="footer" />
</div>
</div>
</template>
Dynamic Slot Names
Dynamic directive arguments also work on v-slot
, allowing the definition of dynamic slot names:
template
<base-layout>
<template v-slot:[dynamicSlotName]>
...
</template>
<!-- with shorthand -->
<template #[dynamicSlotName]>
...
</template>
</base-layout>
Do note the expression is subject to the syntax constraints of dynamic directive arguments.
Scoped Slots
As discussed in Render Scope, slot content does not have access to state in the child component.
However, there are cases where it could be useful if a slot's content can make use of data from both the parent scope and the child scope. To achieve that, we need a way for the child to pass data to a slot when rendering it.
In fact, we can do exactly that - we can pass attributes to a slot outlet just like passing props to a component:
template
<!-- <MyComponent> template -->
<div>
<slot :text="greetingMessage" :count="1"></slot>
</div>
Receiving the slot props is a bit different when using a single default slot vs. using named slots. We are going to show how to receive props using a single default slot first, by using v-slot
directly on the child component tag:
template
<MyComponent v-slot="slotProps">
{{ slotProps.text }} {{ slotProps.count }}
</MyComponent>
The props passed to the slot by the child are available as the value of the corresponding v-slot
directive, which can be accessed by expressions inside the slot.
You can think of a scoped slot as a function being passed into the child component. The child component then calls it, passing props as arguments:
js
MyComponent({
// passing the default slot, but as a function
default: (slotProps) => {
return `${slotProps.text} ${slotProps.count}`
}
})
function MyComponent(slots) {
const greetingMessage = 'hello'
return `<div>${
// call the slot function with props!
slots.default({ text: greetingMessage, count: 1 })
}</div>`
}
In fact, this is very close to how scoped slots are compiled, and how you would use scoped slots in manual render functions.
Notice how v-slot="slotProps"
matches the slot function signature. Just like with function arguments, we can use destructuring in v-slot
:
template
<MyComponent v-slot="{ text, count }">
{{ text }} {{ count }}
</MyComponent>
Named Scoped Slots
Named scoped slots work similarly - slot props are accessible as the value of the v-slot
directive: v-slot:name="slotProps"
. When using the shorthand, it looks like this:
template
<MyComponent>
<template #header="headerProps">
{{ headerProps }}
</template>
<template #default="defaultProps">
{{ defaultProps }}
</template>
<template #footer="footerProps">
{{ footerProps }}
</template>
</MyComponent>
Passing props to a named slot:
template
<slot name="header" message="hello"></slot>
Note the name
of a slot won't be included in the props because it is reserved - so the resulting headerProps
would be { message: 'hello' }
.
If you are mixing named slots with the default scoped slot, you need to use an explicit <template>
tag for the default slot. Attempting to place the v-slot
directive directly on the component will result in a compilation error. This is to avoid any ambiguity about the scope of the props of the default slot. For example:
template
<!-- <MyComponent> template -->
<div>
<slot :message="hello"></slot>
<slot name="footer" />
</div>
template
<!-- This template won't compile -->
<MyComponent v-slot="{ message }">
<p>{{ message }}</p>
<template #footer>
<!-- message belongs to the default slot, and is not available here -->
<p>{{ message }}</p>
</template>
</MyComponent>
Using an explicit <template>
tag for the default slot helps to make it clear that the message
prop is not available inside the other slot:
template
<MyComponent>
<!-- Use explicit default slot -->
<template #default="{ message }">
<p>{{ message }}</p>
</template>
<template #footer>
<p>Here's some contact info</p>
</template>
</MyComponent>
Fancy List Example
You may be wondering what would be a good use case for scoped slots. Here's an example: imagine a <FancyList>
component that renders a list of items - it may encapsulate the logic for loading remote data, using the data to display a list, or even advanced features like pagination or infinite scrolling. However, we want it to be flexible with how each item looks and leave the styling of each item to the parent component consuming it. So the desired usage may look like this:
template
<FancyList :api-url="url" :per-page="10">
<template #item="{ body, username, likes }">
<div class="item">
<p>{{ body }}</p>
<p>by {{ username }} | {{ likes }} likes</p>
</div>
</template>
</FancyList>
Inside <FancyList>
, we can render the same <slot>
multiple times with different item data (notice we are using v-bind
to pass an object as slot props):
template
<ul>
<li v-for="item in items">
<slot name="item" v-bind="item"></slot>
</li>
</ul>
Renderless Components
The <FancyList>
use case we discussed above encapsulates both reusable logic (data fetching, pagination etc.) and visual output, while delegating part of the visual output to the consumer component via scoped slots.
If we push this concept a bit further, we can come up with components that only encapsulate logic and do not render anything by themselves - visual output is fully delegated to the consumer component with scoped slots. We call this type of component a Renderless Component.
An example renderless component could be one that encapsulates the logic of tracking the current mouse position:
template
<MouseTracker v-slot="{ x, y }">
Mouse is at: {{ x }}, {{ y }}
</MouseTracker>
While an interesting pattern, most of what can be achieved with Renderless Components can be achieved in a more efficient fashion with Composition API, without incurring the overhead of extra component nesting. Later, we will see how we can implement the same mouse tracking functionality as a Composable.
That said, scoped slots are still useful in cases where we need to both encapsulate logic and compose visual output, like in the <FancyList>
example.     hhuh(hh	h}ubh)}(h}(hNh	}(h(https://vuejs.org/guide/extras/animationh
Animation Techniques | Vue.jsuhX  Animation Techniques
Vue provides the <Transition>
and <TransitionGroup>
components for handling enter / leave and list transitions. However, there are many other ways of using animations on the web, even in a Vue application. Here we will discuss a few additional techniques.
Class-based Animations
For elements that are not entering / leaving the DOM, we can trigger animations by dynamically adding a CSS class:
js
const disabled = ref(false)
function warnDisabled() {
disabled.value = true
setTimeout(() => {
disabled.value = false
}, 1500)
}
template
<div :class="{ shake: disabled }">
<button @click="warnDisabled">Click me</button>
<span v-if="disabled">This feature is disabled!</span>
</div>
css
.shake {
animation: shake 0.82s cubic-bezier(0.36, 0.07, 0.19, 0.97) both;
transform: translate3d(0, 0, 0);
}
@keyframes shake {
10%,
90% {
transform: translate3d(-1px, 0, 0);
}
20%,
80% {
transform: translate3d(2px, 0, 0);
}
30%,
50%,
70% {
transform: translate3d(-4px, 0, 0);
}
40%,
60% {
transform: translate3d(4px, 0, 0);
}
}
State-driven Animations
Some transition effects can be applied by interpolating values, for instance by binding a style to an element while an interaction occurs. Take this example for instance:
js
const x = ref(0)
function onMousemove(e) {
x.value = e.clientX
}
template
<div
@mousemove="onMousemove"
:style="{ backgroundColor: `hsl(${x}, 80%, 50%)` }"
class="movearea"
>
<p>Move your mouse across this div...</p>
<p>x: {{ x }}</p>
</div>
css
.movearea {
transition: 0.3s background-color ease;
}
Move your mouse across this div...
x: 0
In addition to color, you can also use style bindings to animate transform, width, or height. You can even animate SVG paths using spring physics - after all, they are all attribute data bindings:
Drag Me
Animating with Watchers
With some creativity, we can use watchers to animate anything based on some numerical state. For example, we can animate the number itself:
js
import { ref, reactive, watch } from 'vue'
import gsap from 'gsap'
const number = ref(0)
const tweened = reactive({
number: 0
})
watch(number, (n) => {
gsap.to(tweened, { duration: 0.5, number: Number(n) || 0 })
})
template
Type a number: <input v-model.number="number" />
<p>{{ tweened.number.toFixed(0) }}</p>
Type a number:
0hhuh(hh	h}ubh)}(h}(hNh	}(h2https://vuejs.org/guide/essentials/class-and-styleh
!Class and Style Bindings | Vue.jsuhX  Class and Style Bindings
A common need for data binding is manipulating an element's class list and inline styles. Since class
and style
are both attributes, we can use v-bind
to assign them a string value dynamically, much like with other attributes. However, trying to generate those values using string concatenation can be annoying and error-prone. For this reason, Vue provides special enhancements when v-bind
is used with class
and style
. In addition to strings, the expressions can also evaluate to objects or arrays.
Binding HTML Classes
Binding to Objects
We can pass an object to :class
(short for v-bind:class
) to dynamically toggle classes:
template
<div :class="{ active: isActive }"></div>
The above syntax means the presence of the active
class will be determined by the truthiness of the data property isActive
.
You can have multiple classes toggled by having more fields in the object. In addition, the :class
directive can also co-exist with the plain class
attribute. So given the following state:
js
const isActive = ref(true)
const hasError = ref(false)
And the following template:
template
<div
class="static"
:class="{ active: isActive, 'text-danger': hasError }"
></div>
It will render:
template
<div class="static active"></div>
When isActive
or hasError
changes, the class list will be updated accordingly. For example, if hasError
becomes true
, the class list will become "static active text-danger"
.
The bound object doesn't have to be inline:
js
const classObject = reactive({
active: true,
'text-danger': false
})
template
<div :class="classObject"></div>
This will render:
template
<div class="active"></div>
We can also bind to a computed property that returns an object. This is a common and powerful pattern:
js
const isActive = ref(true)
const error = ref(null)
const classObject = computed(() => ({
active: isActive.value && !error.value,
'text-danger': error.value && error.value.type === 'fatal'
}))
template
<div :class="classObject"></div>
Binding to Arrays
We can bind :class
to an array to apply a list of classes:
js
const activeClass = ref('active')
const errorClass = ref('text-danger')
template
<div :class="[activeClass, errorClass]"></div>
Which will render:
template
<div class="active text-danger"></div>
If you would like to also toggle a class in the list conditionally, you can do it with a ternary expression:
template
<div :class="[isActive ? activeClass : '', errorClass]"></div>
This will always apply errorClass
, but activeClass
will only be applied when isActive
is truthy.
However, this can be a bit verbose if you have multiple conditional classes. That's why it's also possible to use the object syntax inside the array syntax:
template
<div :class="[{ [activeClass]: isActive }, errorClass]"></div>
With Components
This section assumes knowledge of Components. Feel free to skip it and come back later.
When you use the class
attribute on a component with a single root element, those classes will be added to the component's root element and merged with any existing class already on it.
For example, if we have a component named MyComponent
with the following template:
template
<!-- child component template -->
<p class="foo bar">Hi!</p>
Then add some classes when using it:
template
<!-- when using the component -->
<MyComponent class="baz boo" />
The rendered HTML will be:
template
<p class="foo bar baz boo">Hi!</p>
The same is true for class bindings:
template
<MyComponent :class="{ active: isActive }" />
When isActive
is truthy, the rendered HTML will be:
template
<p class="foo bar active">Hi!</p>
If your component has multiple root elements, you would need to define which element will receive this class. You can do this using the $attrs
component property:
template
<!-- MyComponent template using $attrs -->
<p :class="$attrs.class">Hi!</p>
<span>This is a child component</span>
template
<MyComponent class="baz" />
Will render:
html
<p class="baz">Hi!</p>
<span>This is a child component</span>
You can learn more about component attribute inheritance in Fallthrough Attributes section.
Binding Inline Styles
Binding to Objects
:style
supports binding to JavaScript object values - it corresponds to an HTML element's style
property:
js
const activeColor = ref('red')
const fontSize = ref(30)
template
<div :style="{ color: activeColor, fontSize: fontSize + 'px' }"></div>
Although camelCase keys are recommended, :style
also supports kebab-cased CSS property keys (corresponds to how they are used in actual CSS) - for example:
template
<div :style="{ 'font-size': fontSize + 'px' }"></div>
It is often a good idea to bind to a style object directly so that the template is cleaner:
js
const styleObject = reactive({
color: 'red',
fontSize: '30px'
})
template
<div :style="styleObject"></div>
Again, object style binding is often used in conjunction with computed properties that return objects.
Binding to Arrays
We can bind :style
to an array of multiple style objects. These objects will be merged and applied to the same element:
template
<div :style="[baseStyles, overridingStyles]"></div>
Auto-prefixing
When you use a CSS property that requires a vendor prefix in :style
, Vue will automatically add the appropriate prefix. Vue does this by checking at runtime to see which style properties are supported in the current browser. If the browser doesn't support a particular property then various prefixed variants will be tested to try to find one that is supported.
Multiple Values
You can provide an array of multiple (prefixed) values to a style property, for example:
template
<div :style="{ display: ['-webkit-box', '-ms-flexbox', 'flex'] }"></div>
This will only render the last value in the array which the browser supports. In this example, it will render display: flex
for browsers that support the unprefixed version of flexbox.hhuh(hh	h}ubh)}(h}(hNh	}(h0https://vuejs.org/guide/essentials/template-refsh
Template Refs | Vue.jsuhX  Template Refs
While Vue's declarative rendering model abstracts away most of the direct DOM operations for you, there may still be cases where we need direct access to the underlying DOM elements. To achieve this, we can use the special ref
attribute:
template
<input ref="input">
ref
is a special attribute, similar to the key
attribute discussed in the v-for
chapter. It allows us to obtain a direct reference to a specific DOM element or child component instance after it's mounted. This may be useful when you want to, for example, programmatically focus an input on component mount, or initialize a 3rd party library on an element.
Accessing the Refs
To obtain the reference with Composition API, we need to declare a ref with a name that matches the template ref attribute's value:
vue
<script setup>
import { ref, onMounted } from 'vue'
// declare a ref to hold the element reference
// the name must match template ref value
const input = ref(null)
onMounted(() => {
input.value.focus()
})
</script>
<template>
<input ref="input" />
</template>
If not using <script setup>
, make sure to also return the ref from setup()
:
js
export default {
setup() {
const input = ref(null)
// ...
return {
input
}
}
}
Note that you can only access the ref after the component is mounted. If you try to access input
in a template expression, it will be null
on the first render. This is because the element doesn't exist until after the first render!
If you are trying to watch the changes of a template ref, make sure to account for the case where the ref has null
value:
js
watchEffect(() => {
if (input.value) {
input.value.focus()
} else {
// not mounted yet, or the element was unmounted (e.g. by v-if)
}
})
See also: Typing Template Refs
Refs inside v-for
Requires v3.2.25 or above
When ref
is used inside v-for
, the corresponding ref should contain an Array value, which will be populated with the elements after mount:
vue
<script setup>
import { ref, onMounted } from 'vue'
const list = ref([
/* ... */
])
const itemRefs = ref([])
onMounted(() => console.log(itemRefs.value))
</script>
<template>
<ul>
<li v-for="item in list" ref="itemRefs">
{{ item }}
</li>
</ul>
</template>
It should be noted that the ref array does not guarantee the same order as the source array.
Function Refs
Instead of a string key, the ref
attribute can also be bound to a function, which will be called on each component update and gives you full flexibility on where to store the element reference. The function receives the element reference as the first argument:
template
<input :ref="(el) => { /* assign el to a property or ref */ }">
Note we are using a dynamic :ref
binding so we can pass it a function instead of a ref name string. When the element is unmounted, the argument will be null
. You can, of course, use a method instead of an inline function.
Ref on Component
This section assumes knowledge of Components. Feel free to skip it and come back later.
ref
can also be used on a child component. In this case the reference will be that of a component instance:
vue
<script setup>
import { ref, onMounted } from 'vue'
import Child from './Child.vue'
const child = ref(null)
onMounted(() => {
// child.value will hold an instance of <Child />
})
</script>
<template>
<Child ref="child" />
</template>
If the child component is using Options API or not using <script setup>
, the referenced instance will be identical to the child component's this
, which means the parent component will have full access to every property and method of the child component. This makes it easy to create tightly coupled implementation details between the parent and the child, so component refs should be only used when absolutely needed - in most cases, you should try to implement parent / child interactions using the standard props and emit interfaces first.
An exception here is that components using <script setup>
are private by default: a parent component referencing a child component using <script setup>
won't be able to access anything unless the child component chooses to expose a public interface using the defineExpose
macro:
vue
<script setup>
import { ref } from 'vue'
const a = 1
const b = ref(2)
// Compiler macros, such as defineExpose, don't need to be imported
defineExpose({
a,
b
})
</script>
When a parent gets an instance of this component via template refs, the retrieved instance will be of the shape { a: number, b: number }
(refs are automatically unwrapped just like on normal instances).
See also: Typing Component Template Refshhuh(hh	h}ubh)}(h}(hNh	}(h2https://vuejs.org/guide/extras/composition-api-faqh
Composition API FAQ | Vue.jsuhX.  Composition API FAQ
TIP
This FAQ assumes prior experience with Vue - in particular, experience with Vue 2 while primarily using Options API.
What is Composition API?
Composition API is a set of APIs that allows us to author Vue components using imported functions instead of declaring options. It is an umbrella term that covers the following APIs:
Reactivity API, e.g.
ref()
andreactive()
, that allows us to directly create reactive state, computed state, and watchers.Lifecycle Hooks, e.g.
onMounted()
andonUnmounted()
, that allow us to programmatically hook into the component lifecycle.Dependency Injection, i.e.
provide()
andinject()
, that allow us to leverage Vue's dependency injection system while using Reactivity APIs.
Composition API is a built-in feature of Vue 3 and Vue 2.7. For older Vue 2 versions, use the officially maintained @vue/composition-api
plugin. In Vue 3, it is also primarily used together with the <script setup>
syntax in Single-File Components. Here's a basic example of a component using Composition API:
vue
<script setup>
import { ref, onMounted } from 'vue'
// reactive state
const count = ref(0)
// functions that mutate state and trigger updates
function increment() {
count.value++
}
// lifecycle hooks
onMounted(() => {
console.log(`The initial count is ${count.value}.`)
})
</script>
<template>
<button @click="increment">Count is: {{ count }}</button>
</template>
Despite an API style based on function composition, Composition API is NOT functional programming. Composition API is based on Vue's mutable, fine-grained reactivity paradigm, whereas functional programming emphasizes immutability.
If you are interested in learning how to use Vue with Composition API, you can set the site-wide API preference to Composition API using the toggle at the top of the left sidebar, and then go through the guide from the beginning.
Why Composition API?
Better Logic Reuse
The primary advantage of Composition API is that it enables clean, efficient logic reuse in the form of Composable functions. It solves all the drawbacks of mixins, the primary logic reuse mechanism for Options API.
Composition API's logic reuse capability has given rise to impressive community projects such as VueUse, an ever-growing collection of composable utilities. It also serves as a clean mechanism for easily integrating stateful third-party services or libraries into Vue's reactivity system, for example immutable data, state machines, and RxJS.
More Flexible Code Organization
Many users love that we write organized code by default with Options API: everything has its place based on the option it falls under. However, Options API poses serious limitations when a single component's logic grows beyond a certain complexity threshold. This limitation is particularly prominent in components that need to deal with multiple logical concerns, which we have witnessed first hand in many production Vue 2 apps.
Take the folder explorer component from Vue CLI's GUI as an example: this component is responsible for the following logical concerns:
- Tracking current folder state and displaying its content
- Handling folder navigation (opening, closing, refreshing...)
- Handling new folder creation
- Toggling show favorite folders only
- Toggling show hidden folders
- Handling current working directory changes
The original version of the component was written in Options API. If we give each line of code a color based on the logical concern it is dealing with, this is how it looks:
Notice how code dealing with the same logical concern is forced to be split under different options, located in different parts of the file. In a component that is several hundred lines long, understanding and navigating a single logical concern requires constantly scrolling up and down the file, making it much more difficult than it should be. In addition, if we ever intend to extract a logical concern into a reusable utility, it takes quite a bit of work to find and extract the right pieces of code from different parts of the file.
Here's the same component, before and after the refactor into Composition API:
Notice how the code related to the same logical concern can now be grouped together: we no longer need to jump between different options blocks while working on a specific logical concern. Moreover, we can now move a group of code into an external file with minimal effort, since we no longer need to shuffle the code around in order to extract them. This reduced friction for refactoring is key to the long-term maintainability in large codebases.
Better Type Inference
In recent years, more and more frontend developers are adopting TypeScript as it helps us write more robust code, make changes with more confidence, and provides a great development experience with IDE support. However, the Options API, originally conceived in 2013, was designed without type inference in mind. We had to implement some absurdly complex type gymnastics to make type inference work with the Options API. Even with all this effort, type inference for Options API can still break down for mixins and dependency injection.
This had led many developers who wanted to use Vue with TS to lean towards Class API powered by vue-class-component
. However, a class-based API heavily relies on ES decorators, a language feature that was only a stage 2 proposal when Vue 3 was being developed in 2019. We felt it was too risky to base an official API on an unstable proposal. Since then, the decorators proposal has gone through yet another complete overhaul, and finally reached stage 3 in 2022. In addition, class-based API suffers from logic reuse and organization limitations similar to Options API.
In comparison, Composition API utilizes mostly plain variables and functions, which are naturally type friendly. Code written in Composition API can enjoy full type inference with little need for manual type hints. Most of the time, Composition API code will look largely identical in TypeScript and plain JavaScript. This also makes it possible for plain JavaScript users to benefit from partial type inference.
Smaller Production Bundle and Less Overhead
Code written in Composition API and <script setup>
is also more efficient and minification-friendly than Options API equivalent. This is because the template in a <script setup>
component is compiled as a function inlined in the same scope of the <script setup>
code. Unlike property access from this
, the compiled template code can directly access variables declared inside <script setup>
, without an instance proxy in between. This also leads to better minification because all the variable names can be safely shortened.
Relationship with Options API
Trade-offs
Some users moving from Options API found their Composition API code less organized, and concluded that Composition API is "worse" in terms of code organization. We recommend users with such opinions to look at that problem from a different perspective.
It is true that Composition API no longer provides the "guard rails" that guide you to put your code into respective buckets. In return, you get to author component code like how you would write normal JavaScript. This means you can and should apply any code organization best practices to your Composition API code as you would when writing normal JavaScript. If you can write well-organized JavaScript, you should also be able to write well-organized Composition API code.
Options API does allow you to "think less" when writing component code, which is why many users love it. However, in reducing the mental overhead, it also locks you into the prescribed code organization pattern with no escape hatch, which can make it difficult to refactor or improve code quality in larger scale projects. In this regard, Composition API provides better long term scalability.
Does Composition API cover all use cases?
Yes in terms of stateful logic. When using Composition API, there are only a few options that may still be needed: props
, emits
, name
, and inheritAttrs
.
TIP
Since 3.3 you can directly use defineOptions
in <script setup>
to set the component name or inheritAttrs
property
If you intend to exclusively use Composition API (along with the options listed above), you can shave a few kbs off your production bundle via a compile-time flag that drops Options API related code from Vue. Note this also affects Vue components in your dependencies.
Can I use both APIs in the same component?
Yes. You can use Composition API via the setup()
option in an Options API component.
However, we only recommend doing so if you have an existing Options API codebase that needs to integrate with new features / external libraries written with Composition API.
Will Options API be deprecated?
No, we do not have any plan to do so. Options API is an integral part of Vue and the reason many developers love it. We also realize that many of the benefits of Composition API only manifest in larger-scale projects, and Options API remains a solid choice for many low-to-medium-complexity scenarios.
Relationship with Class API
We no longer recommend using Class API with Vue 3, given that Composition API provides great TypeScript integration with additional logic reuse and code organization benefits.
Comparison with React Hooks
Composition API provides the same level of logic composition capabilities as React Hooks, but with some important differences.
React Hooks are invoked repeatedly every time a component updates. This creates a number of caveats that can confuse even seasoned React developers. It also leads to performance optimization issues that can severely affect development experience. Here are some examples:
Hooks are call-order sensitive and cannot be conditional.
Variables declared in a React component can be captured by a hook closure and become "stale" if the developer fails to pass in the correct dependencies array. This leads to React developers relying on ESLint rules to ensure correct dependencies are passed. However, the rule is often not smart enough and over-compensates for correctness, which leads to unnecessary invalidation and headaches when edge cases are encountered.
Expensive computations require the use of
useMemo
, which again requires manually passing in the correct dependencies array.Event handlers passed to child components cause unnecessary child updates by default, and require explicit
useCallback
as an optimization. This is almost always needed, and again requires a correct dependencies array. Neglecting this leads to over-rendering apps by default and can cause performance issues without realizing it.The stale closure problem, combined with Concurrent features, makes it difficult to reason about when a piece of hooks code is run, and makes working with mutable state that should persist across renders (via
useRef
) cumbersome.
Note: some of the above issues that are related to memoization can be resolved by the upcoming React Compiler.
In comparison, Vue Composition API:
Invokes
setup()
or<script setup>
code only once. This makes the code align better with the intuitions of idiomatic JavaScript usage as there are no stale closures to worry about. Composition API calls are also not sensitive to call order and can be conditional.Vue's runtime reactivity system automatically collects reactive dependencies used in computed properties and watchers, so there's no need to manually declare dependencies.
No need to manually cache callback functions to avoid unnecessary child updates. In general, Vue's fine-grained reactivity system ensures child components only update when they need to. Manual child-update optimizations are rarely a concern for Vue developers.
We acknowledge the creativity of React Hooks, and it is a major source of inspiration for Composition API. However, the issues mentioned above do exist in its design and we noticed Vue's reactivity model happens to provide a way around them.hhuh(hh	h}ubh)}(h}(hNh	}(h/https://vuejs.org/guide/components/registrationh
Component Registration | Vue.jsuhX/  Component Registration
This page assumes you've already read the Components Basics. Read that first if you are new to components.
A Vue component needs to be "registered" so that Vue knows where to locate its implementation when it is encountered in a template. There are two ways to register components: global and local.
Global Registration
We can make components available globally in the current Vue application using the .component()
method:
js
import { createApp } from 'vue'
const app = createApp({})
app.component(
// the registered name
'MyComponent',
// the implementation
{
/* ... */
}
)
If using SFCs, you will be registering the imported .vue
files:
js
import MyComponent from './App.vue'
app.component('MyComponent', MyComponent)
The .component()
method can be chained:
js
app
.component('ComponentA', ComponentA)
.component('ComponentB', ComponentB)
.component('ComponentC', ComponentC)
Globally registered components can be used in the template of any component within this application:
template
<!-- this will work in any component inside the app -->
<ComponentA/>
<ComponentB/>
<ComponentC/>
This even applies to all subcomponents, meaning all three of these components will also be available inside each other.
Local Registration
While convenient, global registration has a few drawbacks:
Global registration prevents build systems from removing unused components (a.k.a "tree-shaking"). If you globally register a component but end up not using it anywhere in your app, it will still be included in the final bundle.
Global registration makes dependency relationships less explicit in large applications. It makes it difficult to locate a child component's implementation from a parent component using it. This can affect long-term maintainability similar to using too many global variables.
Local registration scopes the availability of the registered components to the current component only. It makes the dependency relationship more explicit, and is more tree-shaking friendly.
When using SFC with <script setup>
, imported components can be locally used without registration:
vue
<script setup>
import ComponentA from './ComponentA.vue'
</script>
<template>
<ComponentA />
</template>
In non-<script setup>
, you will need to use the components
option:
js
import ComponentA from './ComponentA.js'
export default {
components: {
ComponentA
},
setup() {
// ...
}
}
For each property in the components
object, the key will be the registered name of the component, while the value will contain the implementation of the component. The above example is using the ES2015 property shorthand and is equivalent to:
js
export default {
components: {
ComponentA: ComponentA
}
// ...
}
Note that locally registered components are not also available in descendant components. In this case, ComponentA
will be made available to the current component only, not any of its child or descendant components.
Component Name Casing
Throughout the guide, we are using PascalCase names when registering components. This is because:
PascalCase names are valid JavaScript identifiers. This makes it easier to import and register components in JavaScript. It also helps IDEs with auto-completion.
<PascalCase />
makes it more obvious that this is a Vue component instead of a native HTML element in templates. It also differentiates Vue components from custom elements (web components).
This is the recommended style when working with SFC or string templates. However, as discussed in in-DOM Template Parsing Caveats, PascalCase tags are not usable in in-DOM templates.
Luckily, Vue supports resolving kebab-case tags to components registered using PascalCase. This means a component registered as MyComponent
can be referenced in the template via both <MyComponent>
and <my-component>
. This allows us to use the same JavaScript component registration code regardless of template source.hhuh(hh	h}ubh)}(h}(hNh	}(h(https://vuejs.org/guide/components/propsh
Props | Vue.jsuhX,  Props
This page assumes you've already read the Components Basics. Read that first if you are new to components.
Props Declaration
Vue components require explicit props declaration so that Vue knows what external props passed to the component should be treated as fallthrough attributes (which will be discussed in its dedicated section).
In SFCs using <script setup>
, props can be declared using the defineProps()
macro:
vue
<script setup>
const props = defineProps(['foo'])
console.log(props.foo)
</script>
In non-<script setup>
components, props are declared using the props
option:
js
export default {
props: ['foo'],
setup(props) {
// setup() receives props as the first argument.
console.log(props.foo)
}
}
Notice the argument passed to defineProps()
is the same as the value provided to the props
options: the same props options API is shared between the two declaration styles.
In addition to declaring props using an array of strings, we can also use the object syntax:
js
// in <script setup>
defineProps({
title: String,
likes: Number
})
js
// in non-<script setup>
export default {
props: {
title: String,
likes: Number
}
}
For each property in the object declaration syntax, the key is the name of the prop, while the value should be the constructor function of the expected type.
This not only documents your component, but will also warn other developers using your component in the browser console if they pass the wrong type. We will discuss more details about prop validation further down this page.
If you are using TypeScript with <script setup>
, it's also possible to declare props using pure type annotations:
vue
<script setup lang="ts">
defineProps<{
title?: string
likes?: number
}>()
</script>
More details: Typing Component Props
Prop Passing Details
Prop Name Casing
We declare long prop names using camelCase because this avoids having to use quotes when using them as property keys, and allows us to reference them directly in template expressions because they are valid JavaScript identifiers:
js
defineProps({
greetingMessage: String
})
template
<span>{{ greetingMessage }}</span>
Technically, you can also use camelCase when passing props to a child component (except in in-DOM templates). However, the convention is using kebab-case in all cases to align with HTML attributes:
template
<MyComponent greeting-message="hello" />
We use PascalCase for component tags when possible because it improves template readability by differentiating Vue components from native elements. However, there isn't as much practical benefit in using camelCase when passing props, so we choose to follow each language's conventions.
Static vs. Dynamic Props
So far, you've seen props passed as static values, like in:
template
<BlogPost title="My journey with Vue" />
You've also seen props assigned dynamically with v-bind
or its :
shortcut, such as in:
template
<!-- Dynamically assign the value of a variable -->
<BlogPost :title="post.title" />
<!-- Dynamically assign the value of a complex expression -->
<BlogPost :title="post.title + ' by ' + post.author.name" />
Passing Different Value Types
In the two examples above, we happen to pass string values, but any type of value can be passed to a prop.
Number
template
<!-- Even though `42` is static, we need v-bind to tell Vue that -->
<!-- this is a JavaScript expression rather than a string. -->
<BlogPost :likes="42" />
<!-- Dynamically assign to the value of a variable. -->
<BlogPost :likes="post.likes" />
Boolean
template
<!-- Including the prop with no value will imply `true`. -->
<BlogPost is-published />
<!-- Even though `false` is static, we need v-bind to tell Vue that -->
<!-- this is a JavaScript expression rather than a string. -->
<BlogPost :is-published="false" />
<!-- Dynamically assign to the value of a variable. -->
<BlogPost :is-published="post.isPublished" />
Array
template
<!-- Even though the array is static, we need v-bind to tell Vue that -->
<!-- this is a JavaScript expression rather than a string. -->
<BlogPost :comment-ids="[234, 266, 273]" />
<!-- Dynamically assign to the value of a variable. -->
<BlogPost :comment-ids="post.commentIds" />
Object
template
<!-- Even though the object is static, we need v-bind to tell Vue that -->
<!-- this is a JavaScript expression rather than a string. -->
<BlogPost
:author="{
name: 'Veronica',
company: 'Veridian Dynamics'
}"
/>
<!-- Dynamically assign to the value of a variable. -->
<BlogPost :author="post.author" />
Binding Multiple Properties Using an Object
If you want to pass all the properties of an object as props, you can use v-bind
without an argument (v-bind
instead of :prop-name
). For example, given a post
object:
js
const post = {
id: 1,
title: 'My Journey with Vue'
}
The following template:
template
<BlogPost v-bind="post" />
Will be equivalent to:
template
<BlogPost :id="post.id" :title="post.title" />
One-Way Data Flow
All props form a one-way-down binding between the child property and the parent one: when the parent property updates, it will flow down to the child, but not the other way around. This prevents child components from accidentally mutating the parent's state, which can make your app's data flow harder to understand.
In addition, every time the parent component is updated, all props in the child component will be refreshed with the latest value. This means you should not attempt to mutate a prop inside a child component. If you do, Vue will warn you in the console:
js
const props = defineProps(['foo'])
// ❌ warning, props are readonly!
props.foo = 'bar'
There are usually two cases where it's tempting to mutate a prop:
The prop is used to pass in an initial value; the child component wants to use it as a local data property afterwards. In this case, it's best to define a local data property that uses the prop as its initial value:
jsconst props = defineProps(['initialCounter']) // counter only uses props.initialCounter as the initial value; // it is disconnected from future prop updates. const counter = ref(props.initialCounter)
The prop is passed in as a raw value that needs to be transformed. In this case, it's best to define a computed property using the prop's value:
jsconst props = defineProps(['size']) // computed property that auto-updates when the prop changes const normalizedSize = computed(() => props.size.trim().toLowerCase())
Mutating Object / Array Props
When objects and arrays are passed as props, while the child component cannot mutate the prop binding, it will be able to mutate the object or array's nested properties. This is because in JavaScript objects and arrays are passed by reference, and it is unreasonably expensive for Vue to prevent such mutations.
The main drawback of such mutations is that it allows the child component to affect parent state in a way that isn't obvious to the parent component, potentially making it more difficult to reason about the data flow in the future. As a best practice, you should avoid such mutations unless the parent and child are tightly coupled by design. In most cases, the child should emit an event to let the parent perform the mutation.
Prop Validation
Components can specify requirements for their props, such as the types you've already seen. If a requirement is not met, Vue will warn you in the browser's JavaScript console. This is especially useful when developing a component that is intended to be used by others.
To specify prop validations, you can provide an object with validation requirements to the defineProps()
macro , instead of an array of strings. For example:
js
defineProps({
// Basic type check
// (`null` and `undefined` values will allow any type)
propA: Number,
// Multiple possible types
propB: [String, Number],
// Required string
propC: {
type: String,
required: true
},
// Required but nullable string
propD: {
type: [String, null],
required: true
},
// Number with a default value
propE: {
type: Number,
default: 100
},
// Object with a default value
propF: {
type: Object,
// Object or array defaults must be returned from
// a factory function. The function receives the raw
// props received by the component as the argument.
default(rawProps) {
return { message: 'hello' }
}
},
// Custom validator function
// full props passed as 2nd argument in 3.4+
propG: {
validator(value, props) {
// The value must match one of these strings
return ['success', 'warning', 'danger'].includes(value)
}
},
// Function with a default value
propH: {
type: Function,
// Unlike object or array default, this is not a factory
// function - this is a function to serve as a default value
default() {
return 'Default function'
}
}
})
TIP
Code inside the defineProps()
argument cannot access other variables declared in <script setup>
, because the entire expression is moved to an outer function scope when compiled.
Additional details:
All props are optional by default, unless
required: true
is specified.An absent optional prop other than
Boolean
will haveundefined
value.The
Boolean
absent props will be cast tofalse
. You can change this by setting adefault
for it — i.e.:default: undefined
to behave as a non-Boolean prop.If a
default
value is specified, it will be used if the resolved prop value isundefined
- this includes both when the prop is absent, or an explicitundefined
value is passed.
When prop validation fails, Vue will produce a console warning (if using the development build).
If using Type-based props declarations , Vue will try its best to compile the type annotations into equivalent runtime prop declarations. For example, defineProps<{ msg: string }>
will be compiled into { msg: { type: String, required: true }}
.
Runtime Type Checks
The type
can be one of the following native constructors:
String
Number
Boolean
Array
Object
Date
Function
Symbol
Error
In addition, type
can also be a custom class or constructor function and the assertion will be made with an instanceof
check. For example, given the following class:
js
class Person {
constructor(firstName, lastName) {
this.firstName = firstName
this.lastName = lastName
}
}
You could use it as a prop's type:
js
defineProps({
author: Person
})
Vue will use instanceof Person
to validate whether the value of the author
prop is indeed an instance of the Person
class.
Nullable Type
If the type is required but nullable, you can use the array syntax that includes null
:
js
defineProps({
id: {
type: [String, null],
required: true
}
})
Note that if type
is just null
without using the array syntax, it will allow any type.
Boolean Casting
Props with Boolean
type have special casting rules to mimic the behavior of native boolean attributes. Given a <MyComponent>
with the following declaration:
js
defineProps({
disabled: Boolean
})
The component can be used like this:
template
<!-- equivalent of passing :disabled="true" -->
<MyComponent disabled />
<!-- equivalent of passing :disabled="false" -->
<MyComponent />
When a prop is declared to allow multiple types, the casting rules for Boolean
will also be applied. However, there is an edge when both String
and Boolean
are allowed - the Boolean casting rule only applies if Boolean appears before String:
js
// disabled will be casted to true
defineProps({
disabled: [Boolean, Number]
})
// disabled will be casted to true
defineProps({
disabled: [Boolean, String]
})
// disabled will be casted to true
defineProps({
disabled: [Number, Boolean]
})
// disabled will be parsed as an empty string (disabled="")
defineProps({
disabled: [String, Boolean]
})hhuh(hh	h}ubh)}(h}(hNh	}(h,https://vuejs.org/guide/essentials/lifecycleh
Lifecycle Hooks | Vue.jsuhX  Lifecycle Hooks
Each Vue component instance goes through a series of initialization steps when it's created - for example, it needs to set up data observation, compile the template, mount the instance to the DOM, and update the DOM when data changes. Along the way, it also runs functions called lifecycle hooks, giving users the opportunity to add their own code at specific stages.
Registering Lifecycle Hooks
For example, the onMounted
hook can be used to run code after the component has finished the initial rendering and created the DOM nodes:
vue
<script setup>
import { onMounted } from 'vue'
onMounted(() => {
console.log(`the component is now mounted.`)
})
</script>
There are also other hooks which will be called at different stages of the instance's lifecycle, with the most commonly used being onMounted
, onUpdated
, and onUnmounted
.
When calling onMounted
, Vue automatically associates the registered callback function with the current active component instance. This requires these hooks to be registered synchronously during component setup. For example, do not do this:
js
setTimeout(() => {
onMounted(() => {
// this won't work.
})
}, 100)
Do note this doesn't mean that the call must be placed lexically inside setup()
or <script setup>
. onMounted()
can be called in an external function as long as the call stack is synchronous and originates from within setup()
.
Lifecycle Diagram
Below is a diagram for the instance lifecycle. You don't need to fully understand everything going on right now, but as you learn and build more, it will be a useful reference.
Consult the Lifecycle Hooks API reference for details on all lifecycle hooks and their respective use cases.hhuh(hh	h}ubh)}(h}(hNh	}(h*https://vuejs.org/guide/scaling-up/routingh
Routing | Vue.jsuhX  Routing
Client-Side vs. Server-Side Routing
Routing on the server side means the server is sending a response based on the URL path that the user is visiting. When we click on a link in a traditional server-rendered web app, the browser receives an HTML response from the server and reloads the entire page with the new HTML.
In a Single-Page Application (SPA), however, the client-side JavaScript can intercept the navigation, dynamically fetch new data, and update the current page without full page reloads. This typically results in a more snappy user experience, especially for use cases that are more like actual "applications", where the user is expected to perform many interactions over a long period of time.
In such SPAs, the "routing" is done on the client side, in the browser. A client-side router is responsible for managing the application's rendered view using browser APIs such as History API or the hashchange
event.
Official Router
Vue is well-suited for building SPAs. For most SPAs, it's recommended to use the officially-supported Vue Router library. For more details, see Vue Router's documentation.
Simple Routing from Scratch
If you only need very simple routing and do not wish to involve a full-featured router library, you can do so with Dynamic Components and update the current component state by listening to browser hashchange
events or using the History API.
Here's a bare-bone example:
vue
<script setup>
import { ref, computed } from 'vue'
import Home from './Home.vue'
import About from './About.vue'
import NotFound from './NotFound.vue'
const routes = {
'/': Home,
'/about': About
}
const currentPath = ref(window.location.hash)
window.addEventListener('hashchange', () => {
currentPath.value = window.location.hash
})
const currentView = computed(() => {
return routes[currentPath.value.slice(1) || '/'] || NotFound
})
</script>
<template>
<a href="#/">Home</a> |
<a href="#/about">About</a> |
<a href="#/non-existent-path">Broken Link</a>
<component :is="currentView" />
</template>hhuh(hh	h}ubh)}(h}(hNh	}(h+https://vuejs.org/guide/essentials/watchersh
Watchers | Vue.jsuhX&  Watchers
Basic Example
Computed properties allow us to declaratively compute derived values. However, there are cases where we need to perform "side effects" in reaction to state changes - for example, mutating the DOM, or changing another piece of state based on the result of an async operation.
With Composition API, we can use the watch
function to trigger a callback whenever a piece of reactive state changes:
vue
<script setup>
import { ref, watch } from 'vue'
const question = ref('')
const answer = ref('Questions usually contain a question mark. ;-)')
const loading = ref(false)
// watch works directly on a ref
watch(question, async (newQuestion, oldQuestion) => {
if (newQuestion.includes('?')) {
loading.value = true
answer.value = 'Thinking...'
try {
const res = await fetch('https://yesno.wtf/api')
answer.value = (await res.json()).answer
} catch (error) {
answer.value = 'Error! Could not reach the API. ' + error
} finally {
loading.value = false
}
}
})
</script>
<template>
<p>
Ask a yes/no question:
<input v-model="question" :disabled="loading" />
</p>
<p>{{ answer }}</p>
</template>
Watch Source Types
watch
's first argument can be different types of reactive "sources": it can be a ref (including computed refs), a reactive object, a getter function, or an array of multiple sources:
js
const x = ref(0)
const y = ref(0)
// single ref
watch(x, (newX) => {
console.log(`x is ${newX}`)
})
// getter
watch(
() => x.value + y.value,
(sum) => {
console.log(`sum of x + y is: ${sum}`)
}
)
// array of multiple sources
watch([x, () => y.value], ([newX, newY]) => {
console.log(`x is ${newX} and y is ${newY}`)
})
Do note that you can't watch a property of a reactive object like this:
js
const obj = reactive({ count: 0 })
// this won't work because we are passing a number to watch()
watch(obj.count, (count) => {
console.log(`Count is: ${count}`)
})
Instead, use a getter:
js
// instead, use a getter:
watch(
() => obj.count,
(count) => {
console.log(`Count is: ${count}`)
}
)
Deep Watchers
When you call watch()
directly on a reactive object, it will implicitly create a deep watcher - the callback will be triggered on all nested mutations:
js
const obj = reactive({ count: 0 })
watch(obj, (newValue, oldValue) => {
// fires on nested property mutations
// Note: `newValue` will be equal to `oldValue` here
// because they both point to the same object!
})
obj.count++
This should be differentiated with a getter that returns a reactive object - in the latter case, the callback will only fire if the getter returns a different object:
js
watch(
() => state.someObject,
() => {
// fires only when state.someObject is replaced
}
)
You can, however, force the second case into a deep watcher by explicitly using the deep
option:
js
watch(
() => state.someObject,
(newValue, oldValue) => {
// Note: `newValue` will be equal to `oldValue` here
// *unless* state.someObject has been replaced
},
{ deep: true }
)
Use with Caution
Deep watch requires traversing all nested properties in the watched object, and can be expensive when used on large data structures. Use it only when necessary and beware of the performance implications.
Eager Watchers
watch
is lazy by default: the callback won't be called until the watched source has changed. But in some cases we may want the same callback logic to be run eagerly - for example, we may want to fetch some initial data, and then re-fetch the data whenever relevant state changes.
We can force a watcher's callback to be executed immediately by passing the immediate: true
option:
js
watch(
source,
(newValue, oldValue) => {
// executed immediately, then again when `source` changes
},
{ immediate: true }
)
Once Watchers
Watcher's callback will execute whenever the watched source changes. If you want the callback to trigger only once when the source changes, use the once: true
option.
js
watch(
source,
(newValue, oldValue) => {
// when `source` changes, triggers only once
},
{ once: true }
)
watchEffect()
It is common for the watcher callback to use exactly the same reactive state as the source. For example, consider the following code, which uses a watcher to load a remote resource whenever the todoId
ref changes:
js
const todoId = ref(1)
const data = ref(null)
watch(
todoId,
async () => {
const response = await fetch(
`https://jsonplaceholder.typicode.com/todos/${todoId.value}`
)
data.value = await response.json()
},
{ immediate: true }
)
In particular, notice how the watcher uses todoId
twice, once as the source and then again inside the callback.
This can be simplified with watchEffect()
. watchEffect()
allows us to track the callback's reactive dependencies automatically. The watcher above can be rewritten as:
js
watchEffect(async () => {
const response = await fetch(
`https://jsonplaceholder.typicode.com/todos/${todoId.value}`
)
data.value = await response.json()
})
Here, the callback will run immediately, there's no need to specify immediate: true
. During its execution, it will automatically track todoId.value
as a dependency (similar to computed properties). Whenever todoId.value
changes, the callback will be run again. With watchEffect()
, we no longer need to pass todoId
explicitly as the source value.
You can check out this example of watchEffect()
and reactive data-fetching in action.
For examples like these, with only one dependency, the benefit of watchEffect()
is relatively small. But for watchers that have multiple dependencies, using watchEffect()
removes the burden of having to maintain the list of dependencies manually. In addition, if you need to watch several properties in a nested data structure, watchEffect()
may prove more efficient than a deep watcher, as it will only track the properties that are used in the callback, rather than recursively tracking all of them.
TIP
watchEffect
only tracks dependencies during its synchronous execution. When using it with an async callback, only properties accessed before the first await
tick will be tracked.
watch
vs. watchEffect
watch
and watchEffect
both allow us to reactively perform side effects. Their main difference is the way they track their reactive dependencies:
watch
only tracks the explicitly watched source. It won't track anything accessed inside the callback. In addition, the callback only triggers when the source has actually changed.watch
separates dependency tracking from the side effect, giving us more precise control over when the callback should fire.watchEffect
, on the other hand, combines dependency tracking and side effect into one phase. It automatically tracks every reactive property accessed during its synchronous execution. This is more convenient and typically results in terser code, but makes its reactive dependencies less explicit.
Callback Flush Timing
When you mutate reactive state, it may trigger both Vue component updates and watcher callbacks created by you.
Similar to component updates, user-created watcher callbacks are batched to avoid duplicate invocations. For example, we probably don't want a watcher to fire a thousand times if we synchronously push a thousand items into an array being watched.
By default, a watcher's callback is called after parent component updates (if any), and before the owner component's DOM updates. This means if you attempt to access the owner component's own DOM inside a watcher callback, the DOM will be in a pre-update state.
Post Watchers
If you want to access the owner component's DOM in a watcher callback after Vue has updated it, you need to specify the flush: 'post'
option:
js
watch(source, callback, {
flush: 'post'
})
watchEffect(callback, {
flush: 'post'
})
Post-flush watchEffect()
also has a convenience alias, watchPostEffect()
:
js
import { watchPostEffect } from 'vue'
watchPostEffect(() => {
/* executed after Vue updates */
})
Sync Watchers
It's also possible to create a watcher that fires synchronously, before any Vue-managed updates:
js
watch(source, callback, {
flush: 'sync'
})
watchEffect(callback, {
flush: 'sync'
})
Sync watchEffect()
also has a convenience alias, watchSyncEffect()
:
js
import { watchSyncEffect } from 'vue'
watchSyncEffect(() => {
/* executed synchronously upon reactive data change */
})
Use with Caution
Sync watchers do not have batching and triggers every time a reactive mutation is detected. It's ok to use them to watch simple boolean values, but avoid using them on data sources that might be synchronously mutated many times, e.g. arrays.
Stopping a Watcher
Watchers declared synchronously inside setup()
or <script setup>
are bound to the owner component instance, and will be automatically stopped when the owner component is unmounted. In most cases, you don't need to worry about stopping the watcher yourself.
The key here is that the watcher must be created synchronously: if the watcher is created in an async callback, it won't be bound to the owner component and must be stopped manually to avoid memory leaks. Here's an example:
vue
<script setup>
import { watchEffect } from 'vue'
// this one will be automatically stopped
watchEffect(() => {})
// ...this one will not!
setTimeout(() => {
watchEffect(() => {})
}, 100)
</script>
To manually stop a watcher, use the returned handle function. This works for both watch
and watchEffect
:
js
const unwatch = watchEffect(() => {})
// ...later, when no longer needed
unwatch()
Note that there should be very few cases where you need to create watchers asynchronously, and synchronous creation should be preferred whenever possible. If you need to wait for some async data, you can make your watch logic conditional instead:
js
// data to be loaded asynchronously
const data = ref(null)
watchEffect(() => {
if (data.value) {
// do something when data is loaded
}
})hhuh(hh	h}ubh)}(h}(hNh	}(h.https://vuejs.org/guide/essentials/applicationh
#Creating a Vue Application | Vue.jsuhX  Creating a Vue Application
The application instance
Every Vue application starts by creating a new application instance with the createApp
function:
js
import { createApp } from 'vue'
const app = createApp({
/* root component options */
})
The Root Component
The object we are passing into createApp
is in fact a component. Every app requires a "root component" that can contain other components as its children.
If you are using Single-File Components, we typically import the root component from another file:
js
import { createApp } from 'vue'
// import the root component App from a single-file component.
import App from './App.vue'
const app = createApp(App)
While many examples in this guide only need a single component, most real applications are organized into a tree of nested, reusable components. For example, a Todo application's component tree might look like this:
App (root component)
├─ TodoList
│ └─ TodoItem
│ ├─ TodoDeleteButton
│ └─ TodoEditButton
└─ TodoFooter
├─ TodoClearButton
└─ TodoStatistics
In later sections of the guide, we will discuss how to define and compose multiple components together. Before that, we will focus on what happens inside a single component.
Mounting the App
An application instance won't render anything until its .mount()
method is called. It expects a "container" argument, which can either be an actual DOM element or a selector string:
html
<div id="app"></div>
js
app.mount('#app')
The content of the app's root component will be rendered inside the container element. The container element itself is not considered part of the app.
The .mount()
method should always be called after all app configurations and asset registrations are done. Also note that its return value, unlike the asset registration methods, is the root component instance instead of the application instance.
In-DOM Root Component Template
The template for the root component is usually part of the component itself, but it is also possible to provide the template separately by writing it directly inside the mount container:
html
<div id="app">
<button @click="count++">{{ count }}</button>
</div>
js
import { createApp } from 'vue'
const app = createApp({
data() {
return {
count: 0
}
}
})
app.mount('#app')
Vue will automatically use the container's innerHTML
as the template if the root component does not already have a template
option.
In-DOM templates are often used in applications that are using Vue without a build step. They can also be used in conjunction with server-side frameworks, where the root template might be generated dynamically by the server.
App Configurations
The application instance exposes a .config
object that allows us to configure a few app-level options, for example, defining an app-level error handler that captures errors from all descendant components:
js
app.config.errorHandler = (err) => {
/* handle error */
}
The application instance also provides a few methods for registering app-scoped assets. For example, registering a component:
js
app.component('TodoDeleteButton', TodoDeleteButton)
This makes the TodoDeleteButton
available for use anywhere in our app. We will discuss registration for components and other types of assets in later sections of the guide. You can also browse the full list of application instance APIs in its API reference.
Make sure to apply all app configurations before mounting the app!
Multiple application instances
You are not limited to a single application instance on the same page. The createApp
API allows multiple Vue applications to co-exist on the same page, each with its own scope for configuration and global assets:
js
const app1 = createApp({
/* ... */
})
app1.mount('#container-1')
const app2 = createApp({
/* ... */
})
app2.mount('#container-2')
If you are using Vue to enhance server-rendered HTML and only need Vue to control specific parts of a large page, avoid mounting a single Vue application instance on the entire page. Instead, create multiple small application instances and mount them on the elements they are responsible for.hhuh(hh	h}ubh)}(h}(hNh	}(h3https://vuejs.org/guide/extras/reactivity-transformh
Reactivity Transform | Vue.jsuhX)!  Reactivity Transform
Removed Experimental Feature
Reactivity Transform was an experimental feature, and has been removed in the latest 3.4 release. Please read about the reasoning here.
If you still intend to use it, it is now available via the Vue Macros plugin.
Composition-API-specific
Reactivity Transform is a Composition-API-specific feature and requires a build step.
Refs vs. Reactive Variables
Ever since the introduction of the Composition API, one of the primary unresolved questions is the use of refs vs. reactive objects. It's easy to lose reactivity when destructuring reactive objects, while it can be cumbersome to use .value
everywhere when using refs. Also, .value
is easy to miss if not using a type system.
Vue Reactivity Transform is a compile-time transform that allows us to write code like this:
vue
<script setup>
let count = $ref(0)
console.log(count)
function increment() {
count++
}
</script>
<template>
<button @click="increment">{{ count }}</button>
</template>
The $ref()
method here is a compile-time macro: it is not an actual method that will be called at runtime. Instead, the Vue compiler uses it as a hint to treat the resulting count
variable as a reactive variable.
Reactive variables can be accessed and re-assigned just like normal variables, but these operations are compiled into refs with .value
. For example, the <script>
part of the above component is compiled into:
js
import { ref } from 'vue'
let count = ref(0)
console.log(count.value)
function increment() {
count.value++
}
Every reactivity API that returns refs will have a $
-prefixed macro equivalent. These APIs include:
ref
->$ref
computed
->$computed
shallowRef
->$shallowRef
customRef
->$customRef
toRef
->$toRef
These macros are globally available and do not need to be imported when Reactivity Transform is enabled, but you can optionally import them from vue/macros
if you want to be more explicit:
js
import { $ref } from 'vue/macros'
let count = $ref(0)
Destructuring with $()
It is common for a composition function to return an object of refs, and use destructuring to retrieve these refs. For this purpose, reactivity transform provides the $()
macro:
js
import { useMouse } from '@vueuse/core'
const { x, y } = $(useMouse())
console.log(x, y)
Compiled output:
js
import { toRef } from 'vue'
import { useMouse } from '@vueuse/core'
const __temp = useMouse(),
x = toRef(__temp, 'x'),
y = toRef(__temp, 'y')
console.log(x.value, y.value)
Note that if x
is already a ref, toRef(__temp, 'x')
will simply return it as-is and no additional ref will be created. If a destructured value is not a ref (e.g. a function), it will still work - the value will be wrapped in a ref so the rest of the code works as expected.
$()
destructure works on both reactive objects and plain objects containing refs.
Convert Existing Refs to Reactive Variables with $()
In some cases we may have wrapped functions that also return refs. However, the Vue compiler won't be able to know ahead of time that a function is going to return a ref. In such cases, the $()
macro can also be used to convert any existing refs into reactive variables:
js
function myCreateRef() {
return ref(0)
}
let count = $(myCreateRef())
Reactive Props Destructure
There are two pain points with the current defineProps()
usage in <script setup>
:
Similar to
.value
, you need to always access props asprops.x
in order to retain reactivity. This means you cannot destructuredefineProps
because the resulting destructured variables are not reactive and will not update.When using the type-only props declaration, there is no easy way to declare default values for the props. We introduced the
withDefaults()
API for this exact purpose, but it's still clunky to use.
We can address these issues by applying a compile-time transform when defineProps
is used with destructuring, similar to what we saw earlier with $()
:
html
<script setup lang="ts">
interface Props {
msg: string
count?: number
foo?: string
}
const {
msg,
// default value just works
count = 1,
// local aliasing also just works
// here we are aliasing `props.foo` to `bar`
foo: bar
} = defineProps<Props>()
watchEffect(() => {
// will log whenever the props change
console.log(msg, count, bar)
})
</script>
The above will be compiled into the following runtime declaration equivalent:
js
export default {
props: {
msg: { type: String, required: true },
count: { type: Number, default: 1 },
foo: String
},
setup(props) {
watchEffect(() => {
console.log(props.msg, props.count, props.foo)
})
}
}
Retaining Reactivity Across Function Boundaries
While reactive variables relieve us from having to use .value
everywhere, it creates an issue of "reactivity loss" when we pass reactive variables across function boundaries. This can happen in two cases:
Passing into function as argument
Given a function that expects a ref as an argument, e.g.:
ts
function trackChange(x: Ref<number>) {
watch(x, (x) => {
console.log('x changed!')
})
}
let count = $ref(0)
trackChange(count) // doesn't work!
The above case will not work as expected because it compiles to:
ts
let count = ref(0)
trackChange(count.value)
Here count.value
is passed as a number, whereas trackChange
expects an actual ref. This can be fixed by wrapping count
with $$()
before passing it:
diff
let count = $ref(0)
- trackChange(count)
+ trackChange($$(count))
The above compiles to:
js
import { ref } from 'vue'
let count = ref(0)
trackChange(count)
As we can see, $$()
is a macro that serves as an escape hint: reactive variables inside $$()
will not get .value
appended.
Returning inside function scope
Reactivity can also be lost if reactive variables are used directly in a returned expression:
ts
function useMouse() {
let x = $ref(0)
let y = $ref(0)
// listen to mousemove...
// doesn't work!
return {
x,
y
}
}
The above return statement compiles to:
ts
return {
x: x.value,
y: y.value
}
In order to retain reactivity, we should be returning the actual refs, not the current value at return time.
Again, we can use $$()
to fix this. In this case, $$()
can be used directly on the returned object - any reference to reactive variables inside the $$()
call will retain the reference to their underlying refs:
ts
function useMouse() {
let x = $ref(0)
let y = $ref(0)
// listen to mousemove...
// fixed
return $$({
x,
y
})
}
Using $$()
on destructured props
$$()
works on destructured props since they are reactive variables as well. The compiler will convert it with toRef
for efficiency:
ts
const { count } = defineProps<{ count: number }>()
passAsRef($$(count))
compiles to:
js
setup(props) {
const __props_count = toRef(props, 'count')
passAsRef(__props_count)
}
TypeScript Integration
Vue provides typings for these macros (available globally) and all types will work as expected. There are no incompatibilities with standard TypeScript semantics, so the syntax will work with all existing tooling.
This also means the macros can work in any files where valid JS / TS are allowed - not just inside Vue SFCs.
Since the macros are available globally, their types need to be explicitly referenced (e.g. in a env.d.ts
file):
ts
/// <reference types="vue/macros-global" />
When explicitly importing the macros from vue/macros
, the type will work without declaring the globals.
Explicit Opt-in
No longer supported in core
The following only applies up to Vue version 3.3 and below. Support has been removed in Vue core 3.4 and above, and @vitejs/plugin-vue
5.0 and above. If you intend to continue using the transform, please migrate to Vue Macros instead.
Vite
- Requires
@vitejs/plugin-vue@>=2.0.0
- Applies to SFCs and js(x)/ts(x) files. A fast usage check is performed on files before applying the transform so there should be no performance cost for files not using the macros.
- Note
reactivityTransform
is now a plugin root-level option instead of nested asscript.refSugar
, since it affects not just SFCs.
js
// vite.config.js
export default {
plugins: [
vue({
reactivityTransform: true
})
]
}
vue-cli
- Currently only affects SFCs
- Requires
vue-loader@>=17.0.0
js
// vue.config.js
module.exports = {
chainWebpack: (config) => {
config.module
.rule('vue')
.use('vue-loader')
.tap((options) => {
return {
...options,
reactivityTransform: true
}
})
}
}
Plain webpack
+ vue-loader
- Currently only affects SFCs
- Requires
vue-loader@>=17.0.0
js
// webpack.config.js
module.exports = {
module: {
rules: [
{
test: /\.vue$/,
loader: 'vue-loader',
options: {
reactivityTransform: true
}
}
]
}
}p     hhuh(hh	h}ubh)}(h}(hNh	}(h*https://vuejs.org/guide/scaling-up/testingh
Testing | Vue.jsuhXH  Testing
Why Test?
Automated tests help you and your team build complex Vue applications quickly and confidently by preventing regressions and encouraging you to break apart your application into testable functions, modules, classes, and components. As with any application, your new Vue app can break in many ways, and it's important that you can catch these issues and fix them before releasing.
In this guide, we'll cover basic terminology and provide our recommendations on which tools to choose for your Vue 3 application.
There is one Vue-specific section covering composables. See Testing Composables below for more details.
When to Test
Start testing early! We recommend you begin writing tests as soon as you can. The longer you wait to add tests to your application, the more dependencies your application will have, and the harder it will be to start.
Testing Types
When designing your Vue application's testing strategy, you should leverage the following testing types:
- Unit: Checks that inputs to a given function, class, or composable are producing the expected output or side effects.
- Component: Checks that your component mounts, renders, can be interacted with, and behaves as expected. These tests import more code than unit tests, are more complex, and require more time to execute.
- End-to-end: Checks features that span multiple pages and makes real network requests against your production-built Vue application. These tests often involve standing up a database or other backend.
Each testing type plays a role in your application's testing strategy, and each will protect you against different types of issues.
Overview
We will briefly discuss what each of these are, how they can be implemented for Vue applications, and provide some general recommendations.
Unit Testing
Unit tests are written to verify that small, isolated units of code are working as expected. A unit test usually covers a single function, class, composable, or module. Unit tests focus on logical correctness and only concern themselves with a small portion of the application's overall functionality. They may mock large parts of your application's environment (e.g. initial state, complex classes, 3rd party modules, and network requests).
In general, unit tests will catch issues with a function's business logic and logical correctness.
Take for example this increment
function:
js
// helpers.js
export function increment (current, max = 10) {
if (current < max) {
return current + 1
}
return current
}
Because it's very self-contained, it'll be easy to invoke the increment function and assert that it returns what it's supposed to, so we'll write a Unit Test.
If any of these assertions fail, it's clear that the issue is contained within the increment
function.
js
// helpers.spec.js
import { increment } from './helpers'
describe('increment', () => {
test('increments the current number by 1', () => {
expect(increment(0, 10)).toBe(1)
})
test('does not increment the current number over the max', () => {
expect(increment(10, 10)).toBe(10)
})
test('has a default max of 10', () => {
expect(increment(10)).toBe(10)
})
})
As mentioned previously, unit testing is typically applied to self-contained business logic, components, classes, modules, or functions that do not involve UI rendering, network requests, or other environmental concerns.
These are typically plain JavaScript / TypeScript modules unrelated to Vue. In general, writing unit tests for business logic in Vue applications does not differ significantly from applications using other frameworks.
There are two instances where you DO unit test Vue-specific features:
- Composables
- Components
Composables
One category of functions specific to Vue applications is Composables, which may require special handling during tests. See Testing Composables below for more details.
Unit Testing Components
A component can be tested in two ways:
Whitebox: Unit Testing
Tests that are "Whitebox tests" are aware of the implementation details and dependencies of a component. They are focused on isolating the component under test. These tests will usually involve mocking some, if not all of your component's children, as well as setting up plugin state and dependencies (e.g. Pinia).
Blackbox: Component Testing
Tests that are "Blackbox tests" are unaware of the implementation details of a component. These tests mock as little as possible to test the integration of your component and the entire system. They usually render all child components and are considered more of an "integration test". See the Component Testing recommendations below.
Recommendation
Since the official setup created by
create-vue
is based on Vite, we recommend using a unit testing framework that can leverage the same configuration and transform pipeline directly from Vite. Vitest is a unit testing framework designed specifically for this purpose, created and maintained by Vue / Vite team members. It integrates with Vite-based projects with minimal effort, and is blazing fast.
Other Options
- Jest is a popular unit testing framework. However, we only recommend Jest if you have an existing Jest test suite that needs to be migrated over to a Vite-based project, as Vitest offers a more seamless integration and better performance.
Component Testing
In Vue applications, components are the main building blocks of the UI. Components are therefore the natural unit of isolation when it comes to validating your application's behavior. From a granularity perspective, component testing sits somewhere above unit testing and can be considered a form of integration testing. Much of your Vue Application should be covered by a component test and we recommend that each Vue component has its own spec file.
Component tests should catch issues relating to your component's props, events, slots that it provides, styles, classes, lifecycle hooks, and more.
Component tests should not mock child components, but instead test the interactions between your component and its children by interacting with the components as a user would. For example, a component test should click on an element like a user would instead of programmatically interacting with the component.
Component tests should focus on the component's public interfaces rather than internal implementation details. For most components, the public interface is limited to: events emitted, props, and slots. When testing, remember to test what a component does, not how it does it.
DO
For Visual logic: assert correct render output based on inputted props and slots.
For Behavioral logic: assert correct render updates or emitted events in response to user input events.
In the below example, we demonstrate a Stepper component that has a DOM element labeled "increment" and can be clicked. We pass a prop called
max
that prevents the Stepper from being incremented past2
, so if we click the button 3 times, the UI should still say2
.We know nothing about the implementation of Stepper, only that the "input" is the
max
prop and the "output" is the state of the DOM as the user will see it.
Vue Test Utils
Cypress
Testing Library
js
const valueSelector = '[data-testid=stepper-value]'
const buttonSelector = '[data-testid=increment]'
const wrapper = mount(Stepper, {
props: {
max: 1
}
})
expect(wrapper.find(valueSelector).text()).toContain('0')
await wrapper.find(buttonSelector).trigger('click')
expect(wrapper.find(valueSelector).text()).toContain('1')
DON'T
Don't assert the private state of a component instance or test the private methods of a component. Testing implementation details makes the tests brittle, as they are more likely to break and require updates when the implementation changes.
The component's ultimate job is rendering the correct DOM output, so tests focusing on the DOM output provide the same level of correctness assurance (if not more) while being more robust and resilient to change.
Don't rely exclusively on snapshot tests. Asserting HTML strings does not describe correctness. Write tests with intentionality.
If a method needs to be tested thoroughly, consider extracting it into a standalone utility function and write a dedicated unit test for it. If it cannot be extracted cleanly, it may be tested as a part of a component, integration, or end-to-end test that covers it.
Recommendation
Vitest for components or composables that render headlessly (e.g. the
useFavicon
function in VueUse). Components and DOM can be tested using@vue/test-utils
.Cypress Component Testing for components whose expected behavior depends on properly rendering styles or triggering native DOM events. It can be used with Testing Library via @testing-library/cypress.
The main differences between Vitest and browser-based runners are speed and execution context. In short, browser-based runners, like Cypress, can catch issues that node-based runners, like Vitest, cannot (e.g. style issues, real native DOM events, cookies, local storage, and network failures), but browser-based runners are orders of magnitude slower than Vitest because they do open a browser, compile your stylesheets, and more. Cypress is a browser-based runner that supports component testing. Please read Vitest's comparison page for the latest information comparing Vitest and Cypress.
Mounting Libraries
Component testing often involves mounting the component being tested in isolation, triggering simulated user input events, and asserting on the rendered DOM output. There are dedicated utility libraries that make these tasks simpler.
@vue/test-utils
is the official low-level component testing library that was written to provide users access to Vue specific APIs. It's also the lower-level library@testing-library/vue
is built on top of.@testing-library/vue
is a Vue testing library focused on testing components without relying on implementation details. Its guiding principle is that the more tests resemble the way software is used, the more confidence they can provide.
We recommend using @vue/test-utils
for testing components in applications. @testing-library/vue
has issues with testing asynchronous component with Suspense, so it should be used with caution.
Other Options
Nightwatch is an E2E test runner with Vue Component Testing support. (Example Project)
WebdriverIO for cross-browser component testing that relies on native user interaction based on standardized automation. It can also be used with Testing Library.
E2E Testing
While unit tests provide developers with some degree of confidence, unit and component tests are limited in their abilities to provide holistic coverage of an application when deployed to production. As a result, end-to-end (E2E) tests provide coverage on what is arguably the most important aspect of an application: what happens when users actually use your applications.
End-to-end tests focus on multi-page application behavior that makes network requests against your production-built Vue application. They often involve standing up a database or other backend and may even be run against a live staging environment.
End-to-end tests will often catch issues with your router, state management library, top-level components (e.g. an App or Layout), public assets, or any request handling. As stated above, they catch critical issues that may be impossible to catch with unit tests or component tests.
End-to-end tests do not import any of your Vue application's code but instead rely completely on testing your application by navigating through entire pages in a real browser.
End-to-end tests validate many of the layers in your application. They can either target your locally built application or even a live Staging environment. Testing against your Staging environment not only includes your frontend code and static server but all associated backend services and infrastructure.
The more your tests resemble how your software is used, the more confidence they can give you. - Kent C. Dodds - Author of the Testing Library
By testing how user actions impact your application, E2E tests are often the key to higher confidence in whether an application is functioning properly or not.
Choosing an E2E Testing Solution
While end-to-end (E2E) testing on the web has gained a negative reputation for unreliable (flaky) tests and slowing down development processes, modern E2E tools have made strides forward to create more reliable, interactive, and useful tests. When choosing an E2E testing framework, the following sections provide some guidance on things to keep in mind when choosing a testing framework for your application.
Cross-browser testing
One of the primary benefits that end-to-end (E2E) testing is known for is its ability to test your application across multiple browsers. While it may seem desirable to have 100% cross-browser coverage, it is important to note that cross browser testing has diminishing returns on a team's resources due to the additional time and machine power required to run them consistently. As a result, it is important to be mindful of this trade-off when choosing the amount of cross-browser testing your application needs.
Faster feedback loops
One of the primary problems with end-to-end (E2E) tests and development is that running the entire suite takes a long time. Typically, this is only done in continuous integration and deployment (CI/CD) pipelines. Modern E2E testing frameworks have helped to solve this by adding features like parallelization, which allows for CI/CD pipelines to often run magnitudes faster than before. In addition, when developing locally, the ability to selectively run a single test for the page you are working on while also providing hot reloading of tests can help boost a developer's workflow and productivity.
First-class debugging experience
While developers have traditionally relied on scanning logs in a terminal window to help determine what went wrong in a test, modern end-to-end (E2E) test frameworks allow developers to leverage tools they are already familiar with, e.g. browser developer tools.
Visibility in headless mode
When end-to-end (E2E) tests are run in continuous integration/deployment pipelines, they are often run in headless browsers (i.e., no visible browser is opened for the user to watch). A critical feature of modern E2E testing frameworks is the ability to see snapshots and/or videos of the application during testing, providing some insight into why errors are happening. Historically, it was tedious to maintain these integrations.
Recommendation
Overall, we believe Cypress provides the most complete E2E solution with features like an informative graphical interface, excellent debuggability, built-in assertions, stubs, flake-resistance, parallelization, and snapshots. As mentioned above, it also provides support for Component Testing. It supports Chromium-based browsers, Firefox, and Electron. WebKit support is available, but marked experimental.
Other Options
Playwright is also a great E2E testing solution that supports all modern rendering engines including Chromium, WebKit, and Firefox. Test on Windows, Linux, and macOS, locally or on CI, headless or headed with native mobile emulation of Google Chrome for Android and Mobile Safari.
Nightwatch is an E2E testing solution based on Selenium WebDriver. This gives it the widest browser support range, including native mobile testing. Selenium-based solutions will be slower than Playwright or Cypress.
WebdriverIO is a test automation framework for web and mobile testing based on the WebDriver protocol.
Recipes
Adding Vitest to a Project
In a Vite-based Vue project, run:
sh
> npm install -D vitest happy-dom @testing-library/vue
Next, update the Vite configuration to add the test
option block:
js
// vite.config.js
import { defineConfig } from 'vite'
export default defineConfig({
// ...
test: {
// enable jest-like global test APIs
globals: true,
// simulate DOM with happy-dom
// (requires installing happy-dom as a peer dependency)
environment: 'happy-dom'
}
})
TIP
If you use TypeScript, add vitest/globals
to the types
field in your tsconfig.json
.
json
// tsconfig.json
{
"compilerOptions": {
"types": ["vitest/globals"]
}
}
Then, create a file ending in *.test.js
in your project. You can place all test files in a test directory in the project root or in test directories next to your source files. Vitest will automatically search for them using the naming convention.
js
// MyComponent.test.js
import { render } from '@testing-library/vue'
import MyComponent from './MyComponent.vue'
test('it should work', () => {
const { getByText } = render(MyComponent, {
props: {
/* ... */
}
})
// assert output
getByText('...')
})
Finally, update package.json
to add the test script and run it:
json
{
// ...
"scripts": {
"test": "vitest"
}
}
sh
> npm test
Testing Composables
This section assumes you have read the Composables section.
When it comes to testing composables, we can divide them into two categories: composables that do not rely on a host component instance, and composables that do.
A composable depends on a host component instance when it uses the following APIs:
- Lifecycle hooks
- Provide / Inject
If a composable only uses Reactivity APIs, then it can be tested by directly invoking it and asserting its returned state/methods:
js
// counter.js
import { ref } from 'vue'
export function useCounter() {
const count = ref(0)
const increment = () => count.value++
return {
count,
increment
}
}
js
// counter.test.js
import { useCounter } from './counter.js'
test('useCounter', () => {
const { count, increment } = useCounter()
expect(count.value).toBe(0)
increment()
expect(count.value).toBe(1)
})
A composable that relies on lifecycle hooks or Provide / Inject needs to be wrapped in a host component to be tested. We can create a helper like the following:
js
// test-utils.js
import { createApp } from 'vue'
export function withSetup(composable) {
let result
const app = createApp({
setup() {
result = composable()
// suppress missing template warning
return () => {}
}
})
app.mount(document.createElement('div'))
// return the result and the app instance
// for testing provide/unmount
return [result, app]
}
js
import { withSetup } from './test-utils'
import { useFoo } from './foo'
test('useFoo', () => {
const [result, app] = withSetup(() => useFoo(123))
// mock provide for testing injections
app.provide(...)
// run assertions
expect(result.foo.value).toBe(1)
// trigger onUnmounted hook if needed
app.unmount()
})
For more complex composables, it could also be easier to test it by writing tests against the wrapper component using Component Testing techniques.hhuh(hh	h}ubh)}(h}(hNh	}(h/https://vuejs.org/guide/reusability/composablesh
Composables | Vue.jsuhX;  Composables
TIP
This section assumes basic knowledge of Composition API. If you have been learning Vue with Options API only, you can set the API Preference to Composition API (using the toggle at the top of the left sidebar) and re-read the Reactivity Fundamentals and Lifecycle Hooks chapters.
What is a "Composable"?
In the context of Vue applications, a "composable" is a function that leverages Vue's Composition API to encapsulate and reuse stateful logic.
When building frontend applications, we often need to reuse logic for common tasks. For example, we may need to format dates in many places, so we extract a reusable function for that. This formatter function encapsulates stateless logic: it takes some input and immediately returns expected output. There are many libraries out there for reusing stateless logic - for example lodash and date-fns, which you may have heard of.
By contrast, stateful logic involves managing state that changes over time. A simple example would be tracking the current position of the mouse on a page. In real-world scenarios, it could also be more complex logic such as touch gestures or connection status to a database.
Mouse Tracker Example
If we were to implement the mouse tracking functionality using the Composition API directly inside a component, it would look like this:
vue
<script setup>
import { ref, onMounted, onUnmounted } from 'vue'
const x = ref(0)
const y = ref(0)
function update(event) {
x.value = event.pageX
y.value = event.pageY
}
onMounted(() => window.addEventListener('mousemove', update))
onUnmounted(() => window.removeEventListener('mousemove', update))
</script>
<template>Mouse position is at: {{ x }}, {{ y }}</template>
But what if we want to reuse the same logic in multiple components? We can extract the logic into an external file, as a composable function:
js
// mouse.js
import { ref, onMounted, onUnmounted } from 'vue'
// by convention, composable function names start with "use"
export function useMouse() {
// state encapsulated and managed by the composable
const x = ref(0)
const y = ref(0)
// a composable can update its managed state over time.
function update(event) {
x.value = event.pageX
y.value = event.pageY
}
// a composable can also hook into its owner component's
// lifecycle to setup and teardown side effects.
onMounted(() => window.addEventListener('mousemove', update))
onUnmounted(() => window.removeEventListener('mousemove', update))
// expose managed state as return value
return { x, y }
}
And this is how it can be used in components:
vue
<script setup>
import { useMouse } from './mouse.js'
const { x, y } = useMouse()
</script>
<template>Mouse position is at: {{ x }}, {{ y }}</template>
Mouse position is at: 0, 0
As we can see, the core logic remains identical - all we had to do was move it into an external function and return the state that should be exposed. Just like inside a component, you can use the full range of Composition API functions in composables. The same useMouse()
functionality can now be used in any component.
The cooler part about composables though, is that you can also nest them: one composable function can call one or more other composable functions. This enables us to compose complex logic using small, isolated units, similar to how we compose an entire application using components. In fact, this is why we decided to call