@      ](langchain_core.documents.baseDocument)}(__dict__}(idNmetadata}(source6https://docs.chainlit.io/api-reference/elements/plotlytitlePlotly - Chainlitupage_contentX  Elements
Plotly
The Plotly
class allows you to display a Plotly chart in the chatbot UI. This class takes a Plotly figure.
The advantage of the Plotly
element over the Pyplot
element is that it’s interactive (the user can zoom on the chart for example).
Attributes
name
str
The name of the chart to be displayed in the UI.
display
ElementDisplay
Determines how the chart element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
size
ElementSize
Determines the size of the chart. Only works with display=“inline”. Choices are “small”, “medium” (default), or “large”.
figure
str
The plotly.graph_objects.Figure
instance that you want to display.
Example
import plotly.graph_objects as go
import chainlit as cl
@cl.on_chat_start
async def start():
fig = go.Figure(
data=[go.Bar(y=[2, 1, 3])],
layout_title_text="An example figure",
)
elements = [cl.Plotly(name="chart", figure=fig, display="inline")]
await cl.Message(content="This message has a chart", elements=elements).send()typehu__fields_set__(h	h__private_attribute_values__}ubh)}(h}(hNh	}(hEhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-chat-resumeh
on_chat_resume - ChainlituhXv  Life Cycle Hooks
on_chat_resume
Decorator to enable users to continue a conversation. Requires both data persistence and authentication to be enabled.
This decorator will automatically:
- Send the persisted messages and elements to the UI.
- Restore the user session.
Only JSON serializable fields of the user session will be saved and restored. If you are using a Langchain agent for instance, you will need to reinstantiate and set it in the user session yourself.
Usage
Resume Chat Example
Practical example of how to resume a chat with context.
Parameters
thread
ThreadDict
The persisted chat to resume.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h6https://docs.chainlit.io/api-reference/elements/pyploth
Pyplot - ChainlituhX   Elements
Pyplot
The Pyplot
class allows you to display a Matplotlib pyplot chart in the chatbot UI. This class takes a pyplot figure.
The difference of between this element and the Plotly
element is that the user is shown a static image of the chart when using Pyplot
.
Attributes
name
str
The name of the chart to be displayed in the UI.
display
ElementDisplay
Determines how the chart element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
size
ElementSize
Determines the size of the chart. Only works with display=“inline”. Choices are “small”, “medium” (default), or “large”.
figure
str
The matplotlib.figure.Figure
instance that you want to display.
Example
import matplotlib.pyplot as plt
import chainlit as cl
@cl.on_chat_start
async def main():
fig, ax = plt.subplots()
ax.plot([1, 2, 3, 4], [1, 4, 2, 3])
elements = [
cl.Pyplot(name="plot", figure=fig, display="inline"),
]
await cl.Message(
content="Here is a simple plot",
elements=elements,
).send()hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/step-decoratorh
Step Decorator - ChainlituhXQ  Step Decorator
The step decorator will log steps based on the decorated function. By default, the arguments of the function will be used as the input of the step and the return value will be used as the output.
Under the hood, the step decorator is using the cl.Step class.
tool
steps will be displayed in the UI.Parameters
The name of the step. Default to the name of the decorated function.
The type of the step, useful for monitoring and debugging.
By default the step will be nested under the previous step/message. Set this
to True
to make it a root step.
Language of the output. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
By default only the output of the step is shown. Set this to True
to also
show the input. You can also set this to a language like json
or python
to
syntax highlight the input.
Access the Current step
You can access the current step object using cl.context.current_step
and override values.
import chainlit as cl
@cl.step
async def my_step():
current_step = cl.context.current_step
# Override the input of the step
current_step.input = "My custom input"
# Override the output of the step
current_step.output = "My custom output"
Stream the Output
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI(api_key="YOUR_API_KEY")
@cl.step(type="llm")
async def gpt4():
settings = {
"model": "gpt-4",
"temperature": 0,
}
stream = await client.chat.completions.create(
messages=message_history, stream=True, **settings
)
current_step = cl.context.current_step
async for part in stream:
delta = part.choices[0].delta
if delta.content:
# Stream the output of the step
await current_step.stream_token(delta.content)
Nest Steps
If another step decorated function is called inside the decorated function, the child step will be nested under the parent step.
import chainlit as cl
@cl.step
async def parent_step():
await child_step()
return "Parent step output"
@cl.step
async def child_step():
return "Child step output"
@cl.on_chat_start
async def main():
await parent_step()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h9https://docs.chainlit.io/api-reference/ask/ask-for-actionh
AskUserAction - ChainlituhX  Ask User
AskUserAction
Ask for the user to take an action before continuing.
If the user does not answer in time (see timeout), a TimeoutError
will be raised or None
will be returned depending on raise_on_timeout
parameter.
If a project ID is configured, the messages will be uploaded to the cloud storage.
Attributes
content
str
The content of the message.
actions
List[Action]
The list of Action to prompt the user.
author
str
The author of the message, defaults to the chatbot name defined in your config.
disable_human_feedback
bool
default: "False"The number of seconds to wait for an answer before raising a TimeoutError.
timeout
int
default: 90The number of seconds to wait for an answer before raising a TimeoutError.
raise_on_timeout
bool
default: "False"Whether to raise a socketio TimeoutError if the user does not answer in time.
Returns
response
AskActionResponse | None
requiredThe response of the user.
Example
import chainlit as cl
@cl.on_chat_start
async def main():
res = await cl.AskActionMessage(
content="Pick an action!",
actions=[
cl.Action(name="continue", value="continue", label="✅ Continue"),
cl.Action(name="cancel", value="cancel", label="❌ Cancel"),
],
).send()
if res and res.get("value") == "continue":
await cl.Message(
content="Continue!",
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/get-started/overviewh
Overview - ChainlituhXr  Overview
Chainlit is an open-source Python package to build production ready Conversational AI.
Build Conversational AI with Chainlit
Key features
-
Build fast: Integrate seamlessly with an existing code base or start from scratch in minutes
-
Multi Platform: Write your assistant logic once, use everywhere
-
Data persistence: Collect, monitor and analyze data from your users
-
Visualize multi-steps reasoning: Understand the intermediary steps that produced an output at a glance
Integrations
Chainlit is compatible with all Python programs and libraries. That being said, it comes with a set of integrations with popular libraries and frameworks.
OpenAI
Learn how to explore your OpenAI calls in Chainlit.
OpenAI Assistant
Learn how to integrate your OpenAI Assistants with Chainlit.
Mistral AI
Learn how to use any Mistral AI calls in Chainlit.
Llama Index
Learn how to integrate your Llama Index code with Chainlit.
LangChain
Learn how to use any LangChain agent with Chainlit.
Autogen
Learn how to integrate your Autogen agents with Chainlit.
Haystack
Learn how to integrate your Haystack code with Chainlit.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/chat-profilesh
Chat Profiles - ChainlituhX  Chat
Chat Profiles
Decorator to define the list of chat profiles.
If authentication is enabled, you can access the user details to create the list of chat profiles conditionally.
The icon is optional.
Parameters
current_user
User
The message coming from the UI.
Usage
Simple example
import chainlit as cl
@cl.set_chat_profiles
async def chat_profile():
return [
cl.ChatProfile(
name="GPT-3.5",
markdown_description="The underlying LLM model is **GPT-3.5**.",
icon="https://picsum.photos/200",
),
cl.ChatProfile(
name="GPT-4",
markdown_description="The underlying LLM model is **GPT-4**.",
icon="https://picsum.photos/250",
),
]
@cl.on_chat_start
async def on_chat_start():
chat_profile = cl.user_session.get("chat_profile")
await cl.Message(
content=f"starting chat using the {chat_profile} chat profile"
).send()
With authentication
from typing import Optional
import chainlit as cl
@cl.set_chat_profiles
async def chat_profile(current_user: cl.User):
if current_user.metadata["role"] != "ADMIN":
return None
return [
cl.ChatProfile(
name="GPT-3.5",
markdown_description="The underlying LLM model is **GPT-3.5**, a *175B parameter model* trained on 410GB of text data.",
),
cl.ChatProfile(
name="GPT-4",
markdown_description="The underlying LLM model is **GPT-4**, a *1.5T parameter model* trained on 3.5TB of text data.",
icon="https://picsum.photos/250",
),
cl.ChatProfile(
name="GPT-5",
markdown_description="The underlying LLM model is **GPT-5**.",
icon="https://picsum.photos/200",
),
]
@cl.password_auth_callback
def auth_callback(username: str, password: str) -> Optional[cl.User]:
if (username, password) == ("admin", "admin"):
return cl.User(identifier="admin", metadata={"role": "ADMIN"})
else:
return None
@cl.on_chat_start
async def on_chat_start():
user = cl.user_session.get("user")
chat_profile = cl.user_session.get("chat_profile")
await cl.Message(
content=f"starting chat with {user.identifier} using the {chat_profile} chat profile"
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h>https://docs.chainlit.io/api-reference/input-widgets/textinputh
TextInput - ChainlituhX  Input Widgets
TextInput
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
str
The initial value of the input widget.
placeholder
str
The placeholder value of the input widget.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import TextInput
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
TextInput(id="AgentName", label="Agent Name", initial="AI"),
]
).send()
value = settings["AgentName"]
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h8https://docs.chainlit.io/api-reference/ask/ask-for-inputh
AskUserMessage - ChainlituhX  Ask User
AskUserMessage
Ask for the user input before continuing. If the user does not answer in time (see timeout), a TimeoutError will be raised or None will be returned depending on raise_on_timeout. If a project ID is configured, the messages will be uploaded to the cloud storage.
Attributes
content
str
The content of the message.
author
str
The author of the message, defaults to the chatbot name defined in your config.
timeout
int
The number of seconds to wait for an answer before raising a TimeoutError.
raise_on_timeout
bool
Whether to raise a socketio TimeoutError if the user does not answer in time.
Returns
response
Step
requiredThe response of the user.
Usage
import chainlit as cl
@cl.on_chat_start
async def main():
res = await cl.AskUserMessage(content="What is your name?", timeout=10).send()
if res:
await cl.Message(
content=f"Your name is: {res['output']}",
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/chat-settingsh
Chat Settings - ChainlituhXz  Chat
Chat Settings
The ChatSettings
class is designed to create and send a dynamic form to the UI. This form can be updated by the user.
Attributes
inputs
List[InputWidget]
The fields of the form
Usage
import chainlit as cl
from chainlit.input_widget import Select, Switch, Slider
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Select(
id="Model",
label="OpenAI - Model",
values=["gpt-3.5-turbo", "gpt-3.5-turbo-16k", "gpt-4", "gpt-4-32k"],
initial_index=0,
),
Switch(id="Streaming", label="OpenAI - Stream Tokens", initial=True),
Slider(
id="Temperature",
label="OpenAI - Temperature",
initial=1,
min=0,
max=2,
step=0.1,
),
Slider(
id="SAI_Steps",
label="Stability AI - Steps",
initial=30,
min=10,
max=150,
step=1,
description="Amount of inference steps performed on image generation.",
),
Slider(
id="SAI_Cfg_Scale",
label="Stability AI - Cfg_Scale",
initial=7,
min=1,
max=35,
step=0.1,
description="Influences how strongly your generation is guided to match your prompt.",
),
Slider(
id="SAI_Width",
label="Stability AI - Image Width",
initial=512,
min=256,
max=2048,
step=64,
tooltip="Measured in pixels",
),
Slider(
id="SAI_Height",
label="Stability AI - Image Height",
initial=512,
min=256,
max=2048,
step=64,
tooltip="Measured in pixels",
),
]
).send()
@cl.on_settings_update
async def setup_agent(settings):
print("on_settings_update", settings)
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h9https://docs.chainlit.io/api-reference/input-widgets/tagsh
Tags - ChainlituhXw  Input Widgets
Tags
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
List[str]
The initial values of the input widget.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Tags
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Tags(id="StopSequence", label="OpenAI - StopSequence", initial=["Answer:"]),
]
).send()
value = settings["StopSequence"]hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/author-renameh
+author_rename and Message author - ChainlituhXR  Misceallaneous
author_rename and Message author
This documentation covers two methods for setting or renaming the author of a message to display more friendly author names in the UI: the author_rename
decorator and the Message author specification at message creation.
Method 1: author_rename
Useful for renaming the author of a message dynamically during the message handling process.
Parameters
orig_author
str
requiredThe original author name.
Returns
author
str
requiredThe renamed author
Usage
from langchain import OpenAI, LLMMathChain
import chainlit as cl
@cl.author_rename
def rename(orig_author: str):
rename_dict = {"LLMMathChain": "Albert Einstein", "Chatbot": "Assistant"}
return rename_dict.get(orig_author, orig_author)
@cl.on_message
async def main(message: cl.Message):
llm = OpenAI(temperature=0)
llm_math = LLMMathChain.from_llm(llm=llm)
res = await llm_math.acall(message.content, callbacks=[cl.AsyncLangchainCallbackHandler()])
await cl.Message(content="Hello").send()
Method 2: Message author
Allows for naming the author of a message at the moment of the message creation.
Usage
You can specify the author directly when creating a new message object:
from langchain import OpenAI, LLMMathChain
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
llm = OpenAI(temperature=0)
llm_math = LLMMathChain.from_llm(llm=llm)
res = await llm_math.acall(message.content, callbacks=[cl.AsyncLangchainCallbackHandler()])
# Specify the author at message creation
response_message = cl.Message(content="Hello", author="NewChatBotName")
await response_message.send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h3https://docs.chainlit.io/api-reference/elements/pdfh
PDF viewer - ChainlituhXo  PDF viewer
The Pdf
class allows you to display a PDF hosted remotely or locally in the chatbot UI. This class either takes a URL of a PDF hosted online, or the path of a local PDF.
Attributes
The name of the PDF to be displayed in the UI.
Determines how the PDF element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
The remote URL of the PDF file. Must provide url for a remote PDF (or either path or content for a local PDF).
The local file path of the PDF. Must provide either path or content for a local PDF (or url for a remote PDF).
The file content of the PDF in bytes format. Must provide either path or content for a local PDF (or url for a remote PDF).
Example
Inline
import chainlit as cl
@cl.on_chat_start
async def main():
# Sending a pdf with the local file path
elements = [
cl.Pdf(name="pdf1", display="inline", path="./pdf1.pdf")
]
cl.Message(content="Look at this local pdf!", elements=elements).send()
Side and Page
You must have the name of the pdf in the content of the message for the link to be created.
import chainlit as cl
@cl.on_chat_start
async def main():
# Sending a pdf with the local file path
elements = [
cl.Pdf(name="pdf1", display="side", path="./pdf1.pdf")
]
# Reminder: The name of the pdf must be in the content of the message
await cl.Message(content="Look at this local pdf1!", elements=elements).send()hhuh(h	hh}ubh)}(h}(hNh	}(h;https://docs.chainlit.io/api-reference/input-widgets/switchh
Switch - ChainlituhXj  Input Widgets
Switch
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
int
The initial value of the input widget.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Switch
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Switch(id="Streaming", label="OpenAI - Stream Tokens", initial=True),
]
).send()
value = settings["Streaming"]hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/get-started/pure-pythonh
In Pure Python - ChainlituhX  In Pure Python
In this tutorial, we’ll walk through the steps to create a minimal LLM app.
Prerequisites
Before getting started, make sure you have the following:
- A working installation of Chainlit
- Basic understanding of Python programming
Step 1: Create a Python file
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 2: Write the Application Logic
In app.py
, import the Chainlit package and define a function that will handle incoming messages from the chatbot UI. Decorate the function with the @cl.on_message
decorator to ensure it gets called whenever a user inputs a message.
Here’s the basic structure of the script:
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
# Your custom logic goes here...
# Send a response back to the user
await cl.Message(
content=f"Received: {message.content}",
).send()
The main
function will be called every time a user inputs a message in the chatbot UI. You can put your custom logic within the function to process the user’s input, such as analyzing the text, calling an API, or computing a result.
The Message class is responsible for sending a reply back to the user. In this example, we simply send a message containing the user’s input.
Step 3: Run the Application
To start your Chainlit app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.
Next Steps
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hEhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-audio-chunkh
on_audio_chunk - ChainlituhX  Life Cycle Hooks
on_audio_chunk
Hook to react to an incoming audio chunk from the user’s microphone.
Usage
from io import BytesIO
import chainlit as cl
@cl.on_audio_chunk
async def on_audio_chunk(chunk: cl.AudioChunk):
if chunk.isStart:
buffer = BytesIO()
# This is required for whisper to recognize the file type
buffer.name = f"input_audio.{chunk.mimeType.split('/')[1]}"
# Initialize the session for a new audio stream
cl.user_session.set("audio_buffer", buffer)
cl.user_session.set("audio_mime_type", chunk.mimeType)
# Write the chunks to a buffer and transcribe the whole audio at the end
cl.user_session.get("audio_buffer").write(chunk.data)
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/get-started/installationh
Installation - ChainlituhXQ  Get Started
Installation
Chainlit requires python>=3.8
.
You can install Chainlit it via pip as follows:
pip install chainlit
This will make the chainlit
command available on your system.
Make sure everything runs smoothly:
chainlit hello
This should spawn the chainlit UI and ask for your name like so:
Next steps
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h+https://docs.chainlit.io/examples/cookbook/h
Cookbook - ChainlituhX@  Examples
Cookbook
The Cookbook repository serves as a valuable resource and starting point for developers looking to explore the capabilities of Chainlit in creating LLM apps.
It provides a diverse collection of example projects, each residing in its own folder, showcasing the integration of various tools such as OpenAI, Anthropiс, LangChain, LlamaIndex, ChromaDB, Pinecone and more.
Whether you are seeking basic tutorials or in-depth use cases, the Cookbook repository offers inspiration and practical insights!
https://github.com/Chainlit/cookbook
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hIhttps://docs.chainlit.io/api-reference/data-persistence/custom-data-layerh
Custom Data Layer - ChainlituhX  Custom Data Layer
The BaseDataLayer
class serves as an abstract foundation for data persistence operations within the Chainlit framework. This class outlines methods for managing users, feedback, elements, steps, and threads in a chatbot application.
Methods
Fetches a user by their identifier. Return type is optionally a PersistedUser
.
Creates a new user based on the User
instance provided. Return type is optionally a PersistedUser
.
Inserts or updates feedback. Accepts a Feedback
instance and returns a string as an identifier of the persisted feedback.
Deletes a feedback by feedback_id
. Return True
if it was successful.
Adds a new element to the data layer. Accepts ElementDict
as an argument.
Retrieves an element by thread_id
and element_id
. Return type is optionally an ElementDict
.
Deletes an element given its identifier element_id
.
Creates a new step in the data layer. Accepts StepDict
as an argument.
Updates an existing step. Accepts StepDict
as an argument.
Deletes a step given its identifier step_id
.
Fetches the author of a given thread by thread_id
. Returns a string representing the author identifier.
Deletes a thread given its identifier thread_id
.
Lists threads based on pagination
and filters
arguments. Returns a PaginatedResponse[ThreadDict]
.
Retrieves a thread by its identifier thread_id
. Return type is optionally a ThreadDict
.
Updates a thread’s details like name, user_id, metadata, and tags. Arguments are mostly optional.
Deletes a user session given its identifier id
. Returns a boolean value indicating success.
Decorators
Queues certain methods to execute only after the first user message is received, especially useful for WebsocketSessions
.
Example
Due to the abstract nature of BaseDataLayer
, direct instantiation and usage are not practical without subclassing and implementing the abstract methods.
You can refer to the guide for custom data layer implementation.hhuh(h	hh}ubh)}(h}(hNh	}(h=https://docs.chainlit.io/api-reference/integrations/langchainh
%Langchain Callback Handler - ChainlituhX  Integrations
Langchain Callback Handler
The following code example demonstrates how to pass a callback handler:
llm = OpenAI(temperature=0)
llm_math = LLMMathChain.from_llm(llm=llm)
@cl.on_message
async def main(message: cl.Message):
res = await llm_math.acall(message.content, callbacks=[cl.LangchainCallbackHandler()])
await cl.Message(content="Hello").send()
Final Answer streaming
If streaming is enabled at the LLM level, Langchain will only stream the intermediate steps. You can enable final answer streaming by passing stream_final_answer=True
to the callback handler.
# Optionally, you can also pass the prefix tokens that will be used to identify the final answer
answer_prefix_tokens=["FINAL", "ANSWER"]
cl.LangchainCallbackHandler(
stream_final_answer=True,
answer_prefix_tokens=answer_prefix_tokens,
)
Final answer streaming will only work with prompts that have a consistent
final answer pattern. It will also not work with
AgentType.STRUCTURED_CHAT_ZERO_SHOT_REACT_DESCRIPTION
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h;https://docs.chainlit.io/api-reference/input-widgets/sliderh
Slider - ChainlituhX8  Input Widgets
Slider
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
int
The initial value of the input widget.
min
int
The minimum permitted slider value. Defaults to 0.
max
int
The maximum permitted slider value. Defaults to 10.
step
int
The stepping interval of the slider. Defaults to 1.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Slider
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Slider(
id="Temperature",
label="OpenAI - Temperature",
initial=1,
min=0,
max=2,
step=0.1,
),
]
).send()
value = settings["Temperature"]hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/elements/fileh
File - ChainlituhX  Elements
File
The File
class allows you to display a button that lets users download the content of the file.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the file. This will be shown to users.
url
str
The remote URL of the file image source.
path
str
The local file path of the file image.
content
bytes
The file content of the file image in bytes format.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
elements = [
cl.File(
name="hello.py",
path="./hello.py",
display="inline",
),
]
await cl.Message(
content="This message has a file element", elements=elements
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/api-reference/messageh
Message - ChainlituhX  Chat
Message
The Message
class is designed to send, stream, update or remove messages.
Parameters
content
str
The content of the message.
author
str
The author of the message, defaults to the chatbot name defined in your config file.
elements
Element[]
Elements to attach to the message.
actions
Action[]
Actions to attach to the message.
language
str
Language of the code if the content is code. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
Send a message
Send a new message to the UI.
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
await cl.Message(
content=f"Received: {message.content}",
).send()
Stream a message
Send a message token by token to the UI.
import chainlit as cl
token_list = ["the", "quick", "brown", "fox"]
@cl.on_chat_start
async def main():
msg = cl.Message(content="")
for token in token_list:
await msg.stream_token(token)
await msg.send()
Update a message
Update a message that already has been sent.
import chainlit as cl
@cl.on_chat_start
async def main():
msg = cl.Message(content="Hello!")
await msg.send()
await cl.sleep(2)
msg.content = "Hello again!"
await msg.update()
Remove a message
Remove a message from the UI.
import chainlit as cl
@cl.on_chat_start
async def main():
msg = cl.Message(content="Message 1")
await msg.send()
await cl.sleep(2)
await msg.remove()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h>https://docs.chainlit.io/api-reference/integrations/llamaindexh
&LlamaIndex Callback Handler - ChainlituhX  Integrations
LlamaIndex Callback Handler
Callback Handler to enable Chainlit to display intermediate steps in the UI.
Usage
Code Example
from llama_index.core.callbacks import CallbackManager
from llama_index.core.service_context import ServiceContext
import chainlit as cl
@cl.on_chat_start
async def start():
service_context = ServiceContext.from_defaults(callback_manager=CallbackManager([cl.LlamaIndexCallbackHandler()]))
# use the service context to create the predictor
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hChttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-audio-endh
on_audio_end - ChainlituhX2  Life Cycle Hooks
on_audio_end
Hook to react to the end of an audio recording coming from the user’s microphone.
Usage
from io import BytesIO
import chainlit as cl
@cl.on_audio_end
async def on_audio_end(elements: list[ElementBased]):
# Get the audio buffer from the session
audio_buffer: BytesIO = cl.user_session.get("audio_buffer")
audio_buffer.seek(0) # Move the file pointer to the beginning
audio_file = audio_buffer.read()
audio_mime_type: str = cl.user_session.get("audio_mime_type")
# Apply Speech to Text or any other processing
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h8https://docs.chainlit.io/api-reference/elements/tasklisth
TaskList - ChainlituhXW  Elements
TaskList
The TaskList
class allows you to display a task list next to the chatbot UI.
Attributes
status
str
The status of the TaskList. We suggest using something short like “Ready”, “Running…”, “Failed”, “Done”.
tasks
Task
The list of tasks to be displayed in the UI.
Usage
The TaskList element is slightly different from other elements in that it is not attached to a Message or Step but can be sent directly to the chat interface.
import chainlit as cl
@cl.on_chat_start
async def main():
# Create the TaskList
task_list = cl.TaskList()
task_list.status = "Running..."
# Create a task and put it in the running state
task1 = cl.Task(title="Processing data", status=cl.TaskStatus.RUNNING)
await task_list.add_task(task1)
# Create another task that is in the ready state
task2 = cl.Task(title="Performing calculations")
await task_list.add_task(task2)
# Optional: link a message to each task to allow task navigation in the chat history
message_id = await cl.Message(content="Started processing data").send()
task1.forId = message_id
# Update the task list in the interface
await task_list.send()
# Perform some action on your end
await cl.sleep(1)
# Update the task statuses
task1.status = cl.TaskStatus.DONE
task2.status = cl.TaskStatus.FAILED
task_list.status = "Failed"
await task_list.send()
Task List in action
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h,https://docs.chainlit.io/api-reference/cacheh
cache - ChainlituhX1  Misceallaneous
cache
The cache
decorator is a tool for caching results of resource-intensive calculations or loading processes. It can be conveniently combined with the file watcher to prevent resource reloading each time the application restarts. This not only saves time, but also enhances overall efficiency.
Parameters
func
Callable
The target function whose results need to be cached.
Returns
cached_value
Any
requiredThe computed value that is stored in the cache after its initial calculation.
Usage
import time
import chainlit as cl
@cl.cache
def to_cache():
time.sleep(5) # Simulate a time-consuming process
return "Hello!"
value = to_cache()
@cl.on_message
async def main(message: cl.Message):
await cl.Message(
content=value,
).send()
In this example, the to_cache
function simulates a time-consuming process that returns a value. By using the cl.cache
decorator, the result of the function is cached after its first execution. Future calls to the to_cache
function return the cached value without running the time-consuming process again.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h@https://docs.chainlit.io/api-reference/lifecycle-hooks/on-logouth
on_logout - ChainlituhX  Life Cycle Hooks
on_logout
Decorator to react to a user logging out. Useful to clear cookies or other user data through the HTTP response.
Parameters
request
fastapi.Request
The request object.
response
fastapi.Response
The response object.
Usage
from fastapi import Request, Response
import chainlit as cl
@cl.on_logout
def main(request: Request, response: Response):
response.delete_cookie("my_cookie")
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/elements/imageh
Image - ChainlituhX  Elements
Image
The Image
class is designed to create and handle image elements to be sent and displayed in the chatbot user interface.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the image to be displayed in the UI.
display
ElementDisplay
Determines how the image element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
size
ElementSize
Determines the size of the image. Only works with display=“inline”. Choices are “small”, “medium” (default), or “large”.
url
str
The remote URL of the image source.
path
str
The local file path of the image.
content
bytes
The file content of the image in bytes format.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
image = cl.Image(path="./cat.jpeg", name="image1", display="inline")
# Attach the image to the message
await cl.Message(
content="This message has an image!",
elements=[image],
).send()hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/elements/videoh
Video - ChainlituhX  Elements
Video
The Video
class allows you to display an video player for a specific video file in the chatbot user interface.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the video file to be displayed in the UI. This is shown to users.
display
ElementDisplay
Determines where the element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
url
str
The remote URL of the video.
path
str
The local file path of the video.
content
bytes
The file content of the video in bytes format.
Example
import chainlit as cl
@cl.on_chat_start
async def main():
elements = [
cl.Video(name="example.mp4", path="./example.mp4", display="inline"),
]
await cl.Message(
content="Here is an video file",
elements=elements,
).send()hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/elements/texth
Text - ChainlituhX]  Text
The Text
class allows you to display a text element in the chatbot UI. This class takes a string and creates a text element that can be sent to the UI.
It supports the markdown syntax for formatting text.
You must provide either an url or a path or content bytes.
Attributes
The name of the text element to be displayed in the UI.
The text string or bytes that should be displayed as the content of the text element.
The remote URL of the text source.
The local file path of the text file.
Determines how the text element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
Language of the code if the text is a piece of code. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
text_content = "Hello, this is a text element."
elements = [
cl.Text(name="simple_text", content=text_content, display="inline")
]
await cl.Message(
content="Check out this text element!",
elements=elements,
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h;https://docs.chainlit.io/api-reference/input-widgets/selecth
Select - ChainlituhX  Input Widgets
Select
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
values
List[str]
Labels for the select options.
items
Dict[str, str]
Labels with corresponding values for the select options.
initial_value
int
The initial value of the input widget.
initial_index
int
Index of the initial value of the input widget. Can only be used in combination with ‘values’.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Select
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Select(
id="Model",
label="OpenAI - Model",
values=["gpt-3.5-turbo", "gpt-3.5-turbo-16k", "gpt-4", "gpt-4-32k"],
initial_index=0,
)
]
).send()
value = settings["Model"]
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/api-reference/make-asynch
make_async - ChainlituhX  Misceallaneous
make_async
The make_async
function takes a synchronous function (for instance a LangChain agent) and returns an asynchronous function that will run the original function in a separate thread.
This is useful to run long running synchronous tasks without blocking the event loop.
Parameters
func
Callable
The synchronous function to run in a separate thread.
Returns
async_function
Coroutine
requiredThe asynchronous function that will run the synchronous function in a separate thread.
Usage
import time
import chainlit as cl
def sync_func():
time.sleep(5)
return "Hello!"
@cl.on_message
async def main(message: cl.Message):
answer = await cl.make_async(sync_func)()
await cl.Message(
content=answer,
).send()
LangChain agent
import chainlit as cl
res = await cl.make_async(agent)(input_str, callbacks=[cl.LangchainCallbackHandler()])
await cl.Message(content=res["text"]).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/api-reference/actionh
Action - ChainlituhX  Chat
Action
The Action
class is designed to create and manage actions to be sent and displayed in the chatbot user interface. Actions consist of buttons that the user can interact with, and these interactions trigger specific functionalities within your app.
Attributes
name
str
Name of the action, this should be used in the action_callback
value
str
The value associated with the action. This is useful to differentiate between multiple actions with the same name.
label
str
The label of the action. This is what the user will see. If not provided the name will be used.
description
str
The description of the action. This is what the user will see when they hover the action.
collapsed
bool
Show the action in a drawer menu
Usage
import chainlit as cl
@cl.action_callback("action_button")
async def on_action(action):
await cl.Message(content=f"Executed {action.name}").send()
# Optionally remove the action button from the chatbot user interface
await action.remove()
@cl.on_chat_start
async def start():
# Sending an action button within a chatbot message
actions = [
cl.Action(name="action_button", value="example_value", description="Click me!")
]
await cl.Message(content="Interact with this action button:", actions=actions).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/api-reference/step-classh
Step Class - ChainlituhX+
  Step Class
The Step
class is a Python Context Manager that can be used to create steps in your chainlit app. The step is created when the context manager is entered and is updated to the client when the context manager is exited.
Parameters
The name of the step. Default to the name of the decorated function.
The type of the step, useful for monitoring and debugging.
Elements to attach to the step.
By default the step will be nested under the previous step/message. Set this
to True
to make it a root step.
Language of the output. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
By default only the output of the step is shown. Set this to True
to also
show the input. You can also set this to a language like json
or python
to
syntax highlight the input.
Send a Step
import chainlit as cl
@cl.on_message
async def main():
async with cl.Step(name="Test") as step:
# Step is sent as soon as the context manager is entered
step.input = "hello"
step.output = "world"
# Step is updated when the context manager is exited
Stream the Output
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI()
@cl.on_message
async def main(msg: cl.Message):
# Whether to nest the step under the user message
root = True
async with cl.Step(name="gpt4", type="llm", root=root) as step:
step.input = msg.content
stream = await client.chat.completions.create(
messages=[{"role": "user", "content": msg.content}],
stream=True,
model="gpt-4",
temperature=0,
)
async for part in stream:
delta = part.choices[0].delta
if delta.content:
# Stream the output of the step
await step.stream_token(delta.content)
Nest Steps
To nest steps, simply create a step inside another step.
import chainlit as cl
@cl.on_chat_start
async def main():
async with cl.Step(name="Parent step") as parent_step:
parent_step.input = "Parent step input"
async with cl.Step(name="Child step") as child_step:
child_step.input = "Child step input"
child_step.output = "Child step output"
parent_step.output = "Parent step output"
Update a Step
import chainlit as cl
@cl.on_chat_start
async def main():
async with cl.Step(name="Parent step") as step:
step.input = "Parent step input"
step.output = "Parent step output"
await cl.sleep(2)
step.output = "Parent step output updated"
await step.update()
Remove a Step
import chainlit as cl
@cl.on_chat_start
async def main():
async with cl.Step(name="Parent step") as step:
step.input = "Parent step input"
step.output = "Parent step output"
await cl.sleep(2)
await step.remove()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/elements/audioh
Audio - ChainlituhX{  Elements
Audio
The Audio
class allows you to display an audio player for a specific audio file in the chatbot user interface.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the audio file to be displayed in the UI. This is shown to users.
display
ElementDisplay
Determines where the element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
url
str
The remote URL of the audio.
path
str
The local file path of the audio.
content
bytes
The file content of the audio in bytes format.
auto_play
bool
Whether the audio should start playing automatically.
Example
import chainlit as cl
@cl.on_chat_start
async def main():
elements = [
cl.Audio(name="example.mp3", path="./example.mp3", display="inline"),
]
await cl.Message(
content="Here is an audio file",
elements=elements,
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h<https://docs.chainlit.io/api-reference/integrations/haystackh
Haystack - ChainlituhX  Haystack
The current Haystack integration allows you to run chainlit apps and visualise intermediary steps. Playground capabilities will be added with the release of Haystack 2.0.
Haystack is an end-to-end NLP framework that enables you to build NLP applications powered by LLMs, Transformer models, vector search and more. Whether you want to perform question answering, answer generation, semantic document search, or build tools that are capable of complex decision making and query resolution, you can use the state-of-the-art NLP models with Haystack to build end-to-end NLP applications solving your use case. Check out their repo: https://github.com/deepset-ai/haystack.
A Haystack agent run with reasoning steps
Installation
pip install farm-haystack chainlit
Integration
Create a new Python file named app.py with the code below.
This code adds the Chainlit callback handler to the Haystack callback manager. The callback handler is responsible for listening to the chain’s intermediate steps and sending them to the UI.
Then, you can run chainlit run app.py
in your terminal to run the app and interact with your agent.
Example
Check out this full example from the cookbook: https://github.com/Chainlit/cookbook/tree/main/haystack
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hBhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-chat-endh
on_chat_end - ChainlituhX  Life Cycle Hooks
on_chat_end
Hook to react to the user websocket disconnection event.
Usage
import chainlit as cl
@cl.on_chat_start
def start():
print("hello", cl.user_session.get("id"))
@cl.on_chat_end
def end():
print("goodbye", cl.user_session.get("id"))
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hDhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-chat-starth
on_chat_start - ChainlituhX  Life Cycle Hooks
on_chat_start
Hook to react to the user websocket connection event.
Usage
Code Example
from chainlit import AskUserMessage, Message, on_chat_start
@on_chat_start
async def main():
res = await AskUserMessage(content="What is your name?", timeout=30).send()
if res:
await Message(
content=f"Your name is: {res['content']}.\nChainlit installation is working!\nYou can now start building your own chainlit apps!",
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h7https://docs.chainlit.io/api-reference/ask/ask-for-fileh
AskFileMessage - ChainlituhX5  AskFileMessage
Ask the user to upload a file before continuing. If the user does not answer in time (see timeout), a TimeoutError will be raised or None will be returned depending on raise_on_timeout. If a project ID is configured, the messages will be uploaded to the cloud storage.
Attributes
Text displayed above the upload button.
List of mime type to accept like ["text/csv", "application/pdf"]
or a dict like {"text/plain": [".txt", ".py"]}
.
More infos here https://react-dropzone.org/#!/Accepting%20specific%20file%20types.
Maximum file size in MB. Defaults to 2.
Maximum number of files to upload. Defaults to 1. Maximum value is 10.
The number of seconds to wait for an answer before raising a TimeoutError.
Whether to raise a socketio TimeoutError if the user does not answer in time.
Returns
The files uploaded by the user.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
files = None
# Wait for the user to upload a file
while files == None:
files = await cl.AskFileMessage(
content="Please upload a text file to begin!", accept=["text/plain"]
).send()
text_file = files[0]
with open(text_file.path, "r", encoding="utf-8") as f:
text = f.read()
# Let the user know that the system is ready
await cl.Message(
content=f"`{text_file.name}` uploaded, it contains {len(text)} characters!"
).send()
You can also pass a dict to the accept
parameter to precise the file extension for each mime type:
import chainlit as cl
file = await cl.AskFileMessage(
content="Please upload a python file to begin!", accept={"text/plain": [".py"]}
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/integrations/fastapih
FastAPI - ChainlituhX  Integrations
FastAPI
Chainlit can be mounted as a FastAPI sub application.
my_cl_app
import chainlit as cl
@cl.on_chat_start
async def main():
await cl.Message(content="Hello World").send()
main
from fastapi import FastAPI
from chainlit.utils import mount_chainlit
app = FastAPI()
@app.get("/app")
def read_main():
return {"message": "Hello World from main app"}
mount_chainlit(app=app, target="my_cl_app.py", path="/chainlit")
In the example above, we have a FastAPI application with a single endpoint /app
. We mount the Chainlit application my_cl_app.py
to the /chainlit
path.
Start the FastAPI server:
uvicorn main:app --host 0.0.0.0 --port 80
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hAhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-messageh
on_message - ChainlituhX]  Life Cycle Hooks
on_message
Decorator to react to messages coming from the UI. The decorated function is called every time a new message is received.
Parameters
message
cl.Message
The message coming from the UI.
Usage
import chainlit as cl
@cl.on_message
def main(message: cl.Message):
content = message.content
# do something
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hIhttps://docs.chainlit.io/api-reference/data-persistence/custom-data-layerh
Custom Data Layer - ChainlituhX  Custom Data Layer
The BaseDataLayer
class serves as an abstract foundation for data persistence operations within the Chainlit framework. This class outlines methods for managing users, feedback, elements, steps, and threads in a chatbot application.
Methods
Fetches a user by their identifier. Return type is optionally a PersistedUser
.
Creates a new user based on the User
instance provided. Return type is optionally a PersistedUser
.
Inserts or updates feedback. Accepts a Feedback
instance and returns a string as an identifier of the persisted feedback.
Deletes a feedback by feedback_id
. Return True
if it was successful.
Adds a new element to the data layer. Accepts ElementDict
as an argument.
Retrieves an element by thread_id
and element_id
. Return type is optionally an ElementDict
.
Deletes an element given its identifier element_id
.
Creates a new step in the data layer. Accepts StepDict
as an argument.
Updates an existing step. Accepts StepDict
as an argument.
Deletes a step given its identifier step_id
.
Fetches the author of a given thread by thread_id
. Returns a string representing the author identifier.
Deletes a thread given its identifier thread_id
.
Lists threads based on pagination
and filters
arguments. Returns a PaginatedResponse[ThreadDict]
.
Retrieves a thread by its identifier thread_id
. Return type is optionally a ThreadDict
.
Updates a thread’s details like name, user_id, metadata, and tags. Arguments are mostly optional.
Deletes a user session given its identifier id
. Returns a boolean value indicating success.
Decorators
Queues certain methods to execute only after the first user message is received, especially useful for WebsocketSessions
.
Example
Due to the abstract nature of BaseDataLayer
, direct instantiation and usage are not practical without subclassing and implementing the abstract methods.
You can refer to the guide for custom data layer implementation.hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/concepts/chat-lifecycleh
Chat Life Cycle - ChainlituhX  Chat Life Cycle
Whenever a user connects to your Chainlit app, a new chat session is created. A chat session goes through a life cycle of events, which you can respond to by defining hooks.
On Chat Start
The on_chat_start decorator is used to define a hook that is called when a new chat session is created.
@cl.on_chat_start
def on_chat_start():
print("A new chat session has started!")
On Message
The on_message decorator is used to define a hook that is called when a new message is received from the user.
@cl.on_message
def on_message(msg: cl.Message):
print("The user sent: ", msg.content)
On Stop
The on_stop
decorator is used to define a hook that is called when the user clicks the stop button while a task was running.
@cl.on_stop
def on_stop():
print("The user wants to stop the task!")
On Chat End
The on_chat_end decorator is used to define a hook that is called when the chat session ends either because the user disconnected or started a new chat session.
@cl.on_chat_end
def on_chat_end():
print("The user disconnected!")
On Chat Resume
The on_chat_resume decorator is used to define a hook that is called when a user resumes a chat session that was previously disconnected. This can only happen if authentication and data persistence are enabled.
from chainlit.types import ThreadDict
@cl.on_chat_resume
async def on_chat_resume(thread: ThreadDict):
print("The user resumed a previous chat session!")hhuh(h	hh}ubh)}(h}(hNh	}(h9https://docs.chainlit.io/api-reference/ask/ask-for-actionh
AskUserAction - ChainlituhX  Ask User
AskUserAction
Ask for the user to take an action before continuing.
If the user does not answer in time (see timeout), a TimeoutError
will be raised or None
will be returned depending on raise_on_timeout
parameter.
If a project ID is configured, the messages will be uploaded to the cloud storage.
Attributes
content
str
The content of the message.
actions
List[Action]
The list of Action to prompt the user.
author
str
The author of the message, defaults to the chatbot name defined in your config.
disable_human_feedback
bool
default: "False"The number of seconds to wait for an answer before raising a TimeoutError.
timeout
int
default: 90The number of seconds to wait for an answer before raising a TimeoutError.
raise_on_timeout
bool
default: "False"Whether to raise a socketio TimeoutError if the user does not answer in time.
Returns
response
AskActionResponse | None
requiredThe response of the user.
Example
import chainlit as cl
@cl.on_chat_start
async def main():
res = await cl.AskActionMessage(
content="Pick an action!",
actions=[
cl.Action(name="continue", value="continue", label="✅ Continue"),
cl.Action(name="cancel", value="cancel", label="❌ Cancel"),
],
).send()
if res and res.get("value") == "continue":
await cl.Message(
content="Continue!",
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h2https://docs.chainlit.io/data-persistence/overviewh
Overview - ChainlituhXH  Overview
By default, your Chainlit app does not persist the chats and elements it generates. However, the ability to store and utilize this data can be a crucial part of your project or organization.
Once enabled, data persistence will introduce new features to your application.
Features
Enable Data Persistence in 1 minute
- Navigate to Literal AI and sign in.
- You will be prompted to create a new project:
Project Creation Screen
- Navigate to the
Settings
page. A default API key will be generated for youProject API Key
Activation
Once you have an API key, you will need to pass it via a LITERAL_API_KEY
environment variable.
Next to your Chainlit application, create a .env
file and modify it like so:
LITERAL_API_KEY="your key"
Or inlined:
LITERAL_API_KEY="your key" chainlit run main.py
Or inlined for Windows powershell:
$ENV:LITERAL_API_KEY="your key"; chainlit run main.py
Once activated, your chats and elements will be persisted on Literal AI.
Deactivation
If you wish to deactivate data persistence, simply comment out or remove the LITERAL_API_KEY
environment variable.
Data privacy & security
We prioritize your data’s privacy and security. We understand how crucial the data fed into Chainlit Cloud is for your business and handle it with utmost care.
Contact us for detailed information: contact@chainlit.io
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/author-renameh
+author_rename and Message author - ChainlituhXR  Misceallaneous
author_rename and Message author
This documentation covers two methods for setting or renaming the author of a message to display more friendly author names in the UI: the author_rename
decorator and the Message author specification at message creation.
Method 1: author_rename
Useful for renaming the author of a message dynamically during the message handling process.
Parameters
orig_author
str
requiredThe original author name.
Returns
author
str
requiredThe renamed author
Usage
from langchain import OpenAI, LLMMathChain
import chainlit as cl
@cl.author_rename
def rename(orig_author: str):
rename_dict = {"LLMMathChain": "Albert Einstein", "Chatbot": "Assistant"}
return rename_dict.get(orig_author, orig_author)
@cl.on_message
async def main(message: cl.Message):
llm = OpenAI(temperature=0)
llm_math = LLMMathChain.from_llm(llm=llm)
res = await llm_math.acall(message.content, callbacks=[cl.AsyncLangchainCallbackHandler()])
await cl.Message(content="Hello").send()
Method 2: Message author
Allows for naming the author of a message at the moment of the message creation.
Usage
You can specify the author directly when creating a new message object:
from langchain import OpenAI, LLMMathChain
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
llm = OpenAI(temperature=0)
llm_math = LLMMathChain.from_llm(llm=llm)
res = await llm_math.acall(message.content, callbacks=[cl.AsyncLangchainCallbackHandler()])
# Specify the author at message creation
response_message = cl.Message(content="Hello", author="NewChatBotName")
await response_message.send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h*https://docs.chainlit.io/guides/sync-asynch
Async / Sync - ChainlituhXC  Async / Sync
Asynchronous programming is a powerful way to handle multiple tasks concurrently without blocking the execution of your program. Chainlit is async by default to allow agents to execute tasks in parallel and allow multiple users on a single app.
Python introduced the asyncio
library to make it easier to write asynchronous code using the async/await
syntax. This onboarding guide will help you understand the basics of asynchronous programming in Python and how to use it in your Chainlit project.
Understanding async/await
The async
and await
keywords are used to define and work with asynchronous code in Python. An async
function is a coroutine, which is a special type of function that can pause its execution and resume later, allowing other tasks to run in the meantime.
To define an async function, use the async def
syntax:
async def my_async_function():
# Your async code goes here
To call an async function, you need to use the await
keyword:
async def another_async_function():
result = await my_async_function()
Working with Chainlit
Chainlit uses asynchronous programming to handle events and tasks efficiently. When creating a Chainlit agent, you’ll often need to define async functions to handle events and perform actions.
For example, to create an async function that responds to messages in Chainlit:
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
# Your custom logic goes here
# Send a response back to the user
await cl.Message(
content=f"Received: {message.content}",
).send()
Long running synchronous tasks
In some cases, you need to run long running synchronous functions in your Chainlit project. To prevent blocking the event loop, you can utilize the make_async
function provided by the Chainlit library to transform a synchronous function into an asynchronous one:
from chainlit import make_async
def my_sync_function():
# Your synchronous code goes here
import time
time.sleep(10)
return 0
async_function = make_async(my_sync_function)
async def main():
result = await async_function()
By using this approach, you can maintain the non-blocking nature of your project while still incorporating synchronous functions when necessary.
Call an async function from a sync function
If you need to run an asynchronous function inside a sync function, you can use the run_sync
function provided by the Chainlit library:
from chainlit import run_sync
async def my_async_function():
# Your asynchronous code goes here
def main():
result = run_sync(my_async_function())
main()
By following this guide, you should now have a basic understanding of asynchronous programming in Python and how to use it in your Chainlit project. As you continue to work with Chainlit, you’ll find that async/await and the asyncio library provide a powerful and efficient way to handle multiple agents/tasks concurrently.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hEhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-chat-resumeh
on_chat_resume - ChainlituhXv  Life Cycle Hooks
on_chat_resume
Decorator to enable users to continue a conversation. Requires both data persistence and authentication to be enabled.
This decorator will automatically:
- Send the persisted messages and elements to the UI.
- Restore the user session.
Only JSON serializable fields of the user session will be saved and restored. If you are using a Langchain agent for instance, you will need to reinstantiate and set it in the user session yourself.
Usage
Resume Chat Example
Practical example of how to resume a chat with context.
Parameters
thread
ThreadDict
The persisted chat to resume.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/get-started/pure-pythonh
In Pure Python - ChainlituhX  In Pure Python
In this tutorial, we’ll walk through the steps to create a minimal LLM app.
Prerequisites
Before getting started, make sure you have the following:
- A working installation of Chainlit
- Basic understanding of Python programming
Step 1: Create a Python file
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 2: Write the Application Logic
In app.py
, import the Chainlit package and define a function that will handle incoming messages from the chatbot UI. Decorate the function with the @cl.on_message
decorator to ensure it gets called whenever a user inputs a message.
Here’s the basic structure of the script:
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
# Your custom logic goes here...
# Send a response back to the user
await cl.Message(
content=f"Received: {message.content}",
).send()
The main
function will be called every time a user inputs a message in the chatbot UI. You can put your custom logic within the function to process the user’s input, such as analyzing the text, calling an API, or computing a result.
The Message class is responsible for sending a reply back to the user. In this example, we simply send a message containing the user’s input.
Step 3: Run the Application
To start your Chainlit app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.
Next Steps
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h7https://docs.chainlit.io/data-persistence/tags-metadatah
Tags & Metadata - ChainlituhXW  Data Persistence
Tags & Metadata
Tags and metadata provide valuable context for your threads, steps and generations.
More information here.
@cl.step(type="run")
async def func(input):
# some code
cl.context.current_step.metadata = {"experiment":"1"}
cl.context.current_step.tags = ["to review"]
# some code
return output
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h)https://docs.chainlit.io/concepts/messageh
Message - ChainlituhX/  Message
A Message is a piece of information that is sent from the user to an assistant and vice versa. Coupled with life cycle hooks, they are the building blocks of a chat.
A message has a content, a timestamp and cannot be nested.
Example: Reply to a user message
Lets create a simple assistant that replies to a user message with a greeting.
import chainlit as cl
@cl.on_message
async def on_message(message: cl.Message):
response = f"Hello, you just sent: {message.content}!"
await cl.Message(response).send()
Message API
Learn more about the Message API.
Chat Context
Since LLMs are stateless, you will often have to accumulate the messages of the current conversation in a list to provide the full context to LLM with each query.
You could do that manually with the user_session. However, Chainlit provides a built-in way to do this:
import chainlit as cl
@cl.on_message
async def on_message(message: cl.Message):
# Get all the messages in the conversation in the OpenAI format
print(cl.chat_context.to_openai())
# Send the response
response = f"Hello, you just sent: {message.content}!"
await cl.Message(response).send()
Every message sent or received will be automatically accumulated in cl.chat_context
.
You can then use cl.chat_context.to_openai()
to get the conversation in the OpenAI format and feed it to the LLM.\     hhuh(h	hh}ubh)}(h}(hNh	}(h/https://docs.chainlit.io/integrations/mistralaih
Mistral AI - ChainlituhXN	  Mistral AI
The benefits of this integration is that you can see the Mistral AI API calls in a step in the UI, and you can explore them in the prompt playground.
You will also get the full generation details (prompt, completion, tokens per second…) in your Literal AI dashboard, if your project is using Literal AI.
To benefit from tracing, you need to add cl.instrument_mistralai()
after creating your Mistral AI client.
You shouldn’t configure this integration if you’re already using another integration like Haystack, Langchain or LlamaIndex. Both integrations would record the same generation and create duplicate steps in the UI.
Prerequisites
Before getting started, make sure you have the following:
- A working installation of Chainlit
- The Mistral AI python client package installed,
mistralai
- A Mistral AI API key
- Basic understanding of Python programming
Step 1: Create a Python file
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 2: Write the Application Logic
In app.py
, import the necessary packages and define one function to handle messages incoming from the UI.
import os
import chainlit as cl
from mistralai.async_client import MistralAsyncClient
mai_client = MistralAsyncClient()
# Instrument the Mistral AI client
cl.instrument_mistralai()
settings = {
"model": "mistral-large-latest",
"temperature": 0,
# ... more settings
}
@cl.on_message
async def on_message(message: cl.Message):
response = await mai_client.chat(
messages=[
{
"content": "You are a helpful bot, you always reply in Spanish",
"role": "system"
},
{
"content": message.content,
"role": "user"
}
],
**settings
)
await cl.Message(content=response.choices[0].message.content).send()
Step 3: Fill the environment variables
Create a file named .env
in the same folder as your app.py
file. Add your Mistral AI API key in the MISTRAL_API_KEY
variable.
You can optionally add your Literal AI API key in the LITERAL_API_KEY
.
Step 4: Run the Application
To start your app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.hhuh(h	hh}ubh)}(h}(hNh	}(h2https://docs.chainlit.io/customisation/custom-fonth
Font - ChainlituhX  Customisation
Font
To use a custom font, modify your configuration settings in .chainlit/config.toml.
config.toml
[UI]
# This should be a google font url
custom_font = "https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap"
Then, update your theme’s font family to use the custom font.
config.toml
[UI.theme]
font_family = "Inter, sans-serif"
Once the configuration is updated, restart the application. Your custom font will now be used.hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/data-persistence/enterpriseh
Enterprise - ChainlituhXP  Enterprise
If your organization can’t use third party cloud services for data hosting, we can provide your company with a self-hostable Literal AI docker image (under commercial license).
To request access you can contact us here -> https://forms.gle/BX3UNBLmTF75KgZVA.
Define your Literal AI Server
Once you are hosting your own Literal AI instance, you can point to the server for data persistence.
You will need to use the LITERAL_API_URL
environment variable.
Modify the .env
file next to your Chainlit application.
LITERAL_API_URL="https://cloud.your_literal.com"
Alternatively, inlined:
LITERAL_API_URL="https://cloud.your_literal.com" chainlit run main.py
Activating Data Persistence
Using your own Literal AI instance, you will still need to provide a valid API key to persist the data as described here.
Once activated, your chats and elements will be stored on your own server.
Debug Mode
You can enable the new debug mode by adding -d
to your chainlit run
command. You will see a debug button below each message taking you to the trace/prompt playground.
Debug example
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/integrations/llama-indexh
Llama Index - ChainlituhX
  Llama Index
In this tutorial, we will guide you through the steps to create a Chainlit application integrated with Llama Index.
Preview of the app you'll build
Prerequisites
Before diving in, ensure that the following prerequisites are met:
- A working installation of Chainlit
- The Llama Index package installed
- An OpenAI API key
- A basic understanding of Python programming
Step 1: Set Up Your Data Directory
Create a folder named data
in the root of your app folder. Download the state of the union file (or any files of your own choice) and place it in the data
folder.
Step 2: Create the Python Script
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 3: Write the Application Logic
In app.py
, import the necessary packages and define one function to handle a new chat session and another function to handle messages incoming from the UI.
In this tutorial, we are going to use RetrieverQueryEngine
. Here’s the basic structure of the script:
import os
import openai
import chainlit as cl
from llama_index.core import (
Settings,
StorageContext,
VectorStoreIndex,
SimpleDirectoryReader,
load_index_from_storage,
)
from llama_index.llms.openai import OpenAI
from llama_index.embeddings.openai import OpenAIEmbedding
from llama_index.core.query_engine.retriever_query_engine import RetrieverQueryEngine
from llama_index.core.callbacks import CallbackManager
from llama_index.core.service_context import ServiceContext
openai.api_key = os.environ.get("OPENAI_API_KEY")
try:
# rebuild storage context
storage_context = StorageContext.from_defaults(persist_dir="./storage")
# load index
index = load_index_from_storage(storage_context)
except:
documents = SimpleDirectoryReader("./data").load_data(show_progress=True)
index = VectorStoreIndex.from_documents(documents)
index.storage_context.persist()
@cl.on_chat_start
async def start():
Settings.llm = OpenAI(
model="gpt-3.5-turbo", temperature=0.1, max_tokens=1024, streaming=True
)
Settings.embed_model = OpenAIEmbedding(model="text-embedding-3-small")
Settings.context_window = 4096
service_context = ServiceContext.from_defaults(callback_manager=CallbackManager([cl.LlamaIndexCallbackHandler()]))
query_engine = index.as_query_engine(streaming=True, similarity_top_k=2, service_context=service_context)
cl.user_session.set("query_engine", query_engine)
await cl.Message(
author="Assistant", content="Hello! Im an AI assistant. How may I help you?"
).send()
@cl.on_message
async def main(message: cl.Message):
query_engine = cl.user_session.get("query_engine") # type: RetrieverQueryEngine
msg = cl.Message(content="", author="Assistant")
res = await cl.make_async(query_engine.query)(message.content)
for token in res.response_gen:
await msg.stream_token(token)
await msg.send()
This code sets up an instance of RetrieverQueryEngine
for each chat session. The RetrieverQueryEngine
is invoked everytime a user sends a message to generate the response.
The callback handlers are responsible for listening to the intermediate steps and sending them to the UI.
Step 4: Launch the Application
To kick off your LLM app, open a terminal, navigate to the directory containing app.py
, and run the following command:
chainlit run app.py -w
The -w
flag enables auto-reloading so that you don’t have to restart the server each time you modify your application. Your chatbot UI should now be accessible at http://localhost:8000.hhuh(h	hh}ubh)}(h}(hNh	}(h;https://docs.chainlit.io/api-reference/input-widgets/switchh
Switch - ChainlituhXj  Input Widgets
Switch
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
int
The initial value of the input widget.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Switch
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Switch(id="Streaming", label="OpenAI - Stream Tokens", initial=True),
]
).send()
value = settings["Streaming"]hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/authentication/overviewh
Overview - ChainlituhXX  Authentication
Overview
Chainlit applications are public by default. To enable authentication and make your app private, you need to:
- Define a
CHAINLIT_AUTH_SECRET
environment variable. This is a secret string that is used to sign the authentication tokens. You can change it at any time, but it will log out all users. You can easily generate one usingchainlit create-secret
. - Add one or more authentication callbacks to your app:
Password Auth
Authenticate users with login/password.
OAuth
Authenticate users with your own OAuth app (like Google).
Header
Authenticate users based on a custom header.
Each callback take a different input and optionally return a cl.User
object. If the callback returns None
, the authentication is considered as failed.
Make sure each user has a unique identifier to prevent them from sharing their data.
Get the current authenticated user
You can access the current authenticated user through the User Session.
@cl.on_chat_start
async def on_chat_start():
app_user = cl.user_session.get("user")
await cl.Message(f"Hello {app_user.identifier}").send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h>https://docs.chainlit.io/api-reference/input-widgets/textinputh
TextInput - ChainlituhX  Input Widgets
TextInput
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
str
The initial value of the input widget.
placeholder
str
The placeholder value of the input widget.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import TextInput
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
TextInput(id="AgentName", label="Agent Name", initial="AI"),
]
).send()
value = settings["AgentName"]
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h/https://docs.chainlit.io/customisation/overviewh
Overview - ChainlituhXa  Customisation
Overview
You can tailor your Chainlit Application to reflect your organization’s branding or personal style. Our intention is to provide a good level of customization to ensure a consistent user experience that aligns with your visual guidelines.
In this section we will go through the different options available.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h,https://docs.chainlit.io/customisation/themeh
Theme - ChainlituhXC  Customisation
Theme
Looking to refresh your app’s appearance? You can easily alter the default theme colors in your config.toml
file.
Currently, you have the freedom to modify:
- Background color: This option allows you to change the color of the app’s background.
- Paper color: This alters the color of the ‘paper’ elements within the app, such as the navbar, widgets, etc.
- Primary color: This encompasses three shades - main, dark, and light. These colors are primarily used for interactive interface elements.
If you started your Chainlit app with -w (file watcher), it will refresh every time you update the theme!
Default Theme
To set the default theme, navigate to the [UI.theme]
section in your config.toml
file and update the default
value.
config.toml
[UI.theme]
default = "dark"
Light Theme Modification
To modify the light theme, find or create the [UI.theme.light]
section and update the colors as per your preference.
config.toml
[UI.theme.light]
background = "#110061"
paper = "#FFFFFF"
[UI.theme.light.primary]
main = "#110061"
dark = "#180039"
light = "#FFE7EB"
Dark Theme Modification
To alter the dark theme, the section begins with [UI.theme.dark]
.
config.toml
[UI.theme.dark]
background = "#FAFAFA"
paper = "#FFFFFF"
[UI.theme.dark.primary]
main = "#A80061"
dark = "#380039"
light = "#FFE7EB"
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h>https://docs.chainlit.io/api-reference/integrations/llamaindexh
&LlamaIndex Callback Handler - ChainlituhX  Integrations
LlamaIndex Callback Handler
Callback Handler to enable Chainlit to display intermediate steps in the UI.
Usage
Code Example
from llama_index.core.callbacks import CallbackManager
from llama_index.core.service_context import ServiceContext
import chainlit as cl
@cl.on_chat_start
async def start():
service_context = ServiceContext.from_defaults(callback_manager=CallbackManager([cl.LlamaIndexCallbackHandler()]))
# use the service context to create the predictor
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/chat-settingsh
Chat Settings - ChainlituhXz  Chat
Chat Settings
The ChatSettings
class is designed to create and send a dynamic form to the UI. This form can be updated by the user.
Attributes
inputs
List[InputWidget]
The fields of the form
Usage
import chainlit as cl
from chainlit.input_widget import Select, Switch, Slider
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Select(
id="Model",
label="OpenAI - Model",
values=["gpt-3.5-turbo", "gpt-3.5-turbo-16k", "gpt-4", "gpt-4-32k"],
initial_index=0,
),
Switch(id="Streaming", label="OpenAI - Stream Tokens", initial=True),
Slider(
id="Temperature",
label="OpenAI - Temperature",
initial=1,
min=0,
max=2,
step=0.1,
),
Slider(
id="SAI_Steps",
label="Stability AI - Steps",
initial=30,
min=10,
max=150,
step=1,
description="Amount of inference steps performed on image generation.",
),
Slider(
id="SAI_Cfg_Scale",
label="Stability AI - Cfg_Scale",
initial=7,
min=1,
max=35,
step=0.1,
description="Influences how strongly your generation is guided to match your prompt.",
),
Slider(
id="SAI_Width",
label="Stability AI - Image Width",
initial=512,
min=256,
max=2048,
step=64,
tooltip="Measured in pixels",
),
Slider(
id="SAI_Height",
label="Stability AI - Image Height",
initial=512,
min=256,
max=2048,
step=64,
tooltip="Measured in pixels",
),
]
).send()
@cl.on_settings_update
async def setup_agent(settings):
print("on_settings_update", settings)
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h7https://docs.chainlit.io/api-reference/ask/ask-for-fileh
AskFileMessage - ChainlituhX5  AskFileMessage
Ask the user to upload a file before continuing. If the user does not answer in time (see timeout), a TimeoutError will be raised or None will be returned depending on raise_on_timeout. If a project ID is configured, the messages will be uploaded to the cloud storage.
Attributes
Text displayed above the upload button.
List of mime type to accept like ["text/csv", "application/pdf"]
or a dict like {"text/plain": [".txt", ".py"]}
.
More infos here https://react-dropzone.org/#!/Accepting%20specific%20file%20types.
Maximum file size in MB. Defaults to 2.
Maximum number of files to upload. Defaults to 1. Maximum value is 10.
The number of seconds to wait for an answer before raising a TimeoutError.
Whether to raise a socketio TimeoutError if the user does not answer in time.
Returns
The files uploaded by the user.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
files = None
# Wait for the user to upload a file
while files == None:
files = await cl.AskFileMessage(
content="Please upload a text file to begin!", accept=["text/plain"]
).send()
text_file = files[0]
with open(text_file.path, "r", encoding="utf-8") as f:
text = f.read()
# Let the user know that the system is ready
await cl.Message(
content=f"`{text_file.name}` uploaded, it contains {len(text)} characters!"
).send()
You can also pass a dict to the accept
parameter to precise the file extension for each mime type:
import chainlit as cl
file = await cl.AskFileMessage(
content="Please upload a python file to begin!", accept={"text/plain": [".py"]}
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h*https://docs.chainlit.io/examples/cookbookh
Cookbook - ChainlituhX@  Examples
Cookbook
The Cookbook repository serves as a valuable resource and starting point for developers looking to explore the capabilities of Chainlit in creating LLM apps.
It provides a diverse collection of example projects, each residing in its own folder, showcasing the integration of various tools such as OpenAI, Anthropiс, LangChain, LlamaIndex, ChromaDB, Pinecone and more.
Whether you are seeking basic tutorials or in-depth use cases, the Cookbook repository offers inspiration and practical insights!
https://github.com/Chainlit/cookbook
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/api-reference/messageh
Message - ChainlituhX  Chat
Message
The Message
class is designed to send, stream, update or remove messages.
Parameters
content
str
The content of the message.
author
str
The author of the message, defaults to the chatbot name defined in your config file.
elements
Element[]
Elements to attach to the message.
actions
Action[]
Actions to attach to the message.
language
str
Language of the code if the content is code. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
Send a message
Send a new message to the UI.
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
await cl.Message(
content=f"Received: {message.content}",
).send()
Stream a message
Send a message token by token to the UI.
import chainlit as cl
token_list = ["the", "quick", "brown", "fox"]
@cl.on_chat_start
async def main():
msg = cl.Message(content="")
for token in token_list:
await msg.stream_token(token)
await msg.send()
Update a message
Update a message that already has been sent.
import chainlit as cl
@cl.on_chat_start
async def main():
msg = cl.Message(content="Hello!")
await msg.send()
await cl.sleep(2)
msg.content = "Hello again!"
await msg.update()
Remove a message
Remove a message from the UI.
import chainlit as cl
@cl.on_chat_start
async def main():
msg = cl.Message(content="Message 1")
await msg.send()
await cl.sleep(2)
await msg.remove()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/api-reference/actionh
Action - ChainlituhX  Chat
Action
The Action
class is designed to create and manage actions to be sent and displayed in the chatbot user interface. Actions consist of buttons that the user can interact with, and these interactions trigger specific functionalities within your app.
Attributes
name
str
Name of the action, this should be used in the action_callback
value
str
The value associated with the action. This is useful to differentiate between multiple actions with the same name.
label
str
The label of the action. This is what the user will see. If not provided the name will be used.
description
str
The description of the action. This is what the user will see when they hover the action.
collapsed
bool
Show the action in a drawer menu
Usage
import chainlit as cl
@cl.action_callback("action_button")
async def on_action(action):
await cl.Message(content=f"Executed {action.name}").send()
# Optionally remove the action button from the chatbot user interface
await action.remove()
@cl.on_chat_start
async def start():
# Sending an action button within a chatbot message
actions = [
cl.Action(name="action_button", value="example_value", description="Click me!")
]
await cl.Message(content="Interact with this action button:", actions=actions).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h*https://docs.chainlit.io/examples/securityh
Security - PII - ChainlituhXx
  Security - PII
When building chat applications, it’s crucial to ensure the secure handling of sensitive data, especially Personal Identifiable Information (PII). PII can be directly or indirectly linked to an individual, making it essential to protect user privacy by preventing the transmission of such data to language models.
Example of PII
Consider the text below, where PII has been highlighted:
Hello, my name is John and I live in New York. My credit card number is 3782-8224-6310-005 and my phone number is (212) 688-5500.
And here is the anonymized version:
Hello, my name is <PERSON> and I live in <LOCATION>. My credit card number is <CREDIT_CARD> and my phone number is <PHONE_NUMBER>.
Analyze and anonymize data
Integrate Microsoft Presidio for robust data sanitization in your Chainlit application.
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
# Notice that the message is passed as is
response = await cl.Message(
content=f"Received: {message.content}",
).send()
Before proceeding, ensure that the Python packages required for PII analysis and anonymization are installed. Run the following commands in your terminal to install them:
pip install presidio-analyzer presidio-anonymizer spacy
python -m spacy download en_core_web_lg
Create an async context manager that utilizes the Presidio Analyzer to inspect the incoming text for any PII. This context manager can be included in your main function to scrutinize messages before they are processed. When PII is detected, you should present the user with the option to either continue or cancel the operation. Use Chainlit’s messaging system to accomplish this.
from presidio_analyzer import AnalyzerEngine
from contextlib import asynccontextmanager
analyzer = AnalyzerEngine()
@asynccontextmanager
async def check_text(text: str):
pii_results = analyzer.analyze(text=text, language="en")
if pii_results:
response = await cl.AskActionMessage(
content="PII detected",
actions=[
cl.Action(name="continue", value="continue", label="✅ Continue"),
cl.Action(name="cancel", value="cancel", label="❌ Cancel"),
],
).send()
if response is None or response.get("value") == "cancel":
raise InterruptedError
yield
# ...
@cl.on_message
async def main(message: cl.Message):
async with check_text(message.content):
# This block is only executed when the user press "Continue"
response = await cl.Message(
content=f"Received: {message.content}",
).send()
If your application has a requirement to anonymize PII, Presidio can also do that. Modify the check_text context manager to return anonymized text when PII is detected.
from presidio_anonymizer import AnonymizerEngine
anonymizer = AnonymizerEngine()
@asynccontextmanager
async def check_text(text: str):
pii_results = analyzer.analyze(text=text, language="en")
if pii_results:
response = await cl.AskActionMessage(
content="PII detected",
actions=[
cl.Action(name="continue", value="continue", label="✅ Continue"),
cl.Action(name="cancel", value="cancel", label="❌ Cancel"),
],
).send()
if response is None or response.get("value") == "cancel":
raise InterruptedError
yield anonymizer.anonymize(
text=text,
analyzer_results=pii_results,
).text
else:
yield text
# ...
@cl.on_message
async def main(message: cl.Message):
async with check_text(message.content) as anonymized_message:
response = await llm_chain.arun(
anonymized_message
callbacks=[cl.AsyncLangchainCallbackHandler()]
)
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h'https://docs.chainlit.io/deploy/discordh
Discord - ChainlituhX
  Discord
To make your Chainlit app available on Discord, you will need to create a Discord app and set up the necessary environment variables.
How it Works
The Discord bot will listen to messages mentioning it in channels and direct messages. It will send replies to a dedicated thread or DM depending on the context.
Preview
Supported Features
Message | Streaming | Elements | Audio | Ask User | Chat History | Chat Profiles | Feedback |
---|---|---|---|---|---|---|---|
✅ | ❌ | ✅ | ❌ | ❌ | ✅ | ❌ | ✅ |
Install the Discord Library
The Discord library is not included in the Chainlit dependencies. You will have to install it manually.
pip install discord
Create a Discord App
To start, navigate to the Discord apps dashboard. Here, you should find a button that says New Application. When you click this button, select the option to create your app from scratch.
Create a Discord App
Set the Environment Variables
Navigate to the Bot tab and click on Reset Token
. This will make the token visible. Copy it and set it as an environment variable in your Chainlit app.
Copy the Bot Token
DISCORD_BOT_TOKEN=your_bot_token
Set Intents
Navigate to the Bot tab and enable the MESSAGE CONTENT INTENT
, then click on Save Changes.
Set Intents
Working Locally
If you are working locally, you will have to expose your local Chainlit app to the internet to receive incoming messages to Discord. You can use ngrok for this.
ngrok http 8000
Start the Chainlit App
Since the Chainlit app is not running, the Discord bot will not be able to communicate with it.
For the example, we will use this simple app:
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
# Access the original discord message
print(cl.user_session.get("discord_message"))
# Access the discord user
print(cl.user_session.get("user"))
# Access potential attached files
attached_files = msg.elements
await cl.Message(content="Hello World").send()
Start the Chainlit app.
Using -h to not open the default Chainlit UI since we are using Discord.
chainlit run my_app.py -h
Install the Discord Bot to Your Workspace
Navigate to the OAuth2 tab. In the OAuth2 URL Generator, select the bot
scope.
Configure Installation
Then, in the Bot Permissions section, select the following permissions.
You can check that you have selected the right permissions by looking at the
number of permissions parameter of the URL. It should be 377957238848
.
Bot Permissions
Copy the generated URL and paste it in your browser. You will be prompted to add the bot to a server. Select the server you want to add the bot to.
That’s it! You should now be able to interact with your Chainlit app through Discord.
Chat History
Chat history is directly available through discord.
from chainlit.discord.app import client as discord_client
import chainlit as cl
import discord
@cl.on_message
async def on_message(msg: cl.Message):
# The user session resets on every Discord message.
# So we add previous chat messages manually.
messages = cl.user_session.get("messages", [])
channel: discord.abc.MessageableChannel = cl.user_session.get("discord_channel")
if channel:
cl.user_session.get("messages")
discord_messages = [message async for message in channel.history(limit=10)]
# Go through last 10 messages and remove the current message.
for x in discord_messages[::-1][:-1]:
messages.append({
"role": "assistant" if x.author.name == discord_client.user.name else "user",
"content": x.clean_content if x.clean_content else x.channel.name # first message is empty
})
# Your code here
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h,https://docs.chainlit.io/examples/openai-sqlh
Text to SQL - ChainlituhX  Examples
Text to SQL
Let’s build a simple app that helps users to create SQL queries with natural language.
Preview of the final result
Prerequisites
This example has extra dependencies. You can install them with:
pip install chainlit openai
Imports
app.py
from openai import AsyncOpenAI
import chainlit as cl
cl.instrument_openai()
client = AsyncOpenAI(api_key="YOUR_OPENAI_API_KEY")
Define a prompt template and LLM settings
app.py
template = """SQL tables (and columns):
* Customers(customer_id, signup_date)
* Streaming(customer_id, video_id, watch_date, watch_minutes)
A well-written SQL query that {input}:
```"""
settings = {
"model": "gpt-3.5-turbo",
"temperature": 0,
"max_tokens": 500,
"top_p": 1,
"frequency_penalty": 0,
"presence_penalty": 0,
"stop": ["```"],
}
Add the Assistant Logic
Here, we decorate the main
function with the @on_message decorator to tell Chainlit to run the main
function each time a user sends a message.
Then, we wrap our text to sql logic in a Step.
app.py
@cl.set_starters
async def starters():
return [
cl.Starter(
label=">50 minutes watched",
message="Compute the number of customers who watched more than 50 minutes of video this month."
)
]
@cl.on_message
async def main(message: cl.Message):
stream = await client.chat.completions.create(
messages=[
{
"role": "user",
"content": template.format(input=message.content),
}
], stream=True, **settings
)
msg = await cl.Message(content="", language="sql").send()
async for part in stream:
if token := part.choices[0].delta.content or "":
await msg.stream_token(token)
await msg.update()
Try it out
chainlit run app.py -w
You can ask questions like Compute the number of customers who watched more than 50 minutes of video this month
.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h%https://docs.chainlit.io/integrationsh
FastAPI - ChainlituhX  Integrations
FastAPI
Chainlit can be mounted as a FastAPI sub application.
my_cl_app
import chainlit as cl
@cl.on_chat_start
async def main():
await cl.Message(content="Hello World").send()
main
from fastapi import FastAPI
from chainlit.utils import mount_chainlit
app = FastAPI()
@app.get("/app")
def read_main():
return {"message": "Hello World from main app"}
mount_chainlit(app=app, target="my_cl_app.py", path="/chainlit")
In the example above, we have a FastAPI application with a single endpoint /app
. We mount the Chainlit application my_cl_app.py
to the /chainlit
path.
Start the FastAPI server:
uvicorn main:app --host 0.0.0.0 --port 80
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h*https://docs.chainlit.io/concepts/startersh
Starters - ChainlituhX0  Basic Concepts
Starters
Starters are suggestions to help your users get started with your assistant. You can declare up to 4 starters and optionally define an icon for each one.
starters.py
import chainlit as cl
@cl.set_starters
async def set_starters():
return [
cl.Starter(
label="Morning routine ideation",
message="Can you help me create a personalized morning routine that would help increase my productivity throughout the day? Start by asking me about my current habits and what activities energize me in the morning.",
icon="/public/idea.svg",
),
cl.Starter(
label="Explain superconductors",
message="Explain superconductors like I'm five years old.",
icon="/public/learn.svg",
),
cl.Starter(
label="Python script for daily email reports",
message="Write a script to automate sending daily email reports in Python, and walk me through how I would set it up.",
icon="/public/terminal.svg",
),
cl.Starter(
label="Text inviting friend to wedding",
message="Write a text asking a friend to be my plus-one at a wedding next month. I want to keep it super short and casual, and offer an out.",
icon="/public/write.svg",
)
]
# ...
Starters example
With Chat Profiles
Starters also work with Chat Profiles. You can define different starters for different chat profiles.
starters_with_chat_profiles.py
@cl.set_chat_profiles
async def chat_profile(current_user: cl.User):
if current_user.metadata["role"] != "ADMIN":
return None
return [
cl.ChatProfile(
name="My Chat Profile",
icon="https://picsum.photos/250",
markdown_description="The underlying LLM model is **GPT-3.5**, a *175B parameter model* trained on 410GB of text data.",
starters=[
cl.Starter(
label="Morning routine ideation",
message="Can you help me create a personalized morning routine that would help increase my productivity throughout the day? Start by asking me about my current habits and what activities energize me in the morning.",
icon="/public/idea.svg",
),
cl.Starter(
label="Explain superconductors",
message="Explain superconductors like I'm five years old.",
icon="/public/learn.svg",
),
],
)
]
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/guides/migration/1.1.400h
'Migrate to Chainlit v1.1.400 - ChainlituhX  Guides
Migrate to Chainlit v1.1.400
Join the discord for live updates: https://discord.gg/AzyvDHWARx
Updating Chainlit
Begin the migration by updating Chainlit to the latest version:
pip install --upgrade chainlit
More control over Chain of Thought
The hide_cot
config parameter has been replaced with cot
. The cot
parameter can be set to hidden
, tool_call
, or full
. This parameter controls the display of the Chain of Thought (COT) in the UI.
disable_feedback
is gone
Chainlit 1.1.400 takes a different approach to feedback. Now, a user input will trigger a run. Once the run is complete, the user can provide feedback for the whole run instead of being able to score each message. This change simplifies the feedback process and makes it more intuitive.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h8https://docs.chainlit.io/advanced-features/chat-profilesh
Chat Profiles - ChainlituhXb  Advanced Features
Chat Profiles
Chat Profiles are useful if you want to let your users choose from a list of predefined configured assistants. For example, you can define a chat profile for a support chat, a sales chat, or a chat for a specific product.
Chat Profiles API
Learn how to define chat profiles.
Example of Chat Profiles
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hAhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-messageh
on_message - ChainlituhX]  Life Cycle Hooks
on_message
Decorator to react to messages coming from the UI. The decorated function is called every time a new message is received.
Parameters
message
cl.Message
The message coming from the UI.
Usage
import chainlit as cl
@cl.on_message
def main(message: cl.Message):
content = message.content
# do something
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/get-started/installationh
Installation - ChainlituhXQ  Get Started
Installation
Chainlit requires python>=3.8
.
You can install Chainlit it via pip as follows:
pip install chainlit
This will make the chainlit
command available on your system.
Make sure everything runs smoothly:
chainlit hello
This should spawn the chainlit UI and ask for your name like so:
Next steps
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/customisation/custom-jsh

JS - ChainlituhX[  Customisation
JS
You can inject a custom JavaScript script into the application by adding the following to your config.toml
:
config.toml
[UI]
# ...
# This can either be a css file in your `public` dir or a URL
custom_js = '/public/my_js_script.js'
Once the configuration is updated, restart the application. Your custom script will now be loaded.hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/elements/audioh
Audio - ChainlituhX{  Elements
Audio
The Audio
class allows you to display an audio player for a specific audio file in the chatbot user interface.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the audio file to be displayed in the UI. This is shown to users.
display
ElementDisplay
Determines where the element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
url
str
The remote URL of the audio.
path
str
The local file path of the audio.
content
bytes
The file content of the audio in bytes format.
auto_play
bool
Whether the audio should start playing automatically.
Example
import chainlit as cl
@cl.on_chat_start
async def main():
elements = [
cl.Audio(name="example.mp3", path="./example.mp3", display="inline"),
]
await cl.Message(
content="Here is an audio file",
elements=elements,
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h(https://docs.chainlit.io/deploy/overviewh
Overview - ChainlituhX  Overview
A Chainlit application can be consumed through multiple platforms. Write your assistant logic once, use everywhere!
Available Platforms
Web App
The native Chainlit UI. Available on port 8000.
Copilot
Embed your Chainlit app on any website as a Copilot.
API
Expose custom API endpoints.
Custom React App
Learn how to integrate your custom React frontend with the Chainlit backend.
Teams
Make your Chainlit app available on Teams.
Slack
Make your Chainlit app available on Slack.
Discord
Make your Chainlit app available on Discord.
Deploy your Chainlit Application
No matter the platform(s) you want to serve with your Chainlit application, you will need to deploy it first.
After you’ve successfully set up and tested your Chainlit application locally, the next step is to make it accessible to a wider audience by deploying it to a hosting service. This guide provides various options for self-hosting your Chainlit app.
When running a Chainlit app in production, you should always add -h
to the
chainlit run
command. Otherwise a browser window will be opened server side
and might break your deployment.
Chainlit is built upon websockets, which means the service you deploy your app to has to support them. For auto scaling, make sure to enable sticky sessions.
If you need to deploy your Chainlit app to a subpath like
https://my-app.com/chainlit
, you will need to set the --root-path /chainlit
flag when running the chainlit run
command. This will ensure that
the app is served from the correct path.
- on Ploomber Cloud
- on AWS
- on Azure Container
- on Google Cloud Run
- on Google App Engine
- on Replit
- on Render
- on Fly.io
- on HuggingFace Spaces
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/backend/env-variablesh
 Environment Variables - ChainlituhX  Environment Variables
Hardcoding API keys in your code is not a good practice. It makes your code less portable and less flexible. It also makes it harder to keep your code secure. Instead, you should use environment variables to store values that are specific to your development environment.
Chainlit will automatically load environment variables from a .env
file in the root of your project. This file should be added to your .gitignore
file so that it is not committed to your repository.
OPENAI_API_KEY=sk-...
PINECONE_API_KEY=...
Public Apps & Environment Variables
If you want to share your app to a broader audience, you should not put your own OpenAI API keys in the .env
file.
Instead, you should use user_env
in the Chainlit config to ask each user to provide their own keys.
You can then access the user’s keys in your code using:
import chainlit as cl
user_env = cl.user_session.get("env")
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/elements/imageh
Image - ChainlituhX  Elements
Image
The Image
class is designed to create and handle image elements to be sent and displayed in the chatbot user interface.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the image to be displayed in the UI.
display
ElementDisplay
Determines how the image element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
size
ElementSize
Determines the size of the image. Only works with display=“inline”. Choices are “small”, “medium” (default), or “large”.
url
str
The remote URL of the image source.
path
str
The local file path of the image.
content
bytes
The file content of the image in bytes format.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
image = cl.Image(path="./cat.jpeg", name="image1", display="inline")
# Attach the image to the message
await cl.Message(
content="This message has an image!",
elements=[image],
).send()hhuh(h	hh}ubh)}(h}(hNh	}(h@https://docs.chainlit.io/api-reference/lifecycle-hooks/on-logouth
on_logout - ChainlituhX  Life Cycle Hooks
on_logout
Decorator to react to a user logging out. Useful to clear cookies or other user data through the HTTP response.
Parameters
request
fastapi.Request
The request object.
response
fastapi.Response
The response object.
Usage
from fastapi import Request, Response
import chainlit as cl
@cl.on_logout
def main(request: Request, response: Response):
response.delete_cookie("my_cookie")
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h#https://docs.chainlit.io/deploy/apih
API - ChainlituhX3
  API
You can mount your Chainlit app on an existing FastAPI app to create custom endpoints. One good use case for this is to serve an assistant through a rest API.
How it works
To mount your Chainlit app on an existing FastAPI app, you will have to define a subpath for your Chainlit app.
from fastapi import FastAPI
from chainlit.utils import mount_chainlit
app = FastAPI()
@app.get("/app")
def read_main():
return {"message": "Hello World from main app"}
mount_chainlit(app=app, target="my_cl_app.py", path="/chainlit")
Now run your FastAPI app and you will be able to access your Chainlit app at /chainlit
.
uvicorn app:app --host 0.0.0.0 --port 80
Use Chainlit APIs in your endpoint
To use Chainlit APIs, a Chainlit context is required.
HTTP context
In an HTTP context, Chainlit APIs such as Message.send() will do nothing.
If data persistence is enabled, the Chainlit APIs will still persist data.
from fastapi import FastAPI
from chainlit.utils import mount_chainlit
from chainlit.context import init_http_context
import chainlit as cl
app = FastAPI()
@app.get("/app")
async def read_main():
init_http_context()
await cl.Message(content="Hello, I am a chatbot!").send()
return {"message": "Hello World from main app"}
# pass path="" to mount the Chainlit app on the root path
mount_chainlit(app=app, target="my_cl_app.py", path="/chainlit")
Websocket context
The only use case that requires to use the Websocket context within a custom endpoint is to send data to a websocket client (which you know the session ID of) based on some arbitrary HTTP request.
import chainlit as cl
@cl.on_chat_start
def main():
print("Session id:", cl.user_session.get("id"))
from fastapi import FastAPI, Request
from chainlit.utils import mount_chainlit
from chainlit.context import init_ws_context
from chainlit.session import WebsocketSession
import chainlit as cl
app = FastAPI()
@app.get("/hello/{session_id}")
async def hello(
request: Request,
session_id: str,
):
ws_session = WebsocketSession.get_by_id(session_id=session_id)
init_ws_context(ws_session)
await cl.Message(content="Hello World").send()
return "Data sent to the websocket client"
mount_chainlit(app=app, target="./my_cl_app.py")
Authentication
You can use any authentication system since the request is accessible. However Chainlit authentication is fully compatible with custom endpoints.
from typing_extensions import Annotated
from fastapi import Request, Depends, FastAPI
from fastapi.responses import (
HTMLResponse,
)
from chainlit.context import init_http_context
from chainlit.auth import authenticate_user
import chainlit as cl
app = FastAPI()
@app.get("/hello")
async def hello(
request: Request,
current_user: Annotated[
cl.User, Depends(authenticate_user)
],
):
print(current_user)
init_http_context(user=current_user)
await cl.Message(content="Hello World").send()
return HTMLResponse("Hello World")
Once an endpoint is protected, it will require to have a valid token in the Authorization
header.
{
"Authorization": "Bearer TOKEN"
}
Generate a token
The token is the same token generated when you login in the Chainlit app. You can generate a token manually for a given user with this python script.
This will require to have a CHAINLIT_AUTH_SECRET. You can run chainlit create-secret
to create one.
from chainlit.auth import create_jwt
import chainlit as cl
print(create_jwt(cl.User(identifier="USERNAME")))hhuh(h	hh}ubh)}(h}(hNh	}(h*https://docs.chainlit.io/backend/config/uih

UI - ChainlituhX-  Config
UI
Options
name
str
default: "My Chatbot"The name of both the application and the chatbot.
description
str
The content of the <meta name="description">
of the application.
cot
Literal['hidden', 'tool_call', 'full']
default: "full"The chain of thought (COT) is a feature that shows the user the steps the chatbot took to reach a conclusion. You can hide the COT, only show the tool calls, or show it in full.
default_collapse_content
bool
default: trueWhen handling large text content we collapse it for keeping the threads concise. You can disable manually disable this behavior.
default_expand_message
bool
default: falseSub-messages are hiden by default, you can “expand” the parent message to show those messages. Toggling this setting will display the sub-messages by default.
github
str
Passing this option will display a Github-shaped link. If not passed we will display the link to Chainlit repo.
Default configuration
[UI]
# Name of the app and chatbot.
name = "Chatbot"
# Description of the app and chatbot. This is used for HTML tags.
# description = ""
# Large size content are by default collapsed for a cleaner ui
default_collapse_content = true
# The default value for the expand messages settings.
default_expand_messages = false
# Chain of Thought (CoT) display mode. Can be "hidden", "tool_call" or "full".
cot = "full"
# Link to your github repo. This will add a github button in the UI's header.
# github = ""
# Specify a CSS file that can be used to customize the user interface.
# The CSS file can be served from the public directory or via an external link.
# custom_css = "/public/test.css"
[UI.theme]
#layout = "wide"
#font_family = "Inter, sans-serif"
# Override default MUI light theme. (Check theme.ts)
[UI.theme.light]
#background = "#FAFAFA"
#paper = "#FFFFFF"
[UI.theme.light.primary]
#main = "#F80061"
#dark = "#980039"
#light = "#FFE7EB"
# Override default MUI dark theme. (Check theme.ts)
[UI.theme.dark]
#background = "#FAFAFA"
#paper = "#FFFFFF"
[UI.theme.dark.primary]
#main = "#F80061"
#dark = "#980039"
#light = "#FFE7EB"
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hBhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-chat-endh
on_chat_end - ChainlituhX  Life Cycle Hooks
on_chat_end
Hook to react to the user websocket disconnection event.
Usage
import chainlit as cl
@cl.on_chat_start
def start():
print("hello", cl.user_session.get("id"))
@cl.on_chat_end
def end():
print("goodbye", cl.user_session.get("id"))
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h%https://docs.chainlit.io/deploy/teamsh
Teams - ChainlituhXU
  Teams
To make your Chainlit app available on Teams, you will need to create a Teams bot and set up the necessary environment variables.
How it Works
The Teams bot will be available in direct messages.
Preview
Supported Features
Message | Streaming | Elements | Audio | Ask User | Chat History | Chat Profiles | Feedback |
---|---|---|---|---|---|---|---|
✅ | ❌ | ✅ | ❌ | ❌ | ❌ | ❌ | ✅ |
Install the Botbuilder Library
The Botbuilder library is not included in the Chainlit dependencies. You will have to install it manually.
pip install botbuilder-core
Create a Teams App
To start, navigate to the App Management page. Here, create a new app.
Create a Teams App
Fill the App Basic Information
Navigate to Configure > Basic Information and fill in the basic information about your app. You won’t be able to publish your app until you fill in all the required fields.
Basic infos
Create the Bot
Navigate to Configure > App features and add the Bot feature. Create a new bot and give it the following permissions and save.
Bot permissions
Go to the Bot Framework Portal
Navigate to the Bot Framework Portal, click on the Bot you just created and go to the Settings page.
Get the App ID
In the Bot Framework Portal, you will find the app ID. Copy it and set it as an environment variable in your Chainlit app.
TEAMS_APP_ID=your_app_id
Get the App ID
Working Locally
If you are working locally, you will have to expose your local Chainlit app to the internet to receive incoming messages to Teams. You can use ngrok for this.
ngrok http 8000
This will give you a public URL that you can use to set up the app manifest. Do not forget to replace it once you deploy Chainlit to a public host.
Set the Message Endpoint
Under Configuration, set the messaging endpoint to your Chainlit app HTTPS URL and add the /teams/events
suffix.
Messaging endpoint
Get the App Secret
On the same page, you will find a blue “Manage Microsoft App ID and password” button. Click on it.
Manage password
Navigate to Manage > Certificates & secrets and create a new client secret. Copy it and set it as an environment variable in your Chainlit app.
TEAMS_APP_PASSWORD=your_app_secret
Support Multi Tenant Account Types
Navigate to Manage > Authentication and toggle “Accounts in any organizational directory (Any Microsoft Entra ID tenant - Multitenant)” then save.
Multi tenant
Start the Chainlit App
Since the Chainlit app is not running, the Teams bot will not be able to communicate with it.
For the example, we will use this simple app:
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
# Access the teams user
print(cl.user_session.get("user"))
# Access potential attached files
attached_files = msg.elements
await cl.Message(content="Hello World").send()
Reminder: Make sure the environment variables are set and that your local chainlit app is exposed to the internet via ngrok.
Start the Chainlit app:
chainlit run my_app.py -h
Using -h to not open the default Chainlit UI since we are using Teams.
Publish the Bot
Back to the App Management page, navigate to “Publish to org” and click on “Publish”.
Publish
Authorize the Bot
The Bot will have to be authorized by the Teams admin before it can be used. To do so navigate to the Teams admin center and find the app.
Publish
Then authorize it.
Publish
You should now be able to interact with your Chainlit app through Teams.hhuh(h	hh}ubh)}(h}(hNh	}(h!https://docs.chainlit.io/conceptsh
Chat Life Cycle - ChainlituhX  Chat Life Cycle
Whenever a user connects to your Chainlit app, a new chat session is created. A chat session goes through a life cycle of events, which you can respond to by defining hooks.
On Chat Start
The on_chat_start decorator is used to define a hook that is called when a new chat session is created.
@cl.on_chat_start
def on_chat_start():
print("A new chat session has started!")
On Message
The on_message decorator is used to define a hook that is called when a new message is received from the user.
@cl.on_message
def on_message(msg: cl.Message):
print("The user sent: ", msg.content)
On Stop
The on_stop
decorator is used to define a hook that is called when the user clicks the stop button while a task was running.
@cl.on_stop
def on_stop():
print("The user wants to stop the task!")
On Chat End
The on_chat_end decorator is used to define a hook that is called when the chat session ends either because the user disconnected or started a new chat session.
@cl.on_chat_end
def on_chat_end():
print("The user disconnected!")
On Chat Resume
The on_chat_resume decorator is used to define a hook that is called when a user resumes a chat session that was previously disconnected. This can only happen if authentication and data persistence are enabled.
from chainlit.types import ThreadDict
@cl.on_chat_resume
async def on_chat_resume(thread: ThreadDict):
print("The user resumed a previous chat session!")hhuh(h	hh}ubh)}(h}(hNh	}(h2https://docs.chainlit.io/customisation/translationh
Translation - ChainlituhX  Translation
Translation files are located in the .chainlit/translations
directory. The files are named after the language code, e.g. en-US.json
for English (United States).
The language is dynamically set for each user based on the language of the
browser. The default language is en-US
.
Customizing UI text
In addition to standard translations, you can customize the text of front-end components used within the UI. Each UI element is associated with a unique translation key in the translation files. By modifying these keys, you can personalize or localize the UI text according to your needs.
For example, to change the label of a navigation tab from “Readme” to “Documentation”, locate the corresponding key in your translation file (e.g., components.organisms.header.readme
) and update the value:
"components.organisms.header.readme": "Documentation"
Adding a new language
To add a new language, create a new file in the .chainlit/translations
directory with the language code as the filename. The language code should be in the format of languageCode-COUNTRYCODE
, e.g. en-US
for English (United States) or en-GB
for English (United Kingdom).
Lint translations
To lint the translations, run the following command:
chainlit lint-translations
Translate chainlit.md file
You can define multiple translations for the chainlit.md
file. For instance chainlit_pt-BR.md
for Portuguese (Brazil) and chainlit_es-ES.md
for Spanish (Spain).
The file will be loaded based on the browser’s language, defaulting to chainlit.md
if no translation is available.
Resetting
To reset the the translations, remove the .chainlit/translations
directory and restart your Chainlit application:
chainlit run my-app.pyhhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/get-started/overviewh
Overview - ChainlituhXr  Overview
Chainlit is an open-source Python package to build production ready Conversational AI.
Build Conversational AI with Chainlit
Key features
-
Build fast: Integrate seamlessly with an existing code base or start from scratch in minutes
-
Multi Platform: Write your assistant logic once, use everywhere
-
Data persistence: Collect, monitor and analyze data from your users
-
Visualize multi-steps reasoning: Understand the intermediary steps that produced an output at a glance
Integrations
Chainlit is compatible with all Python programs and libraries. That being said, it comes with a set of integrations with popular libraries and frameworks.
OpenAI
Learn how to explore your OpenAI calls in Chainlit.
OpenAI Assistant
Learn how to integrate your OpenAI Assistants with Chainlit.
Mistral AI
Learn how to use any Mistral AI calls in Chainlit.
Llama Index
Learn how to integrate your Llama Index code with Chainlit.
LangChain
Learn how to use any LangChain agent with Chainlit.
Autogen
Learn how to integrate your Autogen agents with Chainlit.
Haystack
Learn how to integrate your Haystack code with Chainlit.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h)https://docs.chainlit.io/data-persistenceh
Overview - ChainlituhXH  Overview
By default, your Chainlit app does not persist the chats and elements it generates. However, the ability to store and utilize this data can be a crucial part of your project or organization.
Once enabled, data persistence will introduce new features to your application.
Features
Enable Data Persistence in 1 minute
- Navigate to Literal AI and sign in.
- You will be prompted to create a new project:
Project Creation Screen
- Navigate to the
Settings
page. A default API key will be generated for youProject API Key
Activation
Once you have an API key, you will need to pass it via a LITERAL_API_KEY
environment variable.
Next to your Chainlit application, create a .env
file and modify it like so:
LITERAL_API_KEY="your key"
Or inlined:
LITERAL_API_KEY="your key" chainlit run main.py
Or inlined for Windows powershell:
$ENV:LITERAL_API_KEY="your key"; chainlit run main.py
Once activated, your chats and elements will be persisted on Literal AI.
Deactivation
If you wish to deactivate data persistence, simply comment out or remove the LITERAL_API_KEY
environment variable.
Data privacy & security
We prioritize your data’s privacy and security. We understand how crucial the data fed into Chainlit Cloud is for your business and handle it with utmost care.
Contact us for detailed information: contact@chainlit.io
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h)https://docs.chainlit.io/concepts/elementh
Element - ChainlituhXh	  Element
Text messages are the building blocks of a chatbot, but we often want to send more than just text to the user such as images, videos, and more.
That is where elements come in. Each element is a piece of content that can be attached to a Message or a Step and displayed on the user interface.
Text Element
Ideal to display RAG sources.
Image Element
Ideal to display generated images.
PDF Element
Ideal to display RAG sources.
More Elements
The complete list of elements you can display on the user interface.
Example
To attach an element to a message or step, we need to:
- Instantiate the element
- Attach the element to a message or step
import chainlit as cl
@cl.on_chat_start
async def start():
image = cl.Image(path="./cat.jpeg", name="image1", display="inline")
# Attach the image to the message
await cl.Message(
content="This message has an image!",
elements=[image],
).send()
Display Options
There are 3 display options that determine how an element is rendered:
Side
@cl.on_chat_start
async def start():
# Notice the display option
image = cl.Image(path="./cat.jpeg", name="cat image", display="side")
await cl.Message(
# Notice that the name of the image is referenced in the message content
content="Here is the cat image!",
elements=[image],
).send()
The image will not be displayed in the message. Instead, the name of the image will be displayed as clickable link. When the user clicks on the link, the image will be displayed on the side of the message.
Page
@cl.on_chat_start
async def start():
# Notice the display option
image = cl.Image(path="./cat.jpeg", name="cat image", display="page")
await cl.Message(
# Notice that the name of the image is referenced in the message content
content="Here is the cat image!",
elements=[image],
).send()
The image will not be displayed in the message. Instead, the name of the image will be displayed as clickable link. Clicking on the link will redirect to a dedicated page where the image will be displayed.
Inline
@cl.on_chat_start
async def start():
# Notice the display option
image = cl.Image(path="./cat.jpeg", name="cat image", display="inline")
await cl.Message(
# Notice that the name of the image is NOT referenced in the message content
content="Hello!",
elements=[image],
).send()
The image will be displayed below with the message regardless of whether the image name is referenced in the message content.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hDhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-chat-starth
on_chat_start - ChainlituhX  Life Cycle Hooks
on_chat_start
Hook to react to the user websocket connection event.
Usage
Code Example
from chainlit import AskUserMessage, Message, on_chat_start
@on_chat_start
async def main():
res = await AskUserMessage(content="What is your name?", timeout=30).send()
if res:
await Message(
content=f"Your name is: {res['content']}.\nChainlit installation is working!\nYou can now start building your own chainlit apps!",
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/advanced-features/streamingh
Streaming - ChainlituhX`  Advanced Features
Streaming
Chainlit supports streaming for both Message and Step. Here is an example with openai
.
Streaming OpenAI response
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI(api_key="YOUR_OPENAI_API_KEY")
settings = {
"model": "gpt-3.5-turbo",
"temperature": 0.7,
"max_tokens": 500,
"top_p": 1,
"frequency_penalty": 0,
"presence_penalty": 0,
}
@cl.on_chat_start
def start_chat():
cl.user_session.set(
"message_history",
[{"role": "system", "content": "You are a helpful assistant."}],
)
@cl.on_message
async def main(message: cl.Message):
message_history = cl.user_session.get("message_history")
message_history.append({"role": "user", "content": message.content})
msg = cl.Message(content="")
await msg.send()
stream = await client.chat.completions.create(
messages=message_history, stream=True, **settings
)
async for part in stream:
if token := part.choices[0].delta.content or "":
await msg.stream_token(token)
message_history.append({"role": "assistant", "content": msg.content})
await msg.update()
Integrations
Streaming is also supported at a higher level for some integrations.
For example, to use streaming with Langchain just pass streaming=True
when instantiating the LLM:
llm = OpenAI(temperature=0, streaming=True)
Also make sure to pass a callback handler to your chain or agent run.
See here for final answer streaming.hhuh(h	hh}ubh)}(h}(hNh	}(h6https://docs.chainlit.io/api-reference/elements/pyploth
Pyplot - ChainlituhX   Elements
Pyplot
The Pyplot
class allows you to display a Matplotlib pyplot chart in the chatbot UI. This class takes a pyplot figure.
The difference of between this element and the Plotly
element is that the user is shown a static image of the chart when using Pyplot
.
Attributes
name
str
The name of the chart to be displayed in the UI.
display
ElementDisplay
Determines how the chart element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
size
ElementSize
Determines the size of the chart. Only works with display=“inline”. Choices are “small”, “medium” (default), or “large”.
figure
str
The matplotlib.figure.Figure
instance that you want to display.
Example
import matplotlib.pyplot as plt
import chainlit as cl
@cl.on_chat_start
async def main():
fig, ax = plt.subplots()
ax.plot([1, 2, 3, 4], [1, 4, 2, 3])
elements = [
cl.Pyplot(name="plot", figure=fig, display="inline"),
]
await cl.Message(
content="Here is a simple plot",
elements=elements,
).send()hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/api-reference/step-classh
Step Class - ChainlituhX+
  Step Class
The Step
class is a Python Context Manager that can be used to create steps in your chainlit app. The step is created when the context manager is entered and is updated to the client when the context manager is exited.
Parameters
The name of the step. Default to the name of the decorated function.
The type of the step, useful for monitoring and debugging.
Elements to attach to the step.
By default the step will be nested under the previous step/message. Set this
to True
to make it a root step.
Language of the output. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
By default only the output of the step is shown. Set this to True
to also
show the input. You can also set this to a language like json
or python
to
syntax highlight the input.
Send a Step
import chainlit as cl
@cl.on_message
async def main():
async with cl.Step(name="Test") as step:
# Step is sent as soon as the context manager is entered
step.input = "hello"
step.output = "world"
# Step is updated when the context manager is exited
Stream the Output
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI()
@cl.on_message
async def main(msg: cl.Message):
# Whether to nest the step under the user message
root = True
async with cl.Step(name="gpt4", type="llm", root=root) as step:
step.input = msg.content
stream = await client.chat.completions.create(
messages=[{"role": "user", "content": msg.content}],
stream=True,
model="gpt-4",
temperature=0,
)
async for part in stream:
delta = part.choices[0].delta
if delta.content:
# Stream the output of the step
await step.stream_token(delta.content)
Nest Steps
To nest steps, simply create a step inside another step.
import chainlit as cl
@cl.on_chat_start
async def main():
async with cl.Step(name="Parent step") as parent_step:
parent_step.input = "Parent step input"
async with cl.Step(name="Child step") as child_step:
child_step.input = "Child step input"
child_step.output = "Child step output"
parent_step.output = "Parent step output"
Update a Step
import chainlit as cl
@cl.on_chat_start
async def main():
async with cl.Step(name="Parent step") as step:
step.input = "Parent step input"
step.output = "Parent step output"
await cl.sleep(2)
step.output = "Parent step output updated"
await step.update()
Remove a Step
import chainlit as cl
@cl.on_chat_start
async def main():
async with cl.Step(name="Parent step") as step:
step.input = "Parent step input"
step.output = "Parent step output"
await cl.sleep(2)
await step.remove()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/customisation/custom-cssh
CSS - ChainlituhXL  Customisation
CSS
Chainlit Application allows for design customization through the use of a custom CSS stylesheet. To enable this, modify your configuration settings in .chainlit/config.toml.
config.toml
[UI]
# ...
# This can either be a css file in your `public` dir or a URL
custom_css = '/public/stylesheet.css'
At the moment, we do not provide a detailed guide of all the available css classes. It is up to you to dig in the Web Inspector and find the css class you wish to override.
Once the configuration is updated, restart the application. Your custom styling will now be applied.T      hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/customisation/avatarsh
Avatars - ChainlituhX  Customisation
Avatars
The default assistant avatar is the favicon of the application. See how to customize the favicon here.
However, you can customize the avatar by placing an image file in the /public/avatars
folder.
The image file should be named after the author of the message. For example, if the author is My Assistant
, the avatar should be named my_assistant.png
.
public/
└── avatars/
└── my_assistant.png
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/backend/command-lineh
Command Line Options - ChainlituhX2  Backend
Command Line Options
The Chainlit CLI (Command Line Interface) is a tool that allows you to interact with the Chainlit system via command line. It provides several commands to manage your Chainlit applications.
Commands
init
The init
command initializes a Chainlit project by creating a configuration file located at .chainlit/config.toml
chainlit init
run
The run
command starts a Chainlit application.
chainlit run [OPTIONS] TARGET
Options:
-w, --watch
: Reload the app when the module changes. When this option is specified, the file watcher will be started and any changes to files will cause the server to reload the app, allowing faster iterations.-h, --headless
: Prevents the app from opening in the browser.-d, --debug
: Sets the log level to debug. Default log level is error.-c, --ci
: Runs in CI mode.--no-cache
: Disables third parties cache, such as langchain.--host
: Specifies a different host to run the server on.--port
: Specifies a different port to run the server on.--root-path
: Specifies a subpath to run the server on.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h9https://docs.chainlit.io/api-reference/input-widgets/tagsh
Tags - ChainlituhXw  Input Widgets
Tags
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
List[str]
The initial values of the input widget.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Tags
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Tags(id="StopSequence", label="OpenAI - StopSequence", initial=["Answer:"]),
]
).send()
value = settings["StopSequence"]hhuh(h	hh}ubh)}(h}(hNh	}(h3https://docs.chainlit.io/api-reference/elements/pdfh
PDF viewer - ChainlituhXo  PDF viewer
The Pdf
class allows you to display a PDF hosted remotely or locally in the chatbot UI. This class either takes a URL of a PDF hosted online, or the path of a local PDF.
Attributes
The name of the PDF to be displayed in the UI.
Determines how the PDF element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
The remote URL of the PDF file. Must provide url for a remote PDF (or either path or content for a local PDF).
The local file path of the PDF. Must provide either path or content for a local PDF (or url for a remote PDF).
The file content of the PDF in bytes format. Must provide either path or content for a local PDF (or url for a remote PDF).
Example
Inline
import chainlit as cl
@cl.on_chat_start
async def main():
# Sending a pdf with the local file path
elements = [
cl.Pdf(name="pdf1", display="inline", path="./pdf1.pdf")
]
cl.Message(content="Look at this local pdf!", elements=elements).send()
Side and Page
You must have the name of the pdf in the content of the message for the link to be created.
import chainlit as cl
@cl.on_chat_start
async def main():
# Sending a pdf with the local file path
elements = [
cl.Pdf(name="pdf1", display="side", path="./pdf1.pdf")
]
# Reminder: The name of the pdf must be in the content of the message
await cl.Message(content="Look at this local pdf1!", elements=elements).send()hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/step-decoratorh
Step Decorator - ChainlituhXQ  Step Decorator
The step decorator will log steps based on the decorated function. By default, the arguments of the function will be used as the input of the step and the return value will be used as the output.
Under the hood, the step decorator is using the cl.Step class.
tool
steps will be displayed in the UI.Parameters
The name of the step. Default to the name of the decorated function.
The type of the step, useful for monitoring and debugging.
By default the step will be nested under the previous step/message. Set this
to True
to make it a root step.
Language of the output. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
By default only the output of the step is shown. Set this to True
to also
show the input. You can also set this to a language like json
or python
to
syntax highlight the input.
Access the Current step
You can access the current step object using cl.context.current_step
and override values.
import chainlit as cl
@cl.step
async def my_step():
current_step = cl.context.current_step
# Override the input of the step
current_step.input = "My custom input"
# Override the output of the step
current_step.output = "My custom output"
Stream the Output
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI(api_key="YOUR_API_KEY")
@cl.step(type="llm")
async def gpt4():
settings = {
"model": "gpt-4",
"temperature": 0,
}
stream = await client.chat.completions.create(
messages=message_history, stream=True, **settings
)
current_step = cl.context.current_step
async for part in stream:
delta = part.choices[0].delta
if delta.content:
# Stream the output of the step
await current_step.stream_token(delta.content)
Nest Steps
If another step decorated function is called inside the decorated function, the child step will be nested under the parent step.
import chainlit as cl
@cl.step
async def parent_step():
await child_step()
return "Parent step output"
@cl.step
async def child_step():
return "Child step output"
@cl.on_chat_start
async def main():
await parent_step()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h6https://docs.chainlit.io/advanced-features/multi-modalh
Multi-Modality - ChainlituhX  Multi-Modality
The term ‘Multi-Modal’ refers to the ability to support more than just text, encompassing images, videos, audio and files.
Voice Assistant
Chainlit let’s you access the user’s microphone audio stream and process it in real-time. This can be used to create voice assistants, transcribe audio, or even process audio in real-time.
The user will only be able to use the microphone if you implemented the @cl.on_audio_chunk decorator.
Voice Assistant Example
Check the Audio Assistant cookbook example to see how to implement a voice assistant.
Audio capture settings
You can configure audio capture the au through the Chainlit config file.
Spontaneous File Uploads
Within the Chainlit application, users have the flexibility to attach any file to their messages. This can be achieved either by utilizing the drag and drop feature or by clicking on the attach
button located in the chat bar.
Attach files to a message
As a developer, you have the capability to access these attached files through the cl.on_message decorated function.
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
if not msg.elements:
await cl.Message(content="No file attached").send()
return
# Processing images exclusively
images = [file for file in msg.elements if "image" in file.mime]
# Read the first image
with open(images[0].path, "r") as f:
pass
await cl.Message(content=f"Received {len(images)} image(s)").send()
Image Processing with Transformers
Multi-modal capabilities are being added to Large Language Model (effectively making them Large Multi Modal Models). OpenAI’s vision API and the LLaVa cookbook are good places to start for image processing with transformers.
Disabling Spontaneous File Uploads
If you wish to disable this feature (which would prevent users from attaching files to their messages), you can do so by setting features.spontaneous_file_upload.enabled=false
in your Chainlit config file.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/backend/config/featuresh
Features - ChainlituhX  Features
Options
Process and display HTML in messages. This can be a security risk (see https://stackoverflow.com/questions/19603097/why-is-it-dangerous-to-render-user-generated-html-or-javascript).
Allow the user to edit their messages.
Process and display mathematical expressions. This can clash with ”$” characters in messages.
Authorize users to upload files with messages. The files are then accessible in cl.on_message.
Restrict user to only upload accepted mime file types. Example: [“text/plain”, “application/pdf”, “image/x-png”]
Restrict user to upload maximum number of files at a time.
Restrict uploading file size (MB).
Threshold for audio recording.
If the user does not speak for this duration (MS), the recording will be ignored.
Delay for the user to continue speaking in MS. If the user stops speaking for this duration, the recording will stop.
Above this duration (MS), the recording will forcefully stop.
Duration of the audio chunks in MS.
Sample rate of the audio.
Automatically tag threads with the current chat profile (if a chat profile is used)
Default configuration
[features]
unsafe_allow_html = false
latex = false
[features.spontaneous_file_upload]
enabled = true
accept = ["*/*"]
max_files = 20
max_size_mb = 500
[features.audio]
min_decibels = -45
initial_silence_timeout = 3000
silence_timeout = 1500
max_duration = 15000
chunk_duration = 1000
sample_rate = 44100
auto_tag_thread = truehhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/authentication/oauthh
OAuth - ChainlituhX  OAuth
OAuth lets you use third-party services to authenticate your users.
To active an OAuth provider, you need to define both the OAuth callback in your code and the provider(s) environment variables.
Providers
Follow these guides to create an OAuth app for your chosen provider(s). Then copy the information into the right environment variable to active the provider.
If your app is served behind a reverse proxy (like cloud run) you will have to
set the CHAINLIT_URL
environment variable. For instance, if you host your
application at https://mydomain.com
, CHAINLIT_URL
should be set to
https://mydomain.com
.
GitHub
Go to this page to create a new GitHub OAuth app.
The callback URL should be: CHAINLIT_URL/auth/oauth/github/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/github/callback
.
You need to set the following environment variables:
OAUTH_GITHUB_CLIENT_ID
: Client IDOAUTH_GITHUB_CLIENT_SECRET
: Client secret
Gitlab
Go to this page to create a new GitLab OAuth app. When creating the app, you need to allow the openid
, profile
and email
scopes.
The callback URL should be: CHAINLIT_URL/auth/oauth/gitlab/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/gitlab/callback
.
You need to set the following environment variables:
OAUTH_GITLAB_CLIENT_ID
: Client IDOAUTH_GITLAB_CLIENT_SECRET
: Client secretOAUTH_GITLAB_DOMAIN
: domain name (without the protocol)
Go to this page to create a new Google OAuth app.
The callback URL should be: CHAINLIT_URL/auth/oauth/google/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/google/callback
.
You need to set the following environment variables:
OAUTH_GOOGLE_CLIENT_ID
: Client IDOAUTH_GOOGLE_CLIENT_SECRET
: Client secret
Azure Active Directory
Follow this guide to create a new Azure Active Directory OAuth app.
The callback URL should be: CHAINLIT_URL/auth/oauth/azure-ad/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/azure-ad/callback
.
You need to set the following environment variables:
OAUTH_AZURE_AD_CLIENT_ID
: Client IDOAUTH_AZURE_AD_CLIENT_SECRET
: Client secretOAUTH_AZURE_AD_TENANT_ID
: Azure tenant ID
If your application supports “Accounts in this organizational directory only”
(Single tenant), you will need to explicitly set:
OAUTH_AZURE_AD_ENABLE_SINGLE_TENANT=true
. If not, do not set this
environment variable at all.
Okta
Follow this guide to create OIDC app integrations.
The callback URL should be: CHAINLIT_URL/auth/oauth/okta/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/okta/callback
.
You need to set the following environment variables:
OAUTH_OKTA_CLIENT_ID
: Client IDOAUTH_OKTA_CLIENT_SECRET
: Client secretOAUTH_OKTA_DOMAIN
: Domain name for your okta setup - e.g. https://company.okta.com
There are several ways to configure the Okta OAuth routes:
- When using the Single Sign-On to Okta setup, you need to set the
OAUTH_OKTA_AUTHORIZATION_SERVER_ID
environment variable tofalse
. - When using Okta as the identity platform for your app or API either:
- set the
OAUTH_OKTA_AUTHORIZATION_SERVER_ID
environment variable todefault
if you have a developer account, - or set it to the authorization server id from your Custom Authorization Server.
- set the
Descope
Head to the Descope sign-up page, to get started with your account and set up your authentication.
The callback URL should be: CHAINLIT_URL/auth/oauth/descope/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/descope/callback
.
You need to set the following environment variables:
OAUTH_DESCOPE_CLIENT_ID
: Descope Project ID, which can be found under Project Settings in the console.OAUTH_DESCOPE_CLIENT_SECRET
: Descope Access Key, which can be created under Access Keys in the console.
Auth0
Follow this guide to create an Auth0 application.
The callback URL should be: CHAINLIT_URL/auth/oauth/auth0/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/auth0/callback
.
You need to set the following environment variables:
OAUTH_AUTH0_CLIENT_ID
: Client IDOAUTH_AUTH0_CLIENT_SECRET
: Client secretOAUTH_AUTH0_DOMAIN
: Domain name for your auth0 setup
Optional environment variables:
OAUTH_AUTH0_ORIGINAL_DOMAIN
: Original domain name for your auth0 setup, if you are using a custom domain
Amazon Cognito
Follow this guide to create a new Amazon Cognito User Pool.
The callback URL should be: CHAINLIT_URL/auth/oauth/aws-cognito/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/aws-cognito/callback
.
You need to set the following environment variables:
OAUTH_COGNITO_CLIENT_ID
: Client IDOAUTH_COGNITO_CLIENT_SECRET
: Client secretOAUTH_COGNITO_DOMAIN
: Cognito Domain
Examples
Allow all users who passed the oauth authentication.
from typing import Dict, Optional
import chainlit as cl
@cl.oauth_callback
def oauth_callback(
provider_id: str,
token: str,
raw_user_data: Dict[str, str],
default_user: cl.User,
) -> Optional[cl.User]:
return default_user
Only allow users from a specific google domain.
from typing import Dict, Optional
import chainlit as cl
@cl.oauth_callback
def oauth_callback(
provider_id: str,
token: str,
raw_user_data: Dict[str, str],
default_user: cl.User,
) -> Optional[cl.User]:
if provider_id == "google":
if raw_user_data["hd"] == "example.org":
return default_user
return Nonehhuh(h	hh}ubh)}(h}(hNh	}(h8https://docs.chainlit.io/api-reference/ask/ask-for-inputh
AskUserMessage - ChainlituhX  Ask User
AskUserMessage
Ask for the user input before continuing. If the user does not answer in time (see timeout), a TimeoutError will be raised or None will be returned depending on raise_on_timeout. If a project ID is configured, the messages will be uploaded to the cloud storage.
Attributes
content
str
The content of the message.
author
str
The author of the message, defaults to the chatbot name defined in your config.
timeout
int
The number of seconds to wait for an answer before raising a TimeoutError.
raise_on_timeout
bool
Whether to raise a socketio TimeoutError if the user does not answer in time.
Returns
response
Step
requiredThe response of the user.
Usage
import chainlit as cl
@cl.on_chat_start
async def main():
res = await cl.AskUserMessage(content="What is your name?", timeout=10).send()
if res:
await cl.Message(
content=f"Your name is: {res['output']}",
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h%https://docs.chainlit.io/deploy/slackh
Slack - ChainlituhX  Slack
To make your Chainlit app available on Slack, you will need to create a Slack app and set up the necessary environment variables.
How it Works
The Slack bot will listen to messages mentioning it in channels and direct messages. It will send replies to a dedicated thread or DM depending on the context.
Preview
Supported Features
Message | Streaming | Elements | Audio | Ask User | Chat History | Chat Profiles | Feedback |
---|---|---|---|---|---|---|---|
✅ | ❌ | ✅ | ❌ | ❌ | ✅ | ❌ | ✅ |
Install the Slack Bolt Library
The Slack Bolt library is not included in the Chainlit dependencies. You will have to install it manually.
pip install slack_bolt
Create a Slack App
To start, navigate to the Slack apps dashboard for the Slack API. Here, you should find a green button that says Create New App. When you click this button, select the option to create your app from scratch.
Create a name for your bot, such as “ChainlitDemo”. Select the workspace you would like your bot to exist in.
Create a Slack App
Working Locally
If you are working locally, you will have to expose your local Chainlit app to the internet to receive incoming messages to Slack. You can use ngrok for this.
ngrok http 8000
This will give you a public URL that you can use to set up the app manifest. Do not forget to replace it once you deploy Chainlit to a public host.
Set the App Manifest
Go to App Manifest and paste the following Yaml.
{placeholders}
with your own values.display_information:
name: { APP_NAME }
features:
bot_user:
display_name: { APP_NAME }
always_online: false
oauth_config:
scopes:
user:
- im:history
- channels:history
bot:
- app_mentions:read
- channels:read
- chat:write
- files:read
- files:write
- im:history
- im:read
- im:write
- users:read
- users:read.email
- channels:history
- groups:history
settings:
event_subscriptions:
request_url: https://{ CHAINLIT_APP_HOST }/slack/events
bot_events:
- app_home_opened
- app_mention
- message.im
interactivity:
is_enabled: true
request_url: https://{ CHAINLIT_APP_HOST }/slack/events
org_deploy_enabled: false
socket_mode_enabled: false
token_rotation_enabled: false
Click on Save Changes.
Set the App Manifest
You will see a warning stating that the URL is not verified. You can ignore this for now.
[Optional] Allow users to send DMs to Chainlit
By default the app will only listen to mentions in channels.
If you want to allow users to send direct messages to the app, go to App Home and enable “Allow users to send Slash commands and messages from the messages tab”.
Allow DMs
Install the Slack App to Your Workspace
Navigate to the Install App tab and click on Install to Workspace.
Set the Environment Variables
Bot Token
Once the slack application is installed, you will see the Bot User OAuth Token. Set this as an environment variable in your Chainlit app.
Copy the Bot Token
SLACK_BOT_TOKEN=your_bot_token
Signing Secret
Navigate to the Basic Information tab and copy the Signing Secret. Then set it as an environment variable in your Chainlit app.
Copy the Signing Secret
SLACK_SIGNING_SECRET=your_signing_secret
Start the Chainlit App
Since the Chainlit app is not running, the Slack app will not be able to communicate with it.
For the example, we will use this simple app:
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
# Access the original slack event
print(cl.user_session.get("slack_event"))
# Access the slack user
print(cl.user_session.get("user"))
# Access potential attached files
attached_files = msg.elements
await cl.Message(content="Hello World").send()
Reminder: Make sure the environment variables are set and that your local chainlit app is exposed to the internet via ngrok.
Start the Chainlit app:
chainlit run my_app.py -h
Using -h to not open the default Chainlit UI since we are using Slack.
You should now be able to interact with your Chainlit app through Slack.
Chat History
Chat history is directly available through the fetch_slack_message_history
method.
It will fetch the last messages from the current thread or DM channel.
import chainlit as cl
import discord
@cl.on_message
async def on_message(msg: cl.Message):
fetch_slack_message_history = cl.user_session.get("fetch_slack_message_history")
if fetch_slack_message_history:
print(await fetch_slack_message_history(limit=10))
# Your code herehhuh(h	hh}ubh)}(h}(hNh	}(h6https://docs.chainlit.io/api-reference/elements/plotlyh
Plotly - ChainlituhX  Elements
Plotly
The Plotly
class allows you to display a Plotly chart in the chatbot UI. This class takes a Plotly figure.
The advantage of the Plotly
element over the Pyplot
element is that it’s interactive (the user can zoom on the chart for example).
Attributes
name
str
The name of the chart to be displayed in the UI.
display
ElementDisplay
Determines how the chart element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
size
ElementSize
Determines the size of the chart. Only works with display=“inline”. Choices are “small”, “medium” (default), or “large”.
figure
str
The plotly.graph_objects.Figure
instance that you want to display.
Example
import plotly.graph_objects as go
import chainlit as cl
@cl.on_chat_start
async def start():
fig = go.Figure(
data=[go.Bar(y=[2, 1, 3])],
layout_title_text="An example figure",
)
elements = [cl.Plotly(name="chart", figure=fig, display="inline")]
await cl.Message(content="This message has a chart", elements=elements).send()hhuh(h	hh}ubh)}(h}(hNh	}(hEhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-audio-chunkh
on_audio_chunk - ChainlituhX  Life Cycle Hooks
on_audio_chunk
Hook to react to an incoming audio chunk from the user’s microphone.
Usage
from io import BytesIO
import chainlit as cl
@cl.on_audio_chunk
async def on_audio_chunk(chunk: cl.AudioChunk):
if chunk.isStart:
buffer = BytesIO()
# This is required for whisper to recognize the file type
buffer.name = f"input_audio.{chunk.mimeType.split('/')[1]}"
# Initialize the session for a new audio stream
cl.user_session.set("audio_buffer", buffer)
cl.user_session.set("audio_mime_type", chunk.mimeType)
# Write the chunks to a buffer and transcribe the whole audio at the end
cl.user_session.get("audio_buffer").write(chunk.data)
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/deploy/react-frontendh
React - ChainlituhX  Platforms
React
Chainlit allows you to create a custom frontend for your application, offering you the flexibility to design a unique user experience. By integrating your frontend with Chainlit’s backend, you can harness the full power of Chainlit’s features, including:
- Abstractions for easier development
- Monitoring and observability
- Seamless integrations with various tools
- Robust authentication mechanisms
- Support for multi-user environments
- Efficient data streaming capabilities
Custom React frontend
Learn how to integrate your custom React frontend with the Chainlit backend.
The @chainlit/react-client package is designed for integrating Chainlit applications with React. It offers several hooks and an API client for seamless connection and interaction.
Supported Features
Message | Streaming | Elements | Audio | Ask User | Chat History | Chat Profiles | Feedback |
---|---|---|---|---|---|---|---|
✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ |hhuh(h	hh}ubh)}(h}(hNh	}(h2https://docs.chainlit.io/data-persistence/feedbackh
Human Feedback - ChainlituhX?  Human Feedback
Human feedback is a crucial part of developing your LLM app or agent.
It allows your users to provide direct feedback on the interaction, which can be used to improve the performance and accuracy of your system.
By enabling data persistence, each run triggered by a user input will be accompanied by thumbs up and thumbs down icons. Users can also add a text comment to their feedback for more detailed input.
Feedback with comment
Benefits
-
Dataset Creation: Feedback interactions implicitly generate valuable training data to improve the agent’s responses over time.
-
Accuracy Measurement: Feedback scores enable objective measurement and comparison of different agent versions, facilitating continuous model improvement.
-
User-Centric Development: Direct feedback promotes a user-centric approach, ensuring the model evolves to meet user needs and expectations.
-
Training and Fine-Tuning: Human feedback allows for direct model training and fine-tuning based on specific interactions.
How-to
To use human feedback, you first need to enable data persistence.
Human feedback
Conclusion
Human feedback is a powerful tool for improving the performance of your LLM app. By enabling data persistence and collecting feedback, you can create a dataset that can be used to improve the system’s accuracy.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/chat-profilesh
Chat Profiles - ChainlituhX  Chat
Chat Profiles
Decorator to define the list of chat profiles.
If authentication is enabled, you can access the user details to create the list of chat profiles conditionally.
The icon is optional.
Parameters
current_user
User
The message coming from the UI.
Usage
Simple example
import chainlit as cl
@cl.set_chat_profiles
async def chat_profile():
return [
cl.ChatProfile(
name="GPT-3.5",
markdown_description="The underlying LLM model is **GPT-3.5**.",
icon="https://picsum.photos/200",
),
cl.ChatProfile(
name="GPT-4",
markdown_description="The underlying LLM model is **GPT-4**.",
icon="https://picsum.photos/250",
),
]
@cl.on_chat_start
async def on_chat_start():
chat_profile = cl.user_session.get("chat_profile")
await cl.Message(
content=f"starting chat using the {chat_profile} chat profile"
).send()
With authentication
from typing import Optional
import chainlit as cl
@cl.set_chat_profiles
async def chat_profile(current_user: cl.User):
if current_user.metadata["role"] != "ADMIN":
return None
return [
cl.ChatProfile(
name="GPT-3.5",
markdown_description="The underlying LLM model is **GPT-3.5**, a *175B parameter model* trained on 410GB of text data.",
),
cl.ChatProfile(
name="GPT-4",
markdown_description="The underlying LLM model is **GPT-4**, a *1.5T parameter model* trained on 3.5TB of text data.",
icon="https://picsum.photos/250",
),
cl.ChatProfile(
name="GPT-5",
markdown_description="The underlying LLM model is **GPT-5**.",
icon="https://picsum.photos/200",
),
]
@cl.password_auth_callback
def auth_callback(username: str, password: str) -> Optional[cl.User]:
if (username, password) == ("admin", "admin"):
return cl.User(identifier="admin", metadata={"role": "ADMIN"})
else:
return None
@cl.on_chat_start
async def on_chat_start():
user = cl.user_session.get("user")
chat_profile = cl.user_session.get("chat_profile")
await cl.Message(
content=f"starting chat with {user.identifier} using the {chat_profile} chat profile"
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h;https://docs.chainlit.io/api-reference/input-widgets/sliderh
Slider - ChainlituhX8  Input Widgets
Slider
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
int
The initial value of the input widget.
min
int
The minimum permitted slider value. Defaults to 0.
max
int
The maximum permitted slider value. Defaults to 10.
step
int
The stepping interval of the slider. Defaults to 1.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Slider
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Slider(
id="Temperature",
label="OpenAI - Temperature",
initial=1,
min=0,
max=2,
step=0.1,
),
]
).send()
value = settings["Temperature"]hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/integrations/haystackh
Haystack - ChainlituhX  Haystack
The current Haystack integration allows you to run chainlit apps and visualise intermediary steps. Playground capabilities will be added with the release of Haystack 2.0.
Haystack is an end-to-end NLP framework that enables you to build NLP applications powered by LLMs, Transformer models, vector search and more. Whether you want to perform question answering, answer generation, semantic document search, or build tools that are capable of complex decision making and query resolution, you can use the state-of-the-art NLP models with Haystack to build end-to-end NLP applications solving your use case. Check out their repo: https://github.com/deepset-ai/haystack.
A Haystack agent run with reasoning steps
Installation
pip install farm-haystack chainlit
Integration
Create a new Python file named app.py with the code below.
This code adds the Chainlit callback handler to the Haystack callback manager. The callback handler is responsible for listening to the chain’s intermediate steps and sending them to the UI.
Then, you can run chainlit run app.py
in your terminal to run the app and interact with your agent.
Example
Check out this full example from the cookbook: https://github.com/Chainlit/cookbook/tree/main/haystack
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/elements/fileh
File - ChainlituhX  Elements
File
The File
class allows you to display a button that lets users download the content of the file.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the file. This will be shown to users.
url
str
The remote URL of the file image source.
path
str
The local file path of the file image.
content
bytes
The file content of the file image in bytes format.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
elements = [
cl.File(
name="hello.py",
path="./hello.py",
display="inline",
),
]
await cl.Message(
content="This message has a file element", elements=elements
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/backend/config/overviewh
Overview - ChainlituhX  Config
Overview
The .chainlit/config.toml
file is created when you run chainlit run ...
or chainlit init
. It allows you to configure your Chainlit app and to enable/disable specific features.
It is composed of three sections:
The .chainlit/config.toml
file is created when you run chainlit run ...
or chainlit init
. It allows you to configure your Chainlit app and to enable/disable specific features.
It is composed of three sections:hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/advanced-features/test-debugh
Testing & Debugging - ChainlituhX{  Advanced Features
Testing & Debugging
To test or debug your application files and decorated functions, you will need to provide the Chainlit context to your test suite.
In your main application script or test files add:
if __name__ == "__main__":
from chainlit.cli import run_chainlit
run_chainlit(__file__)
Then run the script from your IDE in debug mode.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h3https://docs.chainlit.io/advanced-features/ask-userh
Ask User - ChainlituhX  Advanced Features
Ask User
The ask APIs prompt the user for input. Depending on the API, the user input can be a string, a file, or pick an action.
Until the user provides an input, both the UI and your code will be blocked.
Ask File example
Available Ask APIs
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h&https://docs.chainlit.io/concepts/steph
Step - ChainlituhX<  Basic Concepts
Step
LLM powered Assistants take multiple steps to process a user’s request, forming a chain of thought. Unlike a Message, a Step has a type, an input/output and a start/end.
Depending on the config.ui.cot
setting, the full chain of thought can be displayed in full, hidden or only the tool calls.
In Literal AI, the full chain of thought is logged for debugging and replayability purposes.
A Simple Tool Calling Example
Lets take a simple example of a Chain of Thought that takes a user’s message, process it and sends a response.
import chainlit as cl
@cl.step(type="tool")
async def tool():
# Simulate a running task
await cl.sleep(2)
return "Response from the tool!"
@cl.on_message
async def main(message: cl.Message):
final_answer = await cl.Message(content="").send()
# Call the tool
tool_res = await tool()
# Send the final answer.
await cl.Message(content="This is the final answer").send()
Output of the code above
Step API
There are two ways to create steps, either by using the the @cl.step
decorator or by using the cl.Step
class.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h=https://docs.chainlit.io/api-reference/integrations/langchainh
%Langchain Callback Handler - ChainlituhX  Integrations
Langchain Callback Handler
The following code example demonstrates how to pass a callback handler:
llm = OpenAI(temperature=0)
llm_math = LLMMathChain.from_llm(llm=llm)
@cl.on_message
async def main(message: cl.Message):
res = await llm_math.acall(message.content, callbacks=[cl.LangchainCallbackHandler()])
await cl.Message(content="Hello").send()
Final Answer streaming
If streaming is enabled at the LLM level, Langchain will only stream the intermediate steps. You can enable final answer streaming by passing stream_final_answer=True
to the callback handler.
# Optionally, you can also pass the prefix tokens that will be used to identify the final answer
answer_prefix_tokens=["FINAL", "ANSWER"]
cl.LangchainCallbackHandler(
stream_final_answer=True,
answer_prefix_tokens=answer_prefix_tokens,
)
Final answer streaming will only work with prompts that have a consistent
final answer pattern. It will also not work with
AgentType.STRUCTURED_CHAT_ZERO_SHOT_REACT_DESCRIPTION
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h>https://docs.chainlit.io/customisation/custom-logo-and-faviconh
Logo and Favicon - ChainlituhX}  Logo and Favicon
You can customize the Chainlit application with your own logo and favicon.
Assets such as favicons and logos are cached by default by your browser. You might have to clear your browser cache to see the changes.
Use your Logo
Chainlit Application offers support for both dark and light modes. To accommodate this, prepare two versions of your logo, named logo_dark.png
and logo_light.png
. Place these logos in a /public
folder next to your application. Once you restart the application, your custom logos should be displayed accordingly.
Custom Logo Example
Practical example of how to use custom logos in your Chainlit application.
Use your Favicon
To further enhance branding, you can also update the application’s favicon. Place an image file named favicon
in the public
folder next to your application. After restarting the application, the new favicon will take effect.hhuh(h	hh}ubh)}(h}(hNh	}(h8https://docs.chainlit.io/api-reference/elements/tasklisth
TaskList - ChainlituhXW  Elements
TaskList
The TaskList
class allows you to display a task list next to the chatbot UI.
Attributes
status
str
The status of the TaskList. We suggest using something short like “Ready”, “Running…”, “Failed”, “Done”.
tasks
Task
The list of tasks to be displayed in the UI.
Usage
The TaskList element is slightly different from other elements in that it is not attached to a Message or Step but can be sent directly to the chat interface.
import chainlit as cl
@cl.on_chat_start
async def main():
# Create the TaskList
task_list = cl.TaskList()
task_list.status = "Running..."
# Create a task and put it in the running state
task1 = cl.Task(title="Processing data", status=cl.TaskStatus.RUNNING)
await task_list.add_task(task1)
# Create another task that is in the ready state
task2 = cl.Task(title="Performing calculations")
await task_list.add_task(task2)
# Optional: link a message to each task to allow task navigation in the chat history
message_id = await cl.Message(content="Started processing data").send()
task1.forId = message_id
# Update the task list in the interface
await task_list.send()
# Perform some action on your end
await cl.sleep(1)
# Update the task statuses
task1.status = cl.TaskStatus.DONE
task2.status = cl.TaskStatus.FAILED
task_list.status = "Failed"
await task_list.send()
Task List in action
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/data-persistence/historyh
Chat History - ChainlituhX0  Data Persistence
Chat History
Chat history allow users to search and browse their past conversations.
How-to
To enable chat history, you need to enable:
Chat History
Resume a conversation
To let users continue persisted conversations, use cl.on_chat_resume.
Resuming a conversation
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h2https://docs.chainlit.io/concepts/concepts/messageh
Overview - ChainlituhXr  Overview
Chainlit is an open-source Python package to build production ready Conversational AI.
Build Conversational AI with Chainlit
Key features
-
Build fast: Integrate seamlessly with an existing code base or start from scratch in minutes
-
Multi Platform: Write your assistant logic once, use everywhere
-
Data persistence: Collect, monitor and analyze data from your users
-
Visualize multi-steps reasoning: Understand the intermediary steps that produced an output at a glance
Integrations
Chainlit is compatible with all Python programs and libraries. That being said, it comes with a set of integrations with popular libraries and frameworks.
OpenAI
Learn how to explore your OpenAI calls in Chainlit.
OpenAI Assistant
Learn how to integrate your OpenAI Assistants with Chainlit.
Mistral AI
Learn how to use any Mistral AI calls in Chainlit.
Llama Index
Learn how to integrate your Llama Index code with Chainlit.
LangChain
Learn how to use any LangChain agent with Chainlit.
Autogen
Learn how to integrate your Autogen agents with Chainlit.
Haystack
Learn how to integrate your Haystack code with Chainlit.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/api-reference/make-asynch
make_async - ChainlituhX  Misceallaneous
make_async
The make_async
function takes a synchronous function (for instance a LangChain agent) and returns an asynchronous function that will run the original function in a separate thread.
This is useful to run long running synchronous tasks without blocking the event loop.
Parameters
func
Callable
The synchronous function to run in a separate thread.
Returns
async_function
Coroutine
requiredThe asynchronous function that will run the synchronous function in a separate thread.
Usage
import time
import chainlit as cl
def sync_func():
time.sleep(5)
return "Hello!"
@cl.on_message
async def main(message: cl.Message):
answer = await cl.make_async(sync_func)()
await cl.Message(
content=answer,
).send()
LangChain agent
import chainlit as cl
res = await cl.make_async(agent)(input_str, callbacks=[cl.LangchainCallbackHandler()])
await cl.Message(content=res["text"]).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/elements/texth
Text - ChainlituhX]  Text
The Text
class allows you to display a text element in the chatbot UI. This class takes a string and creates a text element that can be sent to the UI.
It supports the markdown syntax for formatting text.
You must provide either an url or a path or content bytes.
Attributes
The name of the text element to be displayed in the UI.
The text string or bytes that should be displayed as the content of the text element.
The remote URL of the text source.
The local file path of the text file.
Determines how the text element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
Language of the code if the text is a piece of code. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
text_content = "Hello, this is a text element."
elements = [
cl.Text(name="simple_text", content=text_content, display="inline")
]
await cl.Message(
content="Check out this text element!",
elements=elements,
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hChttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-audio-endh
on_audio_end - ChainlituhX2  Life Cycle Hooks
on_audio_end
Hook to react to the end of an audio recording coming from the user’s microphone.
Usage
from io import BytesIO
import chainlit as cl
@cl.on_audio_end
async def on_audio_end(elements: list[ElementBased]):
# Get the audio buffer from the session
audio_buffer: BytesIO = cl.user_session.get("audio_buffer")
audio_buffer.seek(0) # Move the file pointer to the beginning
audio_file = audio_buffer.read()
audio_mime_type: str = cl.user_session.get("audio_mime_type")
# Apply Speech to Text or any other processing
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h&https://docs.chainlit.io/deploy/webapph
Web App - ChainlituhThe native Chainlit UI that is available on port 8000. Should open in your default browser when you run chainlit run.
chainlit run
Preview
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h,https://docs.chainlit.io/api-reference/cacheh
cache - ChainlituhX1  Misceallaneous
cache
The cache
decorator is a tool for caching results of resource-intensive calculations or loading processes. It can be conveniently combined with the file watcher to prevent resource reloading each time the application restarts. This not only saves time, but also enhances overall efficiency.
Parameters
func
Callable
The target function whose results need to be cached.
Returns
cached_value
Any
requiredThe computed value that is stored in the cache after its initial calculation.
Usage
import time
import chainlit as cl
@cl.cache
def to_cache():
time.sleep(5) # Simulate a time-consuming process
return "Hello!"
value = to_cache()
@cl.on_message
async def main(message: cl.Message):
await cl.Message(
content=value,
).send()
In this example, the to_cache
function simulates a time-consuming process that returns a value. By using the cl.cache
decorator, the result of the function is cached after its first execution. Future calls to the to_cache
function return the cached value without running the time-consuming process again.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/authentication/passwordh
Password - ChainlituhX=  Authentication
Password
The @cl.password_auth_callback
receives the username and password from the login form. Returning an cl.User
object will authenticate the user while returning None
will fail the authentication.
You can verify the credentials against any service that you’d like (your own DB, a private google sheet etc.).
The usual security best practices applies here, hash password before storing them.
Example
from typing import Optional
import chainlit as cl
@cl.password_auth_callback
def auth_callback(username: str, password: str):
# Fetch the user matching username from your database
# and compare the hashed password with the value stored in the database
if (username, password) == ("admin", "admin"):
return cl.User(
identifier="admin", metadata={"role": "admin", "provider": "credentials"}
)
else:
return Nonehhuh(h	hh}ubh)}(h}(hNh	}(h<https://docs.chainlit.io/api-reference/integrations/haystackh
Haystack - ChainlituhX  Haystack
The current Haystack integration allows you to run chainlit apps and visualise intermediary steps. Playground capabilities will be added with the release of Haystack 2.0.
Haystack is an end-to-end NLP framework that enables you to build NLP applications powered by LLMs, Transformer models, vector search and more. Whether you want to perform question answering, answer generation, semantic document search, or build tools that are capable of complex decision making and query resolution, you can use the state-of-the-art NLP models with Haystack to build end-to-end NLP applications solving your use case. Check out their repo: https://github.com/deepset-ai/haystack.
A Haystack agent run with reasoning steps
Installation
pip install farm-haystack chainlit
Integration
Create a new Python file named app.py with the code below.
This code adds the Chainlit callback handler to the Haystack callback manager. The callback handler is responsible for listening to the chain’s intermediate steps and sending them to the UI.
Then, you can run chainlit run app.py
in your terminal to run the app and interact with your agent.
Example
Check out this full example from the cookbook: https://github.com/Chainlit/cookbook/tree/main/haystack
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/authentication/headerh
Header - ChainlituhXA  Authentication
Header
Header auth is a simple way to authenticate users using a header. It is typically used to delegate authentication to a reverse proxy.
Example
from typing import Optional
import chainlit as cl
@cl.header_auth_callback
def header_auth_callback(headers: Dict) -> Optional[cl.User]:
# Verify the signature of a token in the header (ex: jwt token)
# or check that the value is matching a row from your database
if headers.get("test-header") == "test-value":
return cl.User(identifier="admin", metadata={"role": "admin", "provider": "header"})
else:
return Nonehhuh(h	hh}ubh)}(h}(hNh	}(h8https://docs.chainlit.io/advanced-features/chat-settingsh
Chat Settings - ChainlituhX  Advanced Features
Chat Settings
Chat settings are useful to let each user configure their chat experience given a set of options.
How it works
Check the chat settings API reference to learn how to configure it.
Preview
If chat settings are set, a new button will appear in the chat bar.
Clicking on this button will open the settings panel. All settings are editable by the user. Once settings are updated, an event is sent to the Chainlit server so the application can react to the update.
Chat Settings in Chainlit
Example
Check out this example from the cookbook that uses this feature: https://github.com/Chainlit/cookbook/tree/main/image-gen
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/elements/videoh
Video - ChainlituhX  Elements
Video
The Video
class allows you to display an video player for a specific video file in the chatbot user interface.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the video file to be displayed in the UI. This is shown to users.
display
ElementDisplay
Determines where the element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
url
str
The remote URL of the video.
path
str
The local file path of the video.
content
bytes
The file content of the video in bytes format.
Example
import chainlit as cl
@cl.on_chat_start
async def main():
elements = [
cl.Video(name="example.mp4", path="./example.mp4", display="inline"),
]
await cl.Message(
content="Here is an video file",
elements=elements,
).send()hhuh(h	hh}ubh)}(h}(hNh	}(h'https://docs.chainlit.io/authenticationh
Overview - ChainlituhXX  Authentication
Overview
Chainlit applications are public by default. To enable authentication and make your app private, you need to:
- Define a
CHAINLIT_AUTH_SECRET
environment variable. This is a secret string that is used to sign the authentication tokens. You can change it at any time, but it will log out all users. You can easily generate one usingchainlit create-secret
. - Add one or more authentication callbacks to your app:
Password Auth
Authenticate users with login/password.
OAuth
Authenticate users with your own OAuth app (like Google).
Header
Authenticate users based on a custom header.
Each callback take a different input and optionally return a cl.User
object. If the callback returns None
, the authentication is considered as failed.
Make sure each user has a unique identifier to prevent them from sharing their data.
Get the current authenticated user
You can access the current authenticated user through the User Session.
@cl.on_chat_start
async def on_chat_start():
app_user = cl.user_session.get("user")
await cl.Message(f"Hello {app_user.identifier}").send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/integrations/embedchainh
Embedchain - ChainlituhX  Integrations
Embedchain
In this tutorial, we’ll walk through the steps to create a Chainlit application integrated with Embedchain.
Step 1: Create a Chainlit Application
In app.py
, import the necessary packages and define one function to handle a new chat session and another function to handle messages incoming from the UI.
With Embedchain
app.py
import chainlit as cl
from embedchain import Pipeline as App
import os
os.environ["OPENAI_API_KEY"] = "sk-xxx"
@cl.on_chat_start
async def on_chat_start():
app = App.from_config(config={
'app': {
'config': {
'name': 'chainlit-app'
}
},
'llm': {
'config': {
'stream': True,
}
}
})
# import your data here
app.add("https://www.forbes.com/profile/elon-musk/")
app.collect_metrics = False
cl.user_session.set("app", app)
@cl.on_message
async def on_message(message: cl.Message):
app = cl.user_session.get("app")
msg = cl.Message(content="")
for chunk in await cl.make_async(app.chat)(message.content):
await msg.stream_token(chunk)
await msg.send()
Step 2: Run the Application
To start your app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
Next Steps
Congratulations! You’ve just created your first LLM app with Chainlit and Embedchain.
Happy coding! 🎉
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h3https://docs.chainlit.io/integrations/message-basedh
&vLLM, LMStudio, HuggingFace - ChainlituhX  vLLM, LMStudio, HuggingFace
We can leverage the OpenAI instrumentation to log calls from inference servers that use messages-based API, such as vLLM, LMStudio or HuggingFace’s TGI.
You shouldn’t configure this integration if you’re already using another integration like Haystack, LangChain or LlamaIndex. Both integrations would record the same generation and create duplicate steps in the UI.
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
In app.py
, import the necessary packages and define one function to handle messages incoming from the UI.
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI(base_url="http://localhost:1234/v1", api_key="lm-studio")
# Instrument the OpenAI client
cl.instrument_openai()
settings = {
"model": "gpt-3.5-turbo",
"temperature": 0,
# ... more settings
}
@cl.on_message
async def on_message(message: cl.Message):
response = await client.chat.completions.create(
messages=[
{
"content": "You are a helpful bot, you always reply in Spanish",
"role": "system"
},
{
"content": input,
"role": "user"
}
],
**settings
)
await cl.Message(content=response.choices[0].message.content).send()
Create a file named .env
in the same folder as your app.py
file. Add your OpenAI API key in the OPENAI_API_KEY
variable. You can optionally add your Literal AI API key in the LITERAL_API_KEY
.
To start your app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h'https://docs.chainlit.io/deploy/copiloth
Copilot - ChainlituhX  Copilot
Software Copilot are a new kind of assistant embedded in your app/product. They are designed to help users get the most out of your app by providing contextual guidance and take actions on their behalf.
Preview
Supported Features
Message | Streaming | Elements | Audio | Ask User | Chat History | Chat Profiles | Feedback |
---|---|---|---|---|---|---|---|
✅ | ✅ | ✅ | ✅ | ✅ | ❌ | ✅ | ✅ |
Embedding the Copilot
First, make sure your Chainlit server is running. Then, add the following script at the end of your website’s <body>
tag:
This example assumes your Chainlit server is running on
http://localhost:8000
<head>
<meta charset="utf-8" />
</head>
<body>
<!-- ... -->
<script src="http://localhost:8000/copilot/index.js"></script>
<script>
window.mountChainlitWidget({
chainlitServer: "http://localhost:8000",
});
</script>
</body>
Remember the HTML file has to be served by a server, opening it directly in your browser won’t work. You can use simple HTTP server for tests purpose.
That’s it! You should now see a floating button on the bottom right corner of your website. Clicking on it will open the Copilot.
Widget Configuration
The mountChainlitWidget
function accepts the following options:
export interface IWidgetConfig {
// URL of the Chainlit server
chainlitServer: string;
// Required if authentication is enabled on the server
accessToken?: string;
// Theme of the copilot
theme?: "light" | "dark";
// Font family to use. It is up to the website to load the font
fontFamily?: string;
// Custom styling to apply to the widget button
button?: {
// ID of the container element to mount the button to
containerId?: string;
// URL of the image to use as the button icon
imageUrl?: string;
style?: {
size?: string;
bgcolor?: string;
color?: string;
bgcolorHover?: string;
borderColor?: string;
borderWidth?: string;
borderStyle?: string;
borderRadius?: string;
boxShadow?: string;
};
};
}
Function Calling
The Copilot can call functions on your website. This is useful for taking actions on behalf of the user. For example, you can call a function to create a new document, or to open a modal.
First, create a CopilotFunction
in your Chainlit server:
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
if cl.context.session.client_type == "copilot":
fn = cl.CopilotFunction(name="test", args={"msg": msg.content})
res = await fn.acall()
await cl.Message(content=res).send()
Then, in your app/website, add the following event listener:
window.addEventListener("chainlit-call-fn", (e) => {
const { name, args, callback } = e.detail;
if (name === "test") {
console.log(name, args);
callback("You sent: " + args.msg);
}
});
As you can see, the event listener receives the function name, arguments, and a callback function. The callback function should be called with the result of the function call.
Send a Message
The Copilot can also send messages directly to the Chainlit server. This is useful for sending context information or user actions to the Chainlit server (like the user selected from cell A1 to B1 on a table).
First, update the @cl.on_message
decorated function to your Chainlit server:
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
if cl.context.session.client_type == "copilot":
if msg.type == "system_message":
# do something with the message
return
fn = cl.CopilotFunction(name="test", args={"msg": msg.content})
res = await fn.acall()
await cl.Message(content=res).send()
Then, in your app/website, you can emit an event like this:
window.sendChainlitMessage({
type: "system_message",
output: "Hello World!",
});
Security
Cross Origin Resource Sharing (CORS)
By default, the Chainlit server accepts requests from any origin. This is useful for development, but not recommended for production.
To restrict the origins that can access the server (hence embed the copilot), set the allow_origins config field to a list of allowed origins.
Authentication
If you want to restrict access to the Copilot per user, you can enable authentication on the Chainlit server.
While the standalone Chainlit application handles the authentication process, the Copilot needs to be configured with an access token. This token is used to authenticate the user with the Chainlit server.
The host app/website is responsible for generating the token and passing it to the Copilot. Here are examples of how to generate the token in different languages:
You will need the CHAINLIT_AUTH_SECRET
you generated when configuring
authentication.hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/concepts/user-sessionh
User Session - ChainlituhX
  User Session
The user session is designed to persist data in memory through the life cycle of a chat session. Each user session is unique to a user and a given chat session.
Why use the user session?
Let’s say you want to keep track of each chat session message count.
A naive implementation might look like this:
This example is for illustrative purposes only. It is not recommended to use this code in production.
import chainlit as cl
counter = 0
@cl.on_message
async def on_message(message: cl.Message):
global counter
counter += 1
await cl.Message(content=f"You sent {counter} message(s)!").send()
At first glance, this code seems to work. However, it has a major flaw. If two users are chatting with the bot at the same time, both users will increment the same counter
.
This is where the user session comes in. Let’s rewrite the above example using the user session:
import chainlit as cl
@cl.on_chat_start
def on_chat_start():
cl.user_session.set("counter", 0)
@cl.on_message
async def on_message(message: cl.Message):
counter = cl.user_session.get("counter")
counter += 1
cl.user_session.set("counter", counter)
await cl.Message(content=f"You sent {counter} message(s)!").send()
User Session Default Values
By default, Chainlit stores chat session related data in the user session.
The following keys are reserved for chat session related data:
The session id.
Only set if you are enabled Authentication. Contains the user object of the user that started this chat session.
Only relevant if you are using the Chat Profiles feature. Contains the chat profile selected by this user.
Only relevant if you are using the Chat Settings feature. Contains the chat settings given by this user.
Only relevant if you are using the user_env config. Contains the environment variables given by this user.hhuh(h	hh}ubh)}(h}(hNh	}(h$https://docs.chainlit.io/examples/qah
Document QA - ChainlituhX  Examples
Document QA
In this example, we’re going to build an chatbot QA app. We’ll learn how to:
- Upload a document
- Create vector embeddings from a file
- Create a chatbot app with the ability to display sources used to generate an answer
This example is inspired from the LangChain doc
Prerequisites
This example has extra dependencies. You can install them with:
pip install langchain chromadb tiktoken
Then, you need to go to create an OpenAI key here.
The state of the union file is available here
Conversational Document QA with LangChain
qa.py
import os
from typing import List
from langchain.embeddings.openai import OpenAIEmbeddings
from langchain.text_splitter import RecursiveCharacterTextSplitter
from langchain.vectorstores import Chroma
from langchain.chains import (
ConversationalRetrievalChain,
)
from langchain.chat_models import ChatOpenAI
from langchain.docstore.document import Document
from langchain.memory import ChatMessageHistory, ConversationBufferMemory
import chainlit as cl
os.environ["OPENAI_API_KEY"] = "OPENAI_API_KEY"
text_splitter = RecursiveCharacterTextSplitter(chunk_size=1000, chunk_overlap=100)
@cl.on_chat_start
async def on_chat_start():
files = None
# Wait for the user to upload a file
while files == None:
files = await cl.AskFileMessage(
content="Please upload a text file to begin!",
accept=["text/plain"],
max_size_mb=20,
timeout=180,
).send()
file = files[0]
msg = cl.Message(content=f"Processing `{file.name}`...")
await msg.send()
with open(file.path, "r", encoding="utf-8") as f:
text = f.read()
# Split the text into chunks
texts = text_splitter.split_text(text)
# Create a metadata for each chunk
metadatas = [{"source": f"{i}-pl"} for i in range(len(texts))]
# Create a Chroma vector store
embeddings = OpenAIEmbeddings()
docsearch = await cl.make_async(Chroma.from_texts)(
texts, embeddings, metadatas=metadatas
)
message_history = ChatMessageHistory()
memory = ConversationBufferMemory(
memory_key="chat_history",
output_key="answer",
chat_memory=message_history,
return_messages=True,
)
# Create a chain that uses the Chroma vector store
chain = ConversationalRetrievalChain.from_llm(
ChatOpenAI(model_name="gpt-3.5-turbo", temperature=0, streaming=True),
chain_type="stuff",
retriever=docsearch.as_retriever(),
memory=memory,
return_source_documents=True,
)
# Let the user know that the system is ready
msg.content = f"Processing `{file.name}` done. You can now ask questions!"
await msg.update()
cl.user_session.set("chain", chain)
@cl.on_message
async def main(message: cl.Message):
chain = cl.user_session.get("chain") # type: ConversationalRetrievalChain
cb = cl.AsyncLangchainCallbackHandler()
res = await chain.acall(message.content, callbacks=[cb])
answer = res["answer"]
source_documents = res["source_documents"] # type: List[Document]
text_elements = [] # type: List[cl.Text]
if source_documents:
for source_idx, source_doc in enumerate(source_documents):
source_name = f"source_{source_idx}"
# Create the text element referenced in the message
text_elements.append(
cl.Text(content=source_doc.page_content, name=source_name, display="side")
)
source_names = [text_el.name for text_el in text_elements]
if source_names:
answer += f"\nSources: {', '.join(source_names)}"
else:
answer += "\nNo sources found"
await cl.Message(content=answer, elements=text_elements).send()
Try it out
chainlit run qa.py
You can then upload any .txt
file to the UI and ask questions about it.
If you are using state_of_the_union.txt
you can ask questions like What did the president say about Ketanji Brown Jackson?
.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h/https://docs.chainlit.io/integrations/langchainh
LangChain - ChainlituhX	  LangChain
In this tutorial, we’ll walk through the steps to create a Chainlit application integrated with LangChain.
Preview of what you will build
Prerequisites
Before getting started, make sure you have the following:
- A working installation of Chainlit
- The LangChain package installed
- An OpenAI API key
- Basic understanding of Python programming
Step 1: Create a Python file
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 2: Write the Application Logic
In app.py
, import the necessary packages and define one function to handle a new chat session and another function to handle messages incoming from the UI.
With Langchain Expression language (LCEL)
Let’s go through a small example.
If your agent/chain does not have an async implementation, fallback to the sync implementation.
This code sets up an instance of Runnable
with a custom ChatPromptTemplate
for each chat session. The Runnable
is invoked everytime a user sends a message to generate the response.
The callback handler is responsible for listening to the chain’s intermediate steps and sending them to the UI.
[Deprecated] With Legacy Chain Interface
This code sets up an instance of LLMChain
with a custom ChatPromptTemplate
for each chat session. The LLMChain
is invoked everytime a user sends a message to generate the response.
The callback handler is responsible for listening to the chain’s intermediate steps and sending them to the UI.
Step 3: Run the Application
To start your app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.
When using LangChain, prompts and completions are not cached by default. To
enable the cache, set the cache=true
in your chainlit config file.
Was this page helpful?*      hhuh(h	hh}ubh)}(h}(hNh	}(h2https://docs.chainlit.io/data-persistence/overviewh
Overview - ChainlituhXH  Overview
By default, your Chainlit app does not persist the chats and elements it generates. However, the ability to store and utilize this data can be a crucial part of your project or organization.
Once enabled, data persistence will introduce new features to your application.
Features
Enable Data Persistence in 1 minute
- Navigate to Literal AI and sign in.
- You will be prompted to create a new project:
Project Creation Screen
- Navigate to the
Settings
page. A default API key will be generated for youProject API Key
Activation
Once you have an API key, you will need to pass it via a LITERAL_API_KEY
environment variable.
Next to your Chainlit application, create a .env
file and modify it like so:
LITERAL_API_KEY="your key"
Or inlined:
LITERAL_API_KEY="your key" chainlit run main.py
Or inlined for Windows powershell:
$ENV:LITERAL_API_KEY="your key"; chainlit run main.py
Once activated, your chats and elements will be persisted on Literal AI.
Deactivation
If you wish to deactivate data persistence, simply comment out or remove the LITERAL_API_KEY
environment variable.
Data privacy & security
We prioritize your data’s privacy and security. We understand how crucial the data fed into Chainlit Cloud is for your business and handle it with utmost care.
Contact us for detailed information: contact@chainlit.io
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/data-persistence/customh
Custom Data Layer - ChainlituhX  Custom Data Layer
Literal AI provides the simplest way to persist, analyze and monitor your data.
If you’re considering implementing a custom data layer, check out this example here for some inspiration.
Also, we would absolutely love to see a community-led open source data layer implementation and list it here. If you’re interested in contributing, please reach out to us on Discord.
You need to import you custom data layer in your chainlit app, and assign it to the data layer variable, like so:
import chainlit.data as cl_data
class CustomDataLayer(cl_data.BaseDataLayer):
# TODO: implement all methods from cl_data.BaseDataLayer
cl_data._data_layer = CustomDataLayer()
SQL alchemy data layer
This custom layer has been tested for PostgreSQL, however it should support more SQL databases thanks to the use of the SQL Alchemy database.
This data layer also supports the BaseStorageClient
that enables you to store your elements into Azure Blob Storage or AWS S3.
Here is the SQL used to create the schema for this data layer:
CREATE TABLE users (
"id" UUID PRIMARY KEY,
"identifier" TEXT NOT NULL UNIQUE,
"metadata" JSONB NOT NULL,
"createdAt" TEXT
);
CREATE TABLE IF NOT EXISTS threads (
"id" UUID PRIMARY KEY,
"createdAt" TEXT,
"name" TEXT,
"userId" UUID,
"userIdentifier" TEXT,
"tags" TEXT[],
"metadata" JSONB,
FOREIGN KEY ("userId") REFERENCES users("id") ON DELETE CASCADE
);
CREATE TABLE IF NOT EXISTS steps (
"id" UUID PRIMARY KEY,
"name" TEXT NOT NULL,
"type" TEXT NOT NULL,
"threadId" UUID NOT NULL,
"parentId" UUID,
"disableFeedback" BOOLEAN NOT NULL,
"streaming" BOOLEAN NOT NULL,
"waitForAnswer" BOOLEAN,
"isError" BOOLEAN,
"metadata" JSONB,
"tags" TEXT[],
"input" TEXT,
"output" TEXT,
"createdAt" TEXT,
"start" TEXT,
"end" TEXT,
"generation" JSONB,
"showInput" TEXT,
"language" TEXT,
"indent" INT
);
CREATE TABLE IF NOT EXISTS elements (
"id" UUID PRIMARY KEY,
"threadId" UUID,
"type" TEXT,
"url" TEXT,
"chainlitKey" TEXT,
"name" TEXT NOT NULL,
"display" TEXT,
"objectKey" TEXT,
"size" TEXT,
"page" INT,
"language" TEXT,
"forId" UUID,
"mime" TEXT
);
CREATE TABLE IF NOT EXISTS feedbacks (
"id" UUID PRIMARY KEY,
"forId" UUID NOT NULL,
"threadId" UUID NOT NULL,
"value" INT NOT NULL,
"comment" TEXT
);
Example
Here is an example of setting up this data layer on a PostgreSQL database with an Azure storage client. First install the required dependencies:
pip install asyncpg SQLAlchemy azure-identity azure-storage-file-datalake
Import the custom data layer and storage client, and set the cl_data._data_layer
variable at the beginning of your Chainlit app.
import chainlit.data as cl_data
from chainlit.data.sql_alchemy import SQLAlchemyDataLayer
from chainlit.data.storage_clients import AzureStorageClient
storage_client = AzureStorageClient(account_url="<your_account_url>", container="<your_container>")
cl_data._data_layer = SQLAlchemyDataLayer(conninfo="<your conninfo>", storage_provider=storage_client)
Note that you need to add +asyncpg
to the protocol in the conninfo
string so that it uses the asyncpg library.
DynamoDB data layer
This data layer also supports the BaseStorageClient
that enables you to store your elements into AWS S3 or Azure Blob Storage.
Example
Here is an example of setting up this data layer. First install boto3:
pip install boto3
Import the custom data layer and storage client, and set the cl_data._data_layer
variable at the beginning of your Chainlit app.
import chainlit.data as cl_data
from chainlit.data.dynamodb import DynamoDBDataLayer
from chainlit.data.storage_clients import S3StorageClient
storage_client = S3StorageClient(bucket="<Your Bucket>")
cl_data._data_layer = DynamoDBDataLayer(table_name="<Your Table>", storage_provider=storage_client)
Table structure
Here is the Cloudformation used to create the dynamo table:
{
"AWSTemplateFormatVersion": "2010-09-09",
"Resources": {
"DynamoDBTable": {
"Type": "AWS::DynamoDB::Table",
"Properties": {
"TableName": "<YOUR-TABLE-NAME>",
"AttributeDefinitions": [
{
"AttributeName": "PK",
"AttributeType": "S"
},
{
"AttributeName": "SK",
"AttributeType": "S"
},
{
"AttributeName": "UserThreadPK",
"AttributeType": "S"
},
{
"AttributeName": "UserThreadSK",
"AttributeType": "S"
}
],
"KeySchema": [
{
"AttributeName": "PK",
"KeyType": "HASH"
},
{
"AttributeName": "SK",
"KeyType": "RANGE"
}
],
"GlobalSecondaryIndexes": [
{
"IndexName": "UserThread",
"KeySchema": [
{
"AttributeName": "UserThreadPK",
"KeyType": "HASH"
},
{
"AttributeName": "UserThreadSK",
"KeyType": "RANGE"
}
],
"Projection": {
"ProjectionType": "INCLUDE",
"NonKeyAttributes": ["id", "name"]
}
}
],
"BillingMode": "PAY_PER_REQUEST"
}
}
}
}
Logging
DynamoDB data layer defines a child of chainlit logger.
import logging
from chainlit import logger
logger.getChild("DynamoDB").setLevel(logging.DEBUG)
Limitations
Filtering by positive/negative feedback is not supported.
The data layer methods are not async. Boto3 is not async and therefore the data layer uses non-async blocking io.
Design
This implementation uses Single Table Design. There are 4 different entity types in one table identified by the prefixes in PK & SK.
Here are the entity types:
type User = {
PK: "USER#{user.identifier}"
SK: "USER"
// ...PersistedUser
}
type Thread = {
PK: f"THREAD#{thread_id}"
SK: "THREAD"
// GSI: UserThread for querying in list_threads
UserThreadPK: f"USER#{user_id}"
UserThreadSK: f"TS#{ts}"
// ...ThreadDict
}
type Step = {
PK: f"THREAD#{threadId}"
SK: f"STEP#{stepId}"
// ...StepDict
// feedback is stored as part of step.
// NOTE: feedback.value is stored as Decimal in dynamo which is not json serializable
feedback?: Feedback
}
type Element = {
"PK": f"THREAD#{threadId}"
"SK": f"ELEMENT#{element.id}"
// ...ElementDict
}
How to implement a custom data layer?
Follow the reference for an exhaustive list of the methods your custom data layer needs to implement.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h(https://docs.chainlit.io/concepts/actionh
Action - ChainlituhX  Basic Concepts
Action
Actions are a way to send clickable buttons to the user interface. Each action is attached to a Message and can be used to trigger a python function when the user clicks on it.
Create an action
Actions are sent to the UI through messages:
import chainlit as cl
@cl.on_chat_start
async def start():
# Sending an action button within a chatbot message
actions = [
cl.Action(name="action_button", value="example_value", description="Click me!")
]
await cl.Message(content="Interact with this action button:", actions=actions).send()
Define a Python Callback
To handle the user’s click on the action button, you need to define a callback function with the @cl.action_callback
decorator:
@cl.action_callback("action_button")
async def on_action(action: cl.Action):
print("The user clicked on the action button!")
return "Thank you for clicking on the action button!"
Action API
Learn how more about Actions.
Toaster
While an action is being processed, a toaster is displayed to the user. The toaster is a small notification that appears at the top right of the screen and indicates that the action is being processed.
If the action callback returns a string, the toaster will display it to the user once the action is processed.
Output of the code abovehhuh(h	hh}ubh)}(h}(hNh	}(h/https://docs.chainlit.io/api-reference/elementsh
Text - ChainlituhX]  Text
The Text
class allows you to display a text element in the chatbot UI. This class takes a string and creates a text element that can be sent to the UI.
It supports the markdown syntax for formatting text.
You must provide either an url or a path or content bytes.
Attributes
The name of the text element to be displayed in the UI.
The text string or bytes that should be displayed as the content of the text element.
The remote URL of the text source.
The local file path of the text file.
Determines how the text element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
Language of the code if the text is a piece of code. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
text_content = "Hello, this is a text element."
elements = [
cl.Text(name="simple_text", content=text_content, display="inline")
]
await cl.Message(
content="Check out this text element!",
elements=elements,
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h*https://docs.chainlit.io/guides/sync-asynch
Async / Sync - ChainlituhXC  Async / Sync
Asynchronous programming is a powerful way to handle multiple tasks concurrently without blocking the execution of your program. Chainlit is async by default to allow agents to execute tasks in parallel and allow multiple users on a single app.
Python introduced the asyncio
library to make it easier to write asynchronous code using the async/await
syntax. This onboarding guide will help you understand the basics of asynchronous programming in Python and how to use it in your Chainlit project.
Understanding async/await
The async
and await
keywords are used to define and work with asynchronous code in Python. An async
function is a coroutine, which is a special type of function that can pause its execution and resume later, allowing other tasks to run in the meantime.
To define an async function, use the async def
syntax:
async def my_async_function():
# Your async code goes here
To call an async function, you need to use the await
keyword:
async def another_async_function():
result = await my_async_function()
Working with Chainlit
Chainlit uses asynchronous programming to handle events and tasks efficiently. When creating a Chainlit agent, you’ll often need to define async functions to handle events and perform actions.
For example, to create an async function that responds to messages in Chainlit:
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
# Your custom logic goes here
# Send a response back to the user
await cl.Message(
content=f"Received: {message.content}",
).send()
Long running synchronous tasks
In some cases, you need to run long running synchronous functions in your Chainlit project. To prevent blocking the event loop, you can utilize the make_async
function provided by the Chainlit library to transform a synchronous function into an asynchronous one:
from chainlit import make_async
def my_sync_function():
# Your synchronous code goes here
import time
time.sleep(10)
return 0
async_function = make_async(my_sync_function)
async def main():
result = await async_function()
By using this approach, you can maintain the non-blocking nature of your project while still incorporating synchronous functions when necessary.
Call an async function from a sync function
If you need to run an asynchronous function inside a sync function, you can use the run_sync
function provided by the Chainlit library:
from chainlit import run_sync
async def my_async_function():
# Your asynchronous code goes here
def main():
result = run_sync(my_async_function())
main()
By following this guide, you should now have a basic understanding of asynchronous programming in Python and how to use it in your Chainlit project. As you continue to work with Chainlit, you’ll find that async/await and the asyncio library provide a powerful and efficient way to handle multiple agents/tasks concurrently.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/author-renameh
+author_rename and Message author - ChainlituhXR  Misceallaneous
author_rename and Message author
This documentation covers two methods for setting or renaming the author of a message to display more friendly author names in the UI: the author_rename
decorator and the Message author specification at message creation.
Method 1: author_rename
Useful for renaming the author of a message dynamically during the message handling process.
Parameters
orig_author
str
requiredThe original author name.
Returns
author
str
requiredThe renamed author
Usage
from langchain import OpenAI, LLMMathChain
import chainlit as cl
@cl.author_rename
def rename(orig_author: str):
rename_dict = {"LLMMathChain": "Albert Einstein", "Chatbot": "Assistant"}
return rename_dict.get(orig_author, orig_author)
@cl.on_message
async def main(message: cl.Message):
llm = OpenAI(temperature=0)
llm_math = LLMMathChain.from_llm(llm=llm)
res = await llm_math.acall(message.content, callbacks=[cl.AsyncLangchainCallbackHandler()])
await cl.Message(content="Hello").send()
Method 2: Message author
Allows for naming the author of a message at the moment of the message creation.
Usage
You can specify the author directly when creating a new message object:
from langchain import OpenAI, LLMMathChain
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
llm = OpenAI(temperature=0)
llm_math = LLMMathChain.from_llm(llm=llm)
res = await llm_math.acall(message.content, callbacks=[cl.AsyncLangchainCallbackHandler()])
# Specify the author at message creation
response_message = cl.Message(content="Hello", author="NewChatBotName")
await response_message.send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h/https://docs.chainlit.io/backend/config/projecth
Project - ChainlituhX  Project
Options
enable_telemetry
bool
default: trueWhether to enable telemetry (default: true). No personal data is collected.
allow_origins
List[str]
default: ["*"]Authorized origins to access the app/copilot.
user_env
List[str]
default: []List of environment variables to be provided by each user to use the app.
session_timeout
int
default: 3600Duration (in seconds) during which the session is saved when the connection is lost
cache
bool
default: falseEnable third parties caching (e.g LangChain cache)
follow_symlink
bool
default: falseFollow symlink for asset mount (see https://github.com/Chainlit/chainlit/issues/317)
Default configuration
[project]
# Whether to enable telemetry (default: true). No personal data is collected.
enable_telemetry = true
# List of environment variables to be provided by each user to use the app.
user_env = []
# Duration (in seconds) during which the session is saved when the connection is lost
session_timeout = 3600
# Enable third parties caching (e.g LangChain cache)
cache = false
# Follow symlink for asset mount (see https://github.com/Chainlit/chainlit/issues/317)
# follow_symlink = false
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h,https://docs.chainlit.io/integrations/openaih
OpenAI - ChainlituhX=	  OpenAI
If you are using OpenAI assistants, check out the OpenAI Assistant example app.
The benefits of this integration is that you can see the OpenAI API calls in a step in the UI, and you can explore them in the prompt playground.
You will also get the full generation details (prompt, completion, tokens per second…) in your Literal AI dashboard, if your project is using Literal AI.
You need to add cl.instrument_openai()
after creating your OpenAI client.
You shouldn’t configure this integration if you’re already using another integration like Haystack, Langchain or LlamaIndex. Both integrations would record the same generation and create duplicate steps in the UI.
Prerequisites
Before getting started, make sure you have the following:
- A working installation of Chainlit
- The OpenAI package installed
- An OpenAI API key
- Basic understanding of Python programming
Step 1: Create a Python file
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 2: Write the Application Logic
In app.py
, import the necessary packages and define one function to handle messages incoming from the UI.
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI()
# Instrument the OpenAI client
cl.instrument_openai()
settings = {
"model": "gpt-3.5-turbo",
"temperature": 0,
# ... more settings
}
@cl.on_message
async def on_message(message: cl.Message):
response = await client.chat.completions.create(
messages=[
{
"content": "You are a helpful bot, you always reply in Spanish",
"role": "system"
},
{
"content": message.content,
"role": "user"
}
],
**settings
)
await cl.Message(content=response.choices[0].message.content).send()
Step 3: Fill the environment variables
Create a file named .env
in the same folder as your app.py
file. Add your OpenAI API key in the OPENAI_API_KEY
variable. You can optionally add your Literal AI API key in the LITERAL_API_KEY
.
Step 4: Run the Application
To start your app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/get-started/pure-pythonh
In Pure Python - ChainlituhX  In Pure Python
In this tutorial, we’ll walk through the steps to create a minimal LLM app.
Prerequisites
Before getting started, make sure you have the following:
- A working installation of Chainlit
- Basic understanding of Python programming
Step 1: Create a Python file
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 2: Write the Application Logic
In app.py
, import the Chainlit package and define a function that will handle incoming messages from the chatbot UI. Decorate the function with the @cl.on_message
decorator to ensure it gets called whenever a user inputs a message.
Here’s the basic structure of the script:
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
# Your custom logic goes here...
# Send a response back to the user
await cl.Message(
content=f"Received: {message.content}",
).send()
The main
function will be called every time a user inputs a message in the chatbot UI. You can put your custom logic within the function to process the user’s input, such as analyzing the text, calling an API, or computing a result.
The Message class is responsible for sending a reply back to the user. In this example, we simply send a message containing the user’s input.
Step 3: Run the Application
To start your Chainlit app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.
Next Steps
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hIhttps://docs.chainlit.io/api-reference/data-persistence/custom-data-layerh
Custom Data Layer - ChainlituhX  Custom Data Layer
The BaseDataLayer
class serves as an abstract foundation for data persistence operations within the Chainlit framework. This class outlines methods for managing users, feedback, elements, steps, and threads in a chatbot application.
Methods
Fetches a user by their identifier. Return type is optionally a PersistedUser
.
Creates a new user based on the User
instance provided. Return type is optionally a PersistedUser
.
Inserts or updates feedback. Accepts a Feedback
instance and returns a string as an identifier of the persisted feedback.
Deletes a feedback by feedback_id
. Return True
if it was successful.
Adds a new element to the data layer. Accepts ElementDict
as an argument.
Retrieves an element by thread_id
and element_id
. Return type is optionally an ElementDict
.
Deletes an element given its identifier element_id
.
Creates a new step in the data layer. Accepts StepDict
as an argument.
Updates an existing step. Accepts StepDict
as an argument.
Deletes a step given its identifier step_id
.
Fetches the author of a given thread by thread_id
. Returns a string representing the author identifier.
Deletes a thread given its identifier thread_id
.
Lists threads based on pagination
and filters
arguments. Returns a PaginatedResponse[ThreadDict]
.
Retrieves a thread by its identifier thread_id
. Return type is optionally a ThreadDict
.
Updates a thread’s details like name, user_id, metadata, and tags. Arguments are mostly optional.
Deletes a user session given its identifier id
. Returns a boolean value indicating success.
Decorators
Queues certain methods to execute only after the first user message is received, especially useful for WebsocketSessions
.
Example
Due to the abstract nature of BaseDataLayer
, direct instantiation and usage are not practical without subclassing and implementing the abstract methods.
You can refer to the guide for custom data layer implementation.hhuh(h	hh}ubh)}(h}(hNh	}(h;https://docs.chainlit.io/api-reference/input-widgets/selecth
Select - ChainlituhX  Input Widgets
Select
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
values
List[str]
Labels for the select options.
items
Dict[str, str]
Labels with corresponding values for the select options.
initial_value
int
The initial value of the input widget.
initial_index
int
Index of the initial value of the input widget. Can only be used in combination with ‘values’.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Select
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Select(
id="Model",
label="OpenAI - Model",
values=["gpt-3.5-turbo", "gpt-3.5-turbo-16k", "gpt-4", "gpt-4-32k"],
initial_index=0,
)
]
).send()
value = settings["Model"]
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/integrations/fastapih
FastAPI - ChainlituhX  Integrations
FastAPI
Chainlit can be mounted as a FastAPI sub application.
my_cl_app
import chainlit as cl
@cl.on_chat_start
async def main():
await cl.Message(content="Hello World").send()
main
from fastapi import FastAPI
from chainlit.utils import mount_chainlit
app = FastAPI()
@app.get("/app")
def read_main():
return {"message": "Hello World from main app"}
mount_chainlit(app=app, target="my_cl_app.py", path="/chainlit")
In the example above, we have a FastAPI application with a single endpoint /app
. We mount the Chainlit application my_cl_app.py
to the /chainlit
path.
Start the FastAPI server:
uvicorn main:app --host 0.0.0.0 --port 80
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hEhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-chat-resumeh
on_chat_resume - ChainlituhXv  Life Cycle Hooks
on_chat_resume
Decorator to enable users to continue a conversation. Requires both data persistence and authentication to be enabled.
This decorator will automatically:
- Send the persisted messages and elements to the UI.
- Restore the user session.
Only JSON serializable fields of the user session will be saved and restored. If you are using a Langchain agent for instance, you will need to reinstantiate and set it in the user session yourself.
Usage
Resume Chat Example
Practical example of how to resume a chat with context.
Parameters
thread
ThreadDict
The persisted chat to resume.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/integrations/llama-indexh
Llama Index - ChainlituhX
  Llama Index
In this tutorial, we will guide you through the steps to create a Chainlit application integrated with Llama Index.
Preview of the app you'll build
Prerequisites
Before diving in, ensure that the following prerequisites are met:
- A working installation of Chainlit
- The Llama Index package installed
- An OpenAI API key
- A basic understanding of Python programming
Step 1: Set Up Your Data Directory
Create a folder named data
in the root of your app folder. Download the state of the union file (or any files of your own choice) and place it in the data
folder.
Step 2: Create the Python Script
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 3: Write the Application Logic
In app.py
, import the necessary packages and define one function to handle a new chat session and another function to handle messages incoming from the UI.
In this tutorial, we are going to use RetrieverQueryEngine
. Here’s the basic structure of the script:
import os
import openai
import chainlit as cl
from llama_index.core import (
Settings,
StorageContext,
VectorStoreIndex,
SimpleDirectoryReader,
load_index_from_storage,
)
from llama_index.llms.openai import OpenAI
from llama_index.embeddings.openai import OpenAIEmbedding
from llama_index.core.query_engine.retriever_query_engine import RetrieverQueryEngine
from llama_index.core.callbacks import CallbackManager
from llama_index.core.service_context import ServiceContext
openai.api_key = os.environ.get("OPENAI_API_KEY")
try:
# rebuild storage context
storage_context = StorageContext.from_defaults(persist_dir="./storage")
# load index
index = load_index_from_storage(storage_context)
except:
documents = SimpleDirectoryReader("./data").load_data(show_progress=True)
index = VectorStoreIndex.from_documents(documents)
index.storage_context.persist()
@cl.on_chat_start
async def start():
Settings.llm = OpenAI(
model="gpt-3.5-turbo", temperature=0.1, max_tokens=1024, streaming=True
)
Settings.embed_model = OpenAIEmbedding(model="text-embedding-3-small")
Settings.context_window = 4096
service_context = ServiceContext.from_defaults(callback_manager=CallbackManager([cl.LlamaIndexCallbackHandler()]))
query_engine = index.as_query_engine(streaming=True, similarity_top_k=2, service_context=service_context)
cl.user_session.set("query_engine", query_engine)
await cl.Message(
author="Assistant", content="Hello! Im an AI assistant. How may I help you?"
).send()
@cl.on_message
async def main(message: cl.Message):
query_engine = cl.user_session.get("query_engine") # type: RetrieverQueryEngine
msg = cl.Message(content="", author="Assistant")
res = await cl.make_async(query_engine.query)(message.content)
for token in res.response_gen:
await msg.stream_token(token)
await msg.send()
This code sets up an instance of RetrieverQueryEngine
for each chat session. The RetrieverQueryEngine
is invoked everytime a user sends a message to generate the response.
The callback handlers are responsible for listening to the intermediate steps and sending them to the UI.
Step 4: Launch the Application
To kick off your LLM app, open a terminal, navigate to the directory containing app.py
, and run the following command:
chainlit run app.py -w
The -w
flag enables auto-reloading so that you don’t have to restart the server each time you modify your application. Your chatbot UI should now be accessible at http://localhost:8000.hhuh(h	hh}ubh)}(h}(hNh	}(h7https://docs.chainlit.io/data-persistence/tags-metadatah
Tags & Metadata - ChainlituhXW  Data Persistence
Tags & Metadata
Tags and metadata provide valuable context for your threads, steps and generations.
More information here.
@cl.step(type="run")
async def func(input):
# some code
cl.context.current_step.metadata = {"experiment":"1"}
cl.context.current_step.tags = ["to review"]
# some code
return output
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h/https://docs.chainlit.io/integrations/mistralaih
Mistral AI - ChainlituhXN	  Mistral AI
The benefits of this integration is that you can see the Mistral AI API calls in a step in the UI, and you can explore them in the prompt playground.
You will also get the full generation details (prompt, completion, tokens per second…) in your Literal AI dashboard, if your project is using Literal AI.
To benefit from tracing, you need to add cl.instrument_mistralai()
after creating your Mistral AI client.
You shouldn’t configure this integration if you’re already using another integration like Haystack, Langchain or LlamaIndex. Both integrations would record the same generation and create duplicate steps in the UI.
Prerequisites
Before getting started, make sure you have the following:
- A working installation of Chainlit
- The Mistral AI python client package installed,
mistralai
- A Mistral AI API key
- Basic understanding of Python programming
Step 1: Create a Python file
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 2: Write the Application Logic
In app.py
, import the necessary packages and define one function to handle messages incoming from the UI.
import os
import chainlit as cl
from mistralai.async_client import MistralAsyncClient
mai_client = MistralAsyncClient()
# Instrument the Mistral AI client
cl.instrument_mistralai()
settings = {
"model": "mistral-large-latest",
"temperature": 0,
# ... more settings
}
@cl.on_message
async def on_message(message: cl.Message):
response = await mai_client.chat(
messages=[
{
"content": "You are a helpful bot, you always reply in Spanish",
"role": "system"
},
{
"content": message.content,
"role": "user"
}
],
**settings
)
await cl.Message(content=response.choices[0].message.content).send()
Step 3: Fill the environment variables
Create a file named .env
in the same folder as your app.py
file. Add your Mistral AI API key in the MISTRAL_API_KEY
variable.
You can optionally add your Literal AI API key in the LITERAL_API_KEY
.
Step 4: Run the Application
To start your app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/authentication/overviewh
Overview - ChainlituhXX  Authentication
Overview
Chainlit applications are public by default. To enable authentication and make your app private, you need to:
- Define a
CHAINLIT_AUTH_SECRET
environment variable. This is a secret string that is used to sign the authentication tokens. You can change it at any time, but it will log out all users. You can easily generate one usingchainlit create-secret
. - Add one or more authentication callbacks to your app:
Password Auth
Authenticate users with login/password.
OAuth
Authenticate users with your own OAuth app (like Google).
Header
Authenticate users based on a custom header.
Each callback take a different input and optionally return a cl.User
object. If the callback returns None
, the authentication is considered as failed.
Make sure each user has a unique identifier to prevent them from sharing their data.
Get the current authenticated user
You can access the current authenticated user through the User Session.
@cl.on_chat_start
async def on_chat_start():
app_user = cl.user_session.get("user")
await cl.Message(f"Hello {app_user.identifier}").send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h2https://docs.chainlit.io/customisation/custom-fonth
Font - ChainlituhX  Customisation
Font
To use a custom font, modify your configuration settings in .chainlit/config.toml.
config.toml
[UI]
# This should be a google font url
custom_font = "https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap"
Then, update your theme’s font family to use the custom font.
config.toml
[UI.theme]
font_family = "Inter, sans-serif"
Once the configuration is updated, restart the application. Your custom font will now be used.hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/concepts/chat-lifecycleh
Chat Life Cycle - ChainlituhX  Chat Life Cycle
Whenever a user connects to your Chainlit app, a new chat session is created. A chat session goes through a life cycle of events, which you can respond to by defining hooks.
On Chat Start
The on_chat_start decorator is used to define a hook that is called when a new chat session is created.
@cl.on_chat_start
def on_chat_start():
print("A new chat session has started!")
On Message
The on_message decorator is used to define a hook that is called when a new message is received from the user.
@cl.on_message
def on_message(msg: cl.Message):
print("The user sent: ", msg.content)
On Stop
The on_stop
decorator is used to define a hook that is called when the user clicks the stop button while a task was running.
@cl.on_stop
def on_stop():
print("The user wants to stop the task!")
On Chat End
The on_chat_end decorator is used to define a hook that is called when the chat session ends either because the user disconnected or started a new chat session.
@cl.on_chat_end
def on_chat_end():
print("The user disconnected!")
On Chat Resume
The on_chat_resume decorator is used to define a hook that is called when a user resumes a chat session that was previously disconnected. This can only happen if authentication and data persistence are enabled.
from chainlit.types import ThreadDict
@cl.on_chat_resume
async def on_chat_resume(thread: ThreadDict):
print("The user resumed a previous chat session!")hhuh(h	hh}ubh)}(h}(hNh	}(h;https://docs.chainlit.io/api-reference/input-widgets/switchh
Switch - ChainlituhXj  Input Widgets
Switch
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
int
The initial value of the input widget.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Switch
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Switch(id="Streaming", label="OpenAI - Stream Tokens", initial=True),
]
).send()
value = settings["Streaming"]hhuh(h	hh}ubh)}(h}(hNh	}(h)https://docs.chainlit.io/concepts/messageh
Message - ChainlituhX/  Message
A Message is a piece of information that is sent from the user to an assistant and vice versa. Coupled with life cycle hooks, they are the building blocks of a chat.
A message has a content, a timestamp and cannot be nested.
Example: Reply to a user message
Lets create a simple assistant that replies to a user message with a greeting.
import chainlit as cl
@cl.on_message
async def on_message(message: cl.Message):
response = f"Hello, you just sent: {message.content}!"
await cl.Message(response).send()
Message API
Learn more about the Message API.
Chat Context
Since LLMs are stateless, you will often have to accumulate the messages of the current conversation in a list to provide the full context to LLM with each query.
You could do that manually with the user_session. However, Chainlit provides a built-in way to do this:
import chainlit as cl
@cl.on_message
async def on_message(message: cl.Message):
# Get all the messages in the conversation in the OpenAI format
print(cl.chat_context.to_openai())
# Send the response
response = f"Hello, you just sent: {message.content}!"
await cl.Message(response).send()
Every message sent or received will be automatically accumulated in cl.chat_context
.
You can then use cl.chat_context.to_openai()
to get the conversation in the OpenAI format and feed it to the LLM.hhuh(h	hh}ubh)}(h}(hNh	}(h9https://docs.chainlit.io/api-reference/ask/ask-for-actionh
AskUserAction - ChainlituhX  Ask User
AskUserAction
Ask for the user to take an action before continuing.
If the user does not answer in time (see timeout), a TimeoutError
will be raised or None
will be returned depending on raise_on_timeout
parameter.
If a project ID is configured, the messages will be uploaded to the cloud storage.
Attributes
content
str
The content of the message.
actions
List[Action]
The list of Action to prompt the user.
author
str
The author of the message, defaults to the chatbot name defined in your config.
disable_human_feedback
bool
default: "False"The number of seconds to wait for an answer before raising a TimeoutError.
timeout
int
default: 90The number of seconds to wait for an answer before raising a TimeoutError.
raise_on_timeout
bool
default: "False"Whether to raise a socketio TimeoutError if the user does not answer in time.
Returns
response
AskActionResponse | None
requiredThe response of the user.
Example
import chainlit as cl
@cl.on_chat_start
async def main():
res = await cl.AskActionMessage(
content="Pick an action!",
actions=[
cl.Action(name="continue", value="continue", label="✅ Continue"),
cl.Action(name="cancel", value="cancel", label="❌ Cancel"),
],
).send()
if res and res.get("value") == "continue":
await cl.Message(
content="Continue!",
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/data-persistence/enterpriseh
Enterprise - ChainlituhXP  Enterprise
If your organization can’t use third party cloud services for data hosting, we can provide your company with a self-hostable Literal AI docker image (under commercial license).
To request access you can contact us here -> https://forms.gle/BX3UNBLmTF75KgZVA.
Define your Literal AI Server
Once you are hosting your own Literal AI instance, you can point to the server for data persistence.
You will need to use the LITERAL_API_URL
environment variable.
Modify the .env
file next to your Chainlit application.
LITERAL_API_URL="https://cloud.your_literal.com"
Alternatively, inlined:
LITERAL_API_URL="https://cloud.your_literal.com" chainlit run main.py
Activating Data Persistence
Using your own Literal AI instance, you will still need to provide a valid API key to persist the data as described here.
Once activated, your chats and elements will be stored on your own server.
Debug Mode
You can enable the new debug mode by adding -d
to your chainlit run
command. You will see a debug button below each message taking you to the trace/prompt playground.
Debug example
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h*https://docs.chainlit.io/examples/cookbookh
Cookbook - ChainlituhX@  Examples
Cookbook
The Cookbook repository serves as a valuable resource and starting point for developers looking to explore the capabilities of Chainlit in creating LLM apps.
It provides a diverse collection of example projects, each residing in its own folder, showcasing the integration of various tools such as OpenAI, Anthropiс, LangChain, LlamaIndex, ChromaDB, Pinecone and more.
Whether you are seeking basic tutorials or in-depth use cases, the Cookbook repository offers inspiration and practical insights!
https://github.com/Chainlit/cookbook
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h>https://docs.chainlit.io/api-reference/input-widgets/textinputh
TextInput - ChainlituhX  Input Widgets
TextInput
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
str
The initial value of the input widget.
placeholder
str
The placeholder value of the input widget.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import TextInput
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
TextInput(id="AgentName", label="Agent Name", initial="AI"),
]
).send()
value = settings["AgentName"]
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/chat-settingsh
Chat Settings - ChainlituhXz  Chat
Chat Settings
The ChatSettings
class is designed to create and send a dynamic form to the UI. This form can be updated by the user.
Attributes
inputs
List[InputWidget]
The fields of the form
Usage
import chainlit as cl
from chainlit.input_widget import Select, Switch, Slider
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Select(
id="Model",
label="OpenAI - Model",
values=["gpt-3.5-turbo", "gpt-3.5-turbo-16k", "gpt-4", "gpt-4-32k"],
initial_index=0,
),
Switch(id="Streaming", label="OpenAI - Stream Tokens", initial=True),
Slider(
id="Temperature",
label="OpenAI - Temperature",
initial=1,
min=0,
max=2,
step=0.1,
),
Slider(
id="SAI_Steps",
label="Stability AI - Steps",
initial=30,
min=10,
max=150,
step=1,
description="Amount of inference steps performed on image generation.",
),
Slider(
id="SAI_Cfg_Scale",
label="Stability AI - Cfg_Scale",
initial=7,
min=1,
max=35,
step=0.1,
description="Influences how strongly your generation is guided to match your prompt.",
),
Slider(
id="SAI_Width",
label="Stability AI - Image Width",
initial=512,
min=256,
max=2048,
step=64,
tooltip="Measured in pixels",
),
Slider(
id="SAI_Height",
label="Stability AI - Image Height",
initial=512,
min=256,
max=2048,
step=64,
tooltip="Measured in pixels",
),
]
).send()
@cl.on_settings_update
async def setup_agent(settings):
print("on_settings_update", settings)
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h*https://docs.chainlit.io/examples/securityh
Security - PII - ChainlituhXx
  Security - PII
When building chat applications, it’s crucial to ensure the secure handling of sensitive data, especially Personal Identifiable Information (PII). PII can be directly or indirectly linked to an individual, making it essential to protect user privacy by preventing the transmission of such data to language models.
Example of PII
Consider the text below, where PII has been highlighted:
Hello, my name is John and I live in New York. My credit card number is 3782-8224-6310-005 and my phone number is (212) 688-5500.
And here is the anonymized version:
Hello, my name is <PERSON> and I live in <LOCATION>. My credit card number is <CREDIT_CARD> and my phone number is <PHONE_NUMBER>.
Analyze and anonymize data
Integrate Microsoft Presidio for robust data sanitization in your Chainlit application.
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
# Notice that the message is passed as is
response = await cl.Message(
content=f"Received: {message.content}",
).send()
Before proceeding, ensure that the Python packages required for PII analysis and anonymization are installed. Run the following commands in your terminal to install them:
pip install presidio-analyzer presidio-anonymizer spacy
python -m spacy download en_core_web_lg
Create an async context manager that utilizes the Presidio Analyzer to inspect the incoming text for any PII. This context manager can be included in your main function to scrutinize messages before they are processed. When PII is detected, you should present the user with the option to either continue or cancel the operation. Use Chainlit’s messaging system to accomplish this.
from presidio_analyzer import AnalyzerEngine
from contextlib import asynccontextmanager
analyzer = AnalyzerEngine()
@asynccontextmanager
async def check_text(text: str):
pii_results = analyzer.analyze(text=text, language="en")
if pii_results:
response = await cl.AskActionMessage(
content="PII detected",
actions=[
cl.Action(name="continue", value="continue", label="✅ Continue"),
cl.Action(name="cancel", value="cancel", label="❌ Cancel"),
],
).send()
if response is None or response.get("value") == "cancel":
raise InterruptedError
yield
# ...
@cl.on_message
async def main(message: cl.Message):
async with check_text(message.content):
# This block is only executed when the user press "Continue"
response = await cl.Message(
content=f"Received: {message.content}",
).send()
If your application has a requirement to anonymize PII, Presidio can also do that. Modify the check_text context manager to return anonymized text when PII is detected.
from presidio_anonymizer import AnonymizerEngine
anonymizer = AnonymizerEngine()
@asynccontextmanager
async def check_text(text: str):
pii_results = analyzer.analyze(text=text, language="en")
if pii_results:
response = await cl.AskActionMessage(
content="PII detected",
actions=[
cl.Action(name="continue", value="continue", label="✅ Continue"),
cl.Action(name="cancel", value="cancel", label="❌ Cancel"),
],
).send()
if response is None or response.get("value") == "cancel":
raise InterruptedError
yield anonymizer.anonymize(
text=text,
analyzer_results=pii_results,
).text
else:
yield text
# ...
@cl.on_message
async def main(message: cl.Message):
async with check_text(message.content) as anonymized_message:
response = await llm_chain.arun(
anonymized_message
callbacks=[cl.AsyncLangchainCallbackHandler()]
)
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h*https://docs.chainlit.io/concepts/startersh
Starters - ChainlituhX0  Basic Concepts
Starters
Starters are suggestions to help your users get started with your assistant. You can declare up to 4 starters and optionally define an icon for each one.
starters.py
import chainlit as cl
@cl.set_starters
async def set_starters():
return [
cl.Starter(
label="Morning routine ideation",
message="Can you help me create a personalized morning routine that would help increase my productivity throughout the day? Start by asking me about my current habits and what activities energize me in the morning.",
icon="/public/idea.svg",
),
cl.Starter(
label="Explain superconductors",
message="Explain superconductors like I'm five years old.",
icon="/public/learn.svg",
),
cl.Starter(
label="Python script for daily email reports",
message="Write a script to automate sending daily email reports in Python, and walk me through how I would set it up.",
icon="/public/terminal.svg",
),
cl.Starter(
label="Text inviting friend to wedding",
message="Write a text asking a friend to be my plus-one at a wedding next month. I want to keep it super short and casual, and offer an out.",
icon="/public/write.svg",
)
]
# ...
Starters example
With Chat Profiles
Starters also work with Chat Profiles. You can define different starters for different chat profiles.
starters_with_chat_profiles.py
@cl.set_chat_profiles
async def chat_profile(current_user: cl.User):
if current_user.metadata["role"] != "ADMIN":
return None
return [
cl.ChatProfile(
name="My Chat Profile",
icon="https://picsum.photos/250",
markdown_description="The underlying LLM model is **GPT-3.5**, a *175B parameter model* trained on 410GB of text data.",
starters=[
cl.Starter(
label="Morning routine ideation",
message="Can you help me create a personalized morning routine that would help increase my productivity throughout the day? Start by asking me about my current habits and what activities energize me in the morning.",
icon="/public/idea.svg",
),
cl.Starter(
label="Explain superconductors",
message="Explain superconductors like I'm five years old.",
icon="/public/learn.svg",
),
],
)
]
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/api-reference/actionh
Action - ChainlituhX  Chat
Action
The Action
class is designed to create and manage actions to be sent and displayed in the chatbot user interface. Actions consist of buttons that the user can interact with, and these interactions trigger specific functionalities within your app.
Attributes
name
str
Name of the action, this should be used in the action_callback
value
str
The value associated with the action. This is useful to differentiate between multiple actions with the same name.
label
str
The label of the action. This is what the user will see. If not provided the name will be used.
description
str
The description of the action. This is what the user will see when they hover the action.
collapsed
bool
Show the action in a drawer menu
Usage
import chainlit as cl
@cl.action_callback("action_button")
async def on_action(action):
await cl.Message(content=f"Executed {action.name}").send()
# Optionally remove the action button from the chatbot user interface
await action.remove()
@cl.on_chat_start
async def start():
# Sending an action button within a chatbot message
actions = [
cl.Action(name="action_button", value="example_value", description="Click me!")
]
await cl.Message(content="Interact with this action button:", actions=actions).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h/https://docs.chainlit.io/customisation/overviewh
Overview - ChainlituhXa  Customisation
Overview
You can tailor your Chainlit Application to reflect your organization’s branding or personal style. Our intention is to provide a good level of customization to ensure a consistent user experience that aligns with your visual guidelines.
In this section we will go through the different options available.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h>https://docs.chainlit.io/api-reference/integrations/llamaindexh
&LlamaIndex Callback Handler - ChainlituhX  Integrations
LlamaIndex Callback Handler
Callback Handler to enable Chainlit to display intermediate steps in the UI.
Usage
Code Example
from llama_index.core.callbacks import CallbackManager
from llama_index.core.service_context import ServiceContext
import chainlit as cl
@cl.on_chat_start
async def start():
service_context = ServiceContext.from_defaults(callback_manager=CallbackManager([cl.LlamaIndexCallbackHandler()]))
# use the service context to create the predictor
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/api-reference/messageh
Message - ChainlituhX  Chat
Message
The Message
class is designed to send, stream, update or remove messages.
Parameters
content
str
The content of the message.
author
str
The author of the message, defaults to the chatbot name defined in your config file.
elements
Element[]
Elements to attach to the message.
actions
Action[]
Actions to attach to the message.
language
str
Language of the code if the content is code. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
Send a message
Send a new message to the UI.
import chainlit as cl
@cl.on_message
async def main(message: cl.Message):
await cl.Message(
content=f"Received: {message.content}",
).send()
Stream a message
Send a message token by token to the UI.
import chainlit as cl
token_list = ["the", "quick", "brown", "fox"]
@cl.on_chat_start
async def main():
msg = cl.Message(content="")
for token in token_list:
await msg.stream_token(token)
await msg.send()
Update a message
Update a message that already has been sent.
import chainlit as cl
@cl.on_chat_start
async def main():
msg = cl.Message(content="Hello!")
await msg.send()
await cl.sleep(2)
msg.content = "Hello again!"
await msg.update()
Remove a message
Remove a message from the UI.
import chainlit as cl
@cl.on_chat_start
async def main():
msg = cl.Message(content="Message 1")
await msg.send()
await cl.sleep(2)
await msg.remove()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h7https://docs.chainlit.io/api-reference/ask/ask-for-fileh
AskFileMessage - ChainlituhX5  AskFileMessage
Ask the user to upload a file before continuing. If the user does not answer in time (see timeout), a TimeoutError will be raised or None will be returned depending on raise_on_timeout. If a project ID is configured, the messages will be uploaded to the cloud storage.
Attributes
Text displayed above the upload button.
List of mime type to accept like ["text/csv", "application/pdf"]
or a dict like {"text/plain": [".txt", ".py"]}
.
More infos here https://react-dropzone.org/#!/Accepting%20specific%20file%20types.
Maximum file size in MB. Defaults to 2.
Maximum number of files to upload. Defaults to 1. Maximum value is 10.
The number of seconds to wait for an answer before raising a TimeoutError.
Whether to raise a socketio TimeoutError if the user does not answer in time.
Returns
The files uploaded by the user.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
files = None
# Wait for the user to upload a file
while files == None:
files = await cl.AskFileMessage(
content="Please upload a text file to begin!", accept=["text/plain"]
).send()
text_file = files[0]
with open(text_file.path, "r", encoding="utf-8") as f:
text = f.read()
# Let the user know that the system is ready
await cl.Message(
content=f"`{text_file.name}` uploaded, it contains {len(text)} characters!"
).send()
You can also pass a dict to the accept
parameter to precise the file extension for each mime type:
import chainlit as cl
file = await cl.AskFileMessage(
content="Please upload a python file to begin!", accept={"text/plain": [".py"]}
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/elements/audioh
Audio - ChainlituhX{  Elements
Audio
The Audio
class allows you to display an audio player for a specific audio file in the chatbot user interface.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the audio file to be displayed in the UI. This is shown to users.
display
ElementDisplay
Determines where the element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
url
str
The remote URL of the audio.
path
str
The local file path of the audio.
content
bytes
The file content of the audio in bytes format.
auto_play
bool
Whether the audio should start playing automatically.
Example
import chainlit as cl
@cl.on_chat_start
async def main():
elements = [
cl.Audio(name="example.mp3", path="./example.mp3", display="inline"),
]
await cl.Message(
content="Here is an audio file",
elements=elements,
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h'https://docs.chainlit.io/deploy/discordh
Discord - ChainlituhX
  Discord
To make your Chainlit app available on Discord, you will need to create a Discord app and set up the necessary environment variables.
How it Works
The Discord bot will listen to messages mentioning it in channels and direct messages. It will send replies to a dedicated thread or DM depending on the context.
Preview
Supported Features
Message | Streaming | Elements | Audio | Ask User | Chat History | Chat Profiles | Feedback |
---|---|---|---|---|---|---|---|
✅ | ❌ | ✅ | ❌ | ❌ | ✅ | ❌ | ✅ |
Install the Discord Library
The Discord library is not included in the Chainlit dependencies. You will have to install it manually.
pip install discord
Create a Discord App
To start, navigate to the Discord apps dashboard. Here, you should find a button that says New Application. When you click this button, select the option to create your app from scratch.
Create a Discord App
Set the Environment Variables
Navigate to the Bot tab and click on Reset Token
. This will make the token visible. Copy it and set it as an environment variable in your Chainlit app.
Copy the Bot Token
DISCORD_BOT_TOKEN=your_bot_token
Set Intents
Navigate to the Bot tab and enable the MESSAGE CONTENT INTENT
, then click on Save Changes.
Set Intents
Working Locally
If you are working locally, you will have to expose your local Chainlit app to the internet to receive incoming messages to Discord. You can use ngrok for this.
ngrok http 8000
Start the Chainlit App
Since the Chainlit app is not running, the Discord bot will not be able to communicate with it.
For the example, we will use this simple app:
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
# Access the original discord message
print(cl.user_session.get("discord_message"))
# Access the discord user
print(cl.user_session.get("user"))
# Access potential attached files
attached_files = msg.elements
await cl.Message(content="Hello World").send()
Start the Chainlit app.
Using -h to not open the default Chainlit UI since we are using Discord.
chainlit run my_app.py -h
Install the Discord Bot to Your Workspace
Navigate to the OAuth2 tab. In the OAuth2 URL Generator, select the bot
scope.
Configure Installation
Then, in the Bot Permissions section, select the following permissions.
You can check that you have selected the right permissions by looking at the
number of permissions parameter of the URL. It should be 377957238848
.
Bot Permissions
Copy the generated URL and paste it in your browser. You will be prompted to add the bot to a server. Select the server you want to add the bot to.
That’s it! You should now be able to interact with your Chainlit app through Discord.
Chat History
Chat history is directly available through discord.
from chainlit.discord.app import client as discord_client
import chainlit as cl
import discord
@cl.on_message
async def on_message(msg: cl.Message):
# The user session resets on every Discord message.
# So we add previous chat messages manually.
messages = cl.user_session.get("messages", [])
channel: discord.abc.MessageableChannel = cl.user_session.get("discord_channel")
if channel:
cl.user_session.get("messages")
discord_messages = [message async for message in channel.history(limit=10)]
# Go through last 10 messages and remove the current message.
for x in discord_messages[::-1][:-1]:
messages.append({
"role": "assistant" if x.author.name == discord_client.user.name else "user",
"content": x.clean_content if x.clean_content else x.channel.name # first message is empty
})
# Your code here
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h#https://docs.chainlit.io/deploy/apih
API - ChainlituhX3
  API
You can mount your Chainlit app on an existing FastAPI app to create custom endpoints. One good use case for this is to serve an assistant through a rest API.
How it works
To mount your Chainlit app on an existing FastAPI app, you will have to define a subpath for your Chainlit app.
from fastapi import FastAPI
from chainlit.utils import mount_chainlit
app = FastAPI()
@app.get("/app")
def read_main():
return {"message": "Hello World from main app"}
mount_chainlit(app=app, target="my_cl_app.py", path="/chainlit")
Now run your FastAPI app and you will be able to access your Chainlit app at /chainlit
.
uvicorn app:app --host 0.0.0.0 --port 80
Use Chainlit APIs in your endpoint
To use Chainlit APIs, a Chainlit context is required.
HTTP context
In an HTTP context, Chainlit APIs such as Message.send() will do nothing.
If data persistence is enabled, the Chainlit APIs will still persist data.
from fastapi import FastAPI
from chainlit.utils import mount_chainlit
from chainlit.context import init_http_context
import chainlit as cl
app = FastAPI()
@app.get("/app")
async def read_main():
init_http_context()
await cl.Message(content="Hello, I am a chatbot!").send()
return {"message": "Hello World from main app"}
# pass path="" to mount the Chainlit app on the root path
mount_chainlit(app=app, target="my_cl_app.py", path="/chainlit")
Websocket context
The only use case that requires to use the Websocket context within a custom endpoint is to send data to a websocket client (which you know the session ID of) based on some arbitrary HTTP request.
import chainlit as cl
@cl.on_chat_start
def main():
print("Session id:", cl.user_session.get("id"))
from fastapi import FastAPI, Request
from chainlit.utils import mount_chainlit
from chainlit.context import init_ws_context
from chainlit.session import WebsocketSession
import chainlit as cl
app = FastAPI()
@app.get("/hello/{session_id}")
async def hello(
request: Request,
session_id: str,
):
ws_session = WebsocketSession.get_by_id(session_id=session_id)
init_ws_context(ws_session)
await cl.Message(content="Hello World").send()
return "Data sent to the websocket client"
mount_chainlit(app=app, target="./my_cl_app.py")
Authentication
You can use any authentication system since the request is accessible. However Chainlit authentication is fully compatible with custom endpoints.
from typing_extensions import Annotated
from fastapi import Request, Depends, FastAPI
from fastapi.responses import (
HTMLResponse,
)
from chainlit.context import init_http_context
from chainlit.auth import authenticate_user
import chainlit as cl
app = FastAPI()
@app.get("/hello")
async def hello(
request: Request,
current_user: Annotated[
cl.User, Depends(authenticate_user)
],
):
print(current_user)
init_http_context(user=current_user)
await cl.Message(content="Hello World").send()
return HTMLResponse("Hello World")
Once an endpoint is protected, it will require to have a valid token in the Authorization
header.
{
"Authorization": "Bearer TOKEN"
}
Generate a token
The token is the same token generated when you login in the Chainlit app. You can generate a token manually for a given user with this python script.
This will require to have a CHAINLIT_AUTH_SECRET. You can run chainlit create-secret
to create one.
from chainlit.auth import create_jwt
import chainlit as cl
print(create_jwt(cl.User(identifier="USERNAME")))hhuh(h	hh}ubh)}(h}(hNh	}(h,https://docs.chainlit.io/customisation/themeh
Theme - ChainlituhXC  Customisation
Theme
Looking to refresh your app’s appearance? You can easily alter the default theme colors in your config.toml
file.
Currently, you have the freedom to modify:
- Background color: This option allows you to change the color of the app’s background.
- Paper color: This alters the color of the ‘paper’ elements within the app, such as the navbar, widgets, etc.
- Primary color: This encompasses three shades - main, dark, and light. These colors are primarily used for interactive interface elements.
If you started your Chainlit app with -w (file watcher), it will refresh every time you update the theme!
Default Theme
To set the default theme, navigate to the [UI.theme]
section in your config.toml
file and update the default
value.
config.toml
[UI.theme]
default = "dark"
Light Theme Modification
To modify the light theme, find or create the [UI.theme.light]
section and update the colors as per your preference.
config.toml
[UI.theme.light]
background = "#110061"
paper = "#FFFFFF"
[UI.theme.light.primary]
main = "#110061"
dark = "#180039"
light = "#FFE7EB"
Dark Theme Modification
To alter the dark theme, the section begins with [UI.theme.dark]
.
config.toml
[UI.theme.dark]
background = "#FAFAFA"
paper = "#FFFFFF"
[UI.theme.dark.primary]
main = "#A80061"
dark = "#380039"
light = "#FFE7EB"
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/get-started/installationh
Installation - ChainlituhXQ  Get Started
Installation
Chainlit requires python>=3.8
.
You can install Chainlit it via pip as follows:
pip install chainlit
This will make the chainlit
command available on your system.
Make sure everything runs smoothly:
chainlit hello
This should spawn the chainlit UI and ask for your name like so:
Next steps
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h8https://docs.chainlit.io/advanced-features/chat-profilesh
Chat Profiles - ChainlituhXb  Advanced Features
Chat Profiles
Chat Profiles are useful if you want to let your users choose from a list of predefined configured assistants. For example, you can define a chat profile for a support chat, a sales chat, or a chat for a specific product.
Chat Profiles API
Learn how to define chat profiles.
Example of Chat Profiles
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hBhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-chat-endG     h
on_chat_end - ChainlituhX  Life Cycle Hooks
on_chat_end
Hook to react to the user websocket disconnection event.
Usage
import chainlit as cl
@cl.on_chat_start
def start():
print("hello", cl.user_session.get("id"))
@cl.on_chat_end
def end():
print("goodbye", cl.user_session.get("id"))
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/elements/imageh
Image - ChainlituhX  Elements
Image
The Image
class is designed to create and handle image elements to be sent and displayed in the chatbot user interface.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the image to be displayed in the UI.
display
ElementDisplay
Determines how the image element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
size
ElementSize
Determines the size of the image. Only works with display=“inline”. Choices are “small”, “medium” (default), or “large”.
url
str
The remote URL of the image source.
path
str
The local file path of the image.
content
bytes
The file content of the image in bytes format.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
image = cl.Image(path="./cat.jpeg", name="image1", display="inline")
# Attach the image to the message
await cl.Message(
content="This message has an image!",
elements=[image],
).send()hhuh(h	hh}ubh)}(h}(hNh	}(h%https://docs.chainlit.io/deploy/teamsh
Teams - ChainlituhXU
  Teams
To make your Chainlit app available on Teams, you will need to create a Teams bot and set up the necessary environment variables.
How it Works
The Teams bot will be available in direct messages.
Preview
Supported Features
Message | Streaming | Elements | Audio | Ask User | Chat History | Chat Profiles | Feedback |
---|---|---|---|---|---|---|---|
✅ | ❌ | ✅ | ❌ | ❌ | ❌ | ❌ | ✅ |
Install the Botbuilder Library
The Botbuilder library is not included in the Chainlit dependencies. You will have to install it manually.
pip install botbuilder-core
Create a Teams App
To start, navigate to the App Management page. Here, create a new app.
Create a Teams App
Fill the App Basic Information
Navigate to Configure > Basic Information and fill in the basic information about your app. You won’t be able to publish your app until you fill in all the required fields.
Basic infos
Create the Bot
Navigate to Configure > App features and add the Bot feature. Create a new bot and give it the following permissions and save.
Bot permissions
Go to the Bot Framework Portal
Navigate to the Bot Framework Portal, click on the Bot you just created and go to the Settings page.
Get the App ID
In the Bot Framework Portal, you will find the app ID. Copy it and set it as an environment variable in your Chainlit app.
TEAMS_APP_ID=your_app_id
Get the App ID
Working Locally
If you are working locally, you will have to expose your local Chainlit app to the internet to receive incoming messages to Teams. You can use ngrok for this.
ngrok http 8000
This will give you a public URL that you can use to set up the app manifest. Do not forget to replace it once you deploy Chainlit to a public host.
Set the Message Endpoint
Under Configuration, set the messaging endpoint to your Chainlit app HTTPS URL and add the /teams/events
suffix.
Messaging endpoint
Get the App Secret
On the same page, you will find a blue “Manage Microsoft App ID and password” button. Click on it.
Manage password
Navigate to Manage > Certificates & secrets and create a new client secret. Copy it and set it as an environment variable in your Chainlit app.
TEAMS_APP_PASSWORD=your_app_secret
Support Multi Tenant Account Types
Navigate to Manage > Authentication and toggle “Accounts in any organizational directory (Any Microsoft Entra ID tenant - Multitenant)” then save.
Multi tenant
Start the Chainlit App
Since the Chainlit app is not running, the Teams bot will not be able to communicate with it.
For the example, we will use this simple app:
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
# Access the teams user
print(cl.user_session.get("user"))
# Access potential attached files
attached_files = msg.elements
await cl.Message(content="Hello World").send()
Reminder: Make sure the environment variables are set and that your local chainlit app is exposed to the internet via ngrok.
Start the Chainlit app:
chainlit run my_app.py -h
Using -h to not open the default Chainlit UI since we are using Teams.
Publish the Bot
Back to the App Management page, navigate to “Publish to org” and click on “Publish”.
Publish
Authorize the Bot
The Bot will have to be authorized by the Teams admin before it can be used. To do so navigate to the Teams admin center and find the app.
Publish
Then authorize it.
Publish
You should now be able to interact with your Chainlit app through Teams.hhuh(h	hh}ubh)}(h}(hNh	}(h%https://docs.chainlit.io/integrationsh
FastAPI - ChainlituhX  Integrations
FastAPI
Chainlit can be mounted as a FastAPI sub application.
my_cl_app
import chainlit as cl
@cl.on_chat_start
async def main():
await cl.Message(content="Hello World").send()
main
from fastapi import FastAPI
from chainlit.utils import mount_chainlit
app = FastAPI()
@app.get("/app")
def read_main():
return {"message": "Hello World from main app"}
mount_chainlit(app=app, target="my_cl_app.py", path="/chainlit")
In the example above, we have a FastAPI application with a single endpoint /app
. We mount the Chainlit application my_cl_app.py
to the /chainlit
path.
Start the FastAPI server:
uvicorn main:app --host 0.0.0.0 --port 80
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/customisation/custom-jsh

JS - ChainlituhX[  Customisation
JS
You can inject a custom JavaScript script into the application by adding the following to your config.toml
:
config.toml
[UI]
# ...
# This can either be a css file in your `public` dir or a URL
custom_js = '/public/my_js_script.js'
Once the configuration is updated, restart the application. Your custom script will now be loaded.hhuh(h	hh}ubh)}(h}(hNh	}(h,https://docs.chainlit.io/examples/openai-sqlh
Text to SQL - ChainlituhX  Examples
Text to SQL
Let’s build a simple app that helps users to create SQL queries with natural language.
Preview of the final result
Prerequisites
This example has extra dependencies. You can install them with:
pip install chainlit openai
Imports
app.py
from openai import AsyncOpenAI
import chainlit as cl
cl.instrument_openai()
client = AsyncOpenAI(api_key="YOUR_OPENAI_API_KEY")
Define a prompt template and LLM settings
app.py
template = """SQL tables (and columns):
* Customers(customer_id, signup_date)
* Streaming(customer_id, video_id, watch_date, watch_minutes)
A well-written SQL query that {input}:
```"""
settings = {
"model": "gpt-3.5-turbo",
"temperature": 0,
"max_tokens": 500,
"top_p": 1,
"frequency_penalty": 0,
"presence_penalty": 0,
"stop": ["```"],
}
Add the Assistant Logic
Here, we decorate the main
function with the @on_message decorator to tell Chainlit to run the main
function each time a user sends a message.
Then, we wrap our text to sql logic in a Step.
app.py
@cl.set_starters
async def starters():
return [
cl.Starter(
label=">50 minutes watched",
message="Compute the number of customers who watched more than 50 minutes of video this month."
)
]
@cl.on_message
async def main(message: cl.Message):
stream = await client.chat.completions.create(
messages=[
{
"role": "user",
"content": template.format(input=message.content),
}
], stream=True, **settings
)
msg = await cl.Message(content="", language="sql").send()
async for part in stream:
if token := part.choices[0].delta.content or "":
await msg.stream_token(token)
await msg.update()
Try it out
chainlit run app.py -w
You can ask questions like Compute the number of customers who watched more than 50 minutes of video this month
.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/guides/migration/1.1.400h
'Migrate to Chainlit v1.1.400 - ChainlituhX  Guides
Migrate to Chainlit v1.1.400
Join the discord for live updates: https://discord.gg/AzyvDHWARx
Updating Chainlit
Begin the migration by updating Chainlit to the latest version:
pip install --upgrade chainlit
More control over Chain of Thought
The hide_cot
config parameter has been replaced with cot
. The cot
parameter can be set to hidden
, tool_call
, or full
. This parameter controls the display of the Chain of Thought (COT) in the UI.
disable_feedback
is gone
Chainlit 1.1.400 takes a different approach to feedback. Now, a user input will trigger a run. Once the run is complete, the user can provide feedback for the whole run instead of being able to score each message. This change simplifies the feedback process and makes it more intuitive.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h!https://docs.chainlit.io/conceptsh
Chat Life Cycle - ChainlituhX  Chat Life Cycle
Whenever a user connects to your Chainlit app, a new chat session is created. A chat session goes through a life cycle of events, which you can respond to by defining hooks.
On Chat Start
The on_chat_start decorator is used to define a hook that is called when a new chat session is created.
@cl.on_chat_start
def on_chat_start():
print("A new chat session has started!")
On Message
The on_message decorator is used to define a hook that is called when a new message is received from the user.
@cl.on_message
def on_message(msg: cl.Message):
print("The user sent: ", msg.content)
On Stop
The on_stop
decorator is used to define a hook that is called when the user clicks the stop button while a task was running.
@cl.on_stop
def on_stop():
print("The user wants to stop the task!")
On Chat End
The on_chat_end decorator is used to define a hook that is called when the chat session ends either because the user disconnected or started a new chat session.
@cl.on_chat_end
def on_chat_end():
print("The user disconnected!")
On Chat Resume
The on_chat_resume decorator is used to define a hook that is called when a user resumes a chat session that was previously disconnected. This can only happen if authentication and data persistence are enabled.
from chainlit.types import ThreadDict
@cl.on_chat_resume
async def on_chat_resume(thread: ThreadDict):
print("The user resumed a previous chat session!")hhuh(h	hh}ubh)}(h}(hNh	}(h@https://docs.chainlit.io/api-reference/lifecycle-hooks/on-logouth
on_logout - ChainlituhX  Life Cycle Hooks
on_logout
Decorator to react to a user logging out. Useful to clear cookies or other user data through the HTTP response.
Parameters
request
fastapi.Request
The request object.
response
fastapi.Response
The response object.
Usage
from fastapi import Request, Response
import chainlit as cl
@cl.on_logout
def main(request: Request, response: Response):
response.delete_cookie("my_cookie")
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hAhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-messageh
on_message - ChainlituhX]  Life Cycle Hooks
on_message
Decorator to react to messages coming from the UI. The decorated function is called every time a new message is received.
Parameters
message
cl.Message
The message coming from the UI.
Usage
import chainlit as cl
@cl.on_message
def main(message: cl.Message):
content = message.content
# do something
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h(https://docs.chainlit.io/deploy/overviewh
Overview - ChainlituhX  Overview
A Chainlit application can be consumed through multiple platforms. Write your assistant logic once, use everywhere!
Available Platforms
Web App
The native Chainlit UI. Available on port 8000.
Copilot
Embed your Chainlit app on any website as a Copilot.
API
Expose custom API endpoints.
Custom React App
Learn how to integrate your custom React frontend with the Chainlit backend.
Teams
Make your Chainlit app available on Teams.
Slack
Make your Chainlit app available on Slack.
Discord
Make your Chainlit app available on Discord.
Deploy your Chainlit Application
No matter the platform(s) you want to serve with your Chainlit application, you will need to deploy it first.
After you’ve successfully set up and tested your Chainlit application locally, the next step is to make it accessible to a wider audience by deploying it to a hosting service. This guide provides various options for self-hosting your Chainlit app.
When running a Chainlit app in production, you should always add -h
to the
chainlit run
command. Otherwise a browser window will be opened server side
and might break your deployment.
Chainlit is built upon websockets, which means the service you deploy your app to has to support them. For auto scaling, make sure to enable sticky sessions.
If you need to deploy your Chainlit app to a subpath like
https://my-app.com/chainlit
, you will need to set the --root-path /chainlit
flag when running the chainlit run
command. This will ensure that
the app is served from the correct path.
- on Ploomber Cloud
- on AWS
- on Azure Container
- on Google Cloud Run
- on Google App Engine
- on Replit
- on Render
- on Fly.io
- on HuggingFace Spaces
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hDhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-chat-starth
on_chat_start - ChainlituhX  Life Cycle Hooks
on_chat_start
Hook to react to the user websocket connection event.
Usage
Code Example
from chainlit import AskUserMessage, Message, on_chat_start
@on_chat_start
async def main():
res = await AskUserMessage(content="What is your name?", timeout=30).send()
if res:
await Message(
content=f"Your name is: {res['content']}.\nChainlit installation is working!\nYou can now start building your own chainlit apps!",
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/backend/env-variablesh
 Environment Variables - ChainlituhX  Environment Variables
Hardcoding API keys in your code is not a good practice. It makes your code less portable and less flexible. It also makes it harder to keep your code secure. Instead, you should use environment variables to store values that are specific to your development environment.
Chainlit will automatically load environment variables from a .env
file in the root of your project. This file should be added to your .gitignore
file so that it is not committed to your repository.
OPENAI_API_KEY=sk-...
PINECONE_API_KEY=...
Public Apps & Environment Variables
If you want to share your app to a broader audience, you should not put your own OpenAI API keys in the .env
file.
Instead, you should use user_env
in the Chainlit config to ask each user to provide their own keys.
You can then access the user’s keys in your code using:
import chainlit as cl
user_env = cl.user_session.get("env")
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/api-reference/step-classh
Step Class - ChainlituhX+
  Step Class
The Step
class is a Python Context Manager that can be used to create steps in your chainlit app. The step is created when the context manager is entered and is updated to the client when the context manager is exited.
Parameters
The name of the step. Default to the name of the decorated function.
The type of the step, useful for monitoring and debugging.
Elements to attach to the step.
By default the step will be nested under the previous step/message. Set this
to True
to make it a root step.
Language of the output. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
By default only the output of the step is shown. Set this to True
to also
show the input. You can also set this to a language like json
or python
to
syntax highlight the input.
Send a Step
import chainlit as cl
@cl.on_message
async def main():
async with cl.Step(name="Test") as step:
# Step is sent as soon as the context manager is entered
step.input = "hello"
step.output = "world"
# Step is updated when the context manager is exited
Stream the Output
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI()
@cl.on_message
async def main(msg: cl.Message):
# Whether to nest the step under the user message
root = True
async with cl.Step(name="gpt4", type="llm", root=root) as step:
step.input = msg.content
stream = await client.chat.completions.create(
messages=[{"role": "user", "content": msg.content}],
stream=True,
model="gpt-4",
temperature=0,
)
async for part in stream:
delta = part.choices[0].delta
if delta.content:
# Stream the output of the step
await step.stream_token(delta.content)
Nest Steps
To nest steps, simply create a step inside another step.
import chainlit as cl
@cl.on_chat_start
async def main():
async with cl.Step(name="Parent step") as parent_step:
parent_step.input = "Parent step input"
async with cl.Step(name="Child step") as child_step:
child_step.input = "Child step input"
child_step.output = "Child step output"
parent_step.output = "Parent step output"
Update a Step
import chainlit as cl
@cl.on_chat_start
async def main():
async with cl.Step(name="Parent step") as step:
step.input = "Parent step input"
step.output = "Parent step output"
await cl.sleep(2)
step.output = "Parent step output updated"
await step.update()
Remove a Step
import chainlit as cl
@cl.on_chat_start
async def main():
async with cl.Step(name="Parent step") as step:
step.input = "Parent step input"
step.output = "Parent step output"
await cl.sleep(2)
await step.remove()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/customisation/avatarsh
Avatars - ChainlituhX  Customisation
Avatars
The default assistant avatar is the favicon of the application. See how to customize the favicon here.
However, you can customize the avatar by placing an image file in the /public/avatars
folder.
The image file should be named after the author of the message. For example, if the author is My Assistant
, the avatar should be named my_assistant.png
.
public/
└── avatars/
└── my_assistant.png
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h)https://docs.chainlit.io/data-persistenceh
Overview - ChainlituhXH  Overview
By default, your Chainlit app does not persist the chats and elements it generates. However, the ability to store and utilize this data can be a crucial part of your project or organization.
Once enabled, data persistence will introduce new features to your application.
Features
Enable Data Persistence in 1 minute
- Navigate to Literal AI and sign in.
- You will be prompted to create a new project:
Project Creation Screen
- Navigate to the
Settings
page. A default API key will be generated for youProject API Key
Activation
Once you have an API key, you will need to pass it via a LITERAL_API_KEY
environment variable.
Next to your Chainlit application, create a .env
file and modify it like so:
LITERAL_API_KEY="your key"
Or inlined:
LITERAL_API_KEY="your key" chainlit run main.py
Or inlined for Windows powershell:
$ENV:LITERAL_API_KEY="your key"; chainlit run main.py
Once activated, your chats and elements will be persisted on Literal AI.
Deactivation
If you wish to deactivate data persistence, simply comment out or remove the LITERAL_API_KEY
environment variable.
Data privacy & security
We prioritize your data’s privacy and security. We understand how crucial the data fed into Chainlit Cloud is for your business and handle it with utmost care.
Contact us for detailed information: contact@chainlit.io
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/get-started/overviewh
Overview - ChainlituhXr  Overview
Chainlit is an open-source Python package to build production ready Conversational AI.
Build Conversational AI with Chainlit
Key features
-
Build fast: Integrate seamlessly with an existing code base or start from scratch in minutes
-
Multi Platform: Write your assistant logic once, use everywhere
-
Data persistence: Collect, monitor and analyze data from your users
-
Visualize multi-steps reasoning: Understand the intermediary steps that produced an output at a glance
Integrations
Chainlit is compatible with all Python programs and libraries. That being said, it comes with a set of integrations with popular libraries and frameworks.
OpenAI
Learn how to explore your OpenAI calls in Chainlit.
OpenAI Assistant
Learn how to integrate your OpenAI Assistants with Chainlit.
Mistral AI
Learn how to use any Mistral AI calls in Chainlit.
Llama Index
Learn how to integrate your Llama Index code with Chainlit.
LangChain
Learn how to use any LangChain agent with Chainlit.
Autogen
Learn how to integrate your Autogen agents with Chainlit.
Haystack
Learn how to integrate your Haystack code with Chainlit.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h3https://docs.chainlit.io/api-reference/elements/pdfh
PDF viewer - ChainlituhXo  PDF viewer
The Pdf
class allows you to display a PDF hosted remotely or locally in the chatbot UI. This class either takes a URL of a PDF hosted online, or the path of a local PDF.
Attributes
The name of the PDF to be displayed in the UI.
Determines how the PDF element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
The remote URL of the PDF file. Must provide url for a remote PDF (or either path or content for a local PDF).
The local file path of the PDF. Must provide either path or content for a local PDF (or url for a remote PDF).
The file content of the PDF in bytes format. Must provide either path or content for a local PDF (or url for a remote PDF).
Example
Inline
import chainlit as cl
@cl.on_chat_start
async def main():
# Sending a pdf with the local file path
elements = [
cl.Pdf(name="pdf1", display="inline", path="./pdf1.pdf")
]
cl.Message(content="Look at this local pdf!", elements=elements).send()
Side and Page
You must have the name of the pdf in the content of the message for the link to be created.
import chainlit as cl
@cl.on_chat_start
async def main():
# Sending a pdf with the local file path
elements = [
cl.Pdf(name="pdf1", display="side", path="./pdf1.pdf")
]
# Reminder: The name of the pdf must be in the content of the message
await cl.Message(content="Look at this local pdf1!", elements=elements).send()hhuh(h	hh}ubh)}(h}(hNh	}(h2https://docs.chainlit.io/customisation/translationh
Translation - ChainlituhX  Translation
Translation files are located in the .chainlit/translations
directory. The files are named after the language code, e.g. en-US.json
for English (United States).
The language is dynamically set for each user based on the language of the
browser. The default language is en-US
.
Customizing UI text
In addition to standard translations, you can customize the text of front-end components used within the UI. Each UI element is associated with a unique translation key in the translation files. By modifying these keys, you can personalize or localize the UI text according to your needs.
For example, to change the label of a navigation tab from “Readme” to “Documentation”, locate the corresponding key in your translation file (e.g., components.organisms.header.readme
) and update the value:
"components.organisms.header.readme": "Documentation"
Adding a new language
To add a new language, create a new file in the .chainlit/translations
directory with the language code as the filename. The language code should be in the format of languageCode-COUNTRYCODE
, e.g. en-US
for English (United States) or en-GB
for English (United Kingdom).
Lint translations
To lint the translations, run the following command:
chainlit lint-translations
Translate chainlit.md file
You can define multiple translations for the chainlit.md
file. For instance chainlit_pt-BR.md
for Portuguese (Brazil) and chainlit_es-ES.md
for Spanish (Spain).
The file will be loaded based on the browser’s language, defaulting to chainlit.md
if no translation is available.
Resetting
To reset the the translations, remove the .chainlit/translations
directory and restart your Chainlit application:
chainlit run my-app.pyhhuh(h	hh}ubh)}(h}(hNh	}(h6https://docs.chainlit.io/api-reference/elements/pyploth
Pyplot - ChainlituhX   Elements
Pyplot
The Pyplot
class allows you to display a Matplotlib pyplot chart in the chatbot UI. This class takes a pyplot figure.
The difference of between this element and the Plotly
element is that the user is shown a static image of the chart when using Pyplot
.
Attributes
name
str
The name of the chart to be displayed in the UI.
display
ElementDisplay
Determines how the chart element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
size
ElementSize
Determines the size of the chart. Only works with display=“inline”. Choices are “small”, “medium” (default), or “large”.
figure
str
The matplotlib.figure.Figure
instance that you want to display.
Example
import matplotlib.pyplot as plt
import chainlit as cl
@cl.on_chat_start
async def main():
fig, ax = plt.subplots()
ax.plot([1, 2, 3, 4], [1, 4, 2, 3])
elements = [
cl.Pyplot(name="plot", figure=fig, display="inline"),
]
await cl.Message(
content="Here is a simple plot",
elements=elements,
).send()hhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/authentication/oauthh
OAuth - ChainlituhX  OAuth
OAuth lets you use third-party services to authenticate your users.
To active an OAuth provider, you need to define both the OAuth callback in your code and the provider(s) environment variables.
Providers
Follow these guides to create an OAuth app for your chosen provider(s). Then copy the information into the right environment variable to active the provider.
If your app is served behind a reverse proxy (like cloud run) you will have to
set the CHAINLIT_URL
environment variable. For instance, if you host your
application at https://mydomain.com
, CHAINLIT_URL
should be set to
https://mydomain.com
.
GitHub
Go to this page to create a new GitHub OAuth app.
The callback URL should be: CHAINLIT_URL/auth/oauth/github/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/github/callback
.
You need to set the following environment variables:
OAUTH_GITHUB_CLIENT_ID
: Client IDOAUTH_GITHUB_CLIENT_SECRET
: Client secret
Gitlab
Go to this page to create a new GitLab OAuth app. When creating the app, you need to allow the openid
, profile
and email
scopes.
The callback URL should be: CHAINLIT_URL/auth/oauth/gitlab/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/gitlab/callback
.
You need to set the following environment variables:
OAUTH_GITLAB_CLIENT_ID
: Client IDOAUTH_GITLAB_CLIENT_SECRET
: Client secretOAUTH_GITLAB_DOMAIN
: domain name (without the protocol)
Go to this page to create a new Google OAuth app.
The callback URL should be: CHAINLIT_URL/auth/oauth/google/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/google/callback
.
You need to set the following environment variables:
OAUTH_GOOGLE_CLIENT_ID
: Client IDOAUTH_GOOGLE_CLIENT_SECRET
: Client secret
Azure Active Directory
Follow this guide to create a new Azure Active Directory OAuth app.
The callback URL should be: CHAINLIT_URL/auth/oauth/azure-ad/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/azure-ad/callback
.
You need to set the following environment variables:
OAUTH_AZURE_AD_CLIENT_ID
: Client IDOAUTH_AZURE_AD_CLIENT_SECRET
: Client secretOAUTH_AZURE_AD_TENANT_ID
: Azure tenant ID
If your application supports “Accounts in this organizational directory only”
(Single tenant), you will need to explicitly set:
OAUTH_AZURE_AD_ENABLE_SINGLE_TENANT=true
. If not, do not set this
environment variable at all.
Okta
Follow this guide to create OIDC app integrations.
The callback URL should be: CHAINLIT_URL/auth/oauth/okta/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/okta/callback
.
You need to set the following environment variables:
OAUTH_OKTA_CLIENT_ID
: Client IDOAUTH_OKTA_CLIENT_SECRET
: Client secretOAUTH_OKTA_DOMAIN
: Domain name for your okta setup - e.g. https://company.okta.com
There are several ways to configure the Okta OAuth routes:
- When using the Single Sign-On to Okta setup, you need to set the
OAUTH_OKTA_AUTHORIZATION_SERVER_ID
environment variable tofalse
. - When using Okta as the identity platform for your app or API either:
- set the
OAUTH_OKTA_AUTHORIZATION_SERVER_ID
environment variable todefault
if you have a developer account, - or set it to the authorization server id from your Custom Authorization Server.
- set the
Descope
Head to the Descope sign-up page, to get started with your account and set up your authentication.
The callback URL should be: CHAINLIT_URL/auth/oauth/descope/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/descope/callback
.
You need to set the following environment variables:
OAUTH_DESCOPE_CLIENT_ID
: Descope Project ID, which can be found under Project Settings in the console.OAUTH_DESCOPE_CLIENT_SECRET
: Descope Access Key, which can be created under Access Keys in the console.
Auth0
Follow this guide to create an Auth0 application.
The callback URL should be: CHAINLIT_URL/auth/oauth/auth0/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/auth0/callback
.
You need to set the following environment variables:
OAUTH_AUTH0_CLIENT_ID
: Client IDOAUTH_AUTH0_CLIENT_SECRET
: Client secretOAUTH_AUTH0_DOMAIN
: Domain name for your auth0 setup
Optional environment variables:
OAUTH_AUTH0_ORIGINAL_DOMAIN
: Original domain name for your auth0 setup, if you are using a custom domain
Amazon Cognito
Follow this guide to create a new Amazon Cognito User Pool.
The callback URL should be: CHAINLIT_URL/auth/oauth/aws-cognito/callback
. If your Chainlit app is hosted at localhost:8000, you should use http://localhost:8000/auth/oauth/aws-cognito/callback
.
You need to set the following environment variables:
OAUTH_COGNITO_CLIENT_ID
: Client IDOAUTH_COGNITO_CLIENT_SECRET
: Client secretOAUTH_COGNITO_DOMAIN
: Cognito Domain
Examples
Allow all users who passed the oauth authentication.
from typing import Dict, Optional
import chainlit as cl
@cl.oauth_callback
def oauth_callback(
provider_id: str,
token: str,
raw_user_data: Dict[str, str],
default_user: cl.User,
) -> Optional[cl.User]:
return default_user
Only allow users from a specific google domain.
from typing import Dict, Optional
import chainlit as cl
@cl.oauth_callback
def oauth_callback(
provider_id: str,
token: str,
raw_user_data: Dict[str, str],
default_user: cl.User,
) -> Optional[cl.User]:
if provider_id == "google":
if raw_user_data["hd"] == "example.org":
return default_user
return Nonehhuh(h	hh}ubh)}(h}(hNh	}(h*https://docs.chainlit.io/backend/config/uih

UI - ChainlituhX-  Config
UI
Options
name
str
default: "My Chatbot"The name of both the application and the chatbot.
description
str
The content of the <meta name="description">
of the application.
cot
Literal['hidden', 'tool_call', 'full']
default: "full"The chain of thought (COT) is a feature that shows the user the steps the chatbot took to reach a conclusion. You can hide the COT, only show the tool calls, or show it in full.
default_collapse_content
bool
default: trueWhen handling large text content we collapse it for keeping the threads concise. You can disable manually disable this behavior.
default_expand_message
bool
default: falseSub-messages are hiden by default, you can “expand” the parent message to show those messages. Toggling this setting will display the sub-messages by default.
github
str
Passing this option will display a Github-shaped link. If not passed we will display the link to Chainlit repo.
Default configuration
[UI]
# Name of the app and chatbot.
name = "Chatbot"
# Description of the app and chatbot. This is used for HTML tags.
# description = ""
# Large size content are by default collapsed for a cleaner ui
default_collapse_content = true
# The default value for the expand messages settings.
default_expand_messages = false
# Chain of Thought (CoT) display mode. Can be "hidden", "tool_call" or "full".
cot = "full"
# Link to your github repo. This will add a github button in the UI's header.
# github = ""
# Specify a CSS file that can be used to customize the user interface.
# The CSS file can be served from the public directory or via an external link.
# custom_css = "/public/test.css"
[UI.theme]
#layout = "wide"
#font_family = "Inter, sans-serif"
# Override default MUI light theme. (Check theme.ts)
[UI.theme.light]
#background = "#FAFAFA"
#paper = "#FFFFFF"
[UI.theme.light.primary]
#main = "#F80061"
#dark = "#980039"
#light = "#FFE7EB"
# Override default MUI dark theme. (Check theme.ts)
[UI.theme.dark]
#background = "#FAFAFA"
#paper = "#FFFFFF"
[UI.theme.dark.primary]
#main = "#F80061"
#dark = "#980039"
#light = "#FFE7EB"
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h-https://docs.chainlit.io/backend/command-lineh
Command Line Options - ChainlituhX2  Backend
Command Line Options
The Chainlit CLI (Command Line Interface) is a tool that allows you to interact with the Chainlit system via command line. It provides several commands to manage your Chainlit applications.
Commands
init
The init
command initializes a Chainlit project by creating a configuration file located at .chainlit/config.toml
chainlit init
run
The run
command starts a Chainlit application.
chainlit run [OPTIONS] TARGET
Options:
-w, --watch
: Reload the app when the module changes. When this option is specified, the file watcher will be started and any changes to files will cause the server to reload the app, allowing faster iterations.-h, --headless
: Prevents the app from opening in the browser.-d, --debug
: Sets the log level to debug. Default log level is error.-c, --ci
: Runs in CI mode.--no-cache
: Disables third parties cache, such as langchain.--host
: Specifies a different host to run the server on.--port
: Specifies a different port to run the server on.--root-path
: Specifies a subpath to run the server on.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/step-decoratorh
Step Decorator - ChainlituhXQ  Step Decorator
The step decorator will log steps based on the decorated function. By default, the arguments of the function will be used as the input of the step and the return value will be used as the output.
Under the hood, the step decorator is using the cl.Step class.
tool
steps will be displayed in the UI.Parameters
The name of the step. Default to the name of the decorated function.
The type of the step, useful for monitoring and debugging.
By default the step will be nested under the previous step/message. Set this
to True
to make it a root step.
Language of the output. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
By default only the output of the step is shown. Set this to True
to also
show the input. You can also set this to a language like json
or python
to
syntax highlight the input.
Access the Current step
You can access the current step object using cl.context.current_step
and override values.
import chainlit as cl
@cl.step
async def my_step():
current_step = cl.context.current_step
# Override the input of the step
current_step.input = "My custom input"
# Override the output of the step
current_step.output = "My custom output"
Stream the Output
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI(api_key="YOUR_API_KEY")
@cl.step(type="llm")
async def gpt4():
settings = {
"model": "gpt-4",
"temperature": 0,
}
stream = await client.chat.completions.create(
messages=message_history, stream=True, **settings
)
current_step = cl.context.current_step
async for part in stream:
delta = part.choices[0].delta
if delta.content:
# Stream the output of the step
await current_step.stream_token(delta.content)
Nest Steps
If another step decorated function is called inside the decorated function, the child step will be nested under the parent step.
import chainlit as cl
@cl.step
async def parent_step():
await child_step()
return "Parent step output"
@cl.step
async def child_step():
return "Child step output"
@cl.on_chat_start
async def main():
await parent_step()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h8https://docs.chainlit.io/api-reference/ask/ask-for-inputh
AskUserMessage - ChainlituhX  Ask User
AskUserMessage
Ask for the user input before continuing. If the user does not answer in time (see timeout), a TimeoutError will be raised or None will be returned depending on raise_on_timeout. If a project ID is configured, the messages will be uploaded to the cloud storage.
Attributes
content
str
The content of the message.
author
str
The author of the message, defaults to the chatbot name defined in your config.
timeout
int
The number of seconds to wait for an answer before raising a TimeoutError.
raise_on_timeout
bool
Whether to raise a socketio TimeoutError if the user does not answer in time.
Returns
response
Step
requiredThe response of the user.
Usage
import chainlit as cl
@cl.on_chat_start
async def main():
res = await cl.AskUserMessage(content="What is your name?", timeout=10).send()
if res:
await cl.Message(
content=f"Your name is: {res['output']}",
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h%https://docs.chainlit.io/deploy/slackh
Slack - ChainlituhX  Slack
To make your Chainlit app available on Slack, you will need to create a Slack app and set up the necessary environment variables.
How it Works
The Slack bot will listen to messages mentioning it in channels and direct messages. It will send replies to a dedicated thread or DM depending on the context.
Preview
Supported Features
Message | Streaming | Elements | Audio | Ask User | Chat History | Chat Profiles | Feedback |
---|---|---|---|---|---|---|---|
✅ | ❌ | ✅ | ❌ | ❌ | ✅ | ❌ | ✅ |
Install the Slack Bolt Library
The Slack Bolt library is not included in the Chainlit dependencies. You will have to install it manually.
pip install slack_bolt
Create a Slack App
To start, navigate to the Slack apps dashboard for the Slack API. Here, you should find a green button that says Create New App. When you click this button, select the option to create your app from scratch.
Create a name for your bot, such as “ChainlitDemo”. Select the workspace you would like your bot to exist in.
Create a Slack App
Working Locally
If you are working locally, you will have to expose your local Chainlit app to the internet to receive incoming messages to Slack. You can use ngrok for this.
ngrok http 8000
This will give you a public URL that you can use to set up the app manifest. Do not forget to replace it once you deploy Chainlit to a public host.
Set the App Manifest
Go to App Manifest and paste the following Yaml.
{placeholders}
with your own values.display_information:
name: { APP_NAME }
features:
bot_user:
display_name: { APP_NAME }
always_online: false
oauth_config:
scopes:
user:
- im:history
- channels:history
bot:
- app_mentions:read
- channels:read
- chat:write
- files:read
- files:write
- im:history
- im:read
- im:write
- users:read
- users:read.email
- channels:history
- groups:history
settings:
event_subscriptions:
request_url: https://{ CHAINLIT_APP_HOST }/slack/events
bot_events:
- app_home_opened
- app_mention
- message.im
interactivity:
is_enabled: true
request_url: https://{ CHAINLIT_APP_HOST }/slack/events
org_deploy_enabled: false
socket_mode_enabled: false
token_rotation_enabled: false
Click on Save Changes.
Set the App Manifest
You will see a warning stating that the URL is not verified. You can ignore this for now.
[Optional] Allow users to send DMs to Chainlit
By default the app will only listen to mentions in channels.
If you want to allow users to send direct messages to the app, go to App Home and enable “Allow users to send Slash commands and messages from the messages tab”.
Allow DMs
Install the Slack App to Your Workspace
Navigate to the Install App tab and click on Install to Workspace.
Set the Environment Variables
Bot Token
Once the slack application is installed, you will see the Bot User OAuth Token. Set this as an environment variable in your Chainlit app.
Copy the Bot Token
SLACK_BOT_TOKEN=your_bot_token
Signing Secret
Navigate to the Basic Information tab and copy the Signing Secret. Then set it as an environment variable in your Chainlit app.
Copy the Signing Secret
SLACK_SIGNING_SECRET=your_signing_secret
Start the Chainlit App
Since the Chainlit app is not running, the Slack app will not be able to communicate with it.
For the example, we will use this simple app:
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
# Access the original slack event
print(cl.user_session.get("slack_event"))
# Access the slack user
print(cl.user_session.get("user"))
# Access potential attached files
attached_files = msg.elements
await cl.Message(content="Hello World").send()
Reminder: Make sure the environment variables are set and that your local chainlit app is exposed to the internet via ngrok.
Start the Chainlit app:
chainlit run my_app.py -h
Using -h to not open the default Chainlit UI since we are using Slack.
You should now be able to interact with your Chainlit app through Slack.
Chat History
Chat history is directly available through the fetch_slack_message_history
method.
It will fetch the last messages from the current thread or DM channel.
import chainlit as cl
import discord
@cl.on_message
async def on_message(msg: cl.Message):
fetch_slack_message_history = cl.user_session.get("fetch_slack_message_history")
if fetch_slack_message_history:
print(await fetch_slack_message_history(limit=10))
# Your code herehhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/backend/config/featuresh
Features - ChainlituhX  Features
Options
Process and display HTML in messages. This can be a security risk (see https://stackoverflow.com/questions/19603097/why-is-it-dangerous-to-render-user-generated-html-or-javascript).
Allow the user to edit their messages.
Process and display mathematical expressions. This can clash with ”$” characters in messages.
Authorize users to upload files with messages. The files are then accessible in cl.on_message.
Restrict user to only upload accepted mime file types. Example: [“text/plain”, “application/pdf”, “image/x-png”]
Restrict user to upload maximum number of files at a time.
Restrict uploading file size (MB).
Threshold for audio recording.
If the user does not speak for this duration (MS), the recording will be ignored.
Delay for the user to continue speaking in MS. If the user stops speaking for this duration, the recording will stop.
Above this duration (MS), the recording will forcefully stop.
Duration of the audio chunks in MS.
Sample rate of the audio.
Automatically tag threads with the current chat profile (if a chat profile is used)
Default configuration
[features]
unsafe_allow_html = false
latex = false
[features.spontaneous_file_upload]
enabled = true
accept = ["*/*"]
max_files = 20
max_size_mb = 500
[features.audio]
min_decibels = -45
initial_silence_timeout = 3000
silence_timeout = 1500
max_duration = 15000
chunk_duration = 1000
sample_rate = 44100
auto_tag_thread = truehhuh(h	hh}ubh)}(h}(hNh	}(h6https://docs.chainlit.io/advanced-features/multi-modalh
Multi-Modality - ChainlituhX  Multi-Modality
The term ‘Multi-Modal’ refers to the ability to support more than just text, encompassing images, videos, audio and files.
Voice Assistant
Chainlit let’s you access the user’s microphone audio stream and process it in real-time. This can be used to create voice assistants, transcribe audio, or even process audio in real-time.
The user will only be able to use the microphone if you implemented the @cl.on_audio_chunk decorator.
Voice Assistant Example
Check the Audio Assistant cookbook example to see how to implement a voice assistant.
Audio capture settings
You can configure audio capture the au through the Chainlit config file.
Spontaneous File Uploads
Within the Chainlit application, users have the flexibility to attach any file to their messages. This can be achieved either by utilizing the drag and drop feature or by clicking on the attach
button located in the chat bar.
Attach files to a message
As a developer, you have the capability to access these attached files through the cl.on_message decorated function.
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
if not msg.elements:
await cl.Message(content="No file attached").send()
return
# Processing images exclusively
images = [file for file in msg.elements if "image" in file.mime]
# Read the first image
with open(images[0].path, "r") as f:
pass
await cl.Message(content=f"Received {len(images)} image(s)").send()
Image Processing with Transformers
Multi-modal capabilities are being added to Large Language Model (effectively making them Large Multi Modal Models). OpenAI’s vision API and the LLaVa cookbook are good places to start for image processing with transformers.
Disabling Spontaneous File Uploads
If you wish to disable this feature (which would prevent users from attaching files to their messages), you can do so by setting features.spontaneous_file_upload.enabled=false
in your Chainlit config file.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h)https://docs.chainlit.io/concepts/elementh
Element - ChainlituhXh	  Element
Text messages are the building blocks of a chatbot, but we often want to send more than just text to the user such as images, videos, and more.
That is where elements come in. Each element is a piece of content that can be attached to a Message or a Step and displayed on the user interface.
Text Element
Ideal to display RAG sources.
Image Element
Ideal to display generated images.
PDF Element
Ideal to display RAG sources.
More Elements
The complete list of elements you can display on the user interface.
Example
To attach an element to a message or step, we need to:
- Instantiate the element
- Attach the element to a message or step
import chainlit as cl
@cl.on_chat_start
async def start():
image = cl.Image(path="./cat.jpeg", name="image1", display="inline")
# Attach the image to the message
await cl.Message(
content="This message has an image!",
elements=[image],
).send()
Display Options
There are 3 display options that determine how an element is rendered:
Side
@cl.on_chat_start
async def start():
# Notice the display option
image = cl.Image(path="./cat.jpeg", name="cat image", display="side")
await cl.Message(
# Notice that the name of the image is referenced in the message content
content="Here is the cat image!",
elements=[image],
).send()
The image will not be displayed in the message. Instead, the name of the image will be displayed as clickable link. When the user clicks on the link, the image will be displayed on the side of the message.
Page
@cl.on_chat_start
async def start():
# Notice the display option
image = cl.Image(path="./cat.jpeg", name="cat image", display="page")
await cl.Message(
# Notice that the name of the image is referenced in the message content
content="Here is the cat image!",
elements=[image],
).send()
The image will not be displayed in the message. Instead, the name of the image will be displayed as clickable link. Clicking on the link will redirect to a dedicated page where the image will be displayed.
Inline
@cl.on_chat_start
async def start():
# Notice the display option
image = cl.Image(path="./cat.jpeg", name="cat image", display="inline")
await cl.Message(
# Notice that the name of the image is NOT referenced in the message content
content="Hello!",
elements=[image],
).send()
The image will be displayed below with the message regardless of whether the image name is referenced in the message content.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/advanced-features/streamingh
Streaming - ChainlituhX`  Advanced Features
Streaming
Chainlit supports streaming for both Message and Step. Here is an example with openai
.
Streaming OpenAI response
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI(api_key="YOUR_OPENAI_API_KEY")
settings = {
"model": "gpt-3.5-turbo",
"temperature": 0.7,
"max_tokens": 500,
"top_p": 1,
"frequency_penalty": 0,
"presence_penalty": 0,
}
@cl.on_chat_start
def start_chat():
cl.user_session.set(
"message_history",
[{"role": "system", "content": "You are a helpful assistant."}],
)
@cl.on_message
async def main(message: cl.Message):
message_history = cl.user_session.get("message_history")
message_history.append({"role": "user", "content": message.content})
msg = cl.Message(content="")
await msg.send()
stream = await client.chat.completions.create(
messages=message_history, stream=True, **settings
)
async for part in stream:
if token := part.choices[0].delta.content or "":
await msg.stream_token(token)
message_history.append({"role": "assistant", "content": msg.content})
await msg.update()
Integrations
Streaming is also supported at a higher level for some integrations.
For example, to use streaming with Langchain just pass streaming=True
when instantiating the LLM:
llm = OpenAI(temperature=0, streaming=True)
Also make sure to pass a callback handler to your chain or agent run.
See here for final answer streaming.hhuh(h	hh}ubh)}(h}(hNh	}(h9https://docs.chainlit.io/api-reference/input-widgets/tagsh
Tags - ChainlituhXw  Input Widgets
Tags
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
List[str]
The initial values of the input widget.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Tags
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Tags(id="StopSequence", label="OpenAI - StopSequence", initial=["Answer:"]),
]
).send()
value = settings["StopSequence"]hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/customisation/custom-cssh
CSS - ChainlituhXL  Customisation
CSS
Chainlit Application allows for design customization through the use of a custom CSS stylesheet. To enable this, modify your configuration settings in .chainlit/config.toml.
config.toml
[UI]
# ...
# This can either be a css file in your `public` dir or a URL
custom_css = '/public/stylesheet.css'
At the moment, we do not provide a detailed guide of all the available css classes. It is up to you to dig in the Web Inspector and find the css class you wish to override.
Once the configuration is updated, restart the application. Your custom styling will now be applied.hhuh(h	hh}ubh)}(h}(hNh	}(h6https://docs.chainlit.io/api-reference/elements/plotlyh
Plotly - ChainlituhX  Elements
Plotly
The Plotly
class allows you to display a Plotly chart in the chatbot UI. This class takes a Plotly figure.
The advantage of the Plotly
element over the Pyplot
element is that it’s interactive (the user can zoom on the chart for example).
Attributes
name
str
The name of the chart to be displayed in the UI.
display
ElementDisplay
Determines how the chart element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
size
ElementSize
Determines the size of the chart. Only works with display=“inline”. Choices are “small”, “medium” (default), or “large”.
figure
str
The plotly.graph_objects.Figure
instance that you want to display.
Example
import plotly.graph_objects as go
import chainlit as cl
@cl.on_chat_start
async def start():
fig = go.Figure(
data=[go.Bar(y=[2, 1, 3])],
layout_title_text="An example figure",
)
elements = [cl.Plotly(name="chart", figure=fig, display="inline")]
await cl.Message(content="This message has a chart", elements=elements).send()hhuh(h	hh}ubh)}(h}(hNh	}(hEhttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-audio-chunkh
on_audio_chunk - ChainlituhX  Life Cycle Hooks
on_audio_chunk
Hook to react to an incoming audio chunk from the user’s microphone.
Usage
from io import BytesIO
import chainlit as cl
@cl.on_audio_chunk
async def on_audio_chunk(chunk: cl.AudioChunk):
if chunk.isStart:
buffer = BytesIO()
# This is required for whisper to recognize the file type
buffer.name = f"input_audio.{chunk.mimeType.split('/')[1]}"
# Initialize the session for a new audio stream
cl.user_session.set("audio_buffer", buffer)
cl.user_session.set("audio_mime_type", chunk.mimeType)
# Write the chunks to a buffer and transcribe the whole audio at the end
cl.user_session.get("audio_buffer").write(chunk.data)
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/deploy/react-frontendh
React - ChainlituhX  Platforms
React
Chainlit allows you to create a custom frontend for your application, offering you the flexibility to design a unique user experience. By integrating your frontend with Chainlit’s backend, you can harness the full power of Chainlit’s features, including:
- Abstractions for easier development
- Monitoring and observability
- Seamless integrations with various tools
- Robust authentication mechanisms
- Support for multi-user environments
- Efficient data streaming capabilities
Custom React frontend
Learn how to integrate your custom React frontend with the Chainlit backend.
The @chainlit/react-client package is designed for integrating Chainlit applications with React. It offers several hooks and an API client for seamless connection and interaction.
Supported Features
Message | Streaming | Elements | Audio | Ask User | Chat History | Chat Profiles | Feedback |
---|---|---|---|---|---|---|---|
✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ | ✅ |hhuh(h	hh}ubh)}(h}(hNh	}(h2https://docs.chainlit.io/data-persistence/feedbackh
Human Feedback - ChainlituhX?  Human Feedback
Human feedback is a crucial part of developing your LLM app or agent.
It allows your users to provide direct feedback on the interaction, which can be used to improve the performance and accuracy of your system.
By enabling data persistence, each run triggered by a user input will be accompanied by thumbs up and thumbs down icons. Users can also add a text comment to their feedback for more detailed input.
Feedback with comment
Benefits
-
Dataset Creation: Feedback interactions implicitly generate valuable training data to improve the agent’s responses over time.
-
Accuracy Measurement: Feedback scores enable objective measurement and comparison of different agent versions, facilitating continuous model improvement.
-
User-Centric Development: Direct feedback promotes a user-centric approach, ensuring the model evolves to meet user needs and expectations.
-
Training and Fine-Tuning: Human feedback allows for direct model training and fine-tuning based on specific interactions.
How-to
To use human feedback, you first need to enable data persistence.
Human feedback
Conclusion
Human feedback is a powerful tool for improving the performance of your LLM app. By enabling data persistence and collecting feedback, you can create a dataset that can be used to improve the system’s accuracy.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/backend/config/overviewh
Overview - ChainlituhX  Config
Overview
The .chainlit/config.toml
file is created when you run chainlit run ...
or chainlit init
. It allows you to configure your Chainlit app and to enable/disable specific features.
It is composed of three sections:
The .chainlit/config.toml
file is created when you run chainlit run ...
or chainlit init
. It allows you to configure your Chainlit app and to enable/disable specific features.
It is composed of three sections:hhuh(h	hh}ubh)}(h}(hNh	}(h;https://docs.chainlit.io/api-reference/input-widgets/sliderh
Slider - ChainlituhX8  Input Widgets
Slider
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
initial
int
The initial value of the input widget.
min
int
The minimum permitted slider value. Defaults to 0.
max
int
The maximum permitted slider value. Defaults to 10.
step
int
The stepping interval of the slider. Defaults to 1.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Slider
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Slider(
id="Temperature",
label="OpenAI - Temperature",
initial=1,
min=0,
max=2,
step=0.1,
),
]
).send()
value = settings["Temperature"]hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/chat-profilesh
Chat Profiles - ChainlituhX  Chat
Chat Profiles
Decorator to define the list of chat profiles.
If authentication is enabled, you can access the user details to create the list of chat profiles conditionally.
The icon is optional.
Parameters
current_user
User
The message coming from the UI.
Usage
Simple example
import chainlit as cl
@cl.set_chat_profiles
async def chat_profile():
return [
cl.ChatProfile(
name="GPT-3.5",
markdown_description="The underlying LLM model is **GPT-3.5**.",
icon="https://picsum.photos/200",
),
cl.ChatProfile(
name="GPT-4",
markdown_description="The underlying LLM model is **GPT-4**.",
icon="https://picsum.photos/250",
),
]
@cl.on_chat_start
async def on_chat_start():
chat_profile = cl.user_session.get("chat_profile")
await cl.Message(
content=f"starting chat using the {chat_profile} chat profile"
).send()
With authentication
from typing import Optional
import chainlit as cl
@cl.set_chat_profiles
async def chat_profile(current_user: cl.User):
if current_user.metadata["role"] != "ADMIN":
return None
return [
cl.ChatProfile(
name="GPT-3.5",
markdown_description="The underlying LLM model is **GPT-3.5**, a *175B parameter model* trained on 410GB of text data.",
),
cl.ChatProfile(
name="GPT-4",
markdown_description="The underlying LLM model is **GPT-4**, a *1.5T parameter model* trained on 3.5TB of text data.",
icon="https://picsum.photos/250",
),
cl.ChatProfile(
name="GPT-5",
markdown_description="The underlying LLM model is **GPT-5**.",
icon="https://picsum.photos/200",
),
]
@cl.password_auth_callback
def auth_callback(username: str, password: str) -> Optional[cl.User]:
if (username, password) == ("admin", "admin"):
return cl.User(identifier="admin", metadata={"role": "ADMIN"})
else:
return None
@cl.on_chat_start
async def on_chat_start():
user = cl.user_session.get("user")
chat_profile = cl.user_session.get("chat_profile")
await cl.Message(
content=f"starting chat with {user.identifier} using the {chat_profile} chat profile"
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h2https://docs.chainlit.io/concepts/concepts/messageh
Overview - ChainlituhXr  Overview
Chainlit is an open-source Python package to build production ready Conversational AI.
Build Conversational AI with Chainlit
Key features
-
Build fast: Integrate seamlessly with an existing code base or start from scratch in minutes
-
Multi Platform: Write your assistant logic once, use everywhere
-
Data persistence: Collect, monitor and analyze data from your users
-
Visualize multi-steps reasoning: Understand the intermediary steps that produced an output at a glance
Integrations
Chainlit is compatible with all Python programs and libraries. That being said, it comes with a set of integrations with popular libraries and frameworks.
OpenAI
Learn how to explore your OpenAI calls in Chainlit.
OpenAI Assistant
Learn how to integrate your OpenAI Assistants with Chainlit.
Mistral AI
Learn how to use any Mistral AI calls in Chainlit.
Llama Index
Learn how to integrate your Llama Index code with Chainlit.
LangChain
Learn how to use any LangChain agent with Chainlit.
Autogen
Learn how to integrate your Autogen agents with Chainlit.
Haystack
Learn how to integrate your Haystack code with Chainlit.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h=https://docs.chainlit.io/api-reference/integrations/langchainh
%Langchain Callback Handler - ChainlituhX  Integrations
Langchain Callback Handler
The following code example demonstrates how to pass a callback handler:
llm = OpenAI(temperature=0)
llm_math = LLMMathChain.from_llm(llm=llm)
@cl.on_message
async def main(message: cl.Message):
res = await llm_math.acall(message.content, callbacks=[cl.LangchainCallbackHandler()])
await cl.Message(content="Hello").send()
Final Answer streaming
If streaming is enabled at the LLM level, Langchain will only stream the intermediate steps. You can enable final answer streaming by passing stream_final_answer=True
to the callback handler.
# Optionally, you can also pass the prefix tokens that will be used to identify the final answer
answer_prefix_tokens=["FINAL", "ANSWER"]
cl.LangchainCallbackHandler(
stream_final_answer=True,
answer_prefix_tokens=answer_prefix_tokens,
)
Final answer streaming will only work with prompts that have a consistent
final answer pattern. It will also not work with
AgentType.STRUCTURED_CHAT_ZERO_SHOT_REACT_DESCRIPTION
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/api-reference/make-asynch
make_async - ChainlituhX  Misceallaneous
make_async
The make_async
function takes a synchronous function (for instance a LangChain agent) and returns an asynchronous function that will run the original function in a separate thread.
This is useful to run long running synchronous tasks without blocking the event loop.
Parameters
func
Callable
The synchronous function to run in a separate thread.
Returns
async_function
Coroutine
requiredThe asynchronous function that will run the synchronous function in a separate thread.
Usage
import time
import chainlit as cl
def sync_func():
time.sleep(5)
return "Hello!"
@cl.on_message
async def main(message: cl.Message):
answer = await cl.make_async(sync_func)()
await cl.Message(
content=answer,
).send()
LangChain agent
import chainlit as cl
res = await cl.make_async(agent)(input_str, callbacks=[cl.LangchainCallbackHandler()])
await cl.Message(content=res["text"]).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h3https://docs.chainlit.io/advanced-features/ask-userh
Ask User - ChainlituhX  Advanced Features
Ask User
The ask APIs prompt the user for input. Depending on the API, the user input can be a string, a file, or pick an action.
Until the user provides an input, both the UI and your code will be blocked.
Ask File example
Available Ask APIs
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/integrations/haystackh
Haystack - ChainlituhX  Haystack
The current Haystack integration allows you to run chainlit apps and visualise intermediary steps. Playground capabilities will be added with the release of Haystack 2.0.
Haystack is an end-to-end NLP framework that enables you to build NLP applications powered by LLMs, Transformer models, vector search and more. Whether you want to perform question answering, answer generation, semantic document search, or build tools that are capable of complex decision making and query resolution, you can use the state-of-the-art NLP models with Haystack to build end-to-end NLP applications solving your use case. Check out their repo: https://github.com/deepset-ai/haystack.
A Haystack agent run with reasoning steps
Installation
pip install farm-haystack chainlit
Integration
Create a new Python file named app.py with the code below.
This code adds the Chainlit callback handler to the Haystack callback manager. The callback handler is responsible for listening to the chain’s intermediate steps and sending them to the UI.
Then, you can run chainlit run app.py
in your terminal to run the app and interact with your agent.
Example
Check out this full example from the cookbook: https://github.com/Chainlit/cookbook/tree/main/haystack
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h>https://docs.chainlit.io/customisation/custom-logo-and-faviconh
Logo and Favicon - ChainlituhX}  Logo and Favicon
You can customize the Chainlit application with your own logo and favicon.
Assets such as favicons and logos are cached by default by your browser. You might have to clear your browser cache to see the changes.
Use your Logo
Chainlit Application offers support for both dark and light modes. To accommodate this, prepare two versions of your logo, named logo_dark.png
and logo_light.png
. Place these logos in a /public
folder next to your application. Once you restart the application, your custom logos should be displayed accordingly.
Custom Logo Example
Practical example of how to use custom logos in your Chainlit application.
Use your Favicon
To further enhance branding, you can also update the application’s favicon. Place an image file named favicon
in the public
folder next to your application. After restarting the application, the new favicon will take effect.      hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/authentication/passwordh
Password - ChainlituhX=  Authentication
Password
The @cl.password_auth_callback
receives the username and password from the login form. Returning an cl.User
object will authenticate the user while returning None
will fail the authentication.
You can verify the credentials against any service that you’d like (your own DB, a private google sheet etc.).
The usual security best practices applies here, hash password before storing them.
Example
from typing import Optional
import chainlit as cl
@cl.password_auth_callback
def auth_callback(username: str, password: str):
# Fetch the user matching username from your database
# and compare the hashed password with the value stored in the database
if (username, password) == ("admin", "admin"):
return cl.User(
identifier="admin", metadata={"role": "admin", "provider": "credentials"}
)
else:
return Nonehhuh(h	hh}ubh)}(h}(hNh	}(h8https://docs.chainlit.io/advanced-features/chat-settingsh
Chat Settings - ChainlituhX  Advanced Features
Chat Settings
Chat settings are useful to let each user configure their chat experience given a set of options.
How it works
Check the chat settings API reference to learn how to configure it.
Preview
If chat settings are set, a new button will appear in the chat bar.
Clicking on this button will open the settings panel. All settings are editable by the user. Once settings are updated, an event is sent to the Chainlit server so the application can react to the update.
Chat Settings in Chainlit
Example
Check out this example from the cookbook that uses this feature: https://github.com/Chainlit/cookbook/tree/main/image-gen
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h&https://docs.chainlit.io/deploy/webapph
Web App - ChainlituhThe native Chainlit UI that is available on port 8000. Should open in your default browser when you run chainlit run.
chainlit run
Preview
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/elements/fileh
File - ChainlituhX  Elements
File
The File
class allows you to display a button that lets users download the content of the file.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the file. This will be shown to users.
url
str
The remote URL of the file image source.
path
str
The local file path of the file image.
content
bytes
The file content of the file image in bytes format.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
elements = [
cl.File(
name="hello.py",
path="./hello.py",
display="inline",
),
]
await cl.Message(
content="This message has a file element", elements=elements
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h1https://docs.chainlit.io/data-persistence/historyh
Chat History - ChainlituhX0  Data Persistence
Chat History
Chat history allow users to search and browse their past conversations.
How-to
To enable chat history, you need to enable:
Chat History
Resume a conversation
To let users continue persisted conversations, use cl.on_chat_resume.
Resuming a conversation
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/advanced-features/test-debugh
Testing & Debugging - ChainlituhX{  Advanced Features
Testing & Debugging
To test or debug your application files and decorated functions, you will need to provide the Chainlit context to your test suite.
In your main application script or test files add:
if __name__ == "__main__":
from chainlit.cli import run_chainlit
run_chainlit(__file__)
Then run the script from your IDE in debug mode.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h4https://docs.chainlit.io/api-reference/elements/texth
Text - ChainlituhX]  Text
The Text
class allows you to display a text element in the chatbot UI. This class takes a string and creates a text element that can be sent to the UI.
It supports the markdown syntax for formatting text.
You must provide either an url or a path or content bytes.
Attributes
The name of the text element to be displayed in the UI.
The text string or bytes that should be displayed as the content of the text element.
The remote URL of the text source.
The local file path of the text file.
Determines how the text element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
Language of the code if the text is a piece of code. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
text_content = "Hello, this is a text element."
elements = [
cl.Text(name="simple_text", content=text_content, display="inline")
]
await cl.Message(
content="Check out this text element!",
elements=elements,
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h&https://docs.chainlit.io/concepts/steph
Step - ChainlituhX<  Basic Concepts
Step
LLM powered Assistants take multiple steps to process a user’s request, forming a chain of thought. Unlike a Message, a Step has a type, an input/output and a start/end.
Depending on the config.ui.cot
setting, the full chain of thought can be displayed in full, hidden or only the tool calls.
In Literal AI, the full chain of thought is logged for debugging and replayability purposes.
A Simple Tool Calling Example
Lets take a simple example of a Chain of Thought that takes a user’s message, process it and sends a response.
import chainlit as cl
@cl.step(type="tool")
async def tool():
# Simulate a running task
await cl.sleep(2)
return "Response from the tool!"
@cl.on_message
async def main(message: cl.Message):
final_answer = await cl.Message(content="").send()
# Call the tool
tool_res = await tool()
# Send the final answer.
await cl.Message(content="This is the final answer").send()
Output of the code above
Step API
There are two ways to create steps, either by using the the @cl.step
decorator or by using the cl.Step
class.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h3https://docs.chainlit.io/integrations/message-basedh
&vLLM, LMStudio, HuggingFace - ChainlituhX  vLLM, LMStudio, HuggingFace
We can leverage the OpenAI instrumentation to log calls from inference servers that use messages-based API, such as vLLM, LMStudio or HuggingFace’s TGI.
You shouldn’t configure this integration if you’re already using another integration like Haystack, LangChain or LlamaIndex. Both integrations would record the same generation and create duplicate steps in the UI.
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
In app.py
, import the necessary packages and define one function to handle messages incoming from the UI.
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI(base_url="http://localhost:1234/v1", api_key="lm-studio")
# Instrument the OpenAI client
cl.instrument_openai()
settings = {
"model": "gpt-3.5-turbo",
"temperature": 0,
# ... more settings
}
@cl.on_message
async def on_message(message: cl.Message):
response = await client.chat.completions.create(
messages=[
{
"content": "You are a helpful bot, you always reply in Spanish",
"role": "system"
},
{
"content": input,
"role": "user"
}
],
**settings
)
await cl.Message(content=response.choices[0].message.content).send()
Create a file named .env
in the same folder as your app.py
file. Add your OpenAI API key in the OPENAI_API_KEY
variable. You can optionally add your Literal AI API key in the LITERAL_API_KEY
.
To start your app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h8https://docs.chainlit.io/api-reference/elements/tasklisth
TaskList - ChainlituhXW  Elements
TaskList
The TaskList
class allows you to display a task list next to the chatbot UI.
Attributes
status
str
The status of the TaskList. We suggest using something short like “Ready”, “Running…”, “Failed”, “Done”.
tasks
Task
The list of tasks to be displayed in the UI.
Usage
The TaskList element is slightly different from other elements in that it is not attached to a Message or Step but can be sent directly to the chat interface.
import chainlit as cl
@cl.on_chat_start
async def main():
# Create the TaskList
task_list = cl.TaskList()
task_list.status = "Running..."
# Create a task and put it in the running state
task1 = cl.Task(title="Processing data", status=cl.TaskStatus.RUNNING)
await task_list.add_task(task1)
# Create another task that is in the ready state
task2 = cl.Task(title="Performing calculations")
await task_list.add_task(task2)
# Optional: link a message to each task to allow task navigation in the chat history
message_id = await cl.Message(content="Started processing data").send()
task1.forId = message_id
# Update the task list in the interface
await task_list.send()
# Perform some action on your end
await cl.sleep(1)
# Update the task statuses
task1.status = cl.TaskStatus.DONE
task2.status = cl.TaskStatus.FAILED
task_list.status = "Failed"
await task_list.send()
Task List in action
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h,https://docs.chainlit.io/api-reference/cacheh
cache - ChainlituhX1  Misceallaneous
cache
The cache
decorator is a tool for caching results of resource-intensive calculations or loading processes. It can be conveniently combined with the file watcher to prevent resource reloading each time the application restarts. This not only saves time, but also enhances overall efficiency.
Parameters
func
Callable
The target function whose results need to be cached.
Returns
cached_value
Any
requiredThe computed value that is stored in the cache after its initial calculation.
Usage
import time
import chainlit as cl
@cl.cache
def to_cache():
time.sleep(5) # Simulate a time-consuming process
return "Hello!"
value = to_cache()
@cl.on_message
async def main(message: cl.Message):
await cl.Message(
content=value,
).send()
In this example, the to_cache
function simulates a time-consuming process that returns a value. By using the cl.cache
decorator, the result of the function is cached after its first execution. Future calls to the to_cache
function return the cached value without running the time-consuming process again.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(hChttps://docs.chainlit.io/api-reference/lifecycle-hooks/on-audio-endh
on_audio_end - ChainlituhX2  Life Cycle Hooks
on_audio_end
Hook to react to the end of an audio recording coming from the user’s microphone.
Usage
from io import BytesIO
import chainlit as cl
@cl.on_audio_end
async def on_audio_end(elements: list[ElementBased]):
# Get the audio buffer from the session
audio_buffer: BytesIO = cl.user_session.get("audio_buffer")
audio_buffer.seek(0) # Move the file pointer to the beginning
audio_file = audio_buffer.read()
audio_mime_type: str = cl.user_session.get("audio_mime_type")
# Apply Speech to Text or any other processing
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/authentication/headerh
Header - ChainlituhXA  Authentication
Header
Header auth is a simple way to authenticate users using a header. It is typically used to delegate authentication to a reverse proxy.
Example
from typing import Optional
import chainlit as cl
@cl.header_auth_callback
def header_auth_callback(headers: Dict) -> Optional[cl.User]:
# Verify the signature of a token in the header (ex: jwt token)
# or check that the value is matching a row from your database
if headers.get("test-header") == "test-value":
return cl.User(identifier="admin", metadata={"role": "admin", "provider": "header"})
else:
return Nonehhuh(h	hh}ubh)}(h}(hNh	}(h5https://docs.chainlit.io/api-reference/elements/videoh
Video - ChainlituhX  Elements
Video
The Video
class allows you to display an video player for a specific video file in the chatbot user interface.
You must provide either an url or a path or content bytes.
Attributes
name
str
The name of the video file to be displayed in the UI. This is shown to users.
display
ElementDisplay
Determines where the element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
url
str
The remote URL of the video.
path
str
The local file path of the video.
content
bytes
The file content of the video in bytes format.
Example
import chainlit as cl
@cl.on_chat_start
async def main():
elements = [
cl.Video(name="example.mp4", path="./example.mp4", display="inline"),
]
await cl.Message(
content="Here is an video file",
elements=elements,
).send()hhuh(h	hh}ubh)}(h}(hNh	}(h/https://docs.chainlit.io/api-reference/elementsh
Text - ChainlituhX]  Text
The Text
class allows you to display a text element in the chatbot UI. This class takes a string and creates a text element that can be sent to the UI.
It supports the markdown syntax for formatting text.
You must provide either an url or a path or content bytes.
Attributes
The name of the text element to be displayed in the UI.
The text string or bytes that should be displayed as the content of the text element.
The remote URL of the text source.
The local file path of the text file.
Determines how the text element should be displayed in the UI. Choices are “side” (default), “inline”, or “page”.
Language of the code if the text is a piece of code. See https://react-code-blocks-rajinwonderland.vercel.app/?path=/story/codeblock—supported-languages for a list of supported languages.
Example
import chainlit as cl
@cl.on_chat_start
async def start():
text_content = "Hello, this is a text element."
elements = [
cl.Text(name="simple_text", content=text_content, display="inline")
]
await cl.Message(
content="Check out this text element!",
elements=elements,
).send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h<https://docs.chainlit.io/api-reference/integrations/haystackh
Haystack - ChainlituhX  Haystack
The current Haystack integration allows you to run chainlit apps and visualise intermediary steps. Playground capabilities will be added with the release of Haystack 2.0.
Haystack is an end-to-end NLP framework that enables you to build NLP applications powered by LLMs, Transformer models, vector search and more. Whether you want to perform question answering, answer generation, semantic document search, or build tools that are capable of complex decision making and query resolution, you can use the state-of-the-art NLP models with Haystack to build end-to-end NLP applications solving your use case. Check out their repo: https://github.com/deepset-ai/haystack.
A Haystack agent run with reasoning steps
Installation
pip install farm-haystack chainlit
Integration
Create a new Python file named app.py with the code below.
This code adds the Chainlit callback handler to the Haystack callback manager. The callback handler is responsible for listening to the chain’s intermediate steps and sending them to the UI.
Then, you can run chainlit run app.py
in your terminal to run the app and interact with your agent.
Example
Check out this full example from the cookbook: https://github.com/Chainlit/cookbook/tree/main/haystack
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/integrations/embedchainh
Embedchain - ChainlituhX  Integrations
Embedchain
In this tutorial, we’ll walk through the steps to create a Chainlit application integrated with Embedchain.
Step 1: Create a Chainlit Application
In app.py
, import the necessary packages and define one function to handle a new chat session and another function to handle messages incoming from the UI.
With Embedchain
app.py
import chainlit as cl
from embedchain import Pipeline as App
import os
os.environ["OPENAI_API_KEY"] = "sk-xxx"
@cl.on_chat_start
async def on_chat_start():
app = App.from_config(config={
'app': {
'config': {
'name': 'chainlit-app'
}
},
'llm': {
'config': {
'stream': True,
}
}
})
# import your data here
app.add("https://www.forbes.com/profile/elon-musk/")
app.collect_metrics = False
cl.user_session.set("app", app)
@cl.on_message
async def on_message(message: cl.Message):
app = cl.user_session.get("app")
msg = cl.Message(content="")
for chunk in await cl.make_async(app.chat)(message.content):
await msg.stream_token(chunk)
await msg.send()
Step 2: Run the Application
To start your app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
Next Steps
Congratulations! You’ve just created your first LLM app with Chainlit and Embedchain.
Happy coding! 🎉
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h$https://docs.chainlit.io/examples/qah
Document QA - ChainlituhX  Examples
Document QA
In this example, we’re going to build an chatbot QA app. We’ll learn how to:
- Upload a document
- Create vector embeddings from a file
- Create a chatbot app with the ability to display sources used to generate an answer
This example is inspired from the LangChain doc
Prerequisites
This example has extra dependencies. You can install them with:
pip install langchain chromadb tiktoken
Then, you need to go to create an OpenAI key here.
The state of the union file is available here
Conversational Document QA with LangChain
qa.py
import os
from typing import List
from langchain.embeddings.openai import OpenAIEmbeddings
from langchain.text_splitter import RecursiveCharacterTextSplitter
from langchain.vectorstores import Chroma
from langchain.chains import (
ConversationalRetrievalChain,
)
from langchain.chat_models import ChatOpenAI
from langchain.docstore.document import Document
from langchain.memory import ChatMessageHistory, ConversationBufferMemory
import chainlit as cl
os.environ["OPENAI_API_KEY"] = "OPENAI_API_KEY"
text_splitter = RecursiveCharacterTextSplitter(chunk_size=1000, chunk_overlap=100)
@cl.on_chat_start
async def on_chat_start():
files = None
# Wait for the user to upload a file
while files == None:
files = await cl.AskFileMessage(
content="Please upload a text file to begin!",
accept=["text/plain"],
max_size_mb=20,
timeout=180,
).send()
file = files[0]
msg = cl.Message(content=f"Processing `{file.name}`...")
await msg.send()
with open(file.path, "r", encoding="utf-8") as f:
text = f.read()
# Split the text into chunks
texts = text_splitter.split_text(text)
# Create a metadata for each chunk
metadatas = [{"source": f"{i}-pl"} for i in range(len(texts))]
# Create a Chroma vector store
embeddings = OpenAIEmbeddings()
docsearch = await cl.make_async(Chroma.from_texts)(
texts, embeddings, metadatas=metadatas
)
message_history = ChatMessageHistory()
memory = ConversationBufferMemory(
memory_key="chat_history",
output_key="answer",
chat_memory=message_history,
return_messages=True,
)
# Create a chain that uses the Chroma vector store
chain = ConversationalRetrievalChain.from_llm(
ChatOpenAI(model_name="gpt-3.5-turbo", temperature=0, streaming=True),
chain_type="stuff",
retriever=docsearch.as_retriever(),
memory=memory,
return_source_documents=True,
)
# Let the user know that the system is ready
msg.content = f"Processing `{file.name}` done. You can now ask questions!"
await msg.update()
cl.user_session.set("chain", chain)
@cl.on_message
async def main(message: cl.Message):
chain = cl.user_session.get("chain") # type: ConversationalRetrievalChain
cb = cl.AsyncLangchainCallbackHandler()
res = await chain.acall(message.content, callbacks=[cb])
answer = res["answer"]
source_documents = res["source_documents"] # type: List[Document]
text_elements = [] # type: List[cl.Text]
if source_documents:
for source_idx, source_doc in enumerate(source_documents):
source_name = f"source_{source_idx}"
# Create the text element referenced in the message
text_elements.append(
cl.Text(content=source_doc.page_content, name=source_name, display="side")
)
source_names = [text_el.name for text_el in text_elements]
if source_names:
answer += f"\nSources: {', '.join(source_names)}"
else:
answer += "\nNo sources found"
await cl.Message(content=answer, elements=text_elements).send()
Try it out
chainlit run qa.py
You can then upload any .txt
file to the UI and ask questions about it.
If you are using state_of_the_union.txt
you can ask questions like What did the president say about Ketanji Brown Jackson?
.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h/https://docs.chainlit.io/backend/config/projecth
Project - ChainlituhX  Project
Options
enable_telemetry
bool
default: trueWhether to enable telemetry (default: true). No personal data is collected.
allow_origins
List[str]
default: ["*"]Authorized origins to access the app/copilot.
user_env
List[str]
default: []List of environment variables to be provided by each user to use the app.
session_timeout
int
default: 3600Duration (in seconds) during which the session is saved when the connection is lost
cache
bool
default: falseEnable third parties caching (e.g LangChain cache)
follow_symlink
bool
default: falseFollow symlink for asset mount (see https://github.com/Chainlit/chainlit/issues/317)
Default configuration
[project]
# Whether to enable telemetry (default: true). No personal data is collected.
enable_telemetry = true
# List of environment variables to be provided by each user to use the app.
user_env = []
# Duration (in seconds) during which the session is saved when the connection is lost
session_timeout = 3600
# Enable third parties caching (e.g LangChain cache)
cache = false
# Follow symlink for asset mount (see https://github.com/Chainlit/chainlit/issues/317)
# follow_symlink = false
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h'https://docs.chainlit.io/deploy/copiloth
Copilot - ChainlituhX  Copilot
Software Copilot are a new kind of assistant embedded in your app/product. They are designed to help users get the most out of your app by providing contextual guidance and take actions on their behalf.
Preview
Supported Features
Message | Streaming | Elements | Audio | Ask User | Chat History | Chat Profiles | Feedback |
---|---|---|---|---|---|---|---|
✅ | ✅ | ✅ | ✅ | ✅ | ❌ | ✅ | ✅ |
Embedding the Copilot
First, make sure your Chainlit server is running. Then, add the following script at the end of your website’s <body>
tag:
This example assumes your Chainlit server is running on
http://localhost:8000
<head>
<meta charset="utf-8" />
</head>
<body>
<!-- ... -->
<script src="http://localhost:8000/copilot/index.js"></script>
<script>
window.mountChainlitWidget({
chainlitServer: "http://localhost:8000",
});
</script>
</body>
Remember the HTML file has to be served by a server, opening it directly in your browser won’t work. You can use simple HTTP server for tests purpose.
That’s it! You should now see a floating button on the bottom right corner of your website. Clicking on it will open the Copilot.
Widget Configuration
The mountChainlitWidget
function accepts the following options:
export interface IWidgetConfig {
// URL of the Chainlit server
chainlitServer: string;
// Required if authentication is enabled on the server
accessToken?: string;
// Theme of the copilot
theme?: "light" | "dark";
// Font family to use. It is up to the website to load the font
fontFamily?: string;
// Custom styling to apply to the widget button
button?: {
// ID of the container element to mount the button to
containerId?: string;
// URL of the image to use as the button icon
imageUrl?: string;
style?: {
size?: string;
bgcolor?: string;
color?: string;
bgcolorHover?: string;
borderColor?: string;
borderWidth?: string;
borderStyle?: string;
borderRadius?: string;
boxShadow?: string;
};
};
}
Function Calling
The Copilot can call functions on your website. This is useful for taking actions on behalf of the user. For example, you can call a function to create a new document, or to open a modal.
First, create a CopilotFunction
in your Chainlit server:
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
if cl.context.session.client_type == "copilot":
fn = cl.CopilotFunction(name="test", args={"msg": msg.content})
res = await fn.acall()
await cl.Message(content=res).send()
Then, in your app/website, add the following event listener:
window.addEventListener("chainlit-call-fn", (e) => {
const { name, args, callback } = e.detail;
if (name === "test") {
console.log(name, args);
callback("You sent: " + args.msg);
}
});
As you can see, the event listener receives the function name, arguments, and a callback function. The callback function should be called with the result of the function call.
Send a Message
The Copilot can also send messages directly to the Chainlit server. This is useful for sending context information or user actions to the Chainlit server (like the user selected from cell A1 to B1 on a table).
First, update the @cl.on_message
decorated function to your Chainlit server:
import chainlit as cl
@cl.on_message
async def on_message(msg: cl.Message):
if cl.context.session.client_type == "copilot":
if msg.type == "system_message":
# do something with the message
return
fn = cl.CopilotFunction(name="test", args={"msg": msg.content})
res = await fn.acall()
await cl.Message(content=res).send()
Then, in your app/website, you can emit an event like this:
window.sendChainlitMessage({
type: "system_message",
output: "Hello World!",
});
Security
Cross Origin Resource Sharing (CORS)
By default, the Chainlit server accepts requests from any origin. This is useful for development, but not recommended for production.
To restrict the origins that can access the server (hence embed the copilot), set the allow_origins config field to a list of allowed origins.
Authentication
If you want to restrict access to the Copilot per user, you can enable authentication on the Chainlit server.
While the standalone Chainlit application handles the authentication process, the Copilot needs to be configured with an access token. This token is used to authenticate the user with the Chainlit server.
The host app/website is responsible for generating the token and passing it to the Copilot. Here are examples of how to generate the token in different languages:
You will need the CHAINLIT_AUTH_SECRET
you generated when configuring
authentication.hhuh(h	hh}ubh)}(h}(hNh	}(h;https://docs.chainlit.io/api-reference/input-widgets/selecth
Select - ChainlituhX  Input Widgets
Select
Attributes
id
str
The identifier used to retrieve the widget value from the settings.
label
str
The label of the input widget.
values
List[str]
Labels for the select options.
items
Dict[str, str]
Labels with corresponding values for the select options.
initial_value
int
The initial value of the input widget.
initial_index
int
Index of the initial value of the input widget. Can only be used in combination with ‘values’.
tooltip
str
The tooltip text shown when hovering over the tooltip icon next to the label.
description
str
The text displayed underneath the input widget.
Usage
Code Example
import chainlit as cl
from chainlit.input_widget import Select
@cl.on_chat_start
async def start():
settings = await cl.ChatSettings(
[
Select(
id="Model",
label="OpenAI - Model",
values=["gpt-3.5-turbo", "gpt-3.5-turbo-16k", "gpt-4", "gpt-4-32k"],
initial_index=0,
)
]
).send()
value = settings["Model"]
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h'https://docs.chainlit.io/authenticationh
Overview - ChainlituhXX  Authentication
Overview
Chainlit applications are public by default. To enable authentication and make your app private, you need to:
- Define a
CHAINLIT_AUTH_SECRET
environment variable. This is a secret string that is used to sign the authentication tokens. You can change it at any time, but it will log out all users. You can easily generate one usingchainlit create-secret
. - Add one or more authentication callbacks to your app:
Password Auth
Authenticate users with login/password.
OAuth
Authenticate users with your own OAuth app (like Google).
Header
Authenticate users based on a custom header.
Each callback take a different input and optionally return a cl.User
object. If the callback returns None
, the authentication is considered as failed.
Make sure each user has a unique identifier to prevent them from sharing their data.
Get the current authenticated user
You can access the current authenticated user through the User Session.
@cl.on_chat_start
async def on_chat_start():
app_user = cl.user_session.get("user")
await cl.Message(f"Hello {app_user.identifier}").send()
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h(https://docs.chainlit.io/concepts/actionh
Action - ChainlituhX  Basic Concepts
Action
Actions are a way to send clickable buttons to the user interface. Each action is attached to a Message and can be used to trigger a python function when the user clicks on it.
Create an action
Actions are sent to the UI through messages:
import chainlit as cl
@cl.on_chat_start
async def start():
# Sending an action button within a chatbot message
actions = [
cl.Action(name="action_button", value="example_value", description="Click me!")
]
await cl.Message(content="Interact with this action button:", actions=actions).send()
Define a Python Callback
To handle the user’s click on the action button, you need to define a callback function with the @cl.action_callback
decorator:
@cl.action_callback("action_button")
async def on_action(action: cl.Action):
print("The user clicked on the action button!")
return "Thank you for clicking on the action button!"
Action API
Learn how more about Actions.
Toaster
While an action is being processed, a toaster is displayed to the user. The toaster is a small notification that appears at the top right of the screen and indicates that the action is being processed.
If the action callback returns a string, the toaster will display it to the user once the action is processed.
Output of the code abovehhuh(h	hh}ubh)}(h}(hNh	}(h/https://docs.chainlit.io/integrations/langchainh
LangChain - ChainlituhX	  LangChain
In this tutorial, we’ll walk through the steps to create a Chainlit application integrated with LangChain.
Preview of what you will build
Prerequisites
Before getting started, make sure you have the following:
- A working installation of Chainlit
- The LangChain package installed
- An OpenAI API key
- Basic understanding of Python programming
Step 1: Create a Python file
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 2: Write the Application Logic
In app.py
, import the necessary packages and define one function to handle a new chat session and another function to handle messages incoming from the UI.
With Langchain Expression language (LCEL)
Let’s go through a small example.
If your agent/chain does not have an async implementation, fallback to the sync implementation.
This code sets up an instance of Runnable
with a custom ChatPromptTemplate
for each chat session. The Runnable
is invoked everytime a user sends a message to generate the response.
The callback handler is responsible for listening to the chain’s intermediate steps and sending them to the UI.
[Deprecated] With Legacy Chain Interface
This code sets up an instance of LLMChain
with a custom ChatPromptTemplate
for each chat session. The LLMChain
is invoked everytime a user sends a message to generate the response.
The callback handler is responsible for listening to the chain’s intermediate steps and sending them to the UI.
Step 3: Run the Application
To start your app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.
When using LangChain, prompts and completions are not cached by default. To
enable the cache, set the cache=true
in your chainlit config file.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h.https://docs.chainlit.io/concepts/user-sessionh
User Session - ChainlituhX
  User Session
The user session is designed to persist data in memory through the life cycle of a chat session. Each user session is unique to a user and a given chat session.
Why use the user session?
Let’s say you want to keep track of each chat session message count.
A naive implementation might look like this:
This example is for illustrative purposes only. It is not recommended to use this code in production.
import chainlit as cl
counter = 0
@cl.on_message
async def on_message(message: cl.Message):
global counter
counter += 1
await cl.Message(content=f"You sent {counter} message(s)!").send()
At first glance, this code seems to work. However, it has a major flaw. If two users are chatting with the bot at the same time, both users will increment the same counter
.
This is where the user session comes in. Let’s rewrite the above example using the user session:
import chainlit as cl
@cl.on_chat_start
def on_chat_start():
cl.user_session.set("counter", 0)
@cl.on_message
async def on_message(message: cl.Message):
counter = cl.user_session.get("counter")
counter += 1
cl.user_session.set("counter", counter)
await cl.Message(content=f"You sent {counter} message(s)!").send()
User Session Default Values
By default, Chainlit stores chat session related data in the user session.
The following keys are reserved for chat session related data:
The session id.
Only set if you are enabled Authentication. Contains the user object of the user that started this chat session.
Only relevant if you are using the Chat Profiles feature. Contains the chat profile selected by this user.
Only relevant if you are using the Chat Settings feature. Contains the chat settings given by this user.
Only relevant if you are using the user_env config. Contains the environment variables given by this user.hhuh(h	hh}ubh)}(h}(hNh	}(h,https://docs.chainlit.io/integrations/openaih
OpenAI - ChainlituhX=	  OpenAI
If you are using OpenAI assistants, check out the OpenAI Assistant example app.
The benefits of this integration is that you can see the OpenAI API calls in a step in the UI, and you can explore them in the prompt playground.
You will also get the full generation details (prompt, completion, tokens per second…) in your Literal AI dashboard, if your project is using Literal AI.
You need to add cl.instrument_openai()
after creating your OpenAI client.
You shouldn’t configure this integration if you’re already using another integration like Haystack, Langchain or LlamaIndex. Both integrations would record the same generation and create duplicate steps in the UI.
Prerequisites
Before getting started, make sure you have the following:
- A working installation of Chainlit
- The OpenAI package installed
- An OpenAI API key
- Basic understanding of Python programming
Step 1: Create a Python file
Create a new Python file named app.py
in your project directory. This file will contain the main logic for your LLM application.
Step 2: Write the Application Logic
In app.py
, import the necessary packages and define one function to handle messages incoming from the UI.
from openai import AsyncOpenAI
import chainlit as cl
client = AsyncOpenAI()
# Instrument the OpenAI client
cl.instrument_openai()
settings = {
"model": "gpt-3.5-turbo",
"temperature": 0,
# ... more settings
}
@cl.on_message
async def on_message(message: cl.Message):
response = await client.chat.completions.create(
messages=[
{
"content": "You are a helpful bot, you always reply in Spanish",
"role": "system"
},
{
"content": message.content,
"role": "user"
}
],
**settings
)
await cl.Message(content=response.choices[0].message.content).send()
Step 3: Fill the environment variables
Create a file named .env
in the same folder as your app.py
file. Add your OpenAI API key in the OPENAI_API_KEY
variable. You can optionally add your Literal AI API key in the LITERAL_API_KEY
.
Step 4: Run the Application
To start your app, open a terminal and navigate to the directory containing app.py
. Then run the following command:
chainlit run app.py -w
The -w
flag tells Chainlit to enable auto-reloading, so you don’t need to restart the server every time you make changes to your application. Your chatbot UI should now be accessible at http://localhost:8000.
Was this page helpful?hhuh(h	hh}ubh)}(h}(hNh	}(h0https://docs.chainlit.io/data-persistence/customh
Custom Data Layer - ChainlituhX  Custom Data Layer
Literal AI provides the simplest way to persist, analyze and monitor your data.
If you’re considering implementing a custom data layer, check out this example here for some inspiration.
Also, we would absolutely love to see a community-led open source data layer implementation and list it here. If you’re interested in contributing, please reach out to us on Discord.
You need to import you custom data layer in your chainlit app, and assign it to the data layer variable, like so:
import chainlit.data as cl_data
class CustomDataLayer(cl_data.BaseDataLayer):
# TODO: implement all methods from cl_data.BaseDataLayer
cl_data._data_layer = CustomDataLayer()
SQL alchemy data layer
This custom layer has been tested for PostgreSQL, however it should support more SQL databases thanks to the use of the SQL Alchemy database.
This data layer also supports the BaseStorageClient
that enables you to store your elements into Azure Blob Storage or AWS S3.
Here is the SQL used to create the schema for this data layer:
CREATE TABLE users (
"id" UUID PRIMARY KEY,
"identifier" TEXT NOT NULL UNIQUE,
"metadata" JSONB NOT NULL,
"createdAt" TEXT
);
CREATE TABLE IF NOT EXISTS threads (
"id" UUID PRIMARY KEY,
"createdAt" TEXT,
"name" TEXT,
"userId" UUID,
"userIdentifier" TEXT,
"tags" TEXT[],
"metadata" JSONB,
FOREIGN KEY ("userId") REFERENCES users("id") ON DELETE CASCADE
);
CREATE TABLE IF NOT EXISTS steps (
"id" UUID PRIMARY KEY,
"name" TEXT NOT NULL,
"type" TEXT NOT NULL,
"threadId" UUID NOT NULL,
"parentId" UUID,
"disableFeedback" BOOLEAN NOT NULL,
"streaming" BOOLEAN NOT NULL,
"waitForAnswer" BOOLEAN,
"isError" BOOLEAN,
"metadata" JSONB,
"tags" TEXT[],
"input" TEXT,
"output" TEXT,
"createdAt" TEXT,
"start" TEXT,
"end" TEXT,
"generation" JSONB,
"showInput" TEXT,
"language" TEXT,
"indent" INT
);
CREATE TABLE IF NOT EXISTS elements (
"id" UUID PRIMARY KEY,
"threadId" UUID,
"type" TEXT,
"url" TEXT,
"chainlitKey" TEXT,
"name" TEXT NOT NULL,
"display" TEXT,
"objectKey" TEXT,
"size" TEXT,
"page" INT,
"language" TEXT,
"forId" UUID,
"mime" TEXT
);
CREATE TABLE IF NOT EXISTS feedbacks (
"id" UUID PRIMARY KEY,
"forId" UUID NOT NULL,
"threadId" UUID NOT NULL,
"value" INT NOT NULL,
"comment" TEXT
);
Example
Here is an example of setting up this data layer on a PostgreSQL database with an Azure storage client. First install the required dependencies:
pip install asyncpg SQLAlchemy azure-identity azure-storage-file-datalake
Import the custom data layer and storage client, and set the cl_data._data_layer
variable at the beginning of your Chainlit app.
import chainlit.data as cl_data
from chainlit.data.sql_alchemy import SQLAlchemyDataLayer
from chainlit.data.storage_clients import AzureStorageClient
storage_client = AzureStorageClient(account_url="<your_account_url>", container="<your_container>")
cl_data._data_layer = SQLAlchemyDataLayer(conninfo="<your conninfo>", storage_provider=storage_client)
Note that you need to add +asyncpg
to the protocol in the conninfo
string so that it uses the asyncpg library.
DynamoDB data layer
This data layer also supports the BaseStorageClient
that enables you to store your elements into AWS S3 or Azure Blob Storage.
Example
Here is an example of setting up this data layer. First install boto3:
pip install boto3
Import the custom data layer and storage client, and set the cl_data._data_layer
variable at the beginning of your Chainlit app.
import chainlit.data as cl_data
from chainlit.data.dynamodb import DynamoDBDataLayer
from chainlit.data.storage_clients import S3StorageClient
storage_client = S3StorageClient(bucket="<Your Bucket>")
cl_data._data_layer = DynamoDBDataLayer(table_name="<Your Table>", storage_provider=storage_client)
Table structure
Here is the Cloudformation used to create the dynamo table:
{
"AWSTemplateFormatVersion": "2010-09-09",
"Resources": {
"DynamoDBTable": {
"Type": "AWS::DynamoDB::Table",
"Properties": {
"TableName": "<YOUR-TABLE-NAME>",
"AttributeDefinitions": [
{
"AttributeName": "PK",
"AttributeType": "S"
},
{
"AttributeName": "SK",
"AttributeType": "S"
},
{
"AttributeName": "UserThreadPK",
"AttributeType": "S"
},
{
"AttributeName": "UserThreadSK",
"AttributeType": "S"
}
],
"KeySchema": [
{
"AttributeName": "PK",
"KeyType": "HASH"
},
{
"AttributeName": "SK",
"KeyType": "RANGE"
}
],
"GlobalSecondaryIndexes": [
{
"IndexName": "UserThread",
"KeySchema": [
{
"AttributeName": "UserThreadPK",
"KeyType": "HASH"
},
{
"AttributeName": "UserThreadSK",
"KeyType": "RANGE"
}
],
"Projection": {
"ProjectionType": "INCLUDE",
"NonKeyAttributes": ["id", "name"]
}
}
],
"BillingMode": "PAY_PER_REQUEST"
}
}
}
}
Logging
DynamoDB data layer defines a child of chainlit logger.
import logging
from chainlit import logger
logger.getChild("DynamoDB").setLevel(logging.DEBUG)
Limitations
Filtering by positive/negative feedback is not supported.
The data layer methods are not async. Boto3 is not async and therefore the data layer uses non-async blocking io.
Design
This implementation uses Single Table Design. There are 4 different entity types in one table identified by the prefixes in PK & SK.
Here are the entity types:
type User = {
PK: "USER#{user.identifier}"
SK: "USER"
// ...PersistedUser
}
type Thread = {
PK: f"THREAD#{thread_id}"
SK: "THREAD"
// GSI: UserThread for querying in list_threads
UserThreadPK: f"USER#{user_id}"
UserThreadSK: f"TS#{ts}"
// ...ThreadDict
}
type Step = {
PK: f"THREAD#{threadId}"
SK: f"STEP#{stepId}"
// ...StepDict
// feedback is stored as part of step.
// NOTE: feedback.value is stored as Decimal in dynamo which is not json serializable
feedback?: Feedback
}
type Element = {
"PK": f"THREAD#{threadId}"
"SK": f"ELEMENT#{element.id}"
// ...ElementDict
}
How to implement a custom data layer?
Follow the reference for an exhaustive list of the methods your custom data layer needs to implement.
Was this page helpful?hhuh(h	hh}ube.