defmodule CodeComparison.Application do
  # See https://hexdocs.pm/elixir/Application.html
  # for more information on OTP Applications
  @moduledoc false

  use Application

  def start(_type, _args) do
    children = [
      {Phoenix.PubSub, name: CodeComparison.PubSub},
      CodeComparisonWeb.Endpoint
    ]

    opts = [strategy: :one_for_one, name: CodeComparison.Supervisor]
    Supervisor.start_link(children, opts)
  end

  def config_change(changed, _new, removed) do
    CodeComparisonWeb.Endpoint.config_change(changed, removed)
    :ok
  end
end
