<h1>Excel to Google Form Automation</h1>


Overview
This UiPath project automates the process of extracting data from an Excel sheet and filling out a Google Form with the extracted information. The automation eliminates manual data entry tasks, saving time and reducing errors.

Features
Extract Data: Automatically retrieve data from an Excel sheet.
Fill Google Form: Input the extracted data into corresponding fields in a Google Form.
Robust and Efficient: Utilizes UiPath's automation capabilities to streamline data entry processes.


Requirements
UiPath Studio: Ensure you have UiPath Studio installed on your system.
Excel File: Prepare an Excel file containing the data to be entered into the Google Form.
Google Account: Access to a Google account with permissions to fill out the target Google Form.


Usage
Open the Project: Open the project in UiPath Studio.
Run the Project: Click on the "Run" button in UiPath Studio to execute the automation.
Input Excel File Path: Provide the file path to the Excel sheet containing the data.
Wait for Execution: The automation will extract data from the Excel sheet and input it into the corresponding fields in the Google Form.


Project Structure
Main.xaml: The main workflow containing the automation logic.
Config.xlsx: Excel file for storing configuration data (e.g., file paths).
README.md: Documentation file providing instructions and information about the project.


Troubleshooting
Ensure that the Excel file path provided is correct and accessible.
Verify that the Google Form fields and selectors used in the automation are accurate and up-to-date.
Handle any potential errors or exceptions gracefully within the workflow.
