---
title: "Themes"
description: "Change the look and feel of your site with Blog-Doc's themes."
---

# Themes

Customize the look and feel of your site by switching between different themes available in Blog-Doc.

Blog-Doc includes:

-   **Default Theme**: Based on the [Responsive Side Menu Layout from Pure.css](https://purecss.io/layouts/side-menu/)
-   **Clean Blog Theme**: Inspired by the [Clean Blog](https://startbootstrap.com/theme/clean-blog) theme from [Start Bootstrap](https://startbootstrap.com/)

## How to Modify the Active Theme

Follow these steps to change the active theme for your site:

1. **Select a Theme**:

    - Select the theme you want to activate on the frontend by clicking its corresponding thumbnail.

2. **Save Your Selection**:

    - Click the "Activate Selected Theme" button to apply and save your chosen theme.

3. **Preview the Changes**:
    - Visit your site’s frontend to review how it appears with the newly selected theme.

## Adding New Themes

More themes will be added to Blog-Doc in the future. If you’ve created a theme for Blog-Doc and want it to be included in the list of available themes, please share it in the [Ideas](https://github.com/LebCit/blog-doc/discussions/categories/ideas) section of the Blog-Doc repository on GitHub.

**Important**: Blog-Doc themes must use plain JavaScript only and should not include any code or images with publishing or distribution restrictions.
