---
title: Site Settings
description: Change your site settings
---

# Site Settings Interface

The site settings interface allows you to customize various elements of your site to meet your specific needs.<br>
**Important**: All fields marked with an asterisk \* are mandatory/required!<br>
After making your changes, click the "Update Site Settings" button. Then, navigate to the frontend of your site to view and verify the updates.

## Available Settings

### Site Title

-   **Description**: The name of your site.
-   **Usage**: Displayed in the browser title bar and in search engine results.

### Site Description

-   **Description**: A tagline describing what your site is about.
-   **Usage**: Often displayed below the site title, depending on the theme structure.

### Site URL

-   **Description**: The URL of your site once it is online.
-   **Important**: The URL must end with a slash `/`.

### Site Favicon

-   **Description**: A small image representing your site, often a smaller version of your site's logo.
-   **Usage**: Displayed in the browser tab and bookmarks.

### Posts Per Page

-   **Description**: Choose how many posts should be rendered on each page of the blog.
-   **Usage**: Helps manage the display of content for better user experience and site performance.

### Post Preview Fallback Image

-   **Description**: If a post has no image, this fallback image will be displayed.
-   **Usage**: Ensures a consistent visual presentation for posts without images.

### Search Feature

-   **Description**: Enable or disable the search feature on your site.
-   **Usage**: Allows visitors to search for content on your site. **Only in Node.js app for now!**

### Footer Copyright

-   **Description**: Change the copyright information displayed in your site's footer.
-   **Usage**: Important for legal and branding purposes.
-   **Important**: HTML attributes MUST be single quoted otherwise your app will break!

### RSS Site Language

-   **Description**: Define the [main language of your site for RSS feeds](https://www.rssboard.org/rss-language-codes).
-   **Usage**: Ensures RSS feed readers display the correct language settings.

### RSS Copyright

-   **Description**: Add copyright information to your RSS feed.
-   **Usage**: Protects your content and informs users of their rights regarding your feed.
