---
title: "Menu"
description: "Create, delete, and reorder menu items."
---

# Menu Management Interface

The menu settings interface allows you to create new menu items, delete existing ones, and reorder them according to your preferences.

## Creating a New Menu Item

1. Click the **"Add Item"** button.
2. A new menu item will appear.
3. Each menu item is a dropdown with fields for the link title and link target.
4. Fill in the desired link title and link target.

## Modifying an Existing Menu Item

-   Each menu item is displayed as a dropdown containing its title and target.
-   You can modify the link title and target at any time by editing the respective fields in the dropdown.

## Reordering Menu Items

-   To reorder a menu item, drag it by its handle ☰ to the desired position.

## Deleting a Menu Item

-   To delete a menu item, click the **"Remove"** button available within the item's dropdown. A modal will appear to confirm the deletion of the menu item. Please note that once deleted, the item will no longer be available after saving the menu.

## Saving Changes

-   Once you’ve made your changes, click the **"Save Menu"** button to apply and save your modifications.
-   **Note:** All link titles and link targets must be filled out. If any titles or links are empty, an alert modal will be displayed, indicating that some fields are incomplete. This will prevent the menu from being saved until all fields are properly filled out.

## Useful links

-   The link target to the frontend homepage is `/`
-   The link target to the archive of posts is `posts`
-   The link target to the list of tags is `tags`
-   The link target to a tag is `tags/the-tag-name`
-   The link target to the search page is `search`
-   The link target to a page is `pages/the-page-title-in-lowercase`
-   The link target to a post is `posts/the-post-title-in-lowercase`
-   To reach an external link, just paste its link in the "Link Target" field

## Viewing Updated Menu

-   To view your updated menu, simply visit the frontend of your site.
