---
title: "What is Blog-Doc?"
description: "A brief introduction to Blog-Doc"
publish_date: 2022-09-30
tags: [Blog-Doc]
published: true
---

Blog-Doc is **the simplest Node.js CMS & SSG** around! With Blog-Doc, you can easily Create, Read, Update, and Delete (CRUD) content through its intuitive [administration interface](/bd-admin). Plus, it transforms your content into a static site using its Static Site Generator (SSG) feature!

Written in JavaScript ES6, Blog-Doc includes the `default`, `clean-blog` and `midday` themes that use [STE](https://litenode.pages.dev/docs/rendering-templates/) as a template engine and Markdown for formatting posts and pages.

<h2>Motivation</h2>

In July 2022, I posted a series on [my personal blog](https://lebcit.github.io/) about creating a Node.js app using [EJS](https://ejs.co/) and improving it. I demonstrated how to use Markdown for content and eventually how to build a simple SSG. To build on that, I decided to create a super simple CMS & SSG from my own tutorials.

<h2>Name, Design & Architecture</h2>

From the start, I aimed for something extremely easy to maintain and enhance. I asked myself two key questions:

-   What’s the purpose of this application?
-   How can it stand out in the crowded CMS and SSG landscape?

The answers emerged from a third question:

-   What do we use the internet for?

Aside from personal communication, entertainment, and shopping, the primary use of the web is to access information. We search, read, and take notes. The web is a platform for sharing knowledge, and blogging and documentation are crucial for that. That’s why I named it **Blog-Doc**.

With the purpose clear, I focused on the app’s design. Simplicity was key. The [Pure.css](https://purecss.io/) documentation was a great example of clean, straightforward design, which was a lucky find!

Finally, designing the app’s architecture required careful planning for future growth. While the possibilities are endless, defining essential functionalities and how they interact helps clarify the development path.

That’s all for now! I’ll dive deeper into the design and architecture in upcoming posts.

See you next time 😉