---
title: "The New Blog-Doc"
description: "A tiny flame in the darkness of error"
featuredImage: "/static/images/tiny-flame.avif"
publish_date: 2023-07-26
tags: [Blog-Doc, LiteNode, Marked]
published: true
---

In the vast landscape of Node.js apps, Blog-Doc shines as a tiny flame in the darkness of error.  
It is a remarkable and unique combination of a Content Management System (CMS) and a Static Site Generator (SSG) built entirely with Node.js.<br/>
While paying homage to the developers of other Node.js-based Static Site Generators, Blog-Doc sets itself apart by offering unparalleled simplicity and speed.

Blog-Doc's latest version proudly employs:

-   [LiteNode](https://litenode.pages.dev/): Fast, lightweight, and independent Node.js web framework.
-   [Marked](https://marked.js.org/): Markdown parser and compiler. Built for speed.

<h2>Motivation & Purpose</h2>

Blog-Doc was born out of a desire to create something truly efficient and straightforward.<br/>
I've realized that existing Static Site Generators often came with unnecessary complexities, resembling gasworks more than elegant solutions.<br/>
Blog-Doc is a passionate response to this challenge, aiming to provide a seamless experience for developers who seek a lightweight, fast, and user-friendly CMS and SSG.

<h2>Blazing Fast and Simple</h2>

Blog-Doc truly lives up to its name, offering blazing-fast performance and an incredibly simple configuration.<br/>
With zero code required for configuration, Blog-Doc can be effortlessly set up as both a Node.js CMS and a static site generator.<br/>
Its minimalist approach ensures that your site loads in the blink of an eye, free from any unnecessary functionalities.

<h2>Design</h2>

Blog-Doc boasts a responsive, elegant, and simple layout. It comes with a ready-to-use template for blogs and documentation, which can be easily customized to suit different designs.

<h2 id="features">Features</h2>

Blog-Doc is packed with a variety of powerful features, making it a versatile and practical tool for developers:

-   Front-end Administration: Easily manage your app directly from the admin interface.
-   Gallery: Conveniently upload and manage images for your pages and posts.
-   Content Management: Create, read, update, and delete pages and posts with ease.
-   Paginated Blog: Enjoy a paginated blog with a customizable number of posts per page.
-   Markdown Support: Write your content using Markdown for a smooth and efficient writing experience.
-   HTML Support: Blog-Doc allows the use of HTML within Markdown for greater flexibility.
-   Tags: Organize your content with tags for easy navigation and categorization.
-   Featured Images: Assign featured images to your posts and pages for visual appeal.
-   Archive and Tags List: Benefit from archive and tags list routes for convenient browsing.
-   Titles & Meta Descriptions: Customize titles and meta descriptions for better SEO.
-   Drag and Drop Menu: Easily reorder menu links with a simple drag-and-drop interface.
-   RSS Feed: Generate an RSS feed for your site to keep your audience updated.
-   Sitemap: Automatically generate a sitemap to enhance search engine discoverability.
-   Built-in Search: Enjoy a built-in search feature for quick content retrieval. **Only in Node.js app for now!**
-   Code Highlighting: Utilize highlight.js for elegant code highlighting in your pages and posts.
-   IDs for Headings: Automatically generate IDs for heading tags for easier linking.
-   No Hot Reloading: Blog-Doc operates without the need for hot reloading during development.

<h2>What's Next?</h2>

I have exciting plans for future improvements.<br/>
The app will continue to evolve and receive updates, it's my personal contribution to the Node.js and Markdown communities.<br/>
Feedback, ideas, and suggestions from the community are warmly welcomed, and Blog-Doc invites developers to explore its potential and customize it for various projects.

<h2>Conclusion</h2>

Blog-Doc is a remarkable achievement in the world of Node.js CMS and SSGs.<br/>
Its simplicity, speed, and powerful features make it a standout choice for developers seeking a lightweight and efficient solution.<br/>
Whether used as a CMS on a Node.js server or deployed as a static site, Blog-Doc promises an enjoyable and productive experience.

Built with love and passion by [LebCit](https://lebcit.github.io/), Blog-Doc stands as a testament to the boundless possibilities of Node.js and Markdown.<br/>
Embrace the simplicity and embark on a journey of creating delightful content with Blog-Doc.

Happy coding!