# Recommended
Find below our recommended software solutions tailored to your needs. Please note that while we strive to offer the best suggestions, individual preferences may vary.

**Note:** Some software is outdated and are no longer being actively developed. They may still be useful, but they aren't supported and most likely contain security vulnerabilities, like Log4Shell, besides worse performance and compatibility. It's advisable to use newer, more efficient versions.

### 🍦 Minecraft Vanilla
- For a pure Minecraft experience without modifications, opt for the [Vanilla](java/VANILLA.md#-vanilla) server.
- Enhance your Vanilla experience with bug fixes, settings, and better performance by using [Fabric](java/MODS.md#-fabric) along with either the [Carpet](https://www.curseforge.com/minecraft/mc-mods/carpet) or [Lithium](https://www.curseforge.com/minecraft/mc-mods/lithium) mod.

### 🚰 Minecraft Vanilla with Plugins
- For servers running version **1.19+**, consider using [Paper](java/PLUGINS.md#-paper), [Pufferfish](java/PLUGINS.md#-pufferfish), or [Purpur](java/PLUGINS.md#-purpur).
- For servers operating on versions **1.8-1.18**, utilize [Paper Legacy](java/PLUGINS.md#-paper).
- For servers running version **1.7.10**, opt for [PaperSpigot](java/PLUGINS.md#-paper).
- For **Beta 1.7.3**, use [Canyon](java/PLUGINS.md#-canyon).

### 🔨 Minecraft with Mods
- Incorporate mods into your server using either [NeoForge](java/MODS.md#-neoforge), [Forge](java/MODS.md#-forge), [Fabric](java/MODS.md#-fabric) or [Quilt](java/MODS.md#-quiltmc), depending on your mod preferences.

### 🔮 Minecraft with Mods and Plugins
- For servers running **1.20.2-1.20.4**, explore [Ketting](java/MODS+PLUGINS.md#-ketting) (Development version).
- Servers on **1.19.2/1.19.4** can utilize [Arclight](java/MODS+PLUGINS.md#-arclight).
- For **1.18.2**, consider [Magma Maintained](java/MODS+PLUGINS.md#-magma-maintained).
- Servers running **1.16.5** can use either [Mohist](java/MODS+PLUGINS.md#-mohist) or [Arclight](java/MODS+PLUGINS.md#-arclight).
- Utilize [CatServer](java/MODS+PLUGINS.md#-catserver) for **1.12.2** servers.
- For **1.7.10**, consider [Crucible](java/MODS+PLUGINS.md#-crucible).
- Fabric mod and plugin integration can be achieved with [Banner](java/MODS+PLUGINS.md#-banner) or [Cardboard](java/MODS+PLUGINS.md#-cardboard).

### 🪨 Minecraft Bedrock
- For a pure Minecraft experience without modifications, opt for the [Vanilla](bedrock/VANILLA.md#-vanilla--bedrock-dedicated-server-) server.
- Create a Minecraft Bedrock Server with plugins using Spigot or Paper along with [Geyser](OTHERS.md#-geysermc).

### 🌐 Minecraft Networks
- Connect multiple Java Edition servers using [Velocity](java/PROXIES.md#-velocity).
- Connect multiple Bedrock Edition servers using [WaterdogPE](bedrock/PROXIES.md#-waterdogpe).
