# Mastering Test-Driven Development

> Test-driven development is a software development process that relies on the repetition of a very short development cycle: requirements are turned into very specific test cases, then the software is improved to pass the new tests, only.

## Important Notions

- 📖 [What are Unit Testing, Integration Testing and Functional Testing?](https://codeutopia.net/blog/2015/04/11/what-are-unit-testing-integration-testing-and-functional-testing/)

- 📖 [What’s the difference between Unit Testing, TDD and BDD?](https://codeutopia.net/blog/2015/03/01/unit-testing-tdd-and-bdd/)

- 📖 [Testing Pyramid](http://www.agilenutshell.com/episodes/41-testing-pyramid)

- 📖 [Types of software Testing](http://www.softwaretestinghelp.com/types-of-software-testing/)

- 📺 [What is code coverage?](https://www.youtube.com/watch?v=uDmdlmdVhL8)

## Mocha & Chai

- [Quick Introduction: Mocha, Chai and Chai-http Test Express API Auth Endpoints](https://blog.khophi.co/mocha-chai-chai-http-test-express-api-auth-endpoints/)

## Mocking

- [Node.js Tests: Mocking HTTP Requests](https://scotch.io/tutorials/nodejs-tests-mocking-http-requests)

- [Mocking External HTTP Requests in Node Tests with Nock](https://semaphoreci.com/community/tutorials/mocking-external-http-requests-in-node-tests-with-nock)
