# Mastering Puppeteer

> Puppeteer is a Node library which provides a high-level API to control Chrome or Chromium over the DevTools Protocol. Puppeteer runs headless by default, but can be configured to run full (non-headless) Chrome or Chromium.

## Anonymity, Proxies & Privacy

- 📖 [Using a proxy in Puppeteer](https://docs.browserless.io/docs/using-a-proxy.html)

- 📖 [How to use a proxy in Puppeteer](https://blog.scrapinghub.com/how-to-use-a-proxy-in-puppeteer)

- 📖 [Running Puppeteer with Tor](https://medium.com/@jsilvax/running-puppeteer-with-tor-45cc449e5672)

- 📖 [Anonymous Web Scraping with Node.js, Tor, Puppeteer and cheerio](https://levelup.gitconnected.com/anonymous-web-scrapping-with-node-js-tor-apify-and-cheerio-3b36ec6a45dc)

## Captchas

- 📖 [Bypassing CAPTCHAs with Headless Chrome](https://medium.com/@jsoverson/bypassing-captchas-with-headless-chrome-93f294518337)

- 🛠 [2Captcha](https://2captcha.com/)

- 🛠 [Death by Captcha](https://www.deathbycaptcha.com/)

- 🛠 [Best Captcha Solver](https://bestcaptchasolver.com/)

- 🛠 [AZ Captcha](https://azcaptcha.com/)

## Performance

- 📖 [Disabling JavaScript Using Puppeteer](https://webkul.com/blog/disabling-javascript-using-puppeteer/)

## Scrapping

- 📺 [Web Scraping Tutorial - How to Scrape Modern Websites for Data](https://www.youtube.com/watch?v=vsmxMLmroyQ)

- 📺 [Web Scraping with Node.js & Puppeteer (🌋 rants included, no extra charge)](https://www.youtube.com/watch?v=pixfH6yyqZk)

- 📺 [A Guide to Web Scraping with Node.js](https://www.youtube.com/watch?v=dXjKh66BR2U)

## Things to know

- 📖 [Load vs network-idle](https://github.com/puppeteer/puppeteer/issues/1666#issuecomment-354224942)
