# Mastering MySQL

> MySQL is an open-source relational database management system. Its name is a combination of "My", the name of co-founder Michael Widenius's daughter, and "SQL", the abbreviation for Structured Query Language.

## Installation

- 📖 [How To Install the Latest MySQL on Ubuntu 18.04](https://www.digitalocean.com/community/tutorials/how-to-install-the-latest-mysql-on-ubuntu-18-04)

- 📖 [How To Move a MySQL Data Directory to a New Location on Ubuntu 16.04](https://www.digitalocean.com/community/tutorials/how-to-move-a-mysql-data-directory-to-a-new-location-on-ubuntu-16-04)

## Tools

- 🛠 [TablePlus](https://tableplus.com/)

- 🛠 [SimpleBackups](https://simplebackups.io/)

## Types

- 📺 [MySQL ENUM](https://www.youtube.com/watch?v=dp6eD1yoA-k)

## Joins

- 📺 [SQL Joins Tutorial for Beginners - Inner Join, Left Join, Right Join, Full Outer Join](https://www.youtube.com/watch?v=2HVMiPPuPIM)

## Query

- ❓ [What's the difference between '!=' and '<>' in mysql?](https://stackoverflow.com/questions/7040305/whats-the-difference-between-and-in-mysql)

## Performance

- 📖 [High-speed inserts with MySQL](https://medium.com/@benmorel/high-speed-inserts-with-mysql-9d3dcd76f723)

- ❓ [Optimizing MySQL LIKE '%string%' queries in innoDB](https://stackoverflow.com/questions/10354248/optimizing-mysql-like-string-queries-in-innodb)

- ❓ [Why does MYSQL higher LIMIT offset slow the query down?](https://stackoverflow.com/questions/4481388/why-does-mysql-higher-limit-offset-slow-the-query-down)

## Things to know

- 📺 [7 Database Paradigms](https://www.youtube.com/watch?v=W2Z7fbCLSTw)

- 📖 [Understanding Managed Databases](https://www.digitalocean.com/community/tutorials/understanding-managed-databases)

- 📖 [PostgreSQL vs. MySQL](https://www.postgresqltutorial.com/postgresql-vs-mysql/)

- 📖 [How to get the database size in MySQL?](https://tableplus.com/blog/2018/08/mysql-how-to-get-the-size-of-mysql-database.html)

- 📖 [Uninstall or Completely remove mysql from ubuntu](https://linuxscriptshub.com/uninstall-completely-remove-mysql-ubuntu-16-04/)

- 📖 [How To Allow Remote Access to MySQL](https://www.digitalocean.com/community/tutorials/how-to-allow-remote-access-to-mysql)

- ❓ [How to mysqldump a remote database from my local machine](https://stackoverflow.com/questions/2989724/how-to-mysqldump-remote-db-from-local-machine)

## Transaction

- 📖 [MySQL Transaction](https://www.mysqltutorial.org/mysql-transaction.aspx/)
