# Mastering Git & Github

> Git is a version-control system for tracking changes in computer files and coordinating work on those files among multiple people. It is primarily used for source-code management in software development, but it can be used to keep track of changes in any set of files.

## Before you start

- 📖 [Got 15 minutes and want to learn Git?](https://try.github.io/levels/1/challenges/1)

## Important Notions

- 📖 [Understanding the GitHub Flow](https://guides.github.com/introduction/flow/index.html)

- 📖 [Git Branching - Basic Branching and Merging](https://git-scm.com/book/en/v2/Git-Branching-Basic-Branching-and-Merging)

- 📺 [Git MERGE vs REBASE](https://www.youtube.com/watch?v=CRlGDDprdOQ)

- 📖 [An introduction to Git merge and rebase: what they are, and how to use them](https://www.freecodecamp.org/news/an-introduction-to-git-merge-and-rebase-what-they-are-and-how-to-use-them-131b863785f/)

- 📺 [The STASH Command](https://www.youtube.com/watch?v=DeU6opFU_zw)

## Branches

- 📖 [How to Delete a Git Branch Both Locally and Remotely](https://www.freecodecamp.org/news/how-to-delete-a-git-branch-both-locally-and-remotely/)

## Cool tricks

- 📖 [Run npm scripts in a git pre-commit Hook](https://elijahmanor.com/npm-precommit-scripts/)

- 📖 [Hey git, please .keep those folders](https://medium.com/@kinduff/hey-git-please-keep-those-folders-eb0ed37621c8)

- 📖 [GitHub Protips: Tips, tricks, hacks, and secrets from Lee Reilly](https://github.blog/2020-04-09-github-protips-tips-tricks-hacks-and-secrets-from-lee-reilly/)

## Github Actions

- 📺 [GitHub Actions - Now with built-in CI/CD! Live from GitHub HQ](https://www.youtube.com/watch?v=E1OunoCyuhY)

- 📖 [Automating your workflow with GitHub Actions](https://help.github.com/en/categories/automating-your-workflow-with-github-actions)

- 📖 [Hello, GitHub Actions!](https://lab.github.com/github/hello-github-actions!)
