# Elastic Stack

> Elastic is a search company that powers three solutions built on one powerful stack: the Elastic Stack. Deploy them anywhere (from the cloud to bare metal) to instantly find actionable insights from any type of data.

## Introduction

- 📺 [Overview of the Elastic Stack (formerly ELK stack)](https://www.youtube.com/watch?v=Hqn5p67uev4)

- 📺 [Common Elastic Stack & Elasticsearch Architectures](https://www.youtube.com/watch?v=Yc-G13lEbpc)

## Elastic Search

### Introduction

- 📺 [What is Elasticsearch?](https://www.youtube.com/watch?v=sKnkQSec1U0)

- 📺 [Introduction to Elasticsearch](https://www.youtube.com/watch?v=yZJfsUOHJjg)

- 📖 [The Beginners’ Guide to Elasticsearch — Part 1](https://medium.com/towards-artificial-intelligence/the-beginners-guide-to-elasticsearch-part-1-2e50d3761e3c)

### Autocompletion

- 📖 [Elasticsearch: Using Completion Suggester to build AutoComplete](https://medium.com/@taranjeet/elasticsearch-using-completion-suggester-to-build-autocomplete-e9c120cf6d87)

### Deployment

- 📖 [How To Install and Configure Elasticsearch on Ubuntu 18.04](https://www.digitalocean.com/community/tutorials/how-to-install-and-configure-elasticsearch-on-ubuntu-18-04)

- 📖 [How To Install Elasticsearch, Logstash, and Kibana (Elastic Stack) on Ubuntu 18.04](https://www.digitalocean.com/community/tutorials/how-to-install-elasticsearch-logstash-and-kibana-elastic-stack-on-ubuntu-18-04)

- 📖 [How to run an Elasticsearch 7 single node cluster for local development using Docker Compose?](https://medium.com/@TimvanBaarsen/how-to-run-an-elasticsearch-7-x-single-node-cluster-for-local-development-using-docker-compose-2b7ab73d8b82)

- ❓ [How to decrease the number of RAM required by Elastic Search](https://stackoverflow.com/a/58656748/1649372)

- ❓ [How do I enable remote access/request in Elasticsearch 2.0?](https://stackoverflow.com/questions/33696944/how-do-i-enable-remote-access-request-in-elasticsearch-2-0)

### Queries

- 📖 [Elasticsearch Queries: A Thorough Guide](https://logz.io/blog/elasticsearch-queries/)

- 📖 [Learn Elasticsearch Sorting in 5 minutes](https://medium.appbase.io/sort-elasticsearch-a-tutorial-on-sorting-with-elasticsearch-762b6c02557f)

- 📖 [How to Sort an Analyzed Text Field in Elasticsearch](https://kb.objectrocket.com/elasticsearch/how-to-sort-an-analyzed-text-field-in-elasticsearch)

### Mapping

- ❓ [Create or update mapping in elasticsearch](https://stackoverflow.com/a/25471930/1649372)

### Node.js

- 📖 [Getting started with Elasticsearch and Node.js - Part 1](https://www.compose.com/articles/getting-started-with-elasticsearch-and-node/)

### Scale

- 📖 [Elasticsearch, how we paginated over 10 000 items](https://medium.com/@Benoit_Travers/elasticsearch-how-we-paginated-over-10-000-items-11198af5018c)
