# Mastering JavaScript

> JavaScript, often abbreviated as JS, is a high-level, interpreted programming language. It is a language which is also characterized as dynamic, weakly typed, prototype-based and multi-paradigm. Alongside HTML and CSS, JavaScript is one of the three core technologies of the World Wide Web.

## Introduction

- 📺 [JavaScript in 2019](https://youtu.be/cS6Txwk8Q-Q)

## Arrays

- 📖 [Eliminating duplicate objects: three approaches](https://2ality.com/2020/07/eliminating-duplicate-objects.html)

## Drag and drop

- 📖 [How To Make A Drag-and-Drop File Uploader With Vanilla JavaScript](https://www.smashingmagazine.com/2018/01/drag-drop-file-uploader-vanilla-js/)

## Ecosystem

- 📖 [State of JS for 2019](https://2019.stateofjs.com/)

- 📖 [State of JS for 2018](https://2018.stateofjs.com/introduction/)

- 📖 [State of JS for 2017](https://2017.stateofjs.com/2017/introduction)

## ES6 to ES10

- 📺 [ES10 / ES2019 _New_ Features!](https://www.youtube.com/watch?v=eps-J_p4eQY)

- 📺 [Array Iteration: 8 Methods - map, filter, reduce, some, every, find, findIndex, forEach](https://www.youtube.com/watch?v=Urwzk6ILvPQ)

- 📺 [JavaScript 2021 New Numeric Separators](https://www.youtube.com/watch?v=8L36qRYruec)

- 📖 [Rename & Destructure Variables in ES6](https://wesbos.com/destructuring-renaming)

## Things to Know

- 📺 [What is THIS in JavaScript? in 100 seconds](https://www.youtube.com/watch?v=YOlr79NaAtQ)

- 📺 [What is Polyfill (Web Development)](https://www.youtube.com/watch?v=saewjAZlwlg)

- 📖 [An Introduction to Source Maps](https://blog.teamtreehouse.com/introduction-source-maps)

- 📖 [Arrays vs Sets](https://www.frontendmayhem.com/javascript-arrays-vs-sets/)

- 📖 [JavaScript: Continue vs Break](https://codeburst.io/javascript-continue-vs-break-47b5c15cacc6)

## Native Features

- 📖 [Share like a native app with the Web Share API](https://web.dev/web-share/)

- 📖 [How to Use the Web Share API](https://css-tricks.com/how-to-use-the-web-share-api/)

## NPM

- 📺 [NPM and the Future of JavaScript](https://www.youtube.com/watch?v=Qa4dxW-Qi2s)

- 📖 [npm-link: symlink a package folder](https://docs.npmjs.com/cli/link.html)

## Performance

- 📺 [Speed highlights (Chrome Dev Summit 2019)](https://www.youtube.com/watch?v=5_Ns2xfBMLw)

## Tips

- 📺 [Top 5 Javascript Things You Should Know!](https://www.youtube.com/watch?v=v0QTqHXiVNw)

- 📖 [Better error handling in JavaScript](https://medium.com/@iaincollins/error-handling-in-javascript-a6172ccdf9af)

- 📖 [Console cheat sheet for JavaScript developers](https://levelup.gitconnected.com/console-cheat-sheet-for-javascript-developers-21f0c49604d4)
