# Mastering Vue.js

> Vue.js is an open-source JavaScript framework for building user interfaces. Integration into projects that use other JavaScript libraries is simplified with Vue because it is designed to be incrementally adoptable.

## Before you start

- 🧠 [Vue.js Roadmap](https://github.com/vuejs/vue/projects/6)

- 📺 [Vue JS 2 - The Complete Guide (incl. Vue Router & Vuex)](https://www.udemy.com/vuejs-2-the-complete-guide/)

- 📺 [Vue.js: the Progressive Framework - Evan You](https://www.youtube.com/watch?v=p2P3z7p_zTI)

- 📺 [3 Ways To Debug Your Vuejs Apps With VS Code And Chrome](https://www.youtube.com/watch?v=lyGt1TmleoU)

- 📖 [Debugging in VS Code](https://vuejs.org/v2/cookbook/debugging-in-vscode.html)

- 📖 [Google, Apple and Other Users of Vue.js](https://medium.com/notonlycss/google-apple-and-other-users-of-vue-js-e4505359e5d5)

## API

- 📖 [Leverage `provide/inject` to avoid prop drilling in Vue.js](https://markus.oberlehner.net/blog/lazy-resolving-observable-api-services-with-vue/)

## Authentication

- 📖 [Handling Authentication In Vue Using Vuex](https://scotch.io/tutorials/handling-authentication-in-vue-using-vuex)

- 📖 [Structuring a Vue project : Authentication](https://medium.com/@zitko/structuring-a-vue-project-authentication-87032e5bfe16)

- 📖 [Route Meta Fields](https://router.vuejs.org/guide/advanced/meta.html)

## Best Practices

- 📖 [Official Vue.js Style Guide](https://vuejs.org/v2/style-guide/)

- 📖 [Building Large-Scale Vue.JS Application](https://stories.scandiweb.com/building-large-scale-vue-js-application-fec63b6e71e5)

- 📖 [Understanding environments in VueJS](https://medium.com/the-andela-way/understanding-environments-in-vuejs-74e94a139b8b)

- 📖 [10 Good Practices for Building and Maintaining Large Vue.js Projects](https://www.telerik.com/blogs/10-good-practices-building-maintaining-large-vuejs-projects)

- 📖 [4 Best Practices for Large Scale Vue.js Projects](https://blog.bitsrc.io/4-best-practices-for-large-scale-vue-js-projects-9a533450bdb2)

- ⁉️ [Why is it considered poor practice to use Axios or HTTP calls in components?](https://stackoverflow.com/questions/45839198/why-is-it-considered-poor-practice-to-use-axios-or-http-calls-in-components)

- 📺 [Are These Vue.js Best Practices? Video Critique!](https://www.youtube.com/watch?v=38XnZ3EJqYQ)

## CLI

- 📖 [Vue CLI Official documentation](https://cli.vuejs.org/)

- 📖 [Distributed Vue.js Applications Part 1: Loading Components via HTTP](https://markus.oberlehner.net/blog/distributed-vue-applications-loading-components-via-http/)

- 📖 [Distributed Vue.js Applications Part 2: Pushing Content and Component Updates to the Client](https://markus.oberlehner.net/blog/distributed-vue-applications-pushing-content-and-component-updates-to-the-client/)

## Components

- 📺 [What Are Vue.js Hooks?](https://www.youtube.com/watch?v=9YKpx7h-Ass)

- 📺 [Why the Vue 3 Composition API?](https://www.youtube.com/watch?v=6HUjDKVn0e0)

- 📖 [Adding v-model Support to Custom Vue.js Components](https://alligator.io/vuejs/add-v-model-support/)

- 📖 [Creating Vue.js Component Instances Programmatically](https://css-tricks.com/creating-vue-js-component-instances-programmatically/)

- 📖 [Scoped Component Slots in Vue.js](https://alligator.io/vuejs/scoped-component-slots/)

- 📖 [Vue.js - How to Build Your First Package & Publish It on NPM](https://www.telerik.com/blogs/vuejs-how-to-build-your-first-package-publish-it-on-npm)

- 📖 [The correct way to force Vue to re-render a component](https://michaelnthiessen.com/force-re-render)

- 📖 [7 Ways to Define a Component Template in Vue.js](https://vuejsdevelopers.com/2017/03/24/vue-js-component-templates/)

- 📖 [Leverage `provide/inject` to avoid prop drilling in Vue.js](https://www.jbakebwa.dev/posts/provide-inject.html)

## Directives

- 📖 [15 Must-Have Vue Directives That Will Significantly Maximize Your Productivity](https://www.telerik.com/blogs/15-must-have-vue-directives-that-will-significantly-maximize-your-productivity)

- 📖 [Rendering Elements only Once (v-once directive)](https://codingexplained.com/coding/front-end/vue-js/rendering-elements-v-directive)

## NativeScript

- 📺 [Ignacio Fuentes - Mobile Apps with Vue and NativeScript](https://www.youtube.com/watch?v=claDp19_aqA)

## News

- 📺 [Design Principles of Vue 3.0 by Evan You](https://www.youtube.com/watch?v=WLpLYhnGqPA)

## Packaging

- 📖 [How to Build Your First Package & Publish It on NPM](https://www.telerik.com/blogs/vuejs-how-to-build-your-first-package-publish-it-on-npm)

## Performance

- 📺 [Sean Larkin - Code splitting patterns in Vue.js](https://www.youtube.com/watch?v=rn97hCNQsKI)

- 📖 [Avoiding Memory Leaks](https://vuejs.org/v2/cookbook/avoiding-memory-leaks.html)

- 📖 [How we got a 100% Lighthouse performance score for our Vue.js app](https://blog.checklyhq.com/how-we-got-a-100-lighthouse-performance-score-for-our-vue-js-app/)

## Productivity

- 📖 [10 Tips to Increase your Productivity when Coding in Vue.js](https://www.telerik.com/blogs/10-tips-to-increase-your-productivity-when-coding-in-vuejs)

## Responsive

- 📖 [Handle Media Queries and Responsive Design with Vue](https://alligator.io/vuejs/vue-media-queries/)

## Router

- 📖 [Navigate Nested Child Routes In A Vue.js Web Application](https://www.thepolyglotdeveloper.com/2017/11/navigate-nested-child-routes-vuejs-web-application/)

## Showcase

- 📗 [Made with Vue.js](https://madewithvuejs.com/)

- 📗 [Vue.js examples](https://vuejsexamples.com/)

## Slots

- 📖 [All You Need to Know About Slots in Vue.js](https://www.telerik.com/blogs/all-you-need-to-know-about-slots-in-vuejs)

## Storybook

- 📖 [Learn Storybook](https://www.learnstorybook.com/intro-to-storybook/vue/en/get-started/)

- 📖 [An (almost) comprehensive guide on using Storybook with Nuxt.js](https://medium.com/js-dojo/a-guide-on-using-storybook-with-nuxt-js-1e0018ec51c9)

- 📖 [Writing tests for Vue.js Storybook](https://dev.to/kylewelsby/writing-tests-for-vue-js-storybook-1bh9)

## Testing

- 📺 [Roman Kuba - Testing Vue components with Jest](https://www.youtube.com/watch?v=pqp0PsPBO_0)

## Vite

- 📖 [What the Heck is Vite?](https://www.wrappixel.com/what-the-heck-is-vite/)

## VuePress

- 📺 [VuePress: Documentation made easy](https://youtu.be/fkrQJzP3Yl4)

## Vuex

- 📺 [Vuex - Intro Tutorial](https://www.youtube.com/watch?v=_2_C9j-8CtM)

- 📺 [Learn Vuex In 10 Minutes (Vue.js State Management)](https://www.youtube.com/watch?v=LW9yIR4GoVU)

- 📖 [Two way data binding and state management with Vuex and strict mode](https://ypereirareis.github.io/blog/2017/04/25/vuejs-two-way-data-binding-state-management-vuex-strict-mode/)

- 📖[Vuex getters are great, but don’t overuse them](https://codeburst.io/vuex-getters-are-great-but-dont-overuse-them-9c946689b414)

- ⁉️ [Vuex | How to commit a global mutation in a module action?](https://stackoverflow.com/questions/44618440/vuex-how-to-commit-a-global-mutation-in-a-module-action)

## YouTube Channels

- 📺 [Vue Mastery](https://www.youtube.com/channel/UCa1zuotKU4Weuw_fLRnPv0A)

- 📺 [VueConf EU](https://www.youtube.com/channel/UC9dJjbYeXjirDYYVfUD3bSw)

- 📺 [Vuejs Amsterdam](https://www.youtube.com/channel/UCxV7lO6dUhpB-IyzmGuVgqg)

- 📺 [Vue NYC](https://www.youtube.com/channel/UCX4w2P-M4cuWQG0WKgU3TTQ)

- 📺 [Vue Toronto](https://www.youtube.com/channel/UCSrbuSqU7S-g9vydCLRYCZg)

- 📺 [Program with Erik](https://www.youtube.com/channel/UCshZ3rdoCLjDYuTR_RBubzw)
