# Mastering Performance

> Web performance refers to the speed in which web pages are downloaded and displayed on the user's web browser. Web performance optimization, or website optimization is the field of knowledge about increasing web performance.

## Auditing

- 📖 [Discover performance opportunities with Lighthouse](https://web.dev/fast/discover-performance-opportunities-with-lighthouse)

## Images & Videos

- 📺 [Optimise page load time: icon font or SVG?](https://www.youtube.com/watch?v=gdL7XWlFJ9c)

- 📖 [Native lazy-loading for the web](https://web.dev/native-lazy-loading)

- 📖 [Use Imagemin to compress images](https://web.dev/fast/use-imagemin-to-compress-images)

- 📖 [Replace animated GIFs with video for faster page loads](https://web.dev/fast/replace-gifs-with-videos)

- 📖 [Use lazysizes to lazyload images](https://web.dev/fast/use-lazysizes-to-lazyload-images)

- 📖 [Serve images with correct dimensions](https://web.dev/fast/serve-images-with-correct-dimensions)

- 📖 [Use WebP images](https://web.dev/fast/serve-images-webp)

## JavaScript

- 📖 [Apply instant loading with the PRPL pattern](https://web.dev/fast/apply-instant-loading-with-prpl)

## Mobile

- 📺 [Mobile Optimisation Tips for Lightning-Fast Mobile Sites](https://www.youtube.com/watch?v=9TYKhUeOnfg)

## Preloading

- 📖 [Using Preload and Prefetch in Your HTML to Load Assets](https://alligator.io/html/preload-prefetch/)
