# Mastering Nuxt.js

> Nuxt.js is a free and open source web application framework based on Vue.js, Node.js, Express.js, Webpack and Babel.js. The framework is advertised as "meta-framework for universal applications".

## Updates

- 📺 [Sébastien Chopin - What is Nuxt 2020?!](https://www.youtube.com/watch?v=9CkfX6LgNUU)

## API

- 📖 [Organize and decouple your API calls in Nuxt.js](https://blog.lichter.io/posts/organize-and-decouple-your-api-calls-in-nuxtjs/)

- 📺 [Axios v Fetch Api in Nuxt.js](https://www.youtube.com/watch?v=N9iSyc2tews)

## Code style

- 📖 [How to properly set up Nuxt with ESLint and Prettier in VSCode](https://medium.com/@gogl.alex/how-to-properly-set-up-eslint-with-prettier-for-vue-or-nuxt-in-vscode-e42532099a9c)

## Deployment

- 📖 [How to run Nuxt.js on DigitalOcean?](https://medium.com/codeartisan/how-to-run-nuxt-js-on-digitalocean-159fc558d2ab)

## Docker

- 📖 [Deploying a Nuxt.js App with Docker](https://jonathanmh.com/deploying-a-nuxt-js-app-with-docker/)

## I18N

- 📖 [Advanced i18n in Nuxt using Interpolations](https://vuedose.tips/advanced-i18n-in-nuxt-using-interpolations/)

## Router

- 📺 [A deep dive into the prefetch feature of Nuxt's nuxt-link component](https://www.youtube.com/watch?v=Or6RDRbXyVI)

- 📖 [Redirect 404 Not Found in Nuxt.js](https://vuedose.tips/tips/redirect-404-not-found-in-nuxt-js/)

## SEO

- 📖 [Optimize SEO and Social Media Sharing in a Nuxt blog](https://vuedose.tips/optimize-seo-and-social-media-sharing-in-a-nuxt-blog/)

## Server Middlewares

- 📺 [Why You Should Learn Server Middleware with Nuxt.js!](https://www.youtube.com/watch?v=j-3RwvWZoaU)

- 📺 [Creating Redirects With Nuxt](https://www.youtube.com/watch?v=6akY6UQMjF8)

- 📖 [Using NuxtJS Server Middleware as a Proxy Pass](https://mccallister.io/using-nuxtjs-server-middleware-as-a-proxy-pass)

- 📖 [My take on using Nuxt with an API](https://blog.lichter.io/posts/nuxt-with-an-api/)

## Storybook

- 📖 [nuxt storybook zero configuration with @nuxtjs/storybook module](https://dev.to/f3ltron/nuxt-storybook-zero-configuration-with-nuxtjs-storybook-module-8a2)

## Things to know

- ❓ [Difference between Asyncdata vs Fetch](https://stackoverflow.com/questions/49251437/difference-between-asyncdata-vs-fetch)

- 📺 [4 Nuxt JS beginner tutorial - Understanding express/nodejs in Nuxtjs](https://www.youtube.com/watch?v=INXFhl8rd6c)

- 📺 [Common Problems With The Nuxt Client-Only Component](https://www.youtube.com/watch?v=sGzaqUj7T9Y)

- 📺 [7 Problems you can avoid by using Nuxt.js for your next Vue app](https://www.youtube.com/watch?v=7ITypVi-qRY)

- 📖 [A Deep Dive Into The Nuxt-Link Component](https://deltener.com/blog/a-deep-dive-into-the-nuxt-link-component/)

- 📖 [Change the Nuxt.js server error page](https://blog.lichter.io/posts/nuxtjs-change-server-error-page/)

## TWA

- 📖 [Nuxt module to transform your PWA into an Android app, using Trusted Web Activities (TWA)](https://laptrinhx.com/nuxt-module-to-transform-your-pwa-into-an-android-app-using-trusted-web-activities-twa-3278016247/)

## Performance

- 📖 [How to Load Third-Party Scripts in Nuxt.js](https://vueschool.io/articles/vuejs-tutorials/how-to-load-third-party-scripts-in-nuxt-js/)
