# Mastering CSS

> Cascading Style Sheets is a style sheet language used for describing the presentation of a document written in a markup language like HTML. CSS is a cornerstone technology of the World Wide Web, alongside HTML and JavaScript.

## Code style

- 📖 [Key concepts for BEM syntax](https://en.bem.info/methodology/key-concepts/)

- 📖 [MindBEMding – getting your head ’round BEM syntax](https://csswizardry.com/2013/01/mindbemding-getting-your-head-round-bem-syntax/)

- 📖 [Naming convention for BEM syntax](https://en.bem.info/methodology/naming-convention/)

- 📖 [More Transparent UI Code with Namespaces](https://csswizardry.com/2015/03/more-transparent-ui-code-with-namespaces/)

- 📖 [InuitCSS README](https://github.com/inuitcss/inuitcss/blob/develop/README.md)

## Flexbox

- 📖 [The peculiar magic of flexbox and auto margins](https://css-tricks.com/the-peculiar-magic-of-flexbox-and-auto-margins/)

## Font

- 📖 [System Font Stack](https://css-tricks.com/snippets/css/system-font-stack/)

## Grid

- 📺 [The magic of auto-fit and auto-fill (and the difference between them)](https://www.youtube.com/watch?v=qjJR3qYCd54)

## Layouts

- 📖 [Building responsive layouts - Designing in the Browser](https://www.youtube.com/watch?v=K1POS8yPqa8)

## Media queries

- 📖 [Create print styles using CSS3 @media queries](https://benfrain.com/create-print-styles-using-css3-media-queries/)

## Navigation

- 📖 [Tutorial: Stripe.com's main navigation](https://lokeshdhakar.com/dev-201-stripe.coms-main-navigation/)

## News

- 📖 [How to Use New CSS “:is()” for Easy Element Targeting](https://webdesign.tutsplus.com/articles/new-css-is-for-easy-element-targeting--cms-34223)

- 📺 [What's New in CSS](https://www.youtube.com/watch?v=107JV5MpgUU)

## Positioning

- 📺 [4 Quickest Ways to Center Div with CSS](https://www.youtube.com/watch?v=mVYgtzDLZfY)

## PostCSS

- 📺 [PostCSS in 100 Seconds](https://www.youtube.com/watch?v=WhCXiEwdU1A)

## SASS / SCSS

- 📖 [Understanding placeholder selectors](http://thesassway.com/intermediate/understanding-placeholder-selectors)

- 📖 [10 Time-Saving CSS Tips I Learned the Hard Way When Using Sass](https://www.telerik.com/blogs/10-time-saving-css-tips-i-learned-the-hard-way-when-using-sass)

- 📖 [Deep Get/Set in Maps](https://css-tricks.com/snippets/sass/deep-getset-maps/)

- 📖 [Extra Map Functions in Sass](https://www.sitepoint.com/extra-map-functions-sass/)

## Stylelint

- 📖 [How to lint SCSS with stylelint](https://medium.com/@bjankord/how-to-lint-scss-with-stylelint-dc87809a9878)

## Tailwind

- 📺 [Tailwind CSS with Vue](https://www.youtube.com/watch?v=ZAjUGkhqUP4)

## Tips & Tricks

- 📺 [Remove all styling with one line of CSS](https://www.youtube.com/watch?v=0GcTUor2ANw)

- 📺 [A couple of cool things you can do with CSS position sticky](https://www.youtube.com/watch?v=8TyoihVGErI)

- 📺 [The Only 2 CSS Properties You Should Animate](https://www.youtube.com/watch?v=N5EW4HnF6FU)

- 📺 [CSS Z-Index and Stacking Context](https://www.youtube.com/watch?v=uS8l4YRXbaw)

- 📺 [Why you shouldn't set font-sizes using em](https://www.youtube.com/watch?v=pautqDqa54I)

- 📺 [You are doing :focus wrong (and I was too)](https://www.youtube.com/watch?v=Mvu5OMGcdVA)

- 📺 [CSS Single VS Double Colon - Which is Correct?](https://www.youtube.com/watch?v=B3Er3gnVxHI)

- 📺 [Top 10 CSS Tricks You Didn't Know!](https://www.youtube.com/watch?v=CxC925yUxSI)

- 📖 [Pure CSS for multiline truncation with ellipsis](http://hackingui.com/front-end/a-pure-css-solution-for-multiline-text-truncation/)
