# Mastering Sails.js

> Sails is the most popular MVC framework for Node.js, designed to emulate the familiar MVC pattern of frameworks like Ruby on Rails, but with support for the requirements of modern apps: data-driven APIs with a scalable, service-oriented architecture.

## Introduction

- 📺 [Introduction to Sails.js](https://youtu.be/ZfPJEOwBP68)

- 📖 [Intro to Sails.js](https://hellosails.com/intro-to-sails-js/)

## Authentication

- 📖 [Building API Authentication from Scratch - Part 1](https://hellosails.com/building-api-authentication-from-scratch-part-1/)

- 📖 [Building API Authentication from Scratch - Part 2](https://hellosails.com/building-api-authentication-from-scratch-part-2/)

- 📖 [Implement Passport.js authentication with Sails.js 1.0](https://medium.com/@greg.hesp/implement-passport-js-authentication-with-sails-js-1-0-50888265fb83)

- 📖 [How To Implement Password Reset In Node.js](http://sahatyalkabov.com/how-to-implement-password-reset-in-nodejs/)

## Policies

- 📖 [Understanding Sails.js Policies (plus example)](https://hellosails.com/understanding-sails-js-policies-plus-example-2/)

- 📖 [Access Management with Sails Permissions](https://hellosails.com/sails-permissions/)

## Deployment

- 📖 [Hosting your Sails.js Application - Heroku](https://hellosails.com/hosting-your-sails-js-application-heroku/)

## Testing

- 📖 [Testing your code](https://sailsjs.com/documentation/concepts/testing)

## Books

- 📖 [Sails.js in Action](https://www.amazon.com/Sails-js-Action-Mike-McNeil/dp/1617292613)

## Blogs

- 📖 [Hello Sails](https://hellosails.com/)
