# Mastering Node.js

> Node.js is an open-source, cross-platform, JavaScript runtime environment that executes JavaScript code outside of a web browser.

## Introduction

- 📺 [How Node.js Works](https://www.youtube.com/watch?v=jOupHNvDIq8)

## Things to know

- 📖 [4 ways to update to the latest Node.js version on a Mac](https://bytearcher.com/articles/ways-to-get-the-latest-node.js-version-on-a-mac/)

- 📺 [API vs. SDK: What's the difference?](https://www.youtube.com/watch?v=kG-fLp9BTRo)

## Deployment

- 📺 [Deploying Node.js App With PM2](https://www.youtube.com/watch?v=RF6Dzwwpduo)

- 📺 [Node JS - Scaling Applications - PM2](https://www.youtube.com/watch?v=iHzoQy1jx7M)

- 📖 [How To Install Node.js on Ubuntu 18.04](https://www.digitalocean.com/community/tutorials/how-to-install-node-js-on-ubuntu-18-04)

## File Input/Output

- 📖 [Using Node.js to Read Really, Really Large Datasets & Files (Pt 1)](https://itnext.io/using-node-js-to-read-really-really-large-files-pt-1-d2057fe76b33)

- 📖 [Streams For the Win: A Performance Comparison of Node.js Methods for Reading Large Datasets (Pt 2)](https://itnext.io/streams-for-the-win-a-performance-comparison-of-nodejs-methods-for-reading-large-datasets-pt-2-bcfa732fa40e)

## Image Manipulation

- 📖 [NodeJS Image Manipulation Libraries](https://medium.com/on-discord/nodejs-image-manipulation-libraries-43a3f955cc67)

- 📖 [Image Processing in NodeJS with Jimp](https://medium.com/@rossbulat/image-processing-in-nodejs-with-jimp-174f39336153)

## NPM

- 📖 [Understanding npm-link](https://medium.com/dailyjs/how-to-use-npm-link-7375b6219557)

- 📖 [NPM Tips and Tricks](https://blog.bitsrc.io/npm-tips-and-tricks-24c5e9defea6)

## Storage

- 📖 [DigitalOcean Spaces: Pros/Cons and how to use it with JavaScript](https://medium.com/dailyjs/digital-ocean-spaces-pros-cons-and-how-to-use-it-with-javascript-1802559ce2bd)

## Things to know

- 📖 [How to Exit in Node.js](https://stackabuse.com/how-to-exit-in-node-js/)
