# Mastering Laravel

> Laravel is a free, open-source PHP web framework, created by Taylor Otwell and intended for the development of web applications following the model–view–controller architectural pattern and based on Symfony.

## Introduction

- 📺 [Laravel 5.7 From Scratch](https://laracasts.com/series/laravel-from-scratch-2018)

- 📺 [Eloquent Relationships](https://laracasts.com/series/eloquent-relationships)

- 📖 [Laravel API Tutorial: How to Build and Test a RESTful API](https://www.toptal.com/laravel/restful-laravel-api-tutorial)

- 📖 [Use Laravel Valet for a Super Quick Dev Server](https://scotch.io/tutorials/use-laravel-valet-for-a-super-quick-dev-server)

## API

- 📺 [Laravel 5.5 API From Scratch Using Resources](https://www.youtube.com/watch?v=4pc6cgisbKE)

- 📺 [HUGE NEW FEATURE: API Resources (14/14) - Laravel 5.5 New Features](https://www.youtube.com/watch?v=Gyr5ZMNaPbc)

- 📖 [Laravel Sanctum](https://laravel.com/docs/master/sanctum)

- 📖 [Using Laravel 5.5 Resources to create your own {JSON:API} formatted API](https://medium.com/zero-equals-false/using-laravel-5-5-resources-to-create-your-own-json-api-formatted-api-2c6af5e4d0e8)

## Auth

- 📺 [Laravel with JWT | From Scratch to Exception Handling](https://www.youtube.com/watch?v=l201RSQ7Ti4)

## Commands & Scheduling

- 📖 [Tips for Using Laravel’s Scheduler](https://laravel-news.com/tips-for-using-laravels-scheduler)

## Controllers

- 📖 [Moving Controllers to sub-folders in a correct way](https://laraveldaily.com/moving-controllers-to-sub-folders-in-a-correct-way/)

## Eloquent

- 📖 [Laravel Eloquent Amazing Tips and Tricks](https://medium.com/@advanceidea/laravel-eloquent-tips-894bc104cb98)

## Emailing

- 📖 [Allowing Users to send email with their own SMTP settings in Laravel](https://laravel-news.com/allowing-users-to-send-email-with-their-own-smtp-settings-in-laravel)

## Facades

- 📺 [Laravel Facade - simplest explanation](https://www.youtube.com/watch?v=zD2VJhOdI5c)

- 📖 [Essential Laravel Knowledge: How A Facade Works](https://calebporzio.com/essential-laravel-knowledge-how-a-facade-work/)

## Laravel Envoyer

- 📺 [How to Deploy Laravel Project with Envoyer](https://www.youtube.com/watch?v=hf0_pU-hRUE)

- 📺 [How to Deploy Laravel Project with Envoyer](https://www.youtube.com/watch?v=hf0_pU-hRUE)

## Laravel Forge

- 📺 [DEMO: New Server and Deployment with Laravel Forge](https://www.youtube.com/watch?v=dzD7HI5lI1M)

- 📺 [Laravel Vapor vs Laravel Forge](https://www.youtube.com/watch?v=iQHKY1vu_Ck)

- 📺 [Laravel E-Commerce - Server Deployment w/ Forge - Part 7](https://www.youtube.com/watch?v=BfCgwYgopUg)

- 📺 [How we Deploy Laravel: Branches, Staging Servers, Forge and Envoyer](https://www.youtube.com/watch?v=8DVuVftFZcQ)

## Middlewares

- 📺 [Why we need middleware](https://www.youtube.com/watch?v=2pPxHrPrvfA)

- 📺 [Laravel core middleware](https://www.youtube.com/watch?v=kXLKPLR_W_0)

- 📺 [Create your own middleware](https://www.youtube.com/watch?v=YHn7EvfVJ44)

- 📺 [Ways to apply middleware](https://www.youtube.com/watch?v=PC_YT--gPzg)

## News

- 📺 [The State of Laravel 2019 by Taylor Otwell](https://www.youtube.com/watch?v=Hfgcg09srSo)

## Nova

- 📺 [Laravel Nova Mastery](https://laracasts.com/series/laravel-nova-mastery)

- 📖 [Improvements on Laravel Nova](https://stitcher.io/blog/improvements-on-laravel-nova)

## Packages

- 📺 [Useful Laravel Packages](https://codewithdre.com/useful-laravel-packages)

## Patterns

- 📖 [Use the Repository Design pattern in a Laravel application](https://medium.com/employbl/use-the-repository-design-pattern-in-a-laravel-application-13f0b46a3dce)

- 📖 [Repository Design Pattern in Laravel Application](https://medium.com/@shishirthedev/repository-design-pattern-in-laravel-application-f474798f53ec)

- 📖 [Simplifying controllers](https://murze.be/simplifying-controllers)

- 📖 [Laravel Tip: Bootable Model Traits](https://tighten.co/blog/laravel-tip-bootable-model-traits)

- 📺 ["Cruddy by Design" - Adam Wathan - Laracon US 2017](https://www.youtube.com/watch?v=MF0jFKvS4SI)

- 📺 [Laravel 6 Advanced - e7 - Repository Pattern](https://www.youtube.com/watch?v=93ZhGkFIwbA)

## Performance

- 📖 [Use Query Caching to make your App really fast](https://kovah.me/en/n7hs3x-laravel-5-use-query-caching-to-make-your-app-really-fast/)

- 📖 [Laravel: The hidden SetCacheHeaders Middleware](https://itnext.io/laravel-the-hidden-setcacheheaders-middleware-4cd594ba462f)

- 📖 [Speed up your Laravel pages by caching the responses](https://jeffochoa.me/speed-up-your-laravel-pages-by-caching-the-responses)

## Permission

- 📖 [When to use Gate::after in Laravel](https://murze.be/when-to-use-gateafter-in-laravel)

## Router

- 📺 [Laravel from Scratch #9 - How to Use the Route Model Binding](https://www.youtube.com/watch?v=tTwlyN_HC0E)

## Service Container

- 📺 [Laravel Service Container Explained](https://www.youtube.com/watch?v=PGVqkEZiUoc)

## Service Provider

- 📺 [Laravel Service Provider](https://www.youtube.com/watch?v=1AxQNDOJTBw)

## TDD

- 📺 [Build A Laravel App With TDD](https://laracasts.com/series/build-a-laravel-app-with-tdd)

- 📺 [Testing Jargon](https://laracasts.com/series/testing-jargon)

- 📖 [Tips to Speed up Your Phpunit Tests](https://laravel-news.com/tips-to-speed-up-phpunit-tests)

- 📖 [My feature test suite setup](https://timacdonald.me/my-feature-test-suite-setup)

- 📖 [DatabaseMigrations, DatabaseTransactions, and WithoutMiddleware](https://mattstauffer.com/blog/better-integration-testing-in-laravel-5.1-databasemigrations-databasetransactions-and-withoutmiddleware/)

## Tips & Tricks

- 🧠 [Laravel Tricks](https://laravel-tricks.com/)

- 📺 [Quick Tip to Navigate from Laravel Route to Controller](https://www.youtube.com/watch?v=-zxzRwbdhR8)

- 📖 [20 Un-known Gems of Laravel](https://meramustaqbil.com/2019/03/23/20-un-known-gems-of-laravel/)

- 📖 [60 (and counting) Laravel Quick Tips](https://laraveldaily.com/wp-content/uploads/2019/04/laravel-tips-2019-04.pdf)

## Traits

- 📺 [Laravel Multi-Tenancy with Single Trait](https://www.youtube.com/watch?v=nCiNqboYFVQ)

## Updates

- 📖 [Laravel Shift](https://laravelshift.com/)

## Valet

- 📖 [How Laravel Valet Works Exactly](https://deliciousbrains.com/how-laravel-valet-works-exactly/)

## Websockets

- 📖 [WebSockets in Laravel](https://johnbraun.blog/posts/websockets-in-laravel)
