# Mastering Adonis

> AdonisJs is a Node.js web framework with a breath of fresh air and drizzle of elegant syntax on top of it. We prefer developer joy and stability over anything else.

## Introduction

- 📺 [AdonisJS 5 - Introduction | The Node.js Framework focused on developer ergonomics and speed](https://www.youtube.com/watch?v=TysfaNcFX_Y)

## API

- 📺 [Introduction [ Build a Simple API - Part 1 ]](https://www.youtube.com/watch?v=5wzcRtrRVd4)

- 📺 [Set up Adonis [ Build a Simple API - Part 2 ]](https://www.youtube.com/watch?v=ugtraz2A3FY)

- 📺 [Create Files with CLI [ Build a Simple API - Part 3 ]](https://www.youtube.com/watch?v=dBqDwJIe4XE)

- 📺 [Database Migrations [ Build a Simple API - Part 4 ]](https://www.youtube.com/watch?v=mXootA5Onr0)

- 📺 [Database Migrations CHALLENGE [ Build a Simple API - Part 5 ]](https://www.youtube.com/watch?v=LAeIFngnHWI)

- 📺 [Query Builder and Lucid ORM [ Build a Simple API - Part 6 ]](https://www.youtube.com/watch?v=C3T_TWpZFaY)

- 📺 [Middleware [ Build a Simple API - Part 7 ]](https://www.youtube.com/watch?v=HxkCHZ3ek-4)

- 📺 [Practice Ideas [ Build a Simple API - Part 8 ]](https://www.youtube.com/watch?v=ab5P3pH8j1Y)

## Deployment

- 📖 [Deploying AdonisJS Apps to DigitalOcean](https://scotch.io/bar-talk/deploying-adonisjs-apps-to-digitalocean).

## IoC Container & Service Providers

- 📺 [Understanding the IoC Container](https://www.youtube.com/watch?v=yTiZrOluehU)

- 📺 [Understanding Service Providers](https://www.youtube.com/watch?v=8ZIiraVxtvQ)

- 📺 [Set Up Service Providers](https://www.youtube.com/watch?v=w4apTeBa4O0)

## Lucid & Databases

- 📺 [Apply Constraints to Lucid Relationships](https://www.youtube.com/watch?v=eOOdseihjSI)

- 📺 [Use Lucid ORM to Query Related Data](https://www.youtube.com/watch?v=_zUF_mhubL0)

- 📺 [Setup and Query Many to Many Relationships with Lucid](https://www.youtube.com/watch?v=NUfpIDMqx2k)

- 📺 [Customize Database Queries](https://www.youtube.com/watch?v=lzhHjE6Ry3c)

- 📖 [Use MySQL Load Files Data in AdonisJS](https://techformist.com/adonisjs-batch-load-files-mysql/)

- 📖 [Querying databases with Knex.js](https://blog.logrocket.com/querying-databases-with-knex-js/)

## Mailing

- 📖 [Setting up Mailgun with Adonis.js](https://madsobel.com/blog/setting-up-mailgun-with-adonis.js/)

## Scheduling

- 📖 [Batch Operations & Scheduling in AdonisJS](https://techformist.com/batch-operations-adonisjs/)

## Things to know

- 📖 [CORS: Cross-Origin Resource Sharing Explained](https://www.ionos.com/digitalguide/websites/web-development/cross-origin-resource-sharing/)
