/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ai.langstream.cli.commands;

import ai.langstream.cli.commands.python.LoadPythonDependenciesCmd;
import ai.langstream.cli.commands.python.PythonRunTests;
import lombok.Getter;
import picocli.CommandLine;

@CommandLine.Command(
        name = "python",
        header = "Tools for Python developers",
        subcommands = {LoadPythonDependenciesCmd.class, PythonRunTests.class})
@Getter
public class RootPythonCmd {
    @CommandLine.ParentCommand private RootCmd rootCmd;
}
