<img  align="left" src="https://komarev.com/ghpvc/?username=Lakhankumawat&repo=LearnCPP&style=for-the-badge&label=VISITORS+COUNT&color=brightgreen"/><img align="right" src="https://img.shields.io/github/repo-size/Lakhankumawat/LearnCPP?style=for-the-badge&logo=appveyor" alt="GitHub repo size"/>

<img align="right" alt="LearnCPP"  src="https://socialify.git.ci/Lakhankumawat/LearnCPP/image?description=1&font=Bitter&forks=1&issues=1&language=1&logo=https%3A%2F%2Fgithub.com%2FLakhankumawat%2FPoP-UP-Window%2Fblob%2Fmaster%2FUntitled%2520design.png%3Fraw%3Dtrue&name=1&pattern=Plus&pulls=1&stargazers=1&theme=Dark" />


<!-------------Swags------------------------->

<p align="center">

<img src="https://forthebadge.com/images/badges/built-with-love.svg" alt=" forks"/>
<img src="https://forthebadge.com/images/badges/built-by-codebabes.svg" alt=" forks"/>
<img src="https://forthebadge.com/images/badges/made-with-c-plus-plus.svg" alt=" forks"/>
<img src="https://forthebadge.com/images/badges/makes-people-smile.svg" alt=" forks"/>
<img src="https://forthebadge.com/images/badges/powered-by-coffee.svg" alt=" forks"/>

</p>


<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-84-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->


<div align="center">


<!------------------------------------Badges------------------------------->
<h2 align="center"> Some Helpful Resources</h2>

| <img src="https://edent.github.io/SuperTinyIcons/images/svg/youtube.svg" width="45" title="YouTube" /> Youtube channels | <img src="https://edent.github.io/SuperTinyIcons/images/png/github.png" width="45" />   Github Repos | <img src="https://img.icons8.com/color/48/000000/badminton-2.png"/> Best Coding Playgrounds |
| --- | --- |----|
| [CppNuts](https://www.youtube.com/user/MrRupeshyadav) | [Codecademy](https://github.com/Codecademy/learn-cpp) | [Leetcode](https://leetcode.com/problemset/all/) |
| [The Cherno](https://www.youtube.com/user/TheChernoProject) | [johnmcfarlane/begin(C++)](https://gist.github.com/johnmcfarlane/1b2d9c83e4d3f700ba61e2df4077c613) | [HackerRank](https://www.hackerrank.com/dashboard) |
|[ChiliTomatoNoodle](https://www.youtube.com/user/ChiliTomatoNoodle)|[ratansingh98/CPP-Learning](https://github.com/ratansingh98/CPP-Learning)|[CodeChef](https://www.codechef.com/)|
|[Bo Qian](https://www.youtube.com/user/BoQianTheProgrammer)|[sahilbansal17/Get_Better_at_CP_in_2_Months](https://github.com/sahilbansal17/Get_Better_at_CP_in_2_Months)|[CodeForces](https://www.codeforces.com/)|




<!--- Tables Offline best ide-->
| <img src="https://img.icons8.com/fluent/48/000000/programming-flag.png"/>Coding IDE's | <img src="https://img.icons8.com/color/48/000000/generic-sorting.png"/>Algorithms | <img src="https://img.icons8.com/fluent/48/000000/notepad.png" width="45" alt="articles" />Useful articles
| --- | --- |---|
| [CodeBlocks](https://www.codeblocks.org/downloads/binaries/") | [Visualisze algorithms through animations](https://visualgo.net/en) | [Learn CPP](https://www.learncpp.com/)
| [VS Code](https://code.visualstudio.com/download) | [CP Algorithms](https://cp-algorithms.com/) | [CF Blog : Resources for cpp](https://codeforces.com/blog/entry/13529")|
</div>


# What's Inside 🗃
- Advanced Data Structures
- [Array](#array)
- [Backtracking](#backtracking)
- [Bit Manipulation](#bit-manipulation)
- [Disjoint Set Union](#disjoint-set-union)
- Divide And Conquer Algorithms
- [Dynamic Programming](#dynamic-programming)
- [Extra](#extra)
- [Graph Algorithms](#graph-algorithms)
- [Graphs](#graphs)
- [Greedy Algorithms](#greedy-algorithms)
- [HashMap](#hashMap)
- HashTable
- [Heap](#heap)
- [Linked List](#linked-list)
- [Mathematical Algorithms](#mathematical-algorithms)
- [Miscellaneous](#miscellaneous)
- [Priority Queue](#priority-queue)
- [Problem Statements and Solution](#problem-statements-and-solution)
- [Queue](#queue)
- [Recursion](#recursion)
- [STL](#stl)
- [Searching Algorithms](#searching-algorithms)
- [Sets](#sets)
- [Sorting Algorithms](#sorting-algorithms)
- [Stack](#stack)
- [String Algorithms](#string-algorithms)
- [Strings](#strings)
- [Template](#template)
- [Tree](#tree)
- Trie

<!-- ## <img src="https://media.giphy.com/media/Y3eZ2VA2b2UP5Lz6os/giphy.gif" alt="prerequisite" width="40px" > Contributing -->

## Read the following steps before contributing.


|     Follow Steps      |  Get Started           |
|----------------|-------------------------------|
| [![Alt text](https://user-images.githubusercontent.com/55774240/160746943-ce6cfa8e-859f-4fa3-b526-4a853ef8284e.jpg)](https://youtu.be/r7Xmlm3Bs8I)| [![Alt text](https://user-images.githubusercontent.com/55774240/160746656-6513e4a4-a953-4372-83ec-9f63369639b7.jpg)](https://youtu.be/MRXcoxDillk) | 
| [![Alt text](https://user-images.githubusercontent.com/55774240/160747046-dc75df22-26f1-4b37-ae41-18bfba32d8d5.jpg)](https://youtu.be/kIFwqp9B7pQ)| [![Alt text](https://user-images.githubusercontent.com/55774240/160747132-369b5bf5-bebe-4abd-ae80-de44859286a2.jpg)](https://youtu.be/7UgC3HDETRA) | 


### Algorithms

|                |Follow these steps                         	|
|----------------|-------------------------------|
|New Algorithm|`'Please see if the algorithm is already present'`|
| What to include |`"Your algorithm should be efficiently written with proper code / comments / time complexity / space complexity / link to gfg or any other documentation on top in code file"`            |
|Where to include         |please commit your algorithm in the correct folder or discuss` [here](https://github.com/Lakhankumawat/LearnCPP/discussions/7) `before committing to where to include`|
| README | `"Please check whether your directory has a README file, if there is then edit your algorithm name with a link, otherwise create a new one "` [how your README should look like](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-Backtracking/README.md)

### Problem Statement 

|                |Follow these steps                         	|
|----------------|-------------------------------|
|New Problem Statement|`'Please see if the problem is present already? If it is do not commit your own '`|
| What to include |`"Your problem statement solution should be efficiently written with proper code / comments / time complexity / space complexity / link to problem statement in code file"`            |
|Where to include         |`Most of the Problem Statements are inside`[here](https://github.com/Lakhankumawat/LearnCPP/tree/main/P-Problem%20Statements%20%26%20Solution)`please commit your problem solution in the correct folder or discuss` [here](https://github.com/Lakhankumawat/LearnCPP/discussions/7) `before committing for where to include`|
| README | `"Please check whether your directory has a README file, if there is then edit your algorithm name with a link, otherwise create a new one "` [how your README should look like](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-Backtracking/README.md)
|Additional Context |`"There are three levels of problem statement"` [1-Level 1](https://github.com/Lakhankumawat/LearnCPP/tree/main/P-Problem%20Statements%20%26%20Solution/1-Level%201 "1-Level 1") `likewise 2-Level 2 & 3-Level 3, please include your problem statement with a solution in the right level you prefer

### To add programs using ```STL```, follow the same approach as  ```Algorithms```

### Readme
Fond of designing README this section will be helpful to you
|                |Follow these steps                         	|
|----------------|-------------------------------|
| 🆕 New README |`'Please see if there is no README in any folder if no? Then please design it, if yes? Then please edit it accordingly to your contribution and follow the guidelines '`|
| 🤔 What to include |`"Your README should be efficiently and written / link to problem statement in README at the top"` [see exmaple](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SortingAlgorithms/README.md)  |
| ✅ Must Contain | `1. and explain in brief about addition` `2. An Image of addition i.e how it works` `3. Mention the Pseudo Code` `4. Time and Space Complexities` `5. Advantages` `6. Disadvantages ` |
| 🪧 Where to include  |`Inside the folder where programs are residing, discuss` [here](https://github.com/Lakhankumawat/LearnCPP/discussions/7) `before committing to where to include`|

## Why contribute?
- If you find any errors or bugs then please report them by creating an issue. 
- If you can provide a more efficient solution or implementation of the algorithm then make sure to contribute. 
- If you want to implement an algorithm, data structure etc.., which is not yet there, then you can open up a PR regarding the same.
- [Link to discussion forum](https://github.com/Lakhankumawat/LearnCPP/discussions/7)
 
## Want to contribute?
- Take a look at [`contributing guidelines`](Contributing.md) if you're interested in helping!
- Refer [GitHub Flow](https://guides.github.com/introduction/flow). 
<!-- Create a branch, add commits, and [open a pull request](https://github.com/Lakhankumawat/HackNITP-3.0/compare). -->
<!--  will mention the method of contri in short in the README-->

<!-- To add this section or not ??  ## How to Contribute -->



<br>

## 🌟 Stargazers Over Time 🌟 

[![Stargazers over time](https://starchart.cc/Lakhankumawat/LearnCPP.svg)](https://starchart.cc/Lakhankumawat/LearnCPP)


## Project Maintainers ❤️ 
<br>
 <table>
  <tr>
    <td align="center"><a href="http://lakhankumawat.me/"><img src="https://avatars.githubusercontent.com/u/55774240?v=4?s=100" width="100px;" alt=""/><br /><sub><b>LakhanKumawat ᵖ⁺</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Lakhankumawat" title="Code">💻</a> <a href="https://github.com/Lakhankumawat/LearnCPP/pulls?q=is%3Apr+reviewed-by%3ALakhankumawat" title="Reviewed Pull Requests">👀</a> <a href="#projectManagement-Lakhankumawat" title="Project Management">📆</a></td>
    <td align="center"><a href="https://n4i9kita.github.io/"><img src="https://avatars.githubusercontent.com/u/60391776?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Nikita Sharma</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=n4i9kita" title="Code">💻</a> <a href="https://github.com/Lakhankumawat/LearnCPP/pulls?q=is%3Apr+reviewed-by%3An4i9kita" title="Reviewed Pull Requests">👀 🚧</a></td>
   <td align="center"><a href="https://github.com/miraj0507"><img src="https://avatars.githubusercontent.com/u/62544210?v=4?s=100" width="100px;" alt=""/><br /><sub><b>SK MIRAJ</b></sub></a><br />💻 👀 🚧 </td>
      <td align="center"><a href="https://github.com/iamgunjan"><img src="https://avatars.githubusercontent.com/u/53567221?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Gunjan</b></sub></a><br />💻 👀 🚧 </td>
      <td align="center"><a href="https://github.com/siddhi-244"><img src="https://avatars.githubusercontent.com/u/69195262?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Siddhi Bhanushali</b></sub></a><br />💻 👀 🚧 </td>
    <td align="center"><a href="https://github.com/Poojaamangal"><img src="https://avatars.githubusercontent.com/u/91134877?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Pooja Mangal</b></sub></a><br />👀</td>
      <td align="center"><a href="https://github.com/Mrjoy832"><img src="https://avatars.githubusercontent.com/u/77873383?v=4?s=100" width="100px;" alt=""/><br /><sub><b>TRIDIB BAG</b></sub></a><br />👀</td>
  </tr>
  <tr>
  <td align="center"><a href="https://github.com/aditi944"><img src="https://avatars.githubusercontent.com/u/68181276?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Aditi</b></sub></a><br />👀</td>
    <td align="center"><a href="https://github.com/vilsi12"><img src="https://avatars.githubusercontent.com/u/53365687?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Vilsi Jain</b></sub></a><br />👀</td>
  </tr>
</table>

<br>
<br>


- ## Array

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [Array Operations](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#array-operations)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/arrayOperations.cpp)|
| 2 | [Antispiral Matrix](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#printing-matrix-in-antispiral-form)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/AntispiralMatrix.cpp)|
| 3  | [Counting Divisibl eSubstrings](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#counting-divisible-substrings)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/CountingDivisibleSubstrings.cpp)|
| 4  | [First Negative in Every Window](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#first-negative-integer-in-every-k-size-window)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/FirstNegativeInEveryWindow.cpp)|
| 5  | [Maximum Sum Subarray](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#maximum-sum-of-subarray)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/MaximumSumSubarray.cpp)|
| 6  | [Missing and Repeating Number](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#printing-matrix-for-find-the-missing-and-repeating-number)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/MissingAndRepeatingNumber.cpp)|
| 7  | [Peak in 1D Array](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#peak-in-1d-array)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/Peak.cpp)|
| 8  |  [Prefix Sum](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#prefix-sum) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/PrefixSum.cpp)|
| 9  | [Reversing of Array](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#reversing-of-array)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/Reversingofarray.cpp)|
| 10  | [Sort an Array of 0's 1's and 2's](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#sort-an-array-of-0s-1s-and-2s)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/Sort_0_1_2.cpp)|
| 11  |  [Best Time to Buy and Sell Stock](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/README.md) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/Stock%20Buy%20And%20Sell.cpp)|
| 12  |  [Symmetric Matrix](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#symmetric-matrix) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/SymmetricMatrix.cpp)|
| 13  | [Trace and Normal](https://github.com/Lakhankumawat/LearnCPP/tree/main/A-Array#trace-and-normal-of-matrix)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/A-Array/TraceAndNormal.cpp)|


- ## Backtracking

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [Hamiltonian Cycle](https://github.com/Lakhankumawat/LearnCPP/tree/main/B-Backtracking#Hamiltonian-Cycle)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-Backtracking/HamiltonianCycle.cpp)|
| 2  | [N-Queen](https://github.com/Lakhankumawat/LearnCPP/tree/main/B-Backtracking#N-Queen-Problem)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-Backtracking/N-Queen.cpp)|
| 3  | Rat in Maze  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-Backtracking/RatInMaze.cpp)|
| 4  | [Subset Sum](https://github.com/Lakhankumawat/LearnCPP/tree/main/B-Backtracking#Subset-Sum)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-Backtracking/SubsetSum.cpp)|
| 5  | [The Knight’s Tour Problem](https://github.com/Lakhankumawat/LearnCPP/tree/main/B-Backtracking#The-Knight-tour-problem)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-Backtracking/TheKnight%E2%80%99stourproblem.cpp)|


- ## Bit Manipulation

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | Bit Manipulation  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-BitManipulation/BitManipulation.cpp)|
| 2  | Cout Set Bits  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-BitManipulation/Count_set_Bits.cpp)|
| 3  | [Swapping 2 Numbers](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-BitManipulation/Swapping%202%20Numbers/readme.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/B-BitManipulation/Swapping%202%20Numbers/swapping.cpp)|




- ## Disjoint Set Union

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  |  [Disjoint Set Union](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DisjointSetUnion/README.md) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DisjointSetUnion/DSU.cpp)|



- ## Dynamic Programming

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [Rod Cutting](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#rod-cutting)   | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/RodCutting.cpp)|
| 2  | [Equal Sum Partition Problem](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#equal-sum-partition-problem)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/Equal_Sum_Partition.cpp)|
| 3  | [Shortest Common Super-sequence](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#shortest-common-super-sequence)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/ShortestCommonSuperSequence.cpp)|
| 4  | [Trapping Rain Water Problem](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#trapping-rain-water-problem) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/TrappingRainWater.cpp)|
| 5  | [Longest Common Subsequence Problem](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#longest-common-subsequence-problem)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/LongestCommonSubsequence.cpp)|
| 6  | [Egg Dropping Puzzle](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#egg-dropping-puzzle)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/EggDroppingPuzzle.cpp)|
| 7  | [Climbing Stairs](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#climbing-stairs) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/ClimbingStairs.cpp)|
| 8  | [Min Cost Climbing Stairs](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#min-cost-climbing-stairs)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/MinCostClimbingStairs.cpp)|
| 9  | [Unique Paths](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#unique-paths)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/UniquePaths.cpp)|
| 10  | [Unique Paths II](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#unique-paths-ii)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/UniquePaths2.cpp)|
| 11  | [Minimum Falling Path Sum](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#minimum-falling-path-sum)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/MinimumFallingPathSum.cpp)|
| 12  | [Knapsack with Duplicate Items](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#knapsack-with-duplicate-items)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/KnapsackwithDuplicateItems.cpp)|
| 13  | [Minimum number of deletions and insertions required](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#minimum-number-of-deletions-and-insertions-required-to-transform-one-string-into-another)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/MinimumInsertionDeletion.cpp)|
| 14  | [Coin Change](https://github.com/Lakhankumawat/LearnCPP/tree/main/D-DynamicProgramming#coin-change)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/CoinChange.cpp)|
| 15  | [Kadane's Algorithm](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/Kadane's%20Algorithm/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/Kadane's%20Algorithm/Kadane's%20Algorithm.cpp)|
| 16  | 0-1 KnapSack  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/01KnapSack.cpp)|
| 17  | Traveling Sales Person | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/TravelingSalesPerson.cpp)|
| 18  | Subset Sum  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/SubsetSum.cpp)|
| 19 |  Minimun Insertions form Palindrome | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/D-DynamicProgramming/Minimum_insertions_form_palindrome.cpp)|



- ## Extra
| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  |  Turtle | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/E-Extra/turtle.cpp)|
| 2  | Projectile  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/E-Extra/Projectile.cpp)|
| 3 |  Design | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/E-Extra/Design.cpp)|




- ## Graph Algorithms


| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [Multistage Graph Shortest Path](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-GraphAlgorithms/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-GraphAlgorithms/MultistageGraphShortestPath.cpp)|
| 2  | Bellman Ford  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-GraphAlgorithms/S-SingleSourceShortestPath/Bellman_Ford.cpp)|
| 3  | Floyd Warshall  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-GraphAlgorithms/S-SingleSourceShortestPath/floyd_warshall.cpp)|
| 4  | Dijsktra Single Source Shortest Path  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-GraphAlgorithms/S-SingleSourceShortestPath/DijsktraSSSp.cpp)|



- ## Graphs

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | Articulation Points  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/ArticulationPoints.cpp)|
| 2  | Graph Coloring  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/GraphColoring.cpp)|
| 3  |  [Check Bipartite](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/B-BipartiteGraph/README.md) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/B-BipartiteGraph/checkBipartite.cpp)|
| 4  | [Add and delete edge of directed graph in an adjacency matrix](https://github.com/Lakhankumawat/LearnCPP/tree/main/G-Graphs/I-Implementation#add-and-delete-edge-of-directed-graph-in-adjacency-matrix)   | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/I-Implementation/DelAddEdgeAdjacencyMatrix.cpp)|
| 5  | [create and display an adjacency matrix](https://github.com/Lakhankumawat/LearnCPP/tree/main/G-Graphs/I-Implementation#adjacency-matrix)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/I-Implementation/AdjacencyMatrix.cpp)|
| 6 | Adjacency List  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/I-Implementation/AdjacencyList.cpp)|
| 7  | Adjacency List Using Hashmap | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/I-Implementation/AdjListUsingHashmap.cpp)|
|  8 |  Prims | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/M-MinimumSpanningTree/Prims.cpp)|
|  9 | [Prims using Priority Queue](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/M-MinimumSpanningTree/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/M-MinimumSpanningTree/primsPriorityQueue.cpp)|
| 10  | Kruskal  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/M-MinimumSpanningTree/Kruskal.cpp)|
| 11  | [kruskal DSU](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/M-MinimumSpanningTree/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/M-MinimumSpanningTree/kruskalDSU.cpp)|
| 12  | [Ford Fulkerson](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/N-NetworkFlow/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/N-NetworkFlow/fordFulkerson.cpp)|
| 13  | Breadth First Search  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/T-TraversalInGraphs/BreadthFirstSearch.cpp)|
| 14  | Depth First Search  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-Graphs/T-TraversalInGraphs/DepthFirstSearch.cpp)|


- ## Greedy Algorithms

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [Optimal Merge Pattern](https://github.com/Lakhankumawat/LearnCPP/tree/main/G-GreedyAlgorithms#Optimal-Merge-Pattern)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-GreedyAlgorithms/OptimalMergePattern.cpp)|
| 2  | [Huffman Coding](https://github.com/Lakhankumawat/LearnCPP/tree/main/G-GreedyAlgorithms#Huffman-Coding)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-GreedyAlgorithms/HuffmanCoding.cpp)|
| 3  | Fractional KnapSack  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-GreedyAlgorithms/FractionalKnapsack.cpp)|
| 4  | Job Scheduling  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-GreedyAlgorithms/JobSequencing_with_Deadlines.cpp)|
| 5  | Busyman Problem | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/G-GreedyAlgorithms/BusyManProblem.cpp)|




- ## HashMap


| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [HashMaps](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/README.md#HashMaps)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/HashMaps.cpp)|
| 2  | [Map](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/README.md#Map) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/Map.cpp)|
| 3  | [Multimap](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/Multimap.cpp)|
|  4 | [UnorderedMap](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/UnorderedMap.cpp)|
| 5  | [UnorderedMaps CustomHashmaps OperatorOverloading](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/README.md#UnorderedMaps-CustomHashmaps-OperatorOverloading)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/UnorderedMaps-CustomHashmaps-OperatorOverloading.cpp)|
| 6  | [Set](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/Set%26Unordered_Set/readme.md) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/Set%26Unordered_Set/set.cpp)|
|  7 | [Unordered Set](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/Set%26Unordered_Set/readme.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-HashMap/Set%26Unordered_Set/unordered_set.cpp)|



- ## Heap


| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [k largest](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-Heap/README.md#k-largest-elements)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-Heap/klargest.cpp)|
| 2  | [Min Heap](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-Heap/README.md#k-largest-elements)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-Heap/MinHeap.cpp)|
| 3  | [Max Heap](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-Heap/README.md#k-largest-elements)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-Heap/MaxHeap.cpp)|
| 4  | Heapify  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-Heap/Heapify.cpp)|
| 5  | Heap Sort  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/H-Heap/HeapSort.cpp)|




- ## Linked List


| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  |  [Singly Linked List](https://github.com/Lakhankumawat/LearnCPP/tree/main/L-LinkedList/S-SinglyLinkedList#singly-linked-list) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/S-SinglyLinkedList/LinkedListOperations.cpp)|
|  2 | [Removing Duplicates](https://github.com/Lakhankumawat/LearnCPP/tree/main/L-LinkedList/S-SinglyLinkedList#removing-duplicates)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/S-SinglyLinkedList/RemovingDuplicates.cpp)|
|  3 |  [Searching in a linked list](https://github.com/Lakhankumawat/LearnCPP/tree/main/L-LinkedList/S-SinglyLinkedList#searching-in-a-linked-list) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/S-SinglyLinkedList/SearchingInALinkedList.cpp)|
| 4  | [Reverse a Linked List](https://github.com/Lakhankumawat/LearnCPP/tree/main/L-LinkedList/S-SinglyLinkedList#reverse-a-linked-list)   | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/S-SinglyLinkedList/ReverseLinkedList.cpp)|
| 5  | [Middle element of the linked list](https://github.com/Lakhankumawat/LearnCPP/tree/main/L-LinkedList/S-SinglyLinkedList#middle-element-of-the-linked-list)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/S-SinglyLinkedList/middleElementOfLinkedList.cpp)|
| 6  | [Palindrome linked list](https://github.com/Lakhankumawat/LearnCPP/tree/main/L-LinkedList/S-SinglyLinkedList#palindrome-linked-list)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/S-SinglyLinkedList/PalindromeLinkedList.cpp)|
| 7  | [Segregate Even Odd](https://github.com/Lakhankumawat/LearnCPP/tree/main/L-LinkedList/S-SinglyLinkedList#segregate-even-odd)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/S-SinglyLinkedList/SegregateEvenOdd.cpp)|
| 8  | [Merge K Sorted LinkedList](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/Merge%20K%20Sorted%20LinkedList/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/Merge%20K%20Sorted%20LinkedList/merge_k_ll.cpp)|
| 9  | [LRU Cache](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/LRU%20Cache/readme.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/LRU%20Cache/LRUCache.cpp)|
| 10  | Circular Linked Lists  | [Explanation](https://github.com/Lakhankumawat/LearnCPP/tree/main/L-LinkedList/C-CircularLinkedList)|
| 11  |  [Reverse a Doubly Linked List](https://github.com/Lakhankumawat/LearnCPP/blob/main/L-LinkedList/D-DoublyLinkedList/README.md) | [Solution]()|



- ## Mathematical Algorithms

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [SegmentedSieve](https://github.com/Lakhankumawat/LearnCPP/blob/main/M-MathematicalAlgorithms/S-SegmentedSieve/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/M-MathematicalAlgorithms/S-SegmentedSieve/SegmentedSieve.cpp)|
|  2 | [Armstrong number](https://github.com/Lakhankumawat/LearnCPP/tree/main/M-MathematicalAlgorithms#armstrong-number)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/M-MathematicalAlgorithms/ArmstrongNumber.cpp)|
| 3  | Eulid Greatest Common Divisor  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/M-MathematicalAlgorithms/EulidGreatestCommonDivisor.cpp)|
|4   | Prime Sum  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/M-MathematicalAlgorithms/primeSum.cpp)|
|  5 | [Factorial Larger Numbers](https://github.com/Lakhankumawat/LearnCPP/blob/main/M-MathematicalAlgorithms/Factorial%20of%20large%20numbers/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/M-MathematicalAlgorithms/Factorial%20of%20large%20numbers/FactorialLargeNumbers.cpp)|
| 6  | [Juggler Sequence](https://github.com/Lakhankumawat/LearnCPP/blob/main/M-MathematicalAlgorithms/JugglerSequence/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/M-MathematicalAlgorithms/JugglerSequence/JugglerSequence.cpp)|


- ## Miscellaneous

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
|  1 | [Exception Handling](https://github.com/Lakhankumawat/LearnCPP/blob/main/Miscellaneous/README.md)   | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/Miscellaneous/Exception_Handling.cpp)|
| 2  | [Lambda Functions](https://github.com/Lakhankumawat/LearnCPP/blob/main/Miscellaneous/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/Miscellaneous/Lambda_Functions.cpp)|
| 3  | [Friend Class](https://github.com/Lakhankumawat/LearnCPP/blob/main/Miscellaneous/F-Friend/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/Miscellaneous/F-Friend/FriendClass.cpp)|
| 4  | [Friend Function](https://github.com/Lakhankumawat/LearnCPP/blob/main/Miscellaneous/F-Friend/README.md#ffunction)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/Miscellaneous/F-Friend/FriendFunction.cpp)|



- ## Priority Queue

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
|  1 | Priority Queue  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/P-PriorityQueue/PriorityQueue.cpp)|
|  2 | Priority Queue STL Comparator  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/P-PriorityQueue/PriorityQueueSTLComparator.cpp)|




- ## Problem Statements and Solution


| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
|  1 | [Aggressive Cows](https://github.com/Lakhankumawat/LearnCPP/blob/main/P-Problem%20Statements%20%26%20Solution/2-Level%202/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/P-Problem%20Statements%20%26%20Solution/2-Level%202/AggressiveCows.cpp)|
| 2  |  Pair with given sum in sorted doubly linked list | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/P-Problem%20Statements%20%26%20Solution/1-Level%201/two_pointer_on_doubly_linked_list.cpp)|
|  3 | Maximum of all Subarrays of size k  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/P-Problem%20Statements%20%26%20Solution/1-Level%201/max_of_size_k_window.cpp)|
|  4 | Lowercase to Uppercase  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/P-Problem%20Statements%20%26%20Solution/1-Level%201/LowercaseToUppercase.cpp)|
| 5  | Counting Frequencies  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/P-Problem%20Statements%20%26%20Solution/1-Level%201/CountingFrequencies.cpp)|



- ## Queue

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  |  [Queue Using Linked List](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/README.md) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/QueueUsingLinkedList.cpp)|
| 2  | [Queue Using Array](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/QueueUsingArray.cpp)|
| 3  | [Queue STL]  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/QueueSTL.cpp)|
| 4  | [Circular Queue Using LinkedList](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/CircularQueueUsingLinkedList.cpp)|
| 5  |  [Reverse Queue](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/README.md) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/ReverseQueue.cpp)|
|  6 | [Circular Queue Using Array](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/Q-Queue/CircularQueueUsingArray.cpp)|




- ## Recursion


| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
|  1 | [Inversion Count](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/Inversion_Count.cpp)|
| 2  | [Replace PI](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/Replace_%CF%80.cpp)|
| 3  |  [Tower of Hanoi](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/README.md)| [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/TowerofHanoi.cpp)|
| 4  | [Calculating GCD and LCM by Recursion](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/Recursive_GCD_LCM.cpp)|
| 5  | [Taylor series by Horner's rule](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/TaylorsSerieHornersRule.cpp)|
| 6  | [Types of Recursion](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/Types%20of%20Recursion/TreeRecursion.cpp)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/R-Recursion/Types%20of%20Recursion/README.md)|


- ## STL

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  |  [Pairs STL](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-STL/P-Pairs/README.md) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-STL/P-Pairs/PairsSTL.cpp)|
|  2 | Lists-Operation  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-STL/C-Containers/L-List/Lists-Operations.cpp)|
|  3 | Lists  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-STL/C-Containers/L-List/Lists.cpp)|
|  4 | Multiset  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-STL/C-Containers/M-Multiset/MultiSetSTL.cpp)|
|  5 | Sets  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-STL/C-Containers/S-Set/Sets.cpp)|
|  6 | [Vector](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-STL/C-Containers/V-Vector/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/tree/main/S-STL/C-Containers/V-Vector)|



- ## Searching Algorithms

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
|1   |  [Linear Search](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SearchingAlgorithms/README.md#linear-search) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SearchingAlgorithms/SimpleLinearSearch.cpp)|
| 2  | [Binary Search](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SearchingAlgorithms/README.md#binary-search)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SearchingAlgorithms/BinarySearch.cpp)|
| 3  | [Search Element in a Rotated Sorted Array](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SearchingAlgorithms/README.md#search-element-in-rotated-sorted-array)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SearchingAlgorithms/SearchElementRotatedSortedArray.cpp)|



- ## Sets


| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
|  1 | [Cartesian Product of two Set](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Sets/README.md#cartesian-product-of-two-set)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Sets/Cartesian_Product.cpp)|
| 2  | [Union of two sets](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Sets/README.md#Union-of-two-sets)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Sets/SetUnion.cpp)|



- ## Sorting Algorithms

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [Bubble Sort](https://github.com/Lakhankumawat/LearnCPP/tree/main/S-SortingAlgorithms#bubble-sort)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SortingAlgorithms/BubbleSort.cpp)|
| 2  | [Insertion Sort](https://github.com/Lakhankumawat/LearnCPP/tree/main/S-SortingAlgorithms#insertion-sort)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SortingAlgorithms/InsertionSort.cpp)|
| 3  | [Quick Sort](https://github.com/Lakhankumawat/LearnCPP/tree/main/S-SortingAlgorithms#quick-sort)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SortingAlgorithms/QuickSort.cpp)|
| 4  | [Merge Sort](https://github.com/Lakhankumawat/LearnCPP/tree/main/S-SortingAlgorithms#merge-sort)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SortingAlgorithms/MergeSort.cpp)|
| 5  | [Counting Sort](https://github.com/Lakhankumawat/LearnCPP/tree/main/S-SortingAlgorithms#counting-sort)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SortingAlgorithms/CountingSort.cpp)|
| 6  | [Bucket Sort](https://github.com/Lakhankumawat/LearnCPP/tree/main/S-SortingAlgorithms#bucket-sort) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SortingAlgorithms/BucketSort.cpp)|
| 7  | [DNF Sort](https://github.com/Lakhankumawat/LearnCPP/tree/main/S-SortingAlgorithms#dnf-sort)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SortingAlgorithms/DutchNationalFlagSort.cpp)|
| 8  | Selection Sort  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-SortingAlgorithms/SelectionSort.cpp)|




- ## Stack

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [Infix to postfix conversion](https://github.com/Lakhankumawat/LearnCPP/tree/main/S-Stack#infix-to-postfix-conversion)   | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/InfixToPostfix.cpp)|
| 2  | [Redundant Parenthesis](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/RedundantParenthesis/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/RedundantParenthesis/RedudantParenthesis.cpp)|
| 3  | [Stack ADT using Linked List](https://github.com/Lakhankumawat/LearnCPP/tree/main/S-Stack#stack-adt-using-linked-list)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/stackADTUsingLL.cpp)|
|  4 | [Converting decimal number to binary](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/DecimalToBinary.cpp)|
|  5 |  Stacks Without STL | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/StacksWithoutSTL.cpp)|
|  6 |  Stacks STL | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/StacksSTL.cpp)|
|  7 | [Next Greater Element](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/NextGreaterElement/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/NextGreaterElement/nge.cpp)|
| 8  | [Bracket Balancing Using Stack](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/Bracket%20Balancing%20Using%20Stack/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Stack/Bracket%20Balancing%20Using%20Stack/Bracket_Balancing_using_Stack.cpp)|



- ## String Algorithms

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  |  [KMP](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-StringAlgorithms/KMP/README.md) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-StringAlgorithms/KMP/kmp.cpp)|




- ## Strings

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  |  Strings | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Strings/Strings.cpp)|
|  2 | String Toknizer  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Strings/StringToknizer.cpp)|
|  3  | String Sorting  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Strings/StringSorting.cpp)|
| 4  | String Reverse  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Strings/StringReverse.cpp)|
| 5  | [String Comparison](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Strings/README.md#string-comparison)   | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Strings/StringComparison.cpp)|
|  6 | [Longest Word In Sentence](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Strings/README.md#longest-word-in-sentence-1)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Strings/LongestWordInSentence.cpp)|
| 7 | [String Palindrome](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Strings/StringPalindrome/README.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/S-Strings/StringPalindrome/StringPalindrome.cpp)|



- ## Template

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1  | [Class Template](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Template/README.md#classTemplate)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Template/ClassTemplate.cpp)|
|  2 | [Function Template](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Template/README.md#functionTemplate)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Template/FunctionTemplate.cpp)|


- ## Tree

| # | Problem Statement & Explanation | Solution |
| --- | --- | --- |
| 1   | [Ceil Value in BST](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinarySearchTree/Ceil%20Value%20in%20BST/readme.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinarySearchTree/Ceil%20Value%20in%20BST/CeilValue.cpp)|
| 2  |  [Check Valid BST](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinarySearchTree/Check%20Valid%20BST/README.md) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinarySearchTree/Check%20Valid%20BST/checkValidBST.cpp)|
|  3 | [Floor Value in BST](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinarySearchTree/Floor%20Value%20in%20BST/Readme.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinarySearchTree/Floor%20Value%20in%20BST/FloorValueBST.cpp)|
| 4  | BST | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinarySearchTree/BST.cpp)|
| 5  | [AVL](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/B-BinarySearchTree#avl-tree)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinarySearchTree/AVL.cpp)|
| 6  |  [Array to Bst](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/B-BinarySearchTree#Array-to-Bst) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinarySearchTree/Arraytobst.cpp)|
| 7  | [Construct BST From Preorder Travsersal](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/B-BinarySearchTree#Construct-BST-From-Preorder-Travsersal)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinarySearchTree/ConstructBSTFromPreoderTraversal.cpp)|
| 8  | [Height of the binary tree](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/B-BinaryTree#height-of-the-binary-tree)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinaryTree/Height_of_Tree.cpp)|
|  9 | [Largest Bst in a Binary Tree](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/B-BinaryTree#largest-bst-in-a-binary-tree)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinaryTree/LargestBSTinBT.cpp)|
|   10 | [Diameter of Binary Tree](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/B-BinaryTree#diameter-of-the-binary-tree)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinaryTree/Diameter.cpp)|
| 11  | [Number of leaf nodes in binary tree](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinaryTree/Readme.md#number-of-leaf-nodes-in-binary-tree)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/B-BinaryTree/No_of_leaf_nodes.cpp)|
| 12  | [FenwickTree](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/F-FenwickTree/Readme.md)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/F-FenwickTree/K_Query.cpp)|
|  13 |  [Iterative Preorder and Postorder Traversal of Generic Tree](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/G-GenricTree#Iterative-Preorder-and-Postorder-Traversal-of-Generic-Tree) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/G-GenricTree/IterativePreorderandPostorder.cpp)|
|  14 | [Level order traversal in a Genric Tree](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/G-GenricTree#Level-order-traversal-in-a-genric-tree)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/G-GenricTree/LevelOrderTraversalOfaGenricTree.cpp)|
|  15 | [Mirror of a Genric Tree](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/G-GenricTree#Mirror-of-a-genric-tree)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/G-GenricTree/MirrorOfGenricTree.cpp)|
| 16  | [Diameter of a Genric Tree](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/G-GenricTree#Diameter-of-a-genric-tree)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/G-GenricTree/DiameterofGenricTree.cpp)|
| 17  |  [Minimum distance between two nodes in a Genric Tree](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/G-GenricTree#minimum-distance-between-two-nodes-in-a-genric-tree) | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/G-GenricTree/MinimumDistanceBetweenNodeGT.cpp)|
| 18  | [Construct and Display Genric Tree](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/G-GenricTree#construct-and-display-genric-tree)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/G-GenricTree/GenricTree.cpp)|
| 19  | [Diagonal Traversal](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/T-TreeTraversals#diagonal-traversal)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/T-TreeTraversals/DiagonalTraversal.cpp)|
| 20  | [Morris Traversal](https://github.com/Lakhankumawat/LearnCPP/tree/main/T-Tree/T-TreeTraversals#morris-traversal)  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/T-TreeTraversals/Morris_Traversal.cpp)|
|  21 | Preorder Traversal | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/T-TreeTraversals/preorderTraversal.cpp)|
| 22  | Postorder Traversal  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/T-TreeTraversals/postorderTraversal.cpp)|
| 23  | Inorder Traversal  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/T-TreeTraversals/inorderTraversal.cpp)|
|  24 | Levelorder Traversal  | [Solution](https://github.com/Lakhankumawat/LearnCPP/blob/main/T-Tree/T-TreeTraversals/levelorderTraversal.cpp)|




## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="http://lakhankumawat.me/"><img src="https://avatars.githubusercontent.com/u/55774240?v=4?s=100" width="100px;" alt=""/><br /><sub><b>LakhanKumawat ᵖ⁺</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Lakhankumawat" title="Code">💻</a> <a href="https://github.com/Lakhankumawat/LearnCPP/pulls?q=is%3Apr+reviewed-by%3ALakhankumawat" title="Reviewed Pull Requests">👀</a> <a href="#projectManagement-Lakhankumawat" title="Project Management">📆</a></td>
    <td align="center"><a href="https://chetasshree.github.io/"><img src="https://avatars.githubusercontent.com/u/75165587?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Chetas Shree Madhusudhan</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=ChetasShree" title="Code">💻</a></td>
    <td align="center"><a href="https://n4i9kita.github.io/"><img src="https://avatars.githubusercontent.com/u/60391776?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Nikita Sharma</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=n4i9kita" title="Code">💻</a> <a href="https://github.com/Lakhankumawat/LearnCPP/pulls?q=is%3Apr+reviewed-by%3An4i9kita" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/ujjwalban"><img src="https://avatars.githubusercontent.com/u/51720065?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ujjwal Bansal</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=ujjwalban" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Supratim2000"><img src="https://avatars.githubusercontent.com/u/52972176?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Supratim2000</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Supratim2000" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/puneetkaur2929"><img src="https://avatars.githubusercontent.com/u/80326308?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Puneet Kaur</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=puneetkaur2929" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/StarEditorBoy"><img src="https://avatars.githubusercontent.com/u/71385306?v=4?s=100" width="100px;" alt=""/><br /><sub><b>StarEditorBoy</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=StarEditorBoy" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://parthib.netlify.app"><img src="https://avatars.githubusercontent.com/u/74641700?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Parthib Sarkar</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=lucy2512" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/rutujaingole"><img src="https://avatars.githubusercontent.com/u/72335505?v=4?s=100" width="100px;" alt=""/><br /><sub><b>rutujaingole</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=rutujaingole" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Lucifer4255"><img src="https://avatars.githubusercontent.com/u/50608734?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Suhotra Dey</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Lucifer4255" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/officSatyam"><img src="https://avatars.githubusercontent.com/u/100135781?v=4?s=100" width="100px;" alt=""/><br /><sub><b>SATYAM KUMAR</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=officSatyam" title="Code">💻</a> <a href="#example-officSatyam" title="Examples">💡</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/aastik-sharma-8846061b8/"><img src="https://avatars.githubusercontent.com/u/84850243?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Aastik Sharma</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=AastikSharma05" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/shivanithorve01"><img src="https://avatars.githubusercontent.com/u/81226536?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Shivani Thorve</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=shivanithorve01" title="Code">💻</a></td>
    <td align="center"><a href="https://bandism.net/"><img src="https://avatars.githubusercontent.com/u/22633385?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ikko Ashimine</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/pulls?q=is%3Apr+reviewed-by%3Aeltociear" title="Reviewed Pull Requests">👀</a> <a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=eltociear" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://allcontributors.org"><img src="https://avatars.githubusercontent.com/u/46410174?v=4?s=100" width="100px;" alt=""/><br /><sub><b>All Contributors</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=all-contributors" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/gaurangSaraswat-07"><img src="https://avatars.githubusercontent.com/u/56469208?v=4?s=100" width="100px;" alt=""/><br /><sub><b>gaurangSaraswat-07</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=gaurangSaraswat-07" title="Code">💻</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/anurag-kr-singh/"><img src="https://avatars.githubusercontent.com/u/86841935?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Anurag Kumar Singh</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Anuragkr07" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/DlVYANSH"><img src="https://avatars.githubusercontent.com/u/86103131?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Divyansh Singh</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=DlVYANSH" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/VaishnaviMandloi"><img src="https://avatars.githubusercontent.com/u/98760492?v=4?s=100" width="100px;" alt=""/><br /><sub><b>VaishnaviMandloi</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=VaishnaviMandloi" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/adi2002vicky"><img src="https://avatars.githubusercontent.com/u/78430607?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Aditya Kumar Singh</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=adi2002vicky" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/aditim26"><img src="https://avatars.githubusercontent.com/u/91279248?v=4?s=100" width="100px;" alt=""/><br /><sub><b>aditim26</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=aditim26" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/Izhar03"><img src="https://avatars.githubusercontent.com/u/55507957?v=4?s=100" width="100px;" alt=""/><br /><sub><b>IZHAR AHMAD</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Izhar03" title="Code">💻</a></td>
    <td align="center"><a href="https://sites.google.com/view/priyanshu-saxena/home"><img src="https://avatars.githubusercontent.com/u/53018678?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Priyanshu Saxena</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=PriyanshuSaxena2612" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Mrudula-Kulkarni"><img src="https://avatars.githubusercontent.com/u/58851969?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mrudula-Kulkarni</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Mrudula-Kulkarni" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/horosahil"><img src="https://avatars.githubusercontent.com/u/60027035?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sahil Horo</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=horosahil" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/ShruthiKartik"><img src="https://avatars.githubusercontent.com/u/99183334?v=4?s=100" width="100px;" alt=""/><br /><sub><b>ShruthiKartik</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=ShruthiKartik" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Aneesh-07"><img src="https://avatars.githubusercontent.com/u/85986613?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Aneesh Tripathi </b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Aneesh-07" title="Code">💻</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/md-nazish-arman-54076619b/"><img src="https://avatars.githubusercontent.com/u/98539013?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Md Nazish Arman</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=mdnazisharman2803" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/shubhamlakheraa"><img src="https://avatars.githubusercontent.com/u/64166515?v=4?s=100" width="100px;" alt=""/><br /><sub><b>SHUBHAM LAKHERA</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=shubhamlakheraa" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/aparnamittal"><img src="https://avatars.githubusercontent.com/u/100208233?v=4?s=100" width="100px;" alt=""/><br /><sub><b>aparnamittal</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=aparnamittal" title="Code">💻</a></td>
    <td align="center"><a href="https://rahulsharma.vercel.app/"><img src="https://avatars.githubusercontent.com/u/67220225?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Rahul Sharma</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Rahul5430" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Jayanth-MKV"><img src="https://avatars.githubusercontent.com/u/93820457?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jayanth MKV</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Jayanth-MKV" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/SidharthSarangi"><img src="https://avatars.githubusercontent.com/u/78564629?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sidharth Sarangi</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=SidharthSarangi" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Rahul-Kumar-prog"><img src="https://avatars.githubusercontent.com/u/68837569?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Rahul kumar</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Rahul-Kumar-prog" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Purvak-10"><img src="https://avatars.githubusercontent.com/u/76229635?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Purvak Baliyan</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Purvak-10" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/mohammadruman"><img src="https://avatars.githubusercontent.com/u/88760648?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mohammad Ruman</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=mohammadruman" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/vinaya563"><img src="https://avatars.githubusercontent.com/u/91210199?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Vinaya Sree Modem</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=vinaya563" title="Code">💻</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/maithili-kharabe-063a631b1"><img src="https://avatars.githubusercontent.com/u/62667818?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Maithili Kharabe</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=MRK04" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/svenkat19"><img src="https://avatars.githubusercontent.com/u/74498344?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Shashank Venkat</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=svenkat19" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/janhavikale06"><img src="https://avatars.githubusercontent.com/u/81229872?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Janhavi Kale</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=janhavikale06" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Mrjoy832"><img src="https://avatars.githubusercontent.com/u/77873383?v=4?s=100" width="100px;" alt=""/><br /><sub><b>TRIDIB BAG</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Mrjoy832" title="Code">💻</a></td>
    <td align="center"><a href="https://sebinfrancis7.github.io/portfolio"><img src="https://avatars.githubusercontent.com/u/59263190?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sebin Francis</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=sebinfrancis7" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/kalash2205"><img src="https://avatars.githubusercontent.com/u/76390773?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kalash Singhal</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=kalash2205" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Bhavneet345"><img src="https://avatars.githubusercontent.com/u/84433782?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Bhavneet Singh</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Bhavneet345" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/dev24il"><img src="https://avatars.githubusercontent.com/u/98025162?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Jyoti Singh</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=dev24il" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/i-am-aisha"><img src="https://avatars.githubusercontent.com/u/100334178?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Aisha</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=i-am-aisha" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/bhumikatewary"><img src="https://avatars.githubusercontent.com/u/77784592?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Bhumika Tewary</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=bhumikatewary" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/arzitmahajan"><img src="https://avatars.githubusercontent.com/u/73886210?v=4?s=100" width="100px;" alt=""/><br /><sub><b>arzitmahajan</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=arzitmahajan" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/PeritusDeveloper"><img src="https://avatars.githubusercontent.com/u/89828000?v=4?s=100" width="100px;" alt=""/><br /><sub><b>PeritusDeveloper</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=PeritusDeveloper" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/PrashantVIT1"><img src="https://avatars.githubusercontent.com/u/75080313?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Prashant Raj</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=PrashantVIT1" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/ritikagarg0326"><img src="https://avatars.githubusercontent.com/u/86939497?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ritika Garg</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=ritikagarg0326" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Shweta2024"><img src="https://avatars.githubusercontent.com/u/75883328?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Shweta Bhagat</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Shweta2024" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/abhilipsasahoo03"><img src="https://avatars.githubusercontent.com/u/80174214?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Abhilipsa Sahoo</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=abhilipsasahoo03" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Akshat-z"><img src="https://avatars.githubusercontent.com/u/76041127?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Akshat Agarwal</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Akshat-z" title="Code">💻</a></td>
    <td align="center"><a href="https://uhini0201.github.io/Me-Myself/"><img src="https://avatars.githubusercontent.com/u/59994163?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Uhini Mukherjee</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=uhini0201" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Pragati1122"><img src="https://avatars.githubusercontent.com/u/84949697?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Pragati Verma</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Pragati1122" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/dewanshiPaul"><img src="https://avatars.githubusercontent.com/u/92020810?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Dewanshi Paul</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=dewanshiPaul" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Arun9739"><img src="https://avatars.githubusercontent.com/u/84305637?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Arun G Nayak</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Arun9739" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Sukriti-m"><img src="https://avatars.githubusercontent.com/u/93239528?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sukriti</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Sukriti-m" title="Code">💻</a></td>
    <td align="center"><a href="http://sarthakskumar.github.io"><img src="https://avatars.githubusercontent.com/u/81763561?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sarthak S Kumar</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=SarthakSKumar" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/deepu0201"><img src="https://avatars.githubusercontent.com/u/73191735?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Deeptarshi Biswas</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=deepu0201" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Pranshu321"><img src="https://avatars.githubusercontent.com/u/86917304?v=4?s=100" width="100px;" alt=""/><br /><sub><b>PRANSHU JAIN</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Pranshu321" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Hend123"><img src="https://avatars.githubusercontent.com/u/31670657?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Hend Ahmed</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Hend123" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/Shatakshi-Choudhary"><img src="https://avatars.githubusercontent.com/u/87706725?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Shatakshi-Choudhary</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Shatakshi-Choudhary" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/alyeyad"><img src="https://avatars.githubusercontent.com/u/78499278?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Aly Eyad</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=alyeyad" title="Code">💻</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/michaelehab16/"><img src="https://avatars.githubusercontent.com/u/29122581?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Michael Ehab</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=michaelehab" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/shr-code"><img src="https://avatars.githubusercontent.com/u/84399701?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Shraddha</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=shr-code" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/SanyaGera"><img src="https://avatars.githubusercontent.com/u/75986201?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Sanya Gera</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=SanyaGera" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/utkarsh006"><img src="https://avatars.githubusercontent.com/u/94545831?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Utkarsh Saxena</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=utkarsh006" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/AyuBisht"><img src="https://avatars.githubusercontent.com/u/94152085?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ayushi Bisht</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=AyuBisht" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://www.linkedin.com/in/mirette-amin-439b0281/"><img src="https://avatars.githubusercontent.com/u/29145628?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Mirette Amin</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=miretteamin" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/LakshayN"><img src="https://avatars.githubusercontent.com/u/67185564?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Lakshay Narula</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=LakshayN" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/SupriyaKumari08"><img src="https://avatars.githubusercontent.com/u/84588360?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Supriya Kumari </b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=SupriyaKumari08" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/gp919934"><img src="https://avatars.githubusercontent.com/u/86097554?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Gaurav Patel</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=gp919934" title="Code">💻</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/nishkarsh800/"><img src="https://avatars.githubusercontent.com/u/94742536?v=4?s=100" width="100px;" alt=""/><br /><sub><b>NISHKARSH SAXENA</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=nishkarsh800" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/Purva-Gharat"><img src="https://avatars.githubusercontent.com/u/69976168?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Purva-Gharat</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Purva-Gharat" title="Code">💻</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/yasmeenelkararty/"><img src="https://avatars.githubusercontent.com/u/66736704?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Yasmeen ElKararty</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=YasmeenKararty" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/Chahat-M"><img src="https://avatars.githubusercontent.com/u/76607503?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Chahat Mittal</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=Chahat-M" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/riyasingh240601"><img src="https://avatars.githubusercontent.com/u/99318546?v=4?s=100" width="100px;" alt=""/><br /><sub><b>riya singh</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=riyasingh240601" title="Code">💻</a></td>
    <td align="center"><a href="https://072arushi.github.io/portfolio_website/"><img src="https://avatars.githubusercontent.com/u/87575658?v=4?s=100" width="100px;" alt=""/><br /><sub><b>arushi_garg</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=072arushi" title="Code">💻</a></td>
    <td align="center"><a href="https://www.linkedin.com/in/shiwangi-kumari-5b0b3b1b7/"><img src="https://avatars.githubusercontent.com/u/77545230?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Shiwangi Kumari</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=sshiwangi" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/R-Ayush777"><img src="https://avatars.githubusercontent.com/u/78534043?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Ayush Rudani</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=R-Ayush777" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/mugdhaPandey"><img src="https://avatars.githubusercontent.com/u/98265153?v=4?s=100" width="100px;" alt=""/><br /><sub><b>mugdhaPandey</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=mugdhaPandey" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/rahulXbarnwal"><img src="https://avatars.githubusercontent.com/u/78689930?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Rahul Barnwal</b></sub></a><br /><a href="https://github.com/Lakhankumawat/LearnCPP/commits?author=rahulXbarnwal" title="Code">💻</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind are welcome!


## Happy Coding !!
<br><br><hr>
  <h6 align="center">© LearnCPP 2022 <br>
  All Rights Reserved</h6>

<p align="center">
Developed with ❤️ in India 🇮🇳 
</p>
