//A graph Can be said bipartite  the graph can be coloured using 2 colours only such a way that no 2 adjacent vertex will be of same colour
//Here its explained using BFS algorithm 

//CODE:

#include<bits/stdc++.h>
using namespace std;
bool bipartite(int src, vector<int>adj[],int color[]){
    queue<int>q;
    q.push(src);
    color[src]=1;
    while(!q.empty()){
        int node=q.front();
        q.pop();

        for(auto it:adj[node]){
            if(color[it]==-1){
                color[it]=1-color[node];
                q.push(it);
            }

            else if(color[it]==color[node])
            {
                return false;
            }
        }
    }
    return true;

}


bool checkBipartite(vector<int>adj[], int n){
    int color[n];
    memset(color,-1,sizeof color);//to set all value memset is used
    for(int i=0;i<n;i++){
        if(color[i]==-1){
            if(!bipartite(i,adj,color)){
                return false;
            }
        }
    }
    return true;
}


int main(){
    int n,m; //n=nodes, m=edges
    cin>>n>>m;
    vector<int>adj[n];
    for(int i=0;i<m;i++){
        int u,v;
        cin>>u>>v;
        adj[u].push_back(v);
        adj[v].push_back(u);

    }

    if(checkBipartite(adj,n)){
        cout<<"yes";
    }

    else{
        cout<<"no";
    }
}


//INPUT: 1 
/*
8 7 
0 1 
1 2 
2 3 
3 4 
4 6 
6 7 
1 7
4 5 
*/
//Output :   yes


//INPUT: 2
/*
7 7 
0 1 
1 2 
2 3 
3 4 
4 6 
6 1
4 5
*/

//Output:  no