<?php
declare(strict_types = 1);

namespace LMS\Routes\Tests\Acceptance\Backend;

/* * *************************************************************
 *
 *  Copyright notice
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************* */

use LMS\Routes\Tests\Acceptance\Support\BackendTester;

/**
 * @author Sergey Borulko <borulkosergey@icloud.com>
 */
class ModuleCest
{
    public function _before(BackendTester $I)
    {
        $I->useExistingSession('admin');

        $I->click('LMS: Routes', '#site_RoutesRoutes');

        $I->switchToContentFrame();
    }

    public function list_view_visible(BackendTester $I)
    {
        $I->wantTo('I want to have a look at existing routes');

        $I->waitForElement('#routes', 5);
    }

    public function detail_view_visible(BackendTester $I)
    {
        $I->wantTo('I want to select an existing route and see its details.');

        $I->click('#route_1');

        $I->waitForElement('.panel', 5);
    }
}
