/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.board;
import game.player;
import game.type;

public class game_engine {
    public board Board;
    public player player1;
    public player player2;
    private int row;
    private int col;
    private int depth;
    private boolean IsPlayer1Turn;

    public game_engine(board Board, player p1, player p2) {
        this.Board = Board;
        this.player1 = p1;
        this.player2 = p2;
        this.depth = 0;
        this.IsPlayer1Turn = true;
    }

    public boolean get_IsPlayer1Turn() {
        return this.IsPlayer1Turn;
    }

    public void set_IsPlayer1Turn(boolean IsPlayer1Turn) {
        this.IsPlayer1Turn = IsPlayer1Turn;
    }

    public boolean IsMoveLeft() {
        this.row = 0;
        while (this.row < this.Board.get_no_of_rows()) {
            this.col = 0;
            while (this.col < this.Board.get_no_of_coloumns()) {
                if (this.Board.game_board[this.row][this.col] == type.pieces.emp) {
                    return true;
                }
                ++this.col;
            }
            ++this.row;
        }
        return false;
    }

    public int evaluate_score(int depth) {
        type.pieces type2 = type.pieces.emp;
        this.row = 0;
        while (this.row < this.Board.get_no_of_rows()) {
            type2 = this.Board.game_board[this.row][0];
            this.col = 0;
            while (this.col < this.Board.get_no_of_coloumns() && this.Board.game_board[this.row][this.col] == type2) {
                ++this.col;
            }
            if (this.col == this.Board.get_no_of_coloumns()) {
                if (type2 == this.player1.get_piece_type()) {
                    return 10 - depth;
                }
                if (type2 == this.player2.get_piece_type()) {
                    return depth - 10;
                }
            }
            ++this.row;
        }
        this.col = 0;
        while (this.col < this.Board.get_no_of_coloumns()) {
            type2 = this.Board.game_board[0][this.col];
            this.row = 0;
            while (this.row < this.Board.get_no_of_rows() && this.Board.game_board[this.row][this.col] == type2) {
                ++this.row;
            }
            if (this.row == this.Board.get_no_of_rows()) {
                if (type2 == this.player1.get_piece_type()) {
                    return 10 - depth;
                }
                if (type2 == this.player2.get_piece_type()) {
                    return depth - 10;
                }
            }
            ++this.col;
        }
        type2 = this.Board.game_board[0][0];
        this.row = 0;
        while (this.row < this.Board.get_no_of_rows() && this.Board.game_board[this.row][this.row] == type2) {
            ++this.row;
        }
        if (this.row == this.Board.get_no_of_rows()) {
            if (type2 == this.player1.get_piece_type()) {
                return 10 - depth;
            }
            if (type2 == this.player2.get_piece_type()) {
                return depth - 10;
            }
        }
        this.row = 0;
        this.col = this.Board.get_no_of_coloumns() - 1;
        type2 = this.Board.game_board[this.row][this.col];
        while (this.col >= 0 && this.Board.game_board[this.row][this.col] == type2) {
            ++this.row;
            --this.col;
        }
        if (this.col < 0) {
            if (type2 == this.player1.get_piece_type()) {
                return 10 - depth;
            }
            if (type2 == this.player2.get_piece_type()) {
                return depth - 10;
            }
        }
        return 0;
    }

    public int minimax(boolean isMax, int depth) {
        int score = this.evaluate_score(depth + 1);
        if (score > 0) {
            return score;
        }
        if (score < 0) {
            return score;
        }
        if (!this.IsMoveLeft()) {
            return 0;
        }
        if (isMax) {
            int best = -1000;
            for (int i = 0; i < this.Board.get_no_of_rows(); ++i) {
                for (int j = 0; j < this.Board.get_no_of_coloumns(); ++j) {
                    if (this.Board.game_board[i][j] != type.pieces.emp) continue;
                    this.Board.game_board[i][j] = this.player1.get_piece_type();
                    best = Math.max(best, this.minimax(!isMax, depth + 1));
                    this.Board.game_board[i][j] = type.pieces.emp;
                }
            }
            return best;
        }
        int best = 1000;
        for (int i = 0; i < this.Board.get_no_of_rows(); ++i) {
            for (int j = 0; j < this.Board.get_no_of_coloumns(); ++j) {
                if (this.Board.game_board[i][j] != type.pieces.emp) continue;
                this.Board.game_board[i][j] = this.player2.get_piece_type();
                best = Math.min(best, this.minimax(!isMax, depth + 1));
                this.Board.game_board[i][j] = type.pieces.emp;
            }
        }
        return best;
    }

    public int[] findBestMove() {
        int bestVal = -1000;
        int[] bestMove = new int[]{-1, -1, -1};
        System.out.println("Computer is evaluting the best possible move.......");
        for (int i = 0; i < this.Board.get_no_of_rows(); ++i) {
            for (int j = 0; j < this.Board.get_no_of_coloumns(); ++j) {
                if (this.Board.game_board[i][j] != type.pieces.emp) continue;
                this.Board.game_board[i][j] = this.player1.get_piece_type();
                int moveVal = this.minimax(false, 0);
                this.Board.game_board[i][j] = type.pieces.emp;
                if (moveVal <= bestVal) continue;
                bestMove[0] = i;
                bestMove[1] = j;
                bestMove[2] = bestVal = moveVal;
            }
        }
        System.out.println("done, Best possible move is " + bestMove[0] + "," + bestMove[1] + " with score " + bestVal);
        return bestMove;
    }
}

