/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public enum SoundEffect {
    WINNING("sounds/win.wav"),
    START("sounds/start.wav"),
    WARNING("sounds/warn.wav"),
    HELP("sounds/help.wav"),
    LOSING("sounds/lose.wav"),
    CLICK("sounds/click.wav"),
    BUTTONCLICK("sounds/buttonclick.wav"),
    DRAW("sounds/draw.wav");

    public static Volume volume;
    private Clip clip;

    private SoundEffect(String soundFileName) {
        try {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(soundFileName);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(url);
            this.clip = AudioSystem.getClip();
            this.clip.open(audioInputStream);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void play() {
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.start();
        }
    }

    public void stop() {
        if (this.clip.isRunning()) {
            this.clip.stop();
        }
        this.clip.setFramePosition(0);
    }

    static void init() {
        SoundEffect.values();
    }

    static {
        volume = Volume.LOW;
    }

    public static enum Volume {
        MUTE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

