# Pixel Paint

Make intuitve pixel art in this simple drawing tool written in _vanilla javascript_ :cake:

![Image](gif/selectionCopy.gif)

## Features
- [x] 100% vanilla javascript!
- [x] pencil, fill, eraser, selection and colorpicker tools
- [x] implements undo and redo with a stack of canvas states
- [x] color palette from the NES and Gameboy
- [x] save your pixel art to PNG
- [x] original 32x32 cursors/button icons

## Hotkeys

| Command          | Hotkey              |
| :--------------- | :------------------ |
| pencil mode      | P                   |
| bucket mode      | B                   |
| mode eraser mode | E                   |
| colorpicker mode | V                   |
| selection mode   | S                   |
| copy selection   | ALT+click and drag  |
| delete selected area | Del or Backspace| 
| remove selection | Esc                 |
| toggle grid      | G                   |
| undo             | Z                   |
| redo             | X                   |
| color swap       | C                   |


## Contributing

One of the joys of posting this project on Github is to get people excited and wanting to contribute to them. Feel free to create Pull Requests for any changes that you think the app could benifit from, or something that you would like to use.

Have a look at some of the [Issues](https://github.com/Kully/pixel-paint/issues) in the repo. If you see something you want to add or comment on, by all means do so!

Have fun and be creative! :art:
