# GPT-Over-API

GPT-Over-API is a lightweight client for OpenAI's GPT language model, which uses a cost-effective API. The client can be easily run from an HTML file in your browser and has no third-party dependencies or servers, making it a simple and secure solution for interacting with GPT which keeps your API token in safe.

## Getting Started

To get started with the GPT-Over-API chat client, simply download the `index.html` file to your computer and open it in your web browser. Once the page loads, you will need to provide your API token to begin using the chat client. If you do not have an API token yet, it can easily be generated on the OpenAI website using link provided in the app.

## Demo

Check out our live [Demo](https://krivich.github.io/GPT-Over-API/) to see GPT-Over-API in action!



## Main Features
1. Easy to use alternative client for ChatGPT
1. Uses a cost-effective API instead of buying a ChatGPT Plus subscription
1. ChatGPT responses can be cut off mid-sentence. This client lets you set a token limit to prevent this issue
1. ChatGPT responses can vary greatly between conversations. Here you to customize parameters like model selection and temperature for more consistent responses
1. Long discussions can be hindered by incorrect responses and discarded hypotheses. Our client lets you specify context data for generating more accurate and relevant answers
1. Serverless HTML & JS client, fully self-contained with no dependencies. Open-source and minimalistic, providing maximum freedom to add features and use in any browser

## Contributing

We welcome contributions from anyone interested in improving GPT-Over-API! This is a very early and basic version of the client, and there is much room for improvement. If you have ideas for new features or improvements, please feel free to submit a pull request. Together, we can make GPT more accessible and useful for everyone.

Note: This project is not affiliated with or endorsed by OpenAI.
