# Contributing to Awesome Guidelines

Thank you for taking the time to contribute! :+1:

## How Can I Contribute?

### Creating Issues

Know of an awesome guideline that’s missing from the list? If it’s not already mentioned in the [open issues](https://github.com/Kristories/awesome-guidelines/issues) or [pull requests](https://github.com/Kristories/awesome-guidelines/pulls), please feel free to create a new issue or submit a pull request. We’d love to hear from you!

### Submitting Pull Requests

You’re welcome to work on any open issue. Just ensure you follow the contribution guidelines while submitting your PR.

### Voting and Commenting

Join the conversation on GitHub Discussions ([Resource suggestions](https://github.com/Kristories/awesome-guidelines/discussions/categories/resource-suggestions)) to vote and provide feedback.

## Contribution Guidelines

* Please search previous suggestions before making a new one, as yours may be a duplicate.
* Use the following format: `[Title](url) - Description.`
* The link should be the name of the package or project.
* Links and categories should be sorted alphabetically.
* Add one link per pull-request.
* Keep descriptions concise, clear and simple, and end them with a period/stop.
* Check your spelling and grammar.
* New categories, or improvements to the existing ones are also welcome.
* Make sure your text editor is set to remove trailing whitespace.

## Quality Standards

Projects listed should meet these criteria to maintain quality:

* Widely used and beneficial to the community.

Thank you to all our [contributors](https://github.com/Kristories/awesome-guidelines/graphs/contributors)! This project wouldn’t be possible without your support.
