<p align="center">
    <img alt="Awesome Guidelines" src="https://repository-images.githubusercontent.com/97054975/e4621f95-3b09-48d7-85e4-244cdbd98bba"/>
</p>

# Awesome Guidelines [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)

A set of guidelines for a specific programming language that provides recommendations on programming style, best practices, and methods for various aspects of writing programs in that language.

## Contents

- [Programming Languages](#programming-languages)
- [Development Environment](#development-environment)
- [Platforms](#platforms)
- [Frameworks](#frameworks)
- [Content Management System](#content-management-system)
- [Tools](#tools)
- [Contributors](#contributors)

## Programming Languages

### Brainfuck

- [BF Style Guide](https://codepen.io/renmans/full/JjdJPpW)

### C

- [C Coding Standard](https://users.ece.cmu.edu/~eno/coding/CCodingStandard.html)
- [C Programming/Structure and style](https://en.wikibooks.org/wiki/C_Programming/Structure_and_style)
- [Making The Best Use of C](https://www.gnu.org/prep/standards/html_node/Writing-C.html) - This chapter provides advice on how best to use the C language when writing GNU software.

### C#

- [C# Coding Conventions](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/coding-style/coding-conventions)
- [C# Style Guide](https://github.com/kodecocodes/c-sharp-style-guide)
- [C# Coding Standards and Naming Conventions](http://www.dofactory.com/reference/csharp-coding-standards)

### C++

- [Google C++ Style Guide](https://google.github.io/styleguide/cppguide.html)
- [C++ Core Guidelines](http://isocpp.github.io/CppCoreGuidelines/CppCoreGuidelines) - A set of tried-and-true guidelines, rules, and best practices about coding in C++.
- [LLVM C++ Coding Standards](https://llvm.org/docs/CodingStandards.html)
- [Mozilla C++ Coding style](https://firefox-source-docs.mozilla.org/code-quality/coding-style/coding_style_cpp.html)
- [Chromium C++ style guide](https://chromium.googlesource.com/chromium/src/+/HEAD/styleguide/c++/c++.md)
- [Webkit C++ Code Style Guidelines](https://webkit.org/code-style-guidelines/)
- [NASA C++ Coding Standards and Style Guide](https://ntrs.nasa.gov/api/citations/20080039927/downloads/20080039927.pdf)
- [OceanBase C++ Coding Standards](https://oceanbase.github.io/oceanbase/coding_standard.html)

### Clojure

- [The Clojure Style Guide](https://github.com/bbatsov/clojure-style-guide) - A community coding style guide for the Clojure programming language.

### Common Lisp

- [Style Guide](http://lisp-lang.org/style-guide/)
- [Google Common Lisp Style Guide](https://google.github.io/styleguide/lispguide.xml)
- [Common Lisp Style Guide](http://labs.ariel-networks.com/cl-style-guide.html)

### D

- [The D Style](https://dlang.org/dstyle.html) - A set of style conventions for writing D programs.

### Dart

- [Effective Dart](https://dart.dev/effective-dart)

### Delphi

- [Delphi's Object Pascal Style Guide](https://docwiki.embarcadero.com/RADStudio/Alexandria/en/Delphi%E2%80%99s_Object_Pascal_Style_Guide)

### Elixir

- [Elixir Styleguide](https://github.com/christopheradams/elixir_style_guide)

### Elm

- [Elm style guide](http://elm-lang.org/docs/style-guide)

### Emacs Lisp

- [Elisp Guide](https://github.com/chrisdone/elisp-guide)
- [Emacs Lisp Style Guide](https://github.com/bbatsov/emacs-lisp-style-guide)

### Erlang

- [Programming Rules and Conventions](http://www.erlang.se/doc/programming_rules.shtml)
- [Erlang Coding Guidelines](https://github.com/inaka/erlang_guidelines)

### F#

- [The F# Component Design Guidelines](https://learn.microsoft.com/en-us/dotnet/fsharp/style-guide/component-design-guidelines)

### Fortran

- [Fortran 90 Standards](http://research.metoffice.gov.uk/research/nwp/numerical/fortran90/f90_standards.html) - European Standards For Writing and Documenting Exchangeable Fortran 90 Code.
- [Fortran Best Practices](https://fortran-lang.org/en/learn/best_practices/) - Style guide and best practices for modern Fortran programs.

### Go

- [Effective Go](https://go.dev/doc/effective_go)
- [Go Standard Project Layout](https://github.com/golang-standards/project-layout) - Basic layout for Go applications.
- [Google Go Style Guide](https://google.github.io/styleguide/go) - Google's coding standards for source code in Go.
- [Uber Go Style Guide](https://github.com/uber-go/guide/blob/master/style.md) - Patterns and conventions used in Go code at Uber.

### Groovy

- [Apache Groovy style guide](http://groovy-lang.org/style-guide.html)

### Haskell

- [Haskell Programming guidelines](https://wiki.haskell.org/Programming_guidelines)

### Java

- [Code Conventions for the Java™ Programming Language](http://www.oracle.com/technetwork/java/codeconvtoc-136057.html)
- [Google Java Style Guide](https://google.github.io/styleguide/javaguide.html) - Google's coding standards for source code in the Java™ Programming Language.
- [Java Programming Style Guide](http://javaranch.com/style.jsp)
- [Alibaba-Java-Coding-Guidelines](https://alibaba.github.io/Alibaba-Java-Coding-Guidelines/) - A guide for Java developers.

### JavaScript

- [AngularJS Style Guide](https://github.com/mgechev/angularjs-style-guide) - Community-driven set of best practices for AngularJS application development.
- [JavaScript The Right Way](http://jstherightway.org) - An easy-to-read, quick reference for JS best practices, accepted coding standards, and links around the Web.
- [Google JavaScript Style Guide](https://google.github.io/styleguide/jsguide.html) - This document serves as the complete definition of Google's coding standards for source code in the JavaScript programming language.
- [Airbnb JavaScript Style Guide](https://github.com/airbnb/javascript) - A mostly reasonable approach to JavaScript.
- [jQuery Core Style Guide](http://contribute.jquery.org/style-guide/js/)
- [JavaScript Style Guides And Beautifiers](https://addyosmani.com/blog/javascript-style-guides-and-beautifiers/)
- [JavaScript Style Guide and Coding Conventions](https://www.w3schools.com/js/js_conventions.asp)
- [Code Conventions for the JavaScript](http://crockford.com/javascript/code.html)
- [JavaScript Clean Code](https://github.com/ryanmcdermott/clean-code-javascript) - Software engineering principles, from Robert C. Martin's book [Clean Code](https://www.amazon.com/Clean-Code-Handbook-Software-Craftsmanship/dp/0132350882), adapted for JavaScript.
- [Mozilla Coding Style Guide for JavaScript](https://developer.mozilla.org/en-US/docs/MDN/Writing_guidelines/Writing_style_guide/Code_style_guide/JavaScript)

### JSON

- [Google JSON Style Guide](https://google.github.io/styleguide/jsoncstyleguide.xml)

### Julia

- [Blue Style](https://github.com/JuliaDiff/BlueStyle)

### Kotlin

- [Coding Conventions](https://kotlinlang.org/docs/coding-conventions.html)

### Lua

- [Lua Style Guide](http://lua-users.org/wiki/LuaStyleGuide)

### Markdown

- [Google Markdown Style Guide](https://github.com/google/styleguide/blob/gh-pages/docguide/style.md) - Style guide for Google-originated projects using Markdown.
- [Markdown Style Guide](http://www.cirosantilli.com/markdown-style-guide/)
- [GitLab Markdown Style Guide](https://about.gitlab.com/handbook/markdown-guide/) - Markdown Style Guide for about.GitLab.com.

### .NET

- [.NET Standard](https://github.com/dotnet/standard)
- [.NET Secure Coding Guidelines](https://learn.microsoft.com/en-us/dotnet/standard/security/secure-coding-guidelines)
- [.NET Naming Guidelines](https://learn.microsoft.com/en-us/dotnet/standard/design-guidelines/naming-guidelines)

### Nim

- [Nim Style Guide](https://nim-lang.org/docs/nep1.html)

### Objective-C

- [Objective-C Style guide](https://github.com/github/objective-c-style-guide) - Style guide & coding conventions for Objective-C projects.
- [Google Objective-C Style Guide](https://github.com/google/styleguide/blob/gh-pages/objcguide.md)
- [NYTimes Objective-C Style Guide](https://github.com/NYTimes/objective-c-style-guide) - The Objective-C Style Guide used by The New York Times.

### Pascal

- [Coding style](http://wiki.freepascal.org/Coding_style)
- [GNU Pascal Coding Standards](https://edoras.sdsu.edu/doc/gpcs-en.html) - GNU Pascal standards used by GNU Pascal project.

### Perl

- [Perl best practices v4](https://www.slideshare.net/RandalSchwartz/perl-best-practices-v4) - Slides by Randal Schwartz, based on the book by Damian Conway.
- [Perl Elements to Avoid](http://perl-begin.org/tutorials/bad-elements/) - A list of unrecommended practices, and what to do instead.
- [perlstyle](https://perldoc.perl.org/perlstyle)

### PHP

- [PHP FIG](http://www.php-fig.org/psr/) - PHP Standards Recommendations.
- [PHP The Right Way](http://www.phptherightway.com) - An easy-to-read, quick reference for PHP best practices, accepted coding standards, and links to authoritative tutorials around the Web.
- [Clean Code PHP](https://github.com/piotrplenik/clean-code-php) - Clean Code concepts adapted for PHP.

### Python

- [Style Guide for Python Code](https://peps.python.org/pep-0008/)
- [Google Python Style Guide](https://google.github.io/styleguide/pyguide.html)
- [The Hitchhiker's Guide to Python](https://docs.python-guide.org/) - Highly regarded Python best practices guide.

### R

- [Google's R Style Guide](https://google.github.io/styleguide/Rguide.html)
- [The tidyverse style guide](http://style.tidyverse.org)

### Racket

- [How to Program Racket: a Style Guide](http://docs.racket-lang.org/style/index.html)

### Ruby

- [The Ruby Style Guide](https://rubystyle.guide) - A community-driven Ruby coding style guide.
- [Ruby Style Guide](https://github.com/airbnb/ruby) - Airbnb's Ruby Style Guide.
- [Ruby Style Guide](https://github.com/rubocop/ruby-style-guide) - A community-driven Ruby coding style guide.

### Rust

- [Rust Style Guide](https://github.com/rust-lang/rust/tree/HEAD/src/doc/style-guide/src)
- [Rust Guidelines](http://aturon.github.io)
- [Rust API Guidelines](https://rust-lang.github.io/api-guidelines/)

### Scala

- [Effective Scala](https://twitter.github.io/effectivescala/)
- [Scala Style Guide](http://docs.scala-lang.org/style/)
- [Databricks Scala Guide](https://github.com/databricks/scala-style-guide) - Databricks Scala Coding Style Guide.
- [Scala Best Practices](https://github.com/alexandru/scala-best-practices)

### Solidity

- [Solidity Style Guide](https://docs.soliditylang.org/en/latest/style-guide.html)
- [Solcurity Standard](https://github.com/transmissions11/solcurity)

### Swift

- [API Design Guidelines](https://www.swift.org/documentation/api-design-guidelines/)
- [Swift](https://github.com/github/swift-style-guide) - GitHub Official Swift style and conventions.
- [Swift style guide](https://github.com/kodecocodes/swift-style-guide)
- [Swift Style Guide](https://github.com/linkedin/swift-style-guide) - LinkedIn Official Swift Style Guide.
- [Metova's Swift style guide](https://github.com/metova/swift-style-guide)
- [Xmartlabs Swift Style Guide](https://github.com/xmartlabs/Swift-Style-Guide) - Swift language style guide & coding conventions followed by Xmartlabs.

### TypeScript

- [Google TypeScript Style Guide](https://google.github.io/styleguide/tsguide.html) - TypeScript Style Guide used at Google's.
- [Typescript deep dive - Style Guide](https://basarat.gitbook.io/typescript/styleguide) - An unofficial TypeScript Style Guide.
- [Typescript Lang - Do's and Don'ts](https://www.typescriptlang.org/docs/handbook/declaration-files/do-s-and-don-ts.html) - Suggestions from Typescript Lang organization.

### Visual Basic

- [Visual Basic Concepts](<https://msdn.microsoft.com/en-us/library/aa240822(v=vs.60).aspx>)
- [Visual Basic/Coding Standards](https://en.wikibooks.org/wiki/Visual_Basic/Coding_Standards)

### XML

- [Google XML Document Format Style Guide](https://google.github.io/styleguide/xmlstyle.html)

## Development Environment

### Shell

- [Shell Style Guide](https://google.github.io/styleguide/shellguide.html)

### Git

- [Git Style Guide](https://github.com/agis/git-style-guide)
- [Few Rules from Git Documentation](https://github.com/git/git/blob/master/Documentation/CodingGuidelines)

### PowerShell

- [The PowerShell Best Practices and Style Guide](https://github.com/PoshCode/PowerShellPracticeAndStyle) - The Unofficial PowerShell Best Practices and Style Guide.

## Platforms

### Android

- [Android Guidelines](https://github.com/ribot/android-guidelines) - Architecture and code guidelines we use at ribot when developing for Android.
- [Xmartlabs Android Style Guide](https://github.com/xmartlabs/Android-Style-Guide) - Style guide for Android by Xmartlabs.

### Apache

- [Apache Developers' C Language Style Guide](http://httpd.apache.org/dev/styleguide.html)

### API

- [HAL](http://stateless.co/hal_specification.html) - A simple format that gives a consistent and easy way to hyperlink between resources in your API.
- [Microsoft REST API Guidelines](https://github.com/Microsoft/api-guidelines) - The Microsoft REST API Guidelines.
- [JSON API - Recommendations](http://jsonapi.org/recommendations) - This section contains recommendations for JSON API implementations.
- [API Security Checklist](https://github.com/shieldfy/API-Security-Checklist) - Checklist of the most important security countermeasures when designing, testing, and releasing your API.
- [Google Cloud API Design Guide](https://cloud.google.com/apis/design) - A general design guide for networked APIs provided by Google.

### Arduino

- [Arduino style guide](https://www.arduino.cc/)
- [API Style Guide for Arduino](https://docs.arduino.cc/learn/contributions/arduino-library-style-guide/)

### Frontend Development

- [CSS Guidelines](https://cssguidelin.es) - High-level advice and guidelines for writing sane, manageable, scalable CSS.
- [Frontend Guidelines](https://github.com/bendc/frontend-guidelines) - Some HTML, CSS and JS best practices.
- [Sass Guidelines](https://sass-guidelin.es) - An opinionated styleguide for writing sane, maintainable and scalable Sass.
- [Airbnb CSS / Sass Styleguide](https://github.com/airbnb/css) - A mostly reasonable approach to CSS and Sass.
- [HTML Style Guide](https://github.com/marcobiedermann/html-style-guide) - A style guide which helps you write better, performant, structured, scalable and maintainable HTML.
- [HTML + CSS Code Guide](http://codeguide.co) - Standards for flexible, durable, and sustainable HTML and CSS.
- [U.S. Web Design Standards](https://designsystem.digital.gov/) - Open source UI components and visual style guide for U.S. government websites.
- [CoffeeScript Style Guide](https://github.com/polarmobile/coffeescript-style-guide) - A collection of best-practices and coding conventions for the CoffeeScript programming language.
- [LESS Coding Guidelines](https://gist.github.com/fat/a47b882eb5f84293c4ed)
- [Google HTML/CSS Style Guide](https://google.github.io/styleguide/htmlcssguide.html)
- [Guidelines for Responsive Web Design](https://www.smashingmagazine.com/2011/01/guidelines-for-responsive-web-design/)
- [Yelp Styleguide](https://www.yelp.com/styleguide)
- [Front-End Checklist](https://github.com/thedaviddias/Front-End-Checklist)
- [BEM - Block Element Modifier](https://getbem.com/) - A methodology that helps you to create reusable components and code sharing in front‑end development.

### GNU

- [GNU coding standards](https://www.gnu.org/prep/standards/)

### Java

- [JavaEE Specification](https://github.com/javaee/javaee-spec)

### Linux

- [Linux kernel coding style](https://www.kernel.org/doc/html/latest/process/coding-style.html)

### Mailchimp

- [Mailchimp Content Style Guide](https://styleguide.mailchimp.com)

### Mozilla

- [Mozilla Coding Style Guide](https://developer.mozilla.org/en-US/docs/MDN/Writing_guidelines/Writing_style_guide/Code_style_guide)

### Google

- [Google-related developer documentation](https://developers.google.com/style) - This style guide provides editorial guidelines for writing clear and consistent Google-related developer documentation.

### Node.js

- [Microsoft + Node.js Guidelines](https://github.com/Microsoft/nodejs-guidelines)
- [Node.js Style Guide](https://github.com/felixge/node-style-guide) - A guide for styling your Node.js / JavaScript code.

### MongoDB

- [Mongo Style Guide](https://github.com/jsoendermann/MongoStyleGuide)

### SQL

- [SQL Style Guide](https://www.sqlstyle.guide)

### Other

- [Keep a CHANGELOG](http://keepachangelog.com/en/0.3.0/) - Don't let your friends dump git logs into CHANGELOGs™.
- [Project Guidelines](https://github.com/elsewhencode/project-guidelines) - A set of best practices for JavaScript projects.
- [Semantic Versioning](http://semver.org)
- [Indent style](https://en.wikipedia.org/wiki/Indentation_style)
- [WebAppSec/Secure Coding Guidelines](https://wiki.mozilla.org/WebAppSec/Secure_Coding_Guidelines)
- [Robot Framework User Guide](https://robotframework.org/robotframework/latest/RobotFrameworkUserGuide.html)
- [CodeQL Coding Standards](https://github.com/github/codeql-coding-standards)

## Frameworks

- [Symfony Coding Standards](https://symfony.com/doc/current/contributing/code/standards.html)
- [Django Coding Style](https://docs.djangoproject.com/en/dev/internals/contributing/writing-code/coding-style)
- [Vue Style Guide](https://vuejs.org/style-guide)
- [Angular Style Guide](https://angular.dev/style-guide)

## Content Management System

- [WordPress Coding Standards](https://developer.wordpress.org/coding-standards/wordpress-coding-standards/)
- [Drupal Coding Standards](https://www.drupal.org/docs/develop/standards)
- [Magento Coding Standards](https://developer.adobe.com/commerce/php/coding-standards/)
- [Octobercms Developer Guide](https://octobercms.com/help/guidelines/developer)

## Tools

- [Checkstyle](https://github.com/checkstyle/checkstyle) - Tool for checking Java source code for adherence to a Code Standard or set of validation rules.
- [Conventional Changelog](https://github.com/conventional-changelog/conventional-changelog)
- [EasyCodingStandard](https://github.com/easy-coding-standard/easy-coding-standard) - The Easiest Way to Use Any Coding Standard.
- [ESLint](https://eslint.org/) - The pluggable linting utility for JavaScript and JSX.
- [JavaScript Standard Style](https://standardjs.com) - One JavaScript Style to Rule Them All.
- [Laravel Pint](https://laravel.com/docs/11.x/pint) - An opinionated PHP code style fixer for minimalists.
- [North](http://pointnorth.io) - Design and development standards to align and guide your project.
- [PHP_CodeSniffer](https://github.com/squizlabs/PHP_CodeSniffer) - The tool for detecting and fixing the violations of the specified standards in PHP code.
- [PHP Coding Standards Fixer](https://cs.symfony.com) - The PHP Coding Standards Fixer (PHP CS Fixer) tool fixes your code to follow standards.
- [RuboCop](https://rubocop.org) - A Ruby static code analyzer and formatter, based on the community Ruby style guide.
- [semantic-release](https://github.com/semantic-release/semantic-release)
- [ShellCheck](https://github.com/koalaman/shellcheck) - A shell script static analysis tool

## Contributors

We welcome contributions! Please take a moment to review our [contribution guidelines](contributing.md) before getting started.

![Alt](https://repobeats.axiom.co/api/embed/57c7dc64df55706884092f3dc88a198c7daeae04.svg "Repobeats analytics image")

### Code Contributors

This project thrives thanks to the efforts of all contributors.
<a href="https://github.com/Kristories/awesome-guidelines/graphs/contributors"><img src="https://opencollective.com/awesome-guidelines/contributors.svg?width=890&button=false" /></a>

[Contribute on opencollective.com](https://opencollective.com/awesome-guidelines/contribute).
