<p align="center">
  <img src="https://www.linkace.org/images/linkace-social.jpg" title="Linkace">
</p>

<p align="center"><b>Your self-hosted bookmark archive.</b></p>

<p align="center">
  <a href="https://twitter.com/LinkAceApp"><img src="https://img.shields.io/badge/X.com%2FLinkAceApp-black" alt="Follow LinkAce on X.com"></a>
  <a href="https://mastodon.social/@linkace"><img src="https://img.shields.io/badge/%40linkace%40mastodon.social-6364ff" alt="Follow LinkAce on Mastodon"></a>
  <a href="https://github.com/Kovah/LinkAce/releases"><img src="https://img.shields.io/github/v/release/kovah/linkace?label=Latest%20Release" alt="Latest Release"></a>
  <a href="https://opensource.org/licenses/GPL-3.0"><img src="https://img.shields.io/github/license/kovah/linkace.svg" alt="License"></a>
</p>
<p>&nbsp;</p>


### Contents

* [About LinkAce](#about-linkace)
* [Setup](#gear-setup)
* [Support](#bulb-support-for-linkace)
* [Contribution](#construction-contribution)


&nbsp;


### About LinkAce

![Preview Screenshot](https://www.linkace.org/images/preview/linkace_dashboard.png)

LinkAce is a self-hosted archive to collect links of your favorite websites. Save articles to read them later, tools to use them in your next project, or historic content to archive it for the long term. LinkAce comes with a lot of features while keeping a clean and minimal interface.  
It provides a long-term archive to store links to websites, media files or anything else with a valid URL. The user is able to categorize the added links to be able to find them later, and share lists of links with friends, family or coworkers. However, LinkAce should not provide a solution to sync your browser bookmarks.

👉 [**Try the Demo**](https://demo.linkace.org)


#### Feature Highlights

* Save links with automatic title and description generation.
* Automated link monitoring informs you when any links become unavailable or were moved.
* Automated archiving of saved sites via the [Internet Archive](https://web.archive.org/).
* Organize bookmarks with the help of lists and tags.
* A full REST API offers access to all features of LinkAce from other apps and services.
* LinkAce is also [available on Zapier](https://zapier.com/apps/linkace/integrations) and integrates with over 2500+ applications.
* LinkAce ships with a light and dark theme, that can be toggled or changes automatically.
* A bookmarklet to quickly save links from any browser.
* Links can be private or public, so friends or internet strangers may see your collection.
* Both private and public links are accessible via RSS feeds.
* Add notes to links to add thoughts or other relevant information.
* An advanced search including different filters and ordering.
* Import and export of bookmarks from HTML.
* Support for complete database and application backups to any AWS S3 storage.

More screenshots of the app and further details about the features can be found on the [LinkAce Website](https://www.linkace.org/).


&nbsp;


### :gear: Setup

LinkAce provides multiple ways of installing it on your server. The complete documentation for all installation methods can be found [**in the wiki**](https://www.linkace.org/docs/v1/setup/).

* [Setup with Docker](https://www.linkace.org/docs/v1/setup/setup-with-docker/) (_recommended_)
* [Setup without Docker](https://www.linkace.org/docs/v1/setup/setup-without-docker/)


&nbsp;


### :bulb: Support for LinkAce

I built LinkAce to solve my own problem, and I now offer my solution and code without charging any money. I spent a lot of my free time building this application, so I won't offer any *free* personal support, customization or installation help. If you need help please visit the [community discussions](https://github.com/Kovah/LinkAce/discussions) and post your issue there.

:star: You can get personal and dedicated support by **becoming a supporter on [Open Collective](https://opencollective.com/linkace), [Patreon](https://www.patreon.com/Kovah) or [Github](https://github.com/sponsors/Kovah)**.

#### Our Supporters on Open Collective

<a href="https://opencollective.com/linkace"><img src="https://opencollective.com/linkace/individuals.svg?width=890"></a>


### Documentation and Community

Details about all features and advanced configuration can be found in the [**project documentation**](https://www.linkace.org/docs/).  
Additionally, you may visit the [community discussions](https://github.com/Kovah/LinkAce/discussions) to share your ideas, talk with other users or find help for specific problems.


&nbsp;


### :construction: Contribution

[![Translations](https://img.shields.io/badge/Translations-Crowdin-2b303d)](https://crowdin.com/project/linkace) [![Code Climate maintainability](https://img.shields.io/codeclimate/maintainability/Kovah/LinkAce) ![Code Climate coverage](https://img.shields.io/codeclimate/coverage/Kovah/LinkAce)](https://codeclimate.com/github/Kovah/LinkAce) [![GitHub Build Status](https://img.shields.io/github/workflow/status/Kovah/LinkAce/Testing/dev?label=Dev%20Build)](https://github.com/Kovah/LinkAce/actions?query=workflow%3ATesting+branch%3Adev)

Please consult the [**contribution guidelines**](CONTRIBUTING.md) to start working on LinkAce.


&nbsp;


Thanks go to these wonderful people for their contributions:

[![List of contributors](https://contrib.rocks/image?repo=kovah/linkace)](https://github.com/Kovah/LinkAce/graphs/contributors)


&nbsp;


LinkAce is a project by [Kevin Woblick](https://kovah.de) and [Contributors](https://github.com/Kovah/LinkAce/graphs/contributors)
