// Taked from TestBookSources/testdata/git-source/VasielBook/Глава_4/4.11/main.c
#include <stdio.h>
#include <stdlib.h>

/* Динамический массив как результат функции */

/*
 * Функция результатом возвращает динамический массив,
 * заполненный числами Фибоначчи
 */

int* fibs(int n)
{
    /* Если указан некоректный раззмер массива */
    if (n <= 0)
        return 0;

    /* Создание динамического массива */
    int* p = malloc(n * sizeof(int));

    /* Первый элемент массива */
    p[0] = 1;

    /* Если в массиве есть второй элемент */
    if (n > 1)
        p[1] = 1;

    /* Индексная переменная */
    int k;

    /* Заполнение прочих элементов массива */
    for (k = 2; k < n; k++)
        p[k] = p[k - 1] + p[k - 2];

    return p;
}

// main function
//
// begin of program

int main(void)
{
    /* Указатель для записи результатов вызова */
    int* nums;

    /* Переменная для записи размера массива */
    int size;

    /* Считывание размера массива */
    printf("Укажите размер массива: ");
    scanf("%d", &size);

    /* Индексная переменная */
    int k;

    /* Отображение элементов массива */
    for (k = 0; k < size; k++)
        printf("| %d ", nums[k]);

    if (size >= 1)
        printf("|\n");

    /* Удаление массива из памяти */
    if (nums) {
        free(nums);
        printf("Динамический массив удалён\n");
    } else
        printf("Массив не был создан\n");

    return 0;
}
