package ast

import (
	"testing"
)

func TestStringLiteral(t *testing.T) {
	nodes := map[string]Node{
		`0x7fe16f0b4d58 <col:11> 'char [45]' lvalue "Number of command line arguments passed: %d\n"`: &StringLiteral{
			Addr:       0x7fe16f0b4d58,
			Pos:        NewPositionFromString("col:11"),
			Type:       "char [45]",
			IsLvalue:   true,
			Value:      "Number of command line arguments passed: %d\n",
			ChildNodes: []Node{},
		},
		`0x7fe16f0b4d58 <col:11> 'char [45]' lvalue "\\"`: &StringLiteral{
			Addr:       0x7fe16f0b4d58,
			Pos:        NewPositionFromString("col:11"),
			Type:       "char [45]",
			IsLvalue:   true,
			Value:      "\\",
			ChildNodes: []Node{},
		},
		`0x22ac548 <col:14> 'char [14]' lvalue "x\vx\000xxx\axx\tx\n"`: &StringLiteral{
			Addr:       0x22ac548,
			Pos:        NewPositionFromString("col:14"),
			Type:       "char [14]",
			IsLvalue:   true,
			Runes:      false,
			Value:      "x\vx\x00xxx\axx\tx\n",
			ChildNodes: []Node{},
		},
		`0x3ed1658 <col:16> 'int [16]' lvalue L"copy successful"`: &StringLiteral{
			Addr:       0x3ed1658,
			Pos:        NewPositionFromString("col:16"),
			Type:       "int [16]",
			IsLvalue:   true,
			Runes:      true,
			Value:      "copy successful",
			ChildNodes: []Node{},
		},
		`0x2759028 <col:19> 'STRING':'char [100]' lvalue "C"`: &StringLiteral{
			Addr:       0x2759028,
			Pos:        NewPositionFromString("col:19"),
			Type:       "STRING",
			Type2:      "char [100]",
			IsLvalue:   true,
			Runes:      false,
			Value:      "C",
			ChildNodes: []Node{},
		},
	}

	runNodeTests(t, nodes)
}
