package ast

// IfStmt is node represent 'if'
type IfStmt struct {
	Addr       Address
	Pos        Position
	HasElse    bool
	ChildNodes []Node
}

func parseIfStmt(line string) *IfStmt {
	groups := groupsFromRegex(
		"<(?P<position>.*)>(?P<hasElse> has_else)?",
		line,
	)

	return &IfStmt{
		Addr:       ParseAddress(groups["address"]),
		Pos:        NewPositionFromString(groups["position"]),
		HasElse:    len(groups["hasElse"]) > 0,
		ChildNodes: []Node{},
	}
}

// AddChild adds a new child node. Child nodes can then be accessed with the
// Children attribute.
func (n *IfStmt) AddChild(node Node) {
	n.ChildNodes = append(n.ChildNodes, node)
}

// Address returns the numeric address of the node. See the documentation for
// the Address type for more information.
func (n *IfStmt) Address() Address {
	return n.Addr
}

// Children returns the child nodes. If this node does not have any children or
// this node does not support children it will always return an empty slice.
func (n *IfStmt) Children() []Node {
	return n.ChildNodes
}

// Position returns the position in the original source code.
func (n *IfStmt) Position() Position {
	return n.Pos
}
