//----------------------------------------------------------------------------
//  PresentationFramework.dll: PresentationFramework, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Framework 4.x
//----------------------------------------------------------------------------
//  UnitName: DDN.System.Windows.Documents.Serialization
//  Author: ying32
//----------------------------------------------------------------------------

unit DDN.System.Windows.Documents.Serialization;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDN.mscorlib,
  DDN.PresentationFramework,
  DDN.System,
  DDN.ReachFramework,
  DDN.PresentationCore,
  DDN.System.Windows.Xps.Serialization;

type

{ enums }

  //-------------namespace: System.Windows.Documents.Serialization----------------
  [DNTypeName('System.Windows.Documents.Serialization.WritingProgressChangeLevel')]
  DNWritingProgressChangeLevel = type Integer;
  DNWritingProgressChangeLevelHelper = record helper for DNWritingProgressChangeLevel
  public const
    None = 0;
    FixedDocumentSequenceWritingProgress = 1;
    FixedDocumentWritingProgress = 2;
    FixedPageWritingProgress = 3;
  end;




type


{ declares }

  DNISerializerFactory = interface; // type: System.Windows.Documents.Serialization.ISerializerFactory, namespace: System.Windows.Documents.Serialization
  DNWritingCompletedEventArgs = interface; // type: System.Windows.Documents.Serialization.WritingCompletedEventArgs, namespace: System.Windows.Documents.Serialization
  DNWritingProgressChangedEventArgs = interface; // type: System.Windows.Documents.Serialization.WritingProgressChangedEventArgs, namespace: System.Windows.Documents.Serialization
  DNWritingCancelledEventArgs = interface; // type: System.Windows.Documents.Serialization.WritingCancelledEventArgs, namespace: System.Windows.Documents.Serialization
  DNWritingPrintTicketRequiredEventArgs = interface; // type: System.Windows.Documents.Serialization.WritingPrintTicketRequiredEventArgs, namespace: System.Windows.Documents.Serialization
  DNSerializerDescriptor = interface; // type: System.Windows.Documents.Serialization.SerializerDescriptor, namespace: System.Windows.Documents.Serialization
  DNSerializerProvider = interface; // type: System.Windows.Documents.Serialization.SerializerProvider, namespace: System.Windows.Documents.Serialization
  DNSerializerWriter = interface; // type: System.Windows.Documents.Serialization.SerializerWriter, namespace: System.Windows.Documents.Serialization
  DNSerializerWriterCollator = interface; // type: System.Windows.Documents.Serialization.SerializerWriterCollator, namespace: System.Windows.Documents.Serialization

{ delegates }

  [DNTypeName('System.Windows.Documents.Serialization.WritingCancelledEventHandler')]
  DNWritingCancelledEventHandler = procedure(sender: DDN.mscorlib.DNObject; e: DNWritingCancelledEventArgs) of object;

  [DNTypeName('System.Windows.Documents.Serialization.WritingCompletedEventHandler')]
  DNWritingCompletedEventHandler = procedure(sender: DDN.mscorlib.DNObject; e: DNWritingCompletedEventArgs) of object;

  [DNTypeName('System.Windows.Documents.Serialization.WritingPrintTicketRequiredEventHandler')]
  DNWritingPrintTicketRequiredEventHandler = procedure(sender: DDN.mscorlib.DNObject; e: DNWritingPrintTicketRequiredEventArgs) of object;

  [DNTypeName('System.Windows.Documents.Serialization.WritingProgressChangedEventHandler')]
  DNWritingProgressChangedEventHandler = procedure(sender: DDN.mscorlib.DNObject; e: DNWritingProgressChangedEventArgs) of object;




{ objects }

  //-------------namespace: System.Windows.Documents.Serialization----------------
  [DNTypeName('System.Windows.Documents.Serialization.ISerializerFactory')]
  DNISerializerFactory = interface(DDN.mscorlib.DNObject)
  ['{07938333-3C70-3A12-8E75-B2DF4E938EB0}']
  { getters & setters } 

    function get_DisplayName: string;
    function get_ManufacturerName: string;
    function get_ManufacturerWebsite: DDN.System.DNUri;
    function get_DefaultFileExtension: string;

  { methods } 

    function CreateSerializerWriter(stream: DDN.mscorlib.DNStream): DNSerializerWriter;

  { propertys } 

    property DisplayName: string read get_DisplayName;
    property ManufacturerName: string read get_ManufacturerName;
    property ManufacturerWebsite: DDN.System.DNUri read get_ManufacturerWebsite;
    property DefaultFileExtension: string read get_DefaultFileExtension;
  end;

  //-------------namespace: System.Windows.Documents.Serialization----------------
  DNWritingCompletedEventArgsClass = interface(DNObjectClass)
  ['{9F19C0E8-EEF5-5B3B-9658-6CFEFA2086E9}']
  { constructors } 

    {class} function init(cancelled: Boolean; state: DDN.mscorlib.DNObject; exception: DDN.mscorlib.DNException): DNWritingCompletedEventArgs;

  end;

  [DNTypeName('System.Windows.Documents.Serialization.WritingCompletedEventArgs')]
  DNWritingCompletedEventArgs = interface(DNObject)
  ['{852F4278-0220-3656-AD67-6C1937A5ED15}']
  { getters & setters } 

    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNWritingCompletedEventArgs = class(TDNGenericImport<DNWritingCompletedEventArgsClass, DNWritingCompletedEventArgs>) end;

  //-------------namespace: System.Windows.Documents.Serialization----------------
  DNWritingProgressChangedEventArgsClass = interface(DNObjectClass)
  ['{FD6FDCEC-59A0-5E67-B4A2-9B8C7045BDD0}']
  { constructors } 

    {class} function init(writingLevel: DNWritingProgressChangeLevel; number: Int32; progressPercentage: Int32; state: DDN.mscorlib.DNObject): DNWritingProgressChangedEventArgs;

  end;

  [DNTypeName('System.Windows.Documents.Serialization.WritingProgressChangedEventArgs')]
  DNWritingProgressChangedEventArgs = interface(DNObject)
  ['{D0140974-7F7A-3DAA-BECE-B7E17B678581}']
  { getters & setters } 

    function get_Number: Int32;
    function get_WritingLevel: DNWritingProgressChangeLevel;
    function get_ProgressPercentage: Int32;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Number: Int32 read get_Number;
    property WritingLevel: DNWritingProgressChangeLevel read get_WritingLevel;
    property ProgressPercentage: Int32 read get_ProgressPercentage;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNWritingProgressChangedEventArgs = class(TDNGenericImport<DNWritingProgressChangedEventArgsClass, DNWritingProgressChangedEventArgs>) end;

  //-------------namespace: System.Windows.Documents.Serialization----------------
  DNWritingCancelledEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{4103B60A-7BB9-569E-A981-19D50E509467}']
  { constructors } 

    {class} function init(exception: DDN.mscorlib.DNException): DNWritingCancelledEventArgs;

  end;

  [DNTypeName('System.Windows.Documents.Serialization.WritingCancelledEventArgs')]
  DNWritingCancelledEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{DAD5EB8B-4F84-30C8-8DED-33CBA7788B46}']
  { getters & setters } 

    function get_Error: DDN.mscorlib.DNException;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Error: DDN.mscorlib.DNException read get_Error;
  end;

  TDNWritingCancelledEventArgs = class(TDNGenericImport<DNWritingCancelledEventArgsClass, DNWritingCancelledEventArgs>) end;

  //-------------namespace: System.Windows.Documents.Serialization----------------
  DNWritingPrintTicketRequiredEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{681A7D8F-5AC9-5DDE-A84B-D4E55DEB566F}']
  { constructors } 

    {class} function init(printTicketLevel: DDN.System.Windows.Documents.Serialization.DNPrintTicketLevel; sequence: Int32): DNWritingPrintTicketRequiredEventArgs;

  end;

  [DNTypeName('System.Windows.Documents.Serialization.WritingPrintTicketRequiredEventArgs')]
  DNWritingPrintTicketRequiredEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{0AB9C9DB-9187-3880-A79E-ED6B4881C60C}']
  { getters & setters } 

    function get_CurrentPrintTicketLevel: DDN.System.Windows.Documents.Serialization.DNPrintTicketLevel;
    function get_Sequence: Int32;
    function get_CurrentPrintTicket: DDN.ReachFramework.DNPrintTicket;
    procedure set_CurrentPrintTicket(value: DDN.ReachFramework.DNPrintTicket);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property CurrentPrintTicketLevel: DDN.System.Windows.Documents.Serialization.DNPrintTicketLevel read get_CurrentPrintTicketLevel;
    property Sequence: Int32 read get_Sequence;
    property CurrentPrintTicket: DDN.ReachFramework.DNPrintTicket read get_CurrentPrintTicket write set_CurrentPrintTicket;
  end;

  TDNWritingPrintTicketRequiredEventArgs = class(TDNGenericImport<DNWritingPrintTicketRequiredEventArgsClass, DNWritingPrintTicketRequiredEventArgs>) end;

  //-------------namespace: System.Windows.Documents.Serialization----------------
  DNSerializerDescriptorClass = interface(DDN.mscorlib.DNObjectClass)
  ['{76279A96-84AA-538B-A229-533F41F9B360}']
  { static methods } 

    {class} function CreateFromFactoryInstance(factoryInstance: DNISerializerFactory): DNSerializerDescriptor;

  end;

  [DNTypeName('System.Windows.Documents.Serialization.SerializerDescriptor')]
  DNSerializerDescriptor = interface(DDN.mscorlib.DNObject)
  ['{0D25A491-84F5-31B7-A268-9C5E773AB52C}']
  { getters & setters } 

    function get_DisplayName: string;
    function get_ManufacturerName: string;
    function get_ManufacturerWebsite: DDN.System.DNUri;
    function get_DefaultFileExtension: string;
    function get_AssemblyName: string;
    function get_AssemblyPath: string;
    function get_FactoryInterfaceName: string;
    function get_AssemblyVersion: DDN.mscorlib.DNVersion;
    function get_WinFXVersion: DDN.mscorlib.DNVersion;
    function get_IsLoadable: Boolean;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property DisplayName: string read get_DisplayName;
    property ManufacturerName: string read get_ManufacturerName;
    property ManufacturerWebsite: DDN.System.DNUri read get_ManufacturerWebsite;
    property DefaultFileExtension: string read get_DefaultFileExtension;
    property AssemblyName: string read get_AssemblyName;
    property AssemblyPath: string read get_AssemblyPath;
    property FactoryInterfaceName: string read get_FactoryInterfaceName;
    property AssemblyVersion: DDN.mscorlib.DNVersion read get_AssemblyVersion;
    property WinFXVersion: DDN.mscorlib.DNVersion read get_WinFXVersion;
    property IsLoadable: Boolean read get_IsLoadable;
  end;

  TDNSerializerDescriptor = class(TDNGenericImport<DNSerializerDescriptorClass, DNSerializerDescriptor>) end;

  //-------------namespace: System.Windows.Documents.Serialization----------------
  DNSerializerProviderClass = interface(DDN.mscorlib.DNObjectClass)
  ['{9A9A4090-88FA-510B-BAC0-B065E9D87D84}']
  { constructors } 

    {class} function init: DNSerializerProvider;

  { static methods } 

    {class} procedure RegisterSerializer(serializerDescriptor: DNSerializerDescriptor; overwrite: Boolean);
    {class} procedure UnregisterSerializer(serializerDescriptor: DNSerializerDescriptor);

  end;

  [DNTypeName('System.Windows.Documents.Serialization.SerializerProvider')]
  DNSerializerProvider = interface(DDN.mscorlib.DNObject)
  ['{F7384B1E-E4C2-3F0A-83FB-9C1781136C38}']
  { getters & setters } 

    function get_InstalledSerializers: DDN.mscorlib.DNReadOnlyCollection<DNSerializerDescriptor>;

  { methods } 

    function CreateSerializerWriter(serializerDescriptor: DNSerializerDescriptor; stream: DDN.mscorlib.DNStream): DNSerializerWriter;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InstalledSerializers: DDN.mscorlib.DNReadOnlyCollection<DNSerializerDescriptor> read get_InstalledSerializers;
  end;

  TDNSerializerProvider = class(TDNGenericImport<DNSerializerProviderClass, DNSerializerProvider>) end;

  //-------------namespace: System.Windows.Documents.Serialization----------------
  DNSerializerWriterClass = interface(DDN.mscorlib.DNObjectClass)
  ['{AA312EE0-DEF2-5134-9304-09C3338DAD51}']
  end;

  [DNTypeName('System.Windows.Documents.Serialization.SerializerWriter')]
  DNSerializerWriter = interface(DDN.mscorlib.DNObject)
  ['{125B777D-0764-3575-913C-EA1DCF3C9991}']
  { events } 

    procedure add_WritingPrintTicketRequired(value: DNWritingPrintTicketRequiredEventHandler);
    procedure remove_WritingPrintTicketRequired(value: DNWritingPrintTicketRequiredEventHandler);
    procedure add_WritingProgressChanged(value: DNWritingProgressChangedEventHandler);
    procedure remove_WritingProgressChanged(value: DNWritingProgressChangedEventHandler);
    procedure add_WritingCompleted(value: DNWritingCompletedEventHandler);
    procedure remove_WritingCompleted(value: DNWritingCompletedEventHandler);
    procedure add_WritingCancelled(value: DNWritingCancelledEventHandler);
    procedure remove_WritingCancelled(value: DNWritingCancelledEventHandler);

  { methods } 

    procedure Write(visual: DDN.PresentationCore.DNVisual); overload;
    procedure Write(visual: DDN.PresentationCore.DNVisual; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(visual: DDN.PresentationCore.DNVisual); overload;
    procedure WriteAsync(visual: DDN.PresentationCore.DNVisual; userState: DDN.mscorlib.DNObject); overload;
    procedure WriteAsync(visual: DDN.PresentationCore.DNVisual; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(visual: DDN.PresentationCore.DNVisual; printTicket: DDN.ReachFramework.DNPrintTicket; userState: DDN.mscorlib.DNObject); overload;
    procedure Write(documentPaginator: DDN.PresentationCore.DNDocumentPaginator); overload;
    procedure Write(documentPaginator: DDN.PresentationCore.DNDocumentPaginator; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(documentPaginator: DDN.PresentationCore.DNDocumentPaginator); overload;
    procedure WriteAsync(documentPaginator: DDN.PresentationCore.DNDocumentPaginator; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(documentPaginator: DDN.PresentationCore.DNDocumentPaginator; userState: DDN.mscorlib.DNObject); overload;
    procedure WriteAsync(documentPaginator: DDN.PresentationCore.DNDocumentPaginator; printTicket: DDN.ReachFramework.DNPrintTicket; userState: DDN.mscorlib.DNObject); overload;
    procedure Write(fixedPage: DNFixedPage); overload;
    procedure Write(fixedPage: DNFixedPage; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(fixedPage: DNFixedPage); overload;
    procedure WriteAsync(fixedPage: DNFixedPage; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(fixedPage: DNFixedPage; userState: DDN.mscorlib.DNObject); overload;
    procedure WriteAsync(fixedPage: DNFixedPage; printTicket: DDN.ReachFramework.DNPrintTicket; userState: DDN.mscorlib.DNObject); overload;
    procedure Write(fixedDocument: DNFixedDocument); overload;
    procedure Write(fixedDocument: DNFixedDocument; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(fixedDocument: DNFixedDocument); overload;
    procedure WriteAsync(fixedDocument: DNFixedDocument; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(fixedDocument: DNFixedDocument; userState: DDN.mscorlib.DNObject); overload;
    procedure WriteAsync(fixedDocument: DNFixedDocument; printTicket: DDN.ReachFramework.DNPrintTicket; userState: DDN.mscorlib.DNObject); overload;
    procedure Write(fixedDocumentSequence: DNFixedDocumentSequence); overload;
    procedure Write(fixedDocumentSequence: DNFixedDocumentSequence; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(fixedDocumentSequence: DNFixedDocumentSequence); overload;
    procedure WriteAsync(fixedDocumentSequence: DNFixedDocumentSequence; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(fixedDocumentSequence: DNFixedDocumentSequence; userState: DDN.mscorlib.DNObject); overload;
    procedure WriteAsync(fixedDocumentSequence: DNFixedDocumentSequence; printTicket: DDN.ReachFramework.DNPrintTicket; userState: DDN.mscorlib.DNObject); overload;
    procedure CancelAsync;
    function CreateVisualsCollator: DNSerializerWriterCollator; overload;
    function CreateVisualsCollator(documentSequencePT: DDN.ReachFramework.DNPrintTicket; documentPT: DDN.ReachFramework.DNPrintTicket): DNSerializerWriterCollator; overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNSerializerWriter = class(TDNGenericImport<DNSerializerWriterClass, DNSerializerWriter>) end;

  //-------------namespace: System.Windows.Documents.Serialization----------------
  DNSerializerWriterCollatorClass = interface(DDN.mscorlib.DNObjectClass)
  ['{9BF0A070-6D17-51DD-BFBD-659C71AA5A8A}']
  end;

  [DNTypeName('System.Windows.Documents.Serialization.SerializerWriterCollator')]
  DNSerializerWriterCollator = interface(DDN.mscorlib.DNObject)
  ['{B1E0E9B4-5E6B-330A-BD73-436F8C248EF3}']
  { methods } 

    procedure BeginBatchWrite;
    procedure EndBatchWrite;
    procedure Write(visual: DDN.PresentationCore.DNVisual); overload;
    procedure Write(visual: DDN.PresentationCore.DNVisual; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(visual: DDN.PresentationCore.DNVisual); overload;
    procedure WriteAsync(visual: DDN.PresentationCore.DNVisual; userState: DDN.mscorlib.DNObject); overload;
    procedure WriteAsync(visual: DDN.PresentationCore.DNVisual; printTicket: DDN.ReachFramework.DNPrintTicket); overload;
    procedure WriteAsync(visual: DDN.PresentationCore.DNVisual; printTicket: DDN.ReachFramework.DNPrintTicket; userState: DDN.mscorlib.DNObject); overload;
    procedure CancelAsync;
    procedure Cancel;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNSerializerWriterCollator = class(TDNGenericImport<DNSerializerWriterCollatorClass, DNSerializerWriterCollator>) end;


implementation

end.
