//----------------------------------------------------------------------------
//  System.Transactions.dll: System.Transactions, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Framework 4.x
//----------------------------------------------------------------------------
//  UnitName: DDN.System.Transactions
//  Author: ying32
//----------------------------------------------------------------------------

unit DDN.System.Transactions;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDN.mscorlib,
  DDN.System.Configuration;

type

{ enums }

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.DependentCloneOption')]
  DNDependentCloneOption = type Integer;
  DNDependentCloneOptionHelper = record helper for DNDependentCloneOption
  public const
    BlockCommitUntilComplete = 0;
    RollbackIfNotComplete = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.EnlistmentOptions')]
  DNEnlistmentOptions = type Integer;
  DNEnlistmentOptionsHelper = record helper for DNEnlistmentOptions
  public const
    None = 0;
    EnlistDuringPrepareRequired = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.EnterpriseServicesInteropOption')]
  DNEnterpriseServicesInteropOption = type Integer;
  DNEnterpriseServicesInteropOptionHelper = record helper for DNEnterpriseServicesInteropOption
  public const
    None = 0;
    Automatic = 1;
    Full = 2;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IsolationLevel')]
  DNIsolationLevel = type Integer;
  DNIsolationLevelHelper = record helper for DNIsolationLevel
  public const
    Serializable = 0;
    RepeatableRead = 1;
    ReadCommitted = 2;
    ReadUncommitted = 3;
    Snapshot = 4;
    Chaos = 5;
    Unspecified = 6;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionScopeAsyncFlowOption')]
  DNTransactionScopeAsyncFlowOption = type Integer;
  DNTransactionScopeAsyncFlowOptionHelper = record helper for DNTransactionScopeAsyncFlowOption
  public const
    Suppress = 0;
    Enabled = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionScopeOption')]
  DNTransactionScopeOption = type Integer;
  DNTransactionScopeOptionHelper = record helper for DNTransactionScopeOption
  public const
    Required = 0;
    RequiresNew = 1;
    Suppress = 2;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionStatus')]
  DNTransactionStatus = type Integer;
  DNTransactionStatusHelper = record helper for DNTransactionStatus
  public const
    Active = 0;
    Committed = 1;
    Aborted = 2;
    InDoubt = 3;
  end;




type


{ declares }

  DNIDtcTransaction = interface; // type: System.Transactions.IDtcTransaction, namespace: System.Transactions
  DNIEnlistmentNotification = interface; // type: System.Transactions.IEnlistmentNotification, namespace: System.Transactions
  DNISinglePhaseNotification = interface; // type: System.Transactions.ISinglePhaseNotification, namespace: System.Transactions
  DNITransactionPromoter = interface; // type: System.Transactions.ITransactionPromoter, namespace: System.Transactions
  DNIPromotableSinglePhaseNotification = interface; // type: System.Transactions.IPromotableSinglePhaseNotification, namespace: System.Transactions
  DNISimpleTransactionSuperior = interface; // type: System.Transactions.ISimpleTransactionSuperior, namespace: System.Transactions
  DNDistributedTransactionPermissionAttribute = interface; // type: System.Transactions.DistributedTransactionPermissionAttribute, namespace: System.Transactions
  DNDefaultSettingsSection = interface; // type: System.Transactions.Configuration.DefaultSettingsSection, namespace: System.Transactions.Configuration
  DNMachineSettingsSection = interface; // type: System.Transactions.Configuration.MachineSettingsSection, namespace: System.Transactions.Configuration
  DNTransactionsSectionGroup = interface; // type: System.Transactions.Configuration.TransactionsSectionGroup, namespace: System.Transactions.Configuration
  DNTransactionEventArgs = interface; // type: System.Transactions.TransactionEventArgs, namespace: System.Transactions
  DNTransactionException = interface; // type: System.Transactions.TransactionException, namespace: System.Transactions
  DNTransactionAbortedException = interface; // type: System.Transactions.TransactionAbortedException, namespace: System.Transactions
  DNTransactionInDoubtException = interface; // type: System.Transactions.TransactionInDoubtException, namespace: System.Transactions
  DNTransactionManagerCommunicationException = interface; // type: System.Transactions.TransactionManagerCommunicationException, namespace: System.Transactions
  DNTransactionPromotionException = interface; // type: System.Transactions.TransactionPromotionException, namespace: System.Transactions
  DNDistributedTransactionPermission = interface; // type: System.Transactions.DistributedTransactionPermission, namespace: System.Transactions
  DNEnlistment = interface; // type: System.Transactions.Enlistment, namespace: System.Transactions
  DNPreparingEnlistment = interface; // type: System.Transactions.PreparingEnlistment, namespace: System.Transactions
  DNSinglePhaseEnlistment = interface; // type: System.Transactions.SinglePhaseEnlistment, namespace: System.Transactions
  DNTransaction = interface; // type: System.Transactions.Transaction, namespace: System.Transactions
  DNCommittableTransaction = interface; // type: System.Transactions.CommittableTransaction, namespace: System.Transactions
  DNDependentTransaction = interface; // type: System.Transactions.DependentTransaction, namespace: System.Transactions
  DNSubordinateTransaction = interface; // type: System.Transactions.SubordinateTransaction, namespace: System.Transactions
  DNTransactionInformation = interface; // type: System.Transactions.TransactionInformation, namespace: System.Transactions
  DNTransactionInterop = interface; // type: System.Transactions.TransactionInterop, namespace: System.Transactions
  DNTransactionManager = interface; // type: System.Transactions.TransactionManager, namespace: System.Transactions
  DNTransactionScope = interface; // type: System.Transactions.TransactionScope, namespace: System.Transactions
  DNTransactionOptions = interface; // type: System.Transactions.TransactionOptions, namespace: System.Transactions

{ delegates }

  [DNTypeName('System.Transactions.HostCurrentTransactionCallback')]
  DNHostCurrentTransactionCallback = function: DNTransaction of object;

  [DNTypeName('System.Transactions.TransactionCompletedEventHandler')]
  DNTransactionCompletedEventHandler = procedure(sender: DDN.mscorlib.DNObject; e: DNTransactionEventArgs) of object;

  [DNTypeName('System.Transactions.TransactionStartedEventHandler')]
  DNTransactionStartedEventHandler = procedure(sender: DDN.mscorlib.DNObject; e: DNTransactionEventArgs) of object;




{ objects }

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IDtcTransaction')]
  DNIDtcTransaction = interface(DDN.mscorlib.DNObject)
  ['{0FB15084-AF41-11CE-BD2B-204C4F4F5020}']
  { methods } 

    procedure Commit(retaining: Int32; commitType: Int32; reserved: Int32);
    procedure &Abort(reason: IntPtr; retaining: Int32; async: Int32);
    procedure GetTransactionInfo(transactionInformation: IntPtr);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IEnlistmentNotification')]
  DNIEnlistmentNotification = interface(DDN.mscorlib.DNObject)
  ['{68723FCB-A005-3CD5-AF43-E27703E304F2}']
  { methods } 

    procedure Prepare(preparingEnlistment: DNPreparingEnlistment);
    procedure Commit(enlistment: DNEnlistment);
    procedure Rollback(enlistment: DNEnlistment);
    procedure InDoubt(enlistment: DNEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ISinglePhaseNotification')]
  DNISinglePhaseNotification = interface(DNIEnlistmentNotification)
  ['{2354C464-7457-3AE8-AF68-751AF5A1FFC0}']
  { methods } 

    procedure SinglePhaseCommit(singlePhaseEnlistment: DNSinglePhaseEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ITransactionPromoter')]
  DNITransactionPromoter = interface(DDN.mscorlib.DNObject)
  ['{2EE24BD6-197C-3BD2-ABB2-03F7113E3B60}']
  { methods } 

    function Promote: TArray<Byte>;

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IPromotableSinglePhaseNotification')]
  DNIPromotableSinglePhaseNotification = interface(DNITransactionPromoter)
  ['{5C25E3AA-572A-331E-88C5-CD69DCEF4C71}']
  { methods } 

    procedure Initialize;
    procedure SinglePhaseCommit(singlePhaseEnlistment: DNSinglePhaseEnlistment);
    procedure Rollback(singlePhaseEnlistment: DNSinglePhaseEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ISimpleTransactionSuperior')]
  DNISimpleTransactionSuperior = interface(DNITransactionPromoter)
  ['{8C30F42C-7396-303C-89E2-3EB683EF53BD}']
  { methods } 

    procedure Rollback;

  end;

  //-------------namespace: System.Transactions----------------
  DNDistributedTransactionPermissionAttributeClass = interface(DDN.mscorlib.DNCodeAccessSecurityAttributeClass)
  ['{00E2FE68-2AF0-5A9B-8E84-804525B63B24}']
  { constructors } 

    {class} function init(action: DDN.mscorlib.DNSecurityAction): DNDistributedTransactionPermissionAttribute;

  end;

  [DNTypeName('System.Transactions.DistributedTransactionPermissionAttribute')]
  DNDistributedTransactionPermissionAttribute = interface(DDN.mscorlib.DNCodeAccessSecurityAttribute)
  ['{D2A55554-97B4-34B9-90A9-CEB2B8A01CAF}']
  { getters & setters } 

    function get_Unrestricted: Boolean;
    procedure set_Unrestricted(value: Boolean);
    function get_Action: DDN.mscorlib.DNSecurityAction;
    procedure set_Action(value: DDN.mscorlib.DNSecurityAction);
    function get_TypeId: DDN.mscorlib.DNObject;

  { methods } 

    function CreatePermission: DDN.mscorlib.DNIPermission;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function Match(obj: DDN.mscorlib.DNObject): Boolean;
    function IsDefaultAttribute: Boolean;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Unrestricted: Boolean read get_Unrestricted write set_Unrestricted;
    property Action: DDN.mscorlib.DNSecurityAction read get_Action write set_Action;
    property TypeId: DDN.mscorlib.DNObject read get_TypeId;
  end;

  TDNDistributedTransactionPermissionAttribute = class(TDNGenericImport<DNDistributedTransactionPermissionAttributeClass, DNDistributedTransactionPermissionAttribute>) end;

  //-------------namespace: System.Transactions.Configuration----------------
  DNDefaultSettingsSectionClass = interface(DNObjectClass)
  ['{CFEC6732-E21B-556D-B7FE-FEE0A0C05207}']
  { constructors } 

    {class} function init: DNDefaultSettingsSection;

  end;

  [DNTypeName('System.Transactions.Configuration.DefaultSettingsSection')]
  DNDefaultSettingsSection = interface(DNObject)
  ['{E24E4EFA-EEB2-399F-B5FC-B348F421E78C}']
  { getters & setters } 

    function get_DistributedTransactionManagerName: string;
    procedure set_DistributedTransactionManagerName(value: string);
    function get_Timeout: DDN.mscorlib.DNTimeSpan;
    procedure set_Timeout(value: DDN.mscorlib.DNTimeSpan);
    function get_SectionInformation: DDN.System.Configuration.DNSectionInformation;
    function get_LockAttributes: DDN.System.Configuration.DNConfigurationLockCollection;
    function get_LockAllAttributesExcept: DDN.System.Configuration.DNConfigurationLockCollection;
    function get_LockElements: DDN.System.Configuration.DNConfigurationLockCollection;
    function get_LockAllElementsExcept: DDN.System.Configuration.DNConfigurationLockCollection;
    function get_LockItem: Boolean;
    procedure set_LockItem(value: Boolean);
    function get_ElementInformation: DDN.System.Configuration.DNElementInformation;
    function get_CurrentConfiguration: DDN.System.Configuration.DNConfiguration;

  { methods } 

    function IsReadOnly: Boolean;
    function Equals(compareTo: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property DistributedTransactionManagerName: string read get_DistributedTransactionManagerName write set_DistributedTransactionManagerName;
    property Timeout: DDN.mscorlib.DNTimeSpan read get_Timeout write set_Timeout;
    property SectionInformation: DDN.System.Configuration.DNSectionInformation read get_SectionInformation;
    property LockAttributes: DDN.System.Configuration.DNConfigurationLockCollection read get_LockAttributes;
    property LockAllAttributesExcept: DDN.System.Configuration.DNConfigurationLockCollection read get_LockAllAttributesExcept;
    property LockElements: DDN.System.Configuration.DNConfigurationLockCollection read get_LockElements;
    property LockAllElementsExcept: DDN.System.Configuration.DNConfigurationLockCollection read get_LockAllElementsExcept;
    property LockItem: Boolean read get_LockItem write set_LockItem;
    property ElementInformation: DDN.System.Configuration.DNElementInformation read get_ElementInformation;
    property CurrentConfiguration: DDN.System.Configuration.DNConfiguration read get_CurrentConfiguration;
  end;

  TDNDefaultSettingsSection = class(TDNGenericImport<DNDefaultSettingsSectionClass, DNDefaultSettingsSection>) end;

  //-------------namespace: System.Transactions.Configuration----------------
  DNMachineSettingsSectionClass = interface(DNObjectClass)
  ['{0150FFB0-583B-5E10-8176-B432576BE0E0}']
  { constructors } 

    {class} function init: DNMachineSettingsSection;

  end;

  [DNTypeName('System.Transactions.Configuration.MachineSettingsSection')]
  DNMachineSettingsSection = interface(DNObject)
  ['{0F166A72-33B1-32E3-95D5-E72F596A703B}']
  { getters & setters } 

    function get_MaxTimeout: DDN.mscorlib.DNTimeSpan;
    procedure set_MaxTimeout(value: DDN.mscorlib.DNTimeSpan);
    function get_SectionInformation: DDN.System.Configuration.DNSectionInformation;
    function get_LockAttributes: DDN.System.Configuration.DNConfigurationLockCollection;
    function get_LockAllAttributesExcept: DDN.System.Configuration.DNConfigurationLockCollection;
    function get_LockElements: DDN.System.Configuration.DNConfigurationLockCollection;
    function get_LockAllElementsExcept: DDN.System.Configuration.DNConfigurationLockCollection;
    function get_LockItem: Boolean;
    procedure set_LockItem(value: Boolean);
    function get_ElementInformation: DDN.System.Configuration.DNElementInformation;
    function get_CurrentConfiguration: DDN.System.Configuration.DNConfiguration;

  { methods } 

    function IsReadOnly: Boolean;
    function Equals(compareTo: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property MaxTimeout: DDN.mscorlib.DNTimeSpan read get_MaxTimeout write set_MaxTimeout;
    property SectionInformation: DDN.System.Configuration.DNSectionInformation read get_SectionInformation;
    property LockAttributes: DDN.System.Configuration.DNConfigurationLockCollection read get_LockAttributes;
    property LockAllAttributesExcept: DDN.System.Configuration.DNConfigurationLockCollection read get_LockAllAttributesExcept;
    property LockElements: DDN.System.Configuration.DNConfigurationLockCollection read get_LockElements;
    property LockAllElementsExcept: DDN.System.Configuration.DNConfigurationLockCollection read get_LockAllElementsExcept;
    property LockItem: Boolean read get_LockItem write set_LockItem;
    property ElementInformation: DDN.System.Configuration.DNElementInformation read get_ElementInformation;
    property CurrentConfiguration: DDN.System.Configuration.DNConfiguration read get_CurrentConfiguration;
  end;

  TDNMachineSettingsSection = class(TDNGenericImport<DNMachineSettingsSectionClass, DNMachineSettingsSection>) end;

  //-------------namespace: System.Transactions.Configuration----------------
  DNTransactionsSectionGroupClass = interface(DNObjectClass)
  ['{9477E008-2455-550C-B0E8-D02F758484B9}']
  { constructors } 

    {class} function init: DNTransactionsSectionGroup;

  { static methods } 

    {class} function GetSectionGroup(config: DDN.System.Configuration.DNConfiguration): DNTransactionsSectionGroup;

  end;

  [DNTypeName('System.Transactions.Configuration.TransactionsSectionGroup')]
  DNTransactionsSectionGroup = interface(DNObject)
  ['{610A65FB-6AD3-3BD2-B78C-6E7D1FE961CC}']
  { getters & setters } 

    function get_DefaultSettings: DNDefaultSettingsSection;
    function get_MachineSettings: DNMachineSettingsSection;
    function get_IsDeclared: Boolean;
    function get_IsDeclarationRequired: Boolean;
    function get_SectionGroupName: string;
    function get_Name: string;
    function get_Type: string;
    procedure set_Type(value: string);
    function get_Sections: DDN.System.Configuration.DNConfigurationSectionCollection;
    function get_SectionGroups: DDN.System.Configuration.DNConfigurationSectionGroupCollection;

  { methods } 

    procedure ForceDeclaration; overload;
    procedure ForceDeclaration(force: Boolean); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property DefaultSettings: DNDefaultSettingsSection read get_DefaultSettings;
    property MachineSettings: DNMachineSettingsSection read get_MachineSettings;
    property IsDeclared: Boolean read get_IsDeclared;
    property IsDeclarationRequired: Boolean read get_IsDeclarationRequired;
    property SectionGroupName: string read get_SectionGroupName;
    property Name: string read get_Name;
    property &Type: string read get_Type write set_Type;
    property Sections: DDN.System.Configuration.DNConfigurationSectionCollection read get_Sections;
    property SectionGroups: DDN.System.Configuration.DNConfigurationSectionGroupCollection read get_SectionGroups;
  end;

  TDNTransactionsSectionGroup = class(TDNGenericImport<DNTransactionsSectionGroupClass, DNTransactionsSectionGroup>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{5C2E318B-7CCE-52E5-9100-75B339191E55}']
  { constructors } 

    {class} function init: DNTransactionEventArgs;

  end;

  [DNTypeName('System.Transactions.TransactionEventArgs')]
  DNTransactionEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{E3243E94-2E74-3227-A119-810C85B9D3DA}']
  { getters & setters } 

    function get_Transaction: DNTransaction;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Transaction: DNTransaction read get_Transaction;
  end;

  TDNTransactionEventArgs = class(TDNGenericImport<DNTransactionEventArgsClass, DNTransactionEventArgs>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionExceptionClass = interface(DDN.mscorlib.DNSystemExceptionClass)
  ['{F391B338-8EAF-5A4E-BC31-1501E30EF695}']
  { constructors } 

    {class} function init: DNTransactionException; overload;
    {class} function init(message: string): DNTransactionException; overload;
    {class} function init(message: string; innerException: DDN.mscorlib.DNException): DNTransactionException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionException')]
  DNTransactionException = interface(DDN.mscorlib.DNSystemException)
  ['{32C3E8D4-C5F9-3FF7-90F2-57726E395867}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDN.mscorlib.DNIDictionary;
    function get_InnerException: DDN.mscorlib.DNException;
    function get_TargetSite: DDN.mscorlib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDN.mscorlib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDN.mscorlib.DNSerializationInfo; context: DDN.mscorlib.DNStreamingContext);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDN.mscorlib.DNIDictionary read get_Data;
    property InnerException: DDN.mscorlib.DNException read get_InnerException;
    property TargetSite: DDN.mscorlib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNTransactionException = class(TDNGenericImport<DNTransactionExceptionClass, DNTransactionException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionAbortedExceptionClass = interface(DNTransactionExceptionClass)
  ['{11A22E82-CA40-5A28-ADCE-8DDAA6C26A0D}']
  { constructors } 

    {class} function init: DNTransactionAbortedException; overload;
    {class} function init(message: string): DNTransactionAbortedException; overload;
    {class} function init(message: string; innerException: DDN.mscorlib.DNException): DNTransactionAbortedException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionAbortedException')]
  DNTransactionAbortedException = interface(DNTransactionException)
  ['{264A2CB8-A0F1-39DF-907F-B3A449161777}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDN.mscorlib.DNIDictionary;
    function get_InnerException: DDN.mscorlib.DNException;
    function get_TargetSite: DDN.mscorlib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDN.mscorlib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDN.mscorlib.DNSerializationInfo; context: DDN.mscorlib.DNStreamingContext);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDN.mscorlib.DNIDictionary read get_Data;
    property InnerException: DDN.mscorlib.DNException read get_InnerException;
    property TargetSite: DDN.mscorlib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNTransactionAbortedException = class(TDNGenericImport<DNTransactionAbortedExceptionClass, DNTransactionAbortedException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInDoubtExceptionClass = interface(DNTransactionExceptionClass)
  ['{F2E13E7D-2311-5EE2-9190-EDBF56FA8813}']
  { constructors } 

    {class} function init: DNTransactionInDoubtException; overload;
    {class} function init(message: string): DNTransactionInDoubtException; overload;
    {class} function init(message: string; innerException: DDN.mscorlib.DNException): DNTransactionInDoubtException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionInDoubtException')]
  DNTransactionInDoubtException = interface(DNTransactionException)
  ['{E42E0FE2-B25F-31AD-A323-14EF161C5DE7}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDN.mscorlib.DNIDictionary;
    function get_InnerException: DDN.mscorlib.DNException;
    function get_TargetSite: DDN.mscorlib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDN.mscorlib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDN.mscorlib.DNSerializationInfo; context: DDN.mscorlib.DNStreamingContext);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDN.mscorlib.DNIDictionary read get_Data;
    property InnerException: DDN.mscorlib.DNException read get_InnerException;
    property TargetSite: DDN.mscorlib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNTransactionInDoubtException = class(TDNGenericImport<DNTransactionInDoubtExceptionClass, DNTransactionInDoubtException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionManagerCommunicationExceptionClass = interface(DNTransactionExceptionClass)
  ['{2692616C-FBE5-5C3E-870A-1BD89EEA6486}']
  { constructors } 

    {class} function init: DNTransactionManagerCommunicationException; overload;
    {class} function init(message: string): DNTransactionManagerCommunicationException; overload;
    {class} function init(message: string; innerException: DDN.mscorlib.DNException): DNTransactionManagerCommunicationException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionManagerCommunicationException')]
  DNTransactionManagerCommunicationException = interface(DNTransactionException)
  ['{E6A4F19D-3F75-3801-B803-AA8D5AE73B7B}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDN.mscorlib.DNIDictionary;
    function get_InnerException: DDN.mscorlib.DNException;
    function get_TargetSite: DDN.mscorlib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDN.mscorlib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDN.mscorlib.DNSerializationInfo; context: DDN.mscorlib.DNStreamingContext);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDN.mscorlib.DNIDictionary read get_Data;
    property InnerException: DDN.mscorlib.DNException read get_InnerException;
    property TargetSite: DDN.mscorlib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNTransactionManagerCommunicationException = class(TDNGenericImport<DNTransactionManagerCommunicationExceptionClass, DNTransactionManagerCommunicationException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionPromotionExceptionClass = interface(DNTransactionExceptionClass)
  ['{3106D3F5-BCE9-5645-956C-307DBA493DFE}']
  { constructors } 

    {class} function init: DNTransactionPromotionException; overload;
    {class} function init(message: string): DNTransactionPromotionException; overload;
    {class} function init(message: string; innerException: DDN.mscorlib.DNException): DNTransactionPromotionException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionPromotionException')]
  DNTransactionPromotionException = interface(DNTransactionException)
  ['{A5DE4030-63EE-3BC5-9FB3-6144CA4234E4}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDN.mscorlib.DNIDictionary;
    function get_InnerException: DDN.mscorlib.DNException;
    function get_TargetSite: DDN.mscorlib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDN.mscorlib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDN.mscorlib.DNSerializationInfo; context: DDN.mscorlib.DNStreamingContext);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDN.mscorlib.DNIDictionary read get_Data;
    property InnerException: DDN.mscorlib.DNException read get_InnerException;
    property TargetSite: DDN.mscorlib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNTransactionPromotionException = class(TDNGenericImport<DNTransactionPromotionExceptionClass, DNTransactionPromotionException>) end;

  //-------------namespace: System.Transactions----------------
  DNDistributedTransactionPermissionClass = interface(DDN.mscorlib.DNCodeAccessPermissionClass)
  ['{CC5250A9-DCFD-5FC3-910A-AC753F139F5D}']
  { constructors } 

    {class} function init(state: DDN.mscorlib.DNPermissionState): DNDistributedTransactionPermission;

  end;

  [DNTypeName('System.Transactions.DistributedTransactionPermission')]
  DNDistributedTransactionPermission = interface(DDN.mscorlib.DNCodeAccessPermission)
  ['{E4FCAA7B-A6A2-3405-A95A-469AC05E43D5}']
  { methods } 

    function IsUnrestricted: Boolean;
    function Copy: DDN.mscorlib.DNIPermission;
    function Intersect(target: DDN.mscorlib.DNIPermission): DDN.mscorlib.DNIPermission;
    function Union(target: DDN.mscorlib.DNIPermission): DDN.mscorlib.DNIPermission;
    function IsSubsetOf(target: DDN.mscorlib.DNIPermission): Boolean;
    function ToXml: DDN.mscorlib.DNSecurityElement;
    procedure FromXml(securityElement: DDN.mscorlib.DNSecurityElement);
    procedure Demand;
    procedure Assert;
    procedure Deny;
    procedure PermitOnly;
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  end;

  TDNDistributedTransactionPermission = class(TDNGenericImport<DNDistributedTransactionPermissionClass, DNDistributedTransactionPermission>) end;

  //-------------namespace: System.Transactions----------------
  DNEnlistmentClass = interface(DDN.mscorlib.DNObjectClass)
  ['{9A4DC1D8-37A2-5741-ADDC-33798B1EFA36}']
  end;

  [DNTypeName('System.Transactions.Enlistment')]
  DNEnlistment = interface(DDN.mscorlib.DNObject)
  ['{490BE79B-6E73-355B-B77C-20970441382A}']
  { methods } 

    procedure Done;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNEnlistment = class(TDNGenericImport<DNEnlistmentClass, DNEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNPreparingEnlistmentClass = interface(DNEnlistmentClass)
  ['{53E64456-0FFF-5FD0-B255-79F77681BC92}']
  end;

  [DNTypeName('System.Transactions.PreparingEnlistment')]
  DNPreparingEnlistment = interface(DNEnlistment)
  ['{2E8C254B-7445-31C0-ADF5-8E190CFF7C3E}']
  { methods } 

    procedure Prepared;
    procedure ForceRollback; overload;
    procedure ForceRollback(e: DDN.mscorlib.DNException); overload;
    function RecoveryInformation: TArray<Byte>;
    procedure Done;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNPreparingEnlistment = class(TDNGenericImport<DNPreparingEnlistmentClass, DNPreparingEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNSinglePhaseEnlistmentClass = interface(DNEnlistmentClass)
  ['{B6024651-53EB-5EAF-8191-36AF8325C7AA}']
  end;

  [DNTypeName('System.Transactions.SinglePhaseEnlistment')]
  DNSinglePhaseEnlistment = interface(DNEnlistment)
  ['{531BEC56-D463-318A-9BF2-F9F4A19DEAE7}']
  { methods } 

    procedure Aborted; overload;
    procedure Aborted(e: DDN.mscorlib.DNException); overload;
    procedure Committed;
    procedure InDoubt; overload;
    procedure InDoubt(e: DDN.mscorlib.DNException); overload;
    procedure Done;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNSinglePhaseEnlistment = class(TDNGenericImport<DNSinglePhaseEnlistmentClass, DNSinglePhaseEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionClass = interface(DNObjectClass)
  ['{A240520D-D05D-5B12-A682-729DD9A75FAC}']
  { static getter & setter } 

    {class} function get_Current: DNTransaction;
    {class} procedure set_Current(value: DNTransaction);

  { static propertys } 

    {class} property Current: DNTransaction read get_Current write set_Current;
  end;

  [DNTypeName('System.Transactions.Transaction')]
  DNTransaction = interface(DDN.mscorlib.DNIDisposable)
  ['{E1F23ACF-DC76-3B52-8794-5BB90592C284}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDN.mscorlib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDN.mscorlib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDN.mscorlib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDN.mscorlib.DNGuid);
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDN.mscorlib.DNGuid read get_PromoterType;
  end;

  TDNTransaction = class(TDNGenericImport<DNTransactionClass, DNTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNCommittableTransactionClass = interface(DNTransactionClass)
  ['{2CC0C5CF-9BF7-5CFC-99A9-DDF181ED2672}']
  { constructors } 

    {class} function init: DNCommittableTransaction; overload;
    {class} function init(timeout: DDN.mscorlib.DNTimeSpan): DNCommittableTransaction; overload;
    {class} function init(options: DNTransactionOptions): DNCommittableTransaction; overload;

  end;

  [DNTypeName('System.Transactions.CommittableTransaction')]
  DNCommittableTransaction = interface(DNTransaction)
  ['{7586BDAA-D0AB-305A-9999-A0B5719BDDD3}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDN.mscorlib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function BeginCommit(asyncCallback: DDN.mscorlib.DNAsyncCallback; asyncState: DDN.mscorlib.DNObject): DDN.mscorlib.DNIAsyncResult;
    procedure Commit;
    procedure EndCommit(asyncResult: DDN.mscorlib.DNIAsyncResult);
    function GetHashCode: Int32;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDN.mscorlib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDN.mscorlib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDN.mscorlib.DNGuid);
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDN.mscorlib.DNGuid read get_PromoterType;
  end;

  TDNCommittableTransaction = class(TDNGenericImport<DNCommittableTransactionClass, DNCommittableTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNDependentTransactionClass = interface(DNTransactionClass)
  ['{1E04B959-AC53-5D01-84ED-64B6829BDE00}']
  end;

  [DNTypeName('System.Transactions.DependentTransaction')]
  DNDependentTransaction = interface(DNTransaction)
  ['{168759F4-7CA6-3DF9-A44F-3FED676C58EF}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDN.mscorlib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    procedure Complete;
    function GetHashCode: Int32;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDN.mscorlib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDN.mscorlib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDN.mscorlib.DNGuid);
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDN.mscorlib.DNGuid read get_PromoterType;
  end;

  TDNDependentTransaction = class(TDNGenericImport<DNDependentTransactionClass, DNDependentTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNSubordinateTransactionClass = interface(DNTransactionClass)
  ['{6DA2EEFD-A857-5A38-B552-99DB799C6F63}']
  { constructors } 

    {class} function init(isoLevel: DNIsolationLevel; superior: DNISimpleTransactionSuperior): DNSubordinateTransaction;

  end;

  [DNTypeName('System.Transactions.SubordinateTransaction')]
  DNSubordinateTransaction = interface(DNTransaction)
  ['{560E99D3-37B1-3D38-8530-684E6F16B9B5}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDN.mscorlib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDN.mscorlib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDN.mscorlib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDN.mscorlib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDN.mscorlib.DNGuid);
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDN.mscorlib.DNGuid read get_PromoterType;
  end;

  TDNSubordinateTransaction = class(TDNGenericImport<DNSubordinateTransactionClass, DNSubordinateTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInformationClass = interface(DDN.mscorlib.DNObjectClass)
  ['{38D6BA6A-F0F3-5A40-B9C2-F6DC314258F6}']
  end;

  [DNTypeName('System.Transactions.TransactionInformation')]
  DNTransactionInformation = interface(DDN.mscorlib.DNObject)
  ['{CD41D142-1F2D-352D-9DE5-A5035C9529BD}']
  { getters & setters } 

    function get_LocalIdentifier: string;
    function get_DistributedIdentifier: DDN.mscorlib.DNGuid;
    function get_CreationTime: DDN.mscorlib.DNDateTime;
    function get_Status: DNTransactionStatus;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property LocalIdentifier: string read get_LocalIdentifier;
    property DistributedIdentifier: DDN.mscorlib.DNGuid read get_DistributedIdentifier;
    property CreationTime: DDN.mscorlib.DNDateTime read get_CreationTime;
    property Status: DNTransactionStatus read get_Status;
  end;

  TDNTransactionInformation = class(TDNGenericImport<DNTransactionInformationClass, DNTransactionInformation>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInteropClass = interface(DDN.mscorlib.DNObjectClass)
  ['{D8558F78-E3D0-58D5-B9BF-DF6745C87B8C}']
  { static fields getter & setter } 

   function __fakeFieldGet_PromoterTypeDtc: DDN.mscorlib.DNGuid;

  { static fields } 

    {class} property PromoterTypeDtc: DDN.mscorlib.DNGuid read __fakeFieldGet_PromoterTypeDtc;

  { static methods } 

    {class} function GetExportCookie(transaction: DNTransaction; whereabouts: TArray<Byte>): TArray<Byte>;
    {class} function GetTransactionFromExportCookie(cookie: TArray<Byte>): DNTransaction;
    {class} function GetTransmitterPropagationToken(transaction: DNTransaction): TArray<Byte>;
    {class} function GetTransactionFromTransmitterPropagationToken(propagationToken: TArray<Byte>): DNTransaction;
    {class} function GetDtcTransaction(transaction: DNTransaction): DNIDtcTransaction;
    {class} function GetTransactionFromDtcTransaction(transactionNative: DNIDtcTransaction): DNTransaction;
    {class} function GetWhereabouts: TArray<Byte>;

  end;

  [DNTypeName('System.Transactions.TransactionInterop')]
  DNTransactionInterop = interface(DDN.mscorlib.DNObject)
  ['{F67C6D69-E281-3062-AA0B-8F77C17C1751}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNTransactionInterop = class(TDNGenericImport<DNTransactionInteropClass, DNTransactionInterop>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionManagerClass = interface(DDN.mscorlib.DNObjectClass)
  ['{C8446A03-570C-55CD-95EA-2B61C3991F45}']
  { static getter & setter } 

    {class} function get_HostCurrentCallback: DNHostCurrentTransactionCallback;
    {class} procedure set_HostCurrentCallback(value: DNHostCurrentTransactionCallback);
    {class} function get_DefaultTimeout: DDN.mscorlib.DNTimeSpan;
    {class} function get_MaximumTimeout: DDN.mscorlib.DNTimeSpan;

  { static methods } 

    {class} function Reenlist(resourceManagerIdentifier: DDN.mscorlib.DNGuid; recoveryInformation: TArray<Byte>; enlistmentNotification: DNIEnlistmentNotification): DNEnlistment;
    {class} procedure RecoveryComplete(resourceManagerIdentifier: DDN.mscorlib.DNGuid);

  { static propertys } 

    {class} property HostCurrentCallback: DNHostCurrentTransactionCallback read get_HostCurrentCallback write set_HostCurrentCallback;
    {class} property DefaultTimeout: DDN.mscorlib.DNTimeSpan read get_DefaultTimeout;
    {class} property MaximumTimeout: DDN.mscorlib.DNTimeSpan read get_MaximumTimeout;
  end;

  [DNTypeName('System.Transactions.TransactionManager')]
  DNTransactionManager = interface(DDN.mscorlib.DNObject)
  ['{E8617F9C-039A-3366-A383-67B5F73D1E48}']
  { events } 

    {class} procedure add_DistributedTransactionStarted(value: DNTransactionStartedEventHandler);
    {class} procedure remove_DistributedTransactionStarted(value: DNTransactionStartedEventHandler);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNTransactionManager = class(TDNGenericImport<DNTransactionManagerClass, DNTransactionManager>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionScopeClass = interface(DNObjectClass)
  ['{0EC82406-28A2-5E1A-AE67-3DFE1BD054EF}']
  { constructors } 

    {class} function init: DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption): DNTransactionScope; overload;
    {class} function init(asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; scopeTimeout: DDN.mscorlib.DNTimeSpan): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; scopeTimeout: DDN.mscorlib.DNTimeSpan; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions; interopOption: DNEnterpriseServicesInteropOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDN.mscorlib.DNTimeSpan): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDN.mscorlib.DNTimeSpan; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDN.mscorlib.DNTimeSpan; interopOption: DNEnterpriseServicesInteropOption): DNTransactionScope; overload;

  end;

  [DNTypeName('System.Transactions.TransactionScope')]
  DNTransactionScope = interface(DDN.mscorlib.DNIDisposable)
  ['{9D930A75-06D4-3E93-A49C-17E4928B3821}']
  { methods } 

    procedure Dispose;
    procedure Complete;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNTransactionScope = class(TDNGenericImport<DNTransactionScopeClass, DNTransactionScope>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionOptionsClass = interface(DDN.mscorlib.DNValueTypeClass)
  ['{3B69E5E5-8A0C-54BD-91E1-FAAE8DECD7D8}']
  end;

  [DNTypeName('System.Transactions.TransactionOptions')]
  DNTransactionOptions = interface(DDN.mscorlib.DNValueType)
  ['{89EEABA3-B630-3A67-84EA-EDE60AE287B5}']
  { getters & setters } 

    function get_Timeout: DDN.mscorlib.DNTimeSpan;
    procedure set_Timeout(value: DDN.mscorlib.DNTimeSpan);
    function get_IsolationLevel: DNIsolationLevel;
    procedure set_IsolationLevel(value: DNIsolationLevel);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function ToString: string;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property Timeout: DDN.mscorlib.DNTimeSpan read get_Timeout write set_Timeout;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel write set_IsolationLevel;
  end;

  TDNTransactionOptions = class(TDNGenericImport<DNTransactionOptionsClass, DNTransactionOptions>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Transactions, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089');

finalization

end.
