//----------------------------------------------------------------------------
//  System.Speech.dll: System.Speech, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Framework 4.x
//----------------------------------------------------------------------------
//  UnitName: DDN.System.Speech
//  Author: ying32
//----------------------------------------------------------------------------

unit DDN.System.Speech;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDN.mscorlib,
  DDN.System,
  DDN.System.Xml;

type

{ enums }

  //-------------namespace: System.Speech.AudioFormat----------------
  [DNTypeName('System.Speech.AudioFormat.AudioBitsPerSample')]
  DNAudioBitsPerSample = type Integer;
  DNAudioBitsPerSampleHelper = record helper for DNAudioBitsPerSample
  public const
    Eight = 8;
    Sixteen = 16;
  end;


  //-------------namespace: System.Speech.AudioFormat----------------
  [DNTypeName('System.Speech.AudioFormat.AudioChannel')]
  DNAudioChannel = type Integer;
  DNAudioChannelHelper = record helper for DNAudioChannel
  public const
    Mono = 1;
    Stereo = 2;
  end;


  //-------------namespace: System.Speech.AudioFormat----------------
  [DNTypeName('System.Speech.AudioFormat.EncodingFormat')]
  DNEncodingFormat = type Integer;
  DNEncodingFormatHelper = record helper for DNEncodingFormat
  public const
    Pcm = 1;
    ALaw = 6;
    ULaw = 7;
  end;


  //-------------namespace: System.Speech.Recognition----------------
  [DNTypeName('System.Speech.Recognition.AudioSignalProblem')]
  DNAudioSignalProblem = type Integer;
  DNAudioSignalProblemHelper = record helper for DNAudioSignalProblem
  public const
    None = 0;
    TooNoisy = 1;
    NoSignal = 2;
    TooLoud = 3;
    TooSoft = 4;
    TooFast = 5;
    TooSlow = 6;
  end;


  //-------------namespace: System.Speech.Recognition----------------
  [DNTypeName('System.Speech.Recognition.AudioState')]
  DNAudioState = type Integer;
  DNAudioStateHelper = record helper for DNAudioState
  public const
    Stopped = 0;
    Silence = 1;
    Speech = 2;
  end;


  //-------------namespace: System.Speech.Recognition----------------
  [DNTypeName('System.Speech.Recognition.DisplayAttributes')]
  DNDisplayAttributes = type Integer;
  DNDisplayAttributesHelper = record helper for DNDisplayAttributes
  public const
    None = 0;
    ZeroTrailingSpaces = 2;
    OneTrailingSpace = 4;
    TwoTrailingSpaces = 8;
    ConsumeLeadingSpaces = 16;
  end;


  //-------------namespace: System.Speech.Recognition----------------
  [DNTypeName('System.Speech.Recognition.RecognizeMode')]
  DNRecognizeMode = type Integer;
  DNRecognizeModeHelper = record helper for DNRecognizeMode
  public const
    Single = 0;
    Multiple = 1;
  end;


  //-------------namespace: System.Speech.Recognition----------------
  [DNTypeName('System.Speech.Recognition.RecognizerState')]
  DNRecognizerState = type Integer;
  DNRecognizerStateHelper = record helper for DNRecognizerState
  public const
    Stopped = 0;
    Listening = 1;
  end;


  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsGrammarMode')]
  DNSrgsGrammarMode = type Integer;
  DNSrgsGrammarModeHelper = record helper for DNSrgsGrammarMode
  public const
    Voice = 0;
    Dtmf = 1;
  end;


  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsPhoneticAlphabet')]
  DNSrgsPhoneticAlphabet = type Integer;
  DNSrgsPhoneticAlphabetHelper = record helper for DNSrgsPhoneticAlphabet
  public const
    Sapi = 0;
    Ipa = 1;
    Ups = 2;
  end;


  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsRuleScope')]
  DNSrgsRuleScope = type Integer;
  DNSrgsRuleScopeHelper = record helper for DNSrgsRuleScope
  public const
    Public_ = 0;
    Private_ = 1;
  end;


  //-------------namespace: System.Speech.Recognition----------------
  [DNTypeName('System.Speech.Recognition.SubsetMatchingMode')]
  DNSubsetMatchingMode = type Integer;
  DNSubsetMatchingModeHelper = record helper for DNSubsetMatchingMode
  public const
    Subsequence = 0;
    OrderedSubset = 1;
    SubsequenceContentRequired = 2;
    OrderedSubsetContentRequired = 3;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.PromptBreak')]
  DNPromptBreak = type Integer;
  DNPromptBreakHelper = record helper for DNPromptBreak
  public const
    None = 0;
    ExtraSmall = 1;
    Small = 2;
    Medium = 3;
    Large = 4;
    ExtraLarge = 5;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.PromptEmphasis')]
  DNPromptEmphasis = type Integer;
  DNPromptEmphasisHelper = record helper for DNPromptEmphasis
  public const
    NotSet = 0;
    Strong = 1;
    Moderate = 2;
    None = 3;
    Reduced = 4;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.PromptRate')]
  DNPromptRate = type Integer;
  DNPromptRateHelper = record helper for DNPromptRate
  public const
    NotSet = 0;
    ExtraFast = 1;
    Fast = 2;
    Medium = 3;
    Slow = 4;
    ExtraSlow = 5;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.PromptVolume')]
  DNPromptVolume = type Integer;
  DNPromptVolumeHelper = record helper for DNPromptVolume
  public const
    NotSet = 0;
    Silent = 1;
    ExtraSoft = 2;
    Soft = 3;
    Medium = 4;
    Loud = 5;
    ExtraLoud = 6;
    Default_ = 7;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.SayAs')]
  DNSynthesis_SayAs = type Integer;
  DNSynthesis_SayAsHelper = record helper for DNSynthesis_SayAs
  public const
    SpellOut = 0;
    NumberOrdinal = 1;
    NumberCardinal = 2;
    Date = 3;
    DayMonthYear = 4;
    MonthDayYear = 5;
    YearMonthDay = 6;
    YearMonth = 7;
    MonthYear = 8;
    MonthDay = 9;
    DayMonth = 10;
    Year = 11;
    Month = 12;
    Day = 13;
    Time = 14;
    Time24 = 15;
    Time12 = 16;
    Telephone = 17;
    Text = 18;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.SynthesisMediaType')]
  DNSynthesisMediaType = type Integer;
  DNSynthesisMediaTypeHelper = record helper for DNSynthesisMediaType
  public const
    Text = 0;
    Ssml = 1;
    WaveAudio = 2;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.SynthesisTextFormat')]
  DNSynthesisTextFormat = type Integer;
  DNSynthesisTextFormatHelper = record helper for DNSynthesisTextFormat
  public const
    Text = 0;
    Ssml = 1;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.SynthesizerEmphasis')]
  DNSynthesizerEmphasis = type Integer;
  DNSynthesizerEmphasisHelper = record helper for DNSynthesizerEmphasis
  public const
    Stressed = 1;
    Emphasized = 2;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.SynthesizerState')]
  DNSynthesizerState = type Integer;
  DNSynthesizerStateHelper = record helper for DNSynthesizerState
  public const
    Ready = 0;
    Speaking = 1;
    Paused = 2;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.ContourPointChangeType')]
  DNContourPointChangeType = type Integer;
  DNContourPointChangeTypeHelper = record helper for DNContourPointChangeType
  public const
    Hz = 0;
    Percentage = 1;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.EmphasisBreak')]
  DNEmphasisBreak = type Integer;
  DNEmphasisBreakHelper = record helper for DNEmphasisBreak
  public const
    Default_ = -7;
    ExtraStrong = -6;
    Strong = -5;
    Medium = -4;
    Weak = -3;
    ExtraWeak = -2;
    None = -1;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.EmphasisWord')]
  DNEmphasisWord = type Integer;
  DNEmphasisWordHelper = record helper for DNEmphasisWord
  public const
    Default_ = 0;
    Strong = 1;
    Moderate = 2;
    None = 3;
    Reduced = 4;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.EventParameterType')]
  DNEventParameterType = type Integer;
  DNEventParameterTypeHelper = record helper for DNEventParameterType
  public const
    Undefined = 0;
    Token = 1;
    Object_ = 2;
    Pointer = 3;
    String_ = 4;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.ProsodyPitch')]
  DNProsodyPitch = type Integer;
  DNProsodyPitchHelper = record helper for DNProsodyPitch
  public const
    Default_ = 0;
    ExtraLow = 1;
    Low = 2;
    Medium = 3;
    High = 4;
    ExtraHigh = 5;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.ProsodyRange')]
  DNProsodyRange = type Integer;
  DNProsodyRangeHelper = record helper for DNProsodyRange
  public const
    Default_ = 0;
    ExtraLow = 1;
    Low = 2;
    Medium = 3;
    High = 4;
    ExtraHigh = 5;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.ProsodyRate')]
  DNProsodyRate = type Integer;
  DNProsodyRateHelper = record helper for DNProsodyRate
  public const
    Default_ = 0;
    ExtraSlow = 1;
    Slow = 2;
    Medium = 3;
    Fast = 4;
    ExtraFast = 5;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.ProsodyUnit')]
  DNProsodyUnit = type Integer;
  DNProsodyUnitHelper = record helper for DNProsodyUnit
  public const
    Default_ = 0;
    Hz = 1;
    Semitone = 2;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.ProsodyVolume')]
  DNProsodyVolume = type Integer;
  DNProsodyVolumeHelper = record helper for DNProsodyVolume
  public const
    ExtraLoud = -7;
    Loud = -6;
    Medium = -5;
    Soft = -4;
    ExtraSoft = -3;
    Silent = -2;
    Default_ = -1;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.SpeakOutputFormat')]
  DNSpeakOutputFormat = type Integer;
  DNSpeakOutputFormatHelper = record helper for DNSpeakOutputFormat
  public const
    WaveFormat = 0;
    Text = 1;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.TtsEngineAction')]
  DNTtsEngineAction = type Integer;
  DNTtsEngineActionHelper = record helper for DNTtsEngineAction
  public const
    Speak = 0;
    Silence = 1;
    Pronounce = 2;
    Bookmark = 3;
    SpellOut = 4;
    StartSentence = 5;
    StartParagraph = 6;
    ParseUnknownTag = 7;
  end;


  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.TtsEventId')]
  DNTtsEventId = type Integer;
  DNTtsEventIdHelper = record helper for DNTtsEventId
  public const
    StartInputStream = 1;
    EndInputStream = 2;
    VoiceChange = 3;
    Bookmark = 4;
    WordBoundary = 5;
    Phoneme = 6;
    SentenceBoundary = 7;
    Viseme = 8;
    AudioLevel = 9;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.VoiceAge')]
  DNVoiceAge = type Integer;
  DNVoiceAgeHelper = record helper for DNVoiceAge
  public const
    NotSet = 0;
    Child = 10;
    Teen = 15;
    Adult = 30;
    Senior = 65;
  end;


  //-------------namespace: System.Speech.Synthesis----------------
  [DNTypeName('System.Speech.Synthesis.VoiceGender')]
  DNVoiceGender = type Integer;
  DNVoiceGenderHelper = record helper for DNVoiceGender
  public const
    NotSet = 0;
    Male = 1;
    Female = 2;
    Neutral = 3;
  end;




type


{ declares }

  DNITtsEngineSite = interface; // type: System.Speech.Synthesis.TtsEngine.ITtsEngineSite, namespace: System.Speech.Synthesis.TtsEngine
  DNSrgsRulesCollection = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsRulesCollection, namespace: System.Speech.Recognition.SrgsGrammar
  DNEmulateRecognizeCompletedEventArgs = interface; // type: System.Speech.Recognition.EmulateRecognizeCompletedEventArgs, namespace: System.Speech.Recognition
  DNLoadGrammarCompletedEventArgs = interface; // type: System.Speech.Recognition.LoadGrammarCompletedEventArgs, namespace: System.Speech.Recognition
  DNRecognizeCompletedEventArgs = interface; // type: System.Speech.Recognition.RecognizeCompletedEventArgs, namespace: System.Speech.Recognition
  DNPromptEventArgs = interface; // type: System.Speech.Synthesis.PromptEventArgs, namespace: System.Speech.Synthesis
  DNBookmarkReachedEventArgs = interface; // type: System.Speech.Synthesis.BookmarkReachedEventArgs, namespace: System.Speech.Synthesis
  DNPhonemeReachedEventArgs = interface; // type: System.Speech.Synthesis.PhonemeReachedEventArgs, namespace: System.Speech.Synthesis
  DNSpeakCompletedEventArgs = interface; // type: System.Speech.Synthesis.SpeakCompletedEventArgs, namespace: System.Speech.Synthesis
  DNSpeakProgressEventArgs = interface; // type: System.Speech.Synthesis.SpeakProgressEventArgs, namespace: System.Speech.Synthesis
  DNSpeakStartedEventArgs = interface; // type: System.Speech.Synthesis.SpeakStartedEventArgs, namespace: System.Speech.Synthesis
  DNVisemeReachedEventArgs = interface; // type: System.Speech.Synthesis.VisemeReachedEventArgs, namespace: System.Speech.Synthesis
  DNVoiceChangeEventArgs = interface; // type: System.Speech.Synthesis.VoiceChangeEventArgs, namespace: System.Speech.Synthesis
  DNAudioLevelUpdatedEventArgs = interface; // type: System.Speech.Recognition.AudioLevelUpdatedEventArgs, namespace: System.Speech.Recognition
  DNAudioSignalProblemOccurredEventArgs = interface; // type: System.Speech.Recognition.AudioSignalProblemOccurredEventArgs, namespace: System.Speech.Recognition
  DNAudioStateChangedEventArgs = interface; // type: System.Speech.Recognition.AudioStateChangedEventArgs, namespace: System.Speech.Recognition
  DNRecognitionEventArgs = interface; // type: System.Speech.Recognition.RecognitionEventArgs, namespace: System.Speech.Recognition
  DNSpeechHypothesizedEventArgs = interface; // type: System.Speech.Recognition.SpeechHypothesizedEventArgs, namespace: System.Speech.Recognition
  DNSpeechRecognitionRejectedEventArgs = interface; // type: System.Speech.Recognition.SpeechRecognitionRejectedEventArgs, namespace: System.Speech.Recognition
  DNSpeechRecognizedEventArgs = interface; // type: System.Speech.Recognition.SpeechRecognizedEventArgs, namespace: System.Speech.Recognition
  DNRecognizerUpdateReachedEventArgs = interface; // type: System.Speech.Recognition.RecognizerUpdateReachedEventArgs, namespace: System.Speech.Recognition
  DNSpeechDetectedEventArgs = interface; // type: System.Speech.Recognition.SpeechDetectedEventArgs, namespace: System.Speech.Recognition
  DNRecognition_StateChangedEventArgs = interface; // type: System.Speech.Recognition.StateChangedEventArgs, namespace: System.Speech.Recognition
  DNSynthesis_StateChangedEventArgs = interface; // type: System.Speech.Synthesis.StateChangedEventArgs, namespace: System.Speech.Synthesis
  DNSrgsElement = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsElement, namespace: System.Speech.Recognition.SrgsGrammar
  DNSrgsItem = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsItem, namespace: System.Speech.Recognition.SrgsGrammar
  DNSrgsNameValueTag = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsNameValueTag, namespace: System.Speech.Recognition.SrgsGrammar
  DNSrgsOneOf = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsOneOf, namespace: System.Speech.Recognition.SrgsGrammar
  DNSrgsRuleRef = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsRuleRef, namespace: System.Speech.Recognition.SrgsGrammar
  DNSrgsSemanticInterpretationTag = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsSemanticInterpretationTag, namespace: System.Speech.Recognition.SrgsGrammar
  DNSrgsSubset = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsSubset, namespace: System.Speech.Recognition.SrgsGrammar
  DNSrgsText = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsText, namespace: System.Speech.Recognition.SrgsGrammar
  DNSrgsToken = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsToken, namespace: System.Speech.Recognition.SrgsGrammar
  DNSpeechAudioFormatInfo = interface; // type: System.Speech.AudioFormat.SpeechAudioFormatInfo, namespace: System.Speech.AudioFormat
  DNChoices = interface; // type: System.Speech.Recognition.Choices, namespace: System.Speech.Recognition
  DNGrammar = interface; // type: System.Speech.Recognition.Grammar, namespace: System.Speech.Recognition
  DNDictationGrammar = interface; // type: System.Speech.Recognition.DictationGrammar, namespace: System.Speech.Recognition
  DNGrammarBuilder = interface; // type: System.Speech.Recognition.GrammarBuilder, namespace: System.Speech.Recognition
  DNRecognizedAudio = interface; // type: System.Speech.Recognition.RecognizedAudio, namespace: System.Speech.Recognition
  DNRecognizedPhrase = interface; // type: System.Speech.Recognition.RecognizedPhrase, namespace: System.Speech.Recognition
  DNRecognitionResult = interface; // type: System.Speech.Recognition.RecognitionResult, namespace: System.Speech.Recognition
  DNRecognizedWordUnit = interface; // type: System.Speech.Recognition.RecognizedWordUnit, namespace: System.Speech.Recognition
  DNRecognizerInfo = interface; // type: System.Speech.Recognition.RecognizerInfo, namespace: System.Speech.Recognition
  DNReplacementText = interface; // type: System.Speech.Recognition.ReplacementText, namespace: System.Speech.Recognition
  DNSemanticResultKey = interface; // type: System.Speech.Recognition.SemanticResultKey, namespace: System.Speech.Recognition
  DNSemanticResultValue = interface; // type: System.Speech.Recognition.SemanticResultValue, namespace: System.Speech.Recognition
  DNSemanticValue = interface; // type: System.Speech.Recognition.SemanticValue, namespace: System.Speech.Recognition
  DNSpeechRecognitionEngine = interface; // type: System.Speech.Recognition.SpeechRecognitionEngine, namespace: System.Speech.Recognition
  DNSpeechRecognizer = interface; // type: System.Speech.Recognition.SpeechRecognizer, namespace: System.Speech.Recognition
  DNSpeechUI = interface; // type: System.Speech.Recognition.SpeechUI, namespace: System.Speech.Recognition
  DNSrgsDocument = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsDocument, namespace: System.Speech.Recognition.SrgsGrammar
  DNSrgsGrammarCompiler = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsGrammarCompiler, namespace: System.Speech.Recognition.SrgsGrammar
  DNSrgsRule = interface; // type: System.Speech.Recognition.SrgsGrammar.SrgsRule, namespace: System.Speech.Recognition.SrgsGrammar
  DNInstalledVoice = interface; // type: System.Speech.Synthesis.InstalledVoice, namespace: System.Speech.Synthesis
  DNPrompt = interface; // type: System.Speech.Synthesis.Prompt, namespace: System.Speech.Synthesis
  DNFilePrompt = interface; // type: System.Speech.Synthesis.FilePrompt, namespace: System.Speech.Synthesis
  DNPromptBuilder = interface; // type: System.Speech.Synthesis.PromptBuilder, namespace: System.Speech.Synthesis
  DNPromptStyle = interface; // type: System.Speech.Synthesis.PromptStyle, namespace: System.Speech.Synthesis
  DNSpeechSynthesizer = interface; // type: System.Speech.Synthesis.SpeechSynthesizer, namespace: System.Speech.Synthesis
  DNProsody = interface; // type: System.Speech.Synthesis.TtsEngine.Prosody, namespace: System.Speech.Synthesis.TtsEngine
  DNTtsEngine_SayAs = interface; // type: System.Speech.Synthesis.TtsEngine.SayAs, namespace: System.Speech.Synthesis.TtsEngine
  DNSkipInfo = interface; // type: System.Speech.Synthesis.TtsEngine.SkipInfo, namespace: System.Speech.Synthesis.TtsEngine
  DNTextFragment = interface; // type: System.Speech.Synthesis.TtsEngine.TextFragment, namespace: System.Speech.Synthesis.TtsEngine
  DNTtsEngineSsml = interface; // type: System.Speech.Synthesis.TtsEngine.TtsEngineSsml, namespace: System.Speech.Synthesis.TtsEngine
  DNVoiceInfo = interface; // type: System.Speech.Synthesis.VoiceInfo, namespace: System.Speech.Synthesis
  DNContourPoint = interface; // type: System.Speech.Synthesis.TtsEngine.ContourPoint, namespace: System.Speech.Synthesis.TtsEngine
  DNFragmentState = interface; // type: System.Speech.Synthesis.TtsEngine.FragmentState, namespace: System.Speech.Synthesis.TtsEngine
  DNProsodyNumber = interface; // type: System.Speech.Synthesis.TtsEngine.ProsodyNumber, namespace: System.Speech.Synthesis.TtsEngine
  DNSpeechEventInfo = interface; // type: System.Speech.Synthesis.TtsEngine.SpeechEventInfo, namespace: System.Speech.Synthesis.TtsEngine


{ objects }

  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  [DNTypeName('System.Speech.Synthesis.TtsEngine.ITtsEngineSite')]
  DNITtsEngineSite = interface(DDN.mscorlib.DNObject)
  ['{9FDED17D-152B-353C-9041-2E64EFD93C09}']
  { getters & setters } 

    function get_EventInterest: Int32;
    function get_Actions: Int32;
    function get_Rate: Int32;
    function get_Volume: Int32;

  { methods } 

    procedure AddEvents(events: TArray<DNSpeechEventInfo>; count: Int32);
    function Write(data: IntPtr; count: Int32): Int32;
    function GetSkipInfo: DNSkipInfo;
    procedure CompleteSkip(skipped: Int32);
    function LoadResource(uri: DDN.System.DNUri; mediaType: string): DDN.mscorlib.DNStream;

  { propertys } 

    property EventInterest: Int32 read get_EventInterest;
    property Actions: Int32 read get_Actions;
    property Rate: Int32 read get_Rate;
    property Volume: Int32 read get_Volume;
  end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsRulesCollectionClass = interface(DDN.mscorlib.DNKeyedCollectionClass<string, DNSrgsRule>)
  ['{238D32DF-792E-5B8D-A43E-1E930FE56FDD}']
  { constructors } 

    {class} function init: DNSrgsRulesCollection;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsRulesCollection')]
  DNSrgsRulesCollection = interface(DDN.mscorlib.DNKeyedCollection<string, DNSrgsRule>)
  ['{748BCA0D-42FF-3129-862D-CD38EA7929CF}']
  { getters & setters } 

    function get_Comparer: DDN.mscorlib.DNIEqualityComparer<string>;
    function get_Item(key: string): DNSrgsRule;
    function get_Count: Int32;

  { methods } 

    procedure Add(rules: TArray<DNSrgsRule>);
    function &Contains(key: string): Boolean; overload;
    function Remove(key: string): Boolean;
    procedure CopyTo(&array: TArray<DNSrgsRule>; index: Int32);
    function &Contains(item: DNSrgsRule): Boolean; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNSrgsRule>;
    function IndexOf(item: DNSrgsRule): Int32;
    procedure RemoveAt(index: Int32);
    procedure Insert(index: Int32; item: DNSrgsRule);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Comparer: DDN.mscorlib.DNIEqualityComparer<string> read get_Comparer;
    property Item[key: string]: DNSrgsRule read get_Item; default;
    property Count: Int32 read get_Count;
  end;

  TDNSrgsRulesCollection = class(TDNGenericImport<DNSrgsRulesCollectionClass, DNSrgsRulesCollection>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNEmulateRecognizeCompletedEventArgsClass = interface(DNObjectClass)
  ['{66C94992-6970-5E8A-9364-C3F913A5D1FE}']
  end;

  [DNTypeName('System.Speech.Recognition.EmulateRecognizeCompletedEventArgs')]
  DNEmulateRecognizeCompletedEventArgs = interface(DNObject)
  ['{199C78C2-6017-31CC-B0F4-3092DB407787}']
  { getters & setters } 

    function get_Result: DNRecognitionResult;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Result: DNRecognitionResult read get_Result;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNEmulateRecognizeCompletedEventArgs = class(TDNGenericImport<DNEmulateRecognizeCompletedEventArgsClass, DNEmulateRecognizeCompletedEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNLoadGrammarCompletedEventArgsClass = interface(DNObjectClass)
  ['{41A2B6EF-D313-5DAF-95D3-DE56ABF16980}']
  end;

  [DNTypeName('System.Speech.Recognition.LoadGrammarCompletedEventArgs')]
  DNLoadGrammarCompletedEventArgs = interface(DNObject)
  ['{AFC9FCDE-E7B1-3EC8-A3DE-72D50615E67B}']
  { getters & setters } 

    function get_Grammar: DNGrammar;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Grammar: DNGrammar read get_Grammar;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNLoadGrammarCompletedEventArgs = class(TDNGenericImport<DNLoadGrammarCompletedEventArgsClass, DNLoadGrammarCompletedEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNRecognizeCompletedEventArgsClass = interface(DNObjectClass)
  ['{A8472A6A-BB9C-59FF-B54C-71777759A18F}']
  end;

  [DNTypeName('System.Speech.Recognition.RecognizeCompletedEventArgs')]
  DNRecognizeCompletedEventArgs = interface(DNObject)
  ['{E5B96E61-90E6-31B6-9BCE-81E1AFF52E09}']
  { getters & setters } 

    function get_Result: DNRecognitionResult;
    function get_InitialSilenceTimeout: Boolean;
    function get_BabbleTimeout: Boolean;
    function get_InputStreamEnded: Boolean;
    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Result: DNRecognitionResult read get_Result;
    property InitialSilenceTimeout: Boolean read get_InitialSilenceTimeout;
    property BabbleTimeout: Boolean read get_BabbleTimeout;
    property InputStreamEnded: Boolean read get_InputStreamEnded;
    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNRecognizeCompletedEventArgs = class(TDNGenericImport<DNRecognizeCompletedEventArgsClass, DNRecognizeCompletedEventArgs>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNPromptEventArgsClass = interface(DNObjectClass)
  ['{6BD0C842-578A-5EB5-90D7-165FEF1B1C10}']
  end;

  [DNTypeName('System.Speech.Synthesis.PromptEventArgs')]
  DNPromptEventArgs = interface(DNObject)
  ['{DB0E0CD4-47BA-31BE-919A-7ADBA5A9F8E9}']
  { getters & setters } 

    function get_Prompt: DNPrompt;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Prompt: DNPrompt read get_Prompt;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNPromptEventArgs = class(TDNGenericImport<DNPromptEventArgsClass, DNPromptEventArgs>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNBookmarkReachedEventArgsClass = interface(DNPromptEventArgsClass)
  ['{AC923FE4-15CB-53EB-9CEA-598E594B3F15}']
  end;

  [DNTypeName('System.Speech.Synthesis.BookmarkReachedEventArgs')]
  DNBookmarkReachedEventArgs = interface(DNPromptEventArgs)
  ['{92407FAB-AF8B-3DAC-8AD8-99E7AA556EDB}']
  { getters & setters } 

    function get_Bookmark: string;
    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_Prompt: DNPrompt;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Bookmark: string read get_Bookmark;
    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
    property Prompt: DNPrompt read get_Prompt;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNBookmarkReachedEventArgs = class(TDNGenericImport<DNBookmarkReachedEventArgsClass, DNBookmarkReachedEventArgs>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNPhonemeReachedEventArgsClass = interface(DNPromptEventArgsClass)
  ['{31C6CCF8-BB64-5CEA-835C-2A4EA9B60433}']
  end;

  [DNTypeName('System.Speech.Synthesis.PhonemeReachedEventArgs')]
  DNPhonemeReachedEventArgs = interface(DNPromptEventArgs)
  ['{AF2667B5-E2FE-30FB-828B-12B97ED0BFA5}']
  { getters & setters } 

    function get_Phoneme: string;
    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_Duration: DDN.mscorlib.DNTimeSpan;
    function get_Emphasis: DNSynthesizerEmphasis;
    function get_NextPhoneme: string;
    function get_Prompt: DNPrompt;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Phoneme: string read get_Phoneme;
    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
    property Duration: DDN.mscorlib.DNTimeSpan read get_Duration;
    property Emphasis: DNSynthesizerEmphasis read get_Emphasis;
    property NextPhoneme: string read get_NextPhoneme;
    property Prompt: DNPrompt read get_Prompt;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNPhonemeReachedEventArgs = class(TDNGenericImport<DNPhonemeReachedEventArgsClass, DNPhonemeReachedEventArgs>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNSpeakCompletedEventArgsClass = interface(DNPromptEventArgsClass)
  ['{449473BA-E581-5242-BEC3-C831E2151336}']
  end;

  [DNTypeName('System.Speech.Synthesis.SpeakCompletedEventArgs')]
  DNSpeakCompletedEventArgs = interface(DNPromptEventArgs)
  ['{F7AC5265-2371-3F5D-B775-89899C2B04BF}']
  { getters & setters } 

    function get_Prompt: DNPrompt;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Prompt: DNPrompt read get_Prompt;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNSpeakCompletedEventArgs = class(TDNGenericImport<DNSpeakCompletedEventArgsClass, DNSpeakCompletedEventArgs>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNSpeakProgressEventArgsClass = interface(DNPromptEventArgsClass)
  ['{99FD39A9-9E57-56A0-A308-FA9FD2C711F9}']
  end;

  [DNTypeName('System.Speech.Synthesis.SpeakProgressEventArgs')]
  DNSpeakProgressEventArgs = interface(DNPromptEventArgs)
  ['{FF4C759D-F2D4-317B-AADC-ABA4495B015F}']
  { getters & setters } 

    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_CharacterPosition: Int32;
    function get_CharacterCount: Int32;
    function get_Text: string;
    function get_Prompt: DNPrompt;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
    property CharacterPosition: Int32 read get_CharacterPosition;
    property CharacterCount: Int32 read get_CharacterCount;
    property Text: string read get_Text;
    property Prompt: DNPrompt read get_Prompt;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNSpeakProgressEventArgs = class(TDNGenericImport<DNSpeakProgressEventArgsClass, DNSpeakProgressEventArgs>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNSpeakStartedEventArgsClass = interface(DNPromptEventArgsClass)
  ['{72F0A4F3-FCD7-59D8-8266-9B15E9387858}']
  end;

  [DNTypeName('System.Speech.Synthesis.SpeakStartedEventArgs')]
  DNSpeakStartedEventArgs = interface(DNPromptEventArgs)
  ['{5C8792B0-FB78-34B8-87EB-F1E131428BA0}']
  { getters & setters } 

    function get_Prompt: DNPrompt;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Prompt: DNPrompt read get_Prompt;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNSpeakStartedEventArgs = class(TDNGenericImport<DNSpeakStartedEventArgsClass, DNSpeakStartedEventArgs>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNVisemeReachedEventArgsClass = interface(DNPromptEventArgsClass)
  ['{C196C06C-4A4F-528A-9137-3105032EE3B6}']
  end;

  [DNTypeName('System.Speech.Synthesis.VisemeReachedEventArgs')]
  DNVisemeReachedEventArgs = interface(DNPromptEventArgs)
  ['{91533B36-1445-3FA3-A30A-185D4BD8D869}']
  { getters & setters } 

    function get_Viseme: Int32;
    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_Duration: DDN.mscorlib.DNTimeSpan;
    function get_Emphasis: DNSynthesizerEmphasis;
    function get_NextViseme: Int32;
    function get_Prompt: DNPrompt;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Viseme: Int32 read get_Viseme;
    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
    property Duration: DDN.mscorlib.DNTimeSpan read get_Duration;
    property Emphasis: DNSynthesizerEmphasis read get_Emphasis;
    property NextViseme: Int32 read get_NextViseme;
    property Prompt: DNPrompt read get_Prompt;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNVisemeReachedEventArgs = class(TDNGenericImport<DNVisemeReachedEventArgsClass, DNVisemeReachedEventArgs>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNVoiceChangeEventArgsClass = interface(DNPromptEventArgsClass)
  ['{C292A17D-0A46-5A58-95DA-C21BA75FEB90}']
  end;

  [DNTypeName('System.Speech.Synthesis.VoiceChangeEventArgs')]
  DNVoiceChangeEventArgs = interface(DNPromptEventArgs)
  ['{DF8B6456-2EFC-3DE9-BB4F-48D6A3B5569E}']
  { getters & setters } 

    function get_Voice: DNVoiceInfo;
    function get_Prompt: DNPrompt;
    function get_Cancelled: Boolean;
    function get_Error: DDN.mscorlib.DNException;
    function get_UserState: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Voice: DNVoiceInfo read get_Voice;
    property Prompt: DNPrompt read get_Prompt;
    property Cancelled: Boolean read get_Cancelled;
    property Error: DDN.mscorlib.DNException read get_Error;
    property UserState: DDN.mscorlib.DNObject read get_UserState;
  end;

  TDNVoiceChangeEventArgs = class(TDNGenericImport<DNVoiceChangeEventArgsClass, DNVoiceChangeEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNAudioLevelUpdatedEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{A6429FA1-FC1B-5017-8EFF-5C86BA84F7F3}']
  end;

  [DNTypeName('System.Speech.Recognition.AudioLevelUpdatedEventArgs')]
  DNAudioLevelUpdatedEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{F0038F81-DCFE-3ABD-8D39-603E6E68F4F1}']
  { getters & setters } 

    function get_AudioLevel: Int32;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property AudioLevel: Int32 read get_AudioLevel;
  end;

  TDNAudioLevelUpdatedEventArgs = class(TDNGenericImport<DNAudioLevelUpdatedEventArgsClass, DNAudioLevelUpdatedEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNAudioSignalProblemOccurredEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{E04CB4BB-C2E0-54AA-8A6E-F19B78516E55}']
  end;

  [DNTypeName('System.Speech.Recognition.AudioSignalProblemOccurredEventArgs')]
  DNAudioSignalProblemOccurredEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{C329A897-9347-39FC-A98E-E27B245D0535}']
  { getters & setters } 

    function get_AudioSignalProblem: DNAudioSignalProblem;
    function get_AudioLevel: Int32;
    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_RecognizerAudioPosition: DDN.mscorlib.DNTimeSpan;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property AudioSignalProblem: DNAudioSignalProblem read get_AudioSignalProblem;
    property AudioLevel: Int32 read get_AudioLevel;
    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
    property RecognizerAudioPosition: DDN.mscorlib.DNTimeSpan read get_RecognizerAudioPosition;
  end;

  TDNAudioSignalProblemOccurredEventArgs = class(TDNGenericImport<DNAudioSignalProblemOccurredEventArgsClass, DNAudioSignalProblemOccurredEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNAudioStateChangedEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{46A70BFE-37D9-5D6E-A890-744202FDC2ED}']
  end;

  [DNTypeName('System.Speech.Recognition.AudioStateChangedEventArgs')]
  DNAudioStateChangedEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{3BB10173-AA22-3A00-B018-DF0D9361C651}']
  { getters & setters } 

    function get_AudioState: DNAudioState;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property AudioState: DNAudioState read get_AudioState;
  end;

  TDNAudioStateChangedEventArgs = class(TDNGenericImport<DNAudioStateChangedEventArgsClass, DNAudioStateChangedEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNRecognitionEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{3FFC0C2E-637E-59AA-A930-C198ADACA4A6}']
  end;

  [DNTypeName('System.Speech.Recognition.RecognitionEventArgs')]
  DNRecognitionEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{DBFF5C2F-CDD5-3320-9B33-735AA74B1FEE}']
  { getters & setters } 

    function get_Result: DNRecognitionResult;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Result: DNRecognitionResult read get_Result;
  end;

  TDNRecognitionEventArgs = class(TDNGenericImport<DNRecognitionEventArgsClass, DNRecognitionEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNSpeechHypothesizedEventArgsClass = interface(DNRecognitionEventArgsClass)
  ['{0CAEF78C-A890-5E63-B16F-5F45BA11E97E}']
  end;

  [DNTypeName('System.Speech.Recognition.SpeechHypothesizedEventArgs')]
  DNSpeechHypothesizedEventArgs = interface(DNRecognitionEventArgs)
  ['{2391D408-AB08-32F8-AD51-16478D125C7C}']
  { getters & setters } 

    function get_Result: DNRecognitionResult;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Result: DNRecognitionResult read get_Result;
  end;

  TDNSpeechHypothesizedEventArgs = class(TDNGenericImport<DNSpeechHypothesizedEventArgsClass, DNSpeechHypothesizedEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNSpeechRecognitionRejectedEventArgsClass = interface(DNRecognitionEventArgsClass)
  ['{27286D58-FE15-57F4-BC4C-0588730F25C1}']
  end;

  [DNTypeName('System.Speech.Recognition.SpeechRecognitionRejectedEventArgs')]
  DNSpeechRecognitionRejectedEventArgs = interface(DNRecognitionEventArgs)
  ['{64FB7D33-56E6-3B7B-8FA0-DBF0491E520E}']
  { getters & setters } 

    function get_Result: DNRecognitionResult;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Result: DNRecognitionResult read get_Result;
  end;

  TDNSpeechRecognitionRejectedEventArgs = class(TDNGenericImport<DNSpeechRecognitionRejectedEventArgsClass, DNSpeechRecognitionRejectedEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNSpeechRecognizedEventArgsClass = interface(DNRecognitionEventArgsClass)
  ['{8A65FA94-5AEE-5A5F-AA43-F9E41DB8516A}']
  end;

  [DNTypeName('System.Speech.Recognition.SpeechRecognizedEventArgs')]
  DNSpeechRecognizedEventArgs = interface(DNRecognitionEventArgs)
  ['{514EFF7E-63B7-385A-AADC-CFBA69187AC8}']
  { getters & setters } 

    function get_Result: DNRecognitionResult;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Result: DNRecognitionResult read get_Result;
  end;

  TDNSpeechRecognizedEventArgs = class(TDNGenericImport<DNSpeechRecognizedEventArgsClass, DNSpeechRecognizedEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNRecognizerUpdateReachedEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{F0A18C35-481D-52AD-AE0D-ECCFB1D579D0}']
  end;

  [DNTypeName('System.Speech.Recognition.RecognizerUpdateReachedEventArgs')]
  DNRecognizerUpdateReachedEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{009EE2D4-FA3D-3819-92A7-EB31D86CB0E6}']
  { getters & setters } 

    function get_UserToken: DDN.mscorlib.DNObject;
    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property UserToken: DDN.mscorlib.DNObject read get_UserToken;
    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
  end;

  TDNRecognizerUpdateReachedEventArgs = class(TDNGenericImport<DNRecognizerUpdateReachedEventArgsClass, DNRecognizerUpdateReachedEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNSpeechDetectedEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{129ABCF2-EEEA-5325-B977-FA49C6A5BC66}']
  end;

  [DNTypeName('System.Speech.Recognition.SpeechDetectedEventArgs')]
  DNSpeechDetectedEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{917A1E12-E132-32EA-9897-6AB69AF0C246}']
  { getters & setters } 

    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
  end;

  TDNSpeechDetectedEventArgs = class(TDNGenericImport<DNSpeechDetectedEventArgsClass, DNSpeechDetectedEventArgs>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNRecognition_StateChangedEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{F95E4C6A-AD8E-52AB-832B-D4560F67D59A}']
  end;

  [DNTypeName('System.Speech.Recognition.StateChangedEventArgs')]
  DNRecognition_StateChangedEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{B1FB438B-A246-3DAA-AA70-76860A46B597}']
  { getters & setters } 

    function get_RecognizerState: DNRecognizerState;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property RecognizerState: DNRecognizerState read get_RecognizerState;
  end;

  TDNRecognition_StateChangedEventArgs = class(TDNGenericImport<DNRecognition_StateChangedEventArgsClass, DNRecognition_StateChangedEventArgs>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNSynthesis_StateChangedEventArgsClass = interface(DDN.mscorlib.DNEventArgsClass)
  ['{152EB17F-3355-5DD1-A3A3-ED59D42E1B59}']
  end;

  [DNTypeName('System.Speech.Synthesis.StateChangedEventArgs')]
  DNSynthesis_StateChangedEventArgs = interface(DDN.mscorlib.DNEventArgs)
  ['{C2AB55F4-0250-3286-B559-BF6F2A25ABFB}']
  { getters & setters } 

    function get_State: DNSynthesizerState;
    function get_PreviousState: DNSynthesizerState;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property State: DNSynthesizerState read get_State;
    property PreviousState: DNSynthesizerState read get_PreviousState;
  end;

  TDNSynthesis_StateChangedEventArgs = class(TDNGenericImport<DNSynthesis_StateChangedEventArgsClass, DNSynthesis_StateChangedEventArgs>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsElementClass = interface(DDN.mscorlib.DNMarshalByRefObjectClass)
  ['{9DA9AD51-4525-533A-B13B-8F8596A8BD45}']
  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsElement')]
  DNSrgsElement = interface(DDN.mscorlib.DNMarshalByRefObject)
  ['{74A6534A-6FEB-3EA4-B0EC-7EA2FA9413B7}']
  { methods } 

    function GetLifetimeService: DDN.mscorlib.DNObject;
    function InitializeLifetimeService: DDN.mscorlib.DNObject;
    function CreateObjRef(requestedType: DDN.mscorlib.DNType): DDN.mscorlib.DNObjRef;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNSrgsElement = class(TDNGenericImport<DNSrgsElementClass, DNSrgsElement>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsItemClass = interface(DNSrgsElementClass)
  ['{49D8C6AF-1EF2-56D6-A0D6-FDABC8376667}']
  { constructors } 

    {class} function init: DNSrgsItem; overload;
    {class} function init(text: string): DNSrgsItem; overload;
    {class} function init(elements: TArray<DNSrgsElement>): DNSrgsItem; overload;
    {class} function init(repeatCount: Int32): DNSrgsItem; overload;
    {class} function init(min: Int32; max: Int32): DNSrgsItem; overload;
    {class} function init(min: Int32; max: Int32; text: string): DNSrgsItem; overload;
    {class} function init(min: Int32; max: Int32; elements: TArray<DNSrgsElement>): DNSrgsItem; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsItem')]
  DNSrgsItem = interface(DNSrgsElement)
  ['{39297572-4111-3374-85D4-04FCBC35B96F}']
  { getters & setters } 

    function get_Elements: DDN.mscorlib.DNCollection<DNSrgsElement>;
    function get_RepeatProbability: Single;
    procedure set_RepeatProbability(value: Single);
    function get_MinRepeat: Int32;
    function get_MaxRepeat: Int32;
    function get_Weight: Single;
    procedure set_Weight(value: Single);

  { methods } 

    procedure SetRepeat(count: Int32); overload;
    procedure SetRepeat(minRepeat: Int32; maxRepeat: Int32); overload;
    procedure Add(element: DNSrgsElement);
    function GetLifetimeService: DDN.mscorlib.DNObject;
    function InitializeLifetimeService: DDN.mscorlib.DNObject;
    function CreateObjRef(requestedType: DDN.mscorlib.DNType): DDN.mscorlib.DNObjRef;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Elements: DDN.mscorlib.DNCollection<DNSrgsElement> read get_Elements;
    property RepeatProbability: Single read get_RepeatProbability write set_RepeatProbability;
    property MinRepeat: Int32 read get_MinRepeat;
    property MaxRepeat: Int32 read get_MaxRepeat;
    property Weight: Single read get_Weight write set_Weight;
  end;

  TDNSrgsItem = class(TDNGenericImport<DNSrgsItemClass, DNSrgsItem>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsNameValueTagClass = interface(DNSrgsElementClass)
  ['{CDFD1D3A-D677-5F8F-8D0D-BE1A4ABFD6A8}']
  { constructors } 

    {class} function init: DNSrgsNameValueTag; overload;
    {class} function init(value: DDN.mscorlib.DNObject): DNSrgsNameValueTag; overload;
    {class} function init(name: string; value: DDN.mscorlib.DNObject): DNSrgsNameValueTag; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsNameValueTag')]
  DNSrgsNameValueTag = interface(DNSrgsElement)
  ['{D43D810E-D290-399F-A575-7AE775A0C13D}']
  { getters & setters } 

    function get_Name: string;
    procedure set_Name(value: string);
    function get_Value: DDN.mscorlib.DNObject;
    procedure set_Value(value: DDN.mscorlib.DNObject);

  { methods } 

    function GetLifetimeService: DDN.mscorlib.DNObject;
    function InitializeLifetimeService: DDN.mscorlib.DNObject;
    function CreateObjRef(requestedType: DDN.mscorlib.DNType): DDN.mscorlib.DNObjRef;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Name: string read get_Name write set_Name;
    property Value: DDN.mscorlib.DNObject read get_Value write set_Value;
  end;

  TDNSrgsNameValueTag = class(TDNGenericImport<DNSrgsNameValueTagClass, DNSrgsNameValueTag>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsOneOfClass = interface(DNSrgsElementClass)
  ['{84B1D712-88C7-5A35-8E91-FEF8D620E842}']
  { constructors } 

    {class} function init: DNSrgsOneOf; overload;
    {class} function init(items: TArray<string>): DNSrgsOneOf; overload;
    {class} function init(items: TArray<DNSrgsItem>): DNSrgsOneOf; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsOneOf')]
  DNSrgsOneOf = interface(DNSrgsElement)
  ['{AACE0F0C-F8DC-3366-86AA-F879AD47B094}']
  { getters & setters } 

    function get_Items: DDN.mscorlib.DNCollection<DNSrgsItem>;

  { methods } 

    procedure Add(item: DNSrgsItem);
    function GetLifetimeService: DDN.mscorlib.DNObject;
    function InitializeLifetimeService: DDN.mscorlib.DNObject;
    function CreateObjRef(requestedType: DDN.mscorlib.DNType): DDN.mscorlib.DNObjRef;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Items: DDN.mscorlib.DNCollection<DNSrgsItem> read get_Items;
  end;

  TDNSrgsOneOf = class(TDNGenericImport<DNSrgsOneOfClass, DNSrgsOneOf>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsRuleRefClass = interface(DNSrgsElementClass)
  ['{CAB3748E-FAB4-51E8-A843-2D8BCB7B6684}']
  { constructors } 

    {class} function init(uri: DDN.System.DNUri): DNSrgsRuleRef; overload;
    {class} function init(uri: DDN.System.DNUri; rule: string): DNSrgsRuleRef; overload;
    {class} function init(uri: DDN.System.DNUri; rule: string; semanticKey: string): DNSrgsRuleRef; overload;
    {class} function init(uri: DDN.System.DNUri; rule: string; semanticKey: string; parameters: string): DNSrgsRuleRef; overload;
    {class} function init(rule: DNSrgsRule): DNSrgsRuleRef; overload;
    {class} function init(rule: DNSrgsRule; semanticKey: string): DNSrgsRuleRef; overload;
    {class} function init(rule: DNSrgsRule; semanticKey: string; parameters: string): DNSrgsRuleRef; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_Null: DNSrgsRuleRef;
   function __fakeFieldGet_Void: DNSrgsRuleRef;
   function __fakeFieldGet_Garbage: DNSrgsRuleRef;
   function __fakeFieldGet_Dictation: DNSrgsRuleRef;
   function __fakeFieldGet_MnemonicSpelling: DNSrgsRuleRef;

  { static fields } 

    {class} property Null: DNSrgsRuleRef read __fakeFieldGet_Null;
    {class} property Void: DNSrgsRuleRef read __fakeFieldGet_Void;
    {class} property Garbage: DNSrgsRuleRef read __fakeFieldGet_Garbage;
    {class} property Dictation: DNSrgsRuleRef read __fakeFieldGet_Dictation;
    {class} property MnemonicSpelling: DNSrgsRuleRef read __fakeFieldGet_MnemonicSpelling;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsRuleRef')]
  DNSrgsRuleRef = interface(DNSrgsElement)
  ['{75081706-BADD-3246-8D0A-7A7E9FF8DCD9}']
  { getters & setters } 

    function get_Uri: DDN.System.DNUri;
    function get_SemanticKey: string;
    function get_Params: string;

  { methods } 

    function GetLifetimeService: DDN.mscorlib.DNObject;
    function InitializeLifetimeService: DDN.mscorlib.DNObject;
    function CreateObjRef(requestedType: DDN.mscorlib.DNType): DDN.mscorlib.DNObjRef;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Uri: DDN.System.DNUri read get_Uri;
    property SemanticKey: string read get_SemanticKey;
    property Params: string read get_Params;
  end;

  TDNSrgsRuleRef = class(TDNGenericImport<DNSrgsRuleRefClass, DNSrgsRuleRef>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsSemanticInterpretationTagClass = interface(DNSrgsElementClass)
  ['{35427AD5-8414-5523-A15C-04B921DB7378}']
  { constructors } 

    {class} function init: DNSrgsSemanticInterpretationTag; overload;
    {class} function init(script: string): DNSrgsSemanticInterpretationTag; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsSemanticInterpretationTag')]
  DNSrgsSemanticInterpretationTag = interface(DNSrgsElement)
  ['{3806C094-713A-38F5-87C8-E2CE7C68DB57}']
  { getters & setters } 

    function get_Script: string;
    procedure set_Script(value: string);

  { methods } 

    function GetLifetimeService: DDN.mscorlib.DNObject;
    function InitializeLifetimeService: DDN.mscorlib.DNObject;
    function CreateObjRef(requestedType: DDN.mscorlib.DNType): DDN.mscorlib.DNObjRef;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Script: string read get_Script write set_Script;
  end;

  TDNSrgsSemanticInterpretationTag = class(TDNGenericImport<DNSrgsSemanticInterpretationTagClass, DNSrgsSemanticInterpretationTag>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsSubsetClass = interface(DNSrgsElementClass)
  ['{01E639E4-97D5-553E-A57B-04D48A53B0CF}']
  { constructors } 

    {class} function init(text: string): DNSrgsSubset; overload;
    {class} function init(text: string; matchingMode: DNSubsetMatchingMode): DNSrgsSubset; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsSubset')]
  DNSrgsSubset = interface(DNSrgsElement)
  ['{BB23F47D-5021-3616-8B78-AC30EBDBE5EF}']
  { getters & setters } 

    function get_MatchingMode: DNSubsetMatchingMode;
    procedure set_MatchingMode(value: DNSubsetMatchingMode);
    function get_Text: string;
    procedure set_Text(value: string);

  { methods } 

    function GetLifetimeService: DDN.mscorlib.DNObject;
    function InitializeLifetimeService: DDN.mscorlib.DNObject;
    function CreateObjRef(requestedType: DDN.mscorlib.DNType): DDN.mscorlib.DNObjRef;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property MatchingMode: DNSubsetMatchingMode read get_MatchingMode write set_MatchingMode;
    property Text: string read get_Text write set_Text;
  end;

  TDNSrgsSubset = class(TDNGenericImport<DNSrgsSubsetClass, DNSrgsSubset>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsTextClass = interface(DNSrgsElementClass)
  ['{CA32993C-F995-59D4-BD52-44C46F6CDCC3}']
  { constructors } 

    {class} function init: DNSrgsText; overload;
    {class} function init(text: string): DNSrgsText; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsText')]
  DNSrgsText = interface(DNSrgsElement)
  ['{3DFC612E-9414-327A-AD87-CADF9E113EBA}']
  { getters & setters } 

    function get_Text: string;
    procedure set_Text(value: string);

  { methods } 

    function GetLifetimeService: DDN.mscorlib.DNObject;
    function InitializeLifetimeService: DDN.mscorlib.DNObject;
    function CreateObjRef(requestedType: DDN.mscorlib.DNType): DDN.mscorlib.DNObjRef;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Text: string read get_Text write set_Text;
  end;

  TDNSrgsText = class(TDNGenericImport<DNSrgsTextClass, DNSrgsText>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsTokenClass = interface(DNSrgsElementClass)
  ['{F1B31DC1-46F9-51FA-A22F-8D46113492B1}']
  { constructors } 

    {class} function init(text: string): DNSrgsToken;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsToken')]
  DNSrgsToken = interface(DNSrgsElement)
  ['{741CB8AB-F7A1-343C-AF61-AA685CD02CAA}']
  { getters & setters } 

    function get_Text: string;
    procedure set_Text(value: string);
    function get_Pronunciation: string;
    procedure set_Pronunciation(value: string);
    function get_Display: string;
    procedure set_Display(value: string);

  { methods } 

    function GetLifetimeService: DDN.mscorlib.DNObject;
    function InitializeLifetimeService: DDN.mscorlib.DNObject;
    function CreateObjRef(requestedType: DDN.mscorlib.DNType): DDN.mscorlib.DNObjRef;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Text: string read get_Text write set_Text;
    property Pronunciation: string read get_Pronunciation write set_Pronunciation;
    property Display: string read get_Display write set_Display;
  end;

  TDNSrgsToken = class(TDNGenericImport<DNSrgsTokenClass, DNSrgsToken>) end;

  //-------------namespace: System.Speech.AudioFormat----------------
  DNSpeechAudioFormatInfoClass = interface(DDN.mscorlib.DNObjectClass)
  ['{89BC0D07-5A05-597E-98BB-D31599C71122}']
  { constructors } 

    {class} function init(encodingFormat: DNEncodingFormat; samplesPerSecond: Int32; bitsPerSample: Int32; channelCount: Int32; averageBytesPerSecond: Int32; blockAlign: Int32; formatSpecificData: TArray<Byte>): DNSpeechAudioFormatInfo; overload;
    {class} function init(samplesPerSecond: Int32; bitsPerSample: DNAudioBitsPerSample; channel: DNAudioChannel): DNSpeechAudioFormatInfo; overload;

  end;

  [DNTypeName('System.Speech.AudioFormat.SpeechAudioFormatInfo')]
  DNSpeechAudioFormatInfo = interface(DDN.mscorlib.DNObject)
  ['{DF6F8A69-E227-3930-931D-2D348F772782}']
  { getters & setters } 

    function get_AverageBytesPerSecond: Int32;
    function get_BitsPerSample: Int32;
    function get_BlockAlign: Int32;
    function get_EncodingFormat: DNEncodingFormat;
    function get_ChannelCount: Int32;
    function get_SamplesPerSecond: Int32;

  { methods } 

    function FormatSpecificData: TArray<Byte>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property AverageBytesPerSecond: Int32 read get_AverageBytesPerSecond;
    property BitsPerSample: Int32 read get_BitsPerSample;
    property BlockAlign: Int32 read get_BlockAlign;
    property EncodingFormat: DNEncodingFormat read get_EncodingFormat;
    property ChannelCount: Int32 read get_ChannelCount;
    property SamplesPerSecond: Int32 read get_SamplesPerSecond;
  end;

  TDNSpeechAudioFormatInfo = class(TDNGenericImport<DNSpeechAudioFormatInfoClass, DNSpeechAudioFormatInfo>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNChoicesClass = interface(DDN.mscorlib.DNObjectClass)
  ['{54CA2C8C-2F60-5348-BBC3-4E437FD250C3}']
  { constructors } 

    {class} function init: DNChoices; overload;
    {class} function init(phrases: TArray<string>): DNChoices; overload;
    {class} function init(alternateChoices: TArray<DNGrammarBuilder>): DNChoices; overload;

  end;

  [DNTypeName('System.Speech.Recognition.Choices')]
  DNChoices = interface(DDN.mscorlib.DNObject)
  ['{E14FD64A-FCFB-38A4-A390-4AB10261F761}']
  { methods } 

    procedure Add(phrases: TArray<string>); overload;
    procedure Add(alternateChoices: TArray<DNGrammarBuilder>); overload;
    function ToGrammarBuilder: DNGrammarBuilder;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNChoices = class(TDNGenericImport<DNChoicesClass, DNChoices>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNGrammarClass = interface(DDN.mscorlib.DNObjectClass)
  ['{65B85C40-6135-5939-9728-B3C7DE55638B}']
  { constructors } 

    {class} function init(path: string): DNGrammar; overload;
    {class} function init(path: string; ruleName: string): DNGrammar; overload;
    {class} function init(path: string; ruleName: string; parameters: TArray<DDN.mscorlib.DNObject>): DNGrammar; overload;
    {class} function init(srgsDocument: DNSrgsDocument): DNGrammar; overload;
    {class} function init(srgsDocument: DNSrgsDocument; ruleName: string): DNGrammar; overload;
    {class} function init(srgsDocument: DNSrgsDocument; ruleName: string; parameters: TArray<DDN.mscorlib.DNObject>): DNGrammar; overload;
    {class} function init(srgsDocument: DNSrgsDocument; ruleName: string; baseUri: DDN.System.DNUri): DNGrammar; overload;
    {class} function init(srgsDocument: DNSrgsDocument; ruleName: string; baseUri: DDN.System.DNUri; parameters: TArray<DDN.mscorlib.DNObject>): DNGrammar; overload;
    {class} function init(stream: DDN.mscorlib.DNStream): DNGrammar; overload;
    {class} function init(stream: DDN.mscorlib.DNStream; ruleName: string): DNGrammar; overload;
    {class} function init(stream: DDN.mscorlib.DNStream; ruleName: string; parameters: TArray<DDN.mscorlib.DNObject>): DNGrammar; overload;
    {class} function init(stream: DDN.mscorlib.DNStream; ruleName: string; baseUri: DDN.System.DNUri): DNGrammar; overload;
    {class} function init(stream: DDN.mscorlib.DNStream; ruleName: string; baseUri: DDN.System.DNUri; parameters: TArray<DDN.mscorlib.DNObject>): DNGrammar; overload;
    {class} function init(builder: DNGrammarBuilder): DNGrammar; overload;

  { static methods } 

    {class} function LoadLocalizedGrammarFromType(&type: DDN.mscorlib.DNType; onInitParameters: TArray<DDN.mscorlib.DNObject>): DNGrammar;

  end;

  [DNTypeName('System.Speech.Recognition.Grammar')]
  DNGrammar = interface(DDN.mscorlib.DNObject)
  ['{F5BBCCB8-6BE5-39EE-BEB9-8FA0A5725151}']
  { getters & setters } 

    function get_Enabled: Boolean;
    procedure set_Enabled(value: Boolean);
    function get_Weight: Single;
    procedure set_Weight(value: Single);
    function get_Priority: Int32;
    procedure set_Priority(value: Int32);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_RuleName: string;
    function get_Loaded: Boolean;

  { events } 

    procedure add_SpeechRecognized(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognizedEventArgs>);
    procedure remove_SpeechRecognized(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognizedEventArgs>);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Enabled: Boolean read get_Enabled write set_Enabled;
    property Weight: Single read get_Weight write set_Weight;
    property Priority: Int32 read get_Priority write set_Priority;
    property Name: string read get_Name write set_Name;
    property RuleName: string read get_RuleName;
    property Loaded: Boolean read get_Loaded;
  end;

  TDNGrammar = class(TDNGenericImport<DNGrammarClass, DNGrammar>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNDictationGrammarClass = interface(DNGrammarClass)
  ['{9FC6157B-C6BA-5B73-99AD-EB3D925F10EE}']
  { constructors } 

    {class} function init: DNDictationGrammar; overload;
    {class} function init(topic: string): DNDictationGrammar; overload;

  end;

  [DNTypeName('System.Speech.Recognition.DictationGrammar')]
  DNDictationGrammar = interface(DNGrammar)
  ['{0382748C-BAB9-3127-865B-193EC336AAC5}']
  { getters & setters } 

    function get_Enabled: Boolean;
    procedure set_Enabled(value: Boolean);
    function get_Weight: Single;
    procedure set_Weight(value: Single);
    function get_Priority: Int32;
    procedure set_Priority(value: Int32);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_RuleName: string;
    function get_Loaded: Boolean;

  { events } 

    procedure add_SpeechRecognized(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognizedEventArgs>);
    procedure remove_SpeechRecognized(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognizedEventArgs>);

  { methods } 

    procedure SetDictationContext(precedingText: string; subsequentText: string);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Enabled: Boolean read get_Enabled write set_Enabled;
    property Weight: Single read get_Weight write set_Weight;
    property Priority: Int32 read get_Priority write set_Priority;
    property Name: string read get_Name write set_Name;
    property RuleName: string read get_RuleName;
    property Loaded: Boolean read get_Loaded;
  end;

  TDNDictationGrammar = class(TDNGenericImport<DNDictationGrammarClass, DNDictationGrammar>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNGrammarBuilderClass = interface(DDN.mscorlib.DNObjectClass)
  ['{06814EEE-D5B1-5F11-A74E-D88909120845}']
  { constructors } 

    {class} function init: DNGrammarBuilder; overload;
    {class} function init(phrase: string): DNGrammarBuilder; overload;
    {class} function init(phrase: string; subsetMatchingCriteria: DNSubsetMatchingMode): DNGrammarBuilder; overload;
    {class} function init(phrase: string; minRepeat: Int32; maxRepeat: Int32): DNGrammarBuilder; overload;
    {class} function init(builder: DNGrammarBuilder; minRepeat: Int32; maxRepeat: Int32): DNGrammarBuilder; overload;
    {class} function init(alternateChoices: DNChoices): DNGrammarBuilder; overload;
    {class} function init(key: DNSemanticResultKey): DNGrammarBuilder; overload;
    {class} function init(value: DNSemanticResultValue): DNGrammarBuilder; overload;

  { static methods } 

    {class} function Add(phrase: string; builder: DNGrammarBuilder): DNGrammarBuilder; overload;
    {class} function Add(builder: DNGrammarBuilder; phrase: string): DNGrammarBuilder; overload;
    {class} function Add(choices: DNChoices; builder: DNGrammarBuilder): DNGrammarBuilder; overload;
    {class} function Add(builder: DNGrammarBuilder; choices: DNChoices): DNGrammarBuilder; overload;
    {class} function Add(builder1: DNGrammarBuilder; builder2: DNGrammarBuilder): DNGrammarBuilder; overload;

  end;

  [DNTypeName('System.Speech.Recognition.GrammarBuilder')]
  DNGrammarBuilder = interface(DDN.mscorlib.DNObject)
  ['{5902BF62-A4DF-3576-B38A-AFE8263F954F}']
  { getters & setters } 

    function get_DebugShowPhrases: string;
    function get_Culture: DDN.mscorlib.DNCultureInfo;
    procedure set_Culture(value: DDN.mscorlib.DNCultureInfo);

  { methods } 

    procedure Append(phrase: string); overload;
    procedure Append(phrase: string; subsetMatchingCriteria: DNSubsetMatchingMode); overload;
    procedure Append(phrase: string; minRepeat: Int32; maxRepeat: Int32); overload;
    procedure Append(builder: DNGrammarBuilder); overload;
    procedure Append(alternateChoices: DNChoices); overload;
    procedure Append(key: DNSemanticResultKey); overload;
    procedure Append(value: DNSemanticResultValue); overload;
    procedure Append(builder: DNGrammarBuilder; minRepeat: Int32; maxRepeat: Int32); overload;
    procedure AppendDictation; overload;
    procedure AppendDictation(category: string); overload;
    procedure AppendWildcard;
    procedure AppendRuleReference(path: string); overload;
    procedure AppendRuleReference(path: string; rule: string); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property DebugShowPhrases: string read get_DebugShowPhrases;
    property Culture: DDN.mscorlib.DNCultureInfo read get_Culture write set_Culture;
  end;

  TDNGrammarBuilder = class(TDNGenericImport<DNGrammarBuilderClass, DNGrammarBuilder>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNRecognizedAudioClass = interface(DDN.mscorlib.DNObjectClass)
  ['{C758AB1B-9EA4-5C72-AE14-2F81189F7981}']
  end;

  [DNTypeName('System.Speech.Recognition.RecognizedAudio')]
  DNRecognizedAudio = interface(DDN.mscorlib.DNObject)
  ['{F7C98CE4-5C2D-3FB6-8851-B0E57A9707AF}']
  { getters & setters } 

    function get_Format: DNSpeechAudioFormatInfo;
    function get_StartTime: DDN.mscorlib.DNDateTime;
    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_Duration: DDN.mscorlib.DNTimeSpan;

  { methods } 

    procedure WriteToWaveStream(outputStream: DDN.mscorlib.DNStream);
    procedure WriteToAudioStream(outputStream: DDN.mscorlib.DNStream);
    function GetRange(audioPosition: DDN.mscorlib.DNTimeSpan; duration: DDN.mscorlib.DNTimeSpan): DNRecognizedAudio;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Format: DNSpeechAudioFormatInfo read get_Format;
    property StartTime: DDN.mscorlib.DNDateTime read get_StartTime;
    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
    property Duration: DDN.mscorlib.DNTimeSpan read get_Duration;
  end;

  TDNRecognizedAudio = class(TDNGenericImport<DNRecognizedAudioClass, DNRecognizedAudio>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNRecognizedPhraseClass = interface(DDN.mscorlib.DNObjectClass)
  ['{9BBFC25A-1284-558E-9326-710711B130F8}']
  end;

  [DNTypeName('System.Speech.Recognition.RecognizedPhrase')]
  DNRecognizedPhrase = interface(DDN.mscorlib.DNObject)
  ['{D61898F0-54DB-39CD-B353-47B025971BAE}']
  { getters & setters } 

    function get_Text: string;
    function get_Confidence: Single;
    function get_Words: DDN.mscorlib.DNReadOnlyCollection<DNRecognizedWordUnit>;
    function get_Semantics: DNSemanticValue;
    function get_Homophones: DDN.mscorlib.DNReadOnlyCollection<DNRecognizedPhrase>;
    function get_Grammar: DNGrammar;
    function get_ReplacementWordUnits: DDN.mscorlib.DNCollection<DNReplacementText>;
    function get_HomophoneGroupId: Int32;

  { methods } 

    function ConstructSmlFromSemantics: DDN.System.Xml.DNIXPathNavigable;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Text: string read get_Text;
    property Confidence: Single read get_Confidence;
    property Words: DDN.mscorlib.DNReadOnlyCollection<DNRecognizedWordUnit> read get_Words;
    property Semantics: DNSemanticValue read get_Semantics;
    property Homophones: DDN.mscorlib.DNReadOnlyCollection<DNRecognizedPhrase> read get_Homophones;
    property Grammar: DNGrammar read get_Grammar;
    property ReplacementWordUnits: DDN.mscorlib.DNCollection<DNReplacementText> read get_ReplacementWordUnits;
    property HomophoneGroupId: Int32 read get_HomophoneGroupId;
  end;

  TDNRecognizedPhrase = class(TDNGenericImport<DNRecognizedPhraseClass, DNRecognizedPhrase>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNRecognitionResultClass = interface(DNRecognizedPhraseClass)
  ['{F5D88BB8-DF16-5D53-83D2-4B556AE727F8}']
  end;

  [DNTypeName('System.Speech.Recognition.RecognitionResult')]
  DNRecognitionResult = interface(DNRecognizedPhrase)
  ['{B2425F6F-95FA-33F8-B5A0-A9349DC5525D}']
  { getters & setters } 

    function get_Audio: DNRecognizedAudio;
    function get_Alternates: DDN.mscorlib.DNReadOnlyCollection<DNRecognizedPhrase>;
    function get_Text: string;
    function get_Confidence: Single;
    function get_Words: DDN.mscorlib.DNReadOnlyCollection<DNRecognizedWordUnit>;
    function get_Semantics: DNSemanticValue;
    function get_Homophones: DDN.mscorlib.DNReadOnlyCollection<DNRecognizedPhrase>;
    function get_Grammar: DNGrammar;
    function get_ReplacementWordUnits: DDN.mscorlib.DNCollection<DNReplacementText>;
    function get_HomophoneGroupId: Int32;

  { methods } 

    function GetAudioForWordRange(firstWord: DNRecognizedWordUnit; lastWord: DNRecognizedWordUnit): DNRecognizedAudio;
    function ConstructSmlFromSemantics: DDN.System.Xml.DNIXPathNavigable;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Audio: DNRecognizedAudio read get_Audio;
    property Alternates: DDN.mscorlib.DNReadOnlyCollection<DNRecognizedPhrase> read get_Alternates;
    property Text: string read get_Text;
    property Confidence: Single read get_Confidence;
    property Words: DDN.mscorlib.DNReadOnlyCollection<DNRecognizedWordUnit> read get_Words;
    property Semantics: DNSemanticValue read get_Semantics;
    property Homophones: DDN.mscorlib.DNReadOnlyCollection<DNRecognizedPhrase> read get_Homophones;
    property Grammar: DNGrammar read get_Grammar;
    property ReplacementWordUnits: DDN.mscorlib.DNCollection<DNReplacementText> read get_ReplacementWordUnits;
    property HomophoneGroupId: Int32 read get_HomophoneGroupId;
  end;

  TDNRecognitionResult = class(TDNGenericImport<DNRecognitionResultClass, DNRecognitionResult>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNRecognizedWordUnitClass = interface(DDN.mscorlib.DNObjectClass)
  ['{67AE60BA-3717-59FF-979A-AEBC0CC41624}']
  { constructors } 

    {class} function init(text: string; confidence: Single; pronunciation: string; lexicalForm: string; displayAttributes: DNDisplayAttributes; audioPosition: DDN.mscorlib.DNTimeSpan; audioDuration: DDN.mscorlib.DNTimeSpan): DNRecognizedWordUnit;

  end;

  [DNTypeName('System.Speech.Recognition.RecognizedWordUnit')]
  DNRecognizedWordUnit = interface(DDN.mscorlib.DNObject)
  ['{C8782AA7-6CD7-3464-874C-A962070A2383}']
  { getters & setters } 

    function get_Text: string;
    function get_Confidence: Single;
    function get_Pronunciation: string;
    function get_LexicalForm: string;
    function get_DisplayAttributes: DNDisplayAttributes;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Text: string read get_Text;
    property Confidence: Single read get_Confidence;
    property Pronunciation: string read get_Pronunciation;
    property LexicalForm: string read get_LexicalForm;
    property DisplayAttributes: DNDisplayAttributes read get_DisplayAttributes;
  end;

  TDNRecognizedWordUnit = class(TDNGenericImport<DNRecognizedWordUnitClass, DNRecognizedWordUnit>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNRecognizerInfoClass = interface(DNObjectClass)
  ['{5E556195-6D9E-5C09-9103-F87C0B4468BF}']
  end;

  [DNTypeName('System.Speech.Recognition.RecognizerInfo')]
  DNRecognizerInfo = interface(DDN.mscorlib.DNIDisposable)
  ['{126015BA-82AD-3A73-889A-A2D558200564}']
  { getters & setters } 

    function get_Id: string;
    function get_Name: string;
    function get_Description: string;
    function get_Culture: DDN.mscorlib.DNCultureInfo;
    function get_SupportedAudioFormats: DDN.mscorlib.DNReadOnlyCollection<DNSpeechAudioFormatInfo>;
    function get_AdditionalInfo: DDN.mscorlib.DNIDictionary<string, string>;

  { methods } 

    procedure Dispose;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Id: string read get_Id;
    property Name: string read get_Name;
    property Description: string read get_Description;
    property Culture: DDN.mscorlib.DNCultureInfo read get_Culture;
    property SupportedAudioFormats: DDN.mscorlib.DNReadOnlyCollection<DNSpeechAudioFormatInfo> read get_SupportedAudioFormats;
    property AdditionalInfo: DDN.mscorlib.DNIDictionary<string, string> read get_AdditionalInfo;
  end;

  TDNRecognizerInfo = class(TDNGenericImport<DNRecognizerInfoClass, DNRecognizerInfo>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNReplacementTextClass = interface(DDN.mscorlib.DNObjectClass)
  ['{7CAA5297-3DB4-5322-BE15-B174192959C0}']
  end;

  [DNTypeName('System.Speech.Recognition.ReplacementText')]
  DNReplacementText = interface(DDN.mscorlib.DNObject)
  ['{5CF6BCB9-79BB-3C52-9010-5CE253F998E0}']
  { getters & setters } 

    function get_DisplayAttributes: DNDisplayAttributes;
    function get_Text: string;
    function get_FirstWordIndex: Int32;
    function get_CountOfWords: Int32;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property DisplayAttributes: DNDisplayAttributes read get_DisplayAttributes;
    property Text: string read get_Text;
    property FirstWordIndex: Int32 read get_FirstWordIndex;
    property CountOfWords: Int32 read get_CountOfWords;
  end;

  TDNReplacementText = class(TDNGenericImport<DNReplacementTextClass, DNReplacementText>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNSemanticResultKeyClass = interface(DDN.mscorlib.DNObjectClass)
  ['{8F017CE6-5481-5E3D-977C-CE42DA71206D}']
  { constructors } 

    {class} function init(semanticResultKey: string; phrases: TArray<string>): DNSemanticResultKey; overload;
    {class} function init(semanticResultKey: string; builders: TArray<DNGrammarBuilder>): DNSemanticResultKey; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SemanticResultKey')]
  DNSemanticResultKey = interface(DDN.mscorlib.DNObject)
  ['{FC84D12C-6D62-364F-AEFB-DAC7FFAEE4A5}']
  { methods } 

    function ToGrammarBuilder: DNGrammarBuilder;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNSemanticResultKey = class(TDNGenericImport<DNSemanticResultKeyClass, DNSemanticResultKey>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNSemanticResultValueClass = interface(DDN.mscorlib.DNObjectClass)
  ['{C51139F1-7D10-591D-9F2F-2645DC84BEE6}']
  { constructors } 

    {class} function init(value: DDN.mscorlib.DNObject): DNSemanticResultValue; overload;
    {class} function init(phrase: string; value: DDN.mscorlib.DNObject): DNSemanticResultValue; overload;
    {class} function init(builder: DNGrammarBuilder; value: DDN.mscorlib.DNObject): DNSemanticResultValue; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SemanticResultValue')]
  DNSemanticResultValue = interface(DDN.mscorlib.DNObject)
  ['{52555CBB-7278-3EFC-9737-D2549CE3E9B2}']
  { methods } 

    function ToGrammarBuilder: DNGrammarBuilder;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNSemanticResultValue = class(TDNGenericImport<DNSemanticResultValueClass, DNSemanticResultValue>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNSemanticValueClass = interface(DDN.mscorlib.DNObjectClass)
  ['{70105A02-3C2E-50D8-8421-EE336D7E1184}']
  { constructors } 

    {class} function init(keyName: string; value: DDN.mscorlib.DNObject; confidence: Single): DNSemanticValue; overload;
    {class} function init(value: DDN.mscorlib.DNObject): DNSemanticValue; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SemanticValue')]
  DNSemanticValue = interface(DDN.mscorlib.DNObject)
  ['{61E931A7-FEB2-3052-A328-C94255A87EDC}']
  { getters & setters } 

    function get_Value: DDN.mscorlib.DNObject;
    function get_Confidence: Single;
    function get_Count: Int32;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function &Contains(item: DDN.mscorlib.DNKeyValuePair<string, DNSemanticValue>): Boolean;
    function ContainsKey(key: string): Boolean;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Value: DDN.mscorlib.DNObject read get_Value;
    property Confidence: Single read get_Confidence;
    property Count: Int32 read get_Count;
  end;

  TDNSemanticValue = class(TDNGenericImport<DNSemanticValueClass, DNSemanticValue>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNSpeechRecognitionEngineClass = interface(DNObjectClass)
  ['{C38D283E-AFCD-56EC-B6F7-6B2D3C33FCCA}']
  { constructors } 

    {class} function init: DNSpeechRecognitionEngine; overload;
    {class} function init(culture: DDN.mscorlib.DNCultureInfo): DNSpeechRecognitionEngine; overload;
    {class} function init(recognizerId: string): DNSpeechRecognitionEngine; overload;
    {class} function init(recognizerInfo: DNRecognizerInfo): DNSpeechRecognitionEngine; overload;

  { static methods } 

    {class} function InstalledRecognizers: DDN.mscorlib.DNReadOnlyCollection<DNRecognizerInfo>;

  end;

  [DNTypeName('System.Speech.Recognition.SpeechRecognitionEngine')]
  DNSpeechRecognitionEngine = interface(DDN.mscorlib.DNIDisposable)
  ['{F2FEEE7A-3FA5-3F20-9A0E-47C427942366}']
  { getters & setters } 

    function get_InitialSilenceTimeout: DDN.mscorlib.DNTimeSpan;
    procedure set_InitialSilenceTimeout(value: DDN.mscorlib.DNTimeSpan);
    function get_BabbleTimeout: DDN.mscorlib.DNTimeSpan;
    procedure set_BabbleTimeout(value: DDN.mscorlib.DNTimeSpan);
    function get_EndSilenceTimeout: DDN.mscorlib.DNTimeSpan;
    procedure set_EndSilenceTimeout(value: DDN.mscorlib.DNTimeSpan);
    function get_EndSilenceTimeoutAmbiguous: DDN.mscorlib.DNTimeSpan;
    procedure set_EndSilenceTimeoutAmbiguous(value: DDN.mscorlib.DNTimeSpan);
    function get_Grammars: DDN.mscorlib.DNReadOnlyCollection<DNGrammar>;
    function get_RecognizerInfo: DNRecognizerInfo;
    function get_AudioState: DNAudioState;
    function get_AudioLevel: Int32;
    function get_RecognizerAudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_AudioFormat: DNSpeechAudioFormatInfo;
    function get_MaxAlternates: Int32;
    procedure set_MaxAlternates(value: Int32);

  { events } 

    procedure add_RecognizeCompleted(value: DDN.mscorlib.DNEventHandler<DNRecognizeCompletedEventArgs>);
    procedure remove_RecognizeCompleted(value: DDN.mscorlib.DNEventHandler<DNRecognizeCompletedEventArgs>);
    procedure add_EmulateRecognizeCompleted(value: DDN.mscorlib.DNEventHandler<DNEmulateRecognizeCompletedEventArgs>);
    procedure remove_EmulateRecognizeCompleted(value: DDN.mscorlib.DNEventHandler<DNEmulateRecognizeCompletedEventArgs>);
    procedure add_LoadGrammarCompleted(value: DDN.mscorlib.DNEventHandler<DNLoadGrammarCompletedEventArgs>);
    procedure remove_LoadGrammarCompleted(value: DDN.mscorlib.DNEventHandler<DNLoadGrammarCompletedEventArgs>);
    procedure add_SpeechDetected(value: DDN.mscorlib.DNEventHandler<DNSpeechDetectedEventArgs>);
    procedure remove_SpeechDetected(value: DDN.mscorlib.DNEventHandler<DNSpeechDetectedEventArgs>);
    procedure add_SpeechRecognized(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognizedEventArgs>);
    procedure remove_SpeechRecognized(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognizedEventArgs>);
    procedure add_SpeechRecognitionRejected(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognitionRejectedEventArgs>);
    procedure remove_SpeechRecognitionRejected(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognitionRejectedEventArgs>);
    procedure add_RecognizerUpdateReached(value: DDN.mscorlib.DNEventHandler<DNRecognizerUpdateReachedEventArgs>);
    procedure remove_RecognizerUpdateReached(value: DDN.mscorlib.DNEventHandler<DNRecognizerUpdateReachedEventArgs>);
    procedure add_SpeechHypothesized(value: DDN.mscorlib.DNEventHandler<DNSpeechHypothesizedEventArgs>);
    procedure remove_SpeechHypothesized(value: DDN.mscorlib.DNEventHandler<DNSpeechHypothesizedEventArgs>);
    procedure add_AudioSignalProblemOccurred(value: DDN.mscorlib.DNEventHandler<DNAudioSignalProblemOccurredEventArgs>);
    procedure remove_AudioSignalProblemOccurred(value: DDN.mscorlib.DNEventHandler<DNAudioSignalProblemOccurredEventArgs>);
    procedure add_AudioLevelUpdated(value: DDN.mscorlib.DNEventHandler<DNAudioLevelUpdatedEventArgs>);
    procedure remove_AudioLevelUpdated(value: DDN.mscorlib.DNEventHandler<DNAudioLevelUpdatedEventArgs>);
    procedure add_AudioStateChanged(value: DDN.mscorlib.DNEventHandler<DNAudioStateChangedEventArgs>);
    procedure remove_AudioStateChanged(value: DDN.mscorlib.DNEventHandler<DNAudioStateChangedEventArgs>);

  { methods } 

    procedure Dispose;
    procedure SetInputToWaveFile(path: string);
    procedure SetInputToWaveStream(audioSource: DDN.mscorlib.DNStream);
    procedure SetInputToAudioStream(audioSource: DDN.mscorlib.DNStream; audioFormat: DNSpeechAudioFormatInfo);
    procedure SetInputToNull;
    procedure SetInputToDefaultAudioDevice;
    function Recognize: DNRecognitionResult; overload;
    function Recognize(initialSilenceTimeout: DDN.mscorlib.DNTimeSpan): DNRecognitionResult; overload;
    procedure RecognizeAsync; overload;
    procedure RecognizeAsync(mode: DNRecognizeMode); overload;
    procedure RecognizeAsyncCancel;
    procedure RecognizeAsyncStop;
    function QueryRecognizerSetting(settingName: string): DDN.mscorlib.DNObject;
    procedure UpdateRecognizerSetting(settingName: string; updatedValue: string); overload;
    procedure UpdateRecognizerSetting(settingName: string; updatedValue: Int32); overload;
    procedure LoadGrammar(grammar: DNGrammar);
    procedure LoadGrammarAsync(grammar: DNGrammar);
    procedure UnloadGrammar(grammar: DNGrammar);
    procedure UnloadAllGrammars;
    function EmulateRecognize(inputText: string): DNRecognitionResult; overload;
    function EmulateRecognize(inputText: string; compareOptions: DDN.mscorlib.DNCompareOptions): DNRecognitionResult; overload;
    function EmulateRecognize(wordUnits: TArray<DNRecognizedWordUnit>; compareOptions: DDN.mscorlib.DNCompareOptions): DNRecognitionResult; overload;
    procedure EmulateRecognizeAsync(inputText: string); overload;
    procedure EmulateRecognizeAsync(inputText: string; compareOptions: DDN.mscorlib.DNCompareOptions); overload;
    procedure EmulateRecognizeAsync(wordUnits: TArray<DNRecognizedWordUnit>; compareOptions: DDN.mscorlib.DNCompareOptions); overload;
    procedure RequestRecognizerUpdate; overload;
    procedure RequestRecognizerUpdate(userToken: DDN.mscorlib.DNObject); overload;
    procedure RequestRecognizerUpdate(userToken: DDN.mscorlib.DNObject; audioPositionAheadToRaiseUpdate: DDN.mscorlib.DNTimeSpan); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InitialSilenceTimeout: DDN.mscorlib.DNTimeSpan read get_InitialSilenceTimeout write set_InitialSilenceTimeout;
    property BabbleTimeout: DDN.mscorlib.DNTimeSpan read get_BabbleTimeout write set_BabbleTimeout;
    property EndSilenceTimeout: DDN.mscorlib.DNTimeSpan read get_EndSilenceTimeout write set_EndSilenceTimeout;
    property EndSilenceTimeoutAmbiguous: DDN.mscorlib.DNTimeSpan read get_EndSilenceTimeoutAmbiguous write set_EndSilenceTimeoutAmbiguous;
    property Grammars: DDN.mscorlib.DNReadOnlyCollection<DNGrammar> read get_Grammars;
    property RecognizerInfo: DNRecognizerInfo read get_RecognizerInfo;
    property AudioState: DNAudioState read get_AudioState;
    property AudioLevel: Int32 read get_AudioLevel;
    property RecognizerAudioPosition: DDN.mscorlib.DNTimeSpan read get_RecognizerAudioPosition;
    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
    property AudioFormat: DNSpeechAudioFormatInfo read get_AudioFormat;
    property MaxAlternates: Int32 read get_MaxAlternates write set_MaxAlternates;
  end;

  TDNSpeechRecognitionEngine = class(TDNGenericImport<DNSpeechRecognitionEngineClass, DNSpeechRecognitionEngine>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNSpeechRecognizerClass = interface(DNObjectClass)
  ['{BACCC693-588E-5C71-A7E4-73DDF34C5279}']
  { constructors } 

    {class} function init: DNSpeechRecognizer;

  end;

  [DNTypeName('System.Speech.Recognition.SpeechRecognizer')]
  DNSpeechRecognizer = interface(DDN.mscorlib.DNIDisposable)
  ['{55961FA0-F1C5-32E9-A907-14B44AEF8ECE}']
  { getters & setters } 

    function get_State: DNRecognizerState;
    function get_Enabled: Boolean;
    procedure set_Enabled(value: Boolean);
    function get_PauseRecognizerOnRecognition: Boolean;
    procedure set_PauseRecognizerOnRecognition(value: Boolean);
    function get_Grammars: DDN.mscorlib.DNReadOnlyCollection<DNGrammar>;
    function get_RecognizerInfo: DNRecognizerInfo;
    function get_AudioState: DNAudioState;
    function get_AudioLevel: Int32;
    function get_AudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_RecognizerAudioPosition: DDN.mscorlib.DNTimeSpan;
    function get_AudioFormat: DNSpeechAudioFormatInfo;
    function get_MaxAlternates: Int32;
    procedure set_MaxAlternates(value: Int32);

  { events } 

    procedure add_StateChanged(value: DDN.mscorlib.DNEventHandler<DNRecognition_StateChangedEventArgs>);
    procedure remove_StateChanged(value: DDN.mscorlib.DNEventHandler<DNRecognition_StateChangedEventArgs>);
    procedure add_EmulateRecognizeCompleted(value: DDN.mscorlib.DNEventHandler<DNEmulateRecognizeCompletedEventArgs>);
    procedure remove_EmulateRecognizeCompleted(value: DDN.mscorlib.DNEventHandler<DNEmulateRecognizeCompletedEventArgs>);
    procedure add_LoadGrammarCompleted(value: DDN.mscorlib.DNEventHandler<DNLoadGrammarCompletedEventArgs>);
    procedure remove_LoadGrammarCompleted(value: DDN.mscorlib.DNEventHandler<DNLoadGrammarCompletedEventArgs>);
    procedure add_SpeechDetected(value: DDN.mscorlib.DNEventHandler<DNSpeechDetectedEventArgs>);
    procedure remove_SpeechDetected(value: DDN.mscorlib.DNEventHandler<DNSpeechDetectedEventArgs>);
    procedure add_SpeechRecognized(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognizedEventArgs>);
    procedure remove_SpeechRecognized(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognizedEventArgs>);
    procedure add_SpeechRecognitionRejected(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognitionRejectedEventArgs>);
    procedure remove_SpeechRecognitionRejected(value: DDN.mscorlib.DNEventHandler<DNSpeechRecognitionRejectedEventArgs>);
    procedure add_RecognizerUpdateReached(value: DDN.mscorlib.DNEventHandler<DNRecognizerUpdateReachedEventArgs>);
    procedure remove_RecognizerUpdateReached(value: DDN.mscorlib.DNEventHandler<DNRecognizerUpdateReachedEventArgs>);
    procedure add_SpeechHypothesized(value: DDN.mscorlib.DNEventHandler<DNSpeechHypothesizedEventArgs>);
    procedure remove_SpeechHypothesized(value: DDN.mscorlib.DNEventHandler<DNSpeechHypothesizedEventArgs>);
    procedure add_AudioSignalProblemOccurred(value: DDN.mscorlib.DNEventHandler<DNAudioSignalProblemOccurredEventArgs>);
    procedure remove_AudioSignalProblemOccurred(value: DDN.mscorlib.DNEventHandler<DNAudioSignalProblemOccurredEventArgs>);
    procedure add_AudioLevelUpdated(value: DDN.mscorlib.DNEventHandler<DNAudioLevelUpdatedEventArgs>);
    procedure remove_AudioLevelUpdated(value: DDN.mscorlib.DNEventHandler<DNAudioLevelUpdatedEventArgs>);
    procedure add_AudioStateChanged(value: DDN.mscorlib.DNEventHandler<DNAudioStateChangedEventArgs>);
    procedure remove_AudioStateChanged(value: DDN.mscorlib.DNEventHandler<DNAudioStateChangedEventArgs>);

  { methods } 

    procedure Dispose;
    procedure LoadGrammar(grammar: DNGrammar);
    procedure LoadGrammarAsync(grammar: DNGrammar);
    procedure UnloadGrammar(grammar: DNGrammar);
    procedure UnloadAllGrammars;
    function EmulateRecognize(inputText: string): DNRecognitionResult; overload;
    function EmulateRecognize(inputText: string; compareOptions: DDN.mscorlib.DNCompareOptions): DNRecognitionResult; overload;
    function EmulateRecognize(wordUnits: TArray<DNRecognizedWordUnit>; compareOptions: DDN.mscorlib.DNCompareOptions): DNRecognitionResult; overload;
    procedure EmulateRecognizeAsync(inputText: string); overload;
    procedure EmulateRecognizeAsync(inputText: string; compareOptions: DDN.mscorlib.DNCompareOptions); overload;
    procedure EmulateRecognizeAsync(wordUnits: TArray<DNRecognizedWordUnit>; compareOptions: DDN.mscorlib.DNCompareOptions); overload;
    procedure RequestRecognizerUpdate; overload;
    procedure RequestRecognizerUpdate(userToken: DDN.mscorlib.DNObject); overload;
    procedure RequestRecognizerUpdate(userToken: DDN.mscorlib.DNObject; audioPositionAheadToRaiseUpdate: DDN.mscorlib.DNTimeSpan); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property State: DNRecognizerState read get_State;
    property Enabled: Boolean read get_Enabled write set_Enabled;
    property PauseRecognizerOnRecognition: Boolean read get_PauseRecognizerOnRecognition write set_PauseRecognizerOnRecognition;
    property Grammars: DDN.mscorlib.DNReadOnlyCollection<DNGrammar> read get_Grammars;
    property RecognizerInfo: DNRecognizerInfo read get_RecognizerInfo;
    property AudioState: DNAudioState read get_AudioState;
    property AudioLevel: Int32 read get_AudioLevel;
    property AudioPosition: DDN.mscorlib.DNTimeSpan read get_AudioPosition;
    property RecognizerAudioPosition: DDN.mscorlib.DNTimeSpan read get_RecognizerAudioPosition;
    property AudioFormat: DNSpeechAudioFormatInfo read get_AudioFormat;
    property MaxAlternates: Int32 read get_MaxAlternates write set_MaxAlternates;
  end;

  TDNSpeechRecognizer = class(TDNGenericImport<DNSpeechRecognizerClass, DNSpeechRecognizer>) end;

  //-------------namespace: System.Speech.Recognition----------------
  DNSpeechUIClass = interface(DDN.mscorlib.DNObjectClass)
  ['{59830B4A-8EED-5C0F-8E14-6471B1DBC974}']
  { static methods } 

    {class} function SendTextFeedback(result: DNRecognitionResult; feedback: string; isSuccessfulAction: Boolean): Boolean;

  end;

  [DNTypeName('System.Speech.Recognition.SpeechUI')]
  DNSpeechUI = interface(DDN.mscorlib.DNObject)
  ['{BDA7F10E-A7AD-3066-A4DE-C1862E589238}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNSpeechUI = class(TDNGenericImport<DNSpeechUIClass, DNSpeechUI>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsDocumentClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B1B8F995-4B70-5AEE-A451-6B3B25CD0298}']
  { constructors } 

    {class} function init: DNSrgsDocument; overload;
    {class} function init(path: string): DNSrgsDocument; overload;
    {class} function init(srgsGrammar: DDN.System.Xml.DNXmlReader): DNSrgsDocument; overload;
    {class} function init(builder: DNGrammarBuilder): DNSrgsDocument; overload;
    {class} function init(grammarRootRule: DNSrgsRule): DNSrgsDocument; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsDocument')]
  DNSrgsDocument = interface(DDN.mscorlib.DNObject)
  ['{B7BF4B01-2EB8-3E2B-A7D8-24748240B062}']
  { getters & setters } 

    function get_XmlBase: DDN.System.DNUri;
    procedure set_XmlBase(value: DDN.System.DNUri);
    function get_Culture: DDN.mscorlib.DNCultureInfo;
    procedure set_Culture(value: DDN.mscorlib.DNCultureInfo);
    function get_Root: DNSrgsRule;
    procedure set_Root(value: DNSrgsRule);
    function get_Mode: DNSrgsGrammarMode;
    procedure set_Mode(value: DNSrgsGrammarMode);
    function get_PhoneticAlphabet: DNSrgsPhoneticAlphabet;
    procedure set_PhoneticAlphabet(value: DNSrgsPhoneticAlphabet);
    function get_Rules: DNSrgsRulesCollection;
    function get_Language: string;
    procedure set_Language(value: string);
    function get_Namespace: string;
    procedure set_Namespace(value: string);
    function get_CodeBehind: DDN.mscorlib.DNCollection<string>;
    function get_Debug: Boolean;
    procedure set_Debug(value: Boolean);
    function get_Script: string;
    procedure set_Script(value: string);
    function get_ImportNamespaces: DDN.mscorlib.DNCollection<string>;
    function get_AssemblyReferences: DDN.mscorlib.DNCollection<string>;

  { methods } 

    procedure WriteSrgs(srgsGrammar: DDN.System.Xml.DNXmlWriter);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property XmlBase: DDN.System.DNUri read get_XmlBase write set_XmlBase;
    property Culture: DDN.mscorlib.DNCultureInfo read get_Culture write set_Culture;
    property Root: DNSrgsRule read get_Root write set_Root;
    property Mode: DNSrgsGrammarMode read get_Mode write set_Mode;
    property PhoneticAlphabet: DNSrgsPhoneticAlphabet read get_PhoneticAlphabet write set_PhoneticAlphabet;
    property Rules: DNSrgsRulesCollection read get_Rules;
    property Language: string read get_Language write set_Language;
    property Namespace: string read get_Namespace write set_Namespace;
    property CodeBehind: DDN.mscorlib.DNCollection<string> read get_CodeBehind;
    property Debug: Boolean read get_Debug write set_Debug;
    property Script: string read get_Script write set_Script;
    property ImportNamespaces: DDN.mscorlib.DNCollection<string> read get_ImportNamespaces;
    property AssemblyReferences: DDN.mscorlib.DNCollection<string> read get_AssemblyReferences;
  end;

  TDNSrgsDocument = class(TDNGenericImport<DNSrgsDocumentClass, DNSrgsDocument>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsGrammarCompilerClass = interface(DDN.mscorlib.DNObjectClass)
  ['{806684BA-6D7A-5915-BAD0-855C22DCB85A}']
  { static methods } 

    {class} procedure Compile(inputPath: string; outputStream: DDN.mscorlib.DNStream); overload;
    {class} procedure Compile(srgsGrammar: DNSrgsDocument; outputStream: DDN.mscorlib.DNStream); overload;
    {class} procedure Compile(reader: DDN.System.Xml.DNXmlReader; outputStream: DDN.mscorlib.DNStream); overload;
    {class} procedure CompileClassLibrary(inputPaths: TArray<string>; outputPath: string; referencedAssemblies: TArray<string>; keyFile: string); overload;
    {class} procedure CompileClassLibrary(srgsGrammar: DNSrgsDocument; outputPath: string; referencedAssemblies: TArray<string>; keyFile: string); overload;
    {class} procedure CompileClassLibrary(reader: DDN.System.Xml.DNXmlReader; outputPath: string; referencedAssemblies: TArray<string>; keyFile: string); overload;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsGrammarCompiler')]
  DNSrgsGrammarCompiler = interface(DDN.mscorlib.DNObject)
  ['{FC8F69D6-82FC-3077-B31F-FE90832F3964}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNSrgsGrammarCompiler = class(TDNGenericImport<DNSrgsGrammarCompilerClass, DNSrgsGrammarCompiler>) end;

  //-------------namespace: System.Speech.Recognition.SrgsGrammar----------------
  DNSrgsRuleClass = interface(DDN.mscorlib.DNObjectClass)
  ['{936502DD-2CE5-524C-AE9D-F3A1330E7541}']
  { constructors } 

    {class} function init(id: string): DNSrgsRule; overload;
    {class} function init(id: string; elements: TArray<DNSrgsElement>): DNSrgsRule; overload;

  end;

  [DNTypeName('System.Speech.Recognition.SrgsGrammar.SrgsRule')]
  DNSrgsRule = interface(DDN.mscorlib.DNObject)
  ['{4C27DA5F-22FB-3055-BF3C-6E52FC782F00}']
  { getters & setters } 

    function get_Elements: DDN.mscorlib.DNCollection<DNSrgsElement>;
    function get_Id: string;
    procedure set_Id(value: string);
    function get_Scope: DNSrgsRuleScope;
    procedure set_Scope(value: DNSrgsRuleScope);
    function get_BaseClass: string;
    procedure set_BaseClass(value: string);
    function get_Script: string;
    procedure set_Script(value: string);
    function get_OnInit: string;
    procedure set_OnInit(value: string);
    function get_OnParse: string;
    procedure set_OnParse(value: string);
    function get_OnError: string;
    procedure set_OnError(value: string);
    function get_OnRecognition: string;
    procedure set_OnRecognition(value: string);

  { methods } 

    procedure Add(element: DNSrgsElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Elements: DDN.mscorlib.DNCollection<DNSrgsElement> read get_Elements;
    property Id: string read get_Id write set_Id;
    property Scope: DNSrgsRuleScope read get_Scope write set_Scope;
    property BaseClass: string read get_BaseClass write set_BaseClass;
    property Script: string read get_Script write set_Script;
    property OnInit: string read get_OnInit write set_OnInit;
    property OnParse: string read get_OnParse write set_OnParse;
    property OnError: string read get_OnError write set_OnError;
    property OnRecognition: string read get_OnRecognition write set_OnRecognition;
  end;

  TDNSrgsRule = class(TDNGenericImport<DNSrgsRuleClass, DNSrgsRule>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNInstalledVoiceClass = interface(DDN.mscorlib.DNObjectClass)
  ['{F3938146-2A1A-5F4F-A10B-CC94D856127B}']
  end;

  [DNTypeName('System.Speech.Synthesis.InstalledVoice')]
  DNInstalledVoice = interface(DDN.mscorlib.DNObject)
  ['{3B96E379-6DCD-3D97-AC03-41A6B44A4A42}']
  { getters & setters } 

    function get_VoiceInfo: DNVoiceInfo;
    function get_Enabled: Boolean;
    procedure set_Enabled(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property VoiceInfo: DNVoiceInfo read get_VoiceInfo;
    property Enabled: Boolean read get_Enabled write set_Enabled;
  end;

  TDNInstalledVoice = class(TDNGenericImport<DNInstalledVoiceClass, DNInstalledVoice>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNPromptClass = interface(DDN.mscorlib.DNObjectClass)
  ['{E8361B87-257D-519B-9CEA-304FFE503BC8}']
  { constructors } 

    {class} function init(textToSpeak: string): DNPrompt; overload;
    {class} function init(promptBuilder: DNPromptBuilder): DNPrompt; overload;
    {class} function init(textToSpeak: string; media: DNSynthesisTextFormat): DNPrompt; overload;

  end;

  [DNTypeName('System.Speech.Synthesis.Prompt')]
  DNPrompt = interface(DDN.mscorlib.DNObject)
  ['{0E5E20DF-F951-3932-AF44-AE2B15F941DF}']
  { getters & setters } 

    function get_IsCompleted: Boolean;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property IsCompleted: Boolean read get_IsCompleted;
  end;

  TDNPrompt = class(TDNGenericImport<DNPromptClass, DNPrompt>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNFilePromptClass = interface(DNPromptClass)
  ['{59C35C7B-65A0-5E1B-94DC-7667610ED31E}']
  { constructors } 

    {class} function init(path: string; media: DNSynthesisMediaType): DNFilePrompt; overload;
    {class} function init(promptFile: DDN.System.DNUri; media: DNSynthesisMediaType): DNFilePrompt; overload;

  end;

  [DNTypeName('System.Speech.Synthesis.FilePrompt')]
  DNFilePrompt = interface(DNPrompt)
  ['{F422D9CF-2F0A-3FE2-8ADA-0BF552D16F9E}']
  { getters & setters } 

    function get_IsCompleted: Boolean;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property IsCompleted: Boolean read get_IsCompleted;
  end;

  TDNFilePrompt = class(TDNGenericImport<DNFilePromptClass, DNFilePrompt>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNPromptBuilderClass = interface(DDN.mscorlib.DNObjectClass)
  ['{691A97B3-BDC8-5D94-BEEC-A92840A6657E}']
  { constructors } 

    {class} function init: DNPromptBuilder; overload;
    {class} function init(culture: DDN.mscorlib.DNCultureInfo): DNPromptBuilder; overload;

  end;

  [DNTypeName('System.Speech.Synthesis.PromptBuilder')]
  DNPromptBuilder = interface(DDN.mscorlib.DNObject)
  ['{C6CB7F85-CC43-30F8-815E-291781340168}']
  { getters & setters } 

    function get_IsEmpty: Boolean;
    function get_Culture: DDN.mscorlib.DNCultureInfo;
    procedure set_Culture(value: DDN.mscorlib.DNCultureInfo);

  { methods } 

    procedure ClearContent;
    procedure AppendText(textToSpeak: string); overload;
    procedure AppendText(textToSpeak: string; rate: DNPromptRate); overload;
    procedure AppendText(textToSpeak: string; volume: DNPromptVolume); overload;
    procedure AppendText(textToSpeak: string; emphasis: DNPromptEmphasis); overload;
    procedure StartStyle(style: DNPromptStyle);
    procedure EndStyle;
    procedure StartVoice(voice: DNVoiceInfo); overload;
    procedure StartVoice(name: string); overload;
    procedure StartVoice(gender: DNVoiceGender); overload;
    procedure StartVoice(gender: DNVoiceGender; age: DNVoiceAge); overload;
    procedure StartVoice(gender: DNVoiceGender; age: DNVoiceAge; voiceAlternate: Int32); overload;
    procedure StartVoice(culture: DDN.mscorlib.DNCultureInfo); overload;
    procedure EndVoice;
    procedure StartParagraph; overload;
    procedure StartParagraph(culture: DDN.mscorlib.DNCultureInfo); overload;
    procedure EndParagraph;
    procedure StartSentence; overload;
    procedure StartSentence(culture: DDN.mscorlib.DNCultureInfo); overload;
    procedure EndSentence;
    procedure AppendTextWithHint(textToSpeak: string; sayAs: DNSynthesis_SayAs); overload;
    procedure AppendTextWithHint(textToSpeak: string; sayAs: string); overload;
    procedure AppendTextWithPronunciation(textToSpeak: string; pronunciation: string);
    procedure AppendTextWithAlias(textToSpeak: string; substitute: string);
    procedure AppendBreak; overload;
    procedure AppendBreak(strength: DNPromptBreak); overload;
    procedure AppendBreak(duration: DDN.mscorlib.DNTimeSpan); overload;
    procedure AppendAudio(path: string); overload;
    procedure AppendAudio(audioFile: DDN.System.DNUri); overload;
    procedure AppendAudio(audioFile: DDN.System.DNUri; alternateText: string); overload;
    procedure AppendBookmark(bookmarkName: string);
    procedure AppendPromptBuilder(promptBuilder: DNPromptBuilder);
    procedure AppendSsml(path: string); overload;
    procedure AppendSsml(ssmlFile: DDN.System.DNUri); overload;
    procedure AppendSsml(ssmlFile: DDN.System.Xml.DNXmlReader); overload;
    procedure AppendSsmlMarkup(ssmlMarkup: string);
    function ToXml: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property IsEmpty: Boolean read get_IsEmpty;
    property Culture: DDN.mscorlib.DNCultureInfo read get_Culture write set_Culture;
  end;

  TDNPromptBuilder = class(TDNGenericImport<DNPromptBuilderClass, DNPromptBuilder>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNPromptStyleClass = interface(DDN.mscorlib.DNObjectClass)
  ['{3BFCAA7C-9D5C-5610-8D61-9F231CB6CE09}']
  { constructors } 

    {class} function init: DNPromptStyle; overload;
    {class} function init(rate: DNPromptRate): DNPromptStyle; overload;
    {class} function init(volume: DNPromptVolume): DNPromptStyle; overload;
    {class} function init(emphasis: DNPromptEmphasis): DNPromptStyle; overload;

  end;

  [DNTypeName('System.Speech.Synthesis.PromptStyle')]
  DNPromptStyle = interface(DDN.mscorlib.DNObject)
  ['{82EEF0A9-F45D-33AE-8CD7-9ECFE00AB1D3}']
  { getters & setters } 

    function get_Rate: DNPromptRate;
    procedure set_Rate(value: DNPromptRate);
    function get_Volume: DNPromptVolume;
    procedure set_Volume(value: DNPromptVolume);
    function get_Emphasis: DNPromptEmphasis;
    procedure set_Emphasis(value: DNPromptEmphasis);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Rate: DNPromptRate read get_Rate write set_Rate;
    property Volume: DNPromptVolume read get_Volume write set_Volume;
    property Emphasis: DNPromptEmphasis read get_Emphasis write set_Emphasis;
  end;

  TDNPromptStyle = class(TDNGenericImport<DNPromptStyleClass, DNPromptStyle>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNSpeechSynthesizerClass = interface(DNObjectClass)
  ['{CC4869AC-395C-522A-8ACF-6CBB54CC9E34}']
  { constructors } 

    {class} function init: DNSpeechSynthesizer;

  end;

  [DNTypeName('System.Speech.Synthesis.SpeechSynthesizer')]
  DNSpeechSynthesizer = interface(DDN.mscorlib.DNIDisposable)
  ['{A0D7143C-6953-369F-A166-70A7FF5C7915}']
  { getters & setters } 

    function get_State: DNSynthesizerState;
    function get_Rate: Int32;
    procedure set_Rate(value: Int32);
    function get_Volume: Int32;
    procedure set_Volume(value: Int32);
    function get_Voice: DNVoiceInfo;

  { events } 

    procedure add_SpeakStarted(value: DDN.mscorlib.DNEventHandler<DNSpeakStartedEventArgs>);
    procedure remove_SpeakStarted(value: DDN.mscorlib.DNEventHandler<DNSpeakStartedEventArgs>);
    procedure add_SpeakCompleted(value: DDN.mscorlib.DNEventHandler<DNSpeakCompletedEventArgs>);
    procedure remove_SpeakCompleted(value: DDN.mscorlib.DNEventHandler<DNSpeakCompletedEventArgs>);
    procedure add_SpeakProgress(value: DDN.mscorlib.DNEventHandler<DNSpeakProgressEventArgs>);
    procedure remove_SpeakProgress(value: DDN.mscorlib.DNEventHandler<DNSpeakProgressEventArgs>);
    procedure add_BookmarkReached(value: DDN.mscorlib.DNEventHandler<DNBookmarkReachedEventArgs>);
    procedure remove_BookmarkReached(value: DDN.mscorlib.DNEventHandler<DNBookmarkReachedEventArgs>);
    procedure add_VoiceChange(value: DDN.mscorlib.DNEventHandler<DNVoiceChangeEventArgs>);
    procedure remove_VoiceChange(value: DDN.mscorlib.DNEventHandler<DNVoiceChangeEventArgs>);
    procedure add_PhonemeReached(value: DDN.mscorlib.DNEventHandler<DNPhonemeReachedEventArgs>);
    procedure remove_PhonemeReached(value: DDN.mscorlib.DNEventHandler<DNPhonemeReachedEventArgs>);
    procedure add_VisemeReached(value: DDN.mscorlib.DNEventHandler<DNVisemeReachedEventArgs>);
    procedure remove_VisemeReached(value: DDN.mscorlib.DNEventHandler<DNVisemeReachedEventArgs>);
    procedure add_StateChanged(value: DDN.mscorlib.DNEventHandler<DNSynthesis_StateChangedEventArgs>);
    procedure remove_StateChanged(value: DDN.mscorlib.DNEventHandler<DNSynthesis_StateChangedEventArgs>);

  { methods } 

    procedure Dispose;
    procedure SelectVoice(name: string);
    procedure SelectVoiceByHints(gender: DNVoiceGender); overload;
    procedure SelectVoiceByHints(gender: DNVoiceGender; age: DNVoiceAge); overload;
    procedure SelectVoiceByHints(gender: DNVoiceGender; age: DNVoiceAge; voiceAlternate: Int32); overload;
    procedure SelectVoiceByHints(gender: DNVoiceGender; age: DNVoiceAge; voiceAlternate: Int32; culture: DDN.mscorlib.DNCultureInfo); overload;
    function SpeakAsync(textToSpeak: string): DNPrompt; overload;
    procedure SpeakAsync(prompt: DNPrompt); overload;
    function SpeakSsmlAsync(textToSpeak: string): DNPrompt;
    function SpeakAsync(promptBuilder: DNPromptBuilder): DNPrompt; overload;
    procedure Speak(textToSpeak: string); overload;
    procedure Speak(prompt: DNPrompt); overload;
    procedure Speak(promptBuilder: DNPromptBuilder); overload;
    procedure SpeakSsml(textToSpeak: string);
    procedure Pause;
    procedure Resume;
    procedure SpeakAsyncCancel(prompt: DNPrompt);
    procedure SpeakAsyncCancelAll;
    procedure SetOutputToWaveFile(path: string); overload;
    procedure SetOutputToWaveFile(path: string; formatInfo: DNSpeechAudioFormatInfo); overload;
    procedure SetOutputToWaveStream(audioDestination: DDN.mscorlib.DNStream);
    procedure SetOutputToAudioStream(audioDestination: DDN.mscorlib.DNStream; formatInfo: DNSpeechAudioFormatInfo);
    procedure SetOutputToDefaultAudioDevice;
    procedure SetOutputToNull;
    function GetCurrentlySpokenPrompt: DNPrompt;
    function GetInstalledVoices: DDN.mscorlib.DNReadOnlyCollection<DNInstalledVoice>; overload;
    function GetInstalledVoices(culture: DDN.mscorlib.DNCultureInfo): DDN.mscorlib.DNReadOnlyCollection<DNInstalledVoice>; overload;
    procedure AddLexicon(uri: DDN.System.DNUri; mediaType: string);
    procedure RemoveLexicon(uri: DDN.System.DNUri);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property State: DNSynthesizerState read get_State;
    property Rate: Int32 read get_Rate write set_Rate;
    property Volume: Int32 read get_Volume write set_Volume;
    property Voice: DNVoiceInfo read get_Voice;
  end;

  TDNSpeechSynthesizer = class(TDNGenericImport<DNSpeechSynthesizerClass, DNSpeechSynthesizer>) end;

  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  DNProsodyClass = interface(DDN.mscorlib.DNObjectClass)
  ['{7BADB5EB-8344-5B13-B70C-6C305E132508}']
  { constructors } 

    {class} function init: DNProsody;

  end;

  [DNTypeName('System.Speech.Synthesis.TtsEngine.Prosody')]
  DNProsody = interface(DDN.mscorlib.DNObject)
  ['{F5BD8D17-2919-3623-B6B7-353B53476851}']
  { getters & setters } 

    function get_Pitch: DNProsodyNumber;
    procedure set_Pitch(value: DNProsodyNumber);
    function get_Range: DNProsodyNumber;
    procedure set_Range(value: DNProsodyNumber);
    function get_Rate: DNProsodyNumber;
    procedure set_Rate(value: DNProsodyNumber);
    function get_Duration: Int32;
    procedure set_Duration(value: Int32);
    function get_Volume: DNProsodyNumber;
    procedure set_Volume(value: DNProsodyNumber);

  { methods } 

    function GetContourPoints: TArray<DNContourPoint>;
    procedure SetContourPoints(points: TArray<DNContourPoint>);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Pitch: DNProsodyNumber read get_Pitch write set_Pitch;
    property Range: DNProsodyNumber read get_Range write set_Range;
    property Rate: DNProsodyNumber read get_Rate write set_Rate;
    property Duration: Int32 read get_Duration write set_Duration;
    property Volume: DNProsodyNumber read get_Volume write set_Volume;
  end;

  TDNProsody = class(TDNGenericImport<DNProsodyClass, DNProsody>) end;

  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  DNTtsEngine_SayAsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{31EAE651-B28D-5E41-BF26-3385D6A5913B}']
  { constructors } 

    {class} function init: DNTtsEngine_SayAs;

  end;

  [DNTypeName('System.Speech.Synthesis.TtsEngine.SayAs')]
  DNTtsEngine_SayAs = interface(DDN.mscorlib.DNObject)
  ['{05D5E642-02F8-3B94-B19F-ABE4010A9DB8}']
  { getters & setters } 

    function get_InterpretAs: string;
    procedure set_InterpretAs(value: string);
    function get_Format: string;
    procedure set_Format(value: string);
    function get_Detail: string;
    procedure set_Detail(value: string);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InterpretAs: string read get_InterpretAs write set_InterpretAs;
    property Format: string read get_Format write set_Format;
    property Detail: string read get_Detail write set_Detail;
  end;

  TDNTtsEngine_SayAs = class(TDNGenericImport<DNTtsEngine_SayAsClass, DNTtsEngine_SayAs>) end;

  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  DNSkipInfoClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B4EF0087-4851-56AB-B6E1-24619905FE34}']
  { constructors } 

    {class} function init: DNSkipInfo;

  end;

  [DNTypeName('System.Speech.Synthesis.TtsEngine.SkipInfo')]
  DNSkipInfo = interface(DDN.mscorlib.DNObject)
  ['{253B5749-6BCF-36DB-B92F-4DCCC7251BEA}']
  { getters & setters } 

    function get_Type: Int32;
    procedure set_Type(value: Int32);
    function get_Count: Int32;
    procedure set_Count(value: Int32);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property &Type: Int32 read get_Type write set_Type;
    property Count: Int32 read get_Count write set_Count;
  end;

  TDNSkipInfo = class(TDNGenericImport<DNSkipInfoClass, DNSkipInfo>) end;

  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  DNTextFragmentClass = interface(DDN.mscorlib.DNObjectClass)
  ['{2F2C2E00-1248-5BEC-9417-0C437C017241}']
  { constructors } 

    {class} function init: DNTextFragment;

  end;

  [DNTypeName('System.Speech.Synthesis.TtsEngine.TextFragment')]
  DNTextFragment = interface(DDN.mscorlib.DNObject)
  ['{67C83D9B-9F83-3F00-94BD-EF6393074BDC}']
  { getters & setters } 

    function get_State: DNFragmentState;
    procedure set_State(value: DNFragmentState);
    function get_TextToSpeak: string;
    procedure set_TextToSpeak(value: string);
    function get_TextOffset: Int32;
    procedure set_TextOffset(value: Int32);
    function get_TextLength: Int32;
    procedure set_TextLength(value: Int32);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property State: DNFragmentState read get_State write set_State;
    property TextToSpeak: string read get_TextToSpeak write set_TextToSpeak;
    property TextOffset: Int32 read get_TextOffset write set_TextOffset;
    property TextLength: Int32 read get_TextLength write set_TextLength;
  end;

  TDNTextFragment = class(TDNGenericImport<DNTextFragmentClass, DNTextFragment>) end;

  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  DNTtsEngineSsmlClass = interface(DDN.mscorlib.DNObjectClass)
  ['{0348736C-08F5-541E-B5D0-512CA1A58B63}']
  end;

  [DNTypeName('System.Speech.Synthesis.TtsEngine.TtsEngineSsml')]
  DNTtsEngineSsml = interface(DDN.mscorlib.DNObject)
  ['{E015DDC1-44B9-3774-BF30-5752DC293D8C}']
  { methods } 

    function GetOutputFormat(speakOutputFormat: DNSpeakOutputFormat; targetWaveFormat: IntPtr): IntPtr;
    procedure AddLexicon(uri: DDN.System.DNUri; mediaType: string; site: DNITtsEngineSite);
    procedure RemoveLexicon(uri: DDN.System.DNUri; site: DNITtsEngineSite);
    procedure Speak(fragment: TArray<DNTextFragment>; waveHeader: IntPtr; site: DNITtsEngineSite);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNTtsEngineSsml = class(TDNGenericImport<DNTtsEngineSsmlClass, DNTtsEngineSsml>) end;

  //-------------namespace: System.Speech.Synthesis----------------
  DNVoiceInfoClass = interface(DDN.mscorlib.DNObjectClass)
  ['{5CF92CA8-086B-5882-8CB3-781297631A0B}']
  end;

  [DNTypeName('System.Speech.Synthesis.VoiceInfo')]
  DNVoiceInfo = interface(DDN.mscorlib.DNObject)
  ['{153277F1-BCCA-3B91-8913-A797FC2B46F9}']
  { getters & setters } 

    function get_Gender: DNVoiceGender;
    function get_Age: DNVoiceAge;
    function get_Name: string;
    function get_Culture: DDN.mscorlib.DNCultureInfo;
    function get_Id: string;
    function get_Description: string;
    function get_SupportedAudioFormats: DDN.mscorlib.DNReadOnlyCollection<DNSpeechAudioFormatInfo>;
    function get_AdditionalInfo: DDN.mscorlib.DNIDictionary<string, string>;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Gender: DNVoiceGender read get_Gender;
    property Age: DNVoiceAge read get_Age;
    property Name: string read get_Name;
    property Culture: DDN.mscorlib.DNCultureInfo read get_Culture;
    property Id: string read get_Id;
    property Description: string read get_Description;
    property SupportedAudioFormats: DDN.mscorlib.DNReadOnlyCollection<DNSpeechAudioFormatInfo> read get_SupportedAudioFormats;
    property AdditionalInfo: DDN.mscorlib.DNIDictionary<string, string> read get_AdditionalInfo;
  end;

  TDNVoiceInfo = class(TDNGenericImport<DNVoiceInfoClass, DNVoiceInfo>) end;

  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  DNContourPointClass = interface(DDN.mscorlib.DNValueTypeClass)
  ['{B0117B85-91D4-57CD-BA57-F80F5FCC302C}']
  { constructors } 

    {class} function init(start: Single; change: Single; changeType: DNContourPointChangeType): DNContourPoint;

  end;

  [DNTypeName('System.Speech.Synthesis.TtsEngine.ContourPoint')]
  DNContourPoint = interface(DDN.mscorlib.DNValueType)
  ['{AD472970-8BA0-3921-A1B7-4369B2B5F562}']
  { getters & setters } 

    function get_Start: Single;
    function get_Change: Single;
    function get_ChangeType: DNContourPointChangeType;

  { methods } 

    function Equals(other: DNContourPoint): Boolean; overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property Start: Single read get_Start;
    property Change: Single read get_Change;
    property ChangeType: DNContourPointChangeType read get_ChangeType;
  end;

  TDNContourPoint = class(TDNGenericImport<DNContourPointClass, DNContourPoint>) end;

  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  DNFragmentStateClass = interface(DDN.mscorlib.DNValueTypeClass)
  ['{90A32FE5-1715-5F08-8D7A-C8334FB344C4}']
  { constructors } 

    {class} function init(action: DNTtsEngineAction; langId: Int32; emphasis: Int32; duration: Int32; sayAs: DNTtsEngine_SayAs; prosody: DNProsody; phonemes: TArray<Char>): DNFragmentState;

  end;

  [DNTypeName('System.Speech.Synthesis.TtsEngine.FragmentState')]
  DNFragmentState = interface(DDN.mscorlib.DNValueType)
  ['{525997F7-8BBC-3461-B3AA-FCE6E92CF438}']
  { getters & setters } 

    function get_Action: DNTtsEngineAction;
    function get_LangId: Int32;
    function get_Emphasis: Int32;
    function get_Duration: Int32;
    function get_SayAs: DNTtsEngine_SayAs;
    function get_Prosody: DNProsody;
    function get_Phoneme: TArray<Char>;

  { methods } 

    function Equals(other: DNFragmentState): Boolean; overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property Action: DNTtsEngineAction read get_Action;
    property LangId: Int32 read get_LangId;
    property Emphasis: Int32 read get_Emphasis;
    property Duration: Int32 read get_Duration;
    property SayAs: DNTtsEngine_SayAs read get_SayAs;
    property Prosody: DNProsody read get_Prosody;
    property Phoneme: TArray<Char> read get_Phoneme;
  end;

  TDNFragmentState = class(TDNGenericImport<DNFragmentStateClass, DNFragmentState>) end;

  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  DNProsodyNumberClass = interface(DDN.mscorlib.DNValueTypeClass)
  ['{FAEDDE9D-64DE-5E80-8708-56AFA348CC66}']
  { constructors } 

    {class} function init(ssmlAttributeId: Int32): DNProsodyNumber; overload;
    {class} function init(number: Single): DNProsodyNumber; overload;

  end;

  [DNTypeName('System.Speech.Synthesis.TtsEngine.ProsodyNumber')]
  DNProsodyNumber = interface(DDN.mscorlib.DNValueType)
  ['{DEBA92EF-4492-3F4A-A0EF-3C601D47917A}']
  { getters & setters } 

    function get_SsmlAttributeId: Int32;
    function get_IsNumberPercent: Boolean;
    function get_Number: Single;
    function get_Unit: DNProsodyUnit;

  { methods } 

    function Equals(other: DNProsodyNumber): Boolean; overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property SsmlAttributeId: Int32 read get_SsmlAttributeId;
    property IsNumberPercent: Boolean read get_IsNumberPercent;
    property Number: Single read get_Number;
    property &Unit: DNProsodyUnit read get_Unit;
  end;

  TDNProsodyNumber = class(TDNGenericImport<DNProsodyNumberClass, DNProsodyNumber>)
  public const
   AbsoluteNumber = 2147483647;
  end;

  //-------------namespace: System.Speech.Synthesis.TtsEngine----------------
  DNSpeechEventInfoClass = interface(DDN.mscorlib.DNValueTypeClass)
  ['{AC6B0BA8-5677-555A-B0FE-2B40C496FBFA}']
  { constructors } 

    {class} function init(eventId: Int16; parameterType: Int16; param1: Int32; param2: IntPtr): DNSpeechEventInfo;

  end;

  [DNTypeName('System.Speech.Synthesis.TtsEngine.SpeechEventInfo')]
  DNSpeechEventInfo = interface(DDN.mscorlib.DNValueType)
  ['{C3F71718-AF0A-3281-945D-140DE4D66124}']
  { getters & setters } 

    function get_EventId: Int16;
    function get_ParameterType: Int16;
    function get_Param1: Int32;
    function get_Param2: IntPtr;

  { methods } 

    function Equals(other: DNSpeechEventInfo): Boolean; overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property EventId: Int16 read get_EventId;
    property ParameterType: Int16 read get_ParameterType;
    property Param1: Int32 read get_Param1;
    property Param2: IntPtr read get_Param2;
  end;

  TDNSpeechEventInfo = class(TDNGenericImport<DNSpeechEventInfoClass, DNSpeechEventInfo>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Speech, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35');

finalization

end.
