//----------------------------------------------------------------------------
//  System.Security.dll: System.Security, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Framework 4.x
//----------------------------------------------------------------------------
//  UnitName: DDN.System.Security
//  Author: ying32
//----------------------------------------------------------------------------

unit DDN.System.Security;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDN.mscorlib,
  DDN.System,
  DDN.System.Xml;

type

{ enums }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.DataProtectionScope')]
  DNDataProtectionScope = type Integer;
  DNDataProtectionScopeHelper = record helper for DNDataProtectionScope
  public const
    CurrentUser = 0;
    LocalMachine = 1;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.MemoryProtectionScope')]
  DNMemoryProtectionScope = type Integer;
  DNMemoryProtectionScopeHelper = record helper for DNMemoryProtectionScope
  public const
    SameProcess = 0;
    CrossProcess = 1;
    SameLogon = 2;
  end;


  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  [DNTypeName('System.Security.Cryptography.Pkcs.KeyAgreeKeyChoice')]
  DNKeyAgreeKeyChoice = type Integer;
  DNKeyAgreeKeyChoiceHelper = record helper for DNKeyAgreeKeyChoice
  public const
    Unknown = 0;
    EphemeralKey = 1;
    StaticKey = 2;
  end;


  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  [DNTypeName('System.Security.Cryptography.Pkcs.RecipientInfoType')]
  DNRecipientInfoType = type Integer;
  DNRecipientInfoTypeHelper = record helper for DNRecipientInfoType
  public const
    Unknown = 0;
    KeyTransport = 1;
    KeyAgreement = 2;
  end;


  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  [DNTypeName('System.Security.Cryptography.Pkcs.SubjectIdentifierOrKeyType')]
  DNSubjectIdentifierOrKeyType = type Integer;
  DNSubjectIdentifierOrKeyTypeHelper = record helper for DNSubjectIdentifierOrKeyType
  public const
    Unknown = 0;
    IssuerAndSerialNumber = 1;
    SubjectKeyIdentifier = 2;
    PublicKeyInfo = 3;
  end;


  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  [DNTypeName('System.Security.Cryptography.Pkcs.SubjectIdentifierType')]
  DNSubjectIdentifierType = type Integer;
  DNSubjectIdentifierTypeHelper = record helper for DNSubjectIdentifierType
  public const
    Unknown = 0;
    IssuerAndSerialNumber = 1;
    SubjectKeyIdentifier = 2;
    NoSignature = 3;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509SelectionFlag')]
  DNX509SelectionFlag = type Integer;
  DNX509SelectionFlagHelper = record helper for DNX509SelectionFlag
  public const
    SingleSelection = 0;
    MultiSelection = 1;
  end;


  //-------------namespace: System.Security.Permissions----------------
  [DNTypeName('System.Security.Permissions.DataProtectionPermissionFlags')]
  DNDataProtectionPermissionFlags = type Integer;
  DNDataProtectionPermissionFlagsHelper = record helper for DNDataProtectionPermissionFlags
  public const
    NoFlags = 0;
    ProtectData = 1;
    UnprotectData = 2;
    ProtectMemory = 4;
    UnprotectMemory = 8;
    AllFlags = 15;
  end;




type


{ declares }

  DNIRelDecryptor = interface; // type: System.Security.Cryptography.Xml.IRelDecryptor, namespace: System.Security.Cryptography.Xml
  DNDataProtectionPermissionAttribute = interface; // type: System.Security.Permissions.DataProtectionPermissionAttribute, namespace: System.Security.Permissions
  DNDataProtectionPermission = interface; // type: System.Security.Permissions.DataProtectionPermission, namespace: System.Security.Permissions
  DNPkcs9AttributeObject = interface; // type: System.Security.Cryptography.Pkcs.Pkcs9AttributeObject, namespace: System.Security.Cryptography.Pkcs
  DNPkcs9ContentType = interface; // type: System.Security.Cryptography.Pkcs.Pkcs9ContentType, namespace: System.Security.Cryptography.Pkcs
  DNPkcs9DocumentDescription = interface; // type: System.Security.Cryptography.Pkcs.Pkcs9DocumentDescription, namespace: System.Security.Cryptography.Pkcs
  DNPkcs9DocumentName = interface; // type: System.Security.Cryptography.Pkcs.Pkcs9DocumentName, namespace: System.Security.Cryptography.Pkcs
  DNPkcs9MessageDigest = interface; // type: System.Security.Cryptography.Pkcs.Pkcs9MessageDigest, namespace: System.Security.Cryptography.Pkcs
  DNPkcs9SigningTime = interface; // type: System.Security.Cryptography.Pkcs.Pkcs9SigningTime, namespace: System.Security.Cryptography.Pkcs
  DNCryptographicAttributeObject = interface; // type: System.Security.Cryptography.CryptographicAttributeObject, namespace: System.Security.Cryptography
  DNCryptographicAttributeObjectCollection = interface; // type: System.Security.Cryptography.CryptographicAttributeObjectCollection, namespace: System.Security.Cryptography
  DNCryptographicAttributeObjectEnumerator = interface; // type: System.Security.Cryptography.CryptographicAttributeObjectEnumerator, namespace: System.Security.Cryptography
  DNDataProtector = interface; // type: System.Security.Cryptography.DataProtector, namespace: System.Security.Cryptography
  DNDpapiDataProtector = interface; // type: System.Security.Cryptography.DpapiDataProtector, namespace: System.Security.Cryptography
  DNAlgorithmIdentifier = interface; // type: System.Security.Cryptography.Pkcs.AlgorithmIdentifier, namespace: System.Security.Cryptography.Pkcs
  DNCmsRecipient = interface; // type: System.Security.Cryptography.Pkcs.CmsRecipient, namespace: System.Security.Cryptography.Pkcs
  DNCmsRecipientCollection = interface; // type: System.Security.Cryptography.Pkcs.CmsRecipientCollection, namespace: System.Security.Cryptography.Pkcs
  DNCmsRecipientEnumerator = interface; // type: System.Security.Cryptography.Pkcs.CmsRecipientEnumerator, namespace: System.Security.Cryptography.Pkcs
  DNCmsSigner = interface; // type: System.Security.Cryptography.Pkcs.CmsSigner, namespace: System.Security.Cryptography.Pkcs
  DNContentInfo = interface; // type: System.Security.Cryptography.Pkcs.ContentInfo, namespace: System.Security.Cryptography.Pkcs
  DNEnvelopedCms = interface; // type: System.Security.Cryptography.Pkcs.EnvelopedCms, namespace: System.Security.Cryptography.Pkcs
  DNPublicKeyInfo = interface; // type: System.Security.Cryptography.Pkcs.PublicKeyInfo, namespace: System.Security.Cryptography.Pkcs
  DNRecipientInfo = interface; // type: System.Security.Cryptography.Pkcs.RecipientInfo, namespace: System.Security.Cryptography.Pkcs
  DNKeyAgreeRecipientInfo = interface; // type: System.Security.Cryptography.Pkcs.KeyAgreeRecipientInfo, namespace: System.Security.Cryptography.Pkcs
  DNKeyTransRecipientInfo = interface; // type: System.Security.Cryptography.Pkcs.KeyTransRecipientInfo, namespace: System.Security.Cryptography.Pkcs
  DNRecipientInfoCollection = interface; // type: System.Security.Cryptography.Pkcs.RecipientInfoCollection, namespace: System.Security.Cryptography.Pkcs
  DNRecipientInfoEnumerator = interface; // type: System.Security.Cryptography.Pkcs.RecipientInfoEnumerator, namespace: System.Security.Cryptography.Pkcs
  DNSignedCms = interface; // type: System.Security.Cryptography.Pkcs.SignedCms, namespace: System.Security.Cryptography.Pkcs
  DNSignerInfo = interface; // type: System.Security.Cryptography.Pkcs.SignerInfo, namespace: System.Security.Cryptography.Pkcs
  DNSignerInfoCollection = interface; // type: System.Security.Cryptography.Pkcs.SignerInfoCollection, namespace: System.Security.Cryptography.Pkcs
  DNSignerInfoEnumerator = interface; // type: System.Security.Cryptography.Pkcs.SignerInfoEnumerator, namespace: System.Security.Cryptography.Pkcs
  DNSubjectIdentifier = interface; // type: System.Security.Cryptography.Pkcs.SubjectIdentifier, namespace: System.Security.Cryptography.Pkcs
  DNSubjectIdentifierOrKey = interface; // type: System.Security.Cryptography.Pkcs.SubjectIdentifierOrKey, namespace: System.Security.Cryptography.Pkcs
  DNProtectedData = interface; // type: System.Security.Cryptography.ProtectedData, namespace: System.Security.Cryptography
  DNProtectedMemory = interface; // type: System.Security.Cryptography.ProtectedMemory, namespace: System.Security.Cryptography
  DNX509Certificate2UI = interface; // type: System.Security.Cryptography.X509Certificates.X509Certificate2UI, namespace: System.Security.Cryptography.X509Certificates
  DNCipherData = interface; // type: System.Security.Cryptography.Xml.CipherData, namespace: System.Security.Cryptography.Xml
  DNDataObject = interface; // type: System.Security.Cryptography.Xml.DataObject, namespace: System.Security.Cryptography.Xml
  DNEncryptedReference = interface; // type: System.Security.Cryptography.Xml.EncryptedReference, namespace: System.Security.Cryptography.Xml
  DNCipherReference = interface; // type: System.Security.Cryptography.Xml.CipherReference, namespace: System.Security.Cryptography.Xml
  DNDataReference = interface; // type: System.Security.Cryptography.Xml.DataReference, namespace: System.Security.Cryptography.Xml
  DNKeyReference = interface; // type: System.Security.Cryptography.Xml.KeyReference, namespace: System.Security.Cryptography.Xml
  DNEncryptedType = interface; // type: System.Security.Cryptography.Xml.EncryptedType, namespace: System.Security.Cryptography.Xml
  DNEncryptedData = interface; // type: System.Security.Cryptography.Xml.EncryptedData, namespace: System.Security.Cryptography.Xml
  DNEncryptedKey = interface; // type: System.Security.Cryptography.Xml.EncryptedKey, namespace: System.Security.Cryptography.Xml
  DNEncryptedXml = interface; // type: System.Security.Cryptography.Xml.EncryptedXml, namespace: System.Security.Cryptography.Xml
  DNEncryptionMethod = interface; // type: System.Security.Cryptography.Xml.EncryptionMethod, namespace: System.Security.Cryptography.Xml
  DNEncryptionProperty = interface; // type: System.Security.Cryptography.Xml.EncryptionProperty, namespace: System.Security.Cryptography.Xml
  DNEncryptionPropertyCollection = interface; // type: System.Security.Cryptography.Xml.EncryptionPropertyCollection, namespace: System.Security.Cryptography.Xml
  DNKeyInfo = interface; // type: System.Security.Cryptography.Xml.KeyInfo, namespace: System.Security.Cryptography.Xml
  DNKeyInfoClause = interface; // type: System.Security.Cryptography.Xml.KeyInfoClause, namespace: System.Security.Cryptography.Xml
  DNDSAKeyValue = interface; // type: System.Security.Cryptography.Xml.DSAKeyValue, namespace: System.Security.Cryptography.Xml
  DNKeyInfoEncryptedKey = interface; // type: System.Security.Cryptography.Xml.KeyInfoEncryptedKey, namespace: System.Security.Cryptography.Xml
  DNKeyInfoName = interface; // type: System.Security.Cryptography.Xml.KeyInfoName, namespace: System.Security.Cryptography.Xml
  DNKeyInfoNode = interface; // type: System.Security.Cryptography.Xml.KeyInfoNode, namespace: System.Security.Cryptography.Xml
  DNKeyInfoRetrievalMethod = interface; // type: System.Security.Cryptography.Xml.KeyInfoRetrievalMethod, namespace: System.Security.Cryptography.Xml
  DNKeyInfoX509Data = interface; // type: System.Security.Cryptography.Xml.KeyInfoX509Data, namespace: System.Security.Cryptography.Xml
  DNRSAKeyValue = interface; // type: System.Security.Cryptography.Xml.RSAKeyValue, namespace: System.Security.Cryptography.Xml
  DNReference = interface; // type: System.Security.Cryptography.Xml.Reference, namespace: System.Security.Cryptography.Xml
  DNReferenceList = interface; // type: System.Security.Cryptography.Xml.ReferenceList, namespace: System.Security.Cryptography.Xml
  DNSignature = interface; // type: System.Security.Cryptography.Xml.Signature, namespace: System.Security.Cryptography.Xml
  DNSignedInfo = interface; // type: System.Security.Cryptography.Xml.SignedInfo, namespace: System.Security.Cryptography.Xml
  DNSignedXml = interface; // type: System.Security.Cryptography.Xml.SignedXml, namespace: System.Security.Cryptography.Xml
  DNTransform = interface; // type: System.Security.Cryptography.Xml.Transform, namespace: System.Security.Cryptography.Xml
  DNXmlDecryptionTransform = interface; // type: System.Security.Cryptography.Xml.XmlDecryptionTransform, namespace: System.Security.Cryptography.Xml
  DNXmlDsigBase64Transform = interface; // type: System.Security.Cryptography.Xml.XmlDsigBase64Transform, namespace: System.Security.Cryptography.Xml
  DNXmlDsigC14NTransform = interface; // type: System.Security.Cryptography.Xml.XmlDsigC14NTransform, namespace: System.Security.Cryptography.Xml
  DNXmlDsigC14NWithCommentsTransform = interface; // type: System.Security.Cryptography.Xml.XmlDsigC14NWithCommentsTransform, namespace: System.Security.Cryptography.Xml
  DNXmlDsigEnvelopedSignatureTransform = interface; // type: System.Security.Cryptography.Xml.XmlDsigEnvelopedSignatureTransform, namespace: System.Security.Cryptography.Xml
  DNXmlDsigExcC14NTransform = interface; // type: System.Security.Cryptography.Xml.XmlDsigExcC14NTransform, namespace: System.Security.Cryptography.Xml
  DNXmlDsigExcC14NWithCommentsTransform = interface; // type: System.Security.Cryptography.Xml.XmlDsigExcC14NWithCommentsTransform, namespace: System.Security.Cryptography.Xml
  DNXmlDsigXPathTransform = interface; // type: System.Security.Cryptography.Xml.XmlDsigXPathTransform, namespace: System.Security.Cryptography.Xml
  DNXmlDsigXsltTransform = interface; // type: System.Security.Cryptography.Xml.XmlDsigXsltTransform, namespace: System.Security.Cryptography.Xml
  DNXmlLicenseTransform = interface; // type: System.Security.Cryptography.Xml.XmlLicenseTransform, namespace: System.Security.Cryptography.Xml
  DNTransformChain = interface; // type: System.Security.Cryptography.Xml.TransformChain, namespace: System.Security.Cryptography.Xml
  DNX509IssuerSerial = interface; // type: System.Security.Cryptography.Xml.X509IssuerSerial, namespace: System.Security.Cryptography.Xml


{ objects }

  //-------------namespace: System.Security.Cryptography.Xml----------------
  [DNTypeName('System.Security.Cryptography.Xml.IRelDecryptor')]
  DNIRelDecryptor = interface(DDN.mscorlib.DNObject)
  ['{D926D95B-A15C-3D27-B950-06C8AD0704E8}']
  { methods } 

    function Decrypt(encryptionMethod: DNEncryptionMethod; keyInfo: DNKeyInfo; toDecrypt: DDN.mscorlib.DNStream): DDN.mscorlib.DNStream;

  end;

  //-------------namespace: System.Security.Permissions----------------
  DNDataProtectionPermissionAttributeClass = interface(DDN.mscorlib.DNCodeAccessSecurityAttributeClass)
  ['{94B548FD-48A9-5B1F-B320-3AA0FF93E607}']
  { constructors } 

    {class} function init(action: DDN.mscorlib.DNSecurityAction): DNDataProtectionPermissionAttribute;

  end;

  [DNTypeName('System.Security.Permissions.DataProtectionPermissionAttribute')]
  DNDataProtectionPermissionAttribute = interface(DDN.mscorlib.DNCodeAccessSecurityAttribute)
  ['{C3F8F9D4-6BD9-3E21-9DE3-5FFC1EEED4E7}']
  { getters & setters } 

    function get_Flags: DNDataProtectionPermissionFlags;
    procedure set_Flags(value: DNDataProtectionPermissionFlags);
    function get_ProtectData: Boolean;
    procedure set_ProtectData(value: Boolean);
    function get_UnprotectData: Boolean;
    procedure set_UnprotectData(value: Boolean);
    function get_ProtectMemory: Boolean;
    procedure set_ProtectMemory(value: Boolean);
    function get_UnprotectMemory: Boolean;
    procedure set_UnprotectMemory(value: Boolean);
    function get_Action: DDN.mscorlib.DNSecurityAction;
    procedure set_Action(value: DDN.mscorlib.DNSecurityAction);
    function get_Unrestricted: Boolean;
    procedure set_Unrestricted(value: Boolean);
    function get_TypeId: DDN.mscorlib.DNObject;

  { methods } 

    function CreatePermission: DDN.mscorlib.DNIPermission;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function Match(obj: DDN.mscorlib.DNObject): Boolean;
    function IsDefaultAttribute: Boolean;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Flags: DNDataProtectionPermissionFlags read get_Flags write set_Flags;
    property ProtectData: Boolean read get_ProtectData write set_ProtectData;
    property UnprotectData: Boolean read get_UnprotectData write set_UnprotectData;
    property ProtectMemory: Boolean read get_ProtectMemory write set_ProtectMemory;
    property UnprotectMemory: Boolean read get_UnprotectMemory write set_UnprotectMemory;
    property Action: DDN.mscorlib.DNSecurityAction read get_Action write set_Action;
    property Unrestricted: Boolean read get_Unrestricted write set_Unrestricted;
    property TypeId: DDN.mscorlib.DNObject read get_TypeId;
  end;

  TDNDataProtectionPermissionAttribute = class(TDNGenericImport<DNDataProtectionPermissionAttributeClass, DNDataProtectionPermissionAttribute>) end;

  //-------------namespace: System.Security.Permissions----------------
  DNDataProtectionPermissionClass = interface(DDN.mscorlib.DNCodeAccessPermissionClass)
  ['{493E9BBE-FAE1-59A5-87BC-80902F22AAA6}']
  { constructors } 

    {class} function init(state: DDN.mscorlib.DNPermissionState): DNDataProtectionPermission; overload;
    {class} function init(flag: DNDataProtectionPermissionFlags): DNDataProtectionPermission; overload;

  end;

  [DNTypeName('System.Security.Permissions.DataProtectionPermission')]
  DNDataProtectionPermission = interface(DDN.mscorlib.DNCodeAccessPermission)
  ['{C23B46EB-77BE-3C65-8C6A-D26E9C89293A}']
  { getters & setters } 

    function get_Flags: DNDataProtectionPermissionFlags;
    procedure set_Flags(value: DNDataProtectionPermissionFlags);

  { methods } 

    function IsUnrestricted: Boolean;
    function Copy: DDN.mscorlib.DNIPermission;
    function Union(target: DDN.mscorlib.DNIPermission): DDN.mscorlib.DNIPermission;
    function IsSubsetOf(target: DDN.mscorlib.DNIPermission): Boolean;
    function Intersect(target: DDN.mscorlib.DNIPermission): DDN.mscorlib.DNIPermission;
    function ToXml: DDN.mscorlib.DNSecurityElement;
    procedure FromXml(securityElement: DDN.mscorlib.DNSecurityElement);
    procedure Demand;
    procedure Assert;
    procedure Deny;
    procedure PermitOnly;
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property Flags: DNDataProtectionPermissionFlags read get_Flags write set_Flags;
  end;

  TDNDataProtectionPermission = class(TDNGenericImport<DNDataProtectionPermissionClass, DNDataProtectionPermission>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNPkcs9AttributeObjectClass = interface(DNObjectClass)
  ['{D82DC25D-F64E-5C81-A166-6DE18D742940}']
  { constructors } 

    {class} function init: DNPkcs9AttributeObject; overload;
    {class} function init(oid: string; encodedData: TArray<Byte>): DNPkcs9AttributeObject; overload;
    {class} function init(oid: DDN.System.DNOid; encodedData: TArray<Byte>): DNPkcs9AttributeObject; overload;
    {class} function init(asnEncodedData: DDN.System.DNAsnEncodedData): DNPkcs9AttributeObject; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.Pkcs9AttributeObject')]
  DNPkcs9AttributeObject = interface(DNObject)
  ['{3B4D1CD6-2C4F-3734-B72B-A7040AC3ACA6}']
  { getters & setters } 

    function get_Oid: DDN.System.DNOid;
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDN.System.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Oid: DDN.System.DNOid read get_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNPkcs9AttributeObject = class(TDNGenericImport<DNPkcs9AttributeObjectClass, DNPkcs9AttributeObject>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNPkcs9ContentTypeClass = interface(DNPkcs9AttributeObjectClass)
  ['{1D7C7031-0534-5F63-A041-B5B7D3BF6F8D}']
  { constructors } 

    {class} function init: DNPkcs9ContentType;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.Pkcs9ContentType')]
  DNPkcs9ContentType = interface(DNPkcs9AttributeObject)
  ['{88BB2A53-22A7-30AC-8D96-0825EC051A70}']
  { getters & setters } 

    function get_ContentType: DDN.System.DNOid;
    function get_Oid: DDN.System.DNOid;
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDN.System.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property ContentType: DDN.System.DNOid read get_ContentType;
    property Oid: DDN.System.DNOid read get_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNPkcs9ContentType = class(TDNGenericImport<DNPkcs9ContentTypeClass, DNPkcs9ContentType>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNPkcs9DocumentDescriptionClass = interface(DNPkcs9AttributeObjectClass)
  ['{5A9E0FEA-8CCE-58B8-9932-31D1C839C2B1}']
  { constructors } 

    {class} function init: DNPkcs9DocumentDescription; overload;
    {class} function init(documentDescription: string): DNPkcs9DocumentDescription; overload;
    {class} function init(encodedDocumentDescription: TArray<Byte>): DNPkcs9DocumentDescription; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.Pkcs9DocumentDescription')]
  DNPkcs9DocumentDescription = interface(DNPkcs9AttributeObject)
  ['{41EC3031-FC11-32A4-A3B0-5386D6EF865B}']
  { getters & setters } 

    function get_DocumentDescription: string;
    function get_Oid: DDN.System.DNOid;
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDN.System.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property DocumentDescription: string read get_DocumentDescription;
    property Oid: DDN.System.DNOid read get_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNPkcs9DocumentDescription = class(TDNGenericImport<DNPkcs9DocumentDescriptionClass, DNPkcs9DocumentDescription>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNPkcs9DocumentNameClass = interface(DNPkcs9AttributeObjectClass)
  ['{7EA2C31F-C1A5-5944-BC78-1C495121CD09}']
  { constructors } 

    {class} function init: DNPkcs9DocumentName; overload;
    {class} function init(documentName: string): DNPkcs9DocumentName; overload;
    {class} function init(encodedDocumentName: TArray<Byte>): DNPkcs9DocumentName; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.Pkcs9DocumentName')]
  DNPkcs9DocumentName = interface(DNPkcs9AttributeObject)
  ['{A849A423-AEAD-394F-8943-EE5921FA53CA}']
  { getters & setters } 

    function get_DocumentName: string;
    function get_Oid: DDN.System.DNOid;
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDN.System.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property DocumentName: string read get_DocumentName;
    property Oid: DDN.System.DNOid read get_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNPkcs9DocumentName = class(TDNGenericImport<DNPkcs9DocumentNameClass, DNPkcs9DocumentName>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNPkcs9MessageDigestClass = interface(DNPkcs9AttributeObjectClass)
  ['{FB93868B-A2A3-512F-AECD-4E4E7FF769D2}']
  { constructors } 

    {class} function init: DNPkcs9MessageDigest;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.Pkcs9MessageDigest')]
  DNPkcs9MessageDigest = interface(DNPkcs9AttributeObject)
  ['{23D9775B-BDEF-324F-98E0-DF0DAD9F1B52}']
  { getters & setters } 

    function get_MessageDigest: TArray<Byte>;
    function get_Oid: DDN.System.DNOid;
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDN.System.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property MessageDigest: TArray<Byte> read get_MessageDigest;
    property Oid: DDN.System.DNOid read get_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNPkcs9MessageDigest = class(TDNGenericImport<DNPkcs9MessageDigestClass, DNPkcs9MessageDigest>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNPkcs9SigningTimeClass = interface(DNPkcs9AttributeObjectClass)
  ['{821FA1D1-8E9A-5218-8B72-B1BD375944BF}']
  { constructors } 

    {class} function init: DNPkcs9SigningTime; overload;
    {class} function init(signingTime: DDN.mscorlib.DNDateTime): DNPkcs9SigningTime; overload;
    {class} function init(encodedSigningTime: TArray<Byte>): DNPkcs9SigningTime; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.Pkcs9SigningTime')]
  DNPkcs9SigningTime = interface(DNPkcs9AttributeObject)
  ['{93BF70DC-BEA3-34FE-B172-EC1C0AB7E329}']
  { getters & setters } 

    function get_SigningTime: DDN.mscorlib.DNDateTime;
    function get_Oid: DDN.System.DNOid;
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDN.System.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property SigningTime: DDN.mscorlib.DNDateTime read get_SigningTime;
    property Oid: DDN.System.DNOid read get_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNPkcs9SigningTime = class(TDNGenericImport<DNPkcs9SigningTimeClass, DNPkcs9SigningTime>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCryptographicAttributeObjectClass = interface(DDN.mscorlib.DNObjectClass)
  ['{BB73E783-E254-5B33-8599-F33388CFE7F1}']
  { constructors } 

    {class} function init(oid: DDN.System.DNOid): DNCryptographicAttributeObject; overload;
    {class} function init(oid: DDN.System.DNOid; values: DDN.System.DNAsnEncodedDataCollection): DNCryptographicAttributeObject; overload;

  end;

  [DNTypeName('System.Security.Cryptography.CryptographicAttributeObject')]
  DNCryptographicAttributeObject = interface(DDN.mscorlib.DNObject)
  ['{A457D173-FAFD-3DD9-A3BF-4C426D26F47C}']
  { getters & setters } 

    function get_Oid: DDN.System.DNOid;
    function get_Values: DDN.System.DNAsnEncodedDataCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Oid: DDN.System.DNOid read get_Oid;
    property Values: DDN.System.DNAsnEncodedDataCollection read get_Values;
  end;

  TDNCryptographicAttributeObject = class(TDNGenericImport<DNCryptographicAttributeObjectClass, DNCryptographicAttributeObject>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCryptographicAttributeObjectCollectionClass = interface(DNObjectClass)
  ['{991B9107-366A-5CB7-936F-DC56974714E5}']
  { constructors } 

    {class} function init: DNCryptographicAttributeObjectCollection; overload;
    {class} function init(attribute: DNCryptographicAttributeObject): DNCryptographicAttributeObjectCollection; overload;

  end;

  [DNTypeName('System.Security.Cryptography.CryptographicAttributeObjectCollection')]
  DNCryptographicAttributeObjectCollection = interface(DDN.mscorlib.DNICollection)
  ['{0F16A88D-79CE-358C-8E75-49DA19E8D66D}']
  { getters & setters } 

    function get_Item(index: Int32): DNCryptographicAttributeObject;
    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDN.mscorlib.DNObject;

  { methods } 

    function Add(asnEncodedData: DDN.System.DNAsnEncodedData): Int32; overload;
    procedure Remove(attribute: DNCryptographicAttributeObject);
    function GetEnumerator: DNCryptographicAttributeObjectEnumerator;
    procedure CopyTo(&array: TArray<DNCryptographicAttributeObject>; index: Int32);
    function Add(attribute: DNCryptographicAttributeObject): Int32; overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNCryptographicAttributeObject read get_Item; default;
    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
  end;

  TDNCryptographicAttributeObjectCollection = class(TDNGenericImport<DNCryptographicAttributeObjectCollectionClass, DNCryptographicAttributeObjectCollection>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCryptographicAttributeObjectEnumeratorClass = interface(DNObjectClass)
  ['{D726A622-7D65-5E6B-9147-6AB036EF2B6D}']
  end;

  [DNTypeName('System.Security.Cryptography.CryptographicAttributeObjectEnumerator')]
  DNCryptographicAttributeObjectEnumerator = interface(DDN.mscorlib.DNIEnumerator)
  ['{B1B5B4C5-2D8A-3B62-8375-67BA6ACF2BEF}']
  { getters & setters } 

    function get_Current: DNCryptographicAttributeObject;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Current: DNCryptographicAttributeObject read get_Current;
  end;

  TDNCryptographicAttributeObjectEnumerator = class(TDNGenericImport<DNCryptographicAttributeObjectEnumeratorClass, DNCryptographicAttributeObjectEnumerator>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDataProtectorClass = interface(DDN.mscorlib.DNObjectClass)
  ['{EAF46267-1BC9-5663-8442-B38EEB6CFB28}']
  { static methods } 

    {class} function Create(providerClass: string; applicationName: string; primaryPurpose: string; specificPurposes: TArray<string>): DNDataProtector;

  end;

  [DNTypeName('System.Security.Cryptography.DataProtector')]
  DNDataProtector = interface(DDN.mscorlib.DNObject)
  ['{16770A15-E376-3D7F-9349-89DED00E785F}']
  { methods } 

    function IsReprotectRequired(encryptedData: TArray<Byte>): Boolean;
    function Protect(userData: TArray<Byte>): TArray<Byte>;
    function Unprotect(encryptedData: TArray<Byte>): TArray<Byte>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNDataProtector = class(TDNGenericImport<DNDataProtectorClass, DNDataProtector>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDpapiDataProtectorClass = interface(DNDataProtectorClass)
  ['{6E018184-F4FC-55EF-A0AD-DA1E3FC6DAEC}']
  { constructors } 

    {class} function init(appName: string; primaryPurpose: string; specificPurpose: TArray<string>): DNDpapiDataProtector;

  end;

  [DNTypeName('System.Security.Cryptography.DpapiDataProtector')]
  DNDpapiDataProtector = interface(DNDataProtector)
  ['{BD338ADB-1FD8-3A15-B197-07944BA04681}']
  { getters & setters } 

    function get_Scope: DNDataProtectionScope;
    procedure set_Scope(value: DNDataProtectionScope);

  { methods } 

    function IsReprotectRequired(encryptedData: TArray<Byte>): Boolean;
    function Protect(userData: TArray<Byte>): TArray<Byte>;
    function Unprotect(encryptedData: TArray<Byte>): TArray<Byte>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Scope: DNDataProtectionScope read get_Scope write set_Scope;
  end;

  TDNDpapiDataProtector = class(TDNGenericImport<DNDpapiDataProtectorClass, DNDpapiDataProtector>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNAlgorithmIdentifierClass = interface(DDN.mscorlib.DNObjectClass)
  ['{08E51796-3F9A-5A5F-AC5F-5B441A7B4510}']
  { constructors } 

    {class} function init: DNAlgorithmIdentifier; overload;
    {class} function init(oid: DDN.System.DNOid): DNAlgorithmIdentifier; overload;
    {class} function init(oid: DDN.System.DNOid; keyLength: Int32): DNAlgorithmIdentifier; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.AlgorithmIdentifier')]
  DNAlgorithmIdentifier = interface(DDN.mscorlib.DNObject)
  ['{016350BD-4169-3D6C-A04E-69FB925ED24E}']
  { getters & setters } 

    function get_Oid: DDN.System.DNOid;
    procedure set_Oid(value: DDN.System.DNOid);
    function get_KeyLength: Int32;
    procedure set_KeyLength(value: Int32);
    function get_Parameters: TArray<Byte>;
    procedure set_Parameters(value: TArray<Byte>);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Oid: DDN.System.DNOid read get_Oid write set_Oid;
    property KeyLength: Int32 read get_KeyLength write set_KeyLength;
    property Parameters: TArray<Byte> read get_Parameters write set_Parameters;
  end;

  TDNAlgorithmIdentifier = class(TDNGenericImport<DNAlgorithmIdentifierClass, DNAlgorithmIdentifier>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNCmsRecipientClass = interface(DDN.mscorlib.DNObjectClass)
  ['{928A6CD5-B65B-5B0A-90D8-7EE66B3884DB}']
  { constructors } 

    {class} function init(certificate: DDN.System.DNX509Certificate2): DNCmsRecipient; overload;
    {class} function init(recipientIdentifierType: DNSubjectIdentifierType; certificate: DDN.System.DNX509Certificate2): DNCmsRecipient; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.CmsRecipient')]
  DNCmsRecipient = interface(DDN.mscorlib.DNObject)
  ['{E01D5A8E-8F22-3906-BEB7-B00506257CD5}']
  { getters & setters } 

    function get_RecipientIdentifierType: DNSubjectIdentifierType;
    function get_Certificate: DDN.System.DNX509Certificate2;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property RecipientIdentifierType: DNSubjectIdentifierType read get_RecipientIdentifierType;
    property Certificate: DDN.System.DNX509Certificate2 read get_Certificate;
  end;

  TDNCmsRecipient = class(TDNGenericImport<DNCmsRecipientClass, DNCmsRecipient>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNCmsRecipientCollectionClass = interface(DNObjectClass)
  ['{86C8DE48-D692-5031-A650-A1C9350E3CA1}']
  { constructors } 

    {class} function init: DNCmsRecipientCollection; overload;
    {class} function init(recipient: DNCmsRecipient): DNCmsRecipientCollection; overload;
    {class} function init(recipientIdentifierType: DNSubjectIdentifierType; certificates: DDN.System.DNX509Certificate2Collection): DNCmsRecipientCollection; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.CmsRecipientCollection')]
  DNCmsRecipientCollection = interface(DDN.mscorlib.DNICollection)
  ['{BADE85E0-B862-337A-B8B5-16A9CAB6EAF4}']
  { getters & setters } 

    function get_Item(index: Int32): DNCmsRecipient;
    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDN.mscorlib.DNObject;

  { methods } 

    function Add(recipient: DNCmsRecipient): Int32;
    procedure Remove(recipient: DNCmsRecipient);
    function GetEnumerator: DNCmsRecipientEnumerator;
    procedure CopyTo(&array: DDN.mscorlib.DNArray; index: Int32); overload;
    procedure CopyTo(&array: TArray<DNCmsRecipient>; index: Int32); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNCmsRecipient read get_Item; default;
    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
  end;

  TDNCmsRecipientCollection = class(TDNGenericImport<DNCmsRecipientCollectionClass, DNCmsRecipientCollection>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNCmsRecipientEnumeratorClass = interface(DNObjectClass)
  ['{EB3FCD61-34AC-5BDA-BD11-7340B8693EAF}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.CmsRecipientEnumerator')]
  DNCmsRecipientEnumerator = interface(DDN.mscorlib.DNIEnumerator)
  ['{95F00E89-B43C-3A8E-8C8F-FF723400A54F}']
  { getters & setters } 

    function get_Current: DNCmsRecipient;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Current: DNCmsRecipient read get_Current;
  end;

  TDNCmsRecipientEnumerator = class(TDNGenericImport<DNCmsRecipientEnumeratorClass, DNCmsRecipientEnumerator>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNCmsSignerClass = interface(DDN.mscorlib.DNObjectClass)
  ['{34AEDDF9-D571-5669-9FE9-109D251A3B7E}']
  { constructors } 

    {class} function init: DNCmsSigner; overload;
    {class} function init(signerIdentifierType: DNSubjectIdentifierType): DNCmsSigner; overload;
    {class} function init(certificate: DDN.System.DNX509Certificate2): DNCmsSigner; overload;
    {class} function init(parameters: DDN.mscorlib.DNCspParameters): DNCmsSigner; overload;
    {class} function init(signerIdentifierType: DNSubjectIdentifierType; certificate: DDN.System.DNX509Certificate2): DNCmsSigner; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.CmsSigner')]
  DNCmsSigner = interface(DDN.mscorlib.DNObject)
  ['{F9F6FB69-AFB1-338E-BA7B-A2296F6A4362}']
  { getters & setters } 

    function get_SignerIdentifierType: DNSubjectIdentifierType;
    procedure set_SignerIdentifierType(value: DNSubjectIdentifierType);
    function get_Certificate: DDN.System.DNX509Certificate2;
    procedure set_Certificate(value: DDN.System.DNX509Certificate2);
    function get_DigestAlgorithm: DDN.System.DNOid;
    procedure set_DigestAlgorithm(value: DDN.System.DNOid);
    function get_SignedAttributes: DNCryptographicAttributeObjectCollection;
    function get_UnsignedAttributes: DNCryptographicAttributeObjectCollection;
    function get_Certificates: DDN.System.DNX509Certificate2Collection;
    function get_IncludeOption: DDN.System.DNX509IncludeOption;
    procedure set_IncludeOption(value: DDN.System.DNX509IncludeOption);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property SignerIdentifierType: DNSubjectIdentifierType read get_SignerIdentifierType write set_SignerIdentifierType;
    property Certificate: DDN.System.DNX509Certificate2 read get_Certificate write set_Certificate;
    property DigestAlgorithm: DDN.System.DNOid read get_DigestAlgorithm write set_DigestAlgorithm;
    property SignedAttributes: DNCryptographicAttributeObjectCollection read get_SignedAttributes;
    property UnsignedAttributes: DNCryptographicAttributeObjectCollection read get_UnsignedAttributes;
    property Certificates: DDN.System.DNX509Certificate2Collection read get_Certificates;
    property IncludeOption: DDN.System.DNX509IncludeOption read get_IncludeOption write set_IncludeOption;
  end;

  TDNCmsSigner = class(TDNGenericImport<DNCmsSignerClass, DNCmsSigner>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNContentInfoClass = interface(DDN.mscorlib.DNObjectClass)
  ['{18FE1DA7-FCBE-5132-911C-2DDDF9F3EA86}']
  { constructors } 

    {class} function init(content: TArray<Byte>): DNContentInfo; overload;
    {class} function init(contentType: DDN.System.DNOid; content: TArray<Byte>): DNContentInfo; overload;

  { static methods } 

    {class} function GetContentType(encodedMessage: TArray<Byte>): DDN.System.DNOid;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.ContentInfo')]
  DNContentInfo = interface(DDN.mscorlib.DNObject)
  ['{50A08F43-D731-3583-B830-1F81460F6816}']
  { getters & setters } 

    function get_ContentType: DDN.System.DNOid;
    function get_Content: TArray<Byte>;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property ContentType: DDN.System.DNOid read get_ContentType;
    property Content: TArray<Byte> read get_Content;
  end;

  TDNContentInfo = class(TDNGenericImport<DNContentInfoClass, DNContentInfo>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNEnvelopedCmsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{98E07E6F-93FE-5533-A1EE-38A886389CDC}']
  { constructors } 

    {class} function init: DNEnvelopedCms; overload;
    {class} function init(contentInfo: DNContentInfo): DNEnvelopedCms; overload;
    {class} function init(recipientIdentifierType: DNSubjectIdentifierType; contentInfo: DNContentInfo): DNEnvelopedCms; overload;
    {class} function init(contentInfo: DNContentInfo; encryptionAlgorithm: DNAlgorithmIdentifier): DNEnvelopedCms; overload;
    {class} function init(recipientIdentifierType: DNSubjectIdentifierType; contentInfo: DNContentInfo; encryptionAlgorithm: DNAlgorithmIdentifier): DNEnvelopedCms; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.EnvelopedCms')]
  DNEnvelopedCms = interface(DDN.mscorlib.DNObject)
  ['{422E92AA-9BA8-33F6-BEBE-CC85A080135E}']
  { getters & setters } 

    function get_Version: Int32;
    function get_ContentInfo: DNContentInfo;
    function get_ContentEncryptionAlgorithm: DNAlgorithmIdentifier;
    function get_Certificates: DDN.System.DNX509Certificate2Collection;
    function get_UnprotectedAttributes: DNCryptographicAttributeObjectCollection;
    function get_RecipientInfos: DNRecipientInfoCollection;

  { methods } 

    function Encode: TArray<Byte>;
    procedure Decode(encodedMessage: TArray<Byte>);
    procedure Encrypt; overload;
    procedure Encrypt(recipient: DNCmsRecipient); overload;
    procedure Encrypt(recipients: DNCmsRecipientCollection); overload;
    procedure Decrypt; overload;
    procedure Decrypt(recipientInfo: DNRecipientInfo); overload;
    procedure Decrypt(extraStore: DDN.System.DNX509Certificate2Collection); overload;
    procedure Decrypt(recipientInfo: DNRecipientInfo; extraStore: DDN.System.DNX509Certificate2Collection); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Version: Int32 read get_Version;
    property ContentInfo: DNContentInfo read get_ContentInfo;
    property ContentEncryptionAlgorithm: DNAlgorithmIdentifier read get_ContentEncryptionAlgorithm;
    property Certificates: DDN.System.DNX509Certificate2Collection read get_Certificates;
    property UnprotectedAttributes: DNCryptographicAttributeObjectCollection read get_UnprotectedAttributes;
    property RecipientInfos: DNRecipientInfoCollection read get_RecipientInfos;
  end;

  TDNEnvelopedCms = class(TDNGenericImport<DNEnvelopedCmsClass, DNEnvelopedCms>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNPublicKeyInfoClass = interface(DDN.mscorlib.DNObjectClass)
  ['{23D17C0B-F87C-532F-BEC0-6964FD2B2B38}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.PublicKeyInfo')]
  DNPublicKeyInfo = interface(DDN.mscorlib.DNObject)
  ['{BE6D1D7F-0C06-32C8-953F-5C5845D2E43A}']
  { getters & setters } 

    function get_Algorithm: DNAlgorithmIdentifier;
    function get_KeyValue: TArray<Byte>;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Algorithm: DNAlgorithmIdentifier read get_Algorithm;
    property KeyValue: TArray<Byte> read get_KeyValue;
  end;

  TDNPublicKeyInfo = class(TDNGenericImport<DNPublicKeyInfoClass, DNPublicKeyInfo>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNRecipientInfoClass = interface(DDN.mscorlib.DNObjectClass)
  ['{D7BADC27-3961-5B77-B360-01513D030AC9}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.RecipientInfo')]
  DNRecipientInfo = interface(DDN.mscorlib.DNObject)
  ['{DD07B4AD-5778-37B4-B7A0-14889EB6B80B}']
  { getters & setters } 

    function get_Type: DNRecipientInfoType;
    function get_Version: Int32;
    function get_RecipientIdentifier: DNSubjectIdentifier;
    function get_KeyEncryptionAlgorithm: DNAlgorithmIdentifier;
    function get_EncryptedKey: TArray<Byte>;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property &Type: DNRecipientInfoType read get_Type;
    property Version: Int32 read get_Version;
    property RecipientIdentifier: DNSubjectIdentifier read get_RecipientIdentifier;
    property KeyEncryptionAlgorithm: DNAlgorithmIdentifier read get_KeyEncryptionAlgorithm;
    property EncryptedKey: TArray<Byte> read get_EncryptedKey;
  end;

  TDNRecipientInfo = class(TDNGenericImport<DNRecipientInfoClass, DNRecipientInfo>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNKeyAgreeRecipientInfoClass = interface(DNRecipientInfoClass)
  ['{C9D86C92-DA27-524B-867C-A01BBDD7B583}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.KeyAgreeRecipientInfo')]
  DNKeyAgreeRecipientInfo = interface(DNRecipientInfo)
  ['{A4423C3A-AD76-3930-8130-3D99DC2A070D}']
  { getters & setters } 

    function get_Version: Int32;
    function get_OriginatorIdentifierOrKey: DNSubjectIdentifierOrKey;
    function get_RecipientIdentifier: DNSubjectIdentifier;
    function get_Date: DDN.mscorlib.DNDateTime;
    function get_OtherKeyAttribute: DNCryptographicAttributeObject;
    function get_KeyEncryptionAlgorithm: DNAlgorithmIdentifier;
    function get_EncryptedKey: TArray<Byte>;
    function get_Type: DNRecipientInfoType;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Version: Int32 read get_Version;
    property OriginatorIdentifierOrKey: DNSubjectIdentifierOrKey read get_OriginatorIdentifierOrKey;
    property RecipientIdentifier: DNSubjectIdentifier read get_RecipientIdentifier;
    property Date: DDN.mscorlib.DNDateTime read get_Date;
    property OtherKeyAttribute: DNCryptographicAttributeObject read get_OtherKeyAttribute;
    property KeyEncryptionAlgorithm: DNAlgorithmIdentifier read get_KeyEncryptionAlgorithm;
    property EncryptedKey: TArray<Byte> read get_EncryptedKey;
    property &Type: DNRecipientInfoType read get_Type;
  end;

  TDNKeyAgreeRecipientInfo = class(TDNGenericImport<DNKeyAgreeRecipientInfoClass, DNKeyAgreeRecipientInfo>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNKeyTransRecipientInfoClass = interface(DNRecipientInfoClass)
  ['{E2821120-106A-57F0-AE0F-97328BE6E5CF}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.KeyTransRecipientInfo')]
  DNKeyTransRecipientInfo = interface(DNRecipientInfo)
  ['{9E73218E-3C28-3E4E-9DF6-112A400D4468}']
  { getters & setters } 

    function get_Version: Int32;
    function get_RecipientIdentifier: DNSubjectIdentifier;
    function get_KeyEncryptionAlgorithm: DNAlgorithmIdentifier;
    function get_EncryptedKey: TArray<Byte>;
    function get_Type: DNRecipientInfoType;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Version: Int32 read get_Version;
    property RecipientIdentifier: DNSubjectIdentifier read get_RecipientIdentifier;
    property KeyEncryptionAlgorithm: DNAlgorithmIdentifier read get_KeyEncryptionAlgorithm;
    property EncryptedKey: TArray<Byte> read get_EncryptedKey;
    property &Type: DNRecipientInfoType read get_Type;
  end;

  TDNKeyTransRecipientInfo = class(TDNGenericImport<DNKeyTransRecipientInfoClass, DNKeyTransRecipientInfo>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNRecipientInfoCollectionClass = interface(DNObjectClass)
  ['{34984546-EEBF-5194-AEFF-94667C43B0AE}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.RecipientInfoCollection')]
  DNRecipientInfoCollection = interface(DDN.mscorlib.DNICollection)
  ['{710BB5DF-E041-3566-B9FA-40548D84D868}']
  { getters & setters } 

    function get_Item(index: Int32): DNRecipientInfo;
    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDN.mscorlib.DNObject;

  { methods } 

    function GetEnumerator: DNRecipientInfoEnumerator;
    procedure CopyTo(&array: DDN.mscorlib.DNArray; index: Int32); overload;
    procedure CopyTo(&array: TArray<DNRecipientInfo>; index: Int32); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNRecipientInfo read get_Item; default;
    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
  end;

  TDNRecipientInfoCollection = class(TDNGenericImport<DNRecipientInfoCollectionClass, DNRecipientInfoCollection>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNRecipientInfoEnumeratorClass = interface(DNObjectClass)
  ['{40E43F12-CA6B-59E9-9F58-9E2D5405AABE}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.RecipientInfoEnumerator')]
  DNRecipientInfoEnumerator = interface(DDN.mscorlib.DNIEnumerator)
  ['{193CCA77-EED0-31AF-98D2-40C914E017D9}']
  { getters & setters } 

    function get_Current: DNRecipientInfo;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Current: DNRecipientInfo read get_Current;
  end;

  TDNRecipientInfoEnumerator = class(TDNGenericImport<DNRecipientInfoEnumeratorClass, DNRecipientInfoEnumerator>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNSignedCmsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B85B3D29-2DEC-599B-95EA-2BD5002B345D}']
  { constructors } 

    {class} function init: DNSignedCms; overload;
    {class} function init(signerIdentifierType: DNSubjectIdentifierType): DNSignedCms; overload;
    {class} function init(contentInfo: DNContentInfo): DNSignedCms; overload;
    {class} function init(signerIdentifierType: DNSubjectIdentifierType; contentInfo: DNContentInfo): DNSignedCms; overload;
    {class} function init(contentInfo: DNContentInfo; detached: Boolean): DNSignedCms; overload;
    {class} function init(signerIdentifierType: DNSubjectIdentifierType; contentInfo: DNContentInfo; detached: Boolean): DNSignedCms; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.SignedCms')]
  DNSignedCms = interface(DDN.mscorlib.DNObject)
  ['{3B79B3A9-BF36-3477-BE28-A333B438757F}']
  { getters & setters } 

    function get_Version: Int32;
    function get_ContentInfo: DNContentInfo;
    function get_Detached: Boolean;
    function get_Certificates: DDN.System.DNX509Certificate2Collection;
    function get_SignerInfos: DNSignerInfoCollection;

  { methods } 

    function Encode: TArray<Byte>;
    procedure Decode(encodedMessage: TArray<Byte>);
    procedure ComputeSignature; overload;
    procedure ComputeSignature(signer: DNCmsSigner); overload;
    procedure ComputeSignature(signer: DNCmsSigner; silent: Boolean); overload;
    procedure RemoveSignature(index: Int32); overload;
    procedure RemoveSignature(signerInfo: DNSignerInfo); overload;
    procedure CheckSignature(verifySignatureOnly: Boolean); overload;
    procedure CheckSignature(extraStore: DDN.System.DNX509Certificate2Collection; verifySignatureOnly: Boolean); overload;
    procedure CheckHash;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Version: Int32 read get_Version;
    property ContentInfo: DNContentInfo read get_ContentInfo;
    property Detached: Boolean read get_Detached;
    property Certificates: DDN.System.DNX509Certificate2Collection read get_Certificates;
    property SignerInfos: DNSignerInfoCollection read get_SignerInfos;
  end;

  TDNSignedCms = class(TDNGenericImport<DNSignedCmsClass, DNSignedCms>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNSignerInfoClass = interface(DDN.mscorlib.DNObjectClass)
  ['{9FBD8A1A-8369-50CF-886C-D92254E38BEE}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.SignerInfo')]
  DNSignerInfo = interface(DDN.mscorlib.DNObject)
  ['{85282D35-4C09-3365-B598-C3D3652917AC}']
  { getters & setters } 

    function get_Version: Int32;
    function get_Certificate: DDN.System.DNX509Certificate2;
    function get_SignerIdentifier: DNSubjectIdentifier;
    function get_DigestAlgorithm: DDN.System.DNOid;
    function get_SignedAttributes: DNCryptographicAttributeObjectCollection;
    function get_UnsignedAttributes: DNCryptographicAttributeObjectCollection;
    function get_CounterSignerInfos: DNSignerInfoCollection;
    function get_SignatureAlgorithm: DDN.System.DNOid;

  { methods } 

    procedure ComputeCounterSignature; overload;
    procedure ComputeCounterSignature(signer: DNCmsSigner); overload;
    procedure RemoveCounterSignature(index: Int32); overload;
    procedure CheckSignature(verifySignatureOnly: Boolean); overload;
    procedure CheckSignature(extraStore: DDN.System.DNX509Certificate2Collection; verifySignatureOnly: Boolean); overload;
    procedure CheckHash;
    procedure RemoveCounterSignature(counterSignerInfo: DNSignerInfo); overload;
    function GetSignature: TArray<Byte>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Version: Int32 read get_Version;
    property Certificate: DDN.System.DNX509Certificate2 read get_Certificate;
    property SignerIdentifier: DNSubjectIdentifier read get_SignerIdentifier;
    property DigestAlgorithm: DDN.System.DNOid read get_DigestAlgorithm;
    property SignedAttributes: DNCryptographicAttributeObjectCollection read get_SignedAttributes;
    property UnsignedAttributes: DNCryptographicAttributeObjectCollection read get_UnsignedAttributes;
    property CounterSignerInfos: DNSignerInfoCollection read get_CounterSignerInfos;
    property SignatureAlgorithm: DDN.System.DNOid read get_SignatureAlgorithm;
  end;

  TDNSignerInfo = class(TDNGenericImport<DNSignerInfoClass, DNSignerInfo>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNSignerInfoCollectionClass = interface(DNObjectClass)
  ['{105E9E03-91E2-5249-9C06-97BF86DB11C4}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.SignerInfoCollection')]
  DNSignerInfoCollection = interface(DDN.mscorlib.DNICollection)
  ['{508B2DA5-A2BD-3E84-8DFD-C26B1A3B2805}']
  { getters & setters } 

    function get_Item(index: Int32): DNSignerInfo;
    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDN.mscorlib.DNObject;

  { methods } 

    function GetEnumerator: DNSignerInfoEnumerator;
    procedure CopyTo(&array: DDN.mscorlib.DNArray; index: Int32); overload;
    procedure CopyTo(&array: TArray<DNSignerInfo>; index: Int32); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNSignerInfo read get_Item; default;
    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
  end;

  TDNSignerInfoCollection = class(TDNGenericImport<DNSignerInfoCollectionClass, DNSignerInfoCollection>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNSignerInfoEnumeratorClass = interface(DNObjectClass)
  ['{9ECAF90C-0ADD-5DB8-88AD-7C7329CF6AB2}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.SignerInfoEnumerator')]
  DNSignerInfoEnumerator = interface(DDN.mscorlib.DNIEnumerator)
  ['{963E2083-6AC5-3469-B91C-0557EA20BFFC}']
  { getters & setters } 

    function get_Current: DNSignerInfo;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Current: DNSignerInfo read get_Current;
  end;

  TDNSignerInfoEnumerator = class(TDNGenericImport<DNSignerInfoEnumeratorClass, DNSignerInfoEnumerator>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNSubjectIdentifierClass = interface(DDN.mscorlib.DNObjectClass)
  ['{AEEBD3EA-F8B1-5137-9960-64A95E9E52AA}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.SubjectIdentifier')]
  DNSubjectIdentifier = interface(DDN.mscorlib.DNObject)
  ['{1F38155D-2FB4-33BC-8B78-22CA1BF5CAB1}']
  { getters & setters } 

    function get_Type: DNSubjectIdentifierType;
    function get_Value: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property &Type: DNSubjectIdentifierType read get_Type;
    property Value: DDN.mscorlib.DNObject read get_Value;
  end;

  TDNSubjectIdentifier = class(TDNGenericImport<DNSubjectIdentifierClass, DNSubjectIdentifier>) end;

  //-------------namespace: System.Security.Cryptography.Pkcs----------------
  DNSubjectIdentifierOrKeyClass = interface(DDN.mscorlib.DNObjectClass)
  ['{C39B449C-ABE5-55CF-86ED-E6C51B44C5AC}']
  end;

  [DNTypeName('System.Security.Cryptography.Pkcs.SubjectIdentifierOrKey')]
  DNSubjectIdentifierOrKey = interface(DDN.mscorlib.DNObject)
  ['{D684C03D-44E3-3738-B7F3-77CDA73C1C8F}']
  { getters & setters } 

    function get_Type: DNSubjectIdentifierOrKeyType;
    function get_Value: DDN.mscorlib.DNObject;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property &Type: DNSubjectIdentifierOrKeyType read get_Type;
    property Value: DDN.mscorlib.DNObject read get_Value;
  end;

  TDNSubjectIdentifierOrKey = class(TDNGenericImport<DNSubjectIdentifierOrKeyClass, DNSubjectIdentifierOrKey>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNProtectedDataClass = interface(DDN.mscorlib.DNObjectClass)
  ['{023EB4D0-DEAC-50E7-B95C-8A780C93C31D}']
  { static methods } 

    {class} function Protect(userData: TArray<Byte>; optionalEntropy: TArray<Byte>; scope: DNDataProtectionScope): TArray<Byte>;
    {class} function Unprotect(encryptedData: TArray<Byte>; optionalEntropy: TArray<Byte>; scope: DNDataProtectionScope): TArray<Byte>;

  end;

  [DNTypeName('System.Security.Cryptography.ProtectedData')]
  DNProtectedData = interface(DDN.mscorlib.DNObject)
  ['{C91FD287-5DEE-390C-AFD5-7A1B574E50DC}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNProtectedData = class(TDNGenericImport<DNProtectedDataClass, DNProtectedData>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNProtectedMemoryClass = interface(DDN.mscorlib.DNObjectClass)
  ['{8BDDD140-F1B4-59D4-9FE1-197B7FABEC05}']
  { static methods } 

    {class} procedure Protect(userData: TArray<Byte>; scope: DNMemoryProtectionScope);
    {class} procedure Unprotect(encryptedData: TArray<Byte>; scope: DNMemoryProtectionScope);

  end;

  [DNTypeName('System.Security.Cryptography.ProtectedMemory')]
  DNProtectedMemory = interface(DDN.mscorlib.DNObject)
  ['{E3572D8B-459A-341E-9DE1-2BD8BE627CDB}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNProtectedMemory = class(TDNGenericImport<DNProtectedMemoryClass, DNProtectedMemory>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509Certificate2UIClass = interface(DDN.mscorlib.DNObjectClass)
  ['{4E273ECA-7FB5-526F-A4CF-1C744D620157}']
  { static methods } 

    {class} procedure DisplayCertificate(certificate: DDN.System.DNX509Certificate2); overload;
    {class} procedure DisplayCertificate(certificate: DDN.System.DNX509Certificate2; hwndParent: IntPtr); overload;
    {class} function SelectFromCollection(certificates: DDN.System.DNX509Certificate2Collection; title: string; message: string; selectionFlag: DNX509SelectionFlag): DDN.System.DNX509Certificate2Collection; overload;
    {class} function SelectFromCollection(certificates: DDN.System.DNX509Certificate2Collection; title: string; message: string; selectionFlag: DNX509SelectionFlag; hwndParent: IntPtr): DDN.System.DNX509Certificate2Collection; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509Certificate2UI')]
  DNX509Certificate2UI = interface(DDN.mscorlib.DNObject)
  ['{6F0D45A8-97F3-35D8-A4C2-66A27C74DCE9}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNX509Certificate2UI = class(TDNGenericImport<DNX509Certificate2UIClass, DNX509Certificate2UI>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNCipherDataClass = interface(DDN.mscorlib.DNObjectClass)
  ['{12719416-8F29-53A3-BBF1-03D45CB6A036}']
  { constructors } 

    {class} function init: DNCipherData; overload;
    {class} function init(cipherValue: TArray<Byte>): DNCipherData; overload;
    {class} function init(cipherReference: DNCipherReference): DNCipherData; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.CipherData')]
  DNCipherData = interface(DDN.mscorlib.DNObject)
  ['{3659D1BE-8038-3677-A0AA-090D2A504A32}']
  { getters & setters } 

    function get_CipherReference: DNCipherReference;
    procedure set_CipherReference(value: DNCipherReference);
    function get_CipherValue: TArray<Byte>;
    procedure set_CipherValue(value: TArray<Byte>);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property CipherReference: DNCipherReference read get_CipherReference write set_CipherReference;
    property CipherValue: TArray<Byte> read get_CipherValue write set_CipherValue;
  end;

  TDNCipherData = class(TDNGenericImport<DNCipherDataClass, DNCipherData>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNDataObjectClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B72C8303-3285-5E66-9B64-65BDADBB0D7B}']
  { constructors } 

    {class} function init: DNDataObject; overload;
    {class} function init(id: string; mimeType: string; encoding: string; data: DDN.System.Xml.DNXmlElement): DNDataObject; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.DataObject')]
  DNDataObject = interface(DDN.mscorlib.DNObject)
  ['{17E65955-BDA6-3F0E-8800-1B654A63FCC6}']
  { getters & setters } 

    function get_Id: string;
    procedure set_Id(value: string);
    function get_MimeType: string;
    procedure set_MimeType(value: string);
    function get_Encoding: string;
    procedure set_Encoding(value: string);
    function get_Data: DDN.System.Xml.DNXmlNodeList;
    procedure set_Data(value: DDN.System.Xml.DNXmlNodeList);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Id: string read get_Id write set_Id;
    property MimeType: string read get_MimeType write set_MimeType;
    property Encoding: string read get_Encoding write set_Encoding;
    property Data: DDN.System.Xml.DNXmlNodeList read get_Data write set_Data;
  end;

  TDNDataObject = class(TDNGenericImport<DNDataObjectClass, DNDataObject>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNEncryptedReferenceClass = interface(DDN.mscorlib.DNObjectClass)
  ['{5E24E8B3-541B-564C-BA0A-440886A50D0F}']
  end;

  [DNTypeName('System.Security.Cryptography.Xml.EncryptedReference')]
  DNEncryptedReference = interface(DDN.mscorlib.DNObject)
  ['{0390C15D-4623-31A1-81E0-8C493785A7A4}']
  { getters & setters } 

    function get_Uri: string;
    procedure set_Uri(value: string);
    function get_TransformChain: DNTransformChain;
    procedure set_TransformChain(value: DNTransformChain);

  { methods } 

    procedure AddTransform(transform: DNTransform);
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Uri: string read get_Uri write set_Uri;
    property TransformChain: DNTransformChain read get_TransformChain write set_TransformChain;
  end;

  TDNEncryptedReference = class(TDNGenericImport<DNEncryptedReferenceClass, DNEncryptedReference>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNCipherReferenceClass = interface(DNEncryptedReferenceClass)
  ['{BB79A29C-ED5D-5E48-B96C-53E9F5B76806}']
  { constructors } 

    {class} function init: DNCipherReference; overload;
    {class} function init(uri: string): DNCipherReference; overload;
    {class} function init(uri: string; transformChain: DNTransformChain): DNCipherReference; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.CipherReference')]
  DNCipherReference = interface(DNEncryptedReference)
  ['{CD382733-E2F7-300D-A22F-D55B4E50FCAE}']
  { getters & setters } 

    function get_Uri: string;
    procedure set_Uri(value: string);
    function get_TransformChain: DNTransformChain;
    procedure set_TransformChain(value: DNTransformChain);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    procedure AddTransform(transform: DNTransform);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Uri: string read get_Uri write set_Uri;
    property TransformChain: DNTransformChain read get_TransformChain write set_TransformChain;
  end;

  TDNCipherReference = class(TDNGenericImport<DNCipherReferenceClass, DNCipherReference>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNDataReferenceClass = interface(DNEncryptedReferenceClass)
  ['{646EA0AB-9F97-53B8-AF94-B864DE0ED877}']
  { constructors } 

    {class} function init: DNDataReference; overload;
    {class} function init(uri: string): DNDataReference; overload;
    {class} function init(uri: string; transformChain: DNTransformChain): DNDataReference; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.DataReference')]
  DNDataReference = interface(DNEncryptedReference)
  ['{703A7CAD-89F8-32D5-9F29-104824D3CB16}']
  { getters & setters } 

    function get_Uri: string;
    procedure set_Uri(value: string);
    function get_TransformChain: DNTransformChain;
    procedure set_TransformChain(value: DNTransformChain);

  { methods } 

    procedure AddTransform(transform: DNTransform);
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Uri: string read get_Uri write set_Uri;
    property TransformChain: DNTransformChain read get_TransformChain write set_TransformChain;
  end;

  TDNDataReference = class(TDNGenericImport<DNDataReferenceClass, DNDataReference>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNKeyReferenceClass = interface(DNEncryptedReferenceClass)
  ['{9A619B54-E47D-5E7E-8D92-42C2B7B30321}']
  { constructors } 

    {class} function init: DNKeyReference; overload;
    {class} function init(uri: string): DNKeyReference; overload;
    {class} function init(uri: string; transformChain: DNTransformChain): DNKeyReference; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.KeyReference')]
  DNKeyReference = interface(DNEncryptedReference)
  ['{FAE94490-3F08-3462-87F0-3280300E5EC3}']
  { getters & setters } 

    function get_Uri: string;
    procedure set_Uri(value: string);
    function get_TransformChain: DNTransformChain;
    procedure set_TransformChain(value: DNTransformChain);

  { methods } 

    procedure AddTransform(transform: DNTransform);
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Uri: string read get_Uri write set_Uri;
    property TransformChain: DNTransformChain read get_TransformChain write set_TransformChain;
  end;

  TDNKeyReference = class(TDNGenericImport<DNKeyReferenceClass, DNKeyReference>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNEncryptedTypeClass = interface(DDN.mscorlib.DNObjectClass)
  ['{1A58CAF7-1AA2-57B4-B355-5109054389A3}']
  end;

  [DNTypeName('System.Security.Cryptography.Xml.EncryptedType')]
  DNEncryptedType = interface(DDN.mscorlib.DNObject)
  ['{B16957FA-6313-353D-A27A-D0F59B4E8200}']
  { getters & setters } 

    function get_Id: string;
    procedure set_Id(value: string);
    function get_Type: string;
    procedure set_Type(value: string);
    function get_MimeType: string;
    procedure set_MimeType(value: string);
    function get_Encoding: string;
    procedure set_Encoding(value: string);
    function get_KeyInfo: DNKeyInfo;
    procedure set_KeyInfo(value: DNKeyInfo);
    function get_EncryptionMethod: DNEncryptionMethod;
    procedure set_EncryptionMethod(value: DNEncryptionMethod);
    function get_EncryptionProperties: DNEncryptionPropertyCollection;
    function get_CipherData: DNCipherData;
    procedure set_CipherData(value: DNCipherData);

  { methods } 

    procedure AddProperty(ep: DNEncryptionProperty);
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Id: string read get_Id write set_Id;
    property &Type: string read get_Type write set_Type;
    property MimeType: string read get_MimeType write set_MimeType;
    property Encoding: string read get_Encoding write set_Encoding;
    property KeyInfo: DNKeyInfo read get_KeyInfo write set_KeyInfo;
    property EncryptionMethod: DNEncryptionMethod read get_EncryptionMethod write set_EncryptionMethod;
    property EncryptionProperties: DNEncryptionPropertyCollection read get_EncryptionProperties;
    property CipherData: DNCipherData read get_CipherData write set_CipherData;
  end;

  TDNEncryptedType = class(TDNGenericImport<DNEncryptedTypeClass, DNEncryptedType>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNEncryptedDataClass = interface(DNEncryptedTypeClass)
  ['{E56F5504-1E60-5D29-A77B-E993F28DD0D4}']
  { constructors } 

    {class} function init: DNEncryptedData;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.EncryptedData')]
  DNEncryptedData = interface(DNEncryptedType)
  ['{FC2F57BB-F8D4-3D10-AB53-F65C0D6C9997}']
  { getters & setters } 

    function get_Id: string;
    procedure set_Id(value: string);
    function get_Type: string;
    procedure set_Type(value: string);
    function get_MimeType: string;
    procedure set_MimeType(value: string);
    function get_Encoding: string;
    procedure set_Encoding(value: string);
    function get_KeyInfo: DNKeyInfo;
    procedure set_KeyInfo(value: DNKeyInfo);
    function get_EncryptionMethod: DNEncryptionMethod;
    procedure set_EncryptionMethod(value: DNEncryptionMethod);
    function get_EncryptionProperties: DNEncryptionPropertyCollection;
    function get_CipherData: DNCipherData;
    procedure set_CipherData(value: DNCipherData);

  { methods } 

    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure AddProperty(ep: DNEncryptionProperty);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Id: string read get_Id write set_Id;
    property &Type: string read get_Type write set_Type;
    property MimeType: string read get_MimeType write set_MimeType;
    property Encoding: string read get_Encoding write set_Encoding;
    property KeyInfo: DNKeyInfo read get_KeyInfo write set_KeyInfo;
    property EncryptionMethod: DNEncryptionMethod read get_EncryptionMethod write set_EncryptionMethod;
    property EncryptionProperties: DNEncryptionPropertyCollection read get_EncryptionProperties;
    property CipherData: DNCipherData read get_CipherData write set_CipherData;
  end;

  TDNEncryptedData = class(TDNGenericImport<DNEncryptedDataClass, DNEncryptedData>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNEncryptedKeyClass = interface(DNEncryptedTypeClass)
  ['{4BDBAED7-48DD-5EEF-A6C6-29ADCF4B1DF8}']
  { constructors } 

    {class} function init: DNEncryptedKey;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.EncryptedKey')]
  DNEncryptedKey = interface(DNEncryptedType)
  ['{48CB09B5-2B67-3196-9158-51F16E388F70}']
  { getters & setters } 

    function get_Recipient: string;
    procedure set_Recipient(value: string);
    function get_CarriedKeyName: string;
    procedure set_CarriedKeyName(value: string);
    function get_ReferenceList: DNReferenceList;
    function get_Id: string;
    procedure set_Id(value: string);
    function get_Type: string;
    procedure set_Type(value: string);
    function get_MimeType: string;
    procedure set_MimeType(value: string);
    function get_Encoding: string;
    procedure set_Encoding(value: string);
    function get_KeyInfo: DNKeyInfo;
    procedure set_KeyInfo(value: DNKeyInfo);
    function get_EncryptionMethod: DNEncryptionMethod;
    procedure set_EncryptionMethod(value: DNEncryptionMethod);
    function get_EncryptionProperties: DNEncryptionPropertyCollection;
    function get_CipherData: DNCipherData;
    procedure set_CipherData(value: DNCipherData);

  { methods } 

    procedure AddReference(dataReference: DNDataReference); overload;
    procedure AddReference(keyReference: DNKeyReference); overload;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure AddProperty(ep: DNEncryptionProperty);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Recipient: string read get_Recipient write set_Recipient;
    property CarriedKeyName: string read get_CarriedKeyName write set_CarriedKeyName;
    property ReferenceList: DNReferenceList read get_ReferenceList;
    property Id: string read get_Id write set_Id;
    property &Type: string read get_Type write set_Type;
    property MimeType: string read get_MimeType write set_MimeType;
    property Encoding: string read get_Encoding write set_Encoding;
    property KeyInfo: DNKeyInfo read get_KeyInfo write set_KeyInfo;
    property EncryptionMethod: DNEncryptionMethod read get_EncryptionMethod write set_EncryptionMethod;
    property EncryptionProperties: DNEncryptionPropertyCollection read get_EncryptionProperties;
    property CipherData: DNCipherData read get_CipherData write set_CipherData;
  end;

  TDNEncryptedKey = class(TDNGenericImport<DNEncryptedKeyClass, DNEncryptedKey>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNEncryptedXmlClass = interface(DDN.mscorlib.DNObjectClass)
  ['{40AEFBF3-ED84-5B91-A038-F79A01132B3A}']
  { constructors } 

    {class} function init: DNEncryptedXml; overload;
    {class} function init(document: DDN.System.Xml.DNXmlDocument): DNEncryptedXml; overload;
    {class} function init(document: DDN.System.Xml.DNXmlDocument; evidence: DDN.mscorlib.DNEvidence): DNEncryptedXml; overload;

  { static methods } 

    {class} function EncryptKey(keyData: TArray<Byte>; symmetricAlgorithm: DDN.mscorlib.DNSymmetricAlgorithm): TArray<Byte>; overload;
    {class} function EncryptKey(keyData: TArray<Byte>; rsa: DDN.mscorlib.DNRSA; useOAEP: Boolean): TArray<Byte>; overload;
    {class} function DecryptKey(keyData: TArray<Byte>; symmetricAlgorithm: DDN.mscorlib.DNSymmetricAlgorithm): TArray<Byte>; overload;
    {class} function DecryptKey(keyData: TArray<Byte>; rsa: DDN.mscorlib.DNRSA; useOAEP: Boolean): TArray<Byte>; overload;
    {class} procedure ReplaceElement(inputElement: DDN.System.Xml.DNXmlElement; encryptedData: DNEncryptedData; content: Boolean);

  end;

  [DNTypeName('System.Security.Cryptography.Xml.EncryptedXml')]
  DNEncryptedXml = interface(DDN.mscorlib.DNObject)
  ['{05293FB4-17EC-3B7F-92DF-18C9FD266F05}']
  { getters & setters } 

    function get_XmlDSigSearchDepth: Int32;
    procedure set_XmlDSigSearchDepth(value: Int32);
    function get_DocumentEvidence: DDN.mscorlib.DNEvidence;
    procedure set_DocumentEvidence(value: DDN.mscorlib.DNEvidence);
    function get_Resolver: DDN.System.Xml.DNXmlResolver;
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Padding: DDN.mscorlib.DNPaddingMode;
    procedure set_Padding(value: DDN.mscorlib.DNPaddingMode);
    function get_Mode: DDN.mscorlib.DNCipherMode;
    procedure set_Mode(value: DDN.mscorlib.DNCipherMode);
    function get_Encoding: DDN.mscorlib.DNEncoding;
    procedure set_Encoding(value: DDN.mscorlib.DNEncoding);
    function get_Recipient: string;
    procedure set_Recipient(value: string);

  { methods } 

    function GetIdElement(document: DDN.System.Xml.DNXmlDocument; idValue: string): DDN.System.Xml.DNXmlElement;
    procedure AddKeyNameMapping(keyName: string; keyObject: DDN.mscorlib.DNObject);
    procedure ClearKeyNameMappings;
    function DecryptData(encryptedData: DNEncryptedData; symmetricAlgorithm: DDN.mscorlib.DNSymmetricAlgorithm): TArray<Byte>;
    function GetDecryptionIV(encryptedData: DNEncryptedData; symmetricAlgorithmUri: string): TArray<Byte>;
    function GetDecryptionKey(encryptedData: DNEncryptedData; symmetricAlgorithmUri: string): DDN.mscorlib.DNSymmetricAlgorithm;
    function DecryptEncryptedKey(encryptedKey: DNEncryptedKey): TArray<Byte>;
    function Encrypt(inputElement: DDN.System.Xml.DNXmlElement; certificate: DDN.System.DNX509Certificate2): DNEncryptedData; overload;
    function Encrypt(inputElement: DDN.System.Xml.DNXmlElement; keyName: string): DNEncryptedData; overload;
    procedure DecryptDocument;
    function EncryptData(plaintext: TArray<Byte>; symmetricAlgorithm: DDN.mscorlib.DNSymmetricAlgorithm): TArray<Byte>; overload;
    function EncryptData(inputElement: DDN.System.Xml.DNXmlElement; symmetricAlgorithm: DDN.mscorlib.DNSymmetricAlgorithm; content: Boolean): TArray<Byte>; overload;
    procedure ReplaceData(inputElement: DDN.System.Xml.DNXmlElement; decryptedData: TArray<Byte>);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property XmlDSigSearchDepth: Int32 read get_XmlDSigSearchDepth write set_XmlDSigSearchDepth;
    property DocumentEvidence: DDN.mscorlib.DNEvidence read get_DocumentEvidence write set_DocumentEvidence;
    property Resolver: DDN.System.Xml.DNXmlResolver read get_Resolver write set_Resolver;
    property Padding: DDN.mscorlib.DNPaddingMode read get_Padding write set_Padding;
    property Mode: DDN.mscorlib.DNCipherMode read get_Mode write set_Mode;
    property Encoding: DDN.mscorlib.DNEncoding read get_Encoding write set_Encoding;
    property Recipient: string read get_Recipient write set_Recipient;
  end;

  TDNEncryptedXml = class(TDNGenericImport<DNEncryptedXmlClass, DNEncryptedXml>)
  public const
   XmlEncNamespaceUrl = 'http://www.w3.org/2001/04/xmlenc#';
   XmlEncElementUrl = 'http://www.w3.org/2001/04/xmlenc#Element';
   XmlEncElementContentUrl = 'http://www.w3.org/2001/04/xmlenc#Content';
   XmlEncEncryptedKeyUrl = 'http://www.w3.org/2001/04/xmlenc#EncryptedKey';
   XmlEncDESUrl = 'http://www.w3.org/2001/04/xmlenc#des-cbc';
   XmlEncTripleDESUrl = 'http://www.w3.org/2001/04/xmlenc#tripledes-cbc';
   XmlEncAES128Url = 'http://www.w3.org/2001/04/xmlenc#aes128-cbc';
   XmlEncAES256Url = 'http://www.w3.org/2001/04/xmlenc#aes256-cbc';
   XmlEncAES192Url = 'http://www.w3.org/2001/04/xmlenc#aes192-cbc';
   XmlEncRSA15Url = 'http://www.w3.org/2001/04/xmlenc#rsa-1_5';
   XmlEncRSAOAEPUrl = 'http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p';
   XmlEncTripleDESKeyWrapUrl = 'http://www.w3.org/2001/04/xmlenc#kw-tripledes';
   XmlEncAES128KeyWrapUrl = 'http://www.w3.org/2001/04/xmlenc#kw-aes128';
   XmlEncAES256KeyWrapUrl = 'http://www.w3.org/2001/04/xmlenc#kw-aes256';
   XmlEncAES192KeyWrapUrl = 'http://www.w3.org/2001/04/xmlenc#kw-aes192';
   XmlEncSHA256Url = 'http://www.w3.org/2001/04/xmlenc#sha256';
   XmlEncSHA512Url = 'http://www.w3.org/2001/04/xmlenc#sha512';
  end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNEncryptionMethodClass = interface(DDN.mscorlib.DNObjectClass)
  ['{BC7F8721-CDD0-5EFD-8314-85D1C9318DEE}']
  { constructors } 

    {class} function init: DNEncryptionMethod; overload;
    {class} function init(algorithm: string): DNEncryptionMethod; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.EncryptionMethod')]
  DNEncryptionMethod = interface(DDN.mscorlib.DNObject)
  ['{45373A3E-546E-3C91-A8A0-3F3F1BD7F98B}']
  { getters & setters } 

    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_KeyAlgorithm: string;
    procedure set_KeyAlgorithm(value: string);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property KeySize: Int32 read get_KeySize write set_KeySize;
    property KeyAlgorithm: string read get_KeyAlgorithm write set_KeyAlgorithm;
  end;

  TDNEncryptionMethod = class(TDNGenericImport<DNEncryptionMethodClass, DNEncryptionMethod>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNEncryptionPropertyClass = interface(DDN.mscorlib.DNObjectClass)
  ['{C6EC2007-0CC9-5398-89E6-B7502F6CA67C}']
  { constructors } 

    {class} function init: DNEncryptionProperty; overload;
    {class} function init(elementProperty: DDN.System.Xml.DNXmlElement): DNEncryptionProperty; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.EncryptionProperty')]
  DNEncryptionProperty = interface(DDN.mscorlib.DNObject)
  ['{FBCF2510-EE0D-3BBA-81F9-EB08F217DECD}']
  { getters & setters } 

    function get_Id: string;
    function get_Target: string;
    function get_PropertyElement: DDN.System.Xml.DNXmlElement;
    procedure set_PropertyElement(value: DDN.System.Xml.DNXmlElement);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Id: string read get_Id;
    property Target: string read get_Target;
    property PropertyElement: DDN.System.Xml.DNXmlElement read get_PropertyElement write set_PropertyElement;
  end;

  TDNEncryptionProperty = class(TDNGenericImport<DNEncryptionPropertyClass, DNEncryptionProperty>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNEncryptionPropertyCollectionClass = interface(DNObjectClass)
  ['{F50F0241-CF57-5ED2-A6F0-DACFBD9BF9DC}']
  { constructors } 

    {class} function init: DNEncryptionPropertyCollection;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.EncryptionPropertyCollection')]
  DNEncryptionPropertyCollection = interface(DDN.mscorlib.DNIList)
  ['{4EDF7CB8-170C-3691-AF15-EE46A5F94BD8}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsFixedSize: Boolean;
    function get_IsReadOnly: Boolean;
    function get_ItemOf(index: Int32): DNEncryptionProperty;
    procedure set_ItemOf(index: Int32; value: DNEncryptionProperty);
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsSynchronized: Boolean;

  { methods } 

    function GetEnumerator: DDN.mscorlib.DNIEnumerator;
    function Add(value: DNEncryptionProperty): Int32;
    function &Contains(value: DNEncryptionProperty): Boolean;
    function IndexOf(value: DNEncryptionProperty): Int32;
    procedure Insert(index: Int32; value: DNEncryptionProperty);
    procedure Remove(value: DNEncryptionProperty);
    procedure RemoveAt(index: Int32);
    function Item(index: Int32): DNEncryptionProperty;
    procedure CopyTo(&array: DDN.mscorlib.DNArray; index: Int32); overload;
    procedure CopyTo(&array: TArray<DNEncryptionProperty>; index: Int32); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsFixedSize: Boolean read get_IsFixedSize;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property ItemOf[index: Int32]: DNEncryptionProperty read get_ItemOf write set_ItemOf; default;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property IsSynchronized: Boolean read get_IsSynchronized;
  end;

  TDNEncryptionPropertyCollection = class(TDNGenericImport<DNEncryptionPropertyCollectionClass, DNEncryptionPropertyCollection>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNKeyInfoClass = interface(DNObjectClass)
  ['{FC55D02A-89AB-5B1C-A81C-D61D7D5EDE15}']
  { constructors } 

    {class} function init: DNKeyInfo;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.KeyInfo')]
  DNKeyInfo = interface(DDN.mscorlib.DNIEnumerable)
  ['{4FEF8CE8-09B4-3D13-88DD-39A9F077A80C}']
  { getters & setters } 

    function get_Id: string;
    procedure set_Id(value: string);
    function get_Count: Int32;

  { methods } 

    procedure AddClause(clause: DNKeyInfoClause);
    function GetEnumerator: DDN.mscorlib.DNIEnumerator; overload;
    function GetEnumerator(requestedObjectType: DDN.mscorlib.DNType): DDN.mscorlib.DNIEnumerator; overload;
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Id: string read get_Id write set_Id;
    property Count: Int32 read get_Count;
  end;

  TDNKeyInfo = class(TDNGenericImport<DNKeyInfoClass, DNKeyInfo>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNKeyInfoClauseClass = interface(DDN.mscorlib.DNObjectClass)
  ['{0E78A823-CB35-5307-B462-C2C57C34AFD6}']
  end;

  [DNTypeName('System.Security.Cryptography.Xml.KeyInfoClause')]
  DNKeyInfoClause = interface(DDN.mscorlib.DNObject)
  ['{C1677807-714E-320B-B67E-77C6F73AFBC3}']
  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(element: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNKeyInfoClause = class(TDNGenericImport<DNKeyInfoClauseClass, DNKeyInfoClause>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNDSAKeyValueClass = interface(DNKeyInfoClauseClass)
  ['{377CFB91-8900-518F-93BB-9A4DAF7A8573}']
  { constructors } 

    {class} function init: DNDSAKeyValue; overload;
    {class} function init(key: DDN.mscorlib.DNDSA): DNDSAKeyValue; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.DSAKeyValue')]
  DNDSAKeyValue = interface(DNKeyInfoClause)
  ['{A0A0C73D-39C1-322A-961E-96C8AC5372E9}']
  { getters & setters } 

    function get_Key: DDN.mscorlib.DNDSA;
    procedure set_Key(value: DDN.mscorlib.DNDSA);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Key: DDN.mscorlib.DNDSA read get_Key write set_Key;
  end;

  TDNDSAKeyValue = class(TDNGenericImport<DNDSAKeyValueClass, DNDSAKeyValue>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNKeyInfoEncryptedKeyClass = interface(DNKeyInfoClauseClass)
  ['{07FDC586-F492-5315-AD01-43989E8E0ED2}']
  { constructors } 

    {class} function init: DNKeyInfoEncryptedKey; overload;
    {class} function init(encryptedKey: DNEncryptedKey): DNKeyInfoEncryptedKey; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.KeyInfoEncryptedKey')]
  DNKeyInfoEncryptedKey = interface(DNKeyInfoClause)
  ['{F553DA72-AA00-392C-BA00-264884732880}']
  { getters & setters } 

    function get_EncryptedKey: DNEncryptedKey;
    procedure set_EncryptedKey(value: DNEncryptedKey);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property EncryptedKey: DNEncryptedKey read get_EncryptedKey write set_EncryptedKey;
  end;

  TDNKeyInfoEncryptedKey = class(TDNGenericImport<DNKeyInfoEncryptedKeyClass, DNKeyInfoEncryptedKey>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNKeyInfoNameClass = interface(DNKeyInfoClauseClass)
  ['{CF9A57EF-B84F-5BF8-93DE-0E3041631673}']
  { constructors } 

    {class} function init: DNKeyInfoName; overload;
    {class} function init(keyName: string): DNKeyInfoName; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.KeyInfoName')]
  DNKeyInfoName = interface(DNKeyInfoClause)
  ['{9A4062E1-3932-3BBF-853E-522D7AA04085}']
  { getters & setters } 

    function get_Value: string;
    procedure set_Value(value: string);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Value: string read get_Value write set_Value;
  end;

  TDNKeyInfoName = class(TDNGenericImport<DNKeyInfoNameClass, DNKeyInfoName>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNKeyInfoNodeClass = interface(DNKeyInfoClauseClass)
  ['{309743C1-6F21-59A2-9EF2-80AD1F690E56}']
  { constructors } 

    {class} function init: DNKeyInfoNode; overload;
    {class} function init(node: DDN.System.Xml.DNXmlElement): DNKeyInfoNode; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.KeyInfoNode')]
  DNKeyInfoNode = interface(DNKeyInfoClause)
  ['{7766A4DB-3072-34A2-972F-B5408656246C}']
  { getters & setters } 

    function get_Value: DDN.System.Xml.DNXmlElement;
    procedure set_Value(value: DDN.System.Xml.DNXmlElement);

  { methods } 

    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Value: DDN.System.Xml.DNXmlElement read get_Value write set_Value;
  end;

  TDNKeyInfoNode = class(TDNGenericImport<DNKeyInfoNodeClass, DNKeyInfoNode>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNKeyInfoRetrievalMethodClass = interface(DNKeyInfoClauseClass)
  ['{D856FA4A-AC5A-5A26-A77D-DF088B8C9478}']
  { constructors } 

    {class} function init: DNKeyInfoRetrievalMethod; overload;
    {class} function init(strUri: string): DNKeyInfoRetrievalMethod; overload;
    {class} function init(strUri: string; typeName: string): DNKeyInfoRetrievalMethod; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.KeyInfoRetrievalMethod')]
  DNKeyInfoRetrievalMethod = interface(DNKeyInfoClause)
  ['{57F2BFAA-B0E3-30C3-9649-77A9DDD8B64B}']
  { getters & setters } 

    function get_Uri: string;
    procedure set_Uri(value: string);
    function get_Type: string;
    procedure set_Type(value: string);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Uri: string read get_Uri write set_Uri;
    property &Type: string read get_Type write set_Type;
  end;

  TDNKeyInfoRetrievalMethod = class(TDNGenericImport<DNKeyInfoRetrievalMethodClass, DNKeyInfoRetrievalMethod>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNKeyInfoX509DataClass = interface(DNKeyInfoClauseClass)
  ['{5E166CBF-728D-57E4-A131-18D505F9FA94}']
  { constructors } 

    {class} function init: DNKeyInfoX509Data; overload;
    {class} function init(rgbCert: TArray<Byte>): DNKeyInfoX509Data; overload;
    {class} function init(cert: DDN.mscorlib.DNX509Certificate): DNKeyInfoX509Data; overload;
    {class} function init(cert: DDN.mscorlib.DNX509Certificate; includeOption: DDN.System.DNX509IncludeOption): DNKeyInfoX509Data; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.KeyInfoX509Data')]
  DNKeyInfoX509Data = interface(DNKeyInfoClause)
  ['{80A1B9CB-E826-3393-A806-5689B8289E14}']
  { getters & setters } 

    function get_Certificates: DDN.mscorlib.DNArrayList;
    function get_SubjectKeyIds: DDN.mscorlib.DNArrayList;
    function get_SubjectNames: DDN.mscorlib.DNArrayList;
    function get_IssuerSerials: DDN.mscorlib.DNArrayList;
    function get_CRL: TArray<Byte>;
    procedure set_CRL(value: TArray<Byte>);

  { methods } 

    procedure AddCertificate(certificate: DDN.mscorlib.DNX509Certificate);
    procedure AddSubjectKeyId(subjectKeyId: TArray<Byte>); overload;
    procedure AddSubjectKeyId(subjectKeyId: string); overload;
    procedure AddSubjectName(subjectName: string);
    procedure AddIssuerSerial(issuerName: string; serialNumber: string);
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(element: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Certificates: DDN.mscorlib.DNArrayList read get_Certificates;
    property SubjectKeyIds: DDN.mscorlib.DNArrayList read get_SubjectKeyIds;
    property SubjectNames: DDN.mscorlib.DNArrayList read get_SubjectNames;
    property IssuerSerials: DDN.mscorlib.DNArrayList read get_IssuerSerials;
    property CRL: TArray<Byte> read get_CRL write set_CRL;
  end;

  TDNKeyInfoX509Data = class(TDNGenericImport<DNKeyInfoX509DataClass, DNKeyInfoX509Data>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNRSAKeyValueClass = interface(DNKeyInfoClauseClass)
  ['{8ECB78C0-172D-5578-AD47-ED9250A98F6C}']
  { constructors } 

    {class} function init: DNRSAKeyValue; overload;
    {class} function init(key: DDN.mscorlib.DNRSA): DNRSAKeyValue; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.RSAKeyValue')]
  DNRSAKeyValue = interface(DNKeyInfoClause)
  ['{268DE0CB-0A43-39B7-B1BE-2A08D924C414}']
  { getters & setters } 

    function get_Key: DDN.mscorlib.DNRSA;
    procedure set_Key(value: DDN.mscorlib.DNRSA);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Key: DDN.mscorlib.DNRSA read get_Key write set_Key;
  end;

  TDNRSAKeyValue = class(TDNGenericImport<DNRSAKeyValueClass, DNRSAKeyValue>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNReferenceClass = interface(DDN.mscorlib.DNObjectClass)
  ['{1B0A8D95-8E8E-5CD5-AD1A-883B141ED377}']
  { constructors } 

    {class} function init: DNReference; overload;
    {class} function init(stream: DDN.mscorlib.DNStream): DNReference; overload;
    {class} function init(uri: string): DNReference; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.Reference')]
  DNReference = interface(DDN.mscorlib.DNObject)
  ['{BEF96AF0-4A13-3483-8743-89C05AFE9B89}']
  { getters & setters } 

    function get_Id: string;
    procedure set_Id(value: string);
    function get_Uri: string;
    procedure set_Uri(value: string);
    function get_Type: string;
    procedure set_Type(value: string);
    function get_DigestMethod: string;
    procedure set_DigestMethod(value: string);
    function get_DigestValue: TArray<Byte>;
    procedure set_DigestValue(value: TArray<Byte>);
    function get_TransformChain: DNTransformChain;
    procedure set_TransformChain(value: DNTransformChain);

  { methods } 

    procedure AddTransform(transform: DNTransform);
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Id: string read get_Id write set_Id;
    property Uri: string read get_Uri write set_Uri;
    property &Type: string read get_Type write set_Type;
    property DigestMethod: string read get_DigestMethod write set_DigestMethod;
    property DigestValue: TArray<Byte> read get_DigestValue write set_DigestValue;
    property TransformChain: DNTransformChain read get_TransformChain write set_TransformChain;
  end;

  TDNReference = class(TDNGenericImport<DNReferenceClass, DNReference>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNReferenceListClass = interface(DNObjectClass)
  ['{36F6DFA5-BA28-5249-96BA-24643DCCF579}']
  { constructors } 

    {class} function init: DNReferenceList;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.ReferenceList')]
  DNReferenceList = interface(DDN.mscorlib.DNIList)
  ['{BCDD56BB-1E8D-3F2C-BEE0-E43243B00643}']
  { getters & setters } 

    function get_Count: Int32;
    function get_ItemOf(index: Int32): DNEncryptedReference;
    procedure set_ItemOf(index: Int32; value: DNEncryptedReference);
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsSynchronized: Boolean;

  { methods } 

    function GetEnumerator: DDN.mscorlib.DNIEnumerator;
    function &Contains(value: DDN.mscorlib.DNObject): Boolean;
    function IndexOf(value: DDN.mscorlib.DNObject): Int32;
    procedure Insert(index: Int32; value: DDN.mscorlib.DNObject);
    procedure RemoveAt(index: Int32);
    function Item(index: Int32): DNEncryptedReference;
    procedure CopyTo(&array: DDN.mscorlib.DNArray; index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Count: Int32 read get_Count;
    property ItemOf[index: Int32]: DNEncryptedReference read get_ItemOf write set_ItemOf; default;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property IsSynchronized: Boolean read get_IsSynchronized;
  end;

  TDNReferenceList = class(TDNGenericImport<DNReferenceListClass, DNReferenceList>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNSignatureClass = interface(DDN.mscorlib.DNObjectClass)
  ['{2C5D1FF7-84D9-58EB-9424-EFCF9097AA71}']
  { constructors } 

    {class} function init: DNSignature;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.Signature')]
  DNSignature = interface(DDN.mscorlib.DNObject)
  ['{1693EF5C-FC4B-35A7-8423-C2945D7BE194}']
  { getters & setters } 

    function get_Id: string;
    procedure set_Id(value: string);
    function get_SignedInfo: DNSignedInfo;
    procedure set_SignedInfo(value: DNSignedInfo);
    function get_SignatureValue: TArray<Byte>;
    procedure set_SignatureValue(value: TArray<Byte>);
    function get_KeyInfo: DNKeyInfo;
    procedure set_KeyInfo(value: DNKeyInfo);
    function get_ObjectList: DDN.mscorlib.DNIList;
    procedure set_ObjectList(value: DDN.mscorlib.DNIList);

  { methods } 

    procedure AddObject(dataObject: DNDataObject);
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Id: string read get_Id write set_Id;
    property SignedInfo: DNSignedInfo read get_SignedInfo write set_SignedInfo;
    property SignatureValue: TArray<Byte> read get_SignatureValue write set_SignatureValue;
    property KeyInfo: DNKeyInfo read get_KeyInfo write set_KeyInfo;
    property ObjectList: DDN.mscorlib.DNIList read get_ObjectList write set_ObjectList;
  end;

  TDNSignature = class(TDNGenericImport<DNSignatureClass, DNSignature>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNSignedInfoClass = interface(DNObjectClass)
  ['{87B8ADF6-8E82-5AA3-B273-3597227F4754}']
  { constructors } 

    {class} function init: DNSignedInfo;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.SignedInfo')]
  DNSignedInfo = interface(DDN.mscorlib.DNICollection)
  ['{2EB50F73-857A-36B6-A280-799AF76E98BE}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_Id: string;
    procedure set_Id(value: string);
    function get_CanonicalizationMethod: string;
    procedure set_CanonicalizationMethod(value: string);
    function get_CanonicalizationMethodObject: DNTransform;
    function get_SignatureMethod: string;
    procedure set_SignatureMethod(value: string);
    function get_SignatureLength: string;
    procedure set_SignatureLength(value: string);
    function get_References: DDN.mscorlib.DNArrayList;

  { methods } 

    function GetEnumerator: DDN.mscorlib.DNIEnumerator;
    procedure CopyTo(&array: DDN.mscorlib.DNArray; index: Int32);
    procedure AddReference(reference: DNReference);
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property Id: string read get_Id write set_Id;
    property CanonicalizationMethod: string read get_CanonicalizationMethod write set_CanonicalizationMethod;
    property CanonicalizationMethodObject: DNTransform read get_CanonicalizationMethodObject;
    property SignatureMethod: string read get_SignatureMethod write set_SignatureMethod;
    property SignatureLength: string read get_SignatureLength write set_SignatureLength;
    property References: DDN.mscorlib.DNArrayList read get_References;
  end;

  TDNSignedInfo = class(TDNGenericImport<DNSignedInfoClass, DNSignedInfo>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNSignedXmlClass = interface(DDN.mscorlib.DNObjectClass)
  ['{130A794F-4463-5D0A-A4B4-946D847D4B7C}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNSignedXml; overload;
    {class} function init(document: DDN.System.Xml.DNXmlDocument): DNSignedXml; overload;
    {class} function init(elem: DDN.System.Xml.DNXmlElement): DNSignedXml; overload;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.SignedXml')]
  DNSignedXml = interface(DDN.mscorlib.DNObject)
  ['{C1A1D953-CC23-3DA9-A149-1AB9DB11E526}']
  { getters & setters } 

    function get_SigningKeyName: string;
    procedure set_SigningKeyName(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_SignatureFormatValidator: DDN.mscorlib.DNFunc<DNSignedXml, Boolean>;
    procedure set_SignatureFormatValidator(value: DDN.mscorlib.DNFunc<DNSignedXml, Boolean>);
    function get_SafeCanonicalizationMethods: DDN.mscorlib.DNCollection<string>;
    function get_SigningKey: DDN.mscorlib.DNAsymmetricAlgorithm;
    procedure set_SigningKey(value: DDN.mscorlib.DNAsymmetricAlgorithm);
    function get_EncryptedXml: DNEncryptedXml;
    procedure set_EncryptedXml(value: DNEncryptedXml);
    function get_Signature: DNSignature;
    function get_SignedInfo: DNSignedInfo;
    function get_SignatureMethod: string;
    function get_SignatureLength: string;
    function get_SignatureValue: TArray<Byte>;
    function get_KeyInfo: DNKeyInfo;
    procedure set_KeyInfo(value: DNKeyInfo);

  { methods } 

    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadXml(value: DDN.System.Xml.DNXmlElement);
    procedure AddReference(reference: DNReference);
    procedure AddObject(dataObject: DNDataObject);
    function CheckSignature: Boolean; overload;
    function CheckSignatureReturningKey(out signingKey: DDN.mscorlib.DNAsymmetricAlgorithm): Boolean;
    function GetIdElement(document: DDN.System.Xml.DNXmlDocument; idValue: string): DDN.System.Xml.DNXmlElement;
    function CheckSignature(key: DDN.mscorlib.DNAsymmetricAlgorithm): Boolean; overload;
    function CheckSignature(macAlg: DDN.mscorlib.DNKeyedHashAlgorithm): Boolean; overload;
    function CheckSignature(certificate: DDN.System.DNX509Certificate2; verifySignatureOnly: Boolean): Boolean; overload;
    procedure ComputeSignature; overload;
    procedure ComputeSignature(macAlg: DDN.mscorlib.DNKeyedHashAlgorithm); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property SigningKeyName: string read get_SigningKeyName write set_SigningKeyName;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property SignatureFormatValidator: DDN.mscorlib.DNFunc<DNSignedXml, Boolean> read get_SignatureFormatValidator write set_SignatureFormatValidator;
    property SafeCanonicalizationMethods: DDN.mscorlib.DNCollection<string> read get_SafeCanonicalizationMethods;
    property SigningKey: DDN.mscorlib.DNAsymmetricAlgorithm read get_SigningKey write set_SigningKey;
    property EncryptedXml: DNEncryptedXml read get_EncryptedXml write set_EncryptedXml;
    property Signature: DNSignature read get_Signature;
    property SignedInfo: DNSignedInfo read get_SignedInfo;
    property SignatureMethod: string read get_SignatureMethod;
    property SignatureLength: string read get_SignatureLength;
    property SignatureValue: TArray<Byte> read get_SignatureValue;
    property KeyInfo: DNKeyInfo read get_KeyInfo write set_KeyInfo;
  end;

  TDNSignedXml = class(TDNGenericImport<DNSignedXmlClass, DNSignedXml>)
  public const
   XmlDsigNamespaceUrl = 'http://www.w3.org/2000/09/xmldsig#';
   XmlDsigMinimalCanonicalizationUrl = 'http://www.w3.org/2000/09/xmldsig#minimal';
   XmlDsigCanonicalizationUrl = 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315';
   XmlDsigCanonicalizationWithCommentsUrl = 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments';
   XmlDsigSHA1Url = 'http://www.w3.org/2000/09/xmldsig#sha1';
   XmlDsigDSAUrl = 'http://www.w3.org/2000/09/xmldsig#dsa-sha1';
   XmlDsigRSASHA1Url = 'http://www.w3.org/2000/09/xmldsig#rsa-sha1';
   XmlDsigHMACSHA1Url = 'http://www.w3.org/2000/09/xmldsig#hmac-sha1';
   XmlDsigSHA256Url = 'http://www.w3.org/2001/04/xmlenc#sha256';
   XmlDsigRSASHA256Url = 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha256';
   XmlDsigSHA384Url = 'http://www.w3.org/2001/04/xmldsig-more#sha384';
   XmlDsigRSASHA384Url = 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha384';
   XmlDsigSHA512Url = 'http://www.w3.org/2001/04/xmlenc#sha512';
   XmlDsigRSASHA512Url = 'http://www.w3.org/2001/04/xmldsig-more#rsa-sha512';
   XmlDsigC14NTransformUrl = 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315';
   XmlDsigC14NWithCommentsTransformUrl = 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments';
   XmlDsigExcC14NTransformUrl = 'http://www.w3.org/2001/10/xml-exc-c14n#';
   XmlDsigExcC14NWithCommentsTransformUrl = 'http://www.w3.org/2001/10/xml-exc-c14n#WithComments';
   XmlDsigBase64TransformUrl = 'http://www.w3.org/2000/09/xmldsig#base64';
   XmlDsigXPathTransformUrl = 'http://www.w3.org/TR/1999/REC-xpath-19991116';
   XmlDsigXsltTransformUrl = 'http://www.w3.org/TR/1999/REC-xslt-19991116';
   XmlDsigEnvelopedSignatureTransformUrl = 'http://www.w3.org/2000/09/xmldsig#enveloped-signature';
   XmlDecryptionTransformUrl = 'http://www.w3.org/2002/07/decrypt#XML';
   XmlLicenseTransformUrl = 'urn:mpeg:mpeg21:2003:01-REL-R-NS:licenseTransform';
  end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNTransformClass = interface(DDN.mscorlib.DNObjectClass)
  ['{9639F76D-E045-542E-BB01-D805832B15F7}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.Transform')]
  DNTransform = interface(DDN.mscorlib.DNObject)
  ['{FCC012EE-C0D6-3B96-BD98-4A0A4B09DA94}']
  { getters & setters } 

    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    function GetXml: DDN.System.Xml.DNXmlElement;
    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNTransform = class(TDNGenericImport<DNTransformClass, DNTransform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNXmlDecryptionTransformClass = interface(DNTransformClass)
  ['{C77D5C80-A847-5889-A9AF-C8D97E691D2A}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNXmlDecryptionTransform;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.XmlDecryptionTransform')]
  DNXmlDecryptionTransform = interface(DNTransform)
  ['{25256B07-B936-38A9-A6A6-D70FE943EB4F}']
  { getters & setters } 

    function get_EncryptedXml: DNEncryptedXml;
    procedure set_EncryptedXml(value: DNEncryptedXml);
    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    procedure AddExceptUri(uri: string);
    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property EncryptedXml: DNEncryptedXml read get_EncryptedXml write set_EncryptedXml;
    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNXmlDecryptionTransform = class(TDNGenericImport<DNXmlDecryptionTransformClass, DNXmlDecryptionTransform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNXmlDsigBase64TransformClass = interface(DNTransformClass)
  ['{20CC692A-E057-580E-AFD7-F0FACFC88FE1}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNXmlDsigBase64Transform;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.XmlDsigBase64Transform')]
  DNXmlDsigBase64Transform = interface(DNTransform)
  ['{CC6B5E88-1E4A-3753-A872-B6AD4885E573}']
  { getters & setters } 

    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNXmlDsigBase64Transform = class(TDNGenericImport<DNXmlDsigBase64TransformClass, DNXmlDsigBase64Transform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNXmlDsigC14NTransformClass = interface(DNTransformClass)
  ['{4215E3DB-7F42-5695-950B-6103F62AEE24}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNXmlDsigC14NTransform; overload;
    {class} function init(includeComments: Boolean): DNXmlDsigC14NTransform; overload;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.XmlDsigC14NTransform')]
  DNXmlDsigC14NTransform = interface(DNTransform)
  ['{5D53B79A-51F8-3501-AD4A-58C9EC56C5E1}']
  { getters & setters } 

    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNXmlDsigC14NTransform = class(TDNGenericImport<DNXmlDsigC14NTransformClass, DNXmlDsigC14NTransform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNXmlDsigC14NWithCommentsTransformClass = interface(DNXmlDsigC14NTransformClass)
  ['{E1F18D8E-7B16-5E64-9837-D1AAB5C0AF7A}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNXmlDsigC14NWithCommentsTransform;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.XmlDsigC14NWithCommentsTransform')]
  DNXmlDsigC14NWithCommentsTransform = interface(DNXmlDsigC14NTransform)
  ['{8A2CD598-015C-3B4D-A54A-DD15B27F9468}']
  { getters & setters } 

    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNXmlDsigC14NWithCommentsTransform = class(TDNGenericImport<DNXmlDsigC14NWithCommentsTransformClass, DNXmlDsigC14NWithCommentsTransform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNXmlDsigEnvelopedSignatureTransformClass = interface(DNTransformClass)
  ['{9A66ACE3-E412-50EF-A98D-443DCCBE3AC2}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNXmlDsigEnvelopedSignatureTransform; overload;
    {class} function init(includeComments: Boolean): DNXmlDsigEnvelopedSignatureTransform; overload;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.XmlDsigEnvelopedSignatureTransform')]
  DNXmlDsigEnvelopedSignatureTransform = interface(DNTransform)
  ['{AC3C0557-1DB7-3B2A-9C15-6A40B07CF03B}']
  { getters & setters } 

    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNXmlDsigEnvelopedSignatureTransform = class(TDNGenericImport<DNXmlDsigEnvelopedSignatureTransformClass, DNXmlDsigEnvelopedSignatureTransform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNXmlDsigExcC14NTransformClass = interface(DNTransformClass)
  ['{D3C6537A-DF78-59B0-9C95-F0BFC8084C94}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNXmlDsigExcC14NTransform; overload;
    {class} function init(includeComments: Boolean): DNXmlDsigExcC14NTransform; overload;
    {class} function init(inclusiveNamespacesPrefixList: string): DNXmlDsigExcC14NTransform; overload;
    {class} function init(includeComments: Boolean; inclusiveNamespacesPrefixList: string): DNXmlDsigExcC14NTransform; overload;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.XmlDsigExcC14NTransform')]
  DNXmlDsigExcC14NTransform = interface(DNTransform)
  ['{330A5D1D-DD87-3D52-A8F6-291C8E8CA290}']
  { getters & setters } 

    function get_InclusiveNamespacesPrefixList: string;
    procedure set_InclusiveNamespacesPrefixList(value: string);
    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InclusiveNamespacesPrefixList: string read get_InclusiveNamespacesPrefixList write set_InclusiveNamespacesPrefixList;
    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNXmlDsigExcC14NTransform = class(TDNGenericImport<DNXmlDsigExcC14NTransformClass, DNXmlDsigExcC14NTransform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNXmlDsigExcC14NWithCommentsTransformClass = interface(DNXmlDsigExcC14NTransformClass)
  ['{48111CF4-C284-550D-AEAC-BCCAD1B7D430}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNXmlDsigExcC14NWithCommentsTransform; overload;
    {class} function init(inclusiveNamespacesPrefixList: string): DNXmlDsigExcC14NWithCommentsTransform; overload;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.XmlDsigExcC14NWithCommentsTransform')]
  DNXmlDsigExcC14NWithCommentsTransform = interface(DNXmlDsigExcC14NTransform)
  ['{5EEAA1EA-F3A2-322C-B534-A4A63085BDBB}']
  { getters & setters } 

    function get_InclusiveNamespacesPrefixList: string;
    procedure set_InclusiveNamespacesPrefixList(value: string);
    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InclusiveNamespacesPrefixList: string read get_InclusiveNamespacesPrefixList write set_InclusiveNamespacesPrefixList;
    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNXmlDsigExcC14NWithCommentsTransform = class(TDNGenericImport<DNXmlDsigExcC14NWithCommentsTransformClass, DNXmlDsigExcC14NWithCommentsTransform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNXmlDsigXPathTransformClass = interface(DNTransformClass)
  ['{0F5878B6-A1C5-546E-9BBD-E736BC97F9CC}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNXmlDsigXPathTransform;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.XmlDsigXPathTransform')]
  DNXmlDsigXPathTransform = interface(DNTransform)
  ['{8A024016-CC3D-3FD0-A9AD-5E64370CBFFE}']
  { getters & setters } 

    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNXmlDsigXPathTransform = class(TDNGenericImport<DNXmlDsigXPathTransformClass, DNXmlDsigXPathTransform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNXmlDsigXsltTransformClass = interface(DNTransformClass)
  ['{7EA941B3-2F1E-58E1-8D0F-CA6544FD17A5}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNXmlDsigXsltTransform; overload;
    {class} function init(includeComments: Boolean): DNXmlDsigXsltTransform; overload;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.XmlDsigXsltTransform')]
  DNXmlDsigXsltTransform = interface(DNTransform)
  ['{0C0220F2-7A67-3D12-8159-6516E01FA7E4}']
  { getters & setters } 

    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNXmlDsigXsltTransform = class(TDNGenericImport<DNXmlDsigXsltTransformClass, DNXmlDsigXsltTransform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNXmlLicenseTransformClass = interface(DNTransformClass)
  ['{542DB4E2-FB7B-5725-B1E3-D67975D1B946}']
  { static getter & setter } 

    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);

  { constructors } 

    {class} function init: DNXmlLicenseTransform;

  { static propertys } 

    {class} property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
  end;

  [DNTypeName('System.Security.Cryptography.Xml.XmlLicenseTransform')]
  DNXmlLicenseTransform = interface(DNTransform)
  ['{B828D115-C2A3-3B4D-A717-9FB0462E57B4}']
  { getters & setters } 

    function get_InputTypes: TArray<DDN.mscorlib.DNType>;
    function get_OutputTypes: TArray<DDN.mscorlib.DNType>;
    function get_Decryptor: DNIRelDecryptor;
    procedure set_Decryptor(value: DNIRelDecryptor);
    function get_Algorithm: string;
    procedure set_Algorithm(value: string);
    procedure set_Resolver(value: DDN.System.Xml.DNXmlResolver);
    function get_Context: DDN.System.Xml.DNXmlElement;
    procedure set_Context(value: DDN.System.Xml.DNXmlElement);
    function get_PropagatedNamespaces: DDN.mscorlib.DNHashtable;

  { methods } 

    function GetOutput: DDN.mscorlib.DNObject; overload;
    function GetOutput(&type: DDN.mscorlib.DNType): DDN.mscorlib.DNObject; overload;
    procedure LoadInnerXml(nodeList: DDN.System.Xml.DNXmlNodeList);
    procedure LoadInput(obj: DDN.mscorlib.DNObject);
    function GetDigestedOutput(hash: DDN.mscorlib.DNHashAlgorithm): TArray<Byte>;
    function GetXml: DDN.System.Xml.DNXmlElement;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property InputTypes: TArray<DDN.mscorlib.DNType> read get_InputTypes;
    property OutputTypes: TArray<DDN.mscorlib.DNType> read get_OutputTypes;
    property Decryptor: DNIRelDecryptor read get_Decryptor write set_Decryptor;
    property Algorithm: string read get_Algorithm write set_Algorithm;
    property Resolver: DDN.System.Xml.DNXmlResolver write set_Resolver;
    property Context: DDN.System.Xml.DNXmlElement read get_Context write set_Context;
    property PropagatedNamespaces: DDN.mscorlib.DNHashtable read get_PropagatedNamespaces;
  end;

  TDNXmlLicenseTransform = class(TDNGenericImport<DNXmlLicenseTransformClass, DNXmlLicenseTransform>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNTransformChainClass = interface(DDN.mscorlib.DNObjectClass)
  ['{1CEDE88F-1E8A-57B7-9DDB-85B3A20147B3}']
  { constructors } 

    {class} function init: DNTransformChain;

  end;

  [DNTypeName('System.Security.Cryptography.Xml.TransformChain')]
  DNTransformChain = interface(DDN.mscorlib.DNObject)
  ['{E4668765-48E0-391C-BD17-BF1BBEFB1F6C}']
  { getters & setters } 

    function get_Count: Int32;
    function get_Item(index: Int32): DNTransform;

  { methods } 

    procedure Add(transform: DNTransform);
    function GetEnumerator: DDN.mscorlib.DNIEnumerator;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Count: Int32 read get_Count;
    property Item[index: Int32]: DNTransform read get_Item; default;
  end;

  TDNTransformChain = class(TDNGenericImport<DNTransformChainClass, DNTransformChain>) end;

  //-------------namespace: System.Security.Cryptography.Xml----------------
  DNX509IssuerSerialClass = interface(DDN.mscorlib.DNValueTypeClass)
  ['{F565DD75-E9B9-5954-8609-296D00DE2C57}']
  end;

  [DNTypeName('System.Security.Cryptography.Xml.X509IssuerSerial')]
  DNX509IssuerSerial = interface(DDN.mscorlib.DNValueType)
  ['{157BE144-3AED-330B-B384-E54129500F99}']
  { getters & setters } 

    function get_IssuerName: string;
    procedure set_IssuerName(value: string);
    function get_SerialNumber: string;
    procedure set_SerialNumber(value: string);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function ToString: string;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    property IssuerName: string read get_IssuerName write set_IssuerName;
    property SerialNumber: string read get_SerialNumber write set_SerialNumber;
  end;

  TDNX509IssuerSerial = class(TDNGenericImport<DNX509IssuerSerialClass, DNX509IssuerSerial>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
