//----------------------------------------------------------------------------
//  System.Transactions.Local.dll: System.Transactions.Local, Version=4.0.2.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Transactions.Local
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Transactions.Local;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type

{ enums }

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.DependentCloneOption')]
  DNDependentCloneOption = type Integer;
  DNDependentCloneOptionHelper = record helper for DNDependentCloneOption
  public const
    BlockCommitUntilComplete = 0;
    RollbackIfNotComplete = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.EnlistmentOptions')]
  DNEnlistmentOptions = type Integer;
  DNEnlistmentOptionsHelper = record helper for DNEnlistmentOptions
  public const
    None = 0;
    EnlistDuringPrepareRequired = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.EnterpriseServicesInteropOption')]
  DNEnterpriseServicesInteropOption = type Integer;
  DNEnterpriseServicesInteropOptionHelper = record helper for DNEnterpriseServicesInteropOption
  public const
    None = 0;
    Automatic = 1;
    Full = 2;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IsolationLevel')]
  DNIsolationLevel = type Integer;
  DNIsolationLevelHelper = record helper for DNIsolationLevel
  public const
    Serializable = 0;
    RepeatableRead = 1;
    ReadCommitted = 2;
    ReadUncommitted = 3;
    Snapshot = 4;
    Chaos = 5;
    Unspecified = 6;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionScopeAsyncFlowOption')]
  DNTransactionScopeAsyncFlowOption = type Integer;
  DNTransactionScopeAsyncFlowOptionHelper = record helper for DNTransactionScopeAsyncFlowOption
  public const
    Suppress = 0;
    Enabled = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionScopeOption')]
  DNTransactionScopeOption = type Integer;
  DNTransactionScopeOptionHelper = record helper for DNTransactionScopeOption
  public const
    Required = 0;
    RequiresNew = 1;
    Suppress = 2;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionStatus')]
  DNTransactionStatus = type Integer;
  DNTransactionStatusHelper = record helper for DNTransactionStatus
  public const
    Active = 0;
    Committed = 1;
    Aborted = 2;
    InDoubt = 3;
  end;




type


{ declares }

  DNIDtcTransaction = interface; // type: System.Transactions.IDtcTransaction, namespace: System.Transactions
  DNIEnlistmentNotification = interface; // type: System.Transactions.IEnlistmentNotification, namespace: System.Transactions
  DNISinglePhaseNotification = interface; // type: System.Transactions.ISinglePhaseNotification, namespace: System.Transactions
  DNITransactionPromoter = interface; // type: System.Transactions.ITransactionPromoter, namespace: System.Transactions
  DNIPromotableSinglePhaseNotification = interface; // type: System.Transactions.IPromotableSinglePhaseNotification, namespace: System.Transactions
  DNISimpleTransactionSuperior = interface; // type: System.Transactions.ISimpleTransactionSuperior, namespace: System.Transactions
  DNTransactionEventArgs = interface; // type: System.Transactions.TransactionEventArgs, namespace: System.Transactions
  DNTransactionException = interface; // type: System.Transactions.TransactionException, namespace: System.Transactions
  DNTransactionAbortedException = interface; // type: System.Transactions.TransactionAbortedException, namespace: System.Transactions
  DNTransactionInDoubtException = interface; // type: System.Transactions.TransactionInDoubtException, namespace: System.Transactions
  DNTransactionManagerCommunicationException = interface; // type: System.Transactions.TransactionManagerCommunicationException, namespace: System.Transactions
  DNTransactionPromotionException = interface; // type: System.Transactions.TransactionPromotionException, namespace: System.Transactions
  DNEnlistment = interface; // type: System.Transactions.Enlistment, namespace: System.Transactions
  DNPreparingEnlistment = interface; // type: System.Transactions.PreparingEnlistment, namespace: System.Transactions
  DNSinglePhaseEnlistment = interface; // type: System.Transactions.SinglePhaseEnlistment, namespace: System.Transactions
  DNTransaction = interface; // type: System.Transactions.Transaction, namespace: System.Transactions
  DNCommittableTransaction = interface; // type: System.Transactions.CommittableTransaction, namespace: System.Transactions
  DNDependentTransaction = interface; // type: System.Transactions.DependentTransaction, namespace: System.Transactions
  DNSubordinateTransaction = interface; // type: System.Transactions.SubordinateTransaction, namespace: System.Transactions
  DNTransactionInformation = interface; // type: System.Transactions.TransactionInformation, namespace: System.Transactions
  DNTransactionInterop = interface; // type: System.Transactions.TransactionInterop, namespace: System.Transactions
  DNTransactionManager = interface; // type: System.Transactions.TransactionManager, namespace: System.Transactions
  DNTransactionScope = interface; // type: System.Transactions.TransactionScope, namespace: System.Transactions
  DNTransactionOptions = interface; // type: System.Transactions.TransactionOptions, namespace: System.Transactions

{ delegates }

  [DNTypeName('System.Transactions.HostCurrentTransactionCallback')]
  DNHostCurrentTransactionCallback = function: DNTransaction of object;

  [DNTypeName('System.Transactions.TransactionCompletedEventHandler')]
  DNTransactionCompletedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNTransactionEventArgs) of object;

  [DNTypeName('System.Transactions.TransactionStartedEventHandler')]
  DNTransactionStartedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNTransactionEventArgs) of object;




{ objects }

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IDtcTransaction')]
  DNIDtcTransaction = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{0FB15084-AF41-11CE-BD2B-204C4F4F5020}']
  { methods } 

    procedure Commit(retaining: Int32; commitType: Int32; reserved: Int32);
    procedure &Abort(reason: IntPtr; retaining: Int32; async: Int32);
    procedure GetTransactionInfo(transactionInformation: IntPtr);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IEnlistmentNotification')]
  DNIEnlistmentNotification = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{68723FCB-A005-3CD5-AF43-E27703E304F2}']
  { methods } 

    procedure Prepare(preparingEnlistment: DNPreparingEnlistment);
    procedure Commit(enlistment: DNEnlistment);
    procedure Rollback(enlistment: DNEnlistment);
    procedure InDoubt(enlistment: DNEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ISinglePhaseNotification')]
  DNISinglePhaseNotification = interface(DNIEnlistmentNotification)
  ['{2354C464-7457-3AE8-AF68-751AF5A1FFC0}']
  { methods } 

    procedure SinglePhaseCommit(singlePhaseEnlistment: DNSinglePhaseEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ITransactionPromoter')]
  DNITransactionPromoter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{2EE24BD6-197C-3BD2-ABB2-03F7113E3B60}']
  { methods } 

    function Promote: TArray<Byte>;

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IPromotableSinglePhaseNotification')]
  DNIPromotableSinglePhaseNotification = interface(DNITransactionPromoter)
  ['{5C25E3AA-572A-331E-88C5-CD69DCEF4C71}']
  { methods } 

    procedure Initialize;
    procedure SinglePhaseCommit(singlePhaseEnlistment: DNSinglePhaseEnlistment);
    procedure Rollback(singlePhaseEnlistment: DNSinglePhaseEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ISimpleTransactionSuperior')]
  DNISimpleTransactionSuperior = interface(DNITransactionPromoter)
  ['{8C30F42C-7396-303C-89E2-3EB683EF53BD}']
  { methods } 

    procedure Rollback;

  end;

  //-------------namespace: System.Transactions----------------
  DNTransactionEventArgsClass = interface(DDNC.System.Private.CoreLib.DNEventArgsClass)
  ['{7BD11E73-77CF-513E-B2CA-C1DDD8B28AF1}']
  { constructors } 

    {class} function init: DNTransactionEventArgs;

  end;

  [DNTypeName('System.Transactions.TransactionEventArgs')]
  DNTransactionEventArgs = interface(DDNC.System.Private.CoreLib.DNEventArgs)
  ['{B57889B9-7AE6-3DD7-8BAA-70E956F44511}']
  { getters & setters } 

    function get_Transaction: DNTransaction;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Transaction: DNTransaction read get_Transaction;
  end;

  TDNTransactionEventArgs = class(TDNGenericImport<DNTransactionEventArgsClass, DNTransactionEventArgs>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionExceptionClass = interface(DDNC.System.Private.CoreLib.DNSystemExceptionClass)
  ['{F4418FE2-26EA-592D-92DF-F9A04FBBB1E9}']
  { constructors } 

    {class} function init: DNTransactionException; overload;
    {class} function init(message: string): DNTransactionException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionException')]
  DNTransactionException = interface(DDNC.System.Private.CoreLib.DNSystemException)
  ['{452957D9-088B-3A5E-81E2-E339DF393264}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNTransactionException = class(TDNGenericImport<DNTransactionExceptionClass, DNTransactionException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionAbortedExceptionClass = interface(DNTransactionExceptionClass)
  ['{D4C96063-8CAC-5CC7-A2DC-5252B5A6DA90}']
  { constructors } 

    {class} function init: DNTransactionAbortedException; overload;
    {class} function init(message: string): DNTransactionAbortedException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionAbortedException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionAbortedException')]
  DNTransactionAbortedException = interface(DNTransactionException)
  ['{BB99B33D-88A4-33DD-B2C9-332299018FD3}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNTransactionAbortedException = class(TDNGenericImport<DNTransactionAbortedExceptionClass, DNTransactionAbortedException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInDoubtExceptionClass = interface(DNTransactionExceptionClass)
  ['{5D3ABB64-D7F6-56A5-A634-B8F33B494B07}']
  { constructors } 

    {class} function init: DNTransactionInDoubtException; overload;
    {class} function init(message: string): DNTransactionInDoubtException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionInDoubtException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionInDoubtException')]
  DNTransactionInDoubtException = interface(DNTransactionException)
  ['{02BFA2F8-5F8A-3CF9-96EE-917243F0BA96}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNTransactionInDoubtException = class(TDNGenericImport<DNTransactionInDoubtExceptionClass, DNTransactionInDoubtException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionManagerCommunicationExceptionClass = interface(DNTransactionExceptionClass)
  ['{F449C896-DEBB-5E68-BCCA-888D168A7CFB}']
  { constructors } 

    {class} function init: DNTransactionManagerCommunicationException; overload;
    {class} function init(message: string): DNTransactionManagerCommunicationException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionManagerCommunicationException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionManagerCommunicationException')]
  DNTransactionManagerCommunicationException = interface(DNTransactionException)
  ['{15D99DB0-2738-320F-AB2B-15471BB60941}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNTransactionManagerCommunicationException = class(TDNGenericImport<DNTransactionManagerCommunicationExceptionClass, DNTransactionManagerCommunicationException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionPromotionExceptionClass = interface(DNTransactionExceptionClass)
  ['{DE2314C2-8D88-521F-A5E6-2DCFA6FB9A3F}']
  { constructors } 

    {class} function init: DNTransactionPromotionException; overload;
    {class} function init(message: string): DNTransactionPromotionException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionPromotionException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionPromotionException')]
  DNTransactionPromotionException = interface(DNTransactionException)
  ['{6024110A-C4E3-3D8C-9A0F-D4F805470C0B}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNTransactionPromotionException = class(TDNGenericImport<DNTransactionPromotionExceptionClass, DNTransactionPromotionException>) end;

  //-------------namespace: System.Transactions----------------
  DNEnlistmentClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{D3878869-36CA-54AA-BEAD-65A3E08C8490}']
  end;

  [DNTypeName('System.Transactions.Enlistment')]
  DNEnlistment = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{7423C29E-CE00-3C2C-8F08-FCCAC93AC2DC}']
  { methods } 

    procedure Done;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNEnlistment = class(TDNGenericImport<DNEnlistmentClass, DNEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNPreparingEnlistmentClass = interface(DNEnlistmentClass)
  ['{E011637C-0ADA-5C2C-BC5F-039D6AA00C10}']
  end;

  [DNTypeName('System.Transactions.PreparingEnlistment')]
  DNPreparingEnlistment = interface(DNEnlistment)
  ['{927FD970-2CDE-3C99-852B-8DD6181CD319}']
  { methods } 

    procedure Prepared;
    procedure ForceRollback; overload;
    procedure ForceRollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function RecoveryInformation: TArray<Byte>;
    procedure Done;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNPreparingEnlistment = class(TDNGenericImport<DNPreparingEnlistmentClass, DNPreparingEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNSinglePhaseEnlistmentClass = interface(DNEnlistmentClass)
  ['{59CE2F86-10DC-57EB-B84F-C3D853B5A7E3}']
  end;

  [DNTypeName('System.Transactions.SinglePhaseEnlistment')]
  DNSinglePhaseEnlistment = interface(DNEnlistment)
  ['{781E336B-5FF7-3611-9B7D-80DE02C08B4F}']
  { methods } 

    procedure Aborted; overload;
    procedure Aborted(e: DDNC.System.Private.CoreLib.DNException); overload;
    procedure Committed;
    procedure InDoubt; overload;
    procedure InDoubt(e: DDNC.System.Private.CoreLib.DNException); overload;
    procedure Done;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNSinglePhaseEnlistment = class(TDNGenericImport<DNSinglePhaseEnlistmentClass, DNSinglePhaseEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionClass = interface(DNObjectClass)
  ['{4F9E4B3B-E4B4-5FAD-8E86-BA1C0684458B}']
  { static getter & setter } 

    {class} function get_Current: DNTransaction;
    {class} procedure set_Current(value: DNTransaction);

  { static propertys } 

    {class} property Current: DNTransaction read get_Current write set_Current;
  end;

  [DNTypeName('System.Transactions.Transaction')]
  DNTransaction = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{E50501C6-EA38-3E64-9358-95AB41C99F52}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNTransaction = class(TDNGenericImport<DNTransactionClass, DNTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNCommittableTransactionClass = interface(DNTransactionClass)
  ['{40AF0D36-AFFF-59F0-86B2-ED6EF84FFE43}']
  { constructors } 

    {class} function init: DNCommittableTransaction; overload;
    {class} function init(timeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNCommittableTransaction; overload;
    {class} function init(options: DNTransactionOptions): DNCommittableTransaction; overload;

  end;

  [DNTypeName('System.Transactions.CommittableTransaction')]
  DNCommittableTransaction = interface(DNTransaction)
  ['{8C0C032E-11C6-312A-8240-81B1C9FB02C2}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function BeginCommit(asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure Commit;
    procedure EndCommit(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNCommittableTransaction = class(TDNGenericImport<DNCommittableTransactionClass, DNCommittableTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNDependentTransactionClass = interface(DNTransactionClass)
  ['{0911628A-871B-509F-89EA-A24247C8E1C1}']
  end;

  [DNTypeName('System.Transactions.DependentTransaction')]
  DNDependentTransaction = interface(DNTransaction)
  ['{5E6009D4-5666-3060-B36E-A9378C6E7F19}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    procedure Complete;
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNDependentTransaction = class(TDNGenericImport<DNDependentTransactionClass, DNDependentTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNSubordinateTransactionClass = interface(DNTransactionClass)
  ['{3ECB2909-62F1-535A-98FF-DD7B89365668}']
  { constructors } 

    {class} function init(isoLevel: DNIsolationLevel; superior: DNISimpleTransactionSuperior): DNSubordinateTransaction;

  end;

  [DNTypeName('System.Transactions.SubordinateTransaction')]
  DNSubordinateTransaction = interface(DNTransaction)
  ['{14847D60-9FD8-33DE-A525-EFB375F35AE3}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNSubordinateTransaction = class(TDNGenericImport<DNSubordinateTransactionClass, DNSubordinateTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInformationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{231D7F44-2911-51D1-AA7E-65E5C3AFAC7D}']
  end;

  [DNTypeName('System.Transactions.TransactionInformation')]
  DNTransactionInformation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{EDF184A3-795A-3231-9686-C3E784EDD013}']
  { getters & setters } 

    function get_LocalIdentifier: string;
    function get_DistributedIdentifier: DDNC.System.Private.CoreLib.DNGuid;
    function get_CreationTime: DDNC.System.Private.CoreLib.DNDateTime;
    function get_Status: DNTransactionStatus;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property LocalIdentifier: string read get_LocalIdentifier;
    property DistributedIdentifier: DDNC.System.Private.CoreLib.DNGuid read get_DistributedIdentifier;
    property CreationTime: DDNC.System.Private.CoreLib.DNDateTime read get_CreationTime;
    property Status: DNTransactionStatus read get_Status;
  end;

  TDNTransactionInformation = class(TDNGenericImport<DNTransactionInformationClass, DNTransactionInformation>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInteropClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{961ACC86-ED72-5653-ACA6-DFBA15E6CDAA}']
  { static fields getter & setter } 

   function __fakeFieldGet_PromoterTypeDtc: DDNC.System.Private.CoreLib.DNGuid;

  { static fields } 

    {class} property PromoterTypeDtc: DDNC.System.Private.CoreLib.DNGuid read __fakeFieldGet_PromoterTypeDtc;

  { static methods } 

    {class} function GetExportCookie(transaction: DNTransaction; whereabouts: TArray<Byte>): TArray<Byte>;
    {class} function GetTransactionFromExportCookie(cookie: TArray<Byte>): DNTransaction;
    {class} function GetTransmitterPropagationToken(transaction: DNTransaction): TArray<Byte>;
    {class} function GetTransactionFromTransmitterPropagationToken(propagationToken: TArray<Byte>): DNTransaction;
    {class} function GetDtcTransaction(transaction: DNTransaction): DNIDtcTransaction;
    {class} function GetTransactionFromDtcTransaction(transactionNative: DNIDtcTransaction): DNTransaction;
    {class} function GetWhereabouts: TArray<Byte>;

  end;

  [DNTypeName('System.Transactions.TransactionInterop')]
  DNTransactionInterop = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{2DF960D1-5B83-3EA4-BD60-0054D6562349}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNTransactionInterop = class(TDNGenericImport<DNTransactionInteropClass, DNTransactionInterop>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionManagerClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{A393AC98-A140-5EBD-A710-2FAC68BC37A2}']
  { static getter & setter } 

    {class} function get_HostCurrentCallback: DNHostCurrentTransactionCallback;
    {class} procedure set_HostCurrentCallback(value: DNHostCurrentTransactionCallback);
    {class} function get_DefaultTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    {class} function get_MaximumTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;

  { static methods } 

    {class} function Reenlist(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; recoveryInformation: TArray<Byte>; enlistmentNotification: DNIEnlistmentNotification): DNEnlistment;
    {class} procedure RecoveryComplete(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid);

  { static propertys } 

    {class} property HostCurrentCallback: DNHostCurrentTransactionCallback read get_HostCurrentCallback write set_HostCurrentCallback;
    {class} property DefaultTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_DefaultTimeout;
    {class} property MaximumTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_MaximumTimeout;
  end;

  [DNTypeName('System.Transactions.TransactionManager')]
  DNTransactionManager = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E756EE0F-798C-30CA-911C-EF1DEEEF12FA}']
  { events } 

    {class} procedure add_DistributedTransactionStarted(value: DNTransactionStartedEventHandler);
    {class} procedure remove_DistributedTransactionStarted(value: DNTransactionStartedEventHandler);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNTransactionManager = class(TDNGenericImport<DNTransactionManagerClass, DNTransactionManager>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionScopeClass = interface(DNObjectClass)
  ['{1F0D6A74-B89A-50F1-B6AE-E9113E2D06E4}']
  { constructors } 

    {class} function init: DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption): DNTransactionScope; overload;
    {class} function init(asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions; interopOption: DNEnterpriseServicesInteropOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan; interopOption: DNEnterpriseServicesInteropOption): DNTransactionScope; overload;

  end;

  [DNTypeName('System.Transactions.TransactionScope')]
  DNTransactionScope = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{6F5CC938-BF9B-348E-93E8-9FC0713727CE}']
  { methods } 

    procedure Dispose;
    procedure Complete;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNTransactionScope = class(TDNGenericImport<DNTransactionScopeClass, DNTransactionScope>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionOptionsClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{4B863F41-836D-5B8D-A40C-F442AE71D104}']
  end;

  [DNTypeName('System.Transactions.TransactionOptions')]
  DNTransactionOptions = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{1611330D-B209-32C7-9871-CBD937592EB6}']
  { getters & setters } 

    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_IsolationLevel: DNIsolationLevel;
    procedure set_IsolationLevel(value: DNIsolationLevel);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel write set_IsolationLevel;
  end;

  TDNTransactionOptions = class(TDNGenericImport<DNTransactionOptionsClass, DNTransactionOptions>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Transactions.Local, Version=4.0.2.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51');

finalization

end.
