//----------------------------------------------------------------------------
//  System.Security.Cryptography.X509Certificates.dll: System.Security.Cryptography.X509Certificates, Version=4.2.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.Cryptography.X509Certificates
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.Cryptography.X509Certificates;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Collections.NonGeneric,
  DDNC.System.Security.Cryptography.Encoding,
  DDNC.System.Security.Cryptography.Algorithms,
  DDNC.System.Security.Cryptography.Primitives,
  DDNC.System.Private.Uri,
  DDNC.System.Net.Primitives;

type

{ enums }

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.OpenFlags')]
  DNOpenFlags = type Integer;
  DNOpenFlagsHelper = record helper for DNOpenFlags
  public const
    ReadOnly = 0;
    ReadWrite = 1;
    MaxAllowed = 2;
    OpenExistingOnly = 4;
    IncludeArchived = 8;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.StoreLocation')]
  DNStoreLocation = type Integer;
  DNStoreLocationHelper = record helper for DNStoreLocation
  public const
    CurrentUser = 1;
    LocalMachine = 2;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.StoreName')]
  DNStoreName = type Integer;
  DNStoreNameHelper = record helper for DNStoreName
  public const
    AddressBook = 1;
    AuthRoot = 2;
    CertificateAuthority = 3;
    Disallowed = 4;
    My = 5;
    Root = 6;
    TrustedPeople = 7;
    TrustedPublisher = 8;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X500DistinguishedNameFlags')]
  DNX500DistinguishedNameFlags = type Integer;
  DNX500DistinguishedNameFlagsHelper = record helper for DNX500DistinguishedNameFlags
  public const
    None = 0;
    Reversed = 1;
    UseSemicolons = 16;
    DoNotUsePlusSign = 32;
    DoNotUseQuotes = 64;
    UseCommas = 128;
    UseNewLines = 256;
    UseUTF8Encoding = 4096;
    UseT61Encoding = 8192;
    ForceUTF8Encoding = 16384;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509ChainStatusFlags')]
  DNX509ChainStatusFlags = type Integer;
  DNX509ChainStatusFlagsHelper = record helper for DNX509ChainStatusFlags
  public const
    NoError = 0;
    NotTimeValid = 1;
    NotTimeNested = 2;
    Revoked = 4;
    NotSignatureValid = 8;
    NotValidForUsage = 16;
    UntrustedRoot = 32;
    RevocationStatusUnknown = 64;
    Cyclic = 128;
    InvalidExtension = 256;
    InvalidPolicyConstraints = 512;
    InvalidBasicConstraints = 1024;
    InvalidNameConstraints = 2048;
    HasNotSupportedNameConstraint = 4096;
    HasNotDefinedNameConstraint = 8192;
    HasNotPermittedNameConstraint = 16384;
    HasExcludedNameConstraint = 32768;
    PartialChain = 65536;
    CtlNotTimeValid = 131072;
    CtlNotSignatureValid = 262144;
    CtlNotValidForUsage = 524288;
    HasWeakSignature = 1048576;
    OfflineRevocation = 16777216;
    NoIssuanceChainPolicy = 33554432;
    ExplicitDistrust = 67108864;
    HasNotSupportedCriticalExtension = 134217728;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509ContentType')]
  DNX509ContentType = type Integer;
  DNX509ContentTypeHelper = record helper for DNX509ContentType
  public const
    Unknown = 0;
    Cert = 1;
    SerializedCert = 2;
    Pfx = 3;
    Pkcs12 = 3;
    SerializedStore = 4;
    Pkcs7 = 5;
    Authenticode = 6;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509FindType')]
  DNX509FindType = type Integer;
  DNX509FindTypeHelper = record helper for DNX509FindType
  public const
    FindByThumbprint = 0;
    FindBySubjectName = 1;
    FindBySubjectDistinguishedName = 2;
    FindByIssuerName = 3;
    FindByIssuerDistinguishedName = 4;
    FindBySerialNumber = 5;
    FindByTimeValid = 6;
    FindByTimeNotYetValid = 7;
    FindByTimeExpired = 8;
    FindByTemplateName = 9;
    FindByApplicationPolicy = 10;
    FindByCertificatePolicy = 11;
    FindByExtension = 12;
    FindByKeyUsage = 13;
    FindBySubjectKeyIdentifier = 14;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509IncludeOption')]
  DNX509IncludeOption = type Integer;
  DNX509IncludeOptionHelper = record helper for DNX509IncludeOption
  public const
    None = 0;
    ExcludeRoot = 1;
    EndCertOnly = 2;
    WholeChain = 3;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509KeyStorageFlags')]
  DNX509KeyStorageFlags = type Integer;
  DNX509KeyStorageFlagsHelper = record helper for DNX509KeyStorageFlags
  public const
    DefaultKeySet = 0;
    UserKeySet = 1;
    MachineKeySet = 2;
    Exportable = 4;
    UserProtected = 8;
    PersistKeySet = 16;
    EphemeralKeySet = 32;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509KeyUsageFlags')]
  DNX509KeyUsageFlags = type Integer;
  DNX509KeyUsageFlagsHelper = record helper for DNX509KeyUsageFlags
  public const
    None = 0;
    EncipherOnly = 1;
    CrlSign = 2;
    KeyCertSign = 4;
    KeyAgreement = 8;
    DataEncipherment = 16;
    KeyEncipherment = 32;
    NonRepudiation = 64;
    DigitalSignature = 128;
    DecipherOnly = 32768;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509NameType')]
  DNX509NameType = type Integer;
  DNX509NameTypeHelper = record helper for DNX509NameType
  public const
    SimpleName = 0;
    EmailName = 1;
    UpnName = 2;
    DnsName = 3;
    DnsFromAlternativeName = 4;
    UrlName = 5;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509RevocationFlag')]
  DNX509RevocationFlag = type Integer;
  DNX509RevocationFlagHelper = record helper for DNX509RevocationFlag
  public const
    EndCertificateOnly = 0;
    EntireChain = 1;
    ExcludeRoot = 2;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509RevocationMode')]
  DNX509RevocationMode = type Integer;
  DNX509RevocationModeHelper = record helper for DNX509RevocationMode
  public const
    NoCheck = 0;
    Online = 1;
    Offline = 2;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509SubjectKeyIdentifierHashAlgorithm')]
  DNX509SubjectKeyIdentifierHashAlgorithm = type Integer;
  DNX509SubjectKeyIdentifierHashAlgorithmHelper = record helper for DNX509SubjectKeyIdentifierHashAlgorithm
  public const
    Sha1 = 0;
    ShortSha1 = 1;
    CapiSha1 = 2;
  end;


  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  [DNTypeName('System.Security.Cryptography.X509Certificates.X509VerificationFlags')]
  DNX509VerificationFlags = type Integer;
  DNX509VerificationFlagsHelper = record helper for DNX509VerificationFlags
  public const
    NoFlag = 0;
    IgnoreNotTimeValid = 1;
    IgnoreCtlNotTimeValid = 2;
    IgnoreNotTimeNested = 4;
    IgnoreInvalidBasicConstraints = 8;
    AllowUnknownCertificateAuthority = 16;
    IgnoreWrongUsage = 32;
    IgnoreInvalidName = 64;
    IgnoreInvalidPolicy = 128;
    IgnoreEndRevocationUnknown = 256;
    IgnoreCtlSignerRevocationUnknown = 512;
    IgnoreCertificateAuthorityRevocationUnknown = 1024;
    IgnoreRootRevocationUnknown = 2048;
    AllFlags = 4095;
  end;




type


{ declares }

  DNX509CertificateCollection = interface; // type: System.Security.Cryptography.X509Certificates.X509CertificateCollection, namespace: System.Security.Cryptography.X509Certificates
  DNX509Certificate2Collection = interface; // type: System.Security.Cryptography.X509Certificates.X509Certificate2Collection, namespace: System.Security.Cryptography.X509Certificates
  DNSafeX509ChainHandle = interface; // type: Microsoft.Win32.SafeHandles.SafeX509ChainHandle, namespace: Microsoft.Win32.SafeHandles
  DNX500DistinguishedName = interface; // type: System.Security.Cryptography.X509Certificates.X500DistinguishedName, namespace: System.Security.Cryptography.X509Certificates
  DNX509Extension = interface; // type: System.Security.Cryptography.X509Certificates.X509Extension, namespace: System.Security.Cryptography.X509Certificates
  DNX509BasicConstraintsExtension = interface; // type: System.Security.Cryptography.X509Certificates.X509BasicConstraintsExtension, namespace: System.Security.Cryptography.X509Certificates
  DNX509EnhancedKeyUsageExtension = interface; // type: System.Security.Cryptography.X509Certificates.X509EnhancedKeyUsageExtension, namespace: System.Security.Cryptography.X509Certificates
  DNX509KeyUsageExtension = interface; // type: System.Security.Cryptography.X509Certificates.X509KeyUsageExtension, namespace: System.Security.Cryptography.X509Certificates
  DNX509SubjectKeyIdentifierExtension = interface; // type: System.Security.Cryptography.X509Certificates.X509SubjectKeyIdentifierExtension, namespace: System.Security.Cryptography.X509Certificates
  DNCertificateRequest = interface; // type: System.Security.Cryptography.X509Certificates.CertificateRequest, namespace: System.Security.Cryptography.X509Certificates
  DNDSACertificateExtensions = interface; // type: System.Security.Cryptography.X509Certificates.DSACertificateExtensions, namespace: System.Security.Cryptography.X509Certificates
  DNECDsaCertificateExtensions = interface; // type: System.Security.Cryptography.X509Certificates.ECDsaCertificateExtensions, namespace: System.Security.Cryptography.X509Certificates
  DNPublicKey = interface; // type: System.Security.Cryptography.X509Certificates.PublicKey, namespace: System.Security.Cryptography.X509Certificates
  DNRSACertificateExtensions = interface; // type: System.Security.Cryptography.X509Certificates.RSACertificateExtensions, namespace: System.Security.Cryptography.X509Certificates
  DNSubjectAlternativeNameBuilder = interface; // type: System.Security.Cryptography.X509Certificates.SubjectAlternativeNameBuilder, namespace: System.Security.Cryptography.X509Certificates
  DNX509Certificate = interface; // type: System.Security.Cryptography.X509Certificates.X509Certificate, namespace: System.Security.Cryptography.X509Certificates
  DNX509Certificate2 = interface; // type: System.Security.Cryptography.X509Certificates.X509Certificate2, namespace: System.Security.Cryptography.X509Certificates
  DNX509Certificate2Enumerator = interface; // type: System.Security.Cryptography.X509Certificates.X509Certificate2Enumerator, namespace: System.Security.Cryptography.X509Certificates
  DNX509CertificateCollection_X509CertificateEnumerator = interface; // type: System.Security.Cryptography.X509Certificates.X509CertificateCollection+X509CertificateEnumerator, namespace: System.Security.Cryptography.X509Certificates
  DNX509Chain = interface; // type: System.Security.Cryptography.X509Certificates.X509Chain, namespace: System.Security.Cryptography.X509Certificates
  DNX509ChainElement = interface; // type: System.Security.Cryptography.X509Certificates.X509ChainElement, namespace: System.Security.Cryptography.X509Certificates
  DNX509ChainElementCollection = interface; // type: System.Security.Cryptography.X509Certificates.X509ChainElementCollection, namespace: System.Security.Cryptography.X509Certificates
  DNX509ChainElementEnumerator = interface; // type: System.Security.Cryptography.X509Certificates.X509ChainElementEnumerator, namespace: System.Security.Cryptography.X509Certificates
  DNX509ChainPolicy = interface; // type: System.Security.Cryptography.X509Certificates.X509ChainPolicy, namespace: System.Security.Cryptography.X509Certificates
  DNX509ExtensionCollection = interface; // type: System.Security.Cryptography.X509Certificates.X509ExtensionCollection, namespace: System.Security.Cryptography.X509Certificates
  DNX509ExtensionEnumerator = interface; // type: System.Security.Cryptography.X509Certificates.X509ExtensionEnumerator, namespace: System.Security.Cryptography.X509Certificates
  DNX509SignatureGenerator = interface; // type: System.Security.Cryptography.X509Certificates.X509SignatureGenerator, namespace: System.Security.Cryptography.X509Certificates
  DNX509Store = interface; // type: System.Security.Cryptography.X509Certificates.X509Store, namespace: System.Security.Cryptography.X509Certificates
  DNX509ChainStatus = interface; // type: System.Security.Cryptography.X509Certificates.X509ChainStatus, namespace: System.Security.Cryptography.X509Certificates


{ objects }

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509CertificateCollectionClass = interface(DNObjectClass)
  ['{DE7FC8FE-8603-5412-B0C1-82EBBDBC9F4C}']
  { constructors } 

    {class} function init: DNX509CertificateCollection; overload;
    {class} function init(value: TArray<DNX509Certificate>): DNX509CertificateCollection; overload;
    {class} function init(value: DNX509CertificateCollection): DNX509CertificateCollection; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509CertificateCollection')]
  DNX509CertificateCollection = interface(DNObject)
  ['{47367484-BAB8-3A0C-A082-790FA9CC6341}']
  { getters & setters } 

    function get_Item(index: Int32): DNX509Certificate;
    procedure set_Item(index: Int32; value: DNX509Certificate);
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    function Add(value: DNX509Certificate): Int32;
    procedure AddRange(value: TArray<DNX509Certificate>); overload;
    procedure AddRange(value: DNX509CertificateCollection); overload;
    function &Contains(value: DNX509Certificate): Boolean;
    procedure CopyTo(&array: TArray<DNX509Certificate>; index: Int32);
    function GetEnumerator: DNX509CertificateCollection_X509CertificateEnumerator;
    function GetHashCode: Int32;
    function IndexOf(value: DNX509Certificate): Int32;
    procedure Insert(index: Int32; value: DNX509Certificate);
    procedure Remove(value: DNX509Certificate);
    procedure RemoveAt(index: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;

  { propertys } 

    property Item[index: Int32]: DNX509Certificate read get_Item write set_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNX509CertificateCollection = class(TDNGenericImport<DNX509CertificateCollectionClass, DNX509CertificateCollection>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509Certificate2CollectionClass = interface(DNX509CertificateCollectionClass)
  ['{B6013E62-40CC-5A36-958C-AE958A66516B}']
  { constructors } 

    {class} function init: DNX509Certificate2Collection; overload;
    {class} function init(certificate: DNX509Certificate2): DNX509Certificate2Collection; overload;
    {class} function init(certificates: TArray<DNX509Certificate2>): DNX509Certificate2Collection; overload;
    {class} function init(certificates: DNX509Certificate2Collection): DNX509Certificate2Collection; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509Certificate2Collection')]
  DNX509Certificate2Collection = interface(DNX509CertificateCollection)
  ['{CD5CBAF1-7113-3CF2-94BA-A721AF34909F}']
  { getters & setters } 

    function get_Item(index: Int32): DNX509Certificate2;
    procedure set_Item(index: Int32; value: DNX509Certificate2);
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    function Add(certificate: DNX509Certificate2): Int32; overload;
    procedure AddRange(certificates: TArray<DNX509Certificate2>); overload;
    procedure AddRange(certificates: DNX509Certificate2Collection); overload;
    function &Contains(certificate: DNX509Certificate2): Boolean; overload;
    function &Export(contentType: DNX509ContentType): TArray<Byte>; overload;
    function &Export(contentType: DNX509ContentType; password: string): TArray<Byte>; overload;
    function Find(findType: DNX509FindType; findValue: DDNC.System.Private.CoreLib.DNObject; validOnly: Boolean): DNX509Certificate2Collection;
    function GetEnumerator: DNX509Certificate2Enumerator;
    procedure Import(rawData: TArray<Byte>); overload;
    procedure Import(rawData: TArray<Byte>; password: string; keyStorageFlags: DNX509KeyStorageFlags); overload;
    procedure Import(fileName: string); overload;
    procedure Import(fileName: string; password: string; keyStorageFlags: DNX509KeyStorageFlags); overload;
    procedure Insert(index: Int32; certificate: DNX509Certificate2); overload;
    procedure Remove(certificate: DNX509Certificate2); overload;
    procedure RemoveRange(certificates: TArray<DNX509Certificate2>); overload;
    procedure RemoveRange(certificates: DNX509Certificate2Collection); overload;
    function Add(value: DNX509Certificate): Int32; overload;
    procedure AddRange(value: TArray<DNX509Certificate>); overload;
    procedure AddRange(value: DNX509CertificateCollection); overload;
    function &Contains(value: DNX509Certificate): Boolean; overload;
    procedure CopyTo(&array: TArray<DNX509Certificate>; index: Int32);
    function GetHashCode: Int32;
    function IndexOf(value: DNX509Certificate): Int32;
    procedure Insert(index: Int32; value: DNX509Certificate); overload;
    procedure Remove(value: DNX509Certificate); overload;
    procedure RemoveAt(index: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;

  { propertys } 

    property Item[index: Int32]: DNX509Certificate2 read get_Item write set_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNX509Certificate2Collection = class(TDNGenericImport<DNX509Certificate2CollectionClass, DNX509Certificate2Collection>) end;

  //-------------namespace: Microsoft.Win32.SafeHandles----------------
  DNSafeX509ChainHandleClass = interface(DDNC.System.Private.CoreLib.DNSafeHandleZeroOrMinusOneIsInvalidClass)
  ['{6E601F8A-024D-58F5-AC12-E1992A0190E9}']
  end;

  [DNTypeName('Microsoft.Win32.SafeHandles.SafeX509ChainHandle')]
  DNSafeX509ChainHandle = interface(DDNC.System.Private.CoreLib.DNSafeHandleZeroOrMinusOneIsInvalid)
  ['{95CA89FA-0299-356B-B3E4-3DBF29B61251}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeX509ChainHandle = class(TDNGenericImport<DNSafeX509ChainHandleClass, DNSafeX509ChainHandle>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX500DistinguishedNameClass = interface(DNObjectClass)
  ['{657CF5AF-85F1-5329-8063-23C613C662B7}']
  { constructors } 

    {class} function init(encodedDistinguishedName: TArray<Byte>): DNX500DistinguishedName; overload;
    {class} function init(encodedDistinguishedName: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData): DNX500DistinguishedName; overload;
    {class} function init(distinguishedName: DNX500DistinguishedName): DNX500DistinguishedName; overload;
    {class} function init(distinguishedName: string): DNX500DistinguishedName; overload;
    {class} function init(distinguishedName: string; flag: DNX500DistinguishedNameFlags): DNX500DistinguishedName; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X500DistinguishedName')]
  DNX500DistinguishedName = interface(DNObject)
  ['{ABFD1D46-060B-370C-BB8B-DCC7C4AC73E5}']
  { getters & setters } 

    function get_Name: string;
    function get_Oid: DDNC.System.Security.Cryptography.Encoding.DNOid;
    procedure set_Oid(value: DDNC.System.Security.Cryptography.Encoding.DNOid);
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    function Decode(flag: DNX500DistinguishedNameFlags): string;
    function Format(multiLine: Boolean): string;
    procedure CopyFrom(asnEncodedData: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Name: string read get_Name;
    property Oid: DDNC.System.Security.Cryptography.Encoding.DNOid read get_Oid write set_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNX500DistinguishedName = class(TDNGenericImport<DNX500DistinguishedNameClass, DNX500DistinguishedName>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509ExtensionClass = interface(DNObjectClass)
  ['{726BDB22-FD24-5535-923F-222D76699728}']
  { constructors } 

    {class} function init(encodedExtension: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData; critical: Boolean): DNX509Extension; overload;
    {class} function init(oid: DDNC.System.Security.Cryptography.Encoding.DNOid; rawData: TArray<Byte>; critical: Boolean): DNX509Extension; overload;
    {class} function init(oid: string; rawData: TArray<Byte>; critical: Boolean): DNX509Extension; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509Extension')]
  DNX509Extension = interface(DNObject)
  ['{E87F060F-C70C-32AA-80F2-2EB3EFA07C2B}']
  { getters & setters } 

    function get_Critical: Boolean;
    procedure set_Critical(value: Boolean);
    function get_Oid: DDNC.System.Security.Cryptography.Encoding.DNOid;
    procedure set_Oid(value: DDNC.System.Security.Cryptography.Encoding.DNOid);
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Critical: Boolean read get_Critical write set_Critical;
    property Oid: DDNC.System.Security.Cryptography.Encoding.DNOid read get_Oid write set_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNX509Extension = class(TDNGenericImport<DNX509ExtensionClass, DNX509Extension>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509BasicConstraintsExtensionClass = interface(DNX509ExtensionClass)
  ['{2DCED2E9-28E3-53BA-9CEF-994066F6256A}']
  { constructors } 

    {class} function init: DNX509BasicConstraintsExtension; overload;
    {class} function init(certificateAuthority: Boolean; hasPathLengthConstraint: Boolean; pathLengthConstraint: Int32; critical: Boolean): DNX509BasicConstraintsExtension; overload;
    {class} function init(encodedBasicConstraints: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData; critical: Boolean): DNX509BasicConstraintsExtension; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509BasicConstraintsExtension')]
  DNX509BasicConstraintsExtension = interface(DNX509Extension)
  ['{6F2EAD7D-0D49-3E73-9939-0DBF84D39F9E}']
  { getters & setters } 

    function get_CertificateAuthority: Boolean;
    function get_HasPathLengthConstraint: Boolean;
    function get_PathLengthConstraint: Int32;
    function get_Critical: Boolean;
    procedure set_Critical(value: Boolean);
    function get_Oid: DDNC.System.Security.Cryptography.Encoding.DNOid;
    procedure set_Oid(value: DDNC.System.Security.Cryptography.Encoding.DNOid);
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property CertificateAuthority: Boolean read get_CertificateAuthority;
    property HasPathLengthConstraint: Boolean read get_HasPathLengthConstraint;
    property PathLengthConstraint: Int32 read get_PathLengthConstraint;
    property Critical: Boolean read get_Critical write set_Critical;
    property Oid: DDNC.System.Security.Cryptography.Encoding.DNOid read get_Oid write set_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNX509BasicConstraintsExtension = class(TDNGenericImport<DNX509BasicConstraintsExtensionClass, DNX509BasicConstraintsExtension>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509EnhancedKeyUsageExtensionClass = interface(DNX509ExtensionClass)
  ['{C84EE0AC-802B-59B2-A236-C65757ACB24B}']
  { constructors } 

    {class} function init: DNX509EnhancedKeyUsageExtension; overload;
    {class} function init(encodedEnhancedKeyUsages: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData; critical: Boolean): DNX509EnhancedKeyUsageExtension; overload;
    {class} function init(enhancedKeyUsages: DDNC.System.Security.Cryptography.Encoding.DNOidCollection; critical: Boolean): DNX509EnhancedKeyUsageExtension; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509EnhancedKeyUsageExtension')]
  DNX509EnhancedKeyUsageExtension = interface(DNX509Extension)
  ['{DA584BB0-22C7-360B-B5F0-B32C07F51BFC}']
  { getters & setters } 

    function get_EnhancedKeyUsages: DDNC.System.Security.Cryptography.Encoding.DNOidCollection;
    function get_Critical: Boolean;
    procedure set_Critical(value: Boolean);
    function get_Oid: DDNC.System.Security.Cryptography.Encoding.DNOid;
    procedure set_Oid(value: DDNC.System.Security.Cryptography.Encoding.DNOid);
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property EnhancedKeyUsages: DDNC.System.Security.Cryptography.Encoding.DNOidCollection read get_EnhancedKeyUsages;
    property Critical: Boolean read get_Critical write set_Critical;
    property Oid: DDNC.System.Security.Cryptography.Encoding.DNOid read get_Oid write set_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNX509EnhancedKeyUsageExtension = class(TDNGenericImport<DNX509EnhancedKeyUsageExtensionClass, DNX509EnhancedKeyUsageExtension>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509KeyUsageExtensionClass = interface(DNX509ExtensionClass)
  ['{AE65EC35-1237-55A8-99AC-F6A4C9456218}']
  { constructors } 

    {class} function init: DNX509KeyUsageExtension; overload;
    {class} function init(encodedKeyUsage: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData; critical: Boolean): DNX509KeyUsageExtension; overload;
    {class} function init(keyUsages: DNX509KeyUsageFlags; critical: Boolean): DNX509KeyUsageExtension; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509KeyUsageExtension')]
  DNX509KeyUsageExtension = interface(DNX509Extension)
  ['{603A6165-6A28-37BE-A7B1-DC9443EA88DF}']
  { getters & setters } 

    function get_KeyUsages: DNX509KeyUsageFlags;
    function get_Critical: Boolean;
    procedure set_Critical(value: Boolean);
    function get_Oid: DDNC.System.Security.Cryptography.Encoding.DNOid;
    procedure set_Oid(value: DDNC.System.Security.Cryptography.Encoding.DNOid);
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeyUsages: DNX509KeyUsageFlags read get_KeyUsages;
    property Critical: Boolean read get_Critical write set_Critical;
    property Oid: DDNC.System.Security.Cryptography.Encoding.DNOid read get_Oid write set_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNX509KeyUsageExtension = class(TDNGenericImport<DNX509KeyUsageExtensionClass, DNX509KeyUsageExtension>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509SubjectKeyIdentifierExtensionClass = interface(DNX509ExtensionClass)
  ['{7B32AA53-7D8C-516F-87A2-C982C70D8BB3}']
  { constructors } 

    {class} function init: DNX509SubjectKeyIdentifierExtension; overload;
    {class} function init(encodedSubjectKeyIdentifier: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData; critical: Boolean): DNX509SubjectKeyIdentifierExtension; overload;
    {class} function init(subjectKeyIdentifier: TArray<Byte>; critical: Boolean): DNX509SubjectKeyIdentifierExtension; overload;
    {class} function init(key: DNPublicKey; critical: Boolean): DNX509SubjectKeyIdentifierExtension; overload;
    {class} function init(key: DNPublicKey; algorithm: DNX509SubjectKeyIdentifierHashAlgorithm; critical: Boolean): DNX509SubjectKeyIdentifierExtension; overload;
    {class} function init(subjectKeyIdentifier: string; critical: Boolean): DNX509SubjectKeyIdentifierExtension; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509SubjectKeyIdentifierExtension')]
  DNX509SubjectKeyIdentifierExtension = interface(DNX509Extension)
  ['{C49D4A95-73BE-382E-890A-671AB5C5C594}']
  { getters & setters } 

    function get_SubjectKeyIdentifier: string;
    function get_Critical: Boolean;
    procedure set_Critical(value: Boolean);
    function get_Oid: DDNC.System.Security.Cryptography.Encoding.DNOid;
    procedure set_Oid(value: DDNC.System.Security.Cryptography.Encoding.DNOid);
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property SubjectKeyIdentifier: string read get_SubjectKeyIdentifier;
    property Critical: Boolean read get_Critical write set_Critical;
    property Oid: DDNC.System.Security.Cryptography.Encoding.DNOid read get_Oid write set_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNX509SubjectKeyIdentifierExtension = class(TDNGenericImport<DNX509SubjectKeyIdentifierExtensionClass, DNX509SubjectKeyIdentifierExtension>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNCertificateRequestClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{3C5ACE78-1310-5435-87A0-896F07B25AA6}']
  { constructors } 

    {class} function init(subjectName: string; key: DDNC.System.Security.Cryptography.Algorithms.DNECDsa; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNCertificateRequest; overload;
    {class} function init(subjectName: DNX500DistinguishedName; key: DDNC.System.Security.Cryptography.Algorithms.DNECDsa; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNCertificateRequest; overload;
    {class} function init(subjectName: string; key: DDNC.System.Security.Cryptography.Algorithms.DNRSA; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): DNCertificateRequest; overload;
    {class} function init(subjectName: DNX500DistinguishedName; key: DDNC.System.Security.Cryptography.Algorithms.DNRSA; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): DNCertificateRequest; overload;
    {class} function init(subjectName: DNX500DistinguishedName; publicKey: DNPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNCertificateRequest; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.CertificateRequest')]
  DNCertificateRequest = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{700F1BF7-D562-3E8B-8B23-67E57A357ADA}']
  { getters & setters } 

    function get_SubjectName: DNX500DistinguishedName;
    function get_CertificateExtensions: DDNC.System.Private.CoreLib.DNCollection<DNX509Extension>;
    function get_PublicKey: DNPublicKey;
    function get_HashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName;

  { methods } 

    function CreateSigningRequest: TArray<Byte>; overload;
    function CreateSigningRequest(signatureGenerator: DNX509SignatureGenerator): TArray<Byte>; overload;
    function CreateSelfSigned(notBefore: DDNC.System.Private.CoreLib.DNDateTimeOffset; notAfter: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNX509Certificate2;
    function Create(issuerCertificate: DNX509Certificate2; notBefore: DDNC.System.Private.CoreLib.DNDateTimeOffset; notAfter: DDNC.System.Private.CoreLib.DNDateTimeOffset; serialNumber: TArray<Byte>): DNX509Certificate2; overload;
    function Create(issuerName: DNX500DistinguishedName; generator: DNX509SignatureGenerator; notBefore: DDNC.System.Private.CoreLib.DNDateTimeOffset; notAfter: DDNC.System.Private.CoreLib.DNDateTimeOffset; serialNumber: TArray<Byte>): DNX509Certificate2; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property SubjectName: DNX500DistinguishedName read get_SubjectName;
    property CertificateExtensions: DDNC.System.Private.CoreLib.DNCollection<DNX509Extension> read get_CertificateExtensions;
    property PublicKey: DNPublicKey read get_PublicKey;
    property HashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName read get_HashAlgorithm;
  end;

  TDNCertificateRequest = class(TDNGenericImport<DNCertificateRequestClass, DNCertificateRequest>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNDSACertificateExtensionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{89536974-73F1-55CE-A316-5D7FA52FB556}']
  { static methods } 

    {class} function GetDSAPublicKey(certificate: DNX509Certificate2): DDNC.System.Security.Cryptography.Algorithms.DNDSA;
    {class} function GetDSAPrivateKey(certificate: DNX509Certificate2): DDNC.System.Security.Cryptography.Algorithms.DNDSA;
    {class} function CopyWithPrivateKey(certificate: DNX509Certificate2; privateKey: DDNC.System.Security.Cryptography.Algorithms.DNDSA): DNX509Certificate2;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.DSACertificateExtensions')]
  DNDSACertificateExtensions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4B49475E-743B-3605-9172-56ABDFC8B1A1}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNDSACertificateExtensions = class(TDNGenericImport<DNDSACertificateExtensionsClass, DNDSACertificateExtensions>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNECDsaCertificateExtensionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{748BEF0B-2F3C-5DF1-AADF-64D4FDB53C56}']
  { static methods } 

    {class} function GetECDsaPublicKey(certificate: DNX509Certificate2): DDNC.System.Security.Cryptography.Algorithms.DNECDsa;
    {class} function GetECDsaPrivateKey(certificate: DNX509Certificate2): DDNC.System.Security.Cryptography.Algorithms.DNECDsa;
    {class} function CopyWithPrivateKey(certificate: DNX509Certificate2; privateKey: DDNC.System.Security.Cryptography.Algorithms.DNECDsa): DNX509Certificate2;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.ECDsaCertificateExtensions')]
  DNECDsaCertificateExtensions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{82BCEC18-8889-3DE2-9626-C6A409968EF6}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNECDsaCertificateExtensions = class(TDNGenericImport<DNECDsaCertificateExtensionsClass, DNECDsaCertificateExtensions>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNPublicKeyClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{483D9DDD-F0FE-5601-A096-1A8F1A802312}']
  { constructors } 

    {class} function init(oid: DDNC.System.Security.Cryptography.Encoding.DNOid; parameters: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData; keyValue: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData): DNPublicKey;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.PublicKey')]
  DNPublicKey = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{FA10E0F2-D2E0-3267-A67A-1A6A69CDC3FF}']
  { getters & setters } 

    function get_EncodedKeyValue: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData;
    function get_EncodedParameters: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData;
    function get_Key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm;
    function get_Oid: DDNC.System.Security.Cryptography.Encoding.DNOid;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property EncodedKeyValue: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData read get_EncodedKeyValue;
    property EncodedParameters: DDNC.System.Security.Cryptography.Encoding.DNAsnEncodedData read get_EncodedParameters;
    property Key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm read get_Key;
    property Oid: DDNC.System.Security.Cryptography.Encoding.DNOid read get_Oid;
  end;

  TDNPublicKey = class(TDNGenericImport<DNPublicKeyClass, DNPublicKey>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNRSACertificateExtensionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{4B444E35-4622-5295-9099-3D320E6202A6}']
  { static methods } 

    {class} function GetRSAPublicKey(certificate: DNX509Certificate2): DDNC.System.Security.Cryptography.Algorithms.DNRSA;
    {class} function GetRSAPrivateKey(certificate: DNX509Certificate2): DDNC.System.Security.Cryptography.Algorithms.DNRSA;
    {class} function CopyWithPrivateKey(certificate: DNX509Certificate2; privateKey: DDNC.System.Security.Cryptography.Algorithms.DNRSA): DNX509Certificate2;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.RSACertificateExtensions')]
  DNRSACertificateExtensions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{5C00FE87-0519-3F1C-99AC-C8978FF48AEE}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNRSACertificateExtensions = class(TDNGenericImport<DNRSACertificateExtensionsClass, DNRSACertificateExtensions>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNSubjectAlternativeNameBuilderClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{FD4B3668-901D-5B33-98B8-398A2424987B}']
  { constructors } 

    {class} function init: DNSubjectAlternativeNameBuilder;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.SubjectAlternativeNameBuilder')]
  DNSubjectAlternativeNameBuilder = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E46F2946-7FA3-3300-9172-D90542A44745}']
  { methods } 

    procedure AddEmailAddress(emailAddress: string);
    procedure AddDnsName(dnsName: string);
    procedure AddUri(uri: DDNC.System.Private.Uri.DNUri);
    procedure AddIpAddress(ipAddress: DDNC.System.Net.Primitives.DNIPAddress);
    procedure AddUserPrincipalName(upn: string);
    function Build(critical: Boolean): DNX509Extension;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNSubjectAlternativeNameBuilder = class(TDNGenericImport<DNSubjectAlternativeNameBuilderClass, DNSubjectAlternativeNameBuilder>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509CertificateClass = interface(DNObjectClass)
  ['{4877C0DF-5390-5F27-B92A-16DEEA403DD9}']
  { constructors } 

    {class} function init: DNX509Certificate; overload;
    {class} function init(data: TArray<Byte>): DNX509Certificate; overload;
    {class} function init(rawData: TArray<Byte>; password: string): DNX509Certificate; overload;
    {class} function init(rawData: TArray<Byte>; password: DDNC.System.Private.CoreLib.DNSecureString): DNX509Certificate; overload;
    {class} function init(rawData: TArray<Byte>; password: string; keyStorageFlags: DNX509KeyStorageFlags): DNX509Certificate; overload;
    {class} function init(rawData: TArray<Byte>; password: DDNC.System.Private.CoreLib.DNSecureString; keyStorageFlags: DNX509KeyStorageFlags): DNX509Certificate; overload;
    {class} function init(handle: IntPtr): DNX509Certificate; overload;
    {class} function init(fileName: string): DNX509Certificate; overload;
    {class} function init(fileName: string; password: string): DNX509Certificate; overload;
    {class} function init(fileName: string; password: DDNC.System.Private.CoreLib.DNSecureString): DNX509Certificate; overload;
    {class} function init(fileName: string; password: string; keyStorageFlags: DNX509KeyStorageFlags): DNX509Certificate; overload;
    {class} function init(fileName: string; password: DDNC.System.Private.CoreLib.DNSecureString; keyStorageFlags: DNX509KeyStorageFlags): DNX509Certificate; overload;
    {class} function init(cert: DNX509Certificate): DNX509Certificate; overload;
    {class} function init(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext): DNX509Certificate; overload;

  { static methods } 

    {class} function CreateFromCertFile(filename: string): DNX509Certificate;
    {class} function CreateFromSignedFile(filename: string): DNX509Certificate;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509Certificate')]
  DNX509Certificate = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{525DA78A-87B0-32D3-B12D-05EAA8E0136B}']
  { getters & setters } 

    function get_Handle: IntPtr;
    function get_Issuer: string;
    function get_Subject: string;

  { methods } 

    procedure Reset;
    procedure Dispose;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNX509Certificate): Boolean; overload;
    function &Export(contentType: DNX509ContentType): TArray<Byte>; overload;
    function &Export(contentType: DNX509ContentType; password: string): TArray<Byte>; overload;
    function &Export(contentType: DNX509ContentType; password: DDNC.System.Private.CoreLib.DNSecureString): TArray<Byte>; overload;
    function GetRawCertDataString: string;
    function GetCertHash: TArray<Byte>; overload;
    function GetCertHash(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function TryGetCertHash(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function GetCertHashString: string; overload;
    function GetCertHashString(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): string; overload;
    function GetEffectiveDateString: string;
    function GetExpirationDateString: string;
    function GetFormat: string;
    function GetPublicKeyString: string;
    function GetRawCertData: TArray<Byte>;
    function GetHashCode: Int32;
    function GetKeyAlgorithm: string;
    function GetKeyAlgorithmParameters: TArray<Byte>;
    function GetKeyAlgorithmParametersString: string;
    function GetPublicKey: TArray<Byte>;
    function GetSerialNumber: TArray<Byte>;
    function GetSerialNumberString: string;
    function GetName: string;
    function GetIssuerName: string;
    function ToString: string; overload;
    function ToString(fVerbose: Boolean): string; overload;
    procedure Import(rawData: TArray<Byte>); overload;
    procedure Import(rawData: TArray<Byte>; password: string; keyStorageFlags: DNX509KeyStorageFlags); overload;
    procedure Import(rawData: TArray<Byte>; password: DDNC.System.Private.CoreLib.DNSecureString; keyStorageFlags: DNX509KeyStorageFlags); overload;
    procedure Import(fileName: string); overload;
    procedure Import(fileName: string; password: string; keyStorageFlags: DNX509KeyStorageFlags); overload;
    procedure Import(fileName: string; password: DDNC.System.Private.CoreLib.DNSecureString; keyStorageFlags: DNX509KeyStorageFlags); overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Handle: IntPtr read get_Handle;
    property Issuer: string read get_Issuer;
    property Subject: string read get_Subject;
  end;

  TDNX509Certificate = class(TDNGenericImport<DNX509CertificateClass, DNX509Certificate>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509Certificate2Class = interface(DNX509CertificateClass)
  ['{8BC2D770-1C62-5B8F-916F-49974D5471D9}']
  { constructors } 

    {class} function init: DNX509Certificate2; overload;
    {class} function init(rawData: TArray<Byte>): DNX509Certificate2; overload;
    {class} function init(rawData: TArray<Byte>; password: string): DNX509Certificate2; overload;
    {class} function init(rawData: TArray<Byte>; password: DDNC.System.Private.CoreLib.DNSecureString): DNX509Certificate2; overload;
    {class} function init(rawData: TArray<Byte>; password: string; keyStorageFlags: DNX509KeyStorageFlags): DNX509Certificate2; overload;
    {class} function init(rawData: TArray<Byte>; password: DDNC.System.Private.CoreLib.DNSecureString; keyStorageFlags: DNX509KeyStorageFlags): DNX509Certificate2; overload;
    {class} function init(handle: IntPtr): DNX509Certificate2; overload;
    {class} function init(fileName: string): DNX509Certificate2; overload;
    {class} function init(fileName: string; password: string): DNX509Certificate2; overload;
    {class} function init(fileName: string; password: DDNC.System.Private.CoreLib.DNSecureString): DNX509Certificate2; overload;
    {class} function init(fileName: string; password: string; keyStorageFlags: DNX509KeyStorageFlags): DNX509Certificate2; overload;
    {class} function init(fileName: string; password: DDNC.System.Private.CoreLib.DNSecureString; keyStorageFlags: DNX509KeyStorageFlags): DNX509Certificate2; overload;
    {class} function init(certificate: DNX509Certificate): DNX509Certificate2; overload;

  { static methods } 

    {class} function GetCertContentType(rawData: TArray<Byte>): DNX509ContentType; overload;
    {class} function GetCertContentType(fileName: string): DNX509ContentType; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509Certificate2')]
  DNX509Certificate2 = interface(DNX509Certificate)
  ['{BAA79BDC-7ACD-35AD-B15E-22C0FE223C69}']
  { getters & setters } 

    function get_Archived: Boolean;
    procedure set_Archived(value: Boolean);
    function get_Extensions: DNX509ExtensionCollection;
    function get_FriendlyName: string;
    procedure set_FriendlyName(value: string);
    function get_HasPrivateKey: Boolean;
    function get_PrivateKey: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm;
    procedure set_PrivateKey(value: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function get_IssuerName: DNX500DistinguishedName;
    function get_NotAfter: DDNC.System.Private.CoreLib.DNDateTime;
    function get_NotBefore: DDNC.System.Private.CoreLib.DNDateTime;
    function get_PublicKey: DNPublicKey;
    function get_RawData: TArray<Byte>;
    function get_SerialNumber: string;
    function get_SignatureAlgorithm: DDNC.System.Security.Cryptography.Encoding.DNOid;
    function get_SubjectName: DNX500DistinguishedName;
    function get_Thumbprint: string;
    function get_Version: Int32;
    function get_Handle: IntPtr;
    function get_Issuer: string;
    function get_Subject: string;

  { methods } 

    procedure Reset;
    function GetNameInfo(nameType: DNX509NameType; forIssuer: Boolean): string;
    function ToString: string; overload;
    function ToString(verbose: Boolean): string; overload;
    procedure Import(rawData: TArray<Byte>); overload;
    procedure Import(rawData: TArray<Byte>; password: string; keyStorageFlags: DNX509KeyStorageFlags); overload;
    procedure Import(rawData: TArray<Byte>; password: DDNC.System.Private.CoreLib.DNSecureString; keyStorageFlags: DNX509KeyStorageFlags); overload;
    procedure Import(fileName: string); overload;
    procedure Import(fileName: string; password: string; keyStorageFlags: DNX509KeyStorageFlags); overload;
    procedure Import(fileName: string; password: DDNC.System.Private.CoreLib.DNSecureString; keyStorageFlags: DNX509KeyStorageFlags); overload;
    function Verify: Boolean;
    procedure Dispose;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNX509Certificate): Boolean; overload;
    function &Export(contentType: DNX509ContentType): TArray<Byte>; overload;
    function &Export(contentType: DNX509ContentType; password: string): TArray<Byte>; overload;
    function &Export(contentType: DNX509ContentType; password: DDNC.System.Private.CoreLib.DNSecureString): TArray<Byte>; overload;
    function GetRawCertDataString: string;
    function GetCertHash: TArray<Byte>; overload;
    function GetCertHash(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function TryGetCertHash(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function GetCertHashString: string; overload;
    function GetCertHashString(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): string; overload;
    function GetEffectiveDateString: string;
    function GetExpirationDateString: string;
    function GetFormat: string;
    function GetPublicKeyString: string;
    function GetRawCertData: TArray<Byte>;
    function GetHashCode: Int32;
    function GetKeyAlgorithm: string;
    function GetKeyAlgorithmParameters: TArray<Byte>;
    function GetKeyAlgorithmParametersString: string;
    function GetPublicKey: TArray<Byte>;
    function GetSerialNumber: TArray<Byte>;
    function GetSerialNumberString: string;
    function GetName: string;
    function GetIssuerName: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Archived: Boolean read get_Archived write set_Archived;
    property Extensions: DNX509ExtensionCollection read get_Extensions;
    property FriendlyName: string read get_FriendlyName write set_FriendlyName;
    property HasPrivateKey: Boolean read get_HasPrivateKey;
    property PrivateKey: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm read get_PrivateKey write set_PrivateKey;
    property IssuerName: DNX500DistinguishedName read get_IssuerName;
    property NotAfter: DDNC.System.Private.CoreLib.DNDateTime read get_NotAfter;
    property NotBefore: DDNC.System.Private.CoreLib.DNDateTime read get_NotBefore;
    property PublicKey: DNPublicKey read get_PublicKey;
    property RawData: TArray<Byte> read get_RawData;
    property SerialNumber: string read get_SerialNumber;
    property SignatureAlgorithm: DDNC.System.Security.Cryptography.Encoding.DNOid read get_SignatureAlgorithm;
    property SubjectName: DNX500DistinguishedName read get_SubjectName;
    property Thumbprint: string read get_Thumbprint;
    property Version: Int32 read get_Version;
    property Handle: IntPtr read get_Handle;
    property Issuer: string read get_Issuer;
    property Subject: string read get_Subject;
  end;

  TDNX509Certificate2 = class(TDNGenericImport<DNX509Certificate2Class, DNX509Certificate2>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509Certificate2EnumeratorClass = interface(DNObjectClass)
  ['{17B9CE67-F2DB-58C1-B94C-17B28B64F8E6}']
  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509Certificate2Enumerator')]
  DNX509Certificate2Enumerator = interface(DDNC.System.Private.CoreLib.DNIEnumerator)
  ['{B5817C2E-0273-31AC-92C0-6819C04B5C29}']
  { getters & setters } 

    function get_Current: DNX509Certificate2;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Current: DNX509Certificate2 read get_Current;
  end;

  TDNX509Certificate2Enumerator = class(TDNGenericImport<DNX509Certificate2EnumeratorClass, DNX509Certificate2Enumerator>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509CertificateCollection_X509CertificateEnumeratorClass = interface(DNObjectClass)
  ['{1260EB94-FB84-5DEB-8434-E7D1508BB545}']
  { constructors } 

    {class} function init(mappings: DNX509CertificateCollection): DNX509CertificateCollection_X509CertificateEnumerator;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509CertificateCollection+X509CertificateEnumerator')]
  DNX509CertificateCollection_X509CertificateEnumerator = interface(DDNC.System.Private.CoreLib.DNIEnumerator)
  ['{5EBC2442-B05E-3E9E-992A-22A6DFEAF75E}']
  { getters & setters } 

    function get_Current: DNX509Certificate;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Current: DNX509Certificate read get_Current;
  end;

  TDNX509CertificateCollection_X509CertificateEnumerator = class(TDNGenericImport<DNX509CertificateCollection_X509CertificateEnumeratorClass, DNX509CertificateCollection_X509CertificateEnumerator>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509ChainClass = interface(DNObjectClass)
  ['{D02135EF-E9CB-5A01-97BC-ECB9905C1024}']
  { constructors } 

    {class} function init: DNX509Chain; overload;
    {class} function init(useMachineContext: Boolean): DNX509Chain; overload;
    {class} function init(chainContext: IntPtr): DNX509Chain; overload;

  { static methods } 

    {class} function Create: DNX509Chain;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509Chain')]
  DNX509Chain = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{6C72164A-4DBA-3356-A763-A9150778AE40}']
  { getters & setters } 

    function get_ChainElements: DNX509ChainElementCollection;
    function get_ChainPolicy: DNX509ChainPolicy;
    procedure set_ChainPolicy(value: DNX509ChainPolicy);
    function get_ChainStatus: TArray<DNX509ChainStatus>;
    function get_ChainContext: IntPtr;
    function get_SafeHandle: DNSafeX509ChainHandle;

  { methods } 

    function Build(certificate: DNX509Certificate2): Boolean;
    procedure Dispose;
    procedure Reset;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ChainElements: DNX509ChainElementCollection read get_ChainElements;
    property ChainPolicy: DNX509ChainPolicy read get_ChainPolicy write set_ChainPolicy;
    property ChainStatus: TArray<DNX509ChainStatus> read get_ChainStatus;
    property ChainContext: IntPtr read get_ChainContext;
    property SafeHandle: DNSafeX509ChainHandle read get_SafeHandle;
  end;

  TDNX509Chain = class(TDNGenericImport<DNX509ChainClass, DNX509Chain>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509ChainElementClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{8B22448F-452B-536B-AD51-830EB0FF6663}']
  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509ChainElement')]
  DNX509ChainElement = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{3BCA866F-524A-393A-BEE4-A57B2843F0C2}']
  { getters & setters } 

    function get_Certificate: DNX509Certificate2;
    function get_ChainElementStatus: TArray<DNX509ChainStatus>;
    function get_Information: string;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Certificate: DNX509Certificate2 read get_Certificate;
    property ChainElementStatus: TArray<DNX509ChainStatus> read get_ChainElementStatus;
    property Information: string read get_Information;
  end;

  TDNX509ChainElement = class(TDNGenericImport<DNX509ChainElementClass, DNX509ChainElement>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509ChainElementCollectionClass = interface(DNObjectClass)
  ['{DA76014F-E69B-5CEE-81F3-3426AB4EDB16}']
  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509ChainElementCollection')]
  DNX509ChainElementCollection = interface(DDNC.System.Private.CoreLib.DNICollection)
  ['{B7118BB7-CDAA-34DA-8766-662F16FF5C89}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;
    function get_Item(index: Int32): DNX509ChainElement;

  { methods } 

    procedure CopyTo(&array: TArray<DNX509ChainElement>; index: Int32);
    function GetEnumerator: DNX509ChainElementEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
    property Item[index: Int32]: DNX509ChainElement read get_Item; default;
  end;

  TDNX509ChainElementCollection = class(TDNGenericImport<DNX509ChainElementCollectionClass, DNX509ChainElementCollection>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509ChainElementEnumeratorClass = interface(DNObjectClass)
  ['{3B4E50F5-A338-5560-B853-E844CD808095}']
  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509ChainElementEnumerator')]
  DNX509ChainElementEnumerator = interface(DDNC.System.Private.CoreLib.DNIEnumerator)
  ['{9AE44508-1F8A-3ED0-89F4-1C637F207C49}']
  { getters & setters } 

    function get_Current: DNX509ChainElement;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Current: DNX509ChainElement read get_Current;
  end;

  TDNX509ChainElementEnumerator = class(TDNGenericImport<DNX509ChainElementEnumeratorClass, DNX509ChainElementEnumerator>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509ChainPolicyClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{9C41F665-0E78-554D-B3D9-98E9D216C14F}']
  { constructors } 

    {class} function init: DNX509ChainPolicy;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509ChainPolicy')]
  DNX509ChainPolicy = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{0FA9E397-98D3-35DB-971F-240B11119CF6}']
  { getters & setters } 

    function get_ApplicationPolicy: DDNC.System.Security.Cryptography.Encoding.DNOidCollection;
    function get_CertificatePolicy: DDNC.System.Security.Cryptography.Encoding.DNOidCollection;
    function get_ExtraStore: DNX509Certificate2Collection;
    function get_RevocationMode: DNX509RevocationMode;
    procedure set_RevocationMode(value: DNX509RevocationMode);
    function get_RevocationFlag: DNX509RevocationFlag;
    procedure set_RevocationFlag(value: DNX509RevocationFlag);
    function get_VerificationFlags: DNX509VerificationFlags;
    procedure set_VerificationFlags(value: DNX509VerificationFlags);
    function get_VerificationTime: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_VerificationTime(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_UrlRetrievalTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_UrlRetrievalTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);

  { methods } 

    procedure Reset;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ApplicationPolicy: DDNC.System.Security.Cryptography.Encoding.DNOidCollection read get_ApplicationPolicy;
    property CertificatePolicy: DDNC.System.Security.Cryptography.Encoding.DNOidCollection read get_CertificatePolicy;
    property ExtraStore: DNX509Certificate2Collection read get_ExtraStore;
    property RevocationMode: DNX509RevocationMode read get_RevocationMode write set_RevocationMode;
    property RevocationFlag: DNX509RevocationFlag read get_RevocationFlag write set_RevocationFlag;
    property VerificationFlags: DNX509VerificationFlags read get_VerificationFlags write set_VerificationFlags;
    property VerificationTime: DDNC.System.Private.CoreLib.DNDateTime read get_VerificationTime write set_VerificationTime;
    property UrlRetrievalTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_UrlRetrievalTimeout write set_UrlRetrievalTimeout;
  end;

  TDNX509ChainPolicy = class(TDNGenericImport<DNX509ChainPolicyClass, DNX509ChainPolicy>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509ExtensionCollectionClass = interface(DNObjectClass)
  ['{0532E157-C4ED-55BE-BFE3-EB94B3D1A055}']
  { constructors } 

    {class} function init: DNX509ExtensionCollection;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509ExtensionCollection')]
  DNX509ExtensionCollection = interface(DDNC.System.Private.CoreLib.DNICollection)
  ['{4AE611C6-98E2-3DA4-8A1B-8D62CF5F8758}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;
    function get_Item(index: Int32): DNX509Extension; overload;
    function get_Item(oid: string): DNX509Extension; overload;

  { methods } 

    function Add(extension: DNX509Extension): Int32;
    procedure CopyTo(&array: TArray<DNX509Extension>; index: Int32);
    function GetEnumerator: DNX509ExtensionEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
    property Item[index: Int32]: DNX509Extension read get_Item; default;
    property Item[oid: string]: DNX509Extension read get_Item; default;
  end;

  TDNX509ExtensionCollection = class(TDNGenericImport<DNX509ExtensionCollectionClass, DNX509ExtensionCollection>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509ExtensionEnumeratorClass = interface(DNObjectClass)
  ['{A76031B9-4663-5FE4-AD3B-018A00C44CF6}']
  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509ExtensionEnumerator')]
  DNX509ExtensionEnumerator = interface(DDNC.System.Private.CoreLib.DNIEnumerator)
  ['{E27B3CFB-7F3C-3EF9-86CB-18D2F2DE338A}']
  { getters & setters } 

    function get_Current: DNX509Extension;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Current: DNX509Extension read get_Current;
  end;

  TDNX509ExtensionEnumerator = class(TDNGenericImport<DNX509ExtensionEnumeratorClass, DNX509ExtensionEnumerator>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509SignatureGeneratorClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{C667DC13-B36A-54DE-9EBC-823BAF2616AB}']
  { static methods } 

    {class} function CreateForECDsa(key: DDNC.System.Security.Cryptography.Algorithms.DNECDsa): DNX509SignatureGenerator;
    {class} function CreateForRSA(key: DDNC.System.Security.Cryptography.Algorithms.DNRSA; signaturePadding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): DNX509SignatureGenerator;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509SignatureGenerator')]
  DNX509SignatureGenerator = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8CF4FD5D-E5E8-325D-B096-BEAC4C807AB5}']
  { getters & setters } 

    function get_PublicKey: DNPublicKey;

  { methods } 

    function GetSignatureAlgorithmIdentifier(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property PublicKey: DNPublicKey read get_PublicKey;
  end;

  TDNX509SignatureGenerator = class(TDNGenericImport<DNX509SignatureGeneratorClass, DNX509SignatureGenerator>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509StoreClass = interface(DNObjectClass)
  ['{FB4C351A-EA7A-5236-9953-C1D35A23E773}']
  { constructors } 

    {class} function init: DNX509Store; overload;
    {class} function init(storeName: string): DNX509Store; overload;
    {class} function init(storeName: DNStoreName): DNX509Store; overload;
    {class} function init(storeLocation: DNStoreLocation): DNX509Store; overload;
    {class} function init(storeName: DNStoreName; storeLocation: DNStoreLocation): DNX509Store; overload;
    {class} function init(storeName: DNStoreName; storeLocation: DNStoreLocation; flags: DNOpenFlags): DNX509Store; overload;
    {class} function init(storeName: string; storeLocation: DNStoreLocation): DNX509Store; overload;
    {class} function init(storeName: string; storeLocation: DNStoreLocation; flags: DNOpenFlags): DNX509Store; overload;
    {class} function init(storeHandle: IntPtr): DNX509Store; overload;

  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509Store')]
  DNX509Store = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{E6528653-58FC-3D97-9424-573BC078CDC9}']
  { getters & setters } 

    function get_StoreHandle: IntPtr;
    function get_Location: DNStoreLocation;
    function get_Name: string;
    function get_Certificates: DNX509Certificate2Collection;
    function get_IsOpen: Boolean;

  { methods } 

    procedure Open(flags: DNOpenFlags);
    procedure Add(certificate: DNX509Certificate2);
    procedure AddRange(certificates: DNX509Certificate2Collection);
    procedure Remove(certificate: DNX509Certificate2);
    procedure RemoveRange(certificates: DNX509Certificate2Collection);
    procedure Dispose;
    procedure Close;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property StoreHandle: IntPtr read get_StoreHandle;
    property Location: DNStoreLocation read get_Location;
    property Name: string read get_Name;
    property Certificates: DNX509Certificate2Collection read get_Certificates;
    property IsOpen: Boolean read get_IsOpen;
  end;

  TDNX509Store = class(TDNGenericImport<DNX509StoreClass, DNX509Store>) end;

  //-------------namespace: System.Security.Cryptography.X509Certificates----------------
  DNX509ChainStatusClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{2A1477DF-597A-5A59-8228-D079E61DC182}']
  end;

  [DNTypeName('System.Security.Cryptography.X509Certificates.X509ChainStatus')]
  DNX509ChainStatus = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{B3C30007-6A4B-3B9C-9361-F5296E04B8E0}']
  { getters & setters } 

    function get_Status: DNX509ChainStatusFlags;
    procedure set_Status(value: DNX509ChainStatusFlags);
    function get_StatusInformation: string;
    procedure set_StatusInformation(value: string);

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Status: DNX509ChainStatusFlags read get_Status write set_Status;
    property StatusInformation: string read get_StatusInformation write set_StatusInformation;
  end;

  TDNX509ChainStatus = class(TDNGenericImport<DNX509ChainStatusClass, DNX509ChainStatus>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.Cryptography.X509Certificates, Version=4.2.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
