//----------------------------------------------------------------------------
//  System.Security.Cryptography.Encoding.dll: System.Security.Cryptography.Encoding, Version=4.1.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.Cryptography.Encoding
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.Cryptography.Encoding;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Security.Cryptography.Primitives;

type

{ enums }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.FromBase64TransformMode')]
  DNFromBase64TransformMode = type Integer;
  DNFromBase64TransformModeHelper = record helper for DNFromBase64TransformMode
  public const
    IgnoreWhiteSpaces = 0;
    DoNotIgnoreWhiteSpaces = 1;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.OidGroup')]
  DNOidGroup = type Integer;
  DNOidGroupHelper = record helper for DNOidGroup
  public const
    All = 0;
    HashAlgorithm = 1;
    EncryptionAlgorithm = 2;
    PublicKeyAlgorithm = 3;
    SignatureAlgorithm = 4;
    Attribute = 5;
    ExtensionOrAttribute = 6;
    EnhancedKeyUsage = 7;
    Policy = 8;
    Template = 9;
    KeyDerivationFunction = 10;
  end;




type


{ declares }

  DNAsnEncodedData = interface; // type: System.Security.Cryptography.AsnEncodedData, namespace: System.Security.Cryptography
  DNAsnEncodedDataCollection = interface; // type: System.Security.Cryptography.AsnEncodedDataCollection, namespace: System.Security.Cryptography
  DNAsnEncodedDataEnumerator = interface; // type: System.Security.Cryptography.AsnEncodedDataEnumerator, namespace: System.Security.Cryptography
  DNFromBase64Transform = interface; // type: System.Security.Cryptography.FromBase64Transform, namespace: System.Security.Cryptography
  DNOid = interface; // type: System.Security.Cryptography.Oid, namespace: System.Security.Cryptography
  DNOidCollection = interface; // type: System.Security.Cryptography.OidCollection, namespace: System.Security.Cryptography
  DNOidEnumerator = interface; // type: System.Security.Cryptography.OidEnumerator, namespace: System.Security.Cryptography
  DNToBase64Transform = interface; // type: System.Security.Cryptography.ToBase64Transform, namespace: System.Security.Cryptography


{ objects }

  //-------------namespace: System.Security.Cryptography----------------
  DNAsnEncodedDataClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{9BF7F61C-6940-55F6-AED0-EF7E3A021668}']
  { constructors } 

    {class} function init(rawData: TArray<Byte>): DNAsnEncodedData; overload;
    {class} function init(asnEncodedData: DNAsnEncodedData): DNAsnEncodedData; overload;
    {class} function init(oid: DNOid; rawData: TArray<Byte>): DNAsnEncodedData; overload;
    {class} function init(oid: string; rawData: TArray<Byte>): DNAsnEncodedData; overload;

  end;

  [DNTypeName('System.Security.Cryptography.AsnEncodedData')]
  DNAsnEncodedData = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{5159A6F8-14AB-3094-AE8A-1D5B311E1E80}']
  { getters & setters } 

    function get_Oid: DNOid;
    procedure set_Oid(value: DNOid);
    function get_RawData: TArray<Byte>;
    procedure set_RawData(value: TArray<Byte>);

  { methods } 

    procedure CopyFrom(asnEncodedData: DNAsnEncodedData);
    function Format(multiLine: Boolean): string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Oid: DNOid read get_Oid write set_Oid;
    property RawData: TArray<Byte> read get_RawData write set_RawData;
  end;

  TDNAsnEncodedData = class(TDNGenericImport<DNAsnEncodedDataClass, DNAsnEncodedData>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsnEncodedDataCollectionClass = interface(DNObjectClass)
  ['{E4F384B8-935C-5761-B0B6-9CAEBFDB2A09}']
  { constructors } 

    {class} function init: DNAsnEncodedDataCollection; overload;
    {class} function init(asnEncodedData: DNAsnEncodedData): DNAsnEncodedDataCollection; overload;

  end;

  [DNTypeName('System.Security.Cryptography.AsnEncodedDataCollection')]
  DNAsnEncodedDataCollection = interface(DDNC.System.Private.CoreLib.DNICollection)
  ['{15388374-0E40-36C6-81CA-EE3D5038165B}']
  { getters & setters } 

    function get_Item(index: Int32): DNAsnEncodedData;
    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    function Add(asnEncodedData: DNAsnEncodedData): Int32;
    procedure Remove(asnEncodedData: DNAsnEncodedData);
    function GetEnumerator: DNAsnEncodedDataEnumerator;
    procedure CopyTo(&array: TArray<DNAsnEncodedData>; index: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Item[index: Int32]: DNAsnEncodedData read get_Item; default;
    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNAsnEncodedDataCollection = class(TDNGenericImport<DNAsnEncodedDataCollectionClass, DNAsnEncodedDataCollection>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsnEncodedDataEnumeratorClass = interface(DNObjectClass)
  ['{1F72CC47-8832-595C-8BDC-B48C5A47168A}']
  end;

  [DNTypeName('System.Security.Cryptography.AsnEncodedDataEnumerator')]
  DNAsnEncodedDataEnumerator = interface(DDNC.System.Private.CoreLib.DNIEnumerator)
  ['{D31815FF-DEA3-36C7-B263-EE2B3A4C73B5}']
  { getters & setters } 

    function get_Current: DNAsnEncodedData;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Current: DNAsnEncodedData read get_Current;
  end;

  TDNAsnEncodedDataEnumerator = class(TDNGenericImport<DNAsnEncodedDataEnumeratorClass, DNAsnEncodedDataEnumerator>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNFromBase64TransformClass = interface(DNObjectClass)
  ['{52450C41-B43C-5A08-8527-382106795C3F}']
  { constructors } 

    {class} function init: DNFromBase64Transform; overload;
    {class} function init(whitespaces: DNFromBase64TransformMode): DNFromBase64Transform; overload;

  end;

  [DNTypeName('System.Security.Cryptography.FromBase64Transform')]
  DNFromBase64Transform = interface(DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform)
  ['{9DBA428B-1313-344E-90E6-0E8F872AAD21}']
  { getters & setters } 

    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Dispose;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNFromBase64Transform = class(TDNGenericImport<DNFromBase64TransformClass, DNFromBase64Transform>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNOidClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{E797E042-A702-56BD-8263-58678EFFA57E}']
  { constructors } 

    {class} function init: DNOid; overload;
    {class} function init(oid: string): DNOid; overload;
    {class} function init(value: string; friendlyName: string): DNOid; overload;
    {class} function init(oid: DNOid): DNOid; overload;

  { static methods } 

    {class} function FromFriendlyName(friendlyName: string; group: DNOidGroup): DNOid;
    {class} function FromOidValue(oidValue: string; group: DNOidGroup): DNOid;

  end;

  [DNTypeName('System.Security.Cryptography.Oid')]
  DNOid = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{1A96A0D9-25DB-370C-A4D0-D0D5956F7E81}']
  { getters & setters } 

    function get_Value: string;
    procedure set_Value(value: string);
    function get_FriendlyName: string;
    procedure set_FriendlyName(value: string);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Value: string read get_Value write set_Value;
    property FriendlyName: string read get_FriendlyName write set_FriendlyName;
  end;

  TDNOid = class(TDNGenericImport<DNOidClass, DNOid>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNOidCollectionClass = interface(DNObjectClass)
  ['{9B113EB9-BC08-5922-BA03-D4C44F988D5C}']
  { constructors } 

    {class} function init: DNOidCollection;

  end;

  [DNTypeName('System.Security.Cryptography.OidCollection')]
  DNOidCollection = interface(DDNC.System.Private.CoreLib.DNICollection)
  ['{5F453F8B-85CF-383D-AA43-4EF209040530}']
  { getters & setters } 

    function get_Item(index: Int32): DNOid; overload;
    function get_Item(oid: string): DNOid; overload;
    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    function Add(oid: DNOid): Int32;
    function GetEnumerator: DNOidEnumerator;
    procedure CopyTo(&array: TArray<DNOid>; index: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Item[index: Int32]: DNOid read get_Item; default;
    property Item[oid: string]: DNOid read get_Item; default;
    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNOidCollection = class(TDNGenericImport<DNOidCollectionClass, DNOidCollection>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNOidEnumeratorClass = interface(DNObjectClass)
  ['{26727EB7-AC72-5B3E-B54E-9250E41CA884}']
  end;

  [DNTypeName('System.Security.Cryptography.OidEnumerator')]
  DNOidEnumerator = interface(DDNC.System.Private.CoreLib.DNIEnumerator)
  ['{2D52C005-44EE-34B6-9951-B6C7A2B03F1F}']
  { getters & setters } 

    function get_Current: DNOid;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Current: DNOid read get_Current;
  end;

  TDNOidEnumerator = class(TDNGenericImport<DNOidEnumeratorClass, DNOidEnumerator>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNToBase64TransformClass = interface(DNObjectClass)
  ['{97E9BA79-8458-5E40-96E3-5DE453E5410E}']
  { constructors } 

    {class} function init: DNToBase64Transform;

  end;

  [DNTypeName('System.Security.Cryptography.ToBase64Transform')]
  DNToBase64Transform = interface(DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform)
  ['{3AB907D0-C1B4-377C-90B7-E30D7AFD16F6}']
  { getters & setters } 

    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Dispose;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNToBase64Transform = class(TDNGenericImport<DNToBase64TransformClass, DNToBase64Transform>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.Cryptography.Encoding, Version=4.1.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
