//----------------------------------------------------------------------------
//  System.Security.Cryptography.Cng.dll: System.Security.Cryptography.Cng, Version=4.3.3.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.Cryptography.Cng
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.Cryptography.Cng;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Security.Cryptography.Algorithms,
  DDNC.System.Security.Cryptography.Primitives;

type

{ enums }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngExportPolicies')]
  DNCngExportPolicies = type Integer;
  DNCngExportPoliciesHelper = record helper for DNCngExportPolicies
  public const
    None = 0;
    AllowExport = 1;
    AllowPlaintextExport = 2;
    AllowArchiving = 4;
    AllowPlaintextArchiving = 8;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngKeyCreationOptions')]
  DNCngKeyCreationOptions = type Integer;
  DNCngKeyCreationOptionsHelper = record helper for DNCngKeyCreationOptions
  public const
    None = 0;
    MachineKey = 32;
    OverwriteExistingKey = 128;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngKeyHandleOpenOptions')]
  DNCngKeyHandleOpenOptions = type Integer;
  DNCngKeyHandleOpenOptionsHelper = record helper for DNCngKeyHandleOpenOptions
  public const
    None = 0;
    EphemeralKey = 1;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngKeyOpenOptions')]
  DNCngKeyOpenOptions = type Integer;
  DNCngKeyOpenOptionsHelper = record helper for DNCngKeyOpenOptions
  public const
    None = 0;
    UserKey = 0;
    MachineKey = 32;
    Silent = 64;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngKeyUsages')]
  DNCngKeyUsages = type Integer;
  DNCngKeyUsagesHelper = record helper for DNCngKeyUsages
  public const
    None = 0;
    Decryption = 1;
    Signing = 2;
    KeyAgreement = 4;
    AllUsages = 16777215;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngPropertyOptions')]
  DNCngPropertyOptions = type Integer;
  DNCngPropertyOptionsHelper = record helper for DNCngPropertyOptions
  public const
    None = 0;
    CustomProperty = 1073741824;
    Persist = -2147483648;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngUIProtectionLevels')]
  DNCngUIProtectionLevels = type Integer;
  DNCngUIProtectionLevelsHelper = record helper for DNCngUIProtectionLevels
  public const
    None = 0;
    ProtectKey = 1;
    ForceHighProtection = 2;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.ECDiffieHellmanKeyDerivationFunction')]
  DNECDiffieHellmanKeyDerivationFunction = type Integer;
  DNECDiffieHellmanKeyDerivationFunctionHelper = record helper for DNECDiffieHellmanKeyDerivationFunction
  public const
    Hash = 0;
    Hmac = 1;
    Tls = 2;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.ECKeyXmlFormat')]
  DNECKeyXmlFormat = type Integer;
  DNECKeyXmlFormatHelper = record helper for DNECKeyXmlFormat
  public const
    Rfc4050 = 0;
  end;




type


{ declares }

  DNCngPropertyCollection = interface; // type: System.Security.Cryptography.CngPropertyCollection, namespace: System.Security.Cryptography
  DNSafeNCryptHandle = interface; // type: Microsoft.Win32.SafeHandles.SafeNCryptHandle, namespace: Microsoft.Win32.SafeHandles
  DNSafeNCryptKeyHandle = interface; // type: Microsoft.Win32.SafeHandles.SafeNCryptKeyHandle, namespace: Microsoft.Win32.SafeHandles
  DNSafeNCryptProviderHandle = interface; // type: Microsoft.Win32.SafeHandles.SafeNCryptProviderHandle, namespace: Microsoft.Win32.SafeHandles
  DNSafeNCryptSecretHandle = interface; // type: Microsoft.Win32.SafeHandles.SafeNCryptSecretHandle, namespace: Microsoft.Win32.SafeHandles
  DNDSACng = interface; // type: System.Security.Cryptography.DSACng, namespace: System.Security.Cryptography
  DNECDiffieHellmanCng = interface; // type: System.Security.Cryptography.ECDiffieHellmanCng, namespace: System.Security.Cryptography
  DNECDsaCng = interface; // type: System.Security.Cryptography.ECDsaCng, namespace: System.Security.Cryptography
  DNRSACng = interface; // type: System.Security.Cryptography.RSACng, namespace: System.Security.Cryptography
  DNCngAlgorithm = interface; // type: System.Security.Cryptography.CngAlgorithm, namespace: System.Security.Cryptography
  DNCngAlgorithmGroup = interface; // type: System.Security.Cryptography.CngAlgorithmGroup, namespace: System.Security.Cryptography
  DNCngKey = interface; // type: System.Security.Cryptography.CngKey, namespace: System.Security.Cryptography
  DNCngKeyBlobFormat = interface; // type: System.Security.Cryptography.CngKeyBlobFormat, namespace: System.Security.Cryptography
  DNCngKeyCreationParameters = interface; // type: System.Security.Cryptography.CngKeyCreationParameters, namespace: System.Security.Cryptography
  DNCngProvider = interface; // type: System.Security.Cryptography.CngProvider, namespace: System.Security.Cryptography
  DNCngUIPolicy = interface; // type: System.Security.Cryptography.CngUIPolicy, namespace: System.Security.Cryptography
  DNECDiffieHellmanCngPublicKey = interface; // type: System.Security.Cryptography.ECDiffieHellmanCngPublicKey, namespace: System.Security.Cryptography
  DNAesCng = interface; // type: System.Security.Cryptography.AesCng, namespace: System.Security.Cryptography
  DNTripleDESCng = interface; // type: System.Security.Cryptography.TripleDESCng, namespace: System.Security.Cryptography
  DNCngProperty = interface; // type: System.Security.Cryptography.CngProperty, namespace: System.Security.Cryptography


{ objects }

  //-------------namespace: System.Security.Cryptography----------------
  DNCngPropertyCollectionClass = interface(DDNC.System.Private.CoreLib.DNCollectionClass<DNCngProperty>)
  ['{3AB759E7-CDC0-5EAE-A785-DC5FB7B80C41}']
  { constructors } 

    {class} function init: DNCngPropertyCollection;

  end;

  [DNTypeName('System.Security.Cryptography.CngPropertyCollection')]
  DNCngPropertyCollection = interface(DDNC.System.Private.CoreLib.DNCollection<DNCngProperty>)
  ['{8946CDDE-71AE-3578-B70F-747986679237}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    procedure CopyTo(&array: TArray<DNCngProperty>; index: Int32);
    function &Contains(item: DNCngProperty): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNCngProperty>;
    function IndexOf(item: DNCngProperty): Int32;
    procedure Insert(index: Int32; item: DNCngProperty);
    procedure RemoveAt(index: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNCngPropertyCollection = class(TDNGenericImport<DNCngPropertyCollectionClass, DNCngPropertyCollection>) end;

  //-------------namespace: Microsoft.Win32.SafeHandles----------------
  DNSafeNCryptHandleClass = interface(DDNC.System.Private.CoreLib.DNSafeHandleZeroOrMinusOneIsInvalidClass)
  ['{F5C5D068-257C-5F55-B9D7-6B3B5936093D}']
  end;

  [DNTypeName('Microsoft.Win32.SafeHandles.SafeNCryptHandle')]
  DNSafeNCryptHandle = interface(DDNC.System.Private.CoreLib.DNSafeHandleZeroOrMinusOneIsInvalid)
  ['{948CD3FC-65E9-311A-BE16-DECDA3785D51}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeNCryptHandle = class(TDNGenericImport<DNSafeNCryptHandleClass, DNSafeNCryptHandle>) end;

  //-------------namespace: Microsoft.Win32.SafeHandles----------------
  DNSafeNCryptKeyHandleClass = interface(DNSafeNCryptHandleClass)
  ['{9FF1F866-3D95-5D5F-B05C-3B79DF933336}']
  { constructors } 

    {class} function init: DNSafeNCryptKeyHandle; overload;
    {class} function init(handle: IntPtr; parentHandle: DDNC.System.Private.CoreLib.DNSafeHandle): DNSafeNCryptKeyHandle; overload;

  end;

  [DNTypeName('Microsoft.Win32.SafeHandles.SafeNCryptKeyHandle')]
  DNSafeNCryptKeyHandle = interface(DNSafeNCryptHandle)
  ['{21AC3A6C-93BC-3D1E-A0CE-DD1E209BE763}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeNCryptKeyHandle = class(TDNGenericImport<DNSafeNCryptKeyHandleClass, DNSafeNCryptKeyHandle>) end;

  //-------------namespace: Microsoft.Win32.SafeHandles----------------
  DNSafeNCryptProviderHandleClass = interface(DNSafeNCryptHandleClass)
  ['{70B8FE5B-820B-5DB6-8E8B-5106710F356D}']
  { constructors } 

    {class} function init: DNSafeNCryptProviderHandle;

  end;

  [DNTypeName('Microsoft.Win32.SafeHandles.SafeNCryptProviderHandle')]
  DNSafeNCryptProviderHandle = interface(DNSafeNCryptHandle)
  ['{AFF20C80-B845-3886-8183-93B4C9173019}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeNCryptProviderHandle = class(TDNGenericImport<DNSafeNCryptProviderHandleClass, DNSafeNCryptProviderHandle>) end;

  //-------------namespace: Microsoft.Win32.SafeHandles----------------
  DNSafeNCryptSecretHandleClass = interface(DNSafeNCryptHandleClass)
  ['{B332B061-4B82-55A5-8C1E-71CD841A4AD6}']
  { constructors } 

    {class} function init: DNSafeNCryptSecretHandle;

  end;

  [DNTypeName('Microsoft.Win32.SafeHandles.SafeNCryptSecretHandle')]
  DNSafeNCryptSecretHandle = interface(DNSafeNCryptHandle)
  ['{0C47A0F3-EE8C-3D30-9273-8FAAFBC998FD}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeNCryptSecretHandle = class(TDNGenericImport<DNSafeNCryptSecretHandleClass, DNSafeNCryptSecretHandle>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSACngClass = interface(DNObjectClass)
  ['{051D4B92-213D-54CE-8E1E-F9958A8DD2DA}']
  { constructors } 

    {class} function init(key: DNCngKey): DNDSACng; overload;
    {class} function init: DNDSACng; overload;
    {class} function init(keySize: Int32): DNDSACng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSACng')]
  DNDSACng = interface(DNObject)
  ['{17E68ABE-F482-369D-8DC6-80CE26FF44E0}']
  { getters & setters } 

    function get_Key: DNCngKey;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_SignatureAlgorithm: string;
    function get_KeyExchangeAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);

  { methods } 

    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters;
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: DNCngKey read get_Key;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
  end;

  TDNDSACng = class(TDNGenericImport<DNDSACngClass, DNDSACng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanCngClass = interface(DNObjectClass)
  ['{3D5648E2-D58B-5DF0-8AC2-A397FD5C757F}']
  { constructors } 

    {class} function init(key: DNCngKey): DNECDiffieHellmanCng; overload;
    {class} function init: DNECDiffieHellmanCng; overload;
    {class} function init(keySize: Int32): DNECDiffieHellmanCng; overload;
    {class} function init(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve): DNECDiffieHellmanCng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellmanCng')]
  DNECDiffieHellmanCng = interface(DNObject)
  ['{8FC94182-C336-36D8-B02C-D2C9BCECC1A7}']
  { getters & setters } 

    function get_HashAlgorithm: DNCngAlgorithm;
    procedure set_HashAlgorithm(value: DNCngAlgorithm);
    function get_KeyDerivationFunction: DNECDiffieHellmanKeyDerivationFunction;
    procedure set_KeyDerivationFunction(value: DNECDiffieHellmanKeyDerivationFunction);
    function get_HmacKey: TArray<Byte>;
    procedure set_HmacKey(value: TArray<Byte>);
    function get_Label: TArray<Byte>;
    procedure set_Label(value: TArray<Byte>);
    function get_SecretAppend: TArray<Byte>;
    procedure set_SecretAppend(value: TArray<Byte>);
    function get_SecretPrepend: TArray<Byte>;
    procedure set_SecretPrepend(value: TArray<Byte>);
    function get_Seed: TArray<Byte>;
    procedure set_Seed(value: TArray<Byte>);
    function get_UseSecretAgreementAsHmacKey: Boolean;
    function get_PublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey;
    function get_Key: DNCngKey;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;

  { methods } 

    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function DeriveKeyMaterial(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey): TArray<Byte>; overload;
    function DeriveKeyMaterial(otherPartyPublicKey: DNCngKey): TArray<Byte>; overload;
    function DeriveSecretAgreementHandle(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey): DNSafeNCryptSecretHandle; overload;
    function DeriveSecretAgreementHandle(otherPartyPublicKey: DNCngKey): DNSafeNCryptSecretHandle; overload;
    procedure GenerateKey(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve);
    procedure FromXmlString(xml: string; format: DNECKeyXmlFormat); overload;
    function ToXmlString(format: DNECKeyXmlFormat): string; overload;
    function DeriveKeyFromHash(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyTls(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; prfLabel: TArray<Byte>; prfSeed: TArray<Byte>): TArray<Byte>;
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNECParameters);
    function ExportExplicitParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function DeriveKeyFromHash(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>): TArray<Byte>; overload;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportECPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function ExportECPrivateKey: TArray<Byte>;
    function TryExportECPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure FromXmlString(xmlString: string); overload;
    function ToXmlString(includePrivateParameters: Boolean): string; overload;
    procedure Clear;
    procedure Dispose;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashAlgorithm: DNCngAlgorithm read get_HashAlgorithm write set_HashAlgorithm;
    property KeyDerivationFunction: DNECDiffieHellmanKeyDerivationFunction read get_KeyDerivationFunction write set_KeyDerivationFunction;
    property HmacKey: TArray<Byte> read get_HmacKey write set_HmacKey;
    property &Label: TArray<Byte> read get_Label write set_Label;
    property SecretAppend: TArray<Byte> read get_SecretAppend write set_SecretAppend;
    property SecretPrepend: TArray<Byte> read get_SecretPrepend write set_SecretPrepend;
    property Seed: TArray<Byte> read get_Seed write set_Seed;
    property UseSecretAgreementAsHmacKey: Boolean read get_UseSecretAgreementAsHmacKey;
    property PublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey read get_PublicKey;
    property Key: DNCngKey read get_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
  end;

  TDNECDiffieHellmanCng = class(TDNGenericImport<DNECDiffieHellmanCngClass, DNECDiffieHellmanCng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDsaCngClass = interface(DNObjectClass)
  ['{CAF29A94-0D50-5991-95A9-DBE0497AB514}']
  { constructors } 

    {class} function init(key: DNCngKey): DNECDsaCng; overload;
    {class} function init(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve): DNECDsaCng; overload;
    {class} function init: DNECDsaCng; overload;
    {class} function init(keySize: Int32): DNECDsaCng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDsaCng')]
  DNECDsaCng = interface(DNObject)
  ['{500AEEA2-1AF4-3894-B383-80995B6F76D9}']
  { getters & setters } 

    function get_HashAlgorithm: DNCngAlgorithm;
    procedure set_HashAlgorithm(value: DNCngAlgorithm);
    function get_Key: DNCngKey;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;

  { methods } 

    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure FromXmlString(xml: string; format: DNECKeyXmlFormat); overload;
    function SignData(data: TArray<Byte>): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ToXmlString(format: DNECKeyXmlFormat): string; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>): Boolean; overload;
    procedure GenerateKey(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve);
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNECParameters);
    function ExportExplicitParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function SignHash(hash: TArray<Byte>): TArray<Byte>;
    function TrySignHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>): Boolean; overload;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportECPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function ExportECPrivateKey: TArray<Byte>;
    function TryExportECPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure FromXmlString(xmlString: string); overload;
    function ToXmlString(includePrivateParameters: Boolean): string; overload;
    procedure Clear;
    procedure Dispose;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashAlgorithm: DNCngAlgorithm read get_HashAlgorithm write set_HashAlgorithm;
    property Key: DNCngKey read get_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
  end;

  TDNECDsaCng = class(TDNGenericImport<DNECDsaCngClass, DNECDsaCng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSACngClass = interface(DNObjectClass)
  ['{4AB38E23-7769-5665-AF61-328C6D9808AE}']
  { constructors } 

    {class} function init(key: DNCngKey): DNRSACng; overload;
    {class} function init: DNRSACng; overload;
    {class} function init(keySize: Int32): DNRSACng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSACng')]
  DNRSACng = interface(DNObject)
  ['{0FF2CC9A-898A-3FEB-9062-6FCD9AD3D683}']
  { getters & setters } 

    function get_Key: DNCngKey;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);

  { methods } 

    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function Encrypt(data: TArray<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding): TArray<Byte>;
    function Decrypt(data: TArray<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding): TArray<Byte>;
    function TryEncrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TryDecrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters);
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters;
    function SignHash(hash: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function DecryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function EncryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function ExportRSAPrivateKey: TArray<Byte>;
    function TryExportRSAPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ExportRSAPublicKey: TArray<Byte>;
    function TryExportRSAPublicKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportRSAPublicKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportRSAPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: DNCngKey read get_Key;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
  end;

  TDNRSACng = class(TDNGenericImport<DNRSACngClass, DNRSACng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngAlgorithmClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{DC80FFB3-768B-578F-A7F0-1A1C75184E99}']
  { static getter & setter } 

    {class} function get_Rsa: DNCngAlgorithm;
    {class} function get_ECDiffieHellman: DNCngAlgorithm;
    {class} function get_ECDiffieHellmanP256: DNCngAlgorithm;
    {class} function get_ECDiffieHellmanP384: DNCngAlgorithm;
    {class} function get_ECDiffieHellmanP521: DNCngAlgorithm;
    {class} function get_ECDsa: DNCngAlgorithm;
    {class} function get_ECDsaP256: DNCngAlgorithm;
    {class} function get_ECDsaP384: DNCngAlgorithm;
    {class} function get_ECDsaP521: DNCngAlgorithm;
    {class} function get_MD5: DNCngAlgorithm;
    {class} function get_Sha1: DNCngAlgorithm;
    {class} function get_Sha256: DNCngAlgorithm;
    {class} function get_Sha384: DNCngAlgorithm;
    {class} function get_Sha512: DNCngAlgorithm;

  { constructors } 

    {class} function init(algorithm: string): DNCngAlgorithm;

  { static propertys } 

    {class} property Rsa: DNCngAlgorithm read get_Rsa;
    {class} property ECDiffieHellman: DNCngAlgorithm read get_ECDiffieHellman;
    {class} property ECDiffieHellmanP256: DNCngAlgorithm read get_ECDiffieHellmanP256;
    {class} property ECDiffieHellmanP384: DNCngAlgorithm read get_ECDiffieHellmanP384;
    {class} property ECDiffieHellmanP521: DNCngAlgorithm read get_ECDiffieHellmanP521;
    {class} property ECDsa: DNCngAlgorithm read get_ECDsa;
    {class} property ECDsaP256: DNCngAlgorithm read get_ECDsaP256;
    {class} property ECDsaP384: DNCngAlgorithm read get_ECDsaP384;
    {class} property ECDsaP521: DNCngAlgorithm read get_ECDsaP521;
    {class} property MD5: DNCngAlgorithm read get_MD5;
    {class} property Sha1: DNCngAlgorithm read get_Sha1;
    {class} property Sha256: DNCngAlgorithm read get_Sha256;
    {class} property Sha384: DNCngAlgorithm read get_Sha384;
    {class} property Sha512: DNCngAlgorithm read get_Sha512;
  end;

  [DNTypeName('System.Security.Cryptography.CngAlgorithm')]
  DNCngAlgorithm = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{B9975B5F-4251-3C9E-8547-CD11388D4948}']
  { getters & setters } 

    function get_Algorithm: string;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNCngAlgorithm): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Algorithm: string read get_Algorithm;
  end;

  TDNCngAlgorithm = class(TDNGenericImport<DNCngAlgorithmClass, DNCngAlgorithm>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngAlgorithmGroupClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{AAB9D945-53D8-57FA-89EF-7DD84CBAF0D5}']
  { static getter & setter } 

    {class} function get_DiffieHellman: DNCngAlgorithmGroup;
    {class} function get_Dsa: DNCngAlgorithmGroup;
    {class} function get_ECDiffieHellman: DNCngAlgorithmGroup;
    {class} function get_ECDsa: DNCngAlgorithmGroup;
    {class} function get_Rsa: DNCngAlgorithmGroup;

  { constructors } 

    {class} function init(algorithmGroup: string): DNCngAlgorithmGroup;

  { static propertys } 

    {class} property DiffieHellman: DNCngAlgorithmGroup read get_DiffieHellman;
    {class} property Dsa: DNCngAlgorithmGroup read get_Dsa;
    {class} property ECDiffieHellman: DNCngAlgorithmGroup read get_ECDiffieHellman;
    {class} property ECDsa: DNCngAlgorithmGroup read get_ECDsa;
    {class} property Rsa: DNCngAlgorithmGroup read get_Rsa;
  end;

  [DNTypeName('System.Security.Cryptography.CngAlgorithmGroup')]
  DNCngAlgorithmGroup = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{243015EB-97E7-3052-A2B4-A377A4A114C2}']
  { getters & setters } 

    function get_AlgorithmGroup: string;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNCngAlgorithmGroup): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AlgorithmGroup: string read get_AlgorithmGroup;
  end;

  TDNCngAlgorithmGroup = class(TDNGenericImport<DNCngAlgorithmGroupClass, DNCngAlgorithmGroup>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngKeyClass = interface(DNObjectClass)
  ['{C0A91E89-B213-5B93-91CF-EDB3CD1B799E}']
  { static methods } 

    {class} function Create(algorithm: DNCngAlgorithm): DNCngKey; overload;
    {class} function Create(algorithm: DNCngAlgorithm; keyName: string): DNCngKey; overload;
    {class} function Create(algorithm: DNCngAlgorithm; keyName: string; creationParameters: DNCngKeyCreationParameters): DNCngKey; overload;
    {class} function Import(keyBlob: TArray<Byte>; format: DNCngKeyBlobFormat): DNCngKey; overload;
    {class} function Import(keyBlob: TArray<Byte>; format: DNCngKeyBlobFormat; provider: DNCngProvider): DNCngKey; overload;
    {class} function Exists(keyName: string): Boolean; overload;
    {class} function Exists(keyName: string; provider: DNCngProvider): Boolean; overload;
    {class} function Exists(keyName: string; provider: DNCngProvider; options: DNCngKeyOpenOptions): Boolean; overload;
    {class} function Open(keyName: string): DNCngKey; overload;
    {class} function Open(keyName: string; provider: DNCngProvider): DNCngKey; overload;
    {class} function Open(keyName: string; provider: DNCngProvider; openOptions: DNCngKeyOpenOptions): DNCngKey; overload;
    {class} function Open(keyHandle: DNSafeNCryptKeyHandle; keyHandleOpenOptions: DNCngKeyHandleOpenOptions): DNCngKey; overload;

  end;

  [DNTypeName('System.Security.Cryptography.CngKey')]
  DNCngKey = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{76CDB38E-BED8-3733-AE64-94D2B325B648}']
  { getters & setters } 

    function get_Algorithm: DNCngAlgorithm;
    function get_AlgorithmGroup: DNCngAlgorithmGroup;
    function get_ExportPolicy: DNCngExportPolicies;
    function get_Handle: DNSafeNCryptKeyHandle;
    function get_IsEphemeral: Boolean;
    function get_IsMachineKey: Boolean;
    function get_KeyName: string;
    function get_KeySize: Int32;
    function get_KeyUsage: DNCngKeyUsages;
    function get_ParentWindowHandle: IntPtr;
    procedure set_ParentWindowHandle(value: IntPtr);
    function get_Provider: DNCngProvider;
    function get_ProviderHandle: DNSafeNCryptProviderHandle;
    function get_UIPolicy: DNCngUIPolicy;
    function get_UniqueName: string;

  { methods } 

    procedure Dispose;
    function GetProperty(name: string; options: DNCngPropertyOptions): DNCngProperty;
    function HasProperty(name: string; options: DNCngPropertyOptions): Boolean;
    procedure SetProperty(&property: DNCngProperty);
    function &Export(format: DNCngKeyBlobFormat): TArray<Byte>;
    procedure Delete;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Algorithm: DNCngAlgorithm read get_Algorithm;
    property AlgorithmGroup: DNCngAlgorithmGroup read get_AlgorithmGroup;
    property ExportPolicy: DNCngExportPolicies read get_ExportPolicy;
    property Handle: DNSafeNCryptKeyHandle read get_Handle;
    property IsEphemeral: Boolean read get_IsEphemeral;
    property IsMachineKey: Boolean read get_IsMachineKey;
    property KeyName: string read get_KeyName;
    property KeySize: Int32 read get_KeySize;
    property KeyUsage: DNCngKeyUsages read get_KeyUsage;
    property ParentWindowHandle: IntPtr read get_ParentWindowHandle write set_ParentWindowHandle;
    property Provider: DNCngProvider read get_Provider;
    property ProviderHandle: DNSafeNCryptProviderHandle read get_ProviderHandle;
    property UIPolicy: DNCngUIPolicy read get_UIPolicy;
    property UniqueName: string read get_UniqueName;
  end;

  TDNCngKey = class(TDNGenericImport<DNCngKeyClass, DNCngKey>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngKeyBlobFormatClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0999EFA4-7DED-57CC-93B6-3DEC4974B3AB}']
  { static getter & setter } 

    {class} function get_EccPrivateBlob: DNCngKeyBlobFormat;
    {class} function get_EccPublicBlob: DNCngKeyBlobFormat;
    {class} function get_EccFullPrivateBlob: DNCngKeyBlobFormat;
    {class} function get_EccFullPublicBlob: DNCngKeyBlobFormat;
    {class} function get_GenericPrivateBlob: DNCngKeyBlobFormat;
    {class} function get_GenericPublicBlob: DNCngKeyBlobFormat;
    {class} function get_OpaqueTransportBlob: DNCngKeyBlobFormat;
    {class} function get_Pkcs8PrivateBlob: DNCngKeyBlobFormat;

  { constructors } 

    {class} function init(format: string): DNCngKeyBlobFormat;

  { static propertys } 

    {class} property EccPrivateBlob: DNCngKeyBlobFormat read get_EccPrivateBlob;
    {class} property EccPublicBlob: DNCngKeyBlobFormat read get_EccPublicBlob;
    {class} property EccFullPrivateBlob: DNCngKeyBlobFormat read get_EccFullPrivateBlob;
    {class} property EccFullPublicBlob: DNCngKeyBlobFormat read get_EccFullPublicBlob;
    {class} property GenericPrivateBlob: DNCngKeyBlobFormat read get_GenericPrivateBlob;
    {class} property GenericPublicBlob: DNCngKeyBlobFormat read get_GenericPublicBlob;
    {class} property OpaqueTransportBlob: DNCngKeyBlobFormat read get_OpaqueTransportBlob;
    {class} property Pkcs8PrivateBlob: DNCngKeyBlobFormat read get_Pkcs8PrivateBlob;
  end;

  [DNTypeName('System.Security.Cryptography.CngKeyBlobFormat')]
  DNCngKeyBlobFormat = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C80822A9-0C4D-3435-BA83-223641536AE9}']
  { getters & setters } 

    function get_Format: string;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNCngKeyBlobFormat): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Format: string read get_Format;
  end;

  TDNCngKeyBlobFormat = class(TDNGenericImport<DNCngKeyBlobFormatClass, DNCngKeyBlobFormat>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngKeyCreationParametersClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{02E987BA-46F4-5445-80E1-926AC9FBF079}']
  { constructors } 

    {class} function init: DNCngKeyCreationParameters;

  end;

  [DNTypeName('System.Security.Cryptography.CngKeyCreationParameters')]
  DNCngKeyCreationParameters = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E270661F-33B4-383F-AAD2-83A27CDD691B}']
  { getters & setters } 

    function get_ExportPolicy: DDNC.System.Private.CoreLib.DNNullable<DNCngExportPolicies>;
    procedure set_ExportPolicy(value: DDNC.System.Private.CoreLib.DNNullable<DNCngExportPolicies>);
    function get_KeyCreationOptions: DNCngKeyCreationOptions;
    procedure set_KeyCreationOptions(value: DNCngKeyCreationOptions);
    function get_KeyUsage: DDNC.System.Private.CoreLib.DNNullable<DNCngKeyUsages>;
    procedure set_KeyUsage(value: DDNC.System.Private.CoreLib.DNNullable<DNCngKeyUsages>);
    function get_Parameters: DNCngPropertyCollection;
    function get_ParentWindowHandle: IntPtr;
    procedure set_ParentWindowHandle(value: IntPtr);
    function get_Provider: DNCngProvider;
    procedure set_Provider(value: DNCngProvider);
    function get_UIPolicy: DNCngUIPolicy;
    procedure set_UIPolicy(value: DNCngUIPolicy);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ExportPolicy: DDNC.System.Private.CoreLib.DNNullable<DNCngExportPolicies> read get_ExportPolicy write set_ExportPolicy;
    property KeyCreationOptions: DNCngKeyCreationOptions read get_KeyCreationOptions write set_KeyCreationOptions;
    property KeyUsage: DDNC.System.Private.CoreLib.DNNullable<DNCngKeyUsages> read get_KeyUsage write set_KeyUsage;
    property Parameters: DNCngPropertyCollection read get_Parameters;
    property ParentWindowHandle: IntPtr read get_ParentWindowHandle write set_ParentWindowHandle;
    property Provider: DNCngProvider read get_Provider write set_Provider;
    property UIPolicy: DNCngUIPolicy read get_UIPolicy write set_UIPolicy;
  end;

  TDNCngKeyCreationParameters = class(TDNGenericImport<DNCngKeyCreationParametersClass, DNCngKeyCreationParameters>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngProviderClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{DAD64E93-6E7B-52DE-AB1A-1BAC734827B9}']
  { static getter & setter } 

    {class} function get_MicrosoftSmartCardKeyStorageProvider: DNCngProvider;
    {class} function get_MicrosoftSoftwareKeyStorageProvider: DNCngProvider;

  { constructors } 

    {class} function init(provider: string): DNCngProvider;

  { static propertys } 

    {class} property MicrosoftSmartCardKeyStorageProvider: DNCngProvider read get_MicrosoftSmartCardKeyStorageProvider;
    {class} property MicrosoftSoftwareKeyStorageProvider: DNCngProvider read get_MicrosoftSoftwareKeyStorageProvider;
  end;

  [DNTypeName('System.Security.Cryptography.CngProvider')]
  DNCngProvider = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{680062BD-1C03-3609-8825-FFAAD855A685}']
  { getters & setters } 

    function get_Provider: string;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNCngProvider): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Provider: string read get_Provider;
  end;

  TDNCngProvider = class(TDNGenericImport<DNCngProviderClass, DNCngProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngUIPolicyClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{A8F5047F-6131-51D3-81C1-1A0EE1F8BB0D}']
  { constructors } 

    {class} function init(protectionLevel: DNCngUIProtectionLevels): DNCngUIPolicy; overload;
    {class} function init(protectionLevel: DNCngUIProtectionLevels; friendlyName: string): DNCngUIPolicy; overload;
    {class} function init(protectionLevel: DNCngUIProtectionLevels; friendlyName: string; description: string): DNCngUIPolicy; overload;
    {class} function init(protectionLevel: DNCngUIProtectionLevels; friendlyName: string; description: string; useContext: string): DNCngUIPolicy; overload;
    {class} function init(protectionLevel: DNCngUIProtectionLevels; friendlyName: string; description: string; useContext: string; creationTitle: string): DNCngUIPolicy; overload;

  end;

  [DNTypeName('System.Security.Cryptography.CngUIPolicy')]
  DNCngUIPolicy = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{5392CE0D-3D52-3B30-ADB4-7603B36BB1EE}']
  { getters & setters } 

    function get_ProtectionLevel: DNCngUIProtectionLevels;
    function get_FriendlyName: string;
    function get_Description: string;
    function get_UseContext: string;
    function get_CreationTitle: string;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ProtectionLevel: DNCngUIProtectionLevels read get_ProtectionLevel;
    property FriendlyName: string read get_FriendlyName;
    property Description: string read get_Description;
    property UseContext: string read get_UseContext;
    property CreationTitle: string read get_CreationTitle;
  end;

  TDNCngUIPolicy = class(TDNGenericImport<DNCngUIPolicyClass, DNCngUIPolicy>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanCngPublicKeyClass = interface(DNObjectClass)
  ['{7D572430-93D6-5798-9674-84554CBA5EED}']
  { static methods } 

    {class} function FromXmlString(xml: string): DNECDiffieHellmanCngPublicKey;
    {class} function FromByteArray(publicKeyBlob: TArray<Byte>; format: DNCngKeyBlobFormat): DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey;

  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellmanCngPublicKey')]
  DNECDiffieHellmanCngPublicKey = interface(DNObject)
  ['{6F2B6D04-ED3F-36A5-A487-B7208502128A}']
  { getters & setters } 

    function get_BlobFormat: DNCngKeyBlobFormat;

  { methods } 

    function ToXmlString: string;
    function Import: DNCngKey;
    function ExportExplicitParameters: DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    function ExportParameters: DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    procedure Dispose;
    function ToByteArray: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property BlobFormat: DNCngKeyBlobFormat read get_BlobFormat;
  end;

  TDNECDiffieHellmanCngPublicKey = class(TDNGenericImport<DNECDiffieHellmanCngPublicKeyClass, DNECDiffieHellmanCngPublicKey>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesCngClass = interface(DNObjectClass)
  ['{99EAA102-0C09-54FB-91B5-7EC15CB91C46}']
  { constructors } 

    {class} function init: DNAesCng; overload;
    {class} function init(keyName: string): DNAesCng; overload;
    {class} function init(keyName: string; provider: DNCngProvider): DNAesCng; overload;
    {class} function init(keyName: string; provider: DNCngProvider; openOptions: DNCngKeyOpenOptions): DNAesCng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.AesCng')]
  DNAesCng = interface(DNObject)
  ['{84D538AD-AE13-39D6-A40E-FF5C2447FC32}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateKey;
    procedure GenerateIV;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNAesCng = class(TDNGenericImport<DNAesCngClass, DNAesCng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNTripleDESCngClass = interface(DNObjectClass)
  ['{5A1730D5-2484-5987-8CFD-9CC1FFB96211}']
  { constructors } 

    {class} function init: DNTripleDESCng; overload;
    {class} function init(keyName: string): DNTripleDESCng; overload;
    {class} function init(keyName: string; provider: DNCngProvider): DNTripleDESCng; overload;
    {class} function init(keyName: string; provider: DNCngProvider; openOptions: DNCngKeyOpenOptions): DNTripleDESCng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.TripleDESCng')]
  DNTripleDESCng = interface(DNObject)
  ['{0F9E4CB5-BC18-3295-8C8C-5676A1BA9A6D}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateKey;
    procedure GenerateIV;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNTripleDESCng = class(TDNGenericImport<DNTripleDESCngClass, DNTripleDESCng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngPropertyClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{65B6948D-BAD1-534E-866F-FBD8208C2474}']
  { constructors } 

    {class} function init(name: string; value: TArray<Byte>; options: DNCngPropertyOptions): DNCngProperty;

  end;

  [DNTypeName('System.Security.Cryptography.CngProperty')]
  DNCngProperty = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{47E92D4A-43CF-34A4-B091-58992EF54519}']
  { getters & setters } 

    function get_Name: string;
    function get_Options: DNCngPropertyOptions;

  { methods } 

    function GetValue: TArray<Byte>;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNCngProperty): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Name: string read get_Name;
    property Options: DNCngPropertyOptions read get_Options;
  end;

  TDNCngProperty = class(TDNGenericImport<DNCngPropertyClass, DNCngProperty>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.Cryptography.Cng, Version=4.3.3.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
